// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// sln 04.10.2001. BUC61003. Correction of looking for items of complex entity

#include <Interface_Check.hxx>
#include <Interface_EntityIterator.hxx>
#include <Interface_ShareTool.hxx>
#include "RWStepGeom_RWBSplineCurveWithKnots.pxx"
#include "RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve.pxx"
#include "RWStepGeom_RWRationalBSplineCurve.pxx"
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepGeom_BSplineCurveWithKnots.hxx>
#include <StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <NCollection_Array1.hxx>
#include <NCollection_HArray1.hxx>
#include <StepGeom_KnotType.hxx>
#include <StepGeom_RationalBSplineCurve.hxx>
#include <Standard_Integer.hxx>

#include "RWStepGeom_RWBSplineCurveForm.pxx"
#include "RWStepGeom_RWKnotType.pxx"

RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve::
  RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve() = default;

void RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve::ReadStep(
  const occ::handle<StepData_StepReaderData>&                               data,
  const int                                                                 num0,
  occ::handle<Interface_Check>&                                             ach,
  const occ::handle<StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve>& ent) const
{

  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  int num = 0; // num0
  data->NamedForComplex("BOUNDED_CURVE", "BNDCRV", num0, num, ach);

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  //        num =  0; gka TRJ9
  data->NamedForComplex("B_SPLINE_CURVE", "BSPCR", num0, num, ach);

  // --- Instance of common supertype BSplineCurve ---

  if (!data->CheckNbParams(num, 5, ach, "b_spline_curve"))
    return;
  // --- field : degree ---

  int aDegree;
  // szv#4:S4163:12Mar99 `bool stat1 =` not needed
  data->ReadInteger(num, 1, "degree", ach, aDegree);
  // --- field : controlPointsList ---

  occ::handle<NCollection_HArray1<occ::handle<StepGeom_CartesianPoint>>> aControlPointsList;
  occ::handle<StepGeom_CartesianPoint>                                   anent2;
  int                                                                    nsub2;
  if (data->ReadSubList(num, 2, "control_points_list", ach, nsub2))
  {
    int nb2            = data->NbParams(nsub2);
    aControlPointsList = new NCollection_HArray1<occ::handle<StepGeom_CartesianPoint>>(1, nb2);
    for (int i2 = 1; i2 <= nb2; i2++)
    {
      // szv#4:S4163:12Mar99 `bool stat2 =` not needed
      if (data->ReadEntity(nsub2,
                           i2,
                           "cartesian_point",
                           ach,
                           STANDARD_TYPE(StepGeom_CartesianPoint),
                           anent2))
        aControlPointsList->SetValue(i2, anent2);
    }
  }

  // --- field : curveForm ---

  StepGeom_BSplineCurveForm aCurveForm = StepGeom_bscfPolylineForm;
  if (data->ParamType(num, 3) == Interface_ParamEnum)
  {
    const char* text = data->ParamCValue(num, 3);
    if (!RWStepGeom_RWBSplineCurveForm::ConvertToEnum(text, aCurveForm))
    {
      ach->AddFail("Enumeration b_spline_curve_form has not an allowed value");
    }
  }
  else
    ach->AddFail("Parameter #3 (curve_form) is not an enumeration");
  // --- field : closedCurve ---

  StepData_Logical aClosedCurve;
  // szv#4:S4163:12Mar99 `bool stat4 =` not needed
  data->ReadLogical(num, 4, "closed_curve", ach, aClosedCurve);
  // --- field : selfIntersect ---

  StepData_Logical aSelfIntersect;
  // szv#4:S4163:12Mar99 `bool stat5 =` not needed
  data->ReadLogical(num, 5, "self_intersect", ach, aSelfIntersect);

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  //        num =  0; //gka TRJ9
  data->NamedForComplex("B_SPLINE_CURVE_WITH_KNOTS", "BSCWK", num0, num, ach);

  // --- Instance of plex component BSplineCurveWithKnots ---

  if (!data->CheckNbParams(num, 3, ach, "b_spline_curve_with_knots"))
    return;

  // --- field : knotMultiplicities ---

  occ::handle<NCollection_HArray1<int>> aKnotMultiplicities;
  int                                   aKnotMultiplicitiesItem;
  int                                   nsub6;
  if (data->ReadSubList(num, 1, "knot_multiplicities", ach, nsub6))
  {
    int nb6             = data->NbParams(nsub6);
    aKnotMultiplicities = new NCollection_HArray1<int>(1, nb6);
    for (int i6 = 1; i6 <= nb6; i6++)
    {
      // szv#4:S4163:12Mar99 `bool stat6 =` not needed
      if (data->ReadInteger(nsub6, i6, "knot_multiplicities", ach, aKnotMultiplicitiesItem))
        aKnotMultiplicities->SetValue(i6, aKnotMultiplicitiesItem);
    }
  }

  // --- field : knots ---

  occ::handle<NCollection_HArray1<double>> aKnots;
  double                                   aKnotsItem;
  int                                      nsub7;
  if (data->ReadSubList(num, 2, "knots", ach, nsub7))
  {
    int nb7 = data->NbParams(nsub7);
    aKnots  = new NCollection_HArray1<double>(1, nb7);
    for (int i7 = 1; i7 <= nb7; i7++)
    {
      // szv#4:S4163:12Mar99 `bool stat7 =` not needed
      if (data->ReadReal(nsub7, i7, "knots", ach, aKnotsItem))
        aKnots->SetValue(i7, aKnotsItem);
    }
  }

  // --- field : knotSpec ---

  StepGeom_KnotType aKnotSpec = StepGeom_ktUniformKnots;
  if (data->ParamType(num, 3) == Interface_ParamEnum)
  {
    const char* text = data->ParamCValue(num, 3);
    if (!RWStepGeom_RWKnotType::ConvertToEnum(text, aKnotSpec))
    {
      ach->AddFail("Enumeration knot_type has not an allowed value");
    }
  }
  else
    ach->AddFail("Parameter #3 (knot_spec) is not an enumeration");

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  //        num =  0; gka TRJ9
  data->NamedForComplex("CURVE", num0, num, ach);

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  // num =  0;
  data->NamedForComplex("GEOMETRIC_REPRESENTATION_ITEM", "GMRPIT", num0, num, ach);

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  // num =  0;
  data->NamedForComplex("RATIONAL_B_SPLINE_CURVE", "RBSC", num0, num, ach);

  // --- Instance of plex component RationalBSplineCurve ---

  if (!data->CheckNbParams(num, 1, ach, "rational_b_spline_curve"))
    return;

  // --- field : weightsData ---

  occ::handle<NCollection_HArray1<double>> aWeightsData;
  double                                   aWeightsDataItem;
  int                                      nsub9;
  if (data->ReadSubList(num, 1, "weights_data", ach, nsub9))
  {
    int nb9      = data->NbParams(nsub9);
    aWeightsData = new NCollection_HArray1<double>(1, nb9);
    for (int i9 = 1; i9 <= nb9; i9++)
    {
      // szv#4:S4163:12Mar99 `bool stat9 =` not needed
      if (data->ReadReal(nsub9, i9, "weights_data", ach, aWeightsDataItem))
        aWeightsData->SetValue(i9, aWeightsDataItem);
    }
  }

  //	num = data->NextForComplex(num);
  // sln 04.10.2001. BUC61003. Correction of looking for items of complex entity
  // num =  0;
  data->NamedForComplex("REPRESENTATION_ITEM", "RPRITM", num0, num, ach);

  // --- Instance of plex component RepresentationItem ---

  if (!data->CheckNbParams(num, 1, ach, "representation_item"))
    return;

  // --- field : name ---

  occ::handle<TCollection_HAsciiString> aName;
  // szv#4:S4163:12Mar99 `bool stat10 =` not needed
  data->ReadString(num, 1, "name", ach, aName);

  //--- Initialisation of the red entity ---

  ent->Init(aName,
            aDegree,
            aControlPointsList,
            aCurveForm,
            aClosedCurve,
            aSelfIntersect,
            aKnotMultiplicities,
            aKnots,
            aKnotSpec,
            aWeightsData);
}

void RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve::WriteStep(
  StepData_StepWriter&                                                      SW,
  const occ::handle<StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve>& ent) const
{

  // --- Instance of plex component BoundedCurve ---

  SW.StartEntity("BOUNDED_CURVE");

  // --- Instance of common supertype BSplineCurve ---

  SW.StartEntity("B_SPLINE_CURVE");
  // --- field : degree ---

  SW.Send(ent->Degree());
  // --- field : controlPointsList ---

  SW.OpenSub();
  for (int i2 = 1; i2 <= ent->NbControlPointsList(); i2++)
  {
    SW.Send(ent->ControlPointsListValue(i2));
  }
  SW.CloseSub();
  // --- field : curveForm ---

  SW.SendEnum(RWStepGeom_RWBSplineCurveForm::ConvertToString(ent->CurveForm()));

  // --- field : closedCurve ---

  SW.SendLogical(ent->ClosedCurve());
  // --- field : selfIntersect ---

  SW.SendLogical(ent->SelfIntersect());

  // --- Instance of plex component BSplineCurveWithKnots ---

  SW.StartEntity("B_SPLINE_CURVE_WITH_KNOTS");
  // --- field : knotMultiplicities ---

  SW.OpenSub();
  for (int i6 = 1; i6 <= ent->NbKnotMultiplicities(); i6++)
  {
    SW.Send(ent->KnotMultiplicitiesValue(i6));
  }
  SW.CloseSub();
  // --- field : knots ---

  SW.OpenSub();
  for (int i7 = 1; i7 <= ent->NbKnots(); i7++)
  {
    SW.Send(ent->KnotsValue(i7));
  }
  SW.CloseSub();
  // --- field : knotSpec ---

  SW.SendEnum(RWStepGeom_RWKnotType::ConvertToString(ent->KnotSpec()));

  // --- Instance of plex component Curve ---

  SW.StartEntity("CURVE");

  // --- Instance of plex component GeometricRepresentationItem ---

  SW.StartEntity("GEOMETRIC_REPRESENTATION_ITEM");

  // --- Instance of plex component RationalBSplineCurve ---

  SW.StartEntity("RATIONAL_B_SPLINE_CURVE");
  // --- field : weightsData ---

  SW.OpenSub();
  for (int i9 = 1; i9 <= ent->NbWeightsData(); i9++)
  {
    SW.Send(ent->WeightsDataValue(i9));
  }
  SW.CloseSub();

  // --- Instance of plex component RepresentationItem ---

  SW.StartEntity("REPRESENTATION_ITEM");
  // --- field : name ---

  SW.Send(ent->Name());
}

void RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve::Share(
  const occ::handle<StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve>& ent,
  Interface_EntityIterator&                                                 iter) const
{

  int nbElem1 = ent->NbControlPointsList();
  for (int is1 = 1; is1 <= nbElem1; is1++)
  {
    iter.GetOneItem(ent->ControlPointsListValue(is1));
  }
}

void RWStepGeom_RWBSplineCurveWithKnotsAndRationalBSplineCurve::Check(
  const occ::handle<StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve>& ent,
  const Interface_ShareTool&                                                aShto,
  occ::handle<Interface_Check>&                                             ach) const
{
  const occ::handle<StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve>& aRationalBSC = ent;
  occ::handle<StepGeom_BSplineCurveWithKnots> aBSCWK = aRationalBSC->BSplineCurveWithKnots();
  RWStepGeom_RWBSplineCurveWithKnots          t1;
  t1.Check(aBSCWK, aShto, ach);
  occ::handle<StepGeom_RationalBSplineCurve> aRBSC = aRationalBSC->RationalBSplineCurve();
  RWStepGeom_RWRationalBSplineCurve          t2;
  t2.Check(aRBSC, aShto, ach);
}
