// Created on: 2002-12-12
// Created by: data exchange team
// Copyright (c) 2002-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

// Generator:	ExpToCas (EXPRESS -> CASCADE/XSTEP Translator) V1.2

#include <Interface_EntityIterator.hxx>
#include "RWStepFEA_RWCurveElementInterval.pxx"
#include <StepBasic_EulerAngles.hxx>
#include <StepData_StepReaderData.hxx>
#include <StepData_StepWriter.hxx>
#include <StepFEA_CurveElementInterval.hxx>
#include <StepFEA_CurveElementLocation.hxx>

//=================================================================================================

RWStepFEA_RWCurveElementInterval::RWStepFEA_RWCurveElementInterval() = default;

//=================================================================================================

void RWStepFEA_RWCurveElementInterval::ReadStep(
  const occ::handle<StepData_StepReaderData>&      data,
  const int                                        num,
  occ::handle<Interface_Check>&                    ach,
  const occ::handle<StepFEA_CurveElementInterval>& ent) const
{
  // Check number of parameters
  if (!data->CheckNbParams(num, 2, ach, "curve_element_interval"))
    return;

  // Own fields of CurveElementInterval

  occ::handle<StepFEA_CurveElementLocation> aFinishPosition;
  data->ReadEntity(num,
                   1,
                   "finish_position",
                   ach,
                   STANDARD_TYPE(StepFEA_CurveElementLocation),
                   aFinishPosition);

  occ::handle<StepBasic_EulerAngles> aEuAngles;
  data->ReadEntity(num, 2, "eu_angles", ach, STANDARD_TYPE(StepBasic_EulerAngles), aEuAngles);

  // Initialize entity
  ent->Init(aFinishPosition, aEuAngles);
}

//=================================================================================================

void RWStepFEA_RWCurveElementInterval::WriteStep(
  StepData_StepWriter&                             SW,
  const occ::handle<StepFEA_CurveElementInterval>& ent) const
{

  // Own fields of CurveElementInterval

  SW.Send(ent->FinishPosition());

  SW.Send(ent->EuAngles());
}

//=================================================================================================

void RWStepFEA_RWCurveElementInterval::Share(const occ::handle<StepFEA_CurveElementInterval>& ent,
                                             Interface_EntityIterator& iter) const
{

  // Own fields of CurveElementInterval

  iter.AddItem(ent->FinishPosition());

  iter.AddItem(ent->EuAngles());
}
