// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <IGESData_IGESEntity.hxx>
#include <IGESData_IGESModel.hxx>
#include <IGESSelect_SelectDrawingFrom.hxx>
#include <IGESSelect_ViewSorter.hxx>
#include <Interface_EntityIterator.hxx>
#include <Interface_Graph.hxx>
#include <MoniTool_Macros.hxx>
#include <Standard_Type.hxx>
#include <TCollection_AsciiString.hxx>

IMPLEMENT_STANDARD_RTTIEXT(IGESSelect_SelectDrawingFrom, IFSelect_SelectDeduct)

IGESSelect_SelectDrawingFrom::IGESSelect_SelectDrawingFrom() = default;

bool IGESSelect_SelectDrawingFrom::HasUniqueResult() const
{
  return true;
}

Interface_EntityIterator IGESSelect_SelectDrawingFrom::RootResult(const Interface_Graph& G) const
{
  occ::handle<IGESSelect_ViewSorter> sorter = new IGESSelect_ViewSorter;
  sorter->SetModel(GetCasted(IGESData_IGESModel, G.Model()));
  sorter->Clear();
  sorter->AddList(InputResult(G).Content());
  sorter->SortDrawings(G);
  Interface_EntityIterator list;
  int                      nb = sorter->NbSets(true);
  for (int i = 1; i <= nb; i++)
    list.GetOneItem(sorter->SetItem(i, true));
  return list;
}

TCollection_AsciiString IGESSelect_SelectDrawingFrom::Label() const
{
  return TCollection_AsciiString("Drawings attached");
}
