// Created by: CKY / Contract Toubro-Larsen
// Copyright (c) 1993-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

//--------------------------------------------------------------------
//--------------------------------------------------------------------

#include <IGESData_DirChecker.hxx>
#include <IGESData_Dump.hxx>
#include <IGESData_IGESDumper.hxx>
#include <IGESData_IGESReaderData.hxx>
#include <IGESData_IGESWriter.hxx>
#include <IGESData_ParamReader.hxx>
#include <IGESGraph_DefinitionLevel.hxx>
#include <IGESGraph_ToolDefinitionLevel.hxx>
#include <Interface_Check.hxx>
#include <Interface_CopyTool.hxx>
#include <Interface_EntityIterator.hxx>
#include <Interface_ShareTool.hxx>
#include <Message_Messenger.hxx>
#include <Standard_Integer.hxx>
#include <NCollection_Array1.hxx>
#include <NCollection_HArray1.hxx>

IGESGraph_ToolDefinitionLevel::IGESGraph_ToolDefinitionLevel() = default;

void IGESGraph_ToolDefinitionLevel::ReadOwnParams(
  const occ::handle<IGESGraph_DefinitionLevel>& ent,
  const occ::handle<IGESData_IGESReaderData>& /*IR*/,
  IGESData_ParamReader& PR) const
{
  // bool st; //szv#4:S4163:12Mar99 moved down
  int nbval;

  occ::handle<NCollection_HArray1<int>> levelNumbers;

  // Reading nbval(No. of Property Values)
  bool st = PR.ReadInteger(PR.Current(), "No. of Property Values", nbval);
  if (st && nbval > 0)
  {
    // Reading levelNumbers(HArray1OfInteger)
    //      levelNumbers = new NCollection_HArray1<int>(1, nbval);   done by :
    // clang-format off
      PR.ReadInts(PR.CurrentList(nbval), "array levelNumbers", levelNumbers, 1); //szv#4:S4163:12Mar99 `st=` not needed
    // clang-format on
  }
  else
    PR.AddFail("No. of Property Values : Not Positive");

  DirChecker(ent).CheckTypeAndForm(PR.CCheck(), ent);
  ent->Init(levelNumbers);
}

void IGESGraph_ToolDefinitionLevel::WriteOwnParams(
  const occ::handle<IGESGraph_DefinitionLevel>& ent,
  IGESData_IGESWriter&                          IW) const
{
  int Up = ent->NbPropertyValues();
  IW.Send(Up);
  for (int i = 1; i <= Up; i++)
    IW.Send(ent->LevelNumber(i));
}

void IGESGraph_ToolDefinitionLevel::OwnShared(const occ::handle<IGESGraph_DefinitionLevel>& /*ent*/,
                                              Interface_EntityIterator& /*iter*/) const
{
}

void IGESGraph_ToolDefinitionLevel::OwnCopy(const occ::handle<IGESGraph_DefinitionLevel>& another,
                                            const occ::handle<IGESGraph_DefinitionLevel>& ent,
                                            Interface_CopyTool& /*TC*/) const
{
  int                                   nbval;
  occ::handle<NCollection_HArray1<int>> levelNumbers;

  nbval = another->NbPropertyValues();

  levelNumbers = new NCollection_HArray1<int>(1, nbval);
  for (int i = 1; i <= nbval; i++)
    levelNumbers->SetValue(i, another->LevelNumber(i));

  ent->Init(levelNumbers);
}

IGESData_DirChecker IGESGraph_ToolDefinitionLevel::DirChecker(
  const occ::handle<IGESGraph_DefinitionLevel>& /*ent*/) const
{
  IGESData_DirChecker DC(406, 1);
  DC.Structure(IGESData_DefVoid);
  DC.LineFont(IGESData_DefVoid);
  DC.LineWeight(IGESData_DefVoid);
  DC.Color(IGESData_DefVoid);
  DC.BlankStatusIgnored();
  DC.UseFlagIgnored();
  DC.HierarchyStatusIgnored();
  return DC;
}

void IGESGraph_ToolDefinitionLevel::OwnCheck(const occ::handle<IGESGraph_DefinitionLevel>& /*ent*/,
                                             const Interface_ShareTool&,
                                             occ::handle<Interface_Check>& /*ach*/) const
{
}

void IGESGraph_ToolDefinitionLevel::OwnDump(const occ::handle<IGESGraph_DefinitionLevel>& ent,
                                            const IGESData_IGESDumper& /*dumper*/,
                                            Standard_OStream& S,
                                            const int         level) const
{
  S << "IGESGraph_DefinitionLevel\n"
    << "Level Numbers : ";
  IGESData_DumpVals(S, level, 1, ent->NbPropertyValues(), ent->LevelNumber);
  S << std::endl;
}
