// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

//  Include to use for calling IGESFile_Read

#ifndef IGESFile_Read_HeaderFile
#define IGESFile_Read_HeaderFile

#include <IGESData_IGESModel.hxx>
#include <IGESData_Protocol.hxx>
#include <IGESData_FileRecognizer.hxx>

Standard_EXPORT int IGESFile_Read(char*                                  nomfic,
                                  const occ::handle<IGESData_IGESModel>& amodel,
                                  const occ::handle<IGESData_Protocol>&  protocol);

Standard_EXPORT int IGESFile_ReadFNES(char*                                  nomfic,
                                      const occ::handle<IGESData_IGESModel>& amodel,
                                      const occ::handle<IGESData_Protocol>&  protocol);

Standard_EXPORT int IGESFile_Read(char*                                       nomfic,
                                  const occ::handle<IGESData_IGESModel>&      amodel,
                                  const occ::handle<IGESData_Protocol>&       protocol,
                                  const occ::handle<IGESData_FileRecognizer>& reco,
                                  const bool                                  modefnes = false);

#endif
