// Created on: 2001-08-24
// Created by: Alexnder GRIGORIEV
// Copyright (c) 2001-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <Message_Messenger.hxx>
#include <Standard_Type.hxx>
#include <TDataStd_UAttribute.hxx>
#include <TDF_Attribute.hxx>
#include <XmlMDataStd_UAttributeDriver.hxx>
#include <XmlObjMgt_Persistent.hxx>

IMPLEMENT_STANDARD_RTTIEXT(XmlMDataStd_UAttributeDriver, XmlMDF_ADriver)
IMPLEMENT_DOMSTRING(GuidString, "guid")

//=================================================================================================

XmlMDataStd_UAttributeDriver::XmlMDataStd_UAttributeDriver(
  const occ::handle<Message_Messenger>& theMsgDriver)
    : XmlMDF_ADriver(theMsgDriver, nullptr)
{
}

//=================================================================================================

occ::handle<TDF_Attribute> XmlMDataStd_UAttributeDriver::NewEmpty() const
{
  return (new TDataStd_UAttribute());
}

//=================================================================================================

bool XmlMDataStd_UAttributeDriver::Paste(const XmlObjMgt_Persistent&       theSource,
                                         const occ::handle<TDF_Attribute>& theTarget,
                                         XmlObjMgt_RRelocationTable&) const
{
  XmlObjMgt_DOMString aGuidDomStr = theSource.Element().getAttribute(::GuidString());
  const char*         aGuidStr    = (const char*)aGuidDomStr.GetString();
  if (aGuidStr[0] == '\0')
  {
    myMessageDriver->Send("error retrieving GUID for type TDataStd_UAttribute", Message_Fail);
    return false;
  }

  occ::down_cast<TDataStd_UAttribute>(theTarget)->SetID(aGuidStr);
  return true;
}

//=================================================================================================

void XmlMDataStd_UAttributeDriver::Paste(const occ::handle<TDF_Attribute>& theSource,
                                         XmlObjMgt_Persistent&             theTarget,
                                         XmlObjMgt_SRelocationTable&) const
{
  occ::handle<TDataStd_UAttribute> aName = occ::down_cast<TDataStd_UAttribute>(theSource);

  // convert GUID into attribute value
  char                aGuidStr[40];
  Standard_PCharacter pGuidStr;
  pGuidStr = aGuidStr;
  aName->ID().ToCString(pGuidStr);

  theTarget.Element().setAttribute(::GuidString(), aGuidStr);
}
