static DSP_STATIC_DATA const q7_t in_com1[256] = {
    0x52, 0x01, 0x47, 0x20, 0xA5, 0xFD, 0xFC, 0x44,
    0xF5, 0xCB, 0x2A, 0xE7, 0x1E, 0x28, 0xFF, 0xEF,
    0x3E, 0x2C, 0x05, 0x32, 0xAE, 0x09, 0xBE, 0xF5,
    0x24, 0xFA, 0xDE, 0xD6, 0xF4, 0xE7, 0x0D, 0xD7,
    0x10, 0x19, 0x0C, 0xC8, 0xBB, 0x1E, 0x05, 0xAA,
    0x44, 0x60, 0x2D, 0x21, 0x1C, 0xF0, 0x2E, 0x25,
    0xF4, 0xF1, 0xC7, 0x19, 0x26, 0xBB, 0xD0, 0x08,
    0x46, 0xF9, 0xEF, 0x7E, 0x19, 0x1E, 0x1B, 0x0A,
    0x1F, 0x22, 0x12, 0x10, 0x13, 0x05, 0x41, 0x0F,
    0x3B, 0xF6, 0xF9, 0x45, 0xE5, 0xE4, 0x14, 0xCD,
    0xE5, 0xED, 0xF3, 0x14, 0x00, 0xEF, 0xEE, 0xDA,
    0x19, 0x12, 0xB4, 0x0B, 0xAB, 0x14, 0x0A, 0xF7,
    0x15, 0x35, 0x38, 0x0C, 0xCA, 0x32, 0x02, 0xD9,
    0x1F, 0x00, 0xB9, 0x5C, 0xE4, 0x39, 0xE0, 0xE6,
    0x09, 0xAD, 0x0E, 0x30, 0x24, 0xAE, 0xF5, 0x02,
    0x1E, 0xE5, 0x1D, 0xE0, 0xC0, 0x16, 0xEB, 0x35,
    0xAA, 0x30, 0xF4, 0x95, 0xFB, 0xFB, 0xD4, 0x17,
    0x36, 0xF5, 0x26, 0x00, 0x59, 0xDD, 0x47, 0xC5,
    0xE0, 0x86, 0xCA, 0x26, 0x3B, 0xC8, 0x36, 0x31,
    0xD0, 0xAD, 0x05, 0x19, 0x07, 0xF4, 0xBE, 0xED,
    0xC9, 0xD3, 0x17, 0xC0, 0x0D, 0xDE, 0xCF, 0xDA,
    0x66, 0x95, 0xE2, 0xE4, 0x00, 0x10, 0xEC, 0xB8,
    0xD5, 0x27, 0x0B, 0xDD, 0x13, 0x85, 0xD3, 0xDF,
    0xCD, 0xD0, 0x36, 0x3A, 0xFC, 0xDB, 0x2B, 0xE0,
    0x21, 0xDB, 0xE0, 0x1F, 0x64, 0xF0, 0x8F, 0x0E,
    0x45, 0xE1, 0x39, 0x80, 0xBB, 0xF6, 0xC8, 0x42,
    0x02, 0x38, 0x16, 0x62, 0xE2, 0x3B, 0xFD, 0xE4,
    0xF6, 0x91, 0x15, 0xF0, 0xAB, 0x6A, 0x16, 0x0E,
    0xF3, 0xC4, 0xE7, 0x0E, 0xAA, 0x34, 0x1D, 0x13,
    0x44, 0xE8, 0xF2, 0xEF, 0x2E, 0x22, 0x44, 0x41,
    0x2C, 0x2E, 0x74, 0x02, 0x16, 0x06, 0xEA, 0x45,
    0xCB, 0xDE, 0xE5, 0xF3, 0x0F, 0xDE, 0x35, 0x09
    };

static DSP_STATIC_DATA const q7_t in_com2[256] = {
    0x1E, 0xDE, 0x10, 0xF2, 0x91, 0xDC, 0x37, 0x02,
    0xDE, 0x08, 0x28, 0xC3, 0x00, 0xFD, 0x14, 0x14,
    0xFC, 0x1E, 0x25, 0xF2, 0xEC, 0xD7, 0x5B, 0x66,
    0xF2, 0x93, 0xF2, 0x11, 0x35, 0x2A, 0xEE, 0xFE,
    0xE7, 0xE2, 0x27, 0xED, 0xDF, 0x02, 0x41, 0xC1,
    0xED, 0x1C, 0xD8, 0x0D, 0x2D, 0xE7, 0xEA, 0xD6,
    0xD3, 0x44, 0xB5, 0x63, 0x12, 0x2D, 0xF1, 0x1C,
    0xDC, 0xD8, 0xD8, 0xD4, 0x05, 0xEB, 0x04, 0x48,
    0xC6, 0xE1, 0x01, 0x30, 0x1D, 0x01, 0xEA, 0x17,
    0xE0, 0xB4, 0x1D, 0xFD, 0xBB, 0xF3, 0xC1, 0x2C,
    0x2B, 0xE0, 0x95, 0xD4, 0x0A, 0xEA, 0x07, 0xFF,
    0x2F, 0x04, 0x17, 0xF7, 0x02, 0x09, 0x22, 0xE6,
    0x0A, 0xCE, 0x36, 0x35, 0xF1, 0x33, 0x01, 0x27,
    0x96, 0xCC, 0xEB, 0xBC, 0x1C, 0x30, 0x9B, 0xC8,
    0x09, 0xD4, 0x07, 0x25, 0x00, 0x2F, 0x3A, 0xF3,
    0x0F, 0x2A, 0xF6, 0x2B, 0xEE, 0xE9, 0xE1, 0xE3,
    0x01, 0x0D, 0x1D, 0x0F, 0x40, 0x0A, 0x01, 0x12,
    0x39, 0x2F, 0x2F, 0x0C, 0xE7, 0x08, 0x09, 0xE9,
    0xB8, 0xED, 0x93, 0xFD, 0x21, 0xED, 0xE5, 0xCF,
    0x65, 0xE3, 0x16, 0xEC, 0xB9, 0x02, 0xFA, 0x3A,
    0x13, 0x14, 0x27, 0x2A, 0xE4, 0x32, 0xE1, 0xF0,
    0xEF, 0x51, 0x0E, 0x4B, 0x18, 0xF2, 0xB6, 0x18,
    0x16, 0xF2, 0xFA, 0x0A, 0xFE, 0x14, 0x84, 0x1B,
    0x03, 0x05, 0xDC, 0xD9, 0x50, 0xF2, 0x1F, 0xF1,
    0x34, 0x7B, 0x0C, 0x02, 0xCC, 0x2D, 0xFC, 0xBE,
    0x27, 0x0E, 0x1A, 0xFA, 0xD8, 0xFA, 0x14, 0x49,
    0xC0, 0x24, 0x05, 0x18, 0xE6, 0xBC, 0x7F, 0xE0,
    0x24, 0xEE, 0x3B, 0xA6, 0xC2, 0xF9, 0x00, 0xCB,
    0xE0, 0xF0, 0xF7, 0xD3, 0x09, 0xE4, 0x0F, 0xF3,
    0xA8, 0xD8, 0xD0, 0x22, 0x96, 0x1B, 0x0F, 0x44,
    0xA0, 0x45, 0x0C, 0xF4, 0x00, 0xC2, 0xEA, 0xE3,
    0x2A, 0x0E, 0xD5, 0xE2, 0x0E, 0xDC, 0x09, 0xC1
    };

static DSP_STATIC_DATA const q7_t in_bitwise1[47] = {
    0xFB, 0xD4, 0xF1, 0xD8, 0x8A, 0x8F, 0x00, 0xF8,
    0xD2, 0xD0, 0xE3, 0x46, 0xC4, 0x64, 0x5E, 0xB8,
    0x45, 0x14, 0x1C, 0x71, 0x9D, 0x9A, 0x5F, 0x42,
    0xFE, 0x7C, 0xCA, 0x2C, 0x3F, 0x1B, 0xFA, 0xC7,
    0xB5, 0x33, 0x72, 0x46, 0xF0, 0x8A, 0x39, 0xCC,
    0xA2, 0x05, 0xA4, 0x41, 0x87, 0xE0, 0x79
    };

static DSP_STATIC_DATA const q7_t in_bitwise2[47] = {
    0xA7, 0xE3, 0x1B, 0xCA, 0x5D, 0x6A, 0x31, 0x4C,
    0xB2, 0x00, 0xB9, 0xA2, 0x09, 0xEE, 0xA0, 0x4E,
    0xC2, 0x21, 0x65, 0x98, 0xD6, 0xCC, 0x50, 0xD6,
    0x27, 0x04, 0x0D, 0x18, 0x3E, 0xE5, 0x44, 0x3C,
    0x44, 0x5F, 0xC8, 0xBC, 0x2C, 0x67, 0x7A, 0x36,
    0x88, 0x8A, 0xC7, 0xBA, 0x91, 0x45, 0xB9
    };

static DSP_STATIC_DATA const q7_t in_rand[33] = {
    0xF6, 0xFE, 0xF5, 0x1B, 0x0D, 0x13, 0xF9, 0x10,
    0xF6, 0x02, 0xE4, 0xD5, 0xF5, 0xF7, 0x14, 0xDF,
    0xFB, 0xE6, 0xF0, 0xEE, 0x02, 0x18, 0x0E, 0x0E,
    0x16, 0xF8, 0xF3, 0xF2, 0xFF, 0x0F, 0xF6, 0x0D,
    0x1C
    };

static DSP_STATIC_DATA const q7_t in_maxpos[33] = {
    0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01,
    0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01,
    0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01,
    0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01, 0x7E, 0x01,
    0x7E
    };

static DSP_STATIC_DATA const q7_t in_maxneg[33] = {
    0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF,
    0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF,
    0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF,
    0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF, 0x81, 0xFF,
    0x81
    };

static DSP_STATIC_DATA const q7_t in_maxneg2[33] = {
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80
    };

static DSP_STATIC_DATA const q7_t in_clip[303] = {
    0x8D, 0x8E, 0x8E, 0x8F, 0x90, 0x91, 0x91, 0x92,
    0x93, 0x94, 0x94, 0x95, 0x96, 0x97, 0x97, 0x98,
    0x99, 0x9A, 0x9B, 0x9B, 0x9C, 0x9D, 0x9E, 0x9E,
    0x9F, 0xA0, 0xA1, 0xA1, 0xA2, 0xA3, 0xA4, 0xA4,
    0xA5, 0xA6, 0xA7, 0xA8, 0xA8, 0xA9, 0xAA, 0xAB,
    0xAB, 0xAC, 0xAD, 0xAE, 0xAE, 0xAF, 0xB0, 0xB1,
    0xB1, 0xB2, 0xB3, 0xB4, 0xB4, 0xB5, 0xB6, 0xB7,
    0xB8, 0xB8, 0xB9, 0xBA, 0xBB, 0xBB, 0xBC, 0xBD,
    0xBE, 0xBE, 0xBF, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3,
    0xC4, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCB, 0xCC, 0xCD, 0xCE, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD5,
    0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDE, 0xDF, 0xE0, 0xE1, 0xE1,
    0xE2, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0xE8,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEB, 0xEC, 0xED, 0xEE,
    0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF2, 0xF3, 0xF4,
    0xF5, 0xF5, 0xF6, 0xF7, 0xF8, 0xF8, 0xF9, 0xFA,
    0xFB, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFF, 0x00,
    0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x05, 0x06,
    0x07, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0C,
    0x0D, 0x0E, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x12,
    0x13, 0x14, 0x15, 0x15, 0x16, 0x17, 0x18, 0x18,
    0x19, 0x1A, 0x1B, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x1F, 0x20, 0x21, 0x22, 0x22, 0x23, 0x24, 0x25,
    0x25, 0x26, 0x27, 0x28, 0x28, 0x29, 0x2A, 0x2B,
    0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x2F, 0x30, 0x31,
    0x32, 0x32, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37,
    0x38, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3C, 0x3D,
    0x3E, 0x3F, 0x3F, 0x40, 0x41, 0x42, 0x42, 0x43,
    0x44, 0x45, 0x45, 0x46, 0x47, 0x48, 0x48, 0x49,
    0x4A, 0x4B, 0x4C, 0x4C, 0x4D, 0x4E, 0x4F, 0x4F,
    0x50, 0x51, 0x52, 0x52, 0x53, 0x54, 0x55, 0x55,
    0x56, 0x57, 0x58, 0x58, 0x59, 0x5A, 0x5B, 0x5C,
    0x5C, 0x5D, 0x5E, 0x5F, 0x5F, 0x60, 0x61, 0x62,
    0x62, 0x63, 0x64, 0x65, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x69, 0x6A, 0x6B, 0x6C, 0x6C, 0x6D, 0x6E,
    0x6F, 0x6F, 0x70, 0x71, 0x72, 0x72, 0x73
    };

static const q7_t ref_add[256] = {
    0x70, 0xDF, 0x57, 0x12, 0x80, 0xDA, 0x33, 0x47,
    0xD3, 0xD3, 0x52, 0xAA, 0x1E, 0x24, 0x13, 0x03,
    0x3A, 0x4A, 0x2A, 0x25, 0x9A, 0xE0, 0x19, 0x5B,
    0x16, 0x8E, 0xD0, 0xE7, 0x29, 0x11, 0xFC, 0xD5,
    0xF8, 0xFB, 0x33, 0xB6, 0x9A, 0x20, 0x46, 0x80,
    0x31, 0x7B, 0x05, 0x2E, 0x49, 0xD7, 0x17, 0xFB,
    0xC8, 0x36, 0x80, 0x7D, 0x38, 0xE8, 0xC1, 0x24,
    0x22, 0xD1, 0xC7, 0x51, 0x1E, 0x09, 0x20, 0x52,
    0xE5, 0x03, 0x13, 0x41, 0x30, 0x06, 0x2C, 0x26,
    0x1B, 0xAB, 0x16, 0x42, 0xA0, 0xD6, 0xD5, 0xFA,
    0x10, 0xCD, 0x88, 0xE8, 0x0A, 0xD9, 0xF5, 0xD8,
    0x48, 0x16, 0xCB, 0x01, 0xAD, 0x1D, 0x2B, 0xDE,
    0x20, 0x03, 0x6E, 0x41, 0xBB, 0x65, 0x03, 0x00,
    0xB5, 0xCC, 0xA4, 0x18, 0x00, 0x69, 0x80, 0xAE,
    0x13, 0x81, 0x14, 0x55, 0x23, 0xDD, 0x2F, 0xF5,
    0x2D, 0x0F, 0x13, 0x0C, 0xAE, 0xFF, 0xCC, 0x18,
    0xAA, 0x3D, 0x11, 0xA3, 0x3B, 0x04, 0xD5, 0x29,
    0x6F, 0x24, 0x56, 0x0C, 0x41, 0xE5, 0x51, 0xAE,
    0x98, 0x80, 0x80, 0x23, 0x5D, 0xB5, 0x1B, 0x00,
    0x35, 0x90, 0x1A, 0x05, 0xC0, 0xF6, 0xB8, 0x27,
    0xDC, 0xE7, 0x3E, 0xEA, 0xF1, 0x11, 0xB0, 0xCA,
    0x55, 0xE6, 0xF0, 0x2E, 0x18, 0x02, 0xA2, 0xD1,
    0xEB, 0x19, 0x06, 0xE7, 0x11, 0x99, 0x80, 0xFA,
    0xD0, 0xD5, 0x12, 0x13, 0x4C, 0xCD, 0x4A, 0xD1,
    0x55, 0x56, 0xEC, 0x21, 0x30, 0x1D, 0x8B, 0xCB,
    0x6B, 0xEF, 0x53, 0x80, 0x93, 0xF0, 0xDC, 0x7F,
    0xC2, 0x5C, 0x1B, 0x7A, 0xC8, 0xF7, 0x7D, 0xC4,
    0x1A, 0x80, 0x50, 0x95, 0x80, 0x63, 0x16, 0xD9,
    0xD2, 0xB4, 0xDE, 0xE0, 0xB3, 0x18, 0x2B, 0x06,
    0xED, 0xC0, 0xC2, 0x11, 0xC3, 0x3D, 0x52, 0x7F,
    0xCC, 0x73, 0x7F, 0xF5, 0x16, 0xC8, 0xD5, 0x27,
    0xF5, 0xEC, 0xBA, 0xD4, 0x1E, 0xBA, 0x3E, 0xCB
    };

static const q7_t ref_add_possat[33] = {
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F
    };

static const q7_t ref_add_negsat[33] = {
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80
    };

static const q7_t ref_sub[256] = {
    0x33, 0x23, 0x37, 0x2E, 0x14, 0x21, 0xC5, 0x42,
    0x16, 0xC2, 0x02, 0x24, 0x1F, 0x2B, 0xEB, 0xDB,
    0x41, 0x0E, 0xDF, 0x40, 0xC2, 0x32, 0x80, 0x8E,
    0x32, 0x67, 0xEC, 0xC5, 0xC0, 0xBC, 0x1F, 0xD8,
    0x29, 0x37, 0xE5, 0xDB, 0xDC, 0x1C, 0xC3, 0xE9,
    0x56, 0x44, 0x55, 0x14, 0xEF, 0x09, 0x44, 0x4E,
    0x21, 0xAD, 0x12, 0xB6, 0x14, 0x8E, 0xDF, 0xEC,
    0x69, 0x21, 0x17, 0x7F, 0x14, 0x33, 0x17, 0xC1,
    0x59, 0x41, 0x10, 0xE0, 0xF6, 0x05, 0x57, 0xF9,
    0x5A, 0x42, 0xDC, 0x48, 0x2B, 0xF1, 0x53, 0xA1,
    0xBA, 0x0D, 0x5D, 0x40, 0xF5, 0x04, 0xE7, 0xDB,
    0xEA, 0x0E, 0x9E, 0x14, 0xAA, 0x0B, 0xE8, 0x11,
    0x0B, 0x67, 0x02, 0xD7, 0xD9, 0xFF, 0x01, 0xB2,
    0x7F, 0x33, 0xCE, 0x7F, 0xC8, 0x09, 0x44, 0x1D,
    0x00, 0xD9, 0x07, 0x0B, 0x24, 0x80, 0xBA, 0x10,
    0x0F, 0xBB, 0x27, 0xB5, 0xD2, 0x2D, 0x0A, 0x52,
    0xA9, 0x24, 0xD7, 0x86, 0xBC, 0xF1, 0xD4, 0x05,
    0xFD, 0xC6, 0xF7, 0xF3, 0x72, 0xD5, 0x3E, 0xDC,
    0x28, 0x99, 0x37, 0x29, 0x1A, 0xDA, 0x51, 0x63,
    0x80, 0xCA, 0xEF, 0x2D, 0x4E, 0xF3, 0xC5, 0xB4,
    0xB6, 0xBF, 0xF0, 0x96, 0x2A, 0xAC, 0xEE, 0xEA,
    0x77, 0x80, 0xD5, 0x99, 0xE8, 0x1F, 0x36, 0xA0,
    0xBF, 0x35, 0x11, 0xD3, 0x15, 0x80, 0x4F, 0xC3,
    0xCA, 0xCC, 0x5A, 0x62, 0xAD, 0xE8, 0x0C, 0xEE,
    0xED, 0x80, 0xD4, 0x1E, 0x7F, 0xC3, 0x92, 0x50,
    0x1E, 0xD2, 0x1F, 0x86, 0xE3, 0xFC, 0xB3, 0xF9,
    0x42, 0x14, 0x11, 0x4B, 0xFC, 0x7F, 0x80, 0x04,
    0xD3, 0xA3, 0xDA, 0x4A, 0xE8, 0x71, 0x16, 0x43,
    0x13, 0xD4, 0xF0, 0x3B, 0xA1, 0x50, 0x0E, 0x20,
    0x7F, 0x0F, 0x22, 0xCD, 0x7F, 0x07, 0x35, 0xFE,
    0x7F, 0xE8, 0x68, 0x0E, 0x16, 0x44, 0x00, 0x62,
    0xA1, 0xD0, 0x11, 0x11, 0x01, 0x02, 0x2C, 0x48
    };

static const q7_t ref_sub_possat[33] = {
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F
    };

static const q7_t ref_sub_negsat[33] = {
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80
    };

static const q7_t ref_mult[256] = {
    0x13, 0x00, 0x09, 0xFC, 0x4F, 0x01, 0xFE, 0x01,
    0x03, 0xFC, 0x0D, 0x0C, 0x00, 0xFF, 0x00, 0xFD,
    0xFE, 0x0A, 0x01, 0xFB, 0x0D, 0xFD, 0xD1, 0xF7,
    0xFC, 0x05, 0x04, 0xFA, 0xFB, 0xF8, 0xFE, 0x01,
    0xFD, 0xFA, 0x04, 0x08, 0x12, 0x00, 0x02, 0x2B,
    0xF6, 0x15, 0xF2, 0x03, 0x0A, 0x03, 0xF8, 0xF4,
    0x04, 0xF8, 0x21, 0x14, 0x05, 0xE8, 0x06, 0x02,
    0xED, 0x02, 0x05, 0xD5, 0x01, 0xFB, 0x01, 0x06,
    0xF2, 0xF8, 0x00, 0x06, 0x04, 0x00, 0xF5, 0x03,
    0xF2, 0x06, 0xFE, 0xFE, 0x0E, 0x03, 0xF6, 0xEF,
    0xF7, 0x05, 0x0B, 0xF9, 0x00, 0x03, 0xFF, 0x00,
    0x09, 0x01, 0xF3, 0xFF, 0xFF, 0x01, 0x03, 0x02,
    0x02, 0xEB, 0x18, 0x05, 0x06, 0x14, 0x00, 0xF4,
    0xE6, 0x00, 0x0C, 0xCF, 0xFA, 0x15, 0x1A, 0x0B,
    0x01, 0x1D, 0x01, 0x0E, 0x00, 0xE2, 0xFB, 0x00,
    0x03, 0xF7, 0xFE, 0xF5, 0x09, 0xFC, 0x05, 0xF4,
    0x00, 0x05, 0xFD, 0xF4, 0xFE, 0x00, 0x00, 0x03,
    0x18, 0xFC, 0x0E, 0x00, 0xEF, 0xFE, 0x05, 0x0B,
    0x12, 0x13, 0x2E, 0xFF, 0x0F, 0x08, 0xF5, 0xED,
    0xDB, 0x13, 0x01, 0xFC, 0xFC, 0x00, 0x03, 0xF7,
    0xF8, 0xF9, 0x07, 0xEB, 0xFD, 0xF3, 0x0C, 0x05,
    0xF2, 0xBD, 0xFD, 0xEF, 0x00, 0xFE, 0x0B, 0xF2,
    0xF9, 0xFC, 0xFF, 0xFD, 0x00, 0xEC, 0x2B, 0xF9,
    0xFF, 0xFE, 0xF1, 0xEE, 0xFE, 0x04, 0x0A, 0x04,
    0x0D, 0xDC, 0xFD, 0x00, 0xD8, 0xFA, 0x03, 0xF9,
    0x15, 0xFD, 0x0C, 0x06, 0x16, 0x00, 0xF7, 0x26,
    0xFF, 0x10, 0x01, 0x12, 0x06, 0xE0, 0xFD, 0x07,
    0xFD, 0x10, 0x0A, 0x0C, 0x29, 0xFA, 0x00, 0xFA,
    0x03, 0x07, 0x02, 0xFB, 0xFA, 0xF5, 0x03, 0xFE,
    0xD1, 0x08, 0x05, 0xFC, 0xDA, 0x07, 0x08, 0x22,
    0xDF, 0x19, 0x0B, 0x00, 0x00, 0xFD, 0x04, 0xF0,
    0xEF, 0xFC, 0x09, 0x03, 0x02, 0x09, 0x04, 0xFB
    };

static const q7_t ref_mult_possat[33] = {
    0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00,
    0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00,
    0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00,
    0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00, 0x7F, 0x00,
    0x7F
    };

static const q7_t ref_negate[256] = {
    0xAE, 0xFF, 0xB9, 0xE0, 0x5B, 0x03, 0x04, 0xBC,
    0x0B, 0x35, 0xD6, 0x19, 0xE2, 0xD8, 0x01, 0x11,
    0xC2, 0xD4, 0xFB, 0xCE, 0x52, 0xF7, 0x42, 0x0B,
    0xDC, 0x06, 0x22, 0x2A, 0x0C, 0x19, 0xF3, 0x29,
    0xF0, 0xE7, 0xF4, 0x38, 0x45, 0xE2, 0xFB, 0x56,
    0xBC, 0xA0, 0xD3, 0xDF, 0xE4, 0x10, 0xD2, 0xDB,
    0x0C, 0x0F, 0x39, 0xE7, 0xDA, 0x45, 0x30, 0xF8,
    0xBA, 0x07, 0x11, 0x82, 0xE7, 0xE2, 0xE5, 0xF6,
    0xE1, 0xDE, 0xEE, 0xF0, 0xED, 0xFB, 0xBF, 0xF1,
    0xC5, 0x0A, 0x07, 0xBB, 0x1B, 0x1C, 0xEC, 0x33,
    0x1B, 0x13, 0x0D, 0xEC, 0x00, 0x11, 0x12, 0x26,
    0xE7, 0xEE, 0x4C, 0xF5, 0x55, 0xEC, 0xF6, 0x09,
    0xEB, 0xCB, 0xC8, 0xF4, 0x36, 0xCE, 0xFE, 0x27,
    0xE1, 0x00, 0x47, 0xA4, 0x1C, 0xC7, 0x20, 0x1A,
    0xF7, 0x53, 0xF2, 0xD0, 0xDC, 0x52, 0x0B, 0xFE,
    0xE2, 0x1B, 0xE3, 0x20, 0x40, 0xEA, 0x15, 0xCB,
    0x56, 0xD0, 0x0C, 0x6B, 0x05, 0x05, 0x2C, 0xE9,
    0xCA, 0x0B, 0xDA, 0x00, 0xA7, 0x23, 0xB9, 0x3B,
    0x20, 0x7A, 0x36, 0xDA, 0xC5, 0x38, 0xCA, 0xCF,
    0x30, 0x53, 0xFB, 0xE7, 0xF9, 0x0C, 0x42, 0x13,
    0x37, 0x2D, 0xE9, 0x40, 0xF3, 0x22, 0x31, 0x26,
    0x9A, 0x6B, 0x1E, 0x1C, 0x00, 0xF0, 0x14, 0x48,
    0x2B, 0xD9, 0xF5, 0x23, 0xED, 0x7B, 0x2D, 0x21,
    0x33, 0x30, 0xCA, 0xC6, 0x04, 0x25, 0xD5, 0x20,
    0xDF, 0x25, 0x20, 0xE1, 0x9C, 0x10, 0x71, 0xF2,
    0xBB, 0x1F, 0xC7, 0x7F, 0x45, 0x0A, 0x38, 0xBE,
    0xFE, 0xC8, 0xEA, 0x9E, 0x1E, 0xC5, 0x03, 0x1C,
    0x0A, 0x6F, 0xEB, 0x10, 0x55, 0x96, 0xEA, 0xF2,
    0x0D, 0x3C, 0x19, 0xF2, 0x56, 0xCC, 0xE3, 0xED,
    0xBC, 0x18, 0x0E, 0x11, 0xD2, 0xDE, 0xBC, 0xBF,
    0xD4, 0xD2, 0x8C, 0xFE, 0xEA, 0xFA, 0x16, 0xBB,
    0x35, 0x22, 0x1B, 0x0D, 0xF1, 0x22, 0xCB, 0xF7
    };

static const q7_t ref_negate_possat[33] = {
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F
    };

static const q7_t ref_offset[256] = {
    0x7F, 0x41, 0x7F, 0x60, 0xE5, 0x3D, 0x3C, 0x7F,
    0x35, 0x0B, 0x6A, 0x27, 0x5E, 0x68, 0x3F, 0x2F,
    0x7E, 0x6C, 0x45, 0x72, 0xEE, 0x49, 0xFE, 0x35,
    0x64, 0x3A, 0x1E, 0x16, 0x34, 0x27, 0x4D, 0x17,
    0x50, 0x59, 0x4C, 0x08, 0xFB, 0x5E, 0x45, 0xEA,
    0x7F, 0x7F, 0x6D, 0x61, 0x5C, 0x30, 0x6E, 0x65,
    0x34, 0x31, 0x07, 0x59, 0x66, 0xFB, 0x10, 0x48,
    0x7F, 0x39, 0x2F, 0x7F, 0x59, 0x5E, 0x5B, 0x4A,
    0x5F, 0x62, 0x52, 0x50, 0x53, 0x45, 0x7F, 0x4F,
    0x7B, 0x36, 0x39, 0x7F, 0x25, 0x24, 0x54, 0x0D,
    0x25, 0x2D, 0x33, 0x54, 0x40, 0x2F, 0x2E, 0x1A,
    0x59, 0x52, 0xF4, 0x4B, 0xEB, 0x54, 0x4A, 0x37,
    0x55, 0x75, 0x78, 0x4C, 0x0A, 0x72, 0x42, 0x19,
    0x5F, 0x40, 0xF9, 0x7F, 0x24, 0x79, 0x20, 0x26,
    0x49, 0xED, 0x4E, 0x70, 0x64, 0xEE, 0x35, 0x42,
    0x5E, 0x25, 0x5D, 0x20, 0x00, 0x56, 0x2B, 0x75,
    0xEA, 0x70, 0x34, 0xD5, 0x3B, 0x3B, 0x14, 0x57,
    0x76, 0x35, 0x66, 0x40, 0x7F, 0x1D, 0x7F, 0x05,
    0x20, 0xC6, 0x0A, 0x66, 0x7B, 0x08, 0x76, 0x71,
    0x10, 0xED, 0x45, 0x59, 0x47, 0x34, 0xFE, 0x2D,
    0x09, 0x13, 0x57, 0x00, 0x4D, 0x1E, 0x0F, 0x1A,
    0x7F, 0xD5, 0x22, 0x24, 0x40, 0x50, 0x2C, 0xF8,
    0x15, 0x67, 0x4B, 0x1D, 0x53, 0xC5, 0x13, 0x1F,
    0x0D, 0x10, 0x76, 0x7A, 0x3C, 0x1B, 0x6B, 0x20,
    0x61, 0x1B, 0x20, 0x5F, 0x7F, 0x30, 0xCF, 0x4E,
    0x7F, 0x21, 0x79, 0xC0, 0xFB, 0x36, 0x08, 0x7F,
    0x42, 0x78, 0x56, 0x7F, 0x22, 0x7B, 0x3D, 0x24,
    0x36, 0xD1, 0x55, 0x30, 0xEB, 0x7F, 0x56, 0x4E,
    0x33, 0x04, 0x27, 0x4E, 0xEA, 0x74, 0x5D, 0x53,
    0x7F, 0x28, 0x32, 0x2F, 0x6E, 0x62, 0x7F, 0x7F,
    0x6C, 0x6E, 0x7F, 0x42, 0x56, 0x46, 0x2A, 0x7F,
    0x0B, 0x1E, 0x25, 0x33, 0x4F, 0x1E, 0x75, 0x49
    };

static const q7_t ref_offset_possat[33] = {
    0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74,
    0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74,
    0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74,
    0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74, 0x7F, 0x74,
    0x7F
    };

static const q7_t ref_offset_negsat[33] = {
    0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C,
    0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C,
    0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C,
    0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C, 0x80, 0x8C,
    0x80
    };

static const q7_t ref_scale[256] = {
    0x29, 0x00, 0x23, 0x10, 0xD2, 0xFF, 0xFE, 0x22,
    0xFA, 0xE5, 0x15, 0xF3, 0x0F, 0x14, 0xFF, 0xF7,
    0x1F, 0x16, 0x02, 0x19, 0xD7, 0x05, 0xDF, 0xFA,
    0x12, 0xFD, 0xEF, 0xEB, 0xFA, 0xF3, 0x07, 0xEB,
    0x08, 0x0C, 0x06, 0xE4, 0xDD, 0x0F, 0x02, 0xD5,
    0x22, 0x30, 0x17, 0x10, 0x0E, 0xF8, 0x17, 0x12,
    0xFA, 0xF9, 0xE3, 0x0D, 0x13, 0xDD, 0xE8, 0x04,
    0x23, 0xFD, 0xF8, 0x3F, 0x0C, 0x0F, 0x0E, 0x05,
    0x10, 0x11, 0x09, 0x08, 0x09, 0x03, 0x21, 0x08,
    0x1D, 0xFB, 0xFC, 0x23, 0xF3, 0xF2, 0x0A, 0xE7,
    0xF2, 0xF6, 0xF9, 0x0A, 0x00, 0xF7, 0xF7, 0xED,
    0x0C, 0x09, 0xDA, 0x05, 0xD6, 0x0A, 0x05, 0xFC,
    0x0B, 0x1A, 0x1C, 0x06, 0xE5, 0x19, 0x01, 0xED,
    0x10, 0x00, 0xDD, 0x2E, 0xF2, 0x1C, 0xF0, 0xF3,
    0x05, 0xD6, 0x07, 0x18, 0x12, 0xD7, 0xFA, 0x01,
    0x0F, 0xF3, 0x0F, 0xF0, 0xE0, 0x0B, 0xF6, 0x1A,
    0xD5, 0x18, 0xFA, 0xCA, 0xFE, 0xFD, 0xEA, 0x0B,
    0x1B, 0xFB, 0x13, 0x00, 0x2D, 0xEE, 0x24, 0xE3,
    0xF0, 0xC3, 0xE5, 0x13, 0x1E, 0xE4, 0x1B, 0x19,
    0xE8, 0xD6, 0x02, 0x0D, 0x03, 0xFA, 0xDF, 0xF7,
    0xE5, 0xEA, 0x0C, 0xE0, 0x07, 0xEF, 0xE7, 0xED,
    0x33, 0xCB, 0xF1, 0xF2, 0x00, 0x08, 0xF6, 0xDC,
    0xEB, 0x14, 0x06, 0xEE, 0x0A, 0xC2, 0xEA, 0xEF,
    0xE7, 0xE8, 0x1B, 0x1D, 0xFE, 0xED, 0x16, 0xF0,
    0x10, 0xED, 0xF0, 0x10, 0x32, 0xF8, 0xC7, 0x07,
    0x22, 0xF0, 0x1D, 0xC0, 0xDE, 0xFB, 0xE4, 0x21,
    0x01, 0x1C, 0x0B, 0x31, 0xF1, 0x1E, 0xFF, 0xF2,
    0xFB, 0xC9, 0x0B, 0xF8, 0xD5, 0x35, 0x0B, 0x07,
    0xF9, 0xE2, 0xF4, 0x07, 0xD5, 0x1A, 0x0E, 0x09,
    0x22, 0xF4, 0xF9, 0xF8, 0x17, 0x11, 0x22, 0x21,
    0x16, 0x17, 0x3A, 0x01, 0x0B, 0x03, 0xF5, 0x22,
    0xE6, 0xEF, 0xF3, 0xF9, 0x08, 0xEF, 0x1B, 0x05
    };

static const q7_t ref_scale_possat[33] = {
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F
    };

static const q31_t ref_dot_prod_3[1] = {
    0x00003F91
    };

static const q31_t ref_dot_prod_4[1] = {
    0x00002194
    };

static const q31_t ref_dot_prod_4n1[1] = {
    0x0000451D
    };

static const q31_t ref_dot_prod_long[1] = {
    0x00000CE0
    };

static const q7_t ref_abs[256] = {
    0x52, 0x01, 0x47, 0x20, 0x5B, 0x03, 0x04, 0x44,
    0x0B, 0x35, 0x2A, 0x19, 0x1E, 0x28, 0x01, 0x11,
    0x3E, 0x2C, 0x05, 0x32, 0x52, 0x09, 0x42, 0x0B,
    0x24, 0x06, 0x22, 0x2A, 0x0C, 0x19, 0x0D, 0x29,
    0x10, 0x19, 0x0C, 0x38, 0x45, 0x1E, 0x05, 0x56,
    0x44, 0x60, 0x2D, 0x21, 0x1C, 0x10, 0x2E, 0x25,
    0x0C, 0x0F, 0x39, 0x19, 0x26, 0x45, 0x30, 0x08,
    0x46, 0x07, 0x11, 0x7E, 0x19, 0x1E, 0x1B, 0x0A,
    0x1F, 0x22, 0x12, 0x10, 0x13, 0x05, 0x41, 0x0F,
    0x3B, 0x0A, 0x07, 0x45, 0x1B, 0x1C, 0x14, 0x33,
    0x1B, 0x13, 0x0D, 0x14, 0x00, 0x11, 0x12, 0x26,
    0x19, 0x12, 0x4C, 0x0B, 0x55, 0x14, 0x0A, 0x09,
    0x15, 0x35, 0x38, 0x0C, 0x36, 0x32, 0x02, 0x27,
    0x1F, 0x00, 0x47, 0x5C, 0x1C, 0x39, 0x20, 0x1A,
    0x09, 0x53, 0x0E, 0x30, 0x24, 0x52, 0x0B, 0x02,
    0x1E, 0x1B, 0x1D, 0x20, 0x40, 0x16, 0x15, 0x35,
    0x56, 0x30, 0x0C, 0x6B, 0x05, 0x05, 0x2C, 0x17,
    0x36, 0x0B, 0x26, 0x00, 0x59, 0x23, 0x47, 0x3B,
    0x20, 0x7A, 0x36, 0x26, 0x3B, 0x38, 0x36, 0x31,
    0x30, 0x53, 0x05, 0x19, 0x07, 0x0C, 0x42, 0x13,
    0x37, 0x2D, 0x17, 0x40, 0x0D, 0x22, 0x31, 0x26,
    0x66, 0x6B, 0x1E, 0x1C, 0x00, 0x10, 0x14, 0x48,
    0x2B, 0x27, 0x0B, 0x23, 0x13, 0x7B, 0x2D, 0x21,
    0x33, 0x30, 0x36, 0x3A, 0x04, 0x25, 0x2B, 0x20,
    0x21, 0x25, 0x20, 0x1F, 0x64, 0x10, 0x71, 0x0E,
    0x45, 0x1F, 0x39, 0x7F, 0x45, 0x0A, 0x38, 0x42,
    0x02, 0x38, 0x16, 0x62, 0x1E, 0x3B, 0x03, 0x1C,
    0x0A, 0x6F, 0x15, 0x10, 0x55, 0x6A, 0x16, 0x0E,
    0x0D, 0x3C, 0x19, 0x0E, 0x56, 0x34, 0x1D, 0x13,
    0x44, 0x18, 0x0E, 0x11, 0x2E, 0x22, 0x44, 0x41,
    0x2C, 0x2E, 0x74, 0x02, 0x16, 0x06, 0x16, 0x45,
    0x35, 0x22, 0x1B, 0x0D, 0x0F, 0x22, 0x35, 0x09
    };

static const q7_t ref_shift[33] = {
    0xEC, 0xFB, 0xE9, 0x35, 0x1B, 0x25, 0xF3, 0x21,
    0xEB, 0x04, 0xC7, 0xAB, 0xEA, 0xEF, 0x28, 0xBF,
    0xF6, 0xCC, 0xDF, 0xDC, 0x05, 0x30, 0x1C, 0x1B,
    0x2C, 0xEF, 0xE7, 0xE4, 0xFE, 0x1E, 0xEC, 0x19,
    0x38
    };

static const q7_t ref_shift_possat[33] = {
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02, 0x7F, 0x02,
    0x7F
    };

static const q7_t ref_shift_negsat[33] = {
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE, 0x80, 0xFE,
    0x80
    };

static const uint8_t ref_and[47] = {
    0xA3, 0xC0, 0x11, 0xC8, 0x08, 0x0A, 0x00, 0x48,
    0x92, 0x00, 0xA1, 0x02, 0x00, 0x64, 0x00, 0x08,
    0x40, 0x00, 0x04, 0x10, 0x94, 0x88, 0x50, 0x42,
    0x26, 0x04, 0x08, 0x08, 0x3E, 0x01, 0x40, 0x04,
    0x04, 0x13, 0x40, 0x04, 0x20, 0x02, 0x38, 0x04,
    0x80, 0x00, 0x84, 0x00, 0x81, 0x40, 0x39
    };

static const uint8_t ref_or[47] = {
    0xFF, 0xF7, 0xFB, 0xDA, 0xDF, 0xEF, 0x31, 0xFC,
    0xF2, 0xD0, 0xFB, 0xE6, 0xCD, 0xEE, 0xFE, 0xFE,
    0xC7, 0x35, 0x7D, 0xF9, 0xDF, 0xDE, 0x5F, 0xD6,
    0xFF, 0x7C, 0xCF, 0x3C, 0x3F, 0xFF, 0xFE, 0xFF,
    0xF5, 0x7F, 0xFA, 0xFE, 0xFC, 0xEF, 0x7B, 0xFE,
    0xAA, 0x8F, 0xE7, 0xFB, 0x97, 0xE5, 0xF9
    };

static const uint8_t ref_not[47] = {
    0x04, 0x2B, 0x0E, 0x27, 0x75, 0x70, 0xFF, 0x07,
    0x2D, 0x2F, 0x1C, 0xB9, 0x3B, 0x9B, 0xA1, 0x47,
    0xBA, 0xEB, 0xE3, 0x8E, 0x62, 0x65, 0xA0, 0xBD,
    0x01, 0x83, 0x35, 0xD3, 0xC0, 0xE4, 0x05, 0x38,
    0x4A, 0xCC, 0x8D, 0xB9, 0x0F, 0x75, 0xC6, 0x33,
    0x5D, 0xFA, 0x5B, 0xBE, 0x78, 0x1F, 0x86
    };

static const uint8_t ref_xor[47] = {
    0x5C, 0x37, 0xEA, 0x12, 0xD7, 0xE5, 0x31, 0xB4,
    0x60, 0xD0, 0x5A, 0xE4, 0xCD, 0x8A, 0xFE, 0xF6,
    0x87, 0x35, 0x79, 0xE9, 0x4B, 0x56, 0x0F, 0x94,
    0xD9, 0x78, 0xC7, 0x34, 0x01, 0xFE, 0xBE, 0xFB,
    0xF1, 0x6C, 0xBA, 0xFA, 0xDC, 0xED, 0x43, 0xFA,
    0x2A, 0x8F, 0x63, 0xFB, 0x16, 0xA5, 0xC0
    };

static const q7_t ref_clip1[271] = {
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3,
    0xC4, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCB, 0xCC, 0xCD, 0xCE, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD5,
    0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDE, 0xDF, 0xE0, 0xE1, 0xE1,
    0xE2, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0xE8,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEB, 0xEC, 0xED, 0xEE,
    0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF2, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3,
    0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3, 0xF3
    };

static const q7_t ref_clip2[288] = {
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0,
    0xC0, 0xC0, 0xC0, 0xC0, 0xC1, 0xC1, 0xC2, 0xC3,
    0xC4, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCB, 0xCC, 0xCD, 0xCE, 0xCE, 0xCF,
    0xD0, 0xD1, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD5,
    0xD6, 0xD7, 0xD8, 0xD8, 0xD9, 0xDA, 0xDB, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDE, 0xDF, 0xE0, 0xE1, 0xE1,
    0xE2, 0xE3, 0xE4, 0xE5, 0xE5, 0xE6, 0xE7, 0xE8,
    0xE8, 0xE9, 0xEA, 0xEB, 0xEB, 0xEC, 0xED, 0xEE,
    0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF2, 0xF3, 0xF4,
    0xF5, 0xF5, 0xF6, 0xF7, 0xF8, 0xF8, 0xF9, 0xFA,
    0xFB, 0xFB, 0xFC, 0xFD, 0xFE, 0xFE, 0xFF, 0x00,
    0x01, 0x02, 0x02, 0x03, 0x04, 0x05, 0x05, 0x06,
    0x07, 0x08, 0x08, 0x09, 0x0A, 0x0B, 0x0B, 0x0C,
    0x0D, 0x0E, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x12,
    0x13, 0x14, 0x15, 0x15, 0x16, 0x17, 0x18, 0x18,
    0x19, 0x1A, 0x1B, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x1F, 0x20, 0x21, 0x22, 0x22, 0x23, 0x24, 0x25,
    0x25, 0x26, 0x27, 0x28, 0x28, 0x29, 0x2A, 0x2B,
    0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x2F, 0x30, 0x31,
    0x32, 0x32, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37,
    0x38, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3C, 0x3D,
    0x3E, 0x3F, 0x3F, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    };

static const q7_t ref_clip3[303] = {
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
    0x0D, 0x0E, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x12,
    0x13, 0x14, 0x15, 0x15, 0x16, 0x17, 0x18, 0x18,
    0x19, 0x1A, 0x1B, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
    0x1F, 0x20, 0x21, 0x22, 0x22, 0x23, 0x24, 0x25,
    0x25, 0x26, 0x27, 0x28, 0x28, 0x29, 0x2A, 0x2B,
    0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x2F, 0x30, 0x31,
    0x32, 0x32, 0x33, 0x34, 0x35, 0x35, 0x36, 0x37,
    0x38, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3C, 0x3D,
    0x3E, 0x3F, 0x3F, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
    };

