/*
 * Copyright 2024 Google LLC
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include <stdint.h>
#include <zephyr/dt-bindings/input/input-event-codes.h>
#include <zephyr/sys/util.h>
#include <zephyr/usb/class/hid.h>

static const uint8_t input_to_hid_map[] = {
	[INPUT_KEY_A] = HID_KEY_A,
	[INPUT_KEY_B] = HID_KEY_B,
	[INPUT_KEY_C] = HID_KEY_C,
	[INPUT_KEY_D] = HID_KEY_D,
	[INPUT_KEY_E] = HID_KEY_E,
	[INPUT_KEY_F] = HID_KEY_F,
	[INPUT_KEY_G] = HID_KEY_G,
	[INPUT_KEY_H] = HID_KEY_H,
	[INPUT_KEY_I] = HID_KEY_I,
	[INPUT_KEY_J] = HID_KEY_J,
	[INPUT_KEY_K] = HID_KEY_K,
	[INPUT_KEY_L] = HID_KEY_L,
	[INPUT_KEY_M] = HID_KEY_M,
	[INPUT_KEY_N] = HID_KEY_N,
	[INPUT_KEY_O] = HID_KEY_O,
	[INPUT_KEY_P] = HID_KEY_P,
	[INPUT_KEY_Q] = HID_KEY_Q,
	[INPUT_KEY_R] = HID_KEY_R,
	[INPUT_KEY_S] = HID_KEY_S,
	[INPUT_KEY_T] = HID_KEY_T,
	[INPUT_KEY_U] = HID_KEY_U,
	[INPUT_KEY_V] = HID_KEY_V,
	[INPUT_KEY_W] = HID_KEY_W,
	[INPUT_KEY_X] = HID_KEY_X,
	[INPUT_KEY_Y] = HID_KEY_Y,
	[INPUT_KEY_Z] = HID_KEY_Z,
	[INPUT_KEY_1] = HID_KEY_1,
	[INPUT_KEY_2] = HID_KEY_2,
	[INPUT_KEY_3] = HID_KEY_3,
	[INPUT_KEY_4] = HID_KEY_4,
	[INPUT_KEY_5] = HID_KEY_5,
	[INPUT_KEY_6] = HID_KEY_6,
	[INPUT_KEY_7] = HID_KEY_7,
	[INPUT_KEY_8] = HID_KEY_8,
	[INPUT_KEY_9] = HID_KEY_9,
	[INPUT_KEY_0] = HID_KEY_0,
	[INPUT_KEY_ENTER] = HID_KEY_ENTER,
	[INPUT_KEY_ESC] = HID_KEY_ESC,
	[INPUT_KEY_BACKSPACE] = HID_KEY_BACKSPACE,
	[INPUT_KEY_TAB] = HID_KEY_TAB,
	[INPUT_KEY_SPACE] = HID_KEY_SPACE,
	[INPUT_KEY_MINUS] = HID_KEY_MINUS,
	[INPUT_KEY_EQUAL] = HID_KEY_EQUAL,
	[INPUT_KEY_LEFTBRACE] = HID_KEY_LEFTBRACE,
	[INPUT_KEY_RIGHTBRACE] = HID_KEY_RIGHTBRACE,
	[INPUT_KEY_BACKSLASH] = HID_KEY_BACKSLASH,
	[INPUT_KEY_SEMICOLON] = HID_KEY_SEMICOLON,
	[INPUT_KEY_APOSTROPHE] = HID_KEY_APOSTROPHE,
	[INPUT_KEY_GRAVE] = HID_KEY_GRAVE,
	[INPUT_KEY_COMMA] = HID_KEY_COMMA,
	[INPUT_KEY_DOT] = HID_KEY_DOT,
	[INPUT_KEY_SLASH] = HID_KEY_SLASH,
	[INPUT_KEY_CAPSLOCK] = HID_KEY_CAPSLOCK,
	[INPUT_KEY_F1] = HID_KEY_F1,
	[INPUT_KEY_F2] = HID_KEY_F2,
	[INPUT_KEY_F3] = HID_KEY_F3,
	[INPUT_KEY_F4] = HID_KEY_F4,
	[INPUT_KEY_F5] = HID_KEY_F5,
	[INPUT_KEY_F6] = HID_KEY_F6,
	[INPUT_KEY_F7] = HID_KEY_F7,
	[INPUT_KEY_F8] = HID_KEY_F8,
	[INPUT_KEY_F9] = HID_KEY_F9,
	[INPUT_KEY_F10] = HID_KEY_F10,
	[INPUT_KEY_F11] = HID_KEY_F11,
	[INPUT_KEY_F12] = HID_KEY_F12,
	[INPUT_KEY_SYSRQ] = HID_KEY_SYSRQ,
	[INPUT_KEY_SCROLLLOCK] = HID_KEY_SCROLLLOCK,
	[INPUT_KEY_PAUSE] = HID_KEY_PAUSE,
	[INPUT_KEY_INSERT] = HID_KEY_INSERT,
	[INPUT_KEY_HOME] = HID_KEY_HOME,
	[INPUT_KEY_PAGEUP] = HID_KEY_PAGEUP,
	[INPUT_KEY_DELETE] = HID_KEY_DELETE,
	[INPUT_KEY_END] = HID_KEY_END,
	[INPUT_KEY_PAGEDOWN] = HID_KEY_PAGEDOWN,
	[INPUT_KEY_RIGHT] = HID_KEY_RIGHT,
	[INPUT_KEY_LEFT] = HID_KEY_LEFT,
	[INPUT_KEY_DOWN] = HID_KEY_DOWN,
	[INPUT_KEY_UP] = HID_KEY_UP,
	[INPUT_KEY_NUMLOCK] = HID_KEY_NUMLOCK,
	[INPUT_KEY_KPSLASH] = HID_KEY_KPSLASH,
	[INPUT_KEY_KPASTERISK] = HID_KEY_KPASTERISK,
	[INPUT_KEY_KPMINUS] = HID_KEY_KPMINUS,
	[INPUT_KEY_KPPLUS] = HID_KEY_KPPLUS,
	[INPUT_KEY_KPENTER] = HID_KEY_KPENTER,
	[INPUT_KEY_KP1] = HID_KEY_KP_1,
	[INPUT_KEY_KP2] = HID_KEY_KP_2,
	[INPUT_KEY_KP3] = HID_KEY_KP_3,
	[INPUT_KEY_KP4] = HID_KEY_KP_4,
	[INPUT_KEY_KP5] = HID_KEY_KP_5,
	[INPUT_KEY_KP6] = HID_KEY_KP_6,
	[INPUT_KEY_KP7] = HID_KEY_KP_7,
	[INPUT_KEY_KP8] = HID_KEY_KP_8,
	[INPUT_KEY_KP9] = HID_KEY_KP_9,
	[INPUT_KEY_KP0] = HID_KEY_KP_0,
};

int16_t input_to_hid_code(uint16_t input_code)
{
	uint8_t hid_code;

	if (input_code >= ARRAY_SIZE(input_to_hid_map)) {
		return -1;
	}

	hid_code = input_to_hid_map[input_code];

	if (hid_code == 0) {
		return -1;
	}

	return hid_code;
}

uint8_t input_to_hid_modifier(uint16_t input_code)
{
	switch (input_code) {
	case INPUT_KEY_LEFTCTRL:
		return HID_KBD_MODIFIER_LEFT_CTRL;
	case INPUT_KEY_LEFTSHIFT:
		return HID_KBD_MODIFIER_LEFT_SHIFT;
	case INPUT_KEY_LEFTALT:
		return HID_KBD_MODIFIER_LEFT_ALT;
	case INPUT_KEY_LEFTMETA:
		return HID_KBD_MODIFIER_LEFT_UI;
	case INPUT_KEY_RIGHTCTRL:
		return HID_KBD_MODIFIER_RIGHT_CTRL;
	case INPUT_KEY_RIGHTSHIFT:
		return HID_KBD_MODIFIER_RIGHT_SHIFT;
	case INPUT_KEY_RIGHTALT:
		return HID_KBD_MODIFIER_RIGHT_ALT;
	case INPUT_KEY_RIGHTMETA:
		return HID_KBD_MODIFIER_RIGHT_UI;
	default:
		return HID_KBD_MODIFIER_NONE;
	}
}
