/* Copyright (c) 2021 Intel Corporation
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef _ZEPHYR_SOC_INTEL_ADSP_VECTORS
#define _ZEPHYR_SOC_INTEL_ADSP_VECTORS

#include <xtensa/config/core-isa.h>

/* This is the base address of all the vectors defined in SRAM */
#define VECBASE_RESET_PADDR_SRAM \
	(L2_SRAM_BASE + CONFIG_HP_SRAM_RESERVE)

#define MEM_VECBASE_LIT_SIZE                   0x178

/* The addresses of the vectors in SRAM.
 * Only the memerror vector continues to point to its ROM address.
 */
#define INTLEVEL2_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_INTLEVEL2_VECOFS)

#define INTLEVEL3_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_INTLEVEL3_VECOFS)

#define INTLEVEL4_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_INTLEVEL4_VECOFS)

#ifndef SOC_SERIES_INTEL_ADSP_ACE
#define INTLEVEL5_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_INTLEVEL5_VECOFS)

#define INTLEVEL6_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_INTLEVEL6_VECOFS)
#endif /* SOC_SERIES_INTEL_ADSP_ACE */


#define INTLEVEL7_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_NMI_VECOFS)

#define KERNEL_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_KERNEL_VECOFS)

#define USER_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_USER_VECOFS)

#define DOUBLEEXC_VECTOR_PADDR_SRAM \
	(VECBASE_RESET_PADDR_SRAM + XCHAL_DOUBLEEXC_VECOFS)

#define VECTOR_TBL_SIZE				0x1000

/* Vector and literal sizes */
#define MEM_VECT_LIT_SIZE			0x8
#define MEM_VECT_TEXT_SIZE			0x38

#define MEM_ERROR_TEXT_SIZE			0x180
#define MEM_ERROR_LIT_SIZE			0x8

#endif /* _ZEPHYR_SOC_INTEL_ADSP_VECTORS */
