/*
 * Copyright 2024 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#define ABS_ERROR_THRESH_Q15	((int16_t)2)
#define VEC_LENGTH 256

static const int16_t in_a[VEC_LENGTH] = {
	0x0EB1, 0xD7DA, 0xDFC2, 0x2DDA, 0xAEB8, 0x1A8C, 0x34D0, 0xC949,
	0x19FF, 0x1AFC, 0xD67E, 0x2639, 0x1546, 0xF32D, 0x2A82, 0xB79E,
	0x1317, 0xEAF2, 0xCBD9, 0xC454, 0x42FD, 0xBB89, 0x9B4F, 0xCE5C,
	0x09A1, 0xDFC2, 0xD780, 0x2B2C, 0x0FDB, 0xC69C, 0x5D9B, 0xBC82,
	0x2794, 0xC287, 0x152B, 0xDA69, 0x2BE1, 0xE9BB, 0xD5EE, 0xC7C4,
	0xBCDA, 0xC828, 0x19B1, 0x5F41, 0x5146, 0x00F0, 0xDEF6, 0x2A44,
	0xCD0A, 0xE918, 0xF4D0, 0xD863, 0x241F, 0xE030, 0x26F3, 0x1ACB,
	0x245C, 0x047C, 0x9433, 0x2BF5, 0x2F0F, 0x40E5, 0xC00D, 0x849C,
	0x215D, 0xDE1B, 0x264A, 0x311D, 0x0C88, 0x1028, 0x2D8F, 0xCE0E,
	0x1B43, 0x5529, 0x2914, 0xE215, 0x0C95, 0xF727, 0xDF21, 0xD12E,
	0xBF74, 0xBFB5, 0xC4B0, 0xCDBB, 0xE3D0, 0xFAF9, 0x2579, 0xE9F5,
	0xE00D, 0xE3B7, 0x2FE5, 0xE7A2, 0xE72C, 0x4C12, 0x156E, 0x03A9,
	0xE767, 0x14B9, 0x8F36, 0x54D3, 0xF8CF, 0xC5F2, 0xE3E2, 0x3EEB,
	0x054A, 0x6482, 0x013C, 0xFF6D, 0x078F, 0xA20A, 0xEF63, 0xCBAB,
	0xC222, 0xA967, 0x3F6B, 0xFAFE, 0x1498, 0xF9D3, 0xC2C3, 0xCD2C,
	0x1B37, 0xA9E8, 0xF8A4, 0xD3A6, 0xD238, 0x55EC, 0xF7FA, 0x007C,
	0xC1BF, 0x161F, 0x8000, 0x273D, 0xEEC7, 0xFDDA, 0xD41C, 0x51C4,
	0x1697, 0x3C98, 0x2E62, 0xC85D, 0x01FF, 0xC356, 0xBCC5, 0xF6C0,
	0xC2FB, 0x1CC0, 0xC736, 0xED5C, 0x1B3C, 0xCEDC, 0xDC71, 0xD699,
	0x895A, 0xF44E, 0xFEAB, 0xB470, 0xE176, 0xC915, 0x23AD, 0xDBDE,
	0x2579, 0xB028, 0xF293, 0xF1D3, 0x2BE9, 0x3FE0, 0x5143, 0x8BB5,
	0xD9A9, 0xC304, 0x5BE4, 0xBD39, 0xF24A, 0xC721, 0xE044, 0xE5EB,
	0x3015, 0x22EB, 0x0FC5, 0xF766, 0xCAEC, 0x356E, 0xF105, 0xE3F6,
	0xC69B, 0xC858, 0x1EF3, 0xD29A, 0xF220, 0x156B, 0x0625, 0xD1BA,
	0x0DF9, 0x6A80, 0xECF5, 0xBBC4, 0xE8B3, 0x1DBD, 0x27ED, 0x43D5,
	0x38E0, 0x0942, 0x0DB3, 0x93F4, 0xF640, 0xBC17, 0xFB75, 0xB565,
	0x39FD, 0x037E, 0x533F, 0x3981, 0x2FC2, 0xA54D, 0x2DAC, 0x403B,
	0xD1AC, 0x2397, 0x06C3, 0xDD46, 0x9F4C, 0xF716, 0xD4F2, 0xFEEA,
	0xCE26, 0xF1C9, 0x376E, 0x2D6C, 0x1DA1, 0x1ADF, 0x2DB9, 0x1E02,
	0xFA30, 0x0633, 0x4356, 0x06F1, 0x0751, 0x2881, 0x1D47, 0x2D8C,
	0xA430, 0xB60E, 0x9CBD, 0xF925, 0xF90C, 0x235A, 0xDAAC, 0x3B2B,
	0x112A, 0x8F09, 0x00B9, 0xB234, 0xA386, 0xD619, 0x20AA, 0x5063};

static const int16_t in_b[VEC_LENGTH] = {
	0xF977, 0xF484, 0xB38D, 0xC049, 0x127F, 0xEE0D, 0x5183, 0x1CFF,
	0x2EC8, 0x7FFF, 0x44B4, 0xD9AD, 0x4410, 0x27AA, 0x0313, 0xC597,
	0xA23C, 0xFCF7, 0xF6CA, 0x0540, 0x3DD7, 0x4BA0, 0xCB04, 0x4650,
	0x5117, 0x0F7A, 0x16B7, 0x0052, 0x04F6, 0xCBB2, 0xD270, 0xFCD5,
	0xDFF0, 0x389E, 0x2413, 0xD405, 0x08F1, 0xF872, 0xABD2, 0x13D4,
	0x86AB, 0xDECA, 0xEFE1, 0x04D6, 0x2F20, 0xE4F2, 0x74C9, 0xFAFF,
	0x1E5B, 0x4BBC, 0xE50F, 0x26A3, 0xF12F, 0x9774, 0x0465, 0x0FE1,
	0xB3DD, 0xFF6A, 0x2B48, 0xD882, 0xD6B7, 0x077A, 0xE7AC, 0x94B7,
	0x03BB, 0x2E0B, 0xEE40, 0xED35, 0xEC88, 0x3365, 0x60B5, 0x249E,
	0x03B7, 0xCCB7, 0xB6E0, 0xB83B, 0xEB34, 0xEC7F, 0xEC20, 0x037F,
	0x29F7, 0x9EE0, 0x0079, 0xF08C, 0xE025, 0xE064, 0xF44A, 0x28BF,
	0xDB1A, 0x11F0, 0xFF16, 0x5896, 0x01D3, 0x2546, 0x0D96, 0xE7A4,
	0xFBAF, 0xC158, 0x1BD0, 0x1349, 0x0F56, 0x3C3A, 0x0971, 0x0144,
	0x0103, 0xD605, 0x5F13, 0xD660, 0x56D8, 0x281A, 0xCB9C, 0xF087,
	0x0DF1, 0xE910, 0x00A3, 0xDB1F, 0xEF24, 0xCB3C, 0xFDC3, 0x33BF,
	0xC071, 0x2387, 0x1D00, 0xFCAB, 0xDEAF, 0xD8BE, 0x50D2, 0xA530,
	0x3BED, 0x33D0, 0xC7B0, 0x8906, 0x1389, 0x5832, 0x12A8, 0xCD6B,
	0x3FB1, 0x2AF3, 0x1438, 0x230A, 0x1D37, 0xDBE5, 0xC794, 0xCF49,
	0xBD1F, 0x0352, 0xDDEF, 0xF71B, 0xF034, 0x69E3, 0xE115, 0xD0FB,
	0x14C9, 0xF522, 0xDF36, 0xE814, 0xE306, 0x2CE3, 0xDB81, 0x6658,
	0x02D7, 0x1E97, 0xBA82, 0xEE1A, 0x5C73, 0x2956, 0xBC37, 0xF3FA,
	0xD52D, 0xFE74, 0xA370, 0xE439, 0x007A, 0x0138, 0xF675, 0xDAB6,
	0xFB95, 0xE5D5, 0xF490, 0xF4FD, 0x0BD8, 0x58FF, 0xE5FA, 0x1DC2,
	0x0DB3, 0xD10F, 0x006F, 0xC3FA, 0xE69E, 0xFF03, 0x01C4, 0x2F8A,
	0xE336, 0x05F5, 0xD870, 0xDF1E, 0x532B, 0x2F9B, 0xED67, 0xB192,
	0xF663, 0xC955, 0xD832, 0xCB4F, 0x060B, 0x136A, 0x3EC8, 0xCBF4,
	0xF509, 0x480F, 0x22B4, 0xE9D0, 0x3610, 0x35F0, 0xD66A, 0xC10A,
	0x3476, 0x0C80, 0x002B, 0xEF29, 0x02A2, 0x8E39, 0xED70, 0x0D5D,
	0x8AF0, 0x1793, 0x1CD9, 0xE7A7, 0x45C4, 0x422D, 0xCF10, 0x3A84,
	0xF767, 0xC650, 0xF766, 0xCAA0, 0x2688, 0x1341, 0x3C45, 0x492B,
	0x01EE, 0x156F, 0x0862, 0x28AF, 0x42C1, 0xE27E, 0x0164, 0x8BC3,
	0x678D, 0xEECA, 0xCAF7, 0xE0AD, 0x15EB, 0x9059, 0xCAB6, 0xFE6E};

static const int16_t ref_add[VEC_LENGTH] = {
	0x0827, 0xCC5E, 0x934F, 0xEE23, 0xC137, 0x0899, 0x7FFF, 0xE647,
	0x48C7, 0x7FFF, 0x1B32, 0xFFE7, 0x5956, 0x1AD7, 0x2D96, 0x8000,
	0xB553, 0xE7E9, 0xC2A3, 0xC994, 0x7FFF, 0x072A, 0x8000, 0x14AC,
	0x5AB8, 0xEF3B, 0xEE37, 0x2B7E, 0x14D1, 0x924E, 0x300B, 0xB957,
	0x0784, 0xFB26, 0x393E, 0xAE6E, 0x34D3, 0xE22D, 0x81C0, 0xDB98,
	0x8000, 0xA6F2, 0x0992, 0x6417, 0x7FFF, 0xE5E2, 0x53BF, 0x2543,
	0xEB65, 0x34D3, 0xD9DF, 0xFF06, 0x154E, 0x8000, 0x2B58, 0x2AAC,
	0xD839, 0x03E6, 0xBF7B, 0x0477, 0x05C7, 0x485F, 0xA7B9, 0x8000,
	0x2518, 0x0C26, 0x148A, 0x1E53, 0xF910, 0x438D, 0x7FFF, 0xF2AD,
	0x1EFA, 0x21E0, 0xDFF5, 0x9A50, 0xF7C9, 0xE3A5, 0xCB41, 0xD4AD,
	0xE96C, 0x8000, 0xC529, 0xBE46, 0xC3F5, 0xDB5D, 0x19C2, 0x12B5,
	0xBB27, 0xF5A7, 0x2EFA, 0x4038, 0xE8FF, 0x7159, 0x2304, 0xEB4D,
	0xE317, 0xD611, 0xAB06, 0x681C, 0x0825, 0x022B, 0xED53, 0x402F,
	0x064D, 0x3A86, 0x6050, 0xD5CD, 0x5E68, 0xCA23, 0xBAFF, 0xBC32,
	0xD013, 0x9277, 0x400E, 0xD61D, 0x03BC, 0xC50F, 0xC086, 0x00EB,
	0xDBA8, 0xCD6F, 0x15A4, 0xD051, 0xB0E7, 0x2EAA, 0x48CC, 0xA5AC,
	0xFDAC, 0x49EF, 0x8000, 0xB044, 0x0250, 0x560C, 0xE6C4, 0x1F2F,
	0x5648, 0x678B, 0x429A, 0xEB67, 0x1F37, 0x9F3B, 0x8458, 0xC609,
	0x801A, 0x2012, 0xA525, 0xE477, 0x0B71, 0x38BF, 0xBD86, 0xA794,
	0x9E23, 0xE970, 0xDDE1, 0x9C84, 0xC47B, 0xF5F8, 0xFF2E, 0x4237,
	0x2851, 0xCEBF, 0xAD15, 0xDFED, 0x7FFF, 0x6936, 0x0D7A, 0x8000,
	0xAED7, 0xC178, 0xFF54, 0xA172, 0xF2C4, 0xC859, 0xD6B9, 0xC0A1,
	0x2BAA, 0x08C0, 0x0455, 0xEC63, 0xD6C4, 0x7FFF, 0xD6FF, 0x01B8,
	0xD44E, 0x9968, 0x1F62, 0x9693, 0xD8BE, 0x146E, 0x07E9, 0x0143,
	0xF12F, 0x7075, 0xC565, 0x9AE2, 0x3BDE, 0x4D58, 0x1554, 0xF567,
	0x2F43, 0xD297, 0xE5E5, 0x8000, 0xFC4B, 0xCF81, 0x3A3C, 0x8158,
	0x2F06, 0x4B8E, 0x75F2, 0x2351, 0x65D3, 0xDB3E, 0x0417, 0x0145,
	0x0623, 0x3017, 0x06EE, 0xCC6F, 0xA1ED, 0x854F, 0xC262, 0x0C47,
	0x8000, 0x095C, 0x5447, 0x1513, 0x6365, 0x5D0C, 0xFCC9, 0x5886,
	0xF197, 0xCC83, 0x3ABC, 0xD191, 0x2DD9, 0x3BC2, 0x598C, 0x76B7,
	0xA61E, 0xCB7E, 0xA51F, 0x21D4, 0x3BCD, 0x05D8, 0xDC10, 0xC6EE,
	0x78B7, 0x8000, 0xCBB0, 0x92E1, 0xB971, 0x8000, 0xEB5F, 0x4ED1};

static const int64_t ref_power_16[] = {44135408683};

#define FFT_LENGTH 512

int32_t fft_in[FFT_LENGTH * 2];
int32_t fft_out[FFT_LENGTH * 2];

#define IIR_LENGTH 1024

static const int32_t iir_in[IIR_LENGTH] = {
	1073741824,  1073721611,  1073660973,  1073559912,  1073418433,
	1073236539,  1073014240,  1072751541,  1072448454,  1072104991,
	1071721163,  1071296985,  1070832474,  1070327646,  1069782521,
	1069197120,  1068571463,  1067905576,  1067199483,  1066453210,
	1065666786,  1064840240,  1063973603,  1063066908,  1062120190,
	1061133483,  1060106826,  1059040255,  1057933813,  1056787540,
	1055601479,  1054375676,  1053110176,  1051805027,  1050460278,
	1049075980,  1047652185,  1046188947,  1044686319,  1043144360,
	1041563128,  1039942681,  1038283080,  1036584389,  1034846672,
	1033069992,  1031254419,  1029400019,  1027506863,  1025575021,
	1023604568,  1021595576,  1019548122,  1017462282,  1015338136,
	1013175762,  1010975244,  1008736662,  1006460102,  1004145650,
	1001793392,  999403417,   996975815,   994510677,   992008097,
	989468168,   986890986,   984276648,   981625253,   978936900,
	976211691,   973449728,   970651115,   967815958,   964944363,
	962036438,   959092294,   956112040,   953095789,   950043654,
	946955751,   943832195,   940673105,   937478599,   934248797,
	930983821,   927683795,   924348841,   920979087,   917574658,
	914135683,   910662291,   907154613,   903612782,   900036930,
	896427192,   892783704,   889106603,   885396028,   881652118,
	877875015,   874064860,   870221797,   866345970,   862437526,
	858496612,   854523376,   850517968,   846480538,   842411239,
	838310223,   834177646,   830013662,   825818428,   821592103,
	817334846,   813046816,   808728176,   804379087,   799999714,
	795590221,   791150775,   786681543,   782182692,   777654393,
	773096815,   768510131,   763894513,   759250135,   754577171,
	749875798,   745146192,   740388532,   735602997,   730789767,
	725949023,   721080948,   716185724,   711263536,   706314570,
	701339011,   696337047,   691308867,   686254659,   681174614,
	676068923,   670937779,   665781374,   660599903,   655393561,
	650162543,   644907047,   639627271,   634323413,   628995673,
	623644252,   618269352,   612871173,   607449921,   602005798,
	596539010,   591049763,   585538263,   580004717,   574449335,
	568872326,   563273898,   557654264,   552013634,   546352221,
	540670239,   534967900,   529245420,   523503015,   517740900,
	511959292,   506158409,   500338470,   494499693,   488642298,
	482766507,   476872539,   470960618,   465030965,   459083804,
	453119359,   447137854,   441139515,   435124566,   429093236,
	423045751,   416982338,   410903226,   404808644,   398698821,
	392573987,   386434373,   380280210,   374111730,   367929164,
	361732746,   355522709,   349299287,   343062714,   336813225,
	330551055,   324276440,   317989617,   311690821,   305380290,
	299058261,   292724974,   286380665,   280025574,   273659941,
	267284004,   260898005,   254502182,   248096778,   241682033,
	235258189,   228825487,   222384171,   215934481,   209476662,
	203010957,   196537608,   190056859,   183568955,   177074140,
	170572658,   164064754,   157550673,   151030660,   144504961,
	137973822,   131437487,   124896205,   118350220,   111799779,
	105245129,   98686517,    92124189,    85558393,    78989376,
	72417384,    65842666,    59265470,    52686041,    46104630,
	39521482,    32936847,    26350971,    19764104,    13176492,
	6588384,     28,          -6588327,    -13176434,   -19764046,
	-26350914,   -32936789,   -39521425,   -46104572,   -52685984,
	-59265412,   -65842609,   -72417327,   -78989318,   -85558336,
	-92124132,   -98686460,   -105245072,  -111799722,  -118350163,
	-124896148,  -131437430,  -137973764,  -144504904,  -151030603,
	-157550616,  -164064697,  -170572601,  -177074083,  -183568898,
	-190056802,  -196537551,  -203010900,  -209476606,  -215934425,
	-222384114,  -228825431,  -235258133,  -241681977,  -248096722,
	-254502126,  -260897949,  -267283949,  -273659885,  -280025519,
	-286380610,  -292724918,  -299058206,  -305380235,  -311690766,
	-317989562,  -324276386,  -330551001,  -336813171,  -343062660,
	-349299233,  -355522655,  -361732692,  -367929110,  -374111676,
	-380280156,  -386434319,  -392573933,  -398698767,  -404808591,
	-410903173,  -416982285,  -423045698,  -429093183,  -435124514,
	-441139462,  -447137802,  -453119307,  -459083752,  -465030913,
	-470960566,  -476872488,  -482766455,  -488642247,  -494499642,
	-500338419,  -506158358,  -511959241,  -517740849,  -523502964,
	-529245370,  -534967850,  -540670189,  -546352172,  -552013585,
	-557654215,  -563273849,  -568872277,  -574449287,  -580004669,
	-585538214,  -591049714,  -596538962,  -602005750,  -607449873,
	-612871126,  -618269305,  -623644206,  -628995627,  -634323367,
	-639627225,  -644907001,  -650162497,  -655393515,  -660599858,
	-665781329,  -670937734,  -676068879,  -681174570,  -686254615,
	-691308823,  -696337004,  -701338968,  -706314527,  -711263493,
	-716185681,  -721080905,  -725948981,  -730789725,  -735602955,
	-740388491,  -745146151,  -749875757,  -754577130,  -759250094,
	-763894473,  -768510091,  -773096775,  -777654353,  -782182653,
	-786681504,  -791150736,  -795590183,  -799999676,  -804379049,
	-808728138,  -813046778,  -817334808,  -821592066,  -825818391,
	-830013625,  -834177609,  -838310187,  -842411203,  -846480503,
	-850517933,  -854523341,  -858496578,  -862437492,  -866345936,
	-870221763,  -874064826,  -877874981,  -881652085,  -885395995,
	-889106571,  -892783672,  -896427160,  -900036898,  -903612751,
	-907154582,  -910662260,  -914135653,  -917574628,  -920979057,
	-924348812,  -927683766,  -930983793,  -934248769,  -937478571,
	-940673077,  -943832168,  -946955724,  -950043627,  -953095762,
	-956112014,  -959092268,  -962036413,  -964944338,  -967815933,
	-970651091,  -973449704,  -976211667,  -978936877,  -981625230,
	-984276625,  -986890963,  -989468145,  -992008075,  -994510655,
	-996975793,  -999403395,  -1001793371, -1004145629, -1006460082,
	-1008736642, -1010975224, -1013175743, -1015338117, -1017462264,
	-1019548104, -1021595558, -1023604550, -1025575004, -1027506846,
	-1029400002, -1031254403, -1033069977, -1034846656, -1036584374,
	-1038283066, -1039942666, -1041563114, -1043144347, -1044686306,
	-1046188934, -1047652173, -1049075968, -1050460266, -1051805016,
	-1053110165, -1054375665, -1055601469, -1056787530, -1057933803,
	-1059040246, -1060106816, -1061133474, -1062120182, -1063066900,
	-1063973595, -1064840232, -1065666778, -1066453203, -1067199476,
	-1067905570, -1068571458, -1069197114, -1069782516, -1070327641,
	-1070832469, -1071296981, -1071721159, -1072104987, -1072448452,
	-1072751539, -1073014237, -1073236538, -1073418431, -1073559911,
	-1073660972, -1073721610, -1073741823, -1073721611, -1073660973,
	-1073559913, -1073418434, -1073236541, -1073014242, -1072751544,
	-1072448457, -1072104994, -1071721166, -1071296989, -1070832478,
	-1070327651, -1069782526, -1069197125, -1068571469, -1067905582,
	-1067199489, -1066453216, -1065666793, -1064840247, -1063973611,
	-1063066917, -1062120198, -1061133492, -1060106835, -1059040265,
	-1057933823, -1056787550, -1055601490, -1054375687, -1053110187,
	-1051805039, -1050460290, -1049075993, -1047652198, -1046188959,
	-1044686333, -1043144374, -1041563142, -1039942695, -1038283095,
	-1036584404, -1034846687, -1033070008, -1031254435, -1029400035,
	-1027506879, -1025575038, -1023604585, -1021595594, -1019548140,
	-1017462301, -1015338155, -1013175781, -1010975263, -1008736682,
	-1006460122, -1004145670, -1001793412, -999403438,  -996975836,
	-994510699,  -992008119,  -989468190,  -986891009,  -984276671,
	-981625277,  -978936924,  -976211715,  -973449753,  -970651140,
	-967815983,  -964944388,  -962036464,  -959092320,  -956112066,
	-953095815,  -950043681,  -946955778,  -943832223,  -940673133,
	-937478627,  -934248825,  -930983850,  -927683824,  -924348871,
	-920979116,  -917574688,  -914135713,  -910662321,  -907154644,
	-903612813,  -900036961,  -896427223,  -892783736,  -889106635,
	-885396060,  -881652151,  -877875048,  -874064893,  -870221830,
	-866346004,  -862437561,  -858496647,  -854523411,  -850518003,
	-846480574,  -842411274,  -838310259,  -834177682,  -830013698,
	-825818465,  -821592140,  -817334883,  -813046854,  -808728213,
	-804379125,  -799999752,  -795590260,  -791150814,  -786681582,
	-782182732,  -777654433,  -773096855,  -768510171,  -763894553,
	-759250175,  -754577212,  -749875839,  -745146234,  -740388574,
	-735603039,  -730789809,  -725949066,  -721080991,  -716185767,
	-711263580,  -706314613,  -701339055,  -696337091,  -691308911,
	-686254703,  -681174659,  -676068968,  -670937824,  -665781419,
	-660599948,  -655393606,  -650162589,  -644907093,  -639627317,
	-634323460,  -628995720,  -623644299,  -618269399,  -612871220,
	-607449968,  -602005845,  -596539058,  -591049811,  -585538311,
	-580004766,  -574449384,  -568872374,  -563273947,  -557654313,
	-552013683,  -546352271,  -540670288,  -534967950,  -529245470,
	-523503065,  -517740950,  -511959342,  -506158460,  -500338521,
	-494499744,  -488642350,  -482766558,  -476872591,  -470960670,
	-465031017,  -459083856,  -453119411,  -447137906,  -441139567,
	-435124619,  -429093289,  -423045804,  -416982391,  -410903279,
	-404808697,  -398698874,  -392574041,  -386434427,  -380280264,
	-374111784,  -367929218,  -361732801,  -355522764,  -349299342,
	-343062769,  -336813280,  -330551110,  -324276495,  -317989672,
	-311690876,  -305380345,  -299058317,  -292725029,  -286380721,
	-280025630,  -273659997,  -267284060,  -260898060,  -254502238,
	-248096834,  -241682089,  -235258245,  -228825544,  -222384227,
	-215934538,  -209476719,  -203011013,  -196537664,  -190056916,
	-183569012,  -177074196,  -170572714,  -164064810,  -157550729,
	-151030717,  -144505018,  -137973879,  -131437545,  -124896262,
	-118350277,  -111799837,  -105245187,  -98686574,   -92124247,
	-85558450,   -78989433,   -72417442,   -65842724,   -59265527,
	-52686099,   -46104687,   -39521540,   -32936904,   -26351029,
	-19764161,   -13176549,   -6588442,    -86,         6588269,
	13176377,    19763989,    26350856,    32936732,    39521367,
	46104515,    52685927,    59265355,    65842551,    72417269,
	78989261,    85558278,    92124075,    98686402,    105245015,
	111799665,   118350106,   124896091,   131437373,   137973707,
	144504847,   151030546,   157550559,   164064640,   170572544,
	177074026,   183568842,   190056746,   196537494,   203010844,
	209476550,   215934369,   222384058,   228825375,   235258077,
	241681921,   248096666,   254502070,   260897893,   267283893,
	273659830,   280025463,   286380554,   292724863,   299058151,
	305380179,   311690711,   317989507,   324276331,   330550946,
	336813116,   343062605,   349299179,   355522601,   361732638,
	367929056,   374111622,   380280102,   386434266,   392573880,
	398698714,   404808537,   410903120,   416982232,   423045645,
	429093131,   435124461,   441139410,   447137749,   453119255,
	459083700,   465030861,   470960514,   476872436,   482766404,
	488642196,   494499591,   500338368,   506158307,   511959191,
	517740799,   523502914,   529245320,   534967800,   540670139,
	546352122,   552013535,   557654165,   563273800,   568872228,
	574449238,   580004620,   585538166,   591049666,   596538914,
	602005702,   607449826,   612871079,   618269257,   623644159,
	628995580,   634323320,   639627179,   644906955,   650162451,
	655393469,   660599812,   665781284,   670937689,   676068834,
	681174525,   686254571,   691308779,   696336960,   701338924,
	706314483,   711263450,   716185638,   721080863,   725948939,
	730789683,   735602914,   740388449,   745146109,   749875715,
	754577089,   759250053,   763894432,   768510051,   773096736,
	777654314,   782182613,   786681465,   791150698,   795590144,
	799999637,   804379011,   808728100,   813046741,   817334771,
	821592029,   825818355,   830013589,   834177573,   838310151,
	842411167,   846480467,   850517898,   854523307,   858496543,
	862437458,   866345902,   870221729,   874064793,   877874948,
	881652052,   885395963,   889106538,   892783640,   896427128,
	900036867,   903612719,   907154552,   910662230,   914135622,
	917574598,   920979028,   924348783,   927683737,   930983764,
	934248740,   937478543,   940673049,   943832140,   946955696,
	950043600,   953095736,   956111987,   959092242,   962036387,
	964944313,   967815908,   970651066,   973449680,   976211643,
	978936853,   981625207,   984276602,   986890941,   989468123,
	992008053,   994510634,   996975772,   999403374,   1001793350,
	1004145609,  1006460062,  1008736623,  1010975205,  1013175724,
	1015338098,  1017462246,  1019548086,  1021595541,  1023604533,
	1025574987,  1027506829,  1029399986,  1031254387,  1033069961,
	1034846641,  1036584359,  1038283051,  1039942652,  1041563100,
	1043144333,  1044686293,  1046188921,  1047652160,  1049075956,
	1050460255,  1051805004,  1053110154,  1054375654,  1055601458,
	1056787520,  1057933793,  1059040236,  1060106807,  1061133466,
	1062120173,  1063066892,  1063973588,  1064840225,  1065666771,
	1066453196,  1067199470,  1067905564,  1068571452,  1069197109,
	1069782511,  1070327637,  1070832465,  1071296977,  1071721156,
	1072104984,  1072448449,  1072751536,  1073014235,  1073236536,
	1073418430,  1073559910,  1073660971,  1073721610};

static int32_t iir_out[IIR_LENGTH] = {};

#define IIR_M 5

static const int32_t coef_sos[IIR_M * 5] = {526133493, 848256040, 633507676,
					    236223201, 96636764,  0,
					    515396075, 654982512, 762356695,
					    204010946, 214748364, 762356695,
					    547608330, 987842478, 493921239,
					    891205713, 869730877, 998579896,
					    794568949, 0,         633507676,
					    858993459, 386547056, 848256040,
					    1063004405};

static const int16_t coef_g[IIR_M] = {16384, 8192, 4096, 2048, 1024};
static const int64_t ref_power_32[] = {17179951315};

/* Value of MU and rightShift are arbitrary just for testing */
#define MU 100
#define RSH 31
#define FIR_LENGTH 64
#define FIR_M      64

static int32_t fir_err[FIR_LENGTH] = {};
static const int32_t fir_coef_ref[FIR_M] = {
	0,          52686013,   105245101,  157550644,  209476634,  260897977,
	311690793,  361732719,  410903200,  459083778,  506158384,  552013609,
	596538986,  639627248,  681174592,  721080927,  759250114,  795590202,
	830013643,  862437509,  892783688,  920979072,  946955737,  970651103,
	992008086,  1010975234, 1027506854, 1041563121, 1053110171, 1062120186,
	1068571460, 1072448453, 1073741823, 1072448456, 1068571466, 1062120194,
	1053110182, 1041563135, 1027506871, 1010975253, 992008108,  970651128,
	946955764,  920979102,  892783720,  862437544,  830013680,  795590241,
	759250155,  721080969,  681174636,  639627294,  596539034,  552013659,
	506158434,  459083830,  410903253,  361732773,  311690848,  260898033,
	209476691,  157550701,  105245158,  52686070};

static const int32_t fir_in_ref[FIR_LENGTH] = {
	2784,       52687975,   105245127,  157551129,  209480572,  260899599,
	311690864,  361732998,  410904911,  459085677,  506162152,  552013733,
	596539132,  639630371,  681178382,  721082228,  759252428,  795593181,
	830014978,  862438380,  892787610,  920979899,  946958840,  970653120,
	992011496,  1010976065, 1027509675, 1041565392, 1053112620, 1062121586,
	1068572784, 1072451133, 1073743011, 1072450743, 1068572751, 1062121479,
	1053112929, 1041563681, 1027509789, 1010979047, 992010538,  970651799,
	946958915,  920979653,  892787363,  862441108,  830016340,  795592792,
	759252140,  721081076,  681177636,  639628174,  596540644,  552013841,
	506160429,  459083884,  410905774,  361733050,  311692285,  260901927,
	209478927,  157554346,  105247954,  52687892};

static const int32_t fir_ref_ref[FIR_LENGTH + FIR_M] = {
	0,           52686013,    105245101,   157550644,   209476634,
	260897977,   311690793,   361732719,   410903200,   459083778,
	506158384,   552013609,   596538986,   639627248,   681174592,
	721080927,   759250114,   795590202,   830013643,   862437509,
	892783688,   920979072,   946955737,   970651103,   992008086,
	1010975234,  1027506854,  1041563121,  1053110171,  1062120186,
	1068571460,  1072448453,  1073741823,  1072448456,  1068571466,
	1062120194,  1053110182,  1041563135,  1027506871,  1010975253,
	992008108,   970651128,   946955764,   920979102,   892783720,
	862437544,   830013680,   795590241,   759250155,   721080969,
	681174636,   639627294,   596539034,   552013659,   506158434,
	459083830,   410903253,   361732773,   311690848,   260898033,
	209476691,   157550701,   105245158,   52686070,    57,
	-52685955,   -105245043,  -157550587,  -209476578,  -260897921,
	-311690738,  -361732665,  -410903146,  -459083726,  -506158333,
	-552013560,  -596538938,  -639627202,  -681174547,  -721080884,
	-759250074,  -795590163,  -830013607,  -862437475,  -892783656,
	-920979042,  -946955710,  -970651079,  -992008064,  -1010975214,
	-1027506838, -1041563107, -1053110159, -1062120177, -1068571455,
	-1072448450, -1073741823, -1072448459, -1068571472, -1062120203,
	-1053110193, -1041563149, -1027506888, -1010975273, -992008130,
	-970651152,  -946955791,  -920979131,  -892783752,  -862437578,
	-830013716,  -795590279,  -759250196,  -721081012,  -681174681,
	-639627340,  -596539082,  -552013708,  -506158485,  -459083882,
	-410903306,  -361732828,  -311690903,  -260898088,  -209476747,
	-157550758, -105245215,  -52686128};
