/*
 * Copyright (c) 2025 Silicon Laboratories Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * This configuration header is used by the Silicon Labs Bluetooth Controller init
 * functions. Kconfig options are converted to config macros expected by the Controller.
 */
#ifndef SL_BTCTRL_CONFIG_H
#define SL_BTCTRL_CONFIG_H

/* The following section maps common Zephyr Bluetooth host Kconfig options
 * to SL_CATALOG items. Note that the feature dependencies are handled
 * indirectly via Kconfig dependency resolution.
 */
#ifdef CONFIG_BT_FILTER_ACCEPT_LIST
#define SL_CATALOG_BLUETOOTH_FEATURE_ACCEPT_LIST_PRESENT
#endif

#ifdef CONFIG_BT_PER_ADV_SYNC_TRANSFER_SENDER
#ifdef CONFIG_BT_PER_ADV
#define SL_CATALOG_BLUETOOTH_FEATURE_ADVERTISER_PAST_PRESENT
#endif
#ifdef CONFIG_BT_PER_ADV_SYNC
#define SL_CATALOG_BLUETOOTH_FEATURE_SYNC_PAST_PRESENT
#endif
#endif

#ifdef CONFIG_BT_BROADCASTER
/* Both the legacy and extended advertiser require the base advertiser. */
#define SL_CATALOG_BLUETOOTH_FEATURE_ADVERTISER_PRESENT
#define SL_CATALOG_BLUETOOTH_FEATURE_LEGACY_ADVERTISER_PRESENT
#endif

#ifdef CONFIG_BT_ISO
#define SL_CATALOG_BLUETOOTH_FEATURE_CIS_PRESENT
#endif

#ifdef CONFIG_BT_CONN
#define SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_PRESENT
#endif

#ifdef CONFIG_BT_SUBRATING
#define SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_SUBRATING_PRESENT
#endif

#ifdef CONFIG_BT_PHY_UPDATE
#define SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_PHY_UPDATE_PRESENT
#else
#define SL_CATALOG_BLUETOOTH_CONNECTION_PHY_UPDATE_INCOMPATIBLE_PRESENT
#endif

#ifdef CONFIG_BT_CHANNEL_SOUNDING
#define SL_CATALOG_BLUETOOTH_FEATURE_CS_PRESENT
#endif

#ifdef CONFIG_BT_CHANNEL_SOUNDING_TEST
#define SL_CATALOG_BLUETOOTH_FEATURE_CS_TEST_PRESENT
#endif

#ifdef CONFIG_BT_EXT_ADV
#define SL_CATALOG_BLUETOOTH_FEATURE_EXTENDED_ADVERTISER_PRESENT
#define SL_CATALOG_BLUETOOTH_FEATURE_EXTENDED_SCANNER_PRESENT
#endif

#ifdef CONFIG_BT_PER_ADV_SYNC_TRANSFER_RECEIVER
#define SL_CATALOG_BLUETOOTH_FEATURE_PAST_RECEIVER_PRESENT
#endif

#ifdef CONFIG_BT_PER_ADV_RSP
#define SL_CATALOG_BLUETOOTH_FEATURE_PAWR_ADVERTISER_PRESENT
#ifdef CONFIG_BT_CONN
#define SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_PAWR_SCHEDULING_PRESENT
#endif
#endif

#ifdef CONFIG_BT_PER_ADV_SYNC_RSP
#define SL_CATALOG_BLUETOOTH_FEATURE_PAWR_SYNC_PRESENT
#endif

#ifdef CONFIG_BT_PER_ADV
#define SL_CATALOG_BLUETOOTH_FEATURE_PERIODIC_ADVERTISER_PRESENT
#endif

#ifdef CONFIG_BT_EXT_ADV_CODING_SELECTION
/* This does not have any corresponding SL_CATALOG feature, as the coding selection
 * is implicitly supported depending on the 2M / Coded PHY support, when extended
 * advertising is enabled.
 */
#endif

#ifdef CONFIG_BT_TRANSMIT_POWER_CONTROL
#define SL_CATALOG_BLUETOOTH_FEATURE_POWER_CONTROL_PRESENT
#endif

#ifdef CONFIG_BT_CTLR_PRIVACY
#define SL_CATALOG_BLUETOOTH_FEATURE_RESOLVING_LIST_PRESENT
#endif

#ifdef CONFIG_BT_OBSERVER
#define SL_CATALOG_BLUETOOTH_FEATURE_SCANNER_PRESENT
#endif

#ifdef CONFIG_BT_PER_ADV_SYNC
#define SL_CATALOG_BLUETOOTH_FEATURE_SYNC_PRESENT
#endif

#ifdef CONFIG_BT_CTLR_DTM_HCI
#define SL_CATALOG_BLUETOOTH_FEATURE_HCI_TEST_COMMANDS_PRESENT
#endif

#define SL_CATALOG_BLUETOOTH_FEATURE_PHY_SUPPORT_CONFIG_PRESENT

/* The following maps vendor-specific features to SL_CATALOG items */
#ifdef CONFIG_BT_SILABS_EFR32_HIGH_POWER
#define SL_CATALOG_BLUETOOTH_FEATURE_HIGH_POWER_PRESENT
#endif

#ifdef CONFIG_BT_SILABS_EFR32_HIGH_POWER_AFH
#define SL_CATALOG_BLUETOOTH_FEATURE_AFH_PRESENT
#define SL_BT_CONTROLLER_ADAPTIVITY_MODE (SL_BTCTRL_CHANNELMAP_FLAG_ACTIVE_ADAPTIVITY)
#endif

#ifndef CONFIG_BT_SILABS_EFR32_HCI_VS
#define SL_BLUETOOTH_NO_VS_HCI_COMMANDS
#endif

#define SL_CATALOG_BLUETOOTH_RCP_PRESENT

/* The following features are not currently supported with Zephyr */
#undef SL_CATALOG_BLUETOOTH_FEATURE_AOA_RECEIVER_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_AOA_TRANSMITTER_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_AOD_RECEIVER_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_AOD_TRANSMITTER_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_ANALYZER_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_CONNECTION_STATISTICS_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_EVEN_SCHEDULING_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_HCI_DEBUG_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_RADIO_WATCHDOG_PRESENT
#undef SL_CATALOG_BLUETOOTH_FEATURE_USER_POWER_CONTROL_PRESENT
#undef SL_CATALOG_KERNEL_PRESENT /* Only relevant in the SiSDK RTOS adaptation */
#undef SL_CATALOG_RAIL_UTIL_COEX_PRESENT

/* Maps the controller configuration options from Kconfig to Silabs defines */
#define SL_BT_CONTROLLER_BUFFER_MEMORY      CONFIG_BT_SILABS_EFR32_BUFFER_MEMORY
#define SL_BT_CONTROLLER_LE_BUFFER_SIZE_MAX CONFIG_BT_BUF_ACL_TX_COUNT
#define SL_BT_CONTROLLER_USER_ADVERTISERS   CONFIG_BT_SILABS_EFR32_USER_ADVERTISERS
#define SL_BT_CONTROLLER_COMPLETED_PACKETS_THRESHOLD                                               \
	CONFIG_BT_SILABS_EFR32_COMPLETED_PACKETS_THRESHOLD
#define SL_BT_CONTROLLER_COMPLETED_PACKETS_EVENTS_TIMEOUT                                          \
	CONFIG_BT_SILABS_EFR32_COMPLETED_PACKETS_TIMEOUT
#define SL_BT_CONFIG_MAX_QUEUED_ADV_REPORTS CONFIG_BT_SILABS_EFR32_MAX_QUEUED_ADV_REPORTS

/* Default interrupt priorities. These get overwritten later as part of HCI driver init. */
#define SL_BT_CONTROLLER_LINKLAYER_IRQ_PRIORITY 5
#define SL_BT_CONTROLLER_RADIO_IRQ_PRIORITY     4

/* Power level configuration override is not exposed in Zephyr, use RAIL PA config instead. */
#define SL_BT_CONTROLLER_MIN_POWER_LEVEL_OVERRIDE 0
#define SL_BT_CONTROLLER_MAX_POWER_LEVEL_OVERRIDE 0

#define SL_BT_CONTROLLER_SCANNER_RECEPTION_EARLY_ABORT         0
#define SL_BT_CONTROLLER_CONN_EVENT_LENGTH_MIN                 3
#define SL_BT_CONTROLLER_CONN_EVENT_LENGTH_EXTENSION           0
#define SL_BT_CONTROLLER_USE_LEGACY_VENDOR_SPECIFIC_EVENT_CODE 0

/* Use RAIL for PA configuration */
#define SL_BT_CONTROLLER_PA_CONFIG SL_BT_BLUETOOTH_RAIL_UTIL_PA

#endif /* SL_BTCTRL_CONFIG_H */
