/*
 * Copyright (c) 2024 Intel Corporation
 * Copyright (c) 2025 Croxel, Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42686P_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42686P_H_

#include "icm4268x.h"

/**
 * @defgroup ICM42686 Invensense (TDK) ICM42686 DT Options
 * @ingroup sensor_interface
 * @{
 */

/**
 * @defgroup ICM42686_ACCEL_POWER_MODES Accelerometer power modes
 * @{
 */
#define ICM42686_DT_ACCEL_OFF		ICM4268X_DT_ACCEL_OFF
#define ICM42686_DT_ACCEL_LP		ICM4268X_DT_ACCEL_LP
#define ICM42686_DT_ACCEL_LN		ICM4268X_DT_ACCEL_LN
/** @} */

/**
 * @defgroup ICM42686_GYRO_POWER_MODES Gyroscope power modes
 * @{
 */
#define ICM42686_DT_GYRO_OFF		ICM4268X_DT_GYRO_OFF
#define ICM42686_DT_GYRO_STANDBY	ICM4268X_DT_GYRO_STANDBY
#define ICM42686_DT_GYRO_LN		ICM4268X_DT_GYRO_LN
/** @} */

/**
 * @defgroup ICM42686_ACCEL_SCALE Accelerometer scale options
 * @{
 */
#define ICM42686_DT_ACCEL_FS_32		0
#define ICM42686_DT_ACCEL_FS_16		1
#define ICM42686_DT_ACCEL_FS_8		2
#define ICM42686_DT_ACCEL_FS_4		3
#define ICM42686_DT_ACCEL_FS_2		4
/** @} */

/**
 * @defgroup ICM42686_GYRO_SCALE Gyroscope scale options
 * @{
 */
#define ICM42686_DT_GYRO_FS_4000		0
#define ICM42686_DT_GYRO_FS_2000		1
#define ICM42686_DT_GYRO_FS_1000		2
#define ICM42686_DT_GYRO_FS_500			3
#define ICM42686_DT_GYRO_FS_250			4
#define ICM42686_DT_GYRO_FS_125			5
#define ICM42686_DT_GYRO_FS_62_5		6
#define ICM42686_DT_GYRO_FS_31_25		7
/** @} */

/**
 * @defgroup ICM42686_ACCEL_DATA_RATE Accelerometer data rate options
 * @{
 */
#define ICM42686_DT_ACCEL_ODR_32000		ICM4268X_DT_ACCEL_ODR_32000
#define ICM42686_DT_ACCEL_ODR_16000		ICM4268X_DT_ACCEL_ODR_16000
#define ICM42686_DT_ACCEL_ODR_8000		ICM4268X_DT_ACCEL_ODR_8000
#define ICM42686_DT_ACCEL_ODR_4000		ICM4268X_DT_ACCEL_ODR_4000
#define ICM42686_DT_ACCEL_ODR_2000		ICM4268X_DT_ACCEL_ODR_2000
#define ICM42686_DT_ACCEL_ODR_1000		ICM4268X_DT_ACCEL_ODR_1000
#define ICM42686_DT_ACCEL_ODR_200		ICM4268X_DT_ACCEL_ODR_200
#define ICM42686_DT_ACCEL_ODR_100		ICM4268X_DT_ACCEL_ODR_100
#define ICM42686_DT_ACCEL_ODR_50		ICM4268X_DT_ACCEL_ODR_50
#define ICM42686_DT_ACCEL_ODR_25		ICM4268X_DT_ACCEL_ODR_25
#define ICM42686_DT_ACCEL_ODR_12_5		ICM4268X_DT_ACCEL_ODR_12_5
#define ICM42686_DT_ACCEL_ODR_6_25		ICM4268X_DT_ACCEL_ODR_6_25
#define ICM42686_DT_ACCEL_ODR_3_125		ICM4268X_DT_ACCEL_ODR_3_125
#define ICM42686_DT_ACCEL_ODR_1_5625		ICM4268X_DT_ACCEL_ODR_1_5625
#define ICM42686_DT_ACCEL_ODR_500		ICM4268X_DT_ACCEL_ODR_500
/** @} */

/**
 * @defgroup ICM42686_GYRO_DATA_RATE Gyroscope data rate options
 * @{
 */
#define ICM42686_DT_GYRO_ODR_32000		ICM4268X_DT_GYRO_ODR_32000
#define ICM42686_DT_GYRO_ODR_16000		ICM4268X_DT_GYRO_ODR_16000
#define ICM42686_DT_GYRO_ODR_8000		ICM4268X_DT_GYRO_ODR_8000
#define ICM42686_DT_GYRO_ODR_4000		ICM4268X_DT_GYRO_ODR_4000
#define ICM42686_DT_GYRO_ODR_2000		ICM4268X_DT_GYRO_ODR_2000
#define ICM42686_DT_GYRO_ODR_1000		ICM4268X_DT_GYRO_ODR_1000
#define ICM42686_DT_GYRO_ODR_200		ICM4268X_DT_GYRO_ODR_200
#define ICM42686_DT_GYRO_ODR_100		ICM4268X_DT_GYRO_ODR_100
#define ICM42686_DT_GYRO_ODR_50			ICM4268X_DT_GYRO_ODR_50
#define ICM42686_DT_GYRO_ODR_25			ICM4268X_DT_GYRO_ODR_25
#define ICM42686_DT_GYRO_ODR_12_5		ICM4268X_DT_GYRO_ODR_12_5
#define ICM42686_DT_GYRO_ODR_500		ICM4268X_DT_GYRO_ODR_500
/** @} */

/** @} */

#endif /*ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42686P_H_ */
