/*
 * Copyright (c) 2024 GARDENA GmbH
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_SI32_PINCTRL_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_SI32_PINCTRL_

#define SI32_SIGNAL_USART0_TX   0
#define SI32_SIGNAL_USART0_RX   1
#define SI32_SIGNAL_USART0_RTS  2
#define SI32_SIGNAL_USART0_CTS  3
#define SI32_SIGNAL_USART0_UCLK 4

#define SI32_SIGNAL_SPI0_SCK  5
#define SI32_SIGNAL_SPI0_MISO 6
#define SI32_SIGNAL_SPI0_MOSI 7
#define SI32_SIGNAL_SPI0_NSS  8

#define SI32_SIGNAL_USART1_TX   9
#define SI32_SIGNAL_USART1_RX   10
#define SI32_SIGNAL_USART1_RTS  11
#define SI32_SIGNAL_USART1_CTS  12
#define SI32_SIGNAL_USART1_UCLK 13

#define SI32_SIGNAL_EPCA0_CEX0 14
#define SI32_SIGNAL_EPCA0_CEX1 15
#define SI32_SIGNAL_EPCA0_CEX2 16
#define SI32_SIGNAL_EPCA0_CEX3 17
#define SI32_SIGNAL_EPCA0_CEX4 18
#define SI32_SIGNAL_EPCA0_CEX4 19

#define SI32_SIGNAL_PCA0_CEX0 20
#define SI32_SIGNAL_PCA0_CEX1 21

#define SI32_SIGNAL_PCA1_CEX0 22
#define SI32_SIGNAL_PCA1_CEX1 23

#define SI32_SIGNAL_EPCA0_ECI 24

#define SI32_SIGNAL_PCA0_ECI 25

#define SI32_SIGNAL_PCA1_ECI 26

#define SI32_SIGNAL_I2S0_TX_WS  27
#define SI32_SIGNAL_I2S0_TX_SCK 28
#define SI32_SIGNAL_I2S0_TX_SD  29

#define SI32_SIGNAL_I2C0_SDA 30
#define SI32_SIGNAL_I2C0_SCL 31

#define SI32_SIGNAL_CMP0S 32
#define SI32_SIGNAL_CMP0A 33

#define SI32_SIGNAL_CMP1S 34
#define SI32_SIGNAL_CMP1A 35

#define SI32_SIGNAL_TIMER0_CT 36
#define SI32_SIGNAL_TIMER0_EX 37

#define SI32_SIGNAL_TIMER1_CT 38
#define SI32_SIGNAL_TIMER1_EX 39

#define SI32_SIGNAL_UART0_TX  40
#define SI32_SIGNAL_UART0_RX  41
#define SI32_SIGNAL_UART0_RTS 42
#define SI32_SIGNAL_UART0_CTS 43

#define SI32_SIGNAL_UART1_TX 44
#define SI32_SIGNAL_UART1_RX 45

#define SI32_SIGNAL_SPI1_SCK  46
#define SI32_SIGNAL_SPI1_MISO 47
#define SI32_SIGNAL_SPI1_MOSI 48
#define SI32_SIGNAL_SPI1_NSS  49

#define SI32_SIGNAL_SPI2_SCK  50
#define SI32_SIGNAL_SPI2_MISO 51
#define SI32_SIGNAL_SPI2_MOSI 52
#define SI32_SIGNAL_SPI2_NSS  53

#define SI32_SIGNAL_AHB_OUT 54

#define SI32_SIGNAL_SSG0_EX0 55
#define SI32_SIGNAL_SSG0_EX1 56
#define SI32_SIGNAL_SSG0_EX2 57
#define SI32_SIGNAL_SSG0_EX3 58

#define SI32_SIGNAL_RTC0_OUT 59

#define SI32_SIGNAL_I2S0_RX_WS  60
#define SI32_SIGNAL_I2S0_RX_SCK 61
#define SI32_SIGNAL_I2S0_RX_SD  62

#define SI32_SIGNAL_LPTIMER0_OUT 63

#define SI32_SIGNAL_I2C1_SDA 64
#define SI32_SIGNAL_I2C1_SCL 65

#define SI32_SIGNAL_PB_HDKILL 66

/**
 * @brief Specify MUX field
 *
 * @param fun Function name
 * @param port Port number (0 to 4)
 * @param pin Port pin number (0 to 15)
 */
#define SI32_MUX(fun, port, pin)                                                                   \
	((((port)&0x7)) | (((pin)&0xF) << 3) | ((SI32_SIGNAL_##fun & 0x7F) << 22))

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_SI32_PINCTRL_ */
