/*
 * Copyright (c) 2021, Yonatan Schachter
 * Copyright (c) 2024, Andrew Featherstone
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_PINCTRL_COMMON_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_PINCTRL_COMMON_H_

#define RP2_ALT_FUNC_POS  0
#define RP2_ALT_FUNC_MASK 0xf

#define RP2_PIN_NUM_POS  5
#define RP2_PIN_NUM_MASK 0x3f

#define RP2_GPIO_OVERRIDE_NORMAL 0
#define RP2_GPIO_OVERRIDE_INVERT 1
#define RP2_GPIO_OVERRIDE_LOW    2
#define RP2_GPIO_OVERRIDE_HIGH   3

#define RP2XXX_PINMUX(pin_num, alt_func) \
	(((pin_num) << RP2_PIN_NUM_POS) | ((alt_func) << RP2_ALT_FUNC_POS))

/* These function are common. SoC-specific functions are defined in their
 * respective header file. Refer to table 279 and 642 in the RP2040 and RP2350
 * datasheets for the source of these numbers.
 */
#define RP2_PINCTRL_GPIO_FUNC_SPI  1
#define RP2_PINCTRL_GPIO_FUNC_UART 2
#define RP2_PINCTRL_GPIO_FUNC_I2C  3
#define RP2_PINCTRL_GPIO_FUNC_PWM  4
#define RP2_PINCTRL_GPIO_FUNC_SIO  5
#define RP2_PINCTRL_GPIO_FUNC_PIO0 6
#define RP2_PINCTRL_GPIO_FUNC_PIO1 7

#define GPIO_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_SIO)
#define GPIO_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_SIO)

/* These pin assignments for each function are similarly common. */
#define SPI0_RX_P0   RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_CSN_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_SCK_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_TX_P3   RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_RX_P4   RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_CSN_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_SCK_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_TX_P7   RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_RX_P8   RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_CSN_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_SCK_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_TX_P11  RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_RX_P12  RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_CSN_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_SCK_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_TX_P15  RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_RX_P16  RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_CSN_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_SCK_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_TX_P19  RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_RX_P20  RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_CSN_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_SCK_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI0_TX_P23  RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_RX_P24  RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_CSN_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_SCK_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_TX_P27  RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_RX_P28  RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_SPI)
#define SPI1_CSN_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_SPI)

#define UART0_TX_P0   RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RX_P1   RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_CTS_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RTS_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_TX_P4   RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RX_P5   RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_CTS_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RTS_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_TX_P8   RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RX_P9   RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_CTS_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RTS_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_TX_P12  RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RX_P13  RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_CTS_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RTS_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_TX_P16  RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RX_P17  RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_CTS_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RTS_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_TX_P20  RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RX_P21  RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_CTS_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RTS_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_TX_P24  RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RX_P25  RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_CTS_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART1_RTS_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_TX_P28  RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_UART)
#define UART0_RX_P29  RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_UART)

#define I2C0_SDA_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SDA_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C1_SCL_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SDA_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_I2C)
#define I2C0_SCL_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_I2C)

#define PWM_0A_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_0B_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_1A_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_1B_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_2A_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_2B_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_3A_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_3B_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_4A_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_4B_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_5A_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_5B_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_6A_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_6B_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_7A_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_7B_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_0A_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_0B_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_1A_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_1B_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_2A_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_2B_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_3A_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_3B_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_4A_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_4B_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_5A_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_5B_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_6A_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_PWM)
#define PWM_6B_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_PWM)

#define PIO0_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_PIO0)
#define PIO0_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_PIO0)

#define PIO1_P0  RP2XXX_PINMUX(0, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P2  RP2XXX_PINMUX(2, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P3  RP2XXX_PINMUX(3, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P5  RP2XXX_PINMUX(5, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P6  RP2XXX_PINMUX(6, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P8  RP2XXX_PINMUX(8, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P9  RP2XXX_PINMUX(9, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P11 RP2XXX_PINMUX(11, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P12 RP2XXX_PINMUX(12, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P14 RP2XXX_PINMUX(14, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P15 RP2XXX_PINMUX(15, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P17 RP2XXX_PINMUX(17, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P18 RP2XXX_PINMUX(18, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P20 RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P26 RP2XXX_PINMUX(26, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P27 RP2XXX_PINMUX(27, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_PIO1)
#define PIO1_P29 RP2XXX_PINMUX(29, RP2_PINCTRL_GPIO_FUNC_PIO1)

#define GPIN0_P20  RP2XXX_PINMUX(20, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPIN1_P22  RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT0_P21 RP2XXX_PINMUX(21, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT1_P23 RP2XXX_PINMUX(23, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT2_P24 RP2XXX_PINMUX(24, RP2_PINCTRL_GPIO_FUNC_GPCK)
#define GPOUT3_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_GPCK)

#define USB_VBUS_DET_P1  RP2XXX_PINMUX(1, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P4  RP2XXX_PINMUX(4, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P7  RP2XXX_PINMUX(7, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P10 RP2XXX_PINMUX(10, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P13 RP2XXX_PINMUX(13, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P16 RP2XXX_PINMUX(16, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P19 RP2XXX_PINMUX(19, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P22 RP2XXX_PINMUX(22, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P25 RP2XXX_PINMUX(25, RP2_PINCTRL_GPIO_FUNC_USB)
#define USB_VBUS_DET_P28 RP2XXX_PINMUX(28, RP2_PINCTRL_GPIO_FUNC_USB)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RPI_PICO_PINCTRL_COMMON_H_ */
