/*
 * Copyright 2025 Arm Limited and/or its affiliates <open-source-office@arm.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#define MPS4_ALT_FUNC_POS 0
#define MPS4_ALT_FUNC_MASK 0x7

#define MPS4_EXP_NUM_POS 3
#define MPS4_EXP_NUM_MASK 0x1F8

#define MPS4_PINCTRL_FUNC_UART 0
#define MPS4_PINCTRL_FUNC_GPIO 1
#define MPS4_PINCTRL_FUNC_I2C 2
#define MPS4_PINCTRL_FUNC_SPI 3

#define MPS4_PINMUX(alt_func, exp_num) (exp_num << MPS4_EXP_NUM_POS | \
	alt_func << MPS4_ALT_FUNC_POS)

/* GPIO 0 */
#define UART3_RXD_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_UART, 0)
#define UART3_TXD_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_UART, 1)
#define SPI3_SS_EXP    MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI, 10)
#define SPI3_MOSI_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI, 11)
#define SPI3_MISO_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI, 12)
#define SPI3_SCK_EXP   MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI, 13)
#define SBCON2_SDA_EXP MPS4_PINMUX(MPS4_PINCTRL_FUNC_I2C, 14)
#define SBCON2_SCL_EXP MPS4_PINMUX(MPS4_PINCTRL_FUNC_I2C, 15)


/* GPIO 1 */
#define UART4_RXD_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_UART, 16)
#define UART4_TXD_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_UART, 17)
#define SPI4_SS_EXP    MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI,  26)
#define SPI4_MOSI_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI,  27)
#define SPI4_MISO_EXP  MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI,  28)
#define SPI4_SCK_EXP   MPS4_PINMUX(MPS4_PINCTRL_FUNC_SPI,  29)
#define SBCON3_SDA_EXP MPS4_PINMUX(MPS4_PINCTRL_FUNC_I2C,  30)
#define SBCON3_SCL_EXP MPS4_PINMUX(MPS4_PINCTRL_FUNC_I2C,  31)
