/*
 * Copyright 2025 Arm Limited and/or its affiliates <open-source-office@arm.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#define MPS3_ALT_FUNC_POS 0
#define MPS3_ALT_FUNC_MASK 0x7

#define MPS3_EXP_NUM_POS 3
#define MPS3_EXP_NUM_MASK 0x1F8

#define MPS3_PINCTRL_FUNC_UART 0
#define MPS3_PINCTRL_FUNC_GPIO 1
#define MPS3_PINCTRL_FUNC_I2C 2
#define MPS3_PINCTRL_FUNC_SPI 3
#define MPS3_PINCTRL_FUNC_PMOD 4

#define MPS3_PINMUX(alt_func, exp_num) (exp_num << MPS3_EXP_NUM_POS | \
	alt_func << MPS3_ALT_FUNC_POS)

/* GPIO 0 */
#define PMOD1_IO1_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 0)
#define PMOD1_IO0_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 1)
#define PMOD1_SS_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 3)
#define PMOD0_IO2_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 7)
#define PMOD0_IO3_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 8)
#define PMOD1_SCK_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 9)
#define PMOD0_SS_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 10)
#define PMOD0_IO0_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 11)
#define PMOD0_IO1_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 12)
#define PMOD0_SCK_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 13)
#define PMOD1_IO3_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 14)
#define PMOD1_IO2_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_PMOD, 15)

#define UART3_RXD_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_UART, 0)
#define UART3_TXD_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_UART, 1)
#define SPI3_SS_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 10)
#define SPI3_MOSI_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 11)
#define SPI3_MISO_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 12)
#define SPI3_SCK_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 13)
#define SBCON2_SDA_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_I2C, 14)
#define SBCON2_SCL_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_I2C, 15)


/* GPIO 1 */
#define UART4_RXD_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_UART, 16)
#define UART4_TXD_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_UART, 17)
#define SPI4_SS_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 26)
#define SPI4_MOSI_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 27)
#define SPI4_MISO_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 28)
#define SPI4_SCK_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_SPI, 29)
#define SBCON3_SDA_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_I2C, 30)
#define SBCON3_SCL_EXP MPS3_PINMUX(MPS3_PINCTRL_FUNC_I2C, 31)
