/*
 * Copyright (c) 2023 Antmicro <www.antmicro.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_AMBIQ_APOLLO4_PINCTRL_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_AMBIQ_APOLLO4_PINCTRL_H_

#define APOLLO4_ALT_FUNC_POS 0
#define APOLLO4_ALT_FUNC_MASK 0xf

#define APOLLO4_PIN_NUM_POS 4
#define APOLLO4_PIN_NUM_MASK 0x7f

#define APOLLO4_PINMUX(pin_num, alt_func) (pin_num << APOLLO4_PIN_NUM_POS | \
					alt_func << APOLLO4_ALT_FUNC_POS)

#define SWTRACECLK_P0 APOLLO4_PINMUX(0, 0)
#define SLSCL_P0 APOLLO4_PINMUX(0, 1)
#define SLSCK_P0 APOLLO4_PINMUX(0, 2)
#define GPIO_P0 APOLLO4_PINMUX(0, 3)
#define UART0TX_P0 APOLLO4_PINMUX(0, 4)
#define UART1TX_P0 APOLLO4_PINMUX(0, 5)
#define CT0_P0 APOLLO4_PINMUX(0, 6)
#define NCE0_P0 APOLLO4_PINMUX(0, 7)
#define OBSBUS0_P0 APOLLO4_PINMUX(0, 8)
#define VCMPO_P0 APOLLO4_PINMUX(0, 9)
#define FPIO_P0 APOLLO4_PINMUX(0, 11)
#define SWTRACE0_P1 APOLLO4_PINMUX(1, 0)
#define SLSDAWIR3_P1 APOLLO4_PINMUX(1, 1)
#define SLMOSI_P1 APOLLO4_PINMUX(1, 2)
#define GPIO_P1 APOLLO4_PINMUX(1, 3)
#define UART2TX_P1 APOLLO4_PINMUX(1, 4)
#define UART3TX_P1 APOLLO4_PINMUX(1, 5)
#define CT1_P1 APOLLO4_PINMUX(1, 6)
#define NCE1_P1 APOLLO4_PINMUX(1, 7)
#define OBSBUS1_P1 APOLLO4_PINMUX(1, 8)
#define VCMPO_P1 APOLLO4_PINMUX(1, 9)
#define FPIO_P1 APOLLO4_PINMUX(1, 11)
#define SCANIN4_P1 APOLLO4_PINMUX(1, 15)
#define SWTRACE1_P2 APOLLO4_PINMUX(2, 0)
#define SLMISO_P2 APOLLO4_PINMUX(2, 1)
#define TRIG1_P2 APOLLO4_PINMUX(2, 2)
#define GPIO_P2 APOLLO4_PINMUX(2, 3)
#define UART0RX_P2 APOLLO4_PINMUX(2, 4)
#define UART1RX_P2 APOLLO4_PINMUX(2, 5)
#define CT2_P2 APOLLO4_PINMUX(2, 6)
#define NCE2_P2 APOLLO4_PINMUX(2, 7)
#define OBSBUS2_P2 APOLLO4_PINMUX(2, 8)
#define VCMPO_P2 APOLLO4_PINMUX(2, 9)
#define FPIO_P2 APOLLO4_PINMUX(2, 11)
#define SCANRSTN_P2 APOLLO4_PINMUX(2, 15)
#define SWTRACE2_P3 APOLLO4_PINMUX(3, 0)
#define SLNCE_P3 APOLLO4_PINMUX(3, 1)
#define SWO_P3 APOLLO4_PINMUX(3, 2)
#define GPIO_P3 APOLLO4_PINMUX(3, 3)
#define UART2RX_P3 APOLLO4_PINMUX(3, 4)
#define UART3RX_P3 APOLLO4_PINMUX(3, 5)
#define CT3_P3 APOLLO4_PINMUX(3, 6)
#define NCE3_P3 APOLLO4_PINMUX(3, 7)
#define OBSBUS3_P3 APOLLO4_PINMUX(3, 8)
#define FPIO_P3 APOLLO4_PINMUX(3, 11)
#define SCANIN5_P3 APOLLO4_PINMUX(3, 15)
#define SWTRACE3_P4 APOLLO4_PINMUX(4, 0)
#define SLINT_P4 APOLLO4_PINMUX(4, 1)
#define XT32KHZ_P4 APOLLO4_PINMUX(4, 2)
#define GPIO_P4 APOLLO4_PINMUX(4, 3)
#define UART0RTS_P4 APOLLO4_PINMUX(4, 4)
#define UART1RTS_P4 APOLLO4_PINMUX(4, 5)
#define CT4_P4 APOLLO4_PINMUX(4, 6)
#define NCE4_P4 APOLLO4_PINMUX(4, 7)
#define OBSBUS4_P4 APOLLO4_PINMUX(4, 8)
#define I2S0_SDIN_P4 APOLLO4_PINMUX(4, 9)
#define I2S1_SDIN_P4 APOLLO4_PINMUX(4, 10)
#define FPIO_P4 APOLLO4_PINMUX(4, 11)
#define FLB_TDO_P4 APOLLO4_PINMUX(4, 12)
#define FLLOAD_DIR_P4 APOLLO4_PINMUX(4, 13)
#define MDA_TDO_P4 APOLLO4_PINMUX(4, 14)
#define OPCG_TRIG_P4 APOLLO4_PINMUX(4, 15)
#define M0SCL_P5 APOLLO4_PINMUX(5, 0)
#define M0SCK_P5 APOLLO4_PINMUX(5, 1)
#define I2S0_CLK_P5 APOLLO4_PINMUX(5, 2)
#define GPIO_P5 APOLLO4_PINMUX(5, 3)
#define UART2RTS_P5 APOLLO4_PINMUX(5, 4)
#define UART3RTS_P5 APOLLO4_PINMUX(5, 5)
#define CT5_P5 APOLLO4_PINMUX(5, 6)
#define NCE5_P5 APOLLO4_PINMUX(5, 7)
#define OBSBUS5_P5 APOLLO4_PINMUX(5, 8)
#define I2S1_CLK_P5 APOLLO4_PINMUX(5, 10)
#define FPIO_P5 APOLLO4_PINMUX(5, 11)
#define FLB_TDI_P5 APOLLO4_PINMUX(5, 12)
#define FLLOAD_DATA_P5 APOLLO4_PINMUX(5, 13)
#define MDA_SRST_P5 APOLLO4_PINMUX(5, 14)
#define DFT_ISO_P5 APOLLO4_PINMUX(5, 15)
#define M0SDAWIR3_P6 APOLLO4_PINMUX(6, 0)
#define M0MOSI_P6 APOLLO4_PINMUX(6, 1)
#define I2S0_DATA_P6 APOLLO4_PINMUX(6, 2)
#define GPIO_P6 APOLLO4_PINMUX(6, 3)
#define UART0CTS_P6 APOLLO4_PINMUX(6, 4)
#define UART1CTS_P6 APOLLO4_PINMUX(6, 5)
#define CT6_P6 APOLLO4_PINMUX(6, 6)
#define NCE6_P6 APOLLO4_PINMUX(6, 7)
#define OBSBUS6_P6 APOLLO4_PINMUX(6, 8)
#define I2S0_SDOUT_P6 APOLLO4_PINMUX(6, 9)
#define I2S1_SDOUT_P6 APOLLO4_PINMUX(6, 10)
#define FPIO_P6 APOLLO4_PINMUX(6, 11)
#define SCANIN6_P6 APOLLO4_PINMUX(6, 15)
#define M0MISO_P7 APOLLO4_PINMUX(7, 0)
#define TRIG0_P7 APOLLO4_PINMUX(7, 1)
#define I2S0_WS_P7 APOLLO4_PINMUX(7, 2)
#define GPIO_P7 APOLLO4_PINMUX(7, 3)
#define UART2CTS_P7 APOLLO4_PINMUX(7, 4)
#define UART3CTS_P7 APOLLO4_PINMUX(7, 5)
#define CT7_P7 APOLLO4_PINMUX(7, 6)
#define NCE7_P7 APOLLO4_PINMUX(7, 7)
#define OBSBUS7_P7 APOLLO4_PINMUX(7, 8)
#define I2S1_WS_P7 APOLLO4_PINMUX(7, 10)
#define FPIO_P7 APOLLO4_PINMUX(7, 11)
#define SCANIN7_P7 APOLLO4_PINMUX(7, 15)
#define CMPRF1_P8 APOLLO4_PINMUX(8, 0)
#define TRIG1_P8 APOLLO4_PINMUX(8, 1)
#define GPIO_P8 APOLLO4_PINMUX(8, 3)
#define M1SCL_P8 APOLLO4_PINMUX(8, 4)
#define M1SCK_P8 APOLLO4_PINMUX(8, 5)
#define CT8_P8 APOLLO4_PINMUX(8, 6)
#define NCE8_P8 APOLLO4_PINMUX(8, 7)
#define OBSBUS8_P8 APOLLO4_PINMUX(8, 8)
#define FPIO_P8 APOLLO4_PINMUX(8, 11)
#define SCANOUT4_P8 APOLLO4_PINMUX(8, 15)
#define CMPRF0_P9 APOLLO4_PINMUX(9, 0)
#define TRIG2_P9 APOLLO4_PINMUX(9, 1)
#define GPIO_P9 APOLLO4_PINMUX(9, 3)
#define M1SDAWIR3_P9 APOLLO4_PINMUX(9, 4)
#define M1MOSI_P9 APOLLO4_PINMUX(9, 5)
#define CT9_P9 APOLLO4_PINMUX(9, 6)
#define NCE9_P9 APOLLO4_PINMUX(9, 7)
#define OBSBUS9_P9 APOLLO4_PINMUX(9, 8)
#define FPIO_P9 APOLLO4_PINMUX(9, 11)
#define SCANOUT5_P9 APOLLO4_PINMUX(9, 15)
#define CMPIN0_P10 APOLLO4_PINMUX(10, 0)
#define TRIG3_P10 APOLLO4_PINMUX(10, 1)
#define GPIO_P10 APOLLO4_PINMUX(10, 3)
#define M1MISO_P10 APOLLO4_PINMUX(10, 4)
#define CT10_P10 APOLLO4_PINMUX(10, 6)
#define NCE10_P10 APOLLO4_PINMUX(10, 7)
#define OBSBUS10_P10 APOLLO4_PINMUX(10, 8)
#define DISP_TE_P10 APOLLO4_PINMUX(10, 9)
#define FPIO_P10 APOLLO4_PINMUX(10, 11)
#define OPCG_LOAD_P10 APOLLO4_PINMUX(10, 15)
#define CMPIN1_P11 APOLLO4_PINMUX(11, 0)
#define TRIG0_P11 APOLLO4_PINMUX(11, 1)
#define I2S0_CLK_P11 APOLLO4_PINMUX(11, 2)
#define GPIO_P11 APOLLO4_PINMUX(11, 3)
#define UART2RX_P11 APOLLO4_PINMUX(11, 4)
#define UART3RX_P11 APOLLO4_PINMUX(11, 5)
#define CT11_P11 APOLLO4_PINMUX(11, 6)
#define NCE11_P11 APOLLO4_PINMUX(11, 7)
#define OBSBUS11_P11 APOLLO4_PINMUX(11, 8)
#define FPIO_P11 APOLLO4_PINMUX(11, 11)
#define FLB_TCLK_P11 APOLLO4_PINMUX(11, 12)
#define FLLOAD_ADDR_P11 APOLLO4_PINMUX(11, 13)
#define MDA_TCK_P11 APOLLO4_PINMUX(11, 14)
#define SCANIN0_P11 APOLLO4_PINMUX(11, 15)
#define ADCSE7_P12 APOLLO4_PINMUX(12, 0)
#define TRIG1_P12 APOLLO4_PINMUX(12, 1)
#define I2S0_DATA_P12 APOLLO4_PINMUX(12, 2)
#define GPIO_P12 APOLLO4_PINMUX(12, 3)
#define UART0TX_P12 APOLLO4_PINMUX(12, 4)
#define UART1TX_P12 APOLLO4_PINMUX(12, 5)
#define CT12_P12 APOLLO4_PINMUX(12, 6)
#define NCE12_P12 APOLLO4_PINMUX(12, 7)
#define OBSBUS12_P12 APOLLO4_PINMUX(12, 8)
#define CMPRF2_P12 APOLLO4_PINMUX(12, 9)
#define I2S0_SDOUT_P12 APOLLO4_PINMUX(12, 10)
#define FPIO_P12 APOLLO4_PINMUX(12, 11)
#define SCANOUT3_P12 APOLLO4_PINMUX(12, 15)
#define ADCSE6_P13 APOLLO4_PINMUX(13, 0)
#define TRIG2_P13 APOLLO4_PINMUX(13, 1)
#define I2S0_WS_P13 APOLLO4_PINMUX(13, 2)
#define GPIO_P13 APOLLO4_PINMUX(13, 3)
#define UART2TX_P13 APOLLO4_PINMUX(13, 4)
#define UART3TX_P13 APOLLO4_PINMUX(13, 5)
#define CT13_P13 APOLLO4_PINMUX(13, 6)
#define NCE13_P13 APOLLO4_PINMUX(13, 7)
#define OBSBUS13_P13 APOLLO4_PINMUX(13, 8)
#define FPIO_P13 APOLLO4_PINMUX(13, 11)
#define FLB_FCLK_P13 APOLLO4_PINMUX(13, 12)
#define FLLOAD_DATA_P13 APOLLO4_PINMUX(13, 13)
#define MDA_TDI_P13 APOLLO4_PINMUX(13, 14)
#define SCANOUT0_P13 APOLLO4_PINMUX(13, 15)
#define ADCSE5_P14 APOLLO4_PINMUX(14, 0)
#define TRIG3_P14 APOLLO4_PINMUX(14, 1)
#define GPIO_P14 APOLLO4_PINMUX(14, 3)
#define MILLI_CLK_P14 APOLLO4_PINMUX(14, 4)
#define UART1RX_P14 APOLLO4_PINMUX(14, 5)
#define CT14_P14 APOLLO4_PINMUX(14, 6)
#define NCE14_P14 APOLLO4_PINMUX(14, 7)
#define OBSBUS14_P14 APOLLO4_PINMUX(14, 8)
#define I2S0_SDIN_P14 APOLLO4_PINMUX(14, 10)
#define FPIO_P14 APOLLO4_PINMUX(14, 11)
#define FLLOAD_ADDR_P14 APOLLO4_PINMUX(14, 13)
#define MDA_TRSTN_P14 APOLLO4_PINMUX(14, 14)
#define SCANOUT2_P14 APOLLO4_PINMUX(14, 15)
#define ADCSE4_P15 APOLLO4_PINMUX(15, 0)
#define TRIG0_P15 APOLLO4_PINMUX(15, 1)
#define GPIO_P15 APOLLO4_PINMUX(15, 3)
#define MILLI_REC_DAT_P15 APOLLO4_PINMUX(15, 4)
#define UART3RX_P15 APOLLO4_PINMUX(15, 5)
#define CT15_P15 APOLLO4_PINMUX(15, 6)
#define NCE15_P15 APOLLO4_PINMUX(15, 7)
#define OBSBUS15_P15 APOLLO4_PINMUX(15, 8)
#define REFCLK_EXT_P15 APOLLO4_PINMUX(15, 10)
#define FPIO_P15 APOLLO4_PINMUX(15, 11)
#define FLLOAD_DATA_P15 APOLLO4_PINMUX(15, 13)
#define SCANOUT1_P15 APOLLO4_PINMUX(15, 15)
#define ADCSE3_P16 APOLLO4_PINMUX(16, 0)
#define TRIG1_P16 APOLLO4_PINMUX(16, 1)
#define I2S1_CLK_P16 APOLLO4_PINMUX(16, 2)
#define GPIO_P16 APOLLO4_PINMUX(16, 3)
#define MILLI_PBDATA1_P16 APOLLO4_PINMUX(16, 4)
#define UART1RTS_P16 APOLLO4_PINMUX(16, 5)
#define CT16_P16 APOLLO4_PINMUX(16, 6)
#define NCE16_P16 APOLLO4_PINMUX(16, 7)
#define OBSBUS0_P16 APOLLO4_PINMUX(16, 8)
#define FPIO_P16 APOLLO4_PINMUX(16, 11)
#define DFT_RET_P16 APOLLO4_PINMUX(16, 15)
#define ADCSE2_P17 APOLLO4_PINMUX(17, 0)
#define TRIG2_P17 APOLLO4_PINMUX(17, 1)
#define I2S1_DATA_P17 APOLLO4_PINMUX(17, 2)
#define GPIO_P17 APOLLO4_PINMUX(17, 3)
#define MILLI_PBDATA2_P17 APOLLO4_PINMUX(17, 4)
#define UART3RTS_P17 APOLLO4_PINMUX(17, 5)
#define CT17_P17 APOLLO4_PINMUX(17, 6)
#define NCE17_P17 APOLLO4_PINMUX(17, 7)
#define OBSBUS1_P17 APOLLO4_PINMUX(17, 8)
#define I2S1_SDOUT_P17 APOLLO4_PINMUX(17, 9)
#define FPIO_P17 APOLLO4_PINMUX(17, 11)
#define FLLOAD_STRB_P17 APOLLO4_PINMUX(17, 13)
#define MDA_TMS_P17 APOLLO4_PINMUX(17, 14)
#define OPCG_CLK_P17 APOLLO4_PINMUX(17, 15)
#define ADCSE1_P18 APOLLO4_PINMUX(18, 0)
#define ANATEST2_P18 APOLLO4_PINMUX(18, 1)
#define I2S1_WS_P18 APOLLO4_PINMUX(18, 2)
#define GPIO_P18 APOLLO4_PINMUX(18, 3)
#define UART0CTS_P18 APOLLO4_PINMUX(18, 4)
#define UART1CTS_P18 APOLLO4_PINMUX(18, 5)
#define CT18_P18 APOLLO4_PINMUX(18, 6)
#define NCE18_P18 APOLLO4_PINMUX(18, 7)
#define OBSBUS2_P18 APOLLO4_PINMUX(18, 8)
#define FPIO_P18 APOLLO4_PINMUX(18, 11)
#define FLB_TMS_P18 APOLLO4_PINMUX(18, 12)
#define FLLOAD_DATA_P18 APOLLO4_PINMUX(18, 13)
#define MDA_HFRC_EXT_P18 APOLLO4_PINMUX(18, 14)
#define SCANIN1_P18 APOLLO4_PINMUX(18, 15)
#define ADCSE0_P19 APOLLO4_PINMUX(19, 0)
#define ANATEST1_P19 APOLLO4_PINMUX(19, 1)
#define GPIO_P19 APOLLO4_PINMUX(19, 3)
#define UART2CTS_P19 APOLLO4_PINMUX(19, 4)
#define UART3CTS_P19 APOLLO4_PINMUX(19, 5)
#define CT19_P19 APOLLO4_PINMUX(19, 6)
#define NCE19_P19 APOLLO4_PINMUX(19, 7)
#define OBSBUS3_P19 APOLLO4_PINMUX(19, 8)
#define I2S1_SDIN_P19 APOLLO4_PINMUX(19, 9)
#define FPIO_P19 APOLLO4_PINMUX(19, 11)
#define FLB_TRSTN_P19 APOLLO4_PINMUX(19, 12)
#define FLLOAD_ADDR_P19 APOLLO4_PINMUX(19, 13)
#define SCANIN2_P19 APOLLO4_PINMUX(19, 15)
#define SWDCK_P20 APOLLO4_PINMUX(20, 0)
#define TRIG1_P20 APOLLO4_PINMUX(20, 1)
#define GPIO_P20 APOLLO4_PINMUX(20, 3)
#define UART0TX_P20 APOLLO4_PINMUX(20, 4)
#define UART1TX_P20 APOLLO4_PINMUX(20, 5)
#define CT20_P20 APOLLO4_PINMUX(20, 6)
#define NCE20_P20 APOLLO4_PINMUX(20, 7)
#define OBSBUS4_P20 APOLLO4_PINMUX(20, 8)
#define FPIO_P20 APOLLO4_PINMUX(20, 11)
#define SCANCLK_P20 APOLLO4_PINMUX(20, 15)
#define SWDIO_P21 APOLLO4_PINMUX(21, 0)
#define TRIG2_P21 APOLLO4_PINMUX(21, 1)
#define GPIO_P21 APOLLO4_PINMUX(21, 3)
#define UART2TX_P21 APOLLO4_PINMUX(21, 4)
#define UART3TX_P21 APOLLO4_PINMUX(21, 5)
#define CT21_P21 APOLLO4_PINMUX(21, 6)
#define NCE21_P21 APOLLO4_PINMUX(21, 7)
#define OBSBUS5_P21 APOLLO4_PINMUX(21, 8)
#define FPIO_P21 APOLLO4_PINMUX(21, 11)
#define SCANSHFT_P21 APOLLO4_PINMUX(21, 15)
#define M7SCL_P22 APOLLO4_PINMUX(22, 0)
#define M7SCK_P22 APOLLO4_PINMUX(22, 1)
#define SWO_P22 APOLLO4_PINMUX(22, 2)
#define GPIO_P22 APOLLO4_PINMUX(22, 3)
#define UART0RX_P22 APOLLO4_PINMUX(22, 4)
#define UART1RX_P22 APOLLO4_PINMUX(22, 5)
#define CT22_P22 APOLLO4_PINMUX(22, 6)
#define NCE22_P22 APOLLO4_PINMUX(22, 7)
#define OBSBUS6_P22 APOLLO4_PINMUX(22, 8)
#define VCMPO_P22 APOLLO4_PINMUX(22, 9)
#define I3CM1_SCL_P22 APOLLO4_PINMUX(22, 10)
#define FPIO_P22 APOLLO4_PINMUX(22, 11)
#define SCANIN3_P22 APOLLO4_PINMUX(22, 15)
#define M7SDAWIR3_P23 APOLLO4_PINMUX(23, 0)
#define M7MOSI_P23 APOLLO4_PINMUX(23, 1)
#define SWO_P23 APOLLO4_PINMUX(23, 2)
#define GPIO_P23 APOLLO4_PINMUX(23, 3)
#define UART2RX_P23 APOLLO4_PINMUX(23, 4)
#define UART3RX_P23 APOLLO4_PINMUX(23, 5)
#define CT23_P23 APOLLO4_PINMUX(23, 6)
#define NCE23_P23 APOLLO4_PINMUX(23, 7)
#define OBSBUS7_P23 APOLLO4_PINMUX(23, 8)
#define VCMPO_P23 APOLLO4_PINMUX(23, 9)
#define I3CM1_SDA_P23 APOLLO4_PINMUX(23, 10)
#define FPIO_P23 APOLLO4_PINMUX(23, 11)
#define SCANOUT6_P23 APOLLO4_PINMUX(23, 15)
#define M7MISO_P24 APOLLO4_PINMUX(24, 0)
#define TRIG3_P24 APOLLO4_PINMUX(24, 1)
#define SWO_P24 APOLLO4_PINMUX(24, 2)
#define GPIO_P24 APOLLO4_PINMUX(24, 3)
#define UART0RTS_P24 APOLLO4_PINMUX(24, 4)
#define UART1RTS_P24 APOLLO4_PINMUX(24, 5)
#define CT24_P24 APOLLO4_PINMUX(24, 6)
#define NCE24_P24 APOLLO4_PINMUX(24, 7)
#define OBSBUS8_P24 APOLLO4_PINMUX(24, 8)
#define FPIO_P24 APOLLO4_PINMUX(24, 11)
#define SCANOUT7_P24 APOLLO4_PINMUX(24, 15)
#define M2SCL_P25 APOLLO4_PINMUX(25, 0)
#define M2SCK_P25 APOLLO4_PINMUX(25, 1)
#define GPIO_P25 APOLLO4_PINMUX(25, 3)
#define LFRC_EXT_P25 APOLLO4_PINMUX(25, 4)
#define DSP_TMS_P25 APOLLO4_PINMUX(25, 5)
#define CT25_P25 APOLLO4_PINMUX(25, 6)
#define NCE25_P25 APOLLO4_PINMUX(25, 7)
#define OBSBUS9_P25 APOLLO4_PINMUX(25, 8)
#define FPIO_P25 APOLLO4_PINMUX(25, 11)
#define SCANIN8_P25 APOLLO4_PINMUX(25, 15)
#define M2SDAWIR3_P26 APOLLO4_PINMUX(26, 0)
#define M2MOSI_P26 APOLLO4_PINMUX(26, 1)
#define GPIO_P26 APOLLO4_PINMUX(26, 3)
#define HFRC_EXT_P26 APOLLO4_PINMUX(26, 4)
#define CT26_P26 APOLLO4_PINMUX(26, 6)
#define NCE26_P26 APOLLO4_PINMUX(26, 7)
#define OBSBUS10_P26 APOLLO4_PINMUX(26, 8)
#define VCMPO_P26 APOLLO4_PINMUX(26, 9)
#define FPIO_P26 APOLLO4_PINMUX(26, 11)
#define SCANIN9_P26 APOLLO4_PINMUX(26, 15)
#define M2MISO_P27 APOLLO4_PINMUX(27, 0)
#define TRIG0_P27 APOLLO4_PINMUX(27, 1)
#define GPIO_P27 APOLLO4_PINMUX(27, 3)
#define XT_EXT_P27 APOLLO4_PINMUX(27, 4)
#define DSP_TCK_P27 APOLLO4_PINMUX(27, 5)
#define CT27_P27 APOLLO4_PINMUX(27, 6)
#define NCE27_P27 APOLLO4_PINMUX(27, 7)
#define OBSBUS11_P27 APOLLO4_PINMUX(27, 8)
#define I2S0_SDIN_P27 APOLLO4_PINMUX(27, 9)
#define FPIO_P27 APOLLO4_PINMUX(27, 11)
#define SCANIN10_P27 APOLLO4_PINMUX(27, 15)
#define SWO_P28 APOLLO4_PINMUX(28, 0)
#define VCMPO_P28 APOLLO4_PINMUX(28, 1)
#define I2S0_CLK_P28 APOLLO4_PINMUX(28, 2)
#define GPIO_P28 APOLLO4_PINMUX(28, 3)
#define UART2CTS_P28 APOLLO4_PINMUX(28, 4)
#define DSP_TDO_P28 APOLLO4_PINMUX(28, 5)
#define CT28_P28 APOLLO4_PINMUX(28, 6)
#define NCE28_P28 APOLLO4_PINMUX(28, 7)
#define OBSBUS12_P28 APOLLO4_PINMUX(28, 8)
#define FPIO_P28 APOLLO4_PINMUX(28, 11)
#define CME_P28 APOLLO4_PINMUX(28, 15)
#define TRIG0_P29 APOLLO4_PINMUX(29, 0)
#define VCMPO_P29 APOLLO4_PINMUX(29, 1)
#define I2S0_DATA_P29 APOLLO4_PINMUX(29, 2)
#define GPIO_P29 APOLLO4_PINMUX(29, 3)
#define UART1CTS_P29 APOLLO4_PINMUX(29, 4)
#define DSP_TRSTN_P29 APOLLO4_PINMUX(29, 5)
#define CT29_P29 APOLLO4_PINMUX(29, 6)
#define NCE29_P29 APOLLO4_PINMUX(29, 7)
#define OBSBUS13_P29 APOLLO4_PINMUX(29, 8)
#define I2S0_SDOUT_P29 APOLLO4_PINMUX(29, 9)
#define FPIO_P29 APOLLO4_PINMUX(29, 11)
#define CMLE_P29 APOLLO4_PINMUX(29, 15)
#define TRIG1_P30 APOLLO4_PINMUX(30, 0)
#define VCMPO_P30 APOLLO4_PINMUX(30, 1)
#define I2S0_WS_P30 APOLLO4_PINMUX(30, 2)
#define GPIO_P30 APOLLO4_PINMUX(30, 3)
#define UART0TX_P30 APOLLO4_PINMUX(30, 4)
#define DSP_TDI_P30 APOLLO4_PINMUX(30, 5)
#define CT30_P30 APOLLO4_PINMUX(30, 6)
#define NCE30_P30 APOLLO4_PINMUX(30, 7)
#define OBSBUS14_P30 APOLLO4_PINMUX(30, 8)
#define FPIO_P30 APOLLO4_PINMUX(30, 11)
#define SCANOUT8_P30 APOLLO4_PINMUX(30, 15)
#define M3SCL_P31 APOLLO4_PINMUX(31, 0)
#define M3SCK_P31 APOLLO4_PINMUX(31, 1)
#define GPIO_P31 APOLLO4_PINMUX(31, 3)
#define UART2TX_P31 APOLLO4_PINMUX(31, 4)
#define CT31_P31 APOLLO4_PINMUX(31, 6)
#define NCE31_P31 APOLLO4_PINMUX(31, 7)
#define OBSBUS15_P31 APOLLO4_PINMUX(31, 8)
#define VCMPO_P31 APOLLO4_PINMUX(31, 9)
#define FPIO_P31 APOLLO4_PINMUX(31, 11)
#define SCANOUT9_P31 APOLLO4_PINMUX(31, 15)
#define M3SDAWIR3_P32 APOLLO4_PINMUX(32, 0)
#define M3MOSI_P32 APOLLO4_PINMUX(32, 1)
#define GPIO_P32 APOLLO4_PINMUX(32, 3)
#define UART0RX_P32 APOLLO4_PINMUX(32, 4)
#define CT32_P32 APOLLO4_PINMUX(32, 6)
#define NCE32_P32 APOLLO4_PINMUX(32, 7)
#define OBSBUS0_P32 APOLLO4_PINMUX(32, 8)
#define FPIO_P32 APOLLO4_PINMUX(32, 11)
#define SCANOUT10_P32 APOLLO4_PINMUX(32, 15)
#define M3MISO_P33 APOLLO4_PINMUX(33, 0)
#define CLKOUT_P33 APOLLO4_PINMUX(33, 1)
#define GPIO_P33 APOLLO4_PINMUX(33, 3)
#define UART2RX_P33 APOLLO4_PINMUX(33, 4)
#define CT33_P33 APOLLO4_PINMUX(33, 6)
#define NCE33_P33 APOLLO4_PINMUX(33, 7)
#define OBSBUS1_P33 APOLLO4_PINMUX(33, 8)
#define DISP_TE_P33 APOLLO4_PINMUX(33, 9)
#define FPIO_P33 APOLLO4_PINMUX(33, 11)
#define SCANOUT11_P33 APOLLO4_PINMUX(33, 15)
#define M4SCL_P34 APOLLO4_PINMUX(34, 0)
#define M4SCK_P34 APOLLO4_PINMUX(34, 1)
#define SWO_P34 APOLLO4_PINMUX(34, 2)
#define GPIO_P34 APOLLO4_PINMUX(34, 3)
#define UART0TX_P34 APOLLO4_PINMUX(34, 4)
#define CT34_P34 APOLLO4_PINMUX(34, 6)
#define NCE34_P34 APOLLO4_PINMUX(34, 7)
#define OBSBUS2_P34 APOLLO4_PINMUX(34, 8)
#define VCMPO_P34 APOLLO4_PINMUX(34, 9)
#define FPIO_P34 APOLLO4_PINMUX(34, 11)
#define M4SDAWIR3_P35 APOLLO4_PINMUX(35, 0)
#define M4MOSI_P35 APOLLO4_PINMUX(35, 1)
#define SWO_P35 APOLLO4_PINMUX(35, 2)
#define GPIO_P35 APOLLO4_PINMUX(35, 3)
#define UART2TX_P35 APOLLO4_PINMUX(35, 4)
#define UART3TX_P35 APOLLO4_PINMUX(35, 5)
#define CT35_P35 APOLLO4_PINMUX(35, 6)
#define NCE35_P35 APOLLO4_PINMUX(35, 7)
#define OBSBUS3_P35 APOLLO4_PINMUX(35, 8)
#define VCMPO_P35 APOLLO4_PINMUX(35, 9)
#define FPIO_P35 APOLLO4_PINMUX(35, 11)
#define M4MISO_P36 APOLLO4_PINMUX(36, 0)
#define TRIG0_P36 APOLLO4_PINMUX(36, 1)
#define SWO_P36 APOLLO4_PINMUX(36, 2)
#define GPIO_P36 APOLLO4_PINMUX(36, 3)
#define UART0RX_P36 APOLLO4_PINMUX(36, 4)
#define UART1RX_P36 APOLLO4_PINMUX(36, 5)
#define CT36_P36 APOLLO4_PINMUX(36, 6)
#define NCE36_P36 APOLLO4_PINMUX(36, 7)
#define OBSBUS4_P36 APOLLO4_PINMUX(36, 8)
#define FPIO_P36 APOLLO4_PINMUX(36, 11)
#define MSPI1_0_P37 APOLLO4_PINMUX(37, 0)
#define TRIG1_P37 APOLLO4_PINMUX(37, 1)
#define XT32KHZ_P37 APOLLO4_PINMUX(37, 2)
#define GPIO_P37 APOLLO4_PINMUX(37, 3)
#define UART2RX_P37 APOLLO4_PINMUX(37, 4)
#define DISP_D15_P37 APOLLO4_PINMUX(37, 5)
#define CT37_P37 APOLLO4_PINMUX(37, 6)
#define NCE37_P37 APOLLO4_PINMUX(37, 7)
#define OBSBUS5_P37 APOLLO4_PINMUX(37, 8)
#define FPIO_P37 APOLLO4_PINMUX(37, 11)
#define MSPI1_1_P38 APOLLO4_PINMUX(38, 0)
#define TRIG2_P38 APOLLO4_PINMUX(38, 1)
#define SWTRACECLK_P38 APOLLO4_PINMUX(38, 2)
#define GPIO_P38 APOLLO4_PINMUX(38, 3)
#define UART0RTS_P38 APOLLO4_PINMUX(38, 4)
#define DISP_D16_P38 APOLLO4_PINMUX(38, 5)
#define CT38_P38 APOLLO4_PINMUX(38, 6)
#define NCE38_P38 APOLLO4_PINMUX(38, 7)
#define OBSBUS6_P38 APOLLO4_PINMUX(38, 8)
#define FPIO_P38 APOLLO4_PINMUX(38, 11)
#define MSPI1_2_P39 APOLLO4_PINMUX(39, 0)
#define TRIG3_P39 APOLLO4_PINMUX(39, 1)
#define SWTRACE0_P39 APOLLO4_PINMUX(39, 2)
#define GPIO_P39 APOLLO4_PINMUX(39, 3)
#define UART2RTS_P39 APOLLO4_PINMUX(39, 4)
#define DISP_D17_P39 APOLLO4_PINMUX(39, 5)
#define CT39_P39 APOLLO4_PINMUX(39, 6)
#define NCE39_P39 APOLLO4_PINMUX(39, 7)
#define OBSBUS7_P39 APOLLO4_PINMUX(39, 8)
#define FPIO_P39 APOLLO4_PINMUX(39, 11)
#define MSPI1_3_P40 APOLLO4_PINMUX(40, 0)
#define TRIG1_P40 APOLLO4_PINMUX(40, 1)
#define SWTRACE1_P40 APOLLO4_PINMUX(40, 2)
#define GPIO_P40 APOLLO4_PINMUX(40, 3)
#define UART0CTS_P40 APOLLO4_PINMUX(40, 4)
#define DISP_D18_P40 APOLLO4_PINMUX(40, 5)
#define CT40_P40 APOLLO4_PINMUX(40, 6)
#define NCE40_P40 APOLLO4_PINMUX(40, 7)
#define OBSBUS8_P40 APOLLO4_PINMUX(40, 8)
#define FPIO_P40 APOLLO4_PINMUX(40, 11)
#define MSPI1_4_P41 APOLLO4_PINMUX(41, 0)
#define TRIG0_P41 APOLLO4_PINMUX(41, 1)
#define SWTRACE2_P41 APOLLO4_PINMUX(41, 2)
#define GPIO_P41 APOLLO4_PINMUX(41, 3)
#define UART0TX_P41 APOLLO4_PINMUX(41, 4)
#define DISP_D19_P41 APOLLO4_PINMUX(41, 5)
#define CT41_P41 APOLLO4_PINMUX(41, 6)
#define NCE41_P41 APOLLO4_PINMUX(41, 7)
#define OBSBUS9_P41 APOLLO4_PINMUX(41, 8)
#define SWO_P41 APOLLO4_PINMUX(41, 9)
#define FPIO_P41 APOLLO4_PINMUX(41, 11)
#define MSPI1_5_P42 APOLLO4_PINMUX(42, 0)
#define TRIG2_P42 APOLLO4_PINMUX(42, 1)
#define SWTRACE3_P42 APOLLO4_PINMUX(42, 2)
#define GPIO_P42 APOLLO4_PINMUX(42, 3)
#define UART2TX_P42 APOLLO4_PINMUX(42, 4)
#define DISP_D20_P42 APOLLO4_PINMUX(42, 5)
#define CT42_P42 APOLLO4_PINMUX(42, 6)
#define NCE42_P42 APOLLO4_PINMUX(42, 7)
#define OBSBUS10_P42 APOLLO4_PINMUX(42, 8)
#define FPIO_P42 APOLLO4_PINMUX(42, 11)
#define MSPI1_6_P43 APOLLO4_PINMUX(43, 0)
#define TRIG3_P43 APOLLO4_PINMUX(43, 1)
#define SWTRACECTL_P43 APOLLO4_PINMUX(43, 2)
#define GPIO_P43 APOLLO4_PINMUX(43, 3)
#define UART0RX_P43 APOLLO4_PINMUX(43, 4)
#define DISP_D21_P43 APOLLO4_PINMUX(43, 5)
#define CT43_P43 APOLLO4_PINMUX(43, 6)
#define NCE43_P43 APOLLO4_PINMUX(43, 7)
#define OBSBUS11_P43 APOLLO4_PINMUX(43, 8)
#define FPIO_P43 APOLLO4_PINMUX(43, 11)
#define MSPI1_7_P44 APOLLO4_PINMUX(44, 0)
#define TRIG1_P44 APOLLO4_PINMUX(44, 1)
#define SWO_P44 APOLLO4_PINMUX(44, 2)
#define GPIO_P44 APOLLO4_PINMUX(44, 3)
#define UART2RX_P44 APOLLO4_PINMUX(44, 4)
#define DISP_D22_P44 APOLLO4_PINMUX(44, 5)
#define CT44_P44 APOLLO4_PINMUX(44, 6)
#define NCE44_P44 APOLLO4_PINMUX(44, 7)
#define OBSBUS12_P44 APOLLO4_PINMUX(44, 8)
#define VCMPO_P44 APOLLO4_PINMUX(44, 9)
#define FPIO_P44 APOLLO4_PINMUX(44, 11)
#define MSPI1_8_P45 APOLLO4_PINMUX(45, 0)
#define TRIG2_P45 APOLLO4_PINMUX(45, 1)
#define XT32KHZ_P45 APOLLO4_PINMUX(45, 2)
#define GPIO_P45 APOLLO4_PINMUX(45, 3)
#define UART0TX_P45 APOLLO4_PINMUX(45, 4)
#define DISP_D23_P45 APOLLO4_PINMUX(45, 5)
#define CT45_P45 APOLLO4_PINMUX(45, 6)
#define NCE45_P45 APOLLO4_PINMUX(45, 7)
#define OBSBUS13_P45 APOLLO4_PINMUX(45, 8)
#define FPIO_P45 APOLLO4_PINMUX(45, 11)
#define MSPI1_9_P46 APOLLO4_PINMUX(46, 0)
#define TRIG3_P46 APOLLO4_PINMUX(46, 1)
#define CLKOUT_32M_P46 APOLLO4_PINMUX(46, 2)
#define GPIO_P46 APOLLO4_PINMUX(46, 3)
#define UART2TX_P46 APOLLO4_PINMUX(46, 4)
#define UART3TX_P46 APOLLO4_PINMUX(46, 5)
#define CT46_P46 APOLLO4_PINMUX(46, 6)
#define NCE46_P46 APOLLO4_PINMUX(46, 7)
#define OBSBUS14_P46 APOLLO4_PINMUX(46, 8)
#define I2S1_SDIN_P46 APOLLO4_PINMUX(46, 9)
#define I2S0_SDIN_P46 APOLLO4_PINMUX(46, 10)
#define FPIO_P46 APOLLO4_PINMUX(46, 11)
#define M5SCL_P47 APOLLO4_PINMUX(47, 0)
#define M5SCK_P47 APOLLO4_PINMUX(47, 1)
#define I2S1_CLK_P47 APOLLO4_PINMUX(47, 2)
#define GPIO_P47 APOLLO4_PINMUX(47, 3)
#define UART0RX_P47 APOLLO4_PINMUX(47, 4)
#define UART1RX_P47 APOLLO4_PINMUX(47, 5)
#define CT47_P47 APOLLO4_PINMUX(47, 6)
#define NCE47_P47 APOLLO4_PINMUX(47, 7)
#define OBSBUS15_P47 APOLLO4_PINMUX(47, 8)
#define I2S0_CLK_P47 APOLLO4_PINMUX(47, 10)
#define FPIO_P47 APOLLO4_PINMUX(47, 11)
#define M5SDAWIR3_P48 APOLLO4_PINMUX(48, 0)
#define M5MOSI_P48 APOLLO4_PINMUX(48, 1)
#define I2S1_DATA_P48 APOLLO4_PINMUX(48, 2)
#define GPIO_P48 APOLLO4_PINMUX(48, 3)
#define UART2RX_P48 APOLLO4_PINMUX(48, 4)
#define UART3RX_P48 APOLLO4_PINMUX(48, 5)
#define CT48_P48 APOLLO4_PINMUX(48, 6)
#define NCE48_P48 APOLLO4_PINMUX(48, 7)
#define OBSBUS0_P48 APOLLO4_PINMUX(48, 8)
#define I2S1_SDOUT_P48 APOLLO4_PINMUX(48, 9)
#define I2S0_SDOUT_P48 APOLLO4_PINMUX(48, 10)
#define FPIO_P48 APOLLO4_PINMUX(48, 11)
#define M5MISO_P49 APOLLO4_PINMUX(49, 0)
#define TRIG0_P49 APOLLO4_PINMUX(49, 1)
#define I2S1_WS_P49 APOLLO4_PINMUX(49, 2)
#define GPIO_P49 APOLLO4_PINMUX(49, 3)
#define UART0RTS_P49 APOLLO4_PINMUX(49, 4)
#define UART1RTS_P49 APOLLO4_PINMUX(49, 5)
#define CT49_P49 APOLLO4_PINMUX(49, 6)
#define NCE49_P49 APOLLO4_PINMUX(49, 7)
#define OBSBUS1_P49 APOLLO4_PINMUX(49, 8)
#define I2S0_WS_P49 APOLLO4_PINMUX(49, 10)
#define FPIO_P49 APOLLO4_PINMUX(49, 11)
#define PDM0_CLK_P50 APOLLO4_PINMUX(50, 0)
#define TRIG0_P50 APOLLO4_PINMUX(50, 1)
#define SWTRACECLK_P50 APOLLO4_PINMUX(50, 2)
#define GPIO_P50 APOLLO4_PINMUX(50, 3)
#define UART2RTS_P50 APOLLO4_PINMUX(50, 4)
#define UART3RTS_P50 APOLLO4_PINMUX(50, 5)
#define CT50_P50 APOLLO4_PINMUX(50, 6)
#define NCE50_P50 APOLLO4_PINMUX(50, 7)
#define OBSBUS2_P50 APOLLO4_PINMUX(50, 8)
#define DISP_TE_P50 APOLLO4_PINMUX(50, 9)
#define FPIO_P50 APOLLO4_PINMUX(50, 11)
#define PDM0_DATA_P51 APOLLO4_PINMUX(51, 0)
#define TRIG1_P51 APOLLO4_PINMUX(51, 1)
#define SWTRACE0_P51 APOLLO4_PINMUX(51, 2)
#define GPIO_P51 APOLLO4_PINMUX(51, 3)
#define UART0CTS_P51 APOLLO4_PINMUX(51, 4)
#define UART1CTS_P51 APOLLO4_PINMUX(51, 5)
#define CT51_P51 APOLLO4_PINMUX(51, 6)
#define NCE51_P51 APOLLO4_PINMUX(51, 7)
#define OBSBUS3_P51 APOLLO4_PINMUX(51, 8)
#define FPIO_P51 APOLLO4_PINMUX(51, 11)
#define PDM1_CLK_P52 APOLLO4_PINMUX(52, 0)
#define TRIG2_P52 APOLLO4_PINMUX(52, 1)
#define SWTRACE1_P52 APOLLO4_PINMUX(52, 2)
#define GPIO_P52 APOLLO4_PINMUX(52, 3)
#define UART2CTS_P52 APOLLO4_PINMUX(52, 4)
#define UART3CTS_P52 APOLLO4_PINMUX(52, 5)
#define CT52_P52 APOLLO4_PINMUX(52, 6)
#define NCE52_P52 APOLLO4_PINMUX(52, 7)
#define OBSBUS4_P52 APOLLO4_PINMUX(52, 8)
#define VCMPO_P52 APOLLO4_PINMUX(52, 9)
#define FPIO_P52 APOLLO4_PINMUX(52, 11)
#define PDM1_DATA_P53 APOLLO4_PINMUX(53, 0)
#define TRIG3_P53 APOLLO4_PINMUX(53, 1)
#define SWTRACE2_P53 APOLLO4_PINMUX(53, 2)
#define GPIO_P53 APOLLO4_PINMUX(53, 3)
#define UART0TX_P53 APOLLO4_PINMUX(53, 4)
#define UART1TX_P53 APOLLO4_PINMUX(53, 5)
#define CT53_P53 APOLLO4_PINMUX(53, 6)
#define NCE53_P53 APOLLO4_PINMUX(53, 7)
#define OBSBUS5_P53 APOLLO4_PINMUX(53, 8)
#define FPIO_P53 APOLLO4_PINMUX(53, 11)
#define PDM2_CLK_P54 APOLLO4_PINMUX(54, 0)
#define TRIG0_P54 APOLLO4_PINMUX(54, 1)
#define SWTRACE3_P54 APOLLO4_PINMUX(54, 2)
#define GPIO_P54 APOLLO4_PINMUX(54, 3)
#define UART2TX_P54 APOLLO4_PINMUX(54, 4)
#define UART3TX_P54 APOLLO4_PINMUX(54, 5)
#define CT54_P54 APOLLO4_PINMUX(54, 6)
#define NCE54_P54 APOLLO4_PINMUX(54, 7)
#define OBSBUS6_P54 APOLLO4_PINMUX(54, 8)
#define FPIO_P54 APOLLO4_PINMUX(54, 11)
#define PDM2_DATA_P55 APOLLO4_PINMUX(55, 0)
#define TRIG1_P55 APOLLO4_PINMUX(55, 1)
#define SWTRACECTL_P55 APOLLO4_PINMUX(55, 2)
#define GPIO_P55 APOLLO4_PINMUX(55, 3)
#define UART0RX_P55 APOLLO4_PINMUX(55, 4)
#define UART1RX_P55 APOLLO4_PINMUX(55, 5)
#define CT55_P55 APOLLO4_PINMUX(55, 6)
#define NCE55_P55 APOLLO4_PINMUX(55, 7)
#define OBSBUS7_P55 APOLLO4_PINMUX(55, 8)
#define FPIO_P55 APOLLO4_PINMUX(55, 11)
#define PDM3_CLK_P56 APOLLO4_PINMUX(56, 0)
#define TRIG2_P56 APOLLO4_PINMUX(56, 1)
#define SWO_P56 APOLLO4_PINMUX(56, 2)
#define GPIO_P56 APOLLO4_PINMUX(56, 3)
#define UART2RX_P56 APOLLO4_PINMUX(56, 4)
#define UART3RX_P56 APOLLO4_PINMUX(56, 5)
#define CT56_P56 APOLLO4_PINMUX(56, 6)
#define NCE56_P56 APOLLO4_PINMUX(56, 7)
#define OBSBUS8_P56 APOLLO4_PINMUX(56, 8)
#define FPIO_P56 APOLLO4_PINMUX(56, 11)
#define PDM3_DATA_P57 APOLLO4_PINMUX(57, 0)
#define TRIG3_P57 APOLLO4_PINMUX(57, 1)
#define SWO_P57 APOLLO4_PINMUX(57, 2)
#define GPIO_P57 APOLLO4_PINMUX(57, 3)
#define UART0RTS_P57 APOLLO4_PINMUX(57, 4)
#define UART1RTS_P57 APOLLO4_PINMUX(57, 5)
#define CT57_P57 APOLLO4_PINMUX(57, 6)
#define NCE57_P57 APOLLO4_PINMUX(57, 7)
#define OBSBUS9_P57 APOLLO4_PINMUX(57, 8)
#define VCMPO_P57 APOLLO4_PINMUX(57, 9)
#define FPIO_P57 APOLLO4_PINMUX(57, 11)
#define GPIO_P58 APOLLO4_PINMUX(58, 3)
#define UART0RTS_P58 APOLLO4_PINMUX(58, 4)
#define UART3RTS_P58 APOLLO4_PINMUX(58, 5)
#define CT58_P58 APOLLO4_PINMUX(58, 6)
#define NCE58_P58 APOLLO4_PINMUX(58, 7)
#define OBSBUS10_P58 APOLLO4_PINMUX(58, 8)
#define FPIO_P58 APOLLO4_PINMUX(58, 11)
#define TRIG0_P59 APOLLO4_PINMUX(59, 1)
#define GPIO_P59 APOLLO4_PINMUX(59, 3)
#define UART0CTS_P59 APOLLO4_PINMUX(59, 4)
#define UART1CTS_P59 APOLLO4_PINMUX(59, 5)
#define CT59_P59 APOLLO4_PINMUX(59, 6)
#define NCE59_P59 APOLLO4_PINMUX(59, 7)
#define OBSBUS11_P59 APOLLO4_PINMUX(59, 8)
#define FPIO_P59 APOLLO4_PINMUX(59, 11)
#define TRIG1_P60 APOLLO4_PINMUX(60, 1)
#define GPIO_P60 APOLLO4_PINMUX(60, 3)
#define UART0TX_P60 APOLLO4_PINMUX(60, 4)
#define UART3CTS_P60 APOLLO4_PINMUX(60, 5)
#define CT60_P60 APOLLO4_PINMUX(60, 6)
#define NCE60_P60 APOLLO4_PINMUX(60, 7)
#define OBSBUS12_P60 APOLLO4_PINMUX(60, 8)
#define FPIO_P60 APOLLO4_PINMUX(60, 11)
#define M6SCL_P61 APOLLO4_PINMUX(61, 0)
#define M6SCK_P61 APOLLO4_PINMUX(61, 1)
#define I2S1_CLK_P61 APOLLO4_PINMUX(61, 2)
#define GPIO_P61 APOLLO4_PINMUX(61, 3)
#define UART2TX_P61 APOLLO4_PINMUX(61, 4)
#define UART3TX_P61 APOLLO4_PINMUX(61, 5)
#define CT61_P61 APOLLO4_PINMUX(61, 6)
#define NCE61_P61 APOLLO4_PINMUX(61, 7)
#define OBSBUS13_P61 APOLLO4_PINMUX(61, 8)
#define I3CM0_SCL_P61 APOLLO4_PINMUX(61, 10)
#define FPIO_P61 APOLLO4_PINMUX(61, 11)
#define M6SDAWIR3_P62 APOLLO4_PINMUX(62, 0)
#define M6MOSI_P62 APOLLO4_PINMUX(62, 1)
#define I2S1_DATA_P62 APOLLO4_PINMUX(62, 2)
#define GPIO_P62 APOLLO4_PINMUX(62, 3)
#define UART0RX_P62 APOLLO4_PINMUX(62, 4)
#define UART1RX_P62 APOLLO4_PINMUX(62, 5)
#define CT62_P62 APOLLO4_PINMUX(62, 6)
#define NCE62_P62 APOLLO4_PINMUX(62, 7)
#define OBSBUS14_P62 APOLLO4_PINMUX(62, 8)
#define I2S1_SDOUT_P62 APOLLO4_PINMUX(62, 9)
#define I3CM0_SDA_P62 APOLLO4_PINMUX(62, 10)
#define FPIO_P62 APOLLO4_PINMUX(62, 11)
#define M6MISO_P63 APOLLO4_PINMUX(63, 0)
#define CLKOUT_P63 APOLLO4_PINMUX(63, 1)
#define I2S1_WS_P63 APOLLO4_PINMUX(63, 2)
#define GPIO_P63 APOLLO4_PINMUX(63, 3)
#define UART2RX_P63 APOLLO4_PINMUX(63, 4)
#define UART3RX_P63 APOLLO4_PINMUX(63, 5)
#define CT63_P63 APOLLO4_PINMUX(63, 6)
#define NCE63_P63 APOLLO4_PINMUX(63, 7)
#define OBSBUS15_P63 APOLLO4_PINMUX(63, 8)
#define DISP_TE_P63 APOLLO4_PINMUX(63, 9)
#define FPIO_P63 APOLLO4_PINMUX(63, 11)
#define MSPI0_0_P64 APOLLO4_PINMUX(64, 0)
#define XT32KHZ_P64 APOLLO4_PINMUX(64, 1)
#define SWO_P64 APOLLO4_PINMUX(64, 2)
#define GPIO_P64 APOLLO4_PINMUX(64, 3)
#define UART0RTS_P64 APOLLO4_PINMUX(64, 4)
#define DISP_D0_P64 APOLLO4_PINMUX(64, 5)
#define CT64_P64 APOLLO4_PINMUX(64, 6)
#define NCE64_P64 APOLLO4_PINMUX(64, 7)
#define OBSBUS0_P64 APOLLO4_PINMUX(64, 8)
#define I2S1_SDIN_P64 APOLLO4_PINMUX(64, 9)
#define FPIO_P64 APOLLO4_PINMUX(64, 11)
#define MSPI0_1_P65 APOLLO4_PINMUX(65, 0)
#define XT32KHZ_P65 APOLLO4_PINMUX(65, 1)
#define SWO_P65 APOLLO4_PINMUX(65, 2)
#define GPIO_P65 APOLLO4_PINMUX(65, 3)
#define UART0CTS_P65 APOLLO4_PINMUX(65, 4)
#define DISP_D1_P65 APOLLO4_PINMUX(65, 5)
#define CT65_P65 APOLLO4_PINMUX(65, 6)
#define NCE65_P65 APOLLO4_PINMUX(65, 7)
#define OBSBUS1_P65 APOLLO4_PINMUX(65, 8)
#define FPIO_P65 APOLLO4_PINMUX(65, 11)
#define MSPI0_2_P66 APOLLO4_PINMUX(66, 0)
#define CLKOUT_P66 APOLLO4_PINMUX(66, 1)
#define SWO_P66 APOLLO4_PINMUX(66, 2)
#define GPIO_P66 APOLLO4_PINMUX(66, 3)
#define UART0TX_P66 APOLLO4_PINMUX(66, 4)
#define DISP_D2_P66 APOLLO4_PINMUX(66, 5)
#define CT66_P66 APOLLO4_PINMUX(66, 6)
#define NCE66_P66 APOLLO4_PINMUX(66, 7)
#define OBSBUS2_P66 APOLLO4_PINMUX(66, 8)
#define FPIO_P66 APOLLO4_PINMUX(66, 11)
#define MSPI0_3_P67 APOLLO4_PINMUX(67, 0)
#define CLKOUT_P67 APOLLO4_PINMUX(67, 1)
#define SWO_P67 APOLLO4_PINMUX(67, 2)
#define GPIO_P67 APOLLO4_PINMUX(67, 3)
#define UART2TX_P67 APOLLO4_PINMUX(67, 4)
#define DISP_D3_P67 APOLLO4_PINMUX(67, 5)
#define CT67_P67 APOLLO4_PINMUX(67, 6)
#define NCE67_P67 APOLLO4_PINMUX(67, 7)
#define OBSBUS3_P67 APOLLO4_PINMUX(67, 8)
#define FPIO_P67 APOLLO4_PINMUX(67, 11)
#define MSPI0_4_P68 APOLLO4_PINMUX(68, 0)
#define SWO_P68 APOLLO4_PINMUX(68, 1)
#define GPIO_P68 APOLLO4_PINMUX(68, 3)
#define UART0RX_P68 APOLLO4_PINMUX(68, 4)
#define DISP_D4_P68 APOLLO4_PINMUX(68, 5)
#define CT68_P68 APOLLO4_PINMUX(68, 6)
#define NCE68_P68 APOLLO4_PINMUX(68, 7)
#define OBSBUS4_P68 APOLLO4_PINMUX(68, 8)
#define FPIO_P68 APOLLO4_PINMUX(68, 11)
#define MSPI0_5_P69 APOLLO4_PINMUX(69, 0)
#define XT32KHZ_P69 APOLLO4_PINMUX(69, 1)
#define SWO_P69 APOLLO4_PINMUX(69, 2)
#define GPIO_P69 APOLLO4_PINMUX(69, 3)
#define UART2RX_P69 APOLLO4_PINMUX(69, 4)
#define DISP_D5_P69 APOLLO4_PINMUX(69, 5)
#define CT69_P69 APOLLO4_PINMUX(69, 6)
#define NCE69_P69 APOLLO4_PINMUX(69, 7)
#define OBSBUS5_P69 APOLLO4_PINMUX(69, 8)
#define FPIO_P69 APOLLO4_PINMUX(69, 11)
#define MSPI0_6_P70 APOLLO4_PINMUX(70, 0)
#define XT32KHZ_P70 APOLLO4_PINMUX(70, 1)
#define SWTRACE0_P70 APOLLO4_PINMUX(70, 2)
#define GPIO_P70 APOLLO4_PINMUX(70, 3)
#define UART0RTS_P70 APOLLO4_PINMUX(70, 4)
#define DISP_D6_P70 APOLLO4_PINMUX(70, 5)
#define CT70_P70 APOLLO4_PINMUX(70, 6)
#define NCE70_P70 APOLLO4_PINMUX(70, 7)
#define OBSBUS6_P70 APOLLO4_PINMUX(70, 8)
#define FPIO_P70 APOLLO4_PINMUX(70, 11)
#define MSPI0_7_P71 APOLLO4_PINMUX(71, 0)
#define CLKOUT_P71 APOLLO4_PINMUX(71, 1)
#define SWTRACE1_P71 APOLLO4_PINMUX(71, 2)
#define GPIO_P71 APOLLO4_PINMUX(71, 3)
#define UART0CTS_P71 APOLLO4_PINMUX(71, 4)
#define DISP_D7_P71 APOLLO4_PINMUX(71, 5)
#define CT71_P71 APOLLO4_PINMUX(71, 6)
#define NCE71_P71 APOLLO4_PINMUX(71, 7)
#define OBSBUS7_P71 APOLLO4_PINMUX(71, 8)
#define FPIO_P71 APOLLO4_PINMUX(71, 11)
#define MSPI0_8_P72 APOLLO4_PINMUX(72, 0)
#define CLKOUT_P72 APOLLO4_PINMUX(72, 1)
#define SWTRACE2_P72 APOLLO4_PINMUX(72, 2)
#define GPIO_P72 APOLLO4_PINMUX(72, 3)
#define UART0TX_P72 APOLLO4_PINMUX(72, 4)
#define DISP_D8_P72 APOLLO4_PINMUX(72, 5)
#define CT72_P72 APOLLO4_PINMUX(72, 6)
#define NCE72_P72 APOLLO4_PINMUX(72, 7)
#define OBSBUS8_P72 APOLLO4_PINMUX(72, 8)
#define VCMPO_P72 APOLLO4_PINMUX(72, 9)
#define FPIO_P72 APOLLO4_PINMUX(72, 11)
#define MSPI0_9_P73 APOLLO4_PINMUX(73, 0)
#define SWTRACE3_P73 APOLLO4_PINMUX(73, 2)
#define GPIO_P73 APOLLO4_PINMUX(73, 3)
#define UART2TX_P73 APOLLO4_PINMUX(73, 4)
#define DISP_D9_P73 APOLLO4_PINMUX(73, 5)
#define CT73_P73 APOLLO4_PINMUX(73, 6)
#define NCE73_P73 APOLLO4_PINMUX(73, 7)
#define OBSBUS9_P73 APOLLO4_PINMUX(73, 8)
#define FPIO_P73 APOLLO4_PINMUX(73, 11)
#define MSPI2_0_P74 APOLLO4_PINMUX(74, 0)
#define DISP_QSPI_D0_OUT_P74 APOLLO4_PINMUX(74, 1)
#define DISP_QSPI_D0_P74 APOLLO4_PINMUX(74, 2)
#define GPIO_P74 APOLLO4_PINMUX(74, 3)
#define UART0RX_P74 APOLLO4_PINMUX(74, 4)
#define DISP_D10_P74 APOLLO4_PINMUX(74, 5)
#define CT74_P74 APOLLO4_PINMUX(74, 6)
#define NCE74_P74 APOLLO4_PINMUX(74, 7)
#define OBSBUS10_P74 APOLLO4_PINMUX(74, 8)
#define DISP_SPI_SD_P74 APOLLO4_PINMUX(74, 9)
#define DISP_SPI_SDO_P74 APOLLO4_PINMUX(74, 10)
#define FPIO_P74 APOLLO4_PINMUX(74, 11)
#define MSPI2_1_P75 APOLLO4_PINMUX(75, 0)
#define XT32KHZ_P75 APOLLO4_PINMUX(75, 1)
#define DISP_QSPI_D1_P75 APOLLO4_PINMUX(75, 2)
#define GPIO_P75 APOLLO4_PINMUX(75, 3)
#define UART2RX_P75 APOLLO4_PINMUX(75, 4)
#define DISP_D11_P75 APOLLO4_PINMUX(75, 5)
#define CT75_P75 APOLLO4_PINMUX(75, 6)
#define NCE75_P75 APOLLO4_PINMUX(75, 7)
#define OBSBUS11_P75 APOLLO4_PINMUX(75, 8)
#define DISP_SPI_DCX_P75 APOLLO4_PINMUX(75, 9)
#define FPIO_P75 APOLLO4_PINMUX(75, 11)
#define MSPI2_2_P76 APOLLO4_PINMUX(76, 0)
#define XT32KHZ_P76 APOLLO4_PINMUX(76, 1)
#define DISP_QSPI_D2_P76 APOLLO4_PINMUX(76, 2)
#define GPIO_P76 APOLLO4_PINMUX(76, 3)
#define UART0RTS_P76 APOLLO4_PINMUX(76, 4)
#define DISP_D12_P76 APOLLO4_PINMUX(76, 5)
#define CT76_P76 APOLLO4_PINMUX(76, 6)
#define NCE76_P76 APOLLO4_PINMUX(76, 7)
#define OBSBUS12_P76 APOLLO4_PINMUX(76, 8)
#define FPIO_P76 APOLLO4_PINMUX(76, 11)
#define MSPI2_3_P77 APOLLO4_PINMUX(77, 0)
#define DISP_QSPI_D3_P77 APOLLO4_PINMUX(77, 2)
#define GPIO_P77 APOLLO4_PINMUX(77, 3)
#define UART0CTS_P77 APOLLO4_PINMUX(77, 4)
#define DISP_D13_P77 APOLLO4_PINMUX(77, 5)
#define CT77_P77 APOLLO4_PINMUX(77, 6)
#define NCE77_P77 APOLLO4_PINMUX(77, 7)
#define OBSBUS13_P77 APOLLO4_PINMUX(77, 8)
#define FPIO_P77 APOLLO4_PINMUX(77, 11)
#define MSPI2_4_P78 APOLLO4_PINMUX(78, 0)
#define DISP_QSPI_SCK_P78 APOLLO4_PINMUX(78, 2)
#define GPIO_P78 APOLLO4_PINMUX(78, 3)
#define UART0TX_P78 APOLLO4_PINMUX(78, 4)
#define DISP_D14_P78 APOLLO4_PINMUX(78, 5)
#define CT78_P78 APOLLO4_PINMUX(78, 6)
#define NCE78_P78 APOLLO4_PINMUX(78, 7)
#define OBSBUS14_P78 APOLLO4_PINMUX(78, 8)
#define DISP_SPI_SCK_P78 APOLLO4_PINMUX(78, 9)
#define FPIO_P78 APOLLO4_PINMUX(78, 11)
#define MSPI2_5_P79 APOLLO4_PINMUX(79, 0)
#define SDIF_DAT4_P79 APOLLO4_PINMUX(79, 2)
#define GPIO_P79 APOLLO4_PINMUX(79, 3)
#define SWO_P79 APOLLO4_PINMUX(79, 4)
#define DISP_VS_P79 APOLLO4_PINMUX(79, 5)
#define CT79_P79 APOLLO4_PINMUX(79, 6)
#define NCE79_P79 APOLLO4_PINMUX(79, 7)
#define OBSBUS15_P79 APOLLO4_PINMUX(79, 8)
#define DISP_SPI_SDI_P79 APOLLO4_PINMUX(79, 9)
#define FPIO_P79 APOLLO4_PINMUX(79, 11)
#define MSPI2_6_P80 APOLLO4_PINMUX(80, 0)
#define CLKOUT_P80 APOLLO4_PINMUX(80, 1)
#define SDIF_DAT5_P80 APOLLO4_PINMUX(80, 2)
#define GPIO_P80 APOLLO4_PINMUX(80, 3)
#define SWTRACE0_P80 APOLLO4_PINMUX(80, 4)
#define DISP_HS_P80 APOLLO4_PINMUX(80, 5)
#define CT80_P80 APOLLO4_PINMUX(80, 6)
#define NCE80_P80 APOLLO4_PINMUX(80, 7)
#define OBSBUS0_P80 APOLLO4_PINMUX(80, 8)
#define FPIO_P80 APOLLO4_PINMUX(80, 11)
#define MSPI2_7_P81 APOLLO4_PINMUX(81, 0)
#define CLKOUT_P81 APOLLO4_PINMUX(81, 1)
#define SDIF_DAT6_P81 APOLLO4_PINMUX(81, 2)
#define GPIO_P81 APOLLO4_PINMUX(81, 3)
#define SWTRACE1_P81 APOLLO4_PINMUX(81, 4)
#define DISP_DE_P81 APOLLO4_PINMUX(81, 5)
#define CT81_P81 APOLLO4_PINMUX(81, 6)
#define NCE81_P81 APOLLO4_PINMUX(81, 7)
#define OBSBUS1_P81 APOLLO4_PINMUX(81, 8)
#define FPIO_P81 APOLLO4_PINMUX(81, 11)
#define MSPI2_8_P82 APOLLO4_PINMUX(82, 0)
#define XT32KHZ_P82 APOLLO4_PINMUX(82, 1)
#define SDIF_DAT7_P82 APOLLO4_PINMUX(82, 2)
#define GPIO_P82 APOLLO4_PINMUX(82, 3)
#define SWTRACE2_P82 APOLLO4_PINMUX(82, 4)
#define DISP_PCLK_P82 APOLLO4_PINMUX(82, 5)
#define CT82_P82 APOLLO4_PINMUX(82, 6)
#define NCE82_P82 APOLLO4_PINMUX(82, 7)
#define OBSBUS2_P82 APOLLO4_PINMUX(82, 8)
#define FPIO_P82 APOLLO4_PINMUX(82, 11)
#define MSPI2_9_P83 APOLLO4_PINMUX(83, 0)
#define XT32KHZ_P83 APOLLO4_PINMUX(83, 1)
#define SDIF_CMD_P83 APOLLO4_PINMUX(83, 2)
#define GPIO_P83 APOLLO4_PINMUX(83, 3)
#define SWTRACE3_P83 APOLLO4_PINMUX(83, 4)
#define DISP_SD_P83 APOLLO4_PINMUX(83, 5)
#define CT83_P83 APOLLO4_PINMUX(83, 6)
#define NCE83_P83 APOLLO4_PINMUX(83, 7)
#define OBSBUS3_P83 APOLLO4_PINMUX(83, 8)
#define FPIO_P83 APOLLO4_PINMUX(83, 11)
#define SDIF_DAT0_P84 APOLLO4_PINMUX(84, 2)
#define GPIO_P84 APOLLO4_PINMUX(84, 3)
#define CT84_P84 APOLLO4_PINMUX(84, 6)
#define NCE84_P84 APOLLO4_PINMUX(84, 7)
#define OBSBUS4_P84 APOLLO4_PINMUX(84, 8)
#define FPIO_P84 APOLLO4_PINMUX(84, 11)
#define SDIF_DAT1_P85 APOLLO4_PINMUX(85, 2)
#define GPIO_P85 APOLLO4_PINMUX(85, 3)
#define CT85_P85 APOLLO4_PINMUX(85, 6)
#define NCE85_P85 APOLLO4_PINMUX(85, 7)
#define OBSBUS5_P85 APOLLO4_PINMUX(85, 8)
#define FPIO_P85 APOLLO4_PINMUX(85, 11)
#define SDIF_DAT2_P86 APOLLO4_PINMUX(86, 2)
#define GPIO_P86 APOLLO4_PINMUX(86, 3)
#define CT86_P86 APOLLO4_PINMUX(86, 6)
#define NCE86_P86 APOLLO4_PINMUX(86, 7)
#define OBSBUS6_P86 APOLLO4_PINMUX(86, 8)
#define FPIO_P86 APOLLO4_PINMUX(86, 11)
#define SDIF_DAT3_P87 APOLLO4_PINMUX(87, 2)
#define GPIO_P87 APOLLO4_PINMUX(87, 3)
#define CT87_P87 APOLLO4_PINMUX(87, 6)
#define NCE87_P87 APOLLO4_PINMUX(87, 7)
#define OBSBUS7_P87 APOLLO4_PINMUX(87, 8)
#define DISP_TE_P87 APOLLO4_PINMUX(87, 9)
#define FPIO_P87 APOLLO4_PINMUX(87, 11)
#define SDIF_CLKOUT_P88 APOLLO4_PINMUX(88, 2)
#define GPIO_P88 APOLLO4_PINMUX(88, 3)
#define CT88_P88 APOLLO4_PINMUX(88, 6)
#define NCE88_P88 APOLLO4_PINMUX(88, 7)
#define OBSBUS8_P88 APOLLO4_PINMUX(88, 8)
#define FPIO_P88 APOLLO4_PINMUX(88, 11)
#define GPIO_P89 APOLLO4_PINMUX(89, 3)
#define DISP_CM_P89 APOLLO4_PINMUX(89, 5)
#define CT89_P89 APOLLO4_PINMUX(89, 6)
#define NCE89_P89 APOLLO4_PINMUX(89, 7)
#define OBSBUS9_P89 APOLLO4_PINMUX(89, 8)
#define FPIO_P89 APOLLO4_PINMUX(89, 11)
#define GPIO_P90 APOLLO4_PINMUX(90, 3)
#define CT90_P90 APOLLO4_PINMUX(90, 6)
#define NCE90_P90 APOLLO4_PINMUX(90, 7)
#define OBSBUS10_P90 APOLLO4_PINMUX(90, 8)
#define VCMPO_P90 APOLLO4_PINMUX(90, 9)
#define FPIO_P90 APOLLO4_PINMUX(90, 11)
#define GPIO_P91 APOLLO4_PINMUX(91, 3)
#define CT91_P91 APOLLO4_PINMUX(91, 6)
#define NCE91_P91 APOLLO4_PINMUX(91, 7)
#define OBSBUS11_P91 APOLLO4_PINMUX(91, 8)
#define VCMPO_P91 APOLLO4_PINMUX(91, 9)
#define FPIO_P91 APOLLO4_PINMUX(91, 11)
#define GPIO_P92 APOLLO4_PINMUX(92, 3)
#define CT92_P92 APOLLO4_PINMUX(92, 6)
#define NCE92_P92 APOLLO4_PINMUX(92, 7)
#define OBSBUS12_P92 APOLLO4_PINMUX(92, 8)
#define VCMPO_P92 APOLLO4_PINMUX(92, 9)
#define FPIO_P92 APOLLO4_PINMUX(92, 11)
#define MSPI2_9_P93 APOLLO4_PINMUX(93, 0)
#define GPIO_P93 APOLLO4_PINMUX(93, 3)
#define CT93_P93 APOLLO4_PINMUX(93, 6)
#define NCE93_P93 APOLLO4_PINMUX(93, 7)
#define OBSBUS13_P93 APOLLO4_PINMUX(93, 8)
#define VCMPO_P93 APOLLO4_PINMUX(93, 9)
#define FPIO_P93 APOLLO4_PINMUX(93, 11)
#define GPIO_P94 APOLLO4_PINMUX(94, 3)
#define CT94_P94 APOLLO4_PINMUX(94, 6)
#define NCE94_P94 APOLLO4_PINMUX(94, 7)
#define OBSBUS14_P94 APOLLO4_PINMUX(94, 8)
#define VCMPO_P94 APOLLO4_PINMUX(94, 9)
#define FPIO_P94 APOLLO4_PINMUX(94, 11)
#define GPIO_P95 APOLLO4_PINMUX(95, 3)
#define CT95_P95 APOLLO4_PINMUX(95, 6)
#define NCE95_P95 APOLLO4_PINMUX(95, 7)
#define OBSBUS15_P95 APOLLO4_PINMUX(95, 8)
#define FPIO_P95 APOLLO4_PINMUX(95, 11)
#define GPIO_P96 APOLLO4_PINMUX(96, 3)
#define CT96_P96 APOLLO4_PINMUX(96, 6)
#define NCE96_P96 APOLLO4_PINMUX(96, 7)
#define OBSBUS0_P96 APOLLO4_PINMUX(96, 8)
#define FPIO_P96 APOLLO4_PINMUX(96, 11)
#define GPIO_P97 APOLLO4_PINMUX(97, 3)
#define CT97_P97 APOLLO4_PINMUX(97, 6)
#define NCE97_P97 APOLLO4_PINMUX(97, 7)
#define OBSBUS1_P97 APOLLO4_PINMUX(97, 8)
#define FPIO_P97 APOLLO4_PINMUX(97, 11)
#define GPIO_P98 APOLLO4_PINMUX(98, 3)
#define CT98_P98 APOLLO4_PINMUX(98, 6)
#define NCE98_P98 APOLLO4_PINMUX(98, 7)
#define OBSBUS2_P98 APOLLO4_PINMUX(98, 8)
#define FPIO_P98 APOLLO4_PINMUX(98, 11)
#define GPIO_P99 APOLLO4_PINMUX(99, 3)
#define CT99_P99 APOLLO4_PINMUX(99, 6)
#define NCE99_P99 APOLLO4_PINMUX(99, 7)
#define OBSBUS3_P99 APOLLO4_PINMUX(99, 8)
#define FPIO_P99 APOLLO4_PINMUX(99, 11)
#define GPIO_P100 APOLLO4_PINMUX(100, 3)
#define CT100_P100 APOLLO4_PINMUX(100, 6)
#define NCE100_P100 APOLLO4_PINMUX(100, 7)
#define OBSBUS4_P100 APOLLO4_PINMUX(100, 8)
#define FPIO_P100 APOLLO4_PINMUX(100, 11)
#define GPIO_P101 APOLLO4_PINMUX(101, 3)
#define CT101_P101 APOLLO4_PINMUX(101, 6)
#define NCE101_P101 APOLLO4_PINMUX(101, 7)
#define OBSBUS5_P101 APOLLO4_PINMUX(101, 8)
#define FPIO_P101 APOLLO4_PINMUX(101, 11)
#define GPIO_P102 APOLLO4_PINMUX(102, 3)
#define CT102_P102 APOLLO4_PINMUX(102, 6)
#define NCE102_P102 APOLLO4_PINMUX(102, 7)
#define OBSBUS6_P102 APOLLO4_PINMUX(102, 8)
#define FPIO_P102 APOLLO4_PINMUX(102, 11)
#define GPIO_P103 APOLLO4_PINMUX(103, 3)
#define CT103_P103 APOLLO4_PINMUX(103, 6)
#define NCE103_P103 APOLLO4_PINMUX(103, 7)
#define OBSBUS7_P103 APOLLO4_PINMUX(103, 8)
#define FPIO_P103 APOLLO4_PINMUX(103, 11)
#define MSPI1_9_P104 APOLLO4_PINMUX(104, 0)
#define GPIO_P104 APOLLO4_PINMUX(104, 3)
#define CT104_P104 APOLLO4_PINMUX(104, 6)
#define NCE104_P104 APOLLO4_PINMUX(104, 7)
#define OBSBUS8_P104 APOLLO4_PINMUX(104, 8)
#define FPIO_P104 APOLLO4_PINMUX(104, 11)
#define GPIO_P105 APOLLO4_PINMUX(105, 3)
#define CT105_P105 APOLLO4_PINMUX(105, 6)
#define OBSBUS9_P105 APOLLO4_PINMUX(105, 8)
#define GPIO_P106 APOLLO4_PINMUX(106, 3)
#define CT106_P106 APOLLO4_PINMUX(106, 6)
#define OBSBUS10_P106 APOLLO4_PINMUX(106, 8)
#define GPIO_P107 APOLLO4_PINMUX(107, 3)
#define CT107_P107 APOLLO4_PINMUX(107, 6)
#define OBSBUS11_P107 APOLLO4_PINMUX(107, 8)
#define GPIO_P108 APOLLO4_PINMUX(108, 3)
#define CT108_P108 APOLLO4_PINMUX(108, 6)
#define OBSBUS12_P108 APOLLO4_PINMUX(108, 8)
#define GPIO_P109 APOLLO4_PINMUX(109, 3)
#define CT109_P109 APOLLO4_PINMUX(109, 6)
#define OBSBUS13_P109 APOLLO4_PINMUX(109, 8)
#define GPIO_P110 APOLLO4_PINMUX(110, 3)
#define CT110_P110 APOLLO4_PINMUX(110, 6)
#define OBSBUS14_P110 APOLLO4_PINMUX(110, 8)
#define GPIO_P111 APOLLO4_PINMUX(111, 3)
#define CT111_P111 APOLLO4_PINMUX(111, 6)
#define OBSBUS15_P111 APOLLO4_PINMUX(111, 8)
#define GPIO_P112 APOLLO4_PINMUX(112, 3)
#define CT112_P112 APOLLO4_PINMUX(112, 6)
#define OBSBUS0_P112 APOLLO4_PINMUX(112, 8)
#define GPIO_P113 APOLLO4_PINMUX(113, 3)
#define CT113_P113 APOLLO4_PINMUX(113, 6)
#define OBSBUS1_P113 APOLLO4_PINMUX(113, 8)
#define GPIO_P114 APOLLO4_PINMUX(114, 3)
#define CT114_P114 APOLLO4_PINMUX(114, 6)
#define OBSBUS2_P114 APOLLO4_PINMUX(114, 8)
#define GPIO_P115 APOLLO4_PINMUX(115, 3)
#define CT115_P115 APOLLO4_PINMUX(115, 6)
#define OBSBUS3_P115 APOLLO4_PINMUX(115, 8)
#define GPIO_P116 APOLLO4_PINMUX(116, 3)
#define CT116_P116 APOLLO4_PINMUX(116, 6)
#define OBSBUS4_P116 APOLLO4_PINMUX(116, 8)
#define GPIO_P117 APOLLO4_PINMUX(117, 3)
#define CT117_P117 APOLLO4_PINMUX(117, 6)
#define OBSBUS5_P117 APOLLO4_PINMUX(117, 8)
#define GPIO_P118 APOLLO4_PINMUX(118, 3)
#define CT118_P118 APOLLO4_PINMUX(118, 6)
#define OBSBUS6_P118 APOLLO4_PINMUX(118, 8)
#define GPIO_P119 APOLLO4_PINMUX(119, 3)
#define CT119_P119 APOLLO4_PINMUX(119, 6)
#define OBSBUS7_P119 APOLLO4_PINMUX(119, 8)
#define GPIO_P120 APOLLO4_PINMUX(120, 3)
#define CT120_P120 APOLLO4_PINMUX(120, 6)
#define OBSBUS8_P120 APOLLO4_PINMUX(120, 8)
#define GPIO_P121 APOLLO4_PINMUX(121, 3)
#define CT121_P121 APOLLO4_PINMUX(121, 6)
#define OBSBUS9_P121 APOLLO4_PINMUX(121, 8)
#define GPIO_P122 APOLLO4_PINMUX(122, 3)
#define CT122_P122 APOLLO4_PINMUX(122, 6)
#define OBSBUS10_P122 APOLLO4_PINMUX(122, 8)
#define GPIO_P123 APOLLO4_PINMUX(123, 3)
#define CT123_P123 APOLLO4_PINMUX(123, 6)
#define OBSBUS11_P123 APOLLO4_PINMUX(123, 8)
#define GPIO_P124 APOLLO4_PINMUX(124, 3)
#define CT124_P124 APOLLO4_PINMUX(124, 6)
#define OBSBUS12_P124 APOLLO4_PINMUX(124, 8)
#define GPIO_P125 APOLLO4_PINMUX(125, 3)
#define CT125_P125 APOLLO4_PINMUX(125, 6)
#define OBSBUS13_P125 APOLLO4_PINMUX(125, 8)
#define GPIO_P126 APOLLO4_PINMUX(126, 3)
#define CT126_P126 APOLLO4_PINMUX(126, 6)
#define OBSBUS14_P126 APOLLO4_PINMUX(126, 8)
#define GPIO_P127 APOLLO4_PINMUX(127, 3)
#define CT127_P127 APOLLO4_PINMUX(127, 6)
#define OBSBUS15_P127 APOLLO4_PINMUX(127, 8)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_AMBIQ_APOLLO4_PINCTRL_H_ */
