/*
 * Copyright (c) 2022 Schlumberger
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_INTERRUPT_CONTROLLER_INFINEON_XMC4XXX_INTC_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_INTERRUPT_CONTROLLER_INFINEON_XMC4XXX_INTC_H_

#define XMC4XXX_INTC_PORT_POS		0
#define XMC4XXX_INTC_PORT_MASK		0xf

#define XMC4XXX_INTC_PIN_POS		4
#define XMC4XXX_INTC_PIN_MASK		0xf

#define XMC4XXX_INTC_LINE_POS		8
#define XMC4XXX_INTC_LINE_MASK		0x7

#define XMC4XXX_INTC_ERU_SRC_POS	11
#define XMC4XXX_INTC_ERU_SRC_MASK	0x7

#define XMC4XXX_INTC_GET_PORT(mx)    ((mx >> XMC4XXX_INTC_PORT_POS) & XMC4XXX_INTC_PORT_MASK)
#define XMC4XXX_INTC_GET_PIN(mx)     ((mx >> XMC4XXX_INTC_PIN_POS) & XMC4XXX_INTC_PIN_MASK)
#define XMC4XXX_INTC_GET_LINE(mx)    ((mx >> XMC4XXX_INTC_LINE_POS) & XMC4XXX_INTC_LINE_MASK)
#define XMC4XXX_INTC_GET_ERU_SRC(mx) ((mx >> XMC4XXX_INTC_ERU_SRC_POS) & XMC4XXX_INTC_ERU_SRC_MASK)

#define XMC4XXX_INTC_SET_LINE_MAP(port, pin, eru_src, line)                                        \
	((port) << XMC4XXX_INTC_PORT_POS | (pin) << XMC4XXX_INTC_PIN_POS |                         \
	 (eru_src) << XMC4XXX_INTC_ERU_SRC_POS | (line) << XMC4XXX_INTC_LINE_POS)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_INTERRUPT_CONTROLLER_INFINEON_XMC4XXX_INTC_H_ */
