/*
 * Copyright (c) 2023 Teslabs Engineering S.L.
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief ST Morpho header pin constants
 * @ingroup st-morpho-header
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ST_MORPHO_HEADER_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ST_MORPHO_HEADER_H_

/**
 * @defgroup st-morpho-header ST Morpho header
 * @brief Constants for pins exposed on ST Morpho header
 * @ingroup devicetree-gpio-pin-headers
 * @{
 */

/** ST Morpho pin mask (0...143). */
#define ST_MORPHO_PIN_MASK 0xFF

#define ST_MORPHO_L_1  0  /**< Left pin 1 */
#define ST_MORPHO_L_2  1  /**< Left pin 2 */
#define ST_MORPHO_L_3  2  /**< Left pin 3 */
#define ST_MORPHO_L_4  3  /**< Left pin 4 */
#define ST_MORPHO_L_5  4  /**< Left pin 5 */
#define ST_MORPHO_L_6  5  /**< Left pin 6 */
#define ST_MORPHO_L_7  6  /**< Left pin 7 */
#define ST_MORPHO_L_8  7  /**< Left pin 8 */
#define ST_MORPHO_L_9  8  /**< Left pin 9 */
#define ST_MORPHO_L_10 9  /**< Left pin 10 */
#define ST_MORPHO_L_11 10 /**< Left pin 11 */
#define ST_MORPHO_L_12 11 /**< Left pin 12 */
#define ST_MORPHO_L_13 12 /**< Left pin 13 */
#define ST_MORPHO_L_14 13 /**< Left pin 14 */
#define ST_MORPHO_L_15 14 /**< Left pin 15 */
#define ST_MORPHO_L_16 15 /**< Left pin 16 */
#define ST_MORPHO_L_17 16 /**< Left pin 17 */
#define ST_MORPHO_L_18 17 /**< Left pin 18 */
#define ST_MORPHO_L_19 18 /**< Left pin 19 */
#define ST_MORPHO_L_20 19 /**< Left pin 20 */
#define ST_MORPHO_L_21 20 /**< Left pin 21 */
#define ST_MORPHO_L_22 21 /**< Left pin 22 */
#define ST_MORPHO_L_23 22 /**< Left pin 23 */
#define ST_MORPHO_L_24 23 /**< Left pin 24 */
#define ST_MORPHO_L_25 24 /**< Left pin 25 */
#define ST_MORPHO_L_26 25 /**< Left pin 26 */
#define ST_MORPHO_L_27 26 /**< Left pin 27 */
#define ST_MORPHO_L_28 27 /**< Left pin 28 */
#define ST_MORPHO_L_29 28 /**< Left pin 29 */
#define ST_MORPHO_L_30 29 /**< Left pin 30 */
#define ST_MORPHO_L_31 30 /**< Left pin 31 */
#define ST_MORPHO_L_32 31 /**< Left pin 32 */
#define ST_MORPHO_L_33 32 /**< Left pin 33 */
#define ST_MORPHO_L_34 33 /**< Left pin 34 */
#define ST_MORPHO_L_35 34 /**< Left pin 35 */
#define ST_MORPHO_L_36 35 /**< Left pin 36 */
#define ST_MORPHO_L_37 36 /**< Left pin 37 */
#define ST_MORPHO_L_38 37 /**< Left pin 38 */
#define ST_MORPHO_L_39 38 /**< Left pin 39 */
#define ST_MORPHO_L_40 39 /**< Left pin 40 */
#define ST_MORPHO_L_41 40 /**< Left pin 41 */
#define ST_MORPHO_L_42 41 /**< Left pin 42 */
#define ST_MORPHO_L_43 42 /**< Left pin 43 */
#define ST_MORPHO_L_44 43 /**< Left pin 44 */
#define ST_MORPHO_L_45 44 /**< Left pin 45 */
#define ST_MORPHO_L_46 45 /**< Left pin 46 */
#define ST_MORPHO_L_47 46 /**< Left pin 47 */
#define ST_MORPHO_L_48 47 /**< Left pin 48 */
#define ST_MORPHO_L_49 48 /**< Left pin 49 */
#define ST_MORPHO_L_50 49 /**< Left pin 50 */
#define ST_MORPHO_L_51 50 /**< Left pin 51 */
#define ST_MORPHO_L_52 51 /**< Left pin 52 */
#define ST_MORPHO_L_53 52 /**< Left pin 53 */
#define ST_MORPHO_L_54 53 /**< Left pin 54 */
#define ST_MORPHO_L_55 54 /**< Left pin 55 */
#define ST_MORPHO_L_56 55 /**< Left pin 56 */
#define ST_MORPHO_L_57 56 /**< Left pin 57 */
#define ST_MORPHO_L_58 57 /**< Left pin 58 */
#define ST_MORPHO_L_59 58 /**< Left pin 59 */
#define ST_MORPHO_L_60 59 /**< Left pin 60 */
#define ST_MORPHO_L_61 60 /**< Left pin 61 */
#define ST_MORPHO_L_62 61 /**< Left pin 62 */
#define ST_MORPHO_L_63 62 /**< Left pin 63 */
#define ST_MORPHO_L_64 63 /**< Left pin 64 */
#define ST_MORPHO_L_65 64 /**< Left pin 65 */
#define ST_MORPHO_L_66 65 /**< Left pin 66 */
#define ST_MORPHO_L_67 66 /**< Left pin 67 */
#define ST_MORPHO_L_68 67 /**< Left pin 68 */
#define ST_MORPHO_L_69 68 /**< Left pin 69 */
#define ST_MORPHO_L_70 69 /**< Left pin 70 */
#define ST_MORPHO_L_71 70 /**< Left pin 71 */
#define ST_MORPHO_L_72 71 /**< Left pin 72 */

#define ST_MORPHO_R_1  72  /**< Right pin 1 */
#define ST_MORPHO_R_2  73  /**< Right pin 2 */
#define ST_MORPHO_R_3  74  /**< Right pin 3 */
#define ST_MORPHO_R_4  75  /**< Right pin 4 */
#define ST_MORPHO_R_5  76  /**< Right pin 5 */
#define ST_MORPHO_R_6  77  /**< Right pin 6 */
#define ST_MORPHO_R_7  78  /**< Right pin 7 */
#define ST_MORPHO_R_8  79  /**< Right pin 8 */
#define ST_MORPHO_R_9  80  /**< Right pin 9 */
#define ST_MORPHO_R_10 81  /**< Right pin 10 */
#define ST_MORPHO_R_11 82  /**< Right pin 11 */
#define ST_MORPHO_R_12 83  /**< Right pin 12 */
#define ST_MORPHO_R_13 84  /**< Right pin 13 */
#define ST_MORPHO_R_14 85  /**< Right pin 14 */
#define ST_MORPHO_R_15 86  /**< Right pin 15 */
#define ST_MORPHO_R_16 87  /**< Right pin 16 */
#define ST_MORPHO_R_17 88  /**< Right pin 17 */
#define ST_MORPHO_R_18 89  /**< Right pin 18 */
#define ST_MORPHO_R_19 90  /**< Right pin 19 */
#define ST_MORPHO_R_20 91  /**< Right pin 20 */
#define ST_MORPHO_R_21 92  /**< Right pin 21 */
#define ST_MORPHO_R_22 93  /**< Right pin 22 */
#define ST_MORPHO_R_23 94  /**< Right pin 23 */
#define ST_MORPHO_R_24 95  /**< Right pin 24 */
#define ST_MORPHO_R_25 96  /**< Right pin 25 */
#define ST_MORPHO_R_26 97  /**< Right pin 26 */
#define ST_MORPHO_R_27 98  /**< Right pin 27 */
#define ST_MORPHO_R_28 99  /**< Right pin 28 */
#define ST_MORPHO_R_29 100 /**< Right pin 29 */
#define ST_MORPHO_R_30 101 /**< Right pin 30 */
#define ST_MORPHO_R_31 102 /**< Right pin 31 */
#define ST_MORPHO_R_32 103 /**< Right pin 32 */
#define ST_MORPHO_R_33 104 /**< Right pin 33 */
#define ST_MORPHO_R_34 105 /**< Right pin 34 */
#define ST_MORPHO_R_35 106 /**< Right pin 35 */
#define ST_MORPHO_R_36 107 /**< Right pin 36 */
#define ST_MORPHO_R_37 108 /**< Right pin 37 */
#define ST_MORPHO_R_38 109 /**< Right pin 38 */
#define ST_MORPHO_R_39 110 /**< Right pin 39 */
#define ST_MORPHO_R_40 111 /**< Right pin 40 */
#define ST_MORPHO_R_41 112 /**< Right pin 41 */
#define ST_MORPHO_R_42 113 /**< Right pin 42 */
#define ST_MORPHO_R_43 114 /**< Right pin 43 */
#define ST_MORPHO_R_44 115 /**< Right pin 44 */
#define ST_MORPHO_R_45 116 /**< Right pin 45 */
#define ST_MORPHO_R_46 117 /**< Right pin 46 */
#define ST_MORPHO_R_47 118 /**< Right pin 47 */
#define ST_MORPHO_R_48 119 /**< Right pin 48 */
#define ST_MORPHO_R_49 120 /**< Right pin 49 */
#define ST_MORPHO_R_50 121 /**< Right pin 50 */
#define ST_MORPHO_R_51 122 /**< Right pin 51 */
#define ST_MORPHO_R_52 123 /**< Right pin 52 */
#define ST_MORPHO_R_53 124 /**< Right pin 53 */
#define ST_MORPHO_R_54 125 /**< Right pin 54 */
#define ST_MORPHO_R_55 126 /**< Right pin 55 */
#define ST_MORPHO_R_56 127 /**< Right pin 56 */
#define ST_MORPHO_R_57 128 /**< Right pin 57 */
#define ST_MORPHO_R_58 129 /**< Right pin 58 */
#define ST_MORPHO_R_59 130 /**< Right pin 59 */
#define ST_MORPHO_R_60 131 /**< Right pin 60 */
#define ST_MORPHO_R_61 132 /**< Right pin 61 */
#define ST_MORPHO_R_62 133 /**< Right pin 62 */
#define ST_MORPHO_R_63 134 /**< Right pin 63 */
#define ST_MORPHO_R_64 135 /**< Right pin 64 */
#define ST_MORPHO_R_65 136 /**< Right pin 65 */
#define ST_MORPHO_R_66 137 /**< Right pin 66 */
#define ST_MORPHO_R_67 138 /**< Right pin 67 */
#define ST_MORPHO_R_68 139 /**< Right pin 68 */
#define ST_MORPHO_R_69 140 /**< Right pin 69 */
#define ST_MORPHO_R_70 141 /**< Right pin 70 */
#define ST_MORPHO_R_71 142 /**< Right pin 71 */
#define ST_MORPHO_R_72 143 /**< Right pin 72 */

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ST_MORPHO_HEADER_H_ */
