/*
 * Copyright (c) 2023 Antmicro <www.antmicro.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_RENESAS_RZT2M_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_RENESAS_RZT2M_H_
#include <zephyr/sys/util.h>

#define RZT2M_GPIO_DRIVE_OFFSET 8
#define RZT2M_GPIO_DRIVE_MASK   GENMASK(RZT2M_GPIO_DRIVE_OFFSET + 2, RZT2M_GPIO_DRIVE_OFFSET)

/**
 * @brief Select GPIO pin drive strength
 */
#define RZT2M_GPIO_DRIVE_LOW        (0U << RZT2M_GPIO_DRIVE_OFFSET)
#define RZT2M_GPIO_DRIVE_MIDDLE     (1U << RZT2M_GPIO_DRIVE_OFFSET)
#define RZT2M_GPIO_DRIVE_HIGH       (2U << RZT2M_GPIO_DRIVE_OFFSET)
#define RZT2M_GPIO_DRIVE_ULTRA_HIGH (3U << RZT2M_GPIO_DRIVE_OFFSET)

#define RZT2M_GPIO_SCHMITT_TRIGGER_OFFSET 10
#define RZT2M_GPIO_SCHMITT_TRIGGER_MASK   BIT(RZT2M_GPIO_SCHMITT_TRIGGER_OFFSET)

/**
 * @brief Enable GPIO pin schmitt trigger
 */
#define RZT2M_GPIO_SCHMITT_TRIGGER BIT(RZT2M_GPIO_SCHMITT_TRIGGER_OFFSET)

#define RZT2M_GPIO_SLEW_RATE_OFFSET 11
#define RZT2M_GPIO_SLEW_RATE_MASK   BIT(RZT2M_GPIO_SLEW_RATE_OFFSET)

/**
 * @brief Select GPIO pin slew rate
 */
#define RZT2M_GPIO_SLEW_RATE_SLOW 0U
#define RZT2M_GPIO_SLEW_RATE_FAST BIT(RZT2M_GPIO_SLEW_RATE_OFFSET)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_RENESAS_RZT2M_H_ */
