/*
 * Copyright (c) 2025 TOKITA Hiroshi
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief Arduino Nano header pin constants
 * @ingroup arduino-nano-header
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_NANO_HEADER_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_NANO_HEADER_H_

/**
 * @defgroup arduino-nano-header Arduino Nano header
 * @brief Constants for pins exposed on Arduino Nano header
 * @ingroup devicetree-gpio-pin-headers
 * @{
 */

#define ARDUINO_NANO_HEADER_D0  0  /**< Digital pin 0 (D0/RX) */
#define ARDUINO_NANO_HEADER_D1  1  /**< Digital pin 1 (D1/TX) */
#define ARDUINO_NANO_HEADER_D2  2  /**< Digital pin 2 (D2) */
#define ARDUINO_NANO_HEADER_D3  3  /**< Digital pin 3 (D3) */
#define ARDUINO_NANO_HEADER_D4  4  /**< Digital pin 4 (D4) */
#define ARDUINO_NANO_HEADER_D5  5  /**< Digital pin 5 (D5) */
#define ARDUINO_NANO_HEADER_D6  6  /**< Digital pin 6 (D6) */
#define ARDUINO_NANO_HEADER_D7  7  /**< Digital pin 7 (D7) */
#define ARDUINO_NANO_HEADER_D8  8  /**< Digital pin 8 (D8) */
#define ARDUINO_NANO_HEADER_D9  9  /**< Digital pin 9 (D9) */
#define ARDUINO_NANO_HEADER_D10 10 /**< Digital pin 10 (D10/SS) */
#define ARDUINO_NANO_HEADER_D11 11 /**< Digital pin 11 (D11/COPI) */
#define ARDUINO_NANO_HEADER_D12 12 /**< Digital pin 12 (D12/CIPO) */
#define ARDUINO_NANO_HEADER_D13 13 /**< Digital pin 13 (D13/SCK) */
#define ARDUINO_NANO_HEADER_D14 14 /**< Digital pin 14 (D14) */
#define ARDUINO_NANO_HEADER_D15 15 /**< Digital pin 15 (D15) */
#define ARDUINO_NANO_HEADER_D16 16 /**< Digital pin 16 (D16) */
#define ARDUINO_NANO_HEADER_D17 17 /**< Digital pin 17 (D17) */
#define ARDUINO_NANO_HEADER_D18 18 /**< Digital pin 18 (D18) */
#define ARDUINO_NANO_HEADER_D19 19 /**< Digital pin 19 (D19) */
#define ARDUINO_NANO_HEADER_D20 20 /**< Digital pin 20 (D20) */
#define ARDUINO_NANO_HEADER_D21 21 /**< Digital pin 21 (D21) */
#define ARDUINO_NANO_HEADER_A0  14 /**< Analog pin 0 (A0) */
#define ARDUINO_NANO_HEADER_A1  15 /**< Analog pin 1 (A1) */
#define ARDUINO_NANO_HEADER_A2  16 /**< Analog pin 2 (A2) */
#define ARDUINO_NANO_HEADER_A3  19 /**< Analog pin 3 (A3) */
#define ARDUINO_NANO_HEADER_A4  18 /**< Analog pin 4 (A4) */
#define ARDUINO_NANO_HEADER_A5  19 /**< Analog pin 5 (A5) */
#define ARDUINO_NANO_HEADER_A6  20 /**< Analog pin 6 (A6) */
#define ARDUINO_NANO_HEADER_A7  21 /**< Analog pin 7 (A7) */

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_NANO_HEADER_H_ */
