/*
 * Copyright (c) 2025 TOKITA Hiroshi
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief Arduino MKR header pin constants
 * @ingroup arduino-mkr-header
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_MKR_HEADER_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_MKR_HEADER_H_

/**
 * @defgroup arduino-mkr-header Arduino MKR header
 * @brief Constants for pins exposed on Arduino MKR header
 * @ingroup devicetree-gpio-pin-headers
 * @{
 */

#define ARDUINO_MKR_HEADER_D0  0  /**< Digital pin 0 (D0) */
#define ARDUINO_MKR_HEADER_D1  1  /**< Digital pin 1 (D1) */
#define ARDUINO_MKR_HEADER_D2  2  /**< Digital pin 2 (D2) */
#define ARDUINO_MKR_HEADER_D3  3  /**< Digital pin 3 (D3) */
#define ARDUINO_MKR_HEADER_D4  4  /**< Digital pin 4 (D4) */
#define ARDUINO_MKR_HEADER_D5  5  /**< Digital pin 5 (D5) */
#define ARDUINO_MKR_HEADER_D6  6  /**< Digital pin 6 (D6) */
#define ARDUINO_MKR_HEADER_D7  7  /**< Digital pin 7 (D7) */
#define ARDUINO_MKR_HEADER_D8  8  /**< Digital pin 8 (D8/COPI) */
#define ARDUINO_MKR_HEADER_D9  9  /**< Digital pin 9 (D9/SCK) */
#define ARDUINO_MKR_HEADER_D10 10 /**< Digital pin 10 (D10/CIPO) */
#define ARDUINO_MKR_HEADER_D11 11 /**< Digital pin 11 (D11/SDA) */
#define ARDUINO_MKR_HEADER_D12 12 /**< Digital pin 12 (D12/SCL) */
#define ARDUINO_MKR_HEADER_D13 13 /**< Digital pin 13 (D13/RX) */
#define ARDUINO_MKR_HEADER_D14 14 /**< Digital pin 14 (D14/TX) */
#define ARDUINO_MKR_HEADER_A0  15 /**< Analog pin 0 (A0/D15/DAC0) */
#define ARDUINO_MKR_HEADER_A1  16 /**< Analog pin 1 (A1/D16) */
#define ARDUINO_MKR_HEADER_A2  17 /**< Analog pin 2 (A2/D17) */
#define ARDUINO_MKR_HEADER_A3  18 /**< Analog pin 3 (A3/D18) */
#define ARDUINO_MKR_HEADER_A4  19 /**< Analog pin 4 (A4/D19) */
#define ARDUINO_MKR_HEADER_A5  20 /**< Analog pin 5 (A5/D20) */
#define ARDUINO_MKR_HEADER_A6  21 /**< Analog pin 6 (A6/D21) */

/** @} */

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_GPIO_ARDUINO_MKR_HEADER_H_ */
