/*
 * Copyright (c) 2024 Manuel Aebischer <manuel.aebischer@belden.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_RP2350_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_RP2350_H_

#include "rpi-pico-dma-common.h"

#define RPI_PICO_DMA_SLOT_PIO2_TX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x10)
#define RPI_PICO_DMA_SLOT_PIO2_TX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x11)
#define RPI_PICO_DMA_SLOT_PIO2_TX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x12)
#define RPI_PICO_DMA_SLOT_PIO2_TX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x13)
#define RPI_PICO_DMA_SLOT_PIO2_RX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x14)
#define RPI_PICO_DMA_SLOT_PIO2_RX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x15)
#define RPI_PICO_DMA_SLOT_PIO2_RX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x16)
#define RPI_PICO_DMA_SLOT_PIO2_RX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x17)
#define RPI_PICO_DMA_SLOT_SPI0_TX    RPI_PICO_DMA_DREQ_TO_SLOT(0x18)
#define RPI_PICO_DMA_SLOT_SPI0_RX    RPI_PICO_DMA_DREQ_TO_SLOT(0x19)
#define RPI_PICO_DMA_SLOT_SPI1_TX    RPI_PICO_DMA_DREQ_TO_SLOT(0x1A)
#define RPI_PICO_DMA_SLOT_SPI1_RX    RPI_PICO_DMA_DREQ_TO_SLOT(0x1B)
#define RPI_PICO_DMA_SLOT_UART0_TX   RPI_PICO_DMA_DREQ_TO_SLOT(0x1C)
#define RPI_PICO_DMA_SLOT_UART0_RX   RPI_PICO_DMA_DREQ_TO_SLOT(0x1D)
#define RPI_PICO_DMA_SLOT_UART1_TX   RPI_PICO_DMA_DREQ_TO_SLOT(0x1E)
#define RPI_PICO_DMA_SLOT_UART1_RX   RPI_PICO_DMA_DREQ_TO_SLOT(0x1F)
#define RPI_PICO_DMA_SLOT_PWM_WRAP0  RPI_PICO_DMA_DREQ_TO_SLOT(0x20)
#define RPI_PICO_DMA_SLOT_PWM_WRAP1  RPI_PICO_DMA_DREQ_TO_SLOT(0x21)
#define RPI_PICO_DMA_SLOT_PWM_WRAP2  RPI_PICO_DMA_DREQ_TO_SLOT(0x22)
#define RPI_PICO_DMA_SLOT_PWM_WRAP3  RPI_PICO_DMA_DREQ_TO_SLOT(0x23)
#define RPI_PICO_DMA_SLOT_PWM_WRAP4  RPI_PICO_DMA_DREQ_TO_SLOT(0x24)
#define RPI_PICO_DMA_SLOT_PWM_WRAP5  RPI_PICO_DMA_DREQ_TO_SLOT(0x25)
#define RPI_PICO_DMA_SLOT_PWM_WRAP6  RPI_PICO_DMA_DREQ_TO_SLOT(0x26)
#define RPI_PICO_DMA_SLOT_PWM_WRAP7  RPI_PICO_DMA_DREQ_TO_SLOT(0x27)
#define RPI_PICO_DMA_SLOT_PWM_WRAP8  RPI_PICO_DMA_DREQ_TO_SLOT(0x28)
#define RPI_PICO_DMA_SLOT_PWM_WRAP9  RPI_PICO_DMA_DREQ_TO_SLOT(0x29)
#define RPI_PICO_DMA_SLOT_PWM_WRAP10 RPI_PICO_DMA_DREQ_TO_SLOT(0x2A)
#define RPI_PICO_DMA_SLOT_PWM_WRAP11 RPI_PICO_DMA_DREQ_TO_SLOT(0x2B)
#define RPI_PICO_DMA_SLOT_I2C0_TX    RPI_PICO_DMA_DREQ_TO_SLOT(0x2C)
#define RPI_PICO_DMA_SLOT_I2C0_RX    RPI_PICO_DMA_DREQ_TO_SLOT(0x2D)
#define RPI_PICO_DMA_SLOT_I2C1_TX    RPI_PICO_DMA_DREQ_TO_SLOT(0x2E)
#define RPI_PICO_DMA_SLOT_I2C1_RX    RPI_PICO_DMA_DREQ_TO_SLOT(0x2F)
#define RPI_PICO_DMA_SLOT_ADC        RPI_PICO_DMA_DREQ_TO_SLOT(0x30)
#define RPI_PICO_DMA_SLOT_XIP_STREAM RPI_PICO_DMA_DREQ_TO_SLOT(0x31)
#define RPI_PICO_DMA_SLOT_XIP_QMITX  RPI_PICO_DMA_DREQ_TO_SLOT(0x32)
#define RPI_PICO_DMA_SLOT_XIP_QMIRX  RPI_PICO_DMA_DREQ_TO_SLOT(0x33)
#define RPI_PICO_DMA_SLOT_HSTX       RPI_PICO_DMA_DREQ_TO_SLOT(0x34)
#define RPI_PICO_DMA_SLOT_CORESIGHT  RPI_PICO_DMA_DREQ_TO_SLOT(0x35)
#define RPI_PICO_DMA_SLOT_SHA256     RPI_PICO_DMA_DREQ_TO_SLOT(0x36)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_RP2350_H_ */
