/*
 * Copyright (c) 2023 TOKITA Hiroshi <tokita.hiroshi@fujitsu.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_COMMON_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_COMMON_H_

/*
 * Use lower 6-bit of inverted DREQ value for `slot` cell.
 * Need to be able to work for memory-to-memory transfer
 * with zero, which is the default value.
 */
#define RPI_PICO_DMA_SLOT_TO_DREQ(s) (~(s)&0x3F)
#define RPI_PICO_DMA_DREQ_TO_SLOT    RPI_PICO_DMA_SLOT_TO_DREQ

#define RPI_PICO_DMA_SLOT_PIO0_TX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x00)
#define RPI_PICO_DMA_SLOT_PIO0_TX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x01)
#define RPI_PICO_DMA_SLOT_PIO0_TX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x02)
#define RPI_PICO_DMA_SLOT_PIO0_TX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x03)
#define RPI_PICO_DMA_SLOT_PIO0_RX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x04)
#define RPI_PICO_DMA_SLOT_PIO0_RX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x05)
#define RPI_PICO_DMA_SLOT_PIO0_RX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x06)
#define RPI_PICO_DMA_SLOT_PIO0_RX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x07)
#define RPI_PICO_DMA_SLOT_PIO1_TX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x08)
#define RPI_PICO_DMA_SLOT_PIO1_TX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x09)
#define RPI_PICO_DMA_SLOT_PIO1_TX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x0A)
#define RPI_PICO_DMA_SLOT_PIO1_TX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x0B)
#define RPI_PICO_DMA_SLOT_PIO1_RX0   RPI_PICO_DMA_DREQ_TO_SLOT(0x0C)
#define RPI_PICO_DMA_SLOT_PIO1_RX1   RPI_PICO_DMA_DREQ_TO_SLOT(0x0D)
#define RPI_PICO_DMA_SLOT_PIO1_RX2   RPI_PICO_DMA_DREQ_TO_SLOT(0x0E)
#define RPI_PICO_DMA_SLOT_PIO1_RX3   RPI_PICO_DMA_DREQ_TO_SLOT(0x0F)

#define RPI_PICO_DMA_SLOT_DMA_TIMER0 RPI_PICO_DMA_DREQ_TO_SLOT(0x3B)
#define RPI_PICO_DMA_SLOT_DMA_TIMER1 RPI_PICO_DMA_DREQ_TO_SLOT(0x3C)
#define RPI_PICO_DMA_SLOT_DMA_TIMER2 RPI_PICO_DMA_DREQ_TO_SLOT(0x3D)
#define RPI_PICO_DMA_SLOT_DMA_TIMER3 RPI_PICO_DMA_DREQ_TO_SLOT(0x3E)
#define RPI_PICO_DMA_SLOT_FORCE      RPI_PICO_DMA_DREQ_TO_SLOT(0x3F)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_RPI_PICO_DMA_COMMON_H_ */
