/*
 * Copyright (c) 2024 Silicon Laboratories Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_SILABS_COMMON_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_SILABS_COMMON_CLOCK_H_

/*
 * DT macros for clock branches.
 * Must stay in sync with the enum sl_clock_branch_t in the Silicon Labs HAL to be
 * interpreted correctly by the clock control driver.
 */
#define CLOCK_BRANCH_SYSCLK       0
#define CLOCK_BRANCH_HCLK         1
#define CLOCK_BRANCH_HCLKRADIO    2
#define CLOCK_BRANCH_PCLK         3
#define CLOCK_BRANCH_LSPCLK       4
#define CLOCK_BRANCH_TRACECLK     5
#define CLOCK_BRANCH_ADCCLK       6
#define CLOCK_BRANCH_EXPORTCLK    7
#define CLOCK_BRANCH_EM01GRPACLK  8
#define CLOCK_BRANCH_EM01GRPBCLK  9
#define CLOCK_BRANCH_EM01GRPCCLK  10
#define CLOCK_BRANCH_EM01GRPDCLK  11
#define CLOCK_BRANCH_EM23GRPACLK  12
#define CLOCK_BRANCH_EM4GRPACLK   13
#define CLOCK_BRANCH_QSPISYSCLK   14
#define CLOCK_BRANCH_IADCCLK      15
#define CLOCK_BRANCH_WDOG0CLK     16
#define CLOCK_BRANCH_WDOG1CLK     17
#define CLOCK_BRANCH_RTCCCLK      18
#define CLOCK_BRANCH_SYSRTCCLK    19
#define CLOCK_BRANCH_EUART0CLK    20
#define CLOCK_BRANCH_EUSART0CLK   21
#define CLOCK_BRANCH_EUSART1CLK   22
#define CLOCK_BRANCH_DPLLREFCLK   23
#define CLOCK_BRANCH_I2C0CLK      24
#define CLOCK_BRANCH_LCDCLK       25
#define CLOCK_BRANCH_PIXELRZCLK   26
#define CLOCK_BRANCH_PCNT0CLK     27
#define CLOCK_BRANCH_PRORTCCLK    28
#define CLOCK_BRANCH_SYSTICKCLK   29
#define CLOCK_BRANCH_LESENSEHFCLK 30
#define CLOCK_BRANCH_VDAC0CLK     31
#define CLOCK_BRANCH_VDAC1CLK     32
#define CLOCK_BRANCH_USB0CLK      33
#define CLOCK_BRANCH_FLPLLREFCLK  34
#define CLOCK_BRANCH_INVALID      35

#define CLOCK_BIT_MASK 0x03FUL
#define CLOCK_REG_MASK 0x1C0UL

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_SILABS_COMMON_CLOCK_H_ */
