/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_IMX943_CLOCK_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_IMX943_CLOCK_H_

#define IMX943_CLK_32K                  1
#define IMX943_CLK_24M                  2
#define IMX943_CLK_FRO                  3
#define IMX943_CLK_SYSPLL1_VCO          4
#define IMX943_CLK_SYSPLL1_PFD0_UNGATED 5
#define IMX943_CLK_SYSPLL1_PFD0         6
#define IMX943_CLK_SYSPLL1_PFD0_DIV2    7
#define IMX943_CLK_SYSPLL1_PFD1_UNGATED 8
#define IMX943_CLK_SYSPLL1_PFD1         9
#define IMX943_CLK_SYSPLL1_PFD1_DIV2    10
#define IMX943_CLK_SYSPLL1_PFD2_UNGATED 11
#define IMX943_CLK_SYSPLL1_PFD2         12
#define IMX943_CLK_SYSPLL1_PFD2_DIV2    13
#define IMX943_CLK_AUDIOPLL1_VCO        14
#define IMX943_CLK_AUDIOPLL1            15
#define IMX943_CLK_AUDIOPLL2_VCO        16
#define IMX943_CLK_AUDIOPLL2            17
#define IMX943_CLK_RESERVED18           18
#define IMX943_CLK_RESERVED19           19
#define IMX943_CLK_RESERVED20           20
#define IMX943_CLK_RESERVED21           21
#define IMX943_CLK_RESERVED22           22
#define IMX943_CLK_RESERVED23           23
#define IMX943_CLK_ENCPLL_VCO           24
#define IMX943_CLK_ENCPLL_PFD0_UNGATED  25
#define IMX943_CLK_ENCPLL_PFD0          26
#define IMX943_CLK_ENCPLL_PFD1_UNGATED  27
#define IMX943_CLK_ENCPLL_PFD1          28
#define IMX943_CLK_ARMPLL_VCO           29
#define IMX943_CLK_ARMPLL_PFD0_UNGATED  30
#define IMX943_CLK_ARMPLL_PFD0          31
#define IMX943_CLK_ARMPLL_PFD1_UNGATED  32
#define IMX943_CLK_ARMPLL_PFD1          33
#define IMX943_CLK_ARMPLL_PFD2_UNGATED  34
#define IMX943_CLK_ARMPLL_PFD2          35
#define IMX943_CLK_ARMPLL_PFD3_UNGATED  36
#define IMX943_CLK_ARMPLL_PFD3          37
#define IMX943_CLK_DRAMPLL_VCO          38
#define IMX943_CLK_DRAMPLL              39
#define IMX943_CLK_HSIOPLL_VCO          40
#define IMX943_CLK_HSIOPLL              41
#define IMX943_CLK_LDBPLL_VCO           42
#define IMX943_CLK_LDBPLL               43
#define IMX943_CLK_EXT1                 44
#define IMX943_CLK_EXT2                 45

#define IMX943_CCM_NUM_CLK_SRC 46

#define IMX943_CLK_ADC              (IMX943_CCM_NUM_CLK_SRC + 0)
#define IMX943_CLK_BUSAON           (IMX943_CCM_NUM_CLK_SRC + 1)
#define IMX943_CLK_CAN1             (IMX943_CCM_NUM_CLK_SRC + 2)
#define IMX943_CLK_GLITCHFILTER     (IMX943_CCM_NUM_CLK_SRC + 3)
#define IMX943_CLK_GPT1             (IMX943_CCM_NUM_CLK_SRC + 4)
#define IMX943_CLK_I3C1SLOW         (IMX943_CCM_NUM_CLK_SRC + 5)
#define IMX943_CLK_LPI2C1           (IMX943_CCM_NUM_CLK_SRC + 6)
#define IMX943_CLK_LPI2C2           (IMX943_CCM_NUM_CLK_SRC + 7)
#define IMX943_CLK_LPSPI1           (IMX943_CCM_NUM_CLK_SRC + 8)
#define IMX943_CLK_LPSPI2           (IMX943_CCM_NUM_CLK_SRC + 9)
#define IMX943_CLK_LPTMR1           (IMX943_CCM_NUM_CLK_SRC + 10)
#define IMX943_CLK_LPUART1          (IMX943_CCM_NUM_CLK_SRC + 11)
#define IMX943_CLK_LPUART2          (IMX943_CCM_NUM_CLK_SRC + 12)
#define IMX943_CLK_M33              (IMX943_CCM_NUM_CLK_SRC + 13)
#define IMX943_CLK_M33SYSTICK       (IMX943_CCM_NUM_CLK_SRC + 14)
#define IMX943_CLK_PDM              (IMX943_CCM_NUM_CLK_SRC + 15)
#define IMX943_CLK_SAI1             (IMX943_CCM_NUM_CLK_SRC + 16)
#define IMX943_CLK_TPM2             (IMX943_CCM_NUM_CLK_SRC + 17)
#define IMX943_CLK_A55              (IMX943_CCM_NUM_CLK_SRC + 18)
#define IMX943_CLK_A55MTRBUS        (IMX943_CCM_NUM_CLK_SRC + 19)
#define IMX943_CLK_A55PERIPH        (IMX943_CCM_NUM_CLK_SRC + 20)
#define IMX943_CLK_DRAMALT          (IMX943_CCM_NUM_CLK_SRC + 21)
#define IMX943_CLK_DRAMAPB          (IMX943_CCM_NUM_CLK_SRC + 22)
#define IMX943_CLK_DISPAPB          (IMX943_CCM_NUM_CLK_SRC + 23)
#define IMX943_CLK_DISPAXI          (IMX943_CCM_NUM_CLK_SRC + 24)
#define IMX943_CLK_DISPPIX          (IMX943_CCM_NUM_CLK_SRC + 25)
#define IMX943_CLK_HSIOACSCAN480M   (IMX943_CCM_NUM_CLK_SRC + 26)
#define IMX943_CLK_HSIOACSCAN80M    (IMX943_CCM_NUM_CLK_SRC + 27)
#define IMX943_CLK_HSIO             (IMX943_CCM_NUM_CLK_SRC + 28)
#define IMX943_CLK_HSIOPCIEAUX      (IMX943_CCM_NUM_CLK_SRC + 29)
#define IMX943_CLK_HSIOPCIETEST160M (IMX943_CCM_NUM_CLK_SRC + 30)
#define IMX943_CLK_HSIOPCIETEST400M (IMX943_CCM_NUM_CLK_SRC + 31)
#define IMX943_CLK_HSIOPCIETEST500M (IMX943_CCM_NUM_CLK_SRC + 32)
#define IMX943_CLK_SIOPCIETEST50M   (IMX943_CCM_NUM_CLK_SRC + 33)
#define IMX943_CLK_SIOPCIETEST60M   (IMX943_CCM_NUM_CLK_SRC + 34)
#define IMX943_CLK_BUSM70           (IMX943_CCM_NUM_CLK_SRC + 35)
#define IMX943_CLK_M70              (IMX943_CCM_NUM_CLK_SRC + 36)
#define IMX943_CLK_M70SYSTICK       (IMX943_CCM_NUM_CLK_SRC + 37)
#define IMX943_CLK_BUSM71           (IMX943_CCM_NUM_CLK_SRC + 38)
#define IMX943_CLK_M71              (IMX943_CCM_NUM_CLK_SRC + 39)
#define IMX943_CLK_M71SYSTICK       (IMX943_CCM_NUM_CLK_SRC + 40)
#define IMX943_CLK_BUSNETCMIX       (IMX943_CCM_NUM_CLK_SRC + 41)
#define IMX943_CLK_ECAT             (IMX943_CCM_NUM_CLK_SRC + 42)
#define IMX943_CLK_ENET             (IMX943_CCM_NUM_CLK_SRC + 43)
#define IMX943_CLK_ENETPHYTEST200M  (IMX943_CCM_NUM_CLK_SRC + 44)
#define IMX943_CLK_ENETPHYTEST500M  (IMX943_CCM_NUM_CLK_SRC + 45)
#define IMX943_CLK_ENETPHYTEST667M  (IMX943_CCM_NUM_CLK_SRC + 46)
#define IMX943_CLK_ENETREF          (IMX943_CCM_NUM_CLK_SRC + 47)
#define IMX943_CLK_ENETTIMER1       (IMX943_CCM_NUM_CLK_SRC + 48)
#define IMX943_CLK_ENETTIMER2       (IMX943_CCM_NUM_CLK_SRC + 49)
#define IMX943_CLK_ENETTIMER3       (IMX943_CCM_NUM_CLK_SRC + 50)
#define IMX943_CLK_FLEXIO3          (IMX943_CCM_NUM_CLK_SRC + 51)
#define IMX943_CLK_FLEXIO4          (IMX943_CCM_NUM_CLK_SRC + 52)
#define IMX943_CLK_M33SYNC          (IMX943_CCM_NUM_CLK_SRC + 53)
#define IMX943_CLK_M33SYNCSYSTICK   (IMX943_CCM_NUM_CLK_SRC + 54)
#define IMX943_CLK_MAC0             (IMX943_CCM_NUM_CLK_SRC + 55)
#define IMX943_CLK_MAC1             (IMX943_CCM_NUM_CLK_SRC + 56)
#define IMX943_CLK_MAC2             (IMX943_CCM_NUM_CLK_SRC + 57)
#define IMX943_CLK_MAC3             (IMX943_CCM_NUM_CLK_SRC + 58)
#define IMX943_CLK_MAC4             (IMX943_CCM_NUM_CLK_SRC + 59)
#define IMX943_CLK_MAC5             (IMX943_CCM_NUM_CLK_SRC + 60)
#define IMX943_CLK_NOCAPB           (IMX943_CCM_NUM_CLK_SRC + 61)
#define IMX943_CLK_NOC              (IMX943_CCM_NUM_CLK_SRC + 62)
#define IMX943_CLK_NPUAPB           (IMX943_CCM_NUM_CLK_SRC + 63)
#define IMX943_CLK_NPU              (IMX943_CCM_NUM_CLK_SRC + 64)
#define IMX943_CLK_CCMCKO1          (IMX943_CCM_NUM_CLK_SRC + 65)
#define IMX943_CLK_CCMCKO2          (IMX943_CCM_NUM_CLK_SRC + 66)
#define IMX943_CLK_CCMCKO3          (IMX943_CCM_NUM_CLK_SRC + 67)
#define IMX943_CLK_CCMCKO4          (IMX943_CCM_NUM_CLK_SRC + 68)
#define IMX943_CLK_BISS             (IMX943_CCM_NUM_CLK_SRC + 69)
#define IMX943_CLK_BUSWAKEUP        (IMX943_CCM_NUM_CLK_SRC + 70)
#define IMX943_CLK_CAN2             (IMX943_CCM_NUM_CLK_SRC + 71)
#define IMX943_CLK_CAN3             (IMX943_CCM_NUM_CLK_SRC + 72)
#define IMX943_CLK_CAN4             (IMX943_CCM_NUM_CLK_SRC + 73)
#define IMX943_CLK_CAN5             (IMX943_CCM_NUM_CLK_SRC + 74)
#define IMX943_CLK_ENDAT21          (IMX943_CCM_NUM_CLK_SRC + 75)
#define IMX943_CLK_ENDAT22          (IMX943_CCM_NUM_CLK_SRC + 76)
#define IMX943_CLK_ENDAT31FAST      (IMX943_CCM_NUM_CLK_SRC + 77)
#define IMX943_CLK_ENDAT31SLOW      (IMX943_CCM_NUM_CLK_SRC + 78)
#define IMX943_CLK_FLEXIO1          (IMX943_CCM_NUM_CLK_SRC + 79)
#define IMX943_CLK_FLEXIO2          (IMX943_CCM_NUM_CLK_SRC + 80)
#define IMX943_CLK_GPT2             (IMX943_CCM_NUM_CLK_SRC + 81)
#define IMX943_CLK_GPT3             (IMX943_CCM_NUM_CLK_SRC + 82)
#define IMX943_CLK_GPT4             (IMX943_CCM_NUM_CLK_SRC + 83)
#define IMX943_CLK_HIPERFACE1       (IMX943_CCM_NUM_CLK_SRC + 84)
#define IMX943_CLK_HIPERFACE1SYNC   (IMX943_CCM_NUM_CLK_SRC + 85)
#define IMX943_CLK_HIPERFACE2       (IMX943_CCM_NUM_CLK_SRC + 86)
#define IMX943_CLK_HIPERFACE2SYNC   (IMX943_CCM_NUM_CLK_SRC + 87)
#define IMX943_CLK_I3C2SLOW         (IMX943_CCM_NUM_CLK_SRC + 88)
#define IMX943_CLK_LPI2C3           (IMX943_CCM_NUM_CLK_SRC + 89)
#define IMX943_CLK_LPI2C4           (IMX943_CCM_NUM_CLK_SRC + 90)
#define IMX943_CLK_LPI2C5           (IMX943_CCM_NUM_CLK_SRC + 91)
#define IMX943_CLK_LPI2C6           (IMX943_CCM_NUM_CLK_SRC + 92)
#define IMX943_CLK_LPI2C7           (IMX943_CCM_NUM_CLK_SRC + 93)
#define IMX943_CLK_LPI2C8           (IMX943_CCM_NUM_CLK_SRC + 94)
#define IMX943_CLK_LPSPI3           (IMX943_CCM_NUM_CLK_SRC + 95)
#define IMX943_CLK_LPSPI4           (IMX943_CCM_NUM_CLK_SRC + 96)
#define IMX943_CLK_LPSPI5           (IMX943_CCM_NUM_CLK_SRC + 97)
#define IMX943_CLK_LPSPI6           (IMX943_CCM_NUM_CLK_SRC + 98)
#define IMX943_CLK_LPSPI7           (IMX943_CCM_NUM_CLK_SRC + 99)
#define IMX943_CLK_LPSPI8           (IMX943_CCM_NUM_CLK_SRC + 100)
#define IMX943_CLK_LPTMR2           (IMX943_CCM_NUM_CLK_SRC + 101)
#define IMX943_CLK_LPUART10         (IMX943_CCM_NUM_CLK_SRC + 102)
#define IMX943_CLK_LPUART11         (IMX943_CCM_NUM_CLK_SRC + 103)
#define IMX943_CLK_LPUART12         (IMX943_CCM_NUM_CLK_SRC + 104)
#define IMX943_CLK_LPUART3          (IMX943_CCM_NUM_CLK_SRC + 105)
#define IMX943_CLK_LPUART4          (IMX943_CCM_NUM_CLK_SRC + 106)
#define IMX943_CLK_LPUART5          (IMX943_CCM_NUM_CLK_SRC + 107)
#define IMX943_CLK_LPUART6          (IMX943_CCM_NUM_CLK_SRC + 108)
#define IMX943_CLK_LPUART7          (IMX943_CCM_NUM_CLK_SRC + 109)
#define IMX943_CLK_LPUART8          (IMX943_CCM_NUM_CLK_SRC + 110)
#define IMX943_CLK_LPUART9          (IMX943_CCM_NUM_CLK_SRC + 111)
#define IMX943_CLK_SAI2             (IMX943_CCM_NUM_CLK_SRC + 112)
#define IMX943_CLK_SAI3             (IMX943_CCM_NUM_CLK_SRC + 113)
#define IMX943_CLK_SAI4             (IMX943_CCM_NUM_CLK_SRC + 114)
#define IMX943_CLK_SWOTRACE         (IMX943_CCM_NUM_CLK_SRC + 115)
#define IMX943_CLK_TPM4             (IMX943_CCM_NUM_CLK_SRC + 116)
#define IMX943_CLK_TPM5             (IMX943_CCM_NUM_CLK_SRC + 117)
#define IMX943_CLK_TPM6             (IMX943_CCM_NUM_CLK_SRC + 118)
#define IMX943_CLK_USBPHYBURUNIN    (IMX943_CCM_NUM_CLK_SRC + 119)
#define IMX943_CLK_USDHC1           (IMX943_CCM_NUM_CLK_SRC + 120)
#define IMX943_CLK_USDHC2           (IMX943_CCM_NUM_CLK_SRC + 121)
#define IMX943_CLK_USDHC3           (IMX943_CCM_NUM_CLK_SRC + 122)
#define IMX943_CLK_V2XPK            (IMX943_CCM_NUM_CLK_SRC + 123)
#define IMX943_CLK_WAKEUPAXI        (IMX943_CCM_NUM_CLK_SRC + 124)
#define IMX943_CLK_XSPISLVROOT      (IMX943_CCM_NUM_CLK_SRC + 125)
#define IMX943_CLK_XSPI1            (IMX943_CCM_NUM_CLK_SRC + 126)
#define IMX943_CLK_XSPI2            (IMX943_CCM_NUM_CLK_SRC + 127)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_IMX943_CLOCK_H_ */
