/*
 * Copyright (c) 2024 MASSDRIVER EI (massdriver.space)
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef __CH32V20X_V30X_CLOCKS_H__
#define __CH32V20X_V30X_CLOCKS_H__

#define CH32V20X_V30X_AHB_PCENR_OFFSET  0
#define CH32V20X_V30X_APB2_PCENR_OFFSET 1
#define CH32V20X_V30X_APB1_PCENR_OFFSET 2

#define CH32V20X_V30X_CLOCK_CONFIG(bus, bit) (((CH32V20X_V30X_##bus##_PCENR_OFFSET) << 5) | (bit))

#define CH32V20X_V30X_CLOCK_DMA1     CH32V20X_V30X_CLOCK_CONFIG(AHB, 0)
#define CH32V20X_V30X_CLOCK_DMA2     CH32V20X_V30X_CLOCK_CONFIG(AHB, 1)
#define CH32V20X_V30X_CLOCK_SRAM     CH32V20X_V30X_CLOCK_CONFIG(AHB, 2)
#define CH32V20X_V30X_CLOCK_FLITF    CH32V20X_V30X_CLOCK_CONFIG(AHB, 4)
#define CH32V20X_V30X_CLOCK_CRC      CH32V20X_V30X_CLOCK_CONFIG(AHB, 6)
#define CH32V20X_V30X_CLOCK_FSMC     CH32V20X_V30X_CLOCK_CONFIG(AHB, 8)
#define CH32V20X_V30X_CLOCK_RNG      CH32V20X_V30X_CLOCK_CONFIG(AHB, 9)
#define CH32V20X_V30X_CLOCK_SDIO     CH32V20X_V30X_CLOCK_CONFIG(AHB, 10)
#define CH32V20X_V30X_CLOCK_USBHS    CH32V20X_V30X_CLOCK_CONFIG(AHB, 11)
#define CH32V20X_V30X_CLOCK_OTG_FS   CH32V20X_V30X_CLOCK_CONFIG(AHB, 12)
#define CH32V20X_V30X_CLOCK_DVP      CH32V20X_V30X_CLOCK_CONFIG(AHB, 13)
#define CH32V20X_V30X_CLOCK_ETHMAC   CH32V20X_V30X_CLOCK_CONFIG(AHB, 14)
#define CH32V20X_V30X_CLOCK_ETHMACTX CH32V20X_V30X_CLOCK_CONFIG(AHB, 15)
#define CH32V20X_V30X_CLOCK_ETHMACRX CH32V20X_V30X_CLOCK_CONFIG(AHB, 16)
#define CH32V20X_V30X_CLOCK_BLEC     CH32V20X_V30X_CLOCK_CONFIG(AHB, 16)
#define CH32V20X_V30X_CLOCK_BLES     CH32V20X_V30X_CLOCK_CONFIG(AHB, 17)

#define CH32V20X_V30X_CLOCK_AFIO   CH32V20X_V30X_CLOCK_CONFIG(APB2, 0)
#define CH32V20X_V30X_CLOCK_IOPA   CH32V20X_V30X_CLOCK_CONFIG(APB2, 2)
#define CH32V20X_V30X_CLOCK_IOPB   CH32V20X_V30X_CLOCK_CONFIG(APB2, 3)
#define CH32V20X_V30X_CLOCK_IOPC   CH32V20X_V30X_CLOCK_CONFIG(APB2, 4)
#define CH32V20X_V30X_CLOCK_IOPD   CH32V20X_V30X_CLOCK_CONFIG(APB2, 5)
#define CH32V20X_V30X_CLOCK_IOPE   CH32V20X_V30X_CLOCK_CONFIG(APB2, 6)
#define CH32V20X_V30X_CLOCK_ADC1   CH32V20X_V30X_CLOCK_CONFIG(APB2, 9)
#define CH32V20X_V30X_CLOCK_ADC2   CH32V20X_V30X_CLOCK_CONFIG(APB2, 10)
#define CH32V20X_V30X_CLOCK_TIM1   CH32V20X_V30X_CLOCK_CONFIG(APB2, 11)
#define CH32V20X_V30X_CLOCK_SPI1   CH32V20X_V30X_CLOCK_CONFIG(APB2, 12)
#define CH32V20X_V30X_CLOCK_TIM8   CH32V20X_V30X_CLOCK_CONFIG(APB2, 13)
#define CH32V20X_V30X_CLOCK_USART1 CH32V20X_V30X_CLOCK_CONFIG(APB2, 14)
#define CH32V20X_V30X_CLOCK_TIM9   CH32V20X_V30X_CLOCK_CONFIG(APB2, 19)
#define CH32V20X_V30X_CLOCK_TIM10  CH32V20X_V30X_CLOCK_CONFIG(APB2, 20)

#define CH32V20X_V30X_CLOCK_TIM2   CH32V20X_V30X_CLOCK_CONFIG(APB1, 0)
#define CH32V20X_V30X_CLOCK_TIM3   CH32V20X_V30X_CLOCK_CONFIG(APB1, 1)
#define CH32V20X_V30X_CLOCK_TIM4   CH32V20X_V30X_CLOCK_CONFIG(APB1, 2)
#define CH32V20X_V30X_CLOCK_TIM5   CH32V20X_V30X_CLOCK_CONFIG(APB1, 3)
#define CH32V20X_V30X_CLOCK_TIM6   CH32V20X_V30X_CLOCK_CONFIG(APB1, 4)
#define CH32V20X_V30X_CLOCK_TIM7   CH32V20X_V30X_CLOCK_CONFIG(APB1, 5)
#define CH32V20X_V30X_CLOCK_USART6 CH32V20X_V30X_CLOCK_CONFIG(APB1, 6)
#define CH32V20X_V30X_CLOCK_USART7 CH32V20X_V30X_CLOCK_CONFIG(APB1, 7)
#define CH32V20X_V30X_CLOCK_USART8 CH32V20X_V30X_CLOCK_CONFIG(APB1, 8)
#define CH32V20X_V30X_CLOCK_WWDG   CH32V20X_V30X_CLOCK_CONFIG(APB1, 11)
#define CH32V20X_V30X_CLOCK_SPI2   CH32V20X_V30X_CLOCK_CONFIG(APB1, 14)
#define CH32V20X_V30X_CLOCK_SPI3   CH32V20X_V30X_CLOCK_CONFIG(APB1, 15)
#define CH32V20X_V30X_CLOCK_USART2 CH32V20X_V30X_CLOCK_CONFIG(APB1, 17)
#define CH32V20X_V30X_CLOCK_USART3 CH32V20X_V30X_CLOCK_CONFIG(APB1, 18)
#define CH32V20X_V30X_CLOCK_USART4 CH32V20X_V30X_CLOCK_CONFIG(APB1, 19)
#define CH32V20X_V30X_CLOCK_USART5 CH32V20X_V30X_CLOCK_CONFIG(APB1, 20)
#define CH32V20X_V30X_CLOCK_I2C1   CH32V20X_V30X_CLOCK_CONFIG(APB1, 21)
#define CH32V20X_V30X_CLOCK_I2C2   CH32V20X_V30X_CLOCK_CONFIG(APB1, 22)
#define CH32V20X_V30X_CLOCK_USBD   CH32V20X_V30X_CLOCK_CONFIG(APB1, 23)
#define CH32V20X_V30X_CLOCK_CAN1   CH32V20X_V30X_CLOCK_CONFIG(APB1, 25)
#define CH32V20X_V30X_CLOCK_CAN2   CH32V20X_V30X_CLOCK_CONFIG(APB1, 26)
#define CH32V20X_V30X_CLOCK_BKP    CH32V20X_V30X_CLOCK_CONFIG(APB1, 27)
#define CH32V20X_V30X_CLOCK_PWR    CH32V20X_V30X_CLOCK_CONFIG(APB1, 28)
#define CH32V20X_V30X_CLOCK_DAC    CH32V20X_V30X_CLOCK_CONFIG(APB1, 29)

#endif
