/*
 * Copyright (c) 2022 Aspeed Technology Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_AST10X0_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_AST10X0_H_

#define ASPEED_CLK_GRP_0_OFFSET		(0)
#define ASPEED_CLK_GRP_1_OFFSET		(32)
#define ASPEED_CLK_GRP_2_OFFSET		(64)

#define ASPEED_CLK_MCLK			(ASPEED_CLK_GRP_0_OFFSET + 0)
#define ASPEED_CLK_USB_DEVICE		(ASPEED_CLK_GRP_0_OFFSET + 7)
#define ASPEED_CLK_YCLK			(ASPEED_CLK_GRP_0_OFFSET + 13)

#define ASPEED_CLK_LCLK			(ASPEED_CLK_GRP_1_OFFSET + 0)
#define ASPEED_CLK_ESPI			(ASPEED_CLK_GRP_1_OFFSET + 1)
#define ASPEED_CLK_REFCLK		(ASPEED_CLK_GRP_1_OFFSET + 2)

#define ASPEED_CLK_LHCCLK		(ASPEED_CLK_GRP_1_OFFSET + 5)
#define ASPEED_CLK_RSACLK		(ASPEED_CLK_GRP_1_OFFSET + 6)

#define ASPEED_CLK_I3C0			(ASPEED_CLK_GRP_1_OFFSET + 8)
#define ASPEED_CLK_I3C1			(ASPEED_CLK_GRP_1_OFFSET + 9)
#define ASPEED_CLK_I3C2			(ASPEED_CLK_GRP_1_OFFSET + 10)
#define ASPEED_CLK_I3C3			(ASPEED_CLK_GRP_1_OFFSET + 11)

#define ASPEED_CLK_UART1		(ASPEED_CLK_GRP_1_OFFSET + 16)
#define ASPEED_CLK_UART2		(ASPEED_CLK_GRP_1_OFFSET + 17)
#define ASPEED_CLK_UART3		(ASPEED_CLK_GRP_1_OFFSET + 18)
#define ASPEED_CLK_UART4		(ASPEED_CLK_GRP_1_OFFSET + 19)
#define ASPEED_CLK_MAC			(ASPEED_CLK_GRP_1_OFFSET + 20)

#define ASPEED_CLK_UART6		(ASPEED_CLK_GRP_1_OFFSET + 22)
#define ASPEED_CLK_UART7		(ASPEED_CLK_GRP_1_OFFSET + 23)
#define ASPEED_CLK_UART8		(ASPEED_CLK_GRP_1_OFFSET + 24)
#define ASPEED_CLK_UART9		(ASPEED_CLK_GRP_1_OFFSET + 25)
#define ASPEED_CLK_UART10		(ASPEED_CLK_GRP_1_OFFSET + 26)
#define ASPEED_CLK_UART11		(ASPEED_CLK_GRP_1_OFFSET + 27)
#define ASPEED_CLK_UART12		(ASPEED_CLK_GRP_1_OFFSET + 28)
#define ASPEED_CLK_UART13		(ASPEED_CLK_GRP_1_OFFSET + 29)

#define ASPEED_CLK_PCLK			(ASPEED_CLK_GRP_2_OFFSET + 0)
#define ASPEED_CLK_HCLK			(ASPEED_CLK_GRP_2_OFFSET + 1)
#define ASPEED_CLK_UART5		(ASPEED_CLK_GRP_2_OFFSET + 2)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_CLOCK_AST10X0_H_ */
