# SPDX-License-Identifier: Apache-2.0
# The contents of this file is based on include/zephyr/linker/common-rom.ld
# and som of include/zephyr/linker/common-rom/*.ld
# Please keep in sync

zephyr_linker_section(NAME init KVMA RAM_REGION GROUP RODATA_REGION)
zephyr_linker_section_obj_level(SECTION init LEVEL EARLY)
zephyr_linker_section_obj_level(SECTION init LEVEL PRE_KERNEL_1)
zephyr_linker_section_obj_level(SECTION init LEVEL PRE_KERNEL_2)
zephyr_linker_section_obj_level(SECTION init LEVEL POST_KERNEL)
zephyr_linker_section_obj_level(SECTION init LEVEL APPLICATION)
zephyr_linker_section_obj_level(SECTION init LEVEL SMP)

zephyr_iterable_section(NAME device NUMERIC KVMA RAM_REGION GROUP RODATA_REGION)

if(CONFIG_GEN_SW_ISR_TABLE AND NOT CONFIG_SRAM_SW_ISR_TABLE)
  # ld align has been changed to subalign to provide identical behavior scatter vs. ld.
  zephyr_linker_section(NAME sw_isr_table KVMA FLASH GROUP RODATA_REGION NOINPUT)
  zephyr_linker_section_configure(
    SECTION sw_isr_table
    INPUT ".gnu.linkonce.sw_isr_table*"
  )
  if(CONFIG_SHARED_INTERRUPTS)
    zephyr_linker_section_configure(
      SECTION sw_isr_table
      INPUT ".gnu.linkonce.shared_sw_isr_table*"
    )
  endif()
endif()

zephyr_linker_section(NAME initlevel_error KVMA RAM_REGION GROUP RODATA_REGION NOINPUT)
zephyr_linker_section_configure(SECTION initlevel_error INPUT ".z_init_*" KEEP SORT NAME)
# How to do cross linker ?
# ASSERT(SIZEOF(initlevel_error) == 0, "Undefined initialization levels used.")


if(CONFIG_CPP)
  zephyr_linker_section(NAME ctors KVMA RAM_REGION GROUP RODATA_REGION NOINPUT)
  #
  # The compiler fills the constructor pointers table below,
  # hence symbol __CTOR_LIST__ must be aligned on word
  # boundary. To align with the C++ standard, the first element
  # of the array contains the number of actual constructors. The
  # last element is NULL.
  #
# ToDo: Checkup on scatter loading. How to manage ?
# https://www.keil.com/support/man/docs/armlink/armlink_pge1362066006368.htm
# https://developer.arm.com/documentation/dui0378/g/The-ARM-C-and-C---Libraries
#  if(CONFIG_64BIT)
#		. = ALIGN(8);
#		__CTOR_LIST__ = .;
#		QUAD((__CTOR_END__ - __CTOR_LIST__) / 8 - 2)
#		KEEP(*(SORT_BY_NAME(".ctors*")))
#		QUAD(0)
#		__CTOR_END__ = .;
#  else()
#		. = ALIGN(4);
#		__CTOR_LIST__ = .;
#		LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
#		KEEP(*(SORT_BY_NAME(".ctors*")))
#		LONG(0)
#		__CTOR_END__ = .;
#  endif()
#	} GROUP_ROM_LINK_IN(RAMABLE_REGION, ROMABLE_REGION)
#
#	SECTION_PROLOGUE(init_array,,)
#	{
#		. = ALIGN(4);
#		__init_array_start = .;
#		KEEP(*(SORT_BY_NAME(".init_array*")))
#		__init_array_end = .;
#	} GROUP_ROM_LINK_IN(RAMABLE_REGION, ROMABLE_REGION)
endif()

if(CONFIG_USERSPACE)
  # Build-time assignment of permissions to kernel objects to
  # threads declared with K_THREAD_DEFINE()
  zephyr_iterable_section(NAME k_object_assignment VMA FLASH)
endif()

zephyr_linker_section(
  NAME app_shmem_regions
  KVMA RAM_REGION GROUP RODATA_REGION NOINPUT ${XIP_ALIGN_WITH_INPUT}
)
zephyr_linker_section_configure(
  SECTION app_shmem_regions
  INPUT ".app_regions.*"
  KEEP SORT NAME
)

if(CONFIG_NETWORKING)
  zephyr_iterable_section(NAME net_l3_register KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_NET_SOCKETS)
  zephyr_iterable_section(NAME net_socket_register KVMA RAM_REGION GROUP RODATA_REGION)
endif()


if(CONFIG_NET_L2_PPP)
  zephyr_iterable_section(NAME ppp_protocol_handler KVMA RAM_REGION GROUP RODATA_REGION)
endif()

zephyr_iterable_section(NAME bt_l2cap_fixed_chan KVMA RAM_REGION GROUP RODATA_REGION)

if(CONFIG_BT_CLASSIC)
  zephyr_iterable_section(NAME bt_l2cap_br_fixed_chan KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_BT_CONN)
  zephyr_iterable_section(NAME bt_conn_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

zephyr_iterable_section(NAME bt_gatt_service_static KVMA RAM_REGION GROUP RODATA_REGION)

if(CONFIG_BT_MESH)
  zephyr_iterable_section(NAME bt_mesh_subnet_cb KVMA RAM_REGION GROUP RODATA_REGION)
  zephyr_iterable_section(NAME bt_mesh_app_key_cb KVMA RAM_REGION GROUP RODATA_REGION)

  zephyr_iterable_section(NAME bt_mesh_hb_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_BT_MESH_FRIEND)
  zephyr_iterable_section(NAME bt_mesh_friend_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_BT_MESH_LOW_POWER)
  zephyr_iterable_section(NAME bt_mesh_lpn_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_BT_MESH_PROXY)
  zephyr_iterable_section(NAME bt_mesh_proxy_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_EC_HOST_CMD)
  zephyr_iterable_section(NAME ec_host_cmd_handler KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_SETTINGS)
  zephyr_iterable_section(NAME settings_handler_static KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_SENSING)
  zephyr_iterable_section(NAME sensing_sensor_info KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_SENSOR_INFO)
  zephyr_iterable_section(NAME sensor_info KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_SENSOR_ASYNC_API)
  zephyr_iterable_section(NAME sensor_decoder_api KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_ADC_STREAM)
  zephyr_iterable_section(NAME adc_decoder_api KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_MCUMGR)
  zephyr_iterable_section(NAME mcumgr_handler KVMA RAM_REGION GROUP RODATA_REGION)
endif()

zephyr_iterable_section(NAME k_p4wq_initparam KVMA RAM_REGION GROUP RODATA_REGION)

if(CONFIG_EMUL)
  zephyr_iterable_section(NAME emul KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_DNS_SD)
  zephyr_iterable_section(NAME dns_sd_rec KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_PCIE)
  zephyr_iterable_section(NAME irq_alloc KVMA RAM_REGION GROUP RODATA_REGION)
endif()

zephyr_iterable_section(NAME log_strings KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME log_const KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_linker_section(NAME symbol_to_keep GROUP RODATA_REGION NOINPUT)
zephyr_linker_section_configure(SECTION symbol_to_keep INPUT ".symbol_to_keep*" KEEP SORT NAME)

zephyr_iterable_section(NAME shell KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME shell_root_cmds KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME shell_subcmds KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME shell_dynamic_subcmds KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME cfb_font KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_iterable_section(NAME tracing_backend KVMA RAM_REGION GROUP RODATA_REGION)

zephyr_linker_section(NAME zephyr_dbg_info KVMA RAM_REGION GROUP RODATA_REGION NOINPUT ${XIP_ALIGN_WITH_INPUT})
zephyr_linker_section_configure(SECTION zephyr_dbg_info INPUT ".dbg_thread_info" KEEP)

if(CONFIG_SYMTAB)
  zephyr_linker_section(NAME symtab KVMA FLASH GROUP RODATA_REGION NOINPUT)
  zephyr_linker_section_configure(SECTION symtab INPUT ".gnu.linkonce.symtab*")
endif()

if(CONFIG_DEVICE_DEPS)
  zephyr_linker_section(NAME device_deps KVMA RAM_REGION GROUP RODATA_REGION NOINPUT ${XIP_ALIGN_WITH_INPUT} ENDALIGN 16)
  zephyr_linker_section_configure(SECTION device_deps INPUT .__device_deps_pass1* KEEP SORT NAME PASS LINKER_DEVICE_DEPS_PASS1)
  zephyr_linker_section_configure(SECTION device_deps INPUT .__device_deps_pass2* KEEP SORT NAME PASS NOT LINKER_DEVICE_DEPS_PASS1)
endif()

zephyr_iterable_section(NAME _static_thread_data KVMA RAM_REGION GROUP RODATA_REGION)

if(CONFIG_BT_IAS)
  zephyr_iterable_section(NAME bt_ias_cb KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_LOG)
  zephyr_iterable_section(NAME log_link KVMA RAM_REGION GROUP RODATA_REGION)
  zephyr_iterable_section(NAME log_backend KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_MULTI_LEVEL_INTERRUPTS)
  zephyr_iterable_section(NAME intc_table KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_HTTP_SERVER)
  zephyr_iterable_section(NAME http_service_desc KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_COAP_SERVER)
  zephyr_iterable_section(NAME coap_service KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_NET_MGMT)
  zephyr_iterable_section(NAME net_mgmt_event_static_handler KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_NET_SOCKETS_SERVICE)
  zephyr_iterable_section(NAME net_socket_service_desc
                          KVMA RAM_REGION GROUP RODATA_REGION
  )
endif()

if(CONFIG_INPUT)
  zephyr_iterable_section(NAME input_callback KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_USBD_MSC_CLASS)
  zephyr_iterable_section(NAME usbd_msc_lun KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_ZTEST)
  zephyr_iterable_section(NAME ztest_expected_result_entry KVMA RAM_REGION GROUP RODATA_REGION ${XIP_ALIGN_WITH_INPUT})
  zephyr_iterable_section(NAME ztest_suite_node KVMA RAM_REGION GROUP RODATA_REGION ${XIP_ALIGN_WITH_INPUT})
  zephyr_iterable_section(NAME ztest_unit_test KVMA RAM_REGION GROUP RODATA_REGION ${XIP_ALIGN_WITH_INPUT})
  zephyr_iterable_section(NAME ztest_test_rule KVMA RAM_REGION GROUP RODATA_REGION ${XIP_ALIGN_WITH_INPUT})
endif()

if(CONFIG_ZBUS)
  zephyr_iterable_section(NAME zbus_channel KVMA RAM_REGION GROUP RODATA_REGION)
  zephyr_iterable_section(NAME zbus_observer KVMA RAM_REGION GROUP RODATA_REGION)
  zephyr_iterable_section(NAME zbus_channel_observation KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_GNSS)
  zephyr_iterable_section(NAME gnss_data_callback KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_GNSS_SATELLITES)
  zephyr_iterable_section(NAME gnss_satellites_callback KVMA RAM_REGION GROUP RODATA_REGION)
endif()

if(CONFIG_GNSS_RTK)
  zephyr_iterable_section(NAME gnss_rtk_data_callback KVMA RAM_REGION GROUP RODATA_REGION)
endif()
