/*
 * Copyright 2018-2022 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mcxn_flexspi_nor_config.h"

__attribute__((section(".flexspi_fcb"), used))

#ifndef FLEXSPI_USE_CUSTOM_FCB
#define FLEXSPI_USE_CUSTOM_FCB (0)
#endif

#if FLEXSPI_USE_CUSTOM_FCB
/* FCB for W25Q64 */
const uint8_t CUSTOM_FCB[] = {
	0x46, 0x43, 0x46, 0x42, 0x00, 0x04, 0x01, 0x56, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
	0x00, 0x00, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xeb, 0x04, 0x18, 0x0a,
	0x06, 0x32, 0x04, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x05, 0x04, 0x04, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
	0x04, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xd8, 0x04, 0x18, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x18,
	0x08, 0x04, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x10, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#else

/* FCB for W25Q64 */
const flexspi_nor_image_config image_config = {
	.image_version = 0xFFFE0001u,
	.fcb_config = {
		.mem_config = {
			.tag = FLEXSPI_CFG_BLK_TAG,
			.version = FLEXSPI_CFG_BLK_VERSION,
			.read_sample_clk_src =
					FLEXSPI_READ_SAMPLE_CLK_LOOPBACK_FROM_DQS_PAD,
			.cs_hold_time = 3u,
			.cs_setup_time = 3u,
			/* Enable DDR mode, Wordaddassable, Safe */
			/* configuration, Differential clock */
			.controller_misc_option =
			(1u << FLEXSPI_MISC_OFFSET_SAFE_CONFIG_FREQ_ENABLE),
			.device_type = FLEXSPI_DEVICE_TYPE_SERIAL_NOR,
			.sflash_pad_type = SERIAL_FLASH_4_PADS,
			.serial_clk_freq = FLEXSPI_SERIAL_CLK_75MHZ,
			.sflash_a1_size = 8u * 1024u * 1024u,
			.lookup_table = {
				/* Read LUTs */
				[0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0xEB,
					RADDR_SDR, FLEXSPI_4PAD,
					0x18),
				[1] = FLEXSPI_LUT_SEQ(DUMMY_SDR,
					FLEXSPI_4PAD, 0x06,
					READ_SDR, FLEXSPI_4PAD,
					0x04),

				/* Read Status LUTs */
				[4 * 1 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0x05, READ_SDR,
					FLEXSPI_1PAD, 0x04),

				/* Write Enable LUTs */
				[4 * 3 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0x06, STOP,
					FLEXSPI_1PAD, 0x0),

				/* Erase Sector LUTs */
				[4 * 5 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0x20, RADDR_SDR,
					FLEXSPI_1PAD, 0x18),

				/* Erase Block LUTs */
				[4 * 8 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0xD8, RADDR_SDR,
					FLEXSPI_1PAD, 0x18),

				/* Pape Program LUTs */
				[4 * 9 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0x02, RADDR_SDR,
					FLEXSPI_1PAD, 0x18),
				[4 * 9 + 1] = FLEXSPI_LUT_SEQ(WRITE_SDR,
					FLEXSPI_1PAD, 0x04, STOP,
					FLEXSPI_1PAD, 0x0),

				/* Erase Chip LUTs */
				[4 * 11 + 0] = FLEXSPI_LUT_SEQ(CMD_SDR,
					FLEXSPI_1PAD, 0x60, STOP,
					FLEXSPI_1PAD, 0x0),
			},
		},
		.page_size = 256u,
		.sector_size = 4u * 1024u,
		.ipcmd_serial_clk_freq = 1u,
		.block_size = 64u * 1024u,
		.is_uniform_block_size = false,
	}
};

#endif
