/*
 * Copyright (c) 2025 Silicon Laboratories Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/* Vector table is not necessarily at the start of the RAM region: in the case where Zephyr code
 * relocation is used, the vector table is placed after the relocated code.
 * Relocated code is always placed at the start of the RAM SECTION because of the hard-coded value
 * generated by "gen_relocate_app.py" in the file. It can create quite a big gap and lose about the
 * size of alignment in RAM space.
 */

SECTION_PROLOGUE(.sram_vt,,)
{
	/* Heritage of vector table alignment in flash (see vector_table.ld in arch/arm/core/) */
#if defined(CONFIG_ARMV6_M_ARMV8_M_BASELINE)
	. = ALIGN( 1 << LOG2CEIL(4 * 64) );
#elif defined(CONFIG_ARMV7_M_ARMV8_M_MAINLINE)
	. = ALIGN( 1 << LOG2CEIL(4 * 32) );
#else
#error "Unsupported architecture variant"
#endif

	. = ALIGN( 1 << LOG2CEIL(4 * (16 + CONFIG_NUM_IRQS)) );

	_sram_vector_start = .;
	. += _vector_end - _vector_start;
	MPU_ALIGN(_sram_vector_size);
	_sram_vector_end = .;
#if defined(CONFIG_ARM_VECTOR_TABLE_ITCM)
} GROUP_DATA_LINK_IN(ITCM, ROMABLE_REGION)
#elif defined(CONFIG_ARM_VECTOR_TABLE_DTCM)
} GROUP_DATA_LINK_IN(DTCM, ROMABLE_REGION)
#else
} GROUP_DATA_LINK_IN(RAMABLE_REGION, ROMABLE_REGION)
#endif
_sram_vector_size = _sram_vector_end - _sram_vector_start;
