static const uint32_t in_cfft_noisy_16[32] = {
    0xbd2c51f4, 0x0, 0x3efba81f, 0x0,
    0x3f394c4c, 0x0, 0x3f13ead6, 0x0,
    0x3c74abe0, 0x0, 0xbed34803, 0x0,
    0xbf38fe14, 0x0, 0xbeefdab0, 0x0,
    0x3cc6f2eb, 0x0, 0x3ef825ca, 0x0,
    0x3f2ab374, 0x0, 0x3effffb1, 0x0,
    0xbbe63a4a, 0x0, 0xbefe8ffa, 0x0,
    0xbf380fc4, 0x0, 0xbf006c31, 0x0
    };

static const uint32_t in_cifft_noisy_16[32] = {
    0x3de7b5a7, 0x0, 0xbd4e4efb, 0xbe666912,
    0xbe0f8695, 0xc0b3a58e, 0xbde7a450, 0x3c191943,
    0x3d286cbf, 0x3d2962f0, 0xbdd7d4dc, 0x3d279c7e,
    0x3db5d0fc, 0x3d4eebd9, 0x3b613ac0, 0xbdd8428b,
    0xbe708603, 0x0, 0x3b613ac0, 0x3dd8428b,
    0x3db5d0fc, 0xbd4eebd9, 0xbdd7d4dc, 0xbd279c7e,
    0x3d286cbf, 0xbd2962f0, 0xbde7a450, 0xbc191943,
    0xbe0f8695, 0x40b3a58e, 0xbd4e4efb, 0x3e666912
    };

static const uint32_t ref_cfft_noisy_16[32] = {
    0x3de7b5a7, 0x0, 0xbd4e4efb, 0xbe666912,
    0xbe0f8695, 0xc0b3a58e, 0xbde7a450, 0x3c191943,
    0x3d286cbf, 0x3d2962f0, 0xbdd7d4dc, 0x3d279c7e,
    0x3db5d0fc, 0x3d4eebd9, 0x3b613ac0, 0xbdd8428b,
    0xbe708603, 0x0, 0x3b613ac0, 0x3dd8428b,
    0x3db5d0fc, 0xbd4eebd9, 0xbdd7d4dc, 0xbd279c7e,
    0x3d286cbf, 0xbd2962f0, 0xbde7a450, 0xbc191943,
    0xbe0f8695, 0x40b3a58e, 0xbd4e4efb, 0x3e666912
    };

static const uint32_t in_cfft_noisy_32[64] = {
    0x3d4488bd, 0x0, 0x3eee16f4, 0x0,
    0x3f44a9f9, 0x0, 0x3ef1b2dc, 0x0,
    0xbd7df235, 0x0, 0xbef74e08, 0x0,
    0xbf30d013, 0x0, 0xbef828a4, 0x0,
    0xbda55c29, 0x0, 0x3f13dc88, 0x0,
    0x3f39b271, 0x0, 0x3f04f489, 0x0,
    0xbddaa990, 0x0, 0xbeef9469, 0x0,
    0xbf36936d, 0x0, 0xbf04c5e0, 0x0,
    0x3d282c59, 0x0, 0x3ee5cc2f, 0x0,
    0x3f327521, 0x0, 0x3eead49b, 0x0,
    0xbda3eef9, 0x0, 0xbf036c38, 0x0,
    0xbf3c329c, 0x0, 0xbed84f0b, 0x0,
    0x3d3e582d, 0x0, 0x3f0b7949, 0x0,
    0x3f2f1147, 0x0, 0x3eecc652, 0x0,
    0x3d185c7c, 0x0, 0xbee8a2da, 0x0,
    0xbf13b4a3, 0x0, 0xbf015ee5, 0x0
    };

static const uint32_t in_cifft_noisy_32[64] = {
    0x3dce2251, 0x0, 0x3eaa1a3e, 0x3df0bf58,
    0xbd06e1c5, 0x3e8f19ba, 0x3d894baf, 0x3c42f1aa,
    0x3eb0a960, 0xc131ae10, 0xbe8e9453, 0x3e6c4ff9,
    0xbe21d769, 0x3ca90fcd, 0xbc19571c, 0xbea7ed73,
    0xbea17e63, 0xbe0b76ce, 0xbe083833, 0x3e5ab8ad,
    0x3e08b5f9, 0x3d594396, 0xbdb861c8, 0xbd01b753,
    0x3e403b1e, 0x3d9bd13f, 0xbe042d94, 0xbdc86356,
    0x3f0cfbc7, 0x3cb446e8, 0x3e97999c, 0xbe52d0b5,
    0xbdc712ec, 0x0, 0x3e97999c, 0x3e52d0b5,
    0x3f0cfbc7, 0xbcb446e8, 0xbe042d94, 0x3dc86356,
    0x3e403b1e, 0xbd9bd13f, 0xbdb861c8, 0x3d01b753,
    0x3e08b5f9, 0xbd594396, 0xbe083833, 0xbe5ab8ad,
    0xbea17e63, 0x3e0b76ce, 0xbc19571c, 0x3ea7ed73,
    0xbe21d769, 0xbca90fcd, 0xbe8e9453, 0xbe6c4ff9,
    0x3eb0a960, 0x4131ae10, 0x3d894baf, 0xbc42f1aa,
    0xbd06e1c5, 0xbe8f19ba, 0x3eaa1a3e, 0xbdf0bf58
    };

static const uint32_t ref_cfft_noisy_32[64] = {
    0x3dce2251, 0x0, 0x3eaa1a3e, 0x3df0bf58,
    0xbd06e1c5, 0x3e8f19ba, 0x3d894baf, 0x3c42f1aa,
    0x3eb0a960, 0xc131ae10, 0xbe8e9453, 0x3e6c4ff9,
    0xbe21d769, 0x3ca90fcd, 0xbc19571c, 0xbea7ed73,
    0xbea17e63, 0xbe0b76ce, 0xbe083833, 0x3e5ab8ad,
    0x3e08b5f9, 0x3d594396, 0xbdb861c8, 0xbd01b753,
    0x3e403b1e, 0x3d9bd13f, 0xbe042d94, 0xbdc86356,
    0x3f0cfbc7, 0x3cb446e8, 0x3e97999c, 0xbe52d0b5,
    0xbdc712ec, 0x0, 0x3e97999c, 0x3e52d0b5,
    0x3f0cfbc7, 0xbcb446e8, 0xbe042d94, 0x3dc86356,
    0x3e403b1e, 0xbd9bd13f, 0xbdb861c8, 0x3d01b753,
    0x3e08b5f9, 0xbd594396, 0xbe083833, 0xbe5ab8ad,
    0xbea17e63, 0x3e0b76ce, 0xbc19571c, 0x3ea7ed73,
    0xbe21d769, 0xbca90fcd, 0xbe8e9453, 0xbe6c4ff9,
    0x3eb0a960, 0x4131ae10, 0x3d894baf, 0xbc42f1aa,
    0xbd06e1c5, 0xbe8f19ba, 0x3eaa1a3e, 0xbdf0bf58
    };

static const uint32_t in_cfft_noisy_64[128] = {
    0xbd0cf9f7, 0x0, 0x3f04f199, 0x0,
    0x3f2d82ee, 0x0, 0x3ee41382, 0x0,
    0xbc31696e, 0x0, 0xbf044b53, 0x0,
    0xbf26d040, 0x0, 0xbef9997b, 0x0,
    0x3de6d4be, 0x0, 0x3f058a0c, 0x0,
    0x3f3fbe5b, 0x0, 0x3ee43bf2, 0x0,
    0xbcd26f29, 0x0, 0xbf005703, 0x0,
    0xbf2d23de, 0x0, 0xbee17ed7, 0x0,
    0x3d19a5bf, 0x0, 0x3eef53dc, 0x0,
    0x3f3609b5, 0x0, 0x3ef338af, 0x0,
    0x3d30d681, 0x0, 0xbef50893, 0x0,
    0xbf2e0473, 0x0, 0xbefb4e13, 0x0,
    0x3ca9de70, 0x0, 0x3f097537, 0x0,
    0x3f2ed868, 0x0, 0x3ef0d7da, 0x0,
    0xbc61b308, 0x0, 0xbf0378df, 0x0,
    0xbf324445, 0x0, 0xbecd8380, 0x0,
    0xbc628f0b, 0x0, 0x3efbc23b, 0x0,
    0x3f503bc7, 0x0, 0x3f01a348, 0x0,
    0xbd013000, 0x0, 0xbf015e40, 0x0,
    0xbf40c239, 0x0, 0xbf070ac0, 0x0,
    0xbc0ac340, 0x0, 0x3ee8955c, 0x0,
    0x3f2ced08, 0x0, 0x3ef6ca81, 0x0,
    0x3da147d3, 0x0, 0xbee349c3, 0x0,
    0xbf31f764, 0x0, 0xbef9e30c, 0x0,
    0x3d03510d, 0x0, 0x3f0459f3, 0x0,
    0x3f2d1d26, 0x0, 0x3f18bb9b, 0x0,
    0xbda9fa8f, 0x0, 0xbeea19d5, 0x0,
    0xbf2f2a0e, 0x0, 0xbee266d2, 0x0,
    0xbd7a9c62, 0x0, 0x3ee93531, 0x0,
    0x3f38842f, 0x0, 0x3eca7766, 0x0,
    0x39d4b249, 0x0, 0xbec602a4, 0x0,
    0xbf377cb7, 0x0, 0xbf0eaf6c, 0x0
    };

static const uint32_t in_cifft_noisy_64[128] = {
    0x3ead3ec0, 0x0, 0xbe044470, 0xbe26e961,
    0xbe9644be, 0xbcf4ca4e, 0xbe8bbab0, 0xbea04f4d,
    0x3e469666, 0xbca9706f, 0xbedced86, 0x3eb784f4,
    0x3e51ac4e, 0x3c297785, 0xbcf7f85c, 0x3f167b7c,
    0x3e55daf0, 0xc1b14e6a, 0x3d4e4948, 0xbe2a1eb1,
    0xbe2565e7, 0xbe673db0, 0xbee4b0ef, 0xbde4c374,
    0xbeb2ce39, 0xbdbdd873, 0x3eb92c3d, 0xbe82aba5,
    0xbe602070, 0xbd3c01e4, 0xbccfd965, 0xbe8a7b1a,
    0xbde33a4e, 0xbe36b9f2, 0xbd8b675b, 0xbeb4c13e,
    0xbe3ad923, 0xbeb3b366, 0x3eda0378, 0xbf16d69f,
    0x3e5d16bd, 0x3e7ab4d3, 0x3eafab32, 0xbdba3e25,
    0xbe0cd8f8, 0x3e83af4a, 0x3e14c5e7, 0xbe378772,
    0x3d3e05f0, 0x3eb690a9, 0x3db2e850, 0x3d8cda06,
    0xbe3a3ae9, 0x3dc33057, 0xbf1060a5, 0xbe3af6db,
    0xbe6c0320, 0xbe2ecaae, 0x3e4a6824, 0xbdd426af,
    0x3ce93be6, 0x3ed95840, 0x3cdf2055, 0x3ee1cb69,
    0x3d5d347a, 0x0, 0x3cdf2055, 0xbee1cb69,
    0x3ce93be6, 0xbed95840, 0x3e4a6824, 0x3dd426af,
    0xbe6c0320, 0x3e2ecaae, 0xbf1060a5, 0x3e3af6db,
    0xbe3a3ae9, 0xbdc33057, 0x3db2e850, 0xbd8cda06,
    0x3d3e05f0, 0xbeb690a9, 0x3e14c5e7, 0x3e378772,
    0xbe0cd8f8, 0xbe83af4a, 0x3eafab32, 0x3dba3e25,
    0x3e5d16bd, 0xbe7ab4d3, 0x3eda0378, 0x3f16d69f,
    0xbe3ad923, 0x3eb3b366, 0xbd8b675b, 0x3eb4c13e,
    0xbde33a4e, 0x3e36b9f2, 0xbccfd965, 0x3e8a7b1a,
    0xbe602070, 0x3d3c01e4, 0x3eb92c3d, 0x3e82aba5,
    0xbeb2ce39, 0x3dbdd873, 0xbee4b0ef, 0x3de4c374,
    0xbe2565e7, 0x3e673db0, 0x3d4e4948, 0x3e2a1eb1,
    0x3e55daf0, 0x41b14e6a, 0xbcf7f85c, 0xbf167b7c,
    0x3e51ac4e, 0xbc297785, 0xbedced86, 0xbeb784f4,
    0x3e469666, 0x3ca9706f, 0xbe8bbab0, 0x3ea04f4d,
    0xbe9644be, 0x3cf4ca4e, 0xbe044470, 0x3e26e961
    };

static const uint32_t ref_cfft_noisy_64[128] = {
    0x3ead3ec0, 0x0, 0xbe044470, 0xbe26e961,
    0xbe9644be, 0xbcf4ca4e, 0xbe8bbab0, 0xbea04f4d,
    0x3e469666, 0xbca9706f, 0xbedced86, 0x3eb784f4,
    0x3e51ac4e, 0x3c297785, 0xbcf7f85c, 0x3f167b7c,
    0x3e55daf0, 0xc1b14e6a, 0x3d4e4948, 0xbe2a1eb1,
    0xbe2565e7, 0xbe673db0, 0xbee4b0ef, 0xbde4c374,
    0xbeb2ce39, 0xbdbdd873, 0x3eb92c3d, 0xbe82aba5,
    0xbe602070, 0xbd3c01e4, 0xbccfd965, 0xbe8a7b1a,
    0xbde33a4e, 0xbe36b9f2, 0xbd8b675b, 0xbeb4c13e,
    0xbe3ad923, 0xbeb3b366, 0x3eda0378, 0xbf16d69f,
    0x3e5d16bd, 0x3e7ab4d3, 0x3eafab32, 0xbdba3e25,
    0xbe0cd8f8, 0x3e83af4a, 0x3e14c5e7, 0xbe378772,
    0x3d3e05f0, 0x3eb690a9, 0x3db2e850, 0x3d8cda06,
    0xbe3a3ae9, 0x3dc33057, 0xbf1060a5, 0xbe3af6db,
    0xbe6c0320, 0xbe2ecaae, 0x3e4a6824, 0xbdd426af,
    0x3ce93be6, 0x3ed95840, 0x3cdf2055, 0x3ee1cb69,
    0x3d5d347a, 0x0, 0x3cdf2055, 0xbee1cb69,
    0x3ce93be6, 0xbed95840, 0x3e4a6824, 0x3dd426af,
    0xbe6c0320, 0x3e2ecaae, 0xbf1060a5, 0x3e3af6db,
    0xbe3a3ae9, 0xbdc33057, 0x3db2e850, 0xbd8cda06,
    0x3d3e05f0, 0xbeb690a9, 0x3e14c5e7, 0x3e378772,
    0xbe0cd8f8, 0xbe83af4a, 0x3eafab32, 0x3dba3e25,
    0x3e5d16bd, 0xbe7ab4d3, 0x3eda0378, 0x3f16d69f,
    0xbe3ad923, 0x3eb3b366, 0xbd8b675b, 0x3eb4c13e,
    0xbde33a4e, 0x3e36b9f2, 0xbccfd965, 0x3e8a7b1a,
    0xbe602070, 0x3d3c01e4, 0x3eb92c3d, 0x3e82aba5,
    0xbeb2ce39, 0x3dbdd873, 0xbee4b0ef, 0x3de4c374,
    0xbe2565e7, 0x3e673db0, 0x3d4e4948, 0x3e2a1eb1,
    0x3e55daf0, 0x41b14e6a, 0xbcf7f85c, 0xbf167b7c,
    0x3e51ac4e, 0xbc297785, 0xbedced86, 0xbeb784f4,
    0x3e469666, 0x3ca9706f, 0xbe8bbab0, 0x3ea04f4d,
    0xbe9644be, 0x3cf4ca4e, 0xbe044470, 0x3e26e961
    };

static const uint32_t in_cfft_noisy_128[256] = {
    0xbc12ae1b, 0x0, 0x3f07b364, 0x0,
    0x3f29406d, 0x0, 0x3f0287cc, 0x0,
    0xbcb3028c, 0x0, 0xbee3cbac, 0x0,
    0xbf35145f, 0x0, 0xbee4fa07, 0x0,
    0xbb91f86f, 0x0, 0x3ef1da11, 0x0,
    0x3f366b3b, 0x0, 0x3f0e6f93, 0x0,
    0x3d530112, 0x0, 0xbee93419, 0x0,
    0xbf2a55f4, 0x0, 0xbeee1fd4, 0x0,
    0xbcd8a6cf, 0x0, 0x3f053d81, 0x0,
    0x3f35a150, 0x0, 0x3efd50ed, 0x0,
    0x3d49e946, 0x0, 0xbf09e5c2, 0x0,
    0xbf307ec7, 0x0, 0xbf112a66, 0x0,
    0xbd7f27f7, 0x0, 0x3ee7a19f, 0x0,
    0x3f29c871, 0x0, 0x3ed21cb3, 0x0,
    0xbd14d4b2, 0x0, 0xbef6ff5e, 0x0,
    0xbf3253ab, 0x0, 0xbf0e5cdb, 0x0,
    0x3a6c8a96, 0x0, 0x3ef7f9cd, 0x0,
    0x3f1941c9, 0x0, 0x3f000272, 0x0,
    0x3c5633db, 0x0, 0xbef22bf8, 0x0,
    0xbf317fb2, 0x0, 0xbf015d54, 0x0,
    0x3d3c8351, 0x0, 0x3f04d8c8, 0x0,
    0x3f3c3afc, 0x0, 0x3eea604e, 0x0,
    0x3c6c1d6e, 0x0, 0xbee4ca67, 0x0,
    0xbf28b2a6, 0x0, 0xbf0a3952, 0x0,
    0xbc0aa424, 0x0, 0x3f000c12, 0x0,
    0x3f37c0e0, 0x0, 0x3f049603, 0x0,
    0x3d07c030, 0x0, 0xbee23010, 0x0,
    0xbf2eb13f, 0x0, 0xbf06a9a2, 0x0,
    0x3c573a59, 0x0, 0x3f04e74f, 0x0,
    0x3f306f58, 0x0, 0x3edd93ab, 0x0,
    0xbd43e789, 0x0, 0xbefd1051, 0x0,
    0xbf2f376f, 0x0, 0xbef8281e, 0x0,
    0xbd80e474, 0x0, 0x3f1318d6, 0x0,
    0x3f2f2479, 0x0, 0x3f1c4576, 0x0,
    0xba9fcdb5, 0x0, 0xbf07af39, 0x0,
    0xbf326ac8, 0x0, 0xbefb5a41, 0x0,
    0xbd9abefe, 0x0, 0x3ef5fd76, 0x0,
    0x3f1ab162, 0x0, 0x3f012fdb, 0x0,
    0x3e0d92ae, 0x0, 0xbef8885e, 0x0,
    0xbf29da7c, 0x0, 0xbeea21f8, 0x0,
    0xbcc0f288, 0x0, 0x3f08ea58, 0x0,
    0x3f36547d, 0x0, 0x3eebb96f, 0x0,
    0x3c852ca3, 0x0, 0xbf0ee18b, 0x0,
    0xbf278e18, 0x0, 0xbedd6012, 0x0,
    0x3c504572, 0x0, 0x3f1e0b95, 0x0,
    0x3f355610, 0x0, 0x3f05ffd7, 0x0,
    0x3d052177, 0x0, 0xbedd9676, 0x0,
    0xbf2f393b, 0x0, 0xbf084e3e, 0x0,
    0xbcfb4444, 0x0, 0x3f031da4, 0x0,
    0x3f1a7f5f, 0x0, 0x3eed529e, 0x0,
    0x3d7a9864, 0x0, 0xbf16b794, 0x0,
    0xbf3301fb, 0x0, 0xbf0f1fdc, 0x0,
    0xbd1266bc, 0x0, 0x3f18c6e9, 0x0,
    0x3f438b46, 0x0, 0x3ed0d410, 0x0,
    0x3d344f7c, 0x0, 0xbef3d859, 0x0,
    0xbf476a55, 0x0, 0xbef1e456, 0x0,
    0x3b9add0e, 0x0, 0x3ef9fc90, 0x0,
    0x3f2bfbda, 0x0, 0x3ef203ec, 0x0,
    0xbbda7cbb, 0x0, 0xbeefeef1, 0x0,
    0xbf2033dc, 0x0, 0xbf109ec8, 0x0,
    0xbd0ba6de, 0x0, 0x3edef254, 0x0,
    0x3f4669e5, 0x0, 0x3f0a2675, 0x0,
    0x3ce0be8b, 0x0, 0xbee0793d, 0x0,
    0xbf1e25c8, 0x0, 0xbf09b12c, 0x0
    };

static const uint32_t in_cifft_noisy_128[256] = {
    0x3ec70f7b, 0x0, 0xbd5d90cf, 0x3e901346,
    0x3f03cb3e, 0xbe492d82, 0x3f68ee2f, 0xbf032160,
    0xbefb9953, 0xbdeb3daa, 0xbf1c57b9, 0x3dfed177,
    0x3e6a0400, 0x3e16d75b, 0x3ecfc5c8, 0x3f196b48,
    0x3d910cff, 0x3ed2089f, 0xbf0f1353, 0x3e3643a9,
    0x3f1d255f, 0xbf12557f, 0xbec76808, 0x3f488046,
    0x3ded0da1, 0xbd3029b7, 0x3e5e4b4f, 0x3ee92f1e,
    0xbedff084, 0xbd5ae782, 0xbed009f9, 0xbdbd8519,
    0xbf2b1747, 0xc2322237, 0x3d1243f7, 0x3e2ba598,
    0xbe2cbdd4, 0x3e0d4f06, 0xbe475fbe, 0x3de0c512,
    0xbd822c7e, 0x3df6df3c, 0xbe646596, 0xbf19db20,
    0x3f18e450, 0xbf078638, 0x3ec49ee6, 0xbd41d405,
    0xbe83f40e, 0x3d8e182c, 0x3f26b175, 0x3dea96fc,
    0xbed2453f, 0xbe21c66f, 0x3e8708cf, 0xbd7a2e6f,
    0xbe7e339b, 0x3eb47e9c, 0x3d999c1d, 0xbd0512b7,
    0xbf6296cc, 0x3ede0c73, 0xbdd6b65a, 0xbdef31ca,
    0xbd239eb8, 0xbf422134, 0xbe1536f1, 0x3d36deac,
    0x3e0bbe0a, 0x3e8795d1, 0xbe4f1a94, 0x3ce3805a,
    0x3e0d765c, 0xbf0bf124, 0xbd803665, 0xbee45c84,
    0xbec44adf, 0xbe8301c4, 0x3ea9aa7f, 0xbee35fe3,
    0x3f24b11d, 0xbe3a558e, 0xbe4d6548, 0x3d68f6a5,
    0xbefd854a, 0x3ea6968d, 0xbf173998, 0xbe2fc972,
    0x3ea2cb2b, 0xbf38a6ed, 0x3e99d988, 0xbd24181c,
    0x3f08fa0b, 0xbebf3bf4, 0x3e08a814, 0x3f579f18,
    0xbf284a12, 0xbf36d2ae, 0x3ed3f62c, 0xbea9a5b2,
    0x3bfdbde2, 0x3eecda77, 0x3ecc56bf, 0x3d37ad4b,
    0x3ea601aa, 0xbe6ea57a, 0x3e3490f2, 0xbc776c97,
    0xbe475cb4, 0xbdffc3cf, 0x3e228002, 0x3d11ef7a,
    0xbf04547e, 0xbe2821b2, 0xbec18620, 0x3d372af1,
    0x3d6644e6, 0xbf2944f3, 0x3f140c1f, 0xbe94d16e,
    0xbef3d77e, 0xbeb629bf, 0x3dce796c, 0xbe4f3ec5,
    0xbec706ad, 0xbec2df21, 0x3ea0fc47, 0x3dd3799e,
    0xbcbb0385, 0x0, 0x3ea0fc47, 0xbdd3799e,
    0xbec706ad, 0x3ec2df21, 0x3dce796c, 0x3e4f3ec5,
    0xbef3d77e, 0x3eb629bf, 0x3f140c1f, 0x3e94d16e,
    0x3d6644e6, 0x3f2944f3, 0xbec18620, 0xbd372af1,
    0xbf04547e, 0x3e2821b2, 0x3e228002, 0xbd11ef7a,
    0xbe475cb4, 0x3dffc3cf, 0x3e3490f2, 0x3c776c97,
    0x3ea601aa, 0x3e6ea57a, 0x3ecc56bf, 0xbd37ad4b,
    0x3bfdbde2, 0xbeecda77, 0x3ed3f62c, 0x3ea9a5b2,
    0xbf284a12, 0x3f36d2ae, 0x3e08a814, 0xbf579f18,
    0x3f08fa0b, 0x3ebf3bf4, 0x3e99d988, 0x3d24181c,
    0x3ea2cb2b, 0x3f38a6ed, 0xbf173998, 0x3e2fc972,
    0xbefd854a, 0xbea6968d, 0xbe4d6548, 0xbd68f6a5,
    0x3f24b11d, 0x3e3a558e, 0x3ea9aa7f, 0x3ee35fe3,
    0xbec44adf, 0x3e8301c4, 0xbd803665, 0x3ee45c84,
    0x3e0d765c, 0x3f0bf124, 0xbe4f1a94, 0xbce3805a,
    0x3e0bbe0a, 0xbe8795d1, 0xbe1536f1, 0xbd36deac,
    0xbd239eb8, 0x3f422134, 0xbdd6b65a, 0x3def31ca,
    0xbf6296cc, 0xbede0c73, 0x3d999c1d, 0x3d0512b7,
    0xbe7e339b, 0xbeb47e9c, 0x3e8708cf, 0x3d7a2e6f,
    0xbed2453f, 0x3e21c66f, 0x3f26b175, 0xbdea96fc,
    0xbe83f40e, 0xbd8e182c, 0x3ec49ee6, 0x3d41d405,
    0x3f18e450, 0x3f078638, 0xbe646596, 0x3f19db20,
    0xbd822c7e, 0xbdf6df3c, 0xbe475fbe, 0xbde0c512,
    0xbe2cbdd4, 0xbe0d4f06, 0x3d1243f7, 0xbe2ba598,
    0xbf2b1747, 0x42322237, 0xbed009f9, 0x3dbd8519,
    0xbedff084, 0x3d5ae782, 0x3e5e4b4f, 0xbee92f1e,
    0x3ded0da1, 0x3d3029b7, 0xbec76808, 0xbf488046,
    0x3f1d255f, 0x3f12557f, 0xbf0f1353, 0xbe3643a9,
    0x3d910cff, 0xbed2089f, 0x3ecfc5c8, 0xbf196b48,
    0x3e6a0400, 0xbe16d75b, 0xbf1c57b9, 0xbdfed177,
    0xbefb9953, 0x3deb3daa, 0x3f68ee2f, 0x3f032160,
    0x3f03cb3e, 0x3e492d82, 0xbd5d90cf, 0xbe901346
    };

static const uint32_t ref_cfft_noisy_128[256] = {
    0x3ec70f7b, 0x0, 0xbd5d90cf, 0x3e901346,
    0x3f03cb3e, 0xbe492d82, 0x3f68ee2f, 0xbf032160,
    0xbefb9953, 0xbdeb3daa, 0xbf1c57b9, 0x3dfed177,
    0x3e6a0400, 0x3e16d75b, 0x3ecfc5c8, 0x3f196b48,
    0x3d910cff, 0x3ed2089f, 0xbf0f1353, 0x3e3643a9,
    0x3f1d255f, 0xbf12557f, 0xbec76808, 0x3f488046,
    0x3ded0da1, 0xbd3029b7, 0x3e5e4b4f, 0x3ee92f1e,
    0xbedff084, 0xbd5ae782, 0xbed009f9, 0xbdbd8519,
    0xbf2b1747, 0xc2322237, 0x3d1243f7, 0x3e2ba598,
    0xbe2cbdd4, 0x3e0d4f06, 0xbe475fbe, 0x3de0c512,
    0xbd822c7e, 0x3df6df3c, 0xbe646596, 0xbf19db20,
    0x3f18e450, 0xbf078638, 0x3ec49ee6, 0xbd41d405,
    0xbe83f40e, 0x3d8e182c, 0x3f26b175, 0x3dea96fc,
    0xbed2453f, 0xbe21c66f, 0x3e8708cf, 0xbd7a2e6f,
    0xbe7e339b, 0x3eb47e9c, 0x3d999c1d, 0xbd0512b7,
    0xbf6296cc, 0x3ede0c73, 0xbdd6b65a, 0xbdef31ca,
    0xbd239eb8, 0xbf422134, 0xbe1536f1, 0x3d36deac,
    0x3e0bbe0a, 0x3e8795d1, 0xbe4f1a94, 0x3ce3805a,
    0x3e0d765c, 0xbf0bf124, 0xbd803665, 0xbee45c84,
    0xbec44adf, 0xbe8301c4, 0x3ea9aa7f, 0xbee35fe3,
    0x3f24b11d, 0xbe3a558e, 0xbe4d6548, 0x3d68f6a5,
    0xbefd854a, 0x3ea6968d, 0xbf173998, 0xbe2fc972,
    0x3ea2cb2b, 0xbf38a6ed, 0x3e99d988, 0xbd24181c,
    0x3f08fa0b, 0xbebf3bf4, 0x3e08a814, 0x3f579f18,
    0xbf284a12, 0xbf36d2ae, 0x3ed3f62c, 0xbea9a5b2,
    0x3bfdbde2, 0x3eecda77, 0x3ecc56bf, 0x3d37ad4b,
    0x3ea601aa, 0xbe6ea57a, 0x3e3490f2, 0xbc776c97,
    0xbe475cb4, 0xbdffc3cf, 0x3e228002, 0x3d11ef7a,
    0xbf04547e, 0xbe2821b2, 0xbec18620, 0x3d372af1,
    0x3d6644e6, 0xbf2944f3, 0x3f140c1f, 0xbe94d16e,
    0xbef3d77e, 0xbeb629bf, 0x3dce796c, 0xbe4f3ec5,
    0xbec706ad, 0xbec2df21, 0x3ea0fc47, 0x3dd3799e,
    0xbcbb0385, 0x0, 0x3ea0fc47, 0xbdd3799e,
    0xbec706ad, 0x3ec2df21, 0x3dce796c, 0x3e4f3ec5,
    0xbef3d77e, 0x3eb629bf, 0x3f140c1f, 0x3e94d16e,
    0x3d6644e6, 0x3f2944f3, 0xbec18620, 0xbd372af1,
    0xbf04547e, 0x3e2821b2, 0x3e228002, 0xbd11ef7a,
    0xbe475cb4, 0x3dffc3cf, 0x3e3490f2, 0x3c776c97,
    0x3ea601aa, 0x3e6ea57a, 0x3ecc56bf, 0xbd37ad4b,
    0x3bfdbde2, 0xbeecda77, 0x3ed3f62c, 0x3ea9a5b2,
    0xbf284a12, 0x3f36d2ae, 0x3e08a814, 0xbf579f18,
    0x3f08fa0b, 0x3ebf3bf4, 0x3e99d988, 0x3d24181c,
    0x3ea2cb2b, 0x3f38a6ed, 0xbf173998, 0x3e2fc972,
    0xbefd854a, 0xbea6968d, 0xbe4d6548, 0xbd68f6a5,
    0x3f24b11d, 0x3e3a558e, 0x3ea9aa7f, 0x3ee35fe3,
    0xbec44adf, 0x3e8301c4, 0xbd803665, 0x3ee45c84,
    0x3e0d765c, 0x3f0bf124, 0xbe4f1a94, 0xbce3805a,
    0x3e0bbe0a, 0xbe8795d1, 0xbe1536f1, 0xbd36deac,
    0xbd239eb8, 0x3f422134, 0xbdd6b65a, 0x3def31ca,
    0xbf6296cc, 0xbede0c73, 0x3d999c1d, 0x3d0512b7,
    0xbe7e339b, 0xbeb47e9c, 0x3e8708cf, 0x3d7a2e6f,
    0xbed2453f, 0x3e21c66f, 0x3f26b175, 0xbdea96fc,
    0xbe83f40e, 0xbd8e182c, 0x3ec49ee6, 0x3d41d405,
    0x3f18e450, 0x3f078638, 0xbe646596, 0x3f19db20,
    0xbd822c7e, 0xbdf6df3c, 0xbe475fbe, 0xbde0c512,
    0xbe2cbdd4, 0xbe0d4f06, 0x3d1243f7, 0xbe2ba598,
    0xbf2b1747, 0x42322237, 0xbed009f9, 0x3dbd8519,
    0xbedff084, 0x3d5ae782, 0x3e5e4b4f, 0xbee92f1e,
    0x3ded0da1, 0x3d3029b7, 0xbec76808, 0xbf488046,
    0x3f1d255f, 0x3f12557f, 0xbf0f1353, 0xbe3643a9,
    0x3d910cff, 0xbed2089f, 0x3ecfc5c8, 0xbf196b48,
    0x3e6a0400, 0xbe16d75b, 0xbf1c57b9, 0xbdfed177,
    0xbefb9953, 0x3deb3daa, 0x3f68ee2f, 0x3f032160,
    0x3f03cb3e, 0x3e492d82, 0xbd5d90cf, 0xbe901346
    };

static const uint32_t in_cfft_noisy_256[512] = {
    0x3d1d049f, 0x0, 0x3eed01b0, 0x0,
    0x3f2c5a9e, 0x0, 0x3ecec84f, 0x0,
    0x3d186c4d, 0x0, 0xbef02961, 0x0,
    0xbf2600ff, 0x0, 0xbf068359, 0x0,
    0x3cea0731, 0x0, 0x3ecf3470, 0x0,
    0x3f377d49, 0x0, 0x3f012253, 0x0,
    0x3c8b65bc, 0x0, 0xbeef07ea, 0x0,
    0xbf499327, 0x0, 0xbf1b3771, 0x0,
    0x3d9622d6, 0x0, 0x3eed85a9, 0x0,
    0x3f3946d6, 0x0, 0x3f06d23d, 0x0,
    0xbcd6e18f, 0x0, 0xbecf92fa, 0x0,
    0xbf2c4b01, 0x0, 0xbf0130aa, 0x0,
    0xbd52b3da, 0x0, 0x3ef05873, 0x0,
    0x3f2ae9b6, 0x0, 0x3ef91347, 0x0,
    0xbd5abd4c, 0x0, 0xbeebf08f, 0x0,
    0xbf3c5add, 0x0, 0xbf01e437, 0x0,
    0xbcf8f147, 0x0, 0x3f0fd2bf, 0x0,
    0x3f42a015, 0x0, 0x3ed79671, 0x0,
    0xbd821fda, 0x0, 0xbf068db3, 0x0,
    0xbf3c25eb, 0x0, 0xbef80da8, 0x0,
    0x3d2f119d, 0x0, 0x3f083816, 0x0,
    0x3f2fe1e1, 0x0, 0x3eeac656, 0x0,
    0xbde1b5df, 0x0, 0xbf0845d6, 0x0,
    0xbf30b184, 0x0, 0xbeffc797, 0x0,
    0x3d74b822, 0x0, 0x3ee450e6, 0x0,
    0x3f1f1276, 0x0, 0x3ecc5252, 0x0,
    0xbd839e63, 0x0, 0xbefadb8c, 0x0,
    0xbf30b2bd, 0x0, 0xbef2926f, 0x0,
    0x3c4aff6c, 0x0, 0x3ee9bfd0, 0x0,
    0x3f4a37cb, 0x0, 0x3f034322, 0x0,
    0x3bdcb63c, 0x0, 0xbf0ca798, 0x0,
    0xbf29451f, 0x0, 0xbef1cac4, 0x0,
    0x3a8538d9, 0x0, 0x3f007692, 0x0,
    0x3f4466f9, 0x0, 0x3f16da4b, 0x0,
    0x3d4f8436, 0x0, 0xbf16ab77, 0x0,
    0xbf4445fb, 0x0, 0xbf007a92, 0x0,
    0x3b87f02b, 0x0, 0x3f0d322a, 0x0,
    0x3f3445d1, 0x0, 0x3f069eb3, 0x0,
    0xbd97f0a8, 0x0, 0xbef8d4fb, 0x0,
    0xbf39e3d6, 0x0, 0xbf0cd4ce, 0x0,
    0x3bcf73ea, 0x0, 0x3ef412ba, 0x0,
    0x3f148ac1, 0x0, 0x3ef87db5, 0x0,
    0x3ce3af1a, 0x0, 0xbeed0130, 0x0,
    0xbf1e1c98, 0x0, 0xbeefe17d, 0x0,
    0xbcaf4a5d, 0x0, 0x3ef8080b, 0x0,
    0x3f2c30f0, 0x0, 0x3ef23eb5, 0x0,
    0xbb3bc03c, 0x0, 0xbed83748, 0x0,
    0xbf31a07c, 0x0, 0xbef1772a, 0x0,
    0xbd33aa47, 0x0, 0x3f01aeb8, 0x0,
    0x3f1cb26e, 0x0, 0x3f0ce998, 0x0,
    0x3b7a1787, 0x0, 0xbee47f17, 0x0,
    0xbf273386, 0x0, 0xbeeb64e7, 0x0,
    0xbd8480fa, 0x0, 0x3ee1c253, 0x0,
    0x3f3bae09, 0x0, 0x3efb5460, 0x0,
    0xbd53af0a, 0x0, 0xbee42cca, 0x0,
    0xbf2ca342, 0x0, 0xbee96e60, 0x0,
    0x3d8bdbe2, 0x0, 0x3ef5171a, 0x0,
    0x3f2d1213, 0x0, 0x3efbed57, 0x0,
    0x3d921f03, 0x0, 0xbef62f7c, 0x0,
    0xbf29d88b, 0x0, 0xbedb3a72, 0x0,
    0x3d2a002f, 0x0, 0x3efd86d6, 0x0,
    0x3f2e09b1, 0x0, 0x3ed5f94d, 0x0,
    0x3b51cf59, 0x0, 0xbf08e29d, 0x0,
    0xbf4a7ef1, 0x0, 0xbf0c0360, 0x0,
    0xbd3ae529, 0x0, 0x3ef1698c, 0x0,
    0x3f486539, 0x0, 0x3ecbb300, 0x0,
    0xbd3f88f4, 0x0, 0xbeed7990, 0x0,
    0xbf41ff7d, 0x0, 0xbec46264, 0x0,
    0xbc981e51, 0x0, 0x3ed52b19, 0x0,
    0x3f3f33c7, 0x0, 0x3f094d75, 0x0,
    0xbdcdf508, 0x0, 0xbf0aae98, 0x0,
    0xbf3c4afb, 0x0, 0xbef06c9a, 0x0,
    0x3d7748ba, 0x0, 0x3ee7029c, 0x0,
    0x3f18210b, 0x0, 0x3ee71ba5, 0x0,
    0x3d8a31cb, 0x0, 0xbf1766cf, 0x0,
    0xbf28cbb3, 0x0, 0xbf091ffd, 0x0,
    0xbce14a9a, 0x0, 0x3f16671c, 0x0,
    0x3f326511, 0x0, 0x3ee1f857, 0x0,
    0x3cf90dcf, 0x0, 0xbee8a25d, 0x0,
    0xbf2fbc0a, 0x0, 0xbef3c25d, 0x0,
    0x3c4bd3dd, 0x0, 0x3ee5fda1, 0x0,
    0x3f2fa5fb, 0x0, 0x3ec201e5, 0x0,
    0x3c8732b9, 0x0, 0xbef27b88, 0x0,
    0xbf3a88c7, 0x0, 0xbf13a897, 0x0,
    0x3c404729, 0x0, 0x3ed33942, 0x0,
    0x3f498cd1, 0x0, 0x3f0e6963, 0x0,
    0x3cd59604, 0x0, 0xbf06e40e, 0x0,
    0xbf42b79d, 0x0, 0xbf024734, 0x0,
    0x3cee1a02, 0x0, 0x3ee82ea6, 0x0,
    0x3f3c339a, 0x0, 0x3eee96a2, 0x0,
    0x3d68e539, 0x0, 0xbf036261, 0x0,
    0xbf3a1f56, 0x0, 0xbf031a13, 0x0,
    0x3c915374, 0x0, 0x3ee3a2ea, 0x0,
    0x3f32b597, 0x0, 0x3f0eb86e, 0x0,
    0x3d48c268, 0x0, 0xbf0400b9, 0x0,
    0xbf3e7a5d, 0x0, 0xbefe5836, 0x0,
    0x3cbd92b4, 0x0, 0x3ef18b88, 0x0,
    0x3f3b2ef0, 0x0, 0x3ee826e1, 0x0,
    0xbd99387a, 0x0, 0xbf071bd4, 0x0,
    0xbf2b133d, 0x0, 0xbf0146b1, 0x0,
    0xbd1d85f0, 0x0, 0x3efd2ee4, 0x0,
    0x3f3afeb8, 0x0, 0x3f062ef1, 0x0,
    0xbd52542a, 0x0, 0xbf05bb49, 0x0,
    0xbf2caff1, 0x0, 0xbf0025e3, 0x0,
    0x3cd9356d, 0x0, 0x3ef4cff1, 0x0,
    0x3f2e44c6, 0x0, 0x3f055146, 0x0,
    0x3e1643b9, 0x0, 0xbf0f97b3, 0x0,
    0xbf1e483a, 0x0, 0xbf141f3c, 0x0,
    0xbc9b5790, 0x0, 0x3f0a46e5, 0x0,
    0x3f411c9d, 0x0, 0x3efa35eb, 0x0,
    0x3d246189, 0x0, 0xbf06b9c5, 0x0,
    0xbf343406, 0x0, 0xbee248e1, 0x0,
    0xbd065c8b, 0x0, 0x3f14683e, 0x0,
    0x3f1d913d, 0x0, 0x3ee7f6ca, 0x0,
    0x3d7f316d, 0x0, 0xbf084e5e, 0x0,
    0xbf286e64, 0x0, 0xbef3c446, 0x0,
    0xbc9b57b0, 0x0, 0x3eeece67, 0x0,
    0x3f276e67, 0x0, 0x3ef8c4f4, 0x0,
    0x3d7f170d, 0x0, 0xbefd2d48, 0x0,
    0xbf26a883, 0x0, 0xbf07bf23, 0x0,
    0x3c832eec, 0x0, 0x3eea7e61, 0x0,
    0x3f3f82d4, 0x0, 0x3ee6373e, 0x0,
    0x3d896156, 0x0, 0xbed1b28d, 0x0,
    0xbf3530f5, 0x0, 0xbf022a45, 0x0,
    0x3bce6daa, 0x0, 0x3eff3e01, 0x0,
    0x3f3afd98, 0x0, 0x3efa655e, 0x0,
    0x3cfec530, 0x0, 0xbef4a57b, 0x0,
    0xbf377b5f, 0x0, 0xbf13e3b8, 0x0
    };

static const uint32_t in_cifft_noisy_256[512] = {
    0xbf493fac, 0x0, 0x3e5b7a73, 0x3df107a1,
    0xbd34bcec, 0x3f8a6921, 0x3e8bd617, 0xbd3421d8,
    0xbe1aee8a, 0x3e9ccb3b, 0x3e445a19, 0xbf2d98e1,
    0xbf268186, 0x3e70f188, 0x3ea1f7d3, 0x3f2616f3,
    0xbd657d7c, 0x3f42b070, 0xbe062022, 0xbedd3fca,
    0xbf6acbd6, 0xbe8ee85a, 0x3e1b725a, 0x3f48d951,
    0xbe09426c, 0xbeb3b533, 0x3eec1bf4, 0x3ec8389d,
    0xbf2e4e7d, 0xbf20e3d5, 0x3f18adff, 0xbe6bdacd,
    0xbf280a9e, 0xbe06a5d8, 0xbe877177, 0x3d933a37,
    0x3df61279, 0xbf12bda9, 0xbf1a62a0, 0x3e11352c,
    0xbf1ea2ed, 0xbd0823c4, 0xbe1349d8, 0x3eb70855,
    0xbf231d96, 0x3ddf5298, 0x3f13d5cc, 0x3f20111b,
    0x3ee8d4fb, 0x3e07b571, 0xbeed60a2, 0x3e22d945,
    0xbdbe6327, 0xbe3e6203, 0x3f35ceee, 0x3e1e73c8,
    0x3ecf692b, 0xbf6a6b5c, 0xbfa950bb, 0xbe30cc43,
    0x3ea0f7d8, 0x3fa95d70, 0xbf27251e, 0x3e7895d0,
    0xbd8e96cd, 0xc2b265da, 0x3a33bb2f, 0xbf4429c7,
    0xbf5238b4, 0x3db39701, 0xbf86ce35, 0x3ef8277c,
    0xbe16ab79, 0xbf1507c6, 0xbea8e0bc, 0x3f97d510,
    0x3effb2e2, 0x3e142ad7, 0x3f9fd155, 0xbf9de6d6,
    0xbe966bcb, 0xbf46c0e2, 0x3e0e170f, 0x3f40b0ec,
    0x3f20f75a, 0x3f5644e6, 0x3cbce22f, 0x3f6bc6eb,
    0xbe5f5163, 0xbedaf68d, 0x3f72a844, 0x3d9e22ae,
    0x3ed4947b, 0xbe98563c, 0x3dedffe8, 0xbf5ce98e,
    0x3fb6e515, 0x3e083803, 0x3c5f6513, 0x3dfc8c0e,
    0xbe45747a, 0xbf3e0d38, 0xbf192483, 0xbe81b5f2,
    0x3db02bc3, 0xbf03ddfa, 0x3f36ad66, 0x3f3d30d7,
    0xbe041451, 0xbf371f8a, 0xbf0885e9, 0x3f3ae988,
    0xbf7d694a, 0xbf6acb3a, 0x3f88dd97, 0x3f5b33c5,
    0xbefb7a52, 0xbeb28d96, 0xbeb596b3, 0x3df4ef7e,
    0x3d8fcc7f, 0x3f05ecfe, 0x3f247cb3, 0xbf122732,
    0x3efb426b, 0xbf1d1fc5, 0x3e24b779, 0xbf75229f,
    0x3e93e11d, 0xbe1e4c60, 0xbde5b1d1, 0xbe876690,
    0x3de0c009, 0xbf181403, 0x3ed65a4b, 0xbdab7ede,
    0x3d775b08, 0x3f323b66, 0xbe1fb986, 0xbecf6891,
    0x3f535c2f, 0xbf385db4, 0xbdc1a5e1, 0xbef053aa,
    0x3c00526c, 0x3d419971, 0x3cdb347b, 0xbd3c1a4f,
    0xbda77bfd, 0xbe02d29e, 0x3f132bd7, 0x3e80049a,
    0xbea3b2f1, 0x3f32bda9, 0xbe010762, 0x3e57560c,
    0xbe2ab9ba, 0xbf180130, 0x3c3cd275, 0x3ee60f80,
    0x3f168118, 0xbf63caf7, 0xbf198bf1, 0xbd7bc67c,
    0x3e90e3e7, 0x3eae7dfb, 0x3eb77ce5, 0xbd7e0af2,
    0xbed5c22d, 0xbf539540, 0x3f25b195, 0xbe9fddb8,
    0xbf3ca29c, 0xbe9d3552, 0x3f3a2df1, 0xbf4a7491,
    0xbfaecb4c, 0x3f75d506, 0x3de4711f, 0xbf51a341,
    0xbd4e7b24, 0x3eeadcb9, 0x3e66ecd4, 0xbf00d92a,
    0x3f952543, 0x3f447a79, 0x3e441b15, 0x3f52c289,
    0xbf4e3a70, 0x3fa8a5f4, 0x3e4ea965, 0x3e56ed01,
    0x3dc4724e, 0x3ef969f0, 0x3e60b49d, 0xbf6b540f,
    0x3f5d37c4, 0xbcf488c8, 0x3f63e3bd, 0xbf466063,
    0xbe1d0744, 0x3f1eb1a0, 0x3de2ef37, 0xbe933bea,
    0x3e045c9f, 0x3e431d15, 0xbf78ede4, 0xbef209e7,
    0xbf098294, 0xbe4bc60e, 0xbf06e341, 0x3f26c6e6,
    0x3e523e3e, 0xbebd6431, 0xbdaafa95, 0xbef02585,
    0x3e8f6f3c, 0xbe9f9c17, 0xbb7a152c, 0xbe040ab6,
    0x3e034ad4, 0x3e9bff34, 0x3f047a84, 0x3d5cd5e6,
    0x3d88840a, 0x3f633e57, 0xbeb159dc, 0xbe5f2a62,
    0x3ef0b0d7, 0xbefa28a9, 0xbd9e7a6a, 0x3c8cf137,
    0x3f8bb1ed, 0xbd5847fb, 0xbe1a476a, 0x3f01460b,
    0xbf1fe358, 0x3f3d4c90, 0xbe30a5b9, 0x3f47e79b,
    0xbf0f2d84, 0xbee16a48, 0xbd8a9012, 0x3e5b431c,
    0x3f07b06d, 0xbd63474c, 0x3f10b32c, 0x3f80515e,
    0x3f49388c, 0xbef38367, 0x3e9f46aa, 0xbf0f4276,
    0x3dd16dd4, 0x3ecd675d, 0x3f2324ab, 0xbf9d8a19,
    0x3fbefcba, 0x0, 0x3f2324ab, 0x3f9d8a19,
    0x3dd16dd4, 0xbecd675d, 0x3e9f46aa, 0x3f0f4276,
    0x3f49388c, 0x3ef38367, 0x3f10b32c, 0xbf80515e,
    0x3f07b06d, 0x3d63474c, 0xbd8a9012, 0xbe5b431c,
    0xbf0f2d84, 0x3ee16a48, 0xbe30a5b9, 0xbf47e79b,
    0xbf1fe358, 0xbf3d4c90, 0xbe1a476a, 0xbf01460b,
    0x3f8bb1ed, 0x3d5847fb, 0xbd9e7a6a, 0xbc8cf137,
    0x3ef0b0d7, 0x3efa28a9, 0xbeb159dc, 0x3e5f2a62,
    0x3d88840a, 0xbf633e57, 0x3f047a84, 0xbd5cd5e6,
    0x3e034ad4, 0xbe9bff34, 0xbb7a152c, 0x3e040ab6,
    0x3e8f6f3c, 0x3e9f9c17, 0xbdaafa95, 0x3ef02585,
    0x3e523e3e, 0x3ebd6431, 0xbf06e341, 0xbf26c6e6,
    0xbf098294, 0x3e4bc60e, 0xbf78ede4, 0x3ef209e7,
    0x3e045c9f, 0xbe431d15, 0x3de2ef37, 0x3e933bea,
    0xbe1d0744, 0xbf1eb1a0, 0x3f63e3bd, 0x3f466063,
    0x3f5d37c4, 0x3cf488c8, 0x3e60b49d, 0x3f6b540f,
    0x3dc4724e, 0xbef969f0, 0x3e4ea965, 0xbe56ed01,
    0xbf4e3a70, 0xbfa8a5f4, 0x3e441b15, 0xbf52c289,
    0x3f952543, 0xbf447a79, 0x3e66ecd4, 0x3f00d92a,
    0xbd4e7b24, 0xbeeadcb9, 0x3de4711f, 0x3f51a341,
    0xbfaecb4c, 0xbf75d506, 0x3f3a2df1, 0x3f4a7491,
    0xbf3ca29c, 0x3e9d3552, 0x3f25b195, 0x3e9fddb8,
    0xbed5c22d, 0x3f539540, 0x3eb77ce5, 0x3d7e0af2,
    0x3e90e3e7, 0xbeae7dfb, 0xbf198bf1, 0x3d7bc67c,
    0x3f168118, 0x3f63caf7, 0x3c3cd275, 0xbee60f80,
    0xbe2ab9ba, 0x3f180130, 0xbe010762, 0xbe57560c,
    0xbea3b2f1, 0xbf32bda9, 0x3f132bd7, 0xbe80049a,
    0xbda77bfd, 0x3e02d29e, 0x3cdb347b, 0x3d3c1a4f,
    0x3c00526c, 0xbd419971, 0xbdc1a5e1, 0x3ef053aa,
    0x3f535c2f, 0x3f385db4, 0xbe1fb986, 0x3ecf6891,
    0x3d775b08, 0xbf323b66, 0x3ed65a4b, 0x3dab7ede,
    0x3de0c009, 0x3f181403, 0xbde5b1d1, 0x3e876690,
    0x3e93e11d, 0x3e1e4c60, 0x3e24b779, 0x3f75229f,
    0x3efb426b, 0x3f1d1fc5, 0x3f247cb3, 0x3f122732,
    0x3d8fcc7f, 0xbf05ecfe, 0xbeb596b3, 0xbdf4ef7e,
    0xbefb7a52, 0x3eb28d96, 0x3f88dd97, 0xbf5b33c5,
    0xbf7d694a, 0x3f6acb3a, 0xbf0885e9, 0xbf3ae988,
    0xbe041451, 0x3f371f8a, 0x3f36ad66, 0xbf3d30d7,
    0x3db02bc3, 0x3f03ddfa, 0xbf192483, 0x3e81b5f2,
    0xbe45747a, 0x3f3e0d38, 0x3c5f6513, 0xbdfc8c0e,
    0x3fb6e515, 0xbe083803, 0x3dedffe8, 0x3f5ce98e,
    0x3ed4947b, 0x3e98563c, 0x3f72a844, 0xbd9e22ae,
    0xbe5f5163, 0x3edaf68d, 0x3cbce22f, 0xbf6bc6eb,
    0x3f20f75a, 0xbf5644e6, 0x3e0e170f, 0xbf40b0ec,
    0xbe966bcb, 0x3f46c0e2, 0x3f9fd155, 0x3f9de6d6,
    0x3effb2e2, 0xbe142ad7, 0xbea8e0bc, 0xbf97d510,
    0xbe16ab79, 0x3f1507c6, 0xbf86ce35, 0xbef8277c,
    0xbf5238b4, 0xbdb39701, 0x3a33bb2f, 0x3f4429c7,
    0xbd8e96cd, 0x42b265da, 0xbf27251e, 0xbe7895d0,
    0x3ea0f7d8, 0xbfa95d70, 0xbfa950bb, 0x3e30cc43,
    0x3ecf692b, 0x3f6a6b5c, 0x3f35ceee, 0xbe1e73c8,
    0xbdbe6327, 0x3e3e6203, 0xbeed60a2, 0xbe22d945,
    0x3ee8d4fb, 0xbe07b571, 0x3f13d5cc, 0xbf20111b,
    0xbf231d96, 0xbddf5298, 0xbe1349d8, 0xbeb70855,
    0xbf1ea2ed, 0x3d0823c4, 0xbf1a62a0, 0xbe11352c,
    0x3df61279, 0x3f12bda9, 0xbe877177, 0xbd933a37,
    0xbf280a9e, 0x3e06a5d8, 0x3f18adff, 0x3e6bdacd,
    0xbf2e4e7d, 0x3f20e3d5, 0x3eec1bf4, 0xbec8389d,
    0xbe09426c, 0x3eb3b533, 0x3e1b725a, 0xbf48d951,
    0xbf6acbd6, 0x3e8ee85a, 0xbe062022, 0x3edd3fca,
    0xbd657d7c, 0xbf42b070, 0x3ea1f7d3, 0xbf2616f3,
    0xbf268186, 0xbe70f188, 0x3e445a19, 0x3f2d98e1,
    0xbe1aee8a, 0xbe9ccb3b, 0x3e8bd617, 0x3d3421d8,
    0xbd34bcec, 0xbf8a6921, 0x3e5b7a73, 0xbdf107a1
    };

static const uint32_t ref_cfft_noisy_256[512] = {
    0xbf493fac, 0x0, 0x3e5b7a73, 0x3df107a1,
    0xbd34bcec, 0x3f8a6921, 0x3e8bd617, 0xbd3421d8,
    0xbe1aee8a, 0x3e9ccb3b, 0x3e445a19, 0xbf2d98e1,
    0xbf268186, 0x3e70f188, 0x3ea1f7d3, 0x3f2616f3,
    0xbd657d7c, 0x3f42b070, 0xbe062022, 0xbedd3fca,
    0xbf6acbd6, 0xbe8ee85a, 0x3e1b725a, 0x3f48d951,
    0xbe09426c, 0xbeb3b533, 0x3eec1bf4, 0x3ec8389d,
    0xbf2e4e7d, 0xbf20e3d5, 0x3f18adff, 0xbe6bdacd,
    0xbf280a9e, 0xbe06a5d8, 0xbe877177, 0x3d933a37,
    0x3df61279, 0xbf12bda9, 0xbf1a62a0, 0x3e11352c,
    0xbf1ea2ed, 0xbd0823c4, 0xbe1349d8, 0x3eb70855,
    0xbf231d96, 0x3ddf5298, 0x3f13d5cc, 0x3f20111b,
    0x3ee8d4fb, 0x3e07b571, 0xbeed60a2, 0x3e22d945,
    0xbdbe6327, 0xbe3e6203, 0x3f35ceee, 0x3e1e73c8,
    0x3ecf692b, 0xbf6a6b5c, 0xbfa950bb, 0xbe30cc43,
    0x3ea0f7d8, 0x3fa95d70, 0xbf27251e, 0x3e7895d0,
    0xbd8e96cd, 0xc2b265da, 0x3a33bb2f, 0xbf4429c7,
    0xbf5238b4, 0x3db39701, 0xbf86ce35, 0x3ef8277c,
    0xbe16ab79, 0xbf1507c6, 0xbea8e0bc, 0x3f97d510,
    0x3effb2e2, 0x3e142ad7, 0x3f9fd155, 0xbf9de6d6,
    0xbe966bcb, 0xbf46c0e2, 0x3e0e170f, 0x3f40b0ec,
    0x3f20f75a, 0x3f5644e6, 0x3cbce22f, 0x3f6bc6eb,
    0xbe5f5163, 0xbedaf68d, 0x3f72a844, 0x3d9e22ae,
    0x3ed4947b, 0xbe98563c, 0x3dedffe8, 0xbf5ce98e,
    0x3fb6e515, 0x3e083803, 0x3c5f6513, 0x3dfc8c0e,
    0xbe45747a, 0xbf3e0d38, 0xbf192483, 0xbe81b5f2,
    0x3db02bc3, 0xbf03ddfa, 0x3f36ad66, 0x3f3d30d7,
    0xbe041451, 0xbf371f8a, 0xbf0885e9, 0x3f3ae988,
    0xbf7d694a, 0xbf6acb3a, 0x3f88dd97, 0x3f5b33c5,
    0xbefb7a52, 0xbeb28d96, 0xbeb596b3, 0x3df4ef7e,
    0x3d8fcc7f, 0x3f05ecfe, 0x3f247cb3, 0xbf122732,
    0x3efb426b, 0xbf1d1fc5, 0x3e24b779, 0xbf75229f,
    0x3e93e11d, 0xbe1e4c60, 0xbde5b1d1, 0xbe876690,
    0x3de0c009, 0xbf181403, 0x3ed65a4b, 0xbdab7ede,
    0x3d775b08, 0x3f323b66, 0xbe1fb986, 0xbecf6891,
    0x3f535c2f, 0xbf385db4, 0xbdc1a5e1, 0xbef053aa,
    0x3c00526c, 0x3d419971, 0x3cdb347b, 0xbd3c1a4f,
    0xbda77bfd, 0xbe02d29e, 0x3f132bd7, 0x3e80049a,
    0xbea3b2f1, 0x3f32bda9, 0xbe010762, 0x3e57560c,
    0xbe2ab9ba, 0xbf180130, 0x3c3cd275, 0x3ee60f80,
    0x3f168118, 0xbf63caf7, 0xbf198bf1, 0xbd7bc67c,
    0x3e90e3e7, 0x3eae7dfb, 0x3eb77ce5, 0xbd7e0af2,
    0xbed5c22d, 0xbf539540, 0x3f25b195, 0xbe9fddb8,
    0xbf3ca29c, 0xbe9d3552, 0x3f3a2df1, 0xbf4a7491,
    0xbfaecb4c, 0x3f75d506, 0x3de4711f, 0xbf51a341,
    0xbd4e7b24, 0x3eeadcb9, 0x3e66ecd4, 0xbf00d92a,
    0x3f952543, 0x3f447a79, 0x3e441b15, 0x3f52c289,
    0xbf4e3a70, 0x3fa8a5f4, 0x3e4ea965, 0x3e56ed01,
    0x3dc4724e, 0x3ef969f0, 0x3e60b49d, 0xbf6b540f,
    0x3f5d37c4, 0xbcf488c8, 0x3f63e3bd, 0xbf466063,
    0xbe1d0744, 0x3f1eb1a0, 0x3de2ef37, 0xbe933bea,
    0x3e045c9f, 0x3e431d15, 0xbf78ede4, 0xbef209e7,
    0xbf098294, 0xbe4bc60e, 0xbf06e341, 0x3f26c6e6,
    0x3e523e3e, 0xbebd6431, 0xbdaafa95, 0xbef02585,
    0x3e8f6f3c, 0xbe9f9c17, 0xbb7a152c, 0xbe040ab6,
    0x3e034ad4, 0x3e9bff34, 0x3f047a84, 0x3d5cd5e6,
    0x3d88840a, 0x3f633e57, 0xbeb159dc, 0xbe5f2a62,
    0x3ef0b0d7, 0xbefa28a9, 0xbd9e7a6a, 0x3c8cf137,
    0x3f8bb1ed, 0xbd5847fb, 0xbe1a476a, 0x3f01460b,
    0xbf1fe358, 0x3f3d4c90, 0xbe30a5b9, 0x3f47e79b,
    0xbf0f2d84, 0xbee16a48, 0xbd8a9012, 0x3e5b431c,
    0x3f07b06d, 0xbd63474c, 0x3f10b32c, 0x3f80515e,
    0x3f49388c, 0xbef38367, 0x3e9f46aa, 0xbf0f4276,
    0x3dd16dd4, 0x3ecd675d, 0x3f2324ab, 0xbf9d8a19,
    0x3fbefcba, 0x0, 0x3f2324ab, 0x3f9d8a19,
    0x3dd16dd4, 0xbecd675d, 0x3e9f46aa, 0x3f0f4276,
    0x3f49388c, 0x3ef38367, 0x3f10b32c, 0xbf80515e,
    0x3f07b06d, 0x3d63474c, 0xbd8a9012, 0xbe5b431c,
    0xbf0f2d84, 0x3ee16a48, 0xbe30a5b9, 0xbf47e79b,
    0xbf1fe358, 0xbf3d4c90, 0xbe1a476a, 0xbf01460b,
    0x3f8bb1ed, 0x3d5847fb, 0xbd9e7a6a, 0xbc8cf137,
    0x3ef0b0d7, 0x3efa28a9, 0xbeb159dc, 0x3e5f2a62,
    0x3d88840a, 0xbf633e57, 0x3f047a84, 0xbd5cd5e6,
    0x3e034ad4, 0xbe9bff34, 0xbb7a152c, 0x3e040ab6,
    0x3e8f6f3c, 0x3e9f9c17, 0xbdaafa95, 0x3ef02585,
    0x3e523e3e, 0x3ebd6431, 0xbf06e341, 0xbf26c6e6,
    0xbf098294, 0x3e4bc60e, 0xbf78ede4, 0x3ef209e7,
    0x3e045c9f, 0xbe431d15, 0x3de2ef37, 0x3e933bea,
    0xbe1d0744, 0xbf1eb1a0, 0x3f63e3bd, 0x3f466063,
    0x3f5d37c4, 0x3cf488c8, 0x3e60b49d, 0x3f6b540f,
    0x3dc4724e, 0xbef969f0, 0x3e4ea965, 0xbe56ed01,
    0xbf4e3a70, 0xbfa8a5f4, 0x3e441b15, 0xbf52c289,
    0x3f952543, 0xbf447a79, 0x3e66ecd4, 0x3f00d92a,
    0xbd4e7b24, 0xbeeadcb9, 0x3de4711f, 0x3f51a341,
    0xbfaecb4c, 0xbf75d506, 0x3f3a2df1, 0x3f4a7491,
    0xbf3ca29c, 0x3e9d3552, 0x3f25b195, 0x3e9fddb8,
    0xbed5c22d, 0x3f539540, 0x3eb77ce5, 0x3d7e0af2,
    0x3e90e3e7, 0xbeae7dfb, 0xbf198bf1, 0x3d7bc67c,
    0x3f168118, 0x3f63caf7, 0x3c3cd275, 0xbee60f80,
    0xbe2ab9ba, 0x3f180130, 0xbe010762, 0xbe57560c,
    0xbea3b2f1, 0xbf32bda9, 0x3f132bd7, 0xbe80049a,
    0xbda77bfd, 0x3e02d29e, 0x3cdb347b, 0x3d3c1a4f,
    0x3c00526c, 0xbd419971, 0xbdc1a5e1, 0x3ef053aa,
    0x3f535c2f, 0x3f385db4, 0xbe1fb986, 0x3ecf6891,
    0x3d775b08, 0xbf323b66, 0x3ed65a4b, 0x3dab7ede,
    0x3de0c009, 0x3f181403, 0xbde5b1d1, 0x3e876690,
    0x3e93e11d, 0x3e1e4c60, 0x3e24b779, 0x3f75229f,
    0x3efb426b, 0x3f1d1fc5, 0x3f247cb3, 0x3f122732,
    0x3d8fcc7f, 0xbf05ecfe, 0xbeb596b3, 0xbdf4ef7e,
    0xbefb7a52, 0x3eb28d96, 0x3f88dd97, 0xbf5b33c5,
    0xbf7d694a, 0x3f6acb3a, 0xbf0885e9, 0xbf3ae988,
    0xbe041451, 0x3f371f8a, 0x3f36ad66, 0xbf3d30d7,
    0x3db02bc3, 0x3f03ddfa, 0xbf192483, 0x3e81b5f2,
    0xbe45747a, 0x3f3e0d38, 0x3c5f6513, 0xbdfc8c0e,
    0x3fb6e515, 0xbe083803, 0x3dedffe8, 0x3f5ce98e,
    0x3ed4947b, 0x3e98563c, 0x3f72a844, 0xbd9e22ae,
    0xbe5f5163, 0x3edaf68d, 0x3cbce22f, 0xbf6bc6eb,
    0x3f20f75a, 0xbf5644e6, 0x3e0e170f, 0xbf40b0ec,
    0xbe966bcb, 0x3f46c0e2, 0x3f9fd155, 0x3f9de6d6,
    0x3effb2e2, 0xbe142ad7, 0xbea8e0bc, 0xbf97d510,
    0xbe16ab79, 0x3f1507c6, 0xbf86ce35, 0xbef8277c,
    0xbf5238b4, 0xbdb39701, 0x3a33bb2f, 0x3f4429c7,
    0xbd8e96cd, 0x42b265da, 0xbf27251e, 0xbe7895d0,
    0x3ea0f7d8, 0xbfa95d70, 0xbfa950bb, 0x3e30cc43,
    0x3ecf692b, 0x3f6a6b5c, 0x3f35ceee, 0xbe1e73c8,
    0xbdbe6327, 0x3e3e6203, 0xbeed60a2, 0xbe22d945,
    0x3ee8d4fb, 0xbe07b571, 0x3f13d5cc, 0xbf20111b,
    0xbf231d96, 0xbddf5298, 0xbe1349d8, 0xbeb70855,
    0xbf1ea2ed, 0x3d0823c4, 0xbf1a62a0, 0xbe11352c,
    0x3df61279, 0x3f12bda9, 0xbe877177, 0xbd933a37,
    0xbf280a9e, 0x3e06a5d8, 0x3f18adff, 0x3e6bdacd,
    0xbf2e4e7d, 0x3f20e3d5, 0x3eec1bf4, 0xbec8389d,
    0xbe09426c, 0x3eb3b533, 0x3e1b725a, 0xbf48d951,
    0xbf6acbd6, 0x3e8ee85a, 0xbe062022, 0x3edd3fca,
    0xbd657d7c, 0xbf42b070, 0x3ea1f7d3, 0xbf2616f3,
    0xbf268186, 0xbe70f188, 0x3e445a19, 0x3f2d98e1,
    0xbe1aee8a, 0xbe9ccb3b, 0x3e8bd617, 0x3d3421d8,
    0xbd34bcec, 0xbf8a6921, 0x3e5b7a73, 0xbdf107a1
    };

static const uint32_t in_cfft_noisy_512[1024] = {
    0xbd3079b3, 0x0, 0x3ef89ac3, 0x0,
    0x3f37b37c, 0x0, 0x3eef6457, 0x0,
    0xbd164354, 0x0, 0xbf196dcc, 0x0,
    0xbf372efd, 0x0, 0xbf0636ab, 0x0,
    0x3c3c7622, 0x0, 0x3ef9b00b, 0x0,
    0x3f338a06, 0x0, 0x3f0220fd, 0x0,
    0x3ba3d24c, 0x0, 0xbef15209, 0x0,
    0xbf2019fb, 0x0, 0xbf161571, 0x0,
    0x3d980227, 0x0, 0x3ed25bb1, 0x0,
    0x3f391d6f, 0x0, 0x3f11dbd6, 0x0,
    0xbce19c93, 0x0, 0xbed3aa26, 0x0,
    0xbf22c781, 0x0, 0xbf141308, 0x0,
    0xbc231acb, 0x0, 0x3f06884d, 0x0,
    0x3f27af59, 0x0, 0x3f172342, 0x0,
    0x3d1052ea, 0x0, 0xbef738b7, 0x0,
    0xbf328d90, 0x0, 0xbf075f7d, 0x0,
    0x3bce8aa9, 0x0, 0x3edaea1d, 0x0,
    0x3f2730b0, 0x0, 0x3f10d0bf, 0x0,
    0xbd2c0e4f, 0x0, 0xbefab262, 0x0,
    0xbf182080, 0x0, 0xbf1617db, 0x0,
    0xbd46c380, 0x0, 0x3ef71f72, 0x0,
    0x3f231f06, 0x0, 0x3f128020, 0x0,
    0x3d6f4802, 0x0, 0xbf036fce, 0x0,
    0xbf4e211e, 0x0, 0xbef24bfa, 0x0,
    0x3d41f11f, 0x0, 0x3f0f2d55, 0x0,
    0x3f39bd66, 0x0, 0x3ec426e4, 0x0,
    0x3b9247fa, 0x0, 0xbf06e2ab, 0x0,
    0xbf20b83f, 0x0, 0xbee3bf95, 0x0,
    0xbd3e7a5c, 0x0, 0x3f0a8703, 0x0,
    0x3f29d005, 0x0, 0x3edf69fb, 0x0,
    0x3d915caf, 0x0, 0xbef0ad45, 0x0,
    0xbf3977b8, 0x0, 0xbef13e03, 0x0,
    0xbcd83ce4, 0x0, 0x3f070a17, 0x0,
    0x3f2c66a2, 0x0, 0x3ec1f482, 0x0,
    0xbd7a8dbe, 0x0, 0xbf09805c, 0x0,
    0xbf40a3dc, 0x0, 0xbee6930e, 0x0,
    0x3c953fa0, 0x0, 0x3f08eeac, 0x0,
    0x3f30ee84, 0x0, 0x3ef761f8, 0x0,
    0x3d5ab7c6, 0x0, 0xbedc1d61, 0x0,
    0xbf260a90, 0x0, 0xbf04b4f8, 0x0,
    0xbc7c053a, 0x0, 0x3f05ea13, 0x0,
    0x3f342f2f, 0x0, 0x3f22759f, 0x0,
    0x3dd8c0b8, 0x0, 0xbeebf443, 0x0,
    0xbf2d4868, 0x0, 0xbf171c19, 0x0,
    0xbc98ea6d, 0x0, 0x3f09b57a, 0x0,
    0x3f2d3b6c, 0x0, 0x3f05cb65, 0x0,
    0xbd636b9e, 0x0, 0xbee39731, 0x0,
    0xbf30ee14, 0x0, 0xbf178c09, 0x0,
    0x3dcdc5e2, 0x0, 0x3eeee57a, 0x0,
    0x3f31af3a, 0x0, 0x3eec2fb3, 0x0,
    0x3cab12f9, 0x0, 0xbebda430, 0x0,
    0xbf3f47ec, 0x0, 0xbf0043f0, 0x0,
    0xbced5b66, 0x0, 0x3f00b726, 0x0,
    0x3f384202, 0x0, 0x3edd2106, 0x0,
    0xbb73c282, 0x0, 0xbefdee3c, 0x0,
    0xbf270342, 0x0, 0xbf047b8c, 0x0,
    0x3c2dbf2e, 0x0, 0x3f03d1ec, 0x0,
    0x3f350a47, 0x0, 0x3ed75265, 0x0,
    0xbd23bfc3, 0x0, 0xbf02dc26, 0x0,
    0xbf1da23d, 0x0, 0xbef243f2, 0x0,
    0x3d44bb56, 0x0, 0x3efcb146, 0x0,
    0x3f387341, 0x0, 0x3edde8bf, 0x0,
    0x3d2a9d3a, 0x0, 0xbef35bb6, 0x0,
    0xbf352152, 0x0, 0xbf212f9e, 0x0,
    0xbd3b66e8, 0x0, 0x3ef456c8, 0x0,
    0x3f2c48a0, 0x0, 0x3efda7f5, 0x0,
    0x3d47a515, 0x0, 0xbeeca005, 0x0,
    0xbf25fbc6, 0x0, 0xbf0dc3b4, 0x0,
    0x3cde724f, 0x0, 0x3f082848, 0x0,
    0x3f33d1db, 0x0, 0x3ef06437, 0x0,
    0x3d019705, 0x0, 0xbf03199a, 0x0,
    0xbf234942, 0x0, 0xbeef805f, 0x0,
    0xbe0c8dce, 0x0, 0x3ef98d8a, 0x0,
    0x3f215d54, 0x0, 0x3f0e92b0, 0x0,
    0x3cb22293, 0x0, 0xbed31f11, 0x0,
    0xbf341c52, 0x0, 0xbedeaafe, 0x0,
    0xbca38d8c, 0x0, 0x3ee1790d, 0x0,
    0x3f37ebbc, 0x0, 0x3efda9eb, 0x0,
    0xbd20abc1, 0x0, 0xbf03df3c, 0x0,
    0xbf221e22, 0x0, 0xbf0851a6, 0x0,
    0xbd5d4a18, 0x0, 0x3f070c1c, 0x0,
    0x3f30aa33, 0x0, 0x3ec850a8, 0x0,
    0x3de10f75, 0x0, 0xbf026a36, 0x0,
    0xbf15ecb9, 0x0, 0xbee7ef31, 0x0,
    0x3d346778, 0x0, 0x3f029b35, 0x0,
    0x3f4361d7, 0x0, 0x3ef82397, 0x0,
    0xbd06ebc0, 0x0, 0xbf058f6d, 0x0,
    0xbf34cb21, 0x0, 0xbf08351f, 0x0,
    0xbdc852bd, 0x0, 0x3ee0efa2, 0x0,
    0x3f29a066, 0x0, 0x3f172868, 0x0,
    0x3de92682, 0x0, 0xbedbfd0a, 0x0,
    0xbf44602a, 0x0, 0xbee7054b, 0x0,
    0xbc81d968, 0x0, 0x3f05ffbf, 0x0,
    0x3f35cc68, 0x0, 0x3eefcb2c, 0x0,
    0xbcfa468a, 0x0, 0xbeea1e89, 0x0,
    0xbf31b679, 0x0, 0xbf0a9dbb, 0x0,
    0x3d08c301, 0x0, 0x3ef9bb81, 0x0,
    0x3f31a53e, 0x0, 0x3f0bf5d4, 0x0,
    0x3dfc0ff2, 0x0, 0xbf042e4f, 0x0,
    0xbf33f7c6, 0x0, 0xbee71687, 0x0,
    0xbb98ad4b, 0x0, 0x3f1407c6, 0x0,
    0x3f46dd65, 0x0, 0x3f111210, 0x0,
    0xbc8b0447, 0x0, 0xbedbce90, 0x0,
    0xbf2ebc29, 0x0, 0xbf077dd4, 0x0,
    0x3d3ded6b, 0x0, 0x3eeabbc6, 0x0,
    0x3f2b59e8, 0x0, 0x3edfaaa2, 0x0,
    0xbbbc42e7, 0x0, 0xbeea8868, 0x0,
    0xbf329a80, 0x0, 0xbf0c88e3, 0x0,
    0xbd2a0c08, 0x0, 0x3ef85602, 0x0,
    0x3f2d1501, 0x0, 0x3f1c948c, 0x0,
    0xbdccd549, 0x0, 0xbf018ce6, 0x0,
    0xbf24c8b0, 0x0, 0xbeb68c6c, 0x0,
    0xbc297536, 0x0, 0x3eeedbd1, 0x0,
    0x3f208be5, 0x0, 0x3f021b24, 0x0,
    0x3d548435, 0x0, 0xbeeadd75, 0x0,
    0xbf27c712, 0x0, 0xbf0386f3, 0x0,
    0x3d3c28de, 0x0, 0x3ee3517c, 0x0,
    0x3f3841b0, 0x0, 0x3f158001, 0x0,
    0x3ce2be33, 0x0, 0xbf161d62, 0x0,
    0xbf356842, 0x0, 0xbee15fb2, 0x0,
    0x3ca4b2c8, 0x0, 0x3f002e3c, 0x0,
    0x3f32dacc, 0x0, 0x3f09d9da, 0x0,
    0xbcd2c9db, 0x0, 0xbf172cab, 0x0,
    0xbf401cae, 0x0, 0xbf0d0796, 0x0,
    0x3cba7820, 0x0, 0x3f005e50, 0x0,
    0x3f21de42, 0x0, 0x3f0afe16, 0x0,
    0x3d1f36c7, 0x0, 0xbf0ed068, 0x0,
    0xbf3e37bb, 0x0, 0xbf15f495, 0x0,
    0x3c5ee626, 0x0, 0x3f0d652a, 0x0,
    0x3f2d305b, 0x0, 0x3efddfbd, 0x0,
    0x3ca3a05b, 0x0, 0xbef80a0b, 0x0,
    0xbf4cd478, 0x0, 0xbf0933ac, 0x0,
    0xbca24c6b, 0x0, 0x3f01c580, 0x0,
    0x3f392576, 0x0, 0x3efb4103, 0x0,
    0xbd5852a3, 0x0, 0xbf0c7075, 0x0,
    0xbf384355, 0x0, 0xbed5f9ef, 0x0,
    0x3ca46529, 0x0, 0x3f02815a, 0x0,
    0x3f29258d, 0x0, 0x3ed3f34f, 0x0,
    0x3d7da6d2, 0x0, 0xbf0d9ccc, 0x0,
    0xbf2f7457, 0x0, 0xbf131df1, 0x0,
    0x3c30b27a, 0x0, 0x3ee7f156, 0x0,
    0x3f39ffcf, 0x0, 0x3f02cea6, 0x0,
    0x3c382100, 0x0, 0xbef731df, 0x0,
    0xbf38f8b3, 0x0, 0xbf02d0a8, 0x0,
    0x3ca4ce37, 0x0, 0x3f011b33, 0x0,
    0x3f17798e, 0x0, 0x3eed28e6, 0x0,
    0x3a76a0b3, 0x0, 0xbf0d9d27, 0x0,
    0xbf2d6db8, 0x0, 0xbee21f38, 0x0,
    0x3d8d3ce3, 0x0, 0x3ef15b04, 0x0,
    0x3f48a736, 0x0, 0x3ef2c8eb, 0x0,
    0x3c55a21f, 0x0, 0xbf002513, 0x0,
    0xbf44ec69, 0x0, 0xbf02a4fd, 0x0,
    0x3d5508db, 0x0, 0x3ef3a6e7, 0x0,
    0x3f3f3673, 0x0, 0x3f021391, 0x0,
    0x3d8ef1c6, 0x0, 0xbef9b3c1, 0x0,
    0xbf52b4b4, 0x0, 0xbf0fd759, 0x0,
    0x3d8ccbe0, 0x0, 0x3f05da0b, 0x0,
    0x3f3633f2, 0x0, 0x3ee1959a, 0x0,
    0x3c78ab2c, 0x0, 0xbeee7854, 0x0,
    0xbf39330b, 0x0, 0xbee94437, 0x0,
    0x3cfa21a7, 0x0, 0x3f006cc0, 0x0,
    0x3f2142cf, 0x0, 0x3eea0923, 0x0,
    0xbc53a7bc, 0x0, 0xbf0d6aa8, 0x0,
    0xbf49d278, 0x0, 0xbf04aebc, 0x0,
    0x3c61e72f, 0x0, 0x3f0bcc31, 0x0,
    0x3f26f883, 0x0, 0x3f04cf39, 0x0,
    0xbd2c0fbe, 0x0, 0xbefd1029, 0x0,
    0xbf36bf86, 0x0, 0xbf04ac08, 0x0,
    0xbd0e8d12, 0x0, 0x3f0fe5f5, 0x0,
    0x3f27a253, 0x0, 0x3eda03b1, 0x0,
    0xbd1d0587, 0x0, 0xbf0848da, 0x0,
    0xbf334415, 0x0, 0xbedda256, 0x0,
    0xbb0d8eb8, 0x0, 0x3f07e119, 0x0,
    0x3f2a0cc0, 0x0, 0x3f1c3ef1, 0x0,
    0xbdd3a2fc, 0x0, 0xbec7520d, 0x0,
    0xbf2a32d7, 0x0, 0xbeede4ac, 0x0,
    0x3e0cd826, 0x0, 0x3ef66dea, 0x0,
    0x3f270cd8, 0x0, 0x3eebe843, 0x0,
    0x3c544501, 0x0, 0xbf04d216, 0x0,
    0xbf3d0fd2, 0x0, 0xbeeca302, 0x0,
    0xbc5c1d91, 0x0, 0x3efff8fe, 0x0,
    0x3f2ea2bc, 0x0, 0x3eed413e, 0x0,
    0x3b8e7fed, 0x0, 0xbeed3ad3, 0x0,
    0xbf2272ca, 0x0, 0xbef30767, 0x0,
    0xbe0b6953, 0x0, 0x3f0497a6, 0x0,
    0x3f3e54cf, 0x0, 0x3eddd58f, 0x0,
    0x3ddc5208, 0x0, 0xbedef00e, 0x0,
    0xbf47f538, 0x0, 0xbef99a0f, 0x0,
    0x3e24e648, 0x0, 0x3efa2711, 0x0,
    0x3f3675e9, 0x0, 0x3ee044da, 0x0,
    0x3c4ccbbf, 0x0, 0xbf04349d, 0x0,
    0xbf295b93, 0x0, 0xbedc480b, 0x0,
    0x3df91075, 0x0, 0x3f049138, 0x0,
    0x3f2f96ee, 0x0, 0x3f10e154, 0x0,
    0xbcc80c19, 0x0, 0xbefd8efd, 0x0,
    0xbf302f0a, 0x0, 0xbf006fb5, 0x0,
    0xbae6af08, 0x0, 0x3efd524b, 0x0,
    0x3f1b6710, 0x0, 0x3f086905, 0x0,
    0xbe0c5d4f, 0x0, 0xbf050c5f, 0x0,
    0xbf49c216, 0x0, 0xbeeef63e, 0x0,
    0xbd0bad41, 0x0, 0x3ede0b67, 0x0,
    0x3f1e184f, 0x0, 0x3ef6b2ea, 0x0,
    0x3d29b496, 0x0, 0xbf0a0ba4, 0x0,
    0xbf2be2a0, 0x0, 0xbefb0359, 0x0,
    0xbd90c879, 0x0, 0x3ef6b683, 0x0,
    0x3f400b4e, 0x0, 0x3ee9ae90, 0x0,
    0xbdc18181, 0x0, 0xbef231be, 0x0,
    0xbf32a541, 0x0, 0xbee376c2, 0x0,
    0xbcaf0c74, 0x0, 0x3f0955af, 0x0,
    0x3f4674ec, 0x0, 0x3ef98ffe, 0x0,
    0xbd2d27ce, 0x0, 0xbf132d63, 0x0,
    0xbf2e47b1, 0x0, 0xbf07f3d1, 0x0,
    0xbd9d184d, 0x0, 0x3f05a1c1, 0x0,
    0x3f3ad98f, 0x0, 0x3ef9a339, 0x0,
    0x3d182097, 0x0, 0xbed5ab52, 0x0,
    0xbf30475b, 0x0, 0xbf02de5c, 0x0,
    0x3c65a0a1, 0x0, 0x3edb7a35, 0x0,
    0x3f290213, 0x0, 0x3ee400dd, 0x0,
    0x3db3c379, 0x0, 0xbf0a99f0, 0x0,
    0xbf2587c4, 0x0, 0xbeea7d5d, 0x0,
    0x3b84a329, 0x0, 0x3ef606ab, 0x0,
    0x3f3cbc3f, 0x0, 0x3edc846f, 0x0,
    0x3d55e5f6, 0x0, 0xbef1ba70, 0x0,
    0xbf32bdb5, 0x0, 0xbf00ffdb, 0x0,
    0xbcd84750, 0x0, 0x3ef96902, 0x0,
    0x3f342fc0, 0x0, 0x3efa680f, 0x0,
    0x3ddf7f9c, 0x0, 0xbf0e5609, 0x0,
    0xbf433c14, 0x0, 0xbed48a2a, 0x0,
    0x3c8254d4, 0x0, 0x3ed1953c, 0x0,
    0x3f4599f7, 0x0, 0x3efc042c, 0x0,
    0xbc3883ef, 0x0, 0xbefde806, 0x0,
    0xbf39314b, 0x0, 0xbf096cdc, 0x0,
    0xbd2a34d3, 0x0, 0x3f10c855, 0x0,
    0x3f4c7c13, 0x0, 0x3f0002c0, 0x0,
    0xbd8e5515, 0x0, 0xbf03328c, 0x0,
    0xbf3247ee, 0x0, 0xbefe18fe, 0x0,
    0xbdcd399d, 0x0, 0x3f072801, 0x0,
    0x3f1f9328, 0x0, 0x3ee8d5f6, 0x0,
    0x3cefc1ed, 0x0, 0xbef5884d, 0x0,
    0xbf1b41e4, 0x0, 0xbf09e3c1, 0x0,
    0xbd33fc40, 0x0, 0x3edb0a77, 0x0,
    0x3f3fb041, 0x0, 0x3f05f418, 0x0,
    0xbdad46f8, 0x0, 0xbf11699b, 0x0,
    0xbf27fc43, 0x0, 0xbee60962, 0x0,
    0x3d4d876b, 0x0, 0x3f190ed5, 0x0,
    0x3f3bc310, 0x0, 0x3eecff25, 0x0,
    0xbd7b9a27, 0x0, 0xbef810f5, 0x0,
    0xbf2fefc1, 0x0, 0xbef540b5, 0x0,
    0xbd148a7b, 0x0, 0x3ef8ef76, 0x0,
    0x3f3e6634, 0x0, 0x3f0e5da6, 0x0,
    0x3c3dbd0b, 0x0, 0xbf002e2a, 0x0,
    0xbf43f2e2, 0x0, 0xbf01620c, 0x0,
    0xbc79da10, 0x0, 0x3eef15ac, 0x0,
    0x3f398a23, 0x0, 0x3eeb815f, 0x0,
    0xbd4fb66d, 0x0, 0xbf0f6af0, 0x0,
    0xbf376dd4, 0x0, 0xbee23ec1, 0x0
    };

static const uint32_t in_cifft_noisy_512[1024] = {
    0xbdc714d6, 0x0, 0xbe0ccb01, 0xbf687b9c,
    0xbf3ac92e, 0x3ecb0e55, 0x3f018793, 0xbf50bcfc,
    0xbf6ee15a, 0x3f48ce24, 0xbd521742, 0x3eadc4e2,
    0xbede80ae, 0xbf86b3c4, 0x3f9ce3aa, 0xbf172008,
    0xbf0ab0fc, 0x3f1fc34d, 0xbfa23d88, 0xbd7aa377,
    0xbf61d0a9, 0x3ee86ef9, 0xbea3a490, 0xbe967dc1,
    0xbdbe6922, 0x3e1091c9, 0xbdc1f9e3, 0x3f52e8ed,
    0xc00ae901, 0xbfb46ea1, 0xbe22829c, 0xbee02a16,
    0xbe5d5796, 0xbe025ae3, 0xbfb99d0f, 0x3fd89697,
    0x3ead4981, 0xbd1d7a63, 0x3f01eb7f, 0xbf2c4420,
    0x3f22c57a, 0x3d85384b, 0x3e0cfff6, 0xbef89cee,
    0xbdce2149, 0x3e57e852, 0xbf1b1fdb, 0xbe4a6999,
    0xbeab524f, 0x3e903640, 0x3f798f9d, 0x3f681cf2,
    0x3eecad98, 0xbcb75f71, 0xbf464e4e, 0x3b5de9cb,
    0x3f1eaa8b, 0xbfa59261, 0xbf6cd063, 0x3ec2d95b,
    0xbe850888, 0x3fac87dc, 0x3f755ae6, 0xbfa0ee9e,
    0xbf176c69, 0x3ee02a05, 0xbebd6102, 0x3f62eb80,
    0x3fbd99e3, 0x3e4462e6, 0xbf359df8, 0xbf383a21,
    0xbe6415a8, 0x3d855456, 0x3f8d7ac9, 0xbe00c47e,
    0x3e613ab8, 0x3e457d4d, 0xbf9c2cc1, 0x3ee6e8b8,
    0x3e55ec60, 0xbf3463fe, 0xbd9ba6b3, 0x3db188e4,
    0x3fe8cdb6, 0xbf0e7aa0, 0x3ff78cf6, 0xbed791e9,
    0xbe4bef21, 0xbefe4ccd, 0x3f90afd5, 0x3fba6893,
    0xbf869f17, 0x3f06347f, 0x3ebc523d, 0xbf1107ee,
    0x3f982abf, 0x3fa99b5b, 0x3ee8de14, 0x3f1e4c33,
    0xbf0a1532, 0x3fb16674, 0xbdb43f66, 0x3a9d3e04,
    0xbf668c10, 0xbf926178, 0xbf80264e, 0x3f07fbd7,
    0xbe17df32, 0x3d1c7fc1, 0x40003435, 0x3ee77328,
    0x3ee6cd87, 0xbfbdd748, 0x3e35cb95, 0x3dbcc4f3,
    0xbe1a6cf4, 0xbfbd4249, 0xbe45b5ee, 0xbf7c8c5f,
    0x3e97cfc5, 0xbf1f62f9, 0xbea9a064, 0x3e2e555e,
    0x3e50b358, 0xbf0a9956, 0xbf48131b, 0xbfa23d00,
    0xbe690a85, 0xc33323d1, 0x3cd346aa, 0x3fea22e2,
    0x3cee8263, 0xc00c2f84, 0x3ee749bb, 0x3ed0063f,
    0x3edcf166, 0x3f3457b6, 0x3f009b29, 0x3e083c89,
    0x3d8ec326, 0x3ede07a4, 0xbf0ef127, 0x3fda89d1,
    0x3f17a8f0, 0xbf2573ae, 0x3f7e5abf, 0x3f98aa0d,
    0x3f8ffdc2, 0xbfbf6e63, 0xbe058727, 0xbfc6f996,
    0x3f3869fa, 0xbf166d64, 0x3e4fab2c, 0x3f1f21c4,
    0xbf4e53e1, 0x3f01c51d, 0x3d09573d, 0xbf096387,
    0x3ec5671a, 0xbde44f16, 0xbe486bdc, 0xbd6c6f54,
    0xbeb95f2d, 0xbebf5659, 0x3f7bbece, 0xbf14531f,
    0xbf30973e, 0xbf0c8fb3, 0x3fc65fa2, 0x3f0194c4,
    0x3f729912, 0xbf4414ec, 0x40105683, 0xc000c3f9,
    0xbfc0f505, 0x3e8f6c35, 0xbf5e3f63, 0x3ea7116b,
    0xbf053972, 0x3f4f2295, 0x3f22c147, 0x4015a8c7,
    0x3e42cbf9, 0x3fa25bae, 0xbfac6e2f, 0x3fd5ab26,
    0x3fa0ecaa, 0x3e84772b, 0xbf69a38b, 0xbf4e0153,
    0xbeb084a0, 0x3fb2cf1c, 0xbf871c95, 0xbfec5268,
    0xbe16865c, 0xbf61eccc, 0xbf106655, 0xbf15357d,
    0xbd3e9fd1, 0xbe86cd4e, 0xbf1319f7, 0x3ee32205,
    0xbea65582, 0x3ecf5bdd, 0x3e92a03f, 0x3f66f622,
    0xbf650743, 0xbef165ce, 0x3f1d9ab5, 0x3eb5fe8b,
    0x3ecb09b1, 0xbe2b7426, 0xbfb3f3f9, 0x3eee9d04,
    0x3fc5a258, 0xbfb7268c, 0xbde8f372, 0xbc989d44,
    0xbf100753, 0x3f250045, 0xbdac7ee1, 0x3f8355a8,
    0xbce1f409, 0xbe80cdd4, 0xbf56c01e, 0x3d8d281a,
    0xbf0abe9a, 0x3dbadf1b, 0x3f208407, 0x3f560622,
    0xbe050675, 0x3e36842c, 0x3e89fc4f, 0x3c3cf264,
    0x3f679af9, 0xbfa3c6c4, 0xbee649b7, 0x3f16a35b,
    0x3fd31b35, 0xbf71f68c, 0xbefeae83, 0x3fa3ab74,
    0x3f0ef2be, 0x3f068408, 0xbeb74e62, 0xbe69e3ad,
    0xbf3f56af, 0x3f2923b1, 0xbfa38616, 0x3f0fddd2,
    0x3fa4b3c4, 0x402b1d77, 0xbf3c9ac8, 0xbf3a3d07,
    0x3eed07dc, 0xbef7a7f3, 0xc016d452, 0xbb4f0c05,
    0xbf72a872, 0xbe9def7e, 0x3e9dfa7e, 0xbe3b6bcf,
    0xbe562dc4, 0x3ea796bf, 0x3d9c66f4, 0xbd75b7ef,
    0xbf518e7d, 0xbf1d1f0f, 0x3f40ec13, 0xbf040726,
    0x3fd2a25e, 0x3e7ba816, 0xbe3205c3, 0x3fb2fa1b,
    0xbfbc21d5, 0x3f1fbc7c, 0xbea309b9, 0x3debcb36,
    0xbdcc1e9c, 0xbf447ec9, 0xbeb643c7, 0x3ee89f65,
    0x3e0804f2, 0x3f345cca, 0x3f18cd8c, 0xbe1dec89,
    0x3f64f176, 0x3d8564df, 0xbf88caa8, 0x3f1bce7c,
    0x3e41ffc5, 0xbda766da, 0x3f326776, 0x3f8a46e0,
    0xbee5336e, 0x3f581931, 0xbf797b87, 0x3f25fa45,
    0xbf01d8ea, 0xbfedf6df, 0xbe73bed2, 0xbeade010,
    0x3e889f9b, 0xbe3f75f5, 0xbf000fd1, 0xbfdafc5d,
    0x3f8c7592, 0xbed56964, 0x3eed8ddd, 0x3d238292,
    0xbfad167f, 0x3fb73855, 0xbf8a88ba, 0xbf1f184b,
    0xbf5f9639, 0x3f537c84, 0x3efe0e4a, 0x3f99e917,
    0x3ed9385c, 0xbfb18794, 0x3f8ff7fb, 0x3fc542f1,
    0x3f33f135, 0x3fa16dc9, 0x3e405dee, 0xbdbcca2a,
    0xbf476d11, 0xbd88998e, 0x3fcf127b, 0x3e70ef37,
    0xbf2b781f, 0xbfbb5369, 0xbf1405a9, 0x3d877d7f,
    0xbf1f422a, 0xbe8b4660, 0xbbc63dad, 0xbfcc1115,
    0x3d906310, 0x3e08684e, 0xbf15701c, 0xbdd9fd70,
    0x3f4df03b, 0xbda7e021, 0x3f254bed, 0xbe4966be,
    0xbfba80c1, 0x3ea6a501, 0xbe95c56c, 0x3e5acc4c,
    0x3efe88c7, 0xbf2438cd, 0xbf065c96, 0x3fa85530,
    0xbf9be966, 0xbf510c62, 0x3f68ef8f, 0xbf92ccb6,
    0x3f2c4d47, 0xbe6feb9f, 0xbeb9b192, 0x3e751b2f,
    0xbfa1d38d, 0x3ed79761, 0xbf1f3110, 0x3f0aa638,
    0xbdb5511c, 0x3fe0a765, 0xbf128ad4, 0x3fe67613,
    0xbf23c8cc, 0x3f256264, 0x4005d5d0, 0x3f82d0d1,
    0x3f6159a3, 0xbf9f6e36, 0x3f908a14, 0x3f246a5b,
    0x3f3c15d0, 0x3e2e5855, 0x3f3f401b, 0x3db27fe8,
    0xbebcc4f3, 0xbf430e52, 0xbf831ead, 0xbe090d74,
    0x3e21399c, 0xbf9661a9, 0xbe91192a, 0xbf49bcf3,
    0x3f553bc2, 0xbe2f557b, 0x3f1d42bf, 0xbe1fda9f,
    0x3d6ce0e5, 0xbf5e43c5, 0xbf28dce6, 0xbe4baa9c,
    0xc0086a92, 0x3d01ca37, 0xbf543c64, 0x3f02cc58,
    0x3d17dee6, 0x40123d56, 0xbf9b37f1, 0x3e610922,
    0x3f216204, 0xbfb9945d, 0xbf7cf5c2, 0xbe043cd3,
    0xbf195f60, 0x3ea5b3e4, 0xbf664333, 0xbd9eccbb,
    0x3ee1e0d5, 0xbe7742b2, 0x3d95f009, 0xbe5d1384,
    0xbeaba3d2, 0xbfb7bb55, 0xbf9a8ec3, 0x3f219abc,
    0xbea24e93, 0x3fb8ac34, 0xbf018c12, 0x3f3d2cc1,
    0x3f2ec3a7, 0x3ecccfb8, 0xbecdde63, 0x3f89de12,
    0xbf1fddaa, 0xbeecf9d9, 0x3ce71cad, 0xbe911f5a,
    0x3ede7265, 0x3f82043f, 0xbd1e4229, 0x3e7fc680,
    0xbf1e27cb, 0xbfe51cb2, 0xbf331c5d, 0x3e57d298,
    0xbc9b73bb, 0x3de227fd, 0x3fb3dfcd, 0x3dd04981,
    0xbc9c7208, 0x3fa3fd00, 0xbdeecd59, 0xbf01a5a3,
    0x3d0f2ff2, 0xbc9dd326, 0x3fbd4820, 0xbef8e499,
    0xbeaa93d0, 0x3ebe40ca, 0x3f07a6bb, 0x3e8e10a2,
    0x3ebfe39f, 0xbef594e6, 0xbff48856, 0xbcdbcabd,
    0x3d91484e, 0xbfa3284b, 0xbfa09c73, 0x3f106f67,
    0x3ed0128d, 0xbc4a131c, 0xbfa93963, 0xbfafc864,
    0x3efcfd2d, 0xbefea0c1, 0x3f60668c, 0x3f5919a8,
    0xbe71695c, 0xbea65587, 0xbf421b86, 0x3e1a67eb,
    0x3eba203e, 0x3e2e74f2, 0x3f8dff48, 0xbea24203,
    0xbfcfdab1, 0x3f8031dc, 0x3ef4b160, 0x3fd9c28e,
    0x3d9c9018, 0xbf214886, 0xbe90bcab, 0x3ed7459d,
    0xbea56e14, 0x3f8f4934, 0xbda9d514, 0x3e8d6029,
    0x3f1fd18e, 0xbfd2d729, 0x3f879d58, 0x3f4a3e9c,
    0xbef0da21, 0x3fc0ae7c, 0x3e235db0, 0x3e66d338,
    0x3ed5138b, 0x3f851eaf, 0xbf2ce8a5, 0xbfb64dfe,
    0x3e7fea23, 0xbe9d341f, 0x3eeaf683, 0x3f026156,
    0x3f066a5c, 0x0, 0x3eeaf683, 0xbf026156,
    0x3e7fea23, 0x3e9d341f, 0xbf2ce8a5, 0x3fb64dfe,
    0x3ed5138b, 0xbf851eaf, 0x3e235db0, 0xbe66d338,
    0xbef0da21, 0xbfc0ae7c, 0x3f879d58, 0xbf4a3e9c,
    0x3f1fd18e, 0x3fd2d729, 0xbda9d514, 0xbe8d6029,
    0xbea56e14, 0xbf8f4934, 0xbe90bcab, 0xbed7459d,
    0x3d9c9018, 0x3f214886, 0x3ef4b160, 0xbfd9c28e,
    0xbfcfdab1, 0xbf8031dc, 0x3f8dff48, 0x3ea24203,
    0x3eba203e, 0xbe2e74f2, 0xbf421b86, 0xbe1a67eb,
    0xbe71695c, 0x3ea65587, 0x3f60668c, 0xbf5919a8,
    0x3efcfd2d, 0x3efea0c1, 0xbfa93963, 0x3fafc864,
    0x3ed0128d, 0x3c4a131c, 0xbfa09c73, 0xbf106f67,
    0x3d91484e, 0x3fa3284b, 0xbff48856, 0x3cdbcabd,
    0x3ebfe39f, 0x3ef594e6, 0x3f07a6bb, 0xbe8e10a2,
    0xbeaa93d0, 0xbebe40ca, 0x3fbd4820, 0x3ef8e499,
    0x3d0f2ff2, 0x3c9dd326, 0xbdeecd59, 0x3f01a5a3,
    0xbc9c7208, 0xbfa3fd00, 0x3fb3dfcd, 0xbdd04981,
    0xbc9b73bb, 0xbde227fd, 0xbf331c5d, 0xbe57d298,
    0xbf1e27cb, 0x3fe51cb2, 0xbd1e4229, 0xbe7fc680,
    0x3ede7265, 0xbf82043f, 0x3ce71cad, 0x3e911f5a,
    0xbf1fddaa, 0x3eecf9d9, 0xbecdde63, 0xbf89de12,
    0x3f2ec3a7, 0xbecccfb8, 0xbf018c12, 0xbf3d2cc1,
    0xbea24e93, 0xbfb8ac34, 0xbf9a8ec3, 0xbf219abc,
    0xbeaba3d2, 0x3fb7bb55, 0x3d95f009, 0x3e5d1384,
    0x3ee1e0d5, 0x3e7742b2, 0xbf664333, 0x3d9eccbb,
    0xbf195f60, 0xbea5b3e4, 0xbf7cf5c2, 0x3e043cd3,
    0x3f216204, 0x3fb9945d, 0xbf9b37f1, 0xbe610922,
    0x3d17dee6, 0xc0123d56, 0xbf543c64, 0xbf02cc58,
    0xc0086a92, 0xbd01ca37, 0xbf28dce6, 0x3e4baa9c,
    0x3d6ce0e5, 0x3f5e43c5, 0x3f1d42bf, 0x3e1fda9f,
    0x3f553bc2, 0x3e2f557b, 0xbe91192a, 0x3f49bcf3,
    0x3e21399c, 0x3f9661a9, 0xbf831ead, 0x3e090d74,
    0xbebcc4f3, 0x3f430e52, 0x3f3f401b, 0xbdb27fe8,
    0x3f3c15d0, 0xbe2e5855, 0x3f908a14, 0xbf246a5b,
    0x3f6159a3, 0x3f9f6e36, 0x4005d5d0, 0xbf82d0d1,
    0xbf23c8cc, 0xbf256264, 0xbf128ad4, 0xbfe67613,
    0xbdb5511c, 0xbfe0a765, 0xbf1f3110, 0xbf0aa638,
    0xbfa1d38d, 0xbed79761, 0xbeb9b192, 0xbe751b2f,
    0x3f2c4d47, 0x3e6feb9f, 0x3f68ef8f, 0x3f92ccb6,
    0xbf9be966, 0x3f510c62, 0xbf065c96, 0xbfa85530,
    0x3efe88c7, 0x3f2438cd, 0xbe95c56c, 0xbe5acc4c,
    0xbfba80c1, 0xbea6a501, 0x3f254bed, 0x3e4966be,
    0x3f4df03b, 0x3da7e021, 0xbf15701c, 0x3dd9fd70,
    0x3d906310, 0xbe08684e, 0xbbc63dad, 0x3fcc1115,
    0xbf1f422a, 0x3e8b4660, 0xbf1405a9, 0xbd877d7f,
    0xbf2b781f, 0x3fbb5369, 0x3fcf127b, 0xbe70ef37,
    0xbf476d11, 0x3d88998e, 0x3e405dee, 0x3dbcca2a,
    0x3f33f135, 0xbfa16dc9, 0x3f8ff7fb, 0xbfc542f1,
    0x3ed9385c, 0x3fb18794, 0x3efe0e4a, 0xbf99e917,
    0xbf5f9639, 0xbf537c84, 0xbf8a88ba, 0x3f1f184b,
    0xbfad167f, 0xbfb73855, 0x3eed8ddd, 0xbd238292,
    0x3f8c7592, 0x3ed56964, 0xbf000fd1, 0x3fdafc5d,
    0x3e889f9b, 0x3e3f75f5, 0xbe73bed2, 0x3eade010,
    0xbf01d8ea, 0x3fedf6df, 0xbf797b87, 0xbf25fa45,
    0xbee5336e, 0xbf581931, 0x3f326776, 0xbf8a46e0,
    0x3e41ffc5, 0x3da766da, 0xbf88caa8, 0xbf1bce7c,
    0x3f64f176, 0xbd8564df, 0x3f18cd8c, 0x3e1dec89,
    0x3e0804f2, 0xbf345cca, 0xbeb643c7, 0xbee89f65,
    0xbdcc1e9c, 0x3f447ec9, 0xbea309b9, 0xbdebcb36,
    0xbfbc21d5, 0xbf1fbc7c, 0xbe3205c3, 0xbfb2fa1b,
    0x3fd2a25e, 0xbe7ba816, 0x3f40ec13, 0x3f040726,
    0xbf518e7d, 0x3f1d1f0f, 0x3d9c66f4, 0x3d75b7ef,
    0xbe562dc4, 0xbea796bf, 0x3e9dfa7e, 0x3e3b6bcf,
    0xbf72a872, 0x3e9def7e, 0xc016d452, 0x3b4f0c05,
    0x3eed07dc, 0x3ef7a7f3, 0xbf3c9ac8, 0x3f3a3d07,
    0x3fa4b3c4, 0xc02b1d77, 0xbfa38616, 0xbf0fddd2,
    0xbf3f56af, 0xbf2923b1, 0xbeb74e62, 0x3e69e3ad,
    0x3f0ef2be, 0xbf068408, 0xbefeae83, 0xbfa3ab74,
    0x3fd31b35, 0x3f71f68c, 0xbee649b7, 0xbf16a35b,
    0x3f679af9, 0x3fa3c6c4, 0x3e89fc4f, 0xbc3cf264,
    0xbe050675, 0xbe36842c, 0x3f208407, 0xbf560622,
    0xbf0abe9a, 0xbdbadf1b, 0xbf56c01e, 0xbd8d281a,
    0xbce1f409, 0x3e80cdd4, 0xbdac7ee1, 0xbf8355a8,
    0xbf100753, 0xbf250045, 0xbde8f372, 0x3c989d44,
    0x3fc5a258, 0x3fb7268c, 0xbfb3f3f9, 0xbeee9d04,
    0x3ecb09b1, 0x3e2b7426, 0x3f1d9ab5, 0xbeb5fe8b,
    0xbf650743, 0x3ef165ce, 0x3e92a03f, 0xbf66f622,
    0xbea65582, 0xbecf5bdd, 0xbf1319f7, 0xbee32205,
    0xbd3e9fd1, 0x3e86cd4e, 0xbf106655, 0x3f15357d,
    0xbe16865c, 0x3f61eccc, 0xbf871c95, 0x3fec5268,
    0xbeb084a0, 0xbfb2cf1c, 0xbf69a38b, 0x3f4e0153,
    0x3fa0ecaa, 0xbe84772b, 0xbfac6e2f, 0xbfd5ab26,
    0x3e42cbf9, 0xbfa25bae, 0x3f22c147, 0xc015a8c7,
    0xbf053972, 0xbf4f2295, 0xbf5e3f63, 0xbea7116b,
    0xbfc0f505, 0xbe8f6c35, 0x40105683, 0x4000c3f9,
    0x3f729912, 0x3f4414ec, 0x3fc65fa2, 0xbf0194c4,
    0xbf30973e, 0x3f0c8fb3, 0x3f7bbece, 0x3f14531f,
    0xbeb95f2d, 0x3ebf5659, 0xbe486bdc, 0x3d6c6f54,
    0x3ec5671a, 0x3de44f16, 0x3d09573d, 0x3f096387,
    0xbf4e53e1, 0xbf01c51d, 0x3e4fab2c, 0xbf1f21c4,
    0x3f3869fa, 0x3f166d64, 0xbe058727, 0x3fc6f996,
    0x3f8ffdc2, 0x3fbf6e63, 0x3f7e5abf, 0xbf98aa0d,
    0x3f17a8f0, 0x3f2573ae, 0xbf0ef127, 0xbfda89d1,
    0x3d8ec326, 0xbede07a4, 0x3f009b29, 0xbe083c89,
    0x3edcf166, 0xbf3457b6, 0x3ee749bb, 0xbed0063f,
    0x3cee8263, 0x400c2f84, 0x3cd346aa, 0xbfea22e2,
    0xbe690a85, 0x433323d1, 0xbf48131b, 0x3fa23d00,
    0x3e50b358, 0x3f0a9956, 0xbea9a064, 0xbe2e555e,
    0x3e97cfc5, 0x3f1f62f9, 0xbe45b5ee, 0x3f7c8c5f,
    0xbe1a6cf4, 0x3fbd4249, 0x3e35cb95, 0xbdbcc4f3,
    0x3ee6cd87, 0x3fbdd748, 0x40003435, 0xbee77328,
    0xbe17df32, 0xbd1c7fc1, 0xbf80264e, 0xbf07fbd7,
    0xbf668c10, 0x3f926178, 0xbdb43f66, 0xba9d3e04,
    0xbf0a1532, 0xbfb16674, 0x3ee8de14, 0xbf1e4c33,
    0x3f982abf, 0xbfa99b5b, 0x3ebc523d, 0x3f1107ee,
    0xbf869f17, 0xbf06347f, 0x3f90afd5, 0xbfba6893,
    0xbe4bef21, 0x3efe4ccd, 0x3ff78cf6, 0x3ed791e9,
    0x3fe8cdb6, 0x3f0e7aa0, 0xbd9ba6b3, 0xbdb188e4,
    0x3e55ec60, 0x3f3463fe, 0xbf9c2cc1, 0xbee6e8b8,
    0x3e613ab8, 0xbe457d4d, 0x3f8d7ac9, 0x3e00c47e,
    0xbe6415a8, 0xbd855456, 0xbf359df8, 0x3f383a21,
    0x3fbd99e3, 0xbe4462e6, 0xbebd6102, 0xbf62eb80,
    0xbf176c69, 0xbee02a05, 0x3f755ae6, 0x3fa0ee9e,
    0xbe850888, 0xbfac87dc, 0xbf6cd063, 0xbec2d95b,
    0x3f1eaa8b, 0x3fa59261, 0xbf464e4e, 0xbb5de9cb,
    0x3eecad98, 0x3cb75f71, 0x3f798f9d, 0xbf681cf2,
    0xbeab524f, 0xbe903640, 0xbf1b1fdb, 0x3e4a6999,
    0xbdce2149, 0xbe57e852, 0x3e0cfff6, 0x3ef89cee,
    0x3f22c57a, 0xbd85384b, 0x3f01eb7f, 0x3f2c4420,
    0x3ead4981, 0x3d1d7a63, 0xbfb99d0f, 0xbfd89697,
    0xbe5d5796, 0x3e025ae3, 0xbe22829c, 0x3ee02a16,
    0xc00ae901, 0x3fb46ea1, 0xbdc1f9e3, 0xbf52e8ed,
    0xbdbe6922, 0xbe1091c9, 0xbea3a490, 0x3e967dc1,
    0xbf61d0a9, 0xbee86ef9, 0xbfa23d88, 0x3d7aa377,
    0xbf0ab0fc, 0xbf1fc34d, 0x3f9ce3aa, 0x3f172008,
    0xbede80ae, 0x3f86b3c4, 0xbd521742, 0xbeadc4e2,
    0xbf6ee15a, 0xbf48ce24, 0x3f018793, 0x3f50bcfc,
    0xbf3ac92e, 0xbecb0e55, 0xbe0ccb01, 0x3f687b9c
    };

static const uint32_t ref_cfft_noisy_512[1024] = {
    0xbdc714d6, 0x0, 0xbe0ccb01, 0xbf687b9c,
    0xbf3ac92e, 0x3ecb0e55, 0x3f018793, 0xbf50bcfc,
    0xbf6ee15a, 0x3f48ce24, 0xbd521742, 0x3eadc4e2,
    0xbede80ae, 0xbf86b3c4, 0x3f9ce3aa, 0xbf172008,
    0xbf0ab0fc, 0x3f1fc34d, 0xbfa23d88, 0xbd7aa377,
    0xbf61d0a9, 0x3ee86ef9, 0xbea3a490, 0xbe967dc1,
    0xbdbe6922, 0x3e1091c9, 0xbdc1f9e3, 0x3f52e8ed,
    0xc00ae901, 0xbfb46ea1, 0xbe22829c, 0xbee02a16,
    0xbe5d5796, 0xbe025ae3, 0xbfb99d0f, 0x3fd89697,
    0x3ead4981, 0xbd1d7a63, 0x3f01eb7f, 0xbf2c4420,
    0x3f22c57a, 0x3d85384b, 0x3e0cfff6, 0xbef89cee,
    0xbdce2149, 0x3e57e852, 0xbf1b1fdb, 0xbe4a6999,
    0xbeab524f, 0x3e903640, 0x3f798f9d, 0x3f681cf2,
    0x3eecad98, 0xbcb75f71, 0xbf464e4e, 0x3b5de9cb,
    0x3f1eaa8b, 0xbfa59261, 0xbf6cd063, 0x3ec2d95b,
    0xbe850888, 0x3fac87dc, 0x3f755ae6, 0xbfa0ee9e,
    0xbf176c69, 0x3ee02a05, 0xbebd6102, 0x3f62eb80,
    0x3fbd99e3, 0x3e4462e6, 0xbf359df8, 0xbf383a21,
    0xbe6415a8, 0x3d855456, 0x3f8d7ac9, 0xbe00c47e,
    0x3e613ab8, 0x3e457d4d, 0xbf9c2cc1, 0x3ee6e8b8,
    0x3e55ec60, 0xbf3463fe, 0xbd9ba6b3, 0x3db188e4,
    0x3fe8cdb6, 0xbf0e7aa0, 0x3ff78cf6, 0xbed791e9,
    0xbe4bef21, 0xbefe4ccd, 0x3f90afd5, 0x3fba6893,
    0xbf869f17, 0x3f06347f, 0x3ebc523d, 0xbf1107ee,
    0x3f982abf, 0x3fa99b5b, 0x3ee8de14, 0x3f1e4c33,
    0xbf0a1532, 0x3fb16674, 0xbdb43f66, 0x3a9d3e04,
    0xbf668c10, 0xbf926178, 0xbf80264e, 0x3f07fbd7,
    0xbe17df32, 0x3d1c7fc1, 0x40003435, 0x3ee77328,
    0x3ee6cd87, 0xbfbdd748, 0x3e35cb95, 0x3dbcc4f3,
    0xbe1a6cf4, 0xbfbd4249, 0xbe45b5ee, 0xbf7c8c5f,
    0x3e97cfc5, 0xbf1f62f9, 0xbea9a064, 0x3e2e555e,
    0x3e50b358, 0xbf0a9956, 0xbf48131b, 0xbfa23d00,
    0xbe690a85, 0xc33323d1, 0x3cd346aa, 0x3fea22e2,
    0x3cee8263, 0xc00c2f84, 0x3ee749bb, 0x3ed0063f,
    0x3edcf166, 0x3f3457b6, 0x3f009b29, 0x3e083c89,
    0x3d8ec326, 0x3ede07a4, 0xbf0ef127, 0x3fda89d1,
    0x3f17a8f0, 0xbf2573ae, 0x3f7e5abf, 0x3f98aa0d,
    0x3f8ffdc2, 0xbfbf6e63, 0xbe058727, 0xbfc6f996,
    0x3f3869fa, 0xbf166d64, 0x3e4fab2c, 0x3f1f21c4,
    0xbf4e53e1, 0x3f01c51d, 0x3d09573d, 0xbf096387,
    0x3ec5671a, 0xbde44f16, 0xbe486bdc, 0xbd6c6f54,
    0xbeb95f2d, 0xbebf5659, 0x3f7bbece, 0xbf14531f,
    0xbf30973e, 0xbf0c8fb3, 0x3fc65fa2, 0x3f0194c4,
    0x3f729912, 0xbf4414ec, 0x40105683, 0xc000c3f9,
    0xbfc0f505, 0x3e8f6c35, 0xbf5e3f63, 0x3ea7116b,
    0xbf053972, 0x3f4f2295, 0x3f22c147, 0x4015a8c7,
    0x3e42cbf9, 0x3fa25bae, 0xbfac6e2f, 0x3fd5ab26,
    0x3fa0ecaa, 0x3e84772b, 0xbf69a38b, 0xbf4e0153,
    0xbeb084a0, 0x3fb2cf1c, 0xbf871c95, 0xbfec5268,
    0xbe16865c, 0xbf61eccc, 0xbf106655, 0xbf15357d,
    0xbd3e9fd1, 0xbe86cd4e, 0xbf1319f7, 0x3ee32205,
    0xbea65582, 0x3ecf5bdd, 0x3e92a03f, 0x3f66f622,
    0xbf650743, 0xbef165ce, 0x3f1d9ab5, 0x3eb5fe8b,
    0x3ecb09b1, 0xbe2b7426, 0xbfb3f3f9, 0x3eee9d04,
    0x3fc5a258, 0xbfb7268c, 0xbde8f372, 0xbc989d44,
    0xbf100753, 0x3f250045, 0xbdac7ee1, 0x3f8355a8,
    0xbce1f409, 0xbe80cdd4, 0xbf56c01e, 0x3d8d281a,
    0xbf0abe9a, 0x3dbadf1b, 0x3f208407, 0x3f560622,
    0xbe050675, 0x3e36842c, 0x3e89fc4f, 0x3c3cf264,
    0x3f679af9, 0xbfa3c6c4, 0xbee649b7, 0x3f16a35b,
    0x3fd31b35, 0xbf71f68c, 0xbefeae83, 0x3fa3ab74,
    0x3f0ef2be, 0x3f068408, 0xbeb74e62, 0xbe69e3ad,
    0xbf3f56af, 0x3f2923b1, 0xbfa38616, 0x3f0fddd2,
    0x3fa4b3c4, 0x402b1d77, 0xbf3c9ac8, 0xbf3a3d07,
    0x3eed07dc, 0xbef7a7f3, 0xc016d452, 0xbb4f0c05,
    0xbf72a872, 0xbe9def7e, 0x3e9dfa7e, 0xbe3b6bcf,
    0xbe562dc4, 0x3ea796bf, 0x3d9c66f4, 0xbd75b7ef,
    0xbf518e7d, 0xbf1d1f0f, 0x3f40ec13, 0xbf040726,
    0x3fd2a25e, 0x3e7ba816, 0xbe3205c3, 0x3fb2fa1b,
    0xbfbc21d5, 0x3f1fbc7c, 0xbea309b9, 0x3debcb36,
    0xbdcc1e9c, 0xbf447ec9, 0xbeb643c7, 0x3ee89f65,
    0x3e0804f2, 0x3f345cca, 0x3f18cd8c, 0xbe1dec89,
    0x3f64f176, 0x3d8564df, 0xbf88caa8, 0x3f1bce7c,
    0x3e41ffc5, 0xbda766da, 0x3f326776, 0x3f8a46e0,
    0xbee5336e, 0x3f581931, 0xbf797b87, 0x3f25fa45,
    0xbf01d8ea, 0xbfedf6df, 0xbe73bed2, 0xbeade010,
    0x3e889f9b, 0xbe3f75f5, 0xbf000fd1, 0xbfdafc5d,
    0x3f8c7592, 0xbed56964, 0x3eed8ddd, 0x3d238292,
    0xbfad167f, 0x3fb73855, 0xbf8a88ba, 0xbf1f184b,
    0xbf5f9639, 0x3f537c84, 0x3efe0e4a, 0x3f99e917,
    0x3ed9385c, 0xbfb18794, 0x3f8ff7fb, 0x3fc542f1,
    0x3f33f135, 0x3fa16dc9, 0x3e405dee, 0xbdbcca2a,
    0xbf476d11, 0xbd88998e, 0x3fcf127b, 0x3e70ef37,
    0xbf2b781f, 0xbfbb5369, 0xbf1405a9, 0x3d877d7f,
    0xbf1f422a, 0xbe8b4660, 0xbbc63dad, 0xbfcc1115,
    0x3d906310, 0x3e08684e, 0xbf15701c, 0xbdd9fd70,
    0x3f4df03b, 0xbda7e021, 0x3f254bed, 0xbe4966be,
    0xbfba80c1, 0x3ea6a501, 0xbe95c56c, 0x3e5acc4c,
    0x3efe88c7, 0xbf2438cd, 0xbf065c96, 0x3fa85530,
    0xbf9be966, 0xbf510c62, 0x3f68ef8f, 0xbf92ccb6,
    0x3f2c4d47, 0xbe6feb9f, 0xbeb9b192, 0x3e751b2f,
    0xbfa1d38d, 0x3ed79761, 0xbf1f3110, 0x3f0aa638,
    0xbdb5511c, 0x3fe0a765, 0xbf128ad4, 0x3fe67613,
    0xbf23c8cc, 0x3f256264, 0x4005d5d0, 0x3f82d0d1,
    0x3f6159a3, 0xbf9f6e36, 0x3f908a14, 0x3f246a5b,
    0x3f3c15d0, 0x3e2e5855, 0x3f3f401b, 0x3db27fe8,
    0xbebcc4f3, 0xbf430e52, 0xbf831ead, 0xbe090d74,
    0x3e21399c, 0xbf9661a9, 0xbe91192a, 0xbf49bcf3,
    0x3f553bc2, 0xbe2f557b, 0x3f1d42bf, 0xbe1fda9f,
    0x3d6ce0e5, 0xbf5e43c5, 0xbf28dce6, 0xbe4baa9c,
    0xc0086a92, 0x3d01ca37, 0xbf543c64, 0x3f02cc58,
    0x3d17dee6, 0x40123d56, 0xbf9b37f1, 0x3e610922,
    0x3f216204, 0xbfb9945d, 0xbf7cf5c2, 0xbe043cd3,
    0xbf195f60, 0x3ea5b3e4, 0xbf664333, 0xbd9eccbb,
    0x3ee1e0d5, 0xbe7742b2, 0x3d95f009, 0xbe5d1384,
    0xbeaba3d2, 0xbfb7bb55, 0xbf9a8ec3, 0x3f219abc,
    0xbea24e93, 0x3fb8ac34, 0xbf018c12, 0x3f3d2cc1,
    0x3f2ec3a7, 0x3ecccfb8, 0xbecdde63, 0x3f89de12,
    0xbf1fddaa, 0xbeecf9d9, 0x3ce71cad, 0xbe911f5a,
    0x3ede7265, 0x3f82043f, 0xbd1e4229, 0x3e7fc680,
    0xbf1e27cb, 0xbfe51cb2, 0xbf331c5d, 0x3e57d298,
    0xbc9b73bb, 0x3de227fd, 0x3fb3dfcd, 0x3dd04981,
    0xbc9c7208, 0x3fa3fd00, 0xbdeecd59, 0xbf01a5a3,
    0x3d0f2ff2, 0xbc9dd326, 0x3fbd4820, 0xbef8e499,
    0xbeaa93d0, 0x3ebe40ca, 0x3f07a6bb, 0x3e8e10a2,
    0x3ebfe39f, 0xbef594e6, 0xbff48856, 0xbcdbcabd,
    0x3d91484e, 0xbfa3284b, 0xbfa09c73, 0x3f106f67,
    0x3ed0128d, 0xbc4a131c, 0xbfa93963, 0xbfafc864,
    0x3efcfd2d, 0xbefea0c1, 0x3f60668c, 0x3f5919a8,
    0xbe71695c, 0xbea65587, 0xbf421b86, 0x3e1a67eb,
    0x3eba203e, 0x3e2e74f2, 0x3f8dff48, 0xbea24203,
    0xbfcfdab1, 0x3f8031dc, 0x3ef4b160, 0x3fd9c28e,
    0x3d9c9018, 0xbf214886, 0xbe90bcab, 0x3ed7459d,
    0xbea56e14, 0x3f8f4934, 0xbda9d514, 0x3e8d6029,
    0x3f1fd18e, 0xbfd2d729, 0x3f879d58, 0x3f4a3e9c,
    0xbef0da21, 0x3fc0ae7c, 0x3e235db0, 0x3e66d338,
    0x3ed5138b, 0x3f851eaf, 0xbf2ce8a5, 0xbfb64dfe,
    0x3e7fea23, 0xbe9d341f, 0x3eeaf683, 0x3f026156,
    0x3f066a5c, 0x0, 0x3eeaf683, 0xbf026156,
    0x3e7fea23, 0x3e9d341f, 0xbf2ce8a5, 0x3fb64dfe,
    0x3ed5138b, 0xbf851eaf, 0x3e235db0, 0xbe66d338,
    0xbef0da21, 0xbfc0ae7c, 0x3f879d58, 0xbf4a3e9c,
    0x3f1fd18e, 0x3fd2d729, 0xbda9d514, 0xbe8d6029,
    0xbea56e14, 0xbf8f4934, 0xbe90bcab, 0xbed7459d,
    0x3d9c9018, 0x3f214886, 0x3ef4b160, 0xbfd9c28e,
    0xbfcfdab1, 0xbf8031dc, 0x3f8dff48, 0x3ea24203,
    0x3eba203e, 0xbe2e74f2, 0xbf421b86, 0xbe1a67eb,
    0xbe71695c, 0x3ea65587, 0x3f60668c, 0xbf5919a8,
    0x3efcfd2d, 0x3efea0c1, 0xbfa93963, 0x3fafc864,
    0x3ed0128d, 0x3c4a131c, 0xbfa09c73, 0xbf106f67,
    0x3d91484e, 0x3fa3284b, 0xbff48856, 0x3cdbcabd,
    0x3ebfe39f, 0x3ef594e6, 0x3f07a6bb, 0xbe8e10a2,
    0xbeaa93d0, 0xbebe40ca, 0x3fbd4820, 0x3ef8e499,
    0x3d0f2ff2, 0x3c9dd326, 0xbdeecd59, 0x3f01a5a3,
    0xbc9c7208, 0xbfa3fd00, 0x3fb3dfcd, 0xbdd04981,
    0xbc9b73bb, 0xbde227fd, 0xbf331c5d, 0xbe57d298,
    0xbf1e27cb, 0x3fe51cb2, 0xbd1e4229, 0xbe7fc680,
    0x3ede7265, 0xbf82043f, 0x3ce71cad, 0x3e911f5a,
    0xbf1fddaa, 0x3eecf9d9, 0xbecdde63, 0xbf89de12,
    0x3f2ec3a7, 0xbecccfb8, 0xbf018c12, 0xbf3d2cc1,
    0xbea24e93, 0xbfb8ac34, 0xbf9a8ec3, 0xbf219abc,
    0xbeaba3d2, 0x3fb7bb55, 0x3d95f009, 0x3e5d1384,
    0x3ee1e0d5, 0x3e7742b2, 0xbf664333, 0x3d9eccbb,
    0xbf195f60, 0xbea5b3e4, 0xbf7cf5c2, 0x3e043cd3,
    0x3f216204, 0x3fb9945d, 0xbf9b37f1, 0xbe610922,
    0x3d17dee6, 0xc0123d56, 0xbf543c64, 0xbf02cc58,
    0xc0086a92, 0xbd01ca37, 0xbf28dce6, 0x3e4baa9c,
    0x3d6ce0e5, 0x3f5e43c5, 0x3f1d42bf, 0x3e1fda9f,
    0x3f553bc2, 0x3e2f557b, 0xbe91192a, 0x3f49bcf3,
    0x3e21399c, 0x3f9661a9, 0xbf831ead, 0x3e090d74,
    0xbebcc4f3, 0x3f430e52, 0x3f3f401b, 0xbdb27fe8,
    0x3f3c15d0, 0xbe2e5855, 0x3f908a14, 0xbf246a5b,
    0x3f6159a3, 0x3f9f6e36, 0x4005d5d0, 0xbf82d0d1,
    0xbf23c8cc, 0xbf256264, 0xbf128ad4, 0xbfe67613,
    0xbdb5511c, 0xbfe0a765, 0xbf1f3110, 0xbf0aa638,
    0xbfa1d38d, 0xbed79761, 0xbeb9b192, 0xbe751b2f,
    0x3f2c4d47, 0x3e6feb9f, 0x3f68ef8f, 0x3f92ccb6,
    0xbf9be966, 0x3f510c62, 0xbf065c96, 0xbfa85530,
    0x3efe88c7, 0x3f2438cd, 0xbe95c56c, 0xbe5acc4c,
    0xbfba80c1, 0xbea6a501, 0x3f254bed, 0x3e4966be,
    0x3f4df03b, 0x3da7e021, 0xbf15701c, 0x3dd9fd70,
    0x3d906310, 0xbe08684e, 0xbbc63dad, 0x3fcc1115,
    0xbf1f422a, 0x3e8b4660, 0xbf1405a9, 0xbd877d7f,
    0xbf2b781f, 0x3fbb5369, 0x3fcf127b, 0xbe70ef37,
    0xbf476d11, 0x3d88998e, 0x3e405dee, 0x3dbcca2a,
    0x3f33f135, 0xbfa16dc9, 0x3f8ff7fb, 0xbfc542f1,
    0x3ed9385c, 0x3fb18794, 0x3efe0e4a, 0xbf99e917,
    0xbf5f9639, 0xbf537c84, 0xbf8a88ba, 0x3f1f184b,
    0xbfad167f, 0xbfb73855, 0x3eed8ddd, 0xbd238292,
    0x3f8c7592, 0x3ed56964, 0xbf000fd1, 0x3fdafc5d,
    0x3e889f9b, 0x3e3f75f5, 0xbe73bed2, 0x3eade010,
    0xbf01d8ea, 0x3fedf6df, 0xbf797b87, 0xbf25fa45,
    0xbee5336e, 0xbf581931, 0x3f326776, 0xbf8a46e0,
    0x3e41ffc5, 0x3da766da, 0xbf88caa8, 0xbf1bce7c,
    0x3f64f176, 0xbd8564df, 0x3f18cd8c, 0x3e1dec89,
    0x3e0804f2, 0xbf345cca, 0xbeb643c7, 0xbee89f65,
    0xbdcc1e9c, 0x3f447ec9, 0xbea309b9, 0xbdebcb36,
    0xbfbc21d5, 0xbf1fbc7c, 0xbe3205c3, 0xbfb2fa1b,
    0x3fd2a25e, 0xbe7ba816, 0x3f40ec13, 0x3f040726,
    0xbf518e7d, 0x3f1d1f0f, 0x3d9c66f4, 0x3d75b7ef,
    0xbe562dc4, 0xbea796bf, 0x3e9dfa7e, 0x3e3b6bcf,
    0xbf72a872, 0x3e9def7e, 0xc016d452, 0x3b4f0c05,
    0x3eed07dc, 0x3ef7a7f3, 0xbf3c9ac8, 0x3f3a3d07,
    0x3fa4b3c4, 0xc02b1d77, 0xbfa38616, 0xbf0fddd2,
    0xbf3f56af, 0xbf2923b1, 0xbeb74e62, 0x3e69e3ad,
    0x3f0ef2be, 0xbf068408, 0xbefeae83, 0xbfa3ab74,
    0x3fd31b35, 0x3f71f68c, 0xbee649b7, 0xbf16a35b,
    0x3f679af9, 0x3fa3c6c4, 0x3e89fc4f, 0xbc3cf264,
    0xbe050675, 0xbe36842c, 0x3f208407, 0xbf560622,
    0xbf0abe9a, 0xbdbadf1b, 0xbf56c01e, 0xbd8d281a,
    0xbce1f409, 0x3e80cdd4, 0xbdac7ee1, 0xbf8355a8,
    0xbf100753, 0xbf250045, 0xbde8f372, 0x3c989d44,
    0x3fc5a258, 0x3fb7268c, 0xbfb3f3f9, 0xbeee9d04,
    0x3ecb09b1, 0x3e2b7426, 0x3f1d9ab5, 0xbeb5fe8b,
    0xbf650743, 0x3ef165ce, 0x3e92a03f, 0xbf66f622,
    0xbea65582, 0xbecf5bdd, 0xbf1319f7, 0xbee32205,
    0xbd3e9fd1, 0x3e86cd4e, 0xbf106655, 0x3f15357d,
    0xbe16865c, 0x3f61eccc, 0xbf871c95, 0x3fec5268,
    0xbeb084a0, 0xbfb2cf1c, 0xbf69a38b, 0x3f4e0153,
    0x3fa0ecaa, 0xbe84772b, 0xbfac6e2f, 0xbfd5ab26,
    0x3e42cbf9, 0xbfa25bae, 0x3f22c147, 0xc015a8c7,
    0xbf053972, 0xbf4f2295, 0xbf5e3f63, 0xbea7116b,
    0xbfc0f505, 0xbe8f6c35, 0x40105683, 0x4000c3f9,
    0x3f729912, 0x3f4414ec, 0x3fc65fa2, 0xbf0194c4,
    0xbf30973e, 0x3f0c8fb3, 0x3f7bbece, 0x3f14531f,
    0xbeb95f2d, 0x3ebf5659, 0xbe486bdc, 0x3d6c6f54,
    0x3ec5671a, 0x3de44f16, 0x3d09573d, 0x3f096387,
    0xbf4e53e1, 0xbf01c51d, 0x3e4fab2c, 0xbf1f21c4,
    0x3f3869fa, 0x3f166d64, 0xbe058727, 0x3fc6f996,
    0x3f8ffdc2, 0x3fbf6e63, 0x3f7e5abf, 0xbf98aa0d,
    0x3f17a8f0, 0x3f2573ae, 0xbf0ef127, 0xbfda89d1,
    0x3d8ec326, 0xbede07a4, 0x3f009b29, 0xbe083c89,
    0x3edcf166, 0xbf3457b6, 0x3ee749bb, 0xbed0063f,
    0x3cee8263, 0x400c2f84, 0x3cd346aa, 0xbfea22e2,
    0xbe690a85, 0x433323d1, 0xbf48131b, 0x3fa23d00,
    0x3e50b358, 0x3f0a9956, 0xbea9a064, 0xbe2e555e,
    0x3e97cfc5, 0x3f1f62f9, 0xbe45b5ee, 0x3f7c8c5f,
    0xbe1a6cf4, 0x3fbd4249, 0x3e35cb95, 0xbdbcc4f3,
    0x3ee6cd87, 0x3fbdd748, 0x40003435, 0xbee77328,
    0xbe17df32, 0xbd1c7fc1, 0xbf80264e, 0xbf07fbd7,
    0xbf668c10, 0x3f926178, 0xbdb43f66, 0xba9d3e04,
    0xbf0a1532, 0xbfb16674, 0x3ee8de14, 0xbf1e4c33,
    0x3f982abf, 0xbfa99b5b, 0x3ebc523d, 0x3f1107ee,
    0xbf869f17, 0xbf06347f, 0x3f90afd5, 0xbfba6893,
    0xbe4bef21, 0x3efe4ccd, 0x3ff78cf6, 0x3ed791e9,
    0x3fe8cdb6, 0x3f0e7aa0, 0xbd9ba6b3, 0xbdb188e4,
    0x3e55ec60, 0x3f3463fe, 0xbf9c2cc1, 0xbee6e8b8,
    0x3e613ab8, 0xbe457d4d, 0x3f8d7ac9, 0x3e00c47e,
    0xbe6415a8, 0xbd855456, 0xbf359df8, 0x3f383a21,
    0x3fbd99e3, 0xbe4462e6, 0xbebd6102, 0xbf62eb80,
    0xbf176c69, 0xbee02a05, 0x3f755ae6, 0x3fa0ee9e,
    0xbe850888, 0xbfac87dc, 0xbf6cd063, 0xbec2d95b,
    0x3f1eaa8b, 0x3fa59261, 0xbf464e4e, 0xbb5de9cb,
    0x3eecad98, 0x3cb75f71, 0x3f798f9d, 0xbf681cf2,
    0xbeab524f, 0xbe903640, 0xbf1b1fdb, 0x3e4a6999,
    0xbdce2149, 0xbe57e852, 0x3e0cfff6, 0x3ef89cee,
    0x3f22c57a, 0xbd85384b, 0x3f01eb7f, 0x3f2c4420,
    0x3ead4981, 0x3d1d7a63, 0xbfb99d0f, 0xbfd89697,
    0xbe5d5796, 0x3e025ae3, 0xbe22829c, 0x3ee02a16,
    0xc00ae901, 0x3fb46ea1, 0xbdc1f9e3, 0xbf52e8ed,
    0xbdbe6922, 0xbe1091c9, 0xbea3a490, 0x3e967dc1,
    0xbf61d0a9, 0xbee86ef9, 0xbfa23d88, 0x3d7aa377,
    0xbf0ab0fc, 0xbf1fc34d, 0x3f9ce3aa, 0x3f172008,
    0xbede80ae, 0x3f86b3c4, 0xbd521742, 0xbeadc4e2,
    0xbf6ee15a, 0xbf48ce24, 0x3f018793, 0x3f50bcfc,
    0xbf3ac92e, 0xbecb0e55, 0xbe0ccb01, 0x3f687b9c
    };

static const uint32_t in_cfft_noisy_1024[2048] = {
    0xbcd6a782, 0x0, 0x3f0b014e, 0x0,
    0x3f40e889, 0x0, 0x3f00d5e1, 0x0,
    0x3d05b51e, 0x0, 0xbf09cc43, 0x0,
    0xbf229bb1, 0x0, 0xbeefeccb, 0x0,
    0x3c5e8edf, 0x0, 0x3efaade0, 0x0,
    0x3f2e2b15, 0x0, 0x3ee7b684, 0x0,
    0x3d0eccfa, 0x0, 0xbf00700d, 0x0,
    0xbf37283b, 0x0, 0xbed9adf0, 0x0,
    0xbcb7058f, 0x0, 0x3f076c03, 0x0,
    0x3f29c29b, 0x0, 0x3ef1dc1b, 0x0,
    0xbd222038, 0x0, 0xbf0008ca, 0x0,
    0xbf297a6e, 0x0, 0xbf02745f, 0x0,
    0xbd475ffe, 0x0, 0x3ee3ce6a, 0x0,
    0x3f50d8ab, 0x0, 0x3f020878, 0x0,
    0xbcfc3f77, 0x0, 0xbf034420, 0x0,
    0xbf45386c, 0x0, 0xbf005880, 0x0,
    0xbb523d30, 0x0, 0x3eea2c58, 0x0,
    0x3f3eacc0, 0x0, 0x3ef384b6, 0x0,
    0x3d22bd4c, 0x0, 0xbf0c26bf, 0x0,
    0xbf1cbf5d, 0x0, 0xbeeabb1a, 0x0,
    0xbd929dbf, 0x0, 0x3f0128b6, 0x0,
    0x3f4acf3f, 0x0, 0x3ef4d138, 0x0,
    0x3d8a373b, 0x0, 0xbeddcc1d, 0x0,
    0xbf30195c, 0x0, 0xbf09ecda, 0x0,
    0xbd2bd03e, 0x0, 0x3efb01b3, 0x0,
    0x3f3bc488, 0x0, 0x3f02bc3b, 0x0,
    0x3d209ce3, 0x0, 0xbee98787, 0x0,
    0xbf2ee08d, 0x0, 0xbf05f10f, 0x0,
    0xbb756ae7, 0x0, 0x3f0b5a6e, 0x0,
    0x3f3baaae, 0x0, 0x3eee735c, 0x0,
    0xbcd5e325, 0x0, 0xbf0e1dbd, 0x0,
    0xbf259249, 0x0, 0xbeface92, 0x0,
    0xbd0e5e88, 0x0, 0x3eec2fd3, 0x0,
    0x3f35b6c2, 0x0, 0x3f18b748, 0x0,
    0xbd23bf78, 0x0, 0xbef17775, 0x0,
    0xbf30aa1d, 0x0, 0xbf279478, 0x0,
    0xbd6dbe2b, 0x0, 0x3effbb83, 0x0,
    0x3f3f12ec, 0x0, 0x3f1b10f3, 0x0,
    0xbd3e0bdc, 0x0, 0xbf1681bc, 0x0,
    0xbf34c312, 0x0, 0xbeeb33c8, 0x0,
    0x3c6ded95, 0x0, 0x3eda9b77, 0x0,
    0x3f30395f, 0x0, 0x3ee525cb, 0x0,
    0xbda479ae, 0x0, 0xbef9c67c, 0x0,
    0xbf2dc834, 0x0, 0xbf0867b2, 0x0,
    0x3bb982c4, 0x0, 0x3ee77d97, 0x0,
    0x3f29fd46, 0x0, 0x3f0c1fc5, 0x0,
    0x3d7069ea, 0x0, 0xbeea93d9, 0x0,
    0xbf32032c, 0x0, 0xbec6e57b, 0x0,
    0x3d09494d, 0x0, 0x3f060961, 0x0,
    0x3f36e778, 0x0, 0x3f0a3c09, 0x0,
    0x3d9691e8, 0x0, 0xbedadf6a, 0x0,
    0xbf2d1a7c, 0x0, 0xbf0de72a, 0x0,
    0x3cdabf16, 0x0, 0x3f066b4c, 0x0,
    0x3f21031d, 0x0, 0x3ef0f1bc, 0x0,
    0x3c054719, 0x0, 0xbef21d94, 0x0,
    0xbf402f80, 0x0, 0xbf06bbb7, 0x0,
    0x3d07fb7e, 0x0, 0x3eddabc8, 0x0,
    0x3f4468c7, 0x0, 0x3ee8de2d, 0x0,
    0xbd21fb36, 0x0, 0xbf124529, 0x0,
    0xbf2b1695, 0x0, 0xbf085cf0, 0x0,
    0x3c850a3d, 0x0, 0x3ee983c7, 0x0,
    0x3f063fa2, 0x0, 0x3ee9bf74, 0x0,
    0x3d7ae48e, 0x0, 0xbf075298, 0x0,
    0xbf41b73c, 0x0, 0xbeea47d3, 0x0,
    0xbc0f824d, 0x0, 0x3efdaeec, 0x0,
    0x3f504e08, 0x0, 0x3f101c0e, 0x0,
    0xbd6b0031, 0x0, 0xbef36e0a, 0x0,
    0xbf4445de, 0x0, 0xbecdc427, 0x0,
    0x3c8eef52, 0x0, 0x3ef92042, 0x0,
    0x3f2f96b4, 0x0, 0x3eec9d63, 0x0,
    0x3d713d83, 0x0, 0xbf07e83f, 0x0,
    0xbf26847a, 0x0, 0xbefca453, 0x0,
    0xbc09f8fe, 0x0, 0x3f086072, 0x0,
    0x3f23323c, 0x0, 0x3f027fbb, 0x0,
    0xbdc16624, 0x0, 0xbeea2ae8, 0x0,
    0xbf251ae9, 0x0, 0xbee3dcca, 0x0,
    0x3c376f95, 0x0, 0x3eeaa193, 0x0,
    0x3f305ddb, 0x0, 0x3f17513a, 0x0,
    0x3d866487, 0x0, 0xbf032d9d, 0x0,
    0xbf3630f1, 0x0, 0xbf0dd5ca, 0x0,
    0x3d9f6309, 0x0, 0x3ed500d6, 0x0,
    0x3f418404, 0x0, 0x3f1671fa, 0x0,
    0xbdc0ef6a, 0x0, 0xbf03b8d1, 0x0,
    0xbf3c23d6, 0x0, 0xbed7b5ca, 0x0,
    0x3d887189, 0x0, 0x3f0055bc, 0x0,
    0x3f4b3397, 0x0, 0x3f0a9ce3, 0x0,
    0xbda86078, 0x0, 0xbf00f5dd, 0x0,
    0xbf2db503, 0x0, 0xbeffbd9b, 0x0,
    0x3dd29311, 0x0, 0x3f23b98e, 0x0,
    0x3f3247eb, 0x0, 0x3ee29464, 0x0,
    0xbd4848e2, 0x0, 0xbf10624e, 0x0,
    0xbf351dff, 0x0, 0xbf0759a8, 0x0,
    0x3e00855b, 0x0, 0x3efcfd10, 0x0,
    0x3f3553b4, 0x0, 0x3eff21ed, 0x0,
    0x3a0c7375, 0x0, 0xbef22a09, 0x0,
    0xbf346778, 0x0, 0xbf00599c, 0x0,
    0xbc87501b, 0x0, 0x3f094e71, 0x0,
    0x3f2c2ade, 0x0, 0x3f04fd1e, 0x0,
    0x3dbb67aa, 0x0, 0xbf04748d, 0x0,
    0xbf3cb1af, 0x0, 0xbee93a64, 0x0,
    0xbc0f4552, 0x0, 0x3f11339b, 0x0,
    0x3f32643c, 0x0, 0x3f05b98f, 0x0,
    0xbdaeb6ca, 0x0, 0xbed79a98, 0x0,
    0xbf3c2cec, 0x0, 0xbed06e03, 0x0,
    0x3d613216, 0x0, 0x3f1004ca, 0x0,
    0x3f3603c6, 0x0, 0x3f0ef1fd, 0x0,
    0xbb5d5f16, 0x0, 0xbf09dd6e, 0x0,
    0xbf1ed758, 0x0, 0xbf07ac3b, 0x0,
    0xbe0b9dee, 0x0, 0x3f10dc79, 0x0,
    0x3f311d4f, 0x0, 0x3ee6ff00, 0x0,
    0xbd7877ad, 0x0, 0xbf030d09, 0x0,
    0xbf2791d4, 0x0, 0xbf22c5a1, 0x0,
    0x3bdea0ba, 0x0, 0x3eeffd13, 0x0,
    0x3f242798, 0x0, 0x3f17a360, 0x0,
    0xbcebe1c4, 0x0, 0xbeea9108, 0x0,
    0xbf39a313, 0x0, 0xbedb1b69, 0x0,
    0xbd929ccb, 0x0, 0x3ef86420, 0x0,
    0x3f3ef828, 0x0, 0x3efac56b, 0x0,
    0xbb219e38, 0x0, 0xbf018f9a, 0x0,
    0xbf28f5b5, 0x0, 0xbeee7f08, 0x0,
    0xbd5b9dfa, 0x0, 0x3eeec2a2, 0x0,
    0x3f2282bf, 0x0, 0x3f01391d, 0x0,
    0x3d4639f7, 0x0, 0xbf10a0c2, 0x0,
    0xbf412946, 0x0, 0xbee35a69, 0x0,
    0x3d61b484, 0x0, 0x3ee661a9, 0x0,
    0x3f38f81c, 0x0, 0x3ed84910, 0x0,
    0xbd420296, 0x0, 0xbef9bdde, 0x0,
    0xbf3a6a29, 0x0, 0xbeedb21c, 0x0,
    0xbbc6644e, 0x0, 0x3efa2729, 0x0,
    0x3f35b482, 0x0, 0x3ee429b7, 0x0,
    0xbc03ae17, 0x0, 0xbef16306, 0x0,
    0xbf30ecea, 0x0, 0xbef5ed61, 0x0,
    0x3c1ad265, 0x0, 0x3f13ac13, 0x0,
    0x3f2e6a84, 0x0, 0x3ef6e30c, 0x0,
    0xbcea21f4, 0x0, 0xbef45c1f, 0x0,
    0xbf20cd1b, 0x0, 0xbed83f29, 0x0,
    0x3d2d591c, 0x0, 0x3f245b61, 0x0,
    0x3f133984, 0x0, 0x3eec0b65, 0x0,
    0x3cdf9178, 0x0, 0xbf04d0f3, 0x0,
    0xbf2db7c9, 0x0, 0xbf051384, 0x0,
    0xbd039fdb, 0x0, 0x3eee81db, 0x0,
    0x3f418339, 0x0, 0x3f0572aa, 0x0,
    0x3d10ce56, 0x0, 0xbf0c7fdb, 0x0,
    0xbf1453e8, 0x0, 0xbee334d5, 0x0,
    0x3c7490a9, 0x0, 0x3f085054, 0x0,
    0x3f2f43dc, 0x0, 0x3efe7c53, 0x0,
    0xbd948e22, 0x0, 0xbee88555, 0x0,
    0xbf370a3e, 0x0, 0xbf03178a, 0x0,
    0x3d28eee6, 0x0, 0x3f133cbf, 0x0,
    0x3f42f647, 0x0, 0x3ee898f7, 0x0,
    0xbcf40657, 0x0, 0xbeee81c8, 0x0,
    0xbf40245f, 0x0, 0xbeea7334, 0x0,
    0x3c920e63, 0x0, 0x3f0b7009, 0x0,
    0x3f189649, 0x0, 0x3eeebe54, 0x0,
    0x3d2960ee, 0x0, 0xbef4f4a0, 0x0,
    0xbf448181, 0x0, 0xbf070506, 0x0,
    0x3c40946a, 0x0, 0x3f00be15, 0x0,
    0x3f2aa9c3, 0x0, 0x3f195c98, 0x0,
    0x3d0bf5a3, 0x0, 0xbf020dfa, 0x0,
    0xbf35bde8, 0x0, 0xbf009ea4, 0x0,
    0x3d5d3095, 0x0, 0x3f0aad1b, 0x0,
    0x3f466716, 0x0, 0x3efc1a37, 0x0,
    0x3dd086ba, 0x0, 0xbf0aa6d3, 0x0,
    0xbf2e9d2d, 0x0, 0xbf12f631, 0x0,
    0xbd651ef2, 0x0, 0x3eca9262, 0x0,
    0x3f370419, 0x0, 0x3eee3c51, 0x0,
    0xbcace2c7, 0x0, 0xbedb115b, 0x0,
    0xbf1d0085, 0x0, 0xbecae972, 0x0,
    0xbdac5fc8, 0x0, 0x3ef6084e, 0x0,
    0x3f2ed77f, 0x0, 0x3ef3a0ff, 0x0,
    0xbd5ff11f, 0x0, 0xbf0e8015, 0x0,
    0xbf27b6d7, 0x0, 0xbf060a13, 0x0,
    0x3d3dd91b, 0x0, 0x3f0ddf84, 0x0,
    0x3f380e9f, 0x0, 0x3eef9ed9, 0x0,
    0x3d65a59a, 0x0, 0xbeffb7a6, 0x0,
    0xbf2d4eb9, 0x0, 0xbf0d4a98, 0x0,
    0xbd28cbda, 0x0, 0x3f02c791, 0x0,
    0x3f154b27, 0x0, 0x3f08674f, 0x0,
    0xbba81a86, 0x0, 0xbee85b3f, 0x0,
    0xbf1eca80, 0x0, 0xbee8ae17, 0x0,
    0x3d68155b, 0x0, 0x3eef4544, 0x0,
    0x3f2981ee, 0x0, 0x3ed7d98e, 0x0,
    0x3c0e511f, 0x0, 0xbf0ade19, 0x0,
    0xbf1e57bb, 0x0, 0xbed57f51, 0x0,
    0xbca6af3a, 0x0, 0x3f1226ea, 0x0,
    0x3f2a294a, 0x0, 0x3ef5b8f1, 0x0,
    0xbb1dd80e, 0x0, 0xbefe213b, 0x0,
    0xbf2e1787, 0x0, 0xbef329e6, 0x0,
    0xbd9d251a, 0x0, 0x3f08bfd9, 0x0,
    0x3f350a4a, 0x0, 0x3f138e48, 0x0,
    0x3bde396d, 0x0, 0xbf0cfff7, 0x0,
    0xbf31cd2d, 0x0, 0xbf049cae, 0x0,
    0xbda3fe27, 0x0, 0x3f11b3eb, 0x0,
    0x3f1bbbd4, 0x0, 0x3f10a66c, 0x0,
    0x3d925340, 0x0, 0xbef07d9b, 0x0,
    0xbf35ed58, 0x0, 0xbef0e66c, 0x0,
    0xbd2484ba, 0x0, 0x3ee2321d, 0x0,
    0x3f37e437, 0x0, 0x3f10b1f0, 0x0,
    0xbce7c365, 0x0, 0xbf0ba740, 0x0,
    0xbf353280, 0x0, 0xbee6c202, 0x0,
    0xbda5133f, 0x0, 0x3f07d221, 0x0,
    0x3f33b2c0, 0x0, 0x3eeb4cb2, 0x0,
    0xbd373409, 0x0, 0xbf1e8e47, 0x0,
    0xbf38683a, 0x0, 0xbee41ac6, 0x0,
    0x3c250128, 0x0, 0x3ecb62c8, 0x0,
    0x3f3d067f, 0x0, 0x3f01fbe2, 0x0,
    0x3dbcd918, 0x0, 0xbf0fd67f, 0x0,
    0xbf3759b5, 0x0, 0xbef43cc2, 0x0,
    0x3d347aa2, 0x0, 0x3ef11cfb, 0x0,
    0x3f2d2bf3, 0x0, 0x3f088878, 0x0,
    0xbd186980, 0x0, 0xbee88d19, 0x0,
    0xbf34d4c9, 0x0, 0xbf084c69, 0x0,
    0xba9cc2fd, 0x0, 0x3f0f9fa7, 0x0,
    0x3f23009a, 0x0, 0x3ed906df, 0x0,
    0xbcf847f9, 0x0, 0xbee0454e, 0x0,
    0xbf48c66f, 0x0, 0xbef25e8e, 0x0,
    0xbd37b00c, 0x0, 0x3f11e9b5, 0x0,
    0x3f39f2a9, 0x0, 0x3f05efa9, 0x0,
    0xbd77c3d5, 0x0, 0xbee66f79, 0x0,
    0xbf3d2912, 0x0, 0xbf020d62, 0x0,
    0x3c386891, 0x0, 0x3f1bf46c, 0x0,
    0x3f2f8885, 0x0, 0x3ee57c92, 0x0,
    0x3c2aed9f, 0x0, 0xbef0257c, 0x0,
    0xbf1c38c0, 0x0, 0xbecfd6c1, 0x0,
    0xbc513df0, 0x0, 0x3f0643aa, 0x0,
    0x3f3b7db3, 0x0, 0x3edb3c0c, 0x0,
    0x3ce9335f, 0x0, 0xbf15ea49, 0x0,
    0xbf31bbcf, 0x0, 0xbefd5ddb, 0x0,
    0xbb9f361e, 0x0, 0x3ef73d0c, 0x0,
    0x3f23adfa, 0x0, 0x3ef42404, 0x0,
    0xbcaacef7, 0x0, 0xbf0b56cd, 0x0,
    0xbf372bc1, 0x0, 0xbef8f1bd, 0x0,
    0x3d3c6e2b, 0x0, 0x3f1512f4, 0x0,
    0x3f3f1dfa, 0x0, 0x3f0034c5, 0x0,
    0xbd27a0fd, 0x0, 0xbefc3c05, 0x0,
    0xbf3b9001, 0x0, 0xbf1da024, 0x0,
    0xbd56b5ba, 0x0, 0x3f065bc1, 0x0,
    0x3f19a5a8, 0x0, 0x3ee6b64e, 0x0,
    0xbc05ed69, 0x0, 0xbef72f17, 0x0,
    0xbf3fd8cd, 0x0, 0xbf0974e7, 0x0,
    0xbe039cc7, 0x0, 0x3ef6cdcd, 0x0,
    0x3f3943a8, 0x0, 0x3ef2ecbd, 0x0,
    0x3c6a2088, 0x0, 0xbeebb814, 0x0,
    0xbf332874, 0x0, 0xbef729cb, 0x0,
    0x3d4b1d58, 0x0, 0x3f07c4a1, 0x0,
    0x3f40bfd0, 0x0, 0x3f0a5d5b, 0x0,
    0xbda2d39d, 0x0, 0xbeef819a, 0x0,
    0xbf1bd803, 0x0, 0xbee42afc, 0x0,
    0x3caa25f1, 0x0, 0x3ee5456a, 0x0,
    0x3f2bb74a, 0x0, 0x3f0e0cf3, 0x0,
    0x3d60a014, 0x0, 0xbf06142c, 0x0,
    0xbf45d6b7, 0x0, 0xbeedc5d1, 0x0,
    0xbd9b3104, 0x0, 0x3ee2cbbe, 0x0,
    0x3f2ef486, 0x0, 0x3f03516d, 0x0,
    0xbd45fe94, 0x0, 0xbef0b7ca, 0x0,
    0xbf41edcf, 0x0, 0xbeeec2af, 0x0,
    0x3d601620, 0x0, 0x3ee99a4b, 0x0,
    0x3f245626, 0x0, 0x3f07ad34, 0x0,
    0xbc7d8386, 0x0, 0xbeeda02a, 0x0,
    0xbf35fb16, 0x0, 0xbef9eef1, 0x0,
    0x3af765f5, 0x0, 0x3ee1f1df, 0x0,
    0x3f32a591, 0x0, 0x3efdcbc0, 0x0,
    0x3d82d1af, 0x0, 0xbed6b00d, 0x0,
    0xbf2a82c5, 0x0, 0xbedde541, 0x0,
    0x3c14cfae, 0x0, 0x3f1aa34a, 0x0,
    0x3f398134, 0x0, 0x3ee8dc0b, 0x0,
    0xbce8ba40, 0x0, 0xbedeacef, 0x0,
    0xbf3634be, 0x0, 0xbeff7394, 0x0,
    0x3daaeae7, 0x0, 0x3efd731c, 0x0,
    0x3f3adc50, 0x0, 0x3ef20443, 0x0,
    0x3cf47a2c, 0x0, 0xbf131305, 0x0,
    0xbf3bf45a, 0x0, 0xbf0091be, 0x0,
    0xbd50eb16, 0x0, 0x3f040e6c, 0x0,
    0x3f25e24a, 0x0, 0x3f081b15, 0x0,
    0xbd1cc204, 0x0, 0xbf004b33, 0x0,
    0xbf2247e3, 0x0, 0xbf0112a2, 0x0,
    0xbc8275e5, 0x0, 0x3edf0afc, 0x0,
    0x3f319176, 0x0, 0x3f029502, 0x0,
    0x3d277727, 0x0, 0xbf0f6981, 0x0,
    0xbf2d09e9, 0x0, 0xbef9cac3, 0x0,
    0x3bbe691d, 0x0, 0x3efe04c0, 0x0,
    0x3f2e4892, 0x0, 0x3f01713d, 0x0,
    0xbde49d85, 0x0, 0xbed2f77e, 0x0,
    0xbf2039cb, 0x0, 0xbf01418f, 0x0,
    0x3d06f694, 0x0, 0x3edacfee, 0x0,
    0x3f31bedd, 0x0, 0x3f139633, 0x0,
    0xbd29b930, 0x0, 0xbed944a9, 0x0,
    0xbf2e1755, 0x0, 0xbf09f87e, 0x0,
    0x3d2efce2, 0x0, 0x3eeea458, 0x0,
    0x3f3cee69, 0x0, 0x3f11b6e5, 0x0,
    0xbcf63782, 0x0, 0xbef8d78f, 0x0,
    0xbf35fa79, 0x0, 0xbf0d1555, 0x0,
    0xbd05a38c, 0x0, 0x3eda2295, 0x0,
    0x3f2bbaf9, 0x0, 0x3ee84a97, 0x0,
    0x38c931ec, 0x0, 0xbf119dc3, 0x0,
    0xbf3e5781, 0x0, 0xbf0e32bc, 0x0,
    0x3ce7212a, 0x0, 0x3ee7441c, 0x0,
    0x3f0d06f4, 0x0, 0x3ef9f6ab, 0x0,
    0x3bdb49a4, 0x0, 0xbefb7859, 0x0,
    0xbf23ec1f, 0x0, 0xbf027526, 0x0,
    0x3d7745d3, 0x0, 0x3eec5f1d, 0x0,
    0x3f40483f, 0x0, 0x3f05c04a, 0x0,
    0xbd306dc9, 0x0, 0xbf161245, 0x0,
    0xbf2bb04f, 0x0, 0xbf0eab7a, 0x0,
    0x3df19b97, 0x0, 0x3ed17d68, 0x0,
    0x3f44d8c7, 0x0, 0x3f043f84, 0x0,
    0xbd2ff539, 0x0, 0xbefed166, 0x0,
    0xbf1bba3c, 0x0, 0xbee5d246, 0x0,
    0xbd11e7bb, 0x0, 0x3efb7c79, 0x0,
    0x3f1b5ccb, 0x0, 0x3ee2d765, 0x0,
    0xbd053518, 0x0, 0xbf00204f, 0x0,
    0xbf3325b4, 0x0, 0xbeee571e, 0x0,
    0x3c725af9, 0x0, 0x3f0ef3a8, 0x0,
    0x3f20e6c1, 0x0, 0x3ef526be, 0x0,
    0x3c092303, 0x0, 0xbf011977, 0x0,
    0xbf4b5410, 0x0, 0xbf00c1b3, 0x0,
    0xbd040efd, 0x0, 0x3ee1f947, 0x0,
    0x3f2b05e4, 0x0, 0x3efd259e, 0x0,
    0xbcfce48e, 0x0, 0xbed0f58f, 0x0,
    0xbf36dcff, 0x0, 0xbef419eb, 0x0,
    0xbbd9fdd8, 0x0, 0x3f03e723, 0x0,
    0x3f316564, 0x0, 0x3f03c1d8, 0x0,
    0xbd54a143, 0x0, 0xbf1e74f0, 0x0,
    0xbf33dafa, 0x0, 0xbef43f3b, 0x0,
    0x3d0ae0e5, 0x0, 0x3ef52e52, 0x0,
    0x3f344f29, 0x0, 0x3ee31f50, 0x0,
    0xbbae35ad, 0x0, 0xbed6c2dc, 0x0,
    0xbf3ba4bf, 0x0, 0xbecf688f, 0x0,
    0xbd49910d, 0x0, 0x3ede729b, 0x0,
    0x3f28a07f, 0x0, 0x3ee962e0, 0x0,
    0xbda268c7, 0x0, 0xbeef2f10, 0x0,
    0xbf24274c, 0x0, 0xbef7d31f, 0x0,
    0x3d1e37c3, 0x0, 0x3ee0bf70, 0x0,
    0x3f315d75, 0x0, 0x3f2affbc, 0x0,
    0x3da2c7be, 0x0, 0xbf18c8df, 0x0,
    0xbf3cc500, 0x0, 0xbed4f4de, 0x0,
    0xbd0ed607, 0x0, 0x3efeedd8, 0x0,
    0x3f3a2d49, 0x0, 0x3f138548, 0x0,
    0xbd39ea9d, 0x0, 0xbf0a1aca, 0x0,
    0xbf0e0600, 0x0, 0xbedc580f, 0x0,
    0xbc8e3877, 0x0, 0x3f046c98, 0x0,
    0x3f32f329, 0x0, 0x3f06d546, 0x0,
    0xbd517a30, 0x0, 0xbee002b3, 0x0,
    0xbf36255b, 0x0, 0xbf00668a, 0x0,
    0x3bca8ac3, 0x0, 0x3ee41117, 0x0,
    0x3f109ef2, 0x0, 0x3f0189cc, 0x0,
    0xbdb4c52d, 0x0, 0xbef53725, 0x0,
    0xbf469e0d, 0x0, 0xbf0fb07c, 0x0,
    0xbd6d68de, 0x0, 0x3ef72a98, 0x0,
    0x3f291431, 0x0, 0x3f1742ca, 0x0,
    0x3d15078d, 0x0, 0xbeba9623, 0x0,
    0xbf3ad9ba, 0x0, 0xbef53328, 0x0,
    0xbdbd1210, 0x0, 0x3eec6dfe, 0x0,
    0x3f4050ce, 0x0, 0x3f029e04, 0x0,
    0x3da300e4, 0x0, 0xbee962dd, 0x0,
    0xbf2ac0a2, 0x0, 0xbf011030, 0x0,
    0xbba8cf91, 0x0, 0x3f061c13, 0x0,
    0x3f24defe, 0x0, 0x3f12ce66, 0x0,
    0xbaac1394, 0x0, 0xbf00b874, 0x0,
    0xbf1fe8a0, 0x0, 0xbf0a6094, 0x0,
    0xbdbea213, 0x0, 0x3f0b3230, 0x0,
    0x3f2a8def, 0x0, 0x3ef6ddfd, 0x0,
    0xbda22dc3, 0x0, 0xbef8b7e7, 0x0,
    0xbf3f22d6, 0x0, 0xbef093cc, 0x0,
    0xbd2c16b8, 0x0, 0x3eb48b9b, 0x0,
    0x3f2fdfbf, 0x0, 0x3ef893a8, 0x0,
    0x3ce84cb2, 0x0, 0xbef48980, 0x0,
    0xbf2764e7, 0x0, 0xbf0f61e5, 0x0,
    0x3d65e368, 0x0, 0x3f06c81b, 0x0,
    0x3f3fd040, 0x0, 0x3f04b99d, 0x0,
    0xbdfbbf01, 0x0, 0xbef77028, 0x0,
    0xbf3d8e17, 0x0, 0xbed63409, 0x0,
    0xbc325b67, 0x0, 0x3eeca0b0, 0x0,
    0x3f3cab0e, 0x0, 0x3efe0644, 0x0,
    0x3d9294a4, 0x0, 0xbf03cb8c, 0x0,
    0xbf333012, 0x0, 0xbf08cd5c, 0x0,
    0x3d163ded, 0x0, 0x3ef59b8c, 0x0,
    0x3f1825f7, 0x0, 0x3f05d410, 0x0,
    0x3c879232, 0x0, 0xbf150c63, 0x0,
    0xbf19058d, 0x0, 0xbf0f15e9, 0x0,
    0xbc2baec9, 0x0, 0x3f05e699, 0x0,
    0x3f576578, 0x0, 0x3f017ecd, 0x0,
    0x3cc09283, 0x0, 0xbed69c15, 0x0,
    0xbf34aa71, 0x0, 0xbed0b81d, 0x0,
    0xbb9acc15, 0x0, 0x3ee63a96, 0x0,
    0x3f283923, 0x0, 0x3f03fae8, 0x0,
    0xbd174365, 0x0, 0xbf032e84, 0x0,
    0xbf4344ff, 0x0, 0xbf070318, 0x0,
    0xb971fd74, 0x0, 0x3eee50ca, 0x0,
    0x3f20a781, 0x0, 0x3f1253a5, 0x0,
    0xbbd4c01c, 0x0, 0xbf04ef69, 0x0,
    0xbf4790e3, 0x0, 0xbef318ff, 0x0,
    0x3ce94714, 0x0, 0x3f036062, 0x0,
    0x3f2bca81, 0x0, 0x3f00486d, 0x0,
    0x3cbb106d, 0x0, 0xbef00e1e, 0x0,
    0xbf2cd39e, 0x0, 0xbf048811, 0x0,
    0x3d05020b, 0x0, 0x3f09cf0d, 0x0,
    0x3f41029a, 0x0, 0x3f02b38d, 0x0,
    0xbc3f37c2, 0x0, 0xbeeff430, 0x0,
    0xbf46e611, 0x0, 0xbf048a11, 0x0,
    0x3b9047c0, 0x0, 0x3f0ecc01, 0x0,
    0x3f2be3d5, 0x0, 0x3efd862f, 0x0,
    0x3d98a95f, 0x0, 0xbee4eee6, 0x0,
    0xbf353404, 0x0, 0xbedf9887, 0x0,
    0x3cafd696, 0x0, 0x3f17efb6, 0x0,
    0x3f2f9011, 0x0, 0x3ef21ef6, 0x0,
    0xbbcfad59, 0x0, 0xbedc5d68, 0x0,
    0xbf3e36ee, 0x0, 0xbefe5bad, 0x0,
    0x3b8ebb7c, 0x0, 0x3f01f945, 0x0,
    0x3f3aae65, 0x0, 0x3edef588, 0x0,
    0xbd01e10f, 0x0, 0xbee7671e, 0x0,
    0xbf2fad7d, 0x0, 0xbf0f771e, 0x0,
    0xbd8d5f50, 0x0, 0x3f02cfa5, 0x0,
    0x3f3f2b49, 0x0, 0x3edbbd27, 0x0,
    0xbd568355, 0x0, 0xbf169dda, 0x0,
    0xbf286a98, 0x0, 0xbec93ffc, 0x0,
    0x3ce31186, 0x0, 0x3f078698, 0x0,
    0x3f34faeb, 0x0, 0x3f0599f3, 0x0,
    0x3d05d8bc, 0x0, 0xbf005a5e, 0x0,
    0xbf23eee8, 0x0, 0xbec4e5e1, 0x0,
    0x3b0af14f, 0x0, 0x3eec44cd, 0x0,
    0x3f39be66, 0x0, 0x3efa46be, 0x0,
    0x3d3be838, 0x0, 0xbef2cc93, 0x0,
    0xbf442400, 0x0, 0xbeebf683, 0x0,
    0x3d4e2a75, 0x0, 0x3eff4784, 0x0,
    0x3f3faa19, 0x0, 0x3f027e27, 0x0,
    0xbbd5c328, 0x0, 0xbedd103e, 0x0,
    0xbf38fd75, 0x0, 0xbef4ab96, 0x0,
    0x3d62d265, 0x0, 0x3eed9611, 0x0,
    0x3f3ba06f, 0x0, 0x3ed90983, 0x0,
    0xbc559f97, 0x0, 0xbeda14d6, 0x0,
    0xbf46a902, 0x0, 0xbf0a36b3, 0x0,
    0xbd614b7d, 0x0, 0x3f055e57, 0x0,
    0x3f3d3366, 0x0, 0x3f10492a, 0x0,
    0x3d02cc16, 0x0, 0xbedf2c52, 0x0,
    0xbf364816, 0x0, 0xbeddb3ca, 0x0,
    0x3c2325d8, 0x0, 0x3ed4cf60, 0x0,
    0x3f496501, 0x0, 0x3ed9bb5f, 0x0,
    0xbcb4e7ee, 0x0, 0xbf02ca51, 0x0,
    0xbf3a8ae5, 0x0, 0xbf0c55b0, 0x0,
    0x3db6820a, 0x0, 0x3f093420, 0x0,
    0x3f3feb5c, 0x0, 0x3eedd6ad, 0x0,
    0xbbabdb20, 0x0, 0xbee852a6, 0x0,
    0xbf32df13, 0x0, 0xbed0a20c, 0x0,
    0x3c0c9019, 0x0, 0x3efdc505, 0x0,
    0x3f4779de, 0x0, 0x3f03b03a, 0x0,
    0x3d151bcf, 0x0, 0xbf01608b, 0x0,
    0xbf5da8d8, 0x0, 0xbf038f96, 0x0,
    0xbbcdba4c, 0x0, 0x3eedf02c, 0x0,
    0x3f26342f, 0x0, 0x3f0ed989, 0x0,
    0x3c7deb3a, 0x0, 0xbebe2758, 0x0,
    0xbf363ae6, 0x0, 0xbee966b8, 0x0,
    0x3ced4343, 0x0, 0x3eed1daf, 0x0,
    0x3f415260, 0x0, 0x3f04451b, 0x0,
    0xbdf1a3cc, 0x0, 0xbef8bb17, 0x0,
    0xbf238758, 0x0, 0xbf0d3619, 0x0,
    0xbd0f5132, 0x0, 0x3ee63b02, 0x0,
    0x3f2efc57, 0x0, 0x3ec0c5f1, 0x0,
    0xbe2e964e, 0x0, 0xbf0416d2, 0x0,
    0xbf3cb128, 0x0, 0xbf0371a4, 0x0,
    0xbce23128, 0x0, 0x3f0194bc, 0x0,
    0x3f246a3a, 0x0, 0x3ee8679f, 0x0,
    0xbd56c98e, 0x0, 0xbeed336e, 0x0,
    0xbf31fc0f, 0x0, 0xbf014350, 0x0,
    0xbd5b306d, 0x0, 0x3f055143, 0x0,
    0x3f358fab, 0x0, 0x3f0e3e69, 0x0,
    0x3cfe40a3, 0x0, 0xbee77d59, 0x0,
    0xbf30e5c1, 0x0, 0xbf137976, 0x0,
    0x3dad6ed4, 0x0, 0x3f15c647, 0x0,
    0x3f270545, 0x0, 0x3f134648, 0x0,
    0xbd042e4c, 0x0, 0xbed9e425, 0x0,
    0xbf365b92, 0x0, 0xbecd8dce, 0x0,
    0xbc18c8e6, 0x0, 0x3ef00710, 0x0,
    0x3f2ff8e3, 0x0, 0x3f0ac7a7, 0x0,
    0x3ad5d837, 0x0, 0xbeecf011, 0x0,
    0xbf244161, 0x0, 0xbefc7226, 0x0,
    0x3dc8fb37, 0x0, 0x3f165881, 0x0,
    0x3f23225e, 0x0, 0x3f012257, 0x0,
    0xbd725303, 0x0, 0xbf0903ab, 0x0,
    0xbf2f0550, 0x0, 0xbee8801c, 0x0,
    0xbd9d9109, 0x0, 0x3ee3cc4e, 0x0,
    0x3f31ab94, 0x0, 0x3f095dd1, 0x0,
    0xbc7987c6, 0x0, 0xbef84c25, 0x0,
    0xbf29dbb6, 0x0, 0xbf08a267, 0x0,
    0x3d984cf1, 0x0, 0x3f182103, 0x0,
    0x3f289f2c, 0x0, 0x3f018d19, 0x0,
    0xbd04b989, 0x0, 0xbede4cb4, 0x0,
    0xbf25b256, 0x0, 0xbee5d24f, 0x0,
    0x3da2fccb, 0x0, 0x3edc052f, 0x0,
    0x3f2e29b9, 0x0, 0x3f012441, 0x0,
    0xbdcc79d7, 0x0, 0xbf0aba30, 0x0,
    0xbf3a2938, 0x0, 0xbf019348, 0x0,
    0x3d8bdddf, 0x0, 0x3f124ce2, 0x0,
    0x3f31a6f9, 0x0, 0x3f0a5bd6, 0x0,
    0xbd884d1c, 0x0, 0xbf059bca, 0x0,
    0xbf24811c, 0x0, 0xbee6a012, 0x0,
    0xbd631d9e, 0x0, 0x3ef335e7, 0x0,
    0x3f3b510e, 0x0, 0x3efe42d3, 0x0,
    0xbc7b2a5d, 0x0, 0xbf0542df, 0x0,
    0xbf2fa31d, 0x0, 0xbeff6310, 0x0,
    0x3be23a5b, 0x0, 0x3ee8f092, 0x0,
    0x3f48f2a0, 0x0, 0x3ef8f3f0, 0x0,
    0xbd125ed8, 0x0, 0xbef113a0, 0x0,
    0xbf2a8d17, 0x0, 0xbf037de1, 0x0,
    0x3c99a4a7, 0x0, 0x3efb00b4, 0x0,
    0x3f2a99c4, 0x0, 0x3ee7e2bd, 0x0,
    0xbd63bc85, 0x0, 0xbefddf09, 0x0,
    0xbf10b2f1, 0x0, 0xbf00f5f1, 0x0,
    0xbc7d5d2a, 0x0, 0x3ef4233b, 0x0,
    0x3f2c36ed, 0x0, 0x3f0a5d72, 0x0,
    0x3c388ea4, 0x0, 0xbf0fc204, 0x0,
    0xbf30ad37, 0x0, 0xbee18f63, 0x0
    };

static const uint32_t in_cifft_noisy_1024[2048] = {
    0x3fb2a7b1, 0x0, 0x3fd3a59e, 0xbee9c92e,
    0xbf80b4e5, 0x3f562b2f, 0xbf261a1c, 0x3d33d3ce,
    0x3f43b843, 0xbeaa9f76, 0x3de33a19, 0x3f2a0622,
    0x3ff196b8, 0x3f109b07, 0xbecaef98, 0x3f13dda3,
    0xbf85954c, 0xbfb7e93f, 0xbfcb4827, 0x3f3ed09f,
    0xbf5f302b, 0xbdc174a9, 0x3f284cf9, 0xbef56e21,
    0x3f899827, 0xbff6d6c2, 0xbefea450, 0xbc9b8a91,
    0x3fc7e1de, 0xbe6f9050, 0x3eb295d0, 0x3eb53917,
    0xbda404ee, 0x3fa429b1, 0xbf4aaaf2, 0x3e4c9f63,
    0xbf226a8f, 0x4023fbe3, 0x3d87b748, 0x3f1e1a05,
    0x3eded676, 0x3e7c7eea, 0x3e2e60a1, 0xbef396da,
    0x3fb21f3c, 0xc050ccf8, 0x407e7741, 0xbec9ccd2,
    0xbf23aa79, 0xbdd474c7, 0x3f74e54a, 0x3ea08da6,
    0xbfa14beb, 0xbfd0a564, 0x3f42a44b, 0x3f8ad3f7,
    0xc0426153, 0x3f432d67, 0x3fc35f11, 0x3faca521,
    0xbf5e3132, 0x3f9eb89e, 0xbc70c2f4, 0xc002595f,
    0x3fc25967, 0xc0366785, 0x3d973076, 0xbdcf2b10,
    0xbf3146c7, 0xbf2e9bd4, 0x3ff6c262, 0xbf0947c4,
    0xbf2e5216, 0xbf07ffda, 0xbfc8853d, 0x3fa2565a,
    0xbf853572, 0xbf40a350, 0x401d8cbc, 0x3fd32eb0,
    0xbed21e6a, 0xbeda3555, 0xbf526d93, 0x3f198f97,
    0x3fd00f57, 0xbfa46179, 0x3ed23e29, 0xbf09070e,
    0x3fe0fc3c, 0x4012a75b, 0xbf56dec2, 0x3e7b7948,
    0xbea5edb8, 0x3f014f97, 0xbfb65d67, 0xbf66a61a,
    0x3f38f787, 0x3f7d234a, 0xbfeb2100, 0xbf6c3c02,
    0xbf438a3f, 0xbfd69c4d, 0xbcdfc60c, 0xbf760088,
    0x3f427278, 0x3f651c81, 0x3ff46832, 0x3e7307cd,
    0x4001968a, 0x3f23907e, 0x3f592ad0, 0xbfb00d70,
    0xbfd035ae, 0xbf6195bf, 0x3e7bb841, 0xbe46ee99,
    0x3ea6708b, 0xbfa4fa1c, 0x3ec62ad8, 0xbf435dba,
    0x3fe1ab65, 0x3f90ead8, 0xbf003f94, 0x40415b75,
    0xbf3e1342, 0xbd248e4f, 0xbfb38a8e, 0x3f5f9729,
    0x3e047114, 0x3f23212a, 0xbf7ee2ed, 0xbfed59a6,
    0x3f309185, 0xbfadb4c4, 0x3c6245f8, 0x3f977d7c,
    0xbf4b551e, 0x3f327d0f, 0xbf8c4ec0, 0xbfd8ff1b,
    0xbf3e61ab, 0x3f94946e, 0x3f598cff, 0xbea34e91,
    0x3f4218ee, 0x3f8314d9, 0xbfbaf500, 0xbe71a174,
    0x3f8ae42a, 0xbfd42e0f, 0x3ea01cef, 0x3f48cec4,
    0xbf89eb01, 0x3e562101, 0x3eb7ccd2, 0xbeb1fa94,
    0xbe903d0e, 0xbe3a5a5a, 0x3f51f1e1, 0xbef36aa0,
    0x4017ff26, 0xbf39ca30, 0xc01a4817, 0xbfca1a65,
    0x3ff94869, 0xbe9565ce, 0x3ed8bd22, 0xbef4e427,
    0xbf4adb5d, 0xc040074a, 0x3e8298cf, 0x3fc070b8,
    0x3f52b8b3, 0x3fc55aff, 0xbf52d4a4, 0xbf2221c7,
    0xbe93351b, 0x3e86ad09, 0x3ea11504, 0x3ea38522,
    0xbf015c54, 0xbf9e1b99, 0xbfc273fa, 0x3ed5230f,
    0x4009ad9e, 0x3fa3672a, 0xbfa67708, 0xbe99b22f,
    0x3dc1433f, 0x3f12845e, 0x3f63e00f, 0xbfc19f2f,
    0xc054a9ac, 0xc020df2f, 0x3f7cb501, 0xbee9f6e5,
    0x3f1249f6, 0xc0090061, 0x3fab4325, 0xbf906765,
    0x3d1d6ae7, 0xbd72a3a3, 0x3f7332a5, 0x3df7b7c6,
    0xc01bc8dc, 0x3f1cd509, 0x3f27574d, 0x3f82f37b,
    0xbf006920, 0xbeddacc4, 0xbe8b7425, 0xbf518c73,
    0xbe2459f6, 0xbf8f110e, 0x3f38bf66, 0x3f99fe2c,
    0x3fa81c03, 0x3fc0623b, 0xbee0a92c, 0x3e40214f,
    0x3f77623c, 0x3f8183c9, 0x3f90be8e, 0x3f52a43b,
    0xbf15bc07, 0x3dfe1b8f, 0xbf0052b4, 0x3d9f5abd,
    0x3edc3b44, 0x3f98e77c, 0xbfc4a311, 0xbf4555de,
    0x3c2611bf, 0x3ff37eb3, 0x401070b2, 0xbf350dd9,
    0xbfac3efd, 0x3e8c8c8c, 0xc0015363, 0x3e29fa21,
    0x3f7c47aa, 0x3fbef21d, 0x3fdabbf3, 0xbe479a6e,
    0x3e815f15, 0xc000a837, 0x3ffaf982, 0xbf8d896b,
    0xbe987dae, 0xbf76a3ab, 0x3e23708d, 0xbe98fe1d,
    0xbe66323c, 0xbedf4c00, 0x3f6d711b, 0x3e1af60d,
    0x3fb548c3, 0xc3b2d25f, 0x3e671a47, 0xbfdd0450,
    0x3dd35cad, 0x3f8480b0, 0xc008e10a, 0x4028439e,
    0x3e34d0a1, 0x3f4751d5, 0x3f978b7b, 0x3d100f0d,
    0xbf443837, 0x400fa893, 0xbed2d37d, 0xbf1b6148,
    0xbec6a147, 0x3e284486, 0x3e676570, 0x3fa8a8e7,
    0x3f0fc239, 0xbdf8d016, 0x3f59a5dd, 0x3ffdbc0e,
    0x3f4015a4, 0xbebf019b, 0xbfd2f35a, 0xbfa702d4,
    0xbf0999c1, 0xbf29f6b5, 0x3fc49bff, 0x3eb72f9b,
    0xbe86b93b, 0x3d22a846, 0x3f7f07f6, 0xbf5d8863,
    0xbea7533e, 0xbec51afe, 0xbfaf0db2, 0xbf1c5125,
    0xbf32e6ef, 0x3f3a5ddd, 0xbea9454c, 0xbf00f365,
    0xbe7a31b8, 0x4008e29d, 0x3f33c363, 0x3eaa9371,
    0x3f7da56b, 0xbf8f7a1a, 0xbd482313, 0xbef1055a,
    0xbf6fc443, 0xc0019a21, 0x3f808a05, 0x3f32a523,
    0x3f8b0c98, 0x3fac289b, 0xbd77d03e, 0xbf85fcc7,
    0x3fa2fef6, 0x3e166749, 0xbfbe571f, 0xbdc7b5fd,
    0xc017faa1, 0xbfe02e79, 0xbf45e84a, 0x3fccc40b,
    0xbfa33b8b, 0x3fc53f79, 0x3fd3eccf, 0xbfdb9f6d,
    0x3f9d471c, 0xbf5ec722, 0x3f67467b, 0xbea3cdf4,
    0x3fadbfea, 0xbf85a051, 0xbfbd0d51, 0xbf2224c8,
    0xbe9fb5e5, 0xbfa4dc96, 0xbf88665d, 0xbf6003bd,
    0x3de2de41, 0xbfe7252a, 0xc00bdfad, 0x3e3d5bcc,
    0x3f3f97f2, 0x3d10444c, 0xc01bf6e2, 0x3f1efbd2,
    0xbf6d52b5, 0xc03aeb23, 0xbeffc482, 0xbf13f2e2,
    0x3e23dbab, 0x3fe4aa7b, 0xbf09ead4, 0x3ee76d02,
    0x3f3744f7, 0x4005f201, 0x3f2826e0, 0xbf6febc4,
    0x3e3ab551, 0x3e73a01c, 0x3ef0ce48, 0xbe2799e8,
    0x3fec4e7a, 0xbff805fd, 0xbdb67ad6, 0xbfaf3ed2,
    0x3f87cc07, 0xbeb4d61d, 0xbdef46de, 0xc025a519,
    0x3f7f5e23, 0xbf088ca4, 0xbdb7dfb8, 0x3bd703b6,
    0x3f020cbb, 0x40801eef, 0x3fb2e1ef, 0x3f433371,
    0x3fae732f, 0x3f1658d7, 0xbf9f53bf, 0x3e23194e,
    0x3f8ad4ef, 0xbe8d0f7a, 0x3f324228, 0x3f8010f7,
    0xbffb9293, 0xbe530c9d, 0xbf3e00a5, 0x3e044952,
    0x3f41de8f, 0xbf4346c6, 0x3f967644, 0xbef2bec1,
    0xbf32affb, 0xc031142e, 0x3f96e3d5, 0xc022f6d6,
    0x3bf50a0a, 0xc01ee7f6, 0x3ca0bbc5, 0x3df25513,
    0xbf4dbfab, 0x401680bc, 0x3f614769, 0xbf78e4ab,
    0x3eeeeb6b, 0x3f908e68, 0xbf1a1a30, 0x3e2c89d7,
    0x3f152360, 0xc0052657, 0x40124c36, 0xbf063ac4,
    0xbf81a34c, 0x3f3ec7c0, 0xbeeaf397, 0xbd7951fc,
    0xbf07032e, 0x3f2eb2ce, 0x3e001594, 0x3f952a17,
    0xbf5eeb2e, 0xbf97a647, 0xbf2a000a, 0x3f1af068,
    0x3fc87ca1, 0xbdc8fe51, 0x3f43087e, 0xbea74259,
    0xbed00e97, 0x3f713ac4, 0xbe3e19c4, 0xbe5719c2,
    0x3f120524, 0x3f3810b8, 0xbf356656, 0x3f9b7914,
    0xbfcb13a9, 0xbeae0133, 0xbdc3e859, 0x3c3ff9b6,
    0x3ea74c7b, 0xbf086b4d, 0x3f85c3ed, 0x3ff67708,
    0xbf0f893f, 0x3fc95023, 0xbf180480, 0xbf2918ad,
    0x3e8950eb, 0x3f6cd300, 0x3f85fe1f, 0xbedccef9,
    0xbf87a238, 0x3f087df9, 0xbfd56a2a, 0x3fc3d10e,
    0xbe2814a6, 0xbf0119c9, 0xbf36077a, 0x3f993609,
    0x402e42ea, 0xbf2d25a0, 0x3e990ca9, 0x3f325ef2,
    0x3ffcdc90, 0x3f7f3399, 0xbf88ce44, 0x3f985240,
    0x3f278102, 0x3e90b5cf, 0xbfb61866, 0xc08e3c56,
    0x3f7fabda, 0x3fbabefc, 0x3f23512b, 0x3ef93b74,
    0xbd75da37, 0x3cb263c7, 0xbfa25aed, 0xbed7f4ad,
    0xbfad43ee, 0x3e3ccef7, 0x3de6c166, 0x3f92ddfa,
    0x4041d693, 0x4044a872, 0xbffeadac, 0x3f231104,
    0x3f5d3d44, 0xbf2af618, 0xbddadbd2, 0xbfb38504,
    0x3f24c2ba, 0x3fe6a43e, 0x3f8ef5c1, 0xbea3460d,
    0xbf824cdc, 0xbf29b3ba, 0x3e83468f, 0xbe8d9b77,
    0xbec40d20, 0xbf112053, 0xbfc000ea, 0x3f92c82a,
    0xc02f0dc4, 0x3ed76c1f, 0xbf2c7787, 0xbe75ff27,
    0xbfb1dffd, 0x3fa8a1f9, 0xbf859902, 0xbe80b265,
    0x3f3e0e97, 0x3eda6c9d, 0xbf9d4c7f, 0x3f55b48a,
    0xbf7c59d0, 0xbf913d1e, 0xbf9cdc19, 0x3f9694a9,
    0xbe0e29af, 0x4009de3d, 0xbf69aafd, 0xbe76f482,
    0x3f210140, 0x3f9825b8, 0xbec17fef, 0xbe3a9e3b,
    0x3efbb542, 0xbf66cb8e, 0x3f4c9c64, 0xbfb0b99a,
    0xbfbb007b, 0xbf510608, 0x3f2dad1f, 0xbebfa248,
    0x3fa0a001, 0xbe9f866c, 0xbeae93d4, 0x3f95462f,
    0x3ff4037f, 0x3f464270, 0x3f6c7d15, 0x3e9b56d6,
    0xc00a95a5, 0xbf5455ef, 0x3f7809ff, 0xbf32415c,
    0xbead88f4, 0xbd8959a1, 0x3f86cfb2, 0xc0183168,
    0x3e8dc4f7, 0xbd96b4de, 0x4004eb05, 0xbfacc596,
    0xbfa67510, 0xbed1fc0e, 0xbecd734a, 0x4006c179,
    0x401d7eba, 0x4036debb, 0xbf8c640d, 0xbf732fef,
    0xbf863ca0, 0xbf8b59c9, 0xbf3f04b6, 0x3fc62db9,
    0xbfafe90f, 0xbeb50a08, 0xbe410e33, 0xbde60e1f,
    0x3ec3f8fa, 0x4005ab51, 0x3e95142e, 0xbea13206,
    0x3fb99b7e, 0x3f9b1366, 0xc01a5ed0, 0xbe8cf816,
    0xbf813666, 0xbf5af607, 0x3f83fdbc, 0xbe2a882c,
    0x3ee79049, 0xbe048340, 0xbf997bea, 0x3e607a38,
    0x3fca4d67, 0x3d8631b1, 0x3f6c361b, 0xbf4c290a,
    0xbf54a3cf, 0xbf194d33, 0xbf1afe02, 0x3ee58746,
    0xbf818ddc, 0x3f3cc983, 0x3f29cae2, 0xbf120f96,
    0x3f0f3cc8, 0xbf076b1a, 0xbfb2de75, 0x3f0adb75,
    0xbf5c71ff, 0xbfc0fd53, 0xbf047b0c, 0x4021b565,
    0x3e86302b, 0x3f52cef8, 0xbf672802, 0xbf50f837,
    0xbca6ea23, 0x3f0bfc6f, 0xc0060ad1, 0x3fbb3f42,
    0xbfd9056f, 0x3d0e893b, 0x3e92fa22, 0x3f900c35,
    0x3d0e97d6, 0xc000432e, 0x3f784a26, 0x3f0d66cd,
    0x4005b466, 0xbe88c943, 0x401430c8, 0xbe1158bd,
    0x3f5a887a, 0xbef7e969, 0xbfd81ddb, 0xbca762a9,
    0xc0038dc9, 0x40287121, 0x3f5546ab, 0x3f1a281c,
    0x3ec41526, 0x3f77d30a, 0xbe931ca4, 0x3fc1cdae,
    0xbeb56aa2, 0x3fac5426, 0x3f3283c7, 0x3f3ab292,
    0x3f2a6e31, 0xbfb712b1, 0x3fbc392f, 0xbfd74b33,
    0xbfdd4234, 0xc0090aab, 0xbf9b950e, 0xbfe3a2dc,
    0x3f9d2175, 0xbf037520, 0xbf17ecb0, 0x4001ddc8,
    0x3f8bd661, 0xbfbe3365, 0xbf2e0f00, 0xbf53f9b0,
    0x3f32a59b, 0x3f8f2bdc, 0xc008e7dc, 0xbe3e5664,
    0x3de54a6e, 0x3e03effa, 0x3f82405c, 0x3edc1dc8,
    0xbe8ce5ba, 0x3f8a410b, 0xc0000cbc, 0x400375d7,
    0x3f466601, 0xbf1d0dfe, 0x3f7d7798, 0x3f8f3238,
    0x3f283b05, 0x3fa7b315, 0xbf0469ce, 0xc0018dcc,
    0x3fd8ee1e, 0x3f33dc85, 0xc00cc9e2, 0x3e38465e,
    0x3fa0043a, 0x400ae8d0, 0xbf7872a3, 0x3f9c6895,
    0xbfda0f3a, 0x3f045356, 0x3e83d875, 0xbf9d4dbb,
    0x3f5ce817, 0x3fe0581d, 0xbe705b6e, 0xbf7f652b,
    0xbcc7bf11, 0xbd3df22c, 0xbfd61811, 0x3c3fec73,
    0xbf2e3e0d, 0xbd35d395, 0xbf8eee9d, 0x3eef0479,
    0xbec02edc, 0xbfaeae2a, 0x3f14512f, 0xbea64f91,
    0xbf89794f, 0xbf0e7c68, 0xbe9b5f22, 0xbfcc03ee,
    0xbf6a7103, 0xc0325eb5, 0x3f288704, 0x3f61e474,
    0x3e6e757c, 0x3f9b31a9, 0xbf4eb64d, 0xbfd781fc,
    0xbf85bc37, 0xbf1c7b73, 0xbfa123f3, 0x3ea7a012,
    0x3f3bcebc, 0x3e8f85d8, 0x3f77849b, 0xbf8c83ab,
    0x3d871cd9, 0xbeac7121, 0x3ca3f903, 0xbe1fc02b,
    0xbf177e6f, 0x3de30ed8, 0xbf0abfe4, 0xbebfd0c5,
    0x3ec8e79e, 0xbf503568, 0xbfa84de1, 0x3ecc79c6,
    0x3fbd72b8, 0xbfadb896, 0xbf35719c, 0xbf9f586d,
    0xbfc0ed7c, 0xbfb7a13a, 0x3edf13b9, 0xbfafefc7,
    0xbfa5556c, 0x3f6f4bc8, 0x3ef2e84f, 0x3fc29a42,
    0xbf39a742, 0x3fa1d333, 0xc0563fdd, 0xbfb9d0b3,
    0xbfed10bb, 0xbf62321a, 0xbfcfc5ed, 0xc06c5557,
    0x3fbdfe12, 0x3fafa044, 0x400db091, 0xbf753014,
    0x3fc2a37d, 0xbfba481d, 0xbf68da77, 0x40253c34,
    0x3c9aedae, 0xbff3e5a7, 0xbf3aa86c, 0xbeb84315,
    0x3de5a174, 0x3e4d9963, 0x3f2323b6, 0x3fbd70f5,
    0xbf10c283, 0x3f6e352c, 0x3f072d85, 0x3f40fc93,
    0xbf605057, 0x3fc9f68e, 0xbf9079a3, 0x3e1e5595,
    0x3f1e0080, 0x3fd4c035, 0xbf5612bf, 0xbfb4b65c,
    0x3f741ca3, 0x3f980171, 0x3fd79877, 0xbf6fc244,
    0x3e8ca9ac, 0xbf33222c, 0xbfb5d844, 0xc01fc98d,
    0xbf9d88d7, 0x3ee2b792, 0x3e655e18, 0xbedf0919,
    0x3fe8a33b, 0xbf872f88, 0xbf8edf5d, 0xbe90449d,
    0xbf69f371, 0xbf8807cd, 0xbf3e48f5, 0x3d308ff6,
    0xbd708884, 0xbe3653dd, 0xc000ff70, 0x3f162d70,
    0x3f930e9f, 0xbf1f534b, 0x3f6cb41d, 0x403fa3e0,
    0xbd039f67, 0x3e08910f, 0x3f7442ec, 0xbf99e4d1,
    0x3e952ac1, 0x3fc5206b, 0xbe421f17, 0xbf45215d,
    0xc032c561, 0x3f047109, 0x3f095d6c, 0x3fb91c0f,
    0x3f250957, 0x3ef169d7, 0xbfccf829, 0xbffb438f,
    0x3f459353, 0xbf9a4303, 0x3da95b51, 0x3f2ca172,
    0x3de8eb07, 0x3f2da4cd, 0x3f034451, 0x3fc176b3,
    0xbe181a88, 0xbe61b42f, 0x3fa4bd83, 0x3f9d3e9e,
    0x3f76b13e, 0x3f07408b, 0x3f3ec151, 0xbe482d01,
    0xbe6f5169, 0xbfc44e97, 0xbf48f9f8, 0xbf539ebe,
    0x3f42c2ba, 0x3fe34cf5, 0x3eda51a4, 0x3f73ae95,
    0x3fd57c8e, 0xbfe14ee0, 0xbe51b924, 0xbeb4160d,
    0xbed2e119, 0x3fb0b8c4, 0x3f45a548, 0xbe26adc8,
    0x3fa913e0, 0xbfa4e055, 0xbf8a3866, 0xbe36471c,
    0xc01f6b61, 0xbe068f8b, 0xc03ed402, 0xbed4920a,
    0x3f8fac6a, 0x3f5e0fe1, 0x3e7129a1, 0x4026c5d2,
    0xbefb5b2c, 0xc0190fa8, 0xbe5b960d, 0xbfe3474a,
    0x3f98c6ff, 0xbedecddc, 0xbf579d98, 0x3e277b89,
    0x3f3bede0, 0xbeef4e4d, 0xbf9f8111, 0x3f571968,
    0xbdc10895, 0x3fc08fe8, 0x3f69f776, 0x3f6b0b5b,
    0xc0346b9d, 0xbf795972, 0x3e0fc44a, 0x3f575903,
    0x3d0c7478, 0xbdeb9072, 0xbf9a666f, 0x3f5f149d,
    0xbfab06a0, 0x3f90a35f, 0x3edea2af, 0xbb892a9f,
    0xc02e21bf, 0x3d9e4acb, 0x3fc1eee1, 0xbff1077f,
    0xbee21dae, 0xbd892c8e, 0xbed90495, 0x3d756920,
    0x3ea1364c, 0x3fdc9347, 0xbe638625, 0x3f203043,
    0x3d3d29fb, 0x3fabacf5, 0x3efe4fc2, 0x3f78ee7d,
    0xbda3c12a, 0xc01d4bb4, 0xbf998506, 0xbfa69b2f,
    0xbeef761e, 0x4021c275, 0xbde587b6, 0xbfeff148,
    0x3e9a0ab7, 0x3e0d780d, 0x3ec23560, 0x3f520f8e,
    0x3f4eae38, 0xbe52d56d, 0xbe05135e, 0xbf57f327,
    0x3f9e6399, 0x3eb953ff, 0xbf7df14e, 0x3fad437b,
    0xbfa0b4a0, 0x3f0e1d81, 0x3ec1f57d, 0x3f9204a1,
    0x3dbff900, 0x3f84d2c2, 0x3f05d482, 0xbeef1bc7,
    0x3e87911f, 0xbf593f68, 0x3fd07e20, 0x3ef60b2c,
    0xbe638385, 0x400e1bef, 0xbf45120b, 0x3ec45f13,
    0x3f8338a0, 0xbf5b79d9, 0xbfe58ecc, 0xbfb5cc03,
    0xbf1d4a06, 0x3fa109e0, 0x3f4a7fd6, 0x3fc54976,
    0x3f05ea42, 0x3d1fd1ec, 0x3fd20ee0, 0xbfaf7fbe,
    0xbf42485e, 0x400b8eff, 0x3f55026a, 0xbe678b41,
    0xc006059a, 0xbfed283f, 0xbe239344, 0x3e9ac4c4,
    0x3f976d7a, 0xbfe89f60, 0xbf80663e, 0x3eaa1e89,
    0x3f3f862e, 0xbf85e95c, 0xbe7e8c2c, 0x3fa88c61,
    0x3e97dd7a, 0x3e02bbce, 0x3f8a8331, 0xbfe7a14f,
    0xbfab0cfb, 0x3d8de5d7, 0x3f49a58f, 0xc00e432e,
    0xbfa3a0e0, 0x3f945da7, 0xbf8d1296, 0x3f3f3981,
    0x3f78afb3, 0xbf7bba9e, 0x3e21e623, 0xbebd7b48,
    0xbf6ae6c5, 0x3f1e00e6, 0xbef33a2c, 0xbe1ff2cf,
    0xbd9c766e, 0xbfd03488, 0x40148bcf, 0x3f5856d8,
    0x3df619a1, 0x3e5e8b3a, 0x3f5e0815, 0xbf3c854f,
    0x3f09459b, 0x40413ca8, 0x3eb32338, 0x3e987774,
    0x3f950fe6, 0x3f76ab87, 0x3f6d50da, 0x3f1a348c,
    0xc0687489, 0x0, 0x3f6d50da, 0xbf1a348c,
    0x3f950fe6, 0xbf76ab87, 0x3eb32338, 0xbe987774,
    0x3f09459b, 0xc0413ca8, 0x3f5e0815, 0x3f3c854f,
    0x3df619a1, 0xbe5e8b3a, 0x40148bcf, 0xbf5856d8,
    0xbd9c766e, 0x3fd03488, 0xbef33a2c, 0x3e1ff2cf,
    0xbf6ae6c5, 0xbf1e00e6, 0x3e21e623, 0x3ebd7b48,
    0x3f78afb3, 0x3f7bba9e, 0xbf8d1296, 0xbf3f3981,
    0xbfa3a0e0, 0xbf945da7, 0x3f49a58f, 0x400e432e,
    0xbfab0cfb, 0xbd8de5d7, 0x3f8a8331, 0x3fe7a14f,
    0x3e97dd7a, 0xbe02bbce, 0xbe7e8c2c, 0xbfa88c61,
    0x3f3f862e, 0x3f85e95c, 0xbf80663e, 0xbeaa1e89,
    0x3f976d7a, 0x3fe89f60, 0xbe239344, 0xbe9ac4c4,
    0xc006059a, 0x3fed283f, 0x3f55026a, 0x3e678b41,
    0xbf42485e, 0xc00b8eff, 0x3fd20ee0, 0x3faf7fbe,
    0x3f05ea42, 0xbd1fd1ec, 0x3f4a7fd6, 0xbfc54976,
    0xbf1d4a06, 0xbfa109e0, 0xbfe58ecc, 0x3fb5cc03,
    0x3f8338a0, 0x3f5b79d9, 0xbf45120b, 0xbec45f13,
    0xbe638385, 0xc00e1bef, 0x3fd07e20, 0xbef60b2c,
    0x3e87911f, 0x3f593f68, 0x3f05d482, 0x3eef1bc7,
    0x3dbff900, 0xbf84d2c2, 0x3ec1f57d, 0xbf9204a1,
    0xbfa0b4a0, 0xbf0e1d81, 0xbf7df14e, 0xbfad437b,
    0x3f9e6399, 0xbeb953ff, 0xbe05135e, 0x3f57f327,
    0x3f4eae38, 0x3e52d56d, 0x3ec23560, 0xbf520f8e,
    0x3e9a0ab7, 0xbe0d780d, 0xbde587b6, 0x3feff148,
    0xbeef761e, 0xc021c275, 0xbf998506, 0x3fa69b2f,
    0xbda3c12a, 0x401d4bb4, 0x3efe4fc2, 0xbf78ee7d,
    0x3d3d29fb, 0xbfabacf5, 0xbe638625, 0xbf203043,
    0x3ea1364c, 0xbfdc9347, 0xbed90495, 0xbd756920,
    0xbee21dae, 0x3d892c8e, 0x3fc1eee1, 0x3ff1077f,
    0xc02e21bf, 0xbd9e4acb, 0x3edea2af, 0x3b892a9f,
    0xbfab06a0, 0xbf90a35f, 0xbf9a666f, 0xbf5f149d,
    0x3d0c7478, 0x3deb9072, 0x3e0fc44a, 0xbf575903,
    0xc0346b9d, 0x3f795972, 0x3f69f776, 0xbf6b0b5b,
    0xbdc10895, 0xbfc08fe8, 0xbf9f8111, 0xbf571968,
    0x3f3bede0, 0x3eef4e4d, 0xbf579d98, 0xbe277b89,
    0x3f98c6ff, 0x3edecddc, 0xbe5b960d, 0x3fe3474a,
    0xbefb5b2c, 0x40190fa8, 0x3e7129a1, 0xc026c5d2,
    0x3f8fac6a, 0xbf5e0fe1, 0xc03ed402, 0x3ed4920a,
    0xc01f6b61, 0x3e068f8b, 0xbf8a3866, 0x3e36471c,
    0x3fa913e0, 0x3fa4e055, 0x3f45a548, 0x3e26adc8,
    0xbed2e119, 0xbfb0b8c4, 0xbe51b924, 0x3eb4160d,
    0x3fd57c8e, 0x3fe14ee0, 0x3eda51a4, 0xbf73ae95,
    0x3f42c2ba, 0xbfe34cf5, 0xbf48f9f8, 0x3f539ebe,
    0xbe6f5169, 0x3fc44e97, 0x3f3ec151, 0x3e482d01,
    0x3f76b13e, 0xbf07408b, 0x3fa4bd83, 0xbf9d3e9e,
    0xbe181a88, 0x3e61b42f, 0x3f034451, 0xbfc176b3,
    0x3de8eb07, 0xbf2da4cd, 0x3da95b51, 0xbf2ca172,
    0x3f459353, 0x3f9a4303, 0xbfccf829, 0x3ffb438f,
    0x3f250957, 0xbef169d7, 0x3f095d6c, 0xbfb91c0f,
    0xc032c561, 0xbf047109, 0xbe421f17, 0x3f45215d,
    0x3e952ac1, 0xbfc5206b, 0x3f7442ec, 0x3f99e4d1,
    0xbd039f67, 0xbe08910f, 0x3f6cb41d, 0xc03fa3e0,
    0x3f930e9f, 0x3f1f534b, 0xc000ff70, 0xbf162d70,
    0xbd708884, 0x3e3653dd, 0xbf3e48f5, 0xbd308ff6,
    0xbf69f371, 0x3f8807cd, 0xbf8edf5d, 0x3e90449d,
    0x3fe8a33b, 0x3f872f88, 0x3e655e18, 0x3edf0919,
    0xbf9d88d7, 0xbee2b792, 0xbfb5d844, 0x401fc98d,
    0x3e8ca9ac, 0x3f33222c, 0x3fd79877, 0x3f6fc244,
    0x3f741ca3, 0xbf980171, 0xbf5612bf, 0x3fb4b65c,
    0x3f1e0080, 0xbfd4c035, 0xbf9079a3, 0xbe1e5595,
    0xbf605057, 0xbfc9f68e, 0x3f072d85, 0xbf40fc93,
    0xbf10c283, 0xbf6e352c, 0x3f2323b6, 0xbfbd70f5,
    0x3de5a174, 0xbe4d9963, 0xbf3aa86c, 0x3eb84315,
    0x3c9aedae, 0x3ff3e5a7, 0xbf68da77, 0xc0253c34,
    0x3fc2a37d, 0x3fba481d, 0x400db091, 0x3f753014,
    0x3fbdfe12, 0xbfafa044, 0xbfcfc5ed, 0x406c5557,
    0xbfed10bb, 0x3f62321a, 0xc0563fdd, 0x3fb9d0b3,
    0xbf39a742, 0xbfa1d333, 0x3ef2e84f, 0xbfc29a42,
    0xbfa5556c, 0xbf6f4bc8, 0x3edf13b9, 0x3fafefc7,
    0xbfc0ed7c, 0x3fb7a13a, 0xbf35719c, 0x3f9f586d,
    0x3fbd72b8, 0x3fadb896, 0xbfa84de1, 0xbecc79c6,
    0x3ec8e79e, 0x3f503568, 0xbf0abfe4, 0x3ebfd0c5,
    0xbf177e6f, 0xbde30ed8, 0x3ca3f903, 0x3e1fc02b,
    0x3d871cd9, 0x3eac7121, 0x3f77849b, 0x3f8c83ab,
    0x3f3bcebc, 0xbe8f85d8, 0xbfa123f3, 0xbea7a012,
    0xbf85bc37, 0x3f1c7b73, 0xbf4eb64d, 0x3fd781fc,
    0x3e6e757c, 0xbf9b31a9, 0x3f288704, 0xbf61e474,
    0xbf6a7103, 0x40325eb5, 0xbe9b5f22, 0x3fcc03ee,
    0xbf89794f, 0x3f0e7c68, 0x3f14512f, 0x3ea64f91,
    0xbec02edc, 0x3faeae2a, 0xbf8eee9d, 0xbeef0479,
    0xbf2e3e0d, 0x3d35d395, 0xbfd61811, 0xbc3fec73,
    0xbcc7bf11, 0x3d3df22c, 0xbe705b6e, 0x3f7f652b,
    0x3f5ce817, 0xbfe0581d, 0x3e83d875, 0x3f9d4dbb,
    0xbfda0f3a, 0xbf045356, 0xbf7872a3, 0xbf9c6895,
    0x3fa0043a, 0xc00ae8d0, 0xc00cc9e2, 0xbe38465e,
    0x3fd8ee1e, 0xbf33dc85, 0xbf0469ce, 0x40018dcc,
    0x3f283b05, 0xbfa7b315, 0x3f7d7798, 0xbf8f3238,
    0x3f466601, 0x3f1d0dfe, 0xc0000cbc, 0xc00375d7,
    0xbe8ce5ba, 0xbf8a410b, 0x3f82405c, 0xbedc1dc8,
    0x3de54a6e, 0xbe03effa, 0xc008e7dc, 0x3e3e5664,
    0x3f32a59b, 0xbf8f2bdc, 0xbf2e0f00, 0x3f53f9b0,
    0x3f8bd661, 0x3fbe3365, 0xbf17ecb0, 0xc001ddc8,
    0x3f9d2175, 0x3f037520, 0xbf9b950e, 0x3fe3a2dc,
    0xbfdd4234, 0x40090aab, 0x3fbc392f, 0x3fd74b33,
    0x3f2a6e31, 0x3fb712b1, 0x3f3283c7, 0xbf3ab292,
    0xbeb56aa2, 0xbfac5426, 0xbe931ca4, 0xbfc1cdae,
    0x3ec41526, 0xbf77d30a, 0x3f5546ab, 0xbf1a281c,
    0xc0038dc9, 0xc0287121, 0xbfd81ddb, 0x3ca762a9,
    0x3f5a887a, 0x3ef7e969, 0x401430c8, 0x3e1158bd,
    0x4005b466, 0x3e88c943, 0x3f784a26, 0xbf0d66cd,
    0x3d0e97d6, 0x4000432e, 0x3e92fa22, 0xbf900c35,
    0xbfd9056f, 0xbd0e893b, 0xc0060ad1, 0xbfbb3f42,
    0xbca6ea23, 0xbf0bfc6f, 0xbf672802, 0x3f50f837,
    0x3e86302b, 0xbf52cef8, 0xbf047b0c, 0xc021b565,
    0xbf5c71ff, 0x3fc0fd53, 0xbfb2de75, 0xbf0adb75,
    0x3f0f3cc8, 0x3f076b1a, 0x3f29cae2, 0x3f120f96,
    0xbf818ddc, 0xbf3cc983, 0xbf1afe02, 0xbee58746,
    0xbf54a3cf, 0x3f194d33, 0x3f6c361b, 0x3f4c290a,
    0x3fca4d67, 0xbd8631b1, 0xbf997bea, 0xbe607a38,
    0x3ee79049, 0x3e048340, 0x3f83fdbc, 0x3e2a882c,
    0xbf813666, 0x3f5af607, 0xc01a5ed0, 0x3e8cf816,
    0x3fb99b7e, 0xbf9b1366, 0x3e95142e, 0x3ea13206,
    0x3ec3f8fa, 0xc005ab51, 0xbe410e33, 0x3de60e1f,
    0xbfafe90f, 0x3eb50a08, 0xbf3f04b6, 0xbfc62db9,
    0xbf863ca0, 0x3f8b59c9, 0xbf8c640d, 0x3f732fef,
    0x401d7eba, 0xc036debb, 0xbecd734a, 0xc006c179,
    0xbfa67510, 0x3ed1fc0e, 0x4004eb05, 0x3facc596,
    0x3e8dc4f7, 0x3d96b4de, 0x3f86cfb2, 0x40183168,
    0xbead88f4, 0x3d8959a1, 0x3f7809ff, 0x3f32415c,
    0xc00a95a5, 0x3f5455ef, 0x3f6c7d15, 0xbe9b56d6,
    0x3ff4037f, 0xbf464270, 0xbeae93d4, 0xbf95462f,
    0x3fa0a001, 0x3e9f866c, 0x3f2dad1f, 0x3ebfa248,
    0xbfbb007b, 0x3f510608, 0x3f4c9c64, 0x3fb0b99a,
    0x3efbb542, 0x3f66cb8e, 0xbec17fef, 0x3e3a9e3b,
    0x3f210140, 0xbf9825b8, 0xbf69aafd, 0x3e76f482,
    0xbe0e29af, 0xc009de3d, 0xbf9cdc19, 0xbf9694a9,
    0xbf7c59d0, 0x3f913d1e, 0xbf9d4c7f, 0xbf55b48a,
    0x3f3e0e97, 0xbeda6c9d, 0xbf859902, 0x3e80b265,
    0xbfb1dffd, 0xbfa8a1f9, 0xbf2c7787, 0x3e75ff27,
    0xc02f0dc4, 0xbed76c1f, 0xbfc000ea, 0xbf92c82a,
    0xbec40d20, 0x3f112053, 0x3e83468f, 0x3e8d9b77,
    0xbf824cdc, 0x3f29b3ba, 0x3f8ef5c1, 0x3ea3460d,
    0x3f24c2ba, 0xbfe6a43e, 0xbddadbd2, 0x3fb38504,
    0x3f5d3d44, 0x3f2af618, 0xbffeadac, 0xbf231104,
    0x4041d693, 0xc044a872, 0x3de6c166, 0xbf92ddfa,
    0xbfad43ee, 0xbe3ccef7, 0xbfa25aed, 0x3ed7f4ad,
    0xbd75da37, 0xbcb263c7, 0x3f23512b, 0xbef93b74,
    0x3f7fabda, 0xbfbabefc, 0xbfb61866, 0x408e3c56,
    0x3f278102, 0xbe90b5cf, 0xbf88ce44, 0xbf985240,
    0x3ffcdc90, 0xbf7f3399, 0x3e990ca9, 0xbf325ef2,
    0x402e42ea, 0x3f2d25a0, 0xbf36077a, 0xbf993609,
    0xbe2814a6, 0x3f0119c9, 0xbfd56a2a, 0xbfc3d10e,
    0xbf87a238, 0xbf087df9, 0x3f85fe1f, 0x3edccef9,
    0x3e8950eb, 0xbf6cd300, 0xbf180480, 0x3f2918ad,
    0xbf0f893f, 0xbfc95023, 0x3f85c3ed, 0xbff67708,
    0x3ea74c7b, 0x3f086b4d, 0xbdc3e859, 0xbc3ff9b6,
    0xbfcb13a9, 0x3eae0133, 0xbf356656, 0xbf9b7914,
    0x3f120524, 0xbf3810b8, 0xbe3e19c4, 0x3e5719c2,
    0xbed00e97, 0xbf713ac4, 0x3f43087e, 0x3ea74259,
    0x3fc87ca1, 0x3dc8fe51, 0xbf2a000a, 0xbf1af068,
    0xbf5eeb2e, 0x3f97a647, 0x3e001594, 0xbf952a17,
    0xbf07032e, 0xbf2eb2ce, 0xbeeaf397, 0x3d7951fc,
    0xbf81a34c, 0xbf3ec7c0, 0x40124c36, 0x3f063ac4,
    0x3f152360, 0x40052657, 0xbf1a1a30, 0xbe2c89d7,
    0x3eeeeb6b, 0xbf908e68, 0x3f614769, 0x3f78e4ab,
    0xbf4dbfab, 0xc01680bc, 0x3ca0bbc5, 0xbdf25513,
    0x3bf50a0a, 0x401ee7f6, 0x3f96e3d5, 0x4022f6d6,
    0xbf32affb, 0x4031142e, 0x3f967644, 0x3ef2bec1,
    0x3f41de8f, 0x3f4346c6, 0xbf3e00a5, 0xbe044952,
    0xbffb9293, 0x3e530c9d, 0x3f324228, 0xbf8010f7,
    0x3f8ad4ef, 0x3e8d0f7a, 0xbf9f53bf, 0xbe23194e,
    0x3fae732f, 0xbf1658d7, 0x3fb2e1ef, 0xbf433371,
    0x3f020cbb, 0xc0801eef, 0xbdb7dfb8, 0xbbd703b6,
    0x3f7f5e23, 0x3f088ca4, 0xbdef46de, 0x4025a519,
    0x3f87cc07, 0x3eb4d61d, 0xbdb67ad6, 0x3faf3ed2,
    0x3fec4e7a, 0x3ff805fd, 0x3ef0ce48, 0x3e2799e8,
    0x3e3ab551, 0xbe73a01c, 0x3f2826e0, 0x3f6febc4,
    0x3f3744f7, 0xc005f201, 0xbf09ead4, 0xbee76d02,
    0x3e23dbab, 0xbfe4aa7b, 0xbeffc482, 0x3f13f2e2,
    0xbf6d52b5, 0x403aeb23, 0xc01bf6e2, 0xbf1efbd2,
    0x3f3f97f2, 0xbd10444c, 0xc00bdfad, 0xbe3d5bcc,
    0x3de2de41, 0x3fe7252a, 0xbf88665d, 0x3f6003bd,
    0xbe9fb5e5, 0x3fa4dc96, 0xbfbd0d51, 0x3f2224c8,
    0x3fadbfea, 0x3f85a051, 0x3f67467b, 0x3ea3cdf4,
    0x3f9d471c, 0x3f5ec722, 0x3fd3eccf, 0x3fdb9f6d,
    0xbfa33b8b, 0xbfc53f79, 0xbf45e84a, 0xbfccc40b,
    0xc017faa1, 0x3fe02e79, 0xbfbe571f, 0x3dc7b5fd,
    0x3fa2fef6, 0xbe166749, 0xbd77d03e, 0x3f85fcc7,
    0x3f8b0c98, 0xbfac289b, 0x3f808a05, 0xbf32a523,
    0xbf6fc443, 0x40019a21, 0xbd482313, 0x3ef1055a,
    0x3f7da56b, 0x3f8f7a1a, 0x3f33c363, 0xbeaa9371,
    0xbe7a31b8, 0xc008e29d, 0xbea9454c, 0x3f00f365,
    0xbf32e6ef, 0xbf3a5ddd, 0xbfaf0db2, 0x3f1c5125,
    0xbea7533e, 0x3ec51afe, 0x3f7f07f6, 0x3f5d8863,
    0xbe86b93b, 0xbd22a846, 0x3fc49bff, 0xbeb72f9b,
    0xbf0999c1, 0x3f29f6b5, 0xbfd2f35a, 0x3fa702d4,
    0x3f4015a4, 0x3ebf019b, 0x3f59a5dd, 0xbffdbc0e,
    0x3f0fc239, 0x3df8d016, 0x3e676570, 0xbfa8a8e7,
    0xbec6a147, 0xbe284486, 0xbed2d37d, 0x3f1b6148,
    0xbf443837, 0xc00fa893, 0x3f978b7b, 0xbd100f0d,
    0x3e34d0a1, 0xbf4751d5, 0xc008e10a, 0xc028439e,
    0x3dd35cad, 0xbf8480b0, 0x3e671a47, 0x3fdd0450,
    0x3fb548c3, 0x43b2d25f, 0x3f6d711b, 0xbe1af60d,
    0xbe66323c, 0x3edf4c00, 0x3e23708d, 0x3e98fe1d,
    0xbe987dae, 0x3f76a3ab, 0x3ffaf982, 0x3f8d896b,
    0x3e815f15, 0x4000a837, 0x3fdabbf3, 0x3e479a6e,
    0x3f7c47aa, 0xbfbef21d, 0xc0015363, 0xbe29fa21,
    0xbfac3efd, 0xbe8c8c8c, 0x401070b2, 0x3f350dd9,
    0x3c2611bf, 0xbff37eb3, 0xbfc4a311, 0x3f4555de,
    0x3edc3b44, 0xbf98e77c, 0xbf0052b4, 0xbd9f5abd,
    0xbf15bc07, 0xbdfe1b8f, 0x3f90be8e, 0xbf52a43b,
    0x3f77623c, 0xbf8183c9, 0xbee0a92c, 0xbe40214f,
    0x3fa81c03, 0xbfc0623b, 0x3f38bf66, 0xbf99fe2c,
    0xbe2459f6, 0x3f8f110e, 0xbe8b7425, 0x3f518c73,
    0xbf006920, 0x3eddacc4, 0x3f27574d, 0xbf82f37b,
    0xc01bc8dc, 0xbf1cd509, 0x3f7332a5, 0xbdf7b7c6,
    0x3d1d6ae7, 0x3d72a3a3, 0x3fab4325, 0x3f906765,
    0x3f1249f6, 0x40090061, 0x3f7cb501, 0x3ee9f6e5,
    0xc054a9ac, 0x4020df2f, 0x3f63e00f, 0x3fc19f2f,
    0x3dc1433f, 0xbf12845e, 0xbfa67708, 0x3e99b22f,
    0x4009ad9e, 0xbfa3672a, 0xbfc273fa, 0xbed5230f,
    0xbf015c54, 0x3f9e1b99, 0x3ea11504, 0xbea38522,
    0xbe93351b, 0xbe86ad09, 0xbf52d4a4, 0x3f2221c7,
    0x3f52b8b3, 0xbfc55aff, 0x3e8298cf, 0xbfc070b8,
    0xbf4adb5d, 0x4040074a, 0x3ed8bd22, 0x3ef4e427,
    0x3ff94869, 0x3e9565ce, 0xc01a4817, 0x3fca1a65,
    0x4017ff26, 0x3f39ca30, 0x3f51f1e1, 0x3ef36aa0,
    0xbe903d0e, 0x3e3a5a5a, 0x3eb7ccd2, 0x3eb1fa94,
    0xbf89eb01, 0xbe562101, 0x3ea01cef, 0xbf48cec4,
    0x3f8ae42a, 0x3fd42e0f, 0xbfbaf500, 0x3e71a174,
    0x3f4218ee, 0xbf8314d9, 0x3f598cff, 0x3ea34e91,
    0xbf3e61ab, 0xbf94946e, 0xbf8c4ec0, 0x3fd8ff1b,
    0xbf4b551e, 0xbf327d0f, 0x3c6245f8, 0xbf977d7c,
    0x3f309185, 0x3fadb4c4, 0xbf7ee2ed, 0x3fed59a6,
    0x3e047114, 0xbf23212a, 0xbfb38a8e, 0xbf5f9729,
    0xbf3e1342, 0x3d248e4f, 0xbf003f94, 0xc0415b75,
    0x3fe1ab65, 0xbf90ead8, 0x3ec62ad8, 0x3f435dba,
    0x3ea6708b, 0x3fa4fa1c, 0x3e7bb841, 0x3e46ee99,
    0xbfd035ae, 0x3f6195bf, 0x3f592ad0, 0x3fb00d70,
    0x4001968a, 0xbf23907e, 0x3ff46832, 0xbe7307cd,
    0x3f427278, 0xbf651c81, 0xbcdfc60c, 0x3f760088,
    0xbf438a3f, 0x3fd69c4d, 0xbfeb2100, 0x3f6c3c02,
    0x3f38f787, 0xbf7d234a, 0xbfb65d67, 0x3f66a61a,
    0xbea5edb8, 0xbf014f97, 0xbf56dec2, 0xbe7b7948,
    0x3fe0fc3c, 0xc012a75b, 0x3ed23e29, 0x3f09070e,
    0x3fd00f57, 0x3fa46179, 0xbf526d93, 0xbf198f97,
    0xbed21e6a, 0x3eda3555, 0x401d8cbc, 0xbfd32eb0,
    0xbf853572, 0x3f40a350, 0xbfc8853d, 0xbfa2565a,
    0xbf2e5216, 0x3f07ffda, 0x3ff6c262, 0x3f0947c4,
    0xbf3146c7, 0x3f2e9bd4, 0x3d973076, 0x3dcf2b10,
    0x3fc25967, 0x40366785, 0xbc70c2f4, 0x4002595f,
    0xbf5e3132, 0xbf9eb89e, 0x3fc35f11, 0xbfaca521,
    0xc0426153, 0xbf432d67, 0x3f42a44b, 0xbf8ad3f7,
    0xbfa14beb, 0x3fd0a564, 0x3f74e54a, 0xbea08da6,
    0xbf23aa79, 0x3dd474c7, 0x407e7741, 0x3ec9ccd2,
    0x3fb21f3c, 0x4050ccf8, 0x3e2e60a1, 0x3ef396da,
    0x3eded676, 0xbe7c7eea, 0x3d87b748, 0xbf1e1a05,
    0xbf226a8f, 0xc023fbe3, 0xbf4aaaf2, 0xbe4c9f63,
    0xbda404ee, 0xbfa429b1, 0x3eb295d0, 0xbeb53917,
    0x3fc7e1de, 0x3e6f9050, 0xbefea450, 0x3c9b8a91,
    0x3f899827, 0x3ff6d6c2, 0x3f284cf9, 0x3ef56e21,
    0xbf5f302b, 0x3dc174a9, 0xbfcb4827, 0xbf3ed09f,
    0xbf85954c, 0x3fb7e93f, 0xbecaef98, 0xbf13dda3,
    0x3ff196b8, 0xbf109b07, 0x3de33a19, 0xbf2a0622,
    0x3f43b843, 0x3eaa9f76, 0xbf261a1c, 0xbd33d3ce,
    0xbf80b4e5, 0xbf562b2f, 0x3fd3a59e, 0x3ee9c92e
    };

static const uint32_t ref_cfft_noisy_1024[2048] = {
    0x3fb2a7b1, 0x0, 0x3fd3a59e, 0xbee9c92e,
    0xbf80b4e5, 0x3f562b2f, 0xbf261a1c, 0x3d33d3ce,
    0x3f43b843, 0xbeaa9f76, 0x3de33a19, 0x3f2a0622,
    0x3ff196b8, 0x3f109b07, 0xbecaef98, 0x3f13dda3,
    0xbf85954c, 0xbfb7e93f, 0xbfcb4827, 0x3f3ed09f,
    0xbf5f302b, 0xbdc174a9, 0x3f284cf9, 0xbef56e21,
    0x3f899827, 0xbff6d6c2, 0xbefea450, 0xbc9b8a91,
    0x3fc7e1de, 0xbe6f9050, 0x3eb295d0, 0x3eb53917,
    0xbda404ee, 0x3fa429b1, 0xbf4aaaf2, 0x3e4c9f63,
    0xbf226a8f, 0x4023fbe3, 0x3d87b748, 0x3f1e1a05,
    0x3eded676, 0x3e7c7eea, 0x3e2e60a1, 0xbef396da,
    0x3fb21f3c, 0xc050ccf8, 0x407e7741, 0xbec9ccd2,
    0xbf23aa79, 0xbdd474c7, 0x3f74e54a, 0x3ea08da6,
    0xbfa14beb, 0xbfd0a564, 0x3f42a44b, 0x3f8ad3f7,
    0xc0426153, 0x3f432d67, 0x3fc35f11, 0x3faca521,
    0xbf5e3132, 0x3f9eb89e, 0xbc70c2f4, 0xc002595f,
    0x3fc25967, 0xc0366785, 0x3d973076, 0xbdcf2b10,
    0xbf3146c7, 0xbf2e9bd4, 0x3ff6c262, 0xbf0947c4,
    0xbf2e5216, 0xbf07ffda, 0xbfc8853d, 0x3fa2565a,
    0xbf853572, 0xbf40a350, 0x401d8cbc, 0x3fd32eb0,
    0xbed21e6a, 0xbeda3555, 0xbf526d93, 0x3f198f97,
    0x3fd00f57, 0xbfa46179, 0x3ed23e29, 0xbf09070e,
    0x3fe0fc3c, 0x4012a75b, 0xbf56dec2, 0x3e7b7948,
    0xbea5edb8, 0x3f014f97, 0xbfb65d67, 0xbf66a61a,
    0x3f38f787, 0x3f7d234a, 0xbfeb2100, 0xbf6c3c02,
    0xbf438a3f, 0xbfd69c4d, 0xbcdfc60c, 0xbf760088,
    0x3f427278, 0x3f651c81, 0x3ff46832, 0x3e7307cd,
    0x4001968a, 0x3f23907e, 0x3f592ad0, 0xbfb00d70,
    0xbfd035ae, 0xbf6195bf, 0x3e7bb841, 0xbe46ee99,
    0x3ea6708b, 0xbfa4fa1c, 0x3ec62ad8, 0xbf435dba,
    0x3fe1ab65, 0x3f90ead8, 0xbf003f94, 0x40415b75,
    0xbf3e1342, 0xbd248e4f, 0xbfb38a8e, 0x3f5f9729,
    0x3e047114, 0x3f23212a, 0xbf7ee2ed, 0xbfed59a6,
    0x3f309185, 0xbfadb4c4, 0x3c6245f8, 0x3f977d7c,
    0xbf4b551e, 0x3f327d0f, 0xbf8c4ec0, 0xbfd8ff1b,
    0xbf3e61ab, 0x3f94946e, 0x3f598cff, 0xbea34e91,
    0x3f4218ee, 0x3f8314d9, 0xbfbaf500, 0xbe71a174,
    0x3f8ae42a, 0xbfd42e0f, 0x3ea01cef, 0x3f48cec4,
    0xbf89eb01, 0x3e562101, 0x3eb7ccd2, 0xbeb1fa94,
    0xbe903d0e, 0xbe3a5a5a, 0x3f51f1e1, 0xbef36aa0,
    0x4017ff26, 0xbf39ca30, 0xc01a4817, 0xbfca1a65,
    0x3ff94869, 0xbe9565ce, 0x3ed8bd22, 0xbef4e427,
    0xbf4adb5d, 0xc040074a, 0x3e8298cf, 0x3fc070b8,
    0x3f52b8b3, 0x3fc55aff, 0xbf52d4a4, 0xbf2221c7,
    0xbe93351b, 0x3e86ad09, 0x3ea11504, 0x3ea38522,
    0xbf015c54, 0xbf9e1b99, 0xbfc273fa, 0x3ed5230f,
    0x4009ad9e, 0x3fa3672a, 0xbfa67708, 0xbe99b22f,
    0x3dc1433f, 0x3f12845e, 0x3f63e00f, 0xbfc19f2f,
    0xc054a9ac, 0xc020df2f, 0x3f7cb501, 0xbee9f6e5,
    0x3f1249f6, 0xc0090061, 0x3fab4325, 0xbf906765,
    0x3d1d6ae7, 0xbd72a3a3, 0x3f7332a5, 0x3df7b7c6,
    0xc01bc8dc, 0x3f1cd509, 0x3f27574d, 0x3f82f37b,
    0xbf006920, 0xbeddacc4, 0xbe8b7425, 0xbf518c73,
    0xbe2459f6, 0xbf8f110e, 0x3f38bf66, 0x3f99fe2c,
    0x3fa81c03, 0x3fc0623b, 0xbee0a92c, 0x3e40214f,
    0x3f77623c, 0x3f8183c9, 0x3f90be8e, 0x3f52a43b,
    0xbf15bc07, 0x3dfe1b8f, 0xbf0052b4, 0x3d9f5abd,
    0x3edc3b44, 0x3f98e77c, 0xbfc4a311, 0xbf4555de,
    0x3c2611bf, 0x3ff37eb3, 0x401070b2, 0xbf350dd9,
    0xbfac3efd, 0x3e8c8c8c, 0xc0015363, 0x3e29fa21,
    0x3f7c47aa, 0x3fbef21d, 0x3fdabbf3, 0xbe479a6e,
    0x3e815f15, 0xc000a837, 0x3ffaf982, 0xbf8d896b,
    0xbe987dae, 0xbf76a3ab, 0x3e23708d, 0xbe98fe1d,
    0xbe66323c, 0xbedf4c00, 0x3f6d711b, 0x3e1af60d,
    0x3fb548c3, 0xc3b2d25f, 0x3e671a47, 0xbfdd0450,
    0x3dd35cad, 0x3f8480b0, 0xc008e10a, 0x4028439e,
    0x3e34d0a1, 0x3f4751d5, 0x3f978b7b, 0x3d100f0d,
    0xbf443837, 0x400fa893, 0xbed2d37d, 0xbf1b6148,
    0xbec6a147, 0x3e284486, 0x3e676570, 0x3fa8a8e7,
    0x3f0fc239, 0xbdf8d016, 0x3f59a5dd, 0x3ffdbc0e,
    0x3f4015a4, 0xbebf019b, 0xbfd2f35a, 0xbfa702d4,
    0xbf0999c1, 0xbf29f6b5, 0x3fc49bff, 0x3eb72f9b,
    0xbe86b93b, 0x3d22a846, 0x3f7f07f6, 0xbf5d8863,
    0xbea7533e, 0xbec51afe, 0xbfaf0db2, 0xbf1c5125,
    0xbf32e6ef, 0x3f3a5ddd, 0xbea9454c, 0xbf00f365,
    0xbe7a31b8, 0x4008e29d, 0x3f33c363, 0x3eaa9371,
    0x3f7da56b, 0xbf8f7a1a, 0xbd482313, 0xbef1055a,
    0xbf6fc443, 0xc0019a21, 0x3f808a05, 0x3f32a523,
    0x3f8b0c98, 0x3fac289b, 0xbd77d03e, 0xbf85fcc7,
    0x3fa2fef6, 0x3e166749, 0xbfbe571f, 0xbdc7b5fd,
    0xc017faa1, 0xbfe02e79, 0xbf45e84a, 0x3fccc40b,
    0xbfa33b8b, 0x3fc53f79, 0x3fd3eccf, 0xbfdb9f6d,
    0x3f9d471c, 0xbf5ec722, 0x3f67467b, 0xbea3cdf4,
    0x3fadbfea, 0xbf85a051, 0xbfbd0d51, 0xbf2224c8,
    0xbe9fb5e5, 0xbfa4dc96, 0xbf88665d, 0xbf6003bd,
    0x3de2de41, 0xbfe7252a, 0xc00bdfad, 0x3e3d5bcc,
    0x3f3f97f2, 0x3d10444c, 0xc01bf6e2, 0x3f1efbd2,
    0xbf6d52b5, 0xc03aeb23, 0xbeffc482, 0xbf13f2e2,
    0x3e23dbab, 0x3fe4aa7b, 0xbf09ead4, 0x3ee76d02,
    0x3f3744f7, 0x4005f201, 0x3f2826e0, 0xbf6febc4,
    0x3e3ab551, 0x3e73a01c, 0x3ef0ce48, 0xbe2799e8,
    0x3fec4e7a, 0xbff805fd, 0xbdb67ad6, 0xbfaf3ed2,
    0x3f87cc07, 0xbeb4d61d, 0xbdef46de, 0xc025a519,
    0x3f7f5e23, 0xbf088ca4, 0xbdb7dfb8, 0x3bd703b6,
    0x3f020cbb, 0x40801eef, 0x3fb2e1ef, 0x3f433371,
    0x3fae732f, 0x3f1658d7, 0xbf9f53bf, 0x3e23194e,
    0x3f8ad4ef, 0xbe8d0f7a, 0x3f324228, 0x3f8010f7,
    0xbffb9293, 0xbe530c9d, 0xbf3e00a5, 0x3e044952,
    0x3f41de8f, 0xbf4346c6, 0x3f967644, 0xbef2bec1,
    0xbf32affb, 0xc031142e, 0x3f96e3d5, 0xc022f6d6,
    0x3bf50a0a, 0xc01ee7f6, 0x3ca0bbc5, 0x3df25513,
    0xbf4dbfab, 0x401680bc, 0x3f614769, 0xbf78e4ab,
    0x3eeeeb6b, 0x3f908e68, 0xbf1a1a30, 0x3e2c89d7,
    0x3f152360, 0xc0052657, 0x40124c36, 0xbf063ac4,
    0xbf81a34c, 0x3f3ec7c0, 0xbeeaf397, 0xbd7951fc,
    0xbf07032e, 0x3f2eb2ce, 0x3e001594, 0x3f952a17,
    0xbf5eeb2e, 0xbf97a647, 0xbf2a000a, 0x3f1af068,
    0x3fc87ca1, 0xbdc8fe51, 0x3f43087e, 0xbea74259,
    0xbed00e97, 0x3f713ac4, 0xbe3e19c4, 0xbe5719c2,
    0x3f120524, 0x3f3810b8, 0xbf356656, 0x3f9b7914,
    0xbfcb13a9, 0xbeae0133, 0xbdc3e859, 0x3c3ff9b6,
    0x3ea74c7b, 0xbf086b4d, 0x3f85c3ed, 0x3ff67708,
    0xbf0f893f, 0x3fc95023, 0xbf180480, 0xbf2918ad,
    0x3e8950eb, 0x3f6cd300, 0x3f85fe1f, 0xbedccef9,
    0xbf87a238, 0x3f087df9, 0xbfd56a2a, 0x3fc3d10e,
    0xbe2814a6, 0xbf0119c9, 0xbf36077a, 0x3f993609,
    0x402e42ea, 0xbf2d25a0, 0x3e990ca9, 0x3f325ef2,
    0x3ffcdc90, 0x3f7f3399, 0xbf88ce44, 0x3f985240,
    0x3f278102, 0x3e90b5cf, 0xbfb61866, 0xc08e3c56,
    0x3f7fabda, 0x3fbabefc, 0x3f23512b, 0x3ef93b74,
    0xbd75da37, 0x3cb263c7, 0xbfa25aed, 0xbed7f4ad,
    0xbfad43ee, 0x3e3ccef7, 0x3de6c166, 0x3f92ddfa,
    0x4041d693, 0x4044a872, 0xbffeadac, 0x3f231104,
    0x3f5d3d44, 0xbf2af618, 0xbddadbd2, 0xbfb38504,
    0x3f24c2ba, 0x3fe6a43e, 0x3f8ef5c1, 0xbea3460d,
    0xbf824cdc, 0xbf29b3ba, 0x3e83468f, 0xbe8d9b77,
    0xbec40d20, 0xbf112053, 0xbfc000ea, 0x3f92c82a,
    0xc02f0dc4, 0x3ed76c1f, 0xbf2c7787, 0xbe75ff27,
    0xbfb1dffd, 0x3fa8a1f9, 0xbf859902, 0xbe80b265,
    0x3f3e0e97, 0x3eda6c9d, 0xbf9d4c7f, 0x3f55b48a,
    0xbf7c59d0, 0xbf913d1e, 0xbf9cdc19, 0x3f9694a9,
    0xbe0e29af, 0x4009de3d, 0xbf69aafd, 0xbe76f482,
    0x3f210140, 0x3f9825b8, 0xbec17fef, 0xbe3a9e3b,
    0x3efbb542, 0xbf66cb8e, 0x3f4c9c64, 0xbfb0b99a,
    0xbfbb007b, 0xbf510608, 0x3f2dad1f, 0xbebfa248,
    0x3fa0a001, 0xbe9f866c, 0xbeae93d4, 0x3f95462f,
    0x3ff4037f, 0x3f464270, 0x3f6c7d15, 0x3e9b56d6,
    0xc00a95a5, 0xbf5455ef, 0x3f7809ff, 0xbf32415c,
    0xbead88f4, 0xbd8959a1, 0x3f86cfb2, 0xc0183168,
    0x3e8dc4f7, 0xbd96b4de, 0x4004eb05, 0xbfacc596,
    0xbfa67510, 0xbed1fc0e, 0xbecd734a, 0x4006c179,
    0x401d7eba, 0x4036debb, 0xbf8c640d, 0xbf732fef,
    0xbf863ca0, 0xbf8b59c9, 0xbf3f04b6, 0x3fc62db9,
    0xbfafe90f, 0xbeb50a08, 0xbe410e33, 0xbde60e1f,
    0x3ec3f8fa, 0x4005ab51, 0x3e95142e, 0xbea13206,
    0x3fb99b7e, 0x3f9b1366, 0xc01a5ed0, 0xbe8cf816,
    0xbf813666, 0xbf5af607, 0x3f83fdbc, 0xbe2a882c,
    0x3ee79049, 0xbe048340, 0xbf997bea, 0x3e607a38,
    0x3fca4d67, 0x3d8631b1, 0x3f6c361b, 0xbf4c290a,
    0xbf54a3cf, 0xbf194d33, 0xbf1afe02, 0x3ee58746,
    0xbf818ddc, 0x3f3cc983, 0x3f29cae2, 0xbf120f96,
    0x3f0f3cc8, 0xbf076b1a, 0xbfb2de75, 0x3f0adb75,
    0xbf5c71ff, 0xbfc0fd53, 0xbf047b0c, 0x4021b565,
    0x3e86302b, 0x3f52cef8, 0xbf672802, 0xbf50f837,
    0xbca6ea23, 0x3f0bfc6f, 0xc0060ad1, 0x3fbb3f42,
    0xbfd9056f, 0x3d0e893b, 0x3e92fa22, 0x3f900c35,
    0x3d0e97d6, 0xc000432e, 0x3f784a26, 0x3f0d66cd,
    0x4005b466, 0xbe88c943, 0x401430c8, 0xbe1158bd,
    0x3f5a887a, 0xbef7e969, 0xbfd81ddb, 0xbca762a9,
    0xc0038dc9, 0x40287121, 0x3f5546ab, 0x3f1a281c,
    0x3ec41526, 0x3f77d30a, 0xbe931ca4, 0x3fc1cdae,
    0xbeb56aa2, 0x3fac5426, 0x3f3283c7, 0x3f3ab292,
    0x3f2a6e31, 0xbfb712b1, 0x3fbc392f, 0xbfd74b33,
    0xbfdd4234, 0xc0090aab, 0xbf9b950e, 0xbfe3a2dc,
    0x3f9d2175, 0xbf037520, 0xbf17ecb0, 0x4001ddc8,
    0x3f8bd661, 0xbfbe3365, 0xbf2e0f00, 0xbf53f9b0,
    0x3f32a59b, 0x3f8f2bdc, 0xc008e7dc, 0xbe3e5664,
    0x3de54a6e, 0x3e03effa, 0x3f82405c, 0x3edc1dc8,
    0xbe8ce5ba, 0x3f8a410b, 0xc0000cbc, 0x400375d7,
    0x3f466601, 0xbf1d0dfe, 0x3f7d7798, 0x3f8f3238,
    0x3f283b05, 0x3fa7b315, 0xbf0469ce, 0xc0018dcc,
    0x3fd8ee1e, 0x3f33dc85, 0xc00cc9e2, 0x3e38465e,
    0x3fa0043a, 0x400ae8d0, 0xbf7872a3, 0x3f9c6895,
    0xbfda0f3a, 0x3f045356, 0x3e83d875, 0xbf9d4dbb,
    0x3f5ce817, 0x3fe0581d, 0xbe705b6e, 0xbf7f652b,
    0xbcc7bf11, 0xbd3df22c, 0xbfd61811, 0x3c3fec73,
    0xbf2e3e0d, 0xbd35d395, 0xbf8eee9d, 0x3eef0479,
    0xbec02edc, 0xbfaeae2a, 0x3f14512f, 0xbea64f91,
    0xbf89794f, 0xbf0e7c68, 0xbe9b5f22, 0xbfcc03ee,
    0xbf6a7103, 0xc0325eb5, 0x3f288704, 0x3f61e474,
    0x3e6e757c, 0x3f9b31a9, 0xbf4eb64d, 0xbfd781fc,
    0xbf85bc37, 0xbf1c7b73, 0xbfa123f3, 0x3ea7a012,
    0x3f3bcebc, 0x3e8f85d8, 0x3f77849b, 0xbf8c83ab,
    0x3d871cd9, 0xbeac7121, 0x3ca3f903, 0xbe1fc02b,
    0xbf177e6f, 0x3de30ed8, 0xbf0abfe4, 0xbebfd0c5,
    0x3ec8e79e, 0xbf503568, 0xbfa84de1, 0x3ecc79c6,
    0x3fbd72b8, 0xbfadb896, 0xbf35719c, 0xbf9f586d,
    0xbfc0ed7c, 0xbfb7a13a, 0x3edf13b9, 0xbfafefc7,
    0xbfa5556c, 0x3f6f4bc8, 0x3ef2e84f, 0x3fc29a42,
    0xbf39a742, 0x3fa1d333, 0xc0563fdd, 0xbfb9d0b3,
    0xbfed10bb, 0xbf62321a, 0xbfcfc5ed, 0xc06c5557,
    0x3fbdfe12, 0x3fafa044, 0x400db091, 0xbf753014,
    0x3fc2a37d, 0xbfba481d, 0xbf68da77, 0x40253c34,
    0x3c9aedae, 0xbff3e5a7, 0xbf3aa86c, 0xbeb84315,
    0x3de5a174, 0x3e4d9963, 0x3f2323b6, 0x3fbd70f5,
    0xbf10c283, 0x3f6e352c, 0x3f072d85, 0x3f40fc93,
    0xbf605057, 0x3fc9f68e, 0xbf9079a3, 0x3e1e5595,
    0x3f1e0080, 0x3fd4c035, 0xbf5612bf, 0xbfb4b65c,
    0x3f741ca3, 0x3f980171, 0x3fd79877, 0xbf6fc244,
    0x3e8ca9ac, 0xbf33222c, 0xbfb5d844, 0xc01fc98d,
    0xbf9d88d7, 0x3ee2b792, 0x3e655e18, 0xbedf0919,
    0x3fe8a33b, 0xbf872f88, 0xbf8edf5d, 0xbe90449d,
    0xbf69f371, 0xbf8807cd, 0xbf3e48f5, 0x3d308ff6,
    0xbd708884, 0xbe3653dd, 0xc000ff70, 0x3f162d70,
    0x3f930e9f, 0xbf1f534b, 0x3f6cb41d, 0x403fa3e0,
    0xbd039f67, 0x3e08910f, 0x3f7442ec, 0xbf99e4d1,
    0x3e952ac1, 0x3fc5206b, 0xbe421f17, 0xbf45215d,
    0xc032c561, 0x3f047109, 0x3f095d6c, 0x3fb91c0f,
    0x3f250957, 0x3ef169d7, 0xbfccf829, 0xbffb438f,
    0x3f459353, 0xbf9a4303, 0x3da95b51, 0x3f2ca172,
    0x3de8eb07, 0x3f2da4cd, 0x3f034451, 0x3fc176b3,
    0xbe181a88, 0xbe61b42f, 0x3fa4bd83, 0x3f9d3e9e,
    0x3f76b13e, 0x3f07408b, 0x3f3ec151, 0xbe482d01,
    0xbe6f5169, 0xbfc44e97, 0xbf48f9f8, 0xbf539ebe,
    0x3f42c2ba, 0x3fe34cf5, 0x3eda51a4, 0x3f73ae95,
    0x3fd57c8e, 0xbfe14ee0, 0xbe51b924, 0xbeb4160d,
    0xbed2e119, 0x3fb0b8c4, 0x3f45a548, 0xbe26adc8,
    0x3fa913e0, 0xbfa4e055, 0xbf8a3866, 0xbe36471c,
    0xc01f6b61, 0xbe068f8b, 0xc03ed402, 0xbed4920a,
    0x3f8fac6a, 0x3f5e0fe1, 0x3e7129a1, 0x4026c5d2,
    0xbefb5b2c, 0xc0190fa8, 0xbe5b960d, 0xbfe3474a,
    0x3f98c6ff, 0xbedecddc, 0xbf579d98, 0x3e277b89,
    0x3f3bede0, 0xbeef4e4d, 0xbf9f8111, 0x3f571968,
    0xbdc10895, 0x3fc08fe8, 0x3f69f776, 0x3f6b0b5b,
    0xc0346b9d, 0xbf795972, 0x3e0fc44a, 0x3f575903,
    0x3d0c7478, 0xbdeb9072, 0xbf9a666f, 0x3f5f149d,
    0xbfab06a0, 0x3f90a35f, 0x3edea2af, 0xbb892a9f,
    0xc02e21bf, 0x3d9e4acb, 0x3fc1eee1, 0xbff1077f,
    0xbee21dae, 0xbd892c8e, 0xbed90495, 0x3d756920,
    0x3ea1364c, 0x3fdc9347, 0xbe638625, 0x3f203043,
    0x3d3d29fb, 0x3fabacf5, 0x3efe4fc2, 0x3f78ee7d,
    0xbda3c12a, 0xc01d4bb4, 0xbf998506, 0xbfa69b2f,
    0xbeef761e, 0x4021c275, 0xbde587b6, 0xbfeff148,
    0x3e9a0ab7, 0x3e0d780d, 0x3ec23560, 0x3f520f8e,
    0x3f4eae38, 0xbe52d56d, 0xbe05135e, 0xbf57f327,
    0x3f9e6399, 0x3eb953ff, 0xbf7df14e, 0x3fad437b,
    0xbfa0b4a0, 0x3f0e1d81, 0x3ec1f57d, 0x3f9204a1,
    0x3dbff900, 0x3f84d2c2, 0x3f05d482, 0xbeef1bc7,
    0x3e87911f, 0xbf593f68, 0x3fd07e20, 0x3ef60b2c,
    0xbe638385, 0x400e1bef, 0xbf45120b, 0x3ec45f13,
    0x3f8338a0, 0xbf5b79d9, 0xbfe58ecc, 0xbfb5cc03,
    0xbf1d4a06, 0x3fa109e0, 0x3f4a7fd6, 0x3fc54976,
    0x3f05ea42, 0x3d1fd1ec, 0x3fd20ee0, 0xbfaf7fbe,
    0xbf42485e, 0x400b8eff, 0x3f55026a, 0xbe678b41,
    0xc006059a, 0xbfed283f, 0xbe239344, 0x3e9ac4c4,
    0x3f976d7a, 0xbfe89f60, 0xbf80663e, 0x3eaa1e89,
    0x3f3f862e, 0xbf85e95c, 0xbe7e8c2c, 0x3fa88c61,
    0x3e97dd7a, 0x3e02bbce, 0x3f8a8331, 0xbfe7a14f,
    0xbfab0cfb, 0x3d8de5d7, 0x3f49a58f, 0xc00e432e,
    0xbfa3a0e0, 0x3f945da7, 0xbf8d1296, 0x3f3f3981,
    0x3f78afb3, 0xbf7bba9e, 0x3e21e623, 0xbebd7b48,
    0xbf6ae6c5, 0x3f1e00e6, 0xbef33a2c, 0xbe1ff2cf,
    0xbd9c766e, 0xbfd03488, 0x40148bcf, 0x3f5856d8,
    0x3df619a1, 0x3e5e8b3a, 0x3f5e0815, 0xbf3c854f,
    0x3f09459b, 0x40413ca8, 0x3eb32338, 0x3e987774,
    0x3f950fe6, 0x3f76ab87, 0x3f6d50da, 0x3f1a348c,
    0xc0687489, 0x0, 0x3f6d50da, 0xbf1a348c,
    0x3f950fe6, 0xbf76ab87, 0x3eb32338, 0xbe987774,
    0x3f09459b, 0xc0413ca8, 0x3f5e0815, 0x3f3c854f,
    0x3df619a1, 0xbe5e8b3a, 0x40148bcf, 0xbf5856d8,
    0xbd9c766e, 0x3fd03488, 0xbef33a2c, 0x3e1ff2cf,
    0xbf6ae6c5, 0xbf1e00e6, 0x3e21e623, 0x3ebd7b48,
    0x3f78afb3, 0x3f7bba9e, 0xbf8d1296, 0xbf3f3981,
    0xbfa3a0e0, 0xbf945da7, 0x3f49a58f, 0x400e432e,
    0xbfab0cfb, 0xbd8de5d7, 0x3f8a8331, 0x3fe7a14f,
    0x3e97dd7a, 0xbe02bbce, 0xbe7e8c2c, 0xbfa88c61,
    0x3f3f862e, 0x3f85e95c, 0xbf80663e, 0xbeaa1e89,
    0x3f976d7a, 0x3fe89f60, 0xbe239344, 0xbe9ac4c4,
    0xc006059a, 0x3fed283f, 0x3f55026a, 0x3e678b41,
    0xbf42485e, 0xc00b8eff, 0x3fd20ee0, 0x3faf7fbe,
    0x3f05ea42, 0xbd1fd1ec, 0x3f4a7fd6, 0xbfc54976,
    0xbf1d4a06, 0xbfa109e0, 0xbfe58ecc, 0x3fb5cc03,
    0x3f8338a0, 0x3f5b79d9, 0xbf45120b, 0xbec45f13,
    0xbe638385, 0xc00e1bef, 0x3fd07e20, 0xbef60b2c,
    0x3e87911f, 0x3f593f68, 0x3f05d482, 0x3eef1bc7,
    0x3dbff900, 0xbf84d2c2, 0x3ec1f57d, 0xbf9204a1,
    0xbfa0b4a0, 0xbf0e1d81, 0xbf7df14e, 0xbfad437b,
    0x3f9e6399, 0xbeb953ff, 0xbe05135e, 0x3f57f327,
    0x3f4eae38, 0x3e52d56d, 0x3ec23560, 0xbf520f8e,
    0x3e9a0ab7, 0xbe0d780d, 0xbde587b6, 0x3feff148,
    0xbeef761e, 0xc021c275, 0xbf998506, 0x3fa69b2f,
    0xbda3c12a, 0x401d4bb4, 0x3efe4fc2, 0xbf78ee7d,
    0x3d3d29fb, 0xbfabacf5, 0xbe638625, 0xbf203043,
    0x3ea1364c, 0xbfdc9347, 0xbed90495, 0xbd756920,
    0xbee21dae, 0x3d892c8e, 0x3fc1eee1, 0x3ff1077f,
    0xc02e21bf, 0xbd9e4acb, 0x3edea2af, 0x3b892a9f,
    0xbfab06a0, 0xbf90a35f, 0xbf9a666f, 0xbf5f149d,
    0x3d0c7478, 0x3deb9072, 0x3e0fc44a, 0xbf575903,
    0xc0346b9d, 0x3f795972, 0x3f69f776, 0xbf6b0b5b,
    0xbdc10895, 0xbfc08fe8, 0xbf9f8111, 0xbf571968,
    0x3f3bede0, 0x3eef4e4d, 0xbf579d98, 0xbe277b89,
    0x3f98c6ff, 0x3edecddc, 0xbe5b960d, 0x3fe3474a,
    0xbefb5b2c, 0x40190fa8, 0x3e7129a1, 0xc026c5d2,
    0x3f8fac6a, 0xbf5e0fe1, 0xc03ed402, 0x3ed4920a,
    0xc01f6b61, 0x3e068f8b, 0xbf8a3866, 0x3e36471c,
    0x3fa913e0, 0x3fa4e055, 0x3f45a548, 0x3e26adc8,
    0xbed2e119, 0xbfb0b8c4, 0xbe51b924, 0x3eb4160d,
    0x3fd57c8e, 0x3fe14ee0, 0x3eda51a4, 0xbf73ae95,
    0x3f42c2ba, 0xbfe34cf5, 0xbf48f9f8, 0x3f539ebe,
    0xbe6f5169, 0x3fc44e97, 0x3f3ec151, 0x3e482d01,
    0x3f76b13e, 0xbf07408b, 0x3fa4bd83, 0xbf9d3e9e,
    0xbe181a88, 0x3e61b42f, 0x3f034451, 0xbfc176b3,
    0x3de8eb07, 0xbf2da4cd, 0x3da95b51, 0xbf2ca172,
    0x3f459353, 0x3f9a4303, 0xbfccf829, 0x3ffb438f,
    0x3f250957, 0xbef169d7, 0x3f095d6c, 0xbfb91c0f,
    0xc032c561, 0xbf047109, 0xbe421f17, 0x3f45215d,
    0x3e952ac1, 0xbfc5206b, 0x3f7442ec, 0x3f99e4d1,
    0xbd039f67, 0xbe08910f, 0x3f6cb41d, 0xc03fa3e0,
    0x3f930e9f, 0x3f1f534b, 0xc000ff70, 0xbf162d70,
    0xbd708884, 0x3e3653dd, 0xbf3e48f5, 0xbd308ff6,
    0xbf69f371, 0x3f8807cd, 0xbf8edf5d, 0x3e90449d,
    0x3fe8a33b, 0x3f872f88, 0x3e655e18, 0x3edf0919,
    0xbf9d88d7, 0xbee2b792, 0xbfb5d844, 0x401fc98d,
    0x3e8ca9ac, 0x3f33222c, 0x3fd79877, 0x3f6fc244,
    0x3f741ca3, 0xbf980171, 0xbf5612bf, 0x3fb4b65c,
    0x3f1e0080, 0xbfd4c035, 0xbf9079a3, 0xbe1e5595,
    0xbf605057, 0xbfc9f68e, 0x3f072d85, 0xbf40fc93,
    0xbf10c283, 0xbf6e352c, 0x3f2323b6, 0xbfbd70f5,
    0x3de5a174, 0xbe4d9963, 0xbf3aa86c, 0x3eb84315,
    0x3c9aedae, 0x3ff3e5a7, 0xbf68da77, 0xc0253c34,
    0x3fc2a37d, 0x3fba481d, 0x400db091, 0x3f753014,
    0x3fbdfe12, 0xbfafa044, 0xbfcfc5ed, 0x406c5557,
    0xbfed10bb, 0x3f62321a, 0xc0563fdd, 0x3fb9d0b3,
    0xbf39a742, 0xbfa1d333, 0x3ef2e84f, 0xbfc29a42,
    0xbfa5556c, 0xbf6f4bc8, 0x3edf13b9, 0x3fafefc7,
    0xbfc0ed7c, 0x3fb7a13a, 0xbf35719c, 0x3f9f586d,
    0x3fbd72b8, 0x3fadb896, 0xbfa84de1, 0xbecc79c6,
    0x3ec8e79e, 0x3f503568, 0xbf0abfe4, 0x3ebfd0c5,
    0xbf177e6f, 0xbde30ed8, 0x3ca3f903, 0x3e1fc02b,
    0x3d871cd9, 0x3eac7121, 0x3f77849b, 0x3f8c83ab,
    0x3f3bcebc, 0xbe8f85d8, 0xbfa123f3, 0xbea7a012,
    0xbf85bc37, 0x3f1c7b73, 0xbf4eb64d, 0x3fd781fc,
    0x3e6e757c, 0xbf9b31a9, 0x3f288704, 0xbf61e474,
    0xbf6a7103, 0x40325eb5, 0xbe9b5f22, 0x3fcc03ee,
    0xbf89794f, 0x3f0e7c68, 0x3f14512f, 0x3ea64f91,
    0xbec02edc, 0x3faeae2a, 0xbf8eee9d, 0xbeef0479,
    0xbf2e3e0d, 0x3d35d395, 0xbfd61811, 0xbc3fec73,
    0xbcc7bf11, 0x3d3df22c, 0xbe705b6e, 0x3f7f652b,
    0x3f5ce817, 0xbfe0581d, 0x3e83d875, 0x3f9d4dbb,
    0xbfda0f3a, 0xbf045356, 0xbf7872a3, 0xbf9c6895,
    0x3fa0043a, 0xc00ae8d0, 0xc00cc9e2, 0xbe38465e,
    0x3fd8ee1e, 0xbf33dc85, 0xbf0469ce, 0x40018dcc,
    0x3f283b05, 0xbfa7b315, 0x3f7d7798, 0xbf8f3238,
    0x3f466601, 0x3f1d0dfe, 0xc0000cbc, 0xc00375d7,
    0xbe8ce5ba, 0xbf8a410b, 0x3f82405c, 0xbedc1dc8,
    0x3de54a6e, 0xbe03effa, 0xc008e7dc, 0x3e3e5664,
    0x3f32a59b, 0xbf8f2bdc, 0xbf2e0f00, 0x3f53f9b0,
    0x3f8bd661, 0x3fbe3365, 0xbf17ecb0, 0xc001ddc8,
    0x3f9d2175, 0x3f037520, 0xbf9b950e, 0x3fe3a2dc,
    0xbfdd4234, 0x40090aab, 0x3fbc392f, 0x3fd74b33,
    0x3f2a6e31, 0x3fb712b1, 0x3f3283c7, 0xbf3ab292,
    0xbeb56aa2, 0xbfac5426, 0xbe931ca4, 0xbfc1cdae,
    0x3ec41526, 0xbf77d30a, 0x3f5546ab, 0xbf1a281c,
    0xc0038dc9, 0xc0287121, 0xbfd81ddb, 0x3ca762a9,
    0x3f5a887a, 0x3ef7e969, 0x401430c8, 0x3e1158bd,
    0x4005b466, 0x3e88c943, 0x3f784a26, 0xbf0d66cd,
    0x3d0e97d6, 0x4000432e, 0x3e92fa22, 0xbf900c35,
    0xbfd9056f, 0xbd0e893b, 0xc0060ad1, 0xbfbb3f42,
    0xbca6ea23, 0xbf0bfc6f, 0xbf672802, 0x3f50f837,
    0x3e86302b, 0xbf52cef8, 0xbf047b0c, 0xc021b565,
    0xbf5c71ff, 0x3fc0fd53, 0xbfb2de75, 0xbf0adb75,
    0x3f0f3cc8, 0x3f076b1a, 0x3f29cae2, 0x3f120f96,
    0xbf818ddc, 0xbf3cc983, 0xbf1afe02, 0xbee58746,
    0xbf54a3cf, 0x3f194d33, 0x3f6c361b, 0x3f4c290a,
    0x3fca4d67, 0xbd8631b1, 0xbf997bea, 0xbe607a38,
    0x3ee79049, 0x3e048340, 0x3f83fdbc, 0x3e2a882c,
    0xbf813666, 0x3f5af607, 0xc01a5ed0, 0x3e8cf816,
    0x3fb99b7e, 0xbf9b1366, 0x3e95142e, 0x3ea13206,
    0x3ec3f8fa, 0xc005ab51, 0xbe410e33, 0x3de60e1f,
    0xbfafe90f, 0x3eb50a08, 0xbf3f04b6, 0xbfc62db9,
    0xbf863ca0, 0x3f8b59c9, 0xbf8c640d, 0x3f732fef,
    0x401d7eba, 0xc036debb, 0xbecd734a, 0xc006c179,
    0xbfa67510, 0x3ed1fc0e, 0x4004eb05, 0x3facc596,
    0x3e8dc4f7, 0x3d96b4de, 0x3f86cfb2, 0x40183168,
    0xbead88f4, 0x3d8959a1, 0x3f7809ff, 0x3f32415c,
    0xc00a95a5, 0x3f5455ef, 0x3f6c7d15, 0xbe9b56d6,
    0x3ff4037f, 0xbf464270, 0xbeae93d4, 0xbf95462f,
    0x3fa0a001, 0x3e9f866c, 0x3f2dad1f, 0x3ebfa248,
    0xbfbb007b, 0x3f510608, 0x3f4c9c64, 0x3fb0b99a,
    0x3efbb542, 0x3f66cb8e, 0xbec17fef, 0x3e3a9e3b,
    0x3f210140, 0xbf9825b8, 0xbf69aafd, 0x3e76f482,
    0xbe0e29af, 0xc009de3d, 0xbf9cdc19, 0xbf9694a9,
    0xbf7c59d0, 0x3f913d1e, 0xbf9d4c7f, 0xbf55b48a,
    0x3f3e0e97, 0xbeda6c9d, 0xbf859902, 0x3e80b265,
    0xbfb1dffd, 0xbfa8a1f9, 0xbf2c7787, 0x3e75ff27,
    0xc02f0dc4, 0xbed76c1f, 0xbfc000ea, 0xbf92c82a,
    0xbec40d20, 0x3f112053, 0x3e83468f, 0x3e8d9b77,
    0xbf824cdc, 0x3f29b3ba, 0x3f8ef5c1, 0x3ea3460d,
    0x3f24c2ba, 0xbfe6a43e, 0xbddadbd2, 0x3fb38504,
    0x3f5d3d44, 0x3f2af618, 0xbffeadac, 0xbf231104,
    0x4041d693, 0xc044a872, 0x3de6c166, 0xbf92ddfa,
    0xbfad43ee, 0xbe3ccef7, 0xbfa25aed, 0x3ed7f4ad,
    0xbd75da37, 0xbcb263c7, 0x3f23512b, 0xbef93b74,
    0x3f7fabda, 0xbfbabefc, 0xbfb61866, 0x408e3c56,
    0x3f278102, 0xbe90b5cf, 0xbf88ce44, 0xbf985240,
    0x3ffcdc90, 0xbf7f3399, 0x3e990ca9, 0xbf325ef2,
    0x402e42ea, 0x3f2d25a0, 0xbf36077a, 0xbf993609,
    0xbe2814a6, 0x3f0119c9, 0xbfd56a2a, 0xbfc3d10e,
    0xbf87a238, 0xbf087df9, 0x3f85fe1f, 0x3edccef9,
    0x3e8950eb, 0xbf6cd300, 0xbf180480, 0x3f2918ad,
    0xbf0f893f, 0xbfc95023, 0x3f85c3ed, 0xbff67708,
    0x3ea74c7b, 0x3f086b4d, 0xbdc3e859, 0xbc3ff9b6,
    0xbfcb13a9, 0x3eae0133, 0xbf356656, 0xbf9b7914,
    0x3f120524, 0xbf3810b8, 0xbe3e19c4, 0x3e5719c2,
    0xbed00e97, 0xbf713ac4, 0x3f43087e, 0x3ea74259,
    0x3fc87ca1, 0x3dc8fe51, 0xbf2a000a, 0xbf1af068,
    0xbf5eeb2e, 0x3f97a647, 0x3e001594, 0xbf952a17,
    0xbf07032e, 0xbf2eb2ce, 0xbeeaf397, 0x3d7951fc,
    0xbf81a34c, 0xbf3ec7c0, 0x40124c36, 0x3f063ac4,
    0x3f152360, 0x40052657, 0xbf1a1a30, 0xbe2c89d7,
    0x3eeeeb6b, 0xbf908e68, 0x3f614769, 0x3f78e4ab,
    0xbf4dbfab, 0xc01680bc, 0x3ca0bbc5, 0xbdf25513,
    0x3bf50a0a, 0x401ee7f6, 0x3f96e3d5, 0x4022f6d6,
    0xbf32affb, 0x4031142e, 0x3f967644, 0x3ef2bec1,
    0x3f41de8f, 0x3f4346c6, 0xbf3e00a5, 0xbe044952,
    0xbffb9293, 0x3e530c9d, 0x3f324228, 0xbf8010f7,
    0x3f8ad4ef, 0x3e8d0f7a, 0xbf9f53bf, 0xbe23194e,
    0x3fae732f, 0xbf1658d7, 0x3fb2e1ef, 0xbf433371,
    0x3f020cbb, 0xc0801eef, 0xbdb7dfb8, 0xbbd703b6,
    0x3f7f5e23, 0x3f088ca4, 0xbdef46de, 0x4025a519,
    0x3f87cc07, 0x3eb4d61d, 0xbdb67ad6, 0x3faf3ed2,
    0x3fec4e7a, 0x3ff805fd, 0x3ef0ce48, 0x3e2799e8,
    0x3e3ab551, 0xbe73a01c, 0x3f2826e0, 0x3f6febc4,
    0x3f3744f7, 0xc005f201, 0xbf09ead4, 0xbee76d02,
    0x3e23dbab, 0xbfe4aa7b, 0xbeffc482, 0x3f13f2e2,
    0xbf6d52b5, 0x403aeb23, 0xc01bf6e2, 0xbf1efbd2,
    0x3f3f97f2, 0xbd10444c, 0xc00bdfad, 0xbe3d5bcc,
    0x3de2de41, 0x3fe7252a, 0xbf88665d, 0x3f6003bd,
    0xbe9fb5e5, 0x3fa4dc96, 0xbfbd0d51, 0x3f2224c8,
    0x3fadbfea, 0x3f85a051, 0x3f67467b, 0x3ea3cdf4,
    0x3f9d471c, 0x3f5ec722, 0x3fd3eccf, 0x3fdb9f6d,
    0xbfa33b8b, 0xbfc53f79, 0xbf45e84a, 0xbfccc40b,
    0xc017faa1, 0x3fe02e79, 0xbfbe571f, 0x3dc7b5fd,
    0x3fa2fef6, 0xbe166749, 0xbd77d03e, 0x3f85fcc7,
    0x3f8b0c98, 0xbfac289b, 0x3f808a05, 0xbf32a523,
    0xbf6fc443, 0x40019a21, 0xbd482313, 0x3ef1055a,
    0x3f7da56b, 0x3f8f7a1a, 0x3f33c363, 0xbeaa9371,
    0xbe7a31b8, 0xc008e29d, 0xbea9454c, 0x3f00f365,
    0xbf32e6ef, 0xbf3a5ddd, 0xbfaf0db2, 0x3f1c5125,
    0xbea7533e, 0x3ec51afe, 0x3f7f07f6, 0x3f5d8863,
    0xbe86b93b, 0xbd22a846, 0x3fc49bff, 0xbeb72f9b,
    0xbf0999c1, 0x3f29f6b5, 0xbfd2f35a, 0x3fa702d4,
    0x3f4015a4, 0x3ebf019b, 0x3f59a5dd, 0xbffdbc0e,
    0x3f0fc239, 0x3df8d016, 0x3e676570, 0xbfa8a8e7,
    0xbec6a147, 0xbe284486, 0xbed2d37d, 0x3f1b6148,
    0xbf443837, 0xc00fa893, 0x3f978b7b, 0xbd100f0d,
    0x3e34d0a1, 0xbf4751d5, 0xc008e10a, 0xc028439e,
    0x3dd35cad, 0xbf8480b0, 0x3e671a47, 0x3fdd0450,
    0x3fb548c3, 0x43b2d25f, 0x3f6d711b, 0xbe1af60d,
    0xbe66323c, 0x3edf4c00, 0x3e23708d, 0x3e98fe1d,
    0xbe987dae, 0x3f76a3ab, 0x3ffaf982, 0x3f8d896b,
    0x3e815f15, 0x4000a837, 0x3fdabbf3, 0x3e479a6e,
    0x3f7c47aa, 0xbfbef21d, 0xc0015363, 0xbe29fa21,
    0xbfac3efd, 0xbe8c8c8c, 0x401070b2, 0x3f350dd9,
    0x3c2611bf, 0xbff37eb3, 0xbfc4a311, 0x3f4555de,
    0x3edc3b44, 0xbf98e77c, 0xbf0052b4, 0xbd9f5abd,
    0xbf15bc07, 0xbdfe1b8f, 0x3f90be8e, 0xbf52a43b,
    0x3f77623c, 0xbf8183c9, 0xbee0a92c, 0xbe40214f,
    0x3fa81c03, 0xbfc0623b, 0x3f38bf66, 0xbf99fe2c,
    0xbe2459f6, 0x3f8f110e, 0xbe8b7425, 0x3f518c73,
    0xbf006920, 0x3eddacc4, 0x3f27574d, 0xbf82f37b,
    0xc01bc8dc, 0xbf1cd509, 0x3f7332a5, 0xbdf7b7c6,
    0x3d1d6ae7, 0x3d72a3a3, 0x3fab4325, 0x3f906765,
    0x3f1249f6, 0x40090061, 0x3f7cb501, 0x3ee9f6e5,
    0xc054a9ac, 0x4020df2f, 0x3f63e00f, 0x3fc19f2f,
    0x3dc1433f, 0xbf12845e, 0xbfa67708, 0x3e99b22f,
    0x4009ad9e, 0xbfa3672a, 0xbfc273fa, 0xbed5230f,
    0xbf015c54, 0x3f9e1b99, 0x3ea11504, 0xbea38522,
    0xbe93351b, 0xbe86ad09, 0xbf52d4a4, 0x3f2221c7,
    0x3f52b8b3, 0xbfc55aff, 0x3e8298cf, 0xbfc070b8,
    0xbf4adb5d, 0x4040074a, 0x3ed8bd22, 0x3ef4e427,
    0x3ff94869, 0x3e9565ce, 0xc01a4817, 0x3fca1a65,
    0x4017ff26, 0x3f39ca30, 0x3f51f1e1, 0x3ef36aa0,
    0xbe903d0e, 0x3e3a5a5a, 0x3eb7ccd2, 0x3eb1fa94,
    0xbf89eb01, 0xbe562101, 0x3ea01cef, 0xbf48cec4,
    0x3f8ae42a, 0x3fd42e0f, 0xbfbaf500, 0x3e71a174,
    0x3f4218ee, 0xbf8314d9, 0x3f598cff, 0x3ea34e91,
    0xbf3e61ab, 0xbf94946e, 0xbf8c4ec0, 0x3fd8ff1b,
    0xbf4b551e, 0xbf327d0f, 0x3c6245f8, 0xbf977d7c,
    0x3f309185, 0x3fadb4c4, 0xbf7ee2ed, 0x3fed59a6,
    0x3e047114, 0xbf23212a, 0xbfb38a8e, 0xbf5f9729,
    0xbf3e1342, 0x3d248e4f, 0xbf003f94, 0xc0415b75,
    0x3fe1ab65, 0xbf90ead8, 0x3ec62ad8, 0x3f435dba,
    0x3ea6708b, 0x3fa4fa1c, 0x3e7bb841, 0x3e46ee99,
    0xbfd035ae, 0x3f6195bf, 0x3f592ad0, 0x3fb00d70,
    0x4001968a, 0xbf23907e, 0x3ff46832, 0xbe7307cd,
    0x3f427278, 0xbf651c81, 0xbcdfc60c, 0x3f760088,
    0xbf438a3f, 0x3fd69c4d, 0xbfeb2100, 0x3f6c3c02,
    0x3f38f787, 0xbf7d234a, 0xbfb65d67, 0x3f66a61a,
    0xbea5edb8, 0xbf014f97, 0xbf56dec2, 0xbe7b7948,
    0x3fe0fc3c, 0xc012a75b, 0x3ed23e29, 0x3f09070e,
    0x3fd00f57, 0x3fa46179, 0xbf526d93, 0xbf198f97,
    0xbed21e6a, 0x3eda3555, 0x401d8cbc, 0xbfd32eb0,
    0xbf853572, 0x3f40a350, 0xbfc8853d, 0xbfa2565a,
    0xbf2e5216, 0x3f07ffda, 0x3ff6c262, 0x3f0947c4,
    0xbf3146c7, 0x3f2e9bd4, 0x3d973076, 0x3dcf2b10,
    0x3fc25967, 0x40366785, 0xbc70c2f4, 0x4002595f,
    0xbf5e3132, 0xbf9eb89e, 0x3fc35f11, 0xbfaca521,
    0xc0426153, 0xbf432d67, 0x3f42a44b, 0xbf8ad3f7,
    0xbfa14beb, 0x3fd0a564, 0x3f74e54a, 0xbea08da6,
    0xbf23aa79, 0x3dd474c7, 0x407e7741, 0x3ec9ccd2,
    0x3fb21f3c, 0x4050ccf8, 0x3e2e60a1, 0x3ef396da,
    0x3eded676, 0xbe7c7eea, 0x3d87b748, 0xbf1e1a05,
    0xbf226a8f, 0xc023fbe3, 0xbf4aaaf2, 0xbe4c9f63,
    0xbda404ee, 0xbfa429b1, 0x3eb295d0, 0xbeb53917,
    0x3fc7e1de, 0x3e6f9050, 0xbefea450, 0x3c9b8a91,
    0x3f899827, 0x3ff6d6c2, 0x3f284cf9, 0x3ef56e21,
    0xbf5f302b, 0x3dc174a9, 0xbfcb4827, 0xbf3ed09f,
    0xbf85954c, 0x3fb7e93f, 0xbecaef98, 0xbf13dda3,
    0x3ff196b8, 0xbf109b07, 0x3de33a19, 0xbf2a0622,
    0x3f43b843, 0x3eaa9f76, 0xbf261a1c, 0xbd33d3ce,
    0xbf80b4e5, 0xbf562b2f, 0x3fd3a59e, 0x3ee9c92e
    };

static const uint32_t in_cfft_noisy_2048[4096] = {
    0x3c949e1e, 0x0, 0x3efb0204, 0x0,
    0x3f388ffd, 0x0, 0x3ee152bb, 0x0,
    0x3cd0aa1e, 0x0, 0xbed4f40e, 0x0,
    0xbf31f573, 0x0, 0xbef221a1, 0x0,
    0x3d6e533b, 0x0, 0x3f012d91, 0x0,
    0x3f2f527a, 0x0, 0x3eed9864, 0x0,
    0xbc472d25, 0x0, 0xbf08ec3f, 0x0,
    0xbf3b4a37, 0x0, 0xbee49aa1, 0x0,
    0xb98f0a0e, 0x0, 0x3ef4cd9f, 0x0,
    0x3f2a8d95, 0x0, 0x3f043728, 0x0,
    0xbd47e60c, 0x0, 0xbecd1660, 0x0,
    0xbf265044, 0x0, 0xbf07565c, 0x0,
    0xbc9a2dd7, 0x0, 0x3f036c53, 0x0,
    0x3f2be7bd, 0x0, 0x3f0fa024, 0x0,
    0x3b145737, 0x0, 0xbf096938, 0x0,
    0xbf304d2d, 0x0, 0xbf1639a7, 0x0,
    0x3c82d7b9, 0x0, 0x3f001f5e, 0x0,
    0x3f33ab4a, 0x0, 0x3efc5405, 0x0,
    0x3dbeefe5, 0x0, 0xbf01379d, 0x0,
    0xbf3bda8d, 0x0, 0xbf051287, 0x0,
    0xbd3aacfa, 0x0, 0x3f03644c, 0x0,
    0x3f21fdf6, 0x0, 0x3f070c62, 0x0,
    0xbd5376eb, 0x0, 0xbef3c662, 0x0,
    0xbf355df7, 0x0, 0xbee02800, 0x0,
    0x3c8914a8, 0x0, 0x3f1b9651, 0x0,
    0x3f3f2170, 0x0, 0x3ede804e, 0x0,
    0x3cf64ead, 0x0, 0xbf050182, 0x0,
    0xbf3b1cc1, 0x0, 0xbefce303, 0x0,
    0xbdb94bd5, 0x0, 0x3f074a90, 0x0,
    0x3f26734e, 0x0, 0x3f19c884, 0x0,
    0x3db9e266, 0x0, 0xbefd3f22, 0x0,
    0xbf336e17, 0x0, 0xbed54301, 0x0,
    0xbc292851, 0x0, 0x3f06ef40, 0x0,
    0x3f286382, 0x0, 0x3f0e0c54, 0x0,
    0xbd5eb596, 0x0, 0xbedfae5e, 0x0,
    0xbf25687a, 0x0, 0xbf14ac34, 0x0,
    0x3d352d0c, 0x0, 0x3ed56222, 0x0,
    0x3f340912, 0x0, 0x3ee3c80e, 0x0,
    0xbe055b03, 0x0, 0xbef79d07, 0x0,
    0xbf377ad0, 0x0, 0xbeede0bf, 0x0,
    0xbcee7f2b, 0x0, 0x3ee73ceb, 0x0,
    0x3f33dd45, 0x0, 0x3ecc03cd, 0x0,
    0x3d65bd02, 0x0, 0xbef29eed, 0x0,
    0xbf26e47e, 0x0, 0xbef23ee0, 0x0,
    0x3d15f1c5, 0x0, 0x3ef5d7ac, 0x0,
    0x3f3dd7bb, 0x0, 0x3f027166, 0x0,
    0x3dabe78c, 0x0, 0xbf0f89e0, 0x0,
    0xbf2a71d7, 0x0, 0xbef9da42, 0x0,
    0x3c2163ce, 0x0, 0x3eedfa4d, 0x0,
    0x3f3fbbfd, 0x0, 0x3ec2d431, 0x0,
    0xbd2318fb, 0x0, 0xbef99c78, 0x0,
    0xbf2fdcd5, 0x0, 0xbf104a34, 0x0,
    0x3da65a87, 0x0, 0x3f06496e, 0x0,
    0x3f2472ea, 0x0, 0x3f09f6a9, 0x0,
    0x3d11da3d, 0x0, 0xbeebd66e, 0x0,
    0xbf35550e, 0x0, 0xbee3931f, 0x0,
    0xbc4e0516, 0x0, 0x3f0c7e55, 0x0,
    0x3f321883, 0x0, 0x3f16def9, 0x0,
    0x3c7d9578, 0x0, 0xbef1d0f9, 0x0,
    0xbf41dac0, 0x0, 0xbeeefa38, 0x0,
    0xbc9b405c, 0x0, 0x3eefd82f, 0x0,
    0x3f4c2b9c, 0x0, 0x3efe2bb2, 0x0,
    0x3a15bdcf, 0x0, 0xbf06d904, 0x0,
    0xbf390593, 0x0, 0xbefea4ee, 0x0,
    0xbc29cea3, 0x0, 0x3eedc74c, 0x0,
    0x3f2b2bd7, 0x0, 0x3f0e5e09, 0x0,
    0x3cb09f4e, 0x0, 0xbee69b3d, 0x0,
    0xbf4082a4, 0x0, 0xbef0a91b, 0x0,
    0xbe28232c, 0x0, 0x3ef5faca, 0x0,
    0x3f423f71, 0x0, 0x3f03c978, 0x0,
    0x3d33d1d8, 0x0, 0xbf19138e, 0x0,
    0xbf3fb458, 0x0, 0xbf1032de, 0x0,
    0xbd1d7237, 0x0, 0x3ecaefa3, 0x0,
    0x3f24c1e4, 0x0, 0x3f08606c, 0x0,
    0x3cc7f6f8, 0x0, 0xbf0b9206, 0x0,
    0xbf2c3aa6, 0x0, 0xbee79dd3, 0x0,
    0xbba12e01, 0x0, 0x3f1043f3, 0x0,
    0x3f30da63, 0x0, 0x3f075dec, 0x0,
    0xbd14b62d, 0x0, 0xbee16a10, 0x0,
    0xbf3491d7, 0x0, 0xbf0801eb, 0x0,
    0xbce37d76, 0x0, 0x3ec17eb6, 0x0,
    0x3f28fd47, 0x0, 0x3ed7f980, 0x0,
    0x3da2488b, 0x0, 0xbee8b67e, 0x0,
    0xbf1f90fd, 0x0, 0xbf1082e5, 0x0,
    0xbd903c97, 0x0, 0x3ef70c07, 0x0,
    0x3f2bfb2e, 0x0, 0x3eeb5a0f, 0x0,
    0xbcd366c2, 0x0, 0xbf124e7b, 0x0,
    0xbf27290a, 0x0, 0xbefede7a, 0x0,
    0xbc8426c3, 0x0, 0x3ed71e7d, 0x0,
    0x3f32dce8, 0x0, 0x3ee6e2d5, 0x0,
    0x3df65e94, 0x0, 0xbf02ce6c, 0x0,
    0xbf2d04f1, 0x0, 0xbef95da1, 0x0,
    0xbc2e564d, 0x0, 0x3ef07d18, 0x0,
    0x3f316db6, 0x0, 0x3f0b7580, 0x0,
    0xbb9c5e8f, 0x0, 0xbf0c41de, 0x0,
    0xbf14f2f0, 0x0, 0xbf0ced88, 0x0,
    0xbd575b43, 0x0, 0x3f0fcfe5, 0x0,
    0x3f1eeb28, 0x0, 0x3f025a4b, 0x0,
    0xbc01a7de, 0x0, 0xbefdf4ea, 0x0,
    0xbf1e3502, 0x0, 0xbf121fad, 0x0,
    0xbd58664a, 0x0, 0x3f0a80b3, 0x0,
    0x3f30a0ae, 0x0, 0x3eec2780, 0x0,
    0x3ddffdcd, 0x0, 0xbf036fcb, 0x0,
    0xbf319d7f, 0x0, 0xbf043ad5, 0x0,
    0xbcc26e06, 0x0, 0x3ecc375d, 0x0,
    0x3f2cf449, 0x0, 0x3ee667dd, 0x0,
    0x3d481048, 0x0, 0xbf07f42f, 0x0,
    0xbf44144c, 0x0, 0xbee1b46f, 0x0,
    0xbc718c5e, 0x0, 0x3ec6f106, 0x0,
    0x3f3a9da5, 0x0, 0x3f13e484, 0x0,
    0xbc188f25, 0x0, 0xbeef21ca, 0x0,
    0xbf39efa0, 0x0, 0xbf0fb79b, 0x0,
    0xbdb6859f, 0x0, 0x3ef47846, 0x0,
    0x3f2c0c61, 0x0, 0x3f02fdfb, 0x0,
    0x3c87cf39, 0x0, 0xbeecf10b, 0x0,
    0xbf2333f0, 0x0, 0xbed92df1, 0x0,
    0x3d389337, 0x0, 0x3ed93a33, 0x0,
    0x3f19777d, 0x0, 0x3f147f39, 0x0,
    0x3d52b60c, 0x0, 0xbef33752, 0x0,
    0xbf2faae7, 0x0, 0xbefb670e, 0x0,
    0x3c284003, 0x0, 0x3ee7136b, 0x0,
    0x3f26bf15, 0x0, 0x3f07dda5, 0x0,
    0xbb20d947, 0x0, 0xbef547b8, 0x0,
    0xbf3c6db9, 0x0, 0xbf14279d, 0x0,
    0xbd51b14a, 0x0, 0x3ebb1e52, 0x0,
    0x3f2920b4, 0x0, 0x3f06ff8f, 0x0,
    0xbbee320e, 0x0, 0xbf029503, 0x0,
    0xbf40776f, 0x0, 0xbee6d8ba, 0x0,
    0xbd1f0781, 0x0, 0x3eeaf66d, 0x0,
    0x3f243bdd, 0x0, 0x3f0dd287, 0x0,
    0xbd2928e9, 0x0, 0xbf114b4a, 0x0,
    0xbf3e21b4, 0x0, 0xbf01ec66, 0x0,
    0xbc7e34ff, 0x0, 0x3ee90274, 0x0,
    0x3f1843d5, 0x0, 0x3f091006, 0x0,
    0x3d004078, 0x0, 0xbef2c438, 0x0,
    0xbf3f4bdc, 0x0, 0xbf0cf488, 0x0,
    0x3cec336c, 0x0, 0x3ef39377, 0x0,
    0x3f2934d8, 0x0, 0x3ee11fd5, 0x0,
    0xbd91c692, 0x0, 0xbf001a78, 0x0,
    0xbf4cbe69, 0x0, 0xbee08b66, 0x0,
    0x3c694d25, 0x0, 0x3efaa92d, 0x0,
    0x3f40fcd5, 0x0, 0x3f1b373d, 0x0,
    0xbd26e135, 0x0, 0xbeeaf056, 0x0,
    0xbf395339, 0x0, 0xbee5eb4d, 0x0,
    0x3d438b0e, 0x0, 0x3ef9b729, 0x0,
    0x3f42a5bc, 0x0, 0x3f04f645, 0x0,
    0xbccdd631, 0x0, 0xbefa293c, 0x0,
    0xbf3ced2e, 0x0, 0xbf25c994, 0x0,
    0xb9c76f32, 0x0, 0x3f0f5223, 0x0,
    0x3f17b224, 0x0, 0x3eee7359, 0x0,
    0x3d950b91, 0x0, 0xbf01b50e, 0x0,
    0xbf349759, 0x0, 0xbeff3d42, 0x0,
    0x3d22b954, 0x0, 0x3f12b3eb, 0x0,
    0x3f3379e7, 0x0, 0x3f0dd809, 0x0,
    0xbcde2027, 0x0, 0xbedf46d9, 0x0,
    0xbf25017e, 0x0, 0xbf0d46e4, 0x0,
    0x3c94e296, 0x0, 0x3f05c0ec, 0x0,
    0x3f40b3b0, 0x0, 0x3ef48239, 0x0,
    0x3d906381, 0x0, 0xbeeaf860, 0x0,
    0xbf252a43, 0x0, 0xbef99160, 0x0,
    0xbbb05e54, 0x0, 0x3efcd314, 0x0,
    0x3f33e844, 0x0, 0x3ee035e0, 0x0,
    0x3a2b5c13, 0x0, 0xbf0710cb, 0x0,
    0xbf38db34, 0x0, 0xbee55f68, 0x0,
    0xbc950d85, 0x0, 0x3f1ed27a, 0x0,
    0x3f24b58b, 0x0, 0x3f0636e3, 0x0,
    0xbcbcdf06, 0x0, 0xbef4ce01, 0x0,
    0xbf3b11b3, 0x0, 0xbf0e0b89, 0x0,
    0x3bf65fb4, 0x0, 0x3ef45262, 0x0,
    0x3f287d70, 0x0, 0x3ef1c198, 0x0,
    0xbda8c1df, 0x0, 0xbf19a362, 0x0,
    0xbf31234b, 0x0, 0xbf0bcd06, 0x0,
    0x3cc49ffb, 0x0, 0x3ec543c5, 0x0,
    0x3f3eed05, 0x0, 0x3f08f39d, 0x0,
    0xbbcdcab2, 0x0, 0xbeec5799, 0x0,
    0xbf3d1548, 0x0, 0xbef816a2, 0x0,
    0x3d2b05d9, 0x0, 0x3ef1f001, 0x0,
    0x3f4b75b1, 0x0, 0x3eeb5c7e, 0x0,
    0x3d5ec567, 0x0, 0xbef0bdd7, 0x0,
    0xbf21c333, 0x0, 0xbf08b7a4, 0x0,
    0xbd740ab6, 0x0, 0x3f0fc809, 0x0,
    0x3f35bf39, 0x0, 0x3efa7ad7, 0x0,
    0xbcd9adb8, 0x0, 0xbf0caebb, 0x0,
    0xbf37c126, 0x0, 0xbec2abbd, 0x0,
    0xbdef6bd8, 0x0, 0x3eccbe48, 0x0,
    0x3f557145, 0x0, 0x3f0db6fe, 0x0,
    0x3d816c68, 0x0, 0xbf027eb0, 0x0,
    0xbf2dba73, 0x0, 0xbf0cb20e, 0x0,
    0x3d897820, 0x0, 0x3ee9350a, 0x0,
    0x3f378407, 0x0, 0x3ee8e3de, 0x0,
    0xbda9875d, 0x0, 0xbeecbc50, 0x0,
    0xbf3a21ce, 0x0, 0xbf022f43, 0x0,
    0xbc49a829, 0x0, 0x3eb14ee2, 0x0,
    0x3f3748d8, 0x0, 0x3edde845, 0x0,
    0x3dda1aa6, 0x0, 0xbf05580d, 0x0,
    0xbf2b2209, 0x0, 0xbf18ae28, 0x0,
    0x3d61b02c, 0x0, 0x3f02893c, 0x0,
    0x3f2bc6fd, 0x0, 0x3ee68dfa, 0x0,
    0x3c48614f, 0x0, 0xbf153de7, 0x0,
    0xbf42472a, 0x0, 0xbeda863e, 0x0,
    0x3d0ba96a, 0x0, 0x3ef938ba, 0x0,
    0x3f2b5e57, 0x0, 0x3f00b7c9, 0x0,
    0x3d277c3c, 0x0, 0xbf0037e1, 0x0,
    0xbf24f2a2, 0x0, 0xbf03a0d4, 0x0,
    0x3ded65f2, 0x0, 0x3f0495da, 0x0,
    0x3f372d31, 0x0, 0x3f041189, 0x0,
    0x3d6de628, 0x0, 0xbef06eed, 0x0,
    0xbf3ab989, 0x0, 0xbf0e045a, 0x0,
    0x3b22561d, 0x0, 0x3f0a803a, 0x0,
    0x3f3235a4, 0x0, 0x3ee1bcec, 0x0,
    0x3c0444dc, 0x0, 0xbf0d0125, 0x0,
    0xbf30f29f, 0x0, 0xbf0093c6, 0x0,
    0xbbd182a3, 0x0, 0x3ef1a64c, 0x0,
    0x3f3d4460, 0x0, 0x3f05d2ae, 0x0,
    0xbdd9cf99, 0x0, 0xbefcb535, 0x0,
    0xbf29d87d, 0x0, 0xbefdfde1, 0x0,
    0x3d3e6f48, 0x0, 0x3ef92bff, 0x0,
    0x3f3b301a, 0x0, 0x3ee4cfc9, 0x0,
    0x3c6ca47f, 0x0, 0xbf0f8875, 0x0,
    0xbf207b9b, 0x0, 0xbf0a522e, 0x0,
    0x3ca366e0, 0x0, 0x3ed85b79, 0x0,
    0x3f1cec18, 0x0, 0x3edc78e5, 0x0,
    0x3c74865f, 0x0, 0xbf0dd369, 0x0,
    0xbf3bef9c, 0x0, 0xbf115f26, 0x0,
    0x3d439456, 0x0, 0x3f0baa1b, 0x0,
    0x3f2cecaa, 0x0, 0x3ee3b088, 0x0,
    0x3bcd595c, 0x0, 0xbed34299, 0x0,
    0xbf36e626, 0x0, 0xbf06997a, 0x0,
    0xbb5d9e99, 0x0, 0x3ee39bb8, 0x0,
    0x3f310006, 0x0, 0x3ee353d4, 0x0,
    0xbd8d8e32, 0x0, 0xbf159e63, 0x0,
    0xbf32b634, 0x0, 0xbedb3f14, 0x0,
    0xbd447c70, 0x0, 0x3ebf9a3a, 0x0,
    0x3f2c04eb, 0x0, 0x3ede36ed, 0x0,
    0x3d512976, 0x0, 0xbef9ff0d, 0x0,
    0xbf2b6826, 0x0, 0xbefa916e, 0x0,
    0x3d1d6139, 0x0, 0x3ef88a15, 0x0,
    0x3f306da7, 0x0, 0x3f08a2e8, 0x0,
    0x3d75c59b, 0x0, 0xbf049990, 0x0,
    0xbf4d6712, 0x0, 0xbed6723b, 0x0,
    0x3d6248b9, 0x0, 0x3edc29bb, 0x0,
    0x3f22c4ce, 0x0, 0x3f052878, 0x0,
    0xbd651590, 0x0, 0xbee69093, 0x0,
    0xbf3478cf, 0x0, 0xbf08f5c4, 0x0,
    0xbc098a05, 0x0, 0x3ef07fa3, 0x0,
    0x3f26ac70, 0x0, 0x3f06c80c, 0x0,
    0xbbbe31d8, 0x0, 0xbef7c41f, 0x0,
    0xbf301ece, 0x0, 0xbeec3d76, 0x0,
    0xbcb5e0c6, 0x0, 0x3f170bf2, 0x0,
    0x3f2b46da, 0x0, 0x3eddf7e6, 0x0,
    0x3dd1c426, 0x0, 0xbef7680c, 0x0,
    0xbf3a629e, 0x0, 0xbefea34a, 0x0,
    0x3d2c81f8, 0x0, 0x3f0d15a6, 0x0,
    0x3f317028, 0x0, 0x3f0fc608, 0x0,
    0x3d3dc515, 0x0, 0xbee163dd, 0x0,
    0xbf31e33d, 0x0, 0xbee468fc, 0x0,
    0xbcd39dec, 0x0, 0x3f0d42d2, 0x0,
    0x3f0deebc, 0x0, 0x3eebdc78, 0x0,
    0xbd40fd0e, 0x0, 0xbf11314f, 0x0,
    0xbf396f24, 0x0, 0xbf0ec7c8, 0x0,
    0xbd546cfa, 0x0, 0x3edfe8f0, 0x0,
    0x3f3bd376, 0x0, 0x3ee8f4a5, 0x0,
    0xbd99d944, 0x0, 0xbf0121db, 0x0,
    0xbf2aea8e, 0x0, 0xbf03ad2b, 0x0,
    0xbd20d820, 0x0, 0x3f0e6981, 0x0,
    0x3f263f64, 0x0, 0x3ef4bff1, 0x0,
    0x3c3762f8, 0x0, 0xbebfc2c7, 0x0,
    0xbf30fffd, 0x0, 0xbefb441d, 0x0,
    0xbc2ca8a2, 0x0, 0x3ed7b19d, 0x0,
    0x3f40a0c6, 0x0, 0x3efcf56d, 0x0,
    0x3d0bd8d5, 0x0, 0xbf0d6784, 0x0,
    0xbf382677, 0x0, 0xbf0f63d9, 0x0,
    0xbcaa740a, 0x0, 0x3eefff58, 0x0,
    0x3f2067e8, 0x0, 0x3f0d840d, 0x0,
    0xbd58c958, 0x0, 0xbeb91fe1, 0x0,
    0xbf420d3e, 0x0, 0xbefac73c, 0x0,
    0xbcaed719, 0x0, 0x3ee0b5d0, 0x0,
    0x3f47c568, 0x0, 0x3f07e52a, 0x0,
    0xbcd588e4, 0x0, 0xbf0b1478, 0x0,
    0xbf3f5a1e, 0x0, 0xbef3d535, 0x0,
    0x3cc1a27b, 0x0, 0x3ee62c6b, 0x0,
    0x3f25b106, 0x0, 0x3ef287f6, 0x0,
    0xbd86ae5b, 0x0, 0xbf1d00d7, 0x0,
    0xbf2b61b6, 0x0, 0xbef105bd, 0x0,
    0xbcba84d8, 0x0, 0x3ef3a9e5, 0x0,
    0x3f20b10a, 0x0, 0x3eda32d4, 0x0,
    0x3bb55b90, 0x0, 0xbf1f9e5f, 0x0,
    0xbf238750, 0x0, 0xbf02d836, 0x0,
    0x3c3c1f63, 0x0, 0x3f06ea89, 0x0,
    0x3f33a82d, 0x0, 0x3ee8d5a5, 0x0,
    0xbc843fd5, 0x0, 0xbef344fa, 0x0,
    0xbf307e0e, 0x0, 0xbf0667f4, 0x0,
    0x3b420bc2, 0x0, 0x3ef92838, 0x0,
    0x3f326a80, 0x0, 0x3eddf133, 0x0,
    0xbd6012f3, 0x0, 0xbf0ebd53, 0x0,
    0xbf3819ca, 0x0, 0xbf0cd35a, 0x0,
    0xbcf343ba, 0x0, 0x3ef75f4d, 0x0,
    0x3f256f7c, 0x0, 0x3f0046fa, 0x0,
    0x3d9c442c, 0x0, 0xbf277469, 0x0,
    0xbf414be9, 0x0, 0xbef7abe3, 0x0,
    0xbd0ae865, 0x0, 0x3f1a3306, 0x0,
    0x3f506bb7, 0x0, 0x3ef799ae, 0x0,
    0xbc72c3c5, 0x0, 0xbee50297, 0x0,
    0xbf33e0e9, 0x0, 0xbec69773, 0x0,
    0x3d903e09, 0x0, 0x3f034c8d, 0x0,
    0x3f2d5a88, 0x0, 0x3efef2c1, 0x0,
    0x3c9abb08, 0x0, 0xbee41b45, 0x0,
    0xbf1e94ac, 0x0, 0xbf03a4f9, 0x0,
    0x3d8d6785, 0x0, 0x3f0596c4, 0x0,
    0x3f320b22, 0x0, 0x3f0d43be, 0x0,
    0xbbddcda5, 0x0, 0xbf137c3f, 0x0,
    0xbf37da7f, 0x0, 0xbf1012ff, 0x0,
    0x3d5a78a4, 0x0, 0x3f0572e3, 0x0,
    0x3f2d5a8f, 0x0, 0x3f09ae51, 0x0,
    0xbdee4185, 0x0, 0xbf0bba6d, 0x0,
    0xbf369306, 0x0, 0xbee3d4bf, 0x0,
    0x3d0ec501, 0x0, 0x3ef9e7d8, 0x0,
    0x3f35a50e, 0x0, 0x3ec382a0, 0x0,
    0x3cabde75, 0x0, 0xbee43e25, 0x0,
    0xbf367267, 0x0, 0xbf0aaa37, 0x0,
    0x3b3024a8, 0x0, 0x3f04f7c9, 0x0,
    0x3f2d6eb6, 0x0, 0x3ef3e077, 0x0,
    0xbc41370e, 0x0, 0xbf081aca, 0x0,
    0xbf3dd465, 0x0, 0xbec6b33d, 0x0,
    0xbc76900d, 0x0, 0x3ef694bc, 0x0,
    0x3f287ac0, 0x0, 0x3f142850, 0x0,
    0xbc4132d3, 0x0, 0xbef340dd, 0x0,
    0xbf4b3339, 0x0, 0xbedbd9b6, 0x0,
    0xbccb8171, 0x0, 0x3f016e4c, 0x0,
    0x3f29a086, 0x0, 0x3ed7eb90, 0x0,
    0xbdc6c984, 0x0, 0xbf046372, 0x0,
    0xbf38f81a, 0x0, 0xbedc33e0, 0x0,
    0xbd1620f3, 0x0, 0x3f08b13d, 0x0,
    0x3f1ecac5, 0x0, 0x3ee1d03c, 0x0,
    0x3c602c9a, 0x0, 0xbf025c8c, 0x0,
    0xbf40dc63, 0x0, 0xbedd2c96, 0x0,
    0xbca8542e, 0x0, 0x3f07cdfd, 0x0,
    0x3f2cc42e, 0x0, 0x3ef8d5bb, 0x0,
    0x3c0df347, 0x0, 0xbf045548, 0x0,
    0xbf28c9aa, 0x0, 0xbf078d2a, 0x0,
    0x3d365f7c, 0x0, 0x3eeab3d7, 0x0,
    0x3f14d22d, 0x0, 0x3ef85452, 0x0,
    0x3cc113bb, 0x0, 0xbefed8db, 0x0,
    0xbf412dbd, 0x0, 0xbf051244, 0x0,
    0xbd79f203, 0x0, 0x3ee48a0f, 0x0,
    0x3f34c5fb, 0x0, 0x3f0f8e99, 0x0,
    0xbcc614cd, 0x0, 0xbf0e0ec1, 0x0,
    0xbf3cd6d4, 0x0, 0xbef83f62, 0x0,
    0x3d9be286, 0x0, 0x3efa4256, 0x0,
    0x3f398445, 0x0, 0x3f003223, 0x0,
    0xbc8eaf4d, 0x0, 0xbef13056, 0x0,
    0xbf33cbe9, 0x0, 0xbecb0f1a, 0x0,
    0x3a8a5382, 0x0, 0x3f06785d, 0x0,
    0x3f25aee9, 0x0, 0x3ee4263e, 0x0,
    0xbddabe61, 0x0, 0xbf08fbc6, 0x0,
    0xbf40f598, 0x0, 0xbef70087, 0x0,
    0xbdc61359, 0x0, 0x3eef4043, 0x0,
    0x3f39d8ae, 0x0, 0x3f184084, 0x0,
    0xbc78d4f9, 0x0, 0xbefdc5e6, 0x0,
    0xbf32d2ae, 0x0, 0xbeeb5990, 0x0,
    0xbd3f9cc3, 0x0, 0x3ee03c42, 0x0,
    0x3f37d5cb, 0x0, 0x3f02113c, 0x0,
    0x3d338cf2, 0x0, 0xbee5ab6a, 0x0,
    0xbf3446b1, 0x0, 0xbf0fd8b4, 0x0,
    0x3c1cf23a, 0x0, 0x3ed6ade6, 0x0,
    0x3f2e31e2, 0x0, 0x3f0badfd, 0x0,
    0xbd7cacd7, 0x0, 0xbf078d5f, 0x0,
    0xbf29a57e, 0x0, 0xbf0a03f1, 0x0,
    0x3d157597, 0x0, 0x3f014b9b, 0x0,
    0x3f3eec48, 0x0, 0x3ef8d3f2, 0x0,
    0x3c1b7420, 0x0, 0xbf0a2f52, 0x0,
    0xbf3f9bb4, 0x0, 0xbef49a81, 0x0,
    0xbcdd4f3c, 0x0, 0x3f014bf6, 0x0,
    0x3f37915e, 0x0, 0x3f004bcb, 0x0,
    0xbcb485cc, 0x0, 0xbef344ad, 0x0,
    0xbf2ec320, 0x0, 0xbef94048, 0x0,
    0x3dbb962a, 0x0, 0x3f0a88b9, 0x0,
    0x3f3075aa, 0x0, 0x3efc76c7, 0x0,
    0xbc4b8797, 0x0, 0xbef72413, 0x0,
    0xbf219da9, 0x0, 0xbf04aa9a, 0x0,
    0x3cf4e47c, 0x0, 0x3eff2923, 0x0,
    0x3f3b507f, 0x0, 0x3f05112d, 0x0,
    0x3d2afe44, 0x0, 0xbf01d6a1, 0x0,
    0xbf4fa775, 0x0, 0xbeea0d12, 0x0,
    0x3da5bcbd, 0x0, 0x3edac0ea, 0x0,
    0x3f301af8, 0x0, 0x3efa1e44, 0x0,
    0xbbd3c824, 0x0, 0xbeef9d47, 0x0,
    0xbf288454, 0x0, 0xbf066575, 0x0,
    0xbc41c11b, 0x0, 0x3f070064, 0x0,
    0x3f2bf3c3, 0x0, 0x3efe0ffb, 0x0,
    0x3dab51d8, 0x0, 0xbefd516e, 0x0,
    0xbf2a9c1a, 0x0, 0xbef39ded, 0x0,
    0x3a81bf15, 0x0, 0x3f01eeb9, 0x0,
    0x3f2c9acb, 0x0, 0x3eca004a, 0x0,
    0xbd08d12c, 0x0, 0xbf088865, 0x0,
    0xbf41a625, 0x0, 0xbef40886, 0x0,
    0xbc50abe0, 0x0, 0x3f0ef368, 0x0,
    0x3f1a7b3c, 0x0, 0x3eff8d53, 0x0,
    0x3af92cab, 0x0, 0xbee300aa, 0x0,
    0xbf39fe5b, 0x0, 0xbf08f54e, 0x0,
    0x3d5b84d9, 0x0, 0x3ee57ef2, 0x0,
    0x3f2d52be, 0x0, 0x3ee7975d, 0x0,
    0xbd9ef1b0, 0x0, 0xbee0181c, 0x0,
    0xbf237951, 0x0, 0xbf036e3e, 0x0,
    0xbd22b89d, 0x0, 0x3ef419e9, 0x0,
    0x3f322030, 0x0, 0x3f19931e, 0x0,
    0x3d81aab3, 0x0, 0xbee6f540, 0x0,
    0xbf185fc0, 0x0, 0xbf10232a, 0x0,
    0xbd6f3f48, 0x0, 0x3ef3fc2d, 0x0,
    0x3f2d3f23, 0x0, 0x3ed98a1c, 0x0,
    0x3c3b31a4, 0x0, 0xbf05fc24, 0x0,
    0xbf2c2984, 0x0, 0xbefe1763, 0x0,
    0x3c17e138, 0x0, 0x3eff4878, 0x0,
    0x3f3dc8b6, 0x0, 0x3ee79548, 0x0,
    0xbccdc316, 0x0, 0xbef9d2ef, 0x0,
    0xbf3622e1, 0x0, 0xbf011b48, 0x0,
    0xbd601f6d, 0x0, 0x3f0661e7, 0x0,
    0x3f2de182, 0x0, 0x3ecd436b, 0x0,
    0x3d486391, 0x0, 0xbf041c5a, 0x0,
    0xbf38cac5, 0x0, 0xbf0ff642, 0x0,
    0xbdc14767, 0x0, 0x3f02d185, 0x0,
    0x3f246c66, 0x0, 0x3f00208d, 0x0,
    0x3d0d5049, 0x0, 0xbef81219, 0x0,
    0xbf38edb3, 0x0, 0xbef6a7c5, 0x0,
    0x3ce0d8cf, 0x0, 0x3f18938b, 0x0,
    0x3f32a272, 0x0, 0x3f0bf189, 0x0,
    0x3c3b4dba, 0x0, 0xbf0129fa, 0x0,
    0xbf302d58, 0x0, 0xbf06cf14, 0x0,
    0x3d08fc85, 0x0, 0x3efd7f2b, 0x0,
    0x3f41de15, 0x0, 0x3ee88c0c, 0x0,
    0x3cd059dc, 0x0, 0xbf00b87e, 0x0,
    0xbf4d71de, 0x0, 0xbf092917, 0x0,
    0x3defdea2, 0x0, 0x3ee9321d, 0x0,
    0x3f247215, 0x0, 0x3ed398f5, 0x0,
    0x3d81b372, 0x0, 0xbf05b4fa, 0x0,
    0xbf48f950, 0x0, 0xbef9c4a9, 0x0,
    0xbd303713, 0x0, 0x3eedbaef, 0x0,
    0x3f313911, 0x0, 0x3ee0ea3b, 0x0,
    0xbba4d0d4, 0x0, 0xbf145756, 0x0,
    0xbf3b672f, 0x0, 0xbf02a6ef, 0x0,
    0x3c4e9257, 0x0, 0x3efbdcec, 0x0,
    0x3f3b5fea, 0x0, 0x3ef3a3df, 0x0,
    0xbcdd4a7e, 0x0, 0xbf0c61b0, 0x0,
    0xbf25a689, 0x0, 0xbf0c6b9b, 0x0,
    0xbe032079, 0x0, 0x3f0afd13, 0x0,
    0x3f4aff7d, 0x0, 0x3eff723d, 0x0,
    0xbc61daac, 0x0, 0xbeddb337, 0x0,
    0xbf1cfd9a, 0x0, 0xbf04c3b8, 0x0,
    0x3da8d27a, 0x0, 0x3eef6207, 0x0,
    0x3f358625, 0x0, 0x3f0d0e96, 0x0,
    0x3d78878d, 0x0, 0xbef5020b, 0x0,
    0xbf4525d5, 0x0, 0xbee114cd, 0x0,
    0x3a6fcb8e, 0x0, 0x3f08682a, 0x0,
    0x3f404fee, 0x0, 0x3f0b2639, 0x0,
    0xbdaac312, 0x0, 0xbf0782b4, 0x0,
    0xbf348731, 0x0, 0xbf04a65d, 0x0,
    0xbd61ea56, 0x0, 0x3ee0c85e, 0x0,
    0x3f3f8128, 0x0, 0x3f041bc0, 0x0,
    0xbd0ae083, 0x0, 0xbf1d2213, 0x0,
    0xbf3e7ce1, 0x0, 0xbed6e6b9, 0x0,
    0xbd7373a6, 0x0, 0x3f04a374, 0x0,
    0x3f18ba19, 0x0, 0x3ee07c7e, 0x0,
    0xbc7486f4, 0x0, 0xbee95095, 0x0,
    0xbf52ced4, 0x0, 0xbee28703, 0x0,
    0xba9df6b8, 0x0, 0x3f02c15b, 0x0,
    0x3f1f120a, 0x0, 0x3ef73949, 0x0,
    0xbd8fcb07, 0x0, 0xbf0e8a96, 0x0,
    0xbf184049, 0x0, 0xbecf26e4, 0x0,
    0x3db76dec, 0x0, 0x3f024190, 0x0,
    0x3f3a7288, 0x0, 0x3f063932, 0x0,
    0xbbfee928, 0x0, 0xbee35dc3, 0x0,
    0xbf4ddd3d, 0x0, 0xbee3634f, 0x0,
    0xbd049637, 0x0, 0x3f15eaf8, 0x0,
    0x3f3be135, 0x0, 0x3f08d5fd, 0x0,
    0xbd88dec7, 0x0, 0xbf0e6f2b, 0x0,
    0xbf3b92d9, 0x0, 0xbef6ce86, 0x0,
    0x3e1237e9, 0x0, 0x3f02b54d, 0x0,
    0x3f2c62bd, 0x0, 0x3eeb1c9c, 0x0,
    0x3bfa3fd9, 0x0, 0xbecacc5e, 0x0,
    0xbf46adcf, 0x0, 0xbf07ed31, 0x0,
    0x3ca81254, 0x0, 0x3f0fbf22, 0x0,
    0x3f25811c, 0x0, 0x3ee35aec, 0x0,
    0xbce29e2b, 0x0, 0xbef00efd, 0x0,
    0xbf40e046, 0x0, 0xbeec2483, 0x0,
    0x3d94be0d, 0x0, 0x3f0e8783, 0x0,
    0x3f314156, 0x0, 0x3ed842fe, 0x0,
    0xbab20b70, 0x0, 0xbeef7e88, 0x0,
    0xbf2c4ac3, 0x0, 0xbef486fc, 0x0,
    0xbc83f3e1, 0x0, 0x3ec87a56, 0x0,
    0x3f2f1dad, 0x0, 0x3f0c8a95, 0x0,
    0xbb51d127, 0x0, 0xbf043f30, 0x0,
    0xbf2d9f0d, 0x0, 0xbf070f89, 0x0,
    0x3dd9f601, 0x0, 0x3f129ff6, 0x0,
    0x3f375572, 0x0, 0x3f08cb64, 0x0,
    0x3c33e038, 0x0, 0xbedbef0c, 0x0,
    0xbf2e203e, 0x0, 0xbed23d04, 0x0,
    0x3d646649, 0x0, 0x3f13d724, 0x0,
    0x3f3698a1, 0x0, 0x3edaa9fd, 0x0,
    0x3e094930, 0x0, 0xbf0b475b, 0x0,
    0xbf293aa6, 0x0, 0xbefd90bd, 0x0,
    0xbc9de9ee, 0x0, 0x3f04d90e, 0x0,
    0x3f3f8d03, 0x0, 0x3efb83c4, 0x0,
    0xbcce789b, 0x0, 0xbf026b32, 0x0,
    0xbf389186, 0x0, 0xbeefa31e, 0x0,
    0xbd2c8a3e, 0x0, 0x3ef769af, 0x0,
    0x3f385a1a, 0x0, 0x3ee92e0c, 0x0,
    0xbce9dc5b, 0x0, 0xbf034a1d, 0x0,
    0xbf2e4787, 0x0, 0xbef123ff, 0x0,
    0x3bf5204a, 0x0, 0x3ef4f750, 0x0,
    0x3f2f61de, 0x0, 0x3eedae2b, 0x0,
    0x3d254713, 0x0, 0xbeee2f0a, 0x0,
    0xbf34251f, 0x0, 0xbec73507, 0x0,
    0xbd8fbf4a, 0x0, 0x3f05d6cf, 0x0,
    0x3f2f33ed, 0x0, 0x3ef2b32f, 0x0,
    0xbdb9ed07, 0x0, 0xbee9592e, 0x0,
    0xbf39796a, 0x0, 0xbefeed9b, 0x0,
    0x3d6664c3, 0x0, 0x3edf9857, 0x0,
    0x3f30e485, 0x0, 0x3ee7c66d, 0x0,
    0x3a8850ac, 0x0, 0xbf016fa7, 0x0,
    0xbf473bee, 0x0, 0xbee7ee6a, 0x0,
    0xbcb16a39, 0x0, 0x3ee22652, 0x0,
    0x3f4a9fd7, 0x0, 0x3f079609, 0x0,
    0x3dab606e, 0x0, 0xbf06b8f1, 0x0,
    0xbf2f5179, 0x0, 0xbf05bef0, 0x0,
    0xbe0b55ee, 0x0, 0x3f007027, 0x0,
    0x3f206d9f, 0x0, 0x3ed66b6a, 0x0,
    0x3def817f, 0x0, 0xbf004e2b, 0x0,
    0xbf330be7, 0x0, 0xbee6bebe, 0x0,
    0xbce776d3, 0x0, 0x3efa604c, 0x0,
    0x3f38725b, 0x0, 0x3f02ff20, 0x0,
    0xbc91a627, 0x0, 0xbf0aa007, 0x0,
    0xbf2ca159, 0x0, 0xbee29b44, 0x0,
    0xbc700731, 0x0, 0x3f04dc3b, 0x0,
    0x3f1b4334, 0x0, 0x3f1ae4f9, 0x0,
    0xbdd07d74, 0x0, 0xbf0022ce, 0x0,
    0xbf2d3b42, 0x0, 0xbef9320b, 0x0,
    0x3de588fa, 0x0, 0x3ef3ffed, 0x0,
    0x3f47112b, 0x0, 0x3eeffcd1, 0x0,
    0xbd88d6b6, 0x0, 0xbef121bb, 0x0,
    0xbf33ce7d, 0x0, 0xbf0393db, 0x0,
    0xbcbcdc75, 0x0, 0x3f1442e1, 0x0,
    0x3f3cbab2, 0x0, 0x3f03e9e9, 0x0,
    0x3dc13fa7, 0x0, 0xbeeed8c8, 0x0,
    0xbf2ebefa, 0x0, 0xbef7b1d1, 0x0,
    0xbdbe4ec6, 0x0, 0x3f05bb33, 0x0,
    0x3f22b0fb, 0x0, 0x3ef630f5, 0x0,
    0xba54017b, 0x0, 0xbf038570, 0x0,
    0xbf260d06, 0x0, 0xbf097be9, 0x0,
    0xbca3d38e, 0x0, 0x3eff2bc4, 0x0,
    0x3f16d0c9, 0x0, 0x3edbf977, 0x0,
    0xbd2c55ae, 0x0, 0xbee96a46, 0x0,
    0xbf51c737, 0x0, 0xbf10e955, 0x0,
    0x3d9de68a, 0x0, 0x3f032c1b, 0x0,
    0x3f2a7bf2, 0x0, 0x3f007c41, 0x0,
    0x3cccb403, 0x0, 0xbedab082, 0x0,
    0xbf31c06c, 0x0, 0xbf06ace8, 0x0,
    0xbd34d816, 0x0, 0x3ee424a5, 0x0,
    0x3f2219f0, 0x0, 0x3ef8d6aa, 0x0,
    0xbd62d18b, 0x0, 0xbf0c4b59, 0x0,
    0xbf3c5a88, 0x0, 0xbef94b5f, 0x0,
    0xbc8a5f64, 0x0, 0x3ed90b6d, 0x0,
    0x3f3f41e7, 0x0, 0x3f146965, 0x0,
    0xbd2d2521, 0x0, 0xbf0283d1, 0x0,
    0xbf3802ef, 0x0, 0xbef262bb, 0x0,
    0xbc34b141, 0x0, 0x3f02f23b, 0x0,
    0x3f416e27, 0x0, 0x3f09d678, 0x0,
    0xbd18ad20, 0x0, 0xbf0336cb, 0x0,
    0xbf2ef5a1, 0x0, 0xbf05d95f, 0x0,
    0xbc3aba67, 0x0, 0x3eda79c8, 0x0,
    0x3f380443, 0x0, 0x3f0a39e6, 0x0,
    0xbd056eb7, 0x0, 0xbf0c807a, 0x0,
    0xbf1fb6f7, 0x0, 0xbef31f32, 0x0,
    0xbcc199f7, 0x0, 0x3efbe756, 0x0,
    0x3f32c29c, 0x0, 0x3efa98c5, 0x0,
    0xbd36be97, 0x0, 0xbf0d8aea, 0x0,
    0xbf346214, 0x0, 0xbeed5944, 0x0,
    0xbc9947d9, 0x0, 0x3ed7a4b9, 0x0,
    0x3f358e51, 0x0, 0x3f13c777, 0x0,
    0x3d7f6faa, 0x0, 0xbef5c43a, 0x0,
    0xbf346ada, 0x0, 0xbeec9dbc, 0x0,
    0x3d8f2242, 0x0, 0x3efdda37, 0x0,
    0x3f2ff8f8, 0x0, 0x3ef7c1a3, 0x0,
    0xbcac5340, 0x0, 0xbf114411, 0x0,
    0xbf366f70, 0x0, 0xbee5c6c7, 0x0,
    0xbd5db836, 0x0, 0x3f06614a, 0x0,
    0x3f3a7ff8, 0x0, 0x3eddba18, 0x0,
    0x3ce37db5, 0x0, 0xbee37007, 0x0,
    0xbf2b1236, 0x0, 0xbf0f1d96, 0x0,
    0xbc4e7c38, 0x0, 0x3f083b46, 0x0,
    0x3f4baa41, 0x0, 0x3f21fed8, 0x0,
    0xbcc56162, 0x0, 0xbf0845df, 0x0,
    0xbf3942a5, 0x0, 0xbf17bc8e, 0x0,
    0xbd08b113, 0x0, 0x3f170252, 0x0,
    0x3f291ae2, 0x0, 0x3f0fc01f, 0x0,
    0x3c769a5a, 0x0, 0xbee1025a, 0x0,
    0xbf31c94c, 0x0, 0xbf066e60, 0x0,
    0x3d36e06a, 0x0, 0x3ef27960, 0x0,
    0x3f356424, 0x0, 0x3ee9e2c0, 0x0,
    0x3d87737b, 0x0, 0xbf25942f, 0x0,
    0xbf2ba3b3, 0x0, 0xbee9b9b6, 0x0,
    0xbd99d126, 0x0, 0x3ed195ac, 0x0,
    0x3f24b0c7, 0x0, 0x3f17393d, 0x0,
    0x3cb64e61, 0x0, 0xbef47295, 0x0,
    0xbf2c8388, 0x0, 0xbeeb7f08, 0x0,
    0xbd11bfce, 0x0, 0x3f123360, 0x0,
    0x3f2c565c, 0x0, 0x3eecb158, 0x0,
    0xbd21c03f, 0x0, 0xbf112765, 0x0,
    0xbf2e3e0b, 0x0, 0xbef07297, 0x0,
    0xbcdabcc8, 0x0, 0x3ee7f90d, 0x0,
    0x3f4c7dd8, 0x0, 0x3f097855, 0x0,
    0xbce1a49e, 0x0, 0xbf0f47a2, 0x0,
    0xbf48adce, 0x0, 0xbefa6509, 0x0,
    0xbcff0253, 0x0, 0x3eef6c76, 0x0,
    0x3f3c3a61, 0x0, 0x3f05aac1, 0x0,
    0x3a5ac367, 0x0, 0xbef21000, 0x0,
    0xbf37a119, 0x0, 0xbf03efe0, 0x0,
    0x3da98afe, 0x0, 0x3f071f6c, 0x0,
    0x3f19b8bc, 0x0, 0x3eec9adf, 0x0,
    0x3c107ce1, 0x0, 0xbf03934f, 0x0,
    0xbf2a970b, 0x0, 0xbf0b84b0, 0x0,
    0xbb8846c4, 0x0, 0x3efba350, 0x0,
    0x3f3f5e6d, 0x0, 0x3f006484, 0x0,
    0xbdaea0d6, 0x0, 0xbf03b9d7, 0x0,
    0xbf31ee2b, 0x0, 0xbef61f1c, 0x0,
    0x3daf51c2, 0x0, 0x3efc8357, 0x0,
    0x3f423f1c, 0x0, 0x3f12bc47, 0x0,
    0x3cfc6739, 0x0, 0xbeed33f8, 0x0,
    0xbf327e4a, 0x0, 0xbec66e1d, 0x0,
    0x3ba3012e, 0x0, 0x3f0f3b86, 0x0,
    0x3f35fb42, 0x0, 0x3ef8f14f, 0x0,
    0x3caeacce, 0x0, 0xbed50ff5, 0x0,
    0xbf37995b, 0x0, 0xbedbe335, 0x0,
    0x3d3f6080, 0x0, 0x3f088bcb, 0x0,
    0x3f342ad4, 0x0, 0x3edf377d, 0x0,
    0xbd627b09, 0x0, 0xbf067668, 0x0,
    0xbf3d9077, 0x0, 0xbf0e0fad, 0x0,
    0xbd586e64, 0x0, 0x3f09fc5d, 0x0,
    0x3f2a02d9, 0x0, 0x3f0baf2b, 0x0,
    0x3d00db58, 0x0, 0xbef1f10d, 0x0,
    0xbf1f16b4, 0x0, 0xbedd7189, 0x0,
    0x3c88b3ea, 0x0, 0x3efbfdf9, 0x0,
    0x3f324d0e, 0x0, 0x3edb9617, 0x0,
    0x3d7a4904, 0x0, 0xbf054a87, 0x0,
    0xbf412937, 0x0, 0xbf005005, 0x0,
    0xbce89dd4, 0x0, 0x3ef746c7, 0x0,
    0x3f356b82, 0x0, 0x3f0bbfa9, 0x0,
    0x3c9d4f46, 0x0, 0xbf0409e1, 0x0,
    0xbf367daf, 0x0, 0xbee53d65, 0x0,
    0xbd421871, 0x0, 0x3ef65e9c, 0x0,
    0x3f13202a, 0x0, 0x3f023066, 0x0,
    0xbd5c0055, 0x0, 0xbefdd7ad, 0x0,
    0xbf2ded1c, 0x0, 0xbf095672, 0x0,
    0x3d772263, 0x0, 0x3ef012dd, 0x0,
    0x3f46ef8f, 0x0, 0x3f000ed1, 0x0,
    0xbd5057b5, 0x0, 0xbedd3780, 0x0,
    0xbf3b02fd, 0x0, 0xbee7d7eb, 0x0,
    0xbd25a9a2, 0x0, 0x3eef3366, 0x0,
    0x3f49ae61, 0x0, 0x3ee816bb, 0x0,
    0x3cbd5f85, 0x0, 0xbf0e3e4b, 0x0,
    0xbf39c589, 0x0, 0xbee77975, 0x0,
    0xbc838266, 0x0, 0x3edd4368, 0x0,
    0x3f340842, 0x0, 0x3f0323b0, 0x0,
    0xbd8aa837, 0x0, 0xbf010474, 0x0,
    0xbf3dd7ad, 0x0, 0xbf10dd68, 0x0,
    0x3cbb78cc, 0x0, 0x3ef89bab, 0x0,
    0x3f384b41, 0x0, 0x3f0c0c0f, 0x0,
    0xbb61c8b5, 0x0, 0xbeed3136, 0x0,
    0xbf29ea35, 0x0, 0xbef6e8c5, 0x0,
    0x3ab8a456, 0x0, 0x3edc4a43, 0x0,
    0x3f3dd371, 0x0, 0x3ee7e8ad, 0x0,
    0x3d095ba3, 0x0, 0xbefa1c64, 0x0,
    0xbf2d20e1, 0x0, 0xbf09a09a, 0x0,
    0xbd77bbfd, 0x0, 0x3f00fc45, 0x0,
    0x3f327ccb, 0x0, 0x3eeb6129, 0x0,
    0x3de98566, 0x0, 0xbee8ed6f, 0x0,
    0xbf2d3c20, 0x0, 0xbee0e555, 0x0,
    0xbc35cfb7, 0x0, 0x3f08d089, 0x0,
    0x3f31691d, 0x0, 0x3eeb5b17, 0x0,
    0x3d226683, 0x0, 0xbf10fa8d, 0x0,
    0xbf42cd44, 0x0, 0xbf0c3f62, 0x0,
    0xbd621dc5, 0x0, 0x3ee28145, 0x0,
    0x3f482bdf, 0x0, 0x3f0457d1, 0x0,
    0xbd0d457a, 0x0, 0xbee56f09, 0x0,
    0xbf2fd695, 0x0, 0xbf08e44a, 0x0,
    0xbc861f85, 0x0, 0x3f0cf294, 0x0,
    0x3f540f94, 0x0, 0x3ef1ede5, 0x0,
    0xbd045257, 0x0, 0xbef125c8, 0x0,
    0xbf18cb93, 0x0, 0xbeea6b1e, 0x0,
    0xb8bfc803, 0x0, 0x3f03cc2d, 0x0,
    0x3f356a69, 0x0, 0x3f05baab, 0x0,
    0x3cc2fc5f, 0x0, 0xbf0afbf0, 0x0,
    0xbf378b4e, 0x0, 0xbee68eba, 0x0,
    0xbd8a08c0, 0x0, 0x3f038e62, 0x0,
    0x3f328d0a, 0x0, 0x3f0ed093, 0x0,
    0xbdb5f8c2, 0x0, 0xbf01e1fb, 0x0,
    0xbf2f8aa8, 0x0, 0xbef4109b, 0x0,
    0xbc67b335, 0x0, 0x3eed62fe, 0x0,
    0x3f50d864, 0x0, 0x3efc5d86, 0x0,
    0x3dd01ed2, 0x0, 0xbf07e778, 0x0,
    0xbf26519e, 0x0, 0xbee9fde9, 0x0,
    0xbd2406fb, 0x0, 0x3ef28924, 0x0,
    0x3f33b575, 0x0, 0x3ee277c5, 0x0,
    0x3c9a403b, 0x0, 0xbedabf9b, 0x0,
    0xbf3d4861, 0x0, 0xbeeed47d, 0x0,
    0xbd37fb88, 0x0, 0x3ef88be9, 0x0,
    0x3f311c1f, 0x0, 0x3f01d5b3, 0x0,
    0xbcbe9a36, 0x0, 0xbf00a6ae, 0x0,
    0xbf37b2be, 0x0, 0xbf066218, 0x0,
    0xbc0ec9b3, 0x0, 0x3efe79f6, 0x0,
    0x3f37e464, 0x0, 0x3ef31bc6, 0x0,
    0xbd6e58a0, 0x0, 0xbf0ddde4, 0x0,
    0xbf344967, 0x0, 0xbf11ca09, 0x0,
    0x3d48604e, 0x0, 0x3f05e3eb, 0x0,
    0x3f3384f5, 0x0, 0x3f0c2f9d, 0x0,
    0xbc3208bf, 0x0, 0xbee65baf, 0x0,
    0xbf3b142a, 0x0, 0xbf011cae, 0x0,
    0xbd2a7f37, 0x0, 0x3eea4b94, 0x0,
    0x3f29234b, 0x0, 0x3ee1b131, 0x0,
    0x3df7242b, 0x0, 0xbef7dbd0, 0x0,
    0xbf42adf6, 0x0, 0xbee11e55, 0x0,
    0x3d4ecd72, 0x0, 0x3ef2804a, 0x0,
    0x3f306e8a, 0x0, 0x3f02274a, 0x0,
    0xbc02e332, 0x0, 0xbf0e04f8, 0x0,
    0xbf44ec67, 0x0, 0xbf03969b, 0x0,
    0x3d57d242, 0x0, 0x3ef41949, 0x0,
    0x3f463962, 0x0, 0x3f10acdf, 0x0,
    0x3d232fdb, 0x0, 0xbf089901, 0x0,
    0xbf4834d0, 0x0, 0xbf207f59, 0x0,
    0x3c6eda82, 0x0, 0x3eeb007a, 0x0,
    0x3f3d9406, 0x0, 0x3f00723e, 0x0,
    0xbce567e9, 0x0, 0xbf197082, 0x0,
    0xbf1c6add, 0x0, 0xbf035a22, 0x0,
    0x3c2c117a, 0x0, 0x3f0812af, 0x0,
    0x3f26809a, 0x0, 0x3f05e777, 0x0,
    0x3c7d0d4f, 0x0, 0xbed82c2c, 0x0,
    0xbf2cb601, 0x0, 0xbf15ef30, 0x0,
    0xbb29b540, 0x0, 0x3f063919, 0x0,
    0x3f321df7, 0x0, 0x3f1b069e, 0x0,
    0x3c804ed0, 0x0, 0xbecabfe2, 0x0,
    0xbf357262, 0x0, 0xbf059a90, 0x0,
    0xba2ce3a3, 0x0, 0x3eef073f, 0x0,
    0x3f294ff4, 0x0, 0x3ee7760f, 0x0,
    0xbd6a4836, 0x0, 0xbefd3fb1, 0x0,
    0xbf27a613, 0x0, 0xbefa4840, 0x0,
    0x3d2c3f7a, 0x0, 0x3f0206ca, 0x0,
    0x3f31d62e, 0x0, 0x3efcf61d, 0x0,
    0xbd874195, 0x0, 0xbf01d713, 0x0,
    0xbf32daf8, 0x0, 0xbf1d8c93, 0x0,
    0xbd57e481, 0x0, 0x3ed50568, 0x0,
    0x3f37f04e, 0x0, 0x3f02b05d, 0x0,
    0x3c7df9ee, 0x0, 0xbf163f68, 0x0,
    0xbf27b1a5, 0x0, 0xbefde180, 0x0,
    0x3dcd2ae7, 0x0, 0x3f025553, 0x0,
    0x3f31d0b3, 0x0, 0x3f1feb8e, 0x0,
    0xbc154dc9, 0x0, 0xbef918ac, 0x0,
    0xbf3f6e9c, 0x0, 0xbee02a8b, 0x0,
    0x3cf3f510, 0x0, 0x3f13d0ca, 0x0,
    0x3f280680, 0x0, 0x3ef748e5, 0x0,
    0x3d251257, 0x0, 0xbf06a394, 0x0,
    0xbf416e2d, 0x0, 0xbed3bf0c, 0x0,
    0xbc4d6a09, 0x0, 0x3f0a6cb9, 0x0,
    0x3f2d2038, 0x0, 0x3eda2c65, 0x0,
    0x3c177a47, 0x0, 0xbef5b9c0, 0x0,
    0xbf2a687f, 0x0, 0xbef7af00, 0x0,
    0xbc14557e, 0x0, 0x3eed1970, 0x0,
    0x3f270c1f, 0x0, 0x3edf8bc3, 0x0,
    0x3cfeb1da, 0x0, 0xbeea3bc8, 0x0,
    0xbf1bc747, 0x0, 0xbef75312, 0x0,
    0x3d170f1a, 0x0, 0x3f0b962c, 0x0,
    0x3f180702, 0x0, 0x3f08274e, 0x0,
    0xbc0e1a36, 0x0, 0xbef372ff, 0x0,
    0xbf330579, 0x0, 0xbf04a128, 0x0,
    0xbc52b9ac, 0x0, 0x3ee4a1e9, 0x0,
    0x3f13f285, 0x0, 0x3f13037e, 0x0,
    0x3d6de0bc, 0x0, 0xbefc8157, 0x0,
    0xbf34dce1, 0x0, 0xbedd3757, 0x0,
    0xbd218963, 0x0, 0x3edbe50f, 0x0,
    0x3f3bfab9, 0x0, 0x3ef782b9, 0x0,
    0xbd552d64, 0x0, 0xbf1b8150, 0x0,
    0xbf3ac740, 0x0, 0xbef5235b, 0x0,
    0xbd2f7da0, 0x0, 0x3f0136e4, 0x0,
    0x3f3fd492, 0x0, 0x3ef6378f, 0x0,
    0xbcb9965a, 0x0, 0xbf14df49, 0x0,
    0xbf308398, 0x0, 0xbf0b6604, 0x0,
    0x3dbf3823, 0x0, 0x3ee379e5, 0x0,
    0x3f34c3f3, 0x0, 0x3efc916b, 0x0,
    0xbc52f6cd, 0x0, 0xbf01a973, 0x0,
    0xbf37ba5f, 0x0, 0xbef67492, 0x0,
    0xbc9e8307, 0x0, 0x3f15bce9, 0x0,
    0x3f26da42, 0x0, 0x3ef42d96, 0x0,
    0xbda5bb27, 0x0, 0xbf04b24d, 0x0,
    0xbf471799, 0x0, 0xbeec4f46, 0x0,
    0x3c84f631, 0x0, 0x3ef41f8a, 0x0,
    0x3f38a25c, 0x0, 0x3efd0f95, 0x0,
    0xbb774a85, 0x0, 0xbf01443b, 0x0,
    0xbf369049, 0x0, 0xbee0db59, 0x0,
    0x3d79e44f, 0x0, 0x3efca9c6, 0x0,
    0x3f278535, 0x0, 0x3f0263a8, 0x0,
    0x3d8f2ad6, 0x0, 0xbf048ffa, 0x0,
    0xbf3b86bf, 0x0, 0xbf0dcd0d, 0x0,
    0x3cb90ccc, 0x0, 0x3f00f95a, 0x0,
    0x3f22285c, 0x0, 0x3f044ca5, 0x0,
    0xbd51ae69, 0x0, 0xbf127db1, 0x0,
    0xbf214fec, 0x0, 0xbf06df1b, 0x0,
    0x3cda4fb6, 0x0, 0x3f0a49b4, 0x0,
    0x3f37f444, 0x0, 0x3ef5f7ce, 0x0,
    0x3c593f3c, 0x0, 0xbef0555c, 0x0,
    0xbf2f5c6f, 0x0, 0xbef36fdb, 0x0,
    0x3bffd25b, 0x0, 0x3efa286d, 0x0,
    0x3f4b541d, 0x0, 0x3f01bc81, 0x0,
    0x3d08e635, 0x0, 0xbefaf3ac, 0x0,
    0xbf2cd749, 0x0, 0xbf1be28e, 0x0,
    0xbd08a7d0, 0x0, 0x3ee377f7, 0x0,
    0x3f4e85f1, 0x0, 0x3f040903, 0x0,
    0xbaa9ddf4, 0x0, 0xbf0ffaa9, 0x0,
    0xbf4361be, 0x0, 0xbf0163ca, 0x0,
    0x3d08a5b7, 0x0, 0x3ef7f060, 0x0,
    0x3f36cd39, 0x0, 0x3ef8def9, 0x0,
    0x3cca77ef, 0x0, 0xbeee9bdf, 0x0,
    0xbf384666, 0x0, 0xbee51e01, 0x0,
    0x3da74082, 0x0, 0x3f00ac70, 0x0,
    0x3f3cc123, 0x0, 0x3edaa4e7, 0x0,
    0x3b56486d, 0x0, 0xbec83411, 0x0,
    0xbf43c56d, 0x0, 0xbef983ae, 0x0,
    0x3d2e6c75, 0x0, 0x3f138e39, 0x0,
    0x3f3f5e60, 0x0, 0x3f0a907f, 0x0,
    0x3d926480, 0x0, 0xbf098306, 0x0,
    0xbf41551c, 0x0, 0xbefb3dcf, 0x0,
    0xbc114d00, 0x0, 0x3f0836a9, 0x0,
    0x3f229da4, 0x0, 0x3ee8b34e, 0x0,
    0x3d29dfce, 0x0, 0xbf17543c, 0x0,
    0xbf288f02, 0x0, 0xbf10cb39, 0x0,
    0x3c86d8b9, 0x0, 0x3ef954d2, 0x0,
    0x3f300a2f, 0x0, 0x3f0daf7b, 0x0,
    0x3c5a94aa, 0x0, 0xbedc931e, 0x0,
    0xbf3032ef, 0x0, 0xbf00af1d, 0x0,
    0x3aa7d9f5, 0x0, 0x3eee394a, 0x0,
    0x3f28294f, 0x0, 0x3f0ba054, 0x0,
    0x3d60fd9d, 0x0, 0xbf0b53b0, 0x0,
    0xbf26617b, 0x0, 0xbef1bbcd, 0x0,
    0xbd2d0ecb, 0x0, 0x3ee3e907, 0x0,
    0x3f3958ac, 0x0, 0x3f01fcc6, 0x0,
    0xbdf637ce, 0x0, 0xbed44954, 0x0,
    0xbf26e97b, 0x0, 0xbf0413d0, 0x0,
    0xbb6a2910, 0x0, 0x3f0b3546, 0x0,
    0x3f3143fc, 0x0, 0x3edde731, 0x0,
    0x3d52cf3c, 0x0, 0xbefa339a, 0x0,
    0xbf5645c1, 0x0, 0xbef91503, 0x0,
    0x3cc23d06, 0x0, 0x3eff5f43, 0x0,
    0x3f24a8e3, 0x0, 0x3ee05203, 0x0,
    0xbd1170b7, 0x0, 0xbf0edfc4, 0x0,
    0xbf357c35, 0x0, 0xbf02c48a, 0x0,
    0x3b61ec03, 0x0, 0x3f054658, 0x0,
    0x3f3feacd, 0x0, 0x3f0c24dd, 0x0,
    0x3d43552b, 0x0, 0xbeedaf58, 0x0,
    0xbf259f38, 0x0, 0xbf010562, 0x0,
    0x3dd55e5e, 0x0, 0x3ee1ac65, 0x0,
    0x3f3aae3a, 0x0, 0x3f02275c, 0x0,
    0x3cc5eac7, 0x0, 0xbeda26cd, 0x0,
    0xbf1e22ef, 0x0, 0xbf14dc96, 0x0,
    0x3d88feed, 0x0, 0x3ee149b6, 0x0,
    0x3f3b6cfd, 0x0, 0x3f062a83, 0x0,
    0x3cadda31, 0x0, 0xbed62c2b, 0x0,
    0xbf2fbd24, 0x0, 0xbef0838d, 0x0,
    0xbd1d0889, 0x0, 0x3f19f926, 0x0,
    0x3f3e4ca1, 0x0, 0x3f0813e4, 0x0,
    0xbc9f04eb, 0x0, 0xbf0fece0, 0x0,
    0xbf229473, 0x0, 0xbf0537ce, 0x0,
    0xbd6451b9, 0x0, 0x3ef446eb, 0x0,
    0x3f3299af, 0x0, 0x3ef235b5, 0x0,
    0xbd890ee2, 0x0, 0xbeff217b, 0x0,
    0xbf3a9309, 0x0, 0xbeeb2d8d, 0x0,
    0xbd2f6d11, 0x0, 0x3f03b581, 0x0,
    0x3f2d72af, 0x0, 0x3eecf6ee, 0x0,
    0xbc0ffc49, 0x0, 0xbef3f76a, 0x0,
    0xbf240ca0, 0x0, 0xbefcebd7, 0x0,
    0x3d032278, 0x0, 0x3ee56637, 0x0,
    0x3f31707d, 0x0, 0x3eefb72e, 0x0,
    0x3d1c4737, 0x0, 0xbec782ec, 0x0,
    0xbf37e0a2, 0x0, 0xbf0efdc6, 0x0,
    0xbd24c2bd, 0x0, 0x3ee660bd, 0x0,
    0x3f3a5cfc, 0x0, 0x3f00d114, 0x0,
    0xbd83aca3, 0x0, 0xbf121a98, 0x0,
    0xbf27a34f, 0x0, 0xbef9678e, 0x0,
    0x3d2ed871, 0x0, 0x3f04284f, 0x0,
    0x3f481129, 0x0, 0x3f199b32, 0x0,
    0xbd9caadc, 0x0, 0xbee662a8, 0x0,
    0xbf347931, 0x0, 0xbeeb89c4, 0x0,
    0xbd5628ff, 0x0, 0x3f118c0b, 0x0,
    0x3f25d1ac, 0x0, 0x3f1cfa19, 0x0,
    0xbd3e377b, 0x0, 0xbed7e12a, 0x0,
    0xbf29d9da, 0x0, 0xbf0c78f9, 0x0,
    0xbd3b7f47, 0x0, 0x3effb70d, 0x0,
    0x3f265540, 0x0, 0x3ee985ca, 0x0,
    0xbd0d4dfb, 0x0, 0xbf01a5f9, 0x0,
    0xbf2de0ad, 0x0, 0xbeed3d2f, 0x0,
    0xbdb59e83, 0x0, 0x3ec8e8ad, 0x0,
    0x3f2ddee7, 0x0, 0x3efefd28, 0x0,
    0xbd5394a5, 0x0, 0xbef31405, 0x0,
    0xbf2ea91d, 0x0, 0xbf11a48a, 0x0,
    0x3d1747d4, 0x0, 0x3ee6e853, 0x0,
    0x3f298237, 0x0, 0x3ee68f82, 0x0,
    0xbd13e1aa, 0x0, 0xbef98c1a, 0x0,
    0xbf310023, 0x0, 0xbeeead69, 0x0,
    0xbbb8908f, 0x0, 0x3ed3ab11, 0x0,
    0x3f3c4d2f, 0x0, 0x3f19fd45, 0x0,
    0x3c49f9e2, 0x0, 0xbf0503c5, 0x0,
    0xbf32ae82, 0x0, 0xbf07bc8e, 0x0,
    0xbcad7608, 0x0, 0x3f062c7d, 0x0,
    0x3f3835a4, 0x0, 0x3ee66699, 0x0,
    0x3b6fb69d, 0x0, 0xbef8bd54, 0x0,
    0xbf324adc, 0x0, 0xbedb8560, 0x0,
    0xbd60c1a5, 0x0, 0x3ede57e4, 0x0,
    0x3f2b8cd3, 0x0, 0x3ec7be0a, 0x0,
    0x3d4c40e1, 0x0, 0xbf0b694e, 0x0,
    0xbf30bd22, 0x0, 0xbefdf8cf, 0x0,
    0xbcbbcd4f, 0x0, 0x3f03e051, 0x0,
    0x3f3e2fe0, 0x0, 0x3ee0d3a8, 0x0,
    0x3d2de06b, 0x0, 0xbeee7f58, 0x0,
    0xbf140e1d, 0x0, 0xbf0cd979, 0x0,
    0x3dcf9841, 0x0, 0x3f14c7af, 0x0,
    0x3f4b711d, 0x0, 0x3ec071b2, 0x0,
    0xbd82e590, 0x0, 0xbf02e72e, 0x0,
    0xbf429ea3, 0x0, 0xbefc3505, 0x0,
    0x3d92451e, 0x0, 0x3f0596e3, 0x0,
    0x3f29b6ef, 0x0, 0x3f0d1bb2, 0x0,
    0x3d451113, 0x0, 0xbf036541, 0x0,
    0xbf447003, 0x0, 0xbf0dffb2, 0x0,
    0x3dc4298f, 0x0, 0x3eeb3fa2, 0x0,
    0x3f3e3cde, 0x0, 0x3f024480, 0x0,
    0x3cd698b1, 0x0, 0xbee492d4, 0x0,
    0xbf3ac946, 0x0, 0xbefc396c, 0x0,
    0x3ddb4c29, 0x0, 0x3ef77770, 0x0,
    0x3f1e8d05, 0x0, 0x3ee2210e, 0x0,
    0xbd52755e, 0x0, 0xbeed0f40, 0x0,
    0xbf2a561e, 0x0, 0xbee46c67, 0x0,
    0xbc3c5bc9, 0x0, 0x3f036947, 0x0,
    0x3f3e4d7a, 0x0, 0x3ed81bef, 0x0,
    0xbd700d28, 0x0, 0xbf0aa3bb, 0x0,
    0xbf1ee21c, 0x0, 0xbefc0469, 0x0,
    0x3c490667, 0x0, 0x3f022c62, 0x0,
    0x3f3d3675, 0x0, 0x3ef21401, 0x0,
    0xbd5ce509, 0x0, 0xbf0aeb8b, 0x0,
    0xbf33aba6, 0x0, 0xbef12eae, 0x0,
    0xbd84cd3c, 0x0, 0x3f03c9cc, 0x0,
    0x3f3fe3ac, 0x0, 0x3ed7b64f, 0x0,
    0xbdbca68d, 0x0, 0xbf02d0a0, 0x0,
    0xbf453b9e, 0x0, 0xbeea3fa0, 0x0,
    0x3b91f42d, 0x0, 0x3ed71616, 0x0,
    0x3f369b7c, 0x0, 0x3efe3124, 0x0,
    0xbc6b0118, 0x0, 0xbef45b8b, 0x0,
    0xbf44ee4c, 0x0, 0xbeec519b, 0x0,
    0xbc3b0436, 0x0, 0x3efbd8f7, 0x0,
    0x3f2638c1, 0x0, 0x3efd149a, 0x0,
    0x3c5e2b31, 0x0, 0xbf050caf, 0x0,
    0xbf327cb5, 0x0, 0xbed7db2f, 0x0,
    0xbc4d1975, 0x0, 0x3f067e98, 0x0,
    0x3f3a46d9, 0x0, 0x3efa1bfc, 0x0,
    0xbdcc7f76, 0x0, 0xbf113136, 0x0,
    0xbf34744f, 0x0, 0xbefad95e, 0x0,
    0xbdb79b2d, 0x0, 0x3edc20a1, 0x0,
    0x3f2e4805, 0x0, 0x3f0ba15f, 0x0,
    0xbd8edf26, 0x0, 0xbeff3fd8, 0x0,
    0xbf298292, 0x0, 0xbf033ae5, 0x0,
    0xbca1a6a0, 0x0, 0x3f01592a, 0x0,
    0x3f2e7a89, 0x0, 0x3f026cb5, 0x0,
    0x3da75682, 0x0, 0xbeed7c6e, 0x0,
    0xbf390c93, 0x0, 0xbef04f56, 0x0,
    0x3bba82bc, 0x0, 0x3f12d2bb, 0x0,
    0x3f28d1da, 0x0, 0x3ecd12a4, 0x0,
    0xbc03cbf5, 0x0, 0xbf00215d, 0x0,
    0xbf29a760, 0x0, 0xbf179c47, 0x0,
    0xbc9fab30, 0x0, 0x3f0955e3, 0x0,
    0x3f358e24, 0x0, 0x3ee980aa, 0x0,
    0x3bd4f384, 0x0, 0xbf0fd101, 0x0,
    0xbf3f2a8b, 0x0, 0xbf02e1ca, 0x0,
    0x3da2a8a8, 0x0, 0x3f135e42, 0x0,
    0x3f46c2d4, 0x0, 0x3eee40c9, 0x0,
    0xbd9f19a8, 0x0, 0xbef51cc9, 0x0,
    0xbf425459, 0x0, 0xbef7f12c, 0x0,
    0x3b62f213, 0x0, 0x3ee01a38, 0x0,
    0x3f30bf9e, 0x0, 0x3eefc55d, 0x0,
    0x3d78a502, 0x0, 0xbefd4484, 0x0,
    0xbf41418f, 0x0, 0xbef40175, 0x0,
    0x3bb26a08, 0x0, 0x3eee2628, 0x0,
    0x3f381105, 0x0, 0x3efe82d2, 0x0,
    0x3cb8b294, 0x0, 0xbeed84d9, 0x0,
    0xbf31cf27, 0x0, 0xbf025435, 0x0,
    0xbd96783e, 0x0, 0x3eb8acad, 0x0,
    0x3f316173, 0x0, 0x3f0eaf20, 0x0,
    0xbd0f4cc4, 0x0, 0xbf09a58e, 0x0,
    0xbf377c16, 0x0, 0xbefaceef, 0x0,
    0x3cff39b9, 0x0, 0x3ed9765d, 0x0,
    0x3f36d736, 0x0, 0x3ef5d758, 0x0,
    0x3cdd0125, 0x0, 0xbeefddf1, 0x0,
    0xbf4b2e57, 0x0, 0xbf18c7da, 0x0,
    0xbd45617e, 0x0, 0x3eeb6750, 0x0,
    0x3f4486ac, 0x0, 0x3edd8d78, 0x0,
    0x3cc651fa, 0x0, 0xbef60c1f, 0x0,
    0xbf23a1bf, 0x0, 0xbeea905d, 0x0,
    0xbc4bc94c, 0x0, 0x3f09e64e, 0x0,
    0x3f325159, 0x0, 0x3eb6f662, 0x0,
    0x3bece2ca, 0x0, 0xbf020fc4, 0x0,
    0xbf2f4273, 0x0, 0xbef64123, 0x0,
    0xbc103e75, 0x0, 0x3f128b87, 0x0,
    0x3f2b5826, 0x0, 0x3ee89123, 0x0,
    0x3b82d449, 0x0, 0xbee86fa5, 0x0,
    0xbf2c43ce, 0x0, 0xbf025feb, 0x0,
    0xbd88ea50, 0x0, 0x3ef773e0, 0x0,
    0x3f3a9190, 0x0, 0x3ef04a01, 0x0,
    0xbdf372f1, 0x0, 0xbef95ccb, 0x0,
    0xbf394599, 0x0, 0xbf0a096b, 0x0,
    0xbd25aefb, 0x0, 0x3ee92e80, 0x0,
    0x3f3c5a66, 0x0, 0x3f064b18, 0x0,
    0xbd91aea5, 0x0, 0xbf02a182, 0x0,
    0xbf235d7a, 0x0, 0xbed94453, 0x0,
    0x3cce9320, 0x0, 0x3f14b120, 0x0,
    0x3f3eae06, 0x0, 0x3ee791a1, 0x0,
    0xbd00f25e, 0x0, 0xbebf0444, 0x0,
    0xbf1a93b4, 0x0, 0xbf07d731, 0x0,
    0x3c8a6ce9, 0x0, 0x3ef3729f, 0x0,
    0x3f255047, 0x0, 0x3ee71e9d, 0x0,
    0xbccd05ea, 0x0, 0xbf01ff98, 0x0,
    0xbf385c3c, 0x0, 0xbf183ee2, 0x0
    };

static const uint32_t in_cifft_noisy_2048[4096] = {
    0xc0a02ec6, 0x0, 0xbfabf6af, 0x4048596c,
    0x3f2081fd, 0xbebd5d99, 0xbf719dcd, 0xbf5130e3,
    0xbe9a4913, 0xbec74d71, 0x3fc37d33, 0xbfdd69d0,
    0x402d0e47, 0xbef630e1, 0xbe8a6858, 0xc00467ea,
    0x3eb3e454, 0x3c6c2c04, 0xbfe81a6c, 0xc01e1d6e,
    0x3f244007, 0x3f635949, 0x3ed02dd6, 0xbf884571,
    0x3efa8afd, 0x3fb25301, 0x3f7f21e2, 0x3f06c8fe,
    0xbf521414, 0xbfb2362a, 0xbf77aaba, 0x3e73e5b3,
    0x3dc29426, 0x40283b29, 0xbfd0da8d, 0xbff5c6cf,
    0xbf604823, 0xbfc83a17, 0x40472f9d, 0x40231545,
    0x40226305, 0xbeb15efb, 0x406e4fd3, 0xbf797d5b,
    0xc0303516, 0xbe1c147c, 0x3f331f64, 0xbf5141d0,
    0xbf70e6fc, 0x3fe11e63, 0xbe693fae, 0x3d7c6210,
    0xbfcb1700, 0x3fefc537, 0x3e5d5328, 0xbf20ec95,
    0xbfb95584, 0xbefbcd20, 0xbe9aa52f, 0x3f537e35,
    0x3ebb8dc4, 0xbfe92335, 0x3e260c7f, 0xbf4e6787,
    0xbfbba3f4, 0x409d1ad5, 0x3e3bc47e, 0x3fe19272,
    0x3fb757f6, 0x3f6d43e4, 0x3eef8a06, 0xc0457f4b,
    0x3f4ae8df, 0xbe3a0c49, 0x3f9c2210, 0xbe2a41e8,
    0x3f2c0762, 0x3e5e11a5, 0x3e8901e1, 0x3f5af910,
    0xbf49e705, 0x3f6d68ae, 0x3f9752e2, 0xbfa4539e,
    0xc00cb6a2, 0xc0566d4c, 0x3faadf1f, 0x4009947d,
    0x400a0930, 0xbfa827e8, 0x3f17b110, 0x40284e6f,
    0x3fe066f2, 0xc070a368, 0xc0506953, 0x3fe451f8,
    0xc0017bfd, 0xbfe839d2, 0xc015efc6, 0x3ec7c235,
    0x402f2e99, 0x40271067, 0x3eaa0ffc, 0xbe210919,
    0x3e78bde0, 0x4004bd1c, 0x3f8bce5a, 0xbf31ae35,
    0xbef4e29e, 0xbf2d1b4c, 0xbfe9bdae, 0xbe0d3ca2,
    0xbf9e361b, 0x3dd0f36b, 0x40019857, 0x3fb538cd,
    0xbfff0651, 0xbf08445d, 0xc082e678, 0x3e328dea,
    0x3f8ca112, 0x3f4a3dbd, 0x3fcdd640, 0x3f6153a4,
    0xbfec815d, 0x40515e47, 0xc0812fc3, 0x40022a08,
    0x3f0d54c8, 0x3fda4a6c, 0xbfa2e653, 0x3d9cce21,
    0xbef67dab, 0xc02b753d, 0x3efe7528, 0xbef00bab,
    0x3e9586ea, 0x3efabd24, 0xbf028bc5, 0xbebddd1b,
    0x401d0257, 0x4000ed0e, 0xbf01fdd7, 0xc051c6b3,
    0x3ed66da3, 0x3def1967, 0xbf5ad1ae, 0x3f974faa,
    0xbfb6bd81, 0xc0156ded, 0xbfe6c5a7, 0xc05a4ac1,
    0x3f1c8550, 0x4048670f, 0x3d9fb0c2, 0x3d9f9ff9,
    0xbf531a6f, 0x3ecdaa46, 0xc00cea1b, 0xbf568c6d,
    0xbf54dc39, 0xbf398a7e, 0x3dc1d960, 0x3ef319f1,
    0xbf199a7e, 0xc09a3eb4, 0xc077c794, 0xbfd19f58,
    0xc08d3ba8, 0x3f6b0bfc, 0x4062e984, 0xbeb687f8,
    0xbf2d75e3, 0x3fb46bf9, 0x3e7274c7, 0xbfb09e1e,
    0x3f7d0a97, 0x3f6e85ad, 0x3f850f53, 0xbf5b7b3a,
    0xbf87efa8, 0x3ed44c22, 0x4017d4fe, 0x404132d8,
    0xbf0268af, 0x4008f4a3, 0xbfcfa984, 0xbf35b9e4,
    0x3fdafcd9, 0xbfc40b99, 0x3ee00258, 0xc07f4d0a,
    0x3eec69cd, 0xc00201d4, 0xbed8b171, 0xc05baf96,
    0xbf281321, 0x3e813bc8, 0xbed3b592, 0x3f305428,
    0x3fa5d65b, 0xbf91ba4a, 0xc0408765, 0xc08f0542,
    0xc0227e0e, 0xc0809c31, 0x3fd9356b, 0x3f099a15,
    0x3e2fa3a5, 0x3f970ba1, 0xbe4ac0de, 0xbf74d307,
    0x3f839536, 0xc02d10de, 0xbffaba82, 0xbe3468d7,
    0x3fb89891, 0xbdf8c964, 0x4009c927, 0x3f282958,
    0xbf8d554e, 0x3f69a4b3, 0xbf8cd4b3, 0x3e7e64e5,
    0xbf60ddc3, 0xbf9d00f1, 0xbf456937, 0x3eab2c5e,
    0x3f3be000, 0xc007903f, 0xbfbaa2d2, 0xbeadca26,
    0x3e87470c, 0xbdeaccc1, 0xbdb83ae0, 0xc04f83fc,
    0xbf997a66, 0x3fcc6dbf, 0xbfb99a34, 0xc00aff61,
    0x4029b476, 0x40349c72, 0x3e84e3ad, 0xbf03bba1,
    0x4020ca9b, 0xbd0cc93f, 0x3f1e5a6d, 0xc016efc6,
    0x3fad51ae, 0xc04bd717, 0xbed90db7, 0x3f09cda9,
    0x3fc95966, 0xbf16b4a5, 0xbf726849, 0xbf7cfdd3,
    0x3d86fb46, 0x3f2a3e7e, 0x3fec8d70, 0x3f870772,
    0xbff0f848, 0x3f2596e5, 0x3ff8f5a3, 0xbeb4a174,
    0x3b1d39f6, 0xbf5d48fd, 0x3ef86790, 0x3f92fb09,
    0xbf2cd028, 0xbec69262, 0x3fa28334, 0xbe9dc57a,
    0x4016449a, 0x401b406b, 0xbf5b3dbf, 0xbfea14d1,
    0x3f070af6, 0xc059fc3f, 0xbffe220d, 0x3f994a26,
    0xbfcb047a, 0xbfa59e6d, 0xbf992a27, 0x406047d4,
    0xc039d103, 0xbfbd0e36, 0xbfc3353d, 0xc054448e,
    0x3eb51aac, 0x3f3bcfd3, 0xc027de37, 0xbf87a1f4,
    0xbf50f007, 0xbfddac68, 0xbf7a580f, 0xbd07cb54,
    0xbf814ac5, 0x3f1e23d4, 0x3f7221a6, 0x3f8cac50,
    0xbfbd54c4, 0xc03af0b1, 0xbebda6bf, 0x3dd1765f,
    0xbec01527, 0xbf4d1c3b, 0xbf2cd545, 0xbf90663a,
    0x3f52acf9, 0xc007554a, 0x3f2f12da, 0x3f85724e,
    0xc024b552, 0x3f5df8a0, 0x3dc70214, 0x3f87065d,
    0xc024e58d, 0x4000625a, 0xbf0bb3fe, 0x3f6f65d1,
    0x3fc18e19, 0x3dfbc4e4, 0x406d9e30, 0xbf7c3903,
    0x3ed89026, 0xbceeaf7e, 0x3e7fe430, 0xbf3b1bf4,
    0xbdf749ef, 0xbfd33112, 0x40166fb7, 0x3eea456f,
    0xc025f5cd, 0x408c0479, 0x3f6871db, 0xc024b7d8,
    0x3fa88e7d, 0x406a31c2, 0x3f94cc4c, 0x40117bbb,
    0x3f86b093, 0xbf1dbb4f, 0xc037da65, 0xbf01b7d3,
    0x400a6eeb, 0x3f288fbe, 0xbf00df2f, 0x3f1f5dc4,
    0xbe4b9a5e, 0xbf8d15b9, 0x3fcfb9e2, 0xbf4b502d,
    0x3f62cc55, 0x3f3f4bf5, 0x3f74ca02, 0x3e72263a,
    0xbf68d99c, 0xbf826f16, 0xbded5ebb, 0xbf03ed6a,
    0xbfacbe81, 0xbf148d5b, 0x3ecc02e0, 0xbee25083,
    0xbf582497, 0xbfb97af2, 0xbf2741b4, 0x3fbbdbe1,
    0xbfb70a02, 0xc04fe8b3, 0xbecae915, 0xbed2f6df,
    0x3e8248a7, 0x40125c96, 0xbfe712c6, 0xc02309d3,
    0xbe01d205, 0x3f890b81, 0xbe880772, 0xbfd62a6c,
    0xbfaa7cdf, 0xbfa41de7, 0xbe9b07ae, 0xbff53982,
    0xbfb84989, 0x3f3d8b56, 0xbfefc159, 0xbfa651c5,
    0x3c13773b, 0xbdc2b7a0, 0x4006756b, 0xbfbcf278,
    0xbf7a6659, 0x3fd9d958, 0x3ff96f21, 0xc00f61aa,
    0x401af01f, 0x403cd243, 0x3ed15f34, 0x3fba6e07,
    0x3f5b05c8, 0x4018622e, 0xbfdecde8, 0x3fc85583,
    0xc01ec4d3, 0x3f0b1485, 0xc05a95ca, 0x3d9297b2,
    0x40222590, 0xbfe2ceba, 0x3f4c7263, 0xbf55b29a,
    0x4010463b, 0x3fec5f0e, 0xbeaf9c5a, 0xbff532f9,
    0xbe7ef5b6, 0x3f4ea2b6, 0xbd232839, 0x3f2f85da,
    0x3feab870, 0x3f622be7, 0xc01357bd, 0xbed55aca,
    0x402145d6, 0x3ffd5f6e, 0xc02723a0, 0xbf8bc3af,
    0x400e8ed6, 0xc0291107, 0x3f54d5c6, 0xbe59093a,
    0x3f1b8752, 0x3ebc58ac, 0x3f3e13ce, 0x3fbdbf8e,
    0xbf65818e, 0xbd1c614e, 0x3fb05954, 0x3f49f13e,
    0x3f83a3df, 0x3fab52ef, 0x3e9b3707, 0xbec4dd11,
    0xbfd31b51, 0xbe75d513, 0xbf3916d1, 0x402506cb,
    0xc019b041, 0x3f98d079, 0xbfd37d35, 0xbfb47fff,
    0x3f5e709c, 0xbff92e4d, 0xbf80da6a, 0x3ebae27b,
    0xbfe74c3d, 0xbfc16ddd, 0xc0059b73, 0x3faa1e2a,
    0xbf8418d3, 0x3f9d3ba7, 0x3e8be9e8, 0x4029ef63,
    0x3fa2cf6f, 0xbeaa0c31, 0x3f2909c3, 0xbf8aa8f3,
    0x3fd73b1d, 0x3fb77e44, 0x400229e9, 0xbfc8481d,
    0x3fe274e1, 0xbf2daf51, 0x3f900a36, 0xbfaeae42,
    0x3f6ce08a, 0x3c80696c, 0x3f97352e, 0xbf8b8199,
    0xbf13de2b, 0xbd833bfb, 0xbdce52c4, 0x3eea4c06,
    0x3ea30c78, 0xc044909b, 0x40200bb6, 0xbf6c18a7,
    0xbe81e4ef, 0x3f1038cd, 0xbf92127c, 0x3fbb2714,
    0xbeb7bd37, 0x3f893f37, 0x3fd4388a, 0x3fdcfd50,
    0x3e3ae281, 0x407c018c, 0x3d9746ec, 0x4033874c,
    0xbf2a9eb2, 0xc010f5a8, 0xbf05197b, 0xbfba1fc9,
    0x3fd3fcf0, 0xbf85cacc, 0x3f044ee4, 0xc00afa05,
    0x3e88b8a1, 0xc037e478, 0xc048ef01, 0x3fbdd983,
    0x3f179a6f, 0xc433540f, 0xbed07bf9, 0x3f95b0b0,
    0xbf6bf578, 0x407e827b, 0xbdbdc3a0, 0x3ffc61bb,
    0x4021caf3, 0x3fd94fa2, 0x3f64c1dd, 0xbdbdcc3f,
    0x3faa8055, 0x3fe8a9c1, 0xbf936d49, 0xc0a92dc0,
    0xbfcc969d, 0x401631be, 0xbfc15db8, 0xbf1ce75b,
    0x3f805581, 0xbe959024, 0x3fbbd4a5, 0xbf2ffe0e,
    0xbfbdaf4a, 0x3fdce738, 0x4058250d, 0x40237dca,
    0xbe13d2a6, 0xbfce9cfc, 0x3d93145f, 0x3c7f782d,
    0xbf2e9742, 0x3f9f91b2, 0xc04300ab, 0xbebaf3b2,
    0xbf4283f0, 0x3fb7b72e, 0x3f760a1b, 0x3f582c34,
    0xbf75d76e, 0xbe8b76e1, 0x3f13cedc, 0x3efa2db1,
    0x3f4a3a35, 0xbe3ccdd5, 0x3f030b6a, 0x402a251b,
    0x3e8b3d3c, 0x3fd293d3, 0xbe9a4465, 0xbd6982ff,
    0x3f5d71b1, 0x3fedbf7a, 0x3eafc818, 0x3eb30faa,
    0x3ee12b94, 0x404ff1e4, 0xbed1f1f4, 0xbfdd6605,
    0xbe8682c1, 0xbff69b22, 0x3fcc3be1, 0x3dab150e,
    0xbf034184, 0x404d5f51, 0xc00e8779, 0xc004875f,
    0xbebf0b57, 0xbf5f9fe6, 0xbefd6b8b, 0x3f79d67f,
    0x3fd613ca, 0x3f89d9e4, 0xbfff9ff0, 0xbef7397a,
    0x3f4e1b41, 0xc0044db4, 0x3f4e2795, 0xbf965ffa,
    0x3fff0f18, 0x3f98a6b9, 0xbe8cebfe, 0xbfeacf73,
    0x3cd83004, 0xbf572dad, 0x400f6400, 0x3f903e5a,
    0x3f049e55, 0xbf407ebc, 0xbeb58361, 0xc0712202,
    0x3fdddfbd, 0x401d3520, 0x40326ab1, 0x3eab9db4,
    0xbfcdf6de, 0x3f6f1802, 0xbf4fcd51, 0x40006144,
    0xbf8d0f14, 0xbe5e862b, 0xbf9ec090, 0x3f9b61a0,
    0x3fbeab0e, 0xbebaa2b9, 0xbec457e8, 0x3f6514e3,
    0x3f384052, 0x3f0aa83d, 0x400141d8, 0x3f626c07,
    0xc0048a74, 0xbf586cef, 0xc0554a66, 0xbd34e0d4,
    0xbe90feae, 0xc009f082, 0xbf8d8891, 0xc022d6cf,
    0xbf25c57d, 0x3e6a73b8, 0xbfebe6b2, 0x401c306c,
    0x3f8dc07f, 0xc012bf14, 0xc012b2ae, 0xbf0db0be,
    0xbf841e06, 0xbdfe4f53, 0x3f50c2f0, 0xc02a2d69,
    0xbf7176c0, 0x3f0052dc, 0x3f440b0b, 0x3e4a4081,
    0xc005d8e7, 0xbfc01991, 0x3e7b5323, 0xbfdeccc9,
    0xbff55828, 0x3fe4eb54, 0xbfd84738, 0xbe788614,
    0x3eff66d3, 0xc00fe882, 0xbfefa1f2, 0xbfdf094e,
    0xbf94488b, 0x3f44ee1c, 0xbff5048a, 0x3dae2c5c,
    0xbfbd83ba, 0x3f821a1c, 0xbfb32b42, 0x3f302a06,
    0xbfd62dfd, 0xbfc836ca, 0x3fc49334, 0xbe84fc95,
    0x3f7a5687, 0x3fe7442d, 0x4017dbb0, 0x3fea979f,
    0x3f05702a, 0xbfd8221e, 0xbf9eff77, 0xc041b0f9,
    0x3ebffc0e, 0x3f8e31cb, 0x3f5bb3cb, 0xbf2749d0,
    0xc02ef00d, 0xbfcf5969, 0xbe666ab2, 0xc02ac6e3,
    0x4039f47e, 0xc01ecdd1, 0xbe993a51, 0xbfd91c67,
    0xbe063524, 0x3f1da1b9, 0x3fcf0305, 0x3fc1f799,
    0xbff6b8ad, 0xbf0fa55b, 0x3eaa0bdf, 0x3f8c3c5c,
    0xbe056f23, 0x3f399c51, 0x3f631e4b, 0x3f28885d,
    0xc0711bc7, 0x3f958d4b, 0x3fcbcb97, 0xbe9a6ef9,
    0x3fec42ac, 0xbe87478d, 0xbf3d869b, 0xbf460ffd,
    0xbff30a30, 0xc0000f0a, 0xbe29e6a0, 0x40475636,
    0x3fb9d9f7, 0xbf963952, 0xbf670219, 0x3f763d5f,
    0xbf87a187, 0xc01b410f, 0x3d8e529c, 0x3f74b7c5,
    0xbe2cb815, 0xbfaa0ab4, 0xbfb2f018, 0x3e4be41f,
    0x40288066, 0xc00494d7, 0x403dfab3, 0xbf5e7129,
    0xbf203bd7, 0xbf582feb, 0xbfbd53a8, 0x3fe88ec4,
    0x3fff2566, 0x3fc3a812, 0xc07340bf, 0x3f42d587,
    0x3e974288, 0x3f93dee8, 0xbc083a55, 0xc009e565,
    0x3e52406b, 0x3fd20154, 0x3f471543, 0x3ed9c5ec,
    0x4014c8e0, 0x3fa01d9e, 0xbf597a34, 0xbe8d66b0,
    0x3f674f68, 0xbec3c39b, 0xbf4ad85c, 0xc03513ca,
    0xc024bae5, 0xbf816f97, 0x3f9aaf43, 0x3fad522f,
    0x3f026ac0, 0x3f634c67, 0x405ea87c, 0xbebfbe1d,
    0xc0026154, 0x3ec940c8, 0x3f96a547, 0x3fd7b802,
    0x403d9baa, 0xbde68cf2, 0x3fd6569b, 0xbfe9b6db,
    0x4008225a, 0xbed8ad46, 0x3f535236, 0x3ed45599,
    0x3fc07c38, 0xbf8164b9, 0x4082e832, 0x3f8525f0,
    0xbf57b8c4, 0xc001aac5, 0x3f5c25a7, 0x4017168f,
    0x3f7c3c61, 0xbedff63d, 0xc00421b0, 0x3d7db4ee,
    0xc062f5b3, 0xbf1f71ff, 0xbfb360cd, 0x3f1b1fa7,
    0x3f3a5f6f, 0x3ef2a743, 0xbf370cec, 0xbfad3fe2,
    0x3fb35f4d, 0x3f3dca75, 0x3fa9ed53, 0xbfcaa213,
    0xbfdc9b00, 0x3fa06f80, 0x3f569ce1, 0xbf6eda6f,
    0x3ea19a7d, 0xbf461269, 0x3ee11290, 0xbff548f7,
    0xc083b19c, 0xbfe753db, 0x3f3c0e6b, 0x3f0bbe56,
    0x3e028720, 0xbeed2fe6, 0x401a3a13, 0xbf8b26ba,
    0x402de9c1, 0xbe4a82ae, 0xbf1fba56, 0x3f626b7e,
    0x3f2e63e3, 0x3d13cbee, 0xbfa37e8a, 0x3fdf0d14,
    0x4024a336, 0xbfcd3d45, 0x3fe8c08d, 0xbf8023ad,
    0x4002eb41, 0x3fb3e34c, 0xbf12db6f, 0x3f76f78c,
    0xbbf43cd4, 0xbe3128f3, 0x3faa7b78, 0x3f5df707,
    0x3e1ec28b, 0x40567d60, 0x400caa59, 0xbfd71022,
    0xbfda9e08, 0x3e2373e5, 0x3e89fc37, 0xbfb7537c,
    0x3f0e52a1, 0xbf8fc2a9, 0xc01b4176, 0x3fafd76d,
    0x3fb75b7d, 0x3f81a7df, 0x3d973cfc, 0x3e31cdab,
    0xbf3cad23, 0xbf86592b, 0x3fa56200, 0x3f6d4057,
    0xc00da842, 0x3f2108e8, 0xbf5f7de6, 0x3f830703,
    0x3f25c7fb, 0x3f03ec72, 0xc0559c8a, 0xbfdde875,
    0xbf135fcd, 0x3fe413f0, 0xc05d6138, 0x3f588359,
    0xbf80e323, 0xbf9634e0, 0xbcca3e48, 0xbf8ecb86,
    0x3f0a9f5d, 0xc000c5d6, 0x3ffee406, 0xbf388b1c,
    0xbfb98ebf, 0xc040ba6a, 0xbf187dfd, 0x3fb91421,
    0xc04923cd, 0x3f91ad95, 0xbe4fac93, 0x402985b6,
    0x3f16efc7, 0xbee07d91, 0x406c5565, 0x3fa4de9f,
    0x4018df54, 0xc01b81da, 0xbf38102a, 0x4035b808,
    0xc0069ddd, 0x3df7b897, 0x404b4d49, 0x3ff1ddb6,
    0x3f786f30, 0xbd318f38, 0xc0119dc0, 0xbfb919e7,
    0x3c21f487, 0x40024a58, 0xbfdb567e, 0xbf78790e,
    0x3ffc60fd, 0xbde9b746, 0xc020767d, 0xbf90ea85,
    0xbfe43051, 0xc011d3ff, 0xbf23c1ba, 0x3ec13e04,
    0x3ff5d0ee, 0xbeab3524, 0x40198e0c, 0xbfcc9e51,
    0x404d9e09, 0xbc880588, 0xbddd218e, 0x3ee37f5d,
    0xbf855756, 0x3f905934, 0xbf827ae1, 0xbfda3873,
    0x3ed30cc0, 0x3eeee64b, 0xc00f5107, 0xbf14515b,
    0xc0454fc6, 0x3f8e7a60, 0x3f8db381, 0xbfed12e4,
    0x3ed9f2ac, 0xbf642048, 0xbe1fb95d, 0xbf4859e9,
    0xbf53c798, 0xbeb2eed6, 0x3ee21d71, 0x3f850e2a,
    0x401513e1, 0xbfc075ea, 0x4015b3ab, 0xbf153148,
    0xbe86800a, 0xbea3b42a, 0xbed2dce1, 0xbfa7a66f,
    0xbed671b3, 0x3e61a360, 0x3f889d9e, 0xbea78711,
    0x3f37f354, 0xc0153c4b, 0x402ecf65, 0xc01a86d8,
    0x3e3595f2, 0x40529366, 0xbf8ae347, 0xbf90e9d5,
    0x3f723b32, 0xbe0c31d9, 0x3fa4cb83, 0x3f9aceea,
    0x3fa9eea4, 0x3fbc9c38, 0xbedd432c, 0x401ff96a,
    0x3e8e1db5, 0xbf7f5248, 0xbfb7f94f, 0x403f085b,
    0x3fa20817, 0x3f6583ee, 0xbfac81d9, 0x3ff347b1,
    0xbe9d922a, 0xc020c12a, 0xbf9adb06, 0xbf732fa1,
    0xbfc314bb, 0x406dd0fe, 0x4013d467, 0xc0533283,
    0xbd82862d, 0xbf2eff20, 0xbe9f7fa5, 0xbf9658db,
    0xc03638d2, 0x3ff4ee7c, 0x401a2b73, 0x40275358,
    0x3c843299, 0x4081feb4, 0x3dc1d8fd, 0xbe90638b,
    0xbfbb72d6, 0xbd33306f, 0x3f5e74da, 0xbfc3fbfc,
    0xc0798022, 0xc00c5db0, 0xbf8f177f, 0xbe9b76e3,
    0x3f5da605, 0x3f9528f3, 0xbdbe0652, 0x4035cf26,
    0x3fec944f, 0xbfcc1040, 0xbfdd8a2b, 0xbe4053f2,
    0xbf2f63ed, 0xc0165120, 0x3fa052f9, 0xc01b553e,
    0xbf2e43ea, 0xbf474d22, 0xbf68e661, 0x3fd1bb03,
    0xc0607f1b, 0xbf80748c, 0xbf6694cb, 0x3f498719,
    0x3f2c995a, 0x3f9488b4, 0xbf14c80d, 0xc0405dcb,
    0x3ee5bec9, 0xbf575a84, 0xbf64daf9, 0xc0082405,
    0x404da156, 0xbf751fc2, 0xbf5be007, 0xbf5baae3,
    0xbfb463c3, 0xbe760961, 0x3e0e045f, 0xbfc9106e,
    0xbf0a72ae, 0xbea7177e, 0x3b0df3bf, 0xbecaffd7,
    0x3f3a0ccd, 0xc084cdcd, 0x3de250c3, 0xbf0d0384,
    0x3eb32789, 0x3f8024c6, 0xbdbc6be5, 0xbfd6b4b6,
    0xbffe4fe7, 0x3f9b8f49, 0xbf915cf4, 0xbfbc4973,
    0x3dd23c24, 0x3f0a4ca1, 0x3dd23ac9, 0xbf5b82db,
    0xbf007e1b, 0x3f34bce4, 0x402a3ead, 0xc0958c4f,
    0x3f399ce8, 0xc013e3f8, 0x3fea8d7f, 0xbfdc6cee,
    0x3f104e1e, 0xbffcd8fb, 0xbf570177, 0xbe90ac07,
    0x4054bb39, 0x3ec3a776, 0xc02157b1, 0x3fc05ce3,
    0x401b7549, 0xbf9227e2, 0x3f04c5bc, 0x3f3397e5,
    0xc04873b3, 0xbf2656cc, 0xbf7108b5, 0x3fd7dab5,
    0x3f1fb92e, 0xbf2e1fd4, 0x4016074a, 0x3fec2586,
    0xbf1f7819, 0xbf951794, 0x3de2b1d1, 0x40262521,
    0xc01ba4a6, 0xbe8234ef, 0xbf5605c5, 0x3f87d076,
    0x3ffdfa30, 0xbf57c425, 0x3ca32a38, 0x3ef85270,
    0xbfc3b735, 0xbf0c4728, 0xbfff9d8f, 0xc083e54e,
    0x3fe802fe, 0xc046f753, 0x40af880b, 0xc001bcc2,
    0xbc961985, 0xbf97b57c, 0x3fbb05a1, 0xbfea70a5,
    0x3eb37774, 0x40532d77, 0x3fab901a, 0xbf0c6276,
    0xbf16f0e0, 0x3ee2f968, 0xbf8ac7cd, 0xbf430246,
    0x40344df8, 0x3eee9a03, 0xbe64e4c7, 0xbf98456c,
    0x3f1187ae, 0xbfdaed35, 0xbed4f4af, 0x3ea9b2f3,
    0x3f7a7846, 0xc0560248, 0x400a0571, 0xbebcb376,
    0x3ec0ee0d, 0x3eee577a, 0xbf084f41, 0xbdd43d11,
    0xbd1b942f, 0x3f7e5a8c, 0x4049d2e8, 0xbf2f473b,
    0xbe97ab16, 0x3f843ee9, 0x3f9ed93f, 0x4022dfc4,
    0x3f57a31b, 0xbfb2a0cb, 0x3fa78d8e, 0xbe62e66a,
    0x3da28b6a, 0xc01170d7, 0xc020ce62, 0xbdbc330b,
    0x4009bb4f, 0xc02baeb0, 0xc00ca842, 0x40371aaa,
    0xbfbffdf2, 0x402b5e67, 0xbfa12d9a, 0x3ddc6354,
    0x401880d7, 0x3fac3849, 0x3fd28c12, 0xbfde7b72,
    0x4039ad67, 0xc004a35e, 0xbf701928, 0xbf2b0499,
    0xbd9dd699, 0x4048bfb7, 0x406c1807, 0xbf83bbba,
    0x3ea9e30b, 0xbfe31099, 0xbfac1d89, 0x3e90a3dd,
    0x3fb77594, 0xbfebeca9, 0x3fc5b1c3, 0x401669d7,
    0xbf5b73ff, 0xbfa3fbcb, 0xbfca29d7, 0x3f831e2b,
    0x3f6d8f95, 0xc016d099, 0x3dbab4b6, 0xc01463b2,
    0x3eb856ed, 0xbf81128f, 0x3e2e078b, 0xbf407703,
    0xc0502350, 0x3dc5d895, 0xbfcf5ae5, 0xbfd09e15,
    0xbf461db8, 0x3fcaf7ad, 0xbf335652, 0x3faa7c33,
    0xbffba533, 0x3fdb724f, 0x3ff58f68, 0x3f86d48f,
    0xbfa16122, 0xbf3962eb, 0x3e920730, 0xc037ea34,
    0xbf7e97a9, 0xbcd084c3, 0x3fc24356, 0xbec25120,
    0xbf8f5f10, 0x405cba2a, 0xbef6dc35, 0x40469188,
    0xbfd043b7, 0xbd83729a, 0x3e83eaef, 0xbfbd6d96,
    0x3f8accab, 0xbf2afe77, 0x3f69a896, 0xbf5a11f3,
    0xbe9b8ed2, 0xc00d7d5a, 0xbed357ff, 0x3fda4a25,
    0xbe768cc5, 0x3f063cde, 0x4022c901, 0xbf833761,
    0x3e4f1172, 0x3fcde183, 0xbf9e9ec8, 0xbfae6923,
    0xc07fc0c6, 0x40299719, 0xbeb0c6f9, 0x3f942408,
    0x3fc98d30, 0xbf82eef4, 0x3e43ba45, 0xbde6f3fd,
    0x3f587c80, 0x3f60d9b9, 0x3f09336d, 0x4057c192,
    0xbf9a0896, 0x3f2f17ad, 0x3ee32b46, 0x3ef99b59,
    0xbea2924a, 0x3e225b6f, 0x401e66c1, 0x3e8349de,
    0xbf877b5f, 0x3f60d3de, 0x3ec6034d, 0xbffe6bdb,
    0xbe71b98c, 0xbf0f9ed9, 0xbf2643fb, 0xc030cde4,
    0xc019f820, 0x3cdc8446, 0x3e5711d3, 0x3c186058,
    0xbff04b25, 0x3f720018, 0x3f935a3d, 0x3fb751c6,
    0xbf6204cc, 0x3eb6959b, 0xbf5522a3, 0xbf41ca28,
    0xbf10c820, 0xbeebdad8, 0xbfcf03ac, 0xbed71a52,
    0x3e239ca5, 0x406021ae, 0xc06dae49, 0x3faff81e,
    0xbfe08ed3, 0x3f94771e, 0xbf619d26, 0xc07548df,
    0xbe2e91a4, 0x3f5ef274, 0xc0524561, 0xbed1688c,
    0x3f940748, 0x40433984, 0x3fe6ae6d, 0xbea9851f,
    0xbfd2c726, 0xbe6aed7e, 0xbf04f035, 0x3ee9babb,
    0xbe06190f, 0x3f0770dc, 0xbeecdc3e, 0x3f0cd1dc,
    0xc00c0259, 0xbfbafd28, 0x3fce52da, 0x3f7643f8,
    0x3fc8e378, 0xbffadca9, 0x3eb8ca1f, 0xbf5cc7c1,
    0x3fe54793, 0x3f8738c8, 0xbe5934b3, 0xbfadce5f,
    0x3f037fa0, 0x40172dda, 0xbf155829, 0xbfc17d96,
    0xbfc2435a, 0xc007ceef, 0xc0215d64, 0x4018831a,
    0x3f562469, 0x3f55e140, 0xbf417946, 0x3fd9af4c,
    0xbf71148e, 0x3f821663, 0xc013bd5c, 0xbfec1cd4,
    0xbf13505a, 0x3ffd040f, 0x3f2e18c4, 0x3f7d51ee,
    0x3dce5780, 0xbfd9c22c, 0x3fbe0364, 0x3f43c25b,
    0x3f920f42, 0xbf8fcbf9, 0x401068fd, 0xbfbaee7f,
    0x3dbd5763, 0xbe89ddd0, 0xbe1e1fba, 0xbed65dfb,
    0x3e4d4522, 0x3f439e2b, 0x3dc257d9, 0xbf2ee167,
    0x3ebd59a6, 0xbf79fe5c, 0xbfa2ac13, 0x3f8c1cbf,
    0x3f5ff53e, 0xbfbec96f, 0xc02b36bd, 0x3fade45c,
    0xbf74da5f, 0x3ead538a, 0x40562c40, 0xbeaf96cd,
    0xbf0c913f, 0x3ed15134, 0x40155457, 0xbf18924d,
    0x3fb14ffc, 0xbf6e65aa, 0xbf897572, 0xc069323d,
    0x3eb8bd8a, 0x3ff81af4, 0x400ac8ba, 0x3e1ea1c3,
    0x3f1c6be3, 0x3f7158e2, 0x39a5cae0, 0xc0129bd8,
    0xc01a489b, 0x3f505378, 0x400f5b4b, 0x3f8881f9,
    0x400948d4, 0xc00fd594, 0x3d1a6147, 0xbf18ca25,
    0xbff1ea29, 0xbef375fd, 0x3e5ae584, 0xbff06906,
    0xbfcbaee2, 0xbf7fb66f, 0x3f7e3901, 0x3f8d7228,
    0xc03b79ff, 0xbf923593, 0x3e04a7bd, 0xc03455e7,
    0xbeb0bcaf, 0x3f189bd7, 0x3f877a98, 0x40806c52,
    0x3e6f844b, 0x3f4f2767, 0x3f3a38af, 0x3fbd5737,
    0x3ed659fd, 0x3f746dfc, 0x40225182, 0xc0171f31,
    0xc0273574, 0xbea3283c, 0xbfedbb6b, 0xbf98d21e,
    0xbf45d4fc, 0x3f22c153, 0x3fc4afed, 0x3ea8651c,
    0xbf8984ab, 0xbedf1df4, 0xbdf72465, 0x3ffee182,
    0x3fcc36f8, 0xbf310faa, 0x3f5a1f52, 0xbf95ab21,
    0xbcb6f8d9, 0x4016e36e, 0xc0186c00, 0xc054c3d7,
    0x3e9d09ac, 0xc00c5bea, 0xbf2d0f44, 0x3f543764,
    0xbfb5f20e, 0x3d537807, 0xbfe21870, 0x3f28dafb,
    0x3fca22ef, 0x3feb467e, 0xc04f2e9c, 0x3f3ae222,
    0xbfdb82c1, 0xc01eb1e9, 0xbec0b569, 0xbfde906c,
    0xbe71ee9e, 0x40296e96, 0x3fc524ea, 0xbfa25123,
    0x3fd7bc83, 0x3e798f9b, 0xc03ac218, 0xbe0e0375,
    0xbf75876d, 0xbe052ad5, 0xc0993a13, 0x3fe6704e,
    0xbfcbb842, 0x3e658ab3, 0xbd324770, 0xbd8ec891,
    0x4005f789, 0xbfb89f1d, 0xbf3a2858, 0x3f106327,
    0xbdc6cc4d, 0xbe9a087a, 0x3fa20792, 0xc035dbd2,
    0xbfb430d4, 0xc022cc03, 0x3f874349, 0x3f345529,
    0x40056263, 0x405f248d, 0xbd97a2cc, 0x3f0d53c3,
    0x3e8bc498, 0x402d1f2c, 0xbf781ca8, 0x3fa55217,
    0x400d98eb, 0x3f68f244, 0x3febe677, 0xbfd56738,
    0xbfeaec2b, 0x3f4318ce, 0x3ff08f92, 0xbe7910bf,
    0x3e6db71c, 0x3f6a393f, 0x3fbb81f4, 0xbf31d284,
    0xbf1082bc, 0x3fa00dea, 0xbfa4b906, 0xbee003e9,
    0xbeca764f, 0xbe14fde6, 0x3f2f4bbe, 0x3f8c13ad,
    0x3f3e0f60, 0x3f4f9e49, 0x401a7cac, 0xbff3d0ee,
    0x402c1afc, 0xbfce468e, 0x3fa397b1, 0xbf33d435,
    0xc00e943a, 0xbf0f92a3, 0x402f4cdf, 0xbee3f426,
    0xbf30da45, 0x3e920097, 0x3df899dd, 0x3fbc6357,
    0x3f42841f, 0xbff11be9, 0x3fc4b71b, 0xbff76b31,
    0x3fe8dae7, 0x403a265d, 0xbec31aa4, 0xbf755774,
    0x3fb0746a, 0xbe14c836, 0x3e9491f9, 0x3e8c227e,
    0xbe8ba884, 0x3f67dbf5, 0x3fb6b354, 0xbf47f147,
    0x3e597ea8, 0xbf05355c, 0x3f2e4b45, 0x3ee2324c,
    0xbff4c9a6, 0x3fb51799, 0xbffe1b94, 0x3f2bfe59,
    0xc03da9b3, 0xbdb47be2, 0x3f9fbca8, 0x3f83c25e,
    0xbedc807f, 0x3f59e1ed, 0x40017be3, 0xc00b995f,
    0x3fe3ad8a, 0xbde98766, 0x3f512b4d, 0xbf7dba5e,
    0xbfc75a94, 0xbf8914dc, 0x3e56a3dc, 0xbf181cc7,
    0xc045d9d9, 0x3e4c7654, 0xbdfa6d69, 0xbf6af6b8,
    0xbf6a4444, 0x3f508d46, 0xbe6570c4, 0x3e791b85,
    0xbfd2b921, 0x3fda30dd, 0x3f82b88c, 0xbfc54d92,
    0x3f5bb3bb, 0x3f828ce0, 0x3fca92a7, 0xbf5d097a,
    0x3f301745, 0xbf91a0de, 0xc01f2509, 0xbfe2a17f,
    0x40244ccb, 0x3f75a3d8, 0x40783bf2, 0x3f58b9ee,
    0x3fd239b7, 0xbfbdc311, 0x3f771c47, 0x3fbaa8b8,
    0x3eee9025, 0x4058ae35, 0xbf9815ec, 0xbeaff718,
    0x3eaaef5c, 0xbc058f9e, 0x3f0570b7, 0x3face308,
    0x400f3d90, 0x3efdbe66, 0xbfa5292f, 0xbf31a5fa,
    0xbe399fc1, 0xbfad98ff, 0x401e9259, 0xbfb2384d,
    0x3de45379, 0x404f7f9f, 0xbfc328df, 0x3fb885f0,
    0x3f7f2fe2, 0xbea8e4a1, 0xc03b3c2f, 0xbf0626ee,
    0x3fe20908, 0x3f620780, 0x3eb25b90, 0xc003d3e2,
    0xbf8874eb, 0x3f55e00c, 0xbedcb238, 0xbe6624f1,
    0xbeabaeb9, 0xbf4cf712, 0x3e8f7b76, 0xbfd72068,
    0xbfd319c0, 0x3f8702b8, 0xc04bac13, 0x40509da1,
    0xbf2717d3, 0x3e044033, 0xc0b34694, 0x403137e0,
    0x3fcd2a71, 0xbf7c9d08, 0xbf5cfdc9, 0x3f548690,
    0x405c3052, 0x400b8290, 0xbfef948a, 0x3fc0132c,
    0x3ffcd2a6, 0x3f4144ca, 0x3feb4b0a, 0x3f84e223,
    0x3fe83a5a, 0xc0016fe7, 0x3d165d50, 0xbdd3c517,
    0x3eb69f4c, 0xc020cbad, 0xbf0a030e, 0x3fc50bc7,
    0xc042b2fd, 0x3f90a5a0, 0x40416fe7, 0x3f4460c8,
    0x40838d0a, 0xc0cfaa30, 0x3fee35e5, 0xbfd5138f,
    0x3dc705ba, 0xbf5b9648, 0xbc90455d, 0xbf847608,
    0x3ea0459b, 0xbeccb21d, 0x40097a53, 0xbf45267f,
    0x3ffcfa58, 0x3efdbe56, 0x3ffb70af, 0x3f30fc9c,
    0xbf8ccd7e, 0xc0792419, 0x406029c0, 0x3fe6dd1c,
    0xc084c23e, 0x40344546, 0x3f9e6f4e, 0xbef6f1b6,
    0xbe8c92af, 0x400b2215, 0xc025590a, 0xbff53dd5,
    0xbf75364c, 0x3f772c93, 0x3f88156f, 0x3fa89109,
    0xc019e3ac, 0x3fc251fa, 0xbcad74a2, 0x3f35f0c1,
    0x3e12ac11, 0x3f08ea78, 0x3f533728, 0xbf67940c,
    0x3e9b18ed, 0x3fc6fabb, 0x3fc6faa1, 0x404fd971,
    0x3f7b6a3a, 0xbf70bd70, 0xbee6a864, 0x3f5bf474,
    0xbea3b12f, 0xbe75fb47, 0x401d2774, 0xbf6135ca,
    0x402161eb, 0xbf23fdc8, 0xbf96e0b2, 0x3f72a69b,
    0xbe973142, 0xbfb686e4, 0x3e05046e, 0x40135173,
    0x3f55db5a, 0xbf8475de, 0x3f7bf4d6, 0x4033dd6f,
    0x3fe7462b, 0xbfcc7f46, 0xbe1bbcd1, 0x3e7e044b,
    0xbef49240, 0xbe9f9e7a, 0xbf072c0e, 0xbfbbf0a9,
    0x3c601b5c, 0xc0236339, 0x3f5257e5, 0x3eee43e8,
    0xbfa13e5c, 0xc00c0758, 0x3f2f6bbd, 0x3f161fb4,
    0xbf8c1c8b, 0x3fdbf572, 0xbf4970e8, 0xbfc8e41b,
    0x3eabcd91, 0x3e163465, 0xbf5b2272, 0x400fe1db,
    0xc04a02e7, 0x3f3e4536, 0x3fe16301, 0xbf417a44,
    0x3f2ec8c9, 0xbfd8e06e, 0x4005b412, 0x3fbaf9ae,
    0x3e645d38, 0x3f17a30f, 0xbedb82a2, 0xbef8d62f,
    0xbf0c6df5, 0xbf9a47b0, 0xbf8b9013, 0x3f77cc1b,
    0x3f241fea, 0x3f2d6bf7, 0xbf1c0970, 0x3e97fee6,
    0x3e79c35d, 0x3f2c5845, 0x3e3b798b, 0xbfa86d23,
    0xbf69ae45, 0xbf38b3e3, 0x3ee9e40b, 0xbfc244bf,
    0x3faf22e5, 0x3f42fbf2, 0x3fce10a8, 0x3ed71699,
    0xbf4c45e8, 0x3fe137c4, 0xbfc4082f, 0xc03c1b2e,
    0xc03be154, 0x4017dcb4, 0x3ebee933, 0xbf4d3169,
    0x3fa69e74, 0xbf5647c0, 0x3f9c7478, 0x3d92719c,
    0x3ef08202, 0x4006a243, 0xbfcc87ea, 0xbf735932,
    0xbfc36fef, 0x4013bea2, 0x3f6ac3ae, 0x3e7abe58,
    0x3f866a4f, 0x3e99d42e, 0x3ffa9748, 0xc068a225,
    0xc015f25e, 0xbfb16ff8, 0x3ed541fa, 0x402add0e,
    0x3d22c74f, 0x400a72d9, 0x3fdacacd, 0xbf844f6c,
    0x3e5fa5f2, 0xc00dfbf5, 0xbf394379, 0x3fd6eede,
    0x3fd2fd5f, 0x3eb945b3, 0x3fcfc25c, 0x3fc99158,
    0x40090a84, 0xbf0ab402, 0x402fbdd7, 0x409d2509,
    0xbf933168, 0xc0086cf1, 0xbfa99a76, 0xc04a8a26,
    0xbf83bcff, 0xbfe892a6, 0x3cf9f0c8, 0xc015624d,
    0x40647db3, 0x3e63c493, 0xbfcb15ca, 0xc03ae91f,
    0xc03683b6, 0xbfece094, 0x3efc2f5b, 0xbd99c8ec,
    0xbf9795e3, 0x3f4af43f, 0x3f1a5404, 0xbf2b19d1,
    0xc0618ea1, 0x3eb29560, 0x402a4294, 0x404fd34f,
    0xc027c76a, 0xc080f8ba, 0x3fa4c731, 0x3f49d8d1,
    0xbf825939, 0x3f8ca214, 0x4018f5d5, 0xbfaf94eb,
    0x3eb4abe4, 0xc00ba879, 0x3fc9840e, 0xbcb2206d,
    0xbfe8e513, 0xbfa1716f, 0xbffe0333, 0xbf680e74,
    0x3f1b7b6e, 0xbe8366ad, 0xc043f6ad, 0x405d4bc3,
    0xc032c62a, 0x3dbde640, 0xbe9b91f4, 0x4020b514,
    0x3e0822c4, 0x3f8644be, 0xbe50c4d8, 0xbfa7b379,
    0xbebb93a6, 0x3f1b06ad, 0xbda14275, 0xbf59f2a2,
    0x3fdeb2d0, 0x3f941e2c, 0x3e4adc02, 0x3fab636c,
    0x401c513c, 0x4039f394, 0x3f2a7892, 0xbf533701,
    0xbe31118c, 0xc02ab9cd, 0xbec66eed, 0x3e4fba9e,
    0xbf319764, 0x3d6885b1, 0x40255c8f, 0xbc8f8122,
    0x3f226793, 0xbdb13525, 0xbf2ef42a, 0x3f68c39c,
    0x3f4f11ae, 0xbeff0562, 0xbe5dbcf3, 0xbe9a77ee,
    0xbeb4ef00, 0x3fd0486e, 0xbf6a5eab, 0xbf881afb,
    0x3f836ecb, 0x4015e060, 0xbe6b016d, 0x407b1d0c,
    0x3fb66079, 0xbeafb693, 0x3f993c81, 0xbe6babc6,
    0xbf8a4740, 0xbfb31c08, 0x3fa89083, 0x3e5aa8f6,
    0x3a8d406c, 0x3fe68c4f, 0x3f1f84e2, 0x3e1cf5d9,
    0x3ea3ff7f, 0xc0623093, 0x3fa25ba4, 0x3f61e8b1,
    0xbf54a070, 0x402d3abe, 0xbee82d77, 0xbd223c2d,
    0x3e8ed009, 0xbfd61ecc, 0x40590bbd, 0xbeff0d00,
    0x3f670aea, 0x3f04b212, 0x3e373433, 0xbff63df1,
    0xbec873fb, 0xc01857de, 0x3ecbe027, 0x40093b83,
    0xc009ebbe, 0x3fd9eafa, 0xbeca66ac, 0x3ef7f927,
    0xbfc84ce9, 0xbfd06d69, 0x3f3718e7, 0xbf8630ca,
    0x3ed75b4b, 0xbe7896fa, 0x3f52681d, 0xbf3a2d63,
    0x407ea0de, 0x400ac427, 0x3fcea246, 0x3f5eb544,
    0xbfd9db13, 0xbe915b01, 0x3f84978f, 0xc0341d23,
    0xc01162b6, 0xc01fcfad, 0x400a3575, 0x3b31033a,
    0x403c77f5, 0xbfacb8fe, 0x3f429d2e, 0xbfb1e74a,
    0xbf6a3b4b, 0x3fbd55b7, 0x3eb2c0ed, 0xc051e4d0,
    0x3f0afa64, 0xbff399ec, 0x3f147eb1, 0x3f714fe2,
    0xbea7de35, 0x3f8d9978, 0x3ef50469, 0xbfcf570b,
    0xbfc0514f, 0x3f5557c1, 0x3f2e3731, 0x400b3df1,
    0xbf553438, 0xbdcabbbc, 0xbfe2770a, 0x3ee0a36e,
    0xbe0c7bf9, 0x3e948561, 0xbf467283, 0x3f8addc8,
    0xbd879895, 0x4037131d, 0x3fd21af9, 0x3f44555d,
    0x3dd1eb65, 0x3ef4eef7, 0x3fe916dd, 0x3efe7bb2,
    0x3f0a5163, 0x3fe02e30, 0x3ff65003, 0x3f4f4781,
    0xbdd73ff0, 0x3e25bdc3, 0x4022b111, 0xc007fdac,
    0x3fde8d41, 0xbfb2ce52, 0x3fda9267, 0x3eea8c7b,
    0x3f446b58, 0xbf40731e, 0xbed83b4e, 0x4012018a,
    0xc067e8e3, 0xbf892edd, 0xc06cf144, 0x3f7e0bf7,
    0x3ff6611d, 0xbf50542f, 0xc03e8152, 0xbfbf5dcb,
    0xbd21fbd3, 0xbf17d729, 0x3ffbe3cc, 0x3f16b2b4,
    0x408fef8f, 0xc03d32ee, 0xbf4f02b1, 0xc006721b,
    0xc02ddb18, 0x3f23b8af, 0xbfea7779, 0xbf8cd385,
    0xbf598676, 0x3ff72ea9, 0x400a22fb, 0x3f0f11de,
    0xbed8f66d, 0xc00994fc, 0xbf8b54e4, 0xbc616c29,
    0xbfe5c91a, 0x3f70e09e, 0x40090e2b, 0xbec802de,
    0x3f61ab85, 0x0, 0x40090e2b, 0x3ec802de,
    0xbfe5c91a, 0xbf70e09e, 0xbf8b54e4, 0x3c616c29,
    0xbed8f66d, 0x400994fc, 0x400a22fb, 0xbf0f11de,
    0xbf598676, 0xbff72ea9, 0xbfea7779, 0x3f8cd385,
    0xc02ddb18, 0xbf23b8af, 0xbf4f02b1, 0x4006721b,
    0x408fef8f, 0x403d32ee, 0x3ffbe3cc, 0xbf16b2b4,
    0xbd21fbd3, 0x3f17d729, 0xc03e8152, 0x3fbf5dcb,
    0x3ff6611d, 0x3f50542f, 0xc06cf144, 0xbf7e0bf7,
    0xc067e8e3, 0x3f892edd, 0xbed83b4e, 0xc012018a,
    0x3f446b58, 0x3f40731e, 0x3fda9267, 0xbeea8c7b,
    0x3fde8d41, 0x3fb2ce52, 0x4022b111, 0x4007fdac,
    0xbdd73ff0, 0xbe25bdc3, 0x3ff65003, 0xbf4f4781,
    0x3f0a5163, 0xbfe02e30, 0x3fe916dd, 0xbefe7bb2,
    0x3dd1eb65, 0xbef4eef7, 0x3fd21af9, 0xbf44555d,
    0xbd879895, 0xc037131d, 0xbf467283, 0xbf8addc8,
    0xbe0c7bf9, 0xbe948561, 0xbfe2770a, 0xbee0a36e,
    0xbf553438, 0x3dcabbbc, 0x3f2e3731, 0xc00b3df1,
    0xbfc0514f, 0xbf5557c1, 0x3ef50469, 0x3fcf570b,
    0xbea7de35, 0xbf8d9978, 0x3f147eb1, 0xbf714fe2,
    0x3f0afa64, 0x3ff399ec, 0x3eb2c0ed, 0x4051e4d0,
    0xbf6a3b4b, 0xbfbd55b7, 0x3f429d2e, 0x3fb1e74a,
    0x403c77f5, 0x3facb8fe, 0x400a3575, 0xbb31033a,
    0xc01162b6, 0x401fcfad, 0x3f84978f, 0x40341d23,
    0xbfd9db13, 0x3e915b01, 0x3fcea246, 0xbf5eb544,
    0x407ea0de, 0xc00ac427, 0x3f52681d, 0x3f3a2d63,
    0x3ed75b4b, 0x3e7896fa, 0x3f3718e7, 0x3f8630ca,
    0xbfc84ce9, 0x3fd06d69, 0xbeca66ac, 0xbef7f927,
    0xc009ebbe, 0xbfd9eafa, 0x3ecbe027, 0xc0093b83,
    0xbec873fb, 0x401857de, 0x3e373433, 0x3ff63df1,
    0x3f670aea, 0xbf04b212, 0x40590bbd, 0x3eff0d00,
    0x3e8ed009, 0x3fd61ecc, 0xbee82d77, 0x3d223c2d,
    0xbf54a070, 0xc02d3abe, 0x3fa25ba4, 0xbf61e8b1,
    0x3ea3ff7f, 0x40623093, 0x3f1f84e2, 0xbe1cf5d9,
    0x3a8d406c, 0xbfe68c4f, 0x3fa89083, 0xbe5aa8f6,
    0xbf8a4740, 0x3fb31c08, 0x3f993c81, 0x3e6babc6,
    0x3fb66079, 0x3eafb693, 0xbe6b016d, 0xc07b1d0c,
    0x3f836ecb, 0xc015e060, 0xbf6a5eab, 0x3f881afb,
    0xbeb4ef00, 0xbfd0486e, 0xbe5dbcf3, 0x3e9a77ee,
    0x3f4f11ae, 0x3eff0562, 0xbf2ef42a, 0xbf68c39c,
    0x3f226793, 0x3db13525, 0x40255c8f, 0x3c8f8122,
    0xbf319764, 0xbd6885b1, 0xbec66eed, 0xbe4fba9e,
    0xbe31118c, 0x402ab9cd, 0x3f2a7892, 0x3f533701,
    0x401c513c, 0xc039f394, 0x3e4adc02, 0xbfab636c,
    0x3fdeb2d0, 0xbf941e2c, 0xbda14275, 0x3f59f2a2,
    0xbebb93a6, 0xbf1b06ad, 0xbe50c4d8, 0x3fa7b379,
    0x3e0822c4, 0xbf8644be, 0xbe9b91f4, 0xc020b514,
    0xc032c62a, 0xbdbde640, 0xc043f6ad, 0xc05d4bc3,
    0x3f1b7b6e, 0x3e8366ad, 0xbffe0333, 0x3f680e74,
    0xbfe8e513, 0x3fa1716f, 0x3fc9840e, 0x3cb2206d,
    0x3eb4abe4, 0x400ba879, 0x4018f5d5, 0x3faf94eb,
    0xbf825939, 0xbf8ca214, 0x3fa4c731, 0xbf49d8d1,
    0xc027c76a, 0x4080f8ba, 0x402a4294, 0xc04fd34f,
    0xc0618ea1, 0xbeb29560, 0x3f1a5404, 0x3f2b19d1,
    0xbf9795e3, 0xbf4af43f, 0x3efc2f5b, 0x3d99c8ec,
    0xc03683b6, 0x3fece094, 0xbfcb15ca, 0x403ae91f,
    0x40647db3, 0xbe63c493, 0x3cf9f0c8, 0x4015624d,
    0xbf83bcff, 0x3fe892a6, 0xbfa99a76, 0x404a8a26,
    0xbf933168, 0x40086cf1, 0x402fbdd7, 0xc09d2509,
    0x40090a84, 0x3f0ab402, 0x3fcfc25c, 0xbfc99158,
    0x3fd2fd5f, 0xbeb945b3, 0xbf394379, 0xbfd6eede,
    0x3e5fa5f2, 0x400dfbf5, 0x3fdacacd, 0x3f844f6c,
    0x3d22c74f, 0xc00a72d9, 0x3ed541fa, 0xc02add0e,
    0xc015f25e, 0x3fb16ff8, 0x3ffa9748, 0x4068a225,
    0x3f866a4f, 0xbe99d42e, 0x3f6ac3ae, 0xbe7abe58,
    0xbfc36fef, 0xc013bea2, 0xbfcc87ea, 0x3f735932,
    0x3ef08202, 0xc006a243, 0x3f9c7478, 0xbd92719c,
    0x3fa69e74, 0x3f5647c0, 0x3ebee933, 0x3f4d3169,
    0xc03be154, 0xc017dcb4, 0xbfc4082f, 0x403c1b2e,
    0xbf4c45e8, 0xbfe137c4, 0x3fce10a8, 0xbed71699,
    0x3faf22e5, 0xbf42fbf2, 0x3ee9e40b, 0x3fc244bf,
    0xbf69ae45, 0x3f38b3e3, 0x3e3b798b, 0x3fa86d23,
    0x3e79c35d, 0xbf2c5845, 0xbf1c0970, 0xbe97fee6,
    0x3f241fea, 0xbf2d6bf7, 0xbf8b9013, 0xbf77cc1b,
    0xbf0c6df5, 0x3f9a47b0, 0xbedb82a2, 0x3ef8d62f,
    0x3e645d38, 0xbf17a30f, 0x4005b412, 0xbfbaf9ae,
    0x3f2ec8c9, 0x3fd8e06e, 0x3fe16301, 0x3f417a44,
    0xc04a02e7, 0xbf3e4536, 0xbf5b2272, 0xc00fe1db,
    0x3eabcd91, 0xbe163465, 0xbf4970e8, 0x3fc8e41b,
    0xbf8c1c8b, 0xbfdbf572, 0x3f2f6bbd, 0xbf161fb4,
    0xbfa13e5c, 0x400c0758, 0x3f5257e5, 0xbeee43e8,
    0x3c601b5c, 0x40236339, 0xbf072c0e, 0x3fbbf0a9,
    0xbef49240, 0x3e9f9e7a, 0xbe1bbcd1, 0xbe7e044b,
    0x3fe7462b, 0x3fcc7f46, 0x3f7bf4d6, 0xc033dd6f,
    0x3f55db5a, 0x3f8475de, 0x3e05046e, 0xc0135173,
    0xbe973142, 0x3fb686e4, 0xbf96e0b2, 0xbf72a69b,
    0x402161eb, 0x3f23fdc8, 0x401d2774, 0x3f6135ca,
    0xbea3b12f, 0x3e75fb47, 0xbee6a864, 0xbf5bf474,
    0x3f7b6a3a, 0x3f70bd70, 0x3fc6faa1, 0xc04fd971,
    0x3e9b18ed, 0xbfc6fabb, 0x3f533728, 0x3f67940c,
    0x3e12ac11, 0xbf08ea78, 0xbcad74a2, 0xbf35f0c1,
    0xc019e3ac, 0xbfc251fa, 0x3f88156f, 0xbfa89109,
    0xbf75364c, 0xbf772c93, 0xc025590a, 0x3ff53dd5,
    0xbe8c92af, 0xc00b2215, 0x3f9e6f4e, 0x3ef6f1b6,
    0xc084c23e, 0xc0344546, 0x406029c0, 0xbfe6dd1c,
    0xbf8ccd7e, 0x40792419, 0x3ffb70af, 0xbf30fc9c,
    0x3ffcfa58, 0xbefdbe56, 0x40097a53, 0x3f45267f,
    0x3ea0459b, 0x3eccb21d, 0xbc90455d, 0x3f847608,
    0x3dc705ba, 0x3f5b9648, 0x3fee35e5, 0x3fd5138f,
    0x40838d0a, 0x40cfaa30, 0x40416fe7, 0xbf4460c8,
    0xc042b2fd, 0xbf90a5a0, 0xbf0a030e, 0xbfc50bc7,
    0x3eb69f4c, 0x4020cbad, 0x3d165d50, 0x3dd3c517,
    0x3fe83a5a, 0x40016fe7, 0x3feb4b0a, 0xbf84e223,
    0x3ffcd2a6, 0xbf4144ca, 0xbfef948a, 0xbfc0132c,
    0x405c3052, 0xc00b8290, 0xbf5cfdc9, 0xbf548690,
    0x3fcd2a71, 0x3f7c9d08, 0xc0b34694, 0xc03137e0,
    0xbf2717d3, 0xbe044033, 0xc04bac13, 0xc0509da1,
    0xbfd319c0, 0xbf8702b8, 0x3e8f7b76, 0x3fd72068,
    0xbeabaeb9, 0x3f4cf712, 0xbedcb238, 0x3e6624f1,
    0xbf8874eb, 0xbf55e00c, 0x3eb25b90, 0x4003d3e2,
    0x3fe20908, 0xbf620780, 0xc03b3c2f, 0x3f0626ee,
    0x3f7f2fe2, 0x3ea8e4a1, 0xbfc328df, 0xbfb885f0,
    0x3de45379, 0xc04f7f9f, 0x401e9259, 0x3fb2384d,
    0xbe399fc1, 0x3fad98ff, 0xbfa5292f, 0x3f31a5fa,
    0x400f3d90, 0xbefdbe66, 0x3f0570b7, 0xbface308,
    0x3eaaef5c, 0x3c058f9e, 0xbf9815ec, 0x3eaff718,
    0x3eee9025, 0xc058ae35, 0x3f771c47, 0xbfbaa8b8,
    0x3fd239b7, 0x3fbdc311, 0x40783bf2, 0xbf58b9ee,
    0x40244ccb, 0xbf75a3d8, 0xc01f2509, 0x3fe2a17f,
    0x3f301745, 0x3f91a0de, 0x3fca92a7, 0x3f5d097a,
    0x3f5bb3bb, 0xbf828ce0, 0x3f82b88c, 0x3fc54d92,
    0xbfd2b921, 0xbfda30dd, 0xbe6570c4, 0xbe791b85,
    0xbf6a4444, 0xbf508d46, 0xbdfa6d69, 0x3f6af6b8,
    0xc045d9d9, 0xbe4c7654, 0x3e56a3dc, 0x3f181cc7,
    0xbfc75a94, 0x3f8914dc, 0x3f512b4d, 0x3f7dba5e,
    0x3fe3ad8a, 0x3de98766, 0x40017be3, 0x400b995f,
    0xbedc807f, 0xbf59e1ed, 0x3f9fbca8, 0xbf83c25e,
    0xc03da9b3, 0x3db47be2, 0xbffe1b94, 0xbf2bfe59,
    0xbff4c9a6, 0xbfb51799, 0x3f2e4b45, 0xbee2324c,
    0x3e597ea8, 0x3f05355c, 0x3fb6b354, 0x3f47f147,
    0xbe8ba884, 0xbf67dbf5, 0x3e9491f9, 0xbe8c227e,
    0x3fb0746a, 0x3e14c836, 0xbec31aa4, 0x3f755774,
    0x3fe8dae7, 0xc03a265d, 0x3fc4b71b, 0x3ff76b31,
    0x3f42841f, 0x3ff11be9, 0x3df899dd, 0xbfbc6357,
    0xbf30da45, 0xbe920097, 0x402f4cdf, 0x3ee3f426,
    0xc00e943a, 0x3f0f92a3, 0x3fa397b1, 0x3f33d435,
    0x402c1afc, 0x3fce468e, 0x401a7cac, 0x3ff3d0ee,
    0x3f3e0f60, 0xbf4f9e49, 0x3f2f4bbe, 0xbf8c13ad,
    0xbeca764f, 0x3e14fde6, 0xbfa4b906, 0x3ee003e9,
    0xbf1082bc, 0xbfa00dea, 0x3fbb81f4, 0x3f31d284,
    0x3e6db71c, 0xbf6a393f, 0x3ff08f92, 0x3e7910bf,
    0xbfeaec2b, 0xbf4318ce, 0x3febe677, 0x3fd56738,
    0x400d98eb, 0xbf68f244, 0xbf781ca8, 0xbfa55217,
    0x3e8bc498, 0xc02d1f2c, 0xbd97a2cc, 0xbf0d53c3,
    0x40056263, 0xc05f248d, 0x3f874349, 0xbf345529,
    0xbfb430d4, 0x4022cc03, 0x3fa20792, 0x4035dbd2,
    0xbdc6cc4d, 0x3e9a087a, 0xbf3a2858, 0xbf106327,
    0x4005f789, 0x3fb89f1d, 0xbd324770, 0x3d8ec891,
    0xbfcbb842, 0xbe658ab3, 0xc0993a13, 0xbfe6704e,
    0xbf75876d, 0x3e052ad5, 0xc03ac218, 0x3e0e0375,
    0x3fd7bc83, 0xbe798f9b, 0x3fc524ea, 0x3fa25123,
    0xbe71ee9e, 0xc0296e96, 0xbec0b569, 0x3fde906c,
    0xbfdb82c1, 0x401eb1e9, 0xc04f2e9c, 0xbf3ae222,
    0x3fca22ef, 0xbfeb467e, 0xbfe21870, 0xbf28dafb,
    0xbfb5f20e, 0xbd537807, 0xbf2d0f44, 0xbf543764,
    0x3e9d09ac, 0x400c5bea, 0xc0186c00, 0x4054c3d7,
    0xbcb6f8d9, 0xc016e36e, 0x3f5a1f52, 0x3f95ab21,
    0x3fcc36f8, 0x3f310faa, 0xbdf72465, 0xbffee182,
    0xbf8984ab, 0x3edf1df4, 0x3fc4afed, 0xbea8651c,
    0xbf45d4fc, 0xbf22c153, 0xbfedbb6b, 0x3f98d21e,
    0xc0273574, 0x3ea3283c, 0x40225182, 0x40171f31,
    0x3ed659fd, 0xbf746dfc, 0x3f3a38af, 0xbfbd5737,
    0x3e6f844b, 0xbf4f2767, 0x3f877a98, 0xc0806c52,
    0xbeb0bcaf, 0xbf189bd7, 0x3e04a7bd, 0x403455e7,
    0xc03b79ff, 0x3f923593, 0x3f7e3901, 0xbf8d7228,
    0xbfcbaee2, 0x3f7fb66f, 0x3e5ae584, 0x3ff06906,
    0xbff1ea29, 0x3ef375fd, 0x3d1a6147, 0x3f18ca25,
    0x400948d4, 0x400fd594, 0x400f5b4b, 0xbf8881f9,
    0xc01a489b, 0xbf505378, 0x39a5cae0, 0x40129bd8,
    0x3f1c6be3, 0xbf7158e2, 0x400ac8ba, 0xbe1ea1c3,
    0x3eb8bd8a, 0xbff81af4, 0xbf897572, 0x4069323d,
    0x3fb14ffc, 0x3f6e65aa, 0x40155457, 0x3f18924d,
    0xbf0c913f, 0xbed15134, 0x40562c40, 0x3eaf96cd,
    0xbf74da5f, 0xbead538a, 0xc02b36bd, 0xbfade45c,
    0x3f5ff53e, 0x3fbec96f, 0xbfa2ac13, 0xbf8c1cbf,
    0x3ebd59a6, 0x3f79fe5c, 0x3dc257d9, 0x3f2ee167,
    0x3e4d4522, 0xbf439e2b, 0xbe1e1fba, 0x3ed65dfb,
    0x3dbd5763, 0x3e89ddd0, 0x401068fd, 0x3fbaee7f,
    0x3f920f42, 0x3f8fcbf9, 0x3fbe0364, 0xbf43c25b,
    0x3dce5780, 0x3fd9c22c, 0x3f2e18c4, 0xbf7d51ee,
    0xbf13505a, 0xbffd040f, 0xc013bd5c, 0x3fec1cd4,
    0xbf71148e, 0xbf821663, 0xbf417946, 0xbfd9af4c,
    0x3f562469, 0xbf55e140, 0xc0215d64, 0xc018831a,
    0xbfc2435a, 0x4007ceef, 0xbf155829, 0x3fc17d96,
    0x3f037fa0, 0xc0172dda, 0xbe5934b3, 0x3fadce5f,
    0x3fe54793, 0xbf8738c8, 0x3eb8ca1f, 0x3f5cc7c1,
    0x3fc8e378, 0x3ffadca9, 0x3fce52da, 0xbf7643f8,
    0xc00c0259, 0x3fbafd28, 0xbeecdc3e, 0xbf0cd1dc,
    0xbe06190f, 0xbf0770dc, 0xbf04f035, 0xbee9babb,
    0xbfd2c726, 0x3e6aed7e, 0x3fe6ae6d, 0x3ea9851f,
    0x3f940748, 0xc0433984, 0xc0524561, 0x3ed1688c,
    0xbe2e91a4, 0xbf5ef274, 0xbf619d26, 0x407548df,
    0xbfe08ed3, 0xbf94771e, 0xc06dae49, 0xbfaff81e,
    0x3e239ca5, 0xc06021ae, 0xbfcf03ac, 0x3ed71a52,
    0xbf10c820, 0x3eebdad8, 0xbf5522a3, 0x3f41ca28,
    0xbf6204cc, 0xbeb6959b, 0x3f935a3d, 0xbfb751c6,
    0xbff04b25, 0xbf720018, 0x3e5711d3, 0xbc186058,
    0xc019f820, 0xbcdc8446, 0xbf2643fb, 0x4030cde4,
    0xbe71b98c, 0x3f0f9ed9, 0x3ec6034d, 0x3ffe6bdb,
    0xbf877b5f, 0xbf60d3de, 0x401e66c1, 0xbe8349de,
    0xbea2924a, 0xbe225b6f, 0x3ee32b46, 0xbef99b59,
    0xbf9a0896, 0xbf2f17ad, 0x3f09336d, 0xc057c192,
    0x3f587c80, 0xbf60d9b9, 0x3e43ba45, 0x3de6f3fd,
    0x3fc98d30, 0x3f82eef4, 0xbeb0c6f9, 0xbf942408,
    0xc07fc0c6, 0xc0299719, 0xbf9e9ec8, 0x3fae6923,
    0x3e4f1172, 0xbfcde183, 0x4022c901, 0x3f833761,
    0xbe768cc5, 0xbf063cde, 0xbed357ff, 0xbfda4a25,
    0xbe9b8ed2, 0x400d7d5a, 0x3f69a896, 0x3f5a11f3,
    0x3f8accab, 0x3f2afe77, 0x3e83eaef, 0x3fbd6d96,
    0xbfd043b7, 0x3d83729a, 0xbef6dc35, 0xc0469188,
    0xbf8f5f10, 0xc05cba2a, 0x3fc24356, 0x3ec25120,
    0xbf7e97a9, 0x3cd084c3, 0x3e920730, 0x4037ea34,
    0xbfa16122, 0x3f3962eb, 0x3ff58f68, 0xbf86d48f,
    0xbffba533, 0xbfdb724f, 0xbf335652, 0xbfaa7c33,
    0xbf461db8, 0xbfcaf7ad, 0xbfcf5ae5, 0x3fd09e15,
    0xc0502350, 0xbdc5d895, 0x3e2e078b, 0x3f407703,
    0x3eb856ed, 0x3f81128f, 0x3dbab4b6, 0x401463b2,
    0x3f6d8f95, 0x4016d099, 0xbfca29d7, 0xbf831e2b,
    0xbf5b73ff, 0x3fa3fbcb, 0x3fc5b1c3, 0xc01669d7,
    0x3fb77594, 0x3febeca9, 0xbfac1d89, 0xbe90a3dd,
    0x3ea9e30b, 0x3fe31099, 0x406c1807, 0x3f83bbba,
    0xbd9dd699, 0xc048bfb7, 0xbf701928, 0x3f2b0499,
    0x4039ad67, 0x4004a35e, 0x3fd28c12, 0x3fde7b72,
    0x401880d7, 0xbfac3849, 0xbfa12d9a, 0xbddc6354,
    0xbfbffdf2, 0xc02b5e67, 0xc00ca842, 0xc0371aaa,
    0x4009bb4f, 0x402baeb0, 0xc020ce62, 0x3dbc330b,
    0x3da28b6a, 0x401170d7, 0x3fa78d8e, 0x3e62e66a,
    0x3f57a31b, 0x3fb2a0cb, 0x3f9ed93f, 0xc022dfc4,
    0xbe97ab16, 0xbf843ee9, 0x4049d2e8, 0x3f2f473b,
    0xbd1b942f, 0xbf7e5a8c, 0xbf084f41, 0x3dd43d11,
    0x3ec0ee0d, 0xbeee577a, 0x400a0571, 0x3ebcb376,
    0x3f7a7846, 0x40560248, 0xbed4f4af, 0xbea9b2f3,
    0x3f1187ae, 0x3fdaed35, 0xbe64e4c7, 0x3f98456c,
    0x40344df8, 0xbeee9a03, 0xbf8ac7cd, 0x3f430246,
    0xbf16f0e0, 0xbee2f968, 0x3fab901a, 0x3f0c6276,
    0x3eb37774, 0xc0532d77, 0x3fbb05a1, 0x3fea70a5,
    0xbc961985, 0x3f97b57c, 0x40af880b, 0x4001bcc2,
    0x3fe802fe, 0x4046f753, 0xbfff9d8f, 0x4083e54e,
    0xbfc3b735, 0x3f0c4728, 0x3ca32a38, 0xbef85270,
    0x3ffdfa30, 0x3f57c425, 0xbf5605c5, 0xbf87d076,
    0xc01ba4a6, 0x3e8234ef, 0x3de2b1d1, 0xc0262521,
    0xbf1f7819, 0x3f951794, 0x4016074a, 0xbfec2586,
    0x3f1fb92e, 0x3f2e1fd4, 0xbf7108b5, 0xbfd7dab5,
    0xc04873b3, 0x3f2656cc, 0x3f04c5bc, 0xbf3397e5,
    0x401b7549, 0x3f9227e2, 0xc02157b1, 0xbfc05ce3,
    0x4054bb39, 0xbec3a776, 0xbf570177, 0x3e90ac07,
    0x3f104e1e, 0x3ffcd8fb, 0x3fea8d7f, 0x3fdc6cee,
    0x3f399ce8, 0x4013e3f8, 0x402a3ead, 0x40958c4f,
    0xbf007e1b, 0xbf34bce4, 0x3dd23ac9, 0x3f5b82db,
    0x3dd23c24, 0xbf0a4ca1, 0xbf915cf4, 0x3fbc4973,
    0xbffe4fe7, 0xbf9b8f49, 0xbdbc6be5, 0x3fd6b4b6,
    0x3eb32789, 0xbf8024c6, 0x3de250c3, 0x3f0d0384,
    0x3f3a0ccd, 0x4084cdcd, 0x3b0df3bf, 0x3ecaffd7,
    0xbf0a72ae, 0x3ea7177e, 0x3e0e045f, 0x3fc9106e,
    0xbfb463c3, 0x3e760961, 0xbf5be007, 0x3f5baae3,
    0x404da156, 0x3f751fc2, 0xbf64daf9, 0x40082405,
    0x3ee5bec9, 0x3f575a84, 0xbf14c80d, 0x40405dcb,
    0x3f2c995a, 0xbf9488b4, 0xbf6694cb, 0xbf498719,
    0xc0607f1b, 0x3f80748c, 0xbf68e661, 0xbfd1bb03,
    0xbf2e43ea, 0x3f474d22, 0x3fa052f9, 0x401b553e,
    0xbf2f63ed, 0x40165120, 0xbfdd8a2b, 0x3e4053f2,
    0x3fec944f, 0x3fcc1040, 0xbdbe0652, 0xc035cf26,
    0x3f5da605, 0xbf9528f3, 0xbf8f177f, 0x3e9b76e3,
    0xc0798022, 0x400c5db0, 0x3f5e74da, 0x3fc3fbfc,
    0xbfbb72d6, 0x3d33306f, 0x3dc1d8fd, 0x3e90638b,
    0x3c843299, 0xc081feb4, 0x401a2b73, 0xc0275358,
    0xc03638d2, 0xbff4ee7c, 0xbe9f7fa5, 0x3f9658db,
    0xbd82862d, 0x3f2eff20, 0x4013d467, 0x40533283,
    0xbfc314bb, 0xc06dd0fe, 0xbf9adb06, 0x3f732fa1,
    0xbe9d922a, 0x4020c12a, 0xbfac81d9, 0xbff347b1,
    0x3fa20817, 0xbf6583ee, 0xbfb7f94f, 0xc03f085b,
    0x3e8e1db5, 0x3f7f5248, 0xbedd432c, 0xc01ff96a,
    0x3fa9eea4, 0xbfbc9c38, 0x3fa4cb83, 0xbf9aceea,
    0x3f723b32, 0x3e0c31d9, 0xbf8ae347, 0x3f90e9d5,
    0x3e3595f2, 0xc0529366, 0x402ecf65, 0x401a86d8,
    0x3f37f354, 0x40153c4b, 0x3f889d9e, 0x3ea78711,
    0xbed671b3, 0xbe61a360, 0xbed2dce1, 0x3fa7a66f,
    0xbe86800a, 0x3ea3b42a, 0x4015b3ab, 0x3f153148,
    0x401513e1, 0x3fc075ea, 0x3ee21d71, 0xbf850e2a,
    0xbf53c798, 0x3eb2eed6, 0xbe1fb95d, 0x3f4859e9,
    0x3ed9f2ac, 0x3f642048, 0x3f8db381, 0x3fed12e4,
    0xc0454fc6, 0xbf8e7a60, 0xc00f5107, 0x3f14515b,
    0x3ed30cc0, 0xbeeee64b, 0xbf827ae1, 0x3fda3873,
    0xbf855756, 0xbf905934, 0xbddd218e, 0xbee37f5d,
    0x404d9e09, 0x3c880588, 0x40198e0c, 0x3fcc9e51,
    0x3ff5d0ee, 0x3eab3524, 0xbf23c1ba, 0xbec13e04,
    0xbfe43051, 0x4011d3ff, 0xc020767d, 0x3f90ea85,
    0x3ffc60fd, 0x3de9b746, 0xbfdb567e, 0x3f78790e,
    0x3c21f487, 0xc0024a58, 0xc0119dc0, 0x3fb919e7,
    0x3f786f30, 0x3d318f38, 0x404b4d49, 0xbff1ddb6,
    0xc0069ddd, 0xbdf7b897, 0xbf38102a, 0xc035b808,
    0x4018df54, 0x401b81da, 0x406c5565, 0xbfa4de9f,
    0x3f16efc7, 0x3ee07d91, 0xbe4fac93, 0xc02985b6,
    0xc04923cd, 0xbf91ad95, 0xbf187dfd, 0xbfb91421,
    0xbfb98ebf, 0x4040ba6a, 0x3ffee406, 0x3f388b1c,
    0x3f0a9f5d, 0x4000c5d6, 0xbcca3e48, 0x3f8ecb86,
    0xbf80e323, 0x3f9634e0, 0xc05d6138, 0xbf588359,
    0xbf135fcd, 0xbfe413f0, 0xc0559c8a, 0x3fdde875,
    0x3f25c7fb, 0xbf03ec72, 0xbf5f7de6, 0xbf830703,
    0xc00da842, 0xbf2108e8, 0x3fa56200, 0xbf6d4057,
    0xbf3cad23, 0x3f86592b, 0x3d973cfc, 0xbe31cdab,
    0x3fb75b7d, 0xbf81a7df, 0xc01b4176, 0xbfafd76d,
    0x3f0e52a1, 0x3f8fc2a9, 0x3e89fc37, 0x3fb7537c,
    0xbfda9e08, 0xbe2373e5, 0x400caa59, 0x3fd71022,
    0x3e1ec28b, 0xc0567d60, 0x3faa7b78, 0xbf5df707,
    0xbbf43cd4, 0x3e3128f3, 0xbf12db6f, 0xbf76f78c,
    0x4002eb41, 0xbfb3e34c, 0x3fe8c08d, 0x3f8023ad,
    0x4024a336, 0x3fcd3d45, 0xbfa37e8a, 0xbfdf0d14,
    0x3f2e63e3, 0xbd13cbee, 0xbf1fba56, 0xbf626b7e,
    0x402de9c1, 0x3e4a82ae, 0x401a3a13, 0x3f8b26ba,
    0x3e028720, 0x3eed2fe6, 0x3f3c0e6b, 0xbf0bbe56,
    0xc083b19c, 0x3fe753db, 0x3ee11290, 0x3ff548f7,
    0x3ea19a7d, 0x3f461269, 0x3f569ce1, 0x3f6eda6f,
    0xbfdc9b00, 0xbfa06f80, 0x3fa9ed53, 0x3fcaa213,
    0x3fb35f4d, 0xbf3dca75, 0xbf370cec, 0x3fad3fe2,
    0x3f3a5f6f, 0xbef2a743, 0xbfb360cd, 0xbf1b1fa7,
    0xc062f5b3, 0x3f1f71ff, 0xc00421b0, 0xbd7db4ee,
    0x3f7c3c61, 0x3edff63d, 0x3f5c25a7, 0xc017168f,
    0xbf57b8c4, 0x4001aac5, 0x4082e832, 0xbf8525f0,
    0x3fc07c38, 0x3f8164b9, 0x3f535236, 0xbed45599,
    0x4008225a, 0x3ed8ad46, 0x3fd6569b, 0x3fe9b6db,
    0x403d9baa, 0x3de68cf2, 0x3f96a547, 0xbfd7b802,
    0xc0026154, 0xbec940c8, 0x405ea87c, 0x3ebfbe1d,
    0x3f026ac0, 0xbf634c67, 0x3f9aaf43, 0xbfad522f,
    0xc024bae5, 0x3f816f97, 0xbf4ad85c, 0x403513ca,
    0x3f674f68, 0x3ec3c39b, 0xbf597a34, 0x3e8d66b0,
    0x4014c8e0, 0xbfa01d9e, 0x3f471543, 0xbed9c5ec,
    0x3e52406b, 0xbfd20154, 0xbc083a55, 0x4009e565,
    0x3e974288, 0xbf93dee8, 0xc07340bf, 0xbf42d587,
    0x3fff2566, 0xbfc3a812, 0xbfbd53a8, 0xbfe88ec4,
    0xbf203bd7, 0x3f582feb, 0x403dfab3, 0x3f5e7129,
    0x40288066, 0x400494d7, 0xbfb2f018, 0xbe4be41f,
    0xbe2cb815, 0x3faa0ab4, 0x3d8e529c, 0xbf74b7c5,
    0xbf87a187, 0x401b410f, 0xbf670219, 0xbf763d5f,
    0x3fb9d9f7, 0x3f963952, 0xbe29e6a0, 0xc0475636,
    0xbff30a30, 0x40000f0a, 0xbf3d869b, 0x3f460ffd,
    0x3fec42ac, 0x3e87478d, 0x3fcbcb97, 0x3e9a6ef9,
    0xc0711bc7, 0xbf958d4b, 0x3f631e4b, 0xbf28885d,
    0xbe056f23, 0xbf399c51, 0x3eaa0bdf, 0xbf8c3c5c,
    0xbff6b8ad, 0x3f0fa55b, 0x3fcf0305, 0xbfc1f799,
    0xbe063524, 0xbf1da1b9, 0xbe993a51, 0x3fd91c67,
    0x4039f47e, 0x401ecdd1, 0xbe666ab2, 0x402ac6e3,
    0xc02ef00d, 0x3fcf5969, 0x3f5bb3cb, 0x3f2749d0,
    0x3ebffc0e, 0xbf8e31cb, 0xbf9eff77, 0x4041b0f9,
    0x3f05702a, 0x3fd8221e, 0x4017dbb0, 0xbfea979f,
    0x3f7a5687, 0xbfe7442d, 0x3fc49334, 0x3e84fc95,
    0xbfd62dfd, 0x3fc836ca, 0xbfb32b42, 0xbf302a06,
    0xbfbd83ba, 0xbf821a1c, 0xbff5048a, 0xbdae2c5c,
    0xbf94488b, 0xbf44ee1c, 0xbfefa1f2, 0x3fdf094e,
    0x3eff66d3, 0x400fe882, 0xbfd84738, 0x3e788614,
    0xbff55828, 0xbfe4eb54, 0x3e7b5323, 0x3fdeccc9,
    0xc005d8e7, 0x3fc01991, 0x3f440b0b, 0xbe4a4081,
    0xbf7176c0, 0xbf0052dc, 0x3f50c2f0, 0x402a2d69,
    0xbf841e06, 0x3dfe4f53, 0xc012b2ae, 0x3f0db0be,
    0x3f8dc07f, 0x4012bf14, 0xbfebe6b2, 0xc01c306c,
    0xbf25c57d, 0xbe6a73b8, 0xbf8d8891, 0x4022d6cf,
    0xbe90feae, 0x4009f082, 0xc0554a66, 0x3d34e0d4,
    0xc0048a74, 0x3f586cef, 0x400141d8, 0xbf626c07,
    0x3f384052, 0xbf0aa83d, 0xbec457e8, 0xbf6514e3,
    0x3fbeab0e, 0x3ebaa2b9, 0xbf9ec090, 0xbf9b61a0,
    0xbf8d0f14, 0x3e5e862b, 0xbf4fcd51, 0xc0006144,
    0xbfcdf6de, 0xbf6f1802, 0x40326ab1, 0xbeab9db4,
    0x3fdddfbd, 0xc01d3520, 0xbeb58361, 0x40712202,
    0x3f049e55, 0x3f407ebc, 0x400f6400, 0xbf903e5a,
    0x3cd83004, 0x3f572dad, 0xbe8cebfe, 0x3feacf73,
    0x3fff0f18, 0xbf98a6b9, 0x3f4e2795, 0x3f965ffa,
    0x3f4e1b41, 0x40044db4, 0xbfff9ff0, 0x3ef7397a,
    0x3fd613ca, 0xbf89d9e4, 0xbefd6b8b, 0xbf79d67f,
    0xbebf0b57, 0x3f5f9fe6, 0xc00e8779, 0x4004875f,
    0xbf034184, 0xc04d5f51, 0x3fcc3be1, 0xbdab150e,
    0xbe8682c1, 0x3ff69b22, 0xbed1f1f4, 0x3fdd6605,
    0x3ee12b94, 0xc04ff1e4, 0x3eafc818, 0xbeb30faa,
    0x3f5d71b1, 0xbfedbf7a, 0xbe9a4465, 0x3d6982ff,
    0x3e8b3d3c, 0xbfd293d3, 0x3f030b6a, 0xc02a251b,
    0x3f4a3a35, 0x3e3ccdd5, 0x3f13cedc, 0xbefa2db1,
    0xbf75d76e, 0x3e8b76e1, 0x3f760a1b, 0xbf582c34,
    0xbf4283f0, 0xbfb7b72e, 0xc04300ab, 0x3ebaf3b2,
    0xbf2e9742, 0xbf9f91b2, 0x3d93145f, 0xbc7f782d,
    0xbe13d2a6, 0x3fce9cfc, 0x4058250d, 0xc0237dca,
    0xbfbdaf4a, 0xbfdce738, 0x3fbbd4a5, 0x3f2ffe0e,
    0x3f805581, 0x3e959024, 0xbfc15db8, 0x3f1ce75b,
    0xbfcc969d, 0xc01631be, 0xbf936d49, 0x40a92dc0,
    0x3faa8055, 0xbfe8a9c1, 0x3f64c1dd, 0x3dbdcc3f,
    0x4021caf3, 0xbfd94fa2, 0xbdbdc3a0, 0xbffc61bb,
    0xbf6bf578, 0xc07e827b, 0xbed07bf9, 0xbf95b0b0,
    0x3f179a6f, 0x4433540f, 0xc048ef01, 0xbfbdd983,
    0x3e88b8a1, 0x4037e478, 0x3f044ee4, 0x400afa05,
    0x3fd3fcf0, 0x3f85cacc, 0xbf05197b, 0x3fba1fc9,
    0xbf2a9eb2, 0x4010f5a8, 0x3d9746ec, 0xc033874c,
    0x3e3ae281, 0xc07c018c, 0x3fd4388a, 0xbfdcfd50,
    0xbeb7bd37, 0xbf893f37, 0xbf92127c, 0xbfbb2714,
    0xbe81e4ef, 0xbf1038cd, 0x40200bb6, 0x3f6c18a7,
    0x3ea30c78, 0x4044909b, 0xbdce52c4, 0xbeea4c06,
    0xbf13de2b, 0x3d833bfb, 0x3f97352e, 0x3f8b8199,
    0x3f6ce08a, 0xbc80696c, 0x3f900a36, 0x3faeae42,
    0x3fe274e1, 0x3f2daf51, 0x400229e9, 0x3fc8481d,
    0x3fd73b1d, 0xbfb77e44, 0x3f2909c3, 0x3f8aa8f3,
    0x3fa2cf6f, 0x3eaa0c31, 0x3e8be9e8, 0xc029ef63,
    0xbf8418d3, 0xbf9d3ba7, 0xc0059b73, 0xbfaa1e2a,
    0xbfe74c3d, 0x3fc16ddd, 0xbf80da6a, 0xbebae27b,
    0x3f5e709c, 0x3ff92e4d, 0xbfd37d35, 0x3fb47fff,
    0xc019b041, 0xbf98d079, 0xbf3916d1, 0xc02506cb,
    0xbfd31b51, 0x3e75d513, 0x3e9b3707, 0x3ec4dd11,
    0x3f83a3df, 0xbfab52ef, 0x3fb05954, 0xbf49f13e,
    0xbf65818e, 0x3d1c614e, 0x3f3e13ce, 0xbfbdbf8e,
    0x3f1b8752, 0xbebc58ac, 0x3f54d5c6, 0x3e59093a,
    0x400e8ed6, 0x40291107, 0xc02723a0, 0x3f8bc3af,
    0x402145d6, 0xbffd5f6e, 0xc01357bd, 0x3ed55aca,
    0x3feab870, 0xbf622be7, 0xbd232839, 0xbf2f85da,
    0xbe7ef5b6, 0xbf4ea2b6, 0xbeaf9c5a, 0x3ff532f9,
    0x4010463b, 0xbfec5f0e, 0x3f4c7263, 0x3f55b29a,
    0x40222590, 0x3fe2ceba, 0xc05a95ca, 0xbd9297b2,
    0xc01ec4d3, 0xbf0b1485, 0xbfdecde8, 0xbfc85583,
    0x3f5b05c8, 0xc018622e, 0x3ed15f34, 0xbfba6e07,
    0x401af01f, 0xc03cd243, 0x3ff96f21, 0x400f61aa,
    0xbf7a6659, 0xbfd9d958, 0x4006756b, 0x3fbcf278,
    0x3c13773b, 0x3dc2b7a0, 0xbfefc159, 0x3fa651c5,
    0xbfb84989, 0xbf3d8b56, 0xbe9b07ae, 0x3ff53982,
    0xbfaa7cdf, 0x3fa41de7, 0xbe880772, 0x3fd62a6c,
    0xbe01d205, 0xbf890b81, 0xbfe712c6, 0x402309d3,
    0x3e8248a7, 0xc0125c96, 0xbecae915, 0x3ed2f6df,
    0xbfb70a02, 0x404fe8b3, 0xbf2741b4, 0xbfbbdbe1,
    0xbf582497, 0x3fb97af2, 0x3ecc02e0, 0x3ee25083,
    0xbfacbe81, 0x3f148d5b, 0xbded5ebb, 0x3f03ed6a,
    0xbf68d99c, 0x3f826f16, 0x3f74ca02, 0xbe72263a,
    0x3f62cc55, 0xbf3f4bf5, 0x3fcfb9e2, 0x3f4b502d,
    0xbe4b9a5e, 0x3f8d15b9, 0xbf00df2f, 0xbf1f5dc4,
    0x400a6eeb, 0xbf288fbe, 0xc037da65, 0x3f01b7d3,
    0x3f86b093, 0x3f1dbb4f, 0x3f94cc4c, 0xc0117bbb,
    0x3fa88e7d, 0xc06a31c2, 0x3f6871db, 0x4024b7d8,
    0xc025f5cd, 0xc08c0479, 0x40166fb7, 0xbeea456f,
    0xbdf749ef, 0x3fd33112, 0x3e7fe430, 0x3f3b1bf4,
    0x3ed89026, 0x3ceeaf7e, 0x406d9e30, 0x3f7c3903,
    0x3fc18e19, 0xbdfbc4e4, 0xbf0bb3fe, 0xbf6f65d1,
    0xc024e58d, 0xc000625a, 0x3dc70214, 0xbf87065d,
    0xc024b552, 0xbf5df8a0, 0x3f2f12da, 0xbf85724e,
    0x3f52acf9, 0x4007554a, 0xbf2cd545, 0x3f90663a,
    0xbec01527, 0x3f4d1c3b, 0xbebda6bf, 0xbdd1765f,
    0xbfbd54c4, 0x403af0b1, 0x3f7221a6, 0xbf8cac50,
    0xbf814ac5, 0xbf1e23d4, 0xbf7a580f, 0x3d07cb54,
    0xbf50f007, 0x3fddac68, 0xc027de37, 0x3f87a1f4,
    0x3eb51aac, 0xbf3bcfd3, 0xbfc3353d, 0x4054448e,
    0xc039d103, 0x3fbd0e36, 0xbf992a27, 0xc06047d4,
    0xbfcb047a, 0x3fa59e6d, 0xbffe220d, 0xbf994a26,
    0x3f070af6, 0x4059fc3f, 0xbf5b3dbf, 0x3fea14d1,
    0x4016449a, 0xc01b406b, 0x3fa28334, 0x3e9dc57a,
    0xbf2cd028, 0x3ec69262, 0x3ef86790, 0xbf92fb09,
    0x3b1d39f6, 0x3f5d48fd, 0x3ff8f5a3, 0x3eb4a174,
    0xbff0f848, 0xbf2596e5, 0x3fec8d70, 0xbf870772,
    0x3d86fb46, 0xbf2a3e7e, 0xbf726849, 0x3f7cfdd3,
    0x3fc95966, 0x3f16b4a5, 0xbed90db7, 0xbf09cda9,
    0x3fad51ae, 0x404bd717, 0x3f1e5a6d, 0x4016efc6,
    0x4020ca9b, 0x3d0cc93f, 0x3e84e3ad, 0x3f03bba1,
    0x4029b476, 0xc0349c72, 0xbfb99a34, 0x400aff61,
    0xbf997a66, 0xbfcc6dbf, 0xbdb83ae0, 0x404f83fc,
    0x3e87470c, 0x3deaccc1, 0xbfbaa2d2, 0x3eadca26,
    0x3f3be000, 0x4007903f, 0xbf456937, 0xbeab2c5e,
    0xbf60ddc3, 0x3f9d00f1, 0xbf8cd4b3, 0xbe7e64e5,
    0xbf8d554e, 0xbf69a4b3, 0x4009c927, 0xbf282958,
    0x3fb89891, 0x3df8c964, 0xbffaba82, 0x3e3468d7,
    0x3f839536, 0x402d10de, 0xbe4ac0de, 0x3f74d307,
    0x3e2fa3a5, 0xbf970ba1, 0x3fd9356b, 0xbf099a15,
    0xc0227e0e, 0x40809c31, 0xc0408765, 0x408f0542,
    0x3fa5d65b, 0x3f91ba4a, 0xbed3b592, 0xbf305428,
    0xbf281321, 0xbe813bc8, 0xbed8b171, 0x405baf96,
    0x3eec69cd, 0x400201d4, 0x3ee00258, 0x407f4d0a,
    0x3fdafcd9, 0x3fc40b99, 0xbfcfa984, 0x3f35b9e4,
    0xbf0268af, 0xc008f4a3, 0x4017d4fe, 0xc04132d8,
    0xbf87efa8, 0xbed44c22, 0x3f850f53, 0x3f5b7b3a,
    0x3f7d0a97, 0xbf6e85ad, 0x3e7274c7, 0x3fb09e1e,
    0xbf2d75e3, 0xbfb46bf9, 0x4062e984, 0x3eb687f8,
    0xc08d3ba8, 0xbf6b0bfc, 0xc077c794, 0x3fd19f58,
    0xbf199a7e, 0x409a3eb4, 0x3dc1d960, 0xbef319f1,
    0xbf54dc39, 0x3f398a7e, 0xc00cea1b, 0x3f568c6d,
    0xbf531a6f, 0xbecdaa46, 0x3d9fb0c2, 0xbd9f9ff9,
    0x3f1c8550, 0xc048670f, 0xbfe6c5a7, 0x405a4ac1,
    0xbfb6bd81, 0x40156ded, 0xbf5ad1ae, 0xbf974faa,
    0x3ed66da3, 0xbdef1967, 0xbf01fdd7, 0x4051c6b3,
    0x401d0257, 0xc000ed0e, 0xbf028bc5, 0x3ebddd1b,
    0x3e9586ea, 0xbefabd24, 0x3efe7528, 0x3ef00bab,
    0xbef67dab, 0x402b753d, 0xbfa2e653, 0xbd9cce21,
    0x3f0d54c8, 0xbfda4a6c, 0xc0812fc3, 0xc0022a08,
    0xbfec815d, 0xc0515e47, 0x3fcdd640, 0xbf6153a4,
    0x3f8ca112, 0xbf4a3dbd, 0xc082e678, 0xbe328dea,
    0xbfff0651, 0x3f08445d, 0x40019857, 0xbfb538cd,
    0xbf9e361b, 0xbdd0f36b, 0xbfe9bdae, 0x3e0d3ca2,
    0xbef4e29e, 0x3f2d1b4c, 0x3f8bce5a, 0x3f31ae35,
    0x3e78bde0, 0xc004bd1c, 0x3eaa0ffc, 0x3e210919,
    0x402f2e99, 0xc0271067, 0xc015efc6, 0xbec7c235,
    0xc0017bfd, 0x3fe839d2, 0xc0506953, 0xbfe451f8,
    0x3fe066f2, 0x4070a368, 0x3f17b110, 0xc0284e6f,
    0x400a0930, 0x3fa827e8, 0x3faadf1f, 0xc009947d,
    0xc00cb6a2, 0x40566d4c, 0x3f9752e2, 0x3fa4539e,
    0xbf49e705, 0xbf6d68ae, 0x3e8901e1, 0xbf5af910,
    0x3f2c0762, 0xbe5e11a5, 0x3f9c2210, 0x3e2a41e8,
    0x3f4ae8df, 0x3e3a0c49, 0x3eef8a06, 0x40457f4b,
    0x3fb757f6, 0xbf6d43e4, 0x3e3bc47e, 0xbfe19272,
    0xbfbba3f4, 0xc09d1ad5, 0x3e260c7f, 0x3f4e6787,
    0x3ebb8dc4, 0x3fe92335, 0xbe9aa52f, 0xbf537e35,
    0xbfb95584, 0x3efbcd20, 0x3e5d5328, 0x3f20ec95,
    0xbfcb1700, 0xbfefc537, 0xbe693fae, 0xbd7c6210,
    0xbf70e6fc, 0xbfe11e63, 0x3f331f64, 0x3f5141d0,
    0xc0303516, 0x3e1c147c, 0x406e4fd3, 0x3f797d5b,
    0x40226305, 0x3eb15efb, 0x40472f9d, 0xc0231545,
    0xbf604823, 0x3fc83a17, 0xbfd0da8d, 0x3ff5c6cf,
    0x3dc29426, 0xc0283b29, 0xbf77aaba, 0xbe73e5b3,
    0xbf521414, 0x3fb2362a, 0x3f7f21e2, 0xbf06c8fe,
    0x3efa8afd, 0xbfb25301, 0x3ed02dd6, 0x3f884571,
    0x3f244007, 0xbf635949, 0xbfe81a6c, 0x401e1d6e,
    0x3eb3e454, 0xbc6c2c04, 0xbe8a6858, 0x400467ea,
    0x402d0e47, 0x3ef630e1, 0x3fc37d33, 0x3fdd69d0,
    0xbe9a4913, 0x3ec74d71, 0xbf719dcd, 0x3f5130e3,
    0x3f2081fd, 0x3ebd5d99, 0xbfabf6af, 0xc048596c
    };

static const uint32_t ref_cfft_noisy_2048[4096] = {
    0xc0a02ec6, 0x0, 0xbfabf6af, 0x4048596c,
    0x3f2081fd, 0xbebd5d99, 0xbf719dcd, 0xbf5130e3,
    0xbe9a4913, 0xbec74d71, 0x3fc37d33, 0xbfdd69d0,
    0x402d0e47, 0xbef630e1, 0xbe8a6858, 0xc00467ea,
    0x3eb3e454, 0x3c6c2c04, 0xbfe81a6c, 0xc01e1d6e,
    0x3f244007, 0x3f635949, 0x3ed02dd6, 0xbf884571,
    0x3efa8afd, 0x3fb25301, 0x3f7f21e2, 0x3f06c8fe,
    0xbf521414, 0xbfb2362a, 0xbf77aaba, 0x3e73e5b3,
    0x3dc29426, 0x40283b29, 0xbfd0da8d, 0xbff5c6cf,
    0xbf604823, 0xbfc83a17, 0x40472f9d, 0x40231545,
    0x40226305, 0xbeb15efb, 0x406e4fd3, 0xbf797d5b,
    0xc0303516, 0xbe1c147c, 0x3f331f64, 0xbf5141d0,
    0xbf70e6fc, 0x3fe11e63, 0xbe693fae, 0x3d7c6210,
    0xbfcb1700, 0x3fefc537, 0x3e5d5328, 0xbf20ec95,
    0xbfb95584, 0xbefbcd20, 0xbe9aa52f, 0x3f537e35,
    0x3ebb8dc4, 0xbfe92335, 0x3e260c7f, 0xbf4e6787,
    0xbfbba3f4, 0x409d1ad5, 0x3e3bc47e, 0x3fe19272,
    0x3fb757f6, 0x3f6d43e4, 0x3eef8a06, 0xc0457f4b,
    0x3f4ae8df, 0xbe3a0c49, 0x3f9c2210, 0xbe2a41e8,
    0x3f2c0762, 0x3e5e11a5, 0x3e8901e1, 0x3f5af910,
    0xbf49e705, 0x3f6d68ae, 0x3f9752e2, 0xbfa4539e,
    0xc00cb6a2, 0xc0566d4c, 0x3faadf1f, 0x4009947d,
    0x400a0930, 0xbfa827e8, 0x3f17b110, 0x40284e6f,
    0x3fe066f2, 0xc070a368, 0xc0506953, 0x3fe451f8,
    0xc0017bfd, 0xbfe839d2, 0xc015efc6, 0x3ec7c235,
    0x402f2e99, 0x40271067, 0x3eaa0ffc, 0xbe210919,
    0x3e78bde0, 0x4004bd1c, 0x3f8bce5a, 0xbf31ae35,
    0xbef4e29e, 0xbf2d1b4c, 0xbfe9bdae, 0xbe0d3ca2,
    0xbf9e361b, 0x3dd0f36b, 0x40019857, 0x3fb538cd,
    0xbfff0651, 0xbf08445d, 0xc082e678, 0x3e328dea,
    0x3f8ca112, 0x3f4a3dbd, 0x3fcdd640, 0x3f6153a4,
    0xbfec815d, 0x40515e47, 0xc0812fc3, 0x40022a08,
    0x3f0d54c8, 0x3fda4a6c, 0xbfa2e653, 0x3d9cce21,
    0xbef67dab, 0xc02b753d, 0x3efe7528, 0xbef00bab,
    0x3e9586ea, 0x3efabd24, 0xbf028bc5, 0xbebddd1b,
    0x401d0257, 0x4000ed0e, 0xbf01fdd7, 0xc051c6b3,
    0x3ed66da3, 0x3def1967, 0xbf5ad1ae, 0x3f974faa,
    0xbfb6bd81, 0xc0156ded, 0xbfe6c5a7, 0xc05a4ac1,
    0x3f1c8550, 0x4048670f, 0x3d9fb0c2, 0x3d9f9ff9,
    0xbf531a6f, 0x3ecdaa46, 0xc00cea1b, 0xbf568c6d,
    0xbf54dc39, 0xbf398a7e, 0x3dc1d960, 0x3ef319f1,
    0xbf199a7e, 0xc09a3eb4, 0xc077c794, 0xbfd19f58,
    0xc08d3ba8, 0x3f6b0bfc, 0x4062e984, 0xbeb687f8,
    0xbf2d75e3, 0x3fb46bf9, 0x3e7274c7, 0xbfb09e1e,
    0x3f7d0a97, 0x3f6e85ad, 0x3f850f53, 0xbf5b7b3a,
    0xbf87efa8, 0x3ed44c22, 0x4017d4fe, 0x404132d8,
    0xbf0268af, 0x4008f4a3, 0xbfcfa984, 0xbf35b9e4,
    0x3fdafcd9, 0xbfc40b99, 0x3ee00258, 0xc07f4d0a,
    0x3eec69cd, 0xc00201d4, 0xbed8b171, 0xc05baf96,
    0xbf281321, 0x3e813bc8, 0xbed3b592, 0x3f305428,
    0x3fa5d65b, 0xbf91ba4a, 0xc0408765, 0xc08f0542,
    0xc0227e0e, 0xc0809c31, 0x3fd9356b, 0x3f099a15,
    0x3e2fa3a5, 0x3f970ba1, 0xbe4ac0de, 0xbf74d307,
    0x3f839536, 0xc02d10de, 0xbffaba82, 0xbe3468d7,
    0x3fb89891, 0xbdf8c964, 0x4009c927, 0x3f282958,
    0xbf8d554e, 0x3f69a4b3, 0xbf8cd4b3, 0x3e7e64e5,
    0xbf60ddc3, 0xbf9d00f1, 0xbf456937, 0x3eab2c5e,
    0x3f3be000, 0xc007903f, 0xbfbaa2d2, 0xbeadca26,
    0x3e87470c, 0xbdeaccc1, 0xbdb83ae0, 0xc04f83fc,
    0xbf997a66, 0x3fcc6dbf, 0xbfb99a34, 0xc00aff61,
    0x4029b476, 0x40349c72, 0x3e84e3ad, 0xbf03bba1,
    0x4020ca9b, 0xbd0cc93f, 0x3f1e5a6d, 0xc016efc6,
    0x3fad51ae, 0xc04bd717, 0xbed90db7, 0x3f09cda9,
    0x3fc95966, 0xbf16b4a5, 0xbf726849, 0xbf7cfdd3,
    0x3d86fb46, 0x3f2a3e7e, 0x3fec8d70, 0x3f870772,
    0xbff0f848, 0x3f2596e5, 0x3ff8f5a3, 0xbeb4a174,
    0x3b1d39f6, 0xbf5d48fd, 0x3ef86790, 0x3f92fb09,
    0xbf2cd028, 0xbec69262, 0x3fa28334, 0xbe9dc57a,
    0x4016449a, 0x401b406b, 0xbf5b3dbf, 0xbfea14d1,
    0x3f070af6, 0xc059fc3f, 0xbffe220d, 0x3f994a26,
    0xbfcb047a, 0xbfa59e6d, 0xbf992a27, 0x406047d4,
    0xc039d103, 0xbfbd0e36, 0xbfc3353d, 0xc054448e,
    0x3eb51aac, 0x3f3bcfd3, 0xc027de37, 0xbf87a1f4,
    0xbf50f007, 0xbfddac68, 0xbf7a580f, 0xbd07cb54,
    0xbf814ac5, 0x3f1e23d4, 0x3f7221a6, 0x3f8cac50,
    0xbfbd54c4, 0xc03af0b1, 0xbebda6bf, 0x3dd1765f,
    0xbec01527, 0xbf4d1c3b, 0xbf2cd545, 0xbf90663a,
    0x3f52acf9, 0xc007554a, 0x3f2f12da, 0x3f85724e,
    0xc024b552, 0x3f5df8a0, 0x3dc70214, 0x3f87065d,
    0xc024e58d, 0x4000625a, 0xbf0bb3fe, 0x3f6f65d1,
    0x3fc18e19, 0x3dfbc4e4, 0x406d9e30, 0xbf7c3903,
    0x3ed89026, 0xbceeaf7e, 0x3e7fe430, 0xbf3b1bf4,
    0xbdf749ef, 0xbfd33112, 0x40166fb7, 0x3eea456f,
    0xc025f5cd, 0x408c0479, 0x3f6871db, 0xc024b7d8,
    0x3fa88e7d, 0x406a31c2, 0x3f94cc4c, 0x40117bbb,
    0x3f86b093, 0xbf1dbb4f, 0xc037da65, 0xbf01b7d3,
    0x400a6eeb, 0x3f288fbe, 0xbf00df2f, 0x3f1f5dc4,
    0xbe4b9a5e, 0xbf8d15b9, 0x3fcfb9e2, 0xbf4b502d,
    0x3f62cc55, 0x3f3f4bf5, 0x3f74ca02, 0x3e72263a,
    0xbf68d99c, 0xbf826f16, 0xbded5ebb, 0xbf03ed6a,
    0xbfacbe81, 0xbf148d5b, 0x3ecc02e0, 0xbee25083,
    0xbf582497, 0xbfb97af2, 0xbf2741b4, 0x3fbbdbe1,
    0xbfb70a02, 0xc04fe8b3, 0xbecae915, 0xbed2f6df,
    0x3e8248a7, 0x40125c96, 0xbfe712c6, 0xc02309d3,
    0xbe01d205, 0x3f890b81, 0xbe880772, 0xbfd62a6c,
    0xbfaa7cdf, 0xbfa41de7, 0xbe9b07ae, 0xbff53982,
    0xbfb84989, 0x3f3d8b56, 0xbfefc159, 0xbfa651c5,
    0x3c13773b, 0xbdc2b7a0, 0x4006756b, 0xbfbcf278,
    0xbf7a6659, 0x3fd9d958, 0x3ff96f21, 0xc00f61aa,
    0x401af01f, 0x403cd243, 0x3ed15f34, 0x3fba6e07,
    0x3f5b05c8, 0x4018622e, 0xbfdecde8, 0x3fc85583,
    0xc01ec4d3, 0x3f0b1485, 0xc05a95ca, 0x3d9297b2,
    0x40222590, 0xbfe2ceba, 0x3f4c7263, 0xbf55b29a,
    0x4010463b, 0x3fec5f0e, 0xbeaf9c5a, 0xbff532f9,
    0xbe7ef5b6, 0x3f4ea2b6, 0xbd232839, 0x3f2f85da,
    0x3feab870, 0x3f622be7, 0xc01357bd, 0xbed55aca,
    0x402145d6, 0x3ffd5f6e, 0xc02723a0, 0xbf8bc3af,
    0x400e8ed6, 0xc0291107, 0x3f54d5c6, 0xbe59093a,
    0x3f1b8752, 0x3ebc58ac, 0x3f3e13ce, 0x3fbdbf8e,
    0xbf65818e, 0xbd1c614e, 0x3fb05954, 0x3f49f13e,
    0x3f83a3df, 0x3fab52ef, 0x3e9b3707, 0xbec4dd11,
    0xbfd31b51, 0xbe75d513, 0xbf3916d1, 0x402506cb,
    0xc019b041, 0x3f98d079, 0xbfd37d35, 0xbfb47fff,
    0x3f5e709c, 0xbff92e4d, 0xbf80da6a, 0x3ebae27b,
    0xbfe74c3d, 0xbfc16ddd, 0xc0059b73, 0x3faa1e2a,
    0xbf8418d3, 0x3f9d3ba7, 0x3e8be9e8, 0x4029ef63,
    0x3fa2cf6f, 0xbeaa0c31, 0x3f2909c3, 0xbf8aa8f3,
    0x3fd73b1d, 0x3fb77e44, 0x400229e9, 0xbfc8481d,
    0x3fe274e1, 0xbf2daf51, 0x3f900a36, 0xbfaeae42,
    0x3f6ce08a, 0x3c80696c, 0x3f97352e, 0xbf8b8199,
    0xbf13de2b, 0xbd833bfb, 0xbdce52c4, 0x3eea4c06,
    0x3ea30c78, 0xc044909b, 0x40200bb6, 0xbf6c18a7,
    0xbe81e4ef, 0x3f1038cd, 0xbf92127c, 0x3fbb2714,
    0xbeb7bd37, 0x3f893f37, 0x3fd4388a, 0x3fdcfd50,
    0x3e3ae281, 0x407c018c, 0x3d9746ec, 0x4033874c,
    0xbf2a9eb2, 0xc010f5a8, 0xbf05197b, 0xbfba1fc9,
    0x3fd3fcf0, 0xbf85cacc, 0x3f044ee4, 0xc00afa05,
    0x3e88b8a1, 0xc037e478, 0xc048ef01, 0x3fbdd983,
    0x3f179a6f, 0xc433540f, 0xbed07bf9, 0x3f95b0b0,
    0xbf6bf578, 0x407e827b, 0xbdbdc3a0, 0x3ffc61bb,
    0x4021caf3, 0x3fd94fa2, 0x3f64c1dd, 0xbdbdcc3f,
    0x3faa8055, 0x3fe8a9c1, 0xbf936d49, 0xc0a92dc0,
    0xbfcc969d, 0x401631be, 0xbfc15db8, 0xbf1ce75b,
    0x3f805581, 0xbe959024, 0x3fbbd4a5, 0xbf2ffe0e,
    0xbfbdaf4a, 0x3fdce738, 0x4058250d, 0x40237dca,
    0xbe13d2a6, 0xbfce9cfc, 0x3d93145f, 0x3c7f782d,
    0xbf2e9742, 0x3f9f91b2, 0xc04300ab, 0xbebaf3b2,
    0xbf4283f0, 0x3fb7b72e, 0x3f760a1b, 0x3f582c34,
    0xbf75d76e, 0xbe8b76e1, 0x3f13cedc, 0x3efa2db1,
    0x3f4a3a35, 0xbe3ccdd5, 0x3f030b6a, 0x402a251b,
    0x3e8b3d3c, 0x3fd293d3, 0xbe9a4465, 0xbd6982ff,
    0x3f5d71b1, 0x3fedbf7a, 0x3eafc818, 0x3eb30faa,
    0x3ee12b94, 0x404ff1e4, 0xbed1f1f4, 0xbfdd6605,
    0xbe8682c1, 0xbff69b22, 0x3fcc3be1, 0x3dab150e,
    0xbf034184, 0x404d5f51, 0xc00e8779, 0xc004875f,
    0xbebf0b57, 0xbf5f9fe6, 0xbefd6b8b, 0x3f79d67f,
    0x3fd613ca, 0x3f89d9e4, 0xbfff9ff0, 0xbef7397a,
    0x3f4e1b41, 0xc0044db4, 0x3f4e2795, 0xbf965ffa,
    0x3fff0f18, 0x3f98a6b9, 0xbe8cebfe, 0xbfeacf73,
    0x3cd83004, 0xbf572dad, 0x400f6400, 0x3f903e5a,
    0x3f049e55, 0xbf407ebc, 0xbeb58361, 0xc0712202,
    0x3fdddfbd, 0x401d3520, 0x40326ab1, 0x3eab9db4,
    0xbfcdf6de, 0x3f6f1802, 0xbf4fcd51, 0x40006144,
    0xbf8d0f14, 0xbe5e862b, 0xbf9ec090, 0x3f9b61a0,
    0x3fbeab0e, 0xbebaa2b9, 0xbec457e8, 0x3f6514e3,
    0x3f384052, 0x3f0aa83d, 0x400141d8, 0x3f626c07,
    0xc0048a74, 0xbf586cef, 0xc0554a66, 0xbd34e0d4,
    0xbe90feae, 0xc009f082, 0xbf8d8891, 0xc022d6cf,
    0xbf25c57d, 0x3e6a73b8, 0xbfebe6b2, 0x401c306c,
    0x3f8dc07f, 0xc012bf14, 0xc012b2ae, 0xbf0db0be,
    0xbf841e06, 0xbdfe4f53, 0x3f50c2f0, 0xc02a2d69,
    0xbf7176c0, 0x3f0052dc, 0x3f440b0b, 0x3e4a4081,
    0xc005d8e7, 0xbfc01991, 0x3e7b5323, 0xbfdeccc9,
    0xbff55828, 0x3fe4eb54, 0xbfd84738, 0xbe788614,
    0x3eff66d3, 0xc00fe882, 0xbfefa1f2, 0xbfdf094e,
    0xbf94488b, 0x3f44ee1c, 0xbff5048a, 0x3dae2c5c,
    0xbfbd83ba, 0x3f821a1c, 0xbfb32b42, 0x3f302a06,
    0xbfd62dfd, 0xbfc836ca, 0x3fc49334, 0xbe84fc95,
    0x3f7a5687, 0x3fe7442d, 0x4017dbb0, 0x3fea979f,
    0x3f05702a, 0xbfd8221e, 0xbf9eff77, 0xc041b0f9,
    0x3ebffc0e, 0x3f8e31cb, 0x3f5bb3cb, 0xbf2749d0,
    0xc02ef00d, 0xbfcf5969, 0xbe666ab2, 0xc02ac6e3,
    0x4039f47e, 0xc01ecdd1, 0xbe993a51, 0xbfd91c67,
    0xbe063524, 0x3f1da1b9, 0x3fcf0305, 0x3fc1f799,
    0xbff6b8ad, 0xbf0fa55b, 0x3eaa0bdf, 0x3f8c3c5c,
    0xbe056f23, 0x3f399c51, 0x3f631e4b, 0x3f28885d,
    0xc0711bc7, 0x3f958d4b, 0x3fcbcb97, 0xbe9a6ef9,
    0x3fec42ac, 0xbe87478d, 0xbf3d869b, 0xbf460ffd,
    0xbff30a30, 0xc0000f0a, 0xbe29e6a0, 0x40475636,
    0x3fb9d9f7, 0xbf963952, 0xbf670219, 0x3f763d5f,
    0xbf87a187, 0xc01b410f, 0x3d8e529c, 0x3f74b7c5,
    0xbe2cb815, 0xbfaa0ab4, 0xbfb2f018, 0x3e4be41f,
    0x40288066, 0xc00494d7, 0x403dfab3, 0xbf5e7129,
    0xbf203bd7, 0xbf582feb, 0xbfbd53a8, 0x3fe88ec4,
    0x3fff2566, 0x3fc3a812, 0xc07340bf, 0x3f42d587,
    0x3e974288, 0x3f93dee8, 0xbc083a55, 0xc009e565,
    0x3e52406b, 0x3fd20154, 0x3f471543, 0x3ed9c5ec,
    0x4014c8e0, 0x3fa01d9e, 0xbf597a34, 0xbe8d66b0,
    0x3f674f68, 0xbec3c39b, 0xbf4ad85c, 0xc03513ca,
    0xc024bae5, 0xbf816f97, 0x3f9aaf43, 0x3fad522f,
    0x3f026ac0, 0x3f634c67, 0x405ea87c, 0xbebfbe1d,
    0xc0026154, 0x3ec940c8, 0x3f96a547, 0x3fd7b802,
    0x403d9baa, 0xbde68cf2, 0x3fd6569b, 0xbfe9b6db,
    0x4008225a, 0xbed8ad46, 0x3f535236, 0x3ed45599,
    0x3fc07c38, 0xbf8164b9, 0x4082e832, 0x3f8525f0,
    0xbf57b8c4, 0xc001aac5, 0x3f5c25a7, 0x4017168f,
    0x3f7c3c61, 0xbedff63d, 0xc00421b0, 0x3d7db4ee,
    0xc062f5b3, 0xbf1f71ff, 0xbfb360cd, 0x3f1b1fa7,
    0x3f3a5f6f, 0x3ef2a743, 0xbf370cec, 0xbfad3fe2,
    0x3fb35f4d, 0x3f3dca75, 0x3fa9ed53, 0xbfcaa213,
    0xbfdc9b00, 0x3fa06f80, 0x3f569ce1, 0xbf6eda6f,
    0x3ea19a7d, 0xbf461269, 0x3ee11290, 0xbff548f7,
    0xc083b19c, 0xbfe753db, 0x3f3c0e6b, 0x3f0bbe56,
    0x3e028720, 0xbeed2fe6, 0x401a3a13, 0xbf8b26ba,
    0x402de9c1, 0xbe4a82ae, 0xbf1fba56, 0x3f626b7e,
    0x3f2e63e3, 0x3d13cbee, 0xbfa37e8a, 0x3fdf0d14,
    0x4024a336, 0xbfcd3d45, 0x3fe8c08d, 0xbf8023ad,
    0x4002eb41, 0x3fb3e34c, 0xbf12db6f, 0x3f76f78c,
    0xbbf43cd4, 0xbe3128f3, 0x3faa7b78, 0x3f5df707,
    0x3e1ec28b, 0x40567d60, 0x400caa59, 0xbfd71022,
    0xbfda9e08, 0x3e2373e5, 0x3e89fc37, 0xbfb7537c,
    0x3f0e52a1, 0xbf8fc2a9, 0xc01b4176, 0x3fafd76d,
    0x3fb75b7d, 0x3f81a7df, 0x3d973cfc, 0x3e31cdab,
    0xbf3cad23, 0xbf86592b, 0x3fa56200, 0x3f6d4057,
    0xc00da842, 0x3f2108e8, 0xbf5f7de6, 0x3f830703,
    0x3f25c7fb, 0x3f03ec72, 0xc0559c8a, 0xbfdde875,
    0xbf135fcd, 0x3fe413f0, 0xc05d6138, 0x3f588359,
    0xbf80e323, 0xbf9634e0, 0xbcca3e48, 0xbf8ecb86,
    0x3f0a9f5d, 0xc000c5d6, 0x3ffee406, 0xbf388b1c,
    0xbfb98ebf, 0xc040ba6a, 0xbf187dfd, 0x3fb91421,
    0xc04923cd, 0x3f91ad95, 0xbe4fac93, 0x402985b6,
    0x3f16efc7, 0xbee07d91, 0x406c5565, 0x3fa4de9f,
    0x4018df54, 0xc01b81da, 0xbf38102a, 0x4035b808,
    0xc0069ddd, 0x3df7b897, 0x404b4d49, 0x3ff1ddb6,
    0x3f786f30, 0xbd318f38, 0xc0119dc0, 0xbfb919e7,
    0x3c21f487, 0x40024a58, 0xbfdb567e, 0xbf78790e,
    0x3ffc60fd, 0xbde9b746, 0xc020767d, 0xbf90ea85,
    0xbfe43051, 0xc011d3ff, 0xbf23c1ba, 0x3ec13e04,
    0x3ff5d0ee, 0xbeab3524, 0x40198e0c, 0xbfcc9e51,
    0x404d9e09, 0xbc880588, 0xbddd218e, 0x3ee37f5d,
    0xbf855756, 0x3f905934, 0xbf827ae1, 0xbfda3873,
    0x3ed30cc0, 0x3eeee64b, 0xc00f5107, 0xbf14515b,
    0xc0454fc6, 0x3f8e7a60, 0x3f8db381, 0xbfed12e4,
    0x3ed9f2ac, 0xbf642048, 0xbe1fb95d, 0xbf4859e9,
    0xbf53c798, 0xbeb2eed6, 0x3ee21d71, 0x3f850e2a,
    0x401513e1, 0xbfc075ea, 0x4015b3ab, 0xbf153148,
    0xbe86800a, 0xbea3b42a, 0xbed2dce1, 0xbfa7a66f,
    0xbed671b3, 0x3e61a360, 0x3f889d9e, 0xbea78711,
    0x3f37f354, 0xc0153c4b, 0x402ecf65, 0xc01a86d8,
    0x3e3595f2, 0x40529366, 0xbf8ae347, 0xbf90e9d5,
    0x3f723b32, 0xbe0c31d9, 0x3fa4cb83, 0x3f9aceea,
    0x3fa9eea4, 0x3fbc9c38, 0xbedd432c, 0x401ff96a,
    0x3e8e1db5, 0xbf7f5248, 0xbfb7f94f, 0x403f085b,
    0x3fa20817, 0x3f6583ee, 0xbfac81d9, 0x3ff347b1,
    0xbe9d922a, 0xc020c12a, 0xbf9adb06, 0xbf732fa1,
    0xbfc314bb, 0x406dd0fe, 0x4013d467, 0xc0533283,
    0xbd82862d, 0xbf2eff20, 0xbe9f7fa5, 0xbf9658db,
    0xc03638d2, 0x3ff4ee7c, 0x401a2b73, 0x40275358,
    0x3c843299, 0x4081feb4, 0x3dc1d8fd, 0xbe90638b,
    0xbfbb72d6, 0xbd33306f, 0x3f5e74da, 0xbfc3fbfc,
    0xc0798022, 0xc00c5db0, 0xbf8f177f, 0xbe9b76e3,
    0x3f5da605, 0x3f9528f3, 0xbdbe0652, 0x4035cf26,
    0x3fec944f, 0xbfcc1040, 0xbfdd8a2b, 0xbe4053f2,
    0xbf2f63ed, 0xc0165120, 0x3fa052f9, 0xc01b553e,
    0xbf2e43ea, 0xbf474d22, 0xbf68e661, 0x3fd1bb03,
    0xc0607f1b, 0xbf80748c, 0xbf6694cb, 0x3f498719,
    0x3f2c995a, 0x3f9488b4, 0xbf14c80d, 0xc0405dcb,
    0x3ee5bec9, 0xbf575a84, 0xbf64daf9, 0xc0082405,
    0x404da156, 0xbf751fc2, 0xbf5be007, 0xbf5baae3,
    0xbfb463c3, 0xbe760961, 0x3e0e045f, 0xbfc9106e,
    0xbf0a72ae, 0xbea7177e, 0x3b0df3bf, 0xbecaffd7,
    0x3f3a0ccd, 0xc084cdcd, 0x3de250c3, 0xbf0d0384,
    0x3eb32789, 0x3f8024c6, 0xbdbc6be5, 0xbfd6b4b6,
    0xbffe4fe7, 0x3f9b8f49, 0xbf915cf4, 0xbfbc4973,
    0x3dd23c24, 0x3f0a4ca1, 0x3dd23ac9, 0xbf5b82db,
    0xbf007e1b, 0x3f34bce4, 0x402a3ead, 0xc0958c4f,
    0x3f399ce8, 0xc013e3f8, 0x3fea8d7f, 0xbfdc6cee,
    0x3f104e1e, 0xbffcd8fb, 0xbf570177, 0xbe90ac07,
    0x4054bb39, 0x3ec3a776, 0xc02157b1, 0x3fc05ce3,
    0x401b7549, 0xbf9227e2, 0x3f04c5bc, 0x3f3397e5,
    0xc04873b3, 0xbf2656cc, 0xbf7108b5, 0x3fd7dab5,
    0x3f1fb92e, 0xbf2e1fd4, 0x4016074a, 0x3fec2586,
    0xbf1f7819, 0xbf951794, 0x3de2b1d1, 0x40262521,
    0xc01ba4a6, 0xbe8234ef, 0xbf5605c5, 0x3f87d076,
    0x3ffdfa30, 0xbf57c425, 0x3ca32a38, 0x3ef85270,
    0xbfc3b735, 0xbf0c4728, 0xbfff9d8f, 0xc083e54e,
    0x3fe802fe, 0xc046f753, 0x40af880b, 0xc001bcc2,
    0xbc961985, 0xbf97b57c, 0x3fbb05a1, 0xbfea70a5,
    0x3eb37774, 0x40532d77, 0x3fab901a, 0xbf0c6276,
    0xbf16f0e0, 0x3ee2f968, 0xbf8ac7cd, 0xbf430246,
    0x40344df8, 0x3eee9a03, 0xbe64e4c7, 0xbf98456c,
    0x3f1187ae, 0xbfdaed35, 0xbed4f4af, 0x3ea9b2f3,
    0x3f7a7846, 0xc0560248, 0x400a0571, 0xbebcb376,
    0x3ec0ee0d, 0x3eee577a, 0xbf084f41, 0xbdd43d11,
    0xbd1b942f, 0x3f7e5a8c, 0x4049d2e8, 0xbf2f473b,
    0xbe97ab16, 0x3f843ee9, 0x3f9ed93f, 0x4022dfc4,
    0x3f57a31b, 0xbfb2a0cb, 0x3fa78d8e, 0xbe62e66a,
    0x3da28b6a, 0xc01170d7, 0xc020ce62, 0xbdbc330b,
    0x4009bb4f, 0xc02baeb0, 0xc00ca842, 0x40371aaa,
    0xbfbffdf2, 0x402b5e67, 0xbfa12d9a, 0x3ddc6354,
    0x401880d7, 0x3fac3849, 0x3fd28c12, 0xbfde7b72,
    0x4039ad67, 0xc004a35e, 0xbf701928, 0xbf2b0499,
    0xbd9dd699, 0x4048bfb7, 0x406c1807, 0xbf83bbba,
    0x3ea9e30b, 0xbfe31099, 0xbfac1d89, 0x3e90a3dd,
    0x3fb77594, 0xbfebeca9, 0x3fc5b1c3, 0x401669d7,
    0xbf5b73ff, 0xbfa3fbcb, 0xbfca29d7, 0x3f831e2b,
    0x3f6d8f95, 0xc016d099, 0x3dbab4b6, 0xc01463b2,
    0x3eb856ed, 0xbf81128f, 0x3e2e078b, 0xbf407703,
    0xc0502350, 0x3dc5d895, 0xbfcf5ae5, 0xbfd09e15,
    0xbf461db8, 0x3fcaf7ad, 0xbf335652, 0x3faa7c33,
    0xbffba533, 0x3fdb724f, 0x3ff58f68, 0x3f86d48f,
    0xbfa16122, 0xbf3962eb, 0x3e920730, 0xc037ea34,
    0xbf7e97a9, 0xbcd084c3, 0x3fc24356, 0xbec25120,
    0xbf8f5f10, 0x405cba2a, 0xbef6dc35, 0x40469188,
    0xbfd043b7, 0xbd83729a, 0x3e83eaef, 0xbfbd6d96,
    0x3f8accab, 0xbf2afe77, 0x3f69a896, 0xbf5a11f3,
    0xbe9b8ed2, 0xc00d7d5a, 0xbed357ff, 0x3fda4a25,
    0xbe768cc5, 0x3f063cde, 0x4022c901, 0xbf833761,
    0x3e4f1172, 0x3fcde183, 0xbf9e9ec8, 0xbfae6923,
    0xc07fc0c6, 0x40299719, 0xbeb0c6f9, 0x3f942408,
    0x3fc98d30, 0xbf82eef4, 0x3e43ba45, 0xbde6f3fd,
    0x3f587c80, 0x3f60d9b9, 0x3f09336d, 0x4057c192,
    0xbf9a0896, 0x3f2f17ad, 0x3ee32b46, 0x3ef99b59,
    0xbea2924a, 0x3e225b6f, 0x401e66c1, 0x3e8349de,
    0xbf877b5f, 0x3f60d3de, 0x3ec6034d, 0xbffe6bdb,
    0xbe71b98c, 0xbf0f9ed9, 0xbf2643fb, 0xc030cde4,
    0xc019f820, 0x3cdc8446, 0x3e5711d3, 0x3c186058,
    0xbff04b25, 0x3f720018, 0x3f935a3d, 0x3fb751c6,
    0xbf6204cc, 0x3eb6959b, 0xbf5522a3, 0xbf41ca28,
    0xbf10c820, 0xbeebdad8, 0xbfcf03ac, 0xbed71a52,
    0x3e239ca5, 0x406021ae, 0xc06dae49, 0x3faff81e,
    0xbfe08ed3, 0x3f94771e, 0xbf619d26, 0xc07548df,
    0xbe2e91a4, 0x3f5ef274, 0xc0524561, 0xbed1688c,
    0x3f940748, 0x40433984, 0x3fe6ae6d, 0xbea9851f,
    0xbfd2c726, 0xbe6aed7e, 0xbf04f035, 0x3ee9babb,
    0xbe06190f, 0x3f0770dc, 0xbeecdc3e, 0x3f0cd1dc,
    0xc00c0259, 0xbfbafd28, 0x3fce52da, 0x3f7643f8,
    0x3fc8e378, 0xbffadca9, 0x3eb8ca1f, 0xbf5cc7c1,
    0x3fe54793, 0x3f8738c8, 0xbe5934b3, 0xbfadce5f,
    0x3f037fa0, 0x40172dda, 0xbf155829, 0xbfc17d96,
    0xbfc2435a, 0xc007ceef, 0xc0215d64, 0x4018831a,
    0x3f562469, 0x3f55e140, 0xbf417946, 0x3fd9af4c,
    0xbf71148e, 0x3f821663, 0xc013bd5c, 0xbfec1cd4,
    0xbf13505a, 0x3ffd040f, 0x3f2e18c4, 0x3f7d51ee,
    0x3dce5780, 0xbfd9c22c, 0x3fbe0364, 0x3f43c25b,
    0x3f920f42, 0xbf8fcbf9, 0x401068fd, 0xbfbaee7f,
    0x3dbd5763, 0xbe89ddd0, 0xbe1e1fba, 0xbed65dfb,
    0x3e4d4522, 0x3f439e2b, 0x3dc257d9, 0xbf2ee167,
    0x3ebd59a6, 0xbf79fe5c, 0xbfa2ac13, 0x3f8c1cbf,
    0x3f5ff53e, 0xbfbec96f, 0xc02b36bd, 0x3fade45c,
    0xbf74da5f, 0x3ead538a, 0x40562c40, 0xbeaf96cd,
    0xbf0c913f, 0x3ed15134, 0x40155457, 0xbf18924d,
    0x3fb14ffc, 0xbf6e65aa, 0xbf897572, 0xc069323d,
    0x3eb8bd8a, 0x3ff81af4, 0x400ac8ba, 0x3e1ea1c3,
    0x3f1c6be3, 0x3f7158e2, 0x39a5cae0, 0xc0129bd8,
    0xc01a489b, 0x3f505378, 0x400f5b4b, 0x3f8881f9,
    0x400948d4, 0xc00fd594, 0x3d1a6147, 0xbf18ca25,
    0xbff1ea29, 0xbef375fd, 0x3e5ae584, 0xbff06906,
    0xbfcbaee2, 0xbf7fb66f, 0x3f7e3901, 0x3f8d7228,
    0xc03b79ff, 0xbf923593, 0x3e04a7bd, 0xc03455e7,
    0xbeb0bcaf, 0x3f189bd7, 0x3f877a98, 0x40806c52,
    0x3e6f844b, 0x3f4f2767, 0x3f3a38af, 0x3fbd5737,
    0x3ed659fd, 0x3f746dfc, 0x40225182, 0xc0171f31,
    0xc0273574, 0xbea3283c, 0xbfedbb6b, 0xbf98d21e,
    0xbf45d4fc, 0x3f22c153, 0x3fc4afed, 0x3ea8651c,
    0xbf8984ab, 0xbedf1df4, 0xbdf72465, 0x3ffee182,
    0x3fcc36f8, 0xbf310faa, 0x3f5a1f52, 0xbf95ab21,
    0xbcb6f8d9, 0x4016e36e, 0xc0186c00, 0xc054c3d7,
    0x3e9d09ac, 0xc00c5bea, 0xbf2d0f44, 0x3f543764,
    0xbfb5f20e, 0x3d537807, 0xbfe21870, 0x3f28dafb,
    0x3fca22ef, 0x3feb467e, 0xc04f2e9c, 0x3f3ae222,
    0xbfdb82c1, 0xc01eb1e9, 0xbec0b569, 0xbfde906c,
    0xbe71ee9e, 0x40296e96, 0x3fc524ea, 0xbfa25123,
    0x3fd7bc83, 0x3e798f9b, 0xc03ac218, 0xbe0e0375,
    0xbf75876d, 0xbe052ad5, 0xc0993a13, 0x3fe6704e,
    0xbfcbb842, 0x3e658ab3, 0xbd324770, 0xbd8ec891,
    0x4005f789, 0xbfb89f1d, 0xbf3a2858, 0x3f106327,
    0xbdc6cc4d, 0xbe9a087a, 0x3fa20792, 0xc035dbd2,
    0xbfb430d4, 0xc022cc03, 0x3f874349, 0x3f345529,
    0x40056263, 0x405f248d, 0xbd97a2cc, 0x3f0d53c3,
    0x3e8bc498, 0x402d1f2c, 0xbf781ca8, 0x3fa55217,
    0x400d98eb, 0x3f68f244, 0x3febe677, 0xbfd56738,
    0xbfeaec2b, 0x3f4318ce, 0x3ff08f92, 0xbe7910bf,
    0x3e6db71c, 0x3f6a393f, 0x3fbb81f4, 0xbf31d284,
    0xbf1082bc, 0x3fa00dea, 0xbfa4b906, 0xbee003e9,
    0xbeca764f, 0xbe14fde6, 0x3f2f4bbe, 0x3f8c13ad,
    0x3f3e0f60, 0x3f4f9e49, 0x401a7cac, 0xbff3d0ee,
    0x402c1afc, 0xbfce468e, 0x3fa397b1, 0xbf33d435,
    0xc00e943a, 0xbf0f92a3, 0x402f4cdf, 0xbee3f426,
    0xbf30da45, 0x3e920097, 0x3df899dd, 0x3fbc6357,
    0x3f42841f, 0xbff11be9, 0x3fc4b71b, 0xbff76b31,
    0x3fe8dae7, 0x403a265d, 0xbec31aa4, 0xbf755774,
    0x3fb0746a, 0xbe14c836, 0x3e9491f9, 0x3e8c227e,
    0xbe8ba884, 0x3f67dbf5, 0x3fb6b354, 0xbf47f147,
    0x3e597ea8, 0xbf05355c, 0x3f2e4b45, 0x3ee2324c,
    0xbff4c9a6, 0x3fb51799, 0xbffe1b94, 0x3f2bfe59,
    0xc03da9b3, 0xbdb47be2, 0x3f9fbca8, 0x3f83c25e,
    0xbedc807f, 0x3f59e1ed, 0x40017be3, 0xc00b995f,
    0x3fe3ad8a, 0xbde98766, 0x3f512b4d, 0xbf7dba5e,
    0xbfc75a94, 0xbf8914dc, 0x3e56a3dc, 0xbf181cc7,
    0xc045d9d9, 0x3e4c7654, 0xbdfa6d69, 0xbf6af6b8,
    0xbf6a4444, 0x3f508d46, 0xbe6570c4, 0x3e791b85,
    0xbfd2b921, 0x3fda30dd, 0x3f82b88c, 0xbfc54d92,
    0x3f5bb3bb, 0x3f828ce0, 0x3fca92a7, 0xbf5d097a,
    0x3f301745, 0xbf91a0de, 0xc01f2509, 0xbfe2a17f,
    0x40244ccb, 0x3f75a3d8, 0x40783bf2, 0x3f58b9ee,
    0x3fd239b7, 0xbfbdc311, 0x3f771c47, 0x3fbaa8b8,
    0x3eee9025, 0x4058ae35, 0xbf9815ec, 0xbeaff718,
    0x3eaaef5c, 0xbc058f9e, 0x3f0570b7, 0x3face308,
    0x400f3d90, 0x3efdbe66, 0xbfa5292f, 0xbf31a5fa,
    0xbe399fc1, 0xbfad98ff, 0x401e9259, 0xbfb2384d,
    0x3de45379, 0x404f7f9f, 0xbfc328df, 0x3fb885f0,
    0x3f7f2fe2, 0xbea8e4a1, 0xc03b3c2f, 0xbf0626ee,
    0x3fe20908, 0x3f620780, 0x3eb25b90, 0xc003d3e2,
    0xbf8874eb, 0x3f55e00c, 0xbedcb238, 0xbe6624f1,
    0xbeabaeb9, 0xbf4cf712, 0x3e8f7b76, 0xbfd72068,
    0xbfd319c0, 0x3f8702b8, 0xc04bac13, 0x40509da1,
    0xbf2717d3, 0x3e044033, 0xc0b34694, 0x403137e0,
    0x3fcd2a71, 0xbf7c9d08, 0xbf5cfdc9, 0x3f548690,
    0x405c3052, 0x400b8290, 0xbfef948a, 0x3fc0132c,
    0x3ffcd2a6, 0x3f4144ca, 0x3feb4b0a, 0x3f84e223,
    0x3fe83a5a, 0xc0016fe7, 0x3d165d50, 0xbdd3c517,
    0x3eb69f4c, 0xc020cbad, 0xbf0a030e, 0x3fc50bc7,
    0xc042b2fd, 0x3f90a5a0, 0x40416fe7, 0x3f4460c8,
    0x40838d0a, 0xc0cfaa30, 0x3fee35e5, 0xbfd5138f,
    0x3dc705ba, 0xbf5b9648, 0xbc90455d, 0xbf847608,
    0x3ea0459b, 0xbeccb21d, 0x40097a53, 0xbf45267f,
    0x3ffcfa58, 0x3efdbe56, 0x3ffb70af, 0x3f30fc9c,
    0xbf8ccd7e, 0xc0792419, 0x406029c0, 0x3fe6dd1c,
    0xc084c23e, 0x40344546, 0x3f9e6f4e, 0xbef6f1b6,
    0xbe8c92af, 0x400b2215, 0xc025590a, 0xbff53dd5,
    0xbf75364c, 0x3f772c93, 0x3f88156f, 0x3fa89109,
    0xc019e3ac, 0x3fc251fa, 0xbcad74a2, 0x3f35f0c1,
    0x3e12ac11, 0x3f08ea78, 0x3f533728, 0xbf67940c,
    0x3e9b18ed, 0x3fc6fabb, 0x3fc6faa1, 0x404fd971,
    0x3f7b6a3a, 0xbf70bd70, 0xbee6a864, 0x3f5bf474,
    0xbea3b12f, 0xbe75fb47, 0x401d2774, 0xbf6135ca,
    0x402161eb, 0xbf23fdc8, 0xbf96e0b2, 0x3f72a69b,
    0xbe973142, 0xbfb686e4, 0x3e05046e, 0x40135173,
    0x3f55db5a, 0xbf8475de, 0x3f7bf4d6, 0x4033dd6f,
    0x3fe7462b, 0xbfcc7f46, 0xbe1bbcd1, 0x3e7e044b,
    0xbef49240, 0xbe9f9e7a, 0xbf072c0e, 0xbfbbf0a9,
    0x3c601b5c, 0xc0236339, 0x3f5257e5, 0x3eee43e8,
    0xbfa13e5c, 0xc00c0758, 0x3f2f6bbd, 0x3f161fb4,
    0xbf8c1c8b, 0x3fdbf572, 0xbf4970e8, 0xbfc8e41b,
    0x3eabcd91, 0x3e163465, 0xbf5b2272, 0x400fe1db,
    0xc04a02e7, 0x3f3e4536, 0x3fe16301, 0xbf417a44,
    0x3f2ec8c9, 0xbfd8e06e, 0x4005b412, 0x3fbaf9ae,
    0x3e645d38, 0x3f17a30f, 0xbedb82a2, 0xbef8d62f,
    0xbf0c6df5, 0xbf9a47b0, 0xbf8b9013, 0x3f77cc1b,
    0x3f241fea, 0x3f2d6bf7, 0xbf1c0970, 0x3e97fee6,
    0x3e79c35d, 0x3f2c5845, 0x3e3b798b, 0xbfa86d23,
    0xbf69ae45, 0xbf38b3e3, 0x3ee9e40b, 0xbfc244bf,
    0x3faf22e5, 0x3f42fbf2, 0x3fce10a8, 0x3ed71699,
    0xbf4c45e8, 0x3fe137c4, 0xbfc4082f, 0xc03c1b2e,
    0xc03be154, 0x4017dcb4, 0x3ebee933, 0xbf4d3169,
    0x3fa69e74, 0xbf5647c0, 0x3f9c7478, 0x3d92719c,
    0x3ef08202, 0x4006a243, 0xbfcc87ea, 0xbf735932,
    0xbfc36fef, 0x4013bea2, 0x3f6ac3ae, 0x3e7abe58,
    0x3f866a4f, 0x3e99d42e, 0x3ffa9748, 0xc068a225,
    0xc015f25e, 0xbfb16ff8, 0x3ed541fa, 0x402add0e,
    0x3d22c74f, 0x400a72d9, 0x3fdacacd, 0xbf844f6c,
    0x3e5fa5f2, 0xc00dfbf5, 0xbf394379, 0x3fd6eede,
    0x3fd2fd5f, 0x3eb945b3, 0x3fcfc25c, 0x3fc99158,
    0x40090a84, 0xbf0ab402, 0x402fbdd7, 0x409d2509,
    0xbf933168, 0xc0086cf1, 0xbfa99a76, 0xc04a8a26,
    0xbf83bcff, 0xbfe892a6, 0x3cf9f0c8, 0xc015624d,
    0x40647db3, 0x3e63c493, 0xbfcb15ca, 0xc03ae91f,
    0xc03683b6, 0xbfece094, 0x3efc2f5b, 0xbd99c8ec,
    0xbf9795e3, 0x3f4af43f, 0x3f1a5404, 0xbf2b19d1,
    0xc0618ea1, 0x3eb29560, 0x402a4294, 0x404fd34f,
    0xc027c76a, 0xc080f8ba, 0x3fa4c731, 0x3f49d8d1,
    0xbf825939, 0x3f8ca214, 0x4018f5d5, 0xbfaf94eb,
    0x3eb4abe4, 0xc00ba879, 0x3fc9840e, 0xbcb2206d,
    0xbfe8e513, 0xbfa1716f, 0xbffe0333, 0xbf680e74,
    0x3f1b7b6e, 0xbe8366ad, 0xc043f6ad, 0x405d4bc3,
    0xc032c62a, 0x3dbde640, 0xbe9b91f4, 0x4020b514,
    0x3e0822c4, 0x3f8644be, 0xbe50c4d8, 0xbfa7b379,
    0xbebb93a6, 0x3f1b06ad, 0xbda14275, 0xbf59f2a2,
    0x3fdeb2d0, 0x3f941e2c, 0x3e4adc02, 0x3fab636c,
    0x401c513c, 0x4039f394, 0x3f2a7892, 0xbf533701,
    0xbe31118c, 0xc02ab9cd, 0xbec66eed, 0x3e4fba9e,
    0xbf319764, 0x3d6885b1, 0x40255c8f, 0xbc8f8122,
    0x3f226793, 0xbdb13525, 0xbf2ef42a, 0x3f68c39c,
    0x3f4f11ae, 0xbeff0562, 0xbe5dbcf3, 0xbe9a77ee,
    0xbeb4ef00, 0x3fd0486e, 0xbf6a5eab, 0xbf881afb,
    0x3f836ecb, 0x4015e060, 0xbe6b016d, 0x407b1d0c,
    0x3fb66079, 0xbeafb693, 0x3f993c81, 0xbe6babc6,
    0xbf8a4740, 0xbfb31c08, 0x3fa89083, 0x3e5aa8f6,
    0x3a8d406c, 0x3fe68c4f, 0x3f1f84e2, 0x3e1cf5d9,
    0x3ea3ff7f, 0xc0623093, 0x3fa25ba4, 0x3f61e8b1,
    0xbf54a070, 0x402d3abe, 0xbee82d77, 0xbd223c2d,
    0x3e8ed009, 0xbfd61ecc, 0x40590bbd, 0xbeff0d00,
    0x3f670aea, 0x3f04b212, 0x3e373433, 0xbff63df1,
    0xbec873fb, 0xc01857de, 0x3ecbe027, 0x40093b83,
    0xc009ebbe, 0x3fd9eafa, 0xbeca66ac, 0x3ef7f927,
    0xbfc84ce9, 0xbfd06d69, 0x3f3718e7, 0xbf8630ca,
    0x3ed75b4b, 0xbe7896fa, 0x3f52681d, 0xbf3a2d63,
    0x407ea0de, 0x400ac427, 0x3fcea246, 0x3f5eb544,
    0xbfd9db13, 0xbe915b01, 0x3f84978f, 0xc0341d23,
    0xc01162b6, 0xc01fcfad, 0x400a3575, 0x3b31033a,
    0x403c77f5, 0xbfacb8fe, 0x3f429d2e, 0xbfb1e74a,
    0xbf6a3b4b, 0x3fbd55b7, 0x3eb2c0ed, 0xc051e4d0,
    0x3f0afa64, 0xbff399ec, 0x3f147eb1, 0x3f714fe2,
    0xbea7de35, 0x3f8d9978, 0x3ef50469, 0xbfcf570b,
    0xbfc0514f, 0x3f5557c1, 0x3f2e3731, 0x400b3df1,
    0xbf553438, 0xbdcabbbc, 0xbfe2770a, 0x3ee0a36e,
    0xbe0c7bf9, 0x3e948561, 0xbf467283, 0x3f8addc8,
    0xbd879895, 0x4037131d, 0x3fd21af9, 0x3f44555d,
    0x3dd1eb65, 0x3ef4eef7, 0x3fe916dd, 0x3efe7bb2,
    0x3f0a5163, 0x3fe02e30, 0x3ff65003, 0x3f4f4781,
    0xbdd73ff0, 0x3e25bdc3, 0x4022b111, 0xc007fdac,
    0x3fde8d41, 0xbfb2ce52, 0x3fda9267, 0x3eea8c7b,
    0x3f446b58, 0xbf40731e, 0xbed83b4e, 0x4012018a,
    0xc067e8e3, 0xbf892edd, 0xc06cf144, 0x3f7e0bf7,
    0x3ff6611d, 0xbf50542f, 0xc03e8152, 0xbfbf5dcb,
    0xbd21fbd3, 0xbf17d729, 0x3ffbe3cc, 0x3f16b2b4,
    0x408fef8f, 0xc03d32ee, 0xbf4f02b1, 0xc006721b,
    0xc02ddb18, 0x3f23b8af, 0xbfea7779, 0xbf8cd385,
    0xbf598676, 0x3ff72ea9, 0x400a22fb, 0x3f0f11de,
    0xbed8f66d, 0xc00994fc, 0xbf8b54e4, 0xbc616c29,
    0xbfe5c91a, 0x3f70e09e, 0x40090e2b, 0xbec802de,
    0x3f61ab85, 0x0, 0x40090e2b, 0x3ec802de,
    0xbfe5c91a, 0xbf70e09e, 0xbf8b54e4, 0x3c616c29,
    0xbed8f66d, 0x400994fc, 0x400a22fb, 0xbf0f11de,
    0xbf598676, 0xbff72ea9, 0xbfea7779, 0x3f8cd385,
    0xc02ddb18, 0xbf23b8af, 0xbf4f02b1, 0x4006721b,
    0x408fef8f, 0x403d32ee, 0x3ffbe3cc, 0xbf16b2b4,
    0xbd21fbd3, 0x3f17d729, 0xc03e8152, 0x3fbf5dcb,
    0x3ff6611d, 0x3f50542f, 0xc06cf144, 0xbf7e0bf7,
    0xc067e8e3, 0x3f892edd, 0xbed83b4e, 0xc012018a,
    0x3f446b58, 0x3f40731e, 0x3fda9267, 0xbeea8c7b,
    0x3fde8d41, 0x3fb2ce52, 0x4022b111, 0x4007fdac,
    0xbdd73ff0, 0xbe25bdc3, 0x3ff65003, 0xbf4f4781,
    0x3f0a5163, 0xbfe02e30, 0x3fe916dd, 0xbefe7bb2,
    0x3dd1eb65, 0xbef4eef7, 0x3fd21af9, 0xbf44555d,
    0xbd879895, 0xc037131d, 0xbf467283, 0xbf8addc8,
    0xbe0c7bf9, 0xbe948561, 0xbfe2770a, 0xbee0a36e,
    0xbf553438, 0x3dcabbbc, 0x3f2e3731, 0xc00b3df1,
    0xbfc0514f, 0xbf5557c1, 0x3ef50469, 0x3fcf570b,
    0xbea7de35, 0xbf8d9978, 0x3f147eb1, 0xbf714fe2,
    0x3f0afa64, 0x3ff399ec, 0x3eb2c0ed, 0x4051e4d0,
    0xbf6a3b4b, 0xbfbd55b7, 0x3f429d2e, 0x3fb1e74a,
    0x403c77f5, 0x3facb8fe, 0x400a3575, 0xbb31033a,
    0xc01162b6, 0x401fcfad, 0x3f84978f, 0x40341d23,
    0xbfd9db13, 0x3e915b01, 0x3fcea246, 0xbf5eb544,
    0x407ea0de, 0xc00ac427, 0x3f52681d, 0x3f3a2d63,
    0x3ed75b4b, 0x3e7896fa, 0x3f3718e7, 0x3f8630ca,
    0xbfc84ce9, 0x3fd06d69, 0xbeca66ac, 0xbef7f927,
    0xc009ebbe, 0xbfd9eafa, 0x3ecbe027, 0xc0093b83,
    0xbec873fb, 0x401857de, 0x3e373433, 0x3ff63df1,
    0x3f670aea, 0xbf04b212, 0x40590bbd, 0x3eff0d00,
    0x3e8ed009, 0x3fd61ecc, 0xbee82d77, 0x3d223c2d,
    0xbf54a070, 0xc02d3abe, 0x3fa25ba4, 0xbf61e8b1,
    0x3ea3ff7f, 0x40623093, 0x3f1f84e2, 0xbe1cf5d9,
    0x3a8d406c, 0xbfe68c4f, 0x3fa89083, 0xbe5aa8f6,
    0xbf8a4740, 0x3fb31c08, 0x3f993c81, 0x3e6babc6,
    0x3fb66079, 0x3eafb693, 0xbe6b016d, 0xc07b1d0c,
    0x3f836ecb, 0xc015e060, 0xbf6a5eab, 0x3f881afb,
    0xbeb4ef00, 0xbfd0486e, 0xbe5dbcf3, 0x3e9a77ee,
    0x3f4f11ae, 0x3eff0562, 0xbf2ef42a, 0xbf68c39c,
    0x3f226793, 0x3db13525, 0x40255c8f, 0x3c8f8122,
    0xbf319764, 0xbd6885b1, 0xbec66eed, 0xbe4fba9e,
    0xbe31118c, 0x402ab9cd, 0x3f2a7892, 0x3f533701,
    0x401c513c, 0xc039f394, 0x3e4adc02, 0xbfab636c,
    0x3fdeb2d0, 0xbf941e2c, 0xbda14275, 0x3f59f2a2,
    0xbebb93a6, 0xbf1b06ad, 0xbe50c4d8, 0x3fa7b379,
    0x3e0822c4, 0xbf8644be, 0xbe9b91f4, 0xc020b514,
    0xc032c62a, 0xbdbde640, 0xc043f6ad, 0xc05d4bc3,
    0x3f1b7b6e, 0x3e8366ad, 0xbffe0333, 0x3f680e74,
    0xbfe8e513, 0x3fa1716f, 0x3fc9840e, 0x3cb2206d,
    0x3eb4abe4, 0x400ba879, 0x4018f5d5, 0x3faf94eb,
    0xbf825939, 0xbf8ca214, 0x3fa4c731, 0xbf49d8d1,
    0xc027c76a, 0x4080f8ba, 0x402a4294, 0xc04fd34f,
    0xc0618ea1, 0xbeb29560, 0x3f1a5404, 0x3f2b19d1,
    0xbf9795e3, 0xbf4af43f, 0x3efc2f5b, 0x3d99c8ec,
    0xc03683b6, 0x3fece094, 0xbfcb15ca, 0x403ae91f,
    0x40647db3, 0xbe63c493, 0x3cf9f0c8, 0x4015624d,
    0xbf83bcff, 0x3fe892a6, 0xbfa99a76, 0x404a8a26,
    0xbf933168, 0x40086cf1, 0x402fbdd7, 0xc09d2509,
    0x40090a84, 0x3f0ab402, 0x3fcfc25c, 0xbfc99158,
    0x3fd2fd5f, 0xbeb945b3, 0xbf394379, 0xbfd6eede,
    0x3e5fa5f2, 0x400dfbf5, 0x3fdacacd, 0x3f844f6c,
    0x3d22c74f, 0xc00a72d9, 0x3ed541fa, 0xc02add0e,
    0xc015f25e, 0x3fb16ff8, 0x3ffa9748, 0x4068a225,
    0x3f866a4f, 0xbe99d42e, 0x3f6ac3ae, 0xbe7abe58,
    0xbfc36fef, 0xc013bea2, 0xbfcc87ea, 0x3f735932,
    0x3ef08202, 0xc006a243, 0x3f9c7478, 0xbd92719c,
    0x3fa69e74, 0x3f5647c0, 0x3ebee933, 0x3f4d3169,
    0xc03be154, 0xc017dcb4, 0xbfc4082f, 0x403c1b2e,
    0xbf4c45e8, 0xbfe137c4, 0x3fce10a8, 0xbed71699,
    0x3faf22e5, 0xbf42fbf2, 0x3ee9e40b, 0x3fc244bf,
    0xbf69ae45, 0x3f38b3e3, 0x3e3b798b, 0x3fa86d23,
    0x3e79c35d, 0xbf2c5845, 0xbf1c0970, 0xbe97fee6,
    0x3f241fea, 0xbf2d6bf7, 0xbf8b9013, 0xbf77cc1b,
    0xbf0c6df5, 0x3f9a47b0, 0xbedb82a2, 0x3ef8d62f,
    0x3e645d38, 0xbf17a30f, 0x4005b412, 0xbfbaf9ae,
    0x3f2ec8c9, 0x3fd8e06e, 0x3fe16301, 0x3f417a44,
    0xc04a02e7, 0xbf3e4536, 0xbf5b2272, 0xc00fe1db,
    0x3eabcd91, 0xbe163465, 0xbf4970e8, 0x3fc8e41b,
    0xbf8c1c8b, 0xbfdbf572, 0x3f2f6bbd, 0xbf161fb4,
    0xbfa13e5c, 0x400c0758, 0x3f5257e5, 0xbeee43e8,
    0x3c601b5c, 0x40236339, 0xbf072c0e, 0x3fbbf0a9,
    0xbef49240, 0x3e9f9e7a, 0xbe1bbcd1, 0xbe7e044b,
    0x3fe7462b, 0x3fcc7f46, 0x3f7bf4d6, 0xc033dd6f,
    0x3f55db5a, 0x3f8475de, 0x3e05046e, 0xc0135173,
    0xbe973142, 0x3fb686e4, 0xbf96e0b2, 0xbf72a69b,
    0x402161eb, 0x3f23fdc8, 0x401d2774, 0x3f6135ca,
    0xbea3b12f, 0x3e75fb47, 0xbee6a864, 0xbf5bf474,
    0x3f7b6a3a, 0x3f70bd70, 0x3fc6faa1, 0xc04fd971,
    0x3e9b18ed, 0xbfc6fabb, 0x3f533728, 0x3f67940c,
    0x3e12ac11, 0xbf08ea78, 0xbcad74a2, 0xbf35f0c1,
    0xc019e3ac, 0xbfc251fa, 0x3f88156f, 0xbfa89109,
    0xbf75364c, 0xbf772c93, 0xc025590a, 0x3ff53dd5,
    0xbe8c92af, 0xc00b2215, 0x3f9e6f4e, 0x3ef6f1b6,
    0xc084c23e, 0xc0344546, 0x406029c0, 0xbfe6dd1c,
    0xbf8ccd7e, 0x40792419, 0x3ffb70af, 0xbf30fc9c,
    0x3ffcfa58, 0xbefdbe56, 0x40097a53, 0x3f45267f,
    0x3ea0459b, 0x3eccb21d, 0xbc90455d, 0x3f847608,
    0x3dc705ba, 0x3f5b9648, 0x3fee35e5, 0x3fd5138f,
    0x40838d0a, 0x40cfaa30, 0x40416fe7, 0xbf4460c8,
    0xc042b2fd, 0xbf90a5a0, 0xbf0a030e, 0xbfc50bc7,
    0x3eb69f4c, 0x4020cbad, 0x3d165d50, 0x3dd3c517,
    0x3fe83a5a, 0x40016fe7, 0x3feb4b0a, 0xbf84e223,
    0x3ffcd2a6, 0xbf4144ca, 0xbfef948a, 0xbfc0132c,
    0x405c3052, 0xc00b8290, 0xbf5cfdc9, 0xbf548690,
    0x3fcd2a71, 0x3f7c9d08, 0xc0b34694, 0xc03137e0,
    0xbf2717d3, 0xbe044033, 0xc04bac13, 0xc0509da1,
    0xbfd319c0, 0xbf8702b8, 0x3e8f7b76, 0x3fd72068,
    0xbeabaeb9, 0x3f4cf712, 0xbedcb238, 0x3e6624f1,
    0xbf8874eb, 0xbf55e00c, 0x3eb25b90, 0x4003d3e2,
    0x3fe20908, 0xbf620780, 0xc03b3c2f, 0x3f0626ee,
    0x3f7f2fe2, 0x3ea8e4a1, 0xbfc328df, 0xbfb885f0,
    0x3de45379, 0xc04f7f9f, 0x401e9259, 0x3fb2384d,
    0xbe399fc1, 0x3fad98ff, 0xbfa5292f, 0x3f31a5fa,
    0x400f3d90, 0xbefdbe66, 0x3f0570b7, 0xbface308,
    0x3eaaef5c, 0x3c058f9e, 0xbf9815ec, 0x3eaff718,
    0x3eee9025, 0xc058ae35, 0x3f771c47, 0xbfbaa8b8,
    0x3fd239b7, 0x3fbdc311, 0x40783bf2, 0xbf58b9ee,
    0x40244ccb, 0xbf75a3d8, 0xc01f2509, 0x3fe2a17f,
    0x3f301745, 0x3f91a0de, 0x3fca92a7, 0x3f5d097a,
    0x3f5bb3bb, 0xbf828ce0, 0x3f82b88c, 0x3fc54d92,
    0xbfd2b921, 0xbfda30dd, 0xbe6570c4, 0xbe791b85,
    0xbf6a4444, 0xbf508d46, 0xbdfa6d69, 0x3f6af6b8,
    0xc045d9d9, 0xbe4c7654, 0x3e56a3dc, 0x3f181cc7,
    0xbfc75a94, 0x3f8914dc, 0x3f512b4d, 0x3f7dba5e,
    0x3fe3ad8a, 0x3de98766, 0x40017be3, 0x400b995f,
    0xbedc807f, 0xbf59e1ed, 0x3f9fbca8, 0xbf83c25e,
    0xc03da9b3, 0x3db47be2, 0xbffe1b94, 0xbf2bfe59,
    0xbff4c9a6, 0xbfb51799, 0x3f2e4b45, 0xbee2324c,
    0x3e597ea8, 0x3f05355c, 0x3fb6b354, 0x3f47f147,
    0xbe8ba884, 0xbf67dbf5, 0x3e9491f9, 0xbe8c227e,
    0x3fb0746a, 0x3e14c836, 0xbec31aa4, 0x3f755774,
    0x3fe8dae7, 0xc03a265d, 0x3fc4b71b, 0x3ff76b31,
    0x3f42841f, 0x3ff11be9, 0x3df899dd, 0xbfbc6357,
    0xbf30da45, 0xbe920097, 0x402f4cdf, 0x3ee3f426,
    0xc00e943a, 0x3f0f92a3, 0x3fa397b1, 0x3f33d435,
    0x402c1afc, 0x3fce468e, 0x401a7cac, 0x3ff3d0ee,
    0x3f3e0f60, 0xbf4f9e49, 0x3f2f4bbe, 0xbf8c13ad,
    0xbeca764f, 0x3e14fde6, 0xbfa4b906, 0x3ee003e9,
    0xbf1082bc, 0xbfa00dea, 0x3fbb81f4, 0x3f31d284,
    0x3e6db71c, 0xbf6a393f, 0x3ff08f92, 0x3e7910bf,
    0xbfeaec2b, 0xbf4318ce, 0x3febe677, 0x3fd56738,
    0x400d98eb, 0xbf68f244, 0xbf781ca8, 0xbfa55217,
    0x3e8bc498, 0xc02d1f2c, 0xbd97a2cc, 0xbf0d53c3,
    0x40056263, 0xc05f248d, 0x3f874349, 0xbf345529,
    0xbfb430d4, 0x4022cc03, 0x3fa20792, 0x4035dbd2,
    0xbdc6cc4d, 0x3e9a087a, 0xbf3a2858, 0xbf106327,
    0x4005f789, 0x3fb89f1d, 0xbd324770, 0x3d8ec891,
    0xbfcbb842, 0xbe658ab3, 0xc0993a13, 0xbfe6704e,
    0xbf75876d, 0x3e052ad5, 0xc03ac218, 0x3e0e0375,
    0x3fd7bc83, 0xbe798f9b, 0x3fc524ea, 0x3fa25123,
    0xbe71ee9e, 0xc0296e96, 0xbec0b569, 0x3fde906c,
    0xbfdb82c1, 0x401eb1e9, 0xc04f2e9c, 0xbf3ae222,
    0x3fca22ef, 0xbfeb467e, 0xbfe21870, 0xbf28dafb,
    0xbfb5f20e, 0xbd537807, 0xbf2d0f44, 0xbf543764,
    0x3e9d09ac, 0x400c5bea, 0xc0186c00, 0x4054c3d7,
    0xbcb6f8d9, 0xc016e36e, 0x3f5a1f52, 0x3f95ab21,
    0x3fcc36f8, 0x3f310faa, 0xbdf72465, 0xbffee182,
    0xbf8984ab, 0x3edf1df4, 0x3fc4afed, 0xbea8651c,
    0xbf45d4fc, 0xbf22c153, 0xbfedbb6b, 0x3f98d21e,
    0xc0273574, 0x3ea3283c, 0x40225182, 0x40171f31,
    0x3ed659fd, 0xbf746dfc, 0x3f3a38af, 0xbfbd5737,
    0x3e6f844b, 0xbf4f2767, 0x3f877a98, 0xc0806c52,
    0xbeb0bcaf, 0xbf189bd7, 0x3e04a7bd, 0x403455e7,
    0xc03b79ff, 0x3f923593, 0x3f7e3901, 0xbf8d7228,
    0xbfcbaee2, 0x3f7fb66f, 0x3e5ae584, 0x3ff06906,
    0xbff1ea29, 0x3ef375fd, 0x3d1a6147, 0x3f18ca25,
    0x400948d4, 0x400fd594, 0x400f5b4b, 0xbf8881f9,
    0xc01a489b, 0xbf505378, 0x39a5cae0, 0x40129bd8,
    0x3f1c6be3, 0xbf7158e2, 0x400ac8ba, 0xbe1ea1c3,
    0x3eb8bd8a, 0xbff81af4, 0xbf897572, 0x4069323d,
    0x3fb14ffc, 0x3f6e65aa, 0x40155457, 0x3f18924d,
    0xbf0c913f, 0xbed15134, 0x40562c40, 0x3eaf96cd,
    0xbf74da5f, 0xbead538a, 0xc02b36bd, 0xbfade45c,
    0x3f5ff53e, 0x3fbec96f, 0xbfa2ac13, 0xbf8c1cbf,
    0x3ebd59a6, 0x3f79fe5c, 0x3dc257d9, 0x3f2ee167,
    0x3e4d4522, 0xbf439e2b, 0xbe1e1fba, 0x3ed65dfb,
    0x3dbd5763, 0x3e89ddd0, 0x401068fd, 0x3fbaee7f,
    0x3f920f42, 0x3f8fcbf9, 0x3fbe0364, 0xbf43c25b,
    0x3dce5780, 0x3fd9c22c, 0x3f2e18c4, 0xbf7d51ee,
    0xbf13505a, 0xbffd040f, 0xc013bd5c, 0x3fec1cd4,
    0xbf71148e, 0xbf821663, 0xbf417946, 0xbfd9af4c,
    0x3f562469, 0xbf55e140, 0xc0215d64, 0xc018831a,
    0xbfc2435a, 0x4007ceef, 0xbf155829, 0x3fc17d96,
    0x3f037fa0, 0xc0172dda, 0xbe5934b3, 0x3fadce5f,
    0x3fe54793, 0xbf8738c8, 0x3eb8ca1f, 0x3f5cc7c1,
    0x3fc8e378, 0x3ffadca9, 0x3fce52da, 0xbf7643f8,
    0xc00c0259, 0x3fbafd28, 0xbeecdc3e, 0xbf0cd1dc,
    0xbe06190f, 0xbf0770dc, 0xbf04f035, 0xbee9babb,
    0xbfd2c726, 0x3e6aed7e, 0x3fe6ae6d, 0x3ea9851f,
    0x3f940748, 0xc0433984, 0xc0524561, 0x3ed1688c,
    0xbe2e91a4, 0xbf5ef274, 0xbf619d26, 0x407548df,
    0xbfe08ed3, 0xbf94771e, 0xc06dae49, 0xbfaff81e,
    0x3e239ca5, 0xc06021ae, 0xbfcf03ac, 0x3ed71a52,
    0xbf10c820, 0x3eebdad8, 0xbf5522a3, 0x3f41ca28,
    0xbf6204cc, 0xbeb6959b, 0x3f935a3d, 0xbfb751c6,
    0xbff04b25, 0xbf720018, 0x3e5711d3, 0xbc186058,
    0xc019f820, 0xbcdc8446, 0xbf2643fb, 0x4030cde4,
    0xbe71b98c, 0x3f0f9ed9, 0x3ec6034d, 0x3ffe6bdb,
    0xbf877b5f, 0xbf60d3de, 0x401e66c1, 0xbe8349de,
    0xbea2924a, 0xbe225b6f, 0x3ee32b46, 0xbef99b59,
    0xbf9a0896, 0xbf2f17ad, 0x3f09336d, 0xc057c192,
    0x3f587c80, 0xbf60d9b9, 0x3e43ba45, 0x3de6f3fd,
    0x3fc98d30, 0x3f82eef4, 0xbeb0c6f9, 0xbf942408,
    0xc07fc0c6, 0xc0299719, 0xbf9e9ec8, 0x3fae6923,
    0x3e4f1172, 0xbfcde183, 0x4022c901, 0x3f833761,
    0xbe768cc5, 0xbf063cde, 0xbed357ff, 0xbfda4a25,
    0xbe9b8ed2, 0x400d7d5a, 0x3f69a896, 0x3f5a11f3,
    0x3f8accab, 0x3f2afe77, 0x3e83eaef, 0x3fbd6d96,
    0xbfd043b7, 0x3d83729a, 0xbef6dc35, 0xc0469188,
    0xbf8f5f10, 0xc05cba2a, 0x3fc24356, 0x3ec25120,
    0xbf7e97a9, 0x3cd084c3, 0x3e920730, 0x4037ea34,
    0xbfa16122, 0x3f3962eb, 0x3ff58f68, 0xbf86d48f,
    0xbffba533, 0xbfdb724f, 0xbf335652, 0xbfaa7c33,
    0xbf461db8, 0xbfcaf7ad, 0xbfcf5ae5, 0x3fd09e15,
    0xc0502350, 0xbdc5d895, 0x3e2e078b, 0x3f407703,
    0x3eb856ed, 0x3f81128f, 0x3dbab4b6, 0x401463b2,
    0x3f6d8f95, 0x4016d099, 0xbfca29d7, 0xbf831e2b,
    0xbf5b73ff, 0x3fa3fbcb, 0x3fc5b1c3, 0xc01669d7,
    0x3fb77594, 0x3febeca9, 0xbfac1d89, 0xbe90a3dd,
    0x3ea9e30b, 0x3fe31099, 0x406c1807, 0x3f83bbba,
    0xbd9dd699, 0xc048bfb7, 0xbf701928, 0x3f2b0499,
    0x4039ad67, 0x4004a35e, 0x3fd28c12, 0x3fde7b72,
    0x401880d7, 0xbfac3849, 0xbfa12d9a, 0xbddc6354,
    0xbfbffdf2, 0xc02b5e67, 0xc00ca842, 0xc0371aaa,
    0x4009bb4f, 0x402baeb0, 0xc020ce62, 0x3dbc330b,
    0x3da28b6a, 0x401170d7, 0x3fa78d8e, 0x3e62e66a,
    0x3f57a31b, 0x3fb2a0cb, 0x3f9ed93f, 0xc022dfc4,
    0xbe97ab16, 0xbf843ee9, 0x4049d2e8, 0x3f2f473b,
    0xbd1b942f, 0xbf7e5a8c, 0xbf084f41, 0x3dd43d11,
    0x3ec0ee0d, 0xbeee577a, 0x400a0571, 0x3ebcb376,
    0x3f7a7846, 0x40560248, 0xbed4f4af, 0xbea9b2f3,
    0x3f1187ae, 0x3fdaed35, 0xbe64e4c7, 0x3f98456c,
    0x40344df8, 0xbeee9a03, 0xbf8ac7cd, 0x3f430246,
    0xbf16f0e0, 0xbee2f968, 0x3fab901a, 0x3f0c6276,
    0x3eb37774, 0xc0532d77, 0x3fbb05a1, 0x3fea70a5,
    0xbc961985, 0x3f97b57c, 0x40af880b, 0x4001bcc2,
    0x3fe802fe, 0x4046f753, 0xbfff9d8f, 0x4083e54e,
    0xbfc3b735, 0x3f0c4728, 0x3ca32a38, 0xbef85270,
    0x3ffdfa30, 0x3f57c425, 0xbf5605c5, 0xbf87d076,
    0xc01ba4a6, 0x3e8234ef, 0x3de2b1d1, 0xc0262521,
    0xbf1f7819, 0x3f951794, 0x4016074a, 0xbfec2586,
    0x3f1fb92e, 0x3f2e1fd4, 0xbf7108b5, 0xbfd7dab5,
    0xc04873b3, 0x3f2656cc, 0x3f04c5bc, 0xbf3397e5,
    0x401b7549, 0x3f9227e2, 0xc02157b1, 0xbfc05ce3,
    0x4054bb39, 0xbec3a776, 0xbf570177, 0x3e90ac07,
    0x3f104e1e, 0x3ffcd8fb, 0x3fea8d7f, 0x3fdc6cee,
    0x3f399ce8, 0x4013e3f8, 0x402a3ead, 0x40958c4f,
    0xbf007e1b, 0xbf34bce4, 0x3dd23ac9, 0x3f5b82db,
    0x3dd23c24, 0xbf0a4ca1, 0xbf915cf4, 0x3fbc4973,
    0xbffe4fe7, 0xbf9b8f49, 0xbdbc6be5, 0x3fd6b4b6,
    0x3eb32789, 0xbf8024c6, 0x3de250c3, 0x3f0d0384,
    0x3f3a0ccd, 0x4084cdcd, 0x3b0df3bf, 0x3ecaffd7,
    0xbf0a72ae, 0x3ea7177e, 0x3e0e045f, 0x3fc9106e,
    0xbfb463c3, 0x3e760961, 0xbf5be007, 0x3f5baae3,
    0x404da156, 0x3f751fc2, 0xbf64daf9, 0x40082405,
    0x3ee5bec9, 0x3f575a84, 0xbf14c80d, 0x40405dcb,
    0x3f2c995a, 0xbf9488b4, 0xbf6694cb, 0xbf498719,
    0xc0607f1b, 0x3f80748c, 0xbf68e661, 0xbfd1bb03,
    0xbf2e43ea, 0x3f474d22, 0x3fa052f9, 0x401b553e,
    0xbf2f63ed, 0x40165120, 0xbfdd8a2b, 0x3e4053f2,
    0x3fec944f, 0x3fcc1040, 0xbdbe0652, 0xc035cf26,
    0x3f5da605, 0xbf9528f3, 0xbf8f177f, 0x3e9b76e3,
    0xc0798022, 0x400c5db0, 0x3f5e74da, 0x3fc3fbfc,
    0xbfbb72d6, 0x3d33306f, 0x3dc1d8fd, 0x3e90638b,
    0x3c843299, 0xc081feb4, 0x401a2b73, 0xc0275358,
    0xc03638d2, 0xbff4ee7c, 0xbe9f7fa5, 0x3f9658db,
    0xbd82862d, 0x3f2eff20, 0x4013d467, 0x40533283,
    0xbfc314bb, 0xc06dd0fe, 0xbf9adb06, 0x3f732fa1,
    0xbe9d922a, 0x4020c12a, 0xbfac81d9, 0xbff347b1,
    0x3fa20817, 0xbf6583ee, 0xbfb7f94f, 0xc03f085b,
    0x3e8e1db5, 0x3f7f5248, 0xbedd432c, 0xc01ff96a,
    0x3fa9eea4, 0xbfbc9c38, 0x3fa4cb83, 0xbf9aceea,
    0x3f723b32, 0x3e0c31d9, 0xbf8ae347, 0x3f90e9d5,
    0x3e3595f2, 0xc0529366, 0x402ecf65, 0x401a86d8,
    0x3f37f354, 0x40153c4b, 0x3f889d9e, 0x3ea78711,
    0xbed671b3, 0xbe61a360, 0xbed2dce1, 0x3fa7a66f,
    0xbe86800a, 0x3ea3b42a, 0x4015b3ab, 0x3f153148,
    0x401513e1, 0x3fc075ea, 0x3ee21d71, 0xbf850e2a,
    0xbf53c798, 0x3eb2eed6, 0xbe1fb95d, 0x3f4859e9,
    0x3ed9f2ac, 0x3f642048, 0x3f8db381, 0x3fed12e4,
    0xc0454fc6, 0xbf8e7a60, 0xc00f5107, 0x3f14515b,
    0x3ed30cc0, 0xbeeee64b, 0xbf827ae1, 0x3fda3873,
    0xbf855756, 0xbf905934, 0xbddd218e, 0xbee37f5d,
    0x404d9e09, 0x3c880588, 0x40198e0c, 0x3fcc9e51,
    0x3ff5d0ee, 0x3eab3524, 0xbf23c1ba, 0xbec13e04,
    0xbfe43051, 0x4011d3ff, 0xc020767d, 0x3f90ea85,
    0x3ffc60fd, 0x3de9b746, 0xbfdb567e, 0x3f78790e,
    0x3c21f487, 0xc0024a58, 0xc0119dc0, 0x3fb919e7,
    0x3f786f30, 0x3d318f38, 0x404b4d49, 0xbff1ddb6,
    0xc0069ddd, 0xbdf7b897, 0xbf38102a, 0xc035b808,
    0x4018df54, 0x401b81da, 0x406c5565, 0xbfa4de9f,
    0x3f16efc7, 0x3ee07d91, 0xbe4fac93, 0xc02985b6,
    0xc04923cd, 0xbf91ad95, 0xbf187dfd, 0xbfb91421,
    0xbfb98ebf, 0x4040ba6a, 0x3ffee406, 0x3f388b1c,
    0x3f0a9f5d, 0x4000c5d6, 0xbcca3e48, 0x3f8ecb86,
    0xbf80e323, 0x3f9634e0, 0xc05d6138, 0xbf588359,
    0xbf135fcd, 0xbfe413f0, 0xc0559c8a, 0x3fdde875,
    0x3f25c7fb, 0xbf03ec72, 0xbf5f7de6, 0xbf830703,
    0xc00da842, 0xbf2108e8, 0x3fa56200, 0xbf6d4057,
    0xbf3cad23, 0x3f86592b, 0x3d973cfc, 0xbe31cdab,
    0x3fb75b7d, 0xbf81a7df, 0xc01b4176, 0xbfafd76d,
    0x3f0e52a1, 0x3f8fc2a9, 0x3e89fc37, 0x3fb7537c,
    0xbfda9e08, 0xbe2373e5, 0x400caa59, 0x3fd71022,
    0x3e1ec28b, 0xc0567d60, 0x3faa7b78, 0xbf5df707,
    0xbbf43cd4, 0x3e3128f3, 0xbf12db6f, 0xbf76f78c,
    0x4002eb41, 0xbfb3e34c, 0x3fe8c08d, 0x3f8023ad,
    0x4024a336, 0x3fcd3d45, 0xbfa37e8a, 0xbfdf0d14,
    0x3f2e63e3, 0xbd13cbee, 0xbf1fba56, 0xbf626b7e,
    0x402de9c1, 0x3e4a82ae, 0x401a3a13, 0x3f8b26ba,
    0x3e028720, 0x3eed2fe6, 0x3f3c0e6b, 0xbf0bbe56,
    0xc083b19c, 0x3fe753db, 0x3ee11290, 0x3ff548f7,
    0x3ea19a7d, 0x3f461269, 0x3f569ce1, 0x3f6eda6f,
    0xbfdc9b00, 0xbfa06f80, 0x3fa9ed53, 0x3fcaa213,
    0x3fb35f4d, 0xbf3dca75, 0xbf370cec, 0x3fad3fe2,
    0x3f3a5f6f, 0xbef2a743, 0xbfb360cd, 0xbf1b1fa7,
    0xc062f5b3, 0x3f1f71ff, 0xc00421b0, 0xbd7db4ee,
    0x3f7c3c61, 0x3edff63d, 0x3f5c25a7, 0xc017168f,
    0xbf57b8c4, 0x4001aac5, 0x4082e832, 0xbf8525f0,
    0x3fc07c38, 0x3f8164b9, 0x3f535236, 0xbed45599,
    0x4008225a, 0x3ed8ad46, 0x3fd6569b, 0x3fe9b6db,
    0x403d9baa, 0x3de68cf2, 0x3f96a547, 0xbfd7b802,
    0xc0026154, 0xbec940c8, 0x405ea87c, 0x3ebfbe1d,
    0x3f026ac0, 0xbf634c67, 0x3f9aaf43, 0xbfad522f,
    0xc024bae5, 0x3f816f97, 0xbf4ad85c, 0x403513ca,
    0x3f674f68, 0x3ec3c39b, 0xbf597a34, 0x3e8d66b0,
    0x4014c8e0, 0xbfa01d9e, 0x3f471543, 0xbed9c5ec,
    0x3e52406b, 0xbfd20154, 0xbc083a55, 0x4009e565,
    0x3e974288, 0xbf93dee8, 0xc07340bf, 0xbf42d587,
    0x3fff2566, 0xbfc3a812, 0xbfbd53a8, 0xbfe88ec4,
    0xbf203bd7, 0x3f582feb, 0x403dfab3, 0x3f5e7129,
    0x40288066, 0x400494d7, 0xbfb2f018, 0xbe4be41f,
    0xbe2cb815, 0x3faa0ab4, 0x3d8e529c, 0xbf74b7c5,
    0xbf87a187, 0x401b410f, 0xbf670219, 0xbf763d5f,
    0x3fb9d9f7, 0x3f963952, 0xbe29e6a0, 0xc0475636,
    0xbff30a30, 0x40000f0a, 0xbf3d869b, 0x3f460ffd,
    0x3fec42ac, 0x3e87478d, 0x3fcbcb97, 0x3e9a6ef9,
    0xc0711bc7, 0xbf958d4b, 0x3f631e4b, 0xbf28885d,
    0xbe056f23, 0xbf399c51, 0x3eaa0bdf, 0xbf8c3c5c,
    0xbff6b8ad, 0x3f0fa55b, 0x3fcf0305, 0xbfc1f799,
    0xbe063524, 0xbf1da1b9, 0xbe993a51, 0x3fd91c67,
    0x4039f47e, 0x401ecdd1, 0xbe666ab2, 0x402ac6e3,
    0xc02ef00d, 0x3fcf5969, 0x3f5bb3cb, 0x3f2749d0,
    0x3ebffc0e, 0xbf8e31cb, 0xbf9eff77, 0x4041b0f9,
    0x3f05702a, 0x3fd8221e, 0x4017dbb0, 0xbfea979f,
    0x3f7a5687, 0xbfe7442d, 0x3fc49334, 0x3e84fc95,
    0xbfd62dfd, 0x3fc836ca, 0xbfb32b42, 0xbf302a06,
    0xbfbd83ba, 0xbf821a1c, 0xbff5048a, 0xbdae2c5c,
    0xbf94488b, 0xbf44ee1c, 0xbfefa1f2, 0x3fdf094e,
    0x3eff66d3, 0x400fe882, 0xbfd84738, 0x3e788614,
    0xbff55828, 0xbfe4eb54, 0x3e7b5323, 0x3fdeccc9,
    0xc005d8e7, 0x3fc01991, 0x3f440b0b, 0xbe4a4081,
    0xbf7176c0, 0xbf0052dc, 0x3f50c2f0, 0x402a2d69,
    0xbf841e06, 0x3dfe4f53, 0xc012b2ae, 0x3f0db0be,
    0x3f8dc07f, 0x4012bf14, 0xbfebe6b2, 0xc01c306c,
    0xbf25c57d, 0xbe6a73b8, 0xbf8d8891, 0x4022d6cf,
    0xbe90feae, 0x4009f082, 0xc0554a66, 0x3d34e0d4,
    0xc0048a74, 0x3f586cef, 0x400141d8, 0xbf626c07,
    0x3f384052, 0xbf0aa83d, 0xbec457e8, 0xbf6514e3,
    0x3fbeab0e, 0x3ebaa2b9, 0xbf9ec090, 0xbf9b61a0,
    0xbf8d0f14, 0x3e5e862b, 0xbf4fcd51, 0xc0006144,
    0xbfcdf6de, 0xbf6f1802, 0x40326ab1, 0xbeab9db4,
    0x3fdddfbd, 0xc01d3520, 0xbeb58361, 0x40712202,
    0x3f049e55, 0x3f407ebc, 0x400f6400, 0xbf903e5a,
    0x3cd83004, 0x3f572dad, 0xbe8cebfe, 0x3feacf73,
    0x3fff0f18, 0xbf98a6b9, 0x3f4e2795, 0x3f965ffa,
    0x3f4e1b41, 0x40044db4, 0xbfff9ff0, 0x3ef7397a,
    0x3fd613ca, 0xbf89d9e4, 0xbefd6b8b, 0xbf79d67f,
    0xbebf0b57, 0x3f5f9fe6, 0xc00e8779, 0x4004875f,
    0xbf034184, 0xc04d5f51, 0x3fcc3be1, 0xbdab150e,
    0xbe8682c1, 0x3ff69b22, 0xbed1f1f4, 0x3fdd6605,
    0x3ee12b94, 0xc04ff1e4, 0x3eafc818, 0xbeb30faa,
    0x3f5d71b1, 0xbfedbf7a, 0xbe9a4465, 0x3d6982ff,
    0x3e8b3d3c, 0xbfd293d3, 0x3f030b6a, 0xc02a251b,
    0x3f4a3a35, 0x3e3ccdd5, 0x3f13cedc, 0xbefa2db1,
    0xbf75d76e, 0x3e8b76e1, 0x3f760a1b, 0xbf582c34,
    0xbf4283f0, 0xbfb7b72e, 0xc04300ab, 0x3ebaf3b2,
    0xbf2e9742, 0xbf9f91b2, 0x3d93145f, 0xbc7f782d,
    0xbe13d2a6, 0x3fce9cfc, 0x4058250d, 0xc0237dca,
    0xbfbdaf4a, 0xbfdce738, 0x3fbbd4a5, 0x3f2ffe0e,
    0x3f805581, 0x3e959024, 0xbfc15db8, 0x3f1ce75b,
    0xbfcc969d, 0xc01631be, 0xbf936d49, 0x40a92dc0,
    0x3faa8055, 0xbfe8a9c1, 0x3f64c1dd, 0x3dbdcc3f,
    0x4021caf3, 0xbfd94fa2, 0xbdbdc3a0, 0xbffc61bb,
    0xbf6bf578, 0xc07e827b, 0xbed07bf9, 0xbf95b0b0,
    0x3f179a6f, 0x4433540f, 0xc048ef01, 0xbfbdd983,
    0x3e88b8a1, 0x4037e478, 0x3f044ee4, 0x400afa05,
    0x3fd3fcf0, 0x3f85cacc, 0xbf05197b, 0x3fba1fc9,
    0xbf2a9eb2, 0x4010f5a8, 0x3d9746ec, 0xc033874c,
    0x3e3ae281, 0xc07c018c, 0x3fd4388a, 0xbfdcfd50,
    0xbeb7bd37, 0xbf893f37, 0xbf92127c, 0xbfbb2714,
    0xbe81e4ef, 0xbf1038cd, 0x40200bb6, 0x3f6c18a7,
    0x3ea30c78, 0x4044909b, 0xbdce52c4, 0xbeea4c06,
    0xbf13de2b, 0x3d833bfb, 0x3f97352e, 0x3f8b8199,
    0x3f6ce08a, 0xbc80696c, 0x3f900a36, 0x3faeae42,
    0x3fe274e1, 0x3f2daf51, 0x400229e9, 0x3fc8481d,
    0x3fd73b1d, 0xbfb77e44, 0x3f2909c3, 0x3f8aa8f3,
    0x3fa2cf6f, 0x3eaa0c31, 0x3e8be9e8, 0xc029ef63,
    0xbf8418d3, 0xbf9d3ba7, 0xc0059b73, 0xbfaa1e2a,
    0xbfe74c3d, 0x3fc16ddd, 0xbf80da6a, 0xbebae27b,
    0x3f5e709c, 0x3ff92e4d, 0xbfd37d35, 0x3fb47fff,
    0xc019b041, 0xbf98d079, 0xbf3916d1, 0xc02506cb,
    0xbfd31b51, 0x3e75d513, 0x3e9b3707, 0x3ec4dd11,
    0x3f83a3df, 0xbfab52ef, 0x3fb05954, 0xbf49f13e,
    0xbf65818e, 0x3d1c614e, 0x3f3e13ce, 0xbfbdbf8e,
    0x3f1b8752, 0xbebc58ac, 0x3f54d5c6, 0x3e59093a,
    0x400e8ed6, 0x40291107, 0xc02723a0, 0x3f8bc3af,
    0x402145d6, 0xbffd5f6e, 0xc01357bd, 0x3ed55aca,
    0x3feab870, 0xbf622be7, 0xbd232839, 0xbf2f85da,
    0xbe7ef5b6, 0xbf4ea2b6, 0xbeaf9c5a, 0x3ff532f9,
    0x4010463b, 0xbfec5f0e, 0x3f4c7263, 0x3f55b29a,
    0x40222590, 0x3fe2ceba, 0xc05a95ca, 0xbd9297b2,
    0xc01ec4d3, 0xbf0b1485, 0xbfdecde8, 0xbfc85583,
    0x3f5b05c8, 0xc018622e, 0x3ed15f34, 0xbfba6e07,
    0x401af01f, 0xc03cd243, 0x3ff96f21, 0x400f61aa,
    0xbf7a6659, 0xbfd9d958, 0x4006756b, 0x3fbcf278,
    0x3c13773b, 0x3dc2b7a0, 0xbfefc159, 0x3fa651c5,
    0xbfb84989, 0xbf3d8b56, 0xbe9b07ae, 0x3ff53982,
    0xbfaa7cdf, 0x3fa41de7, 0xbe880772, 0x3fd62a6c,
    0xbe01d205, 0xbf890b81, 0xbfe712c6, 0x402309d3,
    0x3e8248a7, 0xc0125c96, 0xbecae915, 0x3ed2f6df,
    0xbfb70a02, 0x404fe8b3, 0xbf2741b4, 0xbfbbdbe1,
    0xbf582497, 0x3fb97af2, 0x3ecc02e0, 0x3ee25083,
    0xbfacbe81, 0x3f148d5b, 0xbded5ebb, 0x3f03ed6a,
    0xbf68d99c, 0x3f826f16, 0x3f74ca02, 0xbe72263a,
    0x3f62cc55, 0xbf3f4bf5, 0x3fcfb9e2, 0x3f4b502d,
    0xbe4b9a5e, 0x3f8d15b9, 0xbf00df2f, 0xbf1f5dc4,
    0x400a6eeb, 0xbf288fbe, 0xc037da65, 0x3f01b7d3,
    0x3f86b093, 0x3f1dbb4f, 0x3f94cc4c, 0xc0117bbb,
    0x3fa88e7d, 0xc06a31c2, 0x3f6871db, 0x4024b7d8,
    0xc025f5cd, 0xc08c0479, 0x40166fb7, 0xbeea456f,
    0xbdf749ef, 0x3fd33112, 0x3e7fe430, 0x3f3b1bf4,
    0x3ed89026, 0x3ceeaf7e, 0x406d9e30, 0x3f7c3903,
    0x3fc18e19, 0xbdfbc4e4, 0xbf0bb3fe, 0xbf6f65d1,
    0xc024e58d, 0xc000625a, 0x3dc70214, 0xbf87065d,
    0xc024b552, 0xbf5df8a0, 0x3f2f12da, 0xbf85724e,
    0x3f52acf9, 0x4007554a, 0xbf2cd545, 0x3f90663a,
    0xbec01527, 0x3f4d1c3b, 0xbebda6bf, 0xbdd1765f,
    0xbfbd54c4, 0x403af0b1, 0x3f7221a6, 0xbf8cac50,
    0xbf814ac5, 0xbf1e23d4, 0xbf7a580f, 0x3d07cb54,
    0xbf50f007, 0x3fddac68, 0xc027de37, 0x3f87a1f4,
    0x3eb51aac, 0xbf3bcfd3, 0xbfc3353d, 0x4054448e,
    0xc039d103, 0x3fbd0e36, 0xbf992a27, 0xc06047d4,
    0xbfcb047a, 0x3fa59e6d, 0xbffe220d, 0xbf994a26,
    0x3f070af6, 0x4059fc3f, 0xbf5b3dbf, 0x3fea14d1,
    0x4016449a, 0xc01b406b, 0x3fa28334, 0x3e9dc57a,
    0xbf2cd028, 0x3ec69262, 0x3ef86790, 0xbf92fb09,
    0x3b1d39f6, 0x3f5d48fd, 0x3ff8f5a3, 0x3eb4a174,
    0xbff0f848, 0xbf2596e5, 0x3fec8d70, 0xbf870772,
    0x3d86fb46, 0xbf2a3e7e, 0xbf726849, 0x3f7cfdd3,
    0x3fc95966, 0x3f16b4a5, 0xbed90db7, 0xbf09cda9,
    0x3fad51ae, 0x404bd717, 0x3f1e5a6d, 0x4016efc6,
    0x4020ca9b, 0x3d0cc93f, 0x3e84e3ad, 0x3f03bba1,
    0x4029b476, 0xc0349c72, 0xbfb99a34, 0x400aff61,
    0xbf997a66, 0xbfcc6dbf, 0xbdb83ae0, 0x404f83fc,
    0x3e87470c, 0x3deaccc1, 0xbfbaa2d2, 0x3eadca26,
    0x3f3be000, 0x4007903f, 0xbf456937, 0xbeab2c5e,
    0xbf60ddc3, 0x3f9d00f1, 0xbf8cd4b3, 0xbe7e64e5,
    0xbf8d554e, 0xbf69a4b3, 0x4009c927, 0xbf282958,
    0x3fb89891, 0x3df8c964, 0xbffaba82, 0x3e3468d7,
    0x3f839536, 0x402d10de, 0xbe4ac0de, 0x3f74d307,
    0x3e2fa3a5, 0xbf970ba1, 0x3fd9356b, 0xbf099a15,
    0xc0227e0e, 0x40809c31, 0xc0408765, 0x408f0542,
    0x3fa5d65b, 0x3f91ba4a, 0xbed3b592, 0xbf305428,
    0xbf281321, 0xbe813bc8, 0xbed8b171, 0x405baf96,
    0x3eec69cd, 0x400201d4, 0x3ee00258, 0x407f4d0a,
    0x3fdafcd9, 0x3fc40b99, 0xbfcfa984, 0x3f35b9e4,
    0xbf0268af, 0xc008f4a3, 0x4017d4fe, 0xc04132d8,
    0xbf87efa8, 0xbed44c22, 0x3f850f53, 0x3f5b7b3a,
    0x3f7d0a97, 0xbf6e85ad, 0x3e7274c7, 0x3fb09e1e,
    0xbf2d75e3, 0xbfb46bf9, 0x4062e984, 0x3eb687f8,
    0xc08d3ba8, 0xbf6b0bfc, 0xc077c794, 0x3fd19f58,
    0xbf199a7e, 0x409a3eb4, 0x3dc1d960, 0xbef319f1,
    0xbf54dc39, 0x3f398a7e, 0xc00cea1b, 0x3f568c6d,
    0xbf531a6f, 0xbecdaa46, 0x3d9fb0c2, 0xbd9f9ff9,
    0x3f1c8550, 0xc048670f, 0xbfe6c5a7, 0x405a4ac1,
    0xbfb6bd81, 0x40156ded, 0xbf5ad1ae, 0xbf974faa,
    0x3ed66da3, 0xbdef1967, 0xbf01fdd7, 0x4051c6b3,
    0x401d0257, 0xc000ed0e, 0xbf028bc5, 0x3ebddd1b,
    0x3e9586ea, 0xbefabd24, 0x3efe7528, 0x3ef00bab,
    0xbef67dab, 0x402b753d, 0xbfa2e653, 0xbd9cce21,
    0x3f0d54c8, 0xbfda4a6c, 0xc0812fc3, 0xc0022a08,
    0xbfec815d, 0xc0515e47, 0x3fcdd640, 0xbf6153a4,
    0x3f8ca112, 0xbf4a3dbd, 0xc082e678, 0xbe328dea,
    0xbfff0651, 0x3f08445d, 0x40019857, 0xbfb538cd,
    0xbf9e361b, 0xbdd0f36b, 0xbfe9bdae, 0x3e0d3ca2,
    0xbef4e29e, 0x3f2d1b4c, 0x3f8bce5a, 0x3f31ae35,
    0x3e78bde0, 0xc004bd1c, 0x3eaa0ffc, 0x3e210919,
    0x402f2e99, 0xc0271067, 0xc015efc6, 0xbec7c235,
    0xc0017bfd, 0x3fe839d2, 0xc0506953, 0xbfe451f8,
    0x3fe066f2, 0x4070a368, 0x3f17b110, 0xc0284e6f,
    0x400a0930, 0x3fa827e8, 0x3faadf1f, 0xc009947d,
    0xc00cb6a2, 0x40566d4c, 0x3f9752e2, 0x3fa4539e,
    0xbf49e705, 0xbf6d68ae, 0x3e8901e1, 0xbf5af910,
    0x3f2c0762, 0xbe5e11a5, 0x3f9c2210, 0x3e2a41e8,
    0x3f4ae8df, 0x3e3a0c49, 0x3eef8a06, 0x40457f4b,
    0x3fb757f6, 0xbf6d43e4, 0x3e3bc47e, 0xbfe19272,
    0xbfbba3f4, 0xc09d1ad5, 0x3e260c7f, 0x3f4e6787,
    0x3ebb8dc4, 0x3fe92335, 0xbe9aa52f, 0xbf537e35,
    0xbfb95584, 0x3efbcd20, 0x3e5d5328, 0x3f20ec95,
    0xbfcb1700, 0xbfefc537, 0xbe693fae, 0xbd7c6210,
    0xbf70e6fc, 0xbfe11e63, 0x3f331f64, 0x3f5141d0,
    0xc0303516, 0x3e1c147c, 0x406e4fd3, 0x3f797d5b,
    0x40226305, 0x3eb15efb, 0x40472f9d, 0xc0231545,
    0xbf604823, 0x3fc83a17, 0xbfd0da8d, 0x3ff5c6cf,
    0x3dc29426, 0xc0283b29, 0xbf77aaba, 0xbe73e5b3,
    0xbf521414, 0x3fb2362a, 0x3f7f21e2, 0xbf06c8fe,
    0x3efa8afd, 0xbfb25301, 0x3ed02dd6, 0x3f884571,
    0x3f244007, 0xbf635949, 0xbfe81a6c, 0x401e1d6e,
    0x3eb3e454, 0xbc6c2c04, 0xbe8a6858, 0x400467ea,
    0x402d0e47, 0x3ef630e1, 0x3fc37d33, 0x3fdd69d0,
    0xbe9a4913, 0x3ec74d71, 0xbf719dcd, 0x3f5130e3,
    0x3f2081fd, 0x3ebd5d99, 0xbfabf6af, 0xc048596c
    };

static const uint32_t in_cfft_noisy_4096[8192] = {
    0x3d991af7, 0x0, 0x3ef3b85b, 0x0,
    0x3f35f7b1, 0x0, 0x3f092f0b, 0x0,
    0xbce5be53, 0x0, 0xbeceb3a3, 0x0,
    0xbf3596db, 0x0, 0xbef22ccf, 0x0,
    0xbc1bd435, 0x0, 0x3ee0944a, 0x0,
    0x3f1f30cb, 0x0, 0x3f0beb84, 0x0,
    0xbb8469d5, 0x0, 0xbef0d11b, 0x0,
    0xbf30b66b, 0x0, 0xbf033f62, 0x0,
    0xbc441afb, 0x0, 0x3f04547b, 0x0,
    0x3f457cfd, 0x0, 0x3ed5f63e, 0x0,
    0x3d37ebf9, 0x0, 0xbf1f2ffa, 0x0,
    0xbf2aa721, 0x0, 0xbf0b111f, 0x0,
    0x3c8fb3dc, 0x0, 0x3f15995c, 0x0,
    0x3f340e28, 0x0, 0x3ef8e455, 0x0,
    0x3da7d807, 0x0, 0xbf0e01f6, 0x0,
    0xbf37188a, 0x0, 0xbf01f269, 0x0,
    0xbc53457a, 0x0, 0x3ef3e94b, 0x0,
    0x3f363ce7, 0x0, 0x3ed8b5fa, 0x0,
    0xbcbd80a1, 0x0, 0xbf0ca61c, 0x0,
    0xbf378bfe, 0x0, 0xbf03eb87, 0x0,
    0x3da7c0bd, 0x0, 0x3f08d670, 0x0,
    0x3f2dbb2d, 0x0, 0x3ee48337, 0x0,
    0x3c2fc2bc, 0x0, 0xbf004555, 0x0,
    0xbf326627, 0x0, 0xbf0dce78, 0x0,
    0x3cea2fc5, 0x0, 0x3f0a3e21, 0x0,
    0x3f2c4e7f, 0x0, 0x3f19d6eb, 0x0,
    0x3db97cda, 0x0, 0xbef0238c, 0x0,
    0xbf326676, 0x0, 0xbf0969ce, 0x0,
    0x3c0d5753, 0x0, 0x3ee44528, 0x0,
    0x3f3015b3, 0x0, 0x3f0bcd5e, 0x0,
    0xbd516774, 0x0, 0xbf08bc00, 0x0,
    0xbf254b1b, 0x0, 0xbf000e24, 0x0,
    0xbdc05cd1, 0x0, 0x3ee543fb, 0x0,
    0x3f350d21, 0x0, 0x3f02c8e8, 0x0,
    0x3d37969a, 0x0, 0xbf017f04, 0x0,
    0xbf3605d0, 0x0, 0xbeedd3da, 0x0,
    0xbdce4592, 0x0, 0x3f1084bb, 0x0,
    0x3f403b70, 0x0, 0x3eea4180, 0x0,
    0xbd5d2d9a, 0x0, 0xbeb61e92, 0x0,
    0xbf3731f9, 0x0, 0xbefd6b7f, 0x0,
    0xbdbcf001, 0x0, 0x3ed12aea, 0x0,
    0x3f4544a9, 0x0, 0x3ef62152, 0x0,
    0x3d7fd926, 0x0, 0xbef98b57, 0x0,
    0xbf30a384, 0x0, 0xbf12f524, 0x0,
    0xbb9bda84, 0x0, 0x3ec708ed, 0x0,
    0x3f34a87a, 0x0, 0x3ee98178, 0x0,
    0xbd801bfa, 0x0, 0xbf13b1ff, 0x0,
    0xbf479963, 0x0, 0xbed6f1be, 0x0,
    0xbce85a7d, 0x0, 0x3f01c0cb, 0x0,
    0x3f36860b, 0x0, 0x3f032c6c, 0x0,
    0x3cbf5f81, 0x0, 0xbefce56c, 0x0,
    0xbf20dd4b, 0x0, 0xbefc87c4, 0x0,
    0xbc8db1b0, 0x0, 0x3f0a4d90, 0x0,
    0x3f23cd04, 0x0, 0x3f02093e, 0x0,
    0xbd21f453, 0x0, 0xbef15097, 0x0,
    0xbf1bfb5a, 0x0, 0xbef41597, 0x0,
    0xbdb36f90, 0x0, 0x3f134ea8, 0x0,
    0x3f548a6e, 0x0, 0x3f00ec9b, 0x0,
    0x3cc4c0ab, 0x0, 0xbef40d58, 0x0,
    0xbf427a45, 0x0, 0xbefcbbdc, 0x0,
    0x3bb98b44, 0x0, 0x3eff04af, 0x0,
    0x3f30b2be, 0x0, 0x3f0da03f, 0x0,
    0x3bee0bee, 0x0, 0xbf047e68, 0x0,
    0xbf3457af, 0x0, 0xbef6a8bd, 0x0,
    0x3e044dd4, 0x0, 0x3f0e6567, 0x0,
    0x3f23b20d, 0x0, 0x3eeb2cd2, 0x0,
    0xbde3b822, 0x0, 0xbf1154e1, 0x0,
    0xbf3e7895, 0x0, 0xbeeb4be0, 0x0,
    0x3ca0e5cc, 0x0, 0x3f032fff, 0x0,
    0x3f199a8d, 0x0, 0x3efd8e85, 0x0,
    0xbcf5f387, 0x0, 0xbf08f628, 0x0,
    0xbf50aa1c, 0x0, 0xbebc2af1, 0x0,
    0xbd360146, 0x0, 0x3ef6b717, 0x0,
    0x3f301c0a, 0x0, 0x3ee4990d, 0x0,
    0x3ca50955, 0x0, 0xbeeced0c, 0x0,
    0xbf2b776b, 0x0, 0xbf0a62b5, 0x0,
    0x3d700271, 0x0, 0x3efcc5fa, 0x0,
    0x3f3cbb65, 0x0, 0x3f123bf1, 0x0,
    0xba7ee5a8, 0x0, 0xbf0741cd, 0x0,
    0xbf2fd29c, 0x0, 0xbf00c7c8, 0x0,
    0xbc4d08d4, 0x0, 0x3f0d527c, 0x0,
    0x3f27c4a6, 0x0, 0x3f02a5b3, 0x0,
    0xbc4c181b, 0x0, 0xbeffae09, 0x0,
    0xbf2d6e84, 0x0, 0xbef8c3ed, 0x0,
    0xbb571b71, 0x0, 0x3ef2f7d1, 0x0,
    0x3f405041, 0x0, 0x3eee9cb4, 0x0,
    0xbda95526, 0x0, 0xbf0726f0, 0x0,
    0xbf3ae197, 0x0, 0xbeee9789, 0x0,
    0x3c61c931, 0x0, 0x3f0ab73b, 0x0,
    0x3f397db1, 0x0, 0x3eff93b1, 0x0,
    0x3cb9afd1, 0x0, 0xbef4b868, 0x0,
    0xbf3733b2, 0x0, 0xbf0d8074, 0x0,
    0xbd9a1bf4, 0x0, 0x3edc942b, 0x0,
    0x3f2b1cd4, 0x0, 0x3ec4fb95, 0x0,
    0xbced3405, 0x0, 0xbf013d23, 0x0,
    0xbf5063c9, 0x0, 0xbef1944b, 0x0,
    0xbc27cb12, 0x0, 0x3ef56309, 0x0,
    0x3f2fe6c5, 0x0, 0x3f02055a, 0x0,
    0x3c102c8e, 0x0, 0xbef454a6, 0x0,
    0xbf4a99c3, 0x0, 0xbef7dda2, 0x0,
    0xbc02cbcb, 0x0, 0x3efbbfe3, 0x0,
    0x3f49ee37, 0x0, 0x3f15aa40, 0x0,
    0xbba64da9, 0x0, 0xbee70cb8, 0x0,
    0xbf2627b1, 0x0, 0xbefeccb3, 0x0,
    0x3d3c175b, 0x0, 0x3efe0019, 0x0,
    0x3f34b028, 0x0, 0x3f07a817, 0x0,
    0x3da5858b, 0x0, 0xbf0beee9, 0x0,
    0xbf22cccc, 0x0, 0xbeee284a, 0x0,
    0xbd31385d, 0x0, 0x3edad8c8, 0x0,
    0x3f34cd91, 0x0, 0x3f021757, 0x0,
    0x3c7663fb, 0x0, 0xbecab8bc, 0x0,
    0xbf381142, 0x0, 0xbf05f0d1, 0x0,
    0x3d14be6e, 0x0, 0x3f016d87, 0x0,
    0x3f2884b2, 0x0, 0x3f001c9b, 0x0,
    0x3b458008, 0x0, 0xbf08d928, 0x0,
    0xbf32b44f, 0x0, 0xbeec6a56, 0x0,
    0x3da7879b, 0x0, 0x3f137c7b, 0x0,
    0x3f3212f5, 0x0, 0x3f0576a8, 0x0,
    0xbd9089e1, 0x0, 0xbeef327e, 0x0,
    0xbf30705b, 0x0, 0xbee83faf, 0x0,
    0x3daf9a4c, 0x0, 0x3f0b198c, 0x0,
    0x3f412c29, 0x0, 0x3f15cc4c, 0x0,
    0x3d39c6e6, 0x0, 0xbf10a781, 0x0,
    0xbf3c3f79, 0x0, 0xbeff2c7c, 0x0,
    0xbc780e29, 0x0, 0x3ece43b7, 0x0,
    0x3f3da03d, 0x0, 0x3f04839a, 0x0,
    0xbd6713a0, 0x0, 0xbf1716eb, 0x0,
    0xbf27b4f8, 0x0, 0xbefe9ddb, 0x0,
    0xbd9751d7, 0x0, 0x3ef780c2, 0x0,
    0x3f2f360a, 0x0, 0x3f15bff5, 0x0,
    0xbc445a96, 0x0, 0xbee2de20, 0x0,
    0xbf1e2fb8, 0x0, 0xbed6c7a6, 0x0,
    0xbcb2081f, 0x0, 0x3f1ac5ae, 0x0,
    0x3f459ebe, 0x0, 0x3f0ab9da, 0x0,
    0xbd1a8d0c, 0x0, 0xbee13061, 0x0,
    0xbf2e472a, 0x0, 0xbf05b081, 0x0,
    0xbd847d42, 0x0, 0x3efbebbe, 0x0,
    0x3f28b51f, 0x0, 0x3f083459, 0x0,
    0x3d18ef16, 0x0, 0xbf06ec3f, 0x0,
    0xbf4e91d0, 0x0, 0xbf147558, 0x0,
    0x3d6f588c, 0x0, 0x3f180447, 0x0,
    0x3f300f57, 0x0, 0x3f0331e0, 0x0,
    0xbc04bddc, 0x0, 0xbefa7421, 0x0,
    0xbf345ca4, 0x0, 0xbf18a0fb, 0x0,
    0x3d1f3246, 0x0, 0x3f03db6f, 0x0,
    0x3f43008a, 0x0, 0x3ecdd6e6, 0x0,
    0xbd8445e8, 0x0, 0xbf0174d3, 0x0,
    0xbf27097d, 0x0, 0xbf0690ca, 0x0,
    0xbc6374bc, 0x0, 0x3ef52907, 0x0,
    0x3f224feb, 0x0, 0x3eefa5e0, 0x0,
    0xbd5cc753, 0x0, 0xbf00a8fc, 0x0,
    0xbf459deb, 0x0, 0xbf0f2af9, 0x0,
    0xbcd70e76, 0x0, 0x3f10dd11, 0x0,
    0x3f213de4, 0x0, 0x3f0915a4, 0x0,
    0xbd0594e4, 0x0, 0xbef6b1cd, 0x0,
    0xbf31b3c1, 0x0, 0xbef5936b, 0x0,
    0x3ce2dd4a, 0x0, 0x3f0c7293, 0x0,
    0x3f25458c, 0x0, 0x3f1162bb, 0x0,
    0xbc7ca350, 0x0, 0xbf088c4c, 0x0,
    0xbf2aa216, 0x0, 0xbf0359b0, 0x0,
    0x3d24b02d, 0x0, 0x3efe5dc1, 0x0,
    0x3f28d88f, 0x0, 0x3f010768, 0x0,
    0xbe04e230, 0x0, 0xbf050acd, 0x0,
    0xbf3f4b2a, 0x0, 0xbef8f9b5, 0x0,
    0x3d51aeda, 0x0, 0x3f039ea6, 0x0,
    0x3f2ca1b6, 0x0, 0x3f05b1f5, 0x0,
    0x3bc99595, 0x0, 0xbf1310a0, 0x0,
    0xbf3c1433, 0x0, 0xbeec3799, 0x0,
    0x3b781e03, 0x0, 0x3f1268ed, 0x0,
    0x3f40bd45, 0x0, 0x3f01edfd, 0x0,
    0xbd9ac2e1, 0x0, 0xbeea2efa, 0x0,
    0xbf358c78, 0x0, 0xbf0ac6ee, 0x0,
    0x3bd48398, 0x0, 0x3ee569ab, 0x0,
    0x3f29b903, 0x0, 0x3ef6aa9a, 0x0,
    0xbd2b8e59, 0x0, 0xbf139310, 0x0,
    0xbf37c1fa, 0x0, 0xbeef59d9, 0x0,
    0x3cb436b0, 0x0, 0x3f03d685, 0x0,
    0x3f38affa, 0x0, 0x3f00bea1, 0x0,
    0xbd23dc43, 0x0, 0xbed9d49b, 0x0,
    0xbf264a7c, 0x0, 0xbefb6a75, 0x0,
    0x3d3d44cc, 0x0, 0x3edeb0ba, 0x0,
    0x3f25aeb5, 0x0, 0x3efcc27a, 0x0,
    0x3c468b21, 0x0, 0xbf0451b0, 0x0,
    0xbf441075, 0x0, 0xbf06f28f, 0x0,
    0xbd935ddc, 0x0, 0x3ef1069e, 0x0,
    0x3f38eae3, 0x0, 0x3eeecc20, 0x0,
    0x3d8abfff, 0x0, 0xbf0ad13c, 0x0,
    0xbf3a9adf, 0x0, 0xbf0b3fa0, 0x0,
    0x3d506b44, 0x0, 0x3f0e8f29, 0x0,
    0x3f28d89e, 0x0, 0x3eccb944, 0x0,
    0x3c7d7a58, 0x0, 0xbf1ef8b6, 0x0,
    0xbf23df2e, 0x0, 0xbed6f534, 0x0,
    0xbd06bebe, 0x0, 0x3f0566e1, 0x0,
    0x3f31d40d, 0x0, 0x3f0539f7, 0x0,
    0xbd85b9b3, 0x0, 0xbeedd984, 0x0,
    0xbf310997, 0x0, 0xbf02a023, 0x0,
    0x3db59f01, 0x0, 0x3ee742ac, 0x0,
    0x3f253f20, 0x0, 0x3f0d4ab6, 0x0,
    0x3d375454, 0x0, 0xbf0640f5, 0x0,
    0xbf2dac81, 0x0, 0xbf0237cd, 0x0,
    0xbd28b94d, 0x0, 0x3eee20a0, 0x0,
    0x3f2b4d62, 0x0, 0x3f04b552, 0x0,
    0xbd491767, 0x0, 0xbee4203e, 0x0,
    0xbf2aa5d4, 0x0, 0xbee621db, 0x0,
    0x3cf3ddcc, 0x0, 0x3ee7b488, 0x0,
    0x3f412c14, 0x0, 0x3f15d8ea, 0x0,
    0x3d69e456, 0x0, 0xbef9b57d, 0x0,
    0xbf29907f, 0x0, 0xbf07ae51, 0x0,
    0x3d403338, 0x0, 0x3f099661, 0x0,
    0x3f2f4ba2, 0x0, 0x3f00417d, 0x0,
    0xbcfb96ac, 0x0, 0xbf082773, 0x0,
    0xbf24111b, 0x0, 0xbefaeb2e, 0x0,
    0x3df73f3b, 0x0, 0x3ee65baa, 0x0,
    0x3f348431, 0x0, 0x3ec9aca6, 0x0,
    0xbc98a9cb, 0x0, 0xbf0dd9d8, 0x0,
    0xbf342051, 0x0, 0xbec03f65, 0x0,
    0x3d52e441, 0x0, 0x3efd6c40, 0x0,
    0x3f372e26, 0x0, 0x3f027e06, 0x0,
    0x3cdb5ff5, 0x0, 0xbeeb5be2, 0x0,
    0xbf20a84e, 0x0, 0xbedc2893, 0x0,
    0xbd4b54ff, 0x0, 0x3f144eb6, 0x0,
    0x3f250b40, 0x0, 0x3f048220, 0x0,
    0xbc4ce0a4, 0x0, 0xbf0ac707, 0x0,
    0xbf168ee5, 0x0, 0xbefdc925, 0x0,
    0x3da6dfab, 0x0, 0x3f00bf21, 0x0,
    0x3f401bb6, 0x0, 0x3f0ea3d9, 0x0,
    0xbac0fbe0, 0x0, 0xbf06bc9b, 0x0,
    0xbf3458e7, 0x0, 0xbef41b25, 0x0,
    0x3bb6c6f9, 0x0, 0x3ec0e143, 0x0,
    0x3f480348, 0x0, 0x3f06418d, 0x0,
    0xbd6d82a4, 0x0, 0xbf0aa53f, 0x0,
    0xbf418f83, 0x0, 0xbed1eddd, 0x0,
    0x3d0a5670, 0x0, 0x3f073ef9, 0x0,
    0x3f2086c9, 0x0, 0x3f0d0027, 0x0,
    0xbd9d7022, 0x0, 0xbf0bfe2a, 0x0,
    0xbf3057e6, 0x0, 0xbf04f393, 0x0,
    0xbcca0615, 0x0, 0x3ee4ce89, 0x0,
    0x3f2cd7a3, 0x0, 0x3efa37f4, 0x0,
    0xb5cd543c, 0x0, 0xbf09da84, 0x0,
    0xbf3949fd, 0x0, 0xbf02d49f, 0x0,
    0x3c9732cf, 0x0, 0x3f092260, 0x0,
    0x3f2d9943, 0x0, 0x3f06b872, 0x0,
    0x3d17cd60, 0x0, 0xbef95dd0, 0x0,
    0xbf39e785, 0x0, 0xbf0a080c, 0x0,
    0xbc20acc0, 0x0, 0x3efa2671, 0x0,
    0x3f388cc4, 0x0, 0x3f0215f2, 0x0,
    0x3d0a5b36, 0x0, 0xbed95bfa, 0x0,
    0xbf44909c, 0x0, 0xbf0c7279, 0x0,
    0x3c02c0f0, 0x0, 0x3f0e0dca, 0x0,
    0x3f3ac4db, 0x0, 0x3ee7c4f9, 0x0,
    0x3d9b616f, 0x0, 0xbeee22f6, 0x0,
    0xbf2346b5, 0x0, 0xbef7f82c, 0x0,
    0xbd9c6b59, 0x0, 0x3ef1204e, 0x0,
    0x3f31ad80, 0x0, 0x3ed47e37, 0x0,
    0xbdc02fb8, 0x0, 0xbf1591fc, 0x0,
    0xbf21dd5c, 0x0, 0xbeeb8a98, 0x0,
    0x3c7543f8, 0x0, 0x3f0480b4, 0x0,
    0x3f3217e3, 0x0, 0x3ef4edf0, 0x0,
    0x3bbbce86, 0x0, 0xbef6bb55, 0x0,
    0xbf215959, 0x0, 0xbf05a141, 0x0,
    0xbdc33990, 0x0, 0x3ef85e01, 0x0,
    0x3f42db54, 0x0, 0x3ef0b71d, 0x0,
    0x3cc2de00, 0x0, 0xbeea08e2, 0x0,
    0xbf3e3c9f, 0x0, 0xbf028b7d, 0x0,
    0x3c28a195, 0x0, 0x3f0a7f9f, 0x0,
    0x3f3a839b, 0x0, 0x3f08c23b, 0x0,
    0xbc10240c, 0x0, 0xbeec69ff, 0x0,
    0xbf2b702f, 0x0, 0xbf08a8e4, 0x0,
    0x3ba5477d, 0x0, 0x3f1004f9, 0x0,
    0x3f48007c, 0x0, 0x3ee64acf, 0x0,
    0x3d8ce599, 0x0, 0xbf0e1857, 0x0,
    0xbf3171d6, 0x0, 0xbedfc9f4, 0x0,
    0x3d92227c, 0x0, 0x3ee737b8, 0x0,
    0x3f2f8f32, 0x0, 0x3f0c8976, 0x0,
    0x3c8866e5, 0x0, 0xbf03d276, 0x0,
    0xbf350580, 0x0, 0xbf04d05a, 0x0,
    0x3c8aaefa, 0x0, 0x3f168d46, 0x0,
    0x3f300a8c, 0x0, 0x3f00aa17, 0x0,
    0x3da3f105, 0x0, 0xbed85f90, 0x0,
    0xbf2abc01, 0x0, 0xbef0a34a, 0x0,
    0xbce08f8e, 0x0, 0x3ed17eec, 0x0,
    0x3f33b5dd, 0x0, 0x3f011cd4, 0x0,
    0x3d422aab, 0x0, 0xbf022fee, 0x0,
    0xbf4f3a2a, 0x0, 0xbec41e6d, 0x0,
    0xbd376ee5, 0x0, 0x3ee3c1a6, 0x0,
    0x3f39b528, 0x0, 0x3f05f017, 0x0,
    0xbc9fd601, 0x0, 0xbf0f6c92, 0x0,
    0xbf3a4834, 0x0, 0xbedc4c72, 0x0,
    0x3bc9f8de, 0x0, 0x3f13ea4d, 0x0,
    0x3f389ed8, 0x0, 0x3f13b39b, 0x0,
    0xbcbb4293, 0x0, 0xbef599a4, 0x0,
    0xbf2efaa4, 0x0, 0xbed8b6ec, 0x0,
    0xbd516873, 0x0, 0x3f0a88b6, 0x0,
    0x3f3bce6a, 0x0, 0x3f167d74, 0x0,
    0xbd969555, 0x0, 0xbf0fa2c3, 0x0,
    0xbf1c0bbc, 0x0, 0xbf02be7e, 0x0,
    0x3be90ba3, 0x0, 0x3ef0881c, 0x0,
    0x3f271a3f, 0x0, 0x3f0cb232, 0x0,
    0x3da680bd, 0x0, 0xbf040a22, 0x0,
    0xbf2eecc4, 0x0, 0xbeea2ded, 0x0,
    0xbccc6c6f, 0x0, 0x3ee80567, 0x0,
    0x3f1e3c2b, 0x0, 0x3f0c39a7, 0x0,
    0x3c4f57e8, 0x0, 0xbef075bf, 0x0,
    0xbf3fe505, 0x0, 0xbef05650, 0x0,
    0xbc3b7033, 0x0, 0x3f0b9836, 0x0,
    0x3f24860d, 0x0, 0x3ed555c3, 0x0,
    0x3d625cb4, 0x0, 0xbeef91a8, 0x0,
    0xbf2488a5, 0x0, 0xbee399a4, 0x0,
    0xbcccb2cf, 0x0, 0x3ef79185, 0x0,
    0x3f2cb407, 0x0, 0x3f037ff2, 0x0,
    0x3cc3b66e, 0x0, 0xbef18613, 0x0,
    0xbf3591c5, 0x0, 0xbf10ba9f, 0x0,
    0xbd9eb72b, 0x0, 0x3ecadc76, 0x0,
    0x3f355c90, 0x0, 0x3ef69797, 0x0,
    0x3cf6261e, 0x0, 0xbf03f511, 0x0,
    0xbf1d89d8, 0x0, 0xbee1296b, 0x0,
    0x3d443000, 0x0, 0x3f1180bc, 0x0,
    0x3f2a3228, 0x0, 0x3efb3026, 0x0,
    0x3d653be5, 0x0, 0xbf10f76b, 0x0,
    0xbf2405fb, 0x0, 0xbefec2eb, 0x0,
    0x3cd2ab19, 0x0, 0x3ef596c5, 0x0,
    0x3f37e83a, 0x0, 0x3eed757d, 0x0,
    0x3cbdd34b, 0x0, 0xbeebf07f, 0x0,
    0xbf3e0a90, 0x0, 0xbf05cbfc, 0x0,
    0xba8a1109, 0x0, 0x3f070365, 0x0,
    0x3f31b4f1, 0x0, 0x3f19a00f, 0x0,
    0x3ccbaed6, 0x0, 0xbefcc339, 0x0,
    0xbf2343d6, 0x0, 0xbf00d6bb, 0x0,
    0xbd836094, 0x0, 0x3eef378c, 0x0,
    0x3f1cd7fc, 0x0, 0x3ef6ec30, 0x0,
    0x3d6606b4, 0x0, 0xbedc71dd, 0x0,
    0xbf2c65d6, 0x0, 0xbeefc871, 0x0,
    0xbd17ecdb, 0x0, 0x3ef611ab, 0x0,
    0x3f2d23c5, 0x0, 0x3f06e161, 0x0,
    0x3cc23880, 0x0, 0xbee290f3, 0x0,
    0xbf35adef, 0x0, 0xbf0330ee, 0x0,
    0xbc146337, 0x0, 0x3f1895bd, 0x0,
    0x3f30d0d3, 0x0, 0x3f0c20ec, 0x0,
    0x3d14b7da, 0x0, 0xbf071391, 0x0,
    0xbf31970c, 0x0, 0xbf06f258, 0x0,
    0xbd0f985d, 0x0, 0x3ef7b9b0, 0x0,
    0x3f2815bb, 0x0, 0x3f0137e0, 0x0,
    0x390e126a, 0x0, 0xbef4baae, 0x0,
    0xbf266cba, 0x0, 0xbf03369c, 0x0,
    0xbc95ee63, 0x0, 0x3eec8ae6, 0x0,
    0x3f2ac076, 0x0, 0x3f0aa956, 0x0,
    0x3ca4f01f, 0x0, 0xbee1544d, 0x0,
    0xbf323628, 0x0, 0xbf0651c8, 0x0,
    0xbd3cd78f, 0x0, 0x3f148e9b, 0x0,
    0x3f44297f, 0x0, 0x3f0a3975, 0x0,
    0x3d2f1516, 0x0, 0xbef0659c, 0x0,
    0xbf272aab, 0x0, 0xbf09d344, 0x0,
    0x3c1b5cab, 0x0, 0x3ef5f56c, 0x0,
    0x3f339603, 0x0, 0x3ef5bfd1, 0x0,
    0x3d6327e5, 0x0, 0xbf136d1e, 0x0,
    0xbf1819f6, 0x0, 0xbee9a7a5, 0x0,
    0xbdb73f4c, 0x0, 0x3f06154a, 0x0,
    0x3f52062d, 0x0, 0x3ee86969, 0x0,
    0xbcbc016b, 0x0, 0xbf089927, 0x0,
    0xbf3a6b41, 0x0, 0xbf02d736, 0x0,
    0xbd338156, 0x0, 0x3f0a18f2, 0x0,
    0x3f3fe29f, 0x0, 0x3eff6419, 0x0,
    0x3d2971c3, 0x0, 0xbf0071ba, 0x0,
    0xbf27f923, 0x0, 0xbedeafbf, 0x0,
    0x3c9474cb, 0x0, 0x3efefaca, 0x0,
    0x3f32b56a, 0x0, 0x3f087ec9, 0x0,
    0x3d8dc00a, 0x0, 0xbef855a7, 0x0,
    0xbf32a8d6, 0x0, 0xbf08a1ce, 0x0,
    0xbe01851d, 0x0, 0x3ef64d09, 0x0,
    0x3f32f08d, 0x0, 0x3ee6b11f, 0x0,
    0xbc643024, 0x0, 0xbee94137, 0x0,
    0xbf3612fd, 0x0, 0xbf0473cd, 0x0,
    0xbdecce12, 0x0, 0x3f02be51, 0x0,
    0x3f39b76c, 0x0, 0x3f084ebb, 0x0,
    0x3d35a4bd, 0x0, 0xbf0a19b0, 0x0,
    0xbf200c9f, 0x0, 0xbee08ae8, 0x0,
    0xbd8c898a, 0x0, 0x3f109836, 0x0,
    0x3f308274, 0x0, 0x3f043677, 0x0,
    0xbcd500d4, 0x0, 0xbef2f53c, 0x0,
    0xbf3987c3, 0x0, 0xbf0f1078, 0x0,
    0xbe030730, 0x0, 0x3eff1f44, 0x0,
    0x3f264a8e, 0x0, 0x3ef25a62, 0x0,
    0xbc712e35, 0x0, 0xbf1065aa, 0x0,
    0xbf38c4cc, 0x0, 0xbf11df1a, 0x0,
    0x3d33ee09, 0x0, 0x3ef9d55b, 0x0,
    0x3f41a79c, 0x0, 0x3eea5361, 0x0,
    0x3d5e50d3, 0x0, 0xbeec1950, 0x0,
    0xbf32d2e7, 0x0, 0xbedf8b43, 0x0,
    0x3dfc96ed, 0x0, 0x3ee91fd3, 0x0,
    0x3f423510, 0x0, 0x3f04c053, 0x0,
    0xbd745ee0, 0x0, 0xbefb153a, 0x0,
    0xbf2b221f, 0x0, 0xbf01fa1e, 0x0,
    0x3d9e7fbf, 0x0, 0x3f0b70de, 0x0,
    0x3f2a341c, 0x0, 0x3efb348d, 0x0,
    0xbce0d694, 0x0, 0xbf159d4c, 0x0,
    0xbf314009, 0x0, 0xbf09dd61, 0x0,
    0xbc33b8d0, 0x0, 0x3f048522, 0x0,
    0x3f316b27, 0x0, 0x3eda1731, 0x0,
    0xbd8e25bd, 0x0, 0xbf17e7c8, 0x0,
    0xbf2ec378, 0x0, 0xbef2406d, 0x0,
    0xbdba7ad4, 0x0, 0x3f13a21e, 0x0,
    0x3f34a516, 0x0, 0x3f0b174b, 0x0,
    0xbc4f9de5, 0x0, 0xbee3dd62, 0x0,
    0xbf2aa1e9, 0x0, 0xbecc247e, 0x0,
    0x3c233bd6, 0x0, 0x3ef2e90e, 0x0,
    0x3f35407d, 0x0, 0x3ee56b87, 0x0,
    0x3bae26ba, 0x0, 0xbeea9f36, 0x0,
    0xbf37025f, 0x0, 0xbf04f83c, 0x0,
    0x3dd78a25, 0x0, 0x3f0022de, 0x0,
    0x3f34f28a, 0x0, 0x3ef3f8db, 0x0,
    0xbd98682b, 0x0, 0xbf0a065d, 0x0,
    0xbf3b357c, 0x0, 0xbed3072d, 0x0,
    0xbd23bfa8, 0x0, 0x3f081971, 0x0,
    0x3f34486b, 0x0, 0x3edda7d4, 0x0,
    0x3d19d119, 0x0, 0xbf0b9b1a, 0x0,
    0xbf4571b1, 0x0, 0xbef2e177, 0x0,
    0x3bf9a177, 0x0, 0x3ef290da, 0x0,
    0x3f3a992b, 0x0, 0x3ef926bb, 0x0,
    0x3d2b5d50, 0x0, 0xbf0a3386, 0x0,
    0xbf2f63ed, 0x0, 0xbed256d9, 0x0,
    0x3d8aed0b, 0x0, 0x3f0cfd03, 0x0,
    0x3f26841e, 0x0, 0x3ef9d5be, 0x0,
    0x3d044bd8, 0x0, 0xbf198e1b, 0x0,
    0xbf47c857, 0x0, 0xbef4cb24, 0x0,
    0x3c073d1d, 0x0, 0x3f054c90, 0x0,
    0x3f3d639e, 0x0, 0x3ee8f365, 0x0,
    0x3bcdc7f1, 0x0, 0xbef8d235, 0x0,
    0xbf2da489, 0x0, 0xbee7fd34, 0x0,
    0x3d200bd3, 0x0, 0x3ee16b24, 0x0,
    0x3f3244a3, 0x0, 0x3f0dc25b, 0x0,
    0xbce2fca3, 0x0, 0xbeeb38e8, 0x0,
    0xbf1bb2e3, 0x0, 0xbede2102, 0x0,
    0x3d0bd547, 0x0, 0x3ee5abd0, 0x0,
    0x3f245b45, 0x0, 0x3eed7cd1, 0x0,
    0xbce69b7f, 0x0, 0xbf0f9fe0, 0x0,
    0xbf3725aa, 0x0, 0xbf1eade9, 0x0,
    0x3e20dc31, 0x0, 0x3f141a97, 0x0,
    0x3f46c59c, 0x0, 0x3eef5238, 0x0,
    0x3c9381e0, 0x0, 0xbed758fb, 0x0,
    0xbf374960, 0x0, 0xbf0b39f6, 0x0,
    0xbd345acd, 0x0, 0x3f09a8f5, 0x0,
    0x3f3b013a, 0x0, 0x3f03df11, 0x0,
    0x3c4d8028, 0x0, 0xbf082d7b, 0x0,
    0xbf356999, 0x0, 0xbef2bec4, 0x0,
    0x3c73233d, 0x0, 0x3f0809a7, 0x0,
    0x3f130663, 0x0, 0x3f0b0906, 0x0,
    0x3d82e6d2, 0x0, 0xbf0d1f76, 0x0,
    0xbf3ee25d, 0x0, 0xbf1358fb, 0x0,
    0xbd5a7969, 0x0, 0x3ecc188d, 0x0,
    0x3f348ac9, 0x0, 0x3efd6599, 0x0,
    0x3ca88394, 0x0, 0xbf13ae96, 0x0,
    0xbf31f7c5, 0x0, 0xbeeb8bdd, 0x0,
    0xbd86a003, 0x0, 0x3efbcdb4, 0x0,
    0x3f2b65b9, 0x0, 0x3f02fbe4, 0x0,
    0xbb082198, 0x0, 0xbf02d00a, 0x0,
    0xbf263253, 0x0, 0xbf034b60, 0x0,
    0xbcc53c52, 0x0, 0x3f02bd8b, 0x0,
    0x3f261138, 0x0, 0x3ee01339, 0x0,
    0xbd4fb813, 0x0, 0xbeec7d63, 0x0,
    0xbf2d237b, 0x0, 0xbf1069cf, 0x0,
    0x3d1f599d, 0x0, 0x3efe048b, 0x0,
    0x3f27e39c, 0x0, 0x3f0e1221, 0x0,
    0x3a5b2bc4, 0x0, 0xbf02be60, 0x0,
    0xbf49aed9, 0x0, 0xbef7eeb7, 0x0,
    0xbcea7653, 0x0, 0x3edf484e, 0x0,
    0x3f200552, 0x0, 0x3efc8207, 0x0,
    0x3c63a4e3, 0x0, 0xbee9d92d, 0x0,
    0xbf336a7a, 0x0, 0xbf0dc0f0, 0x0,
    0xbdb79c35, 0x0, 0x3ef8c7ae, 0x0,
    0x3f289694, 0x0, 0x3ef8c3ac, 0x0,
    0xbce73b09, 0x0, 0xbee09e59, 0x0,
    0xbf362035, 0x0, 0xbedb1d92, 0x0,
    0xbc8fe5bd, 0x0, 0x3efaa130, 0x0,
    0x3f41640f, 0x0, 0x3edd7ad9, 0x0,
    0x3c5e3b86, 0x0, 0xbee0b6b1, 0x0,
    0xbf2acf46, 0x0, 0xbf006485, 0x0,
    0xbcc41e1d, 0x0, 0x3f130fcf, 0x0,
    0x3f2d25e2, 0x0, 0x3f117cbc, 0x0,
    0x3d9e9a54, 0x0, 0xbeee0cc0, 0x0,
    0xbf337f18, 0x0, 0xbefc6727, 0x0,
    0x3c3a7092, 0x0, 0x3efc18ad, 0x0,
    0x3f2b78dd, 0x0, 0x3eefe0bb, 0x0,
    0x3ceb3cd8, 0x0, 0xbf00b845, 0x0,
    0xbf375196, 0x0, 0xbf07c90d, 0x0,
    0x3d13f85e, 0x0, 0x3ef8f9c1, 0x0,
    0x3f2f8017, 0x0, 0x3f0d67e7, 0x0,
    0xbcdbca7c, 0x0, 0xbefc0f80, 0x0,
    0xbf1ea94b, 0x0, 0xbefb2c70, 0x0,
    0xbc05b0bc, 0x0, 0x3f02dbea, 0x0,
    0x3f41a853, 0x0, 0x3f016bfa, 0x0,
    0xbaa9dc11, 0x0, 0xbef0c1fc, 0x0,
    0xbf0f3c55, 0x0, 0xbeeff014, 0x0,
    0x3ca2e831, 0x0, 0x3efafd58, 0x0,
    0x3f42f6e1, 0x0, 0x3f06275b, 0x0,
    0xbbf8eef2, 0x0, 0xbf008a21, 0x0,
    0xbf435f38, 0x0, 0xbeea77ed, 0x0,
    0xbbde9c6f, 0x0, 0x3f0a8a49, 0x0,
    0x3f36cd79, 0x0, 0x3f08937f, 0x0,
    0xbd610a81, 0x0, 0xbec81329, 0x0,
    0xbf2ee25f, 0x0, 0xbf0c51a2, 0x0,
    0x3be5fadb, 0x0, 0x3ed96b2e, 0x0,
    0x3f2d0c5d, 0x0, 0x3f0cc43c, 0x0,
    0xbcdd83aa, 0x0, 0xbedd7673, 0x0,
    0xbf16a03a, 0x0, 0xbef9f8a6, 0x0,
    0xbb666801, 0x0, 0x3ef43d3b, 0x0,
    0x3f2a3974, 0x0, 0x3efeb3ad, 0x0,
    0x3dae5368, 0x0, 0xbf12fbb6, 0x0,
    0xbf2a08e8, 0x0, 0xbf0b88ff, 0x0,
    0xbd708fa2, 0x0, 0x3f28d5d1, 0x0,
    0x3f1c4b3d, 0x0, 0x3efbd0a5, 0x0,
    0x3d86ea4f, 0x0, 0xbef15f68, 0x0,
    0xbf2309f6, 0x0, 0xbef1128b, 0x0,
    0x3cc50885, 0x0, 0x3f067bb6, 0x0,
    0x3f178467, 0x0, 0x3f135252, 0x0,
    0xbd4500ef, 0x0, 0xbf0ba05c, 0x0,
    0xbf484782, 0x0, 0xbf0396d6, 0x0,
    0xbca1f9a6, 0x0, 0x3ef8e4df, 0x0,
    0x3f40de92, 0x0, 0x3eeb482c, 0x0,
    0xbd49337f, 0x0, 0xbf0d0b8e, 0x0,
    0xbf3032aa, 0x0, 0xbf0006e0, 0x0,
    0x3d720235, 0x0, 0x3ee520cf, 0x0,
    0x3f38bb4f, 0x0, 0x3f1bf725, 0x0,
    0x3d0e7773, 0x0, 0xbef7fec7, 0x0,
    0xbf1d1c35, 0x0, 0xbf08c5ed, 0x0,
    0x3d901d7f, 0x0, 0x3f167c91, 0x0,
    0x3f4415af, 0x0, 0x3f0c2b1d, 0x0,
    0x3ca04d22, 0x0, 0xbee8d2ae, 0x0,
    0xbf2d28cf, 0x0, 0xbf046f4f, 0x0,
    0x3d5ce70b, 0x0, 0x3f0b706d, 0x0,
    0x3f3f9888, 0x0, 0x3f04b0f4, 0x0,
    0xbb0f1ef6, 0x0, 0xbf14872e, 0x0,
    0xbf27a957, 0x0, 0xbf00a0aa, 0x0,
    0xba920014, 0x0, 0x3f04ec07, 0x0,
    0x3f3157d0, 0x0, 0x3f0a7956, 0x0,
    0xbd6588fa, 0x0, 0xbf0df099, 0x0,
    0xbf327f50, 0x0, 0xbefa3167, 0x0,
    0xbd627b0d, 0x0, 0x3ef9b841, 0x0,
    0x3f3c57fd, 0x0, 0x3f02cee2, 0x0,
    0xbca6b0d9, 0x0, 0xbeffdf6a, 0x0,
    0xbf23f16a, 0x0, 0xbf0ecc6e, 0x0,
    0x3ba6c038, 0x0, 0x3f0c153c, 0x0,
    0x3f21ad8b, 0x0, 0x3efe287c, 0x0,
    0x3d657522, 0x0, 0xbef997b9, 0x0,
    0xbf3994f0, 0x0, 0xbed98c21, 0x0,
    0x3dadaa01, 0x0, 0x3f07e638, 0x0,
    0x3f2c1fd5, 0x0, 0x3ef1be0e, 0x0,
    0xbcbfbaa7, 0x0, 0xbf010b89, 0x0,
    0xbf2d7972, 0x0, 0xbf05e01f, 0x0,
    0xbc148392, 0x0, 0x3eef7562, 0x0,
    0x3f2ff069, 0x0, 0x3ef26d0c, 0x0,
    0xbcd65948, 0x0, 0xbedd7d02, 0x0,
    0xbf40efa3, 0x0, 0xbeec7364, 0x0,
    0xbcf776ba, 0x0, 0x3efd2f10, 0x0,
    0x3f36af74, 0x0, 0x3f033bd3, 0x0,
    0x3d331abe, 0x0, 0xbf057e92, 0x0,
    0xbf36d071, 0x0, 0xbefe6705, 0x0,
    0xba6c9c3d, 0x0, 0x3f0842f3, 0x0,
    0x3f2411f1, 0x0, 0x3ee57d4f, 0x0,
    0xbcdb6d7e, 0x0, 0xbf09ae1b, 0x0,
    0xbf240e0d, 0x0, 0xbef6621d, 0x0,
    0xbc1da6eb, 0x0, 0x3ef69a52, 0x0,
    0x3f459aa6, 0x0, 0x3ef1f91b, 0x0,
    0x3cc7a58d, 0x0, 0xbef9fdd6, 0x0,
    0xbf3e1f9b, 0x0, 0xbeecd1c3, 0x0,
    0xbd9683c0, 0x0, 0x3f0ad698, 0x0,
    0x3f37f219, 0x0, 0x3f0cbd3a, 0x0,
    0x3ae5ac5c, 0x0, 0xbef8830c, 0x0,
    0xbf29eea7, 0x0, 0xbf0c862c, 0x0,
    0x3dbe30fb, 0x0, 0x3ef5ee89, 0x0,
    0x3f33b042, 0x0, 0x3f03ed5c, 0x0,
    0x3cdab8fb, 0x0, 0xbef88bb9, 0x0,
    0xbf233323, 0x0, 0xbeff5ab4, 0x0,
    0x3d27d70d, 0x0, 0x3eedefdc, 0x0,
    0x3f2c2e6b, 0x0, 0x3f055bde, 0x0,
    0x3ca26221, 0x0, 0xbf06dc1f, 0x0,
    0xbf3deaa6, 0x0, 0xbefd04bc, 0x0,
    0x3cc049c3, 0x0, 0x3ee03fe7, 0x0,
    0x3f2fcab1, 0x0, 0x3ee90064, 0x0,
    0x3de41f2f, 0x0, 0xbee3fd4e, 0x0,
    0xbf311f98, 0x0, 0xbec3e173, 0x0,
    0x3cc33c47, 0x0, 0x3f02714f, 0x0,
    0x3f1220e1, 0x0, 0x3f08e28d, 0x0,
    0xbd929af1, 0x0, 0xbf00c3c1, 0x0,
    0xbf32d7ad, 0x0, 0xbf0f670f, 0x0,
    0x3c019ca6, 0x0, 0x3f166b82, 0x0,
    0x3f40fa75, 0x0, 0x3ed5375d, 0x0,
    0xbd5b56a4, 0x0, 0xbefe1401, 0x0,
    0xbf3d28b0, 0x0, 0xbed1ddf9, 0x0,
    0x3bace412, 0x0, 0x3f0f2045, 0x0,
    0x3f3d76d8, 0x0, 0x3f00aa5b, 0x0,
    0x3ddaaa58, 0x0, 0xbee9f61e, 0x0,
    0xbf39d35e, 0x0, 0xbeeb5fc1, 0x0,
    0x3d3e353f, 0x0, 0x3f0f780f, 0x0,
    0x3f4332f0, 0x0, 0x3efbeedc, 0x0,
    0xbcc83ebb, 0x0, 0xbee13e8a, 0x0,
    0xbf2e9494, 0x0, 0xbf11f6dd, 0x0,
    0xbcd5ce54, 0x0, 0x3efd6f6a, 0x0,
    0x3f274d1a, 0x0, 0x3f00777a, 0x0,
    0x3ceb51d0, 0x0, 0xbed66185, 0x0,
    0xbf52e934, 0x0, 0xbefb379e, 0x0,
    0xbcd6e45c, 0x0, 0x3eea66a9, 0x0,
    0x3f3a8a2e, 0x0, 0x3eef57fa, 0x0,
    0xbd28c81d, 0x0, 0xbf070903, 0x0,
    0xbf1c0a4f, 0x0, 0xbef83cc2, 0x0,
    0xbca86cf5, 0x0, 0x3ed0bedd, 0x0,
    0x3f2ae821, 0x0, 0x3f0224d5, 0x0,
    0xbd2d0b18, 0x0, 0xbef4344e, 0x0,
    0xbf256a06, 0x0, 0xbf1b7e66, 0x0,
    0x3d0e2844, 0x0, 0x3f0c8346, 0x0,
    0x3f3a8ca3, 0x0, 0x3eed791c, 0x0,
    0xbb880a87, 0x0, 0xbed679b5, 0x0,
    0xbf30837a, 0x0, 0xbee639ca, 0x0,
    0xbde1db80, 0x0, 0x3ef1afe0, 0x0,
    0x3f1c8f85, 0x0, 0x3ee5ca78, 0x0,
    0xbc2cccfa, 0x0, 0xbee86823, 0x0,
    0xbf26bfca, 0x0, 0xbf096656, 0x0,
    0x3d129e61, 0x0, 0x3ee064db, 0x0,
    0x3f2d83b6, 0x0, 0x3edbeaf6, 0x0,
    0x3ce11e62, 0x0, 0xbee0cac2, 0x0,
    0xbf2a8c7b, 0x0, 0xbef33546, 0x0,
    0x3b90d22c, 0x0, 0x3f16915b, 0x0,
    0x3f4198c7, 0x0, 0x3effb4d3, 0x0,
    0xbc9d4211, 0x0, 0xbeec32a5, 0x0,
    0xbf28554e, 0x0, 0xbf0f775a, 0x0,
    0xbd5efe54, 0x0, 0x3ee1a429, 0x0,
    0x3f3f0910, 0x0, 0x3f07e53d, 0x0,
    0xbcaa603d, 0x0, 0xbf11807c, 0x0,
    0xbf195465, 0x0, 0xbedd44e5, 0x0,
    0x3e07f3a0, 0x0, 0x3f04148f, 0x0,
    0x3f259df8, 0x0, 0x3f0034d5, 0x0,
    0xbc3c0fd5, 0x0, 0xbf070b00, 0x0,
    0xbf388076, 0x0, 0xbefa3a61, 0x0,
    0xbd2f708d, 0x0, 0x3ef36ac8, 0x0,
    0x3f3b8948, 0x0, 0x3ef2ce20, 0x0,
    0x3d1e1ad4, 0x0, 0xbf0a6e91, 0x0,
    0xbf41a581, 0x0, 0xbee4397a, 0x0,
    0xbd7be3b1, 0x0, 0x3f0ac8ea, 0x0,
    0x3f2a70e1, 0x0, 0x3f05114e, 0x0,
    0xbd664e37, 0x0, 0xbef35f0f, 0x0,
    0xbf226e6d, 0x0, 0xbeed48e0, 0x0,
    0x3b57c29d, 0x0, 0x3efec203, 0x0,
    0x3f2ca214, 0x0, 0x3f004b0c, 0x0,
    0x3cb0ad04, 0x0, 0xbf13e9d7, 0x0,
    0xbf35d304, 0x0, 0xbf0cb47c, 0x0,
    0xbd84f3cd, 0x0, 0x3eed4861, 0x0,
    0x3f258df1, 0x0, 0x3f0af270, 0x0,
    0x3ccd88fc, 0x0, 0xbed580fb, 0x0,
    0xbf3ba5db, 0x0, 0xbf020973, 0x0,
    0x3d013af6, 0x0, 0x3ee99b1c, 0x0,
    0x3f3270c2, 0x0, 0x3f021c68, 0x0,
    0xbc01ef7d, 0x0, 0xbee0e561, 0x0,
    0xbf2b2b4f, 0x0, 0xbf06a293, 0x0,
    0xbca65fd5, 0x0, 0x3f033aab, 0x0,
    0x3f1435a9, 0x0, 0x3f14b6b2, 0x0,
    0x3d074eb3, 0x0, 0xbf0b9dfb, 0x0,
    0xbf249cb6, 0x0, 0xbee0522b, 0x0,
    0xbc816c98, 0x0, 0x3efc423e, 0x0,
    0x3f381e18, 0x0, 0x3f029305, 0x0,
    0x3d33f435, 0x0, 0xbef7023c, 0x0,
    0xbf2cea04, 0x0, 0xbf05ef7d, 0x0,
    0xbd2de0f0, 0x0, 0x3eff8f8d, 0x0,
    0x3f2f7e59, 0x0, 0x3f01ff42, 0x0,
    0xbcdeedce, 0x0, 0xbef4e1df, 0x0,
    0xbf36903f, 0x0, 0xbef9190c, 0x0,
    0x3d2286d2, 0x0, 0x3ef58892, 0x0,
    0x3f34f7a3, 0x0, 0x3f031c0f, 0x0,
    0xbe00dd66, 0x0, 0xbf0d50ac, 0x0,
    0xbf3c6927, 0x0, 0xbeea9388, 0x0,
    0x3d669f00, 0x0, 0x3ee2bf87, 0x0,
    0x3f1bd75a, 0x0, 0x3ed2b718, 0x0,
    0xbd0e58a0, 0x0, 0xbef7cd99, 0x0,
    0xbf2d7dd2, 0x0, 0xbef95044, 0x0,
    0x3c550d4f, 0x0, 0x3ee1d6a5, 0x0,
    0x3f481047, 0x0, 0x3f031bee, 0x0,
    0x3de74ce8, 0x0, 0xbeef853f, 0x0,
    0xbf24897e, 0x0, 0xbf0d8537, 0x0,
    0xbcc25be9, 0x0, 0x3ee9d418, 0x0,
    0x3f2ec066, 0x0, 0x3ef76908, 0x0,
    0x3d2311dc, 0x0, 0xbecdb5fc, 0x0,
    0xbf40a7c9, 0x0, 0xbf0a4416, 0x0,
    0xbd00c05e, 0x0, 0x3f034fcb, 0x0,
    0x3f4adecb, 0x0, 0x3eed7c2a, 0x0,
    0x3d9a6c65, 0x0, 0xbee9f96f, 0x0,
    0xbf323b17, 0x0, 0xbf1a71e0, 0x0,
    0x3da81edc, 0x0, 0x3f08ab19, 0x0,
    0x3f53d21c, 0x0, 0x3ee46453, 0x0,
    0x3bd31255, 0x0, 0xbefd10d6, 0x0,
    0xbf2807d6, 0x0, 0xbf083475, 0x0,
    0xbd98c40b, 0x0, 0x3f0558b8, 0x0,
    0x3f369de2, 0x0, 0x3f0a2a46, 0x0,
    0x3d0dee81, 0x0, 0xbed41945, 0x0,
    0xbf323aa7, 0x0, 0xbee682ed, 0x0,
    0x3dc481f7, 0x0, 0x3ee32b9b, 0x0,
    0x3f2797e9, 0x0, 0x3ef14603, 0x0,
    0xbd9cb065, 0x0, 0xbece9ed0, 0x0,
    0xbf2d28e3, 0x0, 0xbf0ce8a1, 0x0,
    0xb930e91f, 0x0, 0x3f05696f, 0x0,
    0x3f364795, 0x0, 0x3ed9bdbf, 0x0,
    0xbbe6f3ec, 0x0, 0xbef2994a, 0x0,
    0xbf339b29, 0x0, 0xbf04fa18, 0x0,
    0xbcc4507b, 0x0, 0x3f03b063, 0x0,
    0x3f2e7bab, 0x0, 0x3f13741a, 0x0,
    0x3ce71b8f, 0x0, 0xbf0de7ce, 0x0,
    0xbf3f4f51, 0x0, 0xbefc685c, 0x0,
    0x3c14047d, 0x0, 0x3ee672e8, 0x0,
    0x3f203da1, 0x0, 0x3f038f10, 0x0,
    0x3da90a2f, 0x0, 0xbf056504, 0x0,
    0xbf49cafd, 0x0, 0xbf01e25c, 0x0,
    0xbd368cda, 0x0, 0x3ef04274, 0x0,
    0x3f314fd0, 0x0, 0x3f15a989, 0x0,
    0xbcf7a85c, 0x0, 0xbf130948, 0x0,
    0xbf279046, 0x0, 0xbee01a6b, 0x0,
    0x3cddaeac, 0x0, 0x3f08a986, 0x0,
    0x3f3758b5, 0x0, 0x3f0c0ed1, 0x0,
    0xbc9e86ca, 0x0, 0xbeec39d8, 0x0,
    0xbf2844c2, 0x0, 0xbf023689, 0x0,
    0x3d4ad576, 0x0, 0x3f0ad5b4, 0x0,
    0x3f36fb03, 0x0, 0x3f1b537f, 0x0,
    0xbcf13b05, 0x0, 0xbefc7903, 0x0,
    0xbf1b4ac2, 0x0, 0xbee9195a, 0x0,
    0x3da5104c, 0x0, 0x3ede1818, 0x0,
    0x3f3aa5f3, 0x0, 0x3eec2a6a, 0x0,
    0x3d0328bc, 0x0, 0xbeff75d4, 0x0,
    0xbf23d1d9, 0x0, 0xbef775c8, 0x0,
    0xbd2a69f3, 0x0, 0x3edbac5c, 0x0,
    0x3f33dc0b, 0x0, 0x3efe947c, 0x0,
    0x3d374ce1, 0x0, 0xbee62d11, 0x0,
    0xbf38c413, 0x0, 0xbf0a49ca, 0x0,
    0xbd50295b, 0x0, 0x3ef42506, 0x0,
    0x3f318400, 0x0, 0x3eec60b4, 0x0,
    0x3d037386, 0x0, 0xbed89167, 0x0,
    0xbf34b952, 0x0, 0xbebfbc4c, 0x0,
    0xbc00bab3, 0x0, 0x3ecfe6a5, 0x0,
    0x3f317157, 0x0, 0x3ef7506b, 0x0,
    0x3d2f3e73, 0x0, 0xbebe378a, 0x0,
    0xbf284ca8, 0x0, 0xbf069edc, 0x0,
    0x3d944cbd, 0x0, 0x3f04fdf9, 0x0,
    0x3f421f46, 0x0, 0x3f08bfa1, 0x0,
    0x3c7750f7, 0x0, 0xbee4635e, 0x0,
    0xbf345f57, 0x0, 0xbeeaa4f3, 0x0,
    0xbd147040, 0x0, 0x3f147b2f, 0x0,
    0x3f3b5dc3, 0x0, 0x3efbae74, 0x0,
    0xbd1a8453, 0x0, 0xbef21b31, 0x0,
    0xbf27b4b0, 0x0, 0xbef28a32, 0x0,
    0x3c8412a6, 0x0, 0x3eebf961, 0x0,
    0x3f3aa34d, 0x0, 0x3f06e07c, 0x0,
    0x3c94c688, 0x0, 0xbec49d07, 0x0,
    0xbf432f42, 0x0, 0xbec44f3d, 0x0,
    0x3e1085af, 0x0, 0x3f1246ba, 0x0,
    0x3f285977, 0x0, 0x3ee4f9ce, 0x0,
    0xbc8fff5d, 0x0, 0xbf166645, 0x0,
    0xbf2f98bc, 0x0, 0xbef4b458, 0x0,
    0xbd32327e, 0x0, 0x3f125437, 0x0,
    0x3f46a75a, 0x0, 0x3f01fc49, 0x0,
    0x3c46dc23, 0x0, 0xbf0b9188, 0x0,
    0xbf2e3779, 0x0, 0xbf018905, 0x0,
    0xbd82ffde, 0x0, 0x3f0167be, 0x0,
    0x3f2fc4af, 0x0, 0x3f120e7b, 0x0,
    0x3c35c3d5, 0x0, 0xbf0285fe, 0x0,
    0xbf4aae01, 0x0, 0xbeedf1b5, 0x0,
    0x3c60cfaa, 0x0, 0x3f076227, 0x0,
    0x3f3fd47d, 0x0, 0x3f0d8bdb, 0x0,
    0xbbe47e75, 0x0, 0xbf050764, 0x0,
    0xbf3f119f, 0x0, 0xbeec59cc, 0x0,
    0x3b82af2b, 0x0, 0x3f07ac06, 0x0,
    0x3f345040, 0x0, 0x3efff184, 0x0,
    0xbe066781, 0x0, 0xbf0fb507, 0x0,
    0xbf352210, 0x0, 0xbeed883b, 0x0,
    0xbd247792, 0x0, 0x3f0b3a22, 0x0,
    0x3f2e2d4c, 0x0, 0x3f030c12, 0x0,
    0x3ad41532, 0x0, 0xbf0adcb4, 0x0,
    0xbf29adf4, 0x0, 0xbee47ec6, 0x0,
    0xbc5aa3e1, 0x0, 0x3f0c0f46, 0x0,
    0x3f2c0392, 0x0, 0x3f145308, 0x0,
    0x3bd516f1, 0x0, 0xbefa0052, 0x0,
    0xbf3157c3, 0x0, 0xbef9707f, 0x0,
    0xbd3b7b94, 0x0, 0x3ee81dde, 0x0,
    0x3f3f522f, 0x0, 0x3ed91275, 0x0,
    0xbda26abc, 0x0, 0xbee1bfc7, 0x0,
    0xbf346155, 0x0, 0xbf0e8ee2, 0x0,
    0x3dbfab49, 0x0, 0x3ee33a47, 0x0,
    0x3f28e106, 0x0, 0x3f05196f, 0x0,
    0xbc2ec5f6, 0x0, 0xbeebd74e, 0x0,
    0xbf2be1ec, 0x0, 0xbef6ccbe, 0x0,
    0xbd34acc5, 0x0, 0x3f0847d4, 0x0,
    0x3f3d3721, 0x0, 0x3f010ffa, 0x0,
    0xbd3dd83a, 0x0, 0xbef5e374, 0x0,
    0xbf3e66e1, 0x0, 0xbf04a734, 0x0,
    0x3bf62d1a, 0x0, 0x3ef248ce, 0x0,
    0x3f42d4b8, 0x0, 0x3f0513a9, 0x0,
    0x3c004700, 0x0, 0xbefc2a4b, 0x0,
    0xbf33a6b6, 0x0, 0xbf1a2e4a, 0x0,
    0x3cf72773, 0x0, 0x3edce56b, 0x0,
    0x3f465572, 0x0, 0x3ef3c9a2, 0x0,
    0x3d00f8fd, 0x0, 0xbf069413, 0x0,
    0xbf2a9fd2, 0x0, 0xbee7d855, 0x0,
    0xbd5c107f, 0x0, 0x3eff52eb, 0x0,
    0x3f395be3, 0x0, 0x3ef60de1, 0x0,
    0x3ddc6342, 0x0, 0xbf01e45b, 0x0,
    0xbf4838cb, 0x0, 0xbf008b4a, 0x0,
    0x3ccb83c9, 0x0, 0x3ee8f521, 0x0,
    0x3f3fa93a, 0x0, 0x3f038a3f, 0x0,
    0x3c596302, 0x0, 0xbef321b2, 0x0,
    0xbf349a0e, 0x0, 0xbef39591, 0x0,
    0xbc8ebe8a, 0x0, 0x3f0be1fa, 0x0,
    0x3f325114, 0x0, 0x3ef0646d, 0x0,
    0xbc843038, 0x0, 0xbef894a3, 0x0,
    0xbf37e933, 0x0, 0xbf0161cf, 0x0,
    0x3b8b9c0f, 0x0, 0x3f096b6d, 0x0,
    0x3f2d0ac1, 0x0, 0x3f0c1b40, 0x0,
    0x3c7f099b, 0x0, 0xbedd0690, 0x0,
    0xbf25917d, 0x0, 0xbef19461, 0x0,
    0xbc0b57c8, 0x0, 0x3f00aea6, 0x0,
    0x3f282121, 0x0, 0x3ec18d4f, 0x0,
    0x3d5aa8d1, 0x0, 0xbefff427, 0x0,
    0xbf34f145, 0x0, 0xbef9bc3f, 0x0,
    0x3d38af10, 0x0, 0x3f0430a5, 0x0,
    0x3f3ac297, 0x0, 0x3eeb20b1, 0x0,
    0x3cebdc0e, 0x0, 0xbf05a56b, 0x0,
    0xbf23b880, 0x0, 0xbf04343c, 0x0,
    0xbdb83949, 0x0, 0x3f093b6c, 0x0,
    0x3f34fe9b, 0x0, 0x3f16c150, 0x0,
    0x3c257ea5, 0x0, 0xbede78db, 0x0,
    0xbf405226, 0x0, 0xbee76fae, 0x0,
    0xbccdaed6, 0x0, 0x3f011b30, 0x0,
    0x3f53dc25, 0x0, 0x3f0658ce, 0x0,
    0x3d4e6f6e, 0x0, 0xbf01849f, 0x0,
    0xbf37633c, 0x0, 0xbf0e2ddc, 0x0,
    0x3d09f5ef, 0x0, 0x3f06fa4c, 0x0,
    0x3f409fcc, 0x0, 0x3ef681a7, 0x0,
    0xbd22c572, 0x0, 0xbef7471c, 0x0,
    0xbf15ec0d, 0x0, 0xbef0e7d1, 0x0,
    0x3d4cac9a, 0x0, 0x3ee37d44, 0x0,
    0x3f2dd215, 0x0, 0x3f002b3f, 0x0,
    0x3d241b61, 0x0, 0xbefb152d, 0x0,
    0xbf4bf734, 0x0, 0xbefc2830, 0x0,
    0xbd949aba, 0x0, 0x3ef3057e, 0x0,
    0x3f268b6b, 0x0, 0x3f0fed38, 0x0,
    0x3d80c794, 0x0, 0xbef7d25e, 0x0,
    0xbf3b60af, 0x0, 0xbf1a0a1c, 0x0,
    0xbda5339a, 0x0, 0x3ee7d2d9, 0x0,
    0x3f38d375, 0x0, 0x3efb5387, 0x0,
    0xbd372578, 0x0, 0xbefb21e7, 0x0,
    0xbf34ae9f, 0x0, 0xbed225e7, 0x0,
    0xbd1a1740, 0x0, 0x3f0ca781, 0x0,
    0x3f451b4e, 0x0, 0x3ef867f2, 0x0,
    0x3b80cdc2, 0x0, 0xbee6e405, 0x0,
    0xbf1bb1c5, 0x0, 0xbf04bbd0, 0x0,
    0x3dc83451, 0x0, 0x3efaec25, 0x0,
    0x3f3f0ff5, 0x0, 0x3f001475, 0x0,
    0x3cf5fb68, 0x0, 0xbec501e1, 0x0,
    0xbf2de5fe, 0x0, 0xbf10dc5a, 0x0,
    0xbcb476a3, 0x0, 0x3ed20a62, 0x0,
    0x3f34d179, 0x0, 0x3f04f119, 0x0,
    0x3d226740, 0x0, 0xbf07c647, 0x0,
    0xbf37ac3d, 0x0, 0xbef6bc5e, 0x0,
    0x3d7092d9, 0x0, 0x3f02c972, 0x0,
    0x3f367b78, 0x0, 0x3ee033e6, 0x0,
    0x3c3dbfa0, 0x0, 0xbee4ca0d, 0x0,
    0xbf36f337, 0x0, 0xbeedc564, 0x0,
    0xbdad1279, 0x0, 0x3ef1c73f, 0x0,
    0x3f2e5d26, 0x0, 0x3ee8da47, 0x0,
    0xbd258f21, 0x0, 0xbf03fa4d, 0x0,
    0xbf4907df, 0x0, 0xbef2a111, 0x0,
    0x3c691ab4, 0x0, 0x3ef4aee1, 0x0,
    0x3f4524e5, 0x0, 0x3ef8b715, 0x0,
    0x3d835402, 0x0, 0xbf1428fa, 0x0,
    0xbf2f7116, 0x0, 0xbee9e15a, 0x0,
    0x3d474c76, 0x0, 0x3eef3494, 0x0,
    0x3f4c1293, 0x0, 0x3ee0d075, 0x0,
    0xbd923c19, 0x0, 0xbf02bb46, 0x0,
    0xbf44f075, 0x0, 0xbf063a9a, 0x0,
    0xbd1e94c1, 0x0, 0x3ed3b7f7, 0x0,
    0x3f2db4a4, 0x0, 0x3f144f67, 0x0,
    0x3cbf03cc, 0x0, 0xbeff3071, 0x0,
    0xbf279f09, 0x0, 0xbf168e0a, 0x0,
    0x3c550a8d, 0x0, 0x3efaa1ae, 0x0,
    0x3f2e1ae6, 0x0, 0x3f05eb8d, 0x0,
    0xbb02392c, 0x0, 0xbef7adcb, 0x0,
    0xbf2f2c2e, 0x0, 0xbf193dc3, 0x0,
    0xbd932794, 0x0, 0x3f0fc866, 0x0,
    0x3f3070a9, 0x0, 0x3eea2753, 0x0,
    0xbcfbd87c, 0x0, 0xbeeccade, 0x0,
    0xbf2cc88f, 0x0, 0xbf0ff9c3, 0x0,
    0x3d920535, 0x0, 0x3ef256fe, 0x0,
    0x3f2da553, 0x0, 0x3eec0159, 0x0,
    0xbc5fffbb, 0x0, 0xbf1e197e, 0x0,
    0xbf40cabd, 0x0, 0xbefaf856, 0x0,
    0x3cc30f99, 0x0, 0x3efee14e, 0x0,
    0x3f406ba2, 0x0, 0x3f0bdbb9, 0x0,
    0x3bc08458, 0x0, 0xbee48a48, 0x0,
    0xbf3a5fa2, 0x0, 0xbeefa7bd, 0x0,
    0x3d7bbf45, 0x0, 0x3f063c56, 0x0,
    0x3f21ba84, 0x0, 0x3efeca0a, 0x0,
    0x3c8c5776, 0x0, 0xbefeac8b, 0x0,
    0xbf2f8b74, 0x0, 0xbef19c63, 0x0,
    0x3d61f5f4, 0x0, 0x3f0dfc6d, 0x0,
    0x3f32903b, 0x0, 0x3ee19a3d, 0x0,
    0xbd6d330b, 0x0, 0xbefb9a0a, 0x0,
    0xbf367fa4, 0x0, 0xbefcb3cd, 0x0,
    0xbc2fff43, 0x0, 0x3ee7c4bd, 0x0,
    0x3f282cdd, 0x0, 0x3f0f2fc1, 0x0,
    0x3cf4b428, 0x0, 0xbef04e7d, 0x0,
    0xbf32cbe1, 0x0, 0xbee03d20, 0x0,
    0xbd112dca, 0x0, 0x3f0b659f, 0x0,
    0x3f50e13f, 0x0, 0x3ef9d445, 0x0,
    0x3db0bb35, 0x0, 0xbf00b172, 0x0,
    0xbf47ce33, 0x0, 0xbee68eba, 0x0,
    0xbe04eb5d, 0x0, 0x3ecbe280, 0x0,
    0x3f416e46, 0x0, 0x3ef7bb61, 0x0,
    0xbb8686f2, 0x0, 0xbef59116, 0x0,
    0xbf2bc776, 0x0, 0xbef19276, 0x0,
    0xba766279, 0x0, 0x3f1172c0, 0x0,
    0x3f3348c5, 0x0, 0x3ee5d4d8, 0x0,
    0xbcbd3f88, 0x0, 0xbedc8ebf, 0x0,
    0xbf3153b4, 0x0, 0xbee0be34, 0x0,
    0x3b9c09ac, 0x0, 0x3efb3574, 0x0,
    0x3f281ab5, 0x0, 0x3f0bca73, 0x0,
    0x388f1b9d, 0x0, 0xbee6a2d9, 0x0,
    0xbf334a4a, 0x0, 0xbf0a8fce, 0x0,
    0x3b3babf9, 0x0, 0x3ed9022f, 0x0,
    0x3f28fbeb, 0x0, 0x3ee8507f, 0x0,
    0xbc15c6ce, 0x0, 0xbf0c7477, 0x0,
    0xbf34f512, 0x0, 0xbed355cf, 0x0,
    0x3d39eacd, 0x0, 0x3f05bc14, 0x0,
    0x3f3ac69b, 0x0, 0x3eed320e, 0x0,
    0xbd065629, 0x0, 0xbefe652d, 0x0,
    0xbf3579ac, 0x0, 0xbeee2a52, 0x0,
    0xbd14de61, 0x0, 0x3f02eb47, 0x0,
    0x3f2cc6ea, 0x0, 0x3f12c46c, 0x0,
    0xbdaec1ec, 0x0, 0xbf01df5e, 0x0,
    0xbf41bc24, 0x0, 0xbf0f38ee, 0x0,
    0xbd1536de, 0x0, 0x3eee980e, 0x0,
    0x3f260687, 0x0, 0x3f034c9f, 0x0,
    0x3bf81af7, 0x0, 0xbecd79be, 0x0,
    0xbf2d0e59, 0x0, 0xbf041cf5, 0x0,
    0xbd0c92cf, 0x0, 0x3f05e29c, 0x0,
    0x3f2f4219, 0x0, 0x3ee6485a, 0x0,
    0xbd3e6ce1, 0x0, 0xbf0f6ec7, 0x0,
    0xbf129973, 0x0, 0xbedab892, 0x0,
    0x3c3ba961, 0x0, 0x3f047f0b, 0x0,
    0x3f3ccaf6, 0x0, 0x3ee24da0, 0x0,
    0x3d8ee9f0, 0x0, 0xbf05230e, 0x0,
    0xbf4420d2, 0x0, 0xbecfdd74, 0x0,
    0x3ba0f80a, 0x0, 0x3efc9ae0, 0x0,
    0x3f3d74aa, 0x0, 0x3f0ae998, 0x0,
    0x3ca82b07, 0x0, 0xbedfe8a1, 0x0,
    0xbf3431b0, 0x0, 0xbedcec93, 0x0,
    0x3d9d7c3a, 0x0, 0x3f0603b7, 0x0,
    0x3f3e17ea, 0x0, 0x3f132224, 0x0,
    0xbc1422a7, 0x0, 0xbed8e6e3, 0x0,
    0xbf2e1fd2, 0x0, 0xbf01d5fa, 0x0,
    0xbd827fb4, 0x0, 0x3ee02a82, 0x0,
    0x3f21d955, 0x0, 0x3eed17b8, 0x0,
    0xbd410883, 0x0, 0xbecfe579, 0x0,
    0xbf46dd8a, 0x0, 0xbefb1c05, 0x0,
    0xbbd15768, 0x0, 0x3edc78c9, 0x0,
    0x3f359483, 0x0, 0x3f019add, 0x0,
    0xbd80a052, 0x0, 0xbed2914d, 0x0,
    0xbf348dd8, 0x0, 0xbebb90a6, 0x0,
    0x3cad066c, 0x0, 0x3ee19b2d, 0x0,
    0x3f2a9827, 0x0, 0x3ed82941, 0x0,
    0x3cb65fc6, 0x0, 0xbede322d, 0x0,
    0xbf46a9a2, 0x0, 0xbef643d2, 0x0,
    0x3d649e64, 0x0, 0x3f02e74a, 0x0,
    0x3f222d85, 0x0, 0x3ee125b0, 0x0,
    0xbc284725, 0x0, 0xbf100b09, 0x0,
    0xbf31660f, 0x0, 0xbef97962, 0x0,
    0x3c59e32b, 0x0, 0x3ef9674f, 0x0,
    0x3f3c7b67, 0x0, 0x3ecd4772, 0x0,
    0x3c22634d, 0x0, 0xbee51686, 0x0,
    0xbf24472b, 0x0, 0xbecbcc3a, 0x0,
    0x3d63208e, 0x0, 0x3efc8277, 0x0,
    0x3f390471, 0x0, 0x3ef503c1, 0x0,
    0x3c67faa4, 0x0, 0xbef0b0fd, 0x0,
    0xbf3bf86d, 0x0, 0xbefb9d7c, 0x0,
    0x3d2958fa, 0x0, 0x3f0400bc, 0x0,
    0x3f2131de, 0x0, 0x3f002d51, 0x0,
    0xbd47b127, 0x0, 0xbeffd360, 0x0,
    0xbf3d2530, 0x0, 0xbed51617, 0x0,
    0xbd6b77dd, 0x0, 0x3ed6c0e6, 0x0,
    0x3f2b890f, 0x0, 0x3f08a636, 0x0,
    0xbb201ed8, 0x0, 0xbeff2818, 0x0,
    0xbf2972d5, 0x0, 0xbef125ef, 0x0,
    0x3d8c679f, 0x0, 0x3f03c516, 0x0,
    0x3f2dfe30, 0x0, 0x3f18db06, 0x0,
    0x3c9e6d20, 0x0, 0xbf098201, 0x0,
    0xbf35037e, 0x0, 0xbee72f56, 0x0,
    0x3cc7edb1, 0x0, 0x3ef03b1a, 0x0,
    0x3f45db36, 0x0, 0x3ed4990e, 0x0,
    0x3d6a2b8d, 0x0, 0xbf0a67ab, 0x0,
    0xbf14859d, 0x0, 0xbef58c46, 0x0,
    0x3d3cc6f3, 0x0, 0x3ef956a8, 0x0,
    0x3f2caa36, 0x0, 0x3ef3b09e, 0x0,
    0xbd134729, 0x0, 0xbef868b6, 0x0,
    0xbf3a29d8, 0x0, 0xbf032c0e, 0x0,
    0x3a87c8ee, 0x0, 0x3f05d132, 0x0,
    0x3f2fe950, 0x0, 0x3efcc4fc, 0x0,
    0xbd217571, 0x0, 0xbed942d5, 0x0,
    0xbf31c4bd, 0x0, 0xbed0c185, 0x0,
    0xbcd3a508, 0x0, 0x3ee7658a, 0x0,
    0x3f3cb0d9, 0x0, 0x3f04c0f9, 0x0,
    0x3d9dfd28, 0x0, 0xbed12615, 0x0,
    0xbf2dd6a4, 0x0, 0xbeffdfa3, 0x0,
    0x3bc5ab4b, 0x0, 0x3eda5e86, 0x0,
    0x3f32c095, 0x0, 0x3ee85225, 0x0,
    0x3d658d06, 0x0, 0xbee8757b, 0x0,
    0xbf0f880a, 0x0, 0xbedd6f50, 0x0,
    0x3bb8d6ba, 0x0, 0x3f0e883a, 0x0,
    0x3f4eaba0, 0x0, 0x3ee26da4, 0x0,
    0xba568b8e, 0x0, 0xbf0a44af, 0x0,
    0xbf3fa8e2, 0x0, 0xbf055a1c, 0x0,
    0x3d8290e4, 0x0, 0x3f180dc8, 0x0,
    0x3f343d61, 0x0, 0x3eebeb06, 0x0,
    0x3b946402, 0x0, 0xbed48e06, 0x0,
    0xbf263cca, 0x0, 0xbeff4274, 0x0,
    0x3dde974f, 0x0, 0x3ee4a63d, 0x0,
    0x3f376da0, 0x0, 0x3ed65ac6, 0x0,
    0x3c9765a1, 0x0, 0xbf16ca24, 0x0,
    0xbf370507, 0x0, 0xbef21ccf, 0x0,
    0x3cba50a6, 0x0, 0x3f142c98, 0x0,
    0x3f4c0308, 0x0, 0x3f02d0fc, 0x0,
    0x3dbfda91, 0x0, 0xbefbb721, 0x0,
    0xbf48b0e2, 0x0, 0xbefc3782, 0x0,
    0xbcf008ca, 0x0, 0x3ebde060, 0x0,
    0x3f330bc8, 0x0, 0x3eeebbc4, 0x0,
    0xbbfea740, 0x0, 0xbf0c17c8, 0x0,
    0xbf1f83e3, 0x0, 0xbf003a4a, 0x0,
    0xbd266224, 0x0, 0x3ef26bc4, 0x0,
    0x3f2af8e7, 0x0, 0x3eed94bb, 0x0,
    0xbced588a, 0x0, 0xbf1ad4b5, 0x0,
    0xbf38d8da, 0x0, 0xbeef4dac, 0x0,
    0xbd7fa6f9, 0x0, 0x3f06f7f9, 0x0,
    0x3f2b5acb, 0x0, 0x3f0e93d4, 0x0,
    0x3d94377b, 0x0, 0xbef2faaa, 0x0,
    0xbf44e628, 0x0, 0xbf0f6238, 0x0,
    0x3d7765c7, 0x0, 0x3efcf3a3, 0x0,
    0x3f452bf5, 0x0, 0x3ef26054, 0x0,
    0xbd8535d9, 0x0, 0xbf0f2549, 0x0,
    0xbf3cb93f, 0x0, 0xbf0127d5, 0x0,
    0xbd87ca93, 0x0, 0x3ee604d8, 0x0,
    0x3f2d5fda, 0x0, 0x3ed6c6ad, 0x0,
    0x3d12147a, 0x0, 0xbf129fd4, 0x0,
    0xbf4a43fd, 0x0, 0xbf0080f2, 0x0,
    0x3de55640, 0x0, 0x3ee422c6, 0x0,
    0x3f3637d3, 0x0, 0x3ef93578, 0x0,
    0x3d2526ea, 0x0, 0xbf0cf71b, 0x0,
    0xbf3f72e9, 0x0, 0xbef807bf, 0x0,
    0xbd93c7e1, 0x0, 0x3f0a2be7, 0x0,
    0x3f314b47, 0x0, 0x3f083cad, 0x0,
    0x3d0154b5, 0x0, 0xbf0bfc09, 0x0,
    0xbf29394b, 0x0, 0xbf0025fb, 0x0,
    0x3c3f2da5, 0x0, 0x3ef09764, 0x0,
    0x3f30da12, 0x0, 0x3ef06593, 0x0,
    0xbd43d256, 0x0, 0xbf09310d, 0x0,
    0xbf4648b2, 0x0, 0xbeefc11a, 0x0,
    0xbce74745, 0x0, 0x3f056b08, 0x0,
    0x3f330a04, 0x0, 0x3eed3088, 0x0,
    0x3dcdd4b5, 0x0, 0xbf01aa49, 0x0,
    0xbf319a02, 0x0, 0xbf062b45, 0x0,
    0xbbf96bc2, 0x0, 0x3ee1f26e, 0x0,
    0x3f2c544d, 0x0, 0x3edf3213, 0x0,
    0xbdba6ca5, 0x0, 0xbeee96bc, 0x0,
    0xbf2e6477, 0x0, 0xbedd6ce5, 0x0,
    0xbad9c3df, 0x0, 0x3ee74ebf, 0x0,
    0x3f202718, 0x0, 0x3f0a64cf, 0x0,
    0xbcffe592, 0x0, 0xbed98703, 0x0,
    0xbf347211, 0x0, 0xbf01d7aa, 0x0,
    0x3d9542ba, 0x0, 0x3ef299d6, 0x0,
    0x3f3320e2, 0x0, 0x3ef0a586, 0x0,
    0xbcb9cb07, 0x0, 0xbeffa738, 0x0,
    0xbf37fa5b, 0x0, 0xbf0f6ac6, 0x0,
    0xbcdf1803, 0x0, 0x3f0ee58e, 0x0,
    0x3f2214b7, 0x0, 0x3efbd63b, 0x0,
    0x3d0a9456, 0x0, 0xbef82b17, 0x0,
    0xbf357677, 0x0, 0xbef3480e, 0x0,
    0x3c1a4145, 0x0, 0x3ef7d2be, 0x0,
    0x3f2ae6bb, 0x0, 0x3ee12d84, 0x0,
    0x3de8bd67, 0x0, 0xbf06ad67, 0x0,
    0xbf3759ad, 0x0, 0xbed60b47, 0x0,
    0x3d0a4c5f, 0x0, 0x3ef61939, 0x0,
    0x3f23e0f4, 0x0, 0x3edec19d, 0x0,
    0x3d85c061, 0x0, 0xbf045d0a, 0x0,
    0xbf2998a9, 0x0, 0xbf038995, 0x0,
    0x3c733aed, 0x0, 0x3f144cf5, 0x0,
    0x3f3e2391, 0x0, 0x3ef2d0bb, 0x0,
    0xbb9120da, 0x0, 0xbf09c580, 0x0,
    0xbf28fb39, 0x0, 0xbf050eb0, 0x0,
    0xbd98da7f, 0x0, 0x3ed31326, 0x0,
    0x3f2a8a44, 0x0, 0x3ed1c7fa, 0x0,
    0xbd31e8bc, 0x0, 0xbeffb42e, 0x0,
    0xbf5632f3, 0x0, 0xbef8b287, 0x0,
    0x3dced631, 0x0, 0x3f080a4e, 0x0,
    0x3f34bf7d, 0x0, 0x3ee47460, 0x0,
    0xbcfc6897, 0x0, 0xbee012d7, 0x0,
    0xbf394fbc, 0x0, 0xbefda4cf, 0x0,
    0xbd77cc6a, 0x0, 0x3ef81872, 0x0,
    0x3f3429c5, 0x0, 0x3ecd1890, 0x0,
    0x3cd769ef, 0x0, 0xbed8d0e3, 0x0,
    0xbf376db2, 0x0, 0xbf0dab86, 0x0,
    0x3d22c492, 0x0, 0x3f052e8a, 0x0,
    0x3f32333b, 0x0, 0x3f041469, 0x0,
    0x3c52e055, 0x0, 0xbefd59d4, 0x0,
    0xbf3347b5, 0x0, 0xbf04e52f, 0x0,
    0xbd0c43f2, 0x0, 0x3ee0e468, 0x0,
    0x3f37fbaf, 0x0, 0x3f1050c4, 0x0,
    0x3d47b23c, 0x0, 0xbf046ec1, 0x0,
    0xbf45c123, 0x0, 0xbf08e12a, 0x0,
    0xbc92ef5a, 0x0, 0x3f0635fe, 0x0,
    0x3f3a8374, 0x0, 0x3f07d602, 0x0,
    0x3ca4b37d, 0x0, 0xbedb458a, 0x0,
    0xbf2bb355, 0x0, 0xbf0ad925, 0x0,
    0xbce9e042, 0x0, 0x3f14e81b, 0x0,
    0x3f437c0b, 0x0, 0x3f041611, 0x0,
    0x3bfb74f8, 0x0, 0xbf10adcd, 0x0,
    0xbf284165, 0x0, 0xbf09c005, 0x0,
    0xbd0caee8, 0x0, 0x3f04c10c, 0x0,
    0x3f2c1ac5, 0x0, 0x3f077c67, 0x0,
    0xbd71e88d, 0x0, 0xbf06a788, 0x0,
    0xbf22f838, 0x0, 0xbf0ca38a, 0x0,
    0xbc7c9065, 0x0, 0x3ef6f789, 0x0,
    0x3f3d2abb, 0x0, 0x3ed1404d, 0x0,
    0xbd1cf56e, 0x0, 0xbee5be09, 0x0,
    0xbf2e4d76, 0x0, 0xbf064e9c, 0x0,
    0x3cd343fb, 0x0, 0x3eeb93df, 0x0,
    0x3f4b2722, 0x0, 0x3ef32e6b, 0x0,
    0xbce17758, 0x0, 0xbf13eeb5, 0x0,
    0xbf251df5, 0x0, 0xbeeb6142, 0x0,
    0xbd54deb4, 0x0, 0x3ee860a0, 0x0,
    0x3f2e300e, 0x0, 0x3f1d216c, 0x0,
    0x3d440c04, 0x0, 0xbec52594, 0x0,
    0xbf4f6591, 0x0, 0xbee56d2d, 0x0,
    0xbca443a9, 0x0, 0x3efb0e11, 0x0,
    0x3f4ac240, 0x0, 0x3ee0cc31, 0x0,
    0x3dedbc9a, 0x0, 0xbf043f64, 0x0,
    0xbf3cb2b0, 0x0, 0xbf000ed8, 0x0,
    0x3db0af7c, 0x0, 0x3edebc36, 0x0,
    0x3f298522, 0x0, 0x3ef24ae7, 0x0,
    0x3bfcd66f, 0x0, 0xbeeed1d2, 0x0,
    0xbf35443c, 0x0, 0xbedee1df, 0x0,
    0xbce46b31, 0x0, 0x3f0561a9, 0x0,
    0x3f313180, 0x0, 0x3f02c395, 0x0,
    0x3da58775, 0x0, 0xbf097d52, 0x0,
    0xbf2fa030, 0x0, 0xbf14c2e6, 0x0,
    0xbd898977, 0x0, 0x3ee431a8, 0x0,
    0x3f26f36f, 0x0, 0x3efd35e1, 0x0,
    0xbcba7762, 0x0, 0xbf073984, 0x0,
    0xbf3e2d95, 0x0, 0xbf10ef0b, 0x0,
    0xbd392451, 0x0, 0x3ec305cc, 0x0,
    0x3f3b1291, 0x0, 0x3ed90416, 0x0,
    0xbd6010f2, 0x0, 0xbf1d107a, 0x0,
    0xbf3c9417, 0x0, 0xbeca0ae7, 0x0,
    0xbc06f27f, 0x0, 0x3f08d64d, 0x0,
    0x3f29a7de, 0x0, 0x3f0809da, 0x0,
    0xbc4c8c3c, 0x0, 0xbf053311, 0x0,
    0xbf2d11f6, 0x0, 0xbee1d1a8, 0x0,
    0x3aa5d455, 0x0, 0x3ee96024, 0x0,
    0x3f2381e5, 0x0, 0x3eebab51, 0x0,
    0x3d76ce6e, 0x0, 0xbf075fd0, 0x0,
    0xbf37ccb8, 0x0, 0xbec8f86c, 0x0,
    0xbc68ae0c, 0x0, 0x3f035e0e, 0x0,
    0x3f363bd1, 0x0, 0x3f025a9a, 0x0,
    0x3d7bd949, 0x0, 0xbee13a44, 0x0,
    0xbf252b4f, 0x0, 0xbedbb113, 0x0,
    0x3b121afd, 0x0, 0x3ee07ecd, 0x0,
    0x3f2cb3e8, 0x0, 0x3effc17c, 0x0,
    0x3c34972c, 0x0, 0xbf02a99f, 0x0,
    0xbf326213, 0x0, 0xbed17478, 0x0,
    0xbe1b4125, 0x0, 0x3f0cfcf0, 0x0,
    0x3f282ddd, 0x0, 0x3f05fecc, 0x0,
    0xbd035510, 0x0, 0xbee3a7b4, 0x0,
    0xbf392405, 0x0, 0xbeed3a51, 0x0,
    0xbd4f173a, 0x0, 0x3f10eef7, 0x0,
    0x3f3f5950, 0x0, 0x3eeb31c5, 0x0,
    0xbca3490a, 0x0, 0xbf07cd4b, 0x0,
    0xbf34384d, 0x0, 0xbef2cdb8, 0x0,
    0xbb72fc4b, 0x0, 0x3ecb5a81, 0x0,
    0x3f345979, 0x0, 0x3f0b36bf, 0x0,
    0x3da57f63, 0x0, 0xbf0c5c99, 0x0,
    0xbf387934, 0x0, 0xbf083e69, 0x0,
    0xbc7ffaaf, 0x0, 0x3f015ec0, 0x0,
    0x3f31dcbf, 0x0, 0x3f069851, 0x0,
    0xbca7bd14, 0x0, 0xbef7cbad, 0x0,
    0xbf2cd230, 0x0, 0xbebf5c2f, 0x0,
    0xbca8d393, 0x0, 0x3f00d40e, 0x0,
    0x3f3a4aa6, 0x0, 0x3ed93b42, 0x0,
    0xbd4fa489, 0x0, 0xbef02d1d, 0x0,
    0xbf377ba5, 0x0, 0xbee3c499, 0x0,
    0x3c6dfbd0, 0x0, 0x3f037b43, 0x0,
    0x3f30c2b2, 0x0, 0x3f03d30f, 0x0,
    0xbdf4fe1a, 0x0, 0xbefa0223, 0x0,
    0xbf2d692d, 0x0, 0xbf24749e, 0x0,
    0xbd8be214, 0x0, 0x3eebbf29, 0x0,
    0x3f45bc8b, 0x0, 0x3ef4a84f, 0x0,
    0x3c809144, 0x0, 0xbee6f511, 0x0,
    0xbf3469cb, 0x0, 0xbf0d16e6, 0x0,
    0xbd73df16, 0x0, 0x3ef9c22e, 0x0,
    0x3f366d14, 0x0, 0x3ee53705, 0x0,
    0x3d32cef2, 0x0, 0xbf0861b3, 0x0,
    0xbf3223f7, 0x0, 0xbef40453, 0x0,
    0xbd66fb93, 0x0, 0x3edb7370, 0x0,
    0x3f2a1b04, 0x0, 0x3f04bc3a, 0x0,
    0xbd631e9b, 0x0, 0xbeeee00e, 0x0,
    0xbf47e24b, 0x0, 0xbeef3c26, 0x0,
    0xbd6d5b5a, 0x0, 0x3edce394, 0x0,
    0x3f36af0e, 0x0, 0x3ef70118, 0x0,
    0xbd9583f2, 0x0, 0xbefc3f7b, 0x0,
    0xbf30f2c9, 0x0, 0xbef45b5e, 0x0,
    0xbcae9399, 0x0, 0x3f161fa3, 0x0,
    0x3f29a530, 0x0, 0x3f04e7bb, 0x0,
    0x3d09f0f0, 0x0, 0xbf1ab5c8, 0x0,
    0xbf20ab58, 0x0, 0xbf0707a6, 0x0,
    0xbd6c29d8, 0x0, 0x3ebdb080, 0x0,
    0x3f1a12d8, 0x0, 0x3f10ed7d, 0x0,
    0x3d25a804, 0x0, 0xbee14c03, 0x0,
    0xbf286fd0, 0x0, 0xbee8cbcc, 0x0,
    0x3cbbc520, 0x0, 0x3efa0e01, 0x0,
    0x3f3fbad0, 0x0, 0x3ecd729c, 0x0,
    0xbd8d3870, 0x0, 0xbf02fe29, 0x0,
    0xbf2d9de8, 0x0, 0xbed3b6f9, 0x0,
    0xbd3464ab, 0x0, 0x3ecab646, 0x0,
    0x3f2c8969, 0x0, 0x3efd1f05, 0x0,
    0xbdc8bc5d, 0x0, 0xbea643e3, 0x0,
    0xbf38c1ce, 0x0, 0xbf089449, 0x0,
    0x3bc0cfec, 0x0, 0x3ef71400, 0x0,
    0x3f2b8770, 0x0, 0x3efd8921, 0x0,
    0x3d54d440, 0x0, 0xbeddf0ca, 0x0,
    0xbf29d915, 0x0, 0xbefa6223, 0x0,
    0x3cba4fb2, 0x0, 0x3ee8651f, 0x0,
    0x3f36df8e, 0x0, 0x3ef7b7f8, 0x0,
    0x3b725f67, 0x0, 0xbf09222e, 0x0,
    0xbf0cdc61, 0x0, 0xbed7b11c, 0x0,
    0xbdf50754, 0x0, 0x3f06383c, 0x0,
    0x3f2ab93f, 0x0, 0x3f1ce0eb, 0x0,
    0xbd00606a, 0x0, 0xbf02f6ba, 0x0,
    0xbf31db24, 0x0, 0xbf058c3b, 0x0,
    0xbcef00b6, 0x0, 0x3ef2adb6, 0x0,
    0x3f2b635e, 0x0, 0x3ee5e2e5, 0x0,
    0xbd06cf12, 0x0, 0xbedd0257, 0x0,
    0xbf3d6550, 0x0, 0xbefe4308, 0x0,
    0xbbdca4f2, 0x0, 0x3f00f8dd, 0x0,
    0x3f4a11b3, 0x0, 0x3f0e8a43, 0x0,
    0x3d11bc9c, 0x0, 0xbed274cd, 0x0,
    0xbf39a22b, 0x0, 0xbf05d691, 0x0,
    0xbc378ff4, 0x0, 0x3f03aa0e, 0x0,
    0x3f404dac, 0x0, 0x3f008ee3, 0x0,
    0xbcc47d09, 0x0, 0xbf044487, 0x0,
    0xbf393c75, 0x0, 0xbefdac45, 0x0,
    0x3d2b20bd, 0x0, 0x3ef91c94, 0x0,
    0x3f1ebe5b, 0x0, 0x3ee74d1e, 0x0,
    0x3c6b159b, 0x0, 0xbee88d1d, 0x0,
    0xbf339f9f, 0x0, 0xbeeef750, 0x0,
    0x3a4d662d, 0x0, 0x3efe4712, 0x0,
    0x3f56b7c2, 0x0, 0x3f0f4fa9, 0x0,
    0xbc5b301e, 0x0, 0xbef0ae6f, 0x0,
    0xbf50724d, 0x0, 0xbeec2145, 0x0,
    0xbd9f1f94, 0x0, 0x3efda890, 0x0,
    0x3f2f716d, 0x0, 0x3f1250d0, 0x0,
    0x3c30ba8d, 0x0, 0xbf04034e, 0x0,
    0xbf3e8c9a, 0x0, 0xbefa28cf, 0x0,
    0x3dde2169, 0x0, 0x3ef0ce2e, 0x0,
    0x3f465da0, 0x0, 0x3f0fffac, 0x0,
    0xbd4d3ee5, 0x0, 0xbee922ba, 0x0,
    0xbf2c0700, 0x0, 0xbf0f665b, 0x0,
    0xbd70b9c2, 0x0, 0x3efbd364, 0x0,
    0x3f40c8bd, 0x0, 0x3f0c0482, 0x0,
    0x3b87ecd7, 0x0, 0xbeff1597, 0x0,
    0xbf35f879, 0x0, 0xbed9bdaa, 0x0,
    0x3d493b6d, 0x0, 0x3eefc891, 0x0,
    0x3f2e98cd, 0x0, 0x3f13c80c, 0x0,
    0x3d2e8a15, 0x0, 0xbee00b94, 0x0,
    0xbf3a3c15, 0x0, 0xbee1b0ec, 0x0,
    0xbc989f96, 0x0, 0x3ed689e8, 0x0,
    0x3f383f53, 0x0, 0x3efe0780, 0x0,
    0xbd724b63, 0x0, 0xbef27caf, 0x0,
    0xbf3c91ec, 0x0, 0xbee628fc, 0x0,
    0x3c321f7a, 0x0, 0x3ef612bd, 0x0,
    0x3f39fcbf, 0x0, 0x3f034984, 0x0,
    0x3b73e287, 0x0, 0xbefcc9ca, 0x0,
    0xbf34ddb8, 0x0, 0xbebd900c, 0x0,
    0xbd186c7f, 0x0, 0x3f01aa08, 0x0,
    0x3f4b1520, 0x0, 0x3f05a551, 0x0,
    0x3c58edad, 0x0, 0xbf10781f, 0x0,
    0xbf285358, 0x0, 0xbf0feb80, 0x0,
    0xbd5b1aa1, 0x0, 0x3ef245a4, 0x0,
    0x3f39a3dc, 0x0, 0x3ee51bbc, 0x0,
    0xbd134edd, 0x0, 0xbefeae57, 0x0,
    0xbf338990, 0x0, 0xbf100d90, 0x0,
    0xbd990649, 0x0, 0x3ef389d0, 0x0,
    0x3f27c32f, 0x0, 0x3ed41f52, 0x0,
    0xbce82282, 0x0, 0xbf09ad62, 0x0,
    0xbf19e2ec, 0x0, 0xbf0826c3, 0x0,
    0xbd0b92c1, 0x0, 0x3ed9c052, 0x0,
    0x3f1b7ca7, 0x0, 0x3f03aa1a, 0x0,
    0x3cc9a971, 0x0, 0xbedda0cc, 0x0,
    0xbf3881bb, 0x0, 0xbef66744, 0x0,
    0xbd3a1051, 0x0, 0x3f015b71, 0x0,
    0x3f1cb05f, 0x0, 0x3ef0e883, 0x0,
    0x3de306d4, 0x0, 0xbf075a6a, 0x0,
    0xbf41380a, 0x0, 0xbf081726, 0x0,
    0x3cd905f3, 0x0, 0x3efa7078, 0x0,
    0x3f1cf0af, 0x0, 0x3edea1a1, 0x0,
    0xbd2866f6, 0x0, 0xbf0d4eaf, 0x0,
    0xbf2f9e0d, 0x0, 0xbf0f9805, 0x0,
    0x3d8057e7, 0x0, 0x3ef508f9, 0x0,
    0x3f37db7b, 0x0, 0x3ef2f182, 0x0,
    0xbd98c40b, 0x0, 0xbee92328, 0x0,
    0xbf3b6f43, 0x0, 0xbf013db0, 0x0,
    0xbcf09f97, 0x0, 0x3eff26dd, 0x0,
    0x3f3b8315, 0x0, 0x3efd55ae, 0x0,
    0xbd888cff, 0x0, 0xbed34571, 0x0,
    0xbf28d198, 0x0, 0xbed690fc, 0x0,
    0x3d1c6385, 0x0, 0x3edeed04, 0x0,
    0x3f4b7eb9, 0x0, 0x3eeb4f9a, 0x0,
    0x3b85ffbf, 0x0, 0xbefda43b, 0x0,
    0xbf36fff5, 0x0, 0xbee7a70b, 0x0,
    0x3d5eb8f2, 0x0, 0x3efe42b9, 0x0,
    0x3f391ce1, 0x0, 0x3f024439, 0x0,
    0x3d02ffce, 0x0, 0xbf050de9, 0x0,
    0xbf2e2388, 0x0, 0xbeddabc1, 0x0,
    0x3ba9bc11, 0x0, 0x3f106edd, 0x0,
    0x3f1f0811, 0x0, 0x3ef76fa6, 0x0,
    0xbd2b48e4, 0x0, 0xbef0e4a6, 0x0,
    0xbf3dca26, 0x0, 0xbf04788c, 0x0,
    0x3d2f5c60, 0x0, 0x3edeaead, 0x0,
    0x3f536444, 0x0, 0x3ee2f02a, 0x0,
    0xbd39f650, 0x0, 0xbeff5e03, 0x0,
    0xbf34772c, 0x0, 0xbedfe0d1, 0x0,
    0x3d1593b6, 0x0, 0x3f12b24b, 0x0,
    0x3f3491c6, 0x0, 0x3f04247e, 0x0,
    0x3d653e55, 0x0, 0xbebddf43, 0x0,
    0xbf1f5ee3, 0x0, 0xbf04a4a4, 0x0,
    0xbdbb3917, 0x0, 0x3ef855a6, 0x0,
    0x3f4c09dd, 0x0, 0x3effcb8a, 0x0,
    0xbc58f117, 0x0, 0xbefbcd49, 0x0,
    0xbf3cb83c, 0x0, 0xbf0ed507, 0x0,
    0xbb46897d, 0x0, 0x3ef7a691, 0x0,
    0x3f30121a, 0x0, 0x3ef9065a, 0x0,
    0xbd9c126b, 0x0, 0xbefec73c, 0x0,
    0xbf2b4716, 0x0, 0xbf24c9c1, 0x0,
    0xbc1b3ebc, 0x0, 0x3efba591, 0x0,
    0x3f3f8439, 0x0, 0x3f04f423, 0x0,
    0xbc487bd7, 0x0, 0xbef914ce, 0x0,
    0xbf299c7e, 0x0, 0xbf0aee30, 0x0,
    0xbd44c569, 0x0, 0x3ed58cc1, 0x0,
    0x3f312573, 0x0, 0x3f0bb4d7, 0x0,
    0x3d54be8d, 0x0, 0xbeefdc3d, 0x0,
    0xbf2dc1ae, 0x0, 0xbf01f898, 0x0,
    0x3cdc11e7, 0x0, 0x3ee8c539, 0x0,
    0x3f3ddcf6, 0x0, 0x3f0dc665, 0x0,
    0x3d7ca29c, 0x0, 0xbece3887, 0x0,
    0xbf36593f, 0x0, 0xbf01a720, 0x0,
    0x3ba4c3d4, 0x0, 0x3ee85f18, 0x0,
    0x3f3db373, 0x0, 0x3f01735c, 0x0,
    0x3c516d3d, 0x0, 0xbef7eef9, 0x0,
    0xbf26fb66, 0x0, 0xbef06f67, 0x0,
    0xbd1e07f5, 0x0, 0x3ed79666, 0x0,
    0x3f2f595f, 0x0, 0x3f01b389, 0x0,
    0xbcb5cd51, 0x0, 0xbed380c1, 0x0,
    0xbf26f484, 0x0, 0xbee0bff5, 0x0,
    0xba3f43ac, 0x0, 0x3f0a5745, 0x0,
    0x3f390602, 0x0, 0x3f039499, 0x0,
    0x3d1ba057, 0x0, 0xbed4a46d, 0x0,
    0xbf394e61, 0x0, 0xbef34e12, 0x0,
    0xbc5f7ffd, 0x0, 0x3eec5473, 0x0,
    0x3f33420d, 0x0, 0x3ef4a881, 0x0,
    0xbc1f4a26, 0x0, 0xbeee0437, 0x0,
    0xbf3a487b, 0x0, 0xbf03b3ab, 0x0,
    0xbd2f5f11, 0x0, 0x3f0ec133, 0x0,
    0x3f3cda63, 0x0, 0x3ee2600b, 0x0,
    0x3d715521, 0x0, 0xbf0021c6, 0x0,
    0xbf325210, 0x0, 0xbf05903b, 0x0,
    0x3ccfafe3, 0x0, 0x3f076f6c, 0x0,
    0x3f2a30ed, 0x0, 0x3efb2c05, 0x0,
    0xbe0978ec, 0x0, 0xbf15877b, 0x0,
    0xbf2b33c7, 0x0, 0xbf180a9c, 0x0,
    0xbcc74c45, 0x0, 0x3ef87cac, 0x0,
    0x3f2627ed, 0x0, 0x3ec4f469, 0x0,
    0xbccba654, 0x0, 0xbf003535, 0x0,
    0xbf40f8ff, 0x0, 0xbef4ea61, 0x0,
    0x3d30d960, 0x0, 0x3eef8211, 0x0,
    0x3f3b4a86, 0x0, 0x3f14e233, 0x0,
    0xbccc6428, 0x0, 0xbef246f6, 0x0,
    0xbf29511d, 0x0, 0xbeef0a5b, 0x0,
    0x3d00b9de, 0x0, 0x3ee83128, 0x0,
    0x3f3c74cd, 0x0, 0x3ee71009, 0x0,
    0xbc24dc2e, 0x0, 0xbefc1c08, 0x0,
    0xbf1d8679, 0x0, 0xbeee6845, 0x0,
    0xbd80bc37, 0x0, 0x3ef16195, 0x0,
    0x3f34cde4, 0x0, 0x3f035fad, 0x0,
    0xbce2093c, 0x0, 0xbef5ac07, 0x0,
    0xbf2e614e, 0x0, 0xbf168f69, 0x0,
    0xbcde8c5e, 0x0, 0x3f0bd40f, 0x0,
    0x3f44ae88, 0x0, 0x3ed96886, 0x0,
    0xbaa52a39, 0x0, 0xbf09ca16, 0x0,
    0xbf37d559, 0x0, 0xbf0385fa, 0x0,
    0x3d5bc3df, 0x0, 0x3f0f9620, 0x0,
    0x3f30d4e2, 0x0, 0x3ec42a82, 0x0,
    0x3cefdb6b, 0x0, 0xbeee3e00, 0x0,
    0xbf225439, 0x0, 0xbeea69db, 0x0,
    0x3dc6e420, 0x0, 0x3f0e2192, 0x0,
    0x3f1c046a, 0x0, 0x3f007e35, 0x0,
    0x3c34ee4e, 0x0, 0xbf024621, 0x0,
    0xbf3bf895, 0x0, 0xbef0d637, 0x0,
    0x3d3fc494, 0x0, 0x3f18469b, 0x0,
    0x3f37a4d3, 0x0, 0x3ef60b73, 0x0,
    0x3b6c7788, 0x0, 0xbf0e3008, 0x0,
    0xbf366c9e, 0x0, 0xbf099388, 0x0,
    0xbd34d5f4, 0x0, 0x3f0d4f19, 0x0,
    0x3f25c74a, 0x0, 0x3f0b5e3f, 0x0,
    0xbd73154b, 0x0, 0xbef7be28, 0x0,
    0xbf2bc922, 0x0, 0xbeff1928, 0x0,
    0x3c56c737, 0x0, 0x3ed478fe, 0x0,
    0x3f2ce687, 0x0, 0x3f03568b, 0x0,
    0x3d646312, 0x0, 0xbed7d2f1, 0x0,
    0xbf265cf6, 0x0, 0xbf023b96, 0x0,
    0x3b3f99fd, 0x0, 0x3eebef33, 0x0,
    0x3f1b6632, 0x0, 0x3ef9e1a2, 0x0,
    0x3c7fc08a, 0x0, 0xbf053d0a, 0x0,
    0xbf2603c6, 0x0, 0xbeff36dc, 0x0,
    0xbdb021a3, 0x0, 0x3ef3d815, 0x0,
    0x3f370b2f, 0x0, 0x3f0051ae, 0x0,
    0x3d49fb25, 0x0, 0xbf01a77d, 0x0,
    0xbf3f4c1d, 0x0, 0xbf00ff8f, 0x0,
    0xbc263b8f, 0x0, 0x3efa938d, 0x0,
    0x3f1f163b, 0x0, 0x3f0c5954, 0x0,
    0xbe0f1b07, 0x0, 0xbee19aeb, 0x0,
    0xbf2ea2f7, 0x0, 0xbf0bad26, 0x0,
    0xbdf21d7f, 0x0, 0x3ee945a1, 0x0,
    0x3f26cc2b, 0x0, 0x3f032906, 0x0,
    0xbbf03570, 0x0, 0xbf0fe0d1, 0x0,
    0xbf40fc24, 0x0, 0xbf06c2d2, 0x0,
    0xbd794a01, 0x0, 0x3edf776b, 0x0,
    0x3f2be328, 0x0, 0x3ef66688, 0x0,
    0xbdc04e0e, 0x0, 0xbf037a2f, 0x0,
    0xbf2d25b1, 0x0, 0xbf0283f8, 0x0,
    0x3c71e8f3, 0x0, 0x3ef92a25, 0x0,
    0x3f2a169c, 0x0, 0x3f081ed8, 0x0,
    0xbd334bb5, 0x0, 0xbeef29dc, 0x0,
    0xbf4b0394, 0x0, 0xbee36380, 0x0,
    0x3a410a34, 0x0, 0x3f09885d, 0x0,
    0x3f301ae9, 0x0, 0x3efc5fb0, 0x0,
    0xbcc407c1, 0x0, 0xbef3a10b, 0x0,
    0xbf22465a, 0x0, 0xbf03d025, 0x0,
    0x3d8c3b83, 0x0, 0x3f00cb07, 0x0,
    0x3f3091e7, 0x0, 0x3f067349, 0x0,
    0x3d53a54b, 0x0, 0xbf0dfd37, 0x0,
    0xbf29ab76, 0x0, 0xbf31c650, 0x0,
    0x3c8a123e, 0x0, 0x3ef7eab6, 0x0,
    0x3f3faee0, 0x0, 0x3f173fb9, 0x0,
    0x3d59062f, 0x0, 0xbf011034, 0x0,
    0xbf4ada14, 0x0, 0xbf03bef7, 0x0,
    0xbd2a0f23, 0x0, 0x3ef3cdc8, 0x0,
    0x3f231429, 0x0, 0x3ef28a96, 0x0,
    0xbc38dd1e, 0x0, 0xbee45f78, 0x0,
    0xbf3a2b74, 0x0, 0xbf0ca1d0, 0x0,
    0x3c88dde3, 0x0, 0x3edb58d2, 0x0,
    0x3f3cbc41, 0x0, 0x3f01d96c, 0x0,
    0xbd246510, 0x0, 0xbf1a9db2, 0x0,
    0xbf2c4cfa, 0x0, 0xbf2a01a4, 0x0,
    0x3c509fb0, 0x0, 0x3f03c0a9, 0x0,
    0x3f3c9d41, 0x0, 0x3f003930, 0x0,
    0xbd489fa8, 0x0, 0xbef4e2f1, 0x0,
    0xbf3bd9f2, 0x0, 0xbede61d1, 0x0,
    0xbc90f7f6, 0x0, 0x3ed9145e, 0x0,
    0x3f3f0790, 0x0, 0x3eee9bbd, 0x0,
    0xbd3e0158, 0x0, 0xbefede07, 0x0,
    0xbf5625bd, 0x0, 0xbee5c52e, 0x0,
    0xbc3b5110, 0x0, 0x3f0b7339, 0x0,
    0x3f2c6998, 0x0, 0x3f17265a, 0x0,
    0x3c2b989c, 0x0, 0xbf083889, 0x0,
    0xbf40cd7b, 0x0, 0xbee92990, 0x0,
    0x3d87ff4d, 0x0, 0x3ef46d41, 0x0,
    0x3f3a4fe8, 0x0, 0x3edf2b74, 0x0,
    0x3bbe1552, 0x0, 0xbefbc2bc, 0x0,
    0xbf250930, 0x0, 0xbeeeab8b, 0x0,
    0x3d4c0b89, 0x0, 0x3f06693e, 0x0,
    0x3f18eb7f, 0x0, 0x3f00306c, 0x0,
    0xbc4b9e7b, 0x0, 0xbf078780, 0x0,
    0xbf3fe3f4, 0x0, 0xbef9df92, 0x0,
    0xbcd16360, 0x0, 0x3f055bb8, 0x0,
    0x3f33243e, 0x0, 0x3ed781dd, 0x0,
    0x3d679a03, 0x0, 0xbef3b81b, 0x0,
    0xbf2d2006, 0x0, 0xbf0955a2, 0x0,
    0xbd458bb9, 0x0, 0x3f005861, 0x0,
    0x3f3b50e8, 0x0, 0x3ef169f1, 0x0,
    0x3b4db862, 0x0, 0xbf0ebb7a, 0x0,
    0xbf346b72, 0x0, 0xbf08c2c2, 0x0,
    0xbc488eab, 0x0, 0x3ef5251a, 0x0,
    0x3f350f2b, 0x0, 0x3ef3e900, 0x0,
    0x3bd39fda, 0x0, 0xbedbb718, 0x0,
    0xbf31671b, 0x0, 0xbf043c91, 0x0,
    0xbd972721, 0x0, 0x3f0c4542, 0x0,
    0x3f2f6778, 0x0, 0x3ee11d4d, 0x0,
    0x3b4123a4, 0x0, 0xbec8f7cd, 0x0,
    0xbf237328, 0x0, 0xbf02df79, 0x0,
    0x3c39422c, 0x0, 0x3ed2f77d, 0x0,
    0x3f37961f, 0x0, 0x3f049877, 0x0,
    0x3da2b2e1, 0x0, 0xbeede8b5, 0x0,
    0xbf31dc63, 0x0, 0xbef45751, 0x0,
    0xbdeb3d37, 0x0, 0x3ee37cda, 0x0,
    0x3f443b09, 0x0, 0x3ef9dac5, 0x0,
    0x3d9ae02e, 0x0, 0xbf1cec10, 0x0,
    0xbf3067f2, 0x0, 0xbed58112, 0x0,
    0xbd1060ae, 0x0, 0x3f06cb1d, 0x0,
    0x3f4106d5, 0x0, 0x3efaf826, 0x0,
    0xbce3070a, 0x0, 0xbedc7cbf, 0x0,
    0xbf32b893, 0x0, 0xbf04f039, 0x0,
    0x3d3bc4c5, 0x0, 0x3f05bede, 0x0,
    0x3f301bc6, 0x0, 0x3f12df5c, 0x0,
    0x3c0658ce, 0x0, 0xbf063a4c, 0x0,
    0xbf521fa1, 0x0, 0xbf0ff6e7, 0x0,
    0xbd492b5b, 0x0, 0x3ef320d3, 0x0,
    0x3f1d8df0, 0x0, 0x3efe4a89, 0x0,
    0xbce1bb9d, 0x0, 0xbed2e792, 0x0,
    0xbf30b07c, 0x0, 0xbecfe0a7, 0x0,
    0x3b136830, 0x0, 0x3f02d72d, 0x0,
    0x3f4d8c5b, 0x0, 0x3ed03f66, 0x0,
    0x3d804b99, 0x0, 0xbf033154, 0x0,
    0xbf4d5886, 0x0, 0xbf10eb19, 0x0,
    0x3cb51012, 0x0, 0x3ef9f8c8, 0x0,
    0x3f2142c6, 0x0, 0x3f05221e, 0x0,
    0x3c940904, 0x0, 0xbf09f309, 0x0,
    0xbf4d434b, 0x0, 0xbefbc746, 0x0,
    0x3d358aae, 0x0, 0x3f005c58, 0x0,
    0x3f1ef7ed, 0x0, 0x3eeeb830, 0x0,
    0xbd3f17d0, 0x0, 0xbef3bbd7, 0x0,
    0xbf370c43, 0x0, 0xbee9a553, 0x0,
    0xbab48012, 0x0, 0x3eef2e2e, 0x0,
    0x3f37cb3f, 0x0, 0x3f0324e9, 0x0,
    0x3d701855, 0x0, 0xbf0ae5f2, 0x0,
    0xbf301b1c, 0x0, 0xbf032923, 0x0,
    0x3d939ce3, 0x0, 0x3ee6f28d, 0x0,
    0x3f0f40fe, 0x0, 0x3f000ed0, 0x0,
    0x3cfde867, 0x0, 0xbf168981, 0x0,
    0xbf2c1e31, 0x0, 0xbf0ba4da, 0x0,
    0xbc8eabc7, 0x0, 0x3ee49b4c, 0x0,
    0x3f308364, 0x0, 0x3f080f7f, 0x0,
    0xbd2375a9, 0x0, 0xbf044399, 0x0,
    0xbf2b78dc, 0x0, 0xbec4b908, 0x0,
    0x3d80dae3, 0x0, 0x3ee1a040, 0x0,
    0x3f2f2b90, 0x0, 0x3ee123a4, 0x0,
    0x3c36bdc3, 0x0, 0xbeed7d15, 0x0,
    0xbf40bdf1, 0x0, 0xbf02ed7a, 0x0,
    0x3d0e1b52, 0x0, 0x3eefc70c, 0x0,
    0x3f3638fb, 0x0, 0x3edd9909, 0x0,
    0xbccdfcba, 0x0, 0xbecc76e3, 0x0,
    0xbf38b477, 0x0, 0xbef88cdf, 0x0,
    0x3c0bdf53, 0x0, 0x3f0e11e0, 0x0,
    0x3f259aa6, 0x0, 0x3ecfc71f, 0x0,
    0x3a6649de, 0x0, 0xbf00bae8, 0x0,
    0xbf42033f, 0x0, 0xbf04c503, 0x0,
    0x3d9e4848, 0x0, 0x3edbd1c0, 0x0,
    0x3f34de1c, 0x0, 0x3efe0564, 0x0,
    0xbd248549, 0x0, 0xbf06584b, 0x0,
    0xbf32c03d, 0x0, 0xbf15bfa5, 0x0,
    0xbb99b8e8, 0x0, 0x3f01b6df, 0x0,
    0x3f3dd82f, 0x0, 0x3f0fe870, 0x0,
    0x3cdc9518, 0x0, 0xbf04dc26, 0x0,
    0xbf2d27af, 0x0, 0xbef4a4bc, 0x0,
    0x3da78792, 0x0, 0x3eefde32, 0x0,
    0x3f3d2153, 0x0, 0x3ee0e416, 0x0,
    0x3d6212e6, 0x0, 0xbf02f2a3, 0x0,
    0xbf1fdef6, 0x0, 0xbeea7269, 0x0,
    0x3ca9978a, 0x0, 0x3eef2d1a, 0x0,
    0x3f3e021b, 0x0, 0x3f0472c6, 0x0,
    0x3db1f272, 0x0, 0xbeb4f7c4, 0x0,
    0xbf3cc15e, 0x0, 0xbee8eb66, 0x0,
    0x3ca14b77, 0x0, 0x3f134e9f, 0x0,
    0x3f390ac1, 0x0, 0x3ef51788, 0x0,
    0xbb1b1ecb, 0x0, 0xbf126711, 0x0,
    0xbf4b740e, 0x0, 0xbf02983a, 0x0,
    0xbc69e828, 0x0, 0x3f05e46e, 0x0,
    0x3f257e3c, 0x0, 0x3ef752f4, 0x0,
    0xbd25f168, 0x0, 0xbf02cc3c, 0x0,
    0xbf1a41d5, 0x0, 0xbedf17ed, 0x0,
    0xbcceac9f, 0x0, 0x3f2220b7, 0x0,
    0x3f3710d4, 0x0, 0x3edd7713, 0x0,
    0xbdd785ea, 0x0, 0xbf1cd086, 0x0,
    0xbf37918d, 0x0, 0xbedacf6b, 0x0,
    0xbd4b29d3, 0x0, 0x3ef6e50d, 0x0,
    0x3f2dbf53, 0x0, 0x3f0272ec, 0x0,
    0x3db7814d, 0x0, 0xbeced556, 0x0,
    0xbf33bf92, 0x0, 0xbf0d6fcc, 0x0,
    0x3cab76b9, 0x0, 0x3eeacc27, 0x0,
    0x3f37952e, 0x0, 0x3ed0e2ec, 0x0,
    0xbd9e25de, 0x0, 0xbf06b74f, 0x0,
    0xbf1eeacc, 0x0, 0xbf0f5fce, 0x0,
    0xbcdeee32, 0x0, 0x3ef54e93, 0x0,
    0x3f417ff0, 0x0, 0x3ee94bc3, 0x0,
    0x3d36b6a3, 0x0, 0xbefd9db1, 0x0,
    0xbf43678b, 0x0, 0xbf0ee2e4, 0x0,
    0xbcf96695, 0x0, 0x3f043d43, 0x0,
    0x3f2ee974, 0x0, 0x3ee3db1a, 0x0,
    0xbd5a818a, 0x0, 0xbf054ce3, 0x0,
    0xbf35fdd3, 0x0, 0xbf15498a, 0x0,
    0xbd360132, 0x0, 0x3ef2bd41, 0x0,
    0x3f343f85, 0x0, 0x3eee677f, 0x0,
    0x3d07a252, 0x0, 0xbf06f4a3, 0x0,
    0xbf2f1d44, 0x0, 0xbeffadc5, 0x0,
    0xbcd2893d, 0x0, 0x3ef82e26, 0x0,
    0x3f29c428, 0x0, 0x3edcb65c, 0x0,
    0xbcb82f47, 0x0, 0xbf10db84, 0x0,
    0xbf2b2fcd, 0x0, 0xbf0a550e, 0x0,
    0xbc6fbe2b, 0x0, 0x3f085acc, 0x0,
    0x3f36fc9e, 0x0, 0x3ef2f92d, 0x0,
    0x3d801f38, 0x0, 0xbf0c0272, 0x0,
    0xbf3be105, 0x0, 0xbf02d451, 0x0,
    0xbd8417d7, 0x0, 0x3f059b49, 0x0,
    0x3f38345d, 0x0, 0x3f1ed02d, 0x0,
    0x3d4e0d1a, 0x0, 0xbf020c57, 0x0,
    0xbf23b2f5, 0x0, 0xbec1c58c, 0x0,
    0xbc88264b, 0x0, 0x3f084692, 0x0,
    0x3f41f069, 0x0, 0x3f1772df, 0x0,
    0xbc5d4349, 0x0, 0xbebd8855, 0x0,
    0xbf4d705c, 0x0, 0xbeeacb68, 0x0,
    0xbc8f35ce, 0x0, 0x3ee6eb3e, 0x0,
    0x3f3d8d76, 0x0, 0x3f039a6c, 0x0,
    0x3d749d4f, 0x0, 0xbf0500a0, 0x0,
    0xbf2da00f, 0x0, 0xbefe29e0, 0x0,
    0xbd77811c, 0x0, 0x3f0eaf56, 0x0,
    0x3f243fbe, 0x0, 0x3ef683a6, 0x0,
    0xbd2968e0, 0x0, 0xbf05f382, 0x0,
    0xbf3ebece, 0x0, 0xbf083649, 0x0,
    0xbd23c2bf, 0x0, 0x3f0e1af5, 0x0,
    0x3f2b8d84, 0x0, 0x3ee30e11, 0x0,
    0xbcbbb847, 0x0, 0xbf11537b, 0x0,
    0xbf2a4824, 0x0, 0xbf02eb52, 0x0,
    0x3cb5f32f, 0x0, 0x3f039fec, 0x0,
    0x3f2287e7, 0x0, 0x3f09fb33, 0x0,
    0x3d40fdc7, 0x0, 0xbeeb086f, 0x0,
    0xbf2db439, 0x0, 0xbec53f35, 0x0,
    0xbd7d33bc, 0x0, 0x3f0a87e4, 0x0,
    0x3f3021f6, 0x0, 0x3f095554, 0x0,
    0x3d21094f, 0x0, 0xbf074bf9, 0x0,
    0xbf36d830, 0x0, 0xbf042f6d, 0x0,
    0x3def5cad, 0x0, 0x3ef12a48, 0x0,
    0x3f37606e, 0x0, 0x3eda1880, 0x0,
    0xbd1d5727, 0x0, 0xbeedc44c, 0x0,
    0xbf495863, 0x0, 0xbee8ad7c, 0x0,
    0xbd8233e2, 0x0, 0x3f06b78f, 0x0,
    0x3f21d568, 0x0, 0x3ece84b6, 0x0,
    0x3db2bbd3, 0x0, 0xbf155cea, 0x0,
    0xbf3f8ea6, 0x0, 0xbf048756, 0x0,
    0xbce72152, 0x0, 0x3eee656b, 0x0,
    0x3f1f5871, 0x0, 0x3eee85d3, 0x0,
    0x3c262f1f, 0x0, 0xbf1402d2, 0x0,
    0xbf2513bd, 0x0, 0xbed403c4, 0x0,
    0xbd16675c, 0x0, 0x3eed7cb3, 0x0,
    0x3f2e5457, 0x0, 0x3ecce47a, 0x0,
    0x3d76de7a, 0x0, 0xbf004c93, 0x0,
    0xbf30610c, 0x0, 0xbf00721e, 0x0,
    0x3bade70f, 0x0, 0x3ef2fcce, 0x0,
    0x3f33288d, 0x0, 0x3f05920b, 0x0,
    0xbd86fa04, 0x0, 0xbefadb7a, 0x0,
    0xbf35c696, 0x0, 0xbf019c56, 0x0,
    0x3b094c22, 0x0, 0x3f0c9c9a, 0x0,
    0x3f111453, 0x0, 0x3f00494a, 0x0,
    0x3d658619, 0x0, 0xbf09d361, 0x0,
    0xbf2e61c5, 0x0, 0xbf0f4b7f, 0x0,
    0xbd35f3ca, 0x0, 0x3f1365a3, 0x0,
    0x3f325248, 0x0, 0x3f070fb8, 0x0,
    0xbd93d994, 0x0, 0xbf056642, 0x0,
    0xbf2c1b7f, 0x0, 0xbf01d388, 0x0,
    0x3d7aaff6, 0x0, 0x3eec8845, 0x0,
    0x3f2cec3d, 0x0, 0x3ee3acfc, 0x0,
    0xbc3b4919, 0x0, 0xbf05997a, 0x0,
    0xbf2e6d29, 0x0, 0xbeddf549, 0x0,
    0xbca193a2, 0x0, 0x3f00a31a, 0x0,
    0x3f2da4b0, 0x0, 0x3ee9ff11, 0x0,
    0xbc80cc01, 0x0, 0xbf00b962, 0x0,
    0xbf318804, 0x0, 0xbf01ce14, 0x0,
    0xbd748224, 0x0, 0x3f067472, 0x0,
    0x3f4c7cba, 0x0, 0x3efed57e, 0x0,
    0x3c8a512d, 0x0, 0xbf023ece, 0x0,
    0xbf38917a, 0x0, 0xbefe632f, 0x0,
    0xbcf0db33, 0x0, 0x3f023534, 0x0,
    0x3f4bb792, 0x0, 0x3edf9373, 0x0,
    0xbc82a9ca, 0x0, 0xbf033d8d, 0x0,
    0xbf3c5626, 0x0, 0xbf11e496, 0x0,
    0xbd34edee, 0x0, 0x3f033c7a, 0x0,
    0x3f2da342, 0x0, 0x3edb014c, 0x0,
    0x3cb1219e, 0x0, 0xbedeaca9, 0x0,
    0xbf298a74, 0x0, 0xbf0054ce, 0x0,
    0xbc2d30ad, 0x0, 0x3f123883, 0x0,
    0x3f191845, 0x0, 0x3ef776bd, 0x0,
    0x3cd26394, 0x0, 0xbf0773a2, 0x0,
    0xbf34fb18, 0x0, 0xbf12d951, 0x0,
    0xbd0c2fe3, 0x0, 0x3f01814f, 0x0,
    0x3f1feee4, 0x0, 0x3efdb9f2, 0x0,
    0xbcaf4b23, 0x0, 0xbef84838, 0x0,
    0xbf2b470e, 0x0, 0xbedaccaa, 0x0,
    0xbd055d16, 0x0, 0x3efa7bc4, 0x0,
    0x3f340d4e, 0x0, 0x3f02e442, 0x0,
    0xbcb97115, 0x0, 0xbf02030a, 0x0,
    0xbf33bb20, 0x0, 0xbf12c92d, 0x0,
    0x3c331e8d, 0x0, 0x3f0edcca, 0x0,
    0x3f2a5050, 0x0, 0x3edeac74, 0x0,
    0xbdcca251, 0x0, 0xbeffcf19, 0x0,
    0xbf38573b, 0x0, 0xbef66ee4, 0x0,
    0xbd5500b5, 0x0, 0x3f022021, 0x0,
    0x3f39a736, 0x0, 0x3ed96312, 0x0,
    0x3d2c0668, 0x0, 0xbf0c32fe, 0x0,
    0xbf3343a3, 0x0, 0xbf024457, 0x0,
    0x3c617cee, 0x0, 0x3ef979cf, 0x0,
    0x3f34aac0, 0x0, 0x3f0e763b, 0x0,
    0x3d5c7d94, 0x0, 0xbf1a2405, 0x0,
    0xbf323ef0, 0x0, 0xbeeaf65b, 0x0,
    0x3e136cb7, 0x0, 0x3efe2f44, 0x0,
    0x3f3fef66, 0x0, 0x3f1ce4a0, 0x0,
    0x3d58c287, 0x0, 0xbedc23aa, 0x0,
    0xbf41e538, 0x0, 0xbecf1306, 0x0,
    0xbdb02ec4, 0x0, 0x3eebdba8, 0x0,
    0x3f4101db, 0x0, 0x3f01695e, 0x0,
    0x3ce288d8, 0x0, 0xbf122c13, 0x0,
    0xbf225ac5, 0x0, 0xbedd292f, 0x0,
    0x3cd82fd4, 0x0, 0x3ee13a74, 0x0,
    0x3f3123bd, 0x0, 0x3efc2c87, 0x0,
    0x3b8bf56a, 0x0, 0xbf072320, 0x0,
    0xbf316df6, 0x0, 0xbef1ec49, 0x0,
    0x3d4e4984, 0x0, 0x3ee58dc9, 0x0,
    0x3f387802, 0x0, 0x3efd7ade, 0x0,
    0xbcb06edb, 0x0, 0xbee802f1, 0x0,
    0xbf4474ee, 0x0, 0xbecb2e05, 0x0,
    0x3ca24337, 0x0, 0x3eea9ceb, 0x0,
    0x3f3c2fcf, 0x0, 0x3ef8f204, 0x0,
    0x3cee175e, 0x0, 0xbef8d45e, 0x0,
    0xbf45a150, 0x0, 0xbf08e7b3, 0x0,
    0xbd24b6f1, 0x0, 0x3ef741ea, 0x0,
    0x3f2bcaea, 0x0, 0x3f223508, 0x0,
    0x3b7a2684, 0x0, 0xbef0fa01, 0x0,
    0xbf3276dc, 0x0, 0xbef26454, 0x0,
    0x3d17bf10, 0x0, 0x3f06306a, 0x0,
    0x3f38b5aa, 0x0, 0x3ee5c3ca, 0x0,
    0xbccee0e7, 0x0, 0xbef3fb30, 0x0,
    0xbf2a2cbb, 0x0, 0xbef0bdf5, 0x0,
    0x3d22e13f, 0x0, 0x3f02eb6a, 0x0,
    0x3f2b28f3, 0x0, 0x3f150c79, 0x0,
    0x3c94b05f, 0x0, 0xbef73325, 0x0,
    0xbf2f570c, 0x0, 0xbf1eb2d9, 0x0,
    0xbd005996, 0x0, 0x3f0aa948, 0x0,
    0x3f50aafc, 0x0, 0x3eff7510, 0x0,
    0x3c1db1ec, 0x0, 0xbf025fd8, 0x0,
    0xbf2e2c70, 0x0, 0xbefc633d, 0x0,
    0x3da0a909, 0x0, 0x3ee1f940, 0x0,
    0x3f35988b, 0x0, 0x3edcc62c, 0x0,
    0x3c9c6978, 0x0, 0xbf20027a, 0x0,
    0xbf3c7f53, 0x0, 0xbf0872eb, 0x0,
    0x3cb5843b, 0x0, 0x3ec84098, 0x0,
    0x3f2a2ee1, 0x0, 0x3f02c80f, 0x0,
    0x3ccc5041, 0x0, 0xbefbcb89, 0x0,
    0xbf3af8d4, 0x0, 0xbed86648, 0x0,
    0xbd4a44ff, 0x0, 0x3ef714df, 0x0,
    0x3f37b0c5, 0x0, 0x3f066c5e, 0x0,
    0x3b289c22, 0x0, 0xbee6326b, 0x0,
    0xbf2a4fd3, 0x0, 0xbee57ef4, 0x0,
    0x3d02954e, 0x0, 0x3f07bf88, 0x0,
    0x3f3acf5b, 0x0, 0x3edeaa5c, 0x0,
    0x3d596211, 0x0, 0xbf125059, 0x0,
    0xbf333c31, 0x0, 0xbf10aa98, 0x0,
    0x3d10ab19, 0x0, 0x3f062db7, 0x0,
    0x3f301cbf, 0x0, 0x3efd3b24, 0x0,
    0x3d560d11, 0x0, 0xbeefee1d, 0x0,
    0xbf3b9e5b, 0x0, 0xbf105397, 0x0,
    0x3bed8d98, 0x0, 0x3f01d9ab, 0x0,
    0x3f286d52, 0x0, 0x3edaa4fe, 0x0,
    0xbd848fc0, 0x0, 0xbf028f9a, 0x0,
    0xbf4176ad, 0x0, 0xbf01376a, 0x0,
    0xbb268550, 0x0, 0x3f095a35, 0x0,
    0x3f33d0d3, 0x0, 0x3f03627e, 0x0,
    0x3c7cafad, 0x0, 0xbee80e72, 0x0,
    0xbf25c4ea, 0x0, 0xbed7343c, 0x0,
    0xbd7dd4af, 0x0, 0x3f06f582, 0x0,
    0x3f267767, 0x0, 0x3ee57681, 0x0,
    0xbc9cd071, 0x0, 0xbf0f07b1, 0x0,
    0xbf4a4aa6, 0x0, 0xbed5a249, 0x0,
    0xbc2722e0, 0x0, 0x3ed803dc, 0x0,
    0x3f35d88e, 0x0, 0x3ef4774c, 0x0,
    0x3ce6257a, 0x0, 0xbf0603f5, 0x0,
    0xbf2b2e06, 0x0, 0xbefc45ef, 0x0,
    0xbd0d62b3, 0x0, 0x3f0deeda, 0x0,
    0x3f2b332b, 0x0, 0x3ee1b83c, 0x0,
    0xbcaa9226, 0x0, 0xbef5aeb0, 0x0,
    0xbf21e183, 0x0, 0xbf1622b9, 0x0,
    0xbd049fc4, 0x0, 0x3ef1865e, 0x0,
    0x3f27ab2f, 0x0, 0x3f04af1e, 0x0,
    0xbdeb4550, 0x0, 0xbef4d73f, 0x0,
    0xbf28f2c4, 0x0, 0xbee14bfc, 0x0,
    0x3b07c65c, 0x0, 0x3ee64f15, 0x0,
    0x3f30f8ca, 0x0, 0x3ef0354d, 0x0,
    0x3cdbb0c2, 0x0, 0xbeea6470, 0x0,
    0xbf339ec6, 0x0, 0xbf072f2f, 0x0,
    0x3d7baa93, 0x0, 0x3f03e753, 0x0,
    0x3f1f5809, 0x0, 0x3f07890b, 0x0,
    0xbd231587, 0x0, 0xbed6b2dd, 0x0,
    0xbf2ecf0d, 0x0, 0xbf069c6d, 0x0,
    0xbd306a61, 0x0, 0x3f032317, 0x0,
    0x3f32519a, 0x0, 0x3f08b1ab, 0x0,
    0x3c829c2a, 0x0, 0xbf0f33fb, 0x0,
    0xbf2fbf06, 0x0, 0xbf03d2c9, 0x0,
    0x3d7ffa01, 0x0, 0x3efac80b, 0x0,
    0x3f357bee, 0x0, 0x3ecfdda8, 0x0,
    0xbd6617dc, 0x0, 0xbeff6615, 0x0,
    0xbf1e811f, 0x0, 0xbed1d88c, 0x0,
    0x3d581bad, 0x0, 0x3f0994f9, 0x0,
    0x3f45c08b, 0x0, 0x3f02c808, 0x0,
    0xbd32c7c9, 0x0, 0xbefc2652, 0x0,
    0xbf14a43a, 0x0, 0xbeef93fb, 0x0,
    0x3cda633f, 0x0, 0x3edd3a79, 0x0,
    0x3f41f598, 0x0, 0x3ef9b9e6, 0x0,
    0x3a66d271, 0x0, 0xbeddb6c6, 0x0,
    0xbf4809f7, 0x0, 0xbf079dec, 0x0,
    0x3a651704, 0x0, 0x3ef64907, 0x0,
    0x3f2ca42c, 0x0, 0x3f0b8f51, 0x0,
    0x3d80b3c2, 0x0, 0xbefcb184, 0x0,
    0xbf338374, 0x0, 0xbf07302b, 0x0,
    0x3c6f4172, 0x0, 0x3eefa66d, 0x0,
    0x3f3381d8, 0x0, 0x3f0207f8, 0x0,
    0x3cd76e23, 0x0, 0xbf233e78, 0x0,
    0xbf252336, 0x0, 0xbeeff311, 0x0,
    0x3d7a25b3, 0x0, 0x3efecf73, 0x0,
    0x3f2dfe8f, 0x0, 0x3f0c91be, 0x0,
    0x3d87fbf4, 0x0, 0xbf033a11, 0x0,
    0xbf324c16, 0x0, 0xbee5c4b5, 0x0,
    0x3d4fadb1, 0x0, 0x3ef5b625, 0x0,
    0x3f21354f, 0x0, 0x3f0261c4, 0x0,
    0x3cfecc16, 0x0, 0xbef3d83c, 0x0,
    0xbf403d98, 0x0, 0xbf147573, 0x0,
    0x3d43b453, 0x0, 0x3eccddc9, 0x0,
    0x3f32d9a0, 0x0, 0x3f0ca404, 0x0,
    0x3d641c67, 0x0, 0xbf0a9e16, 0x0,
    0xbf2d4add, 0x0, 0xbf159908, 0x0,
    0x3d18e905, 0x0, 0x3ee1af8d, 0x0,
    0x3f2d1a73, 0x0, 0x3ee88cc2, 0x0,
    0xbbce49ee, 0x0, 0xbf07298a, 0x0,
    0xbf21305f, 0x0, 0xbeda237e, 0x0,
    0x3d04bfed, 0x0, 0x3f06e2f5, 0x0,
    0x3f3d29c6, 0x0, 0x3eda8528, 0x0,
    0xbd16c1a9, 0x0, 0xbf1224be, 0x0,
    0xbf2d6012, 0x0, 0xbf0123df, 0x0,
    0x3dd5505c, 0x0, 0x3f003ecd, 0x0,
    0x3f538cb6, 0x0, 0x3eedb4fd, 0x0,
    0xbd66a79d, 0x0, 0xbf1a06e1, 0x0,
    0xbf43ac0f, 0x0, 0xbf01565f, 0x0,
    0x3ba01f92, 0x0, 0x3ef4b57f, 0x0,
    0x3f46f7e9, 0x0, 0x3ef5c0da, 0x0,
    0xbbb9d11f, 0x0, 0xbefa1888, 0x0,
    0xbf434e6b, 0x0, 0xbf06af58, 0x0,
    0xbdc4806d, 0x0, 0x3efc6aab, 0x0,
    0x3f418b0c, 0x0, 0x3f1f2bf9, 0x0,
    0xbd6f1978, 0x0, 0xbf0b5b7f, 0x0,
    0xbf4338b1, 0x0, 0xbf041046, 0x0,
    0xbcdaae08, 0x0, 0x3f01f47f, 0x0,
    0x3f34eca6, 0x0, 0x3f065f0d, 0x0,
    0xbd08b42f, 0x0, 0xbedb811c, 0x0,
    0xbf4d1a8e, 0x0, 0xbef13715, 0x0,
    0xbb646b38, 0x0, 0x3f010b4b, 0x0,
    0x3f452d61, 0x0, 0x3ef81d28, 0x0,
    0x3d7e89b2, 0x0, 0xbf0a91ef, 0x0,
    0xbf46cc2e, 0x0, 0xbf0a1e7f, 0x0,
    0x3d6e5501, 0x0, 0x3eecb4a8, 0x0,
    0x3f533359, 0x0, 0x3f097a14, 0x0,
    0x3ba4c97a, 0x0, 0xbefae736, 0x0,
    0xbf2eb90c, 0x0, 0xbedaed66, 0x0,
    0x3d6ed99e, 0x0, 0x3f06f94d, 0x0,
    0x3f31bb7a, 0x0, 0x3f08e947, 0x0,
    0x3db5d5d2, 0x0, 0xbee24dee, 0x0,
    0xbf3d2f5a, 0x0, 0xbee9a0d4, 0x0,
    0x3cc98c9b, 0x0, 0x3f0b2963, 0x0,
    0x3f3dae9b, 0x0, 0x3effebba, 0x0,
    0xbd15d66e, 0x0, 0xbecdf722, 0x0,
    0xbf242bbb, 0x0, 0xbf0bac79, 0x0,
    0x3dbf4af3, 0x0, 0x3f0d1722, 0x0,
    0x3f3bf7ab, 0x0, 0x3ef342aa, 0x0,
    0x3d337985, 0x0, 0xbf0fcb3c, 0x0,
    0xbf2a2bd0, 0x0, 0xbf0ae1a4, 0x0,
    0x3d939a59, 0x0, 0x3f0f0ab4, 0x0,
    0x3f44f3d1, 0x0, 0x3ef88f7e, 0x0,
    0xbd2f9915, 0x0, 0xbf12311a, 0x0,
    0xbf08298f, 0x0, 0xbf053850, 0x0,
    0xbdf65c37, 0x0, 0x3eee98eb, 0x0,
    0x3f328a5c, 0x0, 0x3ef27665, 0x0,
    0x3da1cb63, 0x0, 0xbeb68555, 0x0,
    0xbf28f9f1, 0x0, 0xbf0246dd, 0x0,
    0xbcdcf1b8, 0x0, 0x3f04ac7d, 0x0,
    0x3f2cf32c, 0x0, 0x3ef7d1c5, 0x0,
    0x3d26e8c0, 0x0, 0xbf1b408b, 0x0,
    0xbf34eb5d, 0x0, 0xbf0b44d0, 0x0,
    0x3cab4b55, 0x0, 0x3f04cd32, 0x0,
    0x3f436410, 0x0, 0x3efd9a99, 0x0,
    0x3d46f691, 0x0, 0xbed4540e, 0x0,
    0xbf342acb, 0x0, 0xbeebf332, 0x0,
    0x3c1b542e, 0x0, 0x3f04fe52, 0x0,
    0x3f346a3f, 0x0, 0x3f0761ce, 0x0,
    0xbd2f5c84, 0x0, 0xbf0578c6, 0x0,
    0xbf27851a, 0x0, 0xbf11664e, 0x0,
    0x3d32b115, 0x0, 0x3f021825, 0x0,
    0x3f471a92, 0x0, 0x3f03c360, 0x0,
    0xbda1cb1e, 0x0, 0xbed7cee2, 0x0,
    0xbf56b161, 0x0, 0xbf0181ce, 0x0,
    0xbc732d2d, 0x0, 0x3ee0b4e6, 0x0,
    0x3f32ca5d, 0x0, 0x3f09df45, 0x0,
    0xbb2b263c, 0x0, 0xbee71ae4, 0x0,
    0xbf13fac1, 0x0, 0xbed81243, 0x0,
    0xbd576e46, 0x0, 0x3f03ed67, 0x0,
    0x3f3a4424, 0x0, 0x3f0c8f65, 0x0,
    0x3d3dfde7, 0x0, 0xbf0fcb93, 0x0,
    0xbf2caa08, 0x0, 0xbf0f01c1, 0x0,
    0xbd8176df, 0x0, 0x3f06ad0e, 0x0,
    0x3f3725a5, 0x0, 0x3ee44aa0, 0x0,
    0x3c461912, 0x0, 0xbee7c262, 0x0,
    0xbf2f8ad3, 0x0, 0xbee542e7, 0x0,
    0xbcdc0477, 0x0, 0x3f081ba5, 0x0,
    0x3f42f1ee, 0x0, 0x3f1d1494, 0x0,
    0x3cc911e4, 0x0, 0xbf033de6, 0x0,
    0xbf3dddb5, 0x0, 0xbec2eff5, 0x0,
    0xbc0b14cc, 0x0, 0x3efec8e0, 0x0,
    0x3f254e23, 0x0, 0x3eff091e, 0x0,
    0x3b9a5192, 0x0, 0xbefc6a64, 0x0,
    0xbf30ebfd, 0x0, 0xbef5d99e, 0x0,
    0xbc363d20, 0x0, 0x3f03639f, 0x0,
    0x3f43506d, 0x0, 0x3f07e1a5, 0x0,
    0xbd3c5347, 0x0, 0xbefae96b, 0x0,
    0xbf279215, 0x0, 0xbf107fea, 0x0,
    0x3baf4afb, 0x0, 0x3ef94788, 0x0,
    0x3f32533f, 0x0, 0x3ecca511, 0x0,
    0x3b974c6a, 0x0, 0xbee64c4d, 0x0,
    0xbf3527c8, 0x0, 0xbf026b72, 0x0,
    0xbd196343, 0x0, 0x3efbc214, 0x0,
    0x3f402881, 0x0, 0x3ee064ad, 0x0,
    0xbcbc75b0, 0x0, 0xbf0a801b, 0x0,
    0xbf36b0df, 0x0, 0xbeddc913, 0x0,
    0x3c65c61b, 0x0, 0x3f06d160, 0x0,
    0x3f330698, 0x0, 0x3f0b34e4, 0x0,
    0xbcf9f881, 0x0, 0xbef0d7ee, 0x0,
    0xbf27a9dc, 0x0, 0xbf0e93c7, 0x0,
    0x3cb54c2f, 0x0, 0x3f01233e, 0x0,
    0x3f41f0c4, 0x0, 0x3eee25ed, 0x0,
    0xbddd6a6e, 0x0, 0xbee81472, 0x0,
    0xbf48ec45, 0x0, 0xbef62837, 0x0,
    0xbca6e179, 0x0, 0x3efda1d2, 0x0,
    0x3f4cd1bd, 0x0, 0x3ef942dd, 0x0,
    0xbcffd9a6, 0x0, 0xbf08619c, 0x0,
    0xbf2ab0d8, 0x0, 0xbeccbd7f, 0x0,
    0x3c53e26e, 0x0, 0x3ef2b8f9, 0x0,
    0x3f3449b6, 0x0, 0x3f0588a5, 0x0,
    0xbcd4fc5e, 0x0, 0xbef297e2, 0x0,
    0xbf38dedf, 0x0, 0xbf10f217, 0x0,
    0x3d3eb6e5, 0x0, 0x3f199e97, 0x0,
    0x3f30412b, 0x0, 0x3f108b9b, 0x0,
    0xbca7bc02, 0x0, 0xbf11e316, 0x0,
    0xbf2b3508, 0x0, 0xbee5829a, 0x0,
    0xbb99da1d, 0x0, 0x3eef40ab, 0x0,
    0x3f313a6b, 0x0, 0x3ee8ae97, 0x0,
    0x3d770167, 0x0, 0xbeead8de, 0x0,
    0xbf37f22c, 0x0, 0xbeda13bd, 0x0,
    0x3dac7565, 0x0, 0x3ef6e1c3, 0x0,
    0x3f37a648, 0x0, 0x3f0f6da7, 0x0,
    0xbc8e8eed, 0x0, 0xbed7f0c0, 0x0,
    0xbf3de8dd, 0x0, 0xbef19ecd, 0x0,
    0xbb12eebf, 0x0, 0x3f0aecfa, 0x0,
    0x3f38ddff, 0x0, 0x3ee3b372, 0x0,
    0x3e008b2c, 0x0, 0xbef5cfae, 0x0,
    0xbf371766, 0x0, 0xbef6f4f8, 0x0,
    0x3d86d740, 0x0, 0x3f0314d3, 0x0,
    0x3f3bb7d9, 0x0, 0x3ecbffae, 0x0,
    0xbccf6af6, 0x0, 0xbf058973, 0x0,
    0xbf2d80b0, 0x0, 0xbef5c22b, 0x0,
    0x3d0f39a1, 0x0, 0x3f0c0bbd, 0x0,
    0x3f1b1e77, 0x0, 0x3eff3e6c, 0x0,
    0x3d8d00c5, 0x0, 0xbef1bcf9, 0x0,
    0xbf28b07e, 0x0, 0xbefb2aaf, 0x0,
    0xbdbe2dac, 0x0, 0x3f068a28, 0x0,
    0x3f0f373d, 0x0, 0x3f04bf87, 0x0,
    0x3d6de30b, 0x0, 0xbee393e5, 0x0,
    0xbf2ed2cd, 0x0, 0xbedeb15d, 0x0,
    0x3e034d1a, 0x0, 0x3ef2347a, 0x0,
    0x3f2ba85e, 0x0, 0x3ed07373, 0x0,
    0xbd1cbac5, 0x0, 0xbf00fd00, 0x0,
    0xbf33c81f, 0x0, 0xbeff55b1, 0x0,
    0xbd67f7c6, 0x0, 0x3f1334d8, 0x0,
    0x3f3f28c1, 0x0, 0x3ef44919, 0x0,
    0x3936ff47, 0x0, 0xbefce627, 0x0,
    0xbf3a4e4e, 0x0, 0xbee9bd14, 0x0,
    0xbdb9c515, 0x0, 0x3eefc02c, 0x0,
    0x3f38b2db, 0x0, 0x3ed20c38, 0x0,
    0x3cb1f39a, 0x0, 0xbee60e94, 0x0,
    0xbf3d97f4, 0x0, 0xbeda1c95, 0x0,
    0x39ca7a12, 0x0, 0x3f078b52, 0x0,
    0x3f28e119, 0x0, 0x3ecba5c0, 0x0,
    0xbbc733f0, 0x0, 0xbed69a8c, 0x0,
    0xbf3fa6db, 0x0, 0xbefad662, 0x0,
    0xbcf5c9f8, 0x0, 0x3ee7c932, 0x0,
    0x3f43d77d, 0x0, 0x3f02428a, 0x0,
    0xbc2dfa9e, 0x0, 0xbef83f80, 0x0,
    0xbf40e572, 0x0, 0xbeb7c005, 0x0,
    0x3bdf0e64, 0x0, 0x3f02a97b, 0x0,
    0x3f228434, 0x0, 0x3ef65e04, 0x0,
    0xbd3361a6, 0x0, 0xbeea3632, 0x0,
    0xbf2c3672, 0x0, 0xbf090d10, 0x0,
    0x3d9c58cc, 0x0, 0x3eeb74c4, 0x0,
    0x3f3cae08, 0x0, 0x3f01520f, 0x0,
    0xbe0940fc, 0x0, 0xbecf9a2a, 0x0,
    0xbf35fee3, 0x0, 0xbeea8245, 0x0,
    0xbcae028c, 0x0, 0x3f0a82f8, 0x0,
    0x3f35625c, 0x0, 0x3eef27c1, 0x0,
    0x3ca11746, 0x0, 0xbf0f3dea, 0x0,
    0xbf3e12a5, 0x0, 0xbee412f1, 0x0,
    0x3d3a9b8b, 0x0, 0x3f046a0f, 0x0,
    0x3f46ebd5, 0x0, 0x3efb9afa, 0x0,
    0xbd4f82df, 0x0, 0xbec90d56, 0x0,
    0xbf22c70f, 0x0, 0xbf157160, 0x0,
    0x3d990408, 0x0, 0x3f092d1e, 0x0,
    0x3f377ec9, 0x0, 0x3f02d73c, 0x0,
    0x3d8297b9, 0x0, 0xbed9b9e9, 0x0,
    0xbf29a568, 0x0, 0xbec8ec25, 0x0,
    0x3c96ccc0, 0x0, 0x3ef7f904, 0x0,
    0x3f31cc25, 0x0, 0x3eeea7da, 0x0,
    0xbd9a9864, 0x0, 0xbecb1621, 0x0,
    0xbf35a2f7, 0x0, 0xbf090175, 0x0,
    0x3d7ac8ba, 0x0, 0x3f0db21a, 0x0,
    0x3f1847ee, 0x0, 0x3eeab27b, 0x0,
    0x3d347b90, 0x0, 0xbed8374f, 0x0,
    0xbf317805, 0x0, 0xbef19bcc, 0x0,
    0x3d44c68d, 0x0, 0x3ee93a4c, 0x0,
    0x3f4020c8, 0x0, 0x3ef19ee3, 0x0,
    0xbcfdb450, 0x0, 0xbf03bc42, 0x0,
    0xbf281896, 0x0, 0xbf00f654, 0x0,
    0x3c0eac18, 0x0, 0x3f109c2d, 0x0,
    0x3f2fa900, 0x0, 0x3f09d385, 0x0,
    0x3da4258d, 0x0, 0xbef5d3b1, 0x0,
    0xbf251c6f, 0x0, 0xbf11a1f6, 0x0,
    0xbcbf5593, 0x0, 0x3edf8018, 0x0,
    0x3f2f8cdc, 0x0, 0x3eedfdcb, 0x0,
    0x3c6799b7, 0x0, 0xbeede159, 0x0,
    0xbf334a66, 0x0, 0xbf145931, 0x0,
    0xbb91a448, 0x0, 0x3ee97287, 0x0,
    0x3f3a9698, 0x0, 0x3ee73772, 0x0,
    0x3d0b7bc0, 0x0, 0xbf0dcfe5, 0x0,
    0xbf38ecfa, 0x0, 0xbede8d8f, 0x0,
    0x3b829d67, 0x0, 0x3f0732fa, 0x0,
    0x3f2a4a60, 0x0, 0x3f0a6b5b, 0x0,
    0x3cd2b51a, 0x0, 0xbf029156, 0x0,
    0xbf2d559c, 0x0, 0xbf0320e0, 0x0,
    0xbd47f62a, 0x0, 0x3ee5cf01, 0x0,
    0x3f26e9fa, 0x0, 0x3f0e6b01, 0x0,
    0xbcd43731, 0x0, 0xbf03151b, 0x0,
    0xbf367cb5, 0x0, 0xbee49bb2, 0x0
    };

static const uint32_t in_cifft_noisy_4096[8192] = {
    0x4083c2dd, 0x0, 0x402312b0, 0xc0c98506,
    0x3fe4bda6, 0x4065197a, 0x3fe3d204, 0x401a1254,
    0xc05876a6, 0x405c887b, 0xbf2ff55b, 0x3f7c747f,
    0x3dce47e8, 0x40665796, 0xbfe86e39, 0x3d9e5ae9,
    0x405f8667, 0xbea3dc41, 0xbfa79273, 0xc0391e4a,
    0xc087edfb, 0x400fd45c, 0x3f6b18cb, 0xbfbcc874,
    0x3ff715d0, 0x3f3e7ebb, 0x3f11f43e, 0x3f196005,
    0xbfa062f7, 0x407cb682, 0x3f9497d7, 0x3edb6e24,
    0xbfe51b44, 0x40a4adab, 0x3eb75362, 0xc032e304,
    0x40134fef, 0x3e2ba4bc, 0xbe805d3d, 0x4013afef,
    0x404cc37c, 0xbe58b9c8, 0xbf591607, 0xc010683d,
    0xbff7905c, 0xbf4eb929, 0xbf186563, 0xc07d9ef5,
    0xbfa8a8a7, 0x40118498, 0x404a2e0d, 0xc08773fa,
    0xbf8e474a, 0x40969740, 0xc0b631ed, 0x40ad666e,
    0x3cc61833, 0x402007b3, 0x3f9c0f2c, 0x4049cd74,
    0xbf1c12e6, 0x3f1e162b, 0xbfac38ae, 0xc02f6ad8,
    0xc036fd5d, 0xbe52e819, 0x3fbc3b66, 0xc00a000f,
    0x3f9ef6a2, 0x3ff13f7e, 0xbc03fc0c, 0x3f8d0942,
    0xc011f52a, 0x3fc66320, 0x3f5c005c, 0xc09552bd,
    0x3fece2c7, 0x405ed0b1, 0x3fb712ba, 0xc07dcca7,
    0xc0bb3249, 0xc01a5f9a, 0xc04b7f06, 0xc0c35caa,
    0x4067b3a4, 0xc01f9497, 0xbccd6426, 0xbfbe2612,
    0xbf79fcfd, 0xc048851d, 0x3e5807fd, 0x40a148fb,
    0xbfaece40, 0xbf6a9ef8, 0x4074654b, 0xbfdd235c,
    0x4022b3f4, 0x3fc552f2, 0xc0635a78, 0x3f959dbd,
    0x3fbbdb71, 0x3cca08ae, 0x3f3717be, 0x3f0d2636,
    0xbfd10231, 0x3e617ec9, 0xbf281b10, 0xc0438388,
    0xbf9acf82, 0x3fbe22d8, 0xbf223723, 0xc010af68,
    0x3fd7c5ae, 0x3f3d9519, 0x3fad7aa7, 0x3f2bcfb2,
    0x3e8ec258, 0xbd76d595, 0x3f752c6a, 0xbf46150b,
    0x3fa6427a, 0x3dee4bd0, 0x3cddeddf, 0x3f85104d,
    0xbf9b2edc, 0x407bf411, 0x3ff12b2e, 0xc032ec61,
    0xc04daca1, 0xc04e1fe2, 0x40534d4f, 0x400a400c,
    0xbefb1a5d, 0x3e41914f, 0x3f91d845, 0xc01a8bbd,
    0xbf71d19d, 0x4082801a, 0x4011e266, 0x4028d553,
    0xbff294ed, 0xbfc8aa0b, 0x3f874a04, 0x3f1c2ef7,
    0x40335c82, 0x408dfe0a, 0xc07270da, 0xbf1b03aa,
    0x40970e51, 0x3fc3c6f7, 0x4025d8c4, 0x3f4b2c6a,
    0x3fe2272e, 0xbfbf55b8, 0x3f5a82c2, 0xbf5fc1d7,
    0x4084e4f8, 0xc085d1bc, 0x3f51a5eb, 0x3fbb7576,
    0x40193e5c, 0xbfa68b0b, 0xbf9cf28e, 0x400fb2d1,
    0xc007e9d0, 0xbe1b815e, 0x3f1285ab, 0xc08e6092,
    0xbf0edbc6, 0xc034a4d9, 0x403cd5c4, 0xbfd02abd,
    0xc07e1e39, 0x40021e70, 0xc06a2854, 0xc0a9140c,
    0xc0876ea8, 0xbf9d972f, 0x4028dce6, 0x40063959,
    0x3f965b26, 0x3fa612b4, 0x3f05dc01, 0x3e9d8eb3,
    0x3f4d8f69, 0xc023c520, 0xbf186475, 0x406c8ca7,
    0x3fe38103, 0x3f22b700, 0xc0398360, 0xbeac52b5,
    0xc0afabbe, 0x3ec14e5a, 0x40008a39, 0xbd5751c3,
    0x3f112e08, 0xbf09742b, 0x3f8e7348, 0x4087a0a5,
    0xbf578295, 0x3fe9e6c0, 0x3f50878b, 0xbf456a15,
    0x3f82f8ca, 0xc02eda1d, 0x3ef062bd, 0x3e34cf9e,
    0x4024fe01, 0xbf1c3278, 0x3f57fb2f, 0x3f4b4cf4,
    0x4002ffda, 0xbc59b05a, 0xc01d50b0, 0xc08b0672,
    0x404f4983, 0xbf2e4010, 0x4016fe5c, 0xbf59ee16,
    0xbfb8b8ba, 0xbf6cb8c8, 0x3fb94369, 0x3ef24b90,
    0x3f5d0bb4, 0xbf413a5a, 0xbff17215, 0xc0481e87,
    0x3fd99f21, 0xbdfecee9, 0xc0109681, 0x40acdbc9,
    0xc0215cd3, 0x3f469a40, 0x40b35f11, 0xc04d916d,
    0x40094096, 0x3e6059d6, 0xbf6c3793, 0xbf035dab,
    0x3ffef090, 0x409e03c0, 0x3fd4c486, 0x401dcc9f,
    0xbe5a3ca5, 0xc0ae24ee, 0xbf9f4c68, 0x3d05ef33,
    0xc09075c8, 0x40003a77, 0x402132f7, 0xbffde7b9,
    0x40002464, 0xbfda113c, 0xbf0974d0, 0xbebaad9d,
    0x3f1b718b, 0x409795bb, 0xbfe22276, 0xbed83732,
    0xc0bf6a3a, 0x3fc07820, 0xbf876e29, 0xbfe60ec7,
    0xbff3e401, 0x3fb1e2e3, 0x3ed91094, 0xbf2119b1,
    0xc0010108, 0x4069abc2, 0xbe11eb2d, 0xbd76d993,
    0xbf8c8348, 0x4067b404, 0x3fada384, 0xbe700283,
    0x3f06c691, 0x3f25be66, 0x3e98bd2b, 0xbe73b92b,
    0x3f875733, 0x409d8bd7, 0x3e6e5630, 0xbfe2694e,
    0x4059b5bb, 0xbfafb712, 0x3e4666e9, 0xc02fea18,
    0xc0806bc7, 0xc041cae1, 0x3e87f748, 0x404419cf,
    0xc00529ca, 0x3fd2ea76, 0x3ede56ee, 0x4069929d,
    0xbf1c1d2e, 0x3f3576b6, 0xbfb8d9e6, 0xc003c544,
    0xc0cc7618, 0xbf954f59, 0xc03c9419, 0x40321186,
    0x3fc18cea, 0x3f4042f6, 0xbf886095, 0xbdaa58e2,
    0x3fd7139e, 0xbfb1ca9e, 0x3ed5e13b, 0x403524e7,
    0xbd4a5c60, 0x4041065e, 0x401814d6, 0xbf4b0cf1,
    0x408cb188, 0x405a36c4, 0x3fe868c4, 0xc02e7536,
    0x401fc7cf, 0xc062a0fa, 0xbf86414c, 0xbef056d1,
    0x4020f3b0, 0xbe0087dc, 0x3fa9f349, 0xbf2cc1c9,
    0xbea96e93, 0xbef67780, 0xc0558bf1, 0xc097765a,
    0xbfec0c9f, 0x403088c7, 0x3e0ce363, 0x3d793111,
    0x406077fe, 0xbdc39453, 0x400e4551, 0xbe840cdc,
    0x40b1ecaa, 0x3eec9a07, 0xbff19fa2, 0xc004ffc7,
    0xbf838a25, 0x3f75632b, 0x3ffb04af, 0xc0f74b76,
    0xbeac7acd, 0x3f2cee4c, 0x3f948026, 0xc01a0b0c,
    0xc0198381, 0x3e1fec7c, 0x3ec4e369, 0xc06c17b0,
    0xc04bac74, 0xbfdeaa43, 0xc03161f8, 0x406ab643,
    0xbf4b7462, 0xbfc10f09, 0x40191149, 0x3f086d07,
    0x3fad726f, 0xbfaced0d, 0xbf7c4320, 0x40870802,
    0x3fdcd3f2, 0xc00f888b, 0x403e67c2, 0x3f9bf01d,
    0x401d0305, 0x3fa1a3a4, 0xbfc6de70, 0xc04be378,
    0x40100dc9, 0x3ff53447, 0xc0421fb6, 0xc01e1901,
    0xbd945490, 0xbfbee472, 0xc010f1f2, 0xbf97c9d9,
    0x3fee6f06, 0xc0660984, 0xc01646a3, 0xc017917e,
    0xbf9f0b86, 0x3fbc692d, 0xbff473f8, 0x3eb361a1,
    0x403d0b34, 0xc022f985, 0x4030ddeb, 0x3fb86612,
    0xc023796e, 0x4022c6d6, 0x3fd1c7a6, 0xc04af94b,
    0x3ff74863, 0x3fa9b65f, 0x402c6bba, 0x401c4a93,
    0xbf85ab8e, 0xbf8cfb52, 0xc037f447, 0x3fccccf0,
    0xc025b3fd, 0x4029bd9a, 0xbf72f131, 0xbfe1c2c5,
    0x3ff471e4, 0xbe10b6cc, 0xbfee2246, 0xbfb04813,
    0x40b2bcf1, 0xc04fe976, 0xbea36184, 0xbff7a42d,
    0xc04bea8a, 0xc0495068, 0xbfc7b144, 0xbf00c53c,
    0x3fb135a1, 0xbe857a0c, 0x402e8eed, 0xbf63b5a2,
    0xbf504050, 0x3f433f8b, 0x3ff84b45, 0x400b9bb4,
    0xc02ef476, 0xc033f486, 0xc0130e1c, 0x40818992,
    0xc01339ec, 0x3fa89ef2, 0x404e22a8, 0x3d83b5b5,
    0x4007c749, 0xc087f2f4, 0x4006711f, 0xbfa26b41,
    0x3e9ce650, 0x3f26fdf8, 0xc0088c1f, 0xc0d5d850,
    0xbf612215, 0x402d48ea, 0x3f8bc854, 0xbf954fe2,
    0xbf378319, 0xc008bf8f, 0xbf52bd28, 0x40446ce5,
    0x3f19b72c, 0xbeb6e954, 0x408efe38, 0xbf1cf6c8,
    0x3f847b2e, 0x4047fb5b, 0x40096355, 0x3f13309e,
    0xc0364c5b, 0x3f23d48f, 0xc030fb62, 0xbfedeb43,
    0x40b9d87c, 0xbf86d541, 0xbf25c8df, 0xc00463b9,
    0x4000e7cc, 0xbe42c3e9, 0xbec00f9c, 0x40224879,
    0x3ee5524e, 0x3f1f14b8, 0x3ec82c42, 0x40554b1e,
    0xbf451c6b, 0xbfc9505a, 0xbe553c73, 0xc09bc07b,
    0x3ff3e296, 0xc06f7ca4, 0xc00b3e2b, 0x40b61200,
    0x4031926c, 0x3ea3c016, 0x3eb959b7, 0x3e7d8684,
    0x401f85e9, 0x3e9c3330, 0x3ef0e105, 0x40618a46,
    0x3e249c73, 0x3fc9b565, 0xbebb852f, 0xbfb92920,
    0xbf2401da, 0xbfd90619, 0xbf043b09, 0x3f6eaaf8,
    0x3fa76081, 0x40118f29, 0x40757c18, 0xbfa35ef6,
    0x3fd77d0c, 0xbf88367a, 0x4025bcf3, 0x3edae4bc,
    0xbf8e3c15, 0xc012059c, 0xbfcd744b, 0xbfcbe8a1,
    0x3fce5217, 0xbecd52c4, 0x3fe3f942, 0xbf520903,
    0xc001dafe, 0x401dfe73, 0x3e9e6fc5, 0xbd249f07,
    0xc04bbed7, 0x403411b5, 0x3ebc7ce8, 0xc037c16b,
    0x3f559e4b, 0x3df09a62, 0x400f8a63, 0xbeba04c3,
    0xbfd6496a, 0xbe0c606a, 0xc0716388, 0xc0327fff,
    0xbf3c4d5e, 0xc027c773, 0xbfac5f8a, 0x3f9115ad,
    0xbf7b044d, 0x3f615cf5, 0x3f447864, 0x3fcbb8b8,
    0x401b5cb6, 0xbf779dff, 0x4023e1c5, 0x3fdf48b1,
    0xbf69a8a9, 0x409900b4, 0xc00f453a, 0xbf0d7631,
    0xbf279e2d, 0x401dff12, 0x3fb1faf4, 0xc000c9e9,
    0xbfebdb57, 0x40a59de0, 0xc009e763, 0xbf3628fa,
    0xc01d03b7, 0xbe98f223, 0x40c87db1, 0xc04b4618,
    0xc0802e03, 0x3fd25f61, 0x3f28b3f0, 0xbfdc076d,
    0xc08802d7, 0xbf01095d, 0x401dd0a5, 0xbf2959ee,
    0x3ffc9e44, 0x3dded34a, 0x3f9ab60d, 0x401bdb0a,
    0x3f57d0b8, 0x3ffa78d3, 0x3f6d8c76, 0xbf1a0be1,
    0x3f9c7323, 0x408caaf4, 0x40349738, 0x3f618673,
    0xc08f5f00, 0x40358996, 0x3f998620, 0xbf947431,
    0x3f02363c, 0xc017d85b, 0x3ebda21f, 0xc03a016b,
    0x3f6d3728, 0x3f97868c, 0x401c7833, 0xc0540386,
    0x3e8caefc, 0x3fc99da9, 0x3d942979, 0xc00a062f,
    0x40035f39, 0xc003dbe9, 0x404cbdf5, 0xbff1e7a3,
    0xbf362100, 0xc059cdb3, 0xbf43e5ea, 0x3f066c78,
    0x40699f55, 0xc05fabff, 0xbfc7ee41, 0xbfa226d3,
    0xc08d34c6, 0xc0a84589, 0xbf26563b, 0xc08f5090,
    0x40650af1, 0x3f5f73a1, 0x408c9014, 0xbd18901c,
    0x3fc1c969, 0x3fea9e20, 0x40819380, 0xbf76bd6c,
    0x3c756119, 0x4023cc31, 0x3e5d7602, 0x3fb7607b,
    0xc0109522, 0xc053bd66, 0x3fa40fe7, 0x408ea274,
    0xbf8d7119, 0x40aea64e, 0x402fe04e, 0x4087f9b9,
    0xbf927bac, 0x3f7b9859, 0x40173517, 0xbd87ae59,
    0xbe05ee05, 0x4039d9af, 0x3f3d3286, 0xc04c1763,
    0x404dea36, 0xbe985654, 0x4033c540, 0x3e6b5ba8,
    0xbfda9dd1, 0xc0415d5a, 0x4006f9cb, 0x3fb67a0c,
    0x3ddb153d, 0x3f176dfe, 0x3fc0cfda, 0xc04bc049,
    0xbf2dd9b8, 0x3ea3388c, 0x404b41aa, 0xbfc9fb91,
    0xbfdd3406, 0xc029d088, 0xbfbd5544, 0xbf792871,
    0xbfb59b4a, 0x3e53c1ed, 0x4073b4ba, 0xc021a936,
    0x3f12ba69, 0xc0b5304e, 0x3f79693e, 0x3f85fe9e,
    0xbc7a9f0d, 0xbf9b10df, 0x40c981e7, 0x4003340e,
    0x3e22e8e2, 0xc02c7dbf, 0x40ae344d, 0x40aea4e1,
    0xc031236a, 0xbc938cfb, 0xbfcff37a, 0xbf189da6,
    0x3fb44d71, 0xbfcdd618, 0x405deb61, 0x3f14e4c8,
    0xc0a29a5e, 0x3e6e149a, 0xbfcbc4e4, 0x3ff443d2,
    0x3e1a7b7c, 0x3ebf5575, 0x404988fc, 0xc01cfc2f,
    0xc06bbfe2, 0xbf9bb49f, 0xc07e7d81, 0x3e9e6c4a,
    0x3fc595fb, 0x3fb97600, 0x3f8889da, 0x3f6bc710,
    0xbfd04613, 0xbf67e471, 0x3f41486f, 0xc02f3814,
    0xc08ed6bb, 0xbff10ea6, 0xbfd0f133, 0xbdbbed2b,
    0xbeb510cf, 0x3fa11316, 0x3fd80cf6, 0x3f3ef5b8,
    0xc09bbc2a, 0x3f1640dc, 0x401ddd50, 0xbf6f3589,
    0xbfcf8461, 0xc020d198, 0x3eb389c8, 0x401f2393,
    0x404278af, 0xc050de6a, 0xc026f76b, 0xbfba68b1,
    0x3ef8f129, 0x404bc103, 0x3e85ce11, 0xbf918837,
    0x3ffe6f8a, 0xbf80524c, 0xc05fc7f8, 0xbf599b1f,
    0x3eeb2691, 0xbe2a7cb5, 0x3fe427de, 0x3fe175bb,
    0x3f0da22a, 0x40810edc, 0x3da0a429, 0xbff0392f,
    0xbee44ce2, 0xbbfc0060, 0x3d9bd6bd, 0x3f3f85aa,
    0xbe704f85, 0x3faa90cf, 0xbf67d5a6, 0x402e839d,
    0x401b0929, 0x3e81a98d, 0x3f6446e4, 0x3fab8407,
    0xc07888f2, 0xc00c58cc, 0xc0110dca, 0x403a2006,
    0xc0dc0c42, 0xbac5dd42, 0xc0009830, 0x3f9d8926,
    0xbfc92071, 0x400a57ba, 0xbdb68b31, 0x3fa59b26,
    0x405937f0, 0x3f58f2fa, 0xc0204877, 0xbe5d2a3c,
    0x4083b2a8, 0x401484ca, 0xbd74e329, 0xbfe9368b,
    0xbef4af69, 0x407ba3cc, 0xbf775f3d, 0x409ea353,
    0xc08b2cf0, 0xc04e22ca, 0x40255006, 0xbfd178de,
    0x400bbec9, 0xc0ac5894, 0x3fe21212, 0xc0a3ce09,
    0xbf19facd, 0x402db707, 0x3fa25d66, 0xbeffa422,
    0xbf9efe1d, 0x405fb7a7, 0x3f8a467b, 0xc002b27b,
    0xc01e92e9, 0x4035cc22, 0xbfff0d8b, 0xbed60a75,
    0xbf59807e, 0xbef4ff4c, 0xbfa81b3f, 0xbfb6df49,
    0xc0acc2e6, 0x3ff091c6, 0x403dab55, 0xbe2cb267,
    0x3e1b3c76, 0xc042341b, 0x3f46c4c5, 0x3c68c1ac,
    0xc003dd19, 0x3f9ee3ab, 0x3fa5034c, 0x3f82de65,
    0x402e866e, 0x3fa01e8c, 0xc03898fa, 0xbfa7ac5a,
    0xbf045540, 0xc0908ce4, 0xc0085f61, 0xbff03f1d,
    0xbfabf9e6, 0x3fd95843, 0xbf894855, 0xc0637397,
    0x40505f4d, 0x3d45df15, 0xbff89637, 0x3eb00375,
    0xc065822d, 0xbde757a3, 0x3fe0c975, 0xbf7298df,
    0xbf19d394, 0xbf34d526, 0x3ff81c09, 0xc00c6bc0,
    0xbfab3b8e, 0x3fbd0d53, 0x4082b559, 0xbf92cf08,
    0x3f6a4e41, 0x3fc41bc1, 0x3fd46c27, 0x3f14e6fe,
    0x404275cf, 0xbf845605, 0x405f2db0, 0x3fae3769,
    0x3be627e8, 0x3f523c5b, 0x4074e110, 0x3fcdad72,
    0xc016da5c, 0xc087caec, 0x3be2fbca, 0xc0876975,
    0xc01c3143, 0xc00e3da7, 0xbfbe32d3, 0x40a0313b,
    0x3f7e8ad2, 0xbfcb0c18, 0x3df68681, 0x3f89d69f,
    0x3ef85cd6, 0xbf3bb984, 0x3f9afdf6, 0x4022dc08,
    0xbf0ce781, 0x3fa8fe9a, 0xbf89cf53, 0x3fade231,
    0xbf4487b7, 0x402e5f81, 0xbf85ea5a, 0xbbd7178e,
    0xc0479630, 0x3f865701, 0x400c7269, 0xbec6ff50,
    0x3f054a72, 0xc07cd210, 0x402aa9e1, 0x3e365b1c,
    0xc01e86f4, 0x402ffae3, 0xbefe0cfa, 0x3f0e65d3,
    0xbf126134, 0x3f6a0b77, 0xbf5927e9, 0x3e950851,
    0x3f8f599b, 0x3f091d1f, 0x3e0f573e, 0x3f94e0ec,
    0xc04c20bd, 0xc062bfeb, 0xc07b80cc, 0xc0664d4d,
    0x3ede962a, 0x3efd9ffb, 0xbeaca9c2, 0x3f24b7d1,
    0xbef9ab94, 0xbde9269b, 0x400a049c, 0x4021d54d,
    0xc018e099, 0x40c235ae, 0xbe289b0d, 0xbf2b9b2b,
    0xc08c6f34, 0xc04df366, 0x4045208c, 0x40d4d245,
    0x3fc36731, 0xc054a150, 0xbfa9b34f, 0xc0161e2f,
    0x3f36f7ed, 0x3faa4166, 0x3f0d5584, 0x3fca4094,
    0x3ef1cbf5, 0x3ee82c5a, 0x3eb921f8, 0x4093747f,
    0xbe8ecfdd, 0xbed51908, 0xc02990ac, 0xbf1d1b3e,
    0xc05f26c3, 0x3f0aa7db, 0xc006b9be, 0xbfd34693,
    0xbe53a7b7, 0xbf8b30a1, 0xc02c4521, 0x3ec4c823,
    0x4041af0b, 0x4021b633, 0x3f08a2be, 0x4058064d,
    0x404db235, 0x3f9a61fe, 0x3f2c4222, 0x3ea33ec6,
    0x4098c260, 0x4084e400, 0x3ee893ca, 0xbf70e13b,
    0xbf54897b, 0xbdbc9db2, 0x3face735, 0x402831a0,
    0xbf91bbbe, 0xbcc4f478, 0x3f9d3f5b, 0x3e5a698f,
    0x409d8d20, 0x40a10fc4, 0xc030ce85, 0xbf1329b8,
    0x40993052, 0xbf907d04, 0xbfc68263, 0x403b26de,
    0xbd5dcf62, 0xc02b6fae, 0x40662d1e, 0x4044267f,
    0xbfa24203, 0xc022efc3, 0xc05d9e46, 0xc047440e,
    0xbfd1d8a4, 0xbfc38ddb, 0x3e17674c, 0x3ebbec0c,
    0x3e9f8e40, 0xbf5667cf, 0x404b9968, 0xbf59aa45,
    0xc00c7bc6, 0xc0a4a903, 0x3fea2387, 0x40150ef9,
    0x4060296d, 0x3fdd76fa, 0xc03c9bf6, 0x3f8bde6d,
    0xc073ee96, 0xc03772f0, 0xc02dd049, 0xc02b8961,
    0xbfbc9498, 0x3f9160bb, 0x3de5cd27, 0x3d2d329f,
    0x4080ea19, 0xc065bc66, 0x3f539394, 0x3e83891f,
    0x4062d580, 0xbfd6e12d, 0xc06ccf7e, 0x3f021c66,
    0x40455483, 0x40112c00, 0xbfed1738, 0x3fff4a67,
    0x3feaa8d8, 0x3feee233, 0xbea2c193, 0x3fa51357,
    0x3f49b62a, 0xbf92a029, 0x402a857e, 0xc02b99ba,
    0xbecc662b, 0xc4b337e2, 0x405bd59b, 0xbffdb32a,
    0x401ecd5c, 0x3fbdd8a3, 0xc039c54a, 0xbf8dd9e3,
    0x401804dc, 0x3f6b14ca, 0xc0096849, 0xbfe4dc46,
    0xc095522a, 0x405ad0af, 0xc02378fc, 0x40525701,
    0xc03f4897, 0x4049f961, 0x3c9407b2, 0x4067a06d,
    0xbfc48d44, 0x4002ad9b, 0x3fcc825b, 0xc0774689,
    0xc0922af1, 0xc0158656, 0xc0173c42, 0x4004d7cb,
    0x3fda6cf0, 0xbed57b8a, 0x3f620e3d, 0xbf2b47f5,
    0x3ed2f032, 0xc07c9d95, 0xc0d064f8, 0x3fe7fe4b,
    0xc096b6f1, 0xbfad6ae2, 0x3ef7b216, 0x40151d83,
    0xbf9fab69, 0xbeb75bd3, 0x407345a3, 0xbfd75467,
    0x3fd8bf39, 0x3f87c11b, 0xbebed3f4, 0x4024c78c,
    0x3f11182d, 0xc00bc3bb, 0x4037caa6, 0x40b2f88c,
    0xbfd3558b, 0x402195c6, 0xbede8602, 0xbf83c372,
    0xbf7a9f8a, 0xc02ac31a, 0x4005878c, 0x3f4286dd,
    0xc01ec8f4, 0xbff033c5, 0x3f9153a2, 0xc05da064,
    0x3f242a5e, 0x3f769944, 0xc090b35d, 0xbfc2d976,
    0x3fd6c17c, 0xbf61bc06, 0x406fdb4b, 0xc000669c,
    0xbf650433, 0xbf4e2ae2, 0xbf10c391, 0x3fd2ae12,
    0xbfe1fa2e, 0xc091f09a, 0x3fa91e95, 0xc032ea21,
    0xbf066279, 0x3fecbdea, 0xbfde1d74, 0xc058e7ae,
    0xbb7efa02, 0xc060e70f, 0x3f841f82, 0xc045eb21,
    0xbfb047e2, 0xbf605dba, 0xbfdcea64, 0x403ac4d2,
    0x3fbeea40, 0xbfddd326, 0xbf39b1eb, 0xbf7d2324,
    0x3e350c0c, 0x401398c0, 0xbec111b7, 0xbf31195c,
    0xbe851067, 0x3f4e91cf, 0x3f9156bf, 0x3f45ba95,
    0xc040d3ca, 0x3e0ac8a3, 0x3f508c42, 0xbf88f496,
    0x3e206aa7, 0x3e64dc2e, 0xbe89e1cf, 0x3ef9c79f,
    0xbf1a17b4, 0x3eb103d8, 0x40065ee7, 0x3efb1543,
    0x3fb68d18, 0x3fd8e8b4, 0x3d8a2705, 0xc067b372,
    0xbf8f641e, 0x3fab17b7, 0xbf34a217, 0x402432ad,
    0x3f847649, 0x40906e0e, 0xc06c61c8, 0xc02577fc,
    0x4066e8f7, 0x3d5f5d81, 0xc072b5d6, 0x3ea0b8d8,
    0x3fb361bc, 0xbffc848b, 0x3fa006f3, 0x40163293,
    0x403db2af, 0x4007690d, 0x40112583, 0xbfec904d,
    0xbffc2114, 0x3f11b4e4, 0x3f45e7f8, 0x4081b837,
    0xc038ce30, 0xc071943e, 0xbef74a53, 0x3c386d80,
    0x40392157, 0x404d9429, 0xc00777cd, 0xc02903c0,
    0xbf879fe1, 0x400b116e, 0x3f2c5213, 0xbf2a2b5e,
    0xbf8c1b31, 0xbf6c3408, 0xc0267e58, 0x3eb1cc58,
    0x3f8b9a81, 0x4031ce6d, 0xbf96b9e8, 0xbf563882,
    0xbf8564fa, 0x40c1a029, 0x408fe19f, 0x4038cb06,
    0xbfcc162c, 0x4046d0d4, 0x3f0ef6e4, 0x3f1fd431,
    0x3efa45b1, 0x3ff9b50b, 0x3c7a2c88, 0xbf73b99b,
    0xbf81adc0, 0x3ff65019, 0x3e384bab, 0xbf1b6677,
    0xbfb3c7d5, 0xc000b362, 0x3fc00110, 0xbf4a049e,
    0x3fb9449a, 0x3ef96784, 0xc09f42ab, 0x3f6625b7,
    0x3ed4669f, 0x3f81e855, 0x401a4cb4, 0x401b4438,
    0x40411081, 0x3fba702d, 0x409e6000, 0x3f654c2d,
    0xbdf53c9d, 0xbf43e151, 0x40840bd5, 0xc0ab7fb3,
    0xc045b6fa, 0xbfaccb72, 0x401af614, 0x40140cf9,
    0xc05af000, 0xbf21eeae, 0xc06ddf3c, 0x4018a2b7,
    0x3eed84b0, 0x3e874e0d, 0xbef79955, 0xc0200324,
    0xbe623b7a, 0x3f04be98, 0x408daddb, 0xbff9d8df,
    0x3e6abb23, 0x3f20a714, 0xc02425af, 0xc01a5ca6,
    0x3d33cf41, 0x4067d08c, 0xc0810313, 0x40abdbac,
    0xc04e391f, 0x3fdb1528, 0xbfcac17d, 0x4092d68d,
    0x3ec404b8, 0x3fee4ade, 0xbfc9df89, 0xbfc9b02f,
    0x405fb0e0, 0xc040c78e, 0x4035464d, 0xbf817f3a,
    0x3ff1f364, 0x4035c918, 0xbe10f445, 0x40937076,
    0xc004d810, 0xbf4af80f, 0x408a13d4, 0xc01f8116,
    0x4001c467, 0x3ec86054, 0xbf235d45, 0x3f9a71dd,
    0x3f906836, 0xc010d936, 0x3f862fa8, 0x403b5b21,
    0x40af493e, 0x3fb3bfb2, 0xbfc13529, 0xbf48bab8,
    0x4085bfcf, 0x3efa61af, 0x3fdf5c93, 0xbfa148f1,
    0xbec77c0e, 0xbfce54d5, 0x3eb11d75, 0x3f67f1d6,
    0xbeceb83c, 0xc09c1fdf, 0xbf3394bc, 0x3f29509c,
    0xbfe49a77, 0xbe24ac08, 0x40366cf8, 0x3f63ea31,
    0xbfe56426, 0x400674fb, 0xc070220f, 0x3da377a5,
    0xbfdc9a28, 0x3e88b0a1, 0xbe9b32ab, 0x3f0dd592,
    0xbee30d7a, 0xbfe19ee0, 0x3ee10801, 0xc01b7e0b,
    0xbebe951e, 0xc0016e4f, 0x3f92ad6b, 0x3f408f6c,
    0x403c8d0e, 0xc0263956, 0xc00d1cfe, 0xbe81ae86,
    0xc0093713, 0x3de9eed3, 0xc07aeab4, 0xbf840b16,
    0x400ddd4b, 0xbfab1fc3, 0xc08e2ffa, 0xbe4d88cd,
    0x3f8ae906, 0xbf40cd80, 0x4059a46c, 0x3ec9e229,
    0xc094c173, 0x40687baf, 0x3fd5f7b6, 0xbe05ff91,
    0x4010682f, 0xbfc97e6b, 0x4014077a, 0x3fe3c7c6,
    0x3f3957e6, 0xbf050deb, 0x3ea98a8a, 0x40aaa70a,
    0x3f6d3369, 0xbf638c1e, 0xc05e479a, 0x3f02c61f,
    0x401674e8, 0x3ef8fde5, 0xbe1a97ff, 0xbf3dcd0f,
    0xbf6044cd, 0x401beb8d, 0x3e574d56, 0xc052782a,
    0x3fd81f57, 0xc086581a, 0xbfc97eb7, 0x3ecc02ce,
    0xbf2ba710, 0xc05b5900, 0xc026f858, 0xba47dc3e,
    0x405b591f, 0xbe023b9b, 0x40364a7f, 0x402fca17,
    0x4023ff8c, 0xbe8c1072, 0xbfc2c62c, 0x3fbb0c79,
    0xc055c872, 0x3f4e6e7b, 0x402615ad, 0x3f9de981,
    0x3f0dad5b, 0x3faf1b08, 0x3f94211c, 0xc08c1f1e,
    0x4078a6ea, 0xbdc6ff06, 0x3f16061d, 0xbf03200d,
    0xc014a65d, 0xc041e542, 0xc05f4e3b, 0x3ff516a9,
    0x3fd545f8, 0xbcafbf7f, 0x3f67565b, 0x3f933331,
    0x404fcba9, 0xbf845139, 0xc0455595, 0x40248990,
    0xbfc34f6b, 0x3e6151f9, 0xbe07b774, 0x3f07d513,
    0xc0008871, 0xbfb46cb5, 0xbf9f27c6, 0xc0b43c69,
    0x3fcb035d, 0xc0941b6c, 0x3f59d3b2, 0xc02401cf,
    0xbff70e5c, 0x402d760f, 0xbf7f86f8, 0xc000b2cf,
    0x3fa5f550, 0x3fad1b8e, 0x403ae9ed, 0x4018c2a8,
    0x400dd74b, 0xbf8cea66, 0x4022c9d9, 0xbeb912fa,
    0xbdf1239c, 0xbe20606c, 0x3f917eae, 0xc0215532,
    0xbfa291ed, 0x40059b6a, 0x4072a9ec, 0xc0061a35,
    0x3f146f45, 0x4007f589, 0xbf833b23, 0xbd7ddd1b,
    0x402a0a60, 0xbf607b02, 0x3fa23e39, 0xbf526b39,
    0xbfaddbec, 0x3e76bd77, 0x3fc99b8a, 0x402ba985,
    0xbd8f0a57, 0xc02a3e3e, 0x4028868d, 0x3f3a9d65,
    0x3f684616, 0x3fbf1639, 0x3f8296c7, 0xbf8fa247,
    0x40c918f7, 0x3fa8a415, 0xc030ed11, 0x409013a1,
    0xc03862f0, 0x3e9736b9, 0x40756668, 0x3e120c73,
    0x3f844139, 0xbf7833a0, 0x3fd4ef6c, 0x3f11638c,
    0x3f872058, 0xbff55269, 0x3eacb005, 0xbfb9a384,
    0x3fc10bc6, 0xbf232d93, 0xbf094d0b, 0xc0312faa,
    0x3f5d1f81, 0x40370cae, 0xbf979a5e, 0x3f931613,
    0x4094e609, 0xc09ca890, 0xc08da472, 0x3e833039,
    0xbf02af1d, 0x40089812, 0xbe62bbfe, 0xc01655f2,
    0xc0453ccc, 0xc028fc26, 0x4091de28, 0xbf99e4c8,
    0x3f932513, 0xbe84d5d8, 0x404a3cbc, 0xc066cb18,
    0x40d34ee1, 0x400078a3, 0x3fd9bfac, 0xbea9d4e4,
    0xc02c88a2, 0xbfcda5c7, 0x40308913, 0xc01d8f32,
    0x40189445, 0x402ff7a4, 0x3fc9abfd, 0x3eb3b06a,
    0xc06c6f8b, 0x3ea5badf, 0xc081a68d, 0x3eabf974,
    0xbfd3630c, 0xbf9b91fe, 0x3fdc0b69, 0xc01e0656,
    0x3f734d62, 0xbfaa07b5, 0x3e24efd4, 0x400f5c73,
    0xbdcb03e5, 0xbd83374d, 0xc0b49d48, 0xc0109399,
    0x3f454f73, 0x3f189248, 0x3f92f454, 0xbedd41f0,
    0xc085313e, 0xc0480d0d, 0xbf51826e, 0xbf939529,
    0xbe3e58d2, 0x3fd60d46, 0x406d16cc, 0xc01c5e20,
    0xbfc0ae0f, 0x3fbc34bb, 0x3f91becf, 0xbd2044e8,
    0xbfaf2dff, 0xbf48f645, 0x4031abb9, 0x3f09a10b,
    0xc0233252, 0x40c653d9, 0x3fa36832, 0x3e2513f7,
    0xbeb709b3, 0x3e9ecc94, 0x3e7c7ea6, 0xbf2c7385,
    0xbe6df45c, 0x3fcc4c28, 0xc04e02bd, 0xc0441791,
    0xbf5091f5, 0x3fa24c81, 0xbf64c3b2, 0xbfe4a17f,
    0x3fb8d71d, 0x3f997812, 0x3f162119, 0xbd61db5d,
    0x3fc66cc4, 0x3f0664f2, 0x4051c46e, 0xbfa1729d,
    0x400a5c4c, 0xbfdf2948, 0xbf83388d, 0x3e13393a,
    0xc0317b59, 0x402a40e9, 0xbf52c7b2, 0xc056cfd4,
    0xbe812636, 0x3cd62a3a, 0xc001361f, 0x4036e425,
    0xc01be010, 0x3ff5dcf5, 0x403e105b, 0xbf072e50,
    0x3feb7bee, 0xc047d420, 0x3e124ce9, 0x3fab49b9,
    0x40386550, 0x3faf40b8, 0x3f8593a0, 0x3fdeb25e,
    0x3faf83db, 0xbf5ef27f, 0x4088c69f, 0x40486218,
    0x3dc930d6, 0x3e3b306b, 0x4094c758, 0x3f45a39f,
    0x4000507f, 0x3fc0b569, 0x3e99d3bc, 0xbfbaa9dd,
    0xc020d98c, 0x3f5c8a2c, 0xc036a33b, 0xbfa1a0af,
    0xbebe6804, 0xbecb897e, 0xbf94c84c, 0xbe81b5f1,
    0xbfc4306a, 0xc008f2ba, 0x3fa64a33, 0x3f169cb5,
    0x3f45e68a, 0xbf751a99, 0xbfd1c2c9, 0xc01ed6e1,
    0xbe96254b, 0xbfcace1c, 0x3f8b048b, 0x3fb489db,
    0x3fac421e, 0x3f428c6c, 0xc05528a4, 0xc08dea7e,
    0x4054d74b, 0xbe2afd7c, 0x3ea3f4f1, 0xc001736a,
    0xc0638b1b, 0xbebc36e4, 0xc00c8bfb, 0x40942801,
    0xbfecaa35, 0xbf76d8e4, 0xbf9423b0, 0x3ef36f6d,
    0x3f07ae7c, 0xbf1d39f8, 0xc036a80d, 0x40e06305,
    0x3f992b32, 0xc0353670, 0x40113c5b, 0xbf170a44,
    0x4064f721, 0xc083ee17, 0xbfeb09ed, 0xbfa700e8,
    0xbf348a01, 0x400a8dfa, 0x401e9aa0, 0xbf5f0f7f,
    0x40a27a23, 0xbe1cc897, 0xbfd57370, 0xbe5ad2f2,
    0x3efed58a, 0xbf344b8e, 0x40910ad4, 0x3f197362,
    0x40bfb48b, 0x403d08e7, 0xbfc3e0a4, 0x40122e7a,
    0xbfd080af, 0x40b0b153, 0xc0824c2b, 0xbf6a9c5d,
    0x3fd0a01f, 0x3f85cceb, 0xbfb0aa58, 0x3f579e94,
    0x3f765986, 0x3f31c4b4, 0xbefb11d9, 0xbfb48d75,
    0x3ecfa34e, 0x4085c2bf, 0x400172b2, 0x4064b36a,
    0xc02d8922, 0xbfcdef44, 0xbefcc121, 0x409276f5,
    0xbfb0dd72, 0xbf2ed68c, 0xc09fe9ee, 0xc006a9fe,
    0x404dc69e, 0xbff1b8b2, 0xc088fcad, 0xbfb3e025,
    0xc04c6f2e, 0xbfa172fb, 0xbfe209c4, 0x408e4cf2,
    0xbf3b6b66, 0xbfb4fe10, 0x3fbf20c6, 0x4075f435,
    0xbf901281, 0x3fbd8068, 0xbf69a14d, 0xc01fbc59,
    0x3ec1645a, 0xbe1c36f5, 0xbe8fcbc9, 0xbf3a0cec,
    0x4066ce62, 0xbf989548, 0xc020831b, 0x3fe8eac7,
    0x400cf138, 0xc05898f7, 0xbff60f29, 0x4022057a,
    0xbfb1fb23, 0xbff45708, 0x3ff6b06a, 0x3d80b5a4,
    0xc02de8bf, 0xc0886ab7, 0x3f90f6f4, 0x404472ae,
    0x402a31e3, 0x3e7e348b, 0x3ff3dfe4, 0xbf24d8ea,
    0xbfbab16d, 0xc0537107, 0x40090fe7, 0x3f6ba825,
    0x401474d4, 0xbfaf29bb, 0x401c9ee5, 0xbfe2eab2,
    0xc07491f8, 0x3f8e06ea, 0x409b61cc, 0xc0830f21,
    0x3e99238a, 0xbe5ae111, 0x3fa1492c, 0x40341d78,
    0x40731bf4, 0xbefd1657, 0xc071ec10, 0xc02fbb57,
    0xc083c620, 0x405897f2, 0xc08bae25, 0xc0038815,
    0xc0032009, 0x3fff71b3, 0x3f2a911b, 0xbf4bcd47,
    0x3efa5b0f, 0x3fb7c43e, 0x3d9df475, 0x3e93be3b,
    0xbf97dbfa, 0xbface3f4, 0xbff82fd8, 0xbfcf8a85,
    0xbf1cc43e, 0xbfaa7bdf, 0x403fbd5d, 0xbfe657b4,
    0xbfb83a6c, 0xbff36bc1, 0x3e2ce9b7, 0x409b32dd,
    0x3f8d9a0f, 0xbf18205a, 0x3ed8fbc0, 0xbf1572c5,
    0xbe80c888, 0xc0772444, 0xc01c28c9, 0xbf0069d2,
    0xc048abcb, 0x3fd3fdfd, 0x4052cc00, 0x40d8fa0e,
    0x4037de14, 0x40194709, 0x3eb59890, 0x3fa70230,
    0xbe9b50ad, 0x404e2839, 0xbe8c6952, 0x3f2f1608,
    0x3df7cb2c, 0xbf6ddb3c, 0xbea42d9a, 0xbe251176,
    0xbf4ed4b1, 0xbf6aa29f, 0x403f5c57, 0xbfb49081,
    0x4015db0e, 0x40041ca5, 0x3fa1500a, 0xbe6b7735,
    0xbe95a0ac, 0x3efdf11a, 0xc01b9b1d, 0x3fb02ed2,
    0x4020465f, 0x3f4f08a8, 0x3fbcca5e, 0xbec620f5,
    0xbfad081c, 0x3ef1ca2d, 0x400ccbf5, 0xc012bf06,
    0xbe52d34c, 0x3f159c3c, 0xbfc80297, 0x3f236e59,
    0x3e0f91a4, 0x3f80f1b2, 0x3fa5fc41, 0xbe987b4d,
    0xc028cd9f, 0xbfd2fd45, 0x3fcc7a38, 0xc032a085,
    0x4062e4b2, 0xbf940035, 0x40041b9c, 0x40579636,
    0xbf777fd4, 0xc0383bab, 0xbf892f03, 0x4012dc90,
    0x40856ab6, 0xbf1cb40d, 0xbf8d243a, 0x3f756f79,
    0xc019cb31, 0x3f9491f4, 0xbee1270c, 0xbfe9b151,
    0x3f8d0b8b, 0xbef016bf, 0xc00316ec, 0xbfa72d1a,
    0x3ee3d564, 0x40120229, 0x3f5073af, 0x3fdd9483,
    0xbf689c59, 0xbdcb9d77, 0x402cf5e1, 0x3f1aeccf,
    0xc02c84c4, 0xbf959353, 0xbf658f6d, 0xc0055e46,
    0xbfb4fc9e, 0x402d8274, 0xbff57628, 0xbe8309df,
    0xbe838e24, 0x404bd2ae, 0xbf0ebd7c, 0x3e3b4417,
    0x3fb03bb9, 0xbe88871c, 0x3e8b4dc3, 0xc020b7f8,
    0xbf57ace8, 0x3fc503d8, 0x3f1a1975, 0x3e524e60,
    0x4097a7ff, 0x3f926023, 0x401d0475, 0x3fd8e9bc,
    0x3f2d6490, 0xbf09ab84, 0x3f1897ac, 0x3fccacb1,
    0xc00aab96, 0xc07a7a73, 0x408478d0, 0xbf7ec4f7,
    0xbe3dd0d9, 0xbf68def9, 0xbfa6b2dc, 0xbfa13af5,
    0xbf7c0df1, 0xbf1d4239, 0x3f92f500, 0xbf07ef2c,
    0xc0015df0, 0x3f8e46c0, 0x3ffdf33b, 0xbd9f3531,
    0x3f114681, 0x4001d5b7, 0x3dcf8010, 0xbfa7a935,
    0x408b841f, 0x3ff6a4d5, 0xbfb618f4, 0x3f55e312,
    0x3f8a9890, 0xbfa21798, 0xbfc7f941, 0xbf392009,
    0xbff647be, 0xc0400bb2, 0x3f69f6b6, 0x4032813c,
    0xc069cb4f, 0xbf7b06fa, 0x3f5acd03, 0xbed9e41f,
    0x401f73f4, 0x3e28cdc5, 0x3f422b6b, 0xbd7792ef,
    0xbf619e39, 0xc0c66aff, 0xbf1d6d04, 0x3e8ec5a2,
    0x3ff5e903, 0x405a6447, 0xbb809b2f, 0x3f8769e9,
    0xbf042973, 0x409fea92, 0x40373705, 0x4098359e,
    0xbe5520f0, 0x3fc9ae2f, 0xc042d298, 0xbfc131e5,
    0xbe8c5f66, 0xc05ec2de, 0x403569d8, 0xc07a39c3,
    0x3f9ecb01, 0x3fa1e13b, 0xc0399a18, 0xbfc81819,
    0x400c78c0, 0x400e1afb, 0x3e0e248e, 0x3fd68ac5,
    0xc0187b90, 0xbf8b53b7, 0x3f78afc2, 0xc025b3b1,
    0xbfa9c71b, 0x3eff7857, 0x3fbec379, 0x3fe35ebc,
    0x3ea6abff, 0xc055783a, 0x3f46eee6, 0xbf23777d,
    0xbfa826cc, 0x4026d9b2, 0x402de68b, 0x3f467342,
    0x3fafd4a9, 0x40697965, 0x4044db1e, 0x40619876,
    0xbf4a9d86, 0x403f6f8b, 0xc0560ea7, 0x3eae0d82,
    0xc050ddeb, 0x3f46bd5b, 0xbf3ba048, 0xbdffbf8d,
    0xc0158827, 0x3fcffce9, 0xbff5bc66, 0x3f85ac5b,
    0xbeac91fb, 0x3fb9f4b2, 0x3f825b28, 0x403b3704,
    0x3f52f772, 0x3fbaf761, 0xbe1527ad, 0xbf98cb20,
    0x3fcf2ab8, 0x3f7385b4, 0x3fb08202, 0xbf47293e,
    0xbf7c7cac, 0xbffff352, 0xbffb8e22, 0x4060b5c8,
    0x407982a1, 0xbec3e4e6, 0x3fca63fc, 0x3f5ad51d,
    0xbeee7f8c, 0x3eca7b66, 0x40c4ce27, 0xbf1cb0dc,
    0xbf26eaee, 0xbef6c4bc, 0xc0061786, 0x3cac160c,
    0xc02fa07d, 0xc002de1b, 0x40c461a8, 0xbf84720a,
    0x3fa62c61, 0x408f0e36, 0x40ab92bc, 0x40ae5000,
    0xbf7d7321, 0x3feb3255, 0xc04a1362, 0xc09c5659,
    0xc03750ae, 0x4022602a, 0xbefb99bd, 0x3f47c0cd,
    0x3f3602dc, 0xbe7171a5, 0xbf864d15, 0xc031574c,
    0xbfaf90f0, 0xbfcb1e0d, 0xbf86178f, 0xbf9bf606,
    0xbf83124a, 0x3f4f1750, 0xbffb8574, 0xc0317576,
    0x4080ee26, 0xbcd17dc9, 0xbfe072a2, 0x3e233703,
    0x3ddfd1b7, 0xbecb8fda, 0xc0077b33, 0xbf208a4f,
    0x3fed0645, 0xbfec9394, 0xc001bee7, 0xbf1dedde,
    0xbfe9190a, 0xbed636c2, 0xbe2b33db, 0xbef383aa,
    0xbfae6e43, 0x3f2a2940, 0x3f867ead, 0x3ea6f47a,
    0x3f93e6f0, 0x40294f3f, 0xbfc4ad37, 0xc08b384e,
    0x40abc997, 0xc055289f, 0xbfa40201, 0x3dda6747,
    0x3fcee5a2, 0xc00ef199, 0x4012727b, 0x3fb768f3,
    0x3dd6991a, 0x402e9c64, 0x403cbbaf, 0x4000271e,
    0x3ef68195, 0xbf47f62d, 0x3fb1c28b, 0x3fae68fb,
    0xbf1b2873, 0x3f236f97, 0x3e54f6a1, 0x3fb3e9c5,
    0xbecb66d1, 0x3fc11130, 0x3eb767a1, 0xc099d0ab,
    0x3d4eb153, 0xbe67225e, 0xbffeaa2e, 0x3ea07694,
    0xbeddd754, 0x3f1f177d, 0x3efb4f61, 0x40530751,
    0x4050f0f6, 0x403d8eec, 0xbf5cd745, 0x40215d25,
    0xbecbb6ca, 0xc013501f, 0x408d4d6f, 0xbf8d942f,
    0x4012ade0, 0xc00d37bc, 0x4035f650, 0x3f6146f7,
    0x3ef86eff, 0xbf41d945, 0xbf2ca592, 0xbedb284c,
    0x3fc6074b, 0x3e96b285, 0x3ffe0017, 0x40660b43,
    0x401067eb, 0x3c849251, 0xc0095cab, 0x3f90a4c9,
    0x3f11541c, 0x3ffeb37e, 0xc0aa72ed, 0xc0312022,
    0xc00c2f8b, 0xbef33150, 0x3f094927, 0x401c05ba,
    0x40b13805, 0x3fb05174, 0xc0667106, 0x408c9796,
    0x40461d69, 0xbfef07dd, 0x3c605a5d, 0xbee7dd23,
    0xc05f259d, 0xbf9f59ff, 0x402ed958, 0xc06a0481,
    0xbf435668, 0x3f0fcdf7, 0xc03cc914, 0x3fb72b12,
    0x3fc4dbf1, 0xc00fbfdb, 0xc0776ce3, 0xc01db653,
    0xbf13afcd, 0x3e8130a0, 0xbfd20849, 0x3f574b39,
    0xc09828cb, 0x401a473b, 0xc0832b49, 0x3f1aa35c,
    0xbfe38d8d, 0x3fde1d08, 0xbf93d818, 0xbc4c3e64,
    0x4007f04e, 0x409d238e, 0xbedd0b4d, 0xc01be8fa,
    0x3e94b56d, 0xbf7335a4, 0x4080d527, 0x40377f30,
    0xbfd4c2a6, 0x3f9b469b, 0xc016b67c, 0xbf72212f,
    0xbf03b86f, 0x3eaa4665, 0x3f582b8b, 0x403abed1,
    0x3f285fe8, 0xc01d222a, 0xc0189332, 0xbed0c6e0,
    0xc09a2946, 0xbe4b9d4e, 0xbe67e6e4, 0xbec0b309,
    0x3fd8a63d, 0x40931b3c, 0x4019c532, 0xc00398cc,
    0xbf6a72d9, 0x3fc12f38, 0x406517b9, 0x3ea5c92a,
    0xbd5a257f, 0x403b121c, 0x3f598732, 0xc064a9a8,
    0xbfbdf1e4, 0xc02c1b4d, 0xc00e7382, 0x3f00b0ee,
    0xbfbc97d4, 0x3dedde4d, 0x4032ca05, 0xbfbe9e57,
    0x404703ba, 0x3fbcf10f, 0xbf85fe9c, 0x3f794c4f,
    0x3f432546, 0xbeb4f8e5, 0xc0c7b17f, 0xbfa90804,
    0x3f4e313c, 0x4030b2f2, 0x403b83b1, 0xbd861013,
    0xbe9cb544, 0x409a30c4, 0xc032bdef, 0x3f5a75ba,
    0x40913ba0, 0x407b2497, 0xbf86db83, 0x40bc5a4a,
    0xbe7a637c, 0xbdfad393, 0x403ca7b1, 0x3fdf345a,
    0xbf1b0406, 0x3f160f05, 0x3f9d9ec5, 0x3eb47a6a,
    0x3fcaea58, 0x402bb57b, 0x408ef077, 0xbfefea60,
    0x406171e0, 0x3fba97e7, 0xbfe1519c, 0xbe3b2fdb,
    0xbf4c9769, 0x402afb58, 0xbf49cee0, 0x3eadee7e,
    0xc01df30c, 0xc0b7aef5, 0x3f30071a, 0x3d7c7e5b,
    0x3fc5be68, 0x402342cd, 0xbf847a84, 0xbda88450,
    0xbf8ba69f, 0x3fac3261, 0xc05508a3, 0xbfd760ac,
    0xbf44d98d, 0x3e98a354, 0x40577ce2, 0xc06ac12e,
    0x403feea3, 0x3eee15f1, 0x3f9f9042, 0xc087e5c0,
    0xbf06a447, 0x401f45bb, 0xbf811258, 0xc03afe37,
    0x3fedfaeb, 0xbf0e5bed, 0x40a1b8b8, 0xc0758b6f,
    0x3fca6c0c, 0x3ec6e4a1, 0xc0a3986d, 0xbeb074a9,
    0xbfe44e6d, 0x3edf6701, 0x3e85e223, 0xc0262eb8,
    0xc094ad23, 0xbfa5e9b3, 0xbfe359e8, 0x3f8d70ff,
    0xc05f53d8, 0x3f253d61, 0xbe60702c, 0x4066ef2c,
    0x3f9c9d5e, 0x3f1c0e6c, 0xbfb2766a, 0xbf78c375,
    0xc06b34cd, 0x3d61862f, 0xc03ca233, 0xbf68c729,
    0x408863af, 0x3fd406c8, 0xc02ef347, 0xbf4497de,
    0xc0338c07, 0x3f321713, 0x401cf9ec, 0x4046ba26,
    0xbfdac521, 0xbded2910, 0xbeb446d8, 0xbd705c0a,
    0xc04ed2d7, 0xbff142e1, 0xbf8bcb56, 0x406332c4,
    0xbf8bb2ff, 0x3f66ca85, 0x3f0b3500, 0xbfd95dc4,
    0xbe1a9994, 0xbe54f83b, 0xbf9cff31, 0x4012af69,
    0x402e1cc4, 0x3f14cb1d, 0xbfcc85c2, 0x3f96326e,
    0xbf82e727, 0xc030831a, 0x3ede21e2, 0xbfc8cd5c,
    0x3f27214e, 0xbfec0afe, 0x4081df18, 0xbff58e5d,
    0xbffdb48d, 0xbe738573, 0x3f56add7, 0xbeed3268,
    0x40036935, 0xbfcf93da, 0x3fc59f08, 0xbf5326cb,
    0xbf901662, 0x40875582, 0xbf3fc0c9, 0x4058f43d,
    0xbf7810d2, 0x3ed3623a, 0x3f47095c, 0x4025a858,
    0xc01945fb, 0xbe225bab, 0x40005a62, 0xc067f2b3,
    0x3fcc3112, 0xc0289523, 0x3e8b3c6d, 0xc008ac66,
    0x3eb0f23c, 0x4000ef84, 0x40524845, 0xbc4a74cc,
    0x40673c83, 0xbf56bf41, 0xbf20f95e, 0x4030df20,
    0x3f9f1334, 0xbf0be6da, 0x3e6e6e95, 0xbfcef60b,
    0x3dee444b, 0x3f4aa234, 0x3fdb28d1, 0x3f3196c9,
    0xc050bbce, 0x3f4bfc52, 0xbe9bb4ac, 0x3ef90d5b,
    0xbf5d5e12, 0x3eeb4957, 0xc04ede9b, 0xc00c63b3,
    0x3f7259b9, 0xbfc22e92, 0x3f5e2eac, 0xbeaf21bb,
    0x40565ff0, 0xbfacd7f4, 0x3e94a369, 0x3d83e146,
    0x3f9931ba, 0xc05098e7, 0x402a560f, 0xbf17da61,
    0xbf93a3d4, 0x3eccbd78, 0xbefc2b24, 0x4018e004,
    0xbec376e3, 0xbfd50db3, 0x40262e6d, 0xbfd96483,
    0xbf372d60, 0x401fb68c, 0xbf758902, 0x4015f8c9,
    0x3f57c7e0, 0xbf37245e, 0x400b11bd, 0xc03fd3ec,
    0x401a4b8c, 0x3f610863, 0xbf897db0, 0xbf16a1b2,
    0x3fd67447, 0xbe05738b, 0xc0305c0a, 0xc0153902,
    0xbf130787, 0x4086ae5b, 0x3fe4417f, 0xc0091b2c,
    0x3e48be9a, 0xbf3cae40, 0xbfd10138, 0xc00aba67,
    0xbf4a3cc8, 0x3ef382ac, 0xbf7ecf68, 0xbf15fbd0,
    0x40202a86, 0xbf838b46, 0xbef6bf67, 0x3fba2995,
    0x3f6e545c, 0xbf37968e, 0xbe988bb3, 0xc027555c,
    0xbf72d5c4, 0x3e325f3c, 0x3f47925c, 0x4065b234,
    0x40187221, 0xbfce0056, 0xbfd14828, 0xbf8d9420,
    0xbed8661c, 0x3fc62c35, 0xbf45a049, 0x403558df,
    0xc083070e, 0x3f51eb1a, 0x40716338, 0xbde6040d,
    0xbfade3bc, 0xbd81a1ea, 0xbf55d462, 0xbf180487,
    0xbdad62e4, 0xbf1be251, 0xc06419a0, 0xbea06d98,
    0x408c0f32, 0xbfc9e399, 0xc05da10a, 0x402be5b3,
    0x3f7a8c1b, 0xbefe3310, 0x3ed550df, 0xbf18be6b,
    0xbfbc3b8a, 0xbfb4436b, 0xc0afe86b, 0x3e8fc6a0,
    0x3f956dea, 0xbf092c80, 0xbfbe6a5f, 0xc0760db0,
    0x3ff3214a, 0x3ff7ffb3, 0xbfcb47d0, 0x3f53de26,
    0x3f05bac3, 0x3e5f416a, 0xbf06376b, 0xbf3471cd,
    0xbf578ebb, 0xc0149e2c, 0xbe928191, 0x3f3e7842,
    0xbefcd7c8, 0x3e3566d7, 0xc0327918, 0xc08aea35,
    0x3f674ce0, 0x3fa393fe, 0xbf7b4529, 0x3fcd778e,
    0x3df8e7ff, 0xc009f66f, 0xc00629f5, 0xc0969c4e,
    0xbee28d32, 0xc040c01f, 0x3fd86335, 0xc065774f,
    0xbfb684bd, 0x3ea3e39c, 0xbdfb890a, 0x405163a8,
    0x405b3f08, 0x3e74135f, 0x3f26c2b6, 0x3fdd8761,
    0xbf356765, 0x3ffcaa17, 0xbf9ee296, 0xbf90a96d,
    0xc0045e4a, 0x3f793220, 0xbfd831e2, 0x3e2fd597,
    0x3ee02f59, 0xbe9eb913, 0x400c8b2a, 0x3e9a84b8,
    0x3fe13f09, 0x3e0df8e8, 0x3ed726a6, 0xbe80704b,
    0x4093156f, 0x3f230e79, 0x40041298, 0x3e94307c,
    0x402a5df1, 0x3f9b1ce8, 0x406d4a7a, 0xbf1440b4,
    0x3e31b0d1, 0x3f10fae9, 0x4004ef79, 0xc05fed40,
    0xbec0ebaf, 0xc0244385, 0xc072dbc2, 0x3fb73e34,
    0x3d9ac551, 0xbf98c62c, 0xc03416e5, 0x3ed07fb9,
    0x3f34e7b8, 0x3efa26a3, 0x3fc830b8, 0x3fc28740,
    0x4088416c, 0x4098a743, 0x408ed0c7, 0x403f5c5c,
    0xbebe635d, 0xbffb7e28, 0x3f903a66, 0x3fd58026,
    0xbda8dcfc, 0x4068d17f, 0xc0186f4a, 0x4018d5e7,
    0xbfff72f5, 0xbf97ad23, 0x3e74338d, 0x3f04b918,
    0xc04ff3a6, 0x3f5b3361, 0x3fb54800, 0x4048bd2e,
    0xc0819014, 0xbf1cefec, 0xbf9cb3b7, 0x3f0a30ff,
    0xbf72c1ee, 0x40536cf3, 0xbf17488d, 0xbfa07ef7,
    0x3f7737be, 0xbf7e35e8, 0xbe90a35c, 0x4019f5ee,
    0xbfc52511, 0x400b6606, 0xc088b8aa, 0x3fb46fb4,
    0xbf921d7f, 0x401f4eaf, 0xc0653488, 0x3d0b41f5,
    0xc03a83e5, 0x3e543a6b, 0x4017bdc8, 0x3ffcd657,
    0xbfc60787, 0x40b64396, 0xbf1d6b65, 0x3f9ca546,
    0x4047f083, 0x3e13b414, 0x3f27096b, 0xc03a0c8a,
    0xbff9322d, 0xbfefa264, 0xbf2a9c64, 0xbf9cb2ad,
    0x3e6c073a, 0xc05a99f4, 0xc0d049b4, 0xbff7e07b,
    0xc00e9f4c, 0xbfd5caf6, 0x3fbe8dfa, 0x3facdaf8,
    0xc020be13, 0x3f68a67a, 0xbf867e1e, 0xc0852f7c,
    0xbfaa8504, 0xbfd9f2a0, 0xbf2c13b7, 0xc04d049b,
    0x3f590e67, 0x3f7dc631, 0x3fb8732e, 0xc077e956,
    0xc02699d3, 0x4056e7fa, 0x4091ebb1, 0xc08fcd93,
    0x3ea81585, 0x3f8702bd, 0x3fac1caf, 0x4035aa4f,
    0xc0080c3d, 0x3fd87d21, 0x401ee6ad, 0x4076a5c2,
    0x3e9753b0, 0xc01ba0b4, 0xc010f72e, 0xbea9a635,
    0x3f862372, 0x4021ef24, 0xbf9492b3, 0x40489e88,
    0x405cc42f, 0x3f51c115, 0xbd9971a6, 0xc002a045,
    0xbe08dd56, 0xc0332bcc, 0xc07f4d8c, 0xbf49a354,
    0xbe130e61, 0x3f04a820, 0xbeacb189, 0x3fa223b5,
    0x40757ec8, 0x3f92e8e7, 0x3fefc4d9, 0xc00ecfc7,
    0x4065a086, 0xbe5b5240, 0x3f1f5795, 0x3ea4b131,
    0xbf9a807a, 0x4024016d, 0xbfd2b697, 0xbfb9b3fa,
    0x406bf909, 0xbde4e93b, 0x3f7af107, 0x407029c7,
    0x3fb0e4e6, 0x3f3e8325, 0x3def231c, 0x3f12ebbd,
    0x40300783, 0xbf0cd0ff, 0xbfe9688c, 0xc0432842,
    0x403a8ecb, 0x3fad17a8, 0x4033879f, 0x3fc99f4b,
    0xbd8a1e21, 0x4088c044, 0x3ecc4c0e, 0x3c381623,
    0x3ee5cf41, 0xbedf1d9d, 0xbfd433aa, 0x402f03e9,
    0xc05ee317, 0x3fef0228, 0xc0291eba, 0xc088419f,
    0x400ea556, 0x408b4ee6, 0xc0298ff2, 0xbfb51c4d,
    0xc045467b, 0xc01a417b, 0xbf1ba50c, 0xc0368aac,
    0x4063621b, 0xc01c3ea5, 0xc018462c, 0xc0ab1801,
    0x3f308143, 0x3f9a5c4d, 0xbf32c93c, 0xc05496df,
    0xbf3234f7, 0xbf453a5e, 0xbe094d13, 0x3ec46835,
    0xbd805886, 0xbf8c2a7c, 0xbecf61bf, 0xc021f9fa,
    0x3f41a1c0, 0x3ebbe56f, 0x3f899ccb, 0xbea45b7e,
    0x4098a231, 0xc0227b9f, 0xc07d4788, 0xc0639a88,
    0xc057e04c, 0x408bcc4b, 0xbf2f09bd, 0x402bccb3,
    0xc0a535d3, 0x3fa27b5b, 0x3f616cc1, 0x404248f2,
    0xbee2feaa, 0x40171584, 0xc0112cd6, 0x400525fd,
    0xbf88f41f, 0xbfba2dfb, 0x4060ea91, 0x3fbeeadd,
    0x401b12a5, 0x404c62ea, 0xbfd3157d, 0x3ebcc3c6,
    0x3fca9943, 0x3ffc0032, 0x3f1daef3, 0xc00f002b,
    0x40390e29, 0xbe4393ea, 0xbf5d0ce2, 0x3ebe5ddf,
    0x40080bc8, 0x3ddde608, 0x3fdb559c, 0x3f8c9182,
    0x3fec0c57, 0x3f915530, 0xbf81830a, 0xc00566b5,
    0x3f62c373, 0xc02288b2, 0x3f1dba3c, 0xc00f1540,
    0xc0b3b3c1, 0x3faa4a37, 0xbef3dc03, 0x3f495948,
    0xbf1f8011, 0x3fb4265e, 0x403dec1a, 0xbffcb7b7,
    0xbfe76530, 0x4021a42d, 0xc09fa0dd, 0x3f0525c1,
    0x3fcdba5f, 0x40b6df62, 0xc02c0dc8, 0xc06c4139,
    0xbfb0e0cc, 0xbf9c97d6, 0x40064e27, 0x3fd9fa6a,
    0xc03cc50d, 0x3d27f33e, 0xc03c4b6b, 0x400da120,
    0x4041cd2e, 0xbf7feb66, 0x3ffc9d02, 0x3ec604f2,
    0xbe01e941, 0xbf2a3708, 0x3ff4e6b3, 0x3fc5c1b3,
    0x3fc919c6, 0x3fe28a57, 0xbfc7e894, 0x3fe05041,
    0xbdc1fae3, 0x3ecd57f3, 0xbf8e7422, 0x4024b7b3,
    0xbe43966e, 0xbf82b701, 0xc02b7f8d, 0xbf907e81,
    0x40039a80, 0x3fc655a7, 0xbf740a6d, 0xbd9af381,
    0x3eeabf9c, 0xc03efd25, 0x403282e9, 0xbfff084f,
    0xc0247613, 0x40015ae9, 0xbf5f42f8, 0x3ff72294,
    0x3e254667, 0x3f36027b, 0x3eb3803d, 0xc0e06d3a,
    0xbc49a1ba, 0x40296e34, 0x3f39baf5, 0xbf9736d8,
    0x3e694cd2, 0xc02da1df, 0x3f763a2f, 0x3fa6eec6,
    0xbf46b9cd, 0xbec3726b, 0x3f91ed12, 0x3fbd3377,
    0xc0759e61, 0x3d8a1714, 0xbf9183c7, 0x3d8e0747,
    0xc09199e8, 0x3fdfa76c, 0x404d92e4, 0xbf913950,
    0x3ffdc25d, 0x3fbd55e3, 0xc08cb691, 0x3f5d10f8,
    0x3f8b0c15, 0x3f1d58d7, 0xbf76a306, 0x4006b2f8,
    0x3fe45933, 0x3f686a0c, 0xc053d9c5, 0x40635306,
    0xc06cfd14, 0x4056b840, 0x3e080eec, 0x40063c70,
    0x40156f17, 0x408726d1, 0x3f87c4d2, 0xc019e7e7,
    0x3f976435, 0x3f95a3ba, 0xbea2fbf0, 0xbf39bb98,
    0x3f4b7703, 0x4072f3a2, 0xbe4fadb0, 0x3f6d2a0b,
    0x3cda7ede, 0xbf360f71, 0x4082b027, 0x4046a989,
    0x3f2cfead, 0xc035091c, 0xbfe426c8, 0xbe9dc0e4,
    0xbd6825d8, 0xc008c61a, 0x40374d55, 0x4003824e,
    0x40f04821, 0x3fa303f6, 0xc08aa950, 0xbd37afc8,
    0x3feedfa4, 0x4046170d, 0xbf58b50d, 0x3e1d8ad5,
    0x40131b97, 0x4014a611, 0x40330fef, 0x3e278a28,
    0xc0849812, 0xc080e4cb, 0xc08c3078, 0x3fd8a87a,
    0x406862ce, 0x3e9c0180, 0x3fc1b2e2, 0xbf9859eb,
    0x4002b371, 0xc0055352, 0x40154331, 0xbe8001f3,
    0x4062c771, 0xbfdaab74, 0x3f6f0460, 0xbfc080fa,
    0x3fea33d0, 0x3f7b5b99, 0x40685c1b, 0xbf88e29c,
    0x409fd96e, 0xbfe6df0f, 0x40375c6d, 0x3e9d27a0,
    0xc05ff90a, 0x3f4f1f41, 0x3f737f36, 0xbdf83340,
    0xc04943c3, 0xbd079312, 0xbe698fd2, 0xbfb42d3b,
    0x3f3584d8, 0xbe29b09e, 0x405aadf3, 0x3fbf325e,
    0x3fabbbe9, 0xbe0ebcf9, 0x3f9939cb, 0x3f9a460a,
    0xbfec695b, 0xc033ef87, 0x3fdcf3ea, 0x4011bea6,
    0xc0108c0c, 0x400c14ae, 0xc0089b1d, 0xbe867f62,
    0xc04718bd, 0x3f34c667, 0x3ef2f601, 0x3ef11d35,
    0x3f23d5a7, 0x402977e1, 0xbf8670cc, 0xbddf37bd,
    0xc073315a, 0xbf8f2cb4, 0xc032deac, 0xbfca6f24,
    0x406acd6a, 0xbf2c1493, 0x400a93ec, 0xc0216a9d,
    0x3f0a06a5, 0x3fd0b0a9, 0xbf13f7b2, 0xc005bcb2,
    0x40530a11, 0x4016e7aa, 0xbd96dca1, 0xbfc9b864,
    0x3f827a85, 0x3fb52564, 0xbf1d42de, 0x3d115d17,
    0x3f8a803e, 0xbef8494f, 0xc00f654a, 0x3fa777ed,
    0xc0033101, 0xbff064da, 0x4020cb37, 0x3e77cdbf,
    0x3e0905e4, 0xc0b1d267, 0xbe83e243, 0x40b81ec2,
    0x4009593f, 0x3f0caf8b, 0x3fcabe49, 0x40587668,
    0x404cb42f, 0x3f8288d8, 0x3ddd1b9e, 0xbe0b0b3d,
    0x3e9a8274, 0x3d2bed2d, 0xbe5edc8b, 0x405bb737,
    0x4008e9a0, 0x4035b946, 0x3feb205e, 0x3f00d110,
    0xbe98e18d, 0x3f8f82e3, 0xbf82dbdd, 0xc034fdf5,
    0x3d82eb64, 0x400a3860, 0x3fcd01a9, 0x3f966e05,
    0xbe2dcc7a, 0xbf5f4092, 0xbf7e3b3f, 0x40333b02,
    0xc0888458, 0x3ff0b154, 0xbfddb5cf, 0xbfda0b0e,
    0xc0331996, 0xbfc66792, 0xbf80ba61, 0xc06822af,
    0xbecd4104, 0xbfa9b6ba, 0xc01e3664, 0xc03453a2,
    0x3fe8642b, 0xbf048a66, 0xbfc0c1c0, 0xc0107951,
    0xc0714b50, 0x3d90a7c9, 0x401a4896, 0x3d1da05e,
    0x4021bbfe, 0xbf7fdc8b, 0x3f0b2f65, 0xbf2a8d11,
    0xbfb29dc0, 0xc032e267, 0x4016c883, 0xbe366955,
    0xbe3ca506, 0xc05a1a7e, 0x3f4ef23d, 0x3d6aec86,
    0x3fa6c212, 0xbfea3ebb, 0x40811174, 0xc05bda33,
    0x3ff27a97, 0xc0062951, 0xc04c59c9, 0xbfb60adc,
    0xbf791da4, 0xbf962f00, 0x40467d2d, 0xc0109225,
    0x401d07dc, 0xbfa9c0e9, 0xc02e6c53, 0x3f07d6e9,
    0xbeb3b26a, 0x3f517dfe, 0xbff74173, 0x40983689,
    0xbed84983, 0xbf70491b, 0x40ad161a, 0x3f3bd919,
    0x402e8866, 0x408e104f, 0x40219574, 0xc07929f1,
    0xc00a14de, 0xbd232bb7, 0xc0543119, 0xc0851e73,
    0xbfab7051, 0x409fb867, 0x409d582a, 0x3fb086d0,
    0xc0608ebc, 0x3f247a27, 0xc0900175, 0xc006b660,
    0xc05b6c19, 0xbf28558e, 0x3fa5d66e, 0xbf809d61,
    0x3ebca4d5, 0x407585b2, 0xbf2084af, 0x3ee2e45f,
    0x3e595593, 0xbfd4fab7, 0x406f81f9, 0x3fc3624c,
    0x3ea935d4, 0xc0033a46, 0xbdf3d7f3, 0xbf93d1aa,
    0xc04b5d6d, 0x3f993a7f, 0x3cbca922, 0xbe8878b4,
    0xc007ebe1, 0xc043a73e, 0x40527c45, 0xbfd610c9,
    0x3fc88c7b, 0x406452b8, 0xbf669f6f, 0xbfe383e4,
    0x3fced90e, 0x3e8b0e8a, 0xbfb884d9, 0x40865661,
    0xc03e1993, 0x3d854f7e, 0xbf6a4ce9, 0xbeaad797,
    0x3f8b64b7, 0x3d5ccc2d, 0x3e0eaf34, 0x3fac4725,
    0x3f8d751a, 0xbf75c4ae, 0x3f14022c, 0xc01cf110,
    0x3fa33181, 0xbf8cd489, 0xbfa6451a, 0xbf2d9e93,
    0xc014ed81, 0x3eb26e5f, 0x40596858, 0xbf4e4194,
    0xbfdb0cba, 0xc0407541, 0xc02197b9, 0xbf026368,
    0xbf1661a9, 0x40909e52, 0xc0211ce7, 0xc068723a,
    0xbe96959b, 0x405aaf4e, 0x404fa7a7, 0xc06773cd,
    0xc013b9bf, 0xbf9b143f, 0x3ffef594, 0x3fdfe9c8,
    0xbf55380a, 0xc006b02d, 0x3ffc0a8b, 0x3fee641f,
    0x3fbed0b3, 0x4026b6a3, 0xc0224400, 0x3fc27464,
    0xc01ed62f, 0xbec25c5a, 0xc0533fc3, 0x40916ce9,
    0xbfd3f1c7, 0xbeb2714a, 0x3fa86a82, 0x3e5424a8,
    0x3ef7ddcf, 0xbfb71a5e, 0x40215cfd, 0x3f3c0ca7,
    0x3fa9b4db, 0x407ceccc, 0xc0213d45, 0xbebec76e,
    0x40240336, 0xc00bc10e, 0x408c5404, 0x3feb6b98,
    0xbf973d77, 0xc0226b23, 0x3fdb64c2, 0xbd76f5da,
    0xbff9eca4, 0x400ab9a5, 0xbfd876d4, 0x3f51330c,
    0x4081c60f, 0xbe473a65, 0x3e7616bc, 0x407ead69,
    0x4016bfdb, 0x40021064, 0xbf71c017, 0xbedb9826,
    0x40586f23, 0x3ecc3e7f, 0x3dc936e2, 0xc087e398,
    0x3feeb53c, 0xbfc7ad8c, 0x3f4d9299, 0x400a4722,
    0x3fd0d9f3, 0x3fac14c2, 0x3fadee57, 0x4085a216,
    0x3f0f57b9, 0xbfab4a66, 0x400853c6, 0x402251d6,
    0xbe9bf45f, 0x404304b1, 0x40b59b7d, 0x3f52aa9e,
    0xc0556734, 0xc05ab774, 0xbea44df1, 0xc0496279,
    0x3f17b2ad, 0x40130957, 0x4023ed3a, 0xbf55d9c4,
    0x3c25fcf8, 0xc049c1ac, 0xbfd7f558, 0xbf518e68,
    0xc0ea474d, 0xbfaa321f, 0x40425bf1, 0xc024d39a,
    0x407c848c, 0xbf41a8c9, 0x3eaf82ee, 0x3ef63b98,
    0xbff07197, 0x3f9b490a, 0xbec47454, 0xc09529c6,
    0x40381c34, 0xbfc6ee36, 0xbf9c7bf7, 0x3f547be1,
    0x40074900, 0x3ed86876, 0xbf9ad6c7, 0xbe936cce,
    0x3f8af2c4, 0x40117d4c, 0x40865d39, 0x40085696,
    0xc00c52fb, 0x3ff8434d, 0x4020cdba, 0xc05011e5,
    0x3f9a14c7, 0xc017ba60, 0x3f835482, 0xbf6c64a1,
    0x404bbca9, 0x409ec6be, 0x3f23b9e0, 0xbdbd69a3,
    0x3f8f01c0, 0x3fd7a58b, 0xbf8fe972, 0x3f9ff0cc,
    0xc0572d26, 0x3f533f65, 0xbfd76d91, 0x3e84632c,
    0xbf3bb895, 0x40285af6, 0x3fbd7c91, 0xbf8dd93d,
    0x3f08bee5, 0xbfe6f6f8, 0x3fabe8c4, 0xc063ab0f,
    0xbf8cee02, 0xbf2244c3, 0x3ecb7369, 0xbf883c05,
    0xc0558db9, 0xc04cd646, 0x3fc74dfb, 0xc01833c1,
    0x3fa5c092, 0xc05719b0, 0x3fd8887a, 0xbe5b2a0e,
    0xbefcf638, 0x3eb1a0d2, 0x408e4e65, 0x40189da3,
    0xc055692e, 0xc03fe7f8, 0x4001a8d0, 0xbf61ec0c,
    0xbe592a78, 0x407f8d9b, 0xbfb2d7d5, 0xbf0587cf,
    0x405b3d6a, 0x3fa456f9, 0x3f03400b, 0xbf23c2cf,
    0x404e1830, 0xbfb7975e, 0x4057825e, 0xc005a19d,
    0xc07b78ff, 0x3fc30deb, 0xbfa9ad79, 0xc09c0f0a,
    0xbfa89759, 0x4024bc71, 0xbe19ca19, 0x4019a9fc,
    0x3eb89160, 0x3ec7db8d, 0x40050c5b, 0xc02a6cb9,
    0x400c3e72, 0x3fe751a9, 0x409f23a3, 0xbfc615ac,
    0xbec81cee, 0xc08898d6, 0x3f3e50d5, 0xbf94fb2e,
    0x3db18d61, 0xbf95649a, 0xbff60106, 0xbe21c4ce,
    0x401cc6d3, 0xbff21bae, 0x3fe7c161, 0x3f7e51db,
    0x3efbcaa6, 0x4052df85, 0xbf1e507b, 0x3f66ed4c,
    0x400774b4, 0xbf5c0c5f, 0x40671649, 0xbd900b65,
    0x3f07f158, 0xbe1d3209, 0x3e15e7f7, 0x407c0456,
    0x3ccfe9fd, 0xbfe16fce, 0xbe9b2648, 0x3f72fc9c,
    0xc097dd90, 0x402f743e, 0x3fa6d634, 0xc0349598,
    0x402d4524, 0xbe390c25, 0x4012487e, 0x3ea0b4af,
    0x4008f8c7, 0x3d258d0e, 0x3fbab730, 0xbf0e616e,
    0x402a1c9d, 0xc012cbfd, 0x3d14b934, 0xbf8066b9,
    0x404dbf64, 0x40a16876, 0xbe69d645, 0x405a93dd,
    0x3fa6b188, 0x3d56a999, 0xc07eeea1, 0x401c2897,
    0x403ff664, 0x3d24a662, 0xbec5493d, 0xbf16c6ef,
    0x4008fba0, 0xbff7df37, 0x3bfaebd0, 0xc036e87b,
    0xc01b5a0b, 0xc02f5f0e, 0xbfb08aad, 0xbf799b3c,
    0x3e7871f6, 0xc0490995, 0x3f9ab3c8, 0xc01027e9,
    0xbf90f2d5, 0xbfa193fa, 0xbfb88ae1, 0xc08ac1f8,
    0x408c7611, 0xbf308ff2, 0x4080cbe1, 0x40803f53,
    0xc01ef997, 0xbff8bfca, 0xbf21536e, 0xbee965d7,
    0x3fc96d6d, 0x3fd5b238, 0x40130973, 0xbfc7fb7c,
    0xbfd1c16b, 0x3faca104, 0xbeac6b07, 0x4086375c,
    0x3ff0d8d5, 0x3f991b07, 0xc046a073, 0xbfb93fba,
    0x3fdb7b4a, 0xbfff921c, 0x403f4c73, 0x408ca508,
    0xc0098472, 0xc00df9a7, 0xbfa3121b, 0xbeb230fa,
    0xc0091e0a, 0x4023d7e5, 0x409728a2, 0xbf2e5ed3,
    0x3f9b78a0, 0x3f0325ee, 0xbf035cbc, 0x400efef9,
    0x3f7d8486, 0x40fcc041, 0xbf987756, 0x3fc2ae42,
    0x3f7d16dc, 0xbfb95c31, 0xc0057837, 0xbf10911f,
    0xbfe403e5, 0xbf4739bd, 0x405748b1, 0x3d8d3373,
    0xbf9e8ab5, 0x40357656, 0x3ed7e15d, 0x408fd53e,
    0xc047bdfe, 0x4058e2a6, 0xc004608c, 0x3f6eb8f5,
    0x405f7c51, 0xbf5edfee, 0xbef163ee, 0xc0bb4c56,
    0xc02440b5, 0xbef3d032, 0xc07005b3, 0x400445a9,
    0xc02880e0, 0x3ebdc232, 0xc0737671, 0xbe96ad2a,
    0xbf6f90ed, 0xc0411951, 0xbf3421c0, 0x404531a7,
    0x3fdb8407, 0xbf355ab5, 0xbfbc26dd, 0x3fdeb6ab,
    0xbff47d06, 0xbe022239, 0x3e94aa51, 0xc054a6c4,
    0x3f299449, 0x3fe9080c, 0xc0031fba, 0xbed28af5,
    0x3fc55aae, 0xbfaaed55, 0xc008ae7b, 0x3e94063e,
    0xbfd8de95, 0xbf85e3c3, 0x3dda950b, 0x40998bdb,
    0xc02f788c, 0xbf96a85b, 0xc00feb10, 0xbdc15445,
    0x4059ba20, 0x3efbf93a, 0xc07dcd48, 0xbd557d87,
    0xbfea8409, 0x3f39f87d, 0xc01ec26f, 0xbf9e7fd8,
    0x404a6f80, 0xbef1ca31, 0x3f79db09, 0xbfdd50d9,
    0x409482f5, 0xbffacac9, 0x3fb50851, 0x4041e46a,
    0x4093003d, 0xbfe4b71f, 0xc06430fc, 0x40482230,
    0x3fe0fca4, 0xbf5d1325, 0x3f9d81dd, 0x3feb9c96,
    0x3f3f1452, 0x404eb3ab, 0x3ff96aa1, 0xbfd7d60c,
    0xc00fda57, 0x40295e6b, 0x3f94ba57, 0xbfaabc94,
    0x3f873ab9, 0x3dd6069b, 0xbe2f9eec, 0xbf016ed8,
    0xbe577a03, 0x3f9fe53f, 0x4061c906, 0xbf909daa,
    0xc004670d, 0x40145c75, 0xc091867e, 0xbf91ed98,
    0x40c062c4, 0xbe772bc0, 0xc05d376b, 0x40b4df69,
    0xc09756d7, 0xbf4e4780, 0xc08154ba, 0xbee0bf2e,
    0xc00961c3, 0xbf058ba6, 0x3fe35746, 0x3e7806d0,
    0xbf9b452f, 0xc047a854, 0x3fba662c, 0x4056c649,
    0xc001c4bb, 0x3e5b9fa7, 0x3f68e7eb, 0xbfbf37f9,
    0x3f2139e2, 0xc08976b3, 0x403e7b34, 0xbf8e50f9,
    0xc0130022, 0xbf6d1197, 0xc03bf6ae, 0xbff734a2,
    0xc042dce4, 0x3e53da3d, 0x4007e231, 0xbf80d42d,
    0x3fa88370, 0x3fd0e84c, 0xc01dc8b9, 0xbf53ec11,
    0xbfcf73bf, 0xbec6cdc1, 0x401de7e2, 0x4027c145,
    0x3e1876a3, 0xc0d95d58, 0xbebc5695, 0x4030c300,
    0x3f9e1a26, 0x404189c5, 0x40428893, 0xc03c6c80,
    0xc0567fff, 0x3f88559b, 0x3ff96e81, 0x4073ba70,
    0x3fb69fbe, 0x40b41324, 0x3c555db2, 0x40a5ceeb,
    0xc009ecb0, 0x3f50ed00, 0x4090006e, 0xbfb3011f,
    0x3fecfa75, 0x3eec6225, 0xbcc506d4, 0x3dbd79aa,
    0x3fbca95a, 0x40832b8b, 0xbfdfcb94, 0xc054fd05,
    0xbf971c1d, 0x40019ac7, 0x3e087175, 0x3f62803a,
    0x406b509b, 0x3fa04f0d, 0xbda5758d, 0xc04ae7bf,
    0x3f843ee6, 0xbf8062a2, 0x402d2958, 0xbfa80589,
    0x3e3dc193, 0x4056b0d1, 0x3d2bbaf0, 0x3fedb003,
    0x3f23e4c4, 0xbf63a1e9, 0xbf33968d, 0xc0091644,
    0xbf95aff3, 0x402312d2, 0xbf70e70e, 0xc0d7055e,
    0x3f94ba3f, 0x4034801d, 0xbfcf1f21, 0x3ec41b58,
    0xbfb60970, 0x3e4cdd84, 0x3fe35ce9, 0xbfd8cfcb,
    0x3ff90046, 0x3fc41248, 0x3f64e3b5, 0x3e6e25eb,
    0xbfdf7ba3, 0x3ed1ea35, 0xc003edc9, 0xbfac2e7d,
    0xbda1acea, 0xbf783557, 0xbfc8568e, 0xbede4117,
    0x3f4b6a8f, 0x3ffd6801, 0xbfe9061d, 0x3fc272bf,
    0x405e09bf, 0xc00ad938, 0xbfc3e690, 0xc00581e4,
    0x3f885a49, 0x3f859d50, 0x3fc5fcbd, 0xbe1d50b4,
    0x3f1336a7, 0xbf8e9ca0, 0x406b208d, 0xc001622f,
    0xbff9ff84, 0x401d2e50, 0x4089dbde, 0x4093ca1f,
    0xbffda12f, 0xbfe660d0, 0xc015a794, 0xbe813195,
    0xbedfdd98, 0xbcd448ce, 0x3da64d6e, 0xbf881042,
    0xc021336c, 0x3f175349, 0x3f969695, 0xbfcc3a40,
    0x3e38a2d9, 0xbf53d8c8, 0xbfa0ffd2, 0xc0872194,
    0x3f1ada1e, 0x3fb89917, 0x3db86a33, 0x403e3c38,
    0xc006028e, 0x40391950, 0xbe977784, 0x3edc1694,
    0xbf0e863d, 0xbfa2f0c7, 0xbe080256, 0x3fd70f12,
    0x40ba6fd7, 0xbf362eee, 0x409bfcc2, 0x40746228,
    0x3f6cb968, 0xbfc5f8ac, 0x40095060, 0xbf8908b7,
    0xc005471f, 0x4030fce8, 0x3eab745d, 0xbf8ede46,
    0x400b5fbd, 0x40098f4f, 0x3f5e927a, 0xc0e62bd0,
    0x407116df, 0xbf7527db, 0xbf111f71, 0x3f69290e,
    0xbfdd8c17, 0x3ff3b3ed, 0x3f5b06b8, 0xbf1b794d,
    0x4025008b, 0xbf98589c, 0xbf5ff0ee, 0xc03888c2,
    0xc001336b, 0x40033712, 0xbfd6267f, 0xbf1df4e2,
    0x4026158c, 0xc04f7450, 0xbf01e34d, 0xbfd50c56,
    0x3f8c2016, 0xc03d1dd4, 0x3f8d3a2c, 0xc0a40c2b,
    0x3ee123da, 0xc0ae73a9, 0xbecff739, 0xbeaef0b5,
    0x3f8f3724, 0x3ee8ef3e, 0x3f12dd24, 0xc012f4d0,
    0x3fafbc7f, 0x4002a56c, 0x4097a275, 0xbff4b0b3,
    0xc08eb718, 0xbdd67d16, 0x3f43397f, 0xc016b933,
    0x3fead629, 0xbf1750aa, 0xbfa0f7b9, 0x3fd5dcde,
    0xbf0bed2d, 0xbe645ae5, 0x3fc27ef9, 0x3fa2997d,
    0x3f9f9f9b, 0x40ace26e, 0x3e4daa71, 0xc02e3297,
    0x3f315f8c, 0xbef5ee01, 0x3e855466, 0x3f1dced3,
    0x3ed023a5, 0x3e3c77d0, 0xbe31034b, 0xbdbe090d,
    0x3ee33036, 0xbfdcf719, 0x3f82e407, 0x40ad255c,
    0xc09ea882, 0xbfaccf7c, 0xbfd342ed, 0xbfcdff7e,
    0x3f67a276, 0x407f4db5, 0x4023a1de, 0xc00ab921,
    0xbfddb070, 0xbeea9113, 0x40b17009, 0xbf16a027,
    0xc09ae618, 0xbf9a7a57, 0x3fb871b2, 0xc03b273d,
    0x408d77c8, 0xbfc785d4, 0xbe938aa4, 0xbf3971c6,
    0xc075f39c, 0x401df0ff, 0xbfbf2ce2, 0x40a6c673,
    0x4011c923, 0x3f681f3d, 0xbfdc517e, 0x3ef2ee04,
    0xbcd70ed4, 0xc05a4f6e, 0x40b0ebe6, 0xbfaad2fb,
    0x4040b8b3, 0x40454815, 0xc05667ed, 0x402a24f4,
    0xc0083585, 0x3fae6310, 0x400d1cfb, 0x401e0da2,
    0xc005d442, 0x40649de6, 0xbe074231, 0xbf987410,
    0xbe8e4e21, 0xbfd2e8d2, 0xbed2c5f9, 0xc00a79ee,
    0xbe30140c, 0xbeeebeec, 0x3ee3acd7, 0xc04e016a,
    0x3fe6167f, 0xbf5c7c7a, 0x3b2616f0, 0xbef5624c,
    0x3fe86864, 0xc08c9175, 0x3ffa7d22, 0x401cdb58,
    0x402514ec, 0xc01ec314, 0xbf87e34c, 0x3f53983c,
    0xbf9916bf, 0xbfed9939, 0xbfadee4a, 0xc04f00fe,
    0xc0894401, 0xc081fd26, 0xc030a022, 0xbee4fcc3,
    0x3ee51476, 0xbcb27587, 0xc045dabc, 0xc06dbf17,
    0x40084e6a, 0xc026b6d0, 0xc0526eff, 0x409c0b20,
    0x409f3c9c, 0x3ec8f40d, 0xbfa61697, 0x3f68c68c,
    0x402cec86, 0xbfa2a040, 0x3f44f358, 0x3fb9786d,
    0xbfc0700a, 0x4066e98e, 0x3f19cbbe, 0xc089c2b5,
    0xc04165f1, 0x409143c8, 0xbf3d3b17, 0xbf652855,
    0xbf1b0fae, 0xbfc8c2b5, 0xc02f6ad2, 0xbf5cb87e,
    0x4057497e, 0xc0728220, 0xc0711ed9, 0x3f0aeddf,
    0x40199549, 0x4038b950, 0xc00b4565, 0x40036a3b,
    0xbf10d0dd, 0x3ff11626, 0xc08ac8a3, 0xbf132276,
    0x3d2a3f42, 0xbfdb2f8b, 0x4054933f, 0xbf252f05,
    0x403112e7, 0x401034f4, 0x40033506, 0x402aca3f,
    0x400e60de, 0xbbb2d421, 0x40785061, 0xbf8f8a1e,
    0xbc1f88d9, 0x4006a36d, 0xbfe036f0, 0xc0248ffe,
    0xbfa191f1, 0xbf9c2de0, 0xbf1c327b, 0xbee927f8,
    0xc085fb19, 0x3f9f52d5, 0x3ebc028a, 0x4043e056,
    0xc039c79b, 0x3fba0b09, 0x3f9ffac1, 0xc04948d0,
    0xbf967fbc, 0xbfc2f95d, 0x3fba455c, 0x3f6b7150,
    0xc0086475, 0x4025c20b, 0x400f479a, 0x3fe33456,
    0xbf539285, 0xc0046dc3, 0xbfcb1e5f, 0x401ffdb6,
    0xbf61a349, 0xbf9be48c, 0xc0160e84, 0x3f34db5e,
    0xc00f7afc, 0xbf6c05b4, 0xbe017fb9, 0x3ec440db,
    0xbf8b55e4, 0xbfc05958, 0xc053ae0f, 0x3f5efd15,
    0x3f4e82f3, 0xbfb84f20, 0x3f17f1b5, 0x401e46b2,
    0xc01510ff, 0xbf82dff4, 0xc04ecd78, 0xbfb04c78,
    0x3fa2a9a8, 0xbfeb4d15, 0xc01cbea8, 0x3ddec74b,
    0xbf41a69b, 0x3f1e8801, 0xbf9de903, 0xbfd62906,
    0x3ffad4e7, 0xbff740dc, 0x3e6cb6b1, 0xbfa916a4,
    0xbfcddbf5, 0x3feda832, 0xc016dbb4, 0x3f8b7bb1,
    0xc03edabc, 0xbecf6f22, 0xc03512ac, 0x3ebfb936,
    0xbfc5b927, 0xc07bbeb2, 0xc0867579, 0x400ab568,
    0xc023b8d5, 0x3eb6bd04, 0x40214580, 0x4020ee56,
    0x3eb7b63a, 0x402a178d, 0xbed595b1, 0xbe85801d,
    0xc085afee, 0xc08d7569, 0x40078165, 0x3ff7c529,
    0x3f521969, 0x401210f8, 0xc03f7622, 0x3f44df71,
    0xbfb3335b, 0xbf10d47b, 0xbd0f7fc5, 0xc01fc234,
    0xbfae4c5d, 0xc05464e1, 0xbe1c697f, 0x3f2e8044,
    0x3ef48414, 0x4074f9cf, 0x400b1e69, 0x408849f2,
    0x40001abb, 0x3de0f5e3, 0xbef61ec3, 0xbe9f9325,
    0xc0332c44, 0x3fa3225d, 0xc04e09c2, 0x4007541c,
    0xbfde22ce, 0xc00d8f4b, 0xbd051039, 0xc022b795,
    0x3f309195, 0x40b341f6, 0xbfb98c57, 0xc0019d39,
    0xbec05896, 0xc0795665, 0x3ebc72e3, 0xbeb74156,
    0x3fd31f67, 0xbfb42e53, 0xc031835a, 0x3f312621,
    0xbb898579, 0x40a4b4c2, 0x3c154986, 0x3f705a3d,
    0xbfc4e935, 0xbfd98422, 0xbe74f759, 0x3fe570af,
    0xc0170d00, 0xc03bb273, 0xbfccb124, 0xbff7cb0e,
    0x3f38048a, 0xc038de03, 0x3dbd2482, 0xbdb54069,
    0x3ef64223, 0x3f9376a4, 0xbdaa3198, 0x3f89662e,
    0x3f8ec668, 0x40933a4a, 0xbf6a366d, 0xbfd1a329,
    0x3f9a2bf4, 0xbfebb823, 0x3fd451ea, 0x401fce17,
    0x403885bd, 0xbe4820a2, 0x3f70b5b9, 0x3fd3e08f,
    0x407599cf, 0xbfae2a57, 0x3f239f77, 0x3faf03fc,
    0x3e160d65, 0x3eb5e094, 0xbf00dd66, 0x3f895379,
    0x3ecc369b, 0xc06283c4, 0xc0278fa9, 0x3fb8dd21,
    0x40913c37, 0x3e8762a3, 0x3f11ba76, 0x3fc9f4c4,
    0x4048f19c, 0x4011c4ad, 0x4042622e, 0xc06d0cd7,
    0x4042be32, 0x406bec73, 0xbf523d39, 0xbead9855,
    0x3f88d690, 0x400fa9b9, 0xc05c9d5b, 0xbee7a719,
    0xbe7dfa1c, 0xbf89dc0d, 0xc027f81b, 0xbf33d9e2,
    0xbf31d1a1, 0xc019a207, 0x3d510e6b, 0xbfc18c57,
    0xbe4954b0, 0x0, 0x3d510e6b, 0x3fc18c57,
    0xbf31d1a1, 0x4019a207, 0xc027f81b, 0x3f33d9e2,
    0xbe7dfa1c, 0x3f89dc0d, 0xc05c9d5b, 0x3ee7a719,
    0x3f88d690, 0xc00fa9b9, 0xbf523d39, 0x3ead9855,
    0x4042be32, 0xc06bec73, 0x4042622e, 0x406d0cd7,
    0x4048f19c, 0xc011c4ad, 0x3f11ba76, 0xbfc9f4c4,
    0x40913c37, 0xbe8762a3, 0xc0278fa9, 0xbfb8dd21,
    0x3ecc369b, 0x406283c4, 0xbf00dd66, 0xbf895379,
    0x3e160d65, 0xbeb5e094, 0x3f239f77, 0xbfaf03fc,
    0x407599cf, 0x3fae2a57, 0x3f70b5b9, 0xbfd3e08f,
    0x403885bd, 0x3e4820a2, 0x3fd451ea, 0xc01fce17,
    0x3f9a2bf4, 0x3febb823, 0xbf6a366d, 0x3fd1a329,
    0x3f8ec668, 0xc0933a4a, 0xbdaa3198, 0xbf89662e,
    0x3ef64223, 0xbf9376a4, 0x3dbd2482, 0x3db54069,
    0x3f38048a, 0x4038de03, 0xbfccb124, 0x3ff7cb0e,
    0xc0170d00, 0x403bb273, 0xbe74f759, 0xbfe570af,
    0xbfc4e935, 0x3fd98422, 0x3c154986, 0xbf705a3d,
    0xbb898579, 0xc0a4b4c2, 0xc031835a, 0xbf312621,
    0x3fd31f67, 0x3fb42e53, 0x3ebc72e3, 0x3eb74156,
    0xbec05896, 0x40795665, 0xbfb98c57, 0x40019d39,
    0x3f309195, 0xc0b341f6, 0xbd051039, 0x4022b795,
    0xbfde22ce, 0x400d8f4b, 0xc04e09c2, 0xc007541c,
    0xc0332c44, 0xbfa3225d, 0xbef61ec3, 0x3e9f9325,
    0x40001abb, 0xbde0f5e3, 0x400b1e69, 0xc08849f2,
    0x3ef48414, 0xc074f9cf, 0xbe1c697f, 0xbf2e8044,
    0xbfae4c5d, 0x405464e1, 0xbd0f7fc5, 0x401fc234,
    0xbfb3335b, 0x3f10d47b, 0xc03f7622, 0xbf44df71,
    0x3f521969, 0xc01210f8, 0x40078165, 0xbff7c529,
    0xc085afee, 0x408d7569, 0xbed595b1, 0x3e85801d,
    0x3eb7b63a, 0xc02a178d, 0x40214580, 0xc020ee56,
    0xc023b8d5, 0xbeb6bd04, 0xc0867579, 0xc00ab568,
    0xbfc5b927, 0x407bbeb2, 0xc03512ac, 0xbebfb936,
    0xc03edabc, 0x3ecf6f22, 0xc016dbb4, 0xbf8b7bb1,
    0xbfcddbf5, 0xbfeda832, 0x3e6cb6b1, 0x3fa916a4,
    0x3ffad4e7, 0x3ff740dc, 0xbf9de903, 0x3fd62906,
    0xbf41a69b, 0xbf1e8801, 0xc01cbea8, 0xbddec74b,
    0x3fa2a9a8, 0x3feb4d15, 0xc04ecd78, 0x3fb04c78,
    0xc01510ff, 0x3f82dff4, 0x3f17f1b5, 0xc01e46b2,
    0x3f4e82f3, 0x3fb84f20, 0xc053ae0f, 0xbf5efd15,
    0xbf8b55e4, 0x3fc05958, 0xbe017fb9, 0xbec440db,
    0xc00f7afc, 0x3f6c05b4, 0xc0160e84, 0xbf34db5e,
    0xbf61a349, 0x3f9be48c, 0xbfcb1e5f, 0xc01ffdb6,
    0xbf539285, 0x40046dc3, 0x400f479a, 0xbfe33456,
    0xc0086475, 0xc025c20b, 0x3fba455c, 0xbf6b7150,
    0xbf967fbc, 0x3fc2f95d, 0x3f9ffac1, 0x404948d0,
    0xc039c79b, 0xbfba0b09, 0x3ebc028a, 0xc043e056,
    0xc085fb19, 0xbf9f52d5, 0xbf1c327b, 0x3ee927f8,
    0xbfa191f1, 0x3f9c2de0, 0xbfe036f0, 0x40248ffe,
    0xbc1f88d9, 0xc006a36d, 0x40785061, 0x3f8f8a1e,
    0x400e60de, 0x3bb2d421, 0x40033506, 0xc02aca3f,
    0x403112e7, 0xc01034f4, 0x4054933f, 0x3f252f05,
    0x3d2a3f42, 0x3fdb2f8b, 0xc08ac8a3, 0x3f132276,
    0xbf10d0dd, 0xbff11626, 0xc00b4565, 0xc0036a3b,
    0x40199549, 0xc038b950, 0xc0711ed9, 0xbf0aeddf,
    0x4057497e, 0x40728220, 0xc02f6ad2, 0x3f5cb87e,
    0xbf1b0fae, 0x3fc8c2b5, 0xbf3d3b17, 0x3f652855,
    0xc04165f1, 0xc09143c8, 0x3f19cbbe, 0x4089c2b5,
    0xbfc0700a, 0xc066e98e, 0x3f44f358, 0xbfb9786d,
    0x402cec86, 0x3fa2a040, 0xbfa61697, 0xbf68c68c,
    0x409f3c9c, 0xbec8f40d, 0xc0526eff, 0xc09c0b20,
    0x40084e6a, 0x4026b6d0, 0xc045dabc, 0x406dbf17,
    0x3ee51476, 0x3cb27587, 0xc030a022, 0x3ee4fcc3,
    0xc0894401, 0x4081fd26, 0xbfadee4a, 0x404f00fe,
    0xbf9916bf, 0x3fed9939, 0xbf87e34c, 0xbf53983c,
    0x402514ec, 0x401ec314, 0x3ffa7d22, 0xc01cdb58,
    0x3fe86864, 0x408c9175, 0x3b2616f0, 0x3ef5624c,
    0x3fe6167f, 0x3f5c7c7a, 0x3ee3acd7, 0x404e016a,
    0xbe30140c, 0x3eeebeec, 0xbed2c5f9, 0x400a79ee,
    0xbe8e4e21, 0x3fd2e8d2, 0xbe074231, 0x3f987410,
    0xc005d442, 0xc0649de6, 0x400d1cfb, 0xc01e0da2,
    0xc0083585, 0xbfae6310, 0xc05667ed, 0xc02a24f4,
    0x4040b8b3, 0xc0454815, 0x40b0ebe6, 0x3faad2fb,
    0xbcd70ed4, 0x405a4f6e, 0xbfdc517e, 0xbef2ee04,
    0x4011c923, 0xbf681f3d, 0xbfbf2ce2, 0xc0a6c673,
    0xc075f39c, 0xc01df0ff, 0xbe938aa4, 0x3f3971c6,
    0x408d77c8, 0x3fc785d4, 0x3fb871b2, 0x403b273d,
    0xc09ae618, 0x3f9a7a57, 0x40b17009, 0x3f16a027,
    0xbfddb070, 0x3eea9113, 0x4023a1de, 0x400ab921,
    0x3f67a276, 0xc07f4db5, 0xbfd342ed, 0x3fcdff7e,
    0xc09ea882, 0x3faccf7c, 0x3f82e407, 0xc0ad255c,
    0x3ee33036, 0x3fdcf719, 0xbe31034b, 0x3dbe090d,
    0x3ed023a5, 0xbe3c77d0, 0x3e855466, 0xbf1dced3,
    0x3f315f8c, 0x3ef5ee01, 0x3e4daa71, 0x402e3297,
    0x3f9f9f9b, 0xc0ace26e, 0x3fc27ef9, 0xbfa2997d,
    0xbf0bed2d, 0x3e645ae5, 0xbfa0f7b9, 0xbfd5dcde,
    0x3fead629, 0x3f1750aa, 0x3f43397f, 0x4016b933,
    0xc08eb718, 0x3dd67d16, 0x4097a275, 0x3ff4b0b3,
    0x3fafbc7f, 0xc002a56c, 0x3f12dd24, 0x4012f4d0,
    0x3f8f3724, 0xbee8ef3e, 0xbecff739, 0x3eaef0b5,
    0x3ee123da, 0x40ae73a9, 0x3f8d3a2c, 0x40a40c2b,
    0x3f8c2016, 0x403d1dd4, 0xbf01e34d, 0x3fd50c56,
    0x4026158c, 0x404f7450, 0xbfd6267f, 0x3f1df4e2,
    0xc001336b, 0xc0033712, 0xbf5ff0ee, 0x403888c2,
    0x4025008b, 0x3f98589c, 0x3f5b06b8, 0x3f1b794d,
    0xbfdd8c17, 0xbff3b3ed, 0xbf111f71, 0xbf69290e,
    0x407116df, 0x3f7527db, 0x3f5e927a, 0x40e62bd0,
    0x400b5fbd, 0xc0098f4f, 0x3eab745d, 0x3f8ede46,
    0xc005471f, 0xc030fce8, 0x40095060, 0x3f8908b7,
    0x3f6cb968, 0x3fc5f8ac, 0x409bfcc2, 0xc0746228,
    0x40ba6fd7, 0x3f362eee, 0xbe080256, 0xbfd70f12,
    0xbf0e863d, 0x3fa2f0c7, 0xbe977784, 0xbedc1694,
    0xc006028e, 0xc0391950, 0x3db86a33, 0xc03e3c38,
    0x3f1ada1e, 0xbfb89917, 0xbfa0ffd2, 0x40872194,
    0x3e38a2d9, 0x3f53d8c8, 0x3f969695, 0x3fcc3a40,
    0xc021336c, 0xbf175349, 0x3da64d6e, 0x3f881042,
    0xbedfdd98, 0x3cd448ce, 0xc015a794, 0x3e813195,
    0xbffda12f, 0x3fe660d0, 0x4089dbde, 0xc093ca1f,
    0xbff9ff84, 0xc01d2e50, 0x406b208d, 0x4001622f,
    0x3f1336a7, 0x3f8e9ca0, 0x3fc5fcbd, 0x3e1d50b4,
    0x3f885a49, 0xbf859d50, 0xbfc3e690, 0x400581e4,
    0x405e09bf, 0x400ad938, 0xbfe9061d, 0xbfc272bf,
    0x3f4b6a8f, 0xbffd6801, 0xbfc8568e, 0x3ede4117,
    0xbda1acea, 0x3f783557, 0xc003edc9, 0x3fac2e7d,
    0xbfdf7ba3, 0xbed1ea35, 0x3f64e3b5, 0xbe6e25eb,
    0x3ff90046, 0xbfc41248, 0x3fe35ce9, 0x3fd8cfcb,
    0xbfb60970, 0xbe4cdd84, 0xbfcf1f21, 0xbec41b58,
    0x3f94ba3f, 0xc034801d, 0xbf70e70e, 0x40d7055e,
    0xbf95aff3, 0xc02312d2, 0xbf33968d, 0x40091644,
    0x3f23e4c4, 0x3f63a1e9, 0x3d2bbaf0, 0xbfedb003,
    0x3e3dc193, 0xc056b0d1, 0x402d2958, 0x3fa80589,
    0x3f843ee6, 0x3f8062a2, 0xbda5758d, 0x404ae7bf,
    0x406b509b, 0xbfa04f0d, 0x3e087175, 0xbf62803a,
    0xbf971c1d, 0xc0019ac7, 0xbfdfcb94, 0x4054fd05,
    0x3fbca95a, 0xc0832b8b, 0xbcc506d4, 0xbdbd79aa,
    0x3fecfa75, 0xbeec6225, 0x4090006e, 0x3fb3011f,
    0xc009ecb0, 0xbf50ed00, 0x3c555db2, 0xc0a5ceeb,
    0x3fb69fbe, 0xc0b41324, 0x3ff96e81, 0xc073ba70,
    0xc0567fff, 0xbf88559b, 0x40428893, 0x403c6c80,
    0x3f9e1a26, 0xc04189c5, 0xbebc5695, 0xc030c300,
    0x3e1876a3, 0x40d95d58, 0x401de7e2, 0xc027c145,
    0xbfcf73bf, 0x3ec6cdc1, 0xc01dc8b9, 0x3f53ec11,
    0x3fa88370, 0xbfd0e84c, 0x4007e231, 0x3f80d42d,
    0xc042dce4, 0xbe53da3d, 0xc03bf6ae, 0x3ff734a2,
    0xc0130022, 0x3f6d1197, 0x403e7b34, 0x3f8e50f9,
    0x3f2139e2, 0x408976b3, 0x3f68e7eb, 0x3fbf37f9,
    0xc001c4bb, 0xbe5b9fa7, 0x3fba662c, 0xc056c649,
    0xbf9b452f, 0x4047a854, 0x3fe35746, 0xbe7806d0,
    0xc00961c3, 0x3f058ba6, 0xc08154ba, 0x3ee0bf2e,
    0xc09756d7, 0x3f4e4780, 0xc05d376b, 0xc0b4df69,
    0x40c062c4, 0x3e772bc0, 0xc091867e, 0x3f91ed98,
    0xc004670d, 0xc0145c75, 0x4061c906, 0x3f909daa,
    0xbe577a03, 0xbf9fe53f, 0xbe2f9eec, 0x3f016ed8,
    0x3f873ab9, 0xbdd6069b, 0x3f94ba57, 0x3faabc94,
    0xc00fda57, 0xc0295e6b, 0x3ff96aa1, 0x3fd7d60c,
    0x3f3f1452, 0xc04eb3ab, 0x3f9d81dd, 0xbfeb9c96,
    0x3fe0fca4, 0x3f5d1325, 0xc06430fc, 0xc0482230,
    0x4093003d, 0x3fe4b71f, 0x3fb50851, 0xc041e46a,
    0x409482f5, 0x3ffacac9, 0x3f79db09, 0x3fdd50d9,
    0x404a6f80, 0x3ef1ca31, 0xc01ec26f, 0x3f9e7fd8,
    0xbfea8409, 0xbf39f87d, 0xc07dcd48, 0x3d557d87,
    0x4059ba20, 0xbefbf93a, 0xc00feb10, 0x3dc15445,
    0xc02f788c, 0x3f96a85b, 0x3dda950b, 0xc0998bdb,
    0xbfd8de95, 0x3f85e3c3, 0xc008ae7b, 0xbe94063e,
    0x3fc55aae, 0x3faaed55, 0xc0031fba, 0x3ed28af5,
    0x3f299449, 0xbfe9080c, 0x3e94aa51, 0x4054a6c4,
    0xbff47d06, 0x3e022239, 0xbfbc26dd, 0xbfdeb6ab,
    0x3fdb8407, 0x3f355ab5, 0xbf3421c0, 0xc04531a7,
    0xbf6f90ed, 0x40411951, 0xc0737671, 0x3e96ad2a,
    0xc02880e0, 0xbebdc232, 0xc07005b3, 0xc00445a9,
    0xc02440b5, 0x3ef3d032, 0xbef163ee, 0x40bb4c56,
    0x405f7c51, 0x3f5edfee, 0xc004608c, 0xbf6eb8f5,
    0xc047bdfe, 0xc058e2a6, 0x3ed7e15d, 0xc08fd53e,
    0xbf9e8ab5, 0xc0357656, 0x405748b1, 0xbd8d3373,
    0xbfe403e5, 0x3f4739bd, 0xc0057837, 0x3f10911f,
    0x3f7d16dc, 0x3fb95c31, 0xbf987756, 0xbfc2ae42,
    0x3f7d8486, 0xc0fcc041, 0xbf035cbc, 0xc00efef9,
    0x3f9b78a0, 0xbf0325ee, 0x409728a2, 0x3f2e5ed3,
    0xc0091e0a, 0xc023d7e5, 0xbfa3121b, 0x3eb230fa,
    0xc0098472, 0x400df9a7, 0x403f4c73, 0xc08ca508,
    0x3fdb7b4a, 0x3fff921c, 0xc046a073, 0x3fb93fba,
    0x3ff0d8d5, 0xbf991b07, 0xbeac6b07, 0xc086375c,
    0xbfd1c16b, 0xbfaca104, 0x40130973, 0x3fc7fb7c,
    0x3fc96d6d, 0xbfd5b238, 0xbf21536e, 0x3ee965d7,
    0xc01ef997, 0x3ff8bfca, 0x4080cbe1, 0xc0803f53,
    0x408c7611, 0x3f308ff2, 0xbfb88ae1, 0x408ac1f8,
    0xbf90f2d5, 0x3fa193fa, 0x3f9ab3c8, 0x401027e9,
    0x3e7871f6, 0x40490995, 0xbfb08aad, 0x3f799b3c,
    0xc01b5a0b, 0x402f5f0e, 0x3bfaebd0, 0x4036e87b,
    0x4008fba0, 0x3ff7df37, 0xbec5493d, 0x3f16c6ef,
    0x403ff664, 0xbd24a662, 0xc07eeea1, 0xc01c2897,
    0x3fa6b188, 0xbd56a999, 0xbe69d645, 0xc05a93dd,
    0x404dbf64, 0xc0a16876, 0x3d14b934, 0x3f8066b9,
    0x402a1c9d, 0x4012cbfd, 0x3fbab730, 0x3f0e616e,
    0x4008f8c7, 0xbd258d0e, 0x4012487e, 0xbea0b4af,
    0x402d4524, 0x3e390c25, 0x3fa6d634, 0x40349598,
    0xc097dd90, 0xc02f743e, 0xbe9b2648, 0xbf72fc9c,
    0x3ccfe9fd, 0x3fe16fce, 0x3e15e7f7, 0xc07c0456,
    0x3f07f158, 0x3e1d3209, 0x40671649, 0x3d900b65,
    0x400774b4, 0x3f5c0c5f, 0xbf1e507b, 0xbf66ed4c,
    0x3efbcaa6, 0xc052df85, 0x3fe7c161, 0xbf7e51db,
    0x401cc6d3, 0x3ff21bae, 0xbff60106, 0x3e21c4ce,
    0x3db18d61, 0x3f95649a, 0x3f3e50d5, 0x3f94fb2e,
    0xbec81cee, 0x408898d6, 0x409f23a3, 0x3fc615ac,
    0x400c3e72, 0xbfe751a9, 0x40050c5b, 0x402a6cb9,
    0x3eb89160, 0xbec7db8d, 0xbe19ca19, 0xc019a9fc,
    0xbfa89759, 0xc024bc71, 0xbfa9ad79, 0x409c0f0a,
    0xc07b78ff, 0xbfc30deb, 0x4057825e, 0x4005a19d,
    0x404e1830, 0x3fb7975e, 0x3f03400b, 0x3f23c2cf,
    0x405b3d6a, 0xbfa456f9, 0xbfb2d7d5, 0x3f0587cf,
    0xbe592a78, 0xc07f8d9b, 0x4001a8d0, 0x3f61ec0c,
    0xc055692e, 0x403fe7f8, 0x408e4e65, 0xc0189da3,
    0xbefcf638, 0xbeb1a0d2, 0x3fd8887a, 0x3e5b2a0e,
    0x3fa5c092, 0x405719b0, 0x3fc74dfb, 0x401833c1,
    0xc0558db9, 0x404cd646, 0x3ecb7369, 0x3f883c05,
    0xbf8cee02, 0x3f2244c3, 0x3fabe8c4, 0x4063ab0f,
    0x3f08bee5, 0x3fe6f6f8, 0x3fbd7c91, 0x3f8dd93d,
    0xbf3bb895, 0xc0285af6, 0xbfd76d91, 0xbe84632c,
    0xc0572d26, 0xbf533f65, 0xbf8fe972, 0xbf9ff0cc,
    0x3f8f01c0, 0xbfd7a58b, 0x3f23b9e0, 0x3dbd69a3,
    0x404bbca9, 0xc09ec6be, 0x3f835482, 0x3f6c64a1,
    0x3f9a14c7, 0x4017ba60, 0x4020cdba, 0x405011e5,
    0xc00c52fb, 0xbff8434d, 0x40865d39, 0xc0085696,
    0x3f8af2c4, 0xc0117d4c, 0xbf9ad6c7, 0x3e936cce,
    0x40074900, 0xbed86876, 0xbf9c7bf7, 0xbf547be1,
    0x40381c34, 0x3fc6ee36, 0xbec47454, 0x409529c6,
    0xbff07197, 0xbf9b490a, 0x3eaf82ee, 0xbef63b98,
    0x407c848c, 0x3f41a8c9, 0x40425bf1, 0x4024d39a,
    0xc0ea474d, 0x3faa321f, 0xbfd7f558, 0x3f518e68,
    0x3c25fcf8, 0x4049c1ac, 0x4023ed3a, 0x3f55d9c4,
    0x3f17b2ad, 0xc0130957, 0xbea44df1, 0x40496279,
    0xc0556734, 0x405ab774, 0x40b59b7d, 0xbf52aa9e,
    0xbe9bf45f, 0xc04304b1, 0x400853c6, 0xc02251d6,
    0x3f0f57b9, 0x3fab4a66, 0x3fadee57, 0xc085a216,
    0x3fd0d9f3, 0xbfac14c2, 0x3f4d9299, 0xc00a4722,
    0x3feeb53c, 0x3fc7ad8c, 0x3dc936e2, 0x4087e398,
    0x40586f23, 0xbecc3e7f, 0xbf71c017, 0x3edb9826,
    0x4016bfdb, 0xc0021064, 0x3e7616bc, 0xc07ead69,
    0x4081c60f, 0x3e473a65, 0xbfd876d4, 0xbf51330c,
    0xbff9eca4, 0xc00ab9a5, 0x3fdb64c2, 0x3d76f5da,
    0xbf973d77, 0x40226b23, 0x408c5404, 0xbfeb6b98,
    0x40240336, 0x400bc10e, 0xc0213d45, 0x3ebec76e,
    0x3fa9b4db, 0xc07ceccc, 0x40215cfd, 0xbf3c0ca7,
    0x3ef7ddcf, 0x3fb71a5e, 0x3fa86a82, 0xbe5424a8,
    0xbfd3f1c7, 0x3eb2714a, 0xc0533fc3, 0xc0916ce9,
    0xc01ed62f, 0x3ec25c5a, 0xc0224400, 0xbfc27464,
    0x3fbed0b3, 0xc026b6a3, 0x3ffc0a8b, 0xbfee641f,
    0xbf55380a, 0x4006b02d, 0x3ffef594, 0xbfdfe9c8,
    0xc013b9bf, 0x3f9b143f, 0x404fa7a7, 0x406773cd,
    0xbe96959b, 0xc05aaf4e, 0xc0211ce7, 0x4068723a,
    0xbf1661a9, 0xc0909e52, 0xc02197b9, 0x3f026368,
    0xbfdb0cba, 0x40407541, 0x40596858, 0x3f4e4194,
    0xc014ed81, 0xbeb26e5f, 0xbfa6451a, 0x3f2d9e93,
    0x3fa33181, 0x3f8cd489, 0x3f14022c, 0x401cf110,
    0x3f8d751a, 0x3f75c4ae, 0x3e0eaf34, 0xbfac4725,
    0x3f8b64b7, 0xbd5ccc2d, 0xbf6a4ce9, 0x3eaad797,
    0xc03e1993, 0xbd854f7e, 0xbfb884d9, 0xc0865661,
    0x3fced90e, 0xbe8b0e8a, 0xbf669f6f, 0x3fe383e4,
    0x3fc88c7b, 0xc06452b8, 0x40527c45, 0x3fd610c9,
    0xc007ebe1, 0x4043a73e, 0x3cbca922, 0x3e8878b4,
    0xc04b5d6d, 0xbf993a7f, 0xbdf3d7f3, 0x3f93d1aa,
    0x3ea935d4, 0x40033a46, 0x406f81f9, 0xbfc3624c,
    0x3e595593, 0x3fd4fab7, 0xbf2084af, 0xbee2e45f,
    0x3ebca4d5, 0xc07585b2, 0x3fa5d66e, 0x3f809d61,
    0xc05b6c19, 0x3f28558e, 0xc0900175, 0x4006b660,
    0xc0608ebc, 0xbf247a27, 0x409d582a, 0xbfb086d0,
    0xbfab7051, 0xc09fb867, 0xc0543119, 0x40851e73,
    0xc00a14de, 0x3d232bb7, 0x40219574, 0x407929f1,
    0x402e8866, 0xc08e104f, 0x40ad161a, 0xbf3bd919,
    0xbed84983, 0x3f70491b, 0xbff74173, 0xc0983689,
    0xbeb3b26a, 0xbf517dfe, 0xc02e6c53, 0xbf07d6e9,
    0x401d07dc, 0x3fa9c0e9, 0x40467d2d, 0x40109225,
    0xbf791da4, 0x3f962f00, 0xc04c59c9, 0x3fb60adc,
    0x3ff27a97, 0x40062951, 0x40811174, 0x405bda33,
    0x3fa6c212, 0x3fea3ebb, 0x3f4ef23d, 0xbd6aec86,
    0xbe3ca506, 0x405a1a7e, 0x4016c883, 0x3e366955,
    0xbfb29dc0, 0x4032e267, 0x3f0b2f65, 0x3f2a8d11,
    0x4021bbfe, 0x3f7fdc8b, 0x401a4896, 0xbd1da05e,
    0xc0714b50, 0xbd90a7c9, 0xbfc0c1c0, 0x40107951,
    0x3fe8642b, 0x3f048a66, 0xc01e3664, 0x403453a2,
    0xbecd4104, 0x3fa9b6ba, 0xbf80ba61, 0x406822af,
    0xc0331996, 0x3fc66792, 0xbfddb5cf, 0x3fda0b0e,
    0xc0888458, 0xbff0b154, 0xbf7e3b3f, 0xc0333b02,
    0xbe2dcc7a, 0x3f5f4092, 0x3fcd01a9, 0xbf966e05,
    0x3d82eb64, 0xc00a3860, 0xbf82dbdd, 0x4034fdf5,
    0xbe98e18d, 0xbf8f82e3, 0x3feb205e, 0xbf00d110,
    0x4008e9a0, 0xc035b946, 0xbe5edc8b, 0xc05bb737,
    0x3e9a8274, 0xbd2bed2d, 0x3ddd1b9e, 0x3e0b0b3d,
    0x404cb42f, 0xbf8288d8, 0x3fcabe49, 0xc0587668,
    0x4009593f, 0xbf0caf8b, 0xbe83e243, 0xc0b81ec2,
    0x3e0905e4, 0x40b1d267, 0x4020cb37, 0xbe77cdbf,
    0xc0033101, 0x3ff064da, 0xc00f654a, 0xbfa777ed,
    0x3f8a803e, 0x3ef8494f, 0xbf1d42de, 0xbd115d17,
    0x3f827a85, 0xbfb52564, 0xbd96dca1, 0x3fc9b864,
    0x40530a11, 0xc016e7aa, 0xbf13f7b2, 0x4005bcb2,
    0x3f0a06a5, 0xbfd0b0a9, 0x400a93ec, 0x40216a9d,
    0x406acd6a, 0x3f2c1493, 0xc032deac, 0x3fca6f24,
    0xc073315a, 0x3f8f2cb4, 0xbf8670cc, 0x3ddf37bd,
    0x3f23d5a7, 0xc02977e1, 0x3ef2f601, 0xbef11d35,
    0xc04718bd, 0xbf34c667, 0xc0089b1d, 0x3e867f62,
    0xc0108c0c, 0xc00c14ae, 0x3fdcf3ea, 0xc011bea6,
    0xbfec695b, 0x4033ef87, 0x3f9939cb, 0xbf9a460a,
    0x3fabbbe9, 0x3e0ebcf9, 0x405aadf3, 0xbfbf325e,
    0x3f3584d8, 0x3e29b09e, 0xbe698fd2, 0x3fb42d3b,
    0xc04943c3, 0x3d079312, 0x3f737f36, 0x3df83340,
    0xc05ff90a, 0xbf4f1f41, 0x40375c6d, 0xbe9d27a0,
    0x409fd96e, 0x3fe6df0f, 0x40685c1b, 0x3f88e29c,
    0x3fea33d0, 0xbf7b5b99, 0x3f6f0460, 0x3fc080fa,
    0x4062c771, 0x3fdaab74, 0x40154331, 0x3e8001f3,
    0x4002b371, 0x40055352, 0x3fc1b2e2, 0x3f9859eb,
    0x406862ce, 0xbe9c0180, 0xc08c3078, 0xbfd8a87a,
    0xc0849812, 0x4080e4cb, 0x40330fef, 0xbe278a28,
    0x40131b97, 0xc014a611, 0xbf58b50d, 0xbe1d8ad5,
    0x3feedfa4, 0xc046170d, 0xc08aa950, 0x3d37afc8,
    0x40f04821, 0xbfa303f6, 0x40374d55, 0xc003824e,
    0xbd6825d8, 0x4008c61a, 0xbfe426c8, 0x3e9dc0e4,
    0x3f2cfead, 0x4035091c, 0x4082b027, 0xc046a989,
    0x3cda7ede, 0x3f360f71, 0xbe4fadb0, 0xbf6d2a0b,
    0x3f4b7703, 0xc072f3a2, 0xbea2fbf0, 0x3f39bb98,
    0x3f976435, 0xbf95a3ba, 0x3f87c4d2, 0x4019e7e7,
    0x40156f17, 0xc08726d1, 0x3e080eec, 0xc0063c70,
    0xc06cfd14, 0xc056b840, 0xc053d9c5, 0xc0635306,
    0x3fe45933, 0xbf686a0c, 0xbf76a306, 0xc006b2f8,
    0x3f8b0c15, 0xbf1d58d7, 0xc08cb691, 0xbf5d10f8,
    0x3ffdc25d, 0xbfbd55e3, 0x404d92e4, 0x3f913950,
    0xc09199e8, 0xbfdfa76c, 0xbf9183c7, 0xbd8e0747,
    0xc0759e61, 0xbd8a1714, 0x3f91ed12, 0xbfbd3377,
    0xbf46b9cd, 0x3ec3726b, 0x3f763a2f, 0xbfa6eec6,
    0x3e694cd2, 0x402da1df, 0x3f39baf5, 0x3f9736d8,
    0xbc49a1ba, 0xc0296e34, 0x3eb3803d, 0x40e06d3a,
    0x3e254667, 0xbf36027b, 0xbf5f42f8, 0xbff72294,
    0xc0247613, 0xc0015ae9, 0x403282e9, 0x3fff084f,
    0x3eeabf9c, 0x403efd25, 0xbf740a6d, 0x3d9af381,
    0x40039a80, 0xbfc655a7, 0xc02b7f8d, 0x3f907e81,
    0xbe43966e, 0x3f82b701, 0xbf8e7422, 0xc024b7b3,
    0xbdc1fae3, 0xbecd57f3, 0xbfc7e894, 0xbfe05041,
    0x3fc919c6, 0xbfe28a57, 0x3ff4e6b3, 0xbfc5c1b3,
    0xbe01e941, 0x3f2a3708, 0x3ffc9d02, 0xbec604f2,
    0x4041cd2e, 0x3f7feb66, 0xc03c4b6b, 0xc00da120,
    0xc03cc50d, 0xbd27f33e, 0x40064e27, 0xbfd9fa6a,
    0xbfb0e0cc, 0x3f9c97d6, 0xc02c0dc8, 0x406c4139,
    0x3fcdba5f, 0xc0b6df62, 0xc09fa0dd, 0xbf0525c1,
    0xbfe76530, 0xc021a42d, 0x403dec1a, 0x3ffcb7b7,
    0xbf1f8011, 0xbfb4265e, 0xbef3dc03, 0xbf495948,
    0xc0b3b3c1, 0xbfaa4a37, 0x3f1dba3c, 0x400f1540,
    0x3f62c373, 0x402288b2, 0xbf81830a, 0x400566b5,
    0x3fec0c57, 0xbf915530, 0x3fdb559c, 0xbf8c9182,
    0x40080bc8, 0xbddde608, 0xbf5d0ce2, 0xbebe5ddf,
    0x40390e29, 0x3e4393ea, 0x3f1daef3, 0x400f002b,
    0x3fca9943, 0xbffc0032, 0xbfd3157d, 0xbebcc3c6,
    0x401b12a5, 0xc04c62ea, 0x4060ea91, 0xbfbeeadd,
    0xbf88f41f, 0x3fba2dfb, 0xc0112cd6, 0xc00525fd,
    0xbee2feaa, 0xc0171584, 0x3f616cc1, 0xc04248f2,
    0xc0a535d3, 0xbfa27b5b, 0xbf2f09bd, 0xc02bccb3,
    0xc057e04c, 0xc08bcc4b, 0xc07d4788, 0x40639a88,
    0x4098a231, 0x40227b9f, 0x3f899ccb, 0x3ea45b7e,
    0x3f41a1c0, 0xbebbe56f, 0xbecf61bf, 0x4021f9fa,
    0xbd805886, 0x3f8c2a7c, 0xbe094d13, 0xbec46835,
    0xbf3234f7, 0x3f453a5e, 0xbf32c93c, 0x405496df,
    0x3f308143, 0xbf9a5c4d, 0xc018462c, 0x40ab1801,
    0x4063621b, 0x401c3ea5, 0xbf1ba50c, 0x40368aac,
    0xc045467b, 0x401a417b, 0xc0298ff2, 0x3fb51c4d,
    0x400ea556, 0xc08b4ee6, 0xc0291eba, 0x4088419f,
    0xc05ee317, 0xbfef0228, 0xbfd433aa, 0xc02f03e9,
    0x3ee5cf41, 0x3edf1d9d, 0x3ecc4c0e, 0xbc381623,
    0xbd8a1e21, 0xc088c044, 0x4033879f, 0xbfc99f4b,
    0x403a8ecb, 0xbfad17a8, 0xbfe9688c, 0x40432842,
    0x40300783, 0x3f0cd0ff, 0x3def231c, 0xbf12ebbd,
    0x3fb0e4e6, 0xbf3e8325, 0x3f7af107, 0xc07029c7,
    0x406bf909, 0x3de4e93b, 0xbfd2b697, 0x3fb9b3fa,
    0xbf9a807a, 0xc024016d, 0x3f1f5795, 0xbea4b131,
    0x4065a086, 0x3e5b5240, 0x3fefc4d9, 0x400ecfc7,
    0x40757ec8, 0xbf92e8e7, 0xbeacb189, 0xbfa223b5,
    0xbe130e61, 0xbf04a820, 0xc07f4d8c, 0x3f49a354,
    0xbe08dd56, 0x40332bcc, 0xbd9971a6, 0x4002a045,
    0x405cc42f, 0xbf51c115, 0xbf9492b3, 0xc0489e88,
    0x3f862372, 0xc021ef24, 0xc010f72e, 0x3ea9a635,
    0x3e9753b0, 0x401ba0b4, 0x401ee6ad, 0xc076a5c2,
    0xc0080c3d, 0xbfd87d21, 0x3fac1caf, 0xc035aa4f,
    0x3ea81585, 0xbf8702bd, 0x4091ebb1, 0x408fcd93,
    0xc02699d3, 0xc056e7fa, 0x3fb8732e, 0x4077e956,
    0x3f590e67, 0xbf7dc631, 0xbf2c13b7, 0x404d049b,
    0xbfaa8504, 0x3fd9f2a0, 0xbf867e1e, 0x40852f7c,
    0xc020be13, 0xbf68a67a, 0x3fbe8dfa, 0xbfacdaf8,
    0xc00e9f4c, 0x3fd5caf6, 0xc0d049b4, 0x3ff7e07b,
    0x3e6c073a, 0x405a99f4, 0xbf2a9c64, 0x3f9cb2ad,
    0xbff9322d, 0x3fefa264, 0x3f27096b, 0x403a0c8a,
    0x4047f083, 0xbe13b414, 0xbf1d6b65, 0xbf9ca546,
    0xbfc60787, 0xc0b64396, 0x4017bdc8, 0xbffcd657,
    0xc03a83e5, 0xbe543a6b, 0xc0653488, 0xbd0b41f5,
    0xbf921d7f, 0xc01f4eaf, 0xc088b8aa, 0xbfb46fb4,
    0xbfc52511, 0xc00b6606, 0xbe90a35c, 0xc019f5ee,
    0x3f7737be, 0x3f7e35e8, 0xbf17488d, 0x3fa07ef7,
    0xbf72c1ee, 0xc0536cf3, 0xbf9cb3b7, 0xbf0a30ff,
    0xc0819014, 0x3f1cefec, 0x3fb54800, 0xc048bd2e,
    0xc04ff3a6, 0xbf5b3361, 0x3e74338d, 0xbf04b918,
    0xbfff72f5, 0x3f97ad23, 0xc0186f4a, 0xc018d5e7,
    0xbda8dcfc, 0xc068d17f, 0x3f903a66, 0xbfd58026,
    0xbebe635d, 0x3ffb7e28, 0x408ed0c7, 0xc03f5c5c,
    0x4088416c, 0xc098a743, 0x3fc830b8, 0xbfc28740,
    0x3f34e7b8, 0xbefa26a3, 0xc03416e5, 0xbed07fb9,
    0x3d9ac551, 0x3f98c62c, 0xc072dbc2, 0xbfb73e34,
    0xbec0ebaf, 0x40244385, 0x4004ef79, 0x405fed40,
    0x3e31b0d1, 0xbf10fae9, 0x406d4a7a, 0x3f1440b4,
    0x402a5df1, 0xbf9b1ce8, 0x40041298, 0xbe94307c,
    0x4093156f, 0xbf230e79, 0x3ed726a6, 0x3e80704b,
    0x3fe13f09, 0xbe0df8e8, 0x400c8b2a, 0xbe9a84b8,
    0x3ee02f59, 0x3e9eb913, 0xbfd831e2, 0xbe2fd597,
    0xc0045e4a, 0xbf793220, 0xbf9ee296, 0x3f90a96d,
    0xbf356765, 0xbffcaa17, 0x3f26c2b6, 0xbfdd8761,
    0x405b3f08, 0xbe74135f, 0xbdfb890a, 0xc05163a8,
    0xbfb684bd, 0xbea3e39c, 0x3fd86335, 0x4065774f,
    0xbee28d32, 0x4040c01f, 0xc00629f5, 0x40969c4e,
    0x3df8e7ff, 0x4009f66f, 0xbf7b4529, 0xbfcd778e,
    0x3f674ce0, 0xbfa393fe, 0xc0327918, 0x408aea35,
    0xbefcd7c8, 0xbe3566d7, 0xbe928191, 0xbf3e7842,
    0xbf578ebb, 0x40149e2c, 0xbf06376b, 0x3f3471cd,
    0x3f05bac3, 0xbe5f416a, 0xbfcb47d0, 0xbf53de26,
    0x3ff3214a, 0xbff7ffb3, 0xbfbe6a5f, 0x40760db0,
    0x3f956dea, 0x3f092c80, 0xc0afe86b, 0xbe8fc6a0,
    0xbfbc3b8a, 0x3fb4436b, 0x3ed550df, 0x3f18be6b,
    0x3f7a8c1b, 0x3efe3310, 0xc05da10a, 0xc02be5b3,
    0x408c0f32, 0x3fc9e399, 0xc06419a0, 0x3ea06d98,
    0xbdad62e4, 0x3f1be251, 0xbf55d462, 0x3f180487,
    0xbfade3bc, 0x3d81a1ea, 0x40716338, 0x3de6040d,
    0xc083070e, 0xbf51eb1a, 0xbf45a049, 0xc03558df,
    0xbed8661c, 0xbfc62c35, 0xbfd14828, 0x3f8d9420,
    0x40187221, 0x3fce0056, 0x3f47925c, 0xc065b234,
    0xbf72d5c4, 0xbe325f3c, 0xbe988bb3, 0x4027555c,
    0x3f6e545c, 0x3f37968e, 0xbef6bf67, 0xbfba2995,
    0x40202a86, 0x3f838b46, 0xbf7ecf68, 0x3f15fbd0,
    0xbf4a3cc8, 0xbef382ac, 0xbfd10138, 0x400aba67,
    0x3e48be9a, 0x3f3cae40, 0x3fe4417f, 0x40091b2c,
    0xbf130787, 0xc086ae5b, 0xc0305c0a, 0x40153902,
    0x3fd67447, 0x3e05738b, 0xbf897db0, 0x3f16a1b2,
    0x401a4b8c, 0xbf610863, 0x400b11bd, 0x403fd3ec,
    0x3f57c7e0, 0x3f37245e, 0xbf758902, 0xc015f8c9,
    0xbf372d60, 0xc01fb68c, 0x40262e6d, 0x3fd96483,
    0xbec376e3, 0x3fd50db3, 0xbefc2b24, 0xc018e004,
    0xbf93a3d4, 0xbeccbd78, 0x402a560f, 0x3f17da61,
    0x3f9931ba, 0x405098e7, 0x3e94a369, 0xbd83e146,
    0x40565ff0, 0x3facd7f4, 0x3f5e2eac, 0x3eaf21bb,
    0x3f7259b9, 0x3fc22e92, 0xc04ede9b, 0x400c63b3,
    0xbf5d5e12, 0xbeeb4957, 0xbe9bb4ac, 0xbef90d5b,
    0xc050bbce, 0xbf4bfc52, 0x3fdb28d1, 0xbf3196c9,
    0x3dee444b, 0xbf4aa234, 0x3e6e6e95, 0x3fcef60b,
    0x3f9f1334, 0x3f0be6da, 0xbf20f95e, 0xc030df20,
    0x40673c83, 0x3f56bf41, 0x40524845, 0x3c4a74cc,
    0x3eb0f23c, 0xc000ef84, 0x3e8b3c6d, 0x4008ac66,
    0x3fcc3112, 0x40289523, 0x40005a62, 0x4067f2b3,
    0xc01945fb, 0x3e225bab, 0x3f47095c, 0xc025a858,
    0xbf7810d2, 0xbed3623a, 0xbf3fc0c9, 0xc058f43d,
    0xbf901662, 0xc0875582, 0x3fc59f08, 0x3f5326cb,
    0x40036935, 0x3fcf93da, 0x3f56add7, 0x3eed3268,
    0xbffdb48d, 0x3e738573, 0x4081df18, 0x3ff58e5d,
    0x3f27214e, 0x3fec0afe, 0x3ede21e2, 0x3fc8cd5c,
    0xbf82e727, 0x4030831a, 0xbfcc85c2, 0xbf96326e,
    0x402e1cc4, 0xbf14cb1d, 0xbf9cff31, 0xc012af69,
    0xbe1a9994, 0x3e54f83b, 0x3f0b3500, 0x3fd95dc4,
    0xbf8bb2ff, 0xbf66ca85, 0xbf8bcb56, 0xc06332c4,
    0xc04ed2d7, 0x3ff142e1, 0xbeb446d8, 0x3d705c0a,
    0xbfdac521, 0x3ded2910, 0x401cf9ec, 0xc046ba26,
    0xc0338c07, 0xbf321713, 0xc02ef347, 0x3f4497de,
    0x408863af, 0xbfd406c8, 0xc03ca233, 0x3f68c729,
    0xc06b34cd, 0xbd61862f, 0xbfb2766a, 0x3f78c375,
    0x3f9c9d5e, 0xbf1c0e6c, 0xbe60702c, 0xc066ef2c,
    0xc05f53d8, 0xbf253d61, 0xbfe359e8, 0xbf8d70ff,
    0xc094ad23, 0x3fa5e9b3, 0x3e85e223, 0x40262eb8,
    0xbfe44e6d, 0xbedf6701, 0xc0a3986d, 0x3eb074a9,
    0x3fca6c0c, 0xbec6e4a1, 0x40a1b8b8, 0x40758b6f,
    0x3fedfaeb, 0x3f0e5bed, 0xbf811258, 0x403afe37,
    0xbf06a447, 0xc01f45bb, 0x3f9f9042, 0x4087e5c0,
    0x403feea3, 0xbeee15f1, 0x40577ce2, 0x406ac12e,
    0xbf44d98d, 0xbe98a354, 0xc05508a3, 0x3fd760ac,
    0xbf8ba69f, 0xbfac3261, 0xbf847a84, 0x3da88450,
    0x3fc5be68, 0xc02342cd, 0x3f30071a, 0xbd7c7e5b,
    0xc01df30c, 0x40b7aef5, 0xbf49cee0, 0xbeadee7e,
    0xbf4c9769, 0xc02afb58, 0xbfe1519c, 0x3e3b2fdb,
    0x406171e0, 0xbfba97e7, 0x408ef077, 0x3fefea60,
    0x3fcaea58, 0xc02bb57b, 0x3f9d9ec5, 0xbeb47a6a,
    0xbf1b0406, 0xbf160f05, 0x403ca7b1, 0xbfdf345a,
    0xbe7a637c, 0x3dfad393, 0xbf86db83, 0xc0bc5a4a,
    0x40913ba0, 0xc07b2497, 0xc032bdef, 0xbf5a75ba,
    0xbe9cb544, 0xc09a30c4, 0x403b83b1, 0x3d861013,
    0x3f4e313c, 0xc030b2f2, 0xc0c7b17f, 0x3fa90804,
    0x3f432546, 0x3eb4f8e5, 0xbf85fe9c, 0xbf794c4f,
    0x404703ba, 0xbfbcf10f, 0x4032ca05, 0x3fbe9e57,
    0xbfbc97d4, 0xbdedde4d, 0xc00e7382, 0xbf00b0ee,
    0xbfbdf1e4, 0x402c1b4d, 0x3f598732, 0x4064a9a8,
    0xbd5a257f, 0xc03b121c, 0x406517b9, 0xbea5c92a,
    0xbf6a72d9, 0xbfc12f38, 0x4019c532, 0x400398cc,
    0x3fd8a63d, 0xc0931b3c, 0xbe67e6e4, 0x3ec0b309,
    0xc09a2946, 0x3e4b9d4e, 0xc0189332, 0x3ed0c6e0,
    0x3f285fe8, 0x401d222a, 0x3f582b8b, 0xc03abed1,
    0xbf03b86f, 0xbeaa4665, 0xc016b67c, 0x3f72212f,
    0xbfd4c2a6, 0xbf9b469b, 0x4080d527, 0xc0377f30,
    0x3e94b56d, 0x3f7335a4, 0xbedd0b4d, 0x401be8fa,
    0x4007f04e, 0xc09d238e, 0xbf93d818, 0x3c4c3e64,
    0xbfe38d8d, 0xbfde1d08, 0xc0832b49, 0xbf1aa35c,
    0xc09828cb, 0xc01a473b, 0xbfd20849, 0xbf574b39,
    0xbf13afcd, 0xbe8130a0, 0xc0776ce3, 0x401db653,
    0x3fc4dbf1, 0x400fbfdb, 0xc03cc914, 0xbfb72b12,
    0xbf435668, 0xbf0fcdf7, 0x402ed958, 0x406a0481,
    0xc05f259d, 0x3f9f59ff, 0x3c605a5d, 0x3ee7dd23,
    0x40461d69, 0x3fef07dd, 0xc0667106, 0xc08c9796,
    0x40b13805, 0xbfb05174, 0x3f094927, 0xc01c05ba,
    0xc00c2f8b, 0x3ef33150, 0xc0aa72ed, 0x40312022,
    0x3f11541c, 0xbffeb37e, 0xc0095cab, 0xbf90a4c9,
    0x401067eb, 0xbc849251, 0x3ffe0017, 0xc0660b43,
    0x3fc6074b, 0xbe96b285, 0xbf2ca592, 0x3edb284c,
    0x3ef86eff, 0x3f41d945, 0x4035f650, 0xbf6146f7,
    0x4012ade0, 0x400d37bc, 0x408d4d6f, 0x3f8d942f,
    0xbecbb6ca, 0x4013501f, 0xbf5cd745, 0xc0215d25,
    0x4050f0f6, 0xc03d8eec, 0x3efb4f61, 0xc0530751,
    0xbeddd754, 0xbf1f177d, 0xbffeaa2e, 0xbea07694,
    0x3d4eb153, 0x3e67225e, 0x3eb767a1, 0x4099d0ab,
    0xbecb66d1, 0xbfc11130, 0x3e54f6a1, 0xbfb3e9c5,
    0xbf1b2873, 0xbf236f97, 0x3fb1c28b, 0xbfae68fb,
    0x3ef68195, 0x3f47f62d, 0x403cbbaf, 0xc000271e,
    0x3dd6991a, 0xc02e9c64, 0x4012727b, 0xbfb768f3,
    0x3fcee5a2, 0x400ef199, 0xbfa40201, 0xbdda6747,
    0x40abc997, 0x4055289f, 0xbfc4ad37, 0x408b384e,
    0x3f93e6f0, 0xc0294f3f, 0x3f867ead, 0xbea6f47a,
    0xbfae6e43, 0xbf2a2940, 0xbe2b33db, 0x3ef383aa,
    0xbfe9190a, 0x3ed636c2, 0xc001bee7, 0x3f1dedde,
    0x3fed0645, 0x3fec9394, 0xc0077b33, 0x3f208a4f,
    0x3ddfd1b7, 0x3ecb8fda, 0xbfe072a2, 0xbe233703,
    0x4080ee26, 0x3cd17dc9, 0xbffb8574, 0x40317576,
    0xbf83124a, 0xbf4f1750, 0xbf86178f, 0x3f9bf606,
    0xbfaf90f0, 0x3fcb1e0d, 0xbf864d15, 0x4031574c,
    0x3f3602dc, 0x3e7171a5, 0xbefb99bd, 0xbf47c0cd,
    0xc03750ae, 0xc022602a, 0xc04a1362, 0x409c5659,
    0xbf7d7321, 0xbfeb3255, 0x40ab92bc, 0xc0ae5000,
    0x3fa62c61, 0xc08f0e36, 0x40c461a8, 0x3f84720a,
    0xc02fa07d, 0x4002de1b, 0xc0061786, 0xbcac160c,
    0xbf26eaee, 0x3ef6c4bc, 0x40c4ce27, 0x3f1cb0dc,
    0xbeee7f8c, 0xbeca7b66, 0x3fca63fc, 0xbf5ad51d,
    0x407982a1, 0x3ec3e4e6, 0xbffb8e22, 0xc060b5c8,
    0xbf7c7cac, 0x3ffff352, 0x3fb08202, 0x3f47293e,
    0x3fcf2ab8, 0xbf7385b4, 0xbe1527ad, 0x3f98cb20,
    0x3f52f772, 0xbfbaf761, 0x3f825b28, 0xc03b3704,
    0xbeac91fb, 0xbfb9f4b2, 0xbff5bc66, 0xbf85ac5b,
    0xc0158827, 0xbfcffce9, 0xbf3ba048, 0x3dffbf8d,
    0xc050ddeb, 0xbf46bd5b, 0xc0560ea7, 0xbeae0d82,
    0xbf4a9d86, 0xc03f6f8b, 0x4044db1e, 0xc0619876,
    0x3fafd4a9, 0xc0697965, 0x402de68b, 0xbf467342,
    0xbfa826cc, 0xc026d9b2, 0x3f46eee6, 0x3f23777d,
    0x3ea6abff, 0x4055783a, 0x3fbec379, 0xbfe35ebc,
    0xbfa9c71b, 0xbeff7857, 0x3f78afc2, 0x4025b3b1,
    0xc0187b90, 0x3f8b53b7, 0x3e0e248e, 0xbfd68ac5,
    0x400c78c0, 0xc00e1afb, 0xc0399a18, 0x3fc81819,
    0x3f9ecb01, 0xbfa1e13b, 0x403569d8, 0x407a39c3,
    0xbe8c5f66, 0x405ec2de, 0xc042d298, 0x3fc131e5,
    0xbe5520f0, 0xbfc9ae2f, 0x40373705, 0xc098359e,
    0xbf042973, 0xc09fea92, 0xbb809b2f, 0xbf8769e9,
    0x3ff5e903, 0xc05a6447, 0xbf1d6d04, 0xbe8ec5a2,
    0xbf619e39, 0x40c66aff, 0x3f422b6b, 0x3d7792ef,
    0x401f73f4, 0xbe28cdc5, 0x3f5acd03, 0x3ed9e41f,
    0xc069cb4f, 0x3f7b06fa, 0x3f69f6b6, 0xc032813c,
    0xbff647be, 0x40400bb2, 0xbfc7f941, 0x3f392009,
    0x3f8a9890, 0x3fa21798, 0xbfb618f4, 0xbf55e312,
    0x408b841f, 0xbff6a4d5, 0x3dcf8010, 0x3fa7a935,
    0x3f114681, 0xc001d5b7, 0x3ffdf33b, 0x3d9f3531,
    0xc0015df0, 0xbf8e46c0, 0x3f92f500, 0x3f07ef2c,
    0xbf7c0df1, 0x3f1d4239, 0xbfa6b2dc, 0x3fa13af5,
    0xbe3dd0d9, 0x3f68def9, 0x408478d0, 0x3f7ec4f7,
    0xc00aab96, 0x407a7a73, 0x3f1897ac, 0xbfccacb1,
    0x3f2d6490, 0x3f09ab84, 0x401d0475, 0xbfd8e9bc,
    0x4097a7ff, 0xbf926023, 0x3f1a1975, 0xbe524e60,
    0xbf57ace8, 0xbfc503d8, 0x3e8b4dc3, 0x4020b7f8,
    0x3fb03bb9, 0x3e88871c, 0xbf0ebd7c, 0xbe3b4417,
    0xbe838e24, 0xc04bd2ae, 0xbff57628, 0x3e8309df,
    0xbfb4fc9e, 0xc02d8274, 0xbf658f6d, 0x40055e46,
    0xc02c84c4, 0x3f959353, 0x402cf5e1, 0xbf1aeccf,
    0xbf689c59, 0x3dcb9d77, 0x3f5073af, 0xbfdd9483,
    0x3ee3d564, 0xc0120229, 0xc00316ec, 0x3fa72d1a,
    0x3f8d0b8b, 0x3ef016bf, 0xbee1270c, 0x3fe9b151,
    0xc019cb31, 0xbf9491f4, 0xbf8d243a, 0xbf756f79,
    0x40856ab6, 0x3f1cb40d, 0xbf892f03, 0xc012dc90,
    0xbf777fd4, 0x40383bab, 0x40041b9c, 0xc0579636,
    0x4062e4b2, 0x3f940035, 0x3fcc7a38, 0x4032a085,
    0xc028cd9f, 0x3fd2fd45, 0x3fa5fc41, 0x3e987b4d,
    0x3e0f91a4, 0xbf80f1b2, 0xbfc80297, 0xbf236e59,
    0xbe52d34c, 0xbf159c3c, 0x400ccbf5, 0x4012bf06,
    0xbfad081c, 0xbef1ca2d, 0x3fbcca5e, 0x3ec620f5,
    0x4020465f, 0xbf4f08a8, 0xc01b9b1d, 0xbfb02ed2,
    0xbe95a0ac, 0xbefdf11a, 0x3fa1500a, 0x3e6b7735,
    0x4015db0e, 0xc0041ca5, 0x403f5c57, 0x3fb49081,
    0xbf4ed4b1, 0x3f6aa29f, 0xbea42d9a, 0x3e251176,
    0x3df7cb2c, 0x3f6ddb3c, 0xbe8c6952, 0xbf2f1608,
    0xbe9b50ad, 0xc04e2839, 0x3eb59890, 0xbfa70230,
    0x4037de14, 0xc0194709, 0x4052cc00, 0xc0d8fa0e,
    0xc048abcb, 0xbfd3fdfd, 0xc01c28c9, 0x3f0069d2,
    0xbe80c888, 0x40772444, 0x3ed8fbc0, 0x3f1572c5,
    0x3f8d9a0f, 0x3f18205a, 0x3e2ce9b7, 0xc09b32dd,
    0xbfb83a6c, 0x3ff36bc1, 0x403fbd5d, 0x3fe657b4,
    0xbf1cc43e, 0x3faa7bdf, 0xbff82fd8, 0x3fcf8a85,
    0xbf97dbfa, 0x3face3f4, 0x3d9df475, 0xbe93be3b,
    0x3efa5b0f, 0xbfb7c43e, 0x3f2a911b, 0x3f4bcd47,
    0xc0032009, 0xbfff71b3, 0xc08bae25, 0x40038815,
    0xc083c620, 0xc05897f2, 0xc071ec10, 0x402fbb57,
    0x40731bf4, 0x3efd1657, 0x3fa1492c, 0xc0341d78,
    0x3e99238a, 0x3e5ae111, 0x409b61cc, 0x40830f21,
    0xc07491f8, 0xbf8e06ea, 0x401c9ee5, 0x3fe2eab2,
    0x401474d4, 0x3faf29bb, 0x40090fe7, 0xbf6ba825,
    0xbfbab16d, 0x40537107, 0x3ff3dfe4, 0x3f24d8ea,
    0x402a31e3, 0xbe7e348b, 0x3f90f6f4, 0xc04472ae,
    0xc02de8bf, 0x40886ab7, 0x3ff6b06a, 0xbd80b5a4,
    0xbfb1fb23, 0x3ff45708, 0xbff60f29, 0xc022057a,
    0x400cf138, 0x405898f7, 0xc020831b, 0xbfe8eac7,
    0x4066ce62, 0x3f989548, 0xbe8fcbc9, 0x3f3a0cec,
    0x3ec1645a, 0x3e1c36f5, 0xbf69a14d, 0x401fbc59,
    0xbf901281, 0xbfbd8068, 0x3fbf20c6, 0xc075f435,
    0xbf3b6b66, 0x3fb4fe10, 0xbfe209c4, 0xc08e4cf2,
    0xc04c6f2e, 0x3fa172fb, 0xc088fcad, 0x3fb3e025,
    0x404dc69e, 0x3ff1b8b2, 0xc09fe9ee, 0x4006a9fe,
    0xbfb0dd72, 0x3f2ed68c, 0xbefcc121, 0xc09276f5,
    0xc02d8922, 0x3fcdef44, 0x400172b2, 0xc064b36a,
    0x3ecfa34e, 0xc085c2bf, 0xbefb11d9, 0x3fb48d75,
    0x3f765986, 0xbf31c4b4, 0xbfb0aa58, 0xbf579e94,
    0x3fd0a01f, 0xbf85cceb, 0xc0824c2b, 0x3f6a9c5d,
    0xbfd080af, 0xc0b0b153, 0xbfc3e0a4, 0xc0122e7a,
    0x40bfb48b, 0xc03d08e7, 0x40910ad4, 0xbf197362,
    0x3efed58a, 0x3f344b8e, 0xbfd57370, 0x3e5ad2f2,
    0x40a27a23, 0x3e1cc897, 0x401e9aa0, 0x3f5f0f7f,
    0xbf348a01, 0xc00a8dfa, 0xbfeb09ed, 0x3fa700e8,
    0x4064f721, 0x4083ee17, 0x40113c5b, 0x3f170a44,
    0x3f992b32, 0x40353670, 0xc036a80d, 0xc0e06305,
    0x3f07ae7c, 0x3f1d39f8, 0xbf9423b0, 0xbef36f6d,
    0xbfecaa35, 0x3f76d8e4, 0xc00c8bfb, 0xc0942801,
    0xc0638b1b, 0x3ebc36e4, 0x3ea3f4f1, 0x4001736a,
    0x4054d74b, 0x3e2afd7c, 0xc05528a4, 0x408dea7e,
    0x3fac421e, 0xbf428c6c, 0x3f8b048b, 0xbfb489db,
    0xbe96254b, 0x3fcace1c, 0xbfd1c2c9, 0x401ed6e1,
    0x3f45e68a, 0x3f751a99, 0x3fa64a33, 0xbf169cb5,
    0xbfc4306a, 0x4008f2ba, 0xbf94c84c, 0x3e81b5f1,
    0xbebe6804, 0x3ecb897e, 0xc036a33b, 0x3fa1a0af,
    0xc020d98c, 0xbf5c8a2c, 0x3e99d3bc, 0x3fbaa9dd,
    0x4000507f, 0xbfc0b569, 0x4094c758, 0xbf45a39f,
    0x3dc930d6, 0xbe3b306b, 0x4088c69f, 0xc0486218,
    0x3faf83db, 0x3f5ef27f, 0x3f8593a0, 0xbfdeb25e,
    0x40386550, 0xbfaf40b8, 0x3e124ce9, 0xbfab49b9,
    0x3feb7bee, 0x4047d420, 0x403e105b, 0x3f072e50,
    0xc01be010, 0xbff5dcf5, 0xc001361f, 0xc036e425,
    0xbe812636, 0xbcd62a3a, 0xbf52c7b2, 0x4056cfd4,
    0xc0317b59, 0xc02a40e9, 0xbf83388d, 0xbe13393a,
    0x400a5c4c, 0x3fdf2948, 0x4051c46e, 0x3fa1729d,
    0x3fc66cc4, 0xbf0664f2, 0x3f162119, 0x3d61db5d,
    0x3fb8d71d, 0xbf997812, 0xbf64c3b2, 0x3fe4a17f,
    0xbf5091f5, 0xbfa24c81, 0xc04e02bd, 0x40441791,
    0xbe6df45c, 0xbfcc4c28, 0x3e7c7ea6, 0x3f2c7385,
    0xbeb709b3, 0xbe9ecc94, 0x3fa36832, 0xbe2513f7,
    0xc0233252, 0xc0c653d9, 0x4031abb9, 0xbf09a10b,
    0xbfaf2dff, 0x3f48f645, 0x3f91becf, 0x3d2044e8,
    0xbfc0ae0f, 0xbfbc34bb, 0x406d16cc, 0x401c5e20,
    0xbe3e58d2, 0xbfd60d46, 0xbf51826e, 0x3f939529,
    0xc085313e, 0x40480d0d, 0x3f92f454, 0x3edd41f0,
    0x3f454f73, 0xbf189248, 0xc0b49d48, 0x40109399,
    0xbdcb03e5, 0x3d83374d, 0x3e24efd4, 0xc00f5c73,
    0x3f734d62, 0x3faa07b5, 0x3fdc0b69, 0x401e0656,
    0xbfd3630c, 0x3f9b91fe, 0xc081a68d, 0xbeabf974,
    0xc06c6f8b, 0xbea5badf, 0x3fc9abfd, 0xbeb3b06a,
    0x40189445, 0xc02ff7a4, 0x40308913, 0x401d8f32,
    0xc02c88a2, 0x3fcda5c7, 0x3fd9bfac, 0x3ea9d4e4,
    0x40d34ee1, 0xc00078a3, 0x404a3cbc, 0x4066cb18,
    0x3f932513, 0x3e84d5d8, 0x4091de28, 0x3f99e4c8,
    0xc0453ccc, 0x4028fc26, 0xbe62bbfe, 0x401655f2,
    0xbf02af1d, 0xc0089812, 0xc08da472, 0xbe833039,
    0x4094e609, 0x409ca890, 0xbf979a5e, 0xbf931613,
    0x3f5d1f81, 0xc0370cae, 0xbf094d0b, 0x40312faa,
    0x3fc10bc6, 0x3f232d93, 0x3eacb005, 0x3fb9a384,
    0x3f872058, 0x3ff55269, 0x3fd4ef6c, 0xbf11638c,
    0x3f844139, 0x3f7833a0, 0x40756668, 0xbe120c73,
    0xc03862f0, 0xbe9736b9, 0xc030ed11, 0xc09013a1,
    0x40c918f7, 0xbfa8a415, 0x3f8296c7, 0x3f8fa247,
    0x3f684616, 0xbfbf1639, 0x4028868d, 0xbf3a9d65,
    0xbd8f0a57, 0x402a3e3e, 0x3fc99b8a, 0xc02ba985,
    0xbfaddbec, 0xbe76bd77, 0x3fa23e39, 0x3f526b39,
    0x402a0a60, 0x3f607b02, 0xbf833b23, 0x3d7ddd1b,
    0x3f146f45, 0xc007f589, 0x4072a9ec, 0x40061a35,
    0xbfa291ed, 0xc0059b6a, 0x3f917eae, 0x40215532,
    0xbdf1239c, 0x3e20606c, 0x4022c9d9, 0x3eb912fa,
    0x400dd74b, 0x3f8cea66, 0x403ae9ed, 0xc018c2a8,
    0x3fa5f550, 0xbfad1b8e, 0xbf7f86f8, 0x4000b2cf,
    0xbff70e5c, 0xc02d760f, 0x3f59d3b2, 0x402401cf,
    0x3fcb035d, 0x40941b6c, 0xbf9f27c6, 0x40b43c69,
    0xc0008871, 0x3fb46cb5, 0xbe07b774, 0xbf07d513,
    0xbfc34f6b, 0xbe6151f9, 0xc0455595, 0xc0248990,
    0x404fcba9, 0x3f845139, 0x3f67565b, 0xbf933331,
    0x3fd545f8, 0x3cafbf7f, 0xc05f4e3b, 0xbff516a9,
    0xc014a65d, 0x4041e542, 0x3f16061d, 0x3f03200d,
    0x4078a6ea, 0x3dc6ff06, 0x3f94211c, 0x408c1f1e,
    0x3f0dad5b, 0xbfaf1b08, 0x402615ad, 0xbf9de981,
    0xc055c872, 0xbf4e6e7b, 0xbfc2c62c, 0xbfbb0c79,
    0x4023ff8c, 0x3e8c1072, 0x40364a7f, 0xc02fca17,
    0x405b591f, 0x3e023b9b, 0xc026f858, 0x3a47dc3e,
    0xbf2ba710, 0x405b5900, 0xbfc97eb7, 0xbecc02ce,
    0x3fd81f57, 0x4086581a, 0x3e574d56, 0x4052782a,
    0xbf6044cd, 0xc01beb8d, 0xbe1a97ff, 0x3f3dcd0f,
    0x401674e8, 0xbef8fde5, 0xc05e479a, 0xbf02c61f,
    0x3f6d3369, 0x3f638c1e, 0x3ea98a8a, 0xc0aaa70a,
    0x3f3957e6, 0x3f050deb, 0x4014077a, 0xbfe3c7c6,
    0x4010682f, 0x3fc97e6b, 0x3fd5f7b6, 0x3e05ff91,
    0xc094c173, 0xc0687baf, 0x4059a46c, 0xbec9e229,
    0x3f8ae906, 0x3f40cd80, 0xc08e2ffa, 0x3e4d88cd,
    0x400ddd4b, 0x3fab1fc3, 0xc07aeab4, 0x3f840b16,
    0xc0093713, 0xbde9eed3, 0xc00d1cfe, 0x3e81ae86,
    0x403c8d0e, 0x40263956, 0x3f92ad6b, 0xbf408f6c,
    0xbebe951e, 0x40016e4f, 0x3ee10801, 0x401b7e0b,
    0xbee30d7a, 0x3fe19ee0, 0xbe9b32ab, 0xbf0dd592,
    0xbfdc9a28, 0xbe88b0a1, 0xc070220f, 0xbda377a5,
    0xbfe56426, 0xc00674fb, 0x40366cf8, 0xbf63ea31,
    0xbfe49a77, 0x3e24ac08, 0xbf3394bc, 0xbf29509c,
    0xbeceb83c, 0x409c1fdf, 0x3eb11d75, 0xbf67f1d6,
    0xbec77c0e, 0x3fce54d5, 0x3fdf5c93, 0x3fa148f1,
    0x4085bfcf, 0xbefa61af, 0xbfc13529, 0x3f48bab8,
    0x40af493e, 0xbfb3bfb2, 0x3f862fa8, 0xc03b5b21,
    0x3f906836, 0x4010d936, 0xbf235d45, 0xbf9a71dd,
    0x4001c467, 0xbec86054, 0x408a13d4, 0x401f8116,
    0xc004d810, 0x3f4af80f, 0xbe10f445, 0xc0937076,
    0x3ff1f364, 0xc035c918, 0x4035464d, 0x3f817f3a,
    0x405fb0e0, 0x4040c78e, 0xbfc9df89, 0x3fc9b02f,
    0x3ec404b8, 0xbfee4ade, 0xbfcac17d, 0xc092d68d,
    0xc04e391f, 0xbfdb1528, 0xc0810313, 0xc0abdbac,
    0x3d33cf41, 0xc067d08c, 0xc02425af, 0x401a5ca6,
    0x3e6abb23, 0xbf20a714, 0x408daddb, 0x3ff9d8df,
    0xbe623b7a, 0xbf04be98, 0xbef79955, 0x40200324,
    0x3eed84b0, 0xbe874e0d, 0xc06ddf3c, 0xc018a2b7,
    0xc05af000, 0x3f21eeae, 0x401af614, 0xc0140cf9,
    0xc045b6fa, 0x3faccb72, 0x40840bd5, 0x40ab7fb3,
    0xbdf53c9d, 0x3f43e151, 0x409e6000, 0xbf654c2d,
    0x40411081, 0xbfba702d, 0x401a4cb4, 0xc01b4438,
    0x3ed4669f, 0xbf81e855, 0xc09f42ab, 0xbf6625b7,
    0x3fb9449a, 0xbef96784, 0x3fc00110, 0x3f4a049e,
    0xbfb3c7d5, 0x4000b362, 0x3e384bab, 0x3f1b6677,
    0xbf81adc0, 0xbff65019, 0x3c7a2c88, 0x3f73b99b,
    0x3efa45b1, 0xbff9b50b, 0x3f0ef6e4, 0xbf1fd431,
    0xbfcc162c, 0xc046d0d4, 0x408fe19f, 0xc038cb06,
    0xbf8564fa, 0xc0c1a029, 0xbf96b9e8, 0x3f563882,
    0x3f8b9a81, 0xc031ce6d, 0xc0267e58, 0xbeb1cc58,
    0xbf8c1b31, 0x3f6c3408, 0x3f2c5213, 0x3f2a2b5e,
    0xbf879fe1, 0xc00b116e, 0xc00777cd, 0x402903c0,
    0x40392157, 0xc04d9429, 0xbef74a53, 0xbc386d80,
    0xc038ce30, 0x4071943e, 0x3f45e7f8, 0xc081b837,
    0xbffc2114, 0xbf11b4e4, 0x40112583, 0x3fec904d,
    0x403db2af, 0xc007690d, 0x3fa006f3, 0xc0163293,
    0x3fb361bc, 0x3ffc848b, 0xc072b5d6, 0xbea0b8d8,
    0x4066e8f7, 0xbd5f5d81, 0xc06c61c8, 0x402577fc,
    0x3f847649, 0xc0906e0e, 0xbf34a217, 0xc02432ad,
    0xbf8f641e, 0xbfab17b7, 0x3d8a2705, 0x4067b372,
    0x3fb68d18, 0xbfd8e8b4, 0x40065ee7, 0xbefb1543,
    0xbf1a17b4, 0xbeb103d8, 0xbe89e1cf, 0xbef9c79f,
    0x3e206aa7, 0xbe64dc2e, 0x3f508c42, 0x3f88f496,
    0xc040d3ca, 0xbe0ac8a3, 0x3f9156bf, 0xbf45ba95,
    0xbe851067, 0xbf4e91cf, 0xbec111b7, 0x3f31195c,
    0x3e350c0c, 0xc01398c0, 0xbf39b1eb, 0x3f7d2324,
    0x3fbeea40, 0x3fddd326, 0xbfdcea64, 0xc03ac4d2,
    0xbfb047e2, 0x3f605dba, 0x3f841f82, 0x4045eb21,
    0xbb7efa02, 0x4060e70f, 0xbfde1d74, 0x4058e7ae,
    0xbf066279, 0xbfecbdea, 0x3fa91e95, 0x4032ea21,
    0xbfe1fa2e, 0x4091f09a, 0xbf10c391, 0xbfd2ae12,
    0xbf650433, 0x3f4e2ae2, 0x406fdb4b, 0x4000669c,
    0x3fd6c17c, 0x3f61bc06, 0xc090b35d, 0x3fc2d976,
    0x3f242a5e, 0xbf769944, 0x3f9153a2, 0x405da064,
    0xc01ec8f4, 0x3ff033c5, 0x4005878c, 0xbf4286dd,
    0xbf7a9f8a, 0x402ac31a, 0xbede8602, 0x3f83c372,
    0xbfd3558b, 0xc02195c6, 0x4037caa6, 0xc0b2f88c,
    0x3f11182d, 0x400bc3bb, 0xbebed3f4, 0xc024c78c,
    0x3fd8bf39, 0xbf87c11b, 0x407345a3, 0x3fd75467,
    0xbf9fab69, 0x3eb75bd3, 0x3ef7b216, 0xc0151d83,
    0xc096b6f1, 0x3fad6ae2, 0xc0d064f8, 0xbfe7fe4b,
    0x3ed2f032, 0x407c9d95, 0x3f620e3d, 0x3f2b47f5,
    0x3fda6cf0, 0x3ed57b8a, 0xc0173c42, 0xc004d7cb,
    0xc0922af1, 0x40158656, 0x3fcc825b, 0x40774689,
    0xbfc48d44, 0xc002ad9b, 0x3c9407b2, 0xc067a06d,
    0xc03f4897, 0xc049f961, 0xc02378fc, 0xc0525701,
    0xc095522a, 0xc05ad0af, 0xc0096849, 0x3fe4dc46,
    0x401804dc, 0xbf6b14ca, 0xc039c54a, 0x3f8dd9e3,
    0x401ecd5c, 0xbfbdd8a3, 0x405bd59b, 0x3ffdb32a,
    0xbecc662b, 0x44b337e2, 0x402a857e, 0x402b99ba,
    0x3f49b62a, 0x3f92a029, 0xbea2c193, 0xbfa51357,
    0x3feaa8d8, 0xbfeee233, 0xbfed1738, 0xbfff4a67,
    0x40455483, 0xc0112c00, 0xc06ccf7e, 0xbf021c66,
    0x4062d580, 0x3fd6e12d, 0x3f539394, 0xbe83891f,
    0x4080ea19, 0x4065bc66, 0x3de5cd27, 0xbd2d329f,
    0xbfbc9498, 0xbf9160bb, 0xc02dd049, 0x402b8961,
    0xc073ee96, 0x403772f0, 0xc03c9bf6, 0xbf8bde6d,
    0x4060296d, 0xbfdd76fa, 0x3fea2387, 0xc0150ef9,
    0xc00c7bc6, 0x40a4a903, 0x404b9968, 0x3f59aa45,
    0x3e9f8e40, 0x3f5667cf, 0x3e17674c, 0xbebbec0c,
    0xbfd1d8a4, 0x3fc38ddb, 0xc05d9e46, 0x4047440e,
    0xbfa24203, 0x4022efc3, 0x40662d1e, 0xc044267f,
    0xbd5dcf62, 0x402b6fae, 0xbfc68263, 0xc03b26de,
    0x40993052, 0x3f907d04, 0xc030ce85, 0x3f1329b8,
    0x409d8d20, 0xc0a10fc4, 0x3f9d3f5b, 0xbe5a698f,
    0xbf91bbbe, 0x3cc4f478, 0x3face735, 0xc02831a0,
    0xbf54897b, 0x3dbc9db2, 0x3ee893ca, 0x3f70e13b,
    0x4098c260, 0xc084e400, 0x3f2c4222, 0xbea33ec6,
    0x404db235, 0xbf9a61fe, 0x3f08a2be, 0xc058064d,
    0x4041af0b, 0xc021b633, 0xc02c4521, 0xbec4c823,
    0xbe53a7b7, 0x3f8b30a1, 0xc006b9be, 0x3fd34693,
    0xc05f26c3, 0xbf0aa7db, 0xc02990ac, 0x3f1d1b3e,
    0xbe8ecfdd, 0x3ed51908, 0x3eb921f8, 0xc093747f,
    0x3ef1cbf5, 0xbee82c5a, 0x3f0d5584, 0xbfca4094,
    0x3f36f7ed, 0xbfaa4166, 0xbfa9b34f, 0x40161e2f,
    0x3fc36731, 0x4054a150, 0x4045208c, 0xc0d4d245,
    0xc08c6f34, 0x404df366, 0xbe289b0d, 0x3f2b9b2b,
    0xc018e099, 0xc0c235ae, 0x400a049c, 0xc021d54d,
    0xbef9ab94, 0x3de9269b, 0xbeaca9c2, 0xbf24b7d1,
    0x3ede962a, 0xbefd9ffb, 0xc07b80cc, 0x40664d4d,
    0xc04c20bd, 0x4062bfeb, 0x3e0f573e, 0xbf94e0ec,
    0x3f8f599b, 0xbf091d1f, 0xbf5927e9, 0xbe950851,
    0xbf126134, 0xbf6a0b77, 0xbefe0cfa, 0xbf0e65d3,
    0xc01e86f4, 0xc02ffae3, 0x402aa9e1, 0xbe365b1c,
    0x3f054a72, 0x407cd210, 0x400c7269, 0x3ec6ff50,
    0xc0479630, 0xbf865701, 0xbf85ea5a, 0x3bd7178e,
    0xbf4487b7, 0xc02e5f81, 0xbf89cf53, 0xbfade231,
    0xbf0ce781, 0xbfa8fe9a, 0x3f9afdf6, 0xc022dc08,
    0x3ef85cd6, 0x3f3bb984, 0x3df68681, 0xbf89d69f,
    0x3f7e8ad2, 0x3fcb0c18, 0xbfbe32d3, 0xc0a0313b,
    0xc01c3143, 0x400e3da7, 0x3be2fbca, 0x40876975,
    0xc016da5c, 0x4087caec, 0x4074e110, 0xbfcdad72,
    0x3be627e8, 0xbf523c5b, 0x405f2db0, 0xbfae3769,
    0x404275cf, 0x3f845605, 0x3fd46c27, 0xbf14e6fe,
    0x3f6a4e41, 0xbfc41bc1, 0x4082b559, 0x3f92cf08,
    0xbfab3b8e, 0xbfbd0d53, 0x3ff81c09, 0x400c6bc0,
    0xbf19d394, 0x3f34d526, 0x3fe0c975, 0x3f7298df,
    0xc065822d, 0x3de757a3, 0xbff89637, 0xbeb00375,
    0x40505f4d, 0xbd45df15, 0xbf894855, 0x40637397,
    0xbfabf9e6, 0xbfd95843, 0xc0085f61, 0x3ff03f1d,
    0xbf045540, 0x40908ce4, 0xc03898fa, 0x3fa7ac5a,
    0x402e866e, 0xbfa01e8c, 0x3fa5034c, 0xbf82de65,
    0xc003dd19, 0xbf9ee3ab, 0x3f46c4c5, 0xbc68c1ac,
    0x3e1b3c76, 0x4042341b, 0x403dab55, 0x3e2cb267,
    0xc0acc2e6, 0xbff091c6, 0xbfa81b3f, 0x3fb6df49,
    0xbf59807e, 0x3ef4ff4c, 0xbfff0d8b, 0x3ed60a75,
    0xc01e92e9, 0xc035cc22, 0x3f8a467b, 0x4002b27b,
    0xbf9efe1d, 0xc05fb7a7, 0x3fa25d66, 0x3effa422,
    0xbf19facd, 0xc02db707, 0x3fe21212, 0x40a3ce09,
    0x400bbec9, 0x40ac5894, 0x40255006, 0x3fd178de,
    0xc08b2cf0, 0x404e22ca, 0xbf775f3d, 0xc09ea353,
    0xbef4af69, 0xc07ba3cc, 0xbd74e329, 0x3fe9368b,
    0x4083b2a8, 0xc01484ca, 0xc0204877, 0x3e5d2a3c,
    0x405937f0, 0xbf58f2fa, 0xbdb68b31, 0xbfa59b26,
    0xbfc92071, 0xc00a57ba, 0xc0009830, 0xbf9d8926,
    0xc0dc0c42, 0x3ac5dd42, 0xc0110dca, 0xc03a2006,
    0xc07888f2, 0x400c58cc, 0x3f6446e4, 0xbfab8407,
    0x401b0929, 0xbe81a98d, 0xbf67d5a6, 0xc02e839d,
    0xbe704f85, 0xbfaa90cf, 0x3d9bd6bd, 0xbf3f85aa,
    0xbee44ce2, 0x3bfc0060, 0x3da0a429, 0x3ff0392f,
    0x3f0da22a, 0xc0810edc, 0x3fe427de, 0xbfe175bb,
    0x3eeb2691, 0x3e2a7cb5, 0xc05fc7f8, 0x3f599b1f,
    0x3ffe6f8a, 0x3f80524c, 0x3e85ce11, 0x3f918837,
    0x3ef8f129, 0xc04bc103, 0xc026f76b, 0x3fba68b1,
    0x404278af, 0x4050de6a, 0x3eb389c8, 0xc01f2393,
    0xbfcf8461, 0x4020d198, 0x401ddd50, 0x3f6f3589,
    0xc09bbc2a, 0xbf1640dc, 0x3fd80cf6, 0xbf3ef5b8,
    0xbeb510cf, 0xbfa11316, 0xbfd0f133, 0x3dbbed2b,
    0xc08ed6bb, 0x3ff10ea6, 0x3f41486f, 0x402f3814,
    0xbfd04613, 0x3f67e471, 0x3f8889da, 0xbf6bc710,
    0x3fc595fb, 0xbfb97600, 0xc07e7d81, 0xbe9e6c4a,
    0xc06bbfe2, 0x3f9bb49f, 0x404988fc, 0x401cfc2f,
    0x3e1a7b7c, 0xbebf5575, 0xbfcbc4e4, 0xbff443d2,
    0xc0a29a5e, 0xbe6e149a, 0x405deb61, 0xbf14e4c8,
    0x3fb44d71, 0x3fcdd618, 0xbfcff37a, 0x3f189da6,
    0xc031236a, 0x3c938cfb, 0x40ae344d, 0xc0aea4e1,
    0x3e22e8e2, 0x402c7dbf, 0x40c981e7, 0xc003340e,
    0xbc7a9f0d, 0x3f9b10df, 0x3f79693e, 0xbf85fe9e,
    0x3f12ba69, 0x40b5304e, 0x4073b4ba, 0x4021a936,
    0xbfb59b4a, 0xbe53c1ed, 0xbfbd5544, 0x3f792871,
    0xbfdd3406, 0x4029d088, 0x404b41aa, 0x3fc9fb91,
    0xbf2dd9b8, 0xbea3388c, 0x3fc0cfda, 0x404bc049,
    0x3ddb153d, 0xbf176dfe, 0x4006f9cb, 0xbfb67a0c,
    0xbfda9dd1, 0x40415d5a, 0x4033c540, 0xbe6b5ba8,
    0x404dea36, 0x3e985654, 0x3f3d3286, 0x404c1763,
    0xbe05ee05, 0xc039d9af, 0x40173517, 0x3d87ae59,
    0xbf927bac, 0xbf7b9859, 0x402fe04e, 0xc087f9b9,
    0xbf8d7119, 0xc0aea64e, 0x3fa40fe7, 0xc08ea274,
    0xc0109522, 0x4053bd66, 0x3e5d7602, 0xbfb7607b,
    0x3c756119, 0xc023cc31, 0x40819380, 0x3f76bd6c,
    0x3fc1c969, 0xbfea9e20, 0x408c9014, 0x3d18901c,
    0x40650af1, 0xbf5f73a1, 0xbf26563b, 0x408f5090,
    0xc08d34c6, 0x40a84589, 0xbfc7ee41, 0x3fa226d3,
    0x40699f55, 0x405fabff, 0xbf43e5ea, 0xbf066c78,
    0xbf362100, 0x4059cdb3, 0x404cbdf5, 0x3ff1e7a3,
    0x40035f39, 0x4003dbe9, 0x3d942979, 0x400a062f,
    0x3e8caefc, 0xbfc99da9, 0x401c7833, 0x40540386,
    0x3f6d3728, 0xbf97868c, 0x3ebda21f, 0x403a016b,
    0x3f02363c, 0x4017d85b, 0x3f998620, 0x3f947431,
    0xc08f5f00, 0xc0358996, 0x40349738, 0xbf618673,
    0x3f9c7323, 0xc08caaf4, 0x3f6d8c76, 0x3f1a0be1,
    0x3f57d0b8, 0xbffa78d3, 0x3f9ab60d, 0xc01bdb0a,
    0x3ffc9e44, 0xbdded34a, 0x401dd0a5, 0x3f2959ee,
    0xc08802d7, 0x3f01095d, 0x3f28b3f0, 0x3fdc076d,
    0xc0802e03, 0xbfd25f61, 0x40c87db1, 0x404b4618,
    0xc01d03b7, 0x3e98f223, 0xc009e763, 0x3f3628fa,
    0xbfebdb57, 0xc0a59de0, 0x3fb1faf4, 0x4000c9e9,
    0xbf279e2d, 0xc01dff12, 0xc00f453a, 0x3f0d7631,
    0xbf69a8a9, 0xc09900b4, 0x4023e1c5, 0xbfdf48b1,
    0x401b5cb6, 0x3f779dff, 0x3f447864, 0xbfcbb8b8,
    0xbf7b044d, 0xbf615cf5, 0xbfac5f8a, 0xbf9115ad,
    0xbf3c4d5e, 0x4027c773, 0xc0716388, 0x40327fff,
    0xbfd6496a, 0x3e0c606a, 0x400f8a63, 0x3eba04c3,
    0x3f559e4b, 0xbdf09a62, 0x3ebc7ce8, 0x4037c16b,
    0xc04bbed7, 0xc03411b5, 0x3e9e6fc5, 0x3d249f07,
    0xc001dafe, 0xc01dfe73, 0x3fe3f942, 0x3f520903,
    0x3fce5217, 0x3ecd52c4, 0xbfcd744b, 0x3fcbe8a1,
    0xbf8e3c15, 0x4012059c, 0x4025bcf3, 0xbedae4bc,
    0x3fd77d0c, 0x3f88367a, 0x40757c18, 0x3fa35ef6,
    0x3fa76081, 0xc0118f29, 0xbf043b09, 0xbf6eaaf8,
    0xbf2401da, 0x3fd90619, 0xbebb852f, 0x3fb92920,
    0x3e249c73, 0xbfc9b565, 0x3ef0e105, 0xc0618a46,
    0x401f85e9, 0xbe9c3330, 0x3eb959b7, 0xbe7d8684,
    0x4031926c, 0xbea3c016, 0xc00b3e2b, 0xc0b61200,
    0x3ff3e296, 0x406f7ca4, 0xbe553c73, 0x409bc07b,
    0xbf451c6b, 0x3fc9505a, 0x3ec82c42, 0xc0554b1e,
    0x3ee5524e, 0xbf1f14b8, 0xbec00f9c, 0xc0224879,
    0x4000e7cc, 0x3e42c3e9, 0xbf25c8df, 0x400463b9,
    0x40b9d87c, 0x3f86d541, 0xc030fb62, 0x3fedeb43,
    0xc0364c5b, 0xbf23d48f, 0x40096355, 0xbf13309e,
    0x3f847b2e, 0xc047fb5b, 0x408efe38, 0x3f1cf6c8,
    0x3f19b72c, 0x3eb6e954, 0xbf52bd28, 0xc0446ce5,
    0xbf378319, 0x4008bf8f, 0x3f8bc854, 0x3f954fe2,
    0xbf612215, 0xc02d48ea, 0xc0088c1f, 0x40d5d850,
    0x3e9ce650, 0xbf26fdf8, 0x4006711f, 0x3fa26b41,
    0x4007c749, 0x4087f2f4, 0x404e22a8, 0xbd83b5b5,
    0xc01339ec, 0xbfa89ef2, 0xc0130e1c, 0xc0818992,
    0xc02ef476, 0x4033f486, 0x3ff84b45, 0xc00b9bb4,
    0xbf504050, 0xbf433f8b, 0x402e8eed, 0x3f63b5a2,
    0x3fb135a1, 0x3e857a0c, 0xbfc7b144, 0x3f00c53c,
    0xc04bea8a, 0x40495068, 0xbea36184, 0x3ff7a42d,
    0x40b2bcf1, 0x404fe976, 0xbfee2246, 0x3fb04813,
    0x3ff471e4, 0x3e10b6cc, 0xbf72f131, 0x3fe1c2c5,
    0xc025b3fd, 0xc029bd9a, 0xc037f447, 0xbfccccf0,
    0xbf85ab8e, 0x3f8cfb52, 0x402c6bba, 0xc01c4a93,
    0x3ff74863, 0xbfa9b65f, 0x3fd1c7a6, 0x404af94b,
    0xc023796e, 0xc022c6d6, 0x4030ddeb, 0xbfb86612,
    0x403d0b34, 0x4022f985, 0xbff473f8, 0xbeb361a1,
    0xbf9f0b86, 0xbfbc692d, 0xc01646a3, 0x4017917e,
    0x3fee6f06, 0x40660984, 0xc010f1f2, 0x3f97c9d9,
    0xbd945490, 0x3fbee472, 0xc0421fb6, 0x401e1901,
    0x40100dc9, 0xbff53447, 0xbfc6de70, 0x404be378,
    0x401d0305, 0xbfa1a3a4, 0x403e67c2, 0xbf9bf01d,
    0x3fdcd3f2, 0x400f888b, 0xbf7c4320, 0xc0870802,
    0x3fad726f, 0x3faced0d, 0x40191149, 0xbf086d07,
    0xbf4b7462, 0x3fc10f09, 0xc03161f8, 0xc06ab643,
    0xc04bac74, 0x3fdeaa43, 0x3ec4e369, 0x406c17b0,
    0xc0198381, 0xbe1fec7c, 0x3f948026, 0x401a0b0c,
    0xbeac7acd, 0xbf2cee4c, 0x3ffb04af, 0x40f74b76,
    0xbf838a25, 0xbf75632b, 0xbff19fa2, 0x4004ffc7,
    0x40b1ecaa, 0xbeec9a07, 0x400e4551, 0x3e840cdc,
    0x406077fe, 0x3dc39453, 0x3e0ce363, 0xbd793111,
    0xbfec0c9f, 0xc03088c7, 0xc0558bf1, 0x4097765a,
    0xbea96e93, 0x3ef67780, 0x3fa9f349, 0x3f2cc1c9,
    0x4020f3b0, 0x3e0087dc, 0xbf86414c, 0x3ef056d1,
    0x401fc7cf, 0x4062a0fa, 0x3fe868c4, 0x402e7536,
    0x408cb188, 0xc05a36c4, 0x401814d6, 0x3f4b0cf1,
    0xbd4a5c60, 0xc041065e, 0x3ed5e13b, 0xc03524e7,
    0x3fd7139e, 0x3fb1ca9e, 0xbf886095, 0x3daa58e2,
    0x3fc18cea, 0xbf4042f6, 0xc03c9419, 0xc0321186,
    0xc0cc7618, 0x3f954f59, 0xbfb8d9e6, 0x4003c544,
    0xbf1c1d2e, 0xbf3576b6, 0x3ede56ee, 0xc069929d,
    0xc00529ca, 0xbfd2ea76, 0x3e87f748, 0xc04419cf,
    0xc0806bc7, 0x4041cae1, 0x3e4666e9, 0x402fea18,
    0x4059b5bb, 0x3fafb712, 0x3e6e5630, 0x3fe2694e,
    0x3f875733, 0xc09d8bd7, 0x3e98bd2b, 0x3e73b92b,
    0x3f06c691, 0xbf25be66, 0x3fada384, 0x3e700283,
    0xbf8c8348, 0xc067b404, 0xbe11eb2d, 0x3d76d993,
    0xc0010108, 0xc069abc2, 0x3ed91094, 0x3f2119b1,
    0xbff3e401, 0xbfb1e2e3, 0xbf876e29, 0x3fe60ec7,
    0xc0bf6a3a, 0xbfc07820, 0xbfe22276, 0x3ed83732,
    0x3f1b718b, 0xc09795bb, 0xbf0974d0, 0x3ebaad9d,
    0x40002464, 0x3fda113c, 0x402132f7, 0x3ffde7b9,
    0xc09075c8, 0xc0003a77, 0xbf9f4c68, 0xbd05ef33,
    0xbe5a3ca5, 0x40ae24ee, 0x3fd4c486, 0xc01dcc9f,
    0x3ffef090, 0xc09e03c0, 0xbf6c3793, 0x3f035dab,
    0x40094096, 0xbe6059d6, 0x40b35f11, 0x404d916d,
    0xc0215cd3, 0xbf469a40, 0xc0109681, 0xc0acdbc9,
    0x3fd99f21, 0x3dfecee9, 0xbff17215, 0x40481e87,
    0x3f5d0bb4, 0x3f413a5a, 0x3fb94369, 0xbef24b90,
    0xbfb8b8ba, 0x3f6cb8c8, 0x4016fe5c, 0x3f59ee16,
    0x404f4983, 0x3f2e4010, 0xc01d50b0, 0x408b0672,
    0x4002ffda, 0x3c59b05a, 0x3f57fb2f, 0xbf4b4cf4,
    0x4024fe01, 0x3f1c3278, 0x3ef062bd, 0xbe34cf9e,
    0x3f82f8ca, 0x402eda1d, 0x3f50878b, 0x3f456a15,
    0xbf578295, 0xbfe9e6c0, 0x3f8e7348, 0xc087a0a5,
    0x3f112e08, 0x3f09742b, 0x40008a39, 0x3d5751c3,
    0xc0afabbe, 0xbec14e5a, 0xc0398360, 0x3eac52b5,
    0x3fe38103, 0xbf22b700, 0xbf186475, 0xc06c8ca7,
    0x3f4d8f69, 0x4023c520, 0x3f05dc01, 0xbe9d8eb3,
    0x3f965b26, 0xbfa612b4, 0x4028dce6, 0xc0063959,
    0xc0876ea8, 0x3f9d972f, 0xc06a2854, 0x40a9140c,
    0xc07e1e39, 0xc0021e70, 0x403cd5c4, 0x3fd02abd,
    0xbf0edbc6, 0x4034a4d9, 0x3f1285ab, 0x408e6092,
    0xc007e9d0, 0x3e1b815e, 0xbf9cf28e, 0xc00fb2d1,
    0x40193e5c, 0x3fa68b0b, 0x3f51a5eb, 0xbfbb7576,
    0x4084e4f8, 0x4085d1bc, 0x3f5a82c2, 0x3f5fc1d7,
    0x3fe2272e, 0x3fbf55b8, 0x4025d8c4, 0xbf4b2c6a,
    0x40970e51, 0xbfc3c6f7, 0xc07270da, 0x3f1b03aa,
    0x40335c82, 0xc08dfe0a, 0x3f874a04, 0xbf1c2ef7,
    0xbff294ed, 0x3fc8aa0b, 0x4011e266, 0xc028d553,
    0xbf71d19d, 0xc082801a, 0x3f91d845, 0x401a8bbd,
    0xbefb1a5d, 0xbe41914f, 0x40534d4f, 0xc00a400c,
    0xc04daca1, 0x404e1fe2, 0x3ff12b2e, 0x4032ec61,
    0xbf9b2edc, 0xc07bf411, 0x3cddeddf, 0xbf85104d,
    0x3fa6427a, 0xbdee4bd0, 0x3f752c6a, 0x3f46150b,
    0x3e8ec258, 0x3d76d595, 0x3fad7aa7, 0xbf2bcfb2,
    0x3fd7c5ae, 0xbf3d9519, 0xbf223723, 0x4010af68,
    0xbf9acf82, 0xbfbe22d8, 0xbf281b10, 0x40438388,
    0xbfd10231, 0xbe617ec9, 0x3f3717be, 0xbf0d2636,
    0x3fbbdb71, 0xbcca08ae, 0xc0635a78, 0xbf959dbd,
    0x4022b3f4, 0xbfc552f2, 0x4074654b, 0x3fdd235c,
    0xbfaece40, 0x3f6a9ef8, 0x3e5807fd, 0xc0a148fb,
    0xbf79fcfd, 0x4048851d, 0xbccd6426, 0x3fbe2612,
    0x4067b3a4, 0x401f9497, 0xc04b7f06, 0x40c35caa,
    0xc0bb3249, 0x401a5f9a, 0x3fb712ba, 0x407dcca7,
    0x3fece2c7, 0xc05ed0b1, 0x3f5c005c, 0x409552bd,
    0xc011f52a, 0xbfc66320, 0xbc03fc0c, 0xbf8d0942,
    0x3f9ef6a2, 0xbff13f7e, 0x3fbc3b66, 0x400a000f,
    0xc036fd5d, 0x3e52e819, 0xbfac38ae, 0x402f6ad8,
    0xbf1c12e6, 0xbf1e162b, 0x3f9c0f2c, 0xc049cd74,
    0x3cc61833, 0xc02007b3, 0xc0b631ed, 0xc0ad666e,
    0xbf8e474a, 0xc0969740, 0x404a2e0d, 0x408773fa,
    0xbfa8a8a7, 0xc0118498, 0xbf186563, 0x407d9ef5,
    0xbff7905c, 0x3f4eb929, 0xbf591607, 0x4010683d,
    0x404cc37c, 0x3e58b9c8, 0xbe805d3d, 0xc013afef,
    0x40134fef, 0xbe2ba4bc, 0x3eb75362, 0x4032e304,
    0xbfe51b44, 0xc0a4adab, 0x3f9497d7, 0xbedb6e24,
    0xbfa062f7, 0xc07cb682, 0x3f11f43e, 0xbf196005,
    0x3ff715d0, 0xbf3e7ebb, 0x3f6b18cb, 0x3fbcc874,
    0xc087edfb, 0xc00fd45c, 0xbfa79273, 0x40391e4a,
    0x405f8667, 0x3ea3dc41, 0xbfe86e39, 0xbd9e5ae9,
    0x3dce47e8, 0xc0665796, 0xbf2ff55b, 0xbf7c747f,
    0xc05876a6, 0xc05c887b, 0x3fe3d204, 0xc01a1254,
    0x3fe4bda6, 0xc065197a, 0x402312b0, 0x40c98506
    };

static const uint32_t ref_cfft_noisy_4096[8192] = {
    0x4083c2dd, 0x0, 0x402312b0, 0xc0c98506,
    0x3fe4bda6, 0x4065197a, 0x3fe3d204, 0x401a1254,
    0xc05876a6, 0x405c887b, 0xbf2ff55b, 0x3f7c747f,
    0x3dce47e8, 0x40665796, 0xbfe86e39, 0x3d9e5ae9,
    0x405f8667, 0xbea3dc41, 0xbfa79273, 0xc0391e4a,
    0xc087edfb, 0x400fd45c, 0x3f6b18cb, 0xbfbcc874,
    0x3ff715d0, 0x3f3e7ebb, 0x3f11f43e, 0x3f196005,
    0xbfa062f7, 0x407cb682, 0x3f9497d7, 0x3edb6e24,
    0xbfe51b44, 0x40a4adab, 0x3eb75362, 0xc032e304,
    0x40134fef, 0x3e2ba4bc, 0xbe805d3d, 0x4013afef,
    0x404cc37c, 0xbe58b9c8, 0xbf591607, 0xc010683d,
    0xbff7905c, 0xbf4eb929, 0xbf186563, 0xc07d9ef5,
    0xbfa8a8a7, 0x40118498, 0x404a2e0d, 0xc08773fa,
    0xbf8e474a, 0x40969740, 0xc0b631ed, 0x40ad666e,
    0x3cc61833, 0x402007b3, 0x3f9c0f2c, 0x4049cd74,
    0xbf1c12e6, 0x3f1e162b, 0xbfac38ae, 0xc02f6ad8,
    0xc036fd5d, 0xbe52e819, 0x3fbc3b66, 0xc00a000f,
    0x3f9ef6a2, 0x3ff13f7e, 0xbc03fc0c, 0x3f8d0942,
    0xc011f52a, 0x3fc66320, 0x3f5c005c, 0xc09552bd,
    0x3fece2c7, 0x405ed0b1, 0x3fb712ba, 0xc07dcca7,
    0xc0bb3249, 0xc01a5f9a, 0xc04b7f06, 0xc0c35caa,
    0x4067b3a4, 0xc01f9497, 0xbccd6426, 0xbfbe2612,
    0xbf79fcfd, 0xc048851d, 0x3e5807fd, 0x40a148fb,
    0xbfaece40, 0xbf6a9ef8, 0x4074654b, 0xbfdd235c,
    0x4022b3f4, 0x3fc552f2, 0xc0635a78, 0x3f959dbd,
    0x3fbbdb71, 0x3cca08ae, 0x3f3717be, 0x3f0d2636,
    0xbfd10231, 0x3e617ec9, 0xbf281b10, 0xc0438388,
    0xbf9acf82, 0x3fbe22d8, 0xbf223723, 0xc010af68,
    0x3fd7c5ae, 0x3f3d9519, 0x3fad7aa7, 0x3f2bcfb2,
    0x3e8ec258, 0xbd76d595, 0x3f752c6a, 0xbf46150b,
    0x3fa6427a, 0x3dee4bd0, 0x3cddeddf, 0x3f85104d,
    0xbf9b2edc, 0x407bf411, 0x3ff12b2e, 0xc032ec61,
    0xc04daca1, 0xc04e1fe2, 0x40534d4f, 0x400a400c,
    0xbefb1a5d, 0x3e41914f, 0x3f91d845, 0xc01a8bbd,
    0xbf71d19d, 0x4082801a, 0x4011e266, 0x4028d553,
    0xbff294ed, 0xbfc8aa0b, 0x3f874a04, 0x3f1c2ef7,
    0x40335c82, 0x408dfe0a, 0xc07270da, 0xbf1b03aa,
    0x40970e51, 0x3fc3c6f7, 0x4025d8c4, 0x3f4b2c6a,
    0x3fe2272e, 0xbfbf55b8, 0x3f5a82c2, 0xbf5fc1d7,
    0x4084e4f8, 0xc085d1bc, 0x3f51a5eb, 0x3fbb7576,
    0x40193e5c, 0xbfa68b0b, 0xbf9cf28e, 0x400fb2d1,
    0xc007e9d0, 0xbe1b815e, 0x3f1285ab, 0xc08e6092,
    0xbf0edbc6, 0xc034a4d9, 0x403cd5c4, 0xbfd02abd,
    0xc07e1e39, 0x40021e70, 0xc06a2854, 0xc0a9140c,
    0xc0876ea8, 0xbf9d972f, 0x4028dce6, 0x40063959,
    0x3f965b26, 0x3fa612b4, 0x3f05dc01, 0x3e9d8eb3,
    0x3f4d8f69, 0xc023c520, 0xbf186475, 0x406c8ca7,
    0x3fe38103, 0x3f22b700, 0xc0398360, 0xbeac52b5,
    0xc0afabbe, 0x3ec14e5a, 0x40008a39, 0xbd5751c3,
    0x3f112e08, 0xbf09742b, 0x3f8e7348, 0x4087a0a5,
    0xbf578295, 0x3fe9e6c0, 0x3f50878b, 0xbf456a15,
    0x3f82f8ca, 0xc02eda1d, 0x3ef062bd, 0x3e34cf9e,
    0x4024fe01, 0xbf1c3278, 0x3f57fb2f, 0x3f4b4cf4,
    0x4002ffda, 0xbc59b05a, 0xc01d50b0, 0xc08b0672,
    0x404f4983, 0xbf2e4010, 0x4016fe5c, 0xbf59ee16,
    0xbfb8b8ba, 0xbf6cb8c8, 0x3fb94369, 0x3ef24b90,
    0x3f5d0bb4, 0xbf413a5a, 0xbff17215, 0xc0481e87,
    0x3fd99f21, 0xbdfecee9, 0xc0109681, 0x40acdbc9,
    0xc0215cd3, 0x3f469a40, 0x40b35f11, 0xc04d916d,
    0x40094096, 0x3e6059d6, 0xbf6c3793, 0xbf035dab,
    0x3ffef090, 0x409e03c0, 0x3fd4c486, 0x401dcc9f,
    0xbe5a3ca5, 0xc0ae24ee, 0xbf9f4c68, 0x3d05ef33,
    0xc09075c8, 0x40003a77, 0x402132f7, 0xbffde7b9,
    0x40002464, 0xbfda113c, 0xbf0974d0, 0xbebaad9d,
    0x3f1b718b, 0x409795bb, 0xbfe22276, 0xbed83732,
    0xc0bf6a3a, 0x3fc07820, 0xbf876e29, 0xbfe60ec7,
    0xbff3e401, 0x3fb1e2e3, 0x3ed91094, 0xbf2119b1,
    0xc0010108, 0x4069abc2, 0xbe11eb2d, 0xbd76d993,
    0xbf8c8348, 0x4067b404, 0x3fada384, 0xbe700283,
    0x3f06c691, 0x3f25be66, 0x3e98bd2b, 0xbe73b92b,
    0x3f875733, 0x409d8bd7, 0x3e6e5630, 0xbfe2694e,
    0x4059b5bb, 0xbfafb712, 0x3e4666e9, 0xc02fea18,
    0xc0806bc7, 0xc041cae1, 0x3e87f748, 0x404419cf,
    0xc00529ca, 0x3fd2ea76, 0x3ede56ee, 0x4069929d,
    0xbf1c1d2e, 0x3f3576b6, 0xbfb8d9e6, 0xc003c544,
    0xc0cc7618, 0xbf954f59, 0xc03c9419, 0x40321186,
    0x3fc18cea, 0x3f4042f6, 0xbf886095, 0xbdaa58e2,
    0x3fd7139e, 0xbfb1ca9e, 0x3ed5e13b, 0x403524e7,
    0xbd4a5c60, 0x4041065e, 0x401814d6, 0xbf4b0cf1,
    0x408cb188, 0x405a36c4, 0x3fe868c4, 0xc02e7536,
    0x401fc7cf, 0xc062a0fa, 0xbf86414c, 0xbef056d1,
    0x4020f3b0, 0xbe0087dc, 0x3fa9f349, 0xbf2cc1c9,
    0xbea96e93, 0xbef67780, 0xc0558bf1, 0xc097765a,
    0xbfec0c9f, 0x403088c7, 0x3e0ce363, 0x3d793111,
    0x406077fe, 0xbdc39453, 0x400e4551, 0xbe840cdc,
    0x40b1ecaa, 0x3eec9a07, 0xbff19fa2, 0xc004ffc7,
    0xbf838a25, 0x3f75632b, 0x3ffb04af, 0xc0f74b76,
    0xbeac7acd, 0x3f2cee4c, 0x3f948026, 0xc01a0b0c,
    0xc0198381, 0x3e1fec7c, 0x3ec4e369, 0xc06c17b0,
    0xc04bac74, 0xbfdeaa43, 0xc03161f8, 0x406ab643,
    0xbf4b7462, 0xbfc10f09, 0x40191149, 0x3f086d07,
    0x3fad726f, 0xbfaced0d, 0xbf7c4320, 0x40870802,
    0x3fdcd3f2, 0xc00f888b, 0x403e67c2, 0x3f9bf01d,
    0x401d0305, 0x3fa1a3a4, 0xbfc6de70, 0xc04be378,
    0x40100dc9, 0x3ff53447, 0xc0421fb6, 0xc01e1901,
    0xbd945490, 0xbfbee472, 0xc010f1f2, 0xbf97c9d9,
    0x3fee6f06, 0xc0660984, 0xc01646a3, 0xc017917e,
    0xbf9f0b86, 0x3fbc692d, 0xbff473f8, 0x3eb361a1,
    0x403d0b34, 0xc022f985, 0x4030ddeb, 0x3fb86612,
    0xc023796e, 0x4022c6d6, 0x3fd1c7a6, 0xc04af94b,
    0x3ff74863, 0x3fa9b65f, 0x402c6bba, 0x401c4a93,
    0xbf85ab8e, 0xbf8cfb52, 0xc037f447, 0x3fccccf0,
    0xc025b3fd, 0x4029bd9a, 0xbf72f131, 0xbfe1c2c5,
    0x3ff471e4, 0xbe10b6cc, 0xbfee2246, 0xbfb04813,
    0x40b2bcf1, 0xc04fe976, 0xbea36184, 0xbff7a42d,
    0xc04bea8a, 0xc0495068, 0xbfc7b144, 0xbf00c53c,
    0x3fb135a1, 0xbe857a0c, 0x402e8eed, 0xbf63b5a2,
    0xbf504050, 0x3f433f8b, 0x3ff84b45, 0x400b9bb4,
    0xc02ef476, 0xc033f486, 0xc0130e1c, 0x40818992,
    0xc01339ec, 0x3fa89ef2, 0x404e22a8, 0x3d83b5b5,
    0x4007c749, 0xc087f2f4, 0x4006711f, 0xbfa26b41,
    0x3e9ce650, 0x3f26fdf8, 0xc0088c1f, 0xc0d5d850,
    0xbf612215, 0x402d48ea, 0x3f8bc854, 0xbf954fe2,
    0xbf378319, 0xc008bf8f, 0xbf52bd28, 0x40446ce5,
    0x3f19b72c, 0xbeb6e954, 0x408efe38, 0xbf1cf6c8,
    0x3f847b2e, 0x4047fb5b, 0x40096355, 0x3f13309e,
    0xc0364c5b, 0x3f23d48f, 0xc030fb62, 0xbfedeb43,
    0x40b9d87c, 0xbf86d541, 0xbf25c8df, 0xc00463b9,
    0x4000e7cc, 0xbe42c3e9, 0xbec00f9c, 0x40224879,
    0x3ee5524e, 0x3f1f14b8, 0x3ec82c42, 0x40554b1e,
    0xbf451c6b, 0xbfc9505a, 0xbe553c73, 0xc09bc07b,
    0x3ff3e296, 0xc06f7ca4, 0xc00b3e2b, 0x40b61200,
    0x4031926c, 0x3ea3c016, 0x3eb959b7, 0x3e7d8684,
    0x401f85e9, 0x3e9c3330, 0x3ef0e105, 0x40618a46,
    0x3e249c73, 0x3fc9b565, 0xbebb852f, 0xbfb92920,
    0xbf2401da, 0xbfd90619, 0xbf043b09, 0x3f6eaaf8,
    0x3fa76081, 0x40118f29, 0x40757c18, 0xbfa35ef6,
    0x3fd77d0c, 0xbf88367a, 0x4025bcf3, 0x3edae4bc,
    0xbf8e3c15, 0xc012059c, 0xbfcd744b, 0xbfcbe8a1,
    0x3fce5217, 0xbecd52c4, 0x3fe3f942, 0xbf520903,
    0xc001dafe, 0x401dfe73, 0x3e9e6fc5, 0xbd249f07,
    0xc04bbed7, 0x403411b5, 0x3ebc7ce8, 0xc037c16b,
    0x3f559e4b, 0x3df09a62, 0x400f8a63, 0xbeba04c3,
    0xbfd6496a, 0xbe0c606a, 0xc0716388, 0xc0327fff,
    0xbf3c4d5e, 0xc027c773, 0xbfac5f8a, 0x3f9115ad,
    0xbf7b044d, 0x3f615cf5, 0x3f447864, 0x3fcbb8b8,
    0x401b5cb6, 0xbf779dff, 0x4023e1c5, 0x3fdf48b1,
    0xbf69a8a9, 0x409900b4, 0xc00f453a, 0xbf0d7631,
    0xbf279e2d, 0x401dff12, 0x3fb1faf4, 0xc000c9e9,
    0xbfebdb57, 0x40a59de0, 0xc009e763, 0xbf3628fa,
    0xc01d03b7, 0xbe98f223, 0x40c87db1, 0xc04b4618,
    0xc0802e03, 0x3fd25f61, 0x3f28b3f0, 0xbfdc076d,
    0xc08802d7, 0xbf01095d, 0x401dd0a5, 0xbf2959ee,
    0x3ffc9e44, 0x3dded34a, 0x3f9ab60d, 0x401bdb0a,
    0x3f57d0b8, 0x3ffa78d3, 0x3f6d8c76, 0xbf1a0be1,
    0x3f9c7323, 0x408caaf4, 0x40349738, 0x3f618673,
    0xc08f5f00, 0x40358996, 0x3f998620, 0xbf947431,
    0x3f02363c, 0xc017d85b, 0x3ebda21f, 0xc03a016b,
    0x3f6d3728, 0x3f97868c, 0x401c7833, 0xc0540386,
    0x3e8caefc, 0x3fc99da9, 0x3d942979, 0xc00a062f,
    0x40035f39, 0xc003dbe9, 0x404cbdf5, 0xbff1e7a3,
    0xbf362100, 0xc059cdb3, 0xbf43e5ea, 0x3f066c78,
    0x40699f55, 0xc05fabff, 0xbfc7ee41, 0xbfa226d3,
    0xc08d34c6, 0xc0a84589, 0xbf26563b, 0xc08f5090,
    0x40650af1, 0x3f5f73a1, 0x408c9014, 0xbd18901c,
    0x3fc1c969, 0x3fea9e20, 0x40819380, 0xbf76bd6c,
    0x3c756119, 0x4023cc31, 0x3e5d7602, 0x3fb7607b,
    0xc0109522, 0xc053bd66, 0x3fa40fe7, 0x408ea274,
    0xbf8d7119, 0x40aea64e, 0x402fe04e, 0x4087f9b9,
    0xbf927bac, 0x3f7b9859, 0x40173517, 0xbd87ae59,
    0xbe05ee05, 0x4039d9af, 0x3f3d3286, 0xc04c1763,
    0x404dea36, 0xbe985654, 0x4033c540, 0x3e6b5ba8,
    0xbfda9dd1, 0xc0415d5a, 0x4006f9cb, 0x3fb67a0c,
    0x3ddb153d, 0x3f176dfe, 0x3fc0cfda, 0xc04bc049,
    0xbf2dd9b8, 0x3ea3388c, 0x404b41aa, 0xbfc9fb91,
    0xbfdd3406, 0xc029d088, 0xbfbd5544, 0xbf792871,
    0xbfb59b4a, 0x3e53c1ed, 0x4073b4ba, 0xc021a936,
    0x3f12ba69, 0xc0b5304e, 0x3f79693e, 0x3f85fe9e,
    0xbc7a9f0d, 0xbf9b10df, 0x40c981e7, 0x4003340e,
    0x3e22e8e2, 0xc02c7dbf, 0x40ae344d, 0x40aea4e1,
    0xc031236a, 0xbc938cfb, 0xbfcff37a, 0xbf189da6,
    0x3fb44d71, 0xbfcdd618, 0x405deb61, 0x3f14e4c8,
    0xc0a29a5e, 0x3e6e149a, 0xbfcbc4e4, 0x3ff443d2,
    0x3e1a7b7c, 0x3ebf5575, 0x404988fc, 0xc01cfc2f,
    0xc06bbfe2, 0xbf9bb49f, 0xc07e7d81, 0x3e9e6c4a,
    0x3fc595fb, 0x3fb97600, 0x3f8889da, 0x3f6bc710,
    0xbfd04613, 0xbf67e471, 0x3f41486f, 0xc02f3814,
    0xc08ed6bb, 0xbff10ea6, 0xbfd0f133, 0xbdbbed2b,
    0xbeb510cf, 0x3fa11316, 0x3fd80cf6, 0x3f3ef5b8,
    0xc09bbc2a, 0x3f1640dc, 0x401ddd50, 0xbf6f3589,
    0xbfcf8461, 0xc020d198, 0x3eb389c8, 0x401f2393,
    0x404278af, 0xc050de6a, 0xc026f76b, 0xbfba68b1,
    0x3ef8f129, 0x404bc103, 0x3e85ce11, 0xbf918837,
    0x3ffe6f8a, 0xbf80524c, 0xc05fc7f8, 0xbf599b1f,
    0x3eeb2691, 0xbe2a7cb5, 0x3fe427de, 0x3fe175bb,
    0x3f0da22a, 0x40810edc, 0x3da0a429, 0xbff0392f,
    0xbee44ce2, 0xbbfc0060, 0x3d9bd6bd, 0x3f3f85aa,
    0xbe704f85, 0x3faa90cf, 0xbf67d5a6, 0x402e839d,
    0x401b0929, 0x3e81a98d, 0x3f6446e4, 0x3fab8407,
    0xc07888f2, 0xc00c58cc, 0xc0110dca, 0x403a2006,
    0xc0dc0c42, 0xbac5dd42, 0xc0009830, 0x3f9d8926,
    0xbfc92071, 0x400a57ba, 0xbdb68b31, 0x3fa59b26,
    0x405937f0, 0x3f58f2fa, 0xc0204877, 0xbe5d2a3c,
    0x4083b2a8, 0x401484ca, 0xbd74e329, 0xbfe9368b,
    0xbef4af69, 0x407ba3cc, 0xbf775f3d, 0x409ea353,
    0xc08b2cf0, 0xc04e22ca, 0x40255006, 0xbfd178de,
    0x400bbec9, 0xc0ac5894, 0x3fe21212, 0xc0a3ce09,
    0xbf19facd, 0x402db707, 0x3fa25d66, 0xbeffa422,
    0xbf9efe1d, 0x405fb7a7, 0x3f8a467b, 0xc002b27b,
    0xc01e92e9, 0x4035cc22, 0xbfff0d8b, 0xbed60a75,
    0xbf59807e, 0xbef4ff4c, 0xbfa81b3f, 0xbfb6df49,
    0xc0acc2e6, 0x3ff091c6, 0x403dab55, 0xbe2cb267,
    0x3e1b3c76, 0xc042341b, 0x3f46c4c5, 0x3c68c1ac,
    0xc003dd19, 0x3f9ee3ab, 0x3fa5034c, 0x3f82de65,
    0x402e866e, 0x3fa01e8c, 0xc03898fa, 0xbfa7ac5a,
    0xbf045540, 0xc0908ce4, 0xc0085f61, 0xbff03f1d,
    0xbfabf9e6, 0x3fd95843, 0xbf894855, 0xc0637397,
    0x40505f4d, 0x3d45df15, 0xbff89637, 0x3eb00375,
    0xc065822d, 0xbde757a3, 0x3fe0c975, 0xbf7298df,
    0xbf19d394, 0xbf34d526, 0x3ff81c09, 0xc00c6bc0,
    0xbfab3b8e, 0x3fbd0d53, 0x4082b559, 0xbf92cf08,
    0x3f6a4e41, 0x3fc41bc1, 0x3fd46c27, 0x3f14e6fe,
    0x404275cf, 0xbf845605, 0x405f2db0, 0x3fae3769,
    0x3be627e8, 0x3f523c5b, 0x4074e110, 0x3fcdad72,
    0xc016da5c, 0xc087caec, 0x3be2fbca, 0xc0876975,
    0xc01c3143, 0xc00e3da7, 0xbfbe32d3, 0x40a0313b,
    0x3f7e8ad2, 0xbfcb0c18, 0x3df68681, 0x3f89d69f,
    0x3ef85cd6, 0xbf3bb984, 0x3f9afdf6, 0x4022dc08,
    0xbf0ce781, 0x3fa8fe9a, 0xbf89cf53, 0x3fade231,
    0xbf4487b7, 0x402e5f81, 0xbf85ea5a, 0xbbd7178e,
    0xc0479630, 0x3f865701, 0x400c7269, 0xbec6ff50,
    0x3f054a72, 0xc07cd210, 0x402aa9e1, 0x3e365b1c,
    0xc01e86f4, 0x402ffae3, 0xbefe0cfa, 0x3f0e65d3,
    0xbf126134, 0x3f6a0b77, 0xbf5927e9, 0x3e950851,
    0x3f8f599b, 0x3f091d1f, 0x3e0f573e, 0x3f94e0ec,
    0xc04c20bd, 0xc062bfeb, 0xc07b80cc, 0xc0664d4d,
    0x3ede962a, 0x3efd9ffb, 0xbeaca9c2, 0x3f24b7d1,
    0xbef9ab94, 0xbde9269b, 0x400a049c, 0x4021d54d,
    0xc018e099, 0x40c235ae, 0xbe289b0d, 0xbf2b9b2b,
    0xc08c6f34, 0xc04df366, 0x4045208c, 0x40d4d245,
    0x3fc36731, 0xc054a150, 0xbfa9b34f, 0xc0161e2f,
    0x3f36f7ed, 0x3faa4166, 0x3f0d5584, 0x3fca4094,
    0x3ef1cbf5, 0x3ee82c5a, 0x3eb921f8, 0x4093747f,
    0xbe8ecfdd, 0xbed51908, 0xc02990ac, 0xbf1d1b3e,
    0xc05f26c3, 0x3f0aa7db, 0xc006b9be, 0xbfd34693,
    0xbe53a7b7, 0xbf8b30a1, 0xc02c4521, 0x3ec4c823,
    0x4041af0b, 0x4021b633, 0x3f08a2be, 0x4058064d,
    0x404db235, 0x3f9a61fe, 0x3f2c4222, 0x3ea33ec6,
    0x4098c260, 0x4084e400, 0x3ee893ca, 0xbf70e13b,
    0xbf54897b, 0xbdbc9db2, 0x3face735, 0x402831a0,
    0xbf91bbbe, 0xbcc4f478, 0x3f9d3f5b, 0x3e5a698f,
    0x409d8d20, 0x40a10fc4, 0xc030ce85, 0xbf1329b8,
    0x40993052, 0xbf907d04, 0xbfc68263, 0x403b26de,
    0xbd5dcf62, 0xc02b6fae, 0x40662d1e, 0x4044267f,
    0xbfa24203, 0xc022efc3, 0xc05d9e46, 0xc047440e,
    0xbfd1d8a4, 0xbfc38ddb, 0x3e17674c, 0x3ebbec0c,
    0x3e9f8e40, 0xbf5667cf, 0x404b9968, 0xbf59aa45,
    0xc00c7bc6, 0xc0a4a903, 0x3fea2387, 0x40150ef9,
    0x4060296d, 0x3fdd76fa, 0xc03c9bf6, 0x3f8bde6d,
    0xc073ee96, 0xc03772f0, 0xc02dd049, 0xc02b8961,
    0xbfbc9498, 0x3f9160bb, 0x3de5cd27, 0x3d2d329f,
    0x4080ea19, 0xc065bc66, 0x3f539394, 0x3e83891f,
    0x4062d580, 0xbfd6e12d, 0xc06ccf7e, 0x3f021c66,
    0x40455483, 0x40112c00, 0xbfed1738, 0x3fff4a67,
    0x3feaa8d8, 0x3feee233, 0xbea2c193, 0x3fa51357,
    0x3f49b62a, 0xbf92a029, 0x402a857e, 0xc02b99ba,
    0xbecc662b, 0xc4b337e2, 0x405bd59b, 0xbffdb32a,
    0x401ecd5c, 0x3fbdd8a3, 0xc039c54a, 0xbf8dd9e3,
    0x401804dc, 0x3f6b14ca, 0xc0096849, 0xbfe4dc46,
    0xc095522a, 0x405ad0af, 0xc02378fc, 0x40525701,
    0xc03f4897, 0x4049f961, 0x3c9407b2, 0x4067a06d,
    0xbfc48d44, 0x4002ad9b, 0x3fcc825b, 0xc0774689,
    0xc0922af1, 0xc0158656, 0xc0173c42, 0x4004d7cb,
    0x3fda6cf0, 0xbed57b8a, 0x3f620e3d, 0xbf2b47f5,
    0x3ed2f032, 0xc07c9d95, 0xc0d064f8, 0x3fe7fe4b,
    0xc096b6f1, 0xbfad6ae2, 0x3ef7b216, 0x40151d83,
    0xbf9fab69, 0xbeb75bd3, 0x407345a3, 0xbfd75467,
    0x3fd8bf39, 0x3f87c11b, 0xbebed3f4, 0x4024c78c,
    0x3f11182d, 0xc00bc3bb, 0x4037caa6, 0x40b2f88c,
    0xbfd3558b, 0x402195c6, 0xbede8602, 0xbf83c372,
    0xbf7a9f8a, 0xc02ac31a, 0x4005878c, 0x3f4286dd,
    0xc01ec8f4, 0xbff033c5, 0x3f9153a2, 0xc05da064,
    0x3f242a5e, 0x3f769944, 0xc090b35d, 0xbfc2d976,
    0x3fd6c17c, 0xbf61bc06, 0x406fdb4b, 0xc000669c,
    0xbf650433, 0xbf4e2ae2, 0xbf10c391, 0x3fd2ae12,
    0xbfe1fa2e, 0xc091f09a, 0x3fa91e95, 0xc032ea21,
    0xbf066279, 0x3fecbdea, 0xbfde1d74, 0xc058e7ae,
    0xbb7efa02, 0xc060e70f, 0x3f841f82, 0xc045eb21,
    0xbfb047e2, 0xbf605dba, 0xbfdcea64, 0x403ac4d2,
    0x3fbeea40, 0xbfddd326, 0xbf39b1eb, 0xbf7d2324,
    0x3e350c0c, 0x401398c0, 0xbec111b7, 0xbf31195c,
    0xbe851067, 0x3f4e91cf, 0x3f9156bf, 0x3f45ba95,
    0xc040d3ca, 0x3e0ac8a3, 0x3f508c42, 0xbf88f496,
    0x3e206aa7, 0x3e64dc2e, 0xbe89e1cf, 0x3ef9c79f,
    0xbf1a17b4, 0x3eb103d8, 0x40065ee7, 0x3efb1543,
    0x3fb68d18, 0x3fd8e8b4, 0x3d8a2705, 0xc067b372,
    0xbf8f641e, 0x3fab17b7, 0xbf34a217, 0x402432ad,
    0x3f847649, 0x40906e0e, 0xc06c61c8, 0xc02577fc,
    0x4066e8f7, 0x3d5f5d81, 0xc072b5d6, 0x3ea0b8d8,
    0x3fb361bc, 0xbffc848b, 0x3fa006f3, 0x40163293,
    0x403db2af, 0x4007690d, 0x40112583, 0xbfec904d,
    0xbffc2114, 0x3f11b4e4, 0x3f45e7f8, 0x4081b837,
    0xc038ce30, 0xc071943e, 0xbef74a53, 0x3c386d80,
    0x40392157, 0x404d9429, 0xc00777cd, 0xc02903c0,
    0xbf879fe1, 0x400b116e, 0x3f2c5213, 0xbf2a2b5e,
    0xbf8c1b31, 0xbf6c3408, 0xc0267e58, 0x3eb1cc58,
    0x3f8b9a81, 0x4031ce6d, 0xbf96b9e8, 0xbf563882,
    0xbf8564fa, 0x40c1a029, 0x408fe19f, 0x4038cb06,
    0xbfcc162c, 0x4046d0d4, 0x3f0ef6e4, 0x3f1fd431,
    0x3efa45b1, 0x3ff9b50b, 0x3c7a2c88, 0xbf73b99b,
    0xbf81adc0, 0x3ff65019, 0x3e384bab, 0xbf1b6677,
    0xbfb3c7d5, 0xc000b362, 0x3fc00110, 0xbf4a049e,
    0x3fb9449a, 0x3ef96784, 0xc09f42ab, 0x3f6625b7,
    0x3ed4669f, 0x3f81e855, 0x401a4cb4, 0x401b4438,
    0x40411081, 0x3fba702d, 0x409e6000, 0x3f654c2d,
    0xbdf53c9d, 0xbf43e151, 0x40840bd5, 0xc0ab7fb3,
    0xc045b6fa, 0xbfaccb72, 0x401af614, 0x40140cf9,
    0xc05af000, 0xbf21eeae, 0xc06ddf3c, 0x4018a2b7,
    0x3eed84b0, 0x3e874e0d, 0xbef79955, 0xc0200324,
    0xbe623b7a, 0x3f04be98, 0x408daddb, 0xbff9d8df,
    0x3e6abb23, 0x3f20a714, 0xc02425af, 0xc01a5ca6,
    0x3d33cf41, 0x4067d08c, 0xc0810313, 0x40abdbac,
    0xc04e391f, 0x3fdb1528, 0xbfcac17d, 0x4092d68d,
    0x3ec404b8, 0x3fee4ade, 0xbfc9df89, 0xbfc9b02f,
    0x405fb0e0, 0xc040c78e, 0x4035464d, 0xbf817f3a,
    0x3ff1f364, 0x4035c918, 0xbe10f445, 0x40937076,
    0xc004d810, 0xbf4af80f, 0x408a13d4, 0xc01f8116,
    0x4001c467, 0x3ec86054, 0xbf235d45, 0x3f9a71dd,
    0x3f906836, 0xc010d936, 0x3f862fa8, 0x403b5b21,
    0x40af493e, 0x3fb3bfb2, 0xbfc13529, 0xbf48bab8,
    0x4085bfcf, 0x3efa61af, 0x3fdf5c93, 0xbfa148f1,
    0xbec77c0e, 0xbfce54d5, 0x3eb11d75, 0x3f67f1d6,
    0xbeceb83c, 0xc09c1fdf, 0xbf3394bc, 0x3f29509c,
    0xbfe49a77, 0xbe24ac08, 0x40366cf8, 0x3f63ea31,
    0xbfe56426, 0x400674fb, 0xc070220f, 0x3da377a5,
    0xbfdc9a28, 0x3e88b0a1, 0xbe9b32ab, 0x3f0dd592,
    0xbee30d7a, 0xbfe19ee0, 0x3ee10801, 0xc01b7e0b,
    0xbebe951e, 0xc0016e4f, 0x3f92ad6b, 0x3f408f6c,
    0x403c8d0e, 0xc0263956, 0xc00d1cfe, 0xbe81ae86,
    0xc0093713, 0x3de9eed3, 0xc07aeab4, 0xbf840b16,
    0x400ddd4b, 0xbfab1fc3, 0xc08e2ffa, 0xbe4d88cd,
    0x3f8ae906, 0xbf40cd80, 0x4059a46c, 0x3ec9e229,
    0xc094c173, 0x40687baf, 0x3fd5f7b6, 0xbe05ff91,
    0x4010682f, 0xbfc97e6b, 0x4014077a, 0x3fe3c7c6,
    0x3f3957e6, 0xbf050deb, 0x3ea98a8a, 0x40aaa70a,
    0x3f6d3369, 0xbf638c1e, 0xc05e479a, 0x3f02c61f,
    0x401674e8, 0x3ef8fde5, 0xbe1a97ff, 0xbf3dcd0f,
    0xbf6044cd, 0x401beb8d, 0x3e574d56, 0xc052782a,
    0x3fd81f57, 0xc086581a, 0xbfc97eb7, 0x3ecc02ce,
    0xbf2ba710, 0xc05b5900, 0xc026f858, 0xba47dc3e,
    0x405b591f, 0xbe023b9b, 0x40364a7f, 0x402fca17,
    0x4023ff8c, 0xbe8c1072, 0xbfc2c62c, 0x3fbb0c79,
    0xc055c872, 0x3f4e6e7b, 0x402615ad, 0x3f9de981,
    0x3f0dad5b, 0x3faf1b08, 0x3f94211c, 0xc08c1f1e,
    0x4078a6ea, 0xbdc6ff06, 0x3f16061d, 0xbf03200d,
    0xc014a65d, 0xc041e542, 0xc05f4e3b, 0x3ff516a9,
    0x3fd545f8, 0xbcafbf7f, 0x3f67565b, 0x3f933331,
    0x404fcba9, 0xbf845139, 0xc0455595, 0x40248990,
    0xbfc34f6b, 0x3e6151f9, 0xbe07b774, 0x3f07d513,
    0xc0008871, 0xbfb46cb5, 0xbf9f27c6, 0xc0b43c69,
    0x3fcb035d, 0xc0941b6c, 0x3f59d3b2, 0xc02401cf,
    0xbff70e5c, 0x402d760f, 0xbf7f86f8, 0xc000b2cf,
    0x3fa5f550, 0x3fad1b8e, 0x403ae9ed, 0x4018c2a8,
    0x400dd74b, 0xbf8cea66, 0x4022c9d9, 0xbeb912fa,
    0xbdf1239c, 0xbe20606c, 0x3f917eae, 0xc0215532,
    0xbfa291ed, 0x40059b6a, 0x4072a9ec, 0xc0061a35,
    0x3f146f45, 0x4007f589, 0xbf833b23, 0xbd7ddd1b,
    0x402a0a60, 0xbf607b02, 0x3fa23e39, 0xbf526b39,
    0xbfaddbec, 0x3e76bd77, 0x3fc99b8a, 0x402ba985,
    0xbd8f0a57, 0xc02a3e3e, 0x4028868d, 0x3f3a9d65,
    0x3f684616, 0x3fbf1639, 0x3f8296c7, 0xbf8fa247,
    0x40c918f7, 0x3fa8a415, 0xc030ed11, 0x409013a1,
    0xc03862f0, 0x3e9736b9, 0x40756668, 0x3e120c73,
    0x3f844139, 0xbf7833a0, 0x3fd4ef6c, 0x3f11638c,
    0x3f872058, 0xbff55269, 0x3eacb005, 0xbfb9a384,
    0x3fc10bc6, 0xbf232d93, 0xbf094d0b, 0xc0312faa,
    0x3f5d1f81, 0x40370cae, 0xbf979a5e, 0x3f931613,
    0x4094e609, 0xc09ca890, 0xc08da472, 0x3e833039,
    0xbf02af1d, 0x40089812, 0xbe62bbfe, 0xc01655f2,
    0xc0453ccc, 0xc028fc26, 0x4091de28, 0xbf99e4c8,
    0x3f932513, 0xbe84d5d8, 0x404a3cbc, 0xc066cb18,
    0x40d34ee1, 0x400078a3, 0x3fd9bfac, 0xbea9d4e4,
    0xc02c88a2, 0xbfcda5c7, 0x40308913, 0xc01d8f32,
    0x40189445, 0x402ff7a4, 0x3fc9abfd, 0x3eb3b06a,
    0xc06c6f8b, 0x3ea5badf, 0xc081a68d, 0x3eabf974,
    0xbfd3630c, 0xbf9b91fe, 0x3fdc0b69, 0xc01e0656,
    0x3f734d62, 0xbfaa07b5, 0x3e24efd4, 0x400f5c73,
    0xbdcb03e5, 0xbd83374d, 0xc0b49d48, 0xc0109399,
    0x3f454f73, 0x3f189248, 0x3f92f454, 0xbedd41f0,
    0xc085313e, 0xc0480d0d, 0xbf51826e, 0xbf939529,
    0xbe3e58d2, 0x3fd60d46, 0x406d16cc, 0xc01c5e20,
    0xbfc0ae0f, 0x3fbc34bb, 0x3f91becf, 0xbd2044e8,
    0xbfaf2dff, 0xbf48f645, 0x4031abb9, 0x3f09a10b,
    0xc0233252, 0x40c653d9, 0x3fa36832, 0x3e2513f7,
    0xbeb709b3, 0x3e9ecc94, 0x3e7c7ea6, 0xbf2c7385,
    0xbe6df45c, 0x3fcc4c28, 0xc04e02bd, 0xc0441791,
    0xbf5091f5, 0x3fa24c81, 0xbf64c3b2, 0xbfe4a17f,
    0x3fb8d71d, 0x3f997812, 0x3f162119, 0xbd61db5d,
    0x3fc66cc4, 0x3f0664f2, 0x4051c46e, 0xbfa1729d,
    0x400a5c4c, 0xbfdf2948, 0xbf83388d, 0x3e13393a,
    0xc0317b59, 0x402a40e9, 0xbf52c7b2, 0xc056cfd4,
    0xbe812636, 0x3cd62a3a, 0xc001361f, 0x4036e425,
    0xc01be010, 0x3ff5dcf5, 0x403e105b, 0xbf072e50,
    0x3feb7bee, 0xc047d420, 0x3e124ce9, 0x3fab49b9,
    0x40386550, 0x3faf40b8, 0x3f8593a0, 0x3fdeb25e,
    0x3faf83db, 0xbf5ef27f, 0x4088c69f, 0x40486218,
    0x3dc930d6, 0x3e3b306b, 0x4094c758, 0x3f45a39f,
    0x4000507f, 0x3fc0b569, 0x3e99d3bc, 0xbfbaa9dd,
    0xc020d98c, 0x3f5c8a2c, 0xc036a33b, 0xbfa1a0af,
    0xbebe6804, 0xbecb897e, 0xbf94c84c, 0xbe81b5f1,
    0xbfc4306a, 0xc008f2ba, 0x3fa64a33, 0x3f169cb5,
    0x3f45e68a, 0xbf751a99, 0xbfd1c2c9, 0xc01ed6e1,
    0xbe96254b, 0xbfcace1c, 0x3f8b048b, 0x3fb489db,
    0x3fac421e, 0x3f428c6c, 0xc05528a4, 0xc08dea7e,
    0x4054d74b, 0xbe2afd7c, 0x3ea3f4f1, 0xc001736a,
    0xc0638b1b, 0xbebc36e4, 0xc00c8bfb, 0x40942801,
    0xbfecaa35, 0xbf76d8e4, 0xbf9423b0, 0x3ef36f6d,
    0x3f07ae7c, 0xbf1d39f8, 0xc036a80d, 0x40e06305,
    0x3f992b32, 0xc0353670, 0x40113c5b, 0xbf170a44,
    0x4064f721, 0xc083ee17, 0xbfeb09ed, 0xbfa700e8,
    0xbf348a01, 0x400a8dfa, 0x401e9aa0, 0xbf5f0f7f,
    0x40a27a23, 0xbe1cc897, 0xbfd57370, 0xbe5ad2f2,
    0x3efed58a, 0xbf344b8e, 0x40910ad4, 0x3f197362,
    0x40bfb48b, 0x403d08e7, 0xbfc3e0a4, 0x40122e7a,
    0xbfd080af, 0x40b0b153, 0xc0824c2b, 0xbf6a9c5d,
    0x3fd0a01f, 0x3f85cceb, 0xbfb0aa58, 0x3f579e94,
    0x3f765986, 0x3f31c4b4, 0xbefb11d9, 0xbfb48d75,
    0x3ecfa34e, 0x4085c2bf, 0x400172b2, 0x4064b36a,
    0xc02d8922, 0xbfcdef44, 0xbefcc121, 0x409276f5,
    0xbfb0dd72, 0xbf2ed68c, 0xc09fe9ee, 0xc006a9fe,
    0x404dc69e, 0xbff1b8b2, 0xc088fcad, 0xbfb3e025,
    0xc04c6f2e, 0xbfa172fb, 0xbfe209c4, 0x408e4cf2,
    0xbf3b6b66, 0xbfb4fe10, 0x3fbf20c6, 0x4075f435,
    0xbf901281, 0x3fbd8068, 0xbf69a14d, 0xc01fbc59,
    0x3ec1645a, 0xbe1c36f5, 0xbe8fcbc9, 0xbf3a0cec,
    0x4066ce62, 0xbf989548, 0xc020831b, 0x3fe8eac7,
    0x400cf138, 0xc05898f7, 0xbff60f29, 0x4022057a,
    0xbfb1fb23, 0xbff45708, 0x3ff6b06a, 0x3d80b5a4,
    0xc02de8bf, 0xc0886ab7, 0x3f90f6f4, 0x404472ae,
    0x402a31e3, 0x3e7e348b, 0x3ff3dfe4, 0xbf24d8ea,
    0xbfbab16d, 0xc0537107, 0x40090fe7, 0x3f6ba825,
    0x401474d4, 0xbfaf29bb, 0x401c9ee5, 0xbfe2eab2,
    0xc07491f8, 0x3f8e06ea, 0x409b61cc, 0xc0830f21,
    0x3e99238a, 0xbe5ae111, 0x3fa1492c, 0x40341d78,
    0x40731bf4, 0xbefd1657, 0xc071ec10, 0xc02fbb57,
    0xc083c620, 0x405897f2, 0xc08bae25, 0xc0038815,
    0xc0032009, 0x3fff71b3, 0x3f2a911b, 0xbf4bcd47,
    0x3efa5b0f, 0x3fb7c43e, 0x3d9df475, 0x3e93be3b,
    0xbf97dbfa, 0xbface3f4, 0xbff82fd8, 0xbfcf8a85,
    0xbf1cc43e, 0xbfaa7bdf, 0x403fbd5d, 0xbfe657b4,
    0xbfb83a6c, 0xbff36bc1, 0x3e2ce9b7, 0x409b32dd,
    0x3f8d9a0f, 0xbf18205a, 0x3ed8fbc0, 0xbf1572c5,
    0xbe80c888, 0xc0772444, 0xc01c28c9, 0xbf0069d2,
    0xc048abcb, 0x3fd3fdfd, 0x4052cc00, 0x40d8fa0e,
    0x4037de14, 0x40194709, 0x3eb59890, 0x3fa70230,
    0xbe9b50ad, 0x404e2839, 0xbe8c6952, 0x3f2f1608,
    0x3df7cb2c, 0xbf6ddb3c, 0xbea42d9a, 0xbe251176,
    0xbf4ed4b1, 0xbf6aa29f, 0x403f5c57, 0xbfb49081,
    0x4015db0e, 0x40041ca5, 0x3fa1500a, 0xbe6b7735,
    0xbe95a0ac, 0x3efdf11a, 0xc01b9b1d, 0x3fb02ed2,
    0x4020465f, 0x3f4f08a8, 0x3fbcca5e, 0xbec620f5,
    0xbfad081c, 0x3ef1ca2d, 0x400ccbf5, 0xc012bf06,
    0xbe52d34c, 0x3f159c3c, 0xbfc80297, 0x3f236e59,
    0x3e0f91a4, 0x3f80f1b2, 0x3fa5fc41, 0xbe987b4d,
    0xc028cd9f, 0xbfd2fd45, 0x3fcc7a38, 0xc032a085,
    0x4062e4b2, 0xbf940035, 0x40041b9c, 0x40579636,
    0xbf777fd4, 0xc0383bab, 0xbf892f03, 0x4012dc90,
    0x40856ab6, 0xbf1cb40d, 0xbf8d243a, 0x3f756f79,
    0xc019cb31, 0x3f9491f4, 0xbee1270c, 0xbfe9b151,
    0x3f8d0b8b, 0xbef016bf, 0xc00316ec, 0xbfa72d1a,
    0x3ee3d564, 0x40120229, 0x3f5073af, 0x3fdd9483,
    0xbf689c59, 0xbdcb9d77, 0x402cf5e1, 0x3f1aeccf,
    0xc02c84c4, 0xbf959353, 0xbf658f6d, 0xc0055e46,
    0xbfb4fc9e, 0x402d8274, 0xbff57628, 0xbe8309df,
    0xbe838e24, 0x404bd2ae, 0xbf0ebd7c, 0x3e3b4417,
    0x3fb03bb9, 0xbe88871c, 0x3e8b4dc3, 0xc020b7f8,
    0xbf57ace8, 0x3fc503d8, 0x3f1a1975, 0x3e524e60,
    0x4097a7ff, 0x3f926023, 0x401d0475, 0x3fd8e9bc,
    0x3f2d6490, 0xbf09ab84, 0x3f1897ac, 0x3fccacb1,
    0xc00aab96, 0xc07a7a73, 0x408478d0, 0xbf7ec4f7,
    0xbe3dd0d9, 0xbf68def9, 0xbfa6b2dc, 0xbfa13af5,
    0xbf7c0df1, 0xbf1d4239, 0x3f92f500, 0xbf07ef2c,
    0xc0015df0, 0x3f8e46c0, 0x3ffdf33b, 0xbd9f3531,
    0x3f114681, 0x4001d5b7, 0x3dcf8010, 0xbfa7a935,
    0x408b841f, 0x3ff6a4d5, 0xbfb618f4, 0x3f55e312,
    0x3f8a9890, 0xbfa21798, 0xbfc7f941, 0xbf392009,
    0xbff647be, 0xc0400bb2, 0x3f69f6b6, 0x4032813c,
    0xc069cb4f, 0xbf7b06fa, 0x3f5acd03, 0xbed9e41f,
    0x401f73f4, 0x3e28cdc5, 0x3f422b6b, 0xbd7792ef,
    0xbf619e39, 0xc0c66aff, 0xbf1d6d04, 0x3e8ec5a2,
    0x3ff5e903, 0x405a6447, 0xbb809b2f, 0x3f8769e9,
    0xbf042973, 0x409fea92, 0x40373705, 0x4098359e,
    0xbe5520f0, 0x3fc9ae2f, 0xc042d298, 0xbfc131e5,
    0xbe8c5f66, 0xc05ec2de, 0x403569d8, 0xc07a39c3,
    0x3f9ecb01, 0x3fa1e13b, 0xc0399a18, 0xbfc81819,
    0x400c78c0, 0x400e1afb, 0x3e0e248e, 0x3fd68ac5,
    0xc0187b90, 0xbf8b53b7, 0x3f78afc2, 0xc025b3b1,
    0xbfa9c71b, 0x3eff7857, 0x3fbec379, 0x3fe35ebc,
    0x3ea6abff, 0xc055783a, 0x3f46eee6, 0xbf23777d,
    0xbfa826cc, 0x4026d9b2, 0x402de68b, 0x3f467342,
    0x3fafd4a9, 0x40697965, 0x4044db1e, 0x40619876,
    0xbf4a9d86, 0x403f6f8b, 0xc0560ea7, 0x3eae0d82,
    0xc050ddeb, 0x3f46bd5b, 0xbf3ba048, 0xbdffbf8d,
    0xc0158827, 0x3fcffce9, 0xbff5bc66, 0x3f85ac5b,
    0xbeac91fb, 0x3fb9f4b2, 0x3f825b28, 0x403b3704,
    0x3f52f772, 0x3fbaf761, 0xbe1527ad, 0xbf98cb20,
    0x3fcf2ab8, 0x3f7385b4, 0x3fb08202, 0xbf47293e,
    0xbf7c7cac, 0xbffff352, 0xbffb8e22, 0x4060b5c8,
    0x407982a1, 0xbec3e4e6, 0x3fca63fc, 0x3f5ad51d,
    0xbeee7f8c, 0x3eca7b66, 0x40c4ce27, 0xbf1cb0dc,
    0xbf26eaee, 0xbef6c4bc, 0xc0061786, 0x3cac160c,
    0xc02fa07d, 0xc002de1b, 0x40c461a8, 0xbf84720a,
    0x3fa62c61, 0x408f0e36, 0x40ab92bc, 0x40ae5000,
    0xbf7d7321, 0x3feb3255, 0xc04a1362, 0xc09c5659,
    0xc03750ae, 0x4022602a, 0xbefb99bd, 0x3f47c0cd,
    0x3f3602dc, 0xbe7171a5, 0xbf864d15, 0xc031574c,
    0xbfaf90f0, 0xbfcb1e0d, 0xbf86178f, 0xbf9bf606,
    0xbf83124a, 0x3f4f1750, 0xbffb8574, 0xc0317576,
    0x4080ee26, 0xbcd17dc9, 0xbfe072a2, 0x3e233703,
    0x3ddfd1b7, 0xbecb8fda, 0xc0077b33, 0xbf208a4f,
    0x3fed0645, 0xbfec9394, 0xc001bee7, 0xbf1dedde,
    0xbfe9190a, 0xbed636c2, 0xbe2b33db, 0xbef383aa,
    0xbfae6e43, 0x3f2a2940, 0x3f867ead, 0x3ea6f47a,
    0x3f93e6f0, 0x40294f3f, 0xbfc4ad37, 0xc08b384e,
    0x40abc997, 0xc055289f, 0xbfa40201, 0x3dda6747,
    0x3fcee5a2, 0xc00ef199, 0x4012727b, 0x3fb768f3,
    0x3dd6991a, 0x402e9c64, 0x403cbbaf, 0x4000271e,
    0x3ef68195, 0xbf47f62d, 0x3fb1c28b, 0x3fae68fb,
    0xbf1b2873, 0x3f236f97, 0x3e54f6a1, 0x3fb3e9c5,
    0xbecb66d1, 0x3fc11130, 0x3eb767a1, 0xc099d0ab,
    0x3d4eb153, 0xbe67225e, 0xbffeaa2e, 0x3ea07694,
    0xbeddd754, 0x3f1f177d, 0x3efb4f61, 0x40530751,
    0x4050f0f6, 0x403d8eec, 0xbf5cd745, 0x40215d25,
    0xbecbb6ca, 0xc013501f, 0x408d4d6f, 0xbf8d942f,
    0x4012ade0, 0xc00d37bc, 0x4035f650, 0x3f6146f7,
    0x3ef86eff, 0xbf41d945, 0xbf2ca592, 0xbedb284c,
    0x3fc6074b, 0x3e96b285, 0x3ffe0017, 0x40660b43,
    0x401067eb, 0x3c849251, 0xc0095cab, 0x3f90a4c9,
    0x3f11541c, 0x3ffeb37e, 0xc0aa72ed, 0xc0312022,
    0xc00c2f8b, 0xbef33150, 0x3f094927, 0x401c05ba,
    0x40b13805, 0x3fb05174, 0xc0667106, 0x408c9796,
    0x40461d69, 0xbfef07dd, 0x3c605a5d, 0xbee7dd23,
    0xc05f259d, 0xbf9f59ff, 0x402ed958, 0xc06a0481,
    0xbf435668, 0x3f0fcdf7, 0xc03cc914, 0x3fb72b12,
    0x3fc4dbf1, 0xc00fbfdb, 0xc0776ce3, 0xc01db653,
    0xbf13afcd, 0x3e8130a0, 0xbfd20849, 0x3f574b39,
    0xc09828cb, 0x401a473b, 0xc0832b49, 0x3f1aa35c,
    0xbfe38d8d, 0x3fde1d08, 0xbf93d818, 0xbc4c3e64,
    0x4007f04e, 0x409d238e, 0xbedd0b4d, 0xc01be8fa,
    0x3e94b56d, 0xbf7335a4, 0x4080d527, 0x40377f30,
    0xbfd4c2a6, 0x3f9b469b, 0xc016b67c, 0xbf72212f,
    0xbf03b86f, 0x3eaa4665, 0x3f582b8b, 0x403abed1,
    0x3f285fe8, 0xc01d222a, 0xc0189332, 0xbed0c6e0,
    0xc09a2946, 0xbe4b9d4e, 0xbe67e6e4, 0xbec0b309,
    0x3fd8a63d, 0x40931b3c, 0x4019c532, 0xc00398cc,
    0xbf6a72d9, 0x3fc12f38, 0x406517b9, 0x3ea5c92a,
    0xbd5a257f, 0x403b121c, 0x3f598732, 0xc064a9a8,
    0xbfbdf1e4, 0xc02c1b4d, 0xc00e7382, 0x3f00b0ee,
    0xbfbc97d4, 0x3dedde4d, 0x4032ca05, 0xbfbe9e57,
    0x404703ba, 0x3fbcf10f, 0xbf85fe9c, 0x3f794c4f,
    0x3f432546, 0xbeb4f8e5, 0xc0c7b17f, 0xbfa90804,
    0x3f4e313c, 0x4030b2f2, 0x403b83b1, 0xbd861013,
    0xbe9cb544, 0x409a30c4, 0xc032bdef, 0x3f5a75ba,
    0x40913ba0, 0x407b2497, 0xbf86db83, 0x40bc5a4a,
    0xbe7a637c, 0xbdfad393, 0x403ca7b1, 0x3fdf345a,
    0xbf1b0406, 0x3f160f05, 0x3f9d9ec5, 0x3eb47a6a,
    0x3fcaea58, 0x402bb57b, 0x408ef077, 0xbfefea60,
    0x406171e0, 0x3fba97e7, 0xbfe1519c, 0xbe3b2fdb,
    0xbf4c9769, 0x402afb58, 0xbf49cee0, 0x3eadee7e,
    0xc01df30c, 0xc0b7aef5, 0x3f30071a, 0x3d7c7e5b,
    0x3fc5be68, 0x402342cd, 0xbf847a84, 0xbda88450,
    0xbf8ba69f, 0x3fac3261, 0xc05508a3, 0xbfd760ac,
    0xbf44d98d, 0x3e98a354, 0x40577ce2, 0xc06ac12e,
    0x403feea3, 0x3eee15f1, 0x3f9f9042, 0xc087e5c0,
    0xbf06a447, 0x401f45bb, 0xbf811258, 0xc03afe37,
    0x3fedfaeb, 0xbf0e5bed, 0x40a1b8b8, 0xc0758b6f,
    0x3fca6c0c, 0x3ec6e4a1, 0xc0a3986d, 0xbeb074a9,
    0xbfe44e6d, 0x3edf6701, 0x3e85e223, 0xc0262eb8,
    0xc094ad23, 0xbfa5e9b3, 0xbfe359e8, 0x3f8d70ff,
    0xc05f53d8, 0x3f253d61, 0xbe60702c, 0x4066ef2c,
    0x3f9c9d5e, 0x3f1c0e6c, 0xbfb2766a, 0xbf78c375,
    0xc06b34cd, 0x3d61862f, 0xc03ca233, 0xbf68c729,
    0x408863af, 0x3fd406c8, 0xc02ef347, 0xbf4497de,
    0xc0338c07, 0x3f321713, 0x401cf9ec, 0x4046ba26,
    0xbfdac521, 0xbded2910, 0xbeb446d8, 0xbd705c0a,
    0xc04ed2d7, 0xbff142e1, 0xbf8bcb56, 0x406332c4,
    0xbf8bb2ff, 0x3f66ca85, 0x3f0b3500, 0xbfd95dc4,
    0xbe1a9994, 0xbe54f83b, 0xbf9cff31, 0x4012af69,
    0x402e1cc4, 0x3f14cb1d, 0xbfcc85c2, 0x3f96326e,
    0xbf82e727, 0xc030831a, 0x3ede21e2, 0xbfc8cd5c,
    0x3f27214e, 0xbfec0afe, 0x4081df18, 0xbff58e5d,
    0xbffdb48d, 0xbe738573, 0x3f56add7, 0xbeed3268,
    0x40036935, 0xbfcf93da, 0x3fc59f08, 0xbf5326cb,
    0xbf901662, 0x40875582, 0xbf3fc0c9, 0x4058f43d,
    0xbf7810d2, 0x3ed3623a, 0x3f47095c, 0x4025a858,
    0xc01945fb, 0xbe225bab, 0x40005a62, 0xc067f2b3,
    0x3fcc3112, 0xc0289523, 0x3e8b3c6d, 0xc008ac66,
    0x3eb0f23c, 0x4000ef84, 0x40524845, 0xbc4a74cc,
    0x40673c83, 0xbf56bf41, 0xbf20f95e, 0x4030df20,
    0x3f9f1334, 0xbf0be6da, 0x3e6e6e95, 0xbfcef60b,
    0x3dee444b, 0x3f4aa234, 0x3fdb28d1, 0x3f3196c9,
    0xc050bbce, 0x3f4bfc52, 0xbe9bb4ac, 0x3ef90d5b,
    0xbf5d5e12, 0x3eeb4957, 0xc04ede9b, 0xc00c63b3,
    0x3f7259b9, 0xbfc22e92, 0x3f5e2eac, 0xbeaf21bb,
    0x40565ff0, 0xbfacd7f4, 0x3e94a369, 0x3d83e146,
    0x3f9931ba, 0xc05098e7, 0x402a560f, 0xbf17da61,
    0xbf93a3d4, 0x3eccbd78, 0xbefc2b24, 0x4018e004,
    0xbec376e3, 0xbfd50db3, 0x40262e6d, 0xbfd96483,
    0xbf372d60, 0x401fb68c, 0xbf758902, 0x4015f8c9,
    0x3f57c7e0, 0xbf37245e, 0x400b11bd, 0xc03fd3ec,
    0x401a4b8c, 0x3f610863, 0xbf897db0, 0xbf16a1b2,
    0x3fd67447, 0xbe05738b, 0xc0305c0a, 0xc0153902,
    0xbf130787, 0x4086ae5b, 0x3fe4417f, 0xc0091b2c,
    0x3e48be9a, 0xbf3cae40, 0xbfd10138, 0xc00aba67,
    0xbf4a3cc8, 0x3ef382ac, 0xbf7ecf68, 0xbf15fbd0,
    0x40202a86, 0xbf838b46, 0xbef6bf67, 0x3fba2995,
    0x3f6e545c, 0xbf37968e, 0xbe988bb3, 0xc027555c,
    0xbf72d5c4, 0x3e325f3c, 0x3f47925c, 0x4065b234,
    0x40187221, 0xbfce0056, 0xbfd14828, 0xbf8d9420,
    0xbed8661c, 0x3fc62c35, 0xbf45a049, 0x403558df,
    0xc083070e, 0x3f51eb1a, 0x40716338, 0xbde6040d,
    0xbfade3bc, 0xbd81a1ea, 0xbf55d462, 0xbf180487,
    0xbdad62e4, 0xbf1be251, 0xc06419a0, 0xbea06d98,
    0x408c0f32, 0xbfc9e399, 0xc05da10a, 0x402be5b3,
    0x3f7a8c1b, 0xbefe3310, 0x3ed550df, 0xbf18be6b,
    0xbfbc3b8a, 0xbfb4436b, 0xc0afe86b, 0x3e8fc6a0,
    0x3f956dea, 0xbf092c80, 0xbfbe6a5f, 0xc0760db0,
    0x3ff3214a, 0x3ff7ffb3, 0xbfcb47d0, 0x3f53de26,
    0x3f05bac3, 0x3e5f416a, 0xbf06376b, 0xbf3471cd,
    0xbf578ebb, 0xc0149e2c, 0xbe928191, 0x3f3e7842,
    0xbefcd7c8, 0x3e3566d7, 0xc0327918, 0xc08aea35,
    0x3f674ce0, 0x3fa393fe, 0xbf7b4529, 0x3fcd778e,
    0x3df8e7ff, 0xc009f66f, 0xc00629f5, 0xc0969c4e,
    0xbee28d32, 0xc040c01f, 0x3fd86335, 0xc065774f,
    0xbfb684bd, 0x3ea3e39c, 0xbdfb890a, 0x405163a8,
    0x405b3f08, 0x3e74135f, 0x3f26c2b6, 0x3fdd8761,
    0xbf356765, 0x3ffcaa17, 0xbf9ee296, 0xbf90a96d,
    0xc0045e4a, 0x3f793220, 0xbfd831e2, 0x3e2fd597,
    0x3ee02f59, 0xbe9eb913, 0x400c8b2a, 0x3e9a84b8,
    0x3fe13f09, 0x3e0df8e8, 0x3ed726a6, 0xbe80704b,
    0x4093156f, 0x3f230e79, 0x40041298, 0x3e94307c,
    0x402a5df1, 0x3f9b1ce8, 0x406d4a7a, 0xbf1440b4,
    0x3e31b0d1, 0x3f10fae9, 0x4004ef79, 0xc05fed40,
    0xbec0ebaf, 0xc0244385, 0xc072dbc2, 0x3fb73e34,
    0x3d9ac551, 0xbf98c62c, 0xc03416e5, 0x3ed07fb9,
    0x3f34e7b8, 0x3efa26a3, 0x3fc830b8, 0x3fc28740,
    0x4088416c, 0x4098a743, 0x408ed0c7, 0x403f5c5c,
    0xbebe635d, 0xbffb7e28, 0x3f903a66, 0x3fd58026,
    0xbda8dcfc, 0x4068d17f, 0xc0186f4a, 0x4018d5e7,
    0xbfff72f5, 0xbf97ad23, 0x3e74338d, 0x3f04b918,
    0xc04ff3a6, 0x3f5b3361, 0x3fb54800, 0x4048bd2e,
    0xc0819014, 0xbf1cefec, 0xbf9cb3b7, 0x3f0a30ff,
    0xbf72c1ee, 0x40536cf3, 0xbf17488d, 0xbfa07ef7,
    0x3f7737be, 0xbf7e35e8, 0xbe90a35c, 0x4019f5ee,
    0xbfc52511, 0x400b6606, 0xc088b8aa, 0x3fb46fb4,
    0xbf921d7f, 0x401f4eaf, 0xc0653488, 0x3d0b41f5,
    0xc03a83e5, 0x3e543a6b, 0x4017bdc8, 0x3ffcd657,
    0xbfc60787, 0x40b64396, 0xbf1d6b65, 0x3f9ca546,
    0x4047f083, 0x3e13b414, 0x3f27096b, 0xc03a0c8a,
    0xbff9322d, 0xbfefa264, 0xbf2a9c64, 0xbf9cb2ad,
    0x3e6c073a, 0xc05a99f4, 0xc0d049b4, 0xbff7e07b,
    0xc00e9f4c, 0xbfd5caf6, 0x3fbe8dfa, 0x3facdaf8,
    0xc020be13, 0x3f68a67a, 0xbf867e1e, 0xc0852f7c,
    0xbfaa8504, 0xbfd9f2a0, 0xbf2c13b7, 0xc04d049b,
    0x3f590e67, 0x3f7dc631, 0x3fb8732e, 0xc077e956,
    0xc02699d3, 0x4056e7fa, 0x4091ebb1, 0xc08fcd93,
    0x3ea81585, 0x3f8702bd, 0x3fac1caf, 0x4035aa4f,
    0xc0080c3d, 0x3fd87d21, 0x401ee6ad, 0x4076a5c2,
    0x3e9753b0, 0xc01ba0b4, 0xc010f72e, 0xbea9a635,
    0x3f862372, 0x4021ef24, 0xbf9492b3, 0x40489e88,
    0x405cc42f, 0x3f51c115, 0xbd9971a6, 0xc002a045,
    0xbe08dd56, 0xc0332bcc, 0xc07f4d8c, 0xbf49a354,
    0xbe130e61, 0x3f04a820, 0xbeacb189, 0x3fa223b5,
    0x40757ec8, 0x3f92e8e7, 0x3fefc4d9, 0xc00ecfc7,
    0x4065a086, 0xbe5b5240, 0x3f1f5795, 0x3ea4b131,
    0xbf9a807a, 0x4024016d, 0xbfd2b697, 0xbfb9b3fa,
    0x406bf909, 0xbde4e93b, 0x3f7af107, 0x407029c7,
    0x3fb0e4e6, 0x3f3e8325, 0x3def231c, 0x3f12ebbd,
    0x40300783, 0xbf0cd0ff, 0xbfe9688c, 0xc0432842,
    0x403a8ecb, 0x3fad17a8, 0x4033879f, 0x3fc99f4b,
    0xbd8a1e21, 0x4088c044, 0x3ecc4c0e, 0x3c381623,
    0x3ee5cf41, 0xbedf1d9d, 0xbfd433aa, 0x402f03e9,
    0xc05ee317, 0x3fef0228, 0xc0291eba, 0xc088419f,
    0x400ea556, 0x408b4ee6, 0xc0298ff2, 0xbfb51c4d,
    0xc045467b, 0xc01a417b, 0xbf1ba50c, 0xc0368aac,
    0x4063621b, 0xc01c3ea5, 0xc018462c, 0xc0ab1801,
    0x3f308143, 0x3f9a5c4d, 0xbf32c93c, 0xc05496df,
    0xbf3234f7, 0xbf453a5e, 0xbe094d13, 0x3ec46835,
    0xbd805886, 0xbf8c2a7c, 0xbecf61bf, 0xc021f9fa,
    0x3f41a1c0, 0x3ebbe56f, 0x3f899ccb, 0xbea45b7e,
    0x4098a231, 0xc0227b9f, 0xc07d4788, 0xc0639a88,
    0xc057e04c, 0x408bcc4b, 0xbf2f09bd, 0x402bccb3,
    0xc0a535d3, 0x3fa27b5b, 0x3f616cc1, 0x404248f2,
    0xbee2feaa, 0x40171584, 0xc0112cd6, 0x400525fd,
    0xbf88f41f, 0xbfba2dfb, 0x4060ea91, 0x3fbeeadd,
    0x401b12a5, 0x404c62ea, 0xbfd3157d, 0x3ebcc3c6,
    0x3fca9943, 0x3ffc0032, 0x3f1daef3, 0xc00f002b,
    0x40390e29, 0xbe4393ea, 0xbf5d0ce2, 0x3ebe5ddf,
    0x40080bc8, 0x3ddde608, 0x3fdb559c, 0x3f8c9182,
    0x3fec0c57, 0x3f915530, 0xbf81830a, 0xc00566b5,
    0x3f62c373, 0xc02288b2, 0x3f1dba3c, 0xc00f1540,
    0xc0b3b3c1, 0x3faa4a37, 0xbef3dc03, 0x3f495948,
    0xbf1f8011, 0x3fb4265e, 0x403dec1a, 0xbffcb7b7,
    0xbfe76530, 0x4021a42d, 0xc09fa0dd, 0x3f0525c1,
    0x3fcdba5f, 0x40b6df62, 0xc02c0dc8, 0xc06c4139,
    0xbfb0e0cc, 0xbf9c97d6, 0x40064e27, 0x3fd9fa6a,
    0xc03cc50d, 0x3d27f33e, 0xc03c4b6b, 0x400da120,
    0x4041cd2e, 0xbf7feb66, 0x3ffc9d02, 0x3ec604f2,
    0xbe01e941, 0xbf2a3708, 0x3ff4e6b3, 0x3fc5c1b3,
    0x3fc919c6, 0x3fe28a57, 0xbfc7e894, 0x3fe05041,
    0xbdc1fae3, 0x3ecd57f3, 0xbf8e7422, 0x4024b7b3,
    0xbe43966e, 0xbf82b701, 0xc02b7f8d, 0xbf907e81,
    0x40039a80, 0x3fc655a7, 0xbf740a6d, 0xbd9af381,
    0x3eeabf9c, 0xc03efd25, 0x403282e9, 0xbfff084f,
    0xc0247613, 0x40015ae9, 0xbf5f42f8, 0x3ff72294,
    0x3e254667, 0x3f36027b, 0x3eb3803d, 0xc0e06d3a,
    0xbc49a1ba, 0x40296e34, 0x3f39baf5, 0xbf9736d8,
    0x3e694cd2, 0xc02da1df, 0x3f763a2f, 0x3fa6eec6,
    0xbf46b9cd, 0xbec3726b, 0x3f91ed12, 0x3fbd3377,
    0xc0759e61, 0x3d8a1714, 0xbf9183c7, 0x3d8e0747,
    0xc09199e8, 0x3fdfa76c, 0x404d92e4, 0xbf913950,
    0x3ffdc25d, 0x3fbd55e3, 0xc08cb691, 0x3f5d10f8,
    0x3f8b0c15, 0x3f1d58d7, 0xbf76a306, 0x4006b2f8,
    0x3fe45933, 0x3f686a0c, 0xc053d9c5, 0x40635306,
    0xc06cfd14, 0x4056b840, 0x3e080eec, 0x40063c70,
    0x40156f17, 0x408726d1, 0x3f87c4d2, 0xc019e7e7,
    0x3f976435, 0x3f95a3ba, 0xbea2fbf0, 0xbf39bb98,
    0x3f4b7703, 0x4072f3a2, 0xbe4fadb0, 0x3f6d2a0b,
    0x3cda7ede, 0xbf360f71, 0x4082b027, 0x4046a989,
    0x3f2cfead, 0xc035091c, 0xbfe426c8, 0xbe9dc0e4,
    0xbd6825d8, 0xc008c61a, 0x40374d55, 0x4003824e,
    0x40f04821, 0x3fa303f6, 0xc08aa950, 0xbd37afc8,
    0x3feedfa4, 0x4046170d, 0xbf58b50d, 0x3e1d8ad5,
    0x40131b97, 0x4014a611, 0x40330fef, 0x3e278a28,
    0xc0849812, 0xc080e4cb, 0xc08c3078, 0x3fd8a87a,
    0x406862ce, 0x3e9c0180, 0x3fc1b2e2, 0xbf9859eb,
    0x4002b371, 0xc0055352, 0x40154331, 0xbe8001f3,
    0x4062c771, 0xbfdaab74, 0x3f6f0460, 0xbfc080fa,
    0x3fea33d0, 0x3f7b5b99, 0x40685c1b, 0xbf88e29c,
    0x409fd96e, 0xbfe6df0f, 0x40375c6d, 0x3e9d27a0,
    0xc05ff90a, 0x3f4f1f41, 0x3f737f36, 0xbdf83340,
    0xc04943c3, 0xbd079312, 0xbe698fd2, 0xbfb42d3b,
    0x3f3584d8, 0xbe29b09e, 0x405aadf3, 0x3fbf325e,
    0x3fabbbe9, 0xbe0ebcf9, 0x3f9939cb, 0x3f9a460a,
    0xbfec695b, 0xc033ef87, 0x3fdcf3ea, 0x4011bea6,
    0xc0108c0c, 0x400c14ae, 0xc0089b1d, 0xbe867f62,
    0xc04718bd, 0x3f34c667, 0x3ef2f601, 0x3ef11d35,
    0x3f23d5a7, 0x402977e1, 0xbf8670cc, 0xbddf37bd,
    0xc073315a, 0xbf8f2cb4, 0xc032deac, 0xbfca6f24,
    0x406acd6a, 0xbf2c1493, 0x400a93ec, 0xc0216a9d,
    0x3f0a06a5, 0x3fd0b0a9, 0xbf13f7b2, 0xc005bcb2,
    0x40530a11, 0x4016e7aa, 0xbd96dca1, 0xbfc9b864,
    0x3f827a85, 0x3fb52564, 0xbf1d42de, 0x3d115d17,
    0x3f8a803e, 0xbef8494f, 0xc00f654a, 0x3fa777ed,
    0xc0033101, 0xbff064da, 0x4020cb37, 0x3e77cdbf,
    0x3e0905e4, 0xc0b1d267, 0xbe83e243, 0x40b81ec2,
    0x4009593f, 0x3f0caf8b, 0x3fcabe49, 0x40587668,
    0x404cb42f, 0x3f8288d8, 0x3ddd1b9e, 0xbe0b0b3d,
    0x3e9a8274, 0x3d2bed2d, 0xbe5edc8b, 0x405bb737,
    0x4008e9a0, 0x4035b946, 0x3feb205e, 0x3f00d110,
    0xbe98e18d, 0x3f8f82e3, 0xbf82dbdd, 0xc034fdf5,
    0x3d82eb64, 0x400a3860, 0x3fcd01a9, 0x3f966e05,
    0xbe2dcc7a, 0xbf5f4092, 0xbf7e3b3f, 0x40333b02,
    0xc0888458, 0x3ff0b154, 0xbfddb5cf, 0xbfda0b0e,
    0xc0331996, 0xbfc66792, 0xbf80ba61, 0xc06822af,
    0xbecd4104, 0xbfa9b6ba, 0xc01e3664, 0xc03453a2,
    0x3fe8642b, 0xbf048a66, 0xbfc0c1c0, 0xc0107951,
    0xc0714b50, 0x3d90a7c9, 0x401a4896, 0x3d1da05e,
    0x4021bbfe, 0xbf7fdc8b, 0x3f0b2f65, 0xbf2a8d11,
    0xbfb29dc0, 0xc032e267, 0x4016c883, 0xbe366955,
    0xbe3ca506, 0xc05a1a7e, 0x3f4ef23d, 0x3d6aec86,
    0x3fa6c212, 0xbfea3ebb, 0x40811174, 0xc05bda33,
    0x3ff27a97, 0xc0062951, 0xc04c59c9, 0xbfb60adc,
    0xbf791da4, 0xbf962f00, 0x40467d2d, 0xc0109225,
    0x401d07dc, 0xbfa9c0e9, 0xc02e6c53, 0x3f07d6e9,
    0xbeb3b26a, 0x3f517dfe, 0xbff74173, 0x40983689,
    0xbed84983, 0xbf70491b, 0x40ad161a, 0x3f3bd919,
    0x402e8866, 0x408e104f, 0x40219574, 0xc07929f1,
    0xc00a14de, 0xbd232bb7, 0xc0543119, 0xc0851e73,
    0xbfab7051, 0x409fb867, 0x409d582a, 0x3fb086d0,
    0xc0608ebc, 0x3f247a27, 0xc0900175, 0xc006b660,
    0xc05b6c19, 0xbf28558e, 0x3fa5d66e, 0xbf809d61,
    0x3ebca4d5, 0x407585b2, 0xbf2084af, 0x3ee2e45f,
    0x3e595593, 0xbfd4fab7, 0x406f81f9, 0x3fc3624c,
    0x3ea935d4, 0xc0033a46, 0xbdf3d7f3, 0xbf93d1aa,
    0xc04b5d6d, 0x3f993a7f, 0x3cbca922, 0xbe8878b4,
    0xc007ebe1, 0xc043a73e, 0x40527c45, 0xbfd610c9,
    0x3fc88c7b, 0x406452b8, 0xbf669f6f, 0xbfe383e4,
    0x3fced90e, 0x3e8b0e8a, 0xbfb884d9, 0x40865661,
    0xc03e1993, 0x3d854f7e, 0xbf6a4ce9, 0xbeaad797,
    0x3f8b64b7, 0x3d5ccc2d, 0x3e0eaf34, 0x3fac4725,
    0x3f8d751a, 0xbf75c4ae, 0x3f14022c, 0xc01cf110,
    0x3fa33181, 0xbf8cd489, 0xbfa6451a, 0xbf2d9e93,
    0xc014ed81, 0x3eb26e5f, 0x40596858, 0xbf4e4194,
    0xbfdb0cba, 0xc0407541, 0xc02197b9, 0xbf026368,
    0xbf1661a9, 0x40909e52, 0xc0211ce7, 0xc068723a,
    0xbe96959b, 0x405aaf4e, 0x404fa7a7, 0xc06773cd,
    0xc013b9bf, 0xbf9b143f, 0x3ffef594, 0x3fdfe9c8,
    0xbf55380a, 0xc006b02d, 0x3ffc0a8b, 0x3fee641f,
    0x3fbed0b3, 0x4026b6a3, 0xc0224400, 0x3fc27464,
    0xc01ed62f, 0xbec25c5a, 0xc0533fc3, 0x40916ce9,
    0xbfd3f1c7, 0xbeb2714a, 0x3fa86a82, 0x3e5424a8,
    0x3ef7ddcf, 0xbfb71a5e, 0x40215cfd, 0x3f3c0ca7,
    0x3fa9b4db, 0x407ceccc, 0xc0213d45, 0xbebec76e,
    0x40240336, 0xc00bc10e, 0x408c5404, 0x3feb6b98,
    0xbf973d77, 0xc0226b23, 0x3fdb64c2, 0xbd76f5da,
    0xbff9eca4, 0x400ab9a5, 0xbfd876d4, 0x3f51330c,
    0x4081c60f, 0xbe473a65, 0x3e7616bc, 0x407ead69,
    0x4016bfdb, 0x40021064, 0xbf71c017, 0xbedb9826,
    0x40586f23, 0x3ecc3e7f, 0x3dc936e2, 0xc087e398,
    0x3feeb53c, 0xbfc7ad8c, 0x3f4d9299, 0x400a4722,
    0x3fd0d9f3, 0x3fac14c2, 0x3fadee57, 0x4085a216,
    0x3f0f57b9, 0xbfab4a66, 0x400853c6, 0x402251d6,
    0xbe9bf45f, 0x404304b1, 0x40b59b7d, 0x3f52aa9e,
    0xc0556734, 0xc05ab774, 0xbea44df1, 0xc0496279,
    0x3f17b2ad, 0x40130957, 0x4023ed3a, 0xbf55d9c4,
    0x3c25fcf8, 0xc049c1ac, 0xbfd7f558, 0xbf518e68,
    0xc0ea474d, 0xbfaa321f, 0x40425bf1, 0xc024d39a,
    0x407c848c, 0xbf41a8c9, 0x3eaf82ee, 0x3ef63b98,
    0xbff07197, 0x3f9b490a, 0xbec47454, 0xc09529c6,
    0x40381c34, 0xbfc6ee36, 0xbf9c7bf7, 0x3f547be1,
    0x40074900, 0x3ed86876, 0xbf9ad6c7, 0xbe936cce,
    0x3f8af2c4, 0x40117d4c, 0x40865d39, 0x40085696,
    0xc00c52fb, 0x3ff8434d, 0x4020cdba, 0xc05011e5,
    0x3f9a14c7, 0xc017ba60, 0x3f835482, 0xbf6c64a1,
    0x404bbca9, 0x409ec6be, 0x3f23b9e0, 0xbdbd69a3,
    0x3f8f01c0, 0x3fd7a58b, 0xbf8fe972, 0x3f9ff0cc,
    0xc0572d26, 0x3f533f65, 0xbfd76d91, 0x3e84632c,
    0xbf3bb895, 0x40285af6, 0x3fbd7c91, 0xbf8dd93d,
    0x3f08bee5, 0xbfe6f6f8, 0x3fabe8c4, 0xc063ab0f,
    0xbf8cee02, 0xbf2244c3, 0x3ecb7369, 0xbf883c05,
    0xc0558db9, 0xc04cd646, 0x3fc74dfb, 0xc01833c1,
    0x3fa5c092, 0xc05719b0, 0x3fd8887a, 0xbe5b2a0e,
    0xbefcf638, 0x3eb1a0d2, 0x408e4e65, 0x40189da3,
    0xc055692e, 0xc03fe7f8, 0x4001a8d0, 0xbf61ec0c,
    0xbe592a78, 0x407f8d9b, 0xbfb2d7d5, 0xbf0587cf,
    0x405b3d6a, 0x3fa456f9, 0x3f03400b, 0xbf23c2cf,
    0x404e1830, 0xbfb7975e, 0x4057825e, 0xc005a19d,
    0xc07b78ff, 0x3fc30deb, 0xbfa9ad79, 0xc09c0f0a,
    0xbfa89759, 0x4024bc71, 0xbe19ca19, 0x4019a9fc,
    0x3eb89160, 0x3ec7db8d, 0x40050c5b, 0xc02a6cb9,
    0x400c3e72, 0x3fe751a9, 0x409f23a3, 0xbfc615ac,
    0xbec81cee, 0xc08898d6, 0x3f3e50d5, 0xbf94fb2e,
    0x3db18d61, 0xbf95649a, 0xbff60106, 0xbe21c4ce,
    0x401cc6d3, 0xbff21bae, 0x3fe7c161, 0x3f7e51db,
    0x3efbcaa6, 0x4052df85, 0xbf1e507b, 0x3f66ed4c,
    0x400774b4, 0xbf5c0c5f, 0x40671649, 0xbd900b65,
    0x3f07f158, 0xbe1d3209, 0x3e15e7f7, 0x407c0456,
    0x3ccfe9fd, 0xbfe16fce, 0xbe9b2648, 0x3f72fc9c,
    0xc097dd90, 0x402f743e, 0x3fa6d634, 0xc0349598,
    0x402d4524, 0xbe390c25, 0x4012487e, 0x3ea0b4af,
    0x4008f8c7, 0x3d258d0e, 0x3fbab730, 0xbf0e616e,
    0x402a1c9d, 0xc012cbfd, 0x3d14b934, 0xbf8066b9,
    0x404dbf64, 0x40a16876, 0xbe69d645, 0x405a93dd,
    0x3fa6b188, 0x3d56a999, 0xc07eeea1, 0x401c2897,
    0x403ff664, 0x3d24a662, 0xbec5493d, 0xbf16c6ef,
    0x4008fba0, 0xbff7df37, 0x3bfaebd0, 0xc036e87b,
    0xc01b5a0b, 0xc02f5f0e, 0xbfb08aad, 0xbf799b3c,
    0x3e7871f6, 0xc0490995, 0x3f9ab3c8, 0xc01027e9,
    0xbf90f2d5, 0xbfa193fa, 0xbfb88ae1, 0xc08ac1f8,
    0x408c7611, 0xbf308ff2, 0x4080cbe1, 0x40803f53,
    0xc01ef997, 0xbff8bfca, 0xbf21536e, 0xbee965d7,
    0x3fc96d6d, 0x3fd5b238, 0x40130973, 0xbfc7fb7c,
    0xbfd1c16b, 0x3faca104, 0xbeac6b07, 0x4086375c,
    0x3ff0d8d5, 0x3f991b07, 0xc046a073, 0xbfb93fba,
    0x3fdb7b4a, 0xbfff921c, 0x403f4c73, 0x408ca508,
    0xc0098472, 0xc00df9a7, 0xbfa3121b, 0xbeb230fa,
    0xc0091e0a, 0x4023d7e5, 0x409728a2, 0xbf2e5ed3,
    0x3f9b78a0, 0x3f0325ee, 0xbf035cbc, 0x400efef9,
    0x3f7d8486, 0x40fcc041, 0xbf987756, 0x3fc2ae42,
    0x3f7d16dc, 0xbfb95c31, 0xc0057837, 0xbf10911f,
    0xbfe403e5, 0xbf4739bd, 0x405748b1, 0x3d8d3373,
    0xbf9e8ab5, 0x40357656, 0x3ed7e15d, 0x408fd53e,
    0xc047bdfe, 0x4058e2a6, 0xc004608c, 0x3f6eb8f5,
    0x405f7c51, 0xbf5edfee, 0xbef163ee, 0xc0bb4c56,
    0xc02440b5, 0xbef3d032, 0xc07005b3, 0x400445a9,
    0xc02880e0, 0x3ebdc232, 0xc0737671, 0xbe96ad2a,
    0xbf6f90ed, 0xc0411951, 0xbf3421c0, 0x404531a7,
    0x3fdb8407, 0xbf355ab5, 0xbfbc26dd, 0x3fdeb6ab,
    0xbff47d06, 0xbe022239, 0x3e94aa51, 0xc054a6c4,
    0x3f299449, 0x3fe9080c, 0xc0031fba, 0xbed28af5,
    0x3fc55aae, 0xbfaaed55, 0xc008ae7b, 0x3e94063e,
    0xbfd8de95, 0xbf85e3c3, 0x3dda950b, 0x40998bdb,
    0xc02f788c, 0xbf96a85b, 0xc00feb10, 0xbdc15445,
    0x4059ba20, 0x3efbf93a, 0xc07dcd48, 0xbd557d87,
    0xbfea8409, 0x3f39f87d, 0xc01ec26f, 0xbf9e7fd8,
    0x404a6f80, 0xbef1ca31, 0x3f79db09, 0xbfdd50d9,
    0x409482f5, 0xbffacac9, 0x3fb50851, 0x4041e46a,
    0x4093003d, 0xbfe4b71f, 0xc06430fc, 0x40482230,
    0x3fe0fca4, 0xbf5d1325, 0x3f9d81dd, 0x3feb9c96,
    0x3f3f1452, 0x404eb3ab, 0x3ff96aa1, 0xbfd7d60c,
    0xc00fda57, 0x40295e6b, 0x3f94ba57, 0xbfaabc94,
    0x3f873ab9, 0x3dd6069b, 0xbe2f9eec, 0xbf016ed8,
    0xbe577a03, 0x3f9fe53f, 0x4061c906, 0xbf909daa,
    0xc004670d, 0x40145c75, 0xc091867e, 0xbf91ed98,
    0x40c062c4, 0xbe772bc0, 0xc05d376b, 0x40b4df69,
    0xc09756d7, 0xbf4e4780, 0xc08154ba, 0xbee0bf2e,
    0xc00961c3, 0xbf058ba6, 0x3fe35746, 0x3e7806d0,
    0xbf9b452f, 0xc047a854, 0x3fba662c, 0x4056c649,
    0xc001c4bb, 0x3e5b9fa7, 0x3f68e7eb, 0xbfbf37f9,
    0x3f2139e2, 0xc08976b3, 0x403e7b34, 0xbf8e50f9,
    0xc0130022, 0xbf6d1197, 0xc03bf6ae, 0xbff734a2,
    0xc042dce4, 0x3e53da3d, 0x4007e231, 0xbf80d42d,
    0x3fa88370, 0x3fd0e84c, 0xc01dc8b9, 0xbf53ec11,
    0xbfcf73bf, 0xbec6cdc1, 0x401de7e2, 0x4027c145,
    0x3e1876a3, 0xc0d95d58, 0xbebc5695, 0x4030c300,
    0x3f9e1a26, 0x404189c5, 0x40428893, 0xc03c6c80,
    0xc0567fff, 0x3f88559b, 0x3ff96e81, 0x4073ba70,
    0x3fb69fbe, 0x40b41324, 0x3c555db2, 0x40a5ceeb,
    0xc009ecb0, 0x3f50ed00, 0x4090006e, 0xbfb3011f,
    0x3fecfa75, 0x3eec6225, 0xbcc506d4, 0x3dbd79aa,
    0x3fbca95a, 0x40832b8b, 0xbfdfcb94, 0xc054fd05,
    0xbf971c1d, 0x40019ac7, 0x3e087175, 0x3f62803a,
    0x406b509b, 0x3fa04f0d, 0xbda5758d, 0xc04ae7bf,
    0x3f843ee6, 0xbf8062a2, 0x402d2958, 0xbfa80589,
    0x3e3dc193, 0x4056b0d1, 0x3d2bbaf0, 0x3fedb003,
    0x3f23e4c4, 0xbf63a1e9, 0xbf33968d, 0xc0091644,
    0xbf95aff3, 0x402312d2, 0xbf70e70e, 0xc0d7055e,
    0x3f94ba3f, 0x4034801d, 0xbfcf1f21, 0x3ec41b58,
    0xbfb60970, 0x3e4cdd84, 0x3fe35ce9, 0xbfd8cfcb,
    0x3ff90046, 0x3fc41248, 0x3f64e3b5, 0x3e6e25eb,
    0xbfdf7ba3, 0x3ed1ea35, 0xc003edc9, 0xbfac2e7d,
    0xbda1acea, 0xbf783557, 0xbfc8568e, 0xbede4117,
    0x3f4b6a8f, 0x3ffd6801, 0xbfe9061d, 0x3fc272bf,
    0x405e09bf, 0xc00ad938, 0xbfc3e690, 0xc00581e4,
    0x3f885a49, 0x3f859d50, 0x3fc5fcbd, 0xbe1d50b4,
    0x3f1336a7, 0xbf8e9ca0, 0x406b208d, 0xc001622f,
    0xbff9ff84, 0x401d2e50, 0x4089dbde, 0x4093ca1f,
    0xbffda12f, 0xbfe660d0, 0xc015a794, 0xbe813195,
    0xbedfdd98, 0xbcd448ce, 0x3da64d6e, 0xbf881042,
    0xc021336c, 0x3f175349, 0x3f969695, 0xbfcc3a40,
    0x3e38a2d9, 0xbf53d8c8, 0xbfa0ffd2, 0xc0872194,
    0x3f1ada1e, 0x3fb89917, 0x3db86a33, 0x403e3c38,
    0xc006028e, 0x40391950, 0xbe977784, 0x3edc1694,
    0xbf0e863d, 0xbfa2f0c7, 0xbe080256, 0x3fd70f12,
    0x40ba6fd7, 0xbf362eee, 0x409bfcc2, 0x40746228,
    0x3f6cb968, 0xbfc5f8ac, 0x40095060, 0xbf8908b7,
    0xc005471f, 0x4030fce8, 0x3eab745d, 0xbf8ede46,
    0x400b5fbd, 0x40098f4f, 0x3f5e927a, 0xc0e62bd0,
    0x407116df, 0xbf7527db, 0xbf111f71, 0x3f69290e,
    0xbfdd8c17, 0x3ff3b3ed, 0x3f5b06b8, 0xbf1b794d,
    0x4025008b, 0xbf98589c, 0xbf5ff0ee, 0xc03888c2,
    0xc001336b, 0x40033712, 0xbfd6267f, 0xbf1df4e2,
    0x4026158c, 0xc04f7450, 0xbf01e34d, 0xbfd50c56,
    0x3f8c2016, 0xc03d1dd4, 0x3f8d3a2c, 0xc0a40c2b,
    0x3ee123da, 0xc0ae73a9, 0xbecff739, 0xbeaef0b5,
    0x3f8f3724, 0x3ee8ef3e, 0x3f12dd24, 0xc012f4d0,
    0x3fafbc7f, 0x4002a56c, 0x4097a275, 0xbff4b0b3,
    0xc08eb718, 0xbdd67d16, 0x3f43397f, 0xc016b933,
    0x3fead629, 0xbf1750aa, 0xbfa0f7b9, 0x3fd5dcde,
    0xbf0bed2d, 0xbe645ae5, 0x3fc27ef9, 0x3fa2997d,
    0x3f9f9f9b, 0x40ace26e, 0x3e4daa71, 0xc02e3297,
    0x3f315f8c, 0xbef5ee01, 0x3e855466, 0x3f1dced3,
    0x3ed023a5, 0x3e3c77d0, 0xbe31034b, 0xbdbe090d,
    0x3ee33036, 0xbfdcf719, 0x3f82e407, 0x40ad255c,
    0xc09ea882, 0xbfaccf7c, 0xbfd342ed, 0xbfcdff7e,
    0x3f67a276, 0x407f4db5, 0x4023a1de, 0xc00ab921,
    0xbfddb070, 0xbeea9113, 0x40b17009, 0xbf16a027,
    0xc09ae618, 0xbf9a7a57, 0x3fb871b2, 0xc03b273d,
    0x408d77c8, 0xbfc785d4, 0xbe938aa4, 0xbf3971c6,
    0xc075f39c, 0x401df0ff, 0xbfbf2ce2, 0x40a6c673,
    0x4011c923, 0x3f681f3d, 0xbfdc517e, 0x3ef2ee04,
    0xbcd70ed4, 0xc05a4f6e, 0x40b0ebe6, 0xbfaad2fb,
    0x4040b8b3, 0x40454815, 0xc05667ed, 0x402a24f4,
    0xc0083585, 0x3fae6310, 0x400d1cfb, 0x401e0da2,
    0xc005d442, 0x40649de6, 0xbe074231, 0xbf987410,
    0xbe8e4e21, 0xbfd2e8d2, 0xbed2c5f9, 0xc00a79ee,
    0xbe30140c, 0xbeeebeec, 0x3ee3acd7, 0xc04e016a,
    0x3fe6167f, 0xbf5c7c7a, 0x3b2616f0, 0xbef5624c,
    0x3fe86864, 0xc08c9175, 0x3ffa7d22, 0x401cdb58,
    0x402514ec, 0xc01ec314, 0xbf87e34c, 0x3f53983c,
    0xbf9916bf, 0xbfed9939, 0xbfadee4a, 0xc04f00fe,
    0xc0894401, 0xc081fd26, 0xc030a022, 0xbee4fcc3,
    0x3ee51476, 0xbcb27587, 0xc045dabc, 0xc06dbf17,
    0x40084e6a, 0xc026b6d0, 0xc0526eff, 0x409c0b20,
    0x409f3c9c, 0x3ec8f40d, 0xbfa61697, 0x3f68c68c,
    0x402cec86, 0xbfa2a040, 0x3f44f358, 0x3fb9786d,
    0xbfc0700a, 0x4066e98e, 0x3f19cbbe, 0xc089c2b5,
    0xc04165f1, 0x409143c8, 0xbf3d3b17, 0xbf652855,
    0xbf1b0fae, 0xbfc8c2b5, 0xc02f6ad2, 0xbf5cb87e,
    0x4057497e, 0xc0728220, 0xc0711ed9, 0x3f0aeddf,
    0x40199549, 0x4038b950, 0xc00b4565, 0x40036a3b,
    0xbf10d0dd, 0x3ff11626, 0xc08ac8a3, 0xbf132276,
    0x3d2a3f42, 0xbfdb2f8b, 0x4054933f, 0xbf252f05,
    0x403112e7, 0x401034f4, 0x40033506, 0x402aca3f,
    0x400e60de, 0xbbb2d421, 0x40785061, 0xbf8f8a1e,
    0xbc1f88d9, 0x4006a36d, 0xbfe036f0, 0xc0248ffe,
    0xbfa191f1, 0xbf9c2de0, 0xbf1c327b, 0xbee927f8,
    0xc085fb19, 0x3f9f52d5, 0x3ebc028a, 0x4043e056,
    0xc039c79b, 0x3fba0b09, 0x3f9ffac1, 0xc04948d0,
    0xbf967fbc, 0xbfc2f95d, 0x3fba455c, 0x3f6b7150,
    0xc0086475, 0x4025c20b, 0x400f479a, 0x3fe33456,
    0xbf539285, 0xc0046dc3, 0xbfcb1e5f, 0x401ffdb6,
    0xbf61a349, 0xbf9be48c, 0xc0160e84, 0x3f34db5e,
    0xc00f7afc, 0xbf6c05b4, 0xbe017fb9, 0x3ec440db,
    0xbf8b55e4, 0xbfc05958, 0xc053ae0f, 0x3f5efd15,
    0x3f4e82f3, 0xbfb84f20, 0x3f17f1b5, 0x401e46b2,
    0xc01510ff, 0xbf82dff4, 0xc04ecd78, 0xbfb04c78,
    0x3fa2a9a8, 0xbfeb4d15, 0xc01cbea8, 0x3ddec74b,
    0xbf41a69b, 0x3f1e8801, 0xbf9de903, 0xbfd62906,
    0x3ffad4e7, 0xbff740dc, 0x3e6cb6b1, 0xbfa916a4,
    0xbfcddbf5, 0x3feda832, 0xc016dbb4, 0x3f8b7bb1,
    0xc03edabc, 0xbecf6f22, 0xc03512ac, 0x3ebfb936,
    0xbfc5b927, 0xc07bbeb2, 0xc0867579, 0x400ab568,
    0xc023b8d5, 0x3eb6bd04, 0x40214580, 0x4020ee56,
    0x3eb7b63a, 0x402a178d, 0xbed595b1, 0xbe85801d,
    0xc085afee, 0xc08d7569, 0x40078165, 0x3ff7c529,
    0x3f521969, 0x401210f8, 0xc03f7622, 0x3f44df71,
    0xbfb3335b, 0xbf10d47b, 0xbd0f7fc5, 0xc01fc234,
    0xbfae4c5d, 0xc05464e1, 0xbe1c697f, 0x3f2e8044,
    0x3ef48414, 0x4074f9cf, 0x400b1e69, 0x408849f2,
    0x40001abb, 0x3de0f5e3, 0xbef61ec3, 0xbe9f9325,
    0xc0332c44, 0x3fa3225d, 0xc04e09c2, 0x4007541c,
    0xbfde22ce, 0xc00d8f4b, 0xbd051039, 0xc022b795,
    0x3f309195, 0x40b341f6, 0xbfb98c57, 0xc0019d39,
    0xbec05896, 0xc0795665, 0x3ebc72e3, 0xbeb74156,
    0x3fd31f67, 0xbfb42e53, 0xc031835a, 0x3f312621,
    0xbb898579, 0x40a4b4c2, 0x3c154986, 0x3f705a3d,
    0xbfc4e935, 0xbfd98422, 0xbe74f759, 0x3fe570af,
    0xc0170d00, 0xc03bb273, 0xbfccb124, 0xbff7cb0e,
    0x3f38048a, 0xc038de03, 0x3dbd2482, 0xbdb54069,
    0x3ef64223, 0x3f9376a4, 0xbdaa3198, 0x3f89662e,
    0x3f8ec668, 0x40933a4a, 0xbf6a366d, 0xbfd1a329,
    0x3f9a2bf4, 0xbfebb823, 0x3fd451ea, 0x401fce17,
    0x403885bd, 0xbe4820a2, 0x3f70b5b9, 0x3fd3e08f,
    0x407599cf, 0xbfae2a57, 0x3f239f77, 0x3faf03fc,
    0x3e160d65, 0x3eb5e094, 0xbf00dd66, 0x3f895379,
    0x3ecc369b, 0xc06283c4, 0xc0278fa9, 0x3fb8dd21,
    0x40913c37, 0x3e8762a3, 0x3f11ba76, 0x3fc9f4c4,
    0x4048f19c, 0x4011c4ad, 0x4042622e, 0xc06d0cd7,
    0x4042be32, 0x406bec73, 0xbf523d39, 0xbead9855,
    0x3f88d690, 0x400fa9b9, 0xc05c9d5b, 0xbee7a719,
    0xbe7dfa1c, 0xbf89dc0d, 0xc027f81b, 0xbf33d9e2,
    0xbf31d1a1, 0xc019a207, 0x3d510e6b, 0xbfc18c57,
    0xbe4954b0, 0x0, 0x3d510e6b, 0x3fc18c57,
    0xbf31d1a1, 0x4019a207, 0xc027f81b, 0x3f33d9e2,
    0xbe7dfa1c, 0x3f89dc0d, 0xc05c9d5b, 0x3ee7a719,
    0x3f88d690, 0xc00fa9b9, 0xbf523d39, 0x3ead9855,
    0x4042be32, 0xc06bec73, 0x4042622e, 0x406d0cd7,
    0x4048f19c, 0xc011c4ad, 0x3f11ba76, 0xbfc9f4c4,
    0x40913c37, 0xbe8762a3, 0xc0278fa9, 0xbfb8dd21,
    0x3ecc369b, 0x406283c4, 0xbf00dd66, 0xbf895379,
    0x3e160d65, 0xbeb5e094, 0x3f239f77, 0xbfaf03fc,
    0x407599cf, 0x3fae2a57, 0x3f70b5b9, 0xbfd3e08f,
    0x403885bd, 0x3e4820a2, 0x3fd451ea, 0xc01fce17,
    0x3f9a2bf4, 0x3febb823, 0xbf6a366d, 0x3fd1a329,
    0x3f8ec668, 0xc0933a4a, 0xbdaa3198, 0xbf89662e,
    0x3ef64223, 0xbf9376a4, 0x3dbd2482, 0x3db54069,
    0x3f38048a, 0x4038de03, 0xbfccb124, 0x3ff7cb0e,
    0xc0170d00, 0x403bb273, 0xbe74f759, 0xbfe570af,
    0xbfc4e935, 0x3fd98422, 0x3c154986, 0xbf705a3d,
    0xbb898579, 0xc0a4b4c2, 0xc031835a, 0xbf312621,
    0x3fd31f67, 0x3fb42e53, 0x3ebc72e3, 0x3eb74156,
    0xbec05896, 0x40795665, 0xbfb98c57, 0x40019d39,
    0x3f309195, 0xc0b341f6, 0xbd051039, 0x4022b795,
    0xbfde22ce, 0x400d8f4b, 0xc04e09c2, 0xc007541c,
    0xc0332c44, 0xbfa3225d, 0xbef61ec3, 0x3e9f9325,
    0x40001abb, 0xbde0f5e3, 0x400b1e69, 0xc08849f2,
    0x3ef48414, 0xc074f9cf, 0xbe1c697f, 0xbf2e8044,
    0xbfae4c5d, 0x405464e1, 0xbd0f7fc5, 0x401fc234,
    0xbfb3335b, 0x3f10d47b, 0xc03f7622, 0xbf44df71,
    0x3f521969, 0xc01210f8, 0x40078165, 0xbff7c529,
    0xc085afee, 0x408d7569, 0xbed595b1, 0x3e85801d,
    0x3eb7b63a, 0xc02a178d, 0x40214580, 0xc020ee56,
    0xc023b8d5, 0xbeb6bd04, 0xc0867579, 0xc00ab568,
    0xbfc5b927, 0x407bbeb2, 0xc03512ac, 0xbebfb936,
    0xc03edabc, 0x3ecf6f22, 0xc016dbb4, 0xbf8b7bb1,
    0xbfcddbf5, 0xbfeda832, 0x3e6cb6b1, 0x3fa916a4,
    0x3ffad4e7, 0x3ff740dc, 0xbf9de903, 0x3fd62906,
    0xbf41a69b, 0xbf1e8801, 0xc01cbea8, 0xbddec74b,
    0x3fa2a9a8, 0x3feb4d15, 0xc04ecd78, 0x3fb04c78,
    0xc01510ff, 0x3f82dff4, 0x3f17f1b5, 0xc01e46b2,
    0x3f4e82f3, 0x3fb84f20, 0xc053ae0f, 0xbf5efd15,
    0xbf8b55e4, 0x3fc05958, 0xbe017fb9, 0xbec440db,
    0xc00f7afc, 0x3f6c05b4, 0xc0160e84, 0xbf34db5e,
    0xbf61a349, 0x3f9be48c, 0xbfcb1e5f, 0xc01ffdb6,
    0xbf539285, 0x40046dc3, 0x400f479a, 0xbfe33456,
    0xc0086475, 0xc025c20b, 0x3fba455c, 0xbf6b7150,
    0xbf967fbc, 0x3fc2f95d, 0x3f9ffac1, 0x404948d0,
    0xc039c79b, 0xbfba0b09, 0x3ebc028a, 0xc043e056,
    0xc085fb19, 0xbf9f52d5, 0xbf1c327b, 0x3ee927f8,
    0xbfa191f1, 0x3f9c2de0, 0xbfe036f0, 0x40248ffe,
    0xbc1f88d9, 0xc006a36d, 0x40785061, 0x3f8f8a1e,
    0x400e60de, 0x3bb2d421, 0x40033506, 0xc02aca3f,
    0x403112e7, 0xc01034f4, 0x4054933f, 0x3f252f05,
    0x3d2a3f42, 0x3fdb2f8b, 0xc08ac8a3, 0x3f132276,
    0xbf10d0dd, 0xbff11626, 0xc00b4565, 0xc0036a3b,
    0x40199549, 0xc038b950, 0xc0711ed9, 0xbf0aeddf,
    0x4057497e, 0x40728220, 0xc02f6ad2, 0x3f5cb87e,
    0xbf1b0fae, 0x3fc8c2b5, 0xbf3d3b17, 0x3f652855,
    0xc04165f1, 0xc09143c8, 0x3f19cbbe, 0x4089c2b5,
    0xbfc0700a, 0xc066e98e, 0x3f44f358, 0xbfb9786d,
    0x402cec86, 0x3fa2a040, 0xbfa61697, 0xbf68c68c,
    0x409f3c9c, 0xbec8f40d, 0xc0526eff, 0xc09c0b20,
    0x40084e6a, 0x4026b6d0, 0xc045dabc, 0x406dbf17,
    0x3ee51476, 0x3cb27587, 0xc030a022, 0x3ee4fcc3,
    0xc0894401, 0x4081fd26, 0xbfadee4a, 0x404f00fe,
    0xbf9916bf, 0x3fed9939, 0xbf87e34c, 0xbf53983c,
    0x402514ec, 0x401ec314, 0x3ffa7d22, 0xc01cdb58,
    0x3fe86864, 0x408c9175, 0x3b2616f0, 0x3ef5624c,
    0x3fe6167f, 0x3f5c7c7a, 0x3ee3acd7, 0x404e016a,
    0xbe30140c, 0x3eeebeec, 0xbed2c5f9, 0x400a79ee,
    0xbe8e4e21, 0x3fd2e8d2, 0xbe074231, 0x3f987410,
    0xc005d442, 0xc0649de6, 0x400d1cfb, 0xc01e0da2,
    0xc0083585, 0xbfae6310, 0xc05667ed, 0xc02a24f4,
    0x4040b8b3, 0xc0454815, 0x40b0ebe6, 0x3faad2fb,
    0xbcd70ed4, 0x405a4f6e, 0xbfdc517e, 0xbef2ee04,
    0x4011c923, 0xbf681f3d, 0xbfbf2ce2, 0xc0a6c673,
    0xc075f39c, 0xc01df0ff, 0xbe938aa4, 0x3f3971c6,
    0x408d77c8, 0x3fc785d4, 0x3fb871b2, 0x403b273d,
    0xc09ae618, 0x3f9a7a57, 0x40b17009, 0x3f16a027,
    0xbfddb070, 0x3eea9113, 0x4023a1de, 0x400ab921,
    0x3f67a276, 0xc07f4db5, 0xbfd342ed, 0x3fcdff7e,
    0xc09ea882, 0x3faccf7c, 0x3f82e407, 0xc0ad255c,
    0x3ee33036, 0x3fdcf719, 0xbe31034b, 0x3dbe090d,
    0x3ed023a5, 0xbe3c77d0, 0x3e855466, 0xbf1dced3,
    0x3f315f8c, 0x3ef5ee01, 0x3e4daa71, 0x402e3297,
    0x3f9f9f9b, 0xc0ace26e, 0x3fc27ef9, 0xbfa2997d,
    0xbf0bed2d, 0x3e645ae5, 0xbfa0f7b9, 0xbfd5dcde,
    0x3fead629, 0x3f1750aa, 0x3f43397f, 0x4016b933,
    0xc08eb718, 0x3dd67d16, 0x4097a275, 0x3ff4b0b3,
    0x3fafbc7f, 0xc002a56c, 0x3f12dd24, 0x4012f4d0,
    0x3f8f3724, 0xbee8ef3e, 0xbecff739, 0x3eaef0b5,
    0x3ee123da, 0x40ae73a9, 0x3f8d3a2c, 0x40a40c2b,
    0x3f8c2016, 0x403d1dd4, 0xbf01e34d, 0x3fd50c56,
    0x4026158c, 0x404f7450, 0xbfd6267f, 0x3f1df4e2,
    0xc001336b, 0xc0033712, 0xbf5ff0ee, 0x403888c2,
    0x4025008b, 0x3f98589c, 0x3f5b06b8, 0x3f1b794d,
    0xbfdd8c17, 0xbff3b3ed, 0xbf111f71, 0xbf69290e,
    0x407116df, 0x3f7527db, 0x3f5e927a, 0x40e62bd0,
    0x400b5fbd, 0xc0098f4f, 0x3eab745d, 0x3f8ede46,
    0xc005471f, 0xc030fce8, 0x40095060, 0x3f8908b7,
    0x3f6cb968, 0x3fc5f8ac, 0x409bfcc2, 0xc0746228,
    0x40ba6fd7, 0x3f362eee, 0xbe080256, 0xbfd70f12,
    0xbf0e863d, 0x3fa2f0c7, 0xbe977784, 0xbedc1694,
    0xc006028e, 0xc0391950, 0x3db86a33, 0xc03e3c38,
    0x3f1ada1e, 0xbfb89917, 0xbfa0ffd2, 0x40872194,
    0x3e38a2d9, 0x3f53d8c8, 0x3f969695, 0x3fcc3a40,
    0xc021336c, 0xbf175349, 0x3da64d6e, 0x3f881042,
    0xbedfdd98, 0x3cd448ce, 0xc015a794, 0x3e813195,
    0xbffda12f, 0x3fe660d0, 0x4089dbde, 0xc093ca1f,
    0xbff9ff84, 0xc01d2e50, 0x406b208d, 0x4001622f,
    0x3f1336a7, 0x3f8e9ca0, 0x3fc5fcbd, 0x3e1d50b4,
    0x3f885a49, 0xbf859d50, 0xbfc3e690, 0x400581e4,
    0x405e09bf, 0x400ad938, 0xbfe9061d, 0xbfc272bf,
    0x3f4b6a8f, 0xbffd6801, 0xbfc8568e, 0x3ede4117,
    0xbda1acea, 0x3f783557, 0xc003edc9, 0x3fac2e7d,
    0xbfdf7ba3, 0xbed1ea35, 0x3f64e3b5, 0xbe6e25eb,
    0x3ff90046, 0xbfc41248, 0x3fe35ce9, 0x3fd8cfcb,
    0xbfb60970, 0xbe4cdd84, 0xbfcf1f21, 0xbec41b58,
    0x3f94ba3f, 0xc034801d, 0xbf70e70e, 0x40d7055e,
    0xbf95aff3, 0xc02312d2, 0xbf33968d, 0x40091644,
    0x3f23e4c4, 0x3f63a1e9, 0x3d2bbaf0, 0xbfedb003,
    0x3e3dc193, 0xc056b0d1, 0x402d2958, 0x3fa80589,
    0x3f843ee6, 0x3f8062a2, 0xbda5758d, 0x404ae7bf,
    0x406b509b, 0xbfa04f0d, 0x3e087175, 0xbf62803a,
    0xbf971c1d, 0xc0019ac7, 0xbfdfcb94, 0x4054fd05,
    0x3fbca95a, 0xc0832b8b, 0xbcc506d4, 0xbdbd79aa,
    0x3fecfa75, 0xbeec6225, 0x4090006e, 0x3fb3011f,
    0xc009ecb0, 0xbf50ed00, 0x3c555db2, 0xc0a5ceeb,
    0x3fb69fbe, 0xc0b41324, 0x3ff96e81, 0xc073ba70,
    0xc0567fff, 0xbf88559b, 0x40428893, 0x403c6c80,
    0x3f9e1a26, 0xc04189c5, 0xbebc5695, 0xc030c300,
    0x3e1876a3, 0x40d95d58, 0x401de7e2, 0xc027c145,
    0xbfcf73bf, 0x3ec6cdc1, 0xc01dc8b9, 0x3f53ec11,
    0x3fa88370, 0xbfd0e84c, 0x4007e231, 0x3f80d42d,
    0xc042dce4, 0xbe53da3d, 0xc03bf6ae, 0x3ff734a2,
    0xc0130022, 0x3f6d1197, 0x403e7b34, 0x3f8e50f9,
    0x3f2139e2, 0x408976b3, 0x3f68e7eb, 0x3fbf37f9,
    0xc001c4bb, 0xbe5b9fa7, 0x3fba662c, 0xc056c649,
    0xbf9b452f, 0x4047a854, 0x3fe35746, 0xbe7806d0,
    0xc00961c3, 0x3f058ba6, 0xc08154ba, 0x3ee0bf2e,
    0xc09756d7, 0x3f4e4780, 0xc05d376b, 0xc0b4df69,
    0x40c062c4, 0x3e772bc0, 0xc091867e, 0x3f91ed98,
    0xc004670d, 0xc0145c75, 0x4061c906, 0x3f909daa,
    0xbe577a03, 0xbf9fe53f, 0xbe2f9eec, 0x3f016ed8,
    0x3f873ab9, 0xbdd6069b, 0x3f94ba57, 0x3faabc94,
    0xc00fda57, 0xc0295e6b, 0x3ff96aa1, 0x3fd7d60c,
    0x3f3f1452, 0xc04eb3ab, 0x3f9d81dd, 0xbfeb9c96,
    0x3fe0fca4, 0x3f5d1325, 0xc06430fc, 0xc0482230,
    0x4093003d, 0x3fe4b71f, 0x3fb50851, 0xc041e46a,
    0x409482f5, 0x3ffacac9, 0x3f79db09, 0x3fdd50d9,
    0x404a6f80, 0x3ef1ca31, 0xc01ec26f, 0x3f9e7fd8,
    0xbfea8409, 0xbf39f87d, 0xc07dcd48, 0x3d557d87,
    0x4059ba20, 0xbefbf93a, 0xc00feb10, 0x3dc15445,
    0xc02f788c, 0x3f96a85b, 0x3dda950b, 0xc0998bdb,
    0xbfd8de95, 0x3f85e3c3, 0xc008ae7b, 0xbe94063e,
    0x3fc55aae, 0x3faaed55, 0xc0031fba, 0x3ed28af5,
    0x3f299449, 0xbfe9080c, 0x3e94aa51, 0x4054a6c4,
    0xbff47d06, 0x3e022239, 0xbfbc26dd, 0xbfdeb6ab,
    0x3fdb8407, 0x3f355ab5, 0xbf3421c0, 0xc04531a7,
    0xbf6f90ed, 0x40411951, 0xc0737671, 0x3e96ad2a,
    0xc02880e0, 0xbebdc232, 0xc07005b3, 0xc00445a9,
    0xc02440b5, 0x3ef3d032, 0xbef163ee, 0x40bb4c56,
    0x405f7c51, 0x3f5edfee, 0xc004608c, 0xbf6eb8f5,
    0xc047bdfe, 0xc058e2a6, 0x3ed7e15d, 0xc08fd53e,
    0xbf9e8ab5, 0xc0357656, 0x405748b1, 0xbd8d3373,
    0xbfe403e5, 0x3f4739bd, 0xc0057837, 0x3f10911f,
    0x3f7d16dc, 0x3fb95c31, 0xbf987756, 0xbfc2ae42,
    0x3f7d8486, 0xc0fcc041, 0xbf035cbc, 0xc00efef9,
    0x3f9b78a0, 0xbf0325ee, 0x409728a2, 0x3f2e5ed3,
    0xc0091e0a, 0xc023d7e5, 0xbfa3121b, 0x3eb230fa,
    0xc0098472, 0x400df9a7, 0x403f4c73, 0xc08ca508,
    0x3fdb7b4a, 0x3fff921c, 0xc046a073, 0x3fb93fba,
    0x3ff0d8d5, 0xbf991b07, 0xbeac6b07, 0xc086375c,
    0xbfd1c16b, 0xbfaca104, 0x40130973, 0x3fc7fb7c,
    0x3fc96d6d, 0xbfd5b238, 0xbf21536e, 0x3ee965d7,
    0xc01ef997, 0x3ff8bfca, 0x4080cbe1, 0xc0803f53,
    0x408c7611, 0x3f308ff2, 0xbfb88ae1, 0x408ac1f8,
    0xbf90f2d5, 0x3fa193fa, 0x3f9ab3c8, 0x401027e9,
    0x3e7871f6, 0x40490995, 0xbfb08aad, 0x3f799b3c,
    0xc01b5a0b, 0x402f5f0e, 0x3bfaebd0, 0x4036e87b,
    0x4008fba0, 0x3ff7df37, 0xbec5493d, 0x3f16c6ef,
    0x403ff664, 0xbd24a662, 0xc07eeea1, 0xc01c2897,
    0x3fa6b188, 0xbd56a999, 0xbe69d645, 0xc05a93dd,
    0x404dbf64, 0xc0a16876, 0x3d14b934, 0x3f8066b9,
    0x402a1c9d, 0x4012cbfd, 0x3fbab730, 0x3f0e616e,
    0x4008f8c7, 0xbd258d0e, 0x4012487e, 0xbea0b4af,
    0x402d4524, 0x3e390c25, 0x3fa6d634, 0x40349598,
    0xc097dd90, 0xc02f743e, 0xbe9b2648, 0xbf72fc9c,
    0x3ccfe9fd, 0x3fe16fce, 0x3e15e7f7, 0xc07c0456,
    0x3f07f158, 0x3e1d3209, 0x40671649, 0x3d900b65,
    0x400774b4, 0x3f5c0c5f, 0xbf1e507b, 0xbf66ed4c,
    0x3efbcaa6, 0xc052df85, 0x3fe7c161, 0xbf7e51db,
    0x401cc6d3, 0x3ff21bae, 0xbff60106, 0x3e21c4ce,
    0x3db18d61, 0x3f95649a, 0x3f3e50d5, 0x3f94fb2e,
    0xbec81cee, 0x408898d6, 0x409f23a3, 0x3fc615ac,
    0x400c3e72, 0xbfe751a9, 0x40050c5b, 0x402a6cb9,
    0x3eb89160, 0xbec7db8d, 0xbe19ca19, 0xc019a9fc,
    0xbfa89759, 0xc024bc71, 0xbfa9ad79, 0x409c0f0a,
    0xc07b78ff, 0xbfc30deb, 0x4057825e, 0x4005a19d,
    0x404e1830, 0x3fb7975e, 0x3f03400b, 0x3f23c2cf,
    0x405b3d6a, 0xbfa456f9, 0xbfb2d7d5, 0x3f0587cf,
    0xbe592a78, 0xc07f8d9b, 0x4001a8d0, 0x3f61ec0c,
    0xc055692e, 0x403fe7f8, 0x408e4e65, 0xc0189da3,
    0xbefcf638, 0xbeb1a0d2, 0x3fd8887a, 0x3e5b2a0e,
    0x3fa5c092, 0x405719b0, 0x3fc74dfb, 0x401833c1,
    0xc0558db9, 0x404cd646, 0x3ecb7369, 0x3f883c05,
    0xbf8cee02, 0x3f2244c3, 0x3fabe8c4, 0x4063ab0f,
    0x3f08bee5, 0x3fe6f6f8, 0x3fbd7c91, 0x3f8dd93d,
    0xbf3bb895, 0xc0285af6, 0xbfd76d91, 0xbe84632c,
    0xc0572d26, 0xbf533f65, 0xbf8fe972, 0xbf9ff0cc,
    0x3f8f01c0, 0xbfd7a58b, 0x3f23b9e0, 0x3dbd69a3,
    0x404bbca9, 0xc09ec6be, 0x3f835482, 0x3f6c64a1,
    0x3f9a14c7, 0x4017ba60, 0x4020cdba, 0x405011e5,
    0xc00c52fb, 0xbff8434d, 0x40865d39, 0xc0085696,
    0x3f8af2c4, 0xc0117d4c, 0xbf9ad6c7, 0x3e936cce,
    0x40074900, 0xbed86876, 0xbf9c7bf7, 0xbf547be1,
    0x40381c34, 0x3fc6ee36, 0xbec47454, 0x409529c6,
    0xbff07197, 0xbf9b490a, 0x3eaf82ee, 0xbef63b98,
    0x407c848c, 0x3f41a8c9, 0x40425bf1, 0x4024d39a,
    0xc0ea474d, 0x3faa321f, 0xbfd7f558, 0x3f518e68,
    0x3c25fcf8, 0x4049c1ac, 0x4023ed3a, 0x3f55d9c4,
    0x3f17b2ad, 0xc0130957, 0xbea44df1, 0x40496279,
    0xc0556734, 0x405ab774, 0x40b59b7d, 0xbf52aa9e,
    0xbe9bf45f, 0xc04304b1, 0x400853c6, 0xc02251d6,
    0x3f0f57b9, 0x3fab4a66, 0x3fadee57, 0xc085a216,
    0x3fd0d9f3, 0xbfac14c2, 0x3f4d9299, 0xc00a4722,
    0x3feeb53c, 0x3fc7ad8c, 0x3dc936e2, 0x4087e398,
    0x40586f23, 0xbecc3e7f, 0xbf71c017, 0x3edb9826,
    0x4016bfdb, 0xc0021064, 0x3e7616bc, 0xc07ead69,
    0x4081c60f, 0x3e473a65, 0xbfd876d4, 0xbf51330c,
    0xbff9eca4, 0xc00ab9a5, 0x3fdb64c2, 0x3d76f5da,
    0xbf973d77, 0x40226b23, 0x408c5404, 0xbfeb6b98,
    0x40240336, 0x400bc10e, 0xc0213d45, 0x3ebec76e,
    0x3fa9b4db, 0xc07ceccc, 0x40215cfd, 0xbf3c0ca7,
    0x3ef7ddcf, 0x3fb71a5e, 0x3fa86a82, 0xbe5424a8,
    0xbfd3f1c7, 0x3eb2714a, 0xc0533fc3, 0xc0916ce9,
    0xc01ed62f, 0x3ec25c5a, 0xc0224400, 0xbfc27464,
    0x3fbed0b3, 0xc026b6a3, 0x3ffc0a8b, 0xbfee641f,
    0xbf55380a, 0x4006b02d, 0x3ffef594, 0xbfdfe9c8,
    0xc013b9bf, 0x3f9b143f, 0x404fa7a7, 0x406773cd,
    0xbe96959b, 0xc05aaf4e, 0xc0211ce7, 0x4068723a,
    0xbf1661a9, 0xc0909e52, 0xc02197b9, 0x3f026368,
    0xbfdb0cba, 0x40407541, 0x40596858, 0x3f4e4194,
    0xc014ed81, 0xbeb26e5f, 0xbfa6451a, 0x3f2d9e93,
    0x3fa33181, 0x3f8cd489, 0x3f14022c, 0x401cf110,
    0x3f8d751a, 0x3f75c4ae, 0x3e0eaf34, 0xbfac4725,
    0x3f8b64b7, 0xbd5ccc2d, 0xbf6a4ce9, 0x3eaad797,
    0xc03e1993, 0xbd854f7e, 0xbfb884d9, 0xc0865661,
    0x3fced90e, 0xbe8b0e8a, 0xbf669f6f, 0x3fe383e4,
    0x3fc88c7b, 0xc06452b8, 0x40527c45, 0x3fd610c9,
    0xc007ebe1, 0x4043a73e, 0x3cbca922, 0x3e8878b4,
    0xc04b5d6d, 0xbf993a7f, 0xbdf3d7f3, 0x3f93d1aa,
    0x3ea935d4, 0x40033a46, 0x406f81f9, 0xbfc3624c,
    0x3e595593, 0x3fd4fab7, 0xbf2084af, 0xbee2e45f,
    0x3ebca4d5, 0xc07585b2, 0x3fa5d66e, 0x3f809d61,
    0xc05b6c19, 0x3f28558e, 0xc0900175, 0x4006b660,
    0xc0608ebc, 0xbf247a27, 0x409d582a, 0xbfb086d0,
    0xbfab7051, 0xc09fb867, 0xc0543119, 0x40851e73,
    0xc00a14de, 0x3d232bb7, 0x40219574, 0x407929f1,
    0x402e8866, 0xc08e104f, 0x40ad161a, 0xbf3bd919,
    0xbed84983, 0x3f70491b, 0xbff74173, 0xc0983689,
    0xbeb3b26a, 0xbf517dfe, 0xc02e6c53, 0xbf07d6e9,
    0x401d07dc, 0x3fa9c0e9, 0x40467d2d, 0x40109225,
    0xbf791da4, 0x3f962f00, 0xc04c59c9, 0x3fb60adc,
    0x3ff27a97, 0x40062951, 0x40811174, 0x405bda33,
    0x3fa6c212, 0x3fea3ebb, 0x3f4ef23d, 0xbd6aec86,
    0xbe3ca506, 0x405a1a7e, 0x4016c883, 0x3e366955,
    0xbfb29dc0, 0x4032e267, 0x3f0b2f65, 0x3f2a8d11,
    0x4021bbfe, 0x3f7fdc8b, 0x401a4896, 0xbd1da05e,
    0xc0714b50, 0xbd90a7c9, 0xbfc0c1c0, 0x40107951,
    0x3fe8642b, 0x3f048a66, 0xc01e3664, 0x403453a2,
    0xbecd4104, 0x3fa9b6ba, 0xbf80ba61, 0x406822af,
    0xc0331996, 0x3fc66792, 0xbfddb5cf, 0x3fda0b0e,
    0xc0888458, 0xbff0b154, 0xbf7e3b3f, 0xc0333b02,
    0xbe2dcc7a, 0x3f5f4092, 0x3fcd01a9, 0xbf966e05,
    0x3d82eb64, 0xc00a3860, 0xbf82dbdd, 0x4034fdf5,
    0xbe98e18d, 0xbf8f82e3, 0x3feb205e, 0xbf00d110,
    0x4008e9a0, 0xc035b946, 0xbe5edc8b, 0xc05bb737,
    0x3e9a8274, 0xbd2bed2d, 0x3ddd1b9e, 0x3e0b0b3d,
    0x404cb42f, 0xbf8288d8, 0x3fcabe49, 0xc0587668,
    0x4009593f, 0xbf0caf8b, 0xbe83e243, 0xc0b81ec2,
    0x3e0905e4, 0x40b1d267, 0x4020cb37, 0xbe77cdbf,
    0xc0033101, 0x3ff064da, 0xc00f654a, 0xbfa777ed,
    0x3f8a803e, 0x3ef8494f, 0xbf1d42de, 0xbd115d17,
    0x3f827a85, 0xbfb52564, 0xbd96dca1, 0x3fc9b864,
    0x40530a11, 0xc016e7aa, 0xbf13f7b2, 0x4005bcb2,
    0x3f0a06a5, 0xbfd0b0a9, 0x400a93ec, 0x40216a9d,
    0x406acd6a, 0x3f2c1493, 0xc032deac, 0x3fca6f24,
    0xc073315a, 0x3f8f2cb4, 0xbf8670cc, 0x3ddf37bd,
    0x3f23d5a7, 0xc02977e1, 0x3ef2f601, 0xbef11d35,
    0xc04718bd, 0xbf34c667, 0xc0089b1d, 0x3e867f62,
    0xc0108c0c, 0xc00c14ae, 0x3fdcf3ea, 0xc011bea6,
    0xbfec695b, 0x4033ef87, 0x3f9939cb, 0xbf9a460a,
    0x3fabbbe9, 0x3e0ebcf9, 0x405aadf3, 0xbfbf325e,
    0x3f3584d8, 0x3e29b09e, 0xbe698fd2, 0x3fb42d3b,
    0xc04943c3, 0x3d079312, 0x3f737f36, 0x3df83340,
    0xc05ff90a, 0xbf4f1f41, 0x40375c6d, 0xbe9d27a0,
    0x409fd96e, 0x3fe6df0f, 0x40685c1b, 0x3f88e29c,
    0x3fea33d0, 0xbf7b5b99, 0x3f6f0460, 0x3fc080fa,
    0x4062c771, 0x3fdaab74, 0x40154331, 0x3e8001f3,
    0x4002b371, 0x40055352, 0x3fc1b2e2, 0x3f9859eb,
    0x406862ce, 0xbe9c0180, 0xc08c3078, 0xbfd8a87a,
    0xc0849812, 0x4080e4cb, 0x40330fef, 0xbe278a28,
    0x40131b97, 0xc014a611, 0xbf58b50d, 0xbe1d8ad5,
    0x3feedfa4, 0xc046170d, 0xc08aa950, 0x3d37afc8,
    0x40f04821, 0xbfa303f6, 0x40374d55, 0xc003824e,
    0xbd6825d8, 0x4008c61a, 0xbfe426c8, 0x3e9dc0e4,
    0x3f2cfead, 0x4035091c, 0x4082b027, 0xc046a989,
    0x3cda7ede, 0x3f360f71, 0xbe4fadb0, 0xbf6d2a0b,
    0x3f4b7703, 0xc072f3a2, 0xbea2fbf0, 0x3f39bb98,
    0x3f976435, 0xbf95a3ba, 0x3f87c4d2, 0x4019e7e7,
    0x40156f17, 0xc08726d1, 0x3e080eec, 0xc0063c70,
    0xc06cfd14, 0xc056b840, 0xc053d9c5, 0xc0635306,
    0x3fe45933, 0xbf686a0c, 0xbf76a306, 0xc006b2f8,
    0x3f8b0c15, 0xbf1d58d7, 0xc08cb691, 0xbf5d10f8,
    0x3ffdc25d, 0xbfbd55e3, 0x404d92e4, 0x3f913950,
    0xc09199e8, 0xbfdfa76c, 0xbf9183c7, 0xbd8e0747,
    0xc0759e61, 0xbd8a1714, 0x3f91ed12, 0xbfbd3377,
    0xbf46b9cd, 0x3ec3726b, 0x3f763a2f, 0xbfa6eec6,
    0x3e694cd2, 0x402da1df, 0x3f39baf5, 0x3f9736d8,
    0xbc49a1ba, 0xc0296e34, 0x3eb3803d, 0x40e06d3a,
    0x3e254667, 0xbf36027b, 0xbf5f42f8, 0xbff72294,
    0xc0247613, 0xc0015ae9, 0x403282e9, 0x3fff084f,
    0x3eeabf9c, 0x403efd25, 0xbf740a6d, 0x3d9af381,
    0x40039a80, 0xbfc655a7, 0xc02b7f8d, 0x3f907e81,
    0xbe43966e, 0x3f82b701, 0xbf8e7422, 0xc024b7b3,
    0xbdc1fae3, 0xbecd57f3, 0xbfc7e894, 0xbfe05041,
    0x3fc919c6, 0xbfe28a57, 0x3ff4e6b3, 0xbfc5c1b3,
    0xbe01e941, 0x3f2a3708, 0x3ffc9d02, 0xbec604f2,
    0x4041cd2e, 0x3f7feb66, 0xc03c4b6b, 0xc00da120,
    0xc03cc50d, 0xbd27f33e, 0x40064e27, 0xbfd9fa6a,
    0xbfb0e0cc, 0x3f9c97d6, 0xc02c0dc8, 0x406c4139,
    0x3fcdba5f, 0xc0b6df62, 0xc09fa0dd, 0xbf0525c1,
    0xbfe76530, 0xc021a42d, 0x403dec1a, 0x3ffcb7b7,
    0xbf1f8011, 0xbfb4265e, 0xbef3dc03, 0xbf495948,
    0xc0b3b3c1, 0xbfaa4a37, 0x3f1dba3c, 0x400f1540,
    0x3f62c373, 0x402288b2, 0xbf81830a, 0x400566b5,
    0x3fec0c57, 0xbf915530, 0x3fdb559c, 0xbf8c9182,
    0x40080bc8, 0xbddde608, 0xbf5d0ce2, 0xbebe5ddf,
    0x40390e29, 0x3e4393ea, 0x3f1daef3, 0x400f002b,
    0x3fca9943, 0xbffc0032, 0xbfd3157d, 0xbebcc3c6,
    0x401b12a5, 0xc04c62ea, 0x4060ea91, 0xbfbeeadd,
    0xbf88f41f, 0x3fba2dfb, 0xc0112cd6, 0xc00525fd,
    0xbee2feaa, 0xc0171584, 0x3f616cc1, 0xc04248f2,
    0xc0a535d3, 0xbfa27b5b, 0xbf2f09bd, 0xc02bccb3,
    0xc057e04c, 0xc08bcc4b, 0xc07d4788, 0x40639a88,
    0x4098a231, 0x40227b9f, 0x3f899ccb, 0x3ea45b7e,
    0x3f41a1c0, 0xbebbe56f, 0xbecf61bf, 0x4021f9fa,
    0xbd805886, 0x3f8c2a7c, 0xbe094d13, 0xbec46835,
    0xbf3234f7, 0x3f453a5e, 0xbf32c93c, 0x405496df,
    0x3f308143, 0xbf9a5c4d, 0xc018462c, 0x40ab1801,
    0x4063621b, 0x401c3ea5, 0xbf1ba50c, 0x40368aac,
    0xc045467b, 0x401a417b, 0xc0298ff2, 0x3fb51c4d,
    0x400ea556, 0xc08b4ee6, 0xc0291eba, 0x4088419f,
    0xc05ee317, 0xbfef0228, 0xbfd433aa, 0xc02f03e9,
    0x3ee5cf41, 0x3edf1d9d, 0x3ecc4c0e, 0xbc381623,
    0xbd8a1e21, 0xc088c044, 0x4033879f, 0xbfc99f4b,
    0x403a8ecb, 0xbfad17a8, 0xbfe9688c, 0x40432842,
    0x40300783, 0x3f0cd0ff, 0x3def231c, 0xbf12ebbd,
    0x3fb0e4e6, 0xbf3e8325, 0x3f7af107, 0xc07029c7,
    0x406bf909, 0x3de4e93b, 0xbfd2b697, 0x3fb9b3fa,
    0xbf9a807a, 0xc024016d, 0x3f1f5795, 0xbea4b131,
    0x4065a086, 0x3e5b5240, 0x3fefc4d9, 0x400ecfc7,
    0x40757ec8, 0xbf92e8e7, 0xbeacb189, 0xbfa223b5,
    0xbe130e61, 0xbf04a820, 0xc07f4d8c, 0x3f49a354,
    0xbe08dd56, 0x40332bcc, 0xbd9971a6, 0x4002a045,
    0x405cc42f, 0xbf51c115, 0xbf9492b3, 0xc0489e88,
    0x3f862372, 0xc021ef24, 0xc010f72e, 0x3ea9a635,
    0x3e9753b0, 0x401ba0b4, 0x401ee6ad, 0xc076a5c2,
    0xc0080c3d, 0xbfd87d21, 0x3fac1caf, 0xc035aa4f,
    0x3ea81585, 0xbf8702bd, 0x4091ebb1, 0x408fcd93,
    0xc02699d3, 0xc056e7fa, 0x3fb8732e, 0x4077e956,
    0x3f590e67, 0xbf7dc631, 0xbf2c13b7, 0x404d049b,
    0xbfaa8504, 0x3fd9f2a0, 0xbf867e1e, 0x40852f7c,
    0xc020be13, 0xbf68a67a, 0x3fbe8dfa, 0xbfacdaf8,
    0xc00e9f4c, 0x3fd5caf6, 0xc0d049b4, 0x3ff7e07b,
    0x3e6c073a, 0x405a99f4, 0xbf2a9c64, 0x3f9cb2ad,
    0xbff9322d, 0x3fefa264, 0x3f27096b, 0x403a0c8a,
    0x4047f083, 0xbe13b414, 0xbf1d6b65, 0xbf9ca546,
    0xbfc60787, 0xc0b64396, 0x4017bdc8, 0xbffcd657,
    0xc03a83e5, 0xbe543a6b, 0xc0653488, 0xbd0b41f5,
    0xbf921d7f, 0xc01f4eaf, 0xc088b8aa, 0xbfb46fb4,
    0xbfc52511, 0xc00b6606, 0xbe90a35c, 0xc019f5ee,
    0x3f7737be, 0x3f7e35e8, 0xbf17488d, 0x3fa07ef7,
    0xbf72c1ee, 0xc0536cf3, 0xbf9cb3b7, 0xbf0a30ff,
    0xc0819014, 0x3f1cefec, 0x3fb54800, 0xc048bd2e,
    0xc04ff3a6, 0xbf5b3361, 0x3e74338d, 0xbf04b918,
    0xbfff72f5, 0x3f97ad23, 0xc0186f4a, 0xc018d5e7,
    0xbda8dcfc, 0xc068d17f, 0x3f903a66, 0xbfd58026,
    0xbebe635d, 0x3ffb7e28, 0x408ed0c7, 0xc03f5c5c,
    0x4088416c, 0xc098a743, 0x3fc830b8, 0xbfc28740,
    0x3f34e7b8, 0xbefa26a3, 0xc03416e5, 0xbed07fb9,
    0x3d9ac551, 0x3f98c62c, 0xc072dbc2, 0xbfb73e34,
    0xbec0ebaf, 0x40244385, 0x4004ef79, 0x405fed40,
    0x3e31b0d1, 0xbf10fae9, 0x406d4a7a, 0x3f1440b4,
    0x402a5df1, 0xbf9b1ce8, 0x40041298, 0xbe94307c,
    0x4093156f, 0xbf230e79, 0x3ed726a6, 0x3e80704b,
    0x3fe13f09, 0xbe0df8e8, 0x400c8b2a, 0xbe9a84b8,
    0x3ee02f59, 0x3e9eb913, 0xbfd831e2, 0xbe2fd597,
    0xc0045e4a, 0xbf793220, 0xbf9ee296, 0x3f90a96d,
    0xbf356765, 0xbffcaa17, 0x3f26c2b6, 0xbfdd8761,
    0x405b3f08, 0xbe74135f, 0xbdfb890a, 0xc05163a8,
    0xbfb684bd, 0xbea3e39c, 0x3fd86335, 0x4065774f,
    0xbee28d32, 0x4040c01f, 0xc00629f5, 0x40969c4e,
    0x3df8e7ff, 0x4009f66f, 0xbf7b4529, 0xbfcd778e,
    0x3f674ce0, 0xbfa393fe, 0xc0327918, 0x408aea35,
    0xbefcd7c8, 0xbe3566d7, 0xbe928191, 0xbf3e7842,
    0xbf578ebb, 0x40149e2c, 0xbf06376b, 0x3f3471cd,
    0x3f05bac3, 0xbe5f416a, 0xbfcb47d0, 0xbf53de26,
    0x3ff3214a, 0xbff7ffb3, 0xbfbe6a5f, 0x40760db0,
    0x3f956dea, 0x3f092c80, 0xc0afe86b, 0xbe8fc6a0,
    0xbfbc3b8a, 0x3fb4436b, 0x3ed550df, 0x3f18be6b,
    0x3f7a8c1b, 0x3efe3310, 0xc05da10a, 0xc02be5b3,
    0x408c0f32, 0x3fc9e399, 0xc06419a0, 0x3ea06d98,
    0xbdad62e4, 0x3f1be251, 0xbf55d462, 0x3f180487,
    0xbfade3bc, 0x3d81a1ea, 0x40716338, 0x3de6040d,
    0xc083070e, 0xbf51eb1a, 0xbf45a049, 0xc03558df,
    0xbed8661c, 0xbfc62c35, 0xbfd14828, 0x3f8d9420,
    0x40187221, 0x3fce0056, 0x3f47925c, 0xc065b234,
    0xbf72d5c4, 0xbe325f3c, 0xbe988bb3, 0x4027555c,
    0x3f6e545c, 0x3f37968e, 0xbef6bf67, 0xbfba2995,
    0x40202a86, 0x3f838b46, 0xbf7ecf68, 0x3f15fbd0,
    0xbf4a3cc8, 0xbef382ac, 0xbfd10138, 0x400aba67,
    0x3e48be9a, 0x3f3cae40, 0x3fe4417f, 0x40091b2c,
    0xbf130787, 0xc086ae5b, 0xc0305c0a, 0x40153902,
    0x3fd67447, 0x3e05738b, 0xbf897db0, 0x3f16a1b2,
    0x401a4b8c, 0xbf610863, 0x400b11bd, 0x403fd3ec,
    0x3f57c7e0, 0x3f37245e, 0xbf758902, 0xc015f8c9,
    0xbf372d60, 0xc01fb68c, 0x40262e6d, 0x3fd96483,
    0xbec376e3, 0x3fd50db3, 0xbefc2b24, 0xc018e004,
    0xbf93a3d4, 0xbeccbd78, 0x402a560f, 0x3f17da61,
    0x3f9931ba, 0x405098e7, 0x3e94a369, 0xbd83e146,
    0x40565ff0, 0x3facd7f4, 0x3f5e2eac, 0x3eaf21bb,
    0x3f7259b9, 0x3fc22e92, 0xc04ede9b, 0x400c63b3,
    0xbf5d5e12, 0xbeeb4957, 0xbe9bb4ac, 0xbef90d5b,
    0xc050bbce, 0xbf4bfc52, 0x3fdb28d1, 0xbf3196c9,
    0x3dee444b, 0xbf4aa234, 0x3e6e6e95, 0x3fcef60b,
    0x3f9f1334, 0x3f0be6da, 0xbf20f95e, 0xc030df20,
    0x40673c83, 0x3f56bf41, 0x40524845, 0x3c4a74cc,
    0x3eb0f23c, 0xc000ef84, 0x3e8b3c6d, 0x4008ac66,
    0x3fcc3112, 0x40289523, 0x40005a62, 0x4067f2b3,
    0xc01945fb, 0x3e225bab, 0x3f47095c, 0xc025a858,
    0xbf7810d2, 0xbed3623a, 0xbf3fc0c9, 0xc058f43d,
    0xbf901662, 0xc0875582, 0x3fc59f08, 0x3f5326cb,
    0x40036935, 0x3fcf93da, 0x3f56add7, 0x3eed3268,
    0xbffdb48d, 0x3e738573, 0x4081df18, 0x3ff58e5d,
    0x3f27214e, 0x3fec0afe, 0x3ede21e2, 0x3fc8cd5c,
    0xbf82e727, 0x4030831a, 0xbfcc85c2, 0xbf96326e,
    0x402e1cc4, 0xbf14cb1d, 0xbf9cff31, 0xc012af69,
    0xbe1a9994, 0x3e54f83b, 0x3f0b3500, 0x3fd95dc4,
    0xbf8bb2ff, 0xbf66ca85, 0xbf8bcb56, 0xc06332c4,
    0xc04ed2d7, 0x3ff142e1, 0xbeb446d8, 0x3d705c0a,
    0xbfdac521, 0x3ded2910, 0x401cf9ec, 0xc046ba26,
    0xc0338c07, 0xbf321713, 0xc02ef347, 0x3f4497de,
    0x408863af, 0xbfd406c8, 0xc03ca233, 0x3f68c729,
    0xc06b34cd, 0xbd61862f, 0xbfb2766a, 0x3f78c375,
    0x3f9c9d5e, 0xbf1c0e6c, 0xbe60702c, 0xc066ef2c,
    0xc05f53d8, 0xbf253d61, 0xbfe359e8, 0xbf8d70ff,
    0xc094ad23, 0x3fa5e9b3, 0x3e85e223, 0x40262eb8,
    0xbfe44e6d, 0xbedf6701, 0xc0a3986d, 0x3eb074a9,
    0x3fca6c0c, 0xbec6e4a1, 0x40a1b8b8, 0x40758b6f,
    0x3fedfaeb, 0x3f0e5bed, 0xbf811258, 0x403afe37,
    0xbf06a447, 0xc01f45bb, 0x3f9f9042, 0x4087e5c0,
    0x403feea3, 0xbeee15f1, 0x40577ce2, 0x406ac12e,
    0xbf44d98d, 0xbe98a354, 0xc05508a3, 0x3fd760ac,
    0xbf8ba69f, 0xbfac3261, 0xbf847a84, 0x3da88450,
    0x3fc5be68, 0xc02342cd, 0x3f30071a, 0xbd7c7e5b,
    0xc01df30c, 0x40b7aef5, 0xbf49cee0, 0xbeadee7e,
    0xbf4c9769, 0xc02afb58, 0xbfe1519c, 0x3e3b2fdb,
    0x406171e0, 0xbfba97e7, 0x408ef077, 0x3fefea60,
    0x3fcaea58, 0xc02bb57b, 0x3f9d9ec5, 0xbeb47a6a,
    0xbf1b0406, 0xbf160f05, 0x403ca7b1, 0xbfdf345a,
    0xbe7a637c, 0x3dfad393, 0xbf86db83, 0xc0bc5a4a,
    0x40913ba0, 0xc07b2497, 0xc032bdef, 0xbf5a75ba,
    0xbe9cb544, 0xc09a30c4, 0x403b83b1, 0x3d861013,
    0x3f4e313c, 0xc030b2f2, 0xc0c7b17f, 0x3fa90804,
    0x3f432546, 0x3eb4f8e5, 0xbf85fe9c, 0xbf794c4f,
    0x404703ba, 0xbfbcf10f, 0x4032ca05, 0x3fbe9e57,
    0xbfbc97d4, 0xbdedde4d, 0xc00e7382, 0xbf00b0ee,
    0xbfbdf1e4, 0x402c1b4d, 0x3f598732, 0x4064a9a8,
    0xbd5a257f, 0xc03b121c, 0x406517b9, 0xbea5c92a,
    0xbf6a72d9, 0xbfc12f38, 0x4019c532, 0x400398cc,
    0x3fd8a63d, 0xc0931b3c, 0xbe67e6e4, 0x3ec0b309,
    0xc09a2946, 0x3e4b9d4e, 0xc0189332, 0x3ed0c6e0,
    0x3f285fe8, 0x401d222a, 0x3f582b8b, 0xc03abed1,
    0xbf03b86f, 0xbeaa4665, 0xc016b67c, 0x3f72212f,
    0xbfd4c2a6, 0xbf9b469b, 0x4080d527, 0xc0377f30,
    0x3e94b56d, 0x3f7335a4, 0xbedd0b4d, 0x401be8fa,
    0x4007f04e, 0xc09d238e, 0xbf93d818, 0x3c4c3e64,
    0xbfe38d8d, 0xbfde1d08, 0xc0832b49, 0xbf1aa35c,
    0xc09828cb, 0xc01a473b, 0xbfd20849, 0xbf574b39,
    0xbf13afcd, 0xbe8130a0, 0xc0776ce3, 0x401db653,
    0x3fc4dbf1, 0x400fbfdb, 0xc03cc914, 0xbfb72b12,
    0xbf435668, 0xbf0fcdf7, 0x402ed958, 0x406a0481,
    0xc05f259d, 0x3f9f59ff, 0x3c605a5d, 0x3ee7dd23,
    0x40461d69, 0x3fef07dd, 0xc0667106, 0xc08c9796,
    0x40b13805, 0xbfb05174, 0x3f094927, 0xc01c05ba,
    0xc00c2f8b, 0x3ef33150, 0xc0aa72ed, 0x40312022,
    0x3f11541c, 0xbffeb37e, 0xc0095cab, 0xbf90a4c9,
    0x401067eb, 0xbc849251, 0x3ffe0017, 0xc0660b43,
    0x3fc6074b, 0xbe96b285, 0xbf2ca592, 0x3edb284c,
    0x3ef86eff, 0x3f41d945, 0x4035f650, 0xbf6146f7,
    0x4012ade0, 0x400d37bc, 0x408d4d6f, 0x3f8d942f,
    0xbecbb6ca, 0x4013501f, 0xbf5cd745, 0xc0215d25,
    0x4050f0f6, 0xc03d8eec, 0x3efb4f61, 0xc0530751,
    0xbeddd754, 0xbf1f177d, 0xbffeaa2e, 0xbea07694,
    0x3d4eb153, 0x3e67225e, 0x3eb767a1, 0x4099d0ab,
    0xbecb66d1, 0xbfc11130, 0x3e54f6a1, 0xbfb3e9c5,
    0xbf1b2873, 0xbf236f97, 0x3fb1c28b, 0xbfae68fb,
    0x3ef68195, 0x3f47f62d, 0x403cbbaf, 0xc000271e,
    0x3dd6991a, 0xc02e9c64, 0x4012727b, 0xbfb768f3,
    0x3fcee5a2, 0x400ef199, 0xbfa40201, 0xbdda6747,
    0x40abc997, 0x4055289f, 0xbfc4ad37, 0x408b384e,
    0x3f93e6f0, 0xc0294f3f, 0x3f867ead, 0xbea6f47a,
    0xbfae6e43, 0xbf2a2940, 0xbe2b33db, 0x3ef383aa,
    0xbfe9190a, 0x3ed636c2, 0xc001bee7, 0x3f1dedde,
    0x3fed0645, 0x3fec9394, 0xc0077b33, 0x3f208a4f,
    0x3ddfd1b7, 0x3ecb8fda, 0xbfe072a2, 0xbe233703,
    0x4080ee26, 0x3cd17dc9, 0xbffb8574, 0x40317576,
    0xbf83124a, 0xbf4f1750, 0xbf86178f, 0x3f9bf606,
    0xbfaf90f0, 0x3fcb1e0d, 0xbf864d15, 0x4031574c,
    0x3f3602dc, 0x3e7171a5, 0xbefb99bd, 0xbf47c0cd,
    0xc03750ae, 0xc022602a, 0xc04a1362, 0x409c5659,
    0xbf7d7321, 0xbfeb3255, 0x40ab92bc, 0xc0ae5000,
    0x3fa62c61, 0xc08f0e36, 0x40c461a8, 0x3f84720a,
    0xc02fa07d, 0x4002de1b, 0xc0061786, 0xbcac160c,
    0xbf26eaee, 0x3ef6c4bc, 0x40c4ce27, 0x3f1cb0dc,
    0xbeee7f8c, 0xbeca7b66, 0x3fca63fc, 0xbf5ad51d,
    0x407982a1, 0x3ec3e4e6, 0xbffb8e22, 0xc060b5c8,
    0xbf7c7cac, 0x3ffff352, 0x3fb08202, 0x3f47293e,
    0x3fcf2ab8, 0xbf7385b4, 0xbe1527ad, 0x3f98cb20,
    0x3f52f772, 0xbfbaf761, 0x3f825b28, 0xc03b3704,
    0xbeac91fb, 0xbfb9f4b2, 0xbff5bc66, 0xbf85ac5b,
    0xc0158827, 0xbfcffce9, 0xbf3ba048, 0x3dffbf8d,
    0xc050ddeb, 0xbf46bd5b, 0xc0560ea7, 0xbeae0d82,
    0xbf4a9d86, 0xc03f6f8b, 0x4044db1e, 0xc0619876,
    0x3fafd4a9, 0xc0697965, 0x402de68b, 0xbf467342,
    0xbfa826cc, 0xc026d9b2, 0x3f46eee6, 0x3f23777d,
    0x3ea6abff, 0x4055783a, 0x3fbec379, 0xbfe35ebc,
    0xbfa9c71b, 0xbeff7857, 0x3f78afc2, 0x4025b3b1,
    0xc0187b90, 0x3f8b53b7, 0x3e0e248e, 0xbfd68ac5,
    0x400c78c0, 0xc00e1afb, 0xc0399a18, 0x3fc81819,
    0x3f9ecb01, 0xbfa1e13b, 0x403569d8, 0x407a39c3,
    0xbe8c5f66, 0x405ec2de, 0xc042d298, 0x3fc131e5,
    0xbe5520f0, 0xbfc9ae2f, 0x40373705, 0xc098359e,
    0xbf042973, 0xc09fea92, 0xbb809b2f, 0xbf8769e9,
    0x3ff5e903, 0xc05a6447, 0xbf1d6d04, 0xbe8ec5a2,
    0xbf619e39, 0x40c66aff, 0x3f422b6b, 0x3d7792ef,
    0x401f73f4, 0xbe28cdc5, 0x3f5acd03, 0x3ed9e41f,
    0xc069cb4f, 0x3f7b06fa, 0x3f69f6b6, 0xc032813c,
    0xbff647be, 0x40400bb2, 0xbfc7f941, 0x3f392009,
    0x3f8a9890, 0x3fa21798, 0xbfb618f4, 0xbf55e312,
    0x408b841f, 0xbff6a4d5, 0x3dcf8010, 0x3fa7a935,
    0x3f114681, 0xc001d5b7, 0x3ffdf33b, 0x3d9f3531,
    0xc0015df0, 0xbf8e46c0, 0x3f92f500, 0x3f07ef2c,
    0xbf7c0df1, 0x3f1d4239, 0xbfa6b2dc, 0x3fa13af5,
    0xbe3dd0d9, 0x3f68def9, 0x408478d0, 0x3f7ec4f7,
    0xc00aab96, 0x407a7a73, 0x3f1897ac, 0xbfccacb1,
    0x3f2d6490, 0x3f09ab84, 0x401d0475, 0xbfd8e9bc,
    0x4097a7ff, 0xbf926023, 0x3f1a1975, 0xbe524e60,
    0xbf57ace8, 0xbfc503d8, 0x3e8b4dc3, 0x4020b7f8,
    0x3fb03bb9, 0x3e88871c, 0xbf0ebd7c, 0xbe3b4417,
    0xbe838e24, 0xc04bd2ae, 0xbff57628, 0x3e8309df,
    0xbfb4fc9e, 0xc02d8274, 0xbf658f6d, 0x40055e46,
    0xc02c84c4, 0x3f959353, 0x402cf5e1, 0xbf1aeccf,
    0xbf689c59, 0x3dcb9d77, 0x3f5073af, 0xbfdd9483,
    0x3ee3d564, 0xc0120229, 0xc00316ec, 0x3fa72d1a,
    0x3f8d0b8b, 0x3ef016bf, 0xbee1270c, 0x3fe9b151,
    0xc019cb31, 0xbf9491f4, 0xbf8d243a, 0xbf756f79,
    0x40856ab6, 0x3f1cb40d, 0xbf892f03, 0xc012dc90,
    0xbf777fd4, 0x40383bab, 0x40041b9c, 0xc0579636,
    0x4062e4b2, 0x3f940035, 0x3fcc7a38, 0x4032a085,
    0xc028cd9f, 0x3fd2fd45, 0x3fa5fc41, 0x3e987b4d,
    0x3e0f91a4, 0xbf80f1b2, 0xbfc80297, 0xbf236e59,
    0xbe52d34c, 0xbf159c3c, 0x400ccbf5, 0x4012bf06,
    0xbfad081c, 0xbef1ca2d, 0x3fbcca5e, 0x3ec620f5,
    0x4020465f, 0xbf4f08a8, 0xc01b9b1d, 0xbfb02ed2,
    0xbe95a0ac, 0xbefdf11a, 0x3fa1500a, 0x3e6b7735,
    0x4015db0e, 0xc0041ca5, 0x403f5c57, 0x3fb49081,
    0xbf4ed4b1, 0x3f6aa29f, 0xbea42d9a, 0x3e251176,
    0x3df7cb2c, 0x3f6ddb3c, 0xbe8c6952, 0xbf2f1608,
    0xbe9b50ad, 0xc04e2839, 0x3eb59890, 0xbfa70230,
    0x4037de14, 0xc0194709, 0x4052cc00, 0xc0d8fa0e,
    0xc048abcb, 0xbfd3fdfd, 0xc01c28c9, 0x3f0069d2,
    0xbe80c888, 0x40772444, 0x3ed8fbc0, 0x3f1572c5,
    0x3f8d9a0f, 0x3f18205a, 0x3e2ce9b7, 0xc09b32dd,
    0xbfb83a6c, 0x3ff36bc1, 0x403fbd5d, 0x3fe657b4,
    0xbf1cc43e, 0x3faa7bdf, 0xbff82fd8, 0x3fcf8a85,
    0xbf97dbfa, 0x3face3f4, 0x3d9df475, 0xbe93be3b,
    0x3efa5b0f, 0xbfb7c43e, 0x3f2a911b, 0x3f4bcd47,
    0xc0032009, 0xbfff71b3, 0xc08bae25, 0x40038815,
    0xc083c620, 0xc05897f2, 0xc071ec10, 0x402fbb57,
    0x40731bf4, 0x3efd1657, 0x3fa1492c, 0xc0341d78,
    0x3e99238a, 0x3e5ae111, 0x409b61cc, 0x40830f21,
    0xc07491f8, 0xbf8e06ea, 0x401c9ee5, 0x3fe2eab2,
    0x401474d4, 0x3faf29bb, 0x40090fe7, 0xbf6ba825,
    0xbfbab16d, 0x40537107, 0x3ff3dfe4, 0x3f24d8ea,
    0x402a31e3, 0xbe7e348b, 0x3f90f6f4, 0xc04472ae,
    0xc02de8bf, 0x40886ab7, 0x3ff6b06a, 0xbd80b5a4,
    0xbfb1fb23, 0x3ff45708, 0xbff60f29, 0xc022057a,
    0x400cf138, 0x405898f7, 0xc020831b, 0xbfe8eac7,
    0x4066ce62, 0x3f989548, 0xbe8fcbc9, 0x3f3a0cec,
    0x3ec1645a, 0x3e1c36f5, 0xbf69a14d, 0x401fbc59,
    0xbf901281, 0xbfbd8068, 0x3fbf20c6, 0xc075f435,
    0xbf3b6b66, 0x3fb4fe10, 0xbfe209c4, 0xc08e4cf2,
    0xc04c6f2e, 0x3fa172fb, 0xc088fcad, 0x3fb3e025,
    0x404dc69e, 0x3ff1b8b2, 0xc09fe9ee, 0x4006a9fe,
    0xbfb0dd72, 0x3f2ed68c, 0xbefcc121, 0xc09276f5,
    0xc02d8922, 0x3fcdef44, 0x400172b2, 0xc064b36a,
    0x3ecfa34e, 0xc085c2bf, 0xbefb11d9, 0x3fb48d75,
    0x3f765986, 0xbf31c4b4, 0xbfb0aa58, 0xbf579e94,
    0x3fd0a01f, 0xbf85cceb, 0xc0824c2b, 0x3f6a9c5d,
    0xbfd080af, 0xc0b0b153, 0xbfc3e0a4, 0xc0122e7a,
    0x40bfb48b, 0xc03d08e7, 0x40910ad4, 0xbf197362,
    0x3efed58a, 0x3f344b8e, 0xbfd57370, 0x3e5ad2f2,
    0x40a27a23, 0x3e1cc897, 0x401e9aa0, 0x3f5f0f7f,
    0xbf348a01, 0xc00a8dfa, 0xbfeb09ed, 0x3fa700e8,
    0x4064f721, 0x4083ee17, 0x40113c5b, 0x3f170a44,
    0x3f992b32, 0x40353670, 0xc036a80d, 0xc0e06305,
    0x3f07ae7c, 0x3f1d39f8, 0xbf9423b0, 0xbef36f6d,
    0xbfecaa35, 0x3f76d8e4, 0xc00c8bfb, 0xc0942801,
    0xc0638b1b, 0x3ebc36e4, 0x3ea3f4f1, 0x4001736a,
    0x4054d74b, 0x3e2afd7c, 0xc05528a4, 0x408dea7e,
    0x3fac421e, 0xbf428c6c, 0x3f8b048b, 0xbfb489db,
    0xbe96254b, 0x3fcace1c, 0xbfd1c2c9, 0x401ed6e1,
    0x3f45e68a, 0x3f751a99, 0x3fa64a33, 0xbf169cb5,
    0xbfc4306a, 0x4008f2ba, 0xbf94c84c, 0x3e81b5f1,
    0xbebe6804, 0x3ecb897e, 0xc036a33b, 0x3fa1a0af,
    0xc020d98c, 0xbf5c8a2c, 0x3e99d3bc, 0x3fbaa9dd,
    0x4000507f, 0xbfc0b569, 0x4094c758, 0xbf45a39f,
    0x3dc930d6, 0xbe3b306b, 0x4088c69f, 0xc0486218,
    0x3faf83db, 0x3f5ef27f, 0x3f8593a0, 0xbfdeb25e,
    0x40386550, 0xbfaf40b8, 0x3e124ce9, 0xbfab49b9,
    0x3feb7bee, 0x4047d420, 0x403e105b, 0x3f072e50,
    0xc01be010, 0xbff5dcf5, 0xc001361f, 0xc036e425,
    0xbe812636, 0xbcd62a3a, 0xbf52c7b2, 0x4056cfd4,
    0xc0317b59, 0xc02a40e9, 0xbf83388d, 0xbe13393a,
    0x400a5c4c, 0x3fdf2948, 0x4051c46e, 0x3fa1729d,
    0x3fc66cc4, 0xbf0664f2, 0x3f162119, 0x3d61db5d,
    0x3fb8d71d, 0xbf997812, 0xbf64c3b2, 0x3fe4a17f,
    0xbf5091f5, 0xbfa24c81, 0xc04e02bd, 0x40441791,
    0xbe6df45c, 0xbfcc4c28, 0x3e7c7ea6, 0x3f2c7385,
    0xbeb709b3, 0xbe9ecc94, 0x3fa36832, 0xbe2513f7,
    0xc0233252, 0xc0c653d9, 0x4031abb9, 0xbf09a10b,
    0xbfaf2dff, 0x3f48f645, 0x3f91becf, 0x3d2044e8,
    0xbfc0ae0f, 0xbfbc34bb, 0x406d16cc, 0x401c5e20,
    0xbe3e58d2, 0xbfd60d46, 0xbf51826e, 0x3f939529,
    0xc085313e, 0x40480d0d, 0x3f92f454, 0x3edd41f0,
    0x3f454f73, 0xbf189248, 0xc0b49d48, 0x40109399,
    0xbdcb03e5, 0x3d83374d, 0x3e24efd4, 0xc00f5c73,
    0x3f734d62, 0x3faa07b5, 0x3fdc0b69, 0x401e0656,
    0xbfd3630c, 0x3f9b91fe, 0xc081a68d, 0xbeabf974,
    0xc06c6f8b, 0xbea5badf, 0x3fc9abfd, 0xbeb3b06a,
    0x40189445, 0xc02ff7a4, 0x40308913, 0x401d8f32,
    0xc02c88a2, 0x3fcda5c7, 0x3fd9bfac, 0x3ea9d4e4,
    0x40d34ee1, 0xc00078a3, 0x404a3cbc, 0x4066cb18,
    0x3f932513, 0x3e84d5d8, 0x4091de28, 0x3f99e4c8,
    0xc0453ccc, 0x4028fc26, 0xbe62bbfe, 0x401655f2,
    0xbf02af1d, 0xc0089812, 0xc08da472, 0xbe833039,
    0x4094e609, 0x409ca890, 0xbf979a5e, 0xbf931613,
    0x3f5d1f81, 0xc0370cae, 0xbf094d0b, 0x40312faa,
    0x3fc10bc6, 0x3f232d93, 0x3eacb005, 0x3fb9a384,
    0x3f872058, 0x3ff55269, 0x3fd4ef6c, 0xbf11638c,
    0x3f844139, 0x3f7833a0, 0x40756668, 0xbe120c73,
    0xc03862f0, 0xbe9736b9, 0xc030ed11, 0xc09013a1,
    0x40c918f7, 0xbfa8a415, 0x3f8296c7, 0x3f8fa247,
    0x3f684616, 0xbfbf1639, 0x4028868d, 0xbf3a9d65,
    0xbd8f0a57, 0x402a3e3e, 0x3fc99b8a, 0xc02ba985,
    0xbfaddbec, 0xbe76bd77, 0x3fa23e39, 0x3f526b39,
    0x402a0a60, 0x3f607b02, 0xbf833b23, 0x3d7ddd1b,
    0x3f146f45, 0xc007f589, 0x4072a9ec, 0x40061a35,
    0xbfa291ed, 0xc0059b6a, 0x3f917eae, 0x40215532,
    0xbdf1239c, 0x3e20606c, 0x4022c9d9, 0x3eb912fa,
    0x400dd74b, 0x3f8cea66, 0x403ae9ed, 0xc018c2a8,
    0x3fa5f550, 0xbfad1b8e, 0xbf7f86f8, 0x4000b2cf,
    0xbff70e5c, 0xc02d760f, 0x3f59d3b2, 0x402401cf,
    0x3fcb035d, 0x40941b6c, 0xbf9f27c6, 0x40b43c69,
    0xc0008871, 0x3fb46cb5, 0xbe07b774, 0xbf07d513,
    0xbfc34f6b, 0xbe6151f9, 0xc0455595, 0xc0248990,
    0x404fcba9, 0x3f845139, 0x3f67565b, 0xbf933331,
    0x3fd545f8, 0x3cafbf7f, 0xc05f4e3b, 0xbff516a9,
    0xc014a65d, 0x4041e542, 0x3f16061d, 0x3f03200d,
    0x4078a6ea, 0x3dc6ff06, 0x3f94211c, 0x408c1f1e,
    0x3f0dad5b, 0xbfaf1b08, 0x402615ad, 0xbf9de981,
    0xc055c872, 0xbf4e6e7b, 0xbfc2c62c, 0xbfbb0c79,
    0x4023ff8c, 0x3e8c1072, 0x40364a7f, 0xc02fca17,
    0x405b591f, 0x3e023b9b, 0xc026f858, 0x3a47dc3e,
    0xbf2ba710, 0x405b5900, 0xbfc97eb7, 0xbecc02ce,
    0x3fd81f57, 0x4086581a, 0x3e574d56, 0x4052782a,
    0xbf6044cd, 0xc01beb8d, 0xbe1a97ff, 0x3f3dcd0f,
    0x401674e8, 0xbef8fde5, 0xc05e479a, 0xbf02c61f,
    0x3f6d3369, 0x3f638c1e, 0x3ea98a8a, 0xc0aaa70a,
    0x3f3957e6, 0x3f050deb, 0x4014077a, 0xbfe3c7c6,
    0x4010682f, 0x3fc97e6b, 0x3fd5f7b6, 0x3e05ff91,
    0xc094c173, 0xc0687baf, 0x4059a46c, 0xbec9e229,
    0x3f8ae906, 0x3f40cd80, 0xc08e2ffa, 0x3e4d88cd,
    0x400ddd4b, 0x3fab1fc3, 0xc07aeab4, 0x3f840b16,
    0xc0093713, 0xbde9eed3, 0xc00d1cfe, 0x3e81ae86,
    0x403c8d0e, 0x40263956, 0x3f92ad6b, 0xbf408f6c,
    0xbebe951e, 0x40016e4f, 0x3ee10801, 0x401b7e0b,
    0xbee30d7a, 0x3fe19ee0, 0xbe9b32ab, 0xbf0dd592,
    0xbfdc9a28, 0xbe88b0a1, 0xc070220f, 0xbda377a5,
    0xbfe56426, 0xc00674fb, 0x40366cf8, 0xbf63ea31,
    0xbfe49a77, 0x3e24ac08, 0xbf3394bc, 0xbf29509c,
    0xbeceb83c, 0x409c1fdf, 0x3eb11d75, 0xbf67f1d6,
    0xbec77c0e, 0x3fce54d5, 0x3fdf5c93, 0x3fa148f1,
    0x4085bfcf, 0xbefa61af, 0xbfc13529, 0x3f48bab8,
    0x40af493e, 0xbfb3bfb2, 0x3f862fa8, 0xc03b5b21,
    0x3f906836, 0x4010d936, 0xbf235d45, 0xbf9a71dd,
    0x4001c467, 0xbec86054, 0x408a13d4, 0x401f8116,
    0xc004d810, 0x3f4af80f, 0xbe10f445, 0xc0937076,
    0x3ff1f364, 0xc035c918, 0x4035464d, 0x3f817f3a,
    0x405fb0e0, 0x4040c78e, 0xbfc9df89, 0x3fc9b02f,
    0x3ec404b8, 0xbfee4ade, 0xbfcac17d, 0xc092d68d,
    0xc04e391f, 0xbfdb1528, 0xc0810313, 0xc0abdbac,
    0x3d33cf41, 0xc067d08c, 0xc02425af, 0x401a5ca6,
    0x3e6abb23, 0xbf20a714, 0x408daddb, 0x3ff9d8df,
    0xbe623b7a, 0xbf04be98, 0xbef79955, 0x40200324,
    0x3eed84b0, 0xbe874e0d, 0xc06ddf3c, 0xc018a2b7,
    0xc05af000, 0x3f21eeae, 0x401af614, 0xc0140cf9,
    0xc045b6fa, 0x3faccb72, 0x40840bd5, 0x40ab7fb3,
    0xbdf53c9d, 0x3f43e151, 0x409e6000, 0xbf654c2d,
    0x40411081, 0xbfba702d, 0x401a4cb4, 0xc01b4438,
    0x3ed4669f, 0xbf81e855, 0xc09f42ab, 0xbf6625b7,
    0x3fb9449a, 0xbef96784, 0x3fc00110, 0x3f4a049e,
    0xbfb3c7d5, 0x4000b362, 0x3e384bab, 0x3f1b6677,
    0xbf81adc0, 0xbff65019, 0x3c7a2c88, 0x3f73b99b,
    0x3efa45b1, 0xbff9b50b, 0x3f0ef6e4, 0xbf1fd431,
    0xbfcc162c, 0xc046d0d4, 0x408fe19f, 0xc038cb06,
    0xbf8564fa, 0xc0c1a029, 0xbf96b9e8, 0x3f563882,
    0x3f8b9a81, 0xc031ce6d, 0xc0267e58, 0xbeb1cc58,
    0xbf8c1b31, 0x3f6c3408, 0x3f2c5213, 0x3f2a2b5e,
    0xbf879fe1, 0xc00b116e, 0xc00777cd, 0x402903c0,
    0x40392157, 0xc04d9429, 0xbef74a53, 0xbc386d80,
    0xc038ce30, 0x4071943e, 0x3f45e7f8, 0xc081b837,
    0xbffc2114, 0xbf11b4e4, 0x40112583, 0x3fec904d,
    0x403db2af, 0xc007690d, 0x3fa006f3, 0xc0163293,
    0x3fb361bc, 0x3ffc848b, 0xc072b5d6, 0xbea0b8d8,
    0x4066e8f7, 0xbd5f5d81, 0xc06c61c8, 0x402577fc,
    0x3f847649, 0xc0906e0e, 0xbf34a217, 0xc02432ad,
    0xbf8f641e, 0xbfab17b7, 0x3d8a2705, 0x4067b372,
    0x3fb68d18, 0xbfd8e8b4, 0x40065ee7, 0xbefb1543,
    0xbf1a17b4, 0xbeb103d8, 0xbe89e1cf, 0xbef9c79f,
    0x3e206aa7, 0xbe64dc2e, 0x3f508c42, 0x3f88f496,
    0xc040d3ca, 0xbe0ac8a3, 0x3f9156bf, 0xbf45ba95,
    0xbe851067, 0xbf4e91cf, 0xbec111b7, 0x3f31195c,
    0x3e350c0c, 0xc01398c0, 0xbf39b1eb, 0x3f7d2324,
    0x3fbeea40, 0x3fddd326, 0xbfdcea64, 0xc03ac4d2,
    0xbfb047e2, 0x3f605dba, 0x3f841f82, 0x4045eb21,
    0xbb7efa02, 0x4060e70f, 0xbfde1d74, 0x4058e7ae,
    0xbf066279, 0xbfecbdea, 0x3fa91e95, 0x4032ea21,
    0xbfe1fa2e, 0x4091f09a, 0xbf10c391, 0xbfd2ae12,
    0xbf650433, 0x3f4e2ae2, 0x406fdb4b, 0x4000669c,
    0x3fd6c17c, 0x3f61bc06, 0xc090b35d, 0x3fc2d976,
    0x3f242a5e, 0xbf769944, 0x3f9153a2, 0x405da064,
    0xc01ec8f4, 0x3ff033c5, 0x4005878c, 0xbf4286dd,
    0xbf7a9f8a, 0x402ac31a, 0xbede8602, 0x3f83c372,
    0xbfd3558b, 0xc02195c6, 0x4037caa6, 0xc0b2f88c,
    0x3f11182d, 0x400bc3bb, 0xbebed3f4, 0xc024c78c,
    0x3fd8bf39, 0xbf87c11b, 0x407345a3, 0x3fd75467,
    0xbf9fab69, 0x3eb75bd3, 0x3ef7b216, 0xc0151d83,
    0xc096b6f1, 0x3fad6ae2, 0xc0d064f8, 0xbfe7fe4b,
    0x3ed2f032, 0x407c9d95, 0x3f620e3d, 0x3f2b47f5,
    0x3fda6cf0, 0x3ed57b8a, 0xc0173c42, 0xc004d7cb,
    0xc0922af1, 0x40158656, 0x3fcc825b, 0x40774689,
    0xbfc48d44, 0xc002ad9b, 0x3c9407b2, 0xc067a06d,
    0xc03f4897, 0xc049f961, 0xc02378fc, 0xc0525701,
    0xc095522a, 0xc05ad0af, 0xc0096849, 0x3fe4dc46,
    0x401804dc, 0xbf6b14ca, 0xc039c54a, 0x3f8dd9e3,
    0x401ecd5c, 0xbfbdd8a3, 0x405bd59b, 0x3ffdb32a,
    0xbecc662b, 0x44b337e2, 0x402a857e, 0x402b99ba,
    0x3f49b62a, 0x3f92a029, 0xbea2c193, 0xbfa51357,
    0x3feaa8d8, 0xbfeee233, 0xbfed1738, 0xbfff4a67,
    0x40455483, 0xc0112c00, 0xc06ccf7e, 0xbf021c66,
    0x4062d580, 0x3fd6e12d, 0x3f539394, 0xbe83891f,
    0x4080ea19, 0x4065bc66, 0x3de5cd27, 0xbd2d329f,
    0xbfbc9498, 0xbf9160bb, 0xc02dd049, 0x402b8961,
    0xc073ee96, 0x403772f0, 0xc03c9bf6, 0xbf8bde6d,
    0x4060296d, 0xbfdd76fa, 0x3fea2387, 0xc0150ef9,
    0xc00c7bc6, 0x40a4a903, 0x404b9968, 0x3f59aa45,
    0x3e9f8e40, 0x3f5667cf, 0x3e17674c, 0xbebbec0c,
    0xbfd1d8a4, 0x3fc38ddb, 0xc05d9e46, 0x4047440e,
    0xbfa24203, 0x4022efc3, 0x40662d1e, 0xc044267f,
    0xbd5dcf62, 0x402b6fae, 0xbfc68263, 0xc03b26de,
    0x40993052, 0x3f907d04, 0xc030ce85, 0x3f1329b8,
    0x409d8d20, 0xc0a10fc4, 0x3f9d3f5b, 0xbe5a698f,
    0xbf91bbbe, 0x3cc4f478, 0x3face735, 0xc02831a0,
    0xbf54897b, 0x3dbc9db2, 0x3ee893ca, 0x3f70e13b,
    0x4098c260, 0xc084e400, 0x3f2c4222, 0xbea33ec6,
    0x404db235, 0xbf9a61fe, 0x3f08a2be, 0xc058064d,
    0x4041af0b, 0xc021b633, 0xc02c4521, 0xbec4c823,
    0xbe53a7b7, 0x3f8b30a1, 0xc006b9be, 0x3fd34693,
    0xc05f26c3, 0xbf0aa7db, 0xc02990ac, 0x3f1d1b3e,
    0xbe8ecfdd, 0x3ed51908, 0x3eb921f8, 0xc093747f,
    0x3ef1cbf5, 0xbee82c5a, 0x3f0d5584, 0xbfca4094,
    0x3f36f7ed, 0xbfaa4166, 0xbfa9b34f, 0x40161e2f,
    0x3fc36731, 0x4054a150, 0x4045208c, 0xc0d4d245,
    0xc08c6f34, 0x404df366, 0xbe289b0d, 0x3f2b9b2b,
    0xc018e099, 0xc0c235ae, 0x400a049c, 0xc021d54d,
    0xbef9ab94, 0x3de9269b, 0xbeaca9c2, 0xbf24b7d1,
    0x3ede962a, 0xbefd9ffb, 0xc07b80cc, 0x40664d4d,
    0xc04c20bd, 0x4062bfeb, 0x3e0f573e, 0xbf94e0ec,
    0x3f8f599b, 0xbf091d1f, 0xbf5927e9, 0xbe950851,
    0xbf126134, 0xbf6a0b77, 0xbefe0cfa, 0xbf0e65d3,
    0xc01e86f4, 0xc02ffae3, 0x402aa9e1, 0xbe365b1c,
    0x3f054a72, 0x407cd210, 0x400c7269, 0x3ec6ff50,
    0xc0479630, 0xbf865701, 0xbf85ea5a, 0x3bd7178e,
    0xbf4487b7, 0xc02e5f81, 0xbf89cf53, 0xbfade231,
    0xbf0ce781, 0xbfa8fe9a, 0x3f9afdf6, 0xc022dc08,
    0x3ef85cd6, 0x3f3bb984, 0x3df68681, 0xbf89d69f,
    0x3f7e8ad2, 0x3fcb0c18, 0xbfbe32d3, 0xc0a0313b,
    0xc01c3143, 0x400e3da7, 0x3be2fbca, 0x40876975,
    0xc016da5c, 0x4087caec, 0x4074e110, 0xbfcdad72,
    0x3be627e8, 0xbf523c5b, 0x405f2db0, 0xbfae3769,
    0x404275cf, 0x3f845605, 0x3fd46c27, 0xbf14e6fe,
    0x3f6a4e41, 0xbfc41bc1, 0x4082b559, 0x3f92cf08,
    0xbfab3b8e, 0xbfbd0d53, 0x3ff81c09, 0x400c6bc0,
    0xbf19d394, 0x3f34d526, 0x3fe0c975, 0x3f7298df,
    0xc065822d, 0x3de757a3, 0xbff89637, 0xbeb00375,
    0x40505f4d, 0xbd45df15, 0xbf894855, 0x40637397,
    0xbfabf9e6, 0xbfd95843, 0xc0085f61, 0x3ff03f1d,
    0xbf045540, 0x40908ce4, 0xc03898fa, 0x3fa7ac5a,
    0x402e866e, 0xbfa01e8c, 0x3fa5034c, 0xbf82de65,
    0xc003dd19, 0xbf9ee3ab, 0x3f46c4c5, 0xbc68c1ac,
    0x3e1b3c76, 0x4042341b, 0x403dab55, 0x3e2cb267,
    0xc0acc2e6, 0xbff091c6, 0xbfa81b3f, 0x3fb6df49,
    0xbf59807e, 0x3ef4ff4c, 0xbfff0d8b, 0x3ed60a75,
    0xc01e92e9, 0xc035cc22, 0x3f8a467b, 0x4002b27b,
    0xbf9efe1d, 0xc05fb7a7, 0x3fa25d66, 0x3effa422,
    0xbf19facd, 0xc02db707, 0x3fe21212, 0x40a3ce09,
    0x400bbec9, 0x40ac5894, 0x40255006, 0x3fd178de,
    0xc08b2cf0, 0x404e22ca, 0xbf775f3d, 0xc09ea353,
    0xbef4af69, 0xc07ba3cc, 0xbd74e329, 0x3fe9368b,
    0x4083b2a8, 0xc01484ca, 0xc0204877, 0x3e5d2a3c,
    0x405937f0, 0xbf58f2fa, 0xbdb68b31, 0xbfa59b26,
    0xbfc92071, 0xc00a57ba, 0xc0009830, 0xbf9d8926,
    0xc0dc0c42, 0x3ac5dd42, 0xc0110dca, 0xc03a2006,
    0xc07888f2, 0x400c58cc, 0x3f6446e4, 0xbfab8407,
    0x401b0929, 0xbe81a98d, 0xbf67d5a6, 0xc02e839d,
    0xbe704f85, 0xbfaa90cf, 0x3d9bd6bd, 0xbf3f85aa,
    0xbee44ce2, 0x3bfc0060, 0x3da0a429, 0x3ff0392f,
    0x3f0da22a, 0xc0810edc, 0x3fe427de, 0xbfe175bb,
    0x3eeb2691, 0x3e2a7cb5, 0xc05fc7f8, 0x3f599b1f,
    0x3ffe6f8a, 0x3f80524c, 0x3e85ce11, 0x3f918837,
    0x3ef8f129, 0xc04bc103, 0xc026f76b, 0x3fba68b1,
    0x404278af, 0x4050de6a, 0x3eb389c8, 0xc01f2393,
    0xbfcf8461, 0x4020d198, 0x401ddd50, 0x3f6f3589,
    0xc09bbc2a, 0xbf1640dc, 0x3fd80cf6, 0xbf3ef5b8,
    0xbeb510cf, 0xbfa11316, 0xbfd0f133, 0x3dbbed2b,
    0xc08ed6bb, 0x3ff10ea6, 0x3f41486f, 0x402f3814,
    0xbfd04613, 0x3f67e471, 0x3f8889da, 0xbf6bc710,
    0x3fc595fb, 0xbfb97600, 0xc07e7d81, 0xbe9e6c4a,
    0xc06bbfe2, 0x3f9bb49f, 0x404988fc, 0x401cfc2f,
    0x3e1a7b7c, 0xbebf5575, 0xbfcbc4e4, 0xbff443d2,
    0xc0a29a5e, 0xbe6e149a, 0x405deb61, 0xbf14e4c8,
    0x3fb44d71, 0x3fcdd618, 0xbfcff37a, 0x3f189da6,
    0xc031236a, 0x3c938cfb, 0x40ae344d, 0xc0aea4e1,
    0x3e22e8e2, 0x402c7dbf, 0x40c981e7, 0xc003340e,
    0xbc7a9f0d, 0x3f9b10df, 0x3f79693e, 0xbf85fe9e,
    0x3f12ba69, 0x40b5304e, 0x4073b4ba, 0x4021a936,
    0xbfb59b4a, 0xbe53c1ed, 0xbfbd5544, 0x3f792871,
    0xbfdd3406, 0x4029d088, 0x404b41aa, 0x3fc9fb91,
    0xbf2dd9b8, 0xbea3388c, 0x3fc0cfda, 0x404bc049,
    0x3ddb153d, 0xbf176dfe, 0x4006f9cb, 0xbfb67a0c,
    0xbfda9dd1, 0x40415d5a, 0x4033c540, 0xbe6b5ba8,
    0x404dea36, 0x3e985654, 0x3f3d3286, 0x404c1763,
    0xbe05ee05, 0xc039d9af, 0x40173517, 0x3d87ae59,
    0xbf927bac, 0xbf7b9859, 0x402fe04e, 0xc087f9b9,
    0xbf8d7119, 0xc0aea64e, 0x3fa40fe7, 0xc08ea274,
    0xc0109522, 0x4053bd66, 0x3e5d7602, 0xbfb7607b,
    0x3c756119, 0xc023cc31, 0x40819380, 0x3f76bd6c,
    0x3fc1c969, 0xbfea9e20, 0x408c9014, 0x3d18901c,
    0x40650af1, 0xbf5f73a1, 0xbf26563b, 0x408f5090,
    0xc08d34c6, 0x40a84589, 0xbfc7ee41, 0x3fa226d3,
    0x40699f55, 0x405fabff, 0xbf43e5ea, 0xbf066c78,
    0xbf362100, 0x4059cdb3, 0x404cbdf5, 0x3ff1e7a3,
    0x40035f39, 0x4003dbe9, 0x3d942979, 0x400a062f,
    0x3e8caefc, 0xbfc99da9, 0x401c7833, 0x40540386,
    0x3f6d3728, 0xbf97868c, 0x3ebda21f, 0x403a016b,
    0x3f02363c, 0x4017d85b, 0x3f998620, 0x3f947431,
    0xc08f5f00, 0xc0358996, 0x40349738, 0xbf618673,
    0x3f9c7323, 0xc08caaf4, 0x3f6d8c76, 0x3f1a0be1,
    0x3f57d0b8, 0xbffa78d3, 0x3f9ab60d, 0xc01bdb0a,
    0x3ffc9e44, 0xbdded34a, 0x401dd0a5, 0x3f2959ee,
    0xc08802d7, 0x3f01095d, 0x3f28b3f0, 0x3fdc076d,
    0xc0802e03, 0xbfd25f61, 0x40c87db1, 0x404b4618,
    0xc01d03b7, 0x3e98f223, 0xc009e763, 0x3f3628fa,
    0xbfebdb57, 0xc0a59de0, 0x3fb1faf4, 0x4000c9e9,
    0xbf279e2d, 0xc01dff12, 0xc00f453a, 0x3f0d7631,
    0xbf69a8a9, 0xc09900b4, 0x4023e1c5, 0xbfdf48b1,
    0x401b5cb6, 0x3f779dff, 0x3f447864, 0xbfcbb8b8,
    0xbf7b044d, 0xbf615cf5, 0xbfac5f8a, 0xbf9115ad,
    0xbf3c4d5e, 0x4027c773, 0xc0716388, 0x40327fff,
    0xbfd6496a, 0x3e0c606a, 0x400f8a63, 0x3eba04c3,
    0x3f559e4b, 0xbdf09a62, 0x3ebc7ce8, 0x4037c16b,
    0xc04bbed7, 0xc03411b5, 0x3e9e6fc5, 0x3d249f07,
    0xc001dafe, 0xc01dfe73, 0x3fe3f942, 0x3f520903,
    0x3fce5217, 0x3ecd52c4, 0xbfcd744b, 0x3fcbe8a1,
    0xbf8e3c15, 0x4012059c, 0x4025bcf3, 0xbedae4bc,
    0x3fd77d0c, 0x3f88367a, 0x40757c18, 0x3fa35ef6,
    0x3fa76081, 0xc0118f29, 0xbf043b09, 0xbf6eaaf8,
    0xbf2401da, 0x3fd90619, 0xbebb852f, 0x3fb92920,
    0x3e249c73, 0xbfc9b565, 0x3ef0e105, 0xc0618a46,
    0x401f85e9, 0xbe9c3330, 0x3eb959b7, 0xbe7d8684,
    0x4031926c, 0xbea3c016, 0xc00b3e2b, 0xc0b61200,
    0x3ff3e296, 0x406f7ca4, 0xbe553c73, 0x409bc07b,
    0xbf451c6b, 0x3fc9505a, 0x3ec82c42, 0xc0554b1e,
    0x3ee5524e, 0xbf1f14b8, 0xbec00f9c, 0xc0224879,
    0x4000e7cc, 0x3e42c3e9, 0xbf25c8df, 0x400463b9,
    0x40b9d87c, 0x3f86d541, 0xc030fb62, 0x3fedeb43,
    0xc0364c5b, 0xbf23d48f, 0x40096355, 0xbf13309e,
    0x3f847b2e, 0xc047fb5b, 0x408efe38, 0x3f1cf6c8,
    0x3f19b72c, 0x3eb6e954, 0xbf52bd28, 0xc0446ce5,
    0xbf378319, 0x4008bf8f, 0x3f8bc854, 0x3f954fe2,
    0xbf612215, 0xc02d48ea, 0xc0088c1f, 0x40d5d850,
    0x3e9ce650, 0xbf26fdf8, 0x4006711f, 0x3fa26b41,
    0x4007c749, 0x4087f2f4, 0x404e22a8, 0xbd83b5b5,
    0xc01339ec, 0xbfa89ef2, 0xc0130e1c, 0xc0818992,
    0xc02ef476, 0x4033f486, 0x3ff84b45, 0xc00b9bb4,
    0xbf504050, 0xbf433f8b, 0x402e8eed, 0x3f63b5a2,
    0x3fb135a1, 0x3e857a0c, 0xbfc7b144, 0x3f00c53c,
    0xc04bea8a, 0x40495068, 0xbea36184, 0x3ff7a42d,
    0x40b2bcf1, 0x404fe976, 0xbfee2246, 0x3fb04813,
    0x3ff471e4, 0x3e10b6cc, 0xbf72f131, 0x3fe1c2c5,
    0xc025b3fd, 0xc029bd9a, 0xc037f447, 0xbfccccf0,
    0xbf85ab8e, 0x3f8cfb52, 0x402c6bba, 0xc01c4a93,
    0x3ff74863, 0xbfa9b65f, 0x3fd1c7a6, 0x404af94b,
    0xc023796e, 0xc022c6d6, 0x4030ddeb, 0xbfb86612,
    0x403d0b34, 0x4022f985, 0xbff473f8, 0xbeb361a1,
    0xbf9f0b86, 0xbfbc692d, 0xc01646a3, 0x4017917e,
    0x3fee6f06, 0x40660984, 0xc010f1f2, 0x3f97c9d9,
    0xbd945490, 0x3fbee472, 0xc0421fb6, 0x401e1901,
    0x40100dc9, 0xbff53447, 0xbfc6de70, 0x404be378,
    0x401d0305, 0xbfa1a3a4, 0x403e67c2, 0xbf9bf01d,
    0x3fdcd3f2, 0x400f888b, 0xbf7c4320, 0xc0870802,
    0x3fad726f, 0x3faced0d, 0x40191149, 0xbf086d07,
    0xbf4b7462, 0x3fc10f09, 0xc03161f8, 0xc06ab643,
    0xc04bac74, 0x3fdeaa43, 0x3ec4e369, 0x406c17b0,
    0xc0198381, 0xbe1fec7c, 0x3f948026, 0x401a0b0c,
    0xbeac7acd, 0xbf2cee4c, 0x3ffb04af, 0x40f74b76,
    0xbf838a25, 0xbf75632b, 0xbff19fa2, 0x4004ffc7,
    0x40b1ecaa, 0xbeec9a07, 0x400e4551, 0x3e840cdc,
    0x406077fe, 0x3dc39453, 0x3e0ce363, 0xbd793111,
    0xbfec0c9f, 0xc03088c7, 0xc0558bf1, 0x4097765a,
    0xbea96e93, 0x3ef67780, 0x3fa9f349, 0x3f2cc1c9,
    0x4020f3b0, 0x3e0087dc, 0xbf86414c, 0x3ef056d1,
    0x401fc7cf, 0x4062a0fa, 0x3fe868c4, 0x402e7536,
    0x408cb188, 0xc05a36c4, 0x401814d6, 0x3f4b0cf1,
    0xbd4a5c60, 0xc041065e, 0x3ed5e13b, 0xc03524e7,
    0x3fd7139e, 0x3fb1ca9e, 0xbf886095, 0x3daa58e2,
    0x3fc18cea, 0xbf4042f6, 0xc03c9419, 0xc0321186,
    0xc0cc7618, 0x3f954f59, 0xbfb8d9e6, 0x4003c544,
    0xbf1c1d2e, 0xbf3576b6, 0x3ede56ee, 0xc069929d,
    0xc00529ca, 0xbfd2ea76, 0x3e87f748, 0xc04419cf,
    0xc0806bc7, 0x4041cae1, 0x3e4666e9, 0x402fea18,
    0x4059b5bb, 0x3fafb712, 0x3e6e5630, 0x3fe2694e,
    0x3f875733, 0xc09d8bd7, 0x3e98bd2b, 0x3e73b92b,
    0x3f06c691, 0xbf25be66, 0x3fada384, 0x3e700283,
    0xbf8c8348, 0xc067b404, 0xbe11eb2d, 0x3d76d993,
    0xc0010108, 0xc069abc2, 0x3ed91094, 0x3f2119b1,
    0xbff3e401, 0xbfb1e2e3, 0xbf876e29, 0x3fe60ec7,
    0xc0bf6a3a, 0xbfc07820, 0xbfe22276, 0x3ed83732,
    0x3f1b718b, 0xc09795bb, 0xbf0974d0, 0x3ebaad9d,
    0x40002464, 0x3fda113c, 0x402132f7, 0x3ffde7b9,
    0xc09075c8, 0xc0003a77, 0xbf9f4c68, 0xbd05ef33,
    0xbe5a3ca5, 0x40ae24ee, 0x3fd4c486, 0xc01dcc9f,
    0x3ffef090, 0xc09e03c0, 0xbf6c3793, 0x3f035dab,
    0x40094096, 0xbe6059d6, 0x40b35f11, 0x404d916d,
    0xc0215cd3, 0xbf469a40, 0xc0109681, 0xc0acdbc9,
    0x3fd99f21, 0x3dfecee9, 0xbff17215, 0x40481e87,
    0x3f5d0bb4, 0x3f413a5a, 0x3fb94369, 0xbef24b90,
    0xbfb8b8ba, 0x3f6cb8c8, 0x4016fe5c, 0x3f59ee16,
    0x404f4983, 0x3f2e4010, 0xc01d50b0, 0x408b0672,
    0x4002ffda, 0x3c59b05a, 0x3f57fb2f, 0xbf4b4cf4,
    0x4024fe01, 0x3f1c3278, 0x3ef062bd, 0xbe34cf9e,
    0x3f82f8ca, 0x402eda1d, 0x3f50878b, 0x3f456a15,
    0xbf578295, 0xbfe9e6c0, 0x3f8e7348, 0xc087a0a5,
    0x3f112e08, 0x3f09742b, 0x40008a39, 0x3d5751c3,
    0xc0afabbe, 0xbec14e5a, 0xc0398360, 0x3eac52b5,
    0x3fe38103, 0xbf22b700, 0xbf186475, 0xc06c8ca7,
    0x3f4d8f69, 0x4023c520, 0x3f05dc01, 0xbe9d8eb3,
    0x3f965b26, 0xbfa612b4, 0x4028dce6, 0xc0063959,
    0xc0876ea8, 0x3f9d972f, 0xc06a2854, 0x40a9140c,
    0xc07e1e39, 0xc0021e70, 0x403cd5c4, 0x3fd02abd,
    0xbf0edbc6, 0x4034a4d9, 0x3f1285ab, 0x408e6092,
    0xc007e9d0, 0x3e1b815e, 0xbf9cf28e, 0xc00fb2d1,
    0x40193e5c, 0x3fa68b0b, 0x3f51a5eb, 0xbfbb7576,
    0x4084e4f8, 0x4085d1bc, 0x3f5a82c2, 0x3f5fc1d7,
    0x3fe2272e, 0x3fbf55b8, 0x4025d8c4, 0xbf4b2c6a,
    0x40970e51, 0xbfc3c6f7, 0xc07270da, 0x3f1b03aa,
    0x40335c82, 0xc08dfe0a, 0x3f874a04, 0xbf1c2ef7,
    0xbff294ed, 0x3fc8aa0b, 0x4011e266, 0xc028d553,
    0xbf71d19d, 0xc082801a, 0x3f91d845, 0x401a8bbd,
    0xbefb1a5d, 0xbe41914f, 0x40534d4f, 0xc00a400c,
    0xc04daca1, 0x404e1fe2, 0x3ff12b2e, 0x4032ec61,
    0xbf9b2edc, 0xc07bf411, 0x3cddeddf, 0xbf85104d,
    0x3fa6427a, 0xbdee4bd0, 0x3f752c6a, 0x3f46150b,
    0x3e8ec258, 0x3d76d595, 0x3fad7aa7, 0xbf2bcfb2,
    0x3fd7c5ae, 0xbf3d9519, 0xbf223723, 0x4010af68,
    0xbf9acf82, 0xbfbe22d8, 0xbf281b10, 0x40438388,
    0xbfd10231, 0xbe617ec9, 0x3f3717be, 0xbf0d2636,
    0x3fbbdb71, 0xbcca08ae, 0xc0635a78, 0xbf959dbd,
    0x4022b3f4, 0xbfc552f2, 0x4074654b, 0x3fdd235c,
    0xbfaece40, 0x3f6a9ef8, 0x3e5807fd, 0xc0a148fb,
    0xbf79fcfd, 0x4048851d, 0xbccd6426, 0x3fbe2612,
    0x4067b3a4, 0x401f9497, 0xc04b7f06, 0x40c35caa,
    0xc0bb3249, 0x401a5f9a, 0x3fb712ba, 0x407dcca7,
    0x3fece2c7, 0xc05ed0b1, 0x3f5c005c, 0x409552bd,
    0xc011f52a, 0xbfc66320, 0xbc03fc0c, 0xbf8d0942,
    0x3f9ef6a2, 0xbff13f7e, 0x3fbc3b66, 0x400a000f,
    0xc036fd5d, 0x3e52e819, 0xbfac38ae, 0x402f6ad8,
    0xbf1c12e6, 0xbf1e162b, 0x3f9c0f2c, 0xc049cd74,
    0x3cc61833, 0xc02007b3, 0xc0b631ed, 0xc0ad666e,
    0xbf8e474a, 0xc0969740, 0x404a2e0d, 0x408773fa,
    0xbfa8a8a7, 0xc0118498, 0xbf186563, 0x407d9ef5,
    0xbff7905c, 0x3f4eb929, 0xbf591607, 0x4010683d,
    0x404cc37c, 0x3e58b9c8, 0xbe805d3d, 0xc013afef,
    0x40134fef, 0xbe2ba4bc, 0x3eb75362, 0x4032e304,
    0xbfe51b44, 0xc0a4adab, 0x3f9497d7, 0xbedb6e24,
    0xbfa062f7, 0xc07cb682, 0x3f11f43e, 0xbf196005,
    0x3ff715d0, 0xbf3e7ebb, 0x3f6b18cb, 0x3fbcc874,
    0xc087edfb, 0xc00fd45c, 0xbfa79273, 0x40391e4a,
    0x405f8667, 0x3ea3dc41, 0xbfe86e39, 0xbd9e5ae9,
    0x3dce47e8, 0xc0665796, 0xbf2ff55b, 0xbf7c747f,
    0xc05876a6, 0xc05c887b, 0x3fe3d204, 0xc01a1254,
    0x3fe4bda6, 0xc065197a, 0x402312b0, 0x40c98506
    };

static const uint32_t in_cfft_step_16[32] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_16[32] = {
    0x40e66666, 0x0, 0xbf666666, 0x4090c992,
    0x0, 0x0, 0xbf666666, 0x3fac68b3,
    0x0, 0x0, 0xbf666666, 0x3f19f2c8,
    0x0, 0x0, 0xbf666666, 0x3e375151,
    0x0, 0x0, 0xbf666666, 0xbe375151,
    0x0, 0x0, 0xbf666666, 0xbf19f2c8,
    0x0, 0x0, 0xbf666666, 0xbfac68b3,
    0x0, 0x0, 0xbf666666, 0xc090c992
    };

static const uint32_t ref_cfft_step_16[32] = {
    0x40e66666, 0x0, 0xbf666666, 0x4090c992,
    0x0, 0x0, 0xbf666666, 0x3fac68b3,
    0x0, 0x0, 0xbf666666, 0x3f19f2c8,
    0x0, 0x0, 0xbf666666, 0x3e375151,
    0x0, 0x0, 0xbf666666, 0xbe375151,
    0x0, 0x0, 0xbf666666, 0xbf19f2c8,
    0x0, 0x0, 0xbf666666, 0xbfac68b3,
    0x0, 0x0, 0xbf666666, 0xc090c992
    };

static const uint32_t in_cfft_step_32[64] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_32[64] = {
    0x41666666, 0x0, 0xbf666666, 0x411234a6,
    0x0, 0x0, 0xbf666666, 0x403de1bb,
    0x0, 0x0, 0xbf666666, 0x3fd78628,
    0x0, 0x0, 0xbf666666, 0x3f8c5f22,
    0x0, 0x0, 0xbf666666, 0x3f3d159b,
    0x0, 0x0, 0xbf666666, 0x3ef64d80,
    0x0, 0x0, 0xbf666666, 0x3e8bc83b,
    0x0, 0x0, 0xbf666666, 0x3db58a13,
    0x0, 0x0, 0xbf666666, 0xbdb58a13,
    0x0, 0x0, 0xbf666666, 0xbe8bc83b,
    0x0, 0x0, 0xbf666666, 0xbef64d80,
    0x0, 0x0, 0xbf666666, 0xbf3d159b,
    0x0, 0x0, 0xbf666666, 0xbf8c5f22,
    0x0, 0x0, 0xbf666666, 0xbfd78628,
    0x0, 0x0, 0xbf666666, 0xc03de1bb,
    0x0, 0x0, 0xbf666666, 0xc11234a6
    };

static const uint32_t ref_cfft_step_32[64] = {
    0x41666666, 0x0, 0xbf666666, 0x411234a6,
    0x0, 0x0, 0xbf666666, 0x403de1bb,
    0x0, 0x0, 0xbf666666, 0x3fd78628,
    0x0, 0x0, 0xbf666666, 0x3f8c5f22,
    0x0, 0x0, 0xbf666666, 0x3f3d159b,
    0x0, 0x0, 0xbf666666, 0x3ef64d80,
    0x0, 0x0, 0xbf666666, 0x3e8bc83b,
    0x0, 0x0, 0xbf666666, 0x3db58a13,
    0x0, 0x0, 0xbf666666, 0xbdb58a13,
    0x0, 0x0, 0xbf666666, 0xbe8bc83b,
    0x0, 0x0, 0xbf666666, 0xbef64d80,
    0x0, 0x0, 0xbf666666, 0xbf3d159b,
    0x0, 0x0, 0xbf666666, 0xbf8c5f22,
    0x0, 0x0, 0xbf666666, 0xbfd78628,
    0x0, 0x0, 0xbf666666, 0xc03de1bb,
    0x0, 0x0, 0xbf666666, 0xc11234a6
    };

static const uint32_t in_cfft_step_64[128] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_64[128] = {
    0x41e66666, 0x0, 0xbf666666, 0x41928f33,
    0x0, 0x0, 0xbf666666, 0x40c22761,
    0x0, 0x0, 0xbf666666, 0x4065f3bc,
    0x0, 0x0, 0xbf666666, 0x4020fb31,
    0x0, 0x0, 0xbf666666, 0x3ff391e7,
    0x0, 0x0, 0xbf666666, 0x3fc03318,
    0x0, 0x0, 0xbf666666, 0x3f9b5448,
    0x0, 0x0, 0xbf666666, 0x3f7e350d,
    0x0, 0x0, 0xbf666666, 0x3f50d288,
    0x0, 0x0, 0xbf666666, 0x3f2ae054,
    0x0, 0x0, 0xbf666666, 0x3f0a18b1,
    0x0, 0x0, 0xbf666666, 0x3ed9f132,
    0x0, 0x0, 0xbf666666, 0x3ea4e07b,
    0x0, 0x0, 0xbf666666, 0x3e66d94a,
    0x0, 0x0, 0xbf666666, 0x3e08b4da,
    0x0, 0x0, 0xbf666666, 0x3d3519e9,
    0x0, 0x0, 0xbf666666, 0xbd3519e9,
    0x0, 0x0, 0xbf666666, 0xbe08b4da,
    0x0, 0x0, 0xbf666666, 0xbe66d94a,
    0x0, 0x0, 0xbf666666, 0xbea4e07b,
    0x0, 0x0, 0xbf666666, 0xbed9f132,
    0x0, 0x0, 0xbf666666, 0xbf0a18b1,
    0x0, 0x0, 0xbf666666, 0xbf2ae054,
    0x0, 0x0, 0xbf666666, 0xbf50d288,
    0x0, 0x0, 0xbf666666, 0xbf7e350d,
    0x0, 0x0, 0xbf666666, 0xbf9b5448,
    0x0, 0x0, 0xbf666666, 0xbfc03318,
    0x0, 0x0, 0xbf666666, 0xbff391e7,
    0x0, 0x0, 0xbf666666, 0xc020fb31,
    0x0, 0x0, 0xbf666666, 0xc065f3bc,
    0x0, 0x0, 0xbf666666, 0xc0c22761,
    0x0, 0x0, 0xbf666666, 0xc1928f33
    };

static const uint32_t ref_cfft_step_64[128] = {
    0x41e66666, 0x0, 0xbf666666, 0x41928f33,
    0x0, 0x0, 0xbf666666, 0x40c22761,
    0x0, 0x0, 0xbf666666, 0x4065f3bc,
    0x0, 0x0, 0xbf666666, 0x4020fb31,
    0x0, 0x0, 0xbf666666, 0x3ff391e7,
    0x0, 0x0, 0xbf666666, 0x3fc03318,
    0x0, 0x0, 0xbf666666, 0x3f9b5448,
    0x0, 0x0, 0xbf666666, 0x3f7e350d,
    0x0, 0x0, 0xbf666666, 0x3f50d288,
    0x0, 0x0, 0xbf666666, 0x3f2ae054,
    0x0, 0x0, 0xbf666666, 0x3f0a18b1,
    0x0, 0x0, 0xbf666666, 0x3ed9f132,
    0x0, 0x0, 0xbf666666, 0x3ea4e07b,
    0x0, 0x0, 0xbf666666, 0x3e66d94a,
    0x0, 0x0, 0xbf666666, 0x3e08b4da,
    0x0, 0x0, 0xbf666666, 0x3d3519e9,
    0x0, 0x0, 0xbf666666, 0xbd3519e9,
    0x0, 0x0, 0xbf666666, 0xbe08b4da,
    0x0, 0x0, 0xbf666666, 0xbe66d94a,
    0x0, 0x0, 0xbf666666, 0xbea4e07b,
    0x0, 0x0, 0xbf666666, 0xbed9f132,
    0x0, 0x0, 0xbf666666, 0xbf0a18b1,
    0x0, 0x0, 0xbf666666, 0xbf2ae054,
    0x0, 0x0, 0xbf666666, 0xbf50d288,
    0x0, 0x0, 0xbf666666, 0xbf7e350d,
    0x0, 0x0, 0xbf666666, 0xbf9b5448,
    0x0, 0x0, 0xbf666666, 0xbfc03318,
    0x0, 0x0, 0xbf666666, 0xbff391e7,
    0x0, 0x0, 0xbf666666, 0xc020fb31,
    0x0, 0x0, 0xbf666666, 0xc065f3bc,
    0x0, 0x0, 0xbf666666, 0xc0c22761,
    0x0, 0x0, 0xbf666666, 0xc1928f33
    };

static const uint32_t in_cfft_step_128[256] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_128[256] = {
    0x42666666, 0x0, 0xbf666666, 0x4212a5d2,
    0x0, 0x0, 0xbf666666, 0x4143374e,
    0x0, 0x0, 0xbf666666, 0x40e98115,
    0x0, 0x0, 0xbf666666, 0x40a5fa7e,
    0x0, 0x0, 0xbf666666, 0x40804092,
    0x0, 0x0, 0xbf666666, 0x405023c0,
    0x0, 0x0, 0xbf666666, 0x402e5b91,
    0x0, 0x0, 0xbf666666, 0x40155288,
    0x0, 0x0, 0xbf666666, 0x4001f18a,
    0x0, 0x0, 0xbf666666, 0x3fe4dcf4,
    0x0, 0x0, 0xbf666666, 0x3fcb5b40,
    0x0, 0x0, 0xbf666666, 0x3fb5ebb2,
    0x0, 0x0, 0xbf666666, 0x3fa39249,
    0x0, 0x0, 0xbf666666, 0x3f939d7b,
    0x0, 0x0, 0xbf666666, 0x3f858c7f,
    0x0, 0x0, 0xbf666666, 0x3f71ff27,
    0x0, 0x0, 0xbf666666, 0x3f5b5bea,
    0x0, 0x0, 0xbf666666, 0x3f46be91,
    0x0, 0x0, 0xbf666666, 0x3f33ce51,
    0x0, 0x0, 0xbf666666, 0x3f224418,
    0x0, 0x0, 0xbf666666, 0x3f11e631,
    0x0, 0x0, 0xbf666666, 0x3f02851e,
    0x0, 0x0, 0xbf666666, 0x3ee7f27e,
    0x0, 0x0, 0xbf666666, 0x3ecc4233,
    0x0, 0x0, 0xbf666666, 0x3eb1c00b,
    0x0, 0x0, 0xbf666666, 0x3e983a4e,
    0x0, 0x0, 0xbf666666, 0x3e7f0a83,
    0x0, 0x0, 0xbf666666, 0x3e4ef3c3,
    0x0, 0x0, 0xbf666666, 0x3e1fe9ab,
    0x0, 0x0, 0xbf666666, 0x3de35648,
    0x0, 0x0, 0xbf666666, 0x3d87f66d,
    0x0, 0x0, 0xbf666666, 0x3cb4fdf9,
    0x0, 0x0, 0xbf666666, 0xbcb4fdf9,
    0x0, 0x0, 0xbf666666, 0xbd87f66d,
    0x0, 0x0, 0xbf666666, 0xbde35648,
    0x0, 0x0, 0xbf666666, 0xbe1fe9ab,
    0x0, 0x0, 0xbf666666, 0xbe4ef3c3,
    0x0, 0x0, 0xbf666666, 0xbe7f0a83,
    0x0, 0x0, 0xbf666666, 0xbe983a4e,
    0x0, 0x0, 0xbf666666, 0xbeb1c00b,
    0x0, 0x0, 0xbf666666, 0xbecc4233,
    0x0, 0x0, 0xbf666666, 0xbee7f27e,
    0x0, 0x0, 0xbf666666, 0xbf02851e,
    0x0, 0x0, 0xbf666666, 0xbf11e631,
    0x0, 0x0, 0xbf666666, 0xbf224418,
    0x0, 0x0, 0xbf666666, 0xbf33ce51,
    0x0, 0x0, 0xbf666666, 0xbf46be91,
    0x0, 0x0, 0xbf666666, 0xbf5b5bea,
    0x0, 0x0, 0xbf666666, 0xbf71ff27,
    0x0, 0x0, 0xbf666666, 0xbf858c7f,
    0x0, 0x0, 0xbf666666, 0xbf939d7b,
    0x0, 0x0, 0xbf666666, 0xbfa39249,
    0x0, 0x0, 0xbf666666, 0xbfb5ebb2,
    0x0, 0x0, 0xbf666666, 0xbfcb5b40,
    0x0, 0x0, 0xbf666666, 0xbfe4dcf4,
    0x0, 0x0, 0xbf666666, 0xc001f18a,
    0x0, 0x0, 0xbf666666, 0xc0155288,
    0x0, 0x0, 0xbf666666, 0xc02e5b91,
    0x0, 0x0, 0xbf666666, 0xc05023c0,
    0x0, 0x0, 0xbf666666, 0xc0804092,
    0x0, 0x0, 0xbf666666, 0xc0a5fa7e,
    0x0, 0x0, 0xbf666666, 0xc0e98115,
    0x0, 0x0, 0xbf666666, 0xc143374e,
    0x0, 0x0, 0xbf666666, 0xc212a5d2
    };

static const uint32_t ref_cfft_step_128[256] = {
    0x42666666, 0x0, 0xbf666666, 0x4212a5d2,
    0x0, 0x0, 0xbf666666, 0x4143374e,
    0x0, 0x0, 0xbf666666, 0x40e98115,
    0x0, 0x0, 0xbf666666, 0x40a5fa7e,
    0x0, 0x0, 0xbf666666, 0x40804092,
    0x0, 0x0, 0xbf666666, 0x405023c0,
    0x0, 0x0, 0xbf666666, 0x402e5b91,
    0x0, 0x0, 0xbf666666, 0x40155288,
    0x0, 0x0, 0xbf666666, 0x4001f18a,
    0x0, 0x0, 0xbf666666, 0x3fe4dcf4,
    0x0, 0x0, 0xbf666666, 0x3fcb5b40,
    0x0, 0x0, 0xbf666666, 0x3fb5ebb2,
    0x0, 0x0, 0xbf666666, 0x3fa39249,
    0x0, 0x0, 0xbf666666, 0x3f939d7b,
    0x0, 0x0, 0xbf666666, 0x3f858c7f,
    0x0, 0x0, 0xbf666666, 0x3f71ff27,
    0x0, 0x0, 0xbf666666, 0x3f5b5bea,
    0x0, 0x0, 0xbf666666, 0x3f46be91,
    0x0, 0x0, 0xbf666666, 0x3f33ce51,
    0x0, 0x0, 0xbf666666, 0x3f224418,
    0x0, 0x0, 0xbf666666, 0x3f11e631,
    0x0, 0x0, 0xbf666666, 0x3f02851e,
    0x0, 0x0, 0xbf666666, 0x3ee7f27e,
    0x0, 0x0, 0xbf666666, 0x3ecc4233,
    0x0, 0x0, 0xbf666666, 0x3eb1c00b,
    0x0, 0x0, 0xbf666666, 0x3e983a4e,
    0x0, 0x0, 0xbf666666, 0x3e7f0a83,
    0x0, 0x0, 0xbf666666, 0x3e4ef3c3,
    0x0, 0x0, 0xbf666666, 0x3e1fe9ab,
    0x0, 0x0, 0xbf666666, 0x3de35648,
    0x0, 0x0, 0xbf666666, 0x3d87f66d,
    0x0, 0x0, 0xbf666666, 0x3cb4fdf9,
    0x0, 0x0, 0xbf666666, 0xbcb4fdf9,
    0x0, 0x0, 0xbf666666, 0xbd87f66d,
    0x0, 0x0, 0xbf666666, 0xbde35648,
    0x0, 0x0, 0xbf666666, 0xbe1fe9ab,
    0x0, 0x0, 0xbf666666, 0xbe4ef3c3,
    0x0, 0x0, 0xbf666666, 0xbe7f0a83,
    0x0, 0x0, 0xbf666666, 0xbe983a4e,
    0x0, 0x0, 0xbf666666, 0xbeb1c00b,
    0x0, 0x0, 0xbf666666, 0xbecc4233,
    0x0, 0x0, 0xbf666666, 0xbee7f27e,
    0x0, 0x0, 0xbf666666, 0xbf02851e,
    0x0, 0x0, 0xbf666666, 0xbf11e631,
    0x0, 0x0, 0xbf666666, 0xbf224418,
    0x0, 0x0, 0xbf666666, 0xbf33ce51,
    0x0, 0x0, 0xbf666666, 0xbf46be91,
    0x0, 0x0, 0xbf666666, 0xbf5b5bea,
    0x0, 0x0, 0xbf666666, 0xbf71ff27,
    0x0, 0x0, 0xbf666666, 0xbf858c7f,
    0x0, 0x0, 0xbf666666, 0xbf939d7b,
    0x0, 0x0, 0xbf666666, 0xbfa39249,
    0x0, 0x0, 0xbf666666, 0xbfb5ebb2,
    0x0, 0x0, 0xbf666666, 0xbfcb5b40,
    0x0, 0x0, 0xbf666666, 0xbfe4dcf4,
    0x0, 0x0, 0xbf666666, 0xc001f18a,
    0x0, 0x0, 0xbf666666, 0xc0155288,
    0x0, 0x0, 0xbf666666, 0xc02e5b91,
    0x0, 0x0, 0xbf666666, 0xc05023c0,
    0x0, 0x0, 0xbf666666, 0xc0804092,
    0x0, 0x0, 0xbf666666, 0xc0a5fa7e,
    0x0, 0x0, 0xbf666666, 0xc0e98115,
    0x0, 0x0, 0xbf666666, 0xc143374e,
    0x0, 0x0, 0xbf666666, 0xc212a5d2
    };

static const uint32_t in_cfft_step_256[512] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_256[512] = {
    0x42e66666, 0x0, 0xbf666666, 0x4292ab7a,
    0x0, 0x0, 0xbf666666, 0x41c37b32,
    0x0, 0x0, 0xbf666666, 0x416a6390,
    0x0, 0x0, 0xbf666666, 0x412737f2,
    0x0, 0x0, 0xbf666666, 0x4101d962,
    0x0, 0x0, 0xbf666666, 0x40d40d19,
    0x0, 0x0, 0xbf666666, 0x40b2fddd,
    0x0, 0x0, 0xbf666666, 0x409aaf3d,
    0x0, 0x0, 0xbf666666, 0x40880a60,
    0x0, 0x0, 0xbf666666, 0x40728acd,
    0x0, 0x0, 0xbf666666, 0x405a89be,
    0x0, 0x0, 0xbf666666, 0x40469fd7,
    0x0, 0x0, 0xbf666666, 0x4035d1ac,
    0x0, 0x0, 0xbf666666, 0x40276e4d,
    0x0, 0x0, 0xbf666666, 0x401af597,
    0x0, 0x0, 0xbf666666, 0x40100876,
    0x0, 0x0, 0xbf666666, 0x40065ee1,
    0x0, 0x0, 0xbf666666, 0x3ffb8288,
    0x0, 0x0, 0xbf666666, 0x3fec0818,
    0x0, 0x0, 0xbf666666, 0x3fde092b,
    0x0, 0x0, 0xbf666666, 0x3fd14df9,
    0x0, 0x0, 0xbf666666, 0x3fc5a91a,
    0x0, 0x0, 0xbf666666, 0x3fbaf531,
    0x0, 0x0, 0xbf666666, 0x3fb1133b,
    0x0, 0x0, 0xbf666666, 0x3fa7e942,
    0x0, 0x0, 0xbf666666, 0x3f9f615f,
    0x0, 0x0, 0xbf666666, 0x3f9768f4,
    0x0, 0x0, 0xbf666666, 0x3f8ff017,
    0x0, 0x0, 0xbf666666, 0x3f88e914,
    0x0, 0x0, 0xbf666666, 0x3f824810,
    0x0, 0x0, 0xbf666666, 0x3f780574,
    0x0, 0x0, 0xbf666666, 0x3f6c201b,
    0x0, 0x0, 0xbf666666, 0x3f60d03c,
    0x0, 0x0, 0xbf666666, 0x3f5607d9,
    0x0, 0x0, 0xbf666666, 0x3f4bba8d,
    0x0, 0x0, 0xbf666666, 0x3f41dd51,
    0x0, 0x0, 0xbf666666, 0x3f38664c,
    0x0, 0x0, 0xbf666666, 0x3f2f4ca6,
    0x0, 0x0, 0xbf666666, 0x3f26886f,
    0x0, 0x0, 0xbf666666, 0x3f1e1279,
    0x0, 0x0, 0xbf666666, 0x3f15e443,
    0x0, 0x0, 0xbf666666, 0x3f0df7e4,
    0x0, 0x0, 0xbf666666, 0x3f0647f8,
    0x0, 0x0, 0xbf666666, 0x3efd9f20,
    0x0, 0x0, 0xbf666666, 0x3eef144b,
    0x0, 0x0, 0xbf666666, 0x3ee0e71b,
    0x0, 0x0, 0xbf666666, 0x3ed30fda,
    0x0, 0x0, 0xbf666666, 0x3ec58765,
    0x0, 0x0, 0xbf666666, 0x3eb84717,
    0x0, 0x0, 0xbf666666, 0x3eab48bf,
    0x0, 0x0, 0xbf666666, 0x3e9e868f,
    0x0, 0x0, 0xbf666666, 0x3e91fb13,
    0x0, 0x0, 0xbf666666, 0x3e85a128,
    0x0, 0x0, 0xbf666666, 0x3e72e7e2,
    0x0, 0x0, 0xbf666666, 0x3e5add9c,
    0x0, 0x0, 0xbf666666, 0x3e431aae,
    0x0, 0x0, 0xbf666666, 0x3e2b96a6,
    0x0, 0x0, 0xbf666666, 0x3e144965,
    0x0, 0x0, 0xbf666666, 0x3dfa5629,
    0x0, 0x0, 0xbf666666, 0x3dcc6833,
    0x0, 0x0, 0xbf666666, 0x3d9eba16,
    0x0, 0x0, 0xbf666666, 0x3d627a9e,
    0x0, 0x0, 0xbf666666, 0x3d07c735,
    0x0, 0x0, 0xbf666666, 0x3c34f6ff,
    0x0, 0x0, 0xbf666666, 0xbc34f6ff,
    0x0, 0x0, 0xbf666666, 0xbd07c735,
    0x0, 0x0, 0xbf666666, 0xbd627a9e,
    0x0, 0x0, 0xbf666666, 0xbd9eba16,
    0x0, 0x0, 0xbf666666, 0xbdcc6833,
    0x0, 0x0, 0xbf666666, 0xbdfa5629,
    0x0, 0x0, 0xbf666666, 0xbe144965,
    0x0, 0x0, 0xbf666666, 0xbe2b96a6,
    0x0, 0x0, 0xbf666666, 0xbe431aae,
    0x0, 0x0, 0xbf666666, 0xbe5add9c,
    0x0, 0x0, 0xbf666666, 0xbe72e7e2,
    0x0, 0x0, 0xbf666666, 0xbe85a128,
    0x0, 0x0, 0xbf666666, 0xbe91fb13,
    0x0, 0x0, 0xbf666666, 0xbe9e868f,
    0x0, 0x0, 0xbf666666, 0xbeab48bf,
    0x0, 0x0, 0xbf666666, 0xbeb84717,
    0x0, 0x0, 0xbf666666, 0xbec58765,
    0x0, 0x0, 0xbf666666, 0xbed30fda,
    0x0, 0x0, 0xbf666666, 0xbee0e71b,
    0x0, 0x0, 0xbf666666, 0xbeef144b,
    0x0, 0x0, 0xbf666666, 0xbefd9f20,
    0x0, 0x0, 0xbf666666, 0xbf0647f8,
    0x0, 0x0, 0xbf666666, 0xbf0df7e4,
    0x0, 0x0, 0xbf666666, 0xbf15e443,
    0x0, 0x0, 0xbf666666, 0xbf1e1279,
    0x0, 0x0, 0xbf666666, 0xbf26886f,
    0x0, 0x0, 0xbf666666, 0xbf2f4ca6,
    0x0, 0x0, 0xbf666666, 0xbf38664c,
    0x0, 0x0, 0xbf666666, 0xbf41dd51,
    0x0, 0x0, 0xbf666666, 0xbf4bba8d,
    0x0, 0x0, 0xbf666666, 0xbf5607d9,
    0x0, 0x0, 0xbf666666, 0xbf60d03c,
    0x0, 0x0, 0xbf666666, 0xbf6c201b,
    0x0, 0x0, 0xbf666666, 0xbf780574,
    0x0, 0x0, 0xbf666666, 0xbf824810,
    0x0, 0x0, 0xbf666666, 0xbf88e914,
    0x0, 0x0, 0xbf666666, 0xbf8ff017,
    0x0, 0x0, 0xbf666666, 0xbf9768f4,
    0x0, 0x0, 0xbf666666, 0xbf9f615f,
    0x0, 0x0, 0xbf666666, 0xbfa7e942,
    0x0, 0x0, 0xbf666666, 0xbfb1133b,
    0x0, 0x0, 0xbf666666, 0xbfbaf531,
    0x0, 0x0, 0xbf666666, 0xbfc5a91a,
    0x0, 0x0, 0xbf666666, 0xbfd14df9,
    0x0, 0x0, 0xbf666666, 0xbfde092b,
    0x0, 0x0, 0xbf666666, 0xbfec0818,
    0x0, 0x0, 0xbf666666, 0xbffb8288,
    0x0, 0x0, 0xbf666666, 0xc0065ee1,
    0x0, 0x0, 0xbf666666, 0xc0100876,
    0x0, 0x0, 0xbf666666, 0xc01af597,
    0x0, 0x0, 0xbf666666, 0xc0276e4d,
    0x0, 0x0, 0xbf666666, 0xc035d1ac,
    0x0, 0x0, 0xbf666666, 0xc0469fd7,
    0x0, 0x0, 0xbf666666, 0xc05a89be,
    0x0, 0x0, 0xbf666666, 0xc0728acd,
    0x0, 0x0, 0xbf666666, 0xc0880a60,
    0x0, 0x0, 0xbf666666, 0xc09aaf3d,
    0x0, 0x0, 0xbf666666, 0xc0b2fddd,
    0x0, 0x0, 0xbf666666, 0xc0d40d19,
    0x0, 0x0, 0xbf666666, 0xc101d962,
    0x0, 0x0, 0xbf666666, 0xc12737f2,
    0x0, 0x0, 0xbf666666, 0xc16a6390,
    0x0, 0x0, 0xbf666666, 0xc1c37b32,
    0x0, 0x0, 0xbf666666, 0xc292ab7a
    };

static const uint32_t ref_cfft_step_256[512] = {
    0x42e66666, 0x0, 0xbf666666, 0x4292ab7a,
    0x0, 0x0, 0xbf666666, 0x41c37b32,
    0x0, 0x0, 0xbf666666, 0x416a6390,
    0x0, 0x0, 0xbf666666, 0x412737f2,
    0x0, 0x0, 0xbf666666, 0x4101d962,
    0x0, 0x0, 0xbf666666, 0x40d40d19,
    0x0, 0x0, 0xbf666666, 0x40b2fddd,
    0x0, 0x0, 0xbf666666, 0x409aaf3d,
    0x0, 0x0, 0xbf666666, 0x40880a60,
    0x0, 0x0, 0xbf666666, 0x40728acd,
    0x0, 0x0, 0xbf666666, 0x405a89be,
    0x0, 0x0, 0xbf666666, 0x40469fd7,
    0x0, 0x0, 0xbf666666, 0x4035d1ac,
    0x0, 0x0, 0xbf666666, 0x40276e4d,
    0x0, 0x0, 0xbf666666, 0x401af597,
    0x0, 0x0, 0xbf666666, 0x40100876,
    0x0, 0x0, 0xbf666666, 0x40065ee1,
    0x0, 0x0, 0xbf666666, 0x3ffb8288,
    0x0, 0x0, 0xbf666666, 0x3fec0818,
    0x0, 0x0, 0xbf666666, 0x3fde092b,
    0x0, 0x0, 0xbf666666, 0x3fd14df9,
    0x0, 0x0, 0xbf666666, 0x3fc5a91a,
    0x0, 0x0, 0xbf666666, 0x3fbaf531,
    0x0, 0x0, 0xbf666666, 0x3fb1133b,
    0x0, 0x0, 0xbf666666, 0x3fa7e942,
    0x0, 0x0, 0xbf666666, 0x3f9f615f,
    0x0, 0x0, 0xbf666666, 0x3f9768f4,
    0x0, 0x0, 0xbf666666, 0x3f8ff017,
    0x0, 0x0, 0xbf666666, 0x3f88e914,
    0x0, 0x0, 0xbf666666, 0x3f824810,
    0x0, 0x0, 0xbf666666, 0x3f780574,
    0x0, 0x0, 0xbf666666, 0x3f6c201b,
    0x0, 0x0, 0xbf666666, 0x3f60d03c,
    0x0, 0x0, 0xbf666666, 0x3f5607d9,
    0x0, 0x0, 0xbf666666, 0x3f4bba8d,
    0x0, 0x0, 0xbf666666, 0x3f41dd51,
    0x0, 0x0, 0xbf666666, 0x3f38664c,
    0x0, 0x0, 0xbf666666, 0x3f2f4ca6,
    0x0, 0x0, 0xbf666666, 0x3f26886f,
    0x0, 0x0, 0xbf666666, 0x3f1e1279,
    0x0, 0x0, 0xbf666666, 0x3f15e443,
    0x0, 0x0, 0xbf666666, 0x3f0df7e4,
    0x0, 0x0, 0xbf666666, 0x3f0647f8,
    0x0, 0x0, 0xbf666666, 0x3efd9f20,
    0x0, 0x0, 0xbf666666, 0x3eef144b,
    0x0, 0x0, 0xbf666666, 0x3ee0e71b,
    0x0, 0x0, 0xbf666666, 0x3ed30fda,
    0x0, 0x0, 0xbf666666, 0x3ec58765,
    0x0, 0x0, 0xbf666666, 0x3eb84717,
    0x0, 0x0, 0xbf666666, 0x3eab48bf,
    0x0, 0x0, 0xbf666666, 0x3e9e868f,
    0x0, 0x0, 0xbf666666, 0x3e91fb13,
    0x0, 0x0, 0xbf666666, 0x3e85a128,
    0x0, 0x0, 0xbf666666, 0x3e72e7e2,
    0x0, 0x0, 0xbf666666, 0x3e5add9c,
    0x0, 0x0, 0xbf666666, 0x3e431aae,
    0x0, 0x0, 0xbf666666, 0x3e2b96a6,
    0x0, 0x0, 0xbf666666, 0x3e144965,
    0x0, 0x0, 0xbf666666, 0x3dfa5629,
    0x0, 0x0, 0xbf666666, 0x3dcc6833,
    0x0, 0x0, 0xbf666666, 0x3d9eba16,
    0x0, 0x0, 0xbf666666, 0x3d627a9e,
    0x0, 0x0, 0xbf666666, 0x3d07c735,
    0x0, 0x0, 0xbf666666, 0x3c34f6ff,
    0x0, 0x0, 0xbf666666, 0xbc34f6ff,
    0x0, 0x0, 0xbf666666, 0xbd07c735,
    0x0, 0x0, 0xbf666666, 0xbd627a9e,
    0x0, 0x0, 0xbf666666, 0xbd9eba16,
    0x0, 0x0, 0xbf666666, 0xbdcc6833,
    0x0, 0x0, 0xbf666666, 0xbdfa5629,
    0x0, 0x0, 0xbf666666, 0xbe144965,
    0x0, 0x0, 0xbf666666, 0xbe2b96a6,
    0x0, 0x0, 0xbf666666, 0xbe431aae,
    0x0, 0x0, 0xbf666666, 0xbe5add9c,
    0x0, 0x0, 0xbf666666, 0xbe72e7e2,
    0x0, 0x0, 0xbf666666, 0xbe85a128,
    0x0, 0x0, 0xbf666666, 0xbe91fb13,
    0x0, 0x0, 0xbf666666, 0xbe9e868f,
    0x0, 0x0, 0xbf666666, 0xbeab48bf,
    0x0, 0x0, 0xbf666666, 0xbeb84717,
    0x0, 0x0, 0xbf666666, 0xbec58765,
    0x0, 0x0, 0xbf666666, 0xbed30fda,
    0x0, 0x0, 0xbf666666, 0xbee0e71b,
    0x0, 0x0, 0xbf666666, 0xbeef144b,
    0x0, 0x0, 0xbf666666, 0xbefd9f20,
    0x0, 0x0, 0xbf666666, 0xbf0647f8,
    0x0, 0x0, 0xbf666666, 0xbf0df7e4,
    0x0, 0x0, 0xbf666666, 0xbf15e443,
    0x0, 0x0, 0xbf666666, 0xbf1e1279,
    0x0, 0x0, 0xbf666666, 0xbf26886f,
    0x0, 0x0, 0xbf666666, 0xbf2f4ca6,
    0x0, 0x0, 0xbf666666, 0xbf38664c,
    0x0, 0x0, 0xbf666666, 0xbf41dd51,
    0x0, 0x0, 0xbf666666, 0xbf4bba8d,
    0x0, 0x0, 0xbf666666, 0xbf5607d9,
    0x0, 0x0, 0xbf666666, 0xbf60d03c,
    0x0, 0x0, 0xbf666666, 0xbf6c201b,
    0x0, 0x0, 0xbf666666, 0xbf780574,
    0x0, 0x0, 0xbf666666, 0xbf824810,
    0x0, 0x0, 0xbf666666, 0xbf88e914,
    0x0, 0x0, 0xbf666666, 0xbf8ff017,
    0x0, 0x0, 0xbf666666, 0xbf9768f4,
    0x0, 0x0, 0xbf666666, 0xbf9f615f,
    0x0, 0x0, 0xbf666666, 0xbfa7e942,
    0x0, 0x0, 0xbf666666, 0xbfb1133b,
    0x0, 0x0, 0xbf666666, 0xbfbaf531,
    0x0, 0x0, 0xbf666666, 0xbfc5a91a,
    0x0, 0x0, 0xbf666666, 0xbfd14df9,
    0x0, 0x0, 0xbf666666, 0xbfde092b,
    0x0, 0x0, 0xbf666666, 0xbfec0818,
    0x0, 0x0, 0xbf666666, 0xbffb8288,
    0x0, 0x0, 0xbf666666, 0xc0065ee1,
    0x0, 0x0, 0xbf666666, 0xc0100876,
    0x0, 0x0, 0xbf666666, 0xc01af597,
    0x0, 0x0, 0xbf666666, 0xc0276e4d,
    0x0, 0x0, 0xbf666666, 0xc035d1ac,
    0x0, 0x0, 0xbf666666, 0xc0469fd7,
    0x0, 0x0, 0xbf666666, 0xc05a89be,
    0x0, 0x0, 0xbf666666, 0xc0728acd,
    0x0, 0x0, 0xbf666666, 0xc0880a60,
    0x0, 0x0, 0xbf666666, 0xc09aaf3d,
    0x0, 0x0, 0xbf666666, 0xc0b2fddd,
    0x0, 0x0, 0xbf666666, 0xc0d40d19,
    0x0, 0x0, 0xbf666666, 0xc101d962,
    0x0, 0x0, 0xbf666666, 0xc12737f2,
    0x0, 0x0, 0xbf666666, 0xc16a6390,
    0x0, 0x0, 0xbf666666, 0xc1c37b32,
    0x0, 0x0, 0xbf666666, 0xc292ab7a
    };

static const uint32_t in_cfft_step_512[1024] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_512[1024] = {
    0x43666666, 0x0, 0xbf666666, 0x4312ace4,
    0x0, 0x0, 0xbf666666, 0x42438c29,
    0x0, 0x0, 0xbf666666, 0x41ea9c21,
    0x0, 0x0, 0xbf666666, 0x41a7872a,
    0x0, 0x0, 0xbf666666, 0x41823f46,
    0x0, 0x0, 0xbf666666, 0x4155064a,
    0x0, 0x0, 0xbf666666, 0x4134248a,
    0x0, 0x0, 0xbf666666, 0x411c037e,
    0x0, 0x0, 0xbf666666, 0x41098c4e,
    0x0, 0x0, 0xbf666666, 0x40f5ea42,
    0x0, 0x0, 0xbf666666, 0x40de450d,
    0x0, 0x0, 0xbf666666, 0x40cab74c,
    0x0, 0x0, 0xbf666666, 0x40ba4599,
    0x0, 0x0, 0xbf666666, 0x40ac3f0d,
    0x0, 0x0, 0xbf666666, 0x40a0238b,
    0x0, 0x0, 0xbf666666, 0x40959408,
    0x0, 0x0, 0xbf666666, 0x408c4882,
    0x0, 0x0, 0xbf666666, 0x4084096e,
    0x0, 0x0, 0xbf666666, 0x40795680,
    0x0, 0x0, 0xbf666666, 0x406c16bd,
    0x0, 0x0, 0xbf666666, 0x40601bdc,
    0x0, 0x0, 0xbf666666, 0x40553884,
    0x0, 0x0, 0xbf666666, 0x404b476c,
    0x0, 0x0, 0xbf666666, 0x404229a3,
    0x0, 0x0, 0xbf666666, 0x4039c547,
    0x0, 0x0, 0xbf666666, 0x40320482,
    0x0, 0x0, 0xbf666666, 0x402ad4cd,
    0x0, 0x0, 0xbf666666, 0x4024264f,
    0x0, 0x0, 0xbf666666, 0x401deb6c,
    0x0, 0x0, 0xbf666666, 0x4018185f,
    0x0, 0x0, 0xbf666666, 0x4012a2ec,
    0x0, 0x0, 0xbf666666, 0x400d8226,
    0x0, 0x0, 0xbf666666, 0x4008ae38,
    0x0, 0x0, 0xbf666666, 0x4004203c,
    0x0, 0x0, 0xbf666666, 0x3fffa435,
    0x0, 0x0, 0xbf666666, 0x3ff77cd2,
    0x0, 0x0, 0xbf666666, 0x3fefc0ad,
    0x0, 0x0, 0xbf666666, 0x3fe8672a,
    0x0, 0x0, 0xbf666666, 0x3fe16891,
    0x0, 0x0, 0xbf666666, 0x3fdabdf3,
    0x0, 0x0, 0xbf666666, 0x3fd4610f,
    0x0, 0x0, 0xbf666666, 0x3fce4c3f,
    0x0, 0x0, 0xbf666666, 0x3fc87a64,
    0x0, 0x0, 0xbf666666, 0x3fc2e6d7,
    0x0, 0x0, 0xbf666666, 0x3fbd8d5e,
    0x0, 0x0, 0xbf666666, 0x3fb86a1c,
    0x0, 0x0, 0xbf666666, 0x3fb37988,
    0x0, 0x0, 0xbf666666, 0x3faeb868,
    0x0, 0x0, 0xbf666666, 0x3faa23c3,
    0x0, 0x0, 0xbf666666, 0x3fa5b8df,
    0x0, 0x0, 0xbf666666, 0x3fa17537,
    0x0, 0x0, 0xbf666666, 0x3f9d567b,
    0x0, 0x0, 0xbf666666, 0x3f995a85,
    0x0, 0x0, 0xbf666666, 0x3f957f59,
    0x0, 0x0, 0xbf666666, 0x3f91c321,
    0x0, 0x0, 0xbf666666, 0x3f8e2427,
    0x0, 0x0, 0xbf666666, 0x3f8aa0d5,
    0x0, 0x0, 0xbf666666, 0x3f8737b0,
    0x0, 0x0, 0xbf666666, 0x3f83e757,
    0x0, 0x0, 0xbf666666, 0x3f80ae81,
    0x0, 0x0, 0xbf666666, 0x3f7b17f5,
    0x0, 0x0, 0xbf666666, 0x3f74fd45,
    0x0, 0x0, 0xbf666666, 0x3f6f0ad8,
    0x0, 0x0, 0xbf666666, 0x3f693eb3,
    0x0, 0x0, 0xbf666666, 0x3f6396fb,
    0x0, 0x0, 0xbf666666, 0x3f5e11f2,
    0x0, 0x0, 0xbf666666, 0x3f58adf2,
    0x0, 0x0, 0xbf666666, 0x3f53696f,
    0x0, 0x0, 0xbf666666, 0x3f4e42f6,
    0x0, 0x0, 0xbf666666, 0x3f493924,
    0x0, 0x0, 0xbf666666, 0x3f444aae,
    0x0, 0x0, 0xbf666666, 0x3f3f7657,
    0x0, 0x0, 0xbf666666, 0x3f3abaf8,
    0x0, 0x0, 0xbf666666, 0x3f361774,
    0x0, 0x0, 0xbf666666, 0x3f318ac2,
    0x0, 0x0, 0xbf666666, 0x3f2d13e1,
    0x0, 0x0, 0xbf666666, 0x3f28b1e2,
    0x0, 0x0, 0xbf666666, 0x3f2463df,
    0x0, 0x0, 0xbf666666, 0x3f2028fe,
    0x0, 0x0, 0xbf666666, 0x3f1c006f,
    0x0, 0x0, 0xbf666666, 0x3f17e96b,
    0x0, 0x0, 0xbf666666, 0x3f13e337,
    0x0, 0x0, 0xbf666666, 0x3f0fed1d,
    0x0, 0x0, 0xbf666666, 0x3f0c0671,
    0x0, 0x0, 0xbf666666, 0x3f082e8f,
    0x0, 0x0, 0xbf666666, 0x3f0464d8,
    0x0, 0x0, 0xbf666666, 0x3f00a8b6,
    0x0, 0x0, 0xbf666666, 0x3ef9f332,
    0x0, 0x0, 0xbf666666, 0x3ef2ade9,
    0x0, 0x0, 0xbf666666, 0x3eeb8088,
    0x0, 0x0, 0xbf666666, 0x3ee46a0e,
    0x0, 0x0, 0xbf666666, 0x3edd6986,
    0x0, 0x0, 0xbf666666, 0x3ed67e02,
    0x0, 0x0, 0xbf666666, 0x3ecfa69e,
    0x0, 0x0, 0xbf666666, 0x3ec8e27e,
    0x0, 0x0, 0xbf666666, 0x3ec230ce,
    0x0, 0x0, 0xbf666666, 0x3ebb90bf,
    0x0, 0x0, 0xbf666666, 0x3eb5018e,
    0x0, 0x0, 0xbf666666, 0x3eae8279,
    0x0, 0x0, 0xbf666666, 0x3ea812c7,
    0x0, 0x0, 0xbf666666, 0x3ea1b1c5,
    0x0, 0x0, 0xbf666666, 0x3e9b5ec4,
    0x0, 0x0, 0xbf666666, 0x3e95191a,
    0x0, 0x0, 0xbf666666, 0x3e8ee025,
    0x0, 0x0, 0xbf666666, 0x3e88b343,
    0x0, 0x0, 0xbf666666, 0x3e8291d9,
    0x0, 0x0, 0xbf666666, 0x3e78f6a0,
    0x0, 0x0, 0xbf666666, 0x3e6cde27,
    0x0, 0x0, 0xbf666666, 0x3e60d927,
    0x0, 0x0, 0xbf666666, 0x3e54e687,
    0x0, 0x0, 0xbf666666, 0x3e490531,
    0x0, 0x0, 0xbf666666, 0x3e3d3419,
    0x0, 0x0, 0xbf666666, 0x3e317235,
    0x0, 0x0, 0xbf666666, 0x3e25be82,
    0x0, 0x0, 0xbf666666, 0x3e1a1801,
    0x0, 0x0, 0xbf666666, 0x3e0e7db7,
    0x0, 0x0, 0xbf666666, 0x3e02eeae,
    0x0, 0x0, 0xbf666666, 0x3deed3e1,
    0x0, 0x0, 0xbf666666, 0x3dd7dd22,
    0x0, 0x0, 0xbf666666, 0x3dc0f742,
    0x0, 0x0, 0xbf666666, 0x3daa206d,
    0x0, 0x0, 0xbf666666, 0x3d9356d3,
    0x0, 0x0, 0xbf666666, 0x3d793152,
    0x0, 0x0, 0xbf666666, 0x3d4bc84b,
    0x0, 0x0, 0xbf666666, 0x3d1e6f08,
    0x0, 0x0, 0xbf666666, 0x3ce24403,
    0x0, 0x0, 0xbf666666, 0x3c87bb6d,
    0x0, 0x0, 0xbf666666, 0x3bb4f540,
    0x0, 0x0, 0xbf666666, 0xbbb4f540,
    0x0, 0x0, 0xbf666666, 0xbc87bb6d,
    0x0, 0x0, 0xbf666666, 0xbce24403,
    0x0, 0x0, 0xbf666666, 0xbd1e6f08,
    0x0, 0x0, 0xbf666666, 0xbd4bc84b,
    0x0, 0x0, 0xbf666666, 0xbd793152,
    0x0, 0x0, 0xbf666666, 0xbd9356d3,
    0x0, 0x0, 0xbf666666, 0xbdaa206d,
    0x0, 0x0, 0xbf666666, 0xbdc0f742,
    0x0, 0x0, 0xbf666666, 0xbdd7dd22,
    0x0, 0x0, 0xbf666666, 0xbdeed3e1,
    0x0, 0x0, 0xbf666666, 0xbe02eeae,
    0x0, 0x0, 0xbf666666, 0xbe0e7db7,
    0x0, 0x0, 0xbf666666, 0xbe1a1801,
    0x0, 0x0, 0xbf666666, 0xbe25be82,
    0x0, 0x0, 0xbf666666, 0xbe317235,
    0x0, 0x0, 0xbf666666, 0xbe3d3419,
    0x0, 0x0, 0xbf666666, 0xbe490531,
    0x0, 0x0, 0xbf666666, 0xbe54e687,
    0x0, 0x0, 0xbf666666, 0xbe60d927,
    0x0, 0x0, 0xbf666666, 0xbe6cde27,
    0x0, 0x0, 0xbf666666, 0xbe78f6a0,
    0x0, 0x0, 0xbf666666, 0xbe8291d9,
    0x0, 0x0, 0xbf666666, 0xbe88b343,
    0x0, 0x0, 0xbf666666, 0xbe8ee025,
    0x0, 0x0, 0xbf666666, 0xbe95191a,
    0x0, 0x0, 0xbf666666, 0xbe9b5ec4,
    0x0, 0x0, 0xbf666666, 0xbea1b1c5,
    0x0, 0x0, 0xbf666666, 0xbea812c7,
    0x0, 0x0, 0xbf666666, 0xbeae8279,
    0x0, 0x0, 0xbf666666, 0xbeb5018e,
    0x0, 0x0, 0xbf666666, 0xbebb90bf,
    0x0, 0x0, 0xbf666666, 0xbec230ce,
    0x0, 0x0, 0xbf666666, 0xbec8e27e,
    0x0, 0x0, 0xbf666666, 0xbecfa69e,
    0x0, 0x0, 0xbf666666, 0xbed67e02,
    0x0, 0x0, 0xbf666666, 0xbedd6986,
    0x0, 0x0, 0xbf666666, 0xbee46a0e,
    0x0, 0x0, 0xbf666666, 0xbeeb8088,
    0x0, 0x0, 0xbf666666, 0xbef2ade9,
    0x0, 0x0, 0xbf666666, 0xbef9f332,
    0x0, 0x0, 0xbf666666, 0xbf00a8b6,
    0x0, 0x0, 0xbf666666, 0xbf0464d8,
    0x0, 0x0, 0xbf666666, 0xbf082e8f,
    0x0, 0x0, 0xbf666666, 0xbf0c0671,
    0x0, 0x0, 0xbf666666, 0xbf0fed1d,
    0x0, 0x0, 0xbf666666, 0xbf13e337,
    0x0, 0x0, 0xbf666666, 0xbf17e96b,
    0x0, 0x0, 0xbf666666, 0xbf1c006f,
    0x0, 0x0, 0xbf666666, 0xbf2028fe,
    0x0, 0x0, 0xbf666666, 0xbf2463df,
    0x0, 0x0, 0xbf666666, 0xbf28b1e2,
    0x0, 0x0, 0xbf666666, 0xbf2d13e1,
    0x0, 0x0, 0xbf666666, 0xbf318ac2,
    0x0, 0x0, 0xbf666666, 0xbf361774,
    0x0, 0x0, 0xbf666666, 0xbf3abaf8,
    0x0, 0x0, 0xbf666666, 0xbf3f7657,
    0x0, 0x0, 0xbf666666, 0xbf444aae,
    0x0, 0x0, 0xbf666666, 0xbf493924,
    0x0, 0x0, 0xbf666666, 0xbf4e42f6,
    0x0, 0x0, 0xbf666666, 0xbf53696f,
    0x0, 0x0, 0xbf666666, 0xbf58adf2,
    0x0, 0x0, 0xbf666666, 0xbf5e11f2,
    0x0, 0x0, 0xbf666666, 0xbf6396fb,
    0x0, 0x0, 0xbf666666, 0xbf693eb3,
    0x0, 0x0, 0xbf666666, 0xbf6f0ad8,
    0x0, 0x0, 0xbf666666, 0xbf74fd45,
    0x0, 0x0, 0xbf666666, 0xbf7b17f5,
    0x0, 0x0, 0xbf666666, 0xbf80ae81,
    0x0, 0x0, 0xbf666666, 0xbf83e757,
    0x0, 0x0, 0xbf666666, 0xbf8737b0,
    0x0, 0x0, 0xbf666666, 0xbf8aa0d5,
    0x0, 0x0, 0xbf666666, 0xbf8e2427,
    0x0, 0x0, 0xbf666666, 0xbf91c321,
    0x0, 0x0, 0xbf666666, 0xbf957f59,
    0x0, 0x0, 0xbf666666, 0xbf995a85,
    0x0, 0x0, 0xbf666666, 0xbf9d567b,
    0x0, 0x0, 0xbf666666, 0xbfa17537,
    0x0, 0x0, 0xbf666666, 0xbfa5b8df,
    0x0, 0x0, 0xbf666666, 0xbfaa23c3,
    0x0, 0x0, 0xbf666666, 0xbfaeb868,
    0x0, 0x0, 0xbf666666, 0xbfb37988,
    0x0, 0x0, 0xbf666666, 0xbfb86a1c,
    0x0, 0x0, 0xbf666666, 0xbfbd8d5e,
    0x0, 0x0, 0xbf666666, 0xbfc2e6d7,
    0x0, 0x0, 0xbf666666, 0xbfc87a64,
    0x0, 0x0, 0xbf666666, 0xbfce4c3f,
    0x0, 0x0, 0xbf666666, 0xbfd4610f,
    0x0, 0x0, 0xbf666666, 0xbfdabdf3,
    0x0, 0x0, 0xbf666666, 0xbfe16891,
    0x0, 0x0, 0xbf666666, 0xbfe8672a,
    0x0, 0x0, 0xbf666666, 0xbfefc0ad,
    0x0, 0x0, 0xbf666666, 0xbff77cd2,
    0x0, 0x0, 0xbf666666, 0xbfffa435,
    0x0, 0x0, 0xbf666666, 0xc004203c,
    0x0, 0x0, 0xbf666666, 0xc008ae38,
    0x0, 0x0, 0xbf666666, 0xc00d8226,
    0x0, 0x0, 0xbf666666, 0xc012a2ec,
    0x0, 0x0, 0xbf666666, 0xc018185f,
    0x0, 0x0, 0xbf666666, 0xc01deb6c,
    0x0, 0x0, 0xbf666666, 0xc024264f,
    0x0, 0x0, 0xbf666666, 0xc02ad4cd,
    0x0, 0x0, 0xbf666666, 0xc0320482,
    0x0, 0x0, 0xbf666666, 0xc039c547,
    0x0, 0x0, 0xbf666666, 0xc04229a3,
    0x0, 0x0, 0xbf666666, 0xc04b476c,
    0x0, 0x0, 0xbf666666, 0xc0553884,
    0x0, 0x0, 0xbf666666, 0xc0601bdc,
    0x0, 0x0, 0xbf666666, 0xc06c16bd,
    0x0, 0x0, 0xbf666666, 0xc0795680,
    0x0, 0x0, 0xbf666666, 0xc084096e,
    0x0, 0x0, 0xbf666666, 0xc08c4882,
    0x0, 0x0, 0xbf666666, 0xc0959408,
    0x0, 0x0, 0xbf666666, 0xc0a0238b,
    0x0, 0x0, 0xbf666666, 0xc0ac3f0d,
    0x0, 0x0, 0xbf666666, 0xc0ba4599,
    0x0, 0x0, 0xbf666666, 0xc0cab74c,
    0x0, 0x0, 0xbf666666, 0xc0de450d,
    0x0, 0x0, 0xbf666666, 0xc0f5ea42,
    0x0, 0x0, 0xbf666666, 0xc1098c4e,
    0x0, 0x0, 0xbf666666, 0xc11c037e,
    0x0, 0x0, 0xbf666666, 0xc134248a,
    0x0, 0x0, 0xbf666666, 0xc155064a,
    0x0, 0x0, 0xbf666666, 0xc1823f46,
    0x0, 0x0, 0xbf666666, 0xc1a7872a,
    0x0, 0x0, 0xbf666666, 0xc1ea9c21,
    0x0, 0x0, 0xbf666666, 0xc2438c29,
    0x0, 0x0, 0xbf666666, 0xc312ace4
    };

static const uint32_t ref_cfft_step_512[1024] = {
    0x43666666, 0x0, 0xbf666666, 0x4312ace4,
    0x0, 0x0, 0xbf666666, 0x42438c29,
    0x0, 0x0, 0xbf666666, 0x41ea9c21,
    0x0, 0x0, 0xbf666666, 0x41a7872a,
    0x0, 0x0, 0xbf666666, 0x41823f46,
    0x0, 0x0, 0xbf666666, 0x4155064a,
    0x0, 0x0, 0xbf666666, 0x4134248a,
    0x0, 0x0, 0xbf666666, 0x411c037e,
    0x0, 0x0, 0xbf666666, 0x41098c4e,
    0x0, 0x0, 0xbf666666, 0x40f5ea42,
    0x0, 0x0, 0xbf666666, 0x40de450d,
    0x0, 0x0, 0xbf666666, 0x40cab74c,
    0x0, 0x0, 0xbf666666, 0x40ba4599,
    0x0, 0x0, 0xbf666666, 0x40ac3f0d,
    0x0, 0x0, 0xbf666666, 0x40a0238b,
    0x0, 0x0, 0xbf666666, 0x40959408,
    0x0, 0x0, 0xbf666666, 0x408c4882,
    0x0, 0x0, 0xbf666666, 0x4084096e,
    0x0, 0x0, 0xbf666666, 0x40795680,
    0x0, 0x0, 0xbf666666, 0x406c16bd,
    0x0, 0x0, 0xbf666666, 0x40601bdc,
    0x0, 0x0, 0xbf666666, 0x40553884,
    0x0, 0x0, 0xbf666666, 0x404b476c,
    0x0, 0x0, 0xbf666666, 0x404229a3,
    0x0, 0x0, 0xbf666666, 0x4039c547,
    0x0, 0x0, 0xbf666666, 0x40320482,
    0x0, 0x0, 0xbf666666, 0x402ad4cd,
    0x0, 0x0, 0xbf666666, 0x4024264f,
    0x0, 0x0, 0xbf666666, 0x401deb6c,
    0x0, 0x0, 0xbf666666, 0x4018185f,
    0x0, 0x0, 0xbf666666, 0x4012a2ec,
    0x0, 0x0, 0xbf666666, 0x400d8226,
    0x0, 0x0, 0xbf666666, 0x4008ae38,
    0x0, 0x0, 0xbf666666, 0x4004203c,
    0x0, 0x0, 0xbf666666, 0x3fffa435,
    0x0, 0x0, 0xbf666666, 0x3ff77cd2,
    0x0, 0x0, 0xbf666666, 0x3fefc0ad,
    0x0, 0x0, 0xbf666666, 0x3fe8672a,
    0x0, 0x0, 0xbf666666, 0x3fe16891,
    0x0, 0x0, 0xbf666666, 0x3fdabdf3,
    0x0, 0x0, 0xbf666666, 0x3fd4610f,
    0x0, 0x0, 0xbf666666, 0x3fce4c3f,
    0x0, 0x0, 0xbf666666, 0x3fc87a64,
    0x0, 0x0, 0xbf666666, 0x3fc2e6d7,
    0x0, 0x0, 0xbf666666, 0x3fbd8d5e,
    0x0, 0x0, 0xbf666666, 0x3fb86a1c,
    0x0, 0x0, 0xbf666666, 0x3fb37988,
    0x0, 0x0, 0xbf666666, 0x3faeb868,
    0x0, 0x0, 0xbf666666, 0x3faa23c3,
    0x0, 0x0, 0xbf666666, 0x3fa5b8df,
    0x0, 0x0, 0xbf666666, 0x3fa17537,
    0x0, 0x0, 0xbf666666, 0x3f9d567b,
    0x0, 0x0, 0xbf666666, 0x3f995a85,
    0x0, 0x0, 0xbf666666, 0x3f957f59,
    0x0, 0x0, 0xbf666666, 0x3f91c321,
    0x0, 0x0, 0xbf666666, 0x3f8e2427,
    0x0, 0x0, 0xbf666666, 0x3f8aa0d5,
    0x0, 0x0, 0xbf666666, 0x3f8737b0,
    0x0, 0x0, 0xbf666666, 0x3f83e757,
    0x0, 0x0, 0xbf666666, 0x3f80ae81,
    0x0, 0x0, 0xbf666666, 0x3f7b17f5,
    0x0, 0x0, 0xbf666666, 0x3f74fd45,
    0x0, 0x0, 0xbf666666, 0x3f6f0ad8,
    0x0, 0x0, 0xbf666666, 0x3f693eb3,
    0x0, 0x0, 0xbf666666, 0x3f6396fb,
    0x0, 0x0, 0xbf666666, 0x3f5e11f2,
    0x0, 0x0, 0xbf666666, 0x3f58adf2,
    0x0, 0x0, 0xbf666666, 0x3f53696f,
    0x0, 0x0, 0xbf666666, 0x3f4e42f6,
    0x0, 0x0, 0xbf666666, 0x3f493924,
    0x0, 0x0, 0xbf666666, 0x3f444aae,
    0x0, 0x0, 0xbf666666, 0x3f3f7657,
    0x0, 0x0, 0xbf666666, 0x3f3abaf8,
    0x0, 0x0, 0xbf666666, 0x3f361774,
    0x0, 0x0, 0xbf666666, 0x3f318ac2,
    0x0, 0x0, 0xbf666666, 0x3f2d13e1,
    0x0, 0x0, 0xbf666666, 0x3f28b1e2,
    0x0, 0x0, 0xbf666666, 0x3f2463df,
    0x0, 0x0, 0xbf666666, 0x3f2028fe,
    0x0, 0x0, 0xbf666666, 0x3f1c006f,
    0x0, 0x0, 0xbf666666, 0x3f17e96b,
    0x0, 0x0, 0xbf666666, 0x3f13e337,
    0x0, 0x0, 0xbf666666, 0x3f0fed1d,
    0x0, 0x0, 0xbf666666, 0x3f0c0671,
    0x0, 0x0, 0xbf666666, 0x3f082e8f,
    0x0, 0x0, 0xbf666666, 0x3f0464d8,
    0x0, 0x0, 0xbf666666, 0x3f00a8b6,
    0x0, 0x0, 0xbf666666, 0x3ef9f332,
    0x0, 0x0, 0xbf666666, 0x3ef2ade9,
    0x0, 0x0, 0xbf666666, 0x3eeb8088,
    0x0, 0x0, 0xbf666666, 0x3ee46a0e,
    0x0, 0x0, 0xbf666666, 0x3edd6986,
    0x0, 0x0, 0xbf666666, 0x3ed67e02,
    0x0, 0x0, 0xbf666666, 0x3ecfa69e,
    0x0, 0x0, 0xbf666666, 0x3ec8e27e,
    0x0, 0x0, 0xbf666666, 0x3ec230ce,
    0x0, 0x0, 0xbf666666, 0x3ebb90bf,
    0x0, 0x0, 0xbf666666, 0x3eb5018e,
    0x0, 0x0, 0xbf666666, 0x3eae8279,
    0x0, 0x0, 0xbf666666, 0x3ea812c7,
    0x0, 0x0, 0xbf666666, 0x3ea1b1c5,
    0x0, 0x0, 0xbf666666, 0x3e9b5ec4,
    0x0, 0x0, 0xbf666666, 0x3e95191a,
    0x0, 0x0, 0xbf666666, 0x3e8ee025,
    0x0, 0x0, 0xbf666666, 0x3e88b343,
    0x0, 0x0, 0xbf666666, 0x3e8291d9,
    0x0, 0x0, 0xbf666666, 0x3e78f6a0,
    0x0, 0x0, 0xbf666666, 0x3e6cde27,
    0x0, 0x0, 0xbf666666, 0x3e60d927,
    0x0, 0x0, 0xbf666666, 0x3e54e687,
    0x0, 0x0, 0xbf666666, 0x3e490531,
    0x0, 0x0, 0xbf666666, 0x3e3d3419,
    0x0, 0x0, 0xbf666666, 0x3e317235,
    0x0, 0x0, 0xbf666666, 0x3e25be82,
    0x0, 0x0, 0xbf666666, 0x3e1a1801,
    0x0, 0x0, 0xbf666666, 0x3e0e7db7,
    0x0, 0x0, 0xbf666666, 0x3e02eeae,
    0x0, 0x0, 0xbf666666, 0x3deed3e1,
    0x0, 0x0, 0xbf666666, 0x3dd7dd22,
    0x0, 0x0, 0xbf666666, 0x3dc0f742,
    0x0, 0x0, 0xbf666666, 0x3daa206d,
    0x0, 0x0, 0xbf666666, 0x3d9356d3,
    0x0, 0x0, 0xbf666666, 0x3d793152,
    0x0, 0x0, 0xbf666666, 0x3d4bc84b,
    0x0, 0x0, 0xbf666666, 0x3d1e6f08,
    0x0, 0x0, 0xbf666666, 0x3ce24403,
    0x0, 0x0, 0xbf666666, 0x3c87bb6d,
    0x0, 0x0, 0xbf666666, 0x3bb4f540,
    0x0, 0x0, 0xbf666666, 0xbbb4f540,
    0x0, 0x0, 0xbf666666, 0xbc87bb6d,
    0x0, 0x0, 0xbf666666, 0xbce24403,
    0x0, 0x0, 0xbf666666, 0xbd1e6f08,
    0x0, 0x0, 0xbf666666, 0xbd4bc84b,
    0x0, 0x0, 0xbf666666, 0xbd793152,
    0x0, 0x0, 0xbf666666, 0xbd9356d3,
    0x0, 0x0, 0xbf666666, 0xbdaa206d,
    0x0, 0x0, 0xbf666666, 0xbdc0f742,
    0x0, 0x0, 0xbf666666, 0xbdd7dd22,
    0x0, 0x0, 0xbf666666, 0xbdeed3e1,
    0x0, 0x0, 0xbf666666, 0xbe02eeae,
    0x0, 0x0, 0xbf666666, 0xbe0e7db7,
    0x0, 0x0, 0xbf666666, 0xbe1a1801,
    0x0, 0x0, 0xbf666666, 0xbe25be82,
    0x0, 0x0, 0xbf666666, 0xbe317235,
    0x0, 0x0, 0xbf666666, 0xbe3d3419,
    0x0, 0x0, 0xbf666666, 0xbe490531,
    0x0, 0x0, 0xbf666666, 0xbe54e687,
    0x0, 0x0, 0xbf666666, 0xbe60d927,
    0x0, 0x0, 0xbf666666, 0xbe6cde27,
    0x0, 0x0, 0xbf666666, 0xbe78f6a0,
    0x0, 0x0, 0xbf666666, 0xbe8291d9,
    0x0, 0x0, 0xbf666666, 0xbe88b343,
    0x0, 0x0, 0xbf666666, 0xbe8ee025,
    0x0, 0x0, 0xbf666666, 0xbe95191a,
    0x0, 0x0, 0xbf666666, 0xbe9b5ec4,
    0x0, 0x0, 0xbf666666, 0xbea1b1c5,
    0x0, 0x0, 0xbf666666, 0xbea812c7,
    0x0, 0x0, 0xbf666666, 0xbeae8279,
    0x0, 0x0, 0xbf666666, 0xbeb5018e,
    0x0, 0x0, 0xbf666666, 0xbebb90bf,
    0x0, 0x0, 0xbf666666, 0xbec230ce,
    0x0, 0x0, 0xbf666666, 0xbec8e27e,
    0x0, 0x0, 0xbf666666, 0xbecfa69e,
    0x0, 0x0, 0xbf666666, 0xbed67e02,
    0x0, 0x0, 0xbf666666, 0xbedd6986,
    0x0, 0x0, 0xbf666666, 0xbee46a0e,
    0x0, 0x0, 0xbf666666, 0xbeeb8088,
    0x0, 0x0, 0xbf666666, 0xbef2ade9,
    0x0, 0x0, 0xbf666666, 0xbef9f332,
    0x0, 0x0, 0xbf666666, 0xbf00a8b6,
    0x0, 0x0, 0xbf666666, 0xbf0464d8,
    0x0, 0x0, 0xbf666666, 0xbf082e8f,
    0x0, 0x0, 0xbf666666, 0xbf0c0671,
    0x0, 0x0, 0xbf666666, 0xbf0fed1d,
    0x0, 0x0, 0xbf666666, 0xbf13e337,
    0x0, 0x0, 0xbf666666, 0xbf17e96b,
    0x0, 0x0, 0xbf666666, 0xbf1c006f,
    0x0, 0x0, 0xbf666666, 0xbf2028fe,
    0x0, 0x0, 0xbf666666, 0xbf2463df,
    0x0, 0x0, 0xbf666666, 0xbf28b1e2,
    0x0, 0x0, 0xbf666666, 0xbf2d13e1,
    0x0, 0x0, 0xbf666666, 0xbf318ac2,
    0x0, 0x0, 0xbf666666, 0xbf361774,
    0x0, 0x0, 0xbf666666, 0xbf3abaf8,
    0x0, 0x0, 0xbf666666, 0xbf3f7657,
    0x0, 0x0, 0xbf666666, 0xbf444aae,
    0x0, 0x0, 0xbf666666, 0xbf493924,
    0x0, 0x0, 0xbf666666, 0xbf4e42f6,
    0x0, 0x0, 0xbf666666, 0xbf53696f,
    0x0, 0x0, 0xbf666666, 0xbf58adf2,
    0x0, 0x0, 0xbf666666, 0xbf5e11f2,
    0x0, 0x0, 0xbf666666, 0xbf6396fb,
    0x0, 0x0, 0xbf666666, 0xbf693eb3,
    0x0, 0x0, 0xbf666666, 0xbf6f0ad8,
    0x0, 0x0, 0xbf666666, 0xbf74fd45,
    0x0, 0x0, 0xbf666666, 0xbf7b17f5,
    0x0, 0x0, 0xbf666666, 0xbf80ae81,
    0x0, 0x0, 0xbf666666, 0xbf83e757,
    0x0, 0x0, 0xbf666666, 0xbf8737b0,
    0x0, 0x0, 0xbf666666, 0xbf8aa0d5,
    0x0, 0x0, 0xbf666666, 0xbf8e2427,
    0x0, 0x0, 0xbf666666, 0xbf91c321,
    0x0, 0x0, 0xbf666666, 0xbf957f59,
    0x0, 0x0, 0xbf666666, 0xbf995a85,
    0x0, 0x0, 0xbf666666, 0xbf9d567b,
    0x0, 0x0, 0xbf666666, 0xbfa17537,
    0x0, 0x0, 0xbf666666, 0xbfa5b8df,
    0x0, 0x0, 0xbf666666, 0xbfaa23c3,
    0x0, 0x0, 0xbf666666, 0xbfaeb868,
    0x0, 0x0, 0xbf666666, 0xbfb37988,
    0x0, 0x0, 0xbf666666, 0xbfb86a1c,
    0x0, 0x0, 0xbf666666, 0xbfbd8d5e,
    0x0, 0x0, 0xbf666666, 0xbfc2e6d7,
    0x0, 0x0, 0xbf666666, 0xbfc87a64,
    0x0, 0x0, 0xbf666666, 0xbfce4c3f,
    0x0, 0x0, 0xbf666666, 0xbfd4610f,
    0x0, 0x0, 0xbf666666, 0xbfdabdf3,
    0x0, 0x0, 0xbf666666, 0xbfe16891,
    0x0, 0x0, 0xbf666666, 0xbfe8672a,
    0x0, 0x0, 0xbf666666, 0xbfefc0ad,
    0x0, 0x0, 0xbf666666, 0xbff77cd2,
    0x0, 0x0, 0xbf666666, 0xbfffa435,
    0x0, 0x0, 0xbf666666, 0xc004203c,
    0x0, 0x0, 0xbf666666, 0xc008ae38,
    0x0, 0x0, 0xbf666666, 0xc00d8226,
    0x0, 0x0, 0xbf666666, 0xc012a2ec,
    0x0, 0x0, 0xbf666666, 0xc018185f,
    0x0, 0x0, 0xbf666666, 0xc01deb6c,
    0x0, 0x0, 0xbf666666, 0xc024264f,
    0x0, 0x0, 0xbf666666, 0xc02ad4cd,
    0x0, 0x0, 0xbf666666, 0xc0320482,
    0x0, 0x0, 0xbf666666, 0xc039c547,
    0x0, 0x0, 0xbf666666, 0xc04229a3,
    0x0, 0x0, 0xbf666666, 0xc04b476c,
    0x0, 0x0, 0xbf666666, 0xc0553884,
    0x0, 0x0, 0xbf666666, 0xc0601bdc,
    0x0, 0x0, 0xbf666666, 0xc06c16bd,
    0x0, 0x0, 0xbf666666, 0xc0795680,
    0x0, 0x0, 0xbf666666, 0xc084096e,
    0x0, 0x0, 0xbf666666, 0xc08c4882,
    0x0, 0x0, 0xbf666666, 0xc0959408,
    0x0, 0x0, 0xbf666666, 0xc0a0238b,
    0x0, 0x0, 0xbf666666, 0xc0ac3f0d,
    0x0, 0x0, 0xbf666666, 0xc0ba4599,
    0x0, 0x0, 0xbf666666, 0xc0cab74c,
    0x0, 0x0, 0xbf666666, 0xc0de450d,
    0x0, 0x0, 0xbf666666, 0xc0f5ea42,
    0x0, 0x0, 0xbf666666, 0xc1098c4e,
    0x0, 0x0, 0xbf666666, 0xc11c037e,
    0x0, 0x0, 0xbf666666, 0xc134248a,
    0x0, 0x0, 0xbf666666, 0xc155064a,
    0x0, 0x0, 0xbf666666, 0xc1823f46,
    0x0, 0x0, 0xbf666666, 0xc1a7872a,
    0x0, 0x0, 0xbf666666, 0xc1ea9c21,
    0x0, 0x0, 0xbf666666, 0xc2438c29,
    0x0, 0x0, 0xbf666666, 0xc312ace4
    };

static const uint32_t in_cfft_step_1024[2048] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_1024[2048] = {
    0x43e66666, 0x0, 0xbf666666, 0x4392ad3f,
    0x0, 0x0, 0xbf666666, 0x42c39067,
    0x0, 0x0, 0xbf666666, 0x426aaa44,
    0x0, 0x0, 0xbf666666, 0x42279af6,
    0x0, 0x0, 0xbf666666, 0x420258ba,
    0x0, 0x0, 0xbf666666, 0x41d54485,
    0x0, 0x0, 0xbf666666, 0x41b46e18,
    0x0, 0x0, 0xbf666666, 0x419c5860,
    0x0, 0x0, 0xbf666666, 0x4189ec87,
    0x0, 0x0, 0xbf666666, 0x4176c163,
    0x0, 0x0, 0xbf666666, 0x415f32e3,
    0x0, 0x0, 0xbf666666, 0x414bbbdb,
    0x0, 0x0, 0xbf666666, 0x413b60e6,
    0x0, 0x0, 0xbf666666, 0x412d711d,
    0x0, 0x0, 0xbf666666, 0x41216c65,
    0x0, 0x0, 0xbf666666, 0x4116f3b2,
    0x0, 0x0, 0xbf666666, 0x410dbf03,
    0x0, 0x0, 0xbf666666, 0x410596cc,
    0x0, 0x0, 0xbf666666, 0x40fc9f09,
    0x0, 0x0, 0xbf666666, 0x40ef8d22,
    0x0, 0x0, 0xbf666666, 0x40e3c02e,
    0x0, 0x0, 0xbf666666, 0x40d90ad5,
    0x0, 0x0, 0xbf666666, 0x40cf47d0,
    0x0, 0x0, 0xbf666666, 0x40c6582f,
    0x0, 0x0, 0xbf666666, 0x40be220e,
    0x0, 0x0, 0xbf666666, 0x40b68f9c,
    0x0, 0x0, 0xbf666666, 0x40af8e4f,
    0x0, 0x0, 0xbf666666, 0x40a90e53,
    0x0, 0x0, 0xbf666666, 0x40a3020a,
    0x0, 0x0, 0xbf666666, 0x409d5db0,
    0x0, 0x0, 0xbf666666, 0x4098170c,
    0x0, 0x0, 0xbf666666, 0x40932530,
    0x0, 0x0, 0xbf666666, 0x408e8049,
    0x0, 0x0, 0xbf666666, 0x408a2173,
    0x0, 0x0, 0xbf666666, 0x40860296,
    0x0, 0x0, 0xbf666666, 0x40821e49,
    0x0, 0x0, 0xbf666666, 0x407cdf77,
    0x0, 0x0, 0xbf666666, 0x4075e542,
    0x0, 0x0, 0xbf666666, 0x406f463e,
    0x0, 0x0, 0xbf666666, 0x4068fb7d,
    0x0, 0x0, 0xbf666666, 0x4062fec1,
    0x0, 0x0, 0xbf666666, 0x405d4a65,
    0x0, 0x0, 0xbf666666, 0x4057d94e,
    0x0, 0x0, 0xbf666666, 0x4052a6d6,
    0x0, 0x0, 0xbf666666, 0x404daec5,
    0x0, 0x0, 0xbf666666, 0x4048ed41,
    0x0, 0x0, 0xbf666666, 0x40445ec4,
    0x0, 0x0, 0xbf666666, 0x40400014,
    0x0, 0x0, 0xbf666666, 0x403bce3d,
    0x0, 0x0, 0xbf666666, 0x4037c686,
    0x0, 0x0, 0xbf666666, 0x4033e66d,
    0x0, 0x0, 0xbf666666, 0x40302ba4,
    0x0, 0x0, 0xbf666666, 0x402c9409,
    0x0, 0x0, 0xbf666666, 0x40291da1,
    0x0, 0x0, 0xbf666666, 0x4025c699,
    0x0, 0x0, 0xbf666666, 0x40228d3d,
    0x0, 0x0, 0xbf666666, 0x401f6ffb,
    0x0, 0x0, 0xbf666666, 0x401c6d59,
    0x0, 0x0, 0xbf666666, 0x401983fb,
    0x0, 0x0, 0xbf666666, 0x4016b29a,
    0x0, 0x0, 0xbf666666, 0x4013f804,
    0x0, 0x0, 0xbf666666, 0x4011531d,
    0x0, 0x0, 0xbf666666, 0x400ec2d9,
    0x0, 0x0, 0xbf666666, 0x400c463f,
    0x0, 0x0, 0xbf666666, 0x4009dc63,
    0x0, 0x0, 0xbf666666, 0x4007846a,
    0x0, 0x0, 0xbf666666, 0x40053d85,
    0x0, 0x0, 0xbf666666, 0x400306f0,
    0x0, 0x0, 0xbf666666, 0x4000dff5,
    0x0, 0x0, 0xbf666666, 0x3ffd8fcc,
    0x0, 0x0, 0xbf666666, 0x3ff97c41,
    0x0, 0x0, 0xbf666666, 0x3ff58415,
    0x0, 0x0, 0xbf666666, 0x3ff1a625,
    0x0, 0x0, 0xbf666666, 0x3fede15e,
    0x0, 0x0, 0xbf666666, 0x3fea34bb,
    0x0, 0x0, 0xbf666666, 0x3fe69f46,
    0x0, 0x0, 0xbf666666, 0x3fe32016,
    0x0, 0x0, 0xbf666666, 0x3fdfb64b,
    0x0, 0x0, 0xbf666666, 0x3fdc6115,
    0x0, 0x0, 0xbf666666, 0x3fd91fac,
    0x0, 0x0, 0xbf666666, 0x3fd5f150,
    0x0, 0x0, 0xbf666666, 0x3fd2d54f,
    0x0, 0x0, 0xbf666666, 0x3fcfcafb,
    0x0, 0x0, 0xbf666666, 0x3fccd1b1,
    0x0, 0x0, 0xbf666666, 0x3fc9e8d6,
    0x0, 0x0, 0xbf666666, 0x3fc70fd5,
    0x0, 0x0, 0xbf666666, 0x3fc44620,
    0x0, 0x0, 0xbf666666, 0x3fc18b2f,
    0x0, 0x0, 0xbf666666, 0x3fbede82,
    0x0, 0x0, 0xbf666666, 0x3fbc3f9d,
    0x0, 0x0, 0xbf666666, 0x3fb9ae0a,
    0x0, 0x0, 0xbf666666, 0x3fb72958,
    0x0, 0x0, 0xbf666666, 0x3fb4b11b,
    0x0, 0x0, 0xbf666666, 0x3fb244ec,
    0x0, 0x0, 0xbf666666, 0x3fafe468,
    0x0, 0x0, 0xbf666666, 0x3fad8f30,
    0x0, 0x0, 0xbf666666, 0x3fab44e8,
    0x0, 0x0, 0xbf666666, 0x3fa9053a,
    0x0, 0x0, 0xbf666666, 0x3fa6cfd2,
    0x0, 0x0, 0xbf666666, 0x3fa4a45f,
    0x0, 0x0, 0xbf666666, 0x3fa28294,
    0x0, 0x0, 0xbf666666, 0x3fa06a28,
    0x0, 0x0, 0xbf666666, 0x3f9e5ad3,
    0x0, 0x0, 0xbf666666, 0x3f9c544f,
    0x0, 0x0, 0xbf666666, 0x3f9a565c,
    0x0, 0x0, 0xbf666666, 0x3f9860ba,
    0x0, 0x0, 0xbf666666, 0x3f96732c,
    0x0, 0x0, 0xbf666666, 0x3f948d76,
    0x0, 0x0, 0xbf666666, 0x3f92af61,
    0x0, 0x0, 0xbf666666, 0x3f90d8b5,
    0x0, 0x0, 0xbf666666, 0x3f8f093f,
    0x0, 0x0, 0xbf666666, 0x3f8d40ca,
    0x0, 0x0, 0xbf666666, 0x3f8b7f27,
    0x0, 0x0, 0xbf666666, 0x3f89c426,
    0x0, 0x0, 0xbf666666, 0x3f880f99,
    0x0, 0x0, 0xbf666666, 0x3f866154,
    0x0, 0x0, 0xbf666666, 0x3f84b92d,
    0x0, 0x0, 0xbf666666, 0x3f8316fa,
    0x0, 0x0, 0xbf666666, 0x3f817a94,
    0x0, 0x0, 0xbf666666, 0x3f7fc7a7,
    0x0, 0x0, 0xbf666666, 0x3f7ca52a,
    0x0, 0x0, 0xbf666666, 0x3f798d66,
    0x0, 0x0, 0xbf666666, 0x3f768017,
    0x0, 0x0, 0xbf666666, 0x3f737cf8,
    0x0, 0x0, 0xbf666666, 0x3f7083ca,
    0x0, 0x0, 0xbf666666, 0x3f6d944b,
    0x0, 0x0, 0xbf666666, 0x3f6aae40,
    0x0, 0x0, 0xbf666666, 0x3f67d16d,
    0x0, 0x0, 0xbf666666, 0x3f64fd98,
    0x0, 0x0, 0xbf666666, 0x3f62328a,
    0x0, 0x0, 0xbf666666, 0x3f5f700b,
    0x0, 0x0, 0xbf666666, 0x3f5cb5e9,
    0x0, 0x0, 0xbf666666, 0x3f5a03ef,
    0x0, 0x0, 0xbf666666, 0x3f5759ec,
    0x0, 0x0, 0xbf666666, 0x3f54b7b1,
    0x0, 0x0, 0xbf666666, 0x3f521d0e,
    0x0, 0x0, 0xbf666666, 0x3f4f89d7,
    0x0, 0x0, 0xbf666666, 0x3f4cfddf,
    0x0, 0x0, 0xbf666666, 0x3f4a78fb,
    0x0, 0x0, 0xbf666666, 0x3f47fb02,
    0x0, 0x0, 0xbf666666, 0x3f4583cc,
    0x0, 0x0, 0xbf666666, 0x3f431331,
    0x0, 0x0, 0xbf666666, 0x3f40a90a,
    0x0, 0x0, 0xbf666666, 0x3f3e4534,
    0x0, 0x0, 0xbf666666, 0x3f3be788,
    0x0, 0x0, 0xbf666666, 0x3f398fe5,
    0x0, 0x0, 0xbf666666, 0x3f373e27,
    0x0, 0x0, 0xbf666666, 0x3f34f22e,
    0x0, 0x0, 0xbf666666, 0x3f32abd9,
    0x0, 0x0, 0xbf666666, 0x3f306b07,
    0x0, 0x0, 0xbf666666, 0x3f2e2f9b,
    0x0, 0x0, 0xbf666666, 0x3f2bf976,
    0x0, 0x0, 0xbf666666, 0x3f29c87a,
    0x0, 0x0, 0xbf666666, 0x3f279c8b,
    0x0, 0x0, 0xbf666666, 0x3f25758d,
    0x0, 0x0, 0xbf666666, 0x3f235364,
    0x0, 0x0, 0xbf666666, 0x3f2135f7,
    0x0, 0x0, 0xbf666666, 0x3f1f1d2b,
    0x0, 0x0, 0xbf666666, 0x3f1d08e6,
    0x0, 0x0, 0xbf666666, 0x3f1af910,
    0x0, 0x0, 0xbf666666, 0x3f18ed92,
    0x0, 0x0, 0xbf666666, 0x3f16e652,
    0x0, 0x0, 0xbf666666, 0x3f14e33a,
    0x0, 0x0, 0xbf666666, 0x3f12e435,
    0x0, 0x0, 0xbf666666, 0x3f10e92a,
    0x0, 0x0, 0xbf666666, 0x3f0ef206,
    0x0, 0x0, 0xbf666666, 0x3f0cfeb3,
    0x0, 0x0, 0xbf666666, 0x3f0b0f1c,
    0x0, 0x0, 0xbf666666, 0x3f09232d,
    0x0, 0x0, 0xbf666666, 0x3f073ad3,
    0x0, 0x0, 0xbf666666, 0x3f0555fa,
    0x0, 0x0, 0xbf666666, 0x3f037490,
    0x0, 0x0, 0xbf666666, 0x3f019681,
    0x0, 0x0, 0xbf666666, 0x3eff7778,
    0x0, 0x0, 0xbf666666, 0x3efbc85f,
    0x0, 0x0, 0xbf666666, 0x3ef81f93,
    0x0, 0x0, 0xbf666666, 0x3ef47cf3,
    0x0, 0x0, 0xbf666666, 0x3ef0e05d,
    0x0, 0x0, 0xbf666666, 0x3eed49b0,
    0x0, 0x0, 0xbf666666, 0x3ee9b8cd,
    0x0, 0x0, 0xbf666666, 0x3ee62d94,
    0x0, 0x0, 0xbf666666, 0x3ee2a7e7,
    0x0, 0x0, 0xbf666666, 0x3edf27a7,
    0x0, 0x0, 0xbf666666, 0x3edbacb6,
    0x0, 0x0, 0xbf666666, 0x3ed836f7,
    0x0, 0x0, 0xbf666666, 0x3ed4c64f,
    0x0, 0x0, 0xbf666666, 0x3ed15aa0,
    0x0, 0x0, 0xbf666666, 0x3ecdf3d0,
    0x0, 0x0, 0xbf666666, 0x3eca91c3,
    0x0, 0x0, 0xbf666666, 0x3ec73460,
    0x0, 0x0, 0xbf666666, 0x3ec3db8b,
    0x0, 0x0, 0xbf666666, 0x3ec0872b,
    0x0, 0x0, 0xbf666666, 0x3ebd3727,
    0x0, 0x0, 0xbf666666, 0x3eb9eb66,
    0x0, 0x0, 0xbf666666, 0x3eb6a3d0,
    0x0, 0x0, 0xbf666666, 0x3eb3604d,
    0x0, 0x0, 0xbf666666, 0x3eb020c6,
    0x0, 0x0, 0xbf666666, 0x3eace522,
    0x0, 0x0, 0xbf666666, 0x3ea9ad4c,
    0x0, 0x0, 0xbf666666, 0x3ea6792d,
    0x0, 0x0, 0xbf666666, 0x3ea348ae,
    0x0, 0x0, 0xbf666666, 0x3ea01bbb,
    0x0, 0x0, 0xbf666666, 0x3e9cf23d,
    0x0, 0x0, 0xbf666666, 0x3e99cc20,
    0x0, 0x0, 0xbf666666, 0x3e96a94d,
    0x0, 0x0, 0xbf666666, 0x3e9389b2,
    0x0, 0x0, 0xbf666666, 0x3e906d3a,
    0x0, 0x0, 0xbf666666, 0x3e8d53d1,
    0x0, 0x0, 0xbf666666, 0x3e8a3d62,
    0x0, 0x0, 0xbf666666, 0x3e8729db,
    0x0, 0x0, 0xbf666666, 0x3e841929,
    0x0, 0x0, 0xbf666666, 0x3e810b38,
    0x0, 0x0, 0xbf666666, 0x3e7bffeb,
    0x0, 0x0, 0xbf666666, 0x3e75ee9f,
    0x0, 0x0, 0xbf666666, 0x3e6fe267,
    0x0, 0x0, 0xbf666666, 0x3e69db1f,
    0x0, 0x0, 0xbf666666, 0x3e63d8a3,
    0x0, 0x0, 0xbf666666, 0x3e5ddad1,
    0x0, 0x0, 0xbf666666, 0x3e57e185,
    0x0, 0x0, 0xbf666666, 0x3e51ec9d,
    0x0, 0x0, 0xbf666666, 0x3e4bfbf6,
    0x0, 0x0, 0xbf666666, 0x3e460f70,
    0x0, 0x0, 0xbf666666, 0x3e4026e8,
    0x0, 0x0, 0xbf666666, 0x3e3a423d,
    0x0, 0x0, 0xbf666666, 0x3e34614f,
    0x0, 0x0, 0xbf666666, 0x3e2e83fe,
    0x0, 0x0, 0xbf666666, 0x3e28aa28,
    0x0, 0x0, 0xbf666666, 0x3e22d3af,
    0x0, 0x0, 0xbf666666, 0x3e1d0073,
    0x0, 0x0, 0xbf666666, 0x3e173053,
    0x0, 0x0, 0xbf666666, 0x3e116332,
    0x0, 0x0, 0xbf666666, 0x3e0b98f0,
    0x0, 0x0, 0xbf666666, 0x3e05d16f,
    0x0, 0x0, 0xbf666666, 0x3e000c91,
    0x0, 0x0, 0xbf666666, 0x3df4946c,
    0x0, 0x0, 0xbf666666, 0x3de91483,
    0x0, 0x0, 0xbf666666, 0x3ddd992a,
    0x0, 0x0, 0xbf666666, 0x3dd22227,
    0x0, 0x0, 0xbf666666, 0x3dc6af3e,
    0x0, 0x0, 0xbf666666, 0x3dbb4036,
    0x0, 0x0, 0xbf666666, 0x3dafd4d3,
    0x0, 0x0, 0xbf666666, 0x3da46cdb,
    0x0, 0x0, 0xbf666666, 0x3d990816,
    0x0, 0x0, 0xbf666666, 0x3d8da648,
    0x0, 0x0, 0xbf666666, 0x3d82473a,
    0x0, 0x0, 0xbf666666, 0x3d6dd565,
    0x0, 0x0, 0xbf666666, 0x3d5720ef,
    0x0, 0x0, 0xbf666666, 0x3d4070a3,
    0x0, 0x0, 0xbf666666, 0x3d29c410,
    0x0, 0x0, 0xbf666666, 0x3d131ac3,
    0x0, 0x0, 0xbf666666, 0x3cf8e89d,
    0x0, 0x0, 0xbf666666, 0x3ccba080,
    0x0, 0x0, 0xbf666666, 0x3c9e5c51,
    0x0, 0x0, 0xbf666666, 0x3c623661,
    0x0, 0x0, 0xbf666666, 0x3c07b87c,
    0x0, 0x0, 0xbf666666, 0x3b34f4d0,
    0x0, 0x0, 0xbf666666, 0xbb34f4d0,
    0x0, 0x0, 0xbf666666, 0xbc07b87c,
    0x0, 0x0, 0xbf666666, 0xbc623661,
    0x0, 0x0, 0xbf666666, 0xbc9e5c51,
    0x0, 0x0, 0xbf666666, 0xbccba080,
    0x0, 0x0, 0xbf666666, 0xbcf8e89d,
    0x0, 0x0, 0xbf666666, 0xbd131ac3,
    0x0, 0x0, 0xbf666666, 0xbd29c410,
    0x0, 0x0, 0xbf666666, 0xbd4070a3,
    0x0, 0x0, 0xbf666666, 0xbd5720ef,
    0x0, 0x0, 0xbf666666, 0xbd6dd565,
    0x0, 0x0, 0xbf666666, 0xbd82473a,
    0x0, 0x0, 0xbf666666, 0xbd8da648,
    0x0, 0x0, 0xbf666666, 0xbd990816,
    0x0, 0x0, 0xbf666666, 0xbda46cdb,
    0x0, 0x0, 0xbf666666, 0xbdafd4d3,
    0x0, 0x0, 0xbf666666, 0xbdbb4036,
    0x0, 0x0, 0xbf666666, 0xbdc6af3e,
    0x0, 0x0, 0xbf666666, 0xbdd22227,
    0x0, 0x0, 0xbf666666, 0xbddd992a,
    0x0, 0x0, 0xbf666666, 0xbde91483,
    0x0, 0x0, 0xbf666666, 0xbdf4946c,
    0x0, 0x0, 0xbf666666, 0xbe000c91,
    0x0, 0x0, 0xbf666666, 0xbe05d16f,
    0x0, 0x0, 0xbf666666, 0xbe0b98f0,
    0x0, 0x0, 0xbf666666, 0xbe116332,
    0x0, 0x0, 0xbf666666, 0xbe173053,
    0x0, 0x0, 0xbf666666, 0xbe1d0073,
    0x0, 0x0, 0xbf666666, 0xbe22d3af,
    0x0, 0x0, 0xbf666666, 0xbe28aa28,
    0x0, 0x0, 0xbf666666, 0xbe2e83fe,
    0x0, 0x0, 0xbf666666, 0xbe34614f,
    0x0, 0x0, 0xbf666666, 0xbe3a423d,
    0x0, 0x0, 0xbf666666, 0xbe4026e8,
    0x0, 0x0, 0xbf666666, 0xbe460f70,
    0x0, 0x0, 0xbf666666, 0xbe4bfbf6,
    0x0, 0x0, 0xbf666666, 0xbe51ec9d,
    0x0, 0x0, 0xbf666666, 0xbe57e185,
    0x0, 0x0, 0xbf666666, 0xbe5ddad1,
    0x0, 0x0, 0xbf666666, 0xbe63d8a3,
    0x0, 0x0, 0xbf666666, 0xbe69db1f,
    0x0, 0x0, 0xbf666666, 0xbe6fe267,
    0x0, 0x0, 0xbf666666, 0xbe75ee9f,
    0x0, 0x0, 0xbf666666, 0xbe7bffeb,
    0x0, 0x0, 0xbf666666, 0xbe810b38,
    0x0, 0x0, 0xbf666666, 0xbe841929,
    0x0, 0x0, 0xbf666666, 0xbe8729db,
    0x0, 0x0, 0xbf666666, 0xbe8a3d62,
    0x0, 0x0, 0xbf666666, 0xbe8d53d1,
    0x0, 0x0, 0xbf666666, 0xbe906d3a,
    0x0, 0x0, 0xbf666666, 0xbe9389b2,
    0x0, 0x0, 0xbf666666, 0xbe96a94d,
    0x0, 0x0, 0xbf666666, 0xbe99cc20,
    0x0, 0x0, 0xbf666666, 0xbe9cf23d,
    0x0, 0x0, 0xbf666666, 0xbea01bbb,
    0x0, 0x0, 0xbf666666, 0xbea348ae,
    0x0, 0x0, 0xbf666666, 0xbea6792d,
    0x0, 0x0, 0xbf666666, 0xbea9ad4c,
    0x0, 0x0, 0xbf666666, 0xbeace522,
    0x0, 0x0, 0xbf666666, 0xbeb020c6,
    0x0, 0x0, 0xbf666666, 0xbeb3604d,
    0x0, 0x0, 0xbf666666, 0xbeb6a3d0,
    0x0, 0x0, 0xbf666666, 0xbeb9eb66,
    0x0, 0x0, 0xbf666666, 0xbebd3727,
    0x0, 0x0, 0xbf666666, 0xbec0872b,
    0x0, 0x0, 0xbf666666, 0xbec3db8b,
    0x0, 0x0, 0xbf666666, 0xbec73460,
    0x0, 0x0, 0xbf666666, 0xbeca91c3,
    0x0, 0x0, 0xbf666666, 0xbecdf3d0,
    0x0, 0x0, 0xbf666666, 0xbed15aa0,
    0x0, 0x0, 0xbf666666, 0xbed4c64f,
    0x0, 0x0, 0xbf666666, 0xbed836f7,
    0x0, 0x0, 0xbf666666, 0xbedbacb6,
    0x0, 0x0, 0xbf666666, 0xbedf27a7,
    0x0, 0x0, 0xbf666666, 0xbee2a7e7,
    0x0, 0x0, 0xbf666666, 0xbee62d94,
    0x0, 0x0, 0xbf666666, 0xbee9b8cd,
    0x0, 0x0, 0xbf666666, 0xbeed49b0,
    0x0, 0x0, 0xbf666666, 0xbef0e05d,
    0x0, 0x0, 0xbf666666, 0xbef47cf3,
    0x0, 0x0, 0xbf666666, 0xbef81f93,
    0x0, 0x0, 0xbf666666, 0xbefbc85f,
    0x0, 0x0, 0xbf666666, 0xbeff7778,
    0x0, 0x0, 0xbf666666, 0xbf019681,
    0x0, 0x0, 0xbf666666, 0xbf037490,
    0x0, 0x0, 0xbf666666, 0xbf0555fa,
    0x0, 0x0, 0xbf666666, 0xbf073ad3,
    0x0, 0x0, 0xbf666666, 0xbf09232d,
    0x0, 0x0, 0xbf666666, 0xbf0b0f1c,
    0x0, 0x0, 0xbf666666, 0xbf0cfeb3,
    0x0, 0x0, 0xbf666666, 0xbf0ef206,
    0x0, 0x0, 0xbf666666, 0xbf10e92a,
    0x0, 0x0, 0xbf666666, 0xbf12e435,
    0x0, 0x0, 0xbf666666, 0xbf14e33a,
    0x0, 0x0, 0xbf666666, 0xbf16e652,
    0x0, 0x0, 0xbf666666, 0xbf18ed92,
    0x0, 0x0, 0xbf666666, 0xbf1af910,
    0x0, 0x0, 0xbf666666, 0xbf1d08e6,
    0x0, 0x0, 0xbf666666, 0xbf1f1d2b,
    0x0, 0x0, 0xbf666666, 0xbf2135f7,
    0x0, 0x0, 0xbf666666, 0xbf235364,
    0x0, 0x0, 0xbf666666, 0xbf25758d,
    0x0, 0x0, 0xbf666666, 0xbf279c8b,
    0x0, 0x0, 0xbf666666, 0xbf29c87a,
    0x0, 0x0, 0xbf666666, 0xbf2bf976,
    0x0, 0x0, 0xbf666666, 0xbf2e2f9b,
    0x0, 0x0, 0xbf666666, 0xbf306b07,
    0x0, 0x0, 0xbf666666, 0xbf32abd9,
    0x0, 0x0, 0xbf666666, 0xbf34f22e,
    0x0, 0x0, 0xbf666666, 0xbf373e27,
    0x0, 0x0, 0xbf666666, 0xbf398fe5,
    0x0, 0x0, 0xbf666666, 0xbf3be788,
    0x0, 0x0, 0xbf666666, 0xbf3e4534,
    0x0, 0x0, 0xbf666666, 0xbf40a90a,
    0x0, 0x0, 0xbf666666, 0xbf431331,
    0x0, 0x0, 0xbf666666, 0xbf4583cc,
    0x0, 0x0, 0xbf666666, 0xbf47fb02,
    0x0, 0x0, 0xbf666666, 0xbf4a78fb,
    0x0, 0x0, 0xbf666666, 0xbf4cfddf,
    0x0, 0x0, 0xbf666666, 0xbf4f89d7,
    0x0, 0x0, 0xbf666666, 0xbf521d0e,
    0x0, 0x0, 0xbf666666, 0xbf54b7b1,
    0x0, 0x0, 0xbf666666, 0xbf5759ec,
    0x0, 0x0, 0xbf666666, 0xbf5a03ef,
    0x0, 0x0, 0xbf666666, 0xbf5cb5e9,
    0x0, 0x0, 0xbf666666, 0xbf5f700b,
    0x0, 0x0, 0xbf666666, 0xbf62328a,
    0x0, 0x0, 0xbf666666, 0xbf64fd98,
    0x0, 0x0, 0xbf666666, 0xbf67d16d,
    0x0, 0x0, 0xbf666666, 0xbf6aae40,
    0x0, 0x0, 0xbf666666, 0xbf6d944b,
    0x0, 0x0, 0xbf666666, 0xbf7083ca,
    0x0, 0x0, 0xbf666666, 0xbf737cf8,
    0x0, 0x0, 0xbf666666, 0xbf768017,
    0x0, 0x0, 0xbf666666, 0xbf798d66,
    0x0, 0x0, 0xbf666666, 0xbf7ca52a,
    0x0, 0x0, 0xbf666666, 0xbf7fc7a7,
    0x0, 0x0, 0xbf666666, 0xbf817a94,
    0x0, 0x0, 0xbf666666, 0xbf8316fa,
    0x0, 0x0, 0xbf666666, 0xbf84b92d,
    0x0, 0x0, 0xbf666666, 0xbf866154,
    0x0, 0x0, 0xbf666666, 0xbf880f99,
    0x0, 0x0, 0xbf666666, 0xbf89c426,
    0x0, 0x0, 0xbf666666, 0xbf8b7f27,
    0x0, 0x0, 0xbf666666, 0xbf8d40ca,
    0x0, 0x0, 0xbf666666, 0xbf8f093f,
    0x0, 0x0, 0xbf666666, 0xbf90d8b5,
    0x0, 0x0, 0xbf666666, 0xbf92af61,
    0x0, 0x0, 0xbf666666, 0xbf948d76,
    0x0, 0x0, 0xbf666666, 0xbf96732c,
    0x0, 0x0, 0xbf666666, 0xbf9860ba,
    0x0, 0x0, 0xbf666666, 0xbf9a565c,
    0x0, 0x0, 0xbf666666, 0xbf9c544f,
    0x0, 0x0, 0xbf666666, 0xbf9e5ad3,
    0x0, 0x0, 0xbf666666, 0xbfa06a28,
    0x0, 0x0, 0xbf666666, 0xbfa28294,
    0x0, 0x0, 0xbf666666, 0xbfa4a45f,
    0x0, 0x0, 0xbf666666, 0xbfa6cfd2,
    0x0, 0x0, 0xbf666666, 0xbfa9053a,
    0x0, 0x0, 0xbf666666, 0xbfab44e8,
    0x0, 0x0, 0xbf666666, 0xbfad8f30,
    0x0, 0x0, 0xbf666666, 0xbfafe468,
    0x0, 0x0, 0xbf666666, 0xbfb244ec,
    0x0, 0x0, 0xbf666666, 0xbfb4b11b,
    0x0, 0x0, 0xbf666666, 0xbfb72958,
    0x0, 0x0, 0xbf666666, 0xbfb9ae0a,
    0x0, 0x0, 0xbf666666, 0xbfbc3f9d,
    0x0, 0x0, 0xbf666666, 0xbfbede82,
    0x0, 0x0, 0xbf666666, 0xbfc18b2f,
    0x0, 0x0, 0xbf666666, 0xbfc44620,
    0x0, 0x0, 0xbf666666, 0xbfc70fd5,
    0x0, 0x0, 0xbf666666, 0xbfc9e8d6,
    0x0, 0x0, 0xbf666666, 0xbfccd1b1,
    0x0, 0x0, 0xbf666666, 0xbfcfcafb,
    0x0, 0x0, 0xbf666666, 0xbfd2d54f,
    0x0, 0x0, 0xbf666666, 0xbfd5f150,
    0x0, 0x0, 0xbf666666, 0xbfd91fac,
    0x0, 0x0, 0xbf666666, 0xbfdc6115,
    0x0, 0x0, 0xbf666666, 0xbfdfb64b,
    0x0, 0x0, 0xbf666666, 0xbfe32016,
    0x0, 0x0, 0xbf666666, 0xbfe69f46,
    0x0, 0x0, 0xbf666666, 0xbfea34bb,
    0x0, 0x0, 0xbf666666, 0xbfede15e,
    0x0, 0x0, 0xbf666666, 0xbff1a625,
    0x0, 0x0, 0xbf666666, 0xbff58415,
    0x0, 0x0, 0xbf666666, 0xbff97c41,
    0x0, 0x0, 0xbf666666, 0xbffd8fcc,
    0x0, 0x0, 0xbf666666, 0xc000dff5,
    0x0, 0x0, 0xbf666666, 0xc00306f0,
    0x0, 0x0, 0xbf666666, 0xc0053d85,
    0x0, 0x0, 0xbf666666, 0xc007846a,
    0x0, 0x0, 0xbf666666, 0xc009dc63,
    0x0, 0x0, 0xbf666666, 0xc00c463f,
    0x0, 0x0, 0xbf666666, 0xc00ec2d9,
    0x0, 0x0, 0xbf666666, 0xc011531d,
    0x0, 0x0, 0xbf666666, 0xc013f804,
    0x0, 0x0, 0xbf666666, 0xc016b29a,
    0x0, 0x0, 0xbf666666, 0xc01983fb,
    0x0, 0x0, 0xbf666666, 0xc01c6d59,
    0x0, 0x0, 0xbf666666, 0xc01f6ffb,
    0x0, 0x0, 0xbf666666, 0xc0228d3d,
    0x0, 0x0, 0xbf666666, 0xc025c699,
    0x0, 0x0, 0xbf666666, 0xc0291da1,
    0x0, 0x0, 0xbf666666, 0xc02c9409,
    0x0, 0x0, 0xbf666666, 0xc0302ba4,
    0x0, 0x0, 0xbf666666, 0xc033e66d,
    0x0, 0x0, 0xbf666666, 0xc037c686,
    0x0, 0x0, 0xbf666666, 0xc03bce3d,
    0x0, 0x0, 0xbf666666, 0xc0400014,
    0x0, 0x0, 0xbf666666, 0xc0445ec4,
    0x0, 0x0, 0xbf666666, 0xc048ed41,
    0x0, 0x0, 0xbf666666, 0xc04daec5,
    0x0, 0x0, 0xbf666666, 0xc052a6d6,
    0x0, 0x0, 0xbf666666, 0xc057d94e,
    0x0, 0x0, 0xbf666666, 0xc05d4a65,
    0x0, 0x0, 0xbf666666, 0xc062fec1,
    0x0, 0x0, 0xbf666666, 0xc068fb7d,
    0x0, 0x0, 0xbf666666, 0xc06f463e,
    0x0, 0x0, 0xbf666666, 0xc075e542,
    0x0, 0x0, 0xbf666666, 0xc07cdf77,
    0x0, 0x0, 0xbf666666, 0xc0821e49,
    0x0, 0x0, 0xbf666666, 0xc0860296,
    0x0, 0x0, 0xbf666666, 0xc08a2173,
    0x0, 0x0, 0xbf666666, 0xc08e8049,
    0x0, 0x0, 0xbf666666, 0xc0932530,
    0x0, 0x0, 0xbf666666, 0xc098170c,
    0x0, 0x0, 0xbf666666, 0xc09d5db0,
    0x0, 0x0, 0xbf666666, 0xc0a3020a,
    0x0, 0x0, 0xbf666666, 0xc0a90e53,
    0x0, 0x0, 0xbf666666, 0xc0af8e4f,
    0x0, 0x0, 0xbf666666, 0xc0b68f9c,
    0x0, 0x0, 0xbf666666, 0xc0be220e,
    0x0, 0x0, 0xbf666666, 0xc0c6582f,
    0x0, 0x0, 0xbf666666, 0xc0cf47d0,
    0x0, 0x0, 0xbf666666, 0xc0d90ad5,
    0x0, 0x0, 0xbf666666, 0xc0e3c02e,
    0x0, 0x0, 0xbf666666, 0xc0ef8d22,
    0x0, 0x0, 0xbf666666, 0xc0fc9f09,
    0x0, 0x0, 0xbf666666, 0xc10596cc,
    0x0, 0x0, 0xbf666666, 0xc10dbf03,
    0x0, 0x0, 0xbf666666, 0xc116f3b2,
    0x0, 0x0, 0xbf666666, 0xc1216c65,
    0x0, 0x0, 0xbf666666, 0xc12d711d,
    0x0, 0x0, 0xbf666666, 0xc13b60e6,
    0x0, 0x0, 0xbf666666, 0xc14bbbdb,
    0x0, 0x0, 0xbf666666, 0xc15f32e3,
    0x0, 0x0, 0xbf666666, 0xc176c163,
    0x0, 0x0, 0xbf666666, 0xc189ec87,
    0x0, 0x0, 0xbf666666, 0xc19c5860,
    0x0, 0x0, 0xbf666666, 0xc1b46e18,
    0x0, 0x0, 0xbf666666, 0xc1d54485,
    0x0, 0x0, 0xbf666666, 0xc20258ba,
    0x0, 0x0, 0xbf666666, 0xc2279af6,
    0x0, 0x0, 0xbf666666, 0xc26aaa44,
    0x0, 0x0, 0xbf666666, 0xc2c39067,
    0x0, 0x0, 0xbf666666, 0xc392ad3f
    };

static const uint32_t ref_cfft_step_1024[2048] = {
    0x43e66666, 0x0, 0xbf666666, 0x4392ad3f,
    0x0, 0x0, 0xbf666666, 0x42c39067,
    0x0, 0x0, 0xbf666666, 0x426aaa44,
    0x0, 0x0, 0xbf666666, 0x42279af6,
    0x0, 0x0, 0xbf666666, 0x420258ba,
    0x0, 0x0, 0xbf666666, 0x41d54485,
    0x0, 0x0, 0xbf666666, 0x41b46e18,
    0x0, 0x0, 0xbf666666, 0x419c5860,
    0x0, 0x0, 0xbf666666, 0x4189ec87,
    0x0, 0x0, 0xbf666666, 0x4176c163,
    0x0, 0x0, 0xbf666666, 0x415f32e3,
    0x0, 0x0, 0xbf666666, 0x414bbbdb,
    0x0, 0x0, 0xbf666666, 0x413b60e6,
    0x0, 0x0, 0xbf666666, 0x412d711d,
    0x0, 0x0, 0xbf666666, 0x41216c65,
    0x0, 0x0, 0xbf666666, 0x4116f3b2,
    0x0, 0x0, 0xbf666666, 0x410dbf03,
    0x0, 0x0, 0xbf666666, 0x410596cc,
    0x0, 0x0, 0xbf666666, 0x40fc9f09,
    0x0, 0x0, 0xbf666666, 0x40ef8d22,
    0x0, 0x0, 0xbf666666, 0x40e3c02e,
    0x0, 0x0, 0xbf666666, 0x40d90ad5,
    0x0, 0x0, 0xbf666666, 0x40cf47d0,
    0x0, 0x0, 0xbf666666, 0x40c6582f,
    0x0, 0x0, 0xbf666666, 0x40be220e,
    0x0, 0x0, 0xbf666666, 0x40b68f9c,
    0x0, 0x0, 0xbf666666, 0x40af8e4f,
    0x0, 0x0, 0xbf666666, 0x40a90e53,
    0x0, 0x0, 0xbf666666, 0x40a3020a,
    0x0, 0x0, 0xbf666666, 0x409d5db0,
    0x0, 0x0, 0xbf666666, 0x4098170c,
    0x0, 0x0, 0xbf666666, 0x40932530,
    0x0, 0x0, 0xbf666666, 0x408e8049,
    0x0, 0x0, 0xbf666666, 0x408a2173,
    0x0, 0x0, 0xbf666666, 0x40860296,
    0x0, 0x0, 0xbf666666, 0x40821e49,
    0x0, 0x0, 0xbf666666, 0x407cdf77,
    0x0, 0x0, 0xbf666666, 0x4075e542,
    0x0, 0x0, 0xbf666666, 0x406f463e,
    0x0, 0x0, 0xbf666666, 0x4068fb7d,
    0x0, 0x0, 0xbf666666, 0x4062fec1,
    0x0, 0x0, 0xbf666666, 0x405d4a65,
    0x0, 0x0, 0xbf666666, 0x4057d94e,
    0x0, 0x0, 0xbf666666, 0x4052a6d6,
    0x0, 0x0, 0xbf666666, 0x404daec5,
    0x0, 0x0, 0xbf666666, 0x4048ed41,
    0x0, 0x0, 0xbf666666, 0x40445ec4,
    0x0, 0x0, 0xbf666666, 0x40400014,
    0x0, 0x0, 0xbf666666, 0x403bce3d,
    0x0, 0x0, 0xbf666666, 0x4037c686,
    0x0, 0x0, 0xbf666666, 0x4033e66d,
    0x0, 0x0, 0xbf666666, 0x40302ba4,
    0x0, 0x0, 0xbf666666, 0x402c9409,
    0x0, 0x0, 0xbf666666, 0x40291da1,
    0x0, 0x0, 0xbf666666, 0x4025c699,
    0x0, 0x0, 0xbf666666, 0x40228d3d,
    0x0, 0x0, 0xbf666666, 0x401f6ffb,
    0x0, 0x0, 0xbf666666, 0x401c6d59,
    0x0, 0x0, 0xbf666666, 0x401983fb,
    0x0, 0x0, 0xbf666666, 0x4016b29a,
    0x0, 0x0, 0xbf666666, 0x4013f804,
    0x0, 0x0, 0xbf666666, 0x4011531d,
    0x0, 0x0, 0xbf666666, 0x400ec2d9,
    0x0, 0x0, 0xbf666666, 0x400c463f,
    0x0, 0x0, 0xbf666666, 0x4009dc63,
    0x0, 0x0, 0xbf666666, 0x4007846a,
    0x0, 0x0, 0xbf666666, 0x40053d85,
    0x0, 0x0, 0xbf666666, 0x400306f0,
    0x0, 0x0, 0xbf666666, 0x4000dff5,
    0x0, 0x0, 0xbf666666, 0x3ffd8fcc,
    0x0, 0x0, 0xbf666666, 0x3ff97c41,
    0x0, 0x0, 0xbf666666, 0x3ff58415,
    0x0, 0x0, 0xbf666666, 0x3ff1a625,
    0x0, 0x0, 0xbf666666, 0x3fede15e,
    0x0, 0x0, 0xbf666666, 0x3fea34bb,
    0x0, 0x0, 0xbf666666, 0x3fe69f46,
    0x0, 0x0, 0xbf666666, 0x3fe32016,
    0x0, 0x0, 0xbf666666, 0x3fdfb64b,
    0x0, 0x0, 0xbf666666, 0x3fdc6115,
    0x0, 0x0, 0xbf666666, 0x3fd91fac,
    0x0, 0x0, 0xbf666666, 0x3fd5f150,
    0x0, 0x0, 0xbf666666, 0x3fd2d54f,
    0x0, 0x0, 0xbf666666, 0x3fcfcafb,
    0x0, 0x0, 0xbf666666, 0x3fccd1b1,
    0x0, 0x0, 0xbf666666, 0x3fc9e8d6,
    0x0, 0x0, 0xbf666666, 0x3fc70fd5,
    0x0, 0x0, 0xbf666666, 0x3fc44620,
    0x0, 0x0, 0xbf666666, 0x3fc18b2f,
    0x0, 0x0, 0xbf666666, 0x3fbede82,
    0x0, 0x0, 0xbf666666, 0x3fbc3f9d,
    0x0, 0x0, 0xbf666666, 0x3fb9ae0a,
    0x0, 0x0, 0xbf666666, 0x3fb72958,
    0x0, 0x0, 0xbf666666, 0x3fb4b11b,
    0x0, 0x0, 0xbf666666, 0x3fb244ec,
    0x0, 0x0, 0xbf666666, 0x3fafe468,
    0x0, 0x0, 0xbf666666, 0x3fad8f30,
    0x0, 0x0, 0xbf666666, 0x3fab44e8,
    0x0, 0x0, 0xbf666666, 0x3fa9053a,
    0x0, 0x0, 0xbf666666, 0x3fa6cfd2,
    0x0, 0x0, 0xbf666666, 0x3fa4a45f,
    0x0, 0x0, 0xbf666666, 0x3fa28294,
    0x0, 0x0, 0xbf666666, 0x3fa06a28,
    0x0, 0x0, 0xbf666666, 0x3f9e5ad3,
    0x0, 0x0, 0xbf666666, 0x3f9c544f,
    0x0, 0x0, 0xbf666666, 0x3f9a565c,
    0x0, 0x0, 0xbf666666, 0x3f9860ba,
    0x0, 0x0, 0xbf666666, 0x3f96732c,
    0x0, 0x0, 0xbf666666, 0x3f948d76,
    0x0, 0x0, 0xbf666666, 0x3f92af61,
    0x0, 0x0, 0xbf666666, 0x3f90d8b5,
    0x0, 0x0, 0xbf666666, 0x3f8f093f,
    0x0, 0x0, 0xbf666666, 0x3f8d40ca,
    0x0, 0x0, 0xbf666666, 0x3f8b7f27,
    0x0, 0x0, 0xbf666666, 0x3f89c426,
    0x0, 0x0, 0xbf666666, 0x3f880f99,
    0x0, 0x0, 0xbf666666, 0x3f866154,
    0x0, 0x0, 0xbf666666, 0x3f84b92d,
    0x0, 0x0, 0xbf666666, 0x3f8316fa,
    0x0, 0x0, 0xbf666666, 0x3f817a94,
    0x0, 0x0, 0xbf666666, 0x3f7fc7a7,
    0x0, 0x0, 0xbf666666, 0x3f7ca52a,
    0x0, 0x0, 0xbf666666, 0x3f798d66,
    0x0, 0x0, 0xbf666666, 0x3f768017,
    0x0, 0x0, 0xbf666666, 0x3f737cf8,
    0x0, 0x0, 0xbf666666, 0x3f7083ca,
    0x0, 0x0, 0xbf666666, 0x3f6d944b,
    0x0, 0x0, 0xbf666666, 0x3f6aae40,
    0x0, 0x0, 0xbf666666, 0x3f67d16d,
    0x0, 0x0, 0xbf666666, 0x3f64fd98,
    0x0, 0x0, 0xbf666666, 0x3f62328a,
    0x0, 0x0, 0xbf666666, 0x3f5f700b,
    0x0, 0x0, 0xbf666666, 0x3f5cb5e9,
    0x0, 0x0, 0xbf666666, 0x3f5a03ef,
    0x0, 0x0, 0xbf666666, 0x3f5759ec,
    0x0, 0x0, 0xbf666666, 0x3f54b7b1,
    0x0, 0x0, 0xbf666666, 0x3f521d0e,
    0x0, 0x0, 0xbf666666, 0x3f4f89d7,
    0x0, 0x0, 0xbf666666, 0x3f4cfddf,
    0x0, 0x0, 0xbf666666, 0x3f4a78fb,
    0x0, 0x0, 0xbf666666, 0x3f47fb02,
    0x0, 0x0, 0xbf666666, 0x3f4583cc,
    0x0, 0x0, 0xbf666666, 0x3f431331,
    0x0, 0x0, 0xbf666666, 0x3f40a90a,
    0x0, 0x0, 0xbf666666, 0x3f3e4534,
    0x0, 0x0, 0xbf666666, 0x3f3be788,
    0x0, 0x0, 0xbf666666, 0x3f398fe5,
    0x0, 0x0, 0xbf666666, 0x3f373e27,
    0x0, 0x0, 0xbf666666, 0x3f34f22e,
    0x0, 0x0, 0xbf666666, 0x3f32abd9,
    0x0, 0x0, 0xbf666666, 0x3f306b07,
    0x0, 0x0, 0xbf666666, 0x3f2e2f9b,
    0x0, 0x0, 0xbf666666, 0x3f2bf976,
    0x0, 0x0, 0xbf666666, 0x3f29c87a,
    0x0, 0x0, 0xbf666666, 0x3f279c8b,
    0x0, 0x0, 0xbf666666, 0x3f25758d,
    0x0, 0x0, 0xbf666666, 0x3f235364,
    0x0, 0x0, 0xbf666666, 0x3f2135f7,
    0x0, 0x0, 0xbf666666, 0x3f1f1d2b,
    0x0, 0x0, 0xbf666666, 0x3f1d08e6,
    0x0, 0x0, 0xbf666666, 0x3f1af910,
    0x0, 0x0, 0xbf666666, 0x3f18ed92,
    0x0, 0x0, 0xbf666666, 0x3f16e652,
    0x0, 0x0, 0xbf666666, 0x3f14e33a,
    0x0, 0x0, 0xbf666666, 0x3f12e435,
    0x0, 0x0, 0xbf666666, 0x3f10e92a,
    0x0, 0x0, 0xbf666666, 0x3f0ef206,
    0x0, 0x0, 0xbf666666, 0x3f0cfeb3,
    0x0, 0x0, 0xbf666666, 0x3f0b0f1c,
    0x0, 0x0, 0xbf666666, 0x3f09232d,
    0x0, 0x0, 0xbf666666, 0x3f073ad3,
    0x0, 0x0, 0xbf666666, 0x3f0555fa,
    0x0, 0x0, 0xbf666666, 0x3f037490,
    0x0, 0x0, 0xbf666666, 0x3f019681,
    0x0, 0x0, 0xbf666666, 0x3eff7778,
    0x0, 0x0, 0xbf666666, 0x3efbc85f,
    0x0, 0x0, 0xbf666666, 0x3ef81f93,
    0x0, 0x0, 0xbf666666, 0x3ef47cf3,
    0x0, 0x0, 0xbf666666, 0x3ef0e05d,
    0x0, 0x0, 0xbf666666, 0x3eed49b0,
    0x0, 0x0, 0xbf666666, 0x3ee9b8cd,
    0x0, 0x0, 0xbf666666, 0x3ee62d94,
    0x0, 0x0, 0xbf666666, 0x3ee2a7e7,
    0x0, 0x0, 0xbf666666, 0x3edf27a7,
    0x0, 0x0, 0xbf666666, 0x3edbacb6,
    0x0, 0x0, 0xbf666666, 0x3ed836f7,
    0x0, 0x0, 0xbf666666, 0x3ed4c64f,
    0x0, 0x0, 0xbf666666, 0x3ed15aa0,
    0x0, 0x0, 0xbf666666, 0x3ecdf3d0,
    0x0, 0x0, 0xbf666666, 0x3eca91c3,
    0x0, 0x0, 0xbf666666, 0x3ec73460,
    0x0, 0x0, 0xbf666666, 0x3ec3db8b,
    0x0, 0x0, 0xbf666666, 0x3ec0872b,
    0x0, 0x0, 0xbf666666, 0x3ebd3727,
    0x0, 0x0, 0xbf666666, 0x3eb9eb66,
    0x0, 0x0, 0xbf666666, 0x3eb6a3d0,
    0x0, 0x0, 0xbf666666, 0x3eb3604d,
    0x0, 0x0, 0xbf666666, 0x3eb020c6,
    0x0, 0x0, 0xbf666666, 0x3eace522,
    0x0, 0x0, 0xbf666666, 0x3ea9ad4c,
    0x0, 0x0, 0xbf666666, 0x3ea6792d,
    0x0, 0x0, 0xbf666666, 0x3ea348ae,
    0x0, 0x0, 0xbf666666, 0x3ea01bbb,
    0x0, 0x0, 0xbf666666, 0x3e9cf23d,
    0x0, 0x0, 0xbf666666, 0x3e99cc20,
    0x0, 0x0, 0xbf666666, 0x3e96a94d,
    0x0, 0x0, 0xbf666666, 0x3e9389b2,
    0x0, 0x0, 0xbf666666, 0x3e906d3a,
    0x0, 0x0, 0xbf666666, 0x3e8d53d1,
    0x0, 0x0, 0xbf666666, 0x3e8a3d62,
    0x0, 0x0, 0xbf666666, 0x3e8729db,
    0x0, 0x0, 0xbf666666, 0x3e841929,
    0x0, 0x0, 0xbf666666, 0x3e810b38,
    0x0, 0x0, 0xbf666666, 0x3e7bffeb,
    0x0, 0x0, 0xbf666666, 0x3e75ee9f,
    0x0, 0x0, 0xbf666666, 0x3e6fe267,
    0x0, 0x0, 0xbf666666, 0x3e69db1f,
    0x0, 0x0, 0xbf666666, 0x3e63d8a3,
    0x0, 0x0, 0xbf666666, 0x3e5ddad1,
    0x0, 0x0, 0xbf666666, 0x3e57e185,
    0x0, 0x0, 0xbf666666, 0x3e51ec9d,
    0x0, 0x0, 0xbf666666, 0x3e4bfbf6,
    0x0, 0x0, 0xbf666666, 0x3e460f70,
    0x0, 0x0, 0xbf666666, 0x3e4026e8,
    0x0, 0x0, 0xbf666666, 0x3e3a423d,
    0x0, 0x0, 0xbf666666, 0x3e34614f,
    0x0, 0x0, 0xbf666666, 0x3e2e83fe,
    0x0, 0x0, 0xbf666666, 0x3e28aa28,
    0x0, 0x0, 0xbf666666, 0x3e22d3af,
    0x0, 0x0, 0xbf666666, 0x3e1d0073,
    0x0, 0x0, 0xbf666666, 0x3e173053,
    0x0, 0x0, 0xbf666666, 0x3e116332,
    0x0, 0x0, 0xbf666666, 0x3e0b98f0,
    0x0, 0x0, 0xbf666666, 0x3e05d16f,
    0x0, 0x0, 0xbf666666, 0x3e000c91,
    0x0, 0x0, 0xbf666666, 0x3df4946c,
    0x0, 0x0, 0xbf666666, 0x3de91483,
    0x0, 0x0, 0xbf666666, 0x3ddd992a,
    0x0, 0x0, 0xbf666666, 0x3dd22227,
    0x0, 0x0, 0xbf666666, 0x3dc6af3e,
    0x0, 0x0, 0xbf666666, 0x3dbb4036,
    0x0, 0x0, 0xbf666666, 0x3dafd4d3,
    0x0, 0x0, 0xbf666666, 0x3da46cdb,
    0x0, 0x0, 0xbf666666, 0x3d990816,
    0x0, 0x0, 0xbf666666, 0x3d8da648,
    0x0, 0x0, 0xbf666666, 0x3d82473a,
    0x0, 0x0, 0xbf666666, 0x3d6dd565,
    0x0, 0x0, 0xbf666666, 0x3d5720ef,
    0x0, 0x0, 0xbf666666, 0x3d4070a3,
    0x0, 0x0, 0xbf666666, 0x3d29c410,
    0x0, 0x0, 0xbf666666, 0x3d131ac3,
    0x0, 0x0, 0xbf666666, 0x3cf8e89d,
    0x0, 0x0, 0xbf666666, 0x3ccba080,
    0x0, 0x0, 0xbf666666, 0x3c9e5c51,
    0x0, 0x0, 0xbf666666, 0x3c623661,
    0x0, 0x0, 0xbf666666, 0x3c07b87c,
    0x0, 0x0, 0xbf666666, 0x3b34f4d0,
    0x0, 0x0, 0xbf666666, 0xbb34f4d0,
    0x0, 0x0, 0xbf666666, 0xbc07b87c,
    0x0, 0x0, 0xbf666666, 0xbc623661,
    0x0, 0x0, 0xbf666666, 0xbc9e5c51,
    0x0, 0x0, 0xbf666666, 0xbccba080,
    0x0, 0x0, 0xbf666666, 0xbcf8e89d,
    0x0, 0x0, 0xbf666666, 0xbd131ac3,
    0x0, 0x0, 0xbf666666, 0xbd29c410,
    0x0, 0x0, 0xbf666666, 0xbd4070a3,
    0x0, 0x0, 0xbf666666, 0xbd5720ef,
    0x0, 0x0, 0xbf666666, 0xbd6dd565,
    0x0, 0x0, 0xbf666666, 0xbd82473a,
    0x0, 0x0, 0xbf666666, 0xbd8da648,
    0x0, 0x0, 0xbf666666, 0xbd990816,
    0x0, 0x0, 0xbf666666, 0xbda46cdb,
    0x0, 0x0, 0xbf666666, 0xbdafd4d3,
    0x0, 0x0, 0xbf666666, 0xbdbb4036,
    0x0, 0x0, 0xbf666666, 0xbdc6af3e,
    0x0, 0x0, 0xbf666666, 0xbdd22227,
    0x0, 0x0, 0xbf666666, 0xbddd992a,
    0x0, 0x0, 0xbf666666, 0xbde91483,
    0x0, 0x0, 0xbf666666, 0xbdf4946c,
    0x0, 0x0, 0xbf666666, 0xbe000c91,
    0x0, 0x0, 0xbf666666, 0xbe05d16f,
    0x0, 0x0, 0xbf666666, 0xbe0b98f0,
    0x0, 0x0, 0xbf666666, 0xbe116332,
    0x0, 0x0, 0xbf666666, 0xbe173053,
    0x0, 0x0, 0xbf666666, 0xbe1d0073,
    0x0, 0x0, 0xbf666666, 0xbe22d3af,
    0x0, 0x0, 0xbf666666, 0xbe28aa28,
    0x0, 0x0, 0xbf666666, 0xbe2e83fe,
    0x0, 0x0, 0xbf666666, 0xbe34614f,
    0x0, 0x0, 0xbf666666, 0xbe3a423d,
    0x0, 0x0, 0xbf666666, 0xbe4026e8,
    0x0, 0x0, 0xbf666666, 0xbe460f70,
    0x0, 0x0, 0xbf666666, 0xbe4bfbf6,
    0x0, 0x0, 0xbf666666, 0xbe51ec9d,
    0x0, 0x0, 0xbf666666, 0xbe57e185,
    0x0, 0x0, 0xbf666666, 0xbe5ddad1,
    0x0, 0x0, 0xbf666666, 0xbe63d8a3,
    0x0, 0x0, 0xbf666666, 0xbe69db1f,
    0x0, 0x0, 0xbf666666, 0xbe6fe267,
    0x0, 0x0, 0xbf666666, 0xbe75ee9f,
    0x0, 0x0, 0xbf666666, 0xbe7bffeb,
    0x0, 0x0, 0xbf666666, 0xbe810b38,
    0x0, 0x0, 0xbf666666, 0xbe841929,
    0x0, 0x0, 0xbf666666, 0xbe8729db,
    0x0, 0x0, 0xbf666666, 0xbe8a3d62,
    0x0, 0x0, 0xbf666666, 0xbe8d53d1,
    0x0, 0x0, 0xbf666666, 0xbe906d3a,
    0x0, 0x0, 0xbf666666, 0xbe9389b2,
    0x0, 0x0, 0xbf666666, 0xbe96a94d,
    0x0, 0x0, 0xbf666666, 0xbe99cc20,
    0x0, 0x0, 0xbf666666, 0xbe9cf23d,
    0x0, 0x0, 0xbf666666, 0xbea01bbb,
    0x0, 0x0, 0xbf666666, 0xbea348ae,
    0x0, 0x0, 0xbf666666, 0xbea6792d,
    0x0, 0x0, 0xbf666666, 0xbea9ad4c,
    0x0, 0x0, 0xbf666666, 0xbeace522,
    0x0, 0x0, 0xbf666666, 0xbeb020c6,
    0x0, 0x0, 0xbf666666, 0xbeb3604d,
    0x0, 0x0, 0xbf666666, 0xbeb6a3d0,
    0x0, 0x0, 0xbf666666, 0xbeb9eb66,
    0x0, 0x0, 0xbf666666, 0xbebd3727,
    0x0, 0x0, 0xbf666666, 0xbec0872b,
    0x0, 0x0, 0xbf666666, 0xbec3db8b,
    0x0, 0x0, 0xbf666666, 0xbec73460,
    0x0, 0x0, 0xbf666666, 0xbeca91c3,
    0x0, 0x0, 0xbf666666, 0xbecdf3d0,
    0x0, 0x0, 0xbf666666, 0xbed15aa0,
    0x0, 0x0, 0xbf666666, 0xbed4c64f,
    0x0, 0x0, 0xbf666666, 0xbed836f7,
    0x0, 0x0, 0xbf666666, 0xbedbacb6,
    0x0, 0x0, 0xbf666666, 0xbedf27a7,
    0x0, 0x0, 0xbf666666, 0xbee2a7e7,
    0x0, 0x0, 0xbf666666, 0xbee62d94,
    0x0, 0x0, 0xbf666666, 0xbee9b8cd,
    0x0, 0x0, 0xbf666666, 0xbeed49b0,
    0x0, 0x0, 0xbf666666, 0xbef0e05d,
    0x0, 0x0, 0xbf666666, 0xbef47cf3,
    0x0, 0x0, 0xbf666666, 0xbef81f93,
    0x0, 0x0, 0xbf666666, 0xbefbc85f,
    0x0, 0x0, 0xbf666666, 0xbeff7778,
    0x0, 0x0, 0xbf666666, 0xbf019681,
    0x0, 0x0, 0xbf666666, 0xbf037490,
    0x0, 0x0, 0xbf666666, 0xbf0555fa,
    0x0, 0x0, 0xbf666666, 0xbf073ad3,
    0x0, 0x0, 0xbf666666, 0xbf09232d,
    0x0, 0x0, 0xbf666666, 0xbf0b0f1c,
    0x0, 0x0, 0xbf666666, 0xbf0cfeb3,
    0x0, 0x0, 0xbf666666, 0xbf0ef206,
    0x0, 0x0, 0xbf666666, 0xbf10e92a,
    0x0, 0x0, 0xbf666666, 0xbf12e435,
    0x0, 0x0, 0xbf666666, 0xbf14e33a,
    0x0, 0x0, 0xbf666666, 0xbf16e652,
    0x0, 0x0, 0xbf666666, 0xbf18ed92,
    0x0, 0x0, 0xbf666666, 0xbf1af910,
    0x0, 0x0, 0xbf666666, 0xbf1d08e6,
    0x0, 0x0, 0xbf666666, 0xbf1f1d2b,
    0x0, 0x0, 0xbf666666, 0xbf2135f7,
    0x0, 0x0, 0xbf666666, 0xbf235364,
    0x0, 0x0, 0xbf666666, 0xbf25758d,
    0x0, 0x0, 0xbf666666, 0xbf279c8b,
    0x0, 0x0, 0xbf666666, 0xbf29c87a,
    0x0, 0x0, 0xbf666666, 0xbf2bf976,
    0x0, 0x0, 0xbf666666, 0xbf2e2f9b,
    0x0, 0x0, 0xbf666666, 0xbf306b07,
    0x0, 0x0, 0xbf666666, 0xbf32abd9,
    0x0, 0x0, 0xbf666666, 0xbf34f22e,
    0x0, 0x0, 0xbf666666, 0xbf373e27,
    0x0, 0x0, 0xbf666666, 0xbf398fe5,
    0x0, 0x0, 0xbf666666, 0xbf3be788,
    0x0, 0x0, 0xbf666666, 0xbf3e4534,
    0x0, 0x0, 0xbf666666, 0xbf40a90a,
    0x0, 0x0, 0xbf666666, 0xbf431331,
    0x0, 0x0, 0xbf666666, 0xbf4583cc,
    0x0, 0x0, 0xbf666666, 0xbf47fb02,
    0x0, 0x0, 0xbf666666, 0xbf4a78fb,
    0x0, 0x0, 0xbf666666, 0xbf4cfddf,
    0x0, 0x0, 0xbf666666, 0xbf4f89d7,
    0x0, 0x0, 0xbf666666, 0xbf521d0e,
    0x0, 0x0, 0xbf666666, 0xbf54b7b1,
    0x0, 0x0, 0xbf666666, 0xbf5759ec,
    0x0, 0x0, 0xbf666666, 0xbf5a03ef,
    0x0, 0x0, 0xbf666666, 0xbf5cb5e9,
    0x0, 0x0, 0xbf666666, 0xbf5f700b,
    0x0, 0x0, 0xbf666666, 0xbf62328a,
    0x0, 0x0, 0xbf666666, 0xbf64fd98,
    0x0, 0x0, 0xbf666666, 0xbf67d16d,
    0x0, 0x0, 0xbf666666, 0xbf6aae40,
    0x0, 0x0, 0xbf666666, 0xbf6d944b,
    0x0, 0x0, 0xbf666666, 0xbf7083ca,
    0x0, 0x0, 0xbf666666, 0xbf737cf8,
    0x0, 0x0, 0xbf666666, 0xbf768017,
    0x0, 0x0, 0xbf666666, 0xbf798d66,
    0x0, 0x0, 0xbf666666, 0xbf7ca52a,
    0x0, 0x0, 0xbf666666, 0xbf7fc7a7,
    0x0, 0x0, 0xbf666666, 0xbf817a94,
    0x0, 0x0, 0xbf666666, 0xbf8316fa,
    0x0, 0x0, 0xbf666666, 0xbf84b92d,
    0x0, 0x0, 0xbf666666, 0xbf866154,
    0x0, 0x0, 0xbf666666, 0xbf880f99,
    0x0, 0x0, 0xbf666666, 0xbf89c426,
    0x0, 0x0, 0xbf666666, 0xbf8b7f27,
    0x0, 0x0, 0xbf666666, 0xbf8d40ca,
    0x0, 0x0, 0xbf666666, 0xbf8f093f,
    0x0, 0x0, 0xbf666666, 0xbf90d8b5,
    0x0, 0x0, 0xbf666666, 0xbf92af61,
    0x0, 0x0, 0xbf666666, 0xbf948d76,
    0x0, 0x0, 0xbf666666, 0xbf96732c,
    0x0, 0x0, 0xbf666666, 0xbf9860ba,
    0x0, 0x0, 0xbf666666, 0xbf9a565c,
    0x0, 0x0, 0xbf666666, 0xbf9c544f,
    0x0, 0x0, 0xbf666666, 0xbf9e5ad3,
    0x0, 0x0, 0xbf666666, 0xbfa06a28,
    0x0, 0x0, 0xbf666666, 0xbfa28294,
    0x0, 0x0, 0xbf666666, 0xbfa4a45f,
    0x0, 0x0, 0xbf666666, 0xbfa6cfd2,
    0x0, 0x0, 0xbf666666, 0xbfa9053a,
    0x0, 0x0, 0xbf666666, 0xbfab44e8,
    0x0, 0x0, 0xbf666666, 0xbfad8f30,
    0x0, 0x0, 0xbf666666, 0xbfafe468,
    0x0, 0x0, 0xbf666666, 0xbfb244ec,
    0x0, 0x0, 0xbf666666, 0xbfb4b11b,
    0x0, 0x0, 0xbf666666, 0xbfb72958,
    0x0, 0x0, 0xbf666666, 0xbfb9ae0a,
    0x0, 0x0, 0xbf666666, 0xbfbc3f9d,
    0x0, 0x0, 0xbf666666, 0xbfbede82,
    0x0, 0x0, 0xbf666666, 0xbfc18b2f,
    0x0, 0x0, 0xbf666666, 0xbfc44620,
    0x0, 0x0, 0xbf666666, 0xbfc70fd5,
    0x0, 0x0, 0xbf666666, 0xbfc9e8d6,
    0x0, 0x0, 0xbf666666, 0xbfccd1b1,
    0x0, 0x0, 0xbf666666, 0xbfcfcafb,
    0x0, 0x0, 0xbf666666, 0xbfd2d54f,
    0x0, 0x0, 0xbf666666, 0xbfd5f150,
    0x0, 0x0, 0xbf666666, 0xbfd91fac,
    0x0, 0x0, 0xbf666666, 0xbfdc6115,
    0x0, 0x0, 0xbf666666, 0xbfdfb64b,
    0x0, 0x0, 0xbf666666, 0xbfe32016,
    0x0, 0x0, 0xbf666666, 0xbfe69f46,
    0x0, 0x0, 0xbf666666, 0xbfea34bb,
    0x0, 0x0, 0xbf666666, 0xbfede15e,
    0x0, 0x0, 0xbf666666, 0xbff1a625,
    0x0, 0x0, 0xbf666666, 0xbff58415,
    0x0, 0x0, 0xbf666666, 0xbff97c41,
    0x0, 0x0, 0xbf666666, 0xbffd8fcc,
    0x0, 0x0, 0xbf666666, 0xc000dff5,
    0x0, 0x0, 0xbf666666, 0xc00306f0,
    0x0, 0x0, 0xbf666666, 0xc0053d85,
    0x0, 0x0, 0xbf666666, 0xc007846a,
    0x0, 0x0, 0xbf666666, 0xc009dc63,
    0x0, 0x0, 0xbf666666, 0xc00c463f,
    0x0, 0x0, 0xbf666666, 0xc00ec2d9,
    0x0, 0x0, 0xbf666666, 0xc011531d,
    0x0, 0x0, 0xbf666666, 0xc013f804,
    0x0, 0x0, 0xbf666666, 0xc016b29a,
    0x0, 0x0, 0xbf666666, 0xc01983fb,
    0x0, 0x0, 0xbf666666, 0xc01c6d59,
    0x0, 0x0, 0xbf666666, 0xc01f6ffb,
    0x0, 0x0, 0xbf666666, 0xc0228d3d,
    0x0, 0x0, 0xbf666666, 0xc025c699,
    0x0, 0x0, 0xbf666666, 0xc0291da1,
    0x0, 0x0, 0xbf666666, 0xc02c9409,
    0x0, 0x0, 0xbf666666, 0xc0302ba4,
    0x0, 0x0, 0xbf666666, 0xc033e66d,
    0x0, 0x0, 0xbf666666, 0xc037c686,
    0x0, 0x0, 0xbf666666, 0xc03bce3d,
    0x0, 0x0, 0xbf666666, 0xc0400014,
    0x0, 0x0, 0xbf666666, 0xc0445ec4,
    0x0, 0x0, 0xbf666666, 0xc048ed41,
    0x0, 0x0, 0xbf666666, 0xc04daec5,
    0x0, 0x0, 0xbf666666, 0xc052a6d6,
    0x0, 0x0, 0xbf666666, 0xc057d94e,
    0x0, 0x0, 0xbf666666, 0xc05d4a65,
    0x0, 0x0, 0xbf666666, 0xc062fec1,
    0x0, 0x0, 0xbf666666, 0xc068fb7d,
    0x0, 0x0, 0xbf666666, 0xc06f463e,
    0x0, 0x0, 0xbf666666, 0xc075e542,
    0x0, 0x0, 0xbf666666, 0xc07cdf77,
    0x0, 0x0, 0xbf666666, 0xc0821e49,
    0x0, 0x0, 0xbf666666, 0xc0860296,
    0x0, 0x0, 0xbf666666, 0xc08a2173,
    0x0, 0x0, 0xbf666666, 0xc08e8049,
    0x0, 0x0, 0xbf666666, 0xc0932530,
    0x0, 0x0, 0xbf666666, 0xc098170c,
    0x0, 0x0, 0xbf666666, 0xc09d5db0,
    0x0, 0x0, 0xbf666666, 0xc0a3020a,
    0x0, 0x0, 0xbf666666, 0xc0a90e53,
    0x0, 0x0, 0xbf666666, 0xc0af8e4f,
    0x0, 0x0, 0xbf666666, 0xc0b68f9c,
    0x0, 0x0, 0xbf666666, 0xc0be220e,
    0x0, 0x0, 0xbf666666, 0xc0c6582f,
    0x0, 0x0, 0xbf666666, 0xc0cf47d0,
    0x0, 0x0, 0xbf666666, 0xc0d90ad5,
    0x0, 0x0, 0xbf666666, 0xc0e3c02e,
    0x0, 0x0, 0xbf666666, 0xc0ef8d22,
    0x0, 0x0, 0xbf666666, 0xc0fc9f09,
    0x0, 0x0, 0xbf666666, 0xc10596cc,
    0x0, 0x0, 0xbf666666, 0xc10dbf03,
    0x0, 0x0, 0xbf666666, 0xc116f3b2,
    0x0, 0x0, 0xbf666666, 0xc1216c65,
    0x0, 0x0, 0xbf666666, 0xc12d711d,
    0x0, 0x0, 0xbf666666, 0xc13b60e6,
    0x0, 0x0, 0xbf666666, 0xc14bbbdb,
    0x0, 0x0, 0xbf666666, 0xc15f32e3,
    0x0, 0x0, 0xbf666666, 0xc176c163,
    0x0, 0x0, 0xbf666666, 0xc189ec87,
    0x0, 0x0, 0xbf666666, 0xc19c5860,
    0x0, 0x0, 0xbf666666, 0xc1b46e18,
    0x0, 0x0, 0xbf666666, 0xc1d54485,
    0x0, 0x0, 0xbf666666, 0xc20258ba,
    0x0, 0x0, 0xbf666666, 0xc2279af6,
    0x0, 0x0, 0xbf666666, 0xc26aaa44,
    0x0, 0x0, 0xbf666666, 0xc2c39067,
    0x0, 0x0, 0xbf666666, 0xc392ad3f
    };

static const uint32_t in_cfft_step_2048[4096] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_2048[4096] = {
    0x44666666, 0x0, 0xbf666666, 0x4412ad55,
    0x0, 0x0, 0xbf666666, 0x43439176,
    0x0, 0x0, 0xbf666666, 0x42eaadcd,
    0x0, 0x0, 0xbf666666, 0x42a79fe8,
    0x0, 0x0, 0xbf666666, 0x42825f17,
    0x0, 0x0, 0xbf666666, 0x42555412,
    0x0, 0x0, 0xbf666666, 0x42348079,
    0x0, 0x0, 0xbf666666, 0x421c6d96,
    0x0, 0x0, 0xbf666666, 0x420a0491,
    0x0, 0x0, 0xbf666666, 0x41f6f71f,
    0x0, 0x0, 0xbf666666, 0x41df6e48,
    0x0, 0x0, 0xbf666666, 0x41cbfce9,
    0x0, 0x0, 0xbf666666, 0x41bba79f,
    0x0, 0x0, 0xbf666666, 0x41adbd7f,
    0x0, 0x0, 0xbf666666, 0x41a1be72,
    0x0, 0x0, 0xbf666666, 0x41974b69,
    0x0, 0x0, 0xbf666666, 0x418e1c65,
    0x0, 0x0, 0xbf666666, 0x4185f9da,
    0x0, 0x0, 0xbf666666, 0x417d707d,
    0x0, 0x0, 0xbf666666, 0x417069ef,
    0x0, 0x0, 0xbf666666, 0x4164a856,
    0x0, 0x0, 0xbf666666, 0x4159fe59,
    0x0, 0x0, 0xbf666666, 0x415046b0,
    0x0, 0x0, 0xbf666666, 0x4147626c,
    0x0, 0x0, 0xbf666666, 0x413f37ab,
    0x0, 0x0, 0xbf666666, 0x4137b099,
    0x0, 0x0, 0xbf666666, 0x4130baae,
    0x0, 0x0, 0xbf666666, 0x412a4615,
    0x0, 0x0, 0xbf666666, 0x41244531,
    0x0, 0x0, 0xbf666666, 0x411eac3d,
    0x0, 0x0, 0xbf666666, 0x41197101,
    0x0, 0x0, 0xbf666666, 0x41148a8f,
    0x0, 0x0, 0xbf666666, 0x410ff113,
    0x0, 0x0, 0xbf666666, 0x410b9dab,
    0x0, 0x0, 0xbf666666, 0x41078a3c,
    0x0, 0x0, 0xbf666666, 0x4103b160,
    0x0, 0x0, 0xbf666666, 0x41000e46,
    0x0, 0x0, 0xbf666666, 0x40f93940,
    0x0, 0x0, 0xbf666666, 0x40f2b12a,
    0x0, 0x0, 0xbf666666, 0x40ec7d5c,
    0x0, 0x0, 0xbf666666, 0x40e69796,
    0x0, 0x0, 0xbf666666, 0x40e0fa35,
    0x0, 0x0, 0xbf666666, 0x40dba01e,
    0x0, 0x0, 0xbf666666, 0x40d684ab,
    0x0, 0x0, 0xbf666666, 0x40d1a3a3,
    0x0, 0x0, 0xbf666666, 0x40ccf92d,
    0x0, 0x0, 0xbf666666, 0x40c881c4,
    0x0, 0x0, 0xbf666666, 0x40c43a2d,
    0x0, 0x0, 0xbf666666, 0x40c01f74,
    0x0, 0x0, 0xbf666666, 0x40bc2ee0,
    0x0, 0x0, 0xbf666666, 0x40b865f0,
    0x0, 0x0, 0xbf666666, 0x40b4c256,
    0x0, 0x0, 0xbf666666, 0x40b141ef,
    0x0, 0x0, 0xbf666666, 0x40ade2c2,
    0x0, 0x0, 0xbf666666, 0x40aaa2fa,
    0x0, 0x0, 0xbf666666, 0x40a780e5,
    0x0, 0x0, 0xbf666666, 0x40a47aef,
    0x0, 0x0, 0xbf666666, 0x40a18fa1,
    0x0, 0x0, 0xbf666666, 0x409ebd9d,
    0x0, 0x0, 0xbf666666, 0x409c039c,
    0x0, 0x0, 0xbf666666, 0x4099606e,
    0x0, 0x0, 0xbf666666, 0x4096d2f5,
    0x0, 0x0, 0xbf666666, 0x40945a26,
    0x0, 0x0, 0xbf666666, 0x4091f508,
    0x0, 0x0, 0xbf666666, 0x408fa2b0,
    0x0, 0x0, 0xbf666666, 0x408d6243,
    0x0, 0x0, 0xbf666666, 0x408b32f0,
    0x0, 0x0, 0xbf666666, 0x408913f6,
    0x0, 0x0, 0xbf666666, 0x4087049c,
    0x0, 0x0, 0xbf666666, 0x40850438,
    0x0, 0x0, 0xbf666666, 0x40831224,
    0x0, 0x0, 0xbf666666, 0x40812dc8,
    0x0, 0x0, 0xbf666666, 0x407ead26,
    0x0, 0x0, 0xbf666666, 0x407b17f5,
    0x0, 0x0, 0xbf666666, 0x40779af9,
    0x0, 0x0, 0xbf666666, 0x4074353d,
    0x0, 0x0, 0xbf666666, 0x4070e5d7,
    0x0, 0x0, 0xbf666666, 0x406dabe9,
    0x0, 0x0, 0xbf666666, 0x406a86a1,
    0x0, 0x0, 0xbf666666, 0x40677539,
    0x0, 0x0, 0xbf666666, 0x406476f1,
    0x0, 0x0, 0xbf666666, 0x40618b16,
    0x0, 0x0, 0xbf666666, 0x405eb0fd,
    0x0, 0x0, 0xbf666666, 0x405be801,
    0x0, 0x0, 0xbf666666, 0x40592f88,
    0x0, 0x0, 0xbf666666, 0x405686fd,
    0x0, 0x0, 0xbf666666, 0x4053edd2,
    0x0, 0x0, 0xbf666666, 0x40516380,
    0x0, 0x0, 0xbf666666, 0x404ee787,
    0x0, 0x0, 0xbf666666, 0x404c796b,
    0x0, 0x0, 0xbf666666, 0x404a18b7,
    0x0, 0x0, 0xbf666666, 0x4047c4fa,
    0x0, 0x0, 0xbf666666, 0x40457dc9,
    0x0, 0x0, 0xbf666666, 0x404342bb,
    0x0, 0x0, 0xbf666666, 0x4041136f,
    0x0, 0x0, 0xbf666666, 0x403eef86,
    0x0, 0x0, 0xbf666666, 0x403cd6a6,
    0x0, 0x0, 0xbf666666, 0x403ac876,
    0x0, 0x0, 0xbf666666, 0x4038c4a5,
    0x0, 0x0, 0xbf666666, 0x4036cae1,
    0x0, 0x0, 0xbf666666, 0x4034dade,
    0x0, 0x0, 0xbf666666, 0x4032f452,
    0x0, 0x0, 0xbf666666, 0x403116f6,
    0x0, 0x0, 0xbf666666, 0x402f4286,
    0x0, 0x0, 0xbf666666, 0x402d76c0,
    0x0, 0x0, 0xbf666666, 0x402bb365,
    0x0, 0x0, 0xbf666666, 0x4029f838,
    0x0, 0x0, 0xbf666666, 0x40284500,
    0x0, 0x0, 0xbf666666, 0x40269982,
    0x0, 0x0, 0xbf666666, 0x4024f58a,
    0x0, 0x0, 0xbf666666, 0x402358e2,
    0x0, 0x0, 0xbf666666, 0x4021c359,
    0x0, 0x0, 0xbf666666, 0x402034be,
    0x0, 0x0, 0xbf666666, 0x401eace1,
    0x0, 0x0, 0xbf666666, 0x401d2b96,
    0x0, 0x0, 0xbf666666, 0x401bb0b1,
    0x0, 0x0, 0xbf666666, 0x401a3c07,
    0x0, 0x0, 0xbf666666, 0x4018cd70,
    0x0, 0x0, 0xbf666666, 0x401764c4,
    0x0, 0x0, 0xbf666666, 0x401601dd,
    0x0, 0x0, 0xbf666666, 0x4014a496,
    0x0, 0x0, 0xbf666666, 0x40134ccd,
    0x0, 0x0, 0xbf666666, 0x4011fa5d,
    0x0, 0x0, 0xbf666666, 0x4010ad26,
    0x0, 0x0, 0xbf666666, 0x400f6508,
    0x0, 0x0, 0xbf666666, 0x400e21e4,
    0x0, 0x0, 0xbf666666, 0x400ce39a,
    0x0, 0x0, 0xbf666666, 0x400baa0f,
    0x0, 0x0, 0xbf666666, 0x400a7524,
    0x0, 0x0, 0xbf666666, 0x400944c0,
    0x0, 0x0, 0xbf666666, 0x400818c7,
    0x0, 0x0, 0xbf666666, 0x4006f11f,
    0x0, 0x0, 0xbf666666, 0x4005cdaf,
    0x0, 0x0, 0xbf666666, 0x4004ae5f,
    0x0, 0x0, 0xbf666666, 0x40039318,
    0x0, 0x0, 0xbf666666, 0x40027bc2,
    0x0, 0x0, 0xbf666666, 0x40016847,
    0x0, 0x0, 0xbf666666, 0x40005892,
    0x0, 0x0, 0xbf666666, 0x3ffe9919,
    0x0, 0x0, 0xbf666666, 0x3ffc8848,
    0x0, 0x0, 0xbf666666, 0x3ffa7e87,
    0x0, 0x0, 0xbf666666, 0x3ff87bb1,
    0x0, 0x0, 0xbf666666, 0x3ff67fa0,
    0x0, 0x0, 0xbf666666, 0x3ff48a2f,
    0x0, 0x0, 0xbf666666, 0x3ff29b3b,
    0x0, 0x0, 0xbf666666, 0x3ff0b2a2,
    0x0, 0x0, 0xbf666666, 0x3feed042,
    0x0, 0x0, 0xbf666666, 0x3fecf3fc,
    0x0, 0x0, 0xbf666666, 0x3feb1dae,
    0x0, 0x0, 0xbf666666, 0x3fe94d3b,
    0x0, 0x0, 0xbf666666, 0x3fe78284,
    0x0, 0x0, 0xbf666666, 0x3fe5bd6d,
    0x0, 0x0, 0xbf666666, 0x3fe3fdd8,
    0x0, 0x0, 0xbf666666, 0x3fe243aa,
    0x0, 0x0, 0xbf666666, 0x3fe08ec8,
    0x0, 0x0, 0xbf666666, 0x3fdedf18,
    0x0, 0x0, 0xbf666666, 0x3fdd3480,
    0x0, 0x0, 0xbf666666, 0x3fdb8ee7,
    0x0, 0x0, 0xbf666666, 0x3fd9ee35,
    0x0, 0x0, 0xbf666666, 0x3fd85253,
    0x0, 0x0, 0xbf666666, 0x3fd6bb28,
    0x0, 0x0, 0xbf666666, 0x3fd5289e,
    0x0, 0x0, 0xbf666666, 0x3fd39aa0,
    0x0, 0x0, 0xbf666666, 0x3fd21118,
    0x0, 0x0, 0xbf666666, 0x3fd08bf1,
    0x0, 0x0, 0xbf666666, 0x3fcf0b16,
    0x0, 0x0, 0xbf666666, 0x3fcd8e73,
    0x0, 0x0, 0xbf666666, 0x3fcc15f6,
    0x0, 0x0, 0xbf666666, 0x3fcaa18b,
    0x0, 0x0, 0xbf666666, 0x3fc9311f,
    0x0, 0x0, 0xbf666666, 0x3fc7c4a1,
    0x0, 0x0, 0xbf666666, 0x3fc65bfe,
    0x0, 0x0, 0xbf666666, 0x3fc4f726,
    0x0, 0x0, 0xbf666666, 0x3fc39607,
    0x0, 0x0, 0xbf666666, 0x3fc23890,
    0x0, 0x0, 0xbf666666, 0x3fc0deb3,
    0x0, 0x0, 0xbf666666, 0x3fbf885e,
    0x0, 0x0, 0xbf666666, 0x3fbe3583,
    0x0, 0x0, 0xbf666666, 0x3fbce612,
    0x0, 0x0, 0xbf666666, 0x3fbb99fd,
    0x0, 0x0, 0xbf666666, 0x3fba5135,
    0x0, 0x0, 0xbf666666, 0x3fb90bad,
    0x0, 0x0, 0xbf666666, 0x3fb7c956,
    0x0, 0x0, 0xbf666666, 0x3fb68a22,
    0x0, 0x0, 0xbf666666, 0x3fb54e05,
    0x0, 0x0, 0xbf666666, 0x3fb414f2,
    0x0, 0x0, 0xbf666666, 0x3fb2dedc,
    0x0, 0x0, 0xbf666666, 0x3fb1abb7,
    0x0, 0x0, 0xbf666666, 0x3fb07b76,
    0x0, 0x0, 0xbf666666, 0x3faf4e0e,
    0x0, 0x0, 0xbf666666, 0x3fae2374,
    0x0, 0x0, 0xbf666666, 0x3facfb9b,
    0x0, 0x0, 0xbf666666, 0x3fabd678,
    0x0, 0x0, 0xbf666666, 0x3faab401,
    0x0, 0x0, 0xbf666666, 0x3fa9942c,
    0x0, 0x0, 0xbf666666, 0x3fa876ec,
    0x0, 0x0, 0xbf666666, 0x3fa75c3a,
    0x0, 0x0, 0xbf666666, 0x3fa64409,
    0x0, 0x0, 0xbf666666, 0x3fa52e51,
    0x0, 0x0, 0xbf666666, 0x3fa41b07,
    0x0, 0x0, 0xbf666666, 0x3fa30a23,
    0x0, 0x0, 0xbf666666, 0x3fa1fb9b,
    0x0, 0x0, 0xbf666666, 0x3fa0ef66,
    0x0, 0x0, 0xbf666666, 0x3f9fe57b,
    0x0, 0x0, 0xbf666666, 0x3f9eddd2,
    0x0, 0x0, 0xbf666666, 0x3f9dd861,
    0x0, 0x0, 0xbf666666, 0x3f9cd520,
    0x0, 0x0, 0xbf666666, 0x3f9bd407,
    0x0, 0x0, 0xbf666666, 0x3f9ad50f,
    0x0, 0x0, 0xbf666666, 0x3f99d82f,
    0x0, 0x0, 0xbf666666, 0x3f98dd5e,
    0x0, 0x0, 0xbf666666, 0x3f97e497,
    0x0, 0x0, 0xbf666666, 0x3f96edd1,
    0x0, 0x0, 0xbf666666, 0x3f95f904,
    0x0, 0x0, 0xbf666666, 0x3f95062a,
    0x0, 0x0, 0xbf666666, 0x3f94153c,
    0x0, 0x0, 0xbf666666, 0x3f932632,
    0x0, 0x0, 0xbf666666, 0x3f923906,
    0x0, 0x0, 0xbf666666, 0x3f914db1,
    0x0, 0x0, 0xbf666666, 0x3f90642d,
    0x0, 0x0, 0xbf666666, 0x3f8f7c72,
    0x0, 0x0, 0xbf666666, 0x3f8e967b,
    0x0, 0x0, 0xbf666666, 0x3f8db242,
    0x0, 0x0, 0xbf666666, 0x3f8ccfc0,
    0x0, 0x0, 0xbf666666, 0x3f8beeef,
    0x0, 0x0, 0xbf666666, 0x3f8b0fc9,
    0x0, 0x0, 0xbf666666, 0x3f8a3249,
    0x0, 0x0, 0xbf666666, 0x3f895669,
    0x0, 0x0, 0xbf666666, 0x3f887c24,
    0x0, 0x0, 0xbf666666, 0x3f87a372,
    0x0, 0x0, 0xbf666666, 0x3f86cc51,
    0x0, 0x0, 0xbf666666, 0x3f85f6b9,
    0x0, 0x0, 0xbf666666, 0x3f8522a6,
    0x0, 0x0, 0xbf666666, 0x3f845013,
    0x0, 0x0, 0xbf666666, 0x3f837efa,
    0x0, 0x0, 0xbf666666, 0x3f82af57,
    0x0, 0x0, 0xbf666666, 0x3f81e124,
    0x0, 0x0, 0xbf666666, 0x3f81145e,
    0x0, 0x0, 0xbf666666, 0x3f8048fe,
    0x0, 0x0, 0xbf666666, 0x3f7efe03,
    0x0, 0x0, 0xbf666666, 0x3f7d6cc5,
    0x0, 0x0, 0xbf666666, 0x3f7bde3a,
    0x0, 0x0, 0xbf666666, 0x3f7a5259,
    0x0, 0x0, 0xbf666666, 0x3f78c91a,
    0x0, 0x0, 0xbf666666, 0x3f774273,
    0x0, 0x0, 0xbf666666, 0x3f75be5d,
    0x0, 0x0, 0xbf666666, 0x3f743ccf,
    0x0, 0x0, 0xbf666666, 0x3f72bdc1,
    0x0, 0x0, 0xbf666666, 0x3f71412a,
    0x0, 0x0, 0xbf666666, 0x3f6fc704,
    0x0, 0x0, 0xbf666666, 0x3f6e4f46,
    0x0, 0x0, 0xbf666666, 0x3f6cd9e8,
    0x0, 0x0, 0xbf666666, 0x3f6b66e4,
    0x0, 0x0, 0xbf666666, 0x3f69f631,
    0x0, 0x0, 0xbf666666, 0x3f6887c8,
    0x0, 0x0, 0xbf666666, 0x3f671ba2,
    0x0, 0x0, 0xbf666666, 0x3f65b1b9,
    0x0, 0x0, 0xbf666666, 0x3f644a04,
    0x0, 0x0, 0xbf666666, 0x3f62e47e,
    0x0, 0x0, 0xbf666666, 0x3f61811f,
    0x0, 0x0, 0xbf666666, 0x3f601fe0,
    0x0, 0x0, 0xbf666666, 0x3f5ec0bc,
    0x0, 0x0, 0xbf666666, 0x3f5d63ab,
    0x0, 0x0, 0xbf666666, 0x3f5c08a8,
    0x0, 0x0, 0xbf666666, 0x3f5aafac,
    0x0, 0x0, 0xbf666666, 0x3f5958b1,
    0x0, 0x0, 0xbf666666, 0x3f5803b0,
    0x0, 0x0, 0xbf666666, 0x3f56b0a5,
    0x0, 0x0, 0xbf666666, 0x3f555f88,
    0x0, 0x0, 0xbf666666, 0x3f541054,
    0x0, 0x0, 0xbf666666, 0x3f52c303,
    0x0, 0x0, 0xbf666666, 0x3f517790,
    0x0, 0x0, 0xbf666666, 0x3f502df5,
    0x0, 0x0, 0xbf666666, 0x3f4ee62d,
    0x0, 0x0, 0xbf666666, 0x3f4da031,
    0x0, 0x0, 0xbf666666, 0x3f4c5bfe,
    0x0, 0x0, 0xbf666666, 0x3f4b198c,
    0x0, 0x0, 0xbf666666, 0x3f49d8d9,
    0x0, 0x0, 0xbf666666, 0x3f4899dd,
    0x0, 0x0, 0xbf666666, 0x3f475c94,
    0x0, 0x0, 0xbf666666, 0x3f4620fa,
    0x0, 0x0, 0xbf666666, 0x3f44e708,
    0x0, 0x0, 0xbf666666, 0x3f43aebb,
    0x0, 0x0, 0xbf666666, 0x3f42780e,
    0x0, 0x0, 0xbf666666, 0x3f4142fb,
    0x0, 0x0, 0xbf666666, 0x3f400f7f,
    0x0, 0x0, 0xbf666666, 0x3f3edd94,
    0x0, 0x0, 0xbf666666, 0x3f3dad36,
    0x0, 0x0, 0xbf666666, 0x3f3c7e61,
    0x0, 0x0, 0xbf666666, 0x3f3b5110,
    0x0, 0x0, 0xbf666666, 0x3f3a253f,
    0x0, 0x0, 0xbf666666, 0x3f38fae9,
    0x0, 0x0, 0xbf666666, 0x3f37d20b,
    0x0, 0x0, 0xbf666666, 0x3f36aaa0,
    0x0, 0x0, 0xbf666666, 0x3f3584a4,
    0x0, 0x0, 0xbf666666, 0x3f346013,
    0x0, 0x0, 0xbf666666, 0x3f333ce9,
    0x0, 0x0, 0xbf666666, 0x3f321b21,
    0x0, 0x0, 0xbf666666, 0x3f30fab9,
    0x0, 0x0, 0xbf666666, 0x3f2fdbac,
    0x0, 0x0, 0xbf666666, 0x3f2ebdf6,
    0x0, 0x0, 0xbf666666, 0x3f2da194,
    0x0, 0x0, 0xbf666666, 0x3f2c8682,
    0x0, 0x0, 0xbf666666, 0x3f2b6cbc,
    0x0, 0x0, 0xbf666666, 0x3f2a543e,
    0x0, 0x0, 0xbf666666, 0x3f293d06,
    0x0, 0x0, 0xbf666666, 0x3f28270f,
    0x0, 0x0, 0xbf666666, 0x3f271256,
    0x0, 0x0, 0xbf666666, 0x3f25fed7,
    0x0, 0x0, 0xbf666666, 0x3f24ec90,
    0x0, 0x0, 0xbf666666, 0x3f23db7c,
    0x0, 0x0, 0xbf666666, 0x3f22cb98,
    0x0, 0x0, 0xbf666666, 0x3f21bce2,
    0x0, 0x0, 0xbf666666, 0x3f20af56,
    0x0, 0x0, 0xbf666666, 0x3f1fa2f0,
    0x0, 0x0, 0xbf666666, 0x3f1e97ae,
    0x0, 0x0, 0xbf666666, 0x3f1d8d8c,
    0x0, 0x0, 0xbf666666, 0x3f1c8487,
    0x0, 0x0, 0xbf666666, 0x3f1b7c9d,
    0x0, 0x0, 0xbf666666, 0x3f1a75c9,
    0x0, 0x0, 0xbf666666, 0x3f19700a,
    0x0, 0x0, 0xbf666666, 0x3f186b5d,
    0x0, 0x0, 0xbf666666, 0x3f1767bd,
    0x0, 0x0, 0xbf666666, 0x3f166529,
    0x0, 0x0, 0xbf666666, 0x3f15639e,
    0x0, 0x0, 0xbf666666, 0x3f146318,
    0x0, 0x0, 0xbf666666, 0x3f136396,
    0x0, 0x0, 0xbf666666, 0x3f126513,
    0x0, 0x0, 0xbf666666, 0x3f11678e,
    0x0, 0x0, 0xbf666666, 0x3f106b05,
    0x0, 0x0, 0xbf666666, 0x3f0f6f73,
    0x0, 0x0, 0xbf666666, 0x3f0e74d6,
    0x0, 0x0, 0xbf666666, 0x3f0d7b2d,
    0x0, 0x0, 0xbf666666, 0x3f0c8274,
    0x0, 0x0, 0xbf666666, 0x3f0b8aa9,
    0x0, 0x0, 0xbf666666, 0x3f0a93c9,
    0x0, 0x0, 0xbf666666, 0x3f099dd2,
    0x0, 0x0, 0xbf666666, 0x3f08a8c1,
    0x0, 0x0, 0xbf666666, 0x3f07b495,
    0x0, 0x0, 0xbf666666, 0x3f06c149,
    0x0, 0x0, 0xbf666666, 0x3f05cedd,
    0x0, 0x0, 0xbf666666, 0x3f04dd4e,
    0x0, 0x0, 0xbf666666, 0x3f03ec99,
    0x0, 0x0, 0xbf666666, 0x3f02fcbc,
    0x0, 0x0, 0xbf666666, 0x3f020db5,
    0x0, 0x0, 0xbf666666, 0x3f011f82,
    0x0, 0x0, 0xbf666666, 0x3f00321f,
    0x0, 0x0, 0xbf666666, 0x3efe8b19,
    0x0, 0x0, 0xbf666666, 0x3efcb38d,
    0x0, 0x0, 0xbf666666, 0x3efadd96,
    0x0, 0x0, 0xbf666666, 0x3ef90931,
    0x0, 0x0, 0xbf666666, 0x3ef73658,
    0x0, 0x0, 0xbf666666, 0x3ef56509,
    0x0, 0x0, 0xbf666666, 0x3ef3953e,
    0x0, 0x0, 0xbf666666, 0x3ef1c6f3,
    0x0, 0x0, 0xbf666666, 0x3eeffa25,
    0x0, 0x0, 0xbf666666, 0x3eee2ecf,
    0x0, 0x0, 0xbf666666, 0x3eec64ee,
    0x0, 0x0, 0xbf666666, 0x3eea9c7d,
    0x0, 0x0, 0xbf666666, 0x3ee8d578,
    0x0, 0x0, 0xbf666666, 0x3ee70fdc,
    0x0, 0x0, 0xbf666666, 0x3ee54ba5,
    0x0, 0x0, 0xbf666666, 0x3ee388cf,
    0x0, 0x0, 0xbf666666, 0x3ee1c756,
    0x0, 0x0, 0xbf666666, 0x3ee00736,
    0x0, 0x0, 0xbf666666, 0x3ede486c,
    0x0, 0x0, 0xbf666666, 0x3edc8af4,
    0x0, 0x0, 0xbf666666, 0x3edaceca,
    0x0, 0x0, 0xbf666666, 0x3ed913ec,
    0x0, 0x0, 0xbf666666, 0x3ed75a54,
    0x0, 0x0, 0xbf666666, 0x3ed5a200,
    0x0, 0x0, 0xbf666666, 0x3ed3eaed,
    0x0, 0x0, 0xbf666666, 0x3ed23516,
    0x0, 0x0, 0xbf666666, 0x3ed08079,
    0x0, 0x0, 0xbf666666, 0x3ececd11,
    0x0, 0x0, 0xbf666666, 0x3ecd1adc,
    0x0, 0x0, 0xbf666666, 0x3ecb69d6,
    0x0, 0x0, 0xbf666666, 0x3ec9b9fc,
    0x0, 0x0, 0xbf666666, 0x3ec80b4a,
    0x0, 0x0, 0xbf666666, 0x3ec65dbe,
    0x0, 0x0, 0xbf666666, 0x3ec4b154,
    0x0, 0x0, 0xbf666666, 0x3ec30609,
    0x0, 0x0, 0xbf666666, 0x3ec15bd9,
    0x0, 0x0, 0xbf666666, 0x3ebfb2c2,
    0x0, 0x0, 0xbf666666, 0x3ebe0ac0,
    0x0, 0x0, 0xbf666666, 0x3ebc63d1,
    0x0, 0x0, 0xbf666666, 0x3ebabdf1,
    0x0, 0x0, 0xbf666666, 0x3eb9191d,
    0x0, 0x0, 0xbf666666, 0x3eb77553,
    0x0, 0x0, 0xbf666666, 0x3eb5d28f,
    0x0, 0x0, 0xbf666666, 0x3eb430cd,
    0x0, 0x0, 0xbf666666, 0x3eb2900d,
    0x0, 0x0, 0xbf666666, 0x3eb0f049,
    0x0, 0x0, 0xbf666666, 0x3eaf5180,
    0x0, 0x0, 0xbf666666, 0x3eadb3af,
    0x0, 0x0, 0xbf666666, 0x3eac16d2,
    0x0, 0x0, 0xbf666666, 0x3eaa7ae8,
    0x0, 0x0, 0xbf666666, 0x3ea8dfec,
    0x0, 0x0, 0xbf666666, 0x3ea745dd,
    0x0, 0x0, 0xbf666666, 0x3ea5acb7,
    0x0, 0x0, 0xbf666666, 0x3ea41478,
    0x0, 0x0, 0xbf666666, 0x3ea27d1d,
    0x0, 0x0, 0xbf666666, 0x3ea0e6a4,
    0x0, 0x0, 0xbf666666, 0x3e9f5109,
    0x0, 0x0, 0xbf666666, 0x3e9dbc4b,
    0x0, 0x0, 0xbf666666, 0x3e9c2865,
    0x0, 0x0, 0xbf666666, 0x3e9a9557,
    0x0, 0x0, 0xbf666666, 0x3e99031d,
    0x0, 0x0, 0xbf666666, 0x3e9771b4,
    0x0, 0x0, 0xbf666666, 0x3e95e11a,
    0x0, 0x0, 0xbf666666, 0x3e94514d,
    0x0, 0x0, 0xbf666666, 0x3e92c24a,
    0x0, 0x0, 0xbf666666, 0x3e91340e,
    0x0, 0x0, 0xbf666666, 0x3e8fa697,
    0x0, 0x0, 0xbf666666, 0x3e8e19e3,
    0x0, 0x0, 0xbf666666, 0x3e8c8dee,
    0x0, 0x0, 0xbf666666, 0x3e8b02b7,
    0x0, 0x0, 0xbf666666, 0x3e89783b,
    0x0, 0x0, 0xbf666666, 0x3e87ee78,
    0x0, 0x0, 0xbf666666, 0x3e86656b,
    0x0, 0x0, 0xbf666666, 0x3e84dd12,
    0x0, 0x0, 0xbf666666, 0x3e83556b,
    0x0, 0x0, 0xbf666666, 0x3e81ce73,
    0x0, 0x0, 0xbf666666, 0x3e804827,
    0x0, 0x0, 0xbf666666, 0x3e7d850d,
    0x0, 0x0, 0xbf666666, 0x3e7a7b1c,
    0x0, 0x0, 0xbf666666, 0x3e777276,
    0x0, 0x0, 0xbf666666, 0x3e746b18,
    0x0, 0x0, 0xbf666666, 0x3e7164fd,
    0x0, 0x0, 0xbf666666, 0x3e6e6020,
    0x0, 0x0, 0xbf666666, 0x3e6b5c7c,
    0x0, 0x0, 0xbf666666, 0x3e685a0e,
    0x0, 0x0, 0xbf666666, 0x3e6558d1,
    0x0, 0x0, 0xbf666666, 0x3e6258c0,
    0x0, 0x0, 0xbf666666, 0x3e5f59d8,
    0x0, 0x0, 0xbf666666, 0x3e5c5c13,
    0x0, 0x0, 0xbf666666, 0x3e595f6d,
    0x0, 0x0, 0xbf666666, 0x3e5663e3,
    0x0, 0x0, 0xbf666666, 0x3e53696f,
    0x0, 0x0, 0xbf666666, 0x3e50700e,
    0x0, 0x0, 0xbf666666, 0x3e4d77bc,
    0x0, 0x0, 0xbf666666, 0x3e4a8073,
    0x0, 0x0, 0xbf666666, 0x3e478a30,
    0x0, 0x0, 0xbf666666, 0x3e4494ef,
    0x0, 0x0, 0xbf666666, 0x3e41a0ac,
    0x0, 0x0, 0xbf666666, 0x3e3ead62,
    0x0, 0x0, 0xbf666666, 0x3e3bbb0d,
    0x0, 0x0, 0xbf666666, 0x3e38c9a9,
    0x0, 0x0, 0xbf666666, 0x3e35d933,
    0x0, 0x0, 0xbf666666, 0x3e32e9a6,
    0x0, 0x0, 0xbf666666, 0x3e2ffafd,
    0x0, 0x0, 0xbf666666, 0x3e2d0d36,
    0x0, 0x0, 0xbf666666, 0x3e2a204c,
    0x0, 0x0, 0xbf666666, 0x3e27343b,
    0x0, 0x0, 0xbf666666, 0x3e2448ff,
    0x0, 0x0, 0xbf666666, 0x3e215e94,
    0x0, 0x0, 0xbf666666, 0x3e1e74f6,
    0x0, 0x0, 0xbf666666, 0x3e1b8c21,
    0x0, 0x0, 0xbf666666, 0x3e18a412,
    0x0, 0x0, 0xbf666666, 0x3e15bcc4,
    0x0, 0x0, 0xbf666666, 0x3e12d634,
    0x0, 0x0, 0xbf666666, 0x3e0ff05e,
    0x0, 0x0, 0xbf666666, 0x3e0d0b3e,
    0x0, 0x0, 0xbf666666, 0x3e0a26cf,
    0x0, 0x0, 0xbf666666, 0x3e07430f,
    0x0, 0x0, 0xbf666666, 0x3e045ffa,
    0x0, 0x0, 0xbf666666, 0x3e017d8b,
    0x0, 0x0, 0xbf666666, 0x3dfd377d,
    0x0, 0x0, 0xbf666666, 0x3df77524,
    0x0, 0x0, 0xbf666666, 0x3df1b401,
    0x0, 0x0, 0xbf666666, 0x3debf40d,
    0x0, 0x0, 0xbf666666, 0x3de63541,
    0x0, 0x0, 0xbf666666, 0x3de07796,
    0x0, 0x0, 0xbf666666, 0x3ddabb04,
    0x0, 0x0, 0xbf666666, 0x3dd4ff83,
    0x0, 0x0, 0xbf666666, 0x3dcf450d,
    0x0, 0x0, 0xbf666666, 0x3dc98b99,
    0x0, 0x0, 0xbf666666, 0x3dc3d322,
    0x0, 0x0, 0xbf666666, 0x3dbe1b9e,
    0x0, 0x0, 0xbf666666, 0x3db86508,
    0x0, 0x0, 0xbf666666, 0x3db2af57,
    0x0, 0x0, 0xbf666666, 0x3dacfa85,
    0x0, 0x0, 0xbf666666, 0x3da7468a,
    0x0, 0x0, 0xbf666666, 0x3da1935f,
    0x0, 0x0, 0xbf666666, 0x3d9be0fd,
    0x0, 0x0, 0xbf666666, 0x3d962f5d,
    0x0, 0x0, 0xbf666666, 0x3d907e77,
    0x0, 0x0, 0xbf666666, 0x3d8ace45,
    0x0, 0x0, 0xbf666666, 0x3d851ebf,
    0x0, 0x0, 0xbf666666, 0x3d7edfbc,
    0x0, 0x0, 0xbf666666, 0x3d738336,
    0x0, 0x0, 0xbf666666, 0x3d6827dd,
    0x0, 0x0, 0xbf666666, 0x3d5ccda4,
    0x0, 0x0, 0xbf666666, 0x3d51747d,
    0x0, 0x0, 0xbf666666, 0x3d461c59,
    0x0, 0x0, 0xbf666666, 0x3d3ac52a,
    0x0, 0x0, 0xbf666666, 0x3d2f6ee1,
    0x0, 0x0, 0xbf666666, 0x3d241972,
    0x0, 0x0, 0xbf666666, 0x3d18c4ce,
    0x0, 0x0, 0xbf666666, 0x3d0d70e6,
    0x0, 0x0, 0xbf666666, 0x3d021dae,
    0x0, 0x0, 0xbf666666, 0x3ced962b,
    0x0, 0x0, 0xbf666666, 0x3cd6f220,
    0x0, 0x0, 0xbf666666, 0x3cc04f1f,
    0x0, 0x0, 0xbf666666, 0x3ca9ad0b,
    0x0, 0x0, 0xbf666666, 0x3c930bc9,
    0x0, 0x0, 0xbf666666, 0x3c78d677,
    0x0, 0x0, 0xbf666666, 0x3c4b9690,
    0x0, 0x0, 0xbf666666, 0x3c1e57a5,
    0x0, 0x0, 0xbf666666, 0x3be232f9,
    0x0, 0x0, 0xbf666666, 0x3b87b7bf,
    0x0, 0x0, 0xbf666666, 0x3ab4f4b4,
    0x0, 0x0, 0xbf666666, 0xbab4f4b4,
    0x0, 0x0, 0xbf666666, 0xbb87b7bf,
    0x0, 0x0, 0xbf666666, 0xbbe232f9,
    0x0, 0x0, 0xbf666666, 0xbc1e57a5,
    0x0, 0x0, 0xbf666666, 0xbc4b9690,
    0x0, 0x0, 0xbf666666, 0xbc78d677,
    0x0, 0x0, 0xbf666666, 0xbc930bc9,
    0x0, 0x0, 0xbf666666, 0xbca9ad0b,
    0x0, 0x0, 0xbf666666, 0xbcc04f1f,
    0x0, 0x0, 0xbf666666, 0xbcd6f220,
    0x0, 0x0, 0xbf666666, 0xbced962b,
    0x0, 0x0, 0xbf666666, 0xbd021dae,
    0x0, 0x0, 0xbf666666, 0xbd0d70e6,
    0x0, 0x0, 0xbf666666, 0xbd18c4ce,
    0x0, 0x0, 0xbf666666, 0xbd241972,
    0x0, 0x0, 0xbf666666, 0xbd2f6ee1,
    0x0, 0x0, 0xbf666666, 0xbd3ac52a,
    0x0, 0x0, 0xbf666666, 0xbd461c59,
    0x0, 0x0, 0xbf666666, 0xbd51747d,
    0x0, 0x0, 0xbf666666, 0xbd5ccda4,
    0x0, 0x0, 0xbf666666, 0xbd6827dd,
    0x0, 0x0, 0xbf666666, 0xbd738336,
    0x0, 0x0, 0xbf666666, 0xbd7edfbc,
    0x0, 0x0, 0xbf666666, 0xbd851ebf,
    0x0, 0x0, 0xbf666666, 0xbd8ace45,
    0x0, 0x0, 0xbf666666, 0xbd907e77,
    0x0, 0x0, 0xbf666666, 0xbd962f5d,
    0x0, 0x0, 0xbf666666, 0xbd9be0fd,
    0x0, 0x0, 0xbf666666, 0xbda1935f,
    0x0, 0x0, 0xbf666666, 0xbda7468a,
    0x0, 0x0, 0xbf666666, 0xbdacfa85,
    0x0, 0x0, 0xbf666666, 0xbdb2af57,
    0x0, 0x0, 0xbf666666, 0xbdb86508,
    0x0, 0x0, 0xbf666666, 0xbdbe1b9e,
    0x0, 0x0, 0xbf666666, 0xbdc3d322,
    0x0, 0x0, 0xbf666666, 0xbdc98b99,
    0x0, 0x0, 0xbf666666, 0xbdcf450d,
    0x0, 0x0, 0xbf666666, 0xbdd4ff83,
    0x0, 0x0, 0xbf666666, 0xbddabb04,
    0x0, 0x0, 0xbf666666, 0xbde07796,
    0x0, 0x0, 0xbf666666, 0xbde63541,
    0x0, 0x0, 0xbf666666, 0xbdebf40d,
    0x0, 0x0, 0xbf666666, 0xbdf1b401,
    0x0, 0x0, 0xbf666666, 0xbdf77524,
    0x0, 0x0, 0xbf666666, 0xbdfd377d,
    0x0, 0x0, 0xbf666666, 0xbe017d8b,
    0x0, 0x0, 0xbf666666, 0xbe045ffa,
    0x0, 0x0, 0xbf666666, 0xbe07430f,
    0x0, 0x0, 0xbf666666, 0xbe0a26cf,
    0x0, 0x0, 0xbf666666, 0xbe0d0b3e,
    0x0, 0x0, 0xbf666666, 0xbe0ff05e,
    0x0, 0x0, 0xbf666666, 0xbe12d634,
    0x0, 0x0, 0xbf666666, 0xbe15bcc4,
    0x0, 0x0, 0xbf666666, 0xbe18a412,
    0x0, 0x0, 0xbf666666, 0xbe1b8c21,
    0x0, 0x0, 0xbf666666, 0xbe1e74f6,
    0x0, 0x0, 0xbf666666, 0xbe215e94,
    0x0, 0x0, 0xbf666666, 0xbe2448ff,
    0x0, 0x0, 0xbf666666, 0xbe27343b,
    0x0, 0x0, 0xbf666666, 0xbe2a204c,
    0x0, 0x0, 0xbf666666, 0xbe2d0d36,
    0x0, 0x0, 0xbf666666, 0xbe2ffafd,
    0x0, 0x0, 0xbf666666, 0xbe32e9a6,
    0x0, 0x0, 0xbf666666, 0xbe35d933,
    0x0, 0x0, 0xbf666666, 0xbe38c9a9,
    0x0, 0x0, 0xbf666666, 0xbe3bbb0d,
    0x0, 0x0, 0xbf666666, 0xbe3ead62,
    0x0, 0x0, 0xbf666666, 0xbe41a0ac,
    0x0, 0x0, 0xbf666666, 0xbe4494ef,
    0x0, 0x0, 0xbf666666, 0xbe478a30,
    0x0, 0x0, 0xbf666666, 0xbe4a8073,
    0x0, 0x0, 0xbf666666, 0xbe4d77bc,
    0x0, 0x0, 0xbf666666, 0xbe50700e,
    0x0, 0x0, 0xbf666666, 0xbe53696f,
    0x0, 0x0, 0xbf666666, 0xbe5663e3,
    0x0, 0x0, 0xbf666666, 0xbe595f6d,
    0x0, 0x0, 0xbf666666, 0xbe5c5c13,
    0x0, 0x0, 0xbf666666, 0xbe5f59d8,
    0x0, 0x0, 0xbf666666, 0xbe6258c0,
    0x0, 0x0, 0xbf666666, 0xbe6558d1,
    0x0, 0x0, 0xbf666666, 0xbe685a0e,
    0x0, 0x0, 0xbf666666, 0xbe6b5c7c,
    0x0, 0x0, 0xbf666666, 0xbe6e6020,
    0x0, 0x0, 0xbf666666, 0xbe7164fd,
    0x0, 0x0, 0xbf666666, 0xbe746b18,
    0x0, 0x0, 0xbf666666, 0xbe777276,
    0x0, 0x0, 0xbf666666, 0xbe7a7b1c,
    0x0, 0x0, 0xbf666666, 0xbe7d850d,
    0x0, 0x0, 0xbf666666, 0xbe804827,
    0x0, 0x0, 0xbf666666, 0xbe81ce73,
    0x0, 0x0, 0xbf666666, 0xbe83556b,
    0x0, 0x0, 0xbf666666, 0xbe84dd12,
    0x0, 0x0, 0xbf666666, 0xbe86656b,
    0x0, 0x0, 0xbf666666, 0xbe87ee78,
    0x0, 0x0, 0xbf666666, 0xbe89783b,
    0x0, 0x0, 0xbf666666, 0xbe8b02b7,
    0x0, 0x0, 0xbf666666, 0xbe8c8dee,
    0x0, 0x0, 0xbf666666, 0xbe8e19e3,
    0x0, 0x0, 0xbf666666, 0xbe8fa697,
    0x0, 0x0, 0xbf666666, 0xbe91340e,
    0x0, 0x0, 0xbf666666, 0xbe92c24a,
    0x0, 0x0, 0xbf666666, 0xbe94514d,
    0x0, 0x0, 0xbf666666, 0xbe95e11a,
    0x0, 0x0, 0xbf666666, 0xbe9771b4,
    0x0, 0x0, 0xbf666666, 0xbe99031d,
    0x0, 0x0, 0xbf666666, 0xbe9a9557,
    0x0, 0x0, 0xbf666666, 0xbe9c2865,
    0x0, 0x0, 0xbf666666, 0xbe9dbc4b,
    0x0, 0x0, 0xbf666666, 0xbe9f5109,
    0x0, 0x0, 0xbf666666, 0xbea0e6a4,
    0x0, 0x0, 0xbf666666, 0xbea27d1d,
    0x0, 0x0, 0xbf666666, 0xbea41478,
    0x0, 0x0, 0xbf666666, 0xbea5acb7,
    0x0, 0x0, 0xbf666666, 0xbea745dd,
    0x0, 0x0, 0xbf666666, 0xbea8dfec,
    0x0, 0x0, 0xbf666666, 0xbeaa7ae8,
    0x0, 0x0, 0xbf666666, 0xbeac16d2,
    0x0, 0x0, 0xbf666666, 0xbeadb3af,
    0x0, 0x0, 0xbf666666, 0xbeaf5180,
    0x0, 0x0, 0xbf666666, 0xbeb0f049,
    0x0, 0x0, 0xbf666666, 0xbeb2900d,
    0x0, 0x0, 0xbf666666, 0xbeb430cd,
    0x0, 0x0, 0xbf666666, 0xbeb5d28f,
    0x0, 0x0, 0xbf666666, 0xbeb77553,
    0x0, 0x0, 0xbf666666, 0xbeb9191d,
    0x0, 0x0, 0xbf666666, 0xbebabdf1,
    0x0, 0x0, 0xbf666666, 0xbebc63d1,
    0x0, 0x0, 0xbf666666, 0xbebe0ac0,
    0x0, 0x0, 0xbf666666, 0xbebfb2c2,
    0x0, 0x0, 0xbf666666, 0xbec15bd9,
    0x0, 0x0, 0xbf666666, 0xbec30609,
    0x0, 0x0, 0xbf666666, 0xbec4b154,
    0x0, 0x0, 0xbf666666, 0xbec65dbe,
    0x0, 0x0, 0xbf666666, 0xbec80b4a,
    0x0, 0x0, 0xbf666666, 0xbec9b9fc,
    0x0, 0x0, 0xbf666666, 0xbecb69d6,
    0x0, 0x0, 0xbf666666, 0xbecd1adc,
    0x0, 0x0, 0xbf666666, 0xbececd11,
    0x0, 0x0, 0xbf666666, 0xbed08079,
    0x0, 0x0, 0xbf666666, 0xbed23516,
    0x0, 0x0, 0xbf666666, 0xbed3eaed,
    0x0, 0x0, 0xbf666666, 0xbed5a200,
    0x0, 0x0, 0xbf666666, 0xbed75a54,
    0x0, 0x0, 0xbf666666, 0xbed913ec,
    0x0, 0x0, 0xbf666666, 0xbedaceca,
    0x0, 0x0, 0xbf666666, 0xbedc8af4,
    0x0, 0x0, 0xbf666666, 0xbede486c,
    0x0, 0x0, 0xbf666666, 0xbee00736,
    0x0, 0x0, 0xbf666666, 0xbee1c756,
    0x0, 0x0, 0xbf666666, 0xbee388cf,
    0x0, 0x0, 0xbf666666, 0xbee54ba5,
    0x0, 0x0, 0xbf666666, 0xbee70fdc,
    0x0, 0x0, 0xbf666666, 0xbee8d578,
    0x0, 0x0, 0xbf666666, 0xbeea9c7d,
    0x0, 0x0, 0xbf666666, 0xbeec64ee,
    0x0, 0x0, 0xbf666666, 0xbeee2ecf,
    0x0, 0x0, 0xbf666666, 0xbeeffa25,
    0x0, 0x0, 0xbf666666, 0xbef1c6f3,
    0x0, 0x0, 0xbf666666, 0xbef3953e,
    0x0, 0x0, 0xbf666666, 0xbef56509,
    0x0, 0x0, 0xbf666666, 0xbef73658,
    0x0, 0x0, 0xbf666666, 0xbef90931,
    0x0, 0x0, 0xbf666666, 0xbefadd96,
    0x0, 0x0, 0xbf666666, 0xbefcb38d,
    0x0, 0x0, 0xbf666666, 0xbefe8b19,
    0x0, 0x0, 0xbf666666, 0xbf00321f,
    0x0, 0x0, 0xbf666666, 0xbf011f82,
    0x0, 0x0, 0xbf666666, 0xbf020db5,
    0x0, 0x0, 0xbf666666, 0xbf02fcbc,
    0x0, 0x0, 0xbf666666, 0xbf03ec99,
    0x0, 0x0, 0xbf666666, 0xbf04dd4e,
    0x0, 0x0, 0xbf666666, 0xbf05cedd,
    0x0, 0x0, 0xbf666666, 0xbf06c149,
    0x0, 0x0, 0xbf666666, 0xbf07b495,
    0x0, 0x0, 0xbf666666, 0xbf08a8c1,
    0x0, 0x0, 0xbf666666, 0xbf099dd2,
    0x0, 0x0, 0xbf666666, 0xbf0a93c9,
    0x0, 0x0, 0xbf666666, 0xbf0b8aa9,
    0x0, 0x0, 0xbf666666, 0xbf0c8274,
    0x0, 0x0, 0xbf666666, 0xbf0d7b2d,
    0x0, 0x0, 0xbf666666, 0xbf0e74d6,
    0x0, 0x0, 0xbf666666, 0xbf0f6f73,
    0x0, 0x0, 0xbf666666, 0xbf106b05,
    0x0, 0x0, 0xbf666666, 0xbf11678e,
    0x0, 0x0, 0xbf666666, 0xbf126513,
    0x0, 0x0, 0xbf666666, 0xbf136396,
    0x0, 0x0, 0xbf666666, 0xbf146318,
    0x0, 0x0, 0xbf666666, 0xbf15639e,
    0x0, 0x0, 0xbf666666, 0xbf166529,
    0x0, 0x0, 0xbf666666, 0xbf1767bd,
    0x0, 0x0, 0xbf666666, 0xbf186b5d,
    0x0, 0x0, 0xbf666666, 0xbf19700a,
    0x0, 0x0, 0xbf666666, 0xbf1a75c9,
    0x0, 0x0, 0xbf666666, 0xbf1b7c9d,
    0x0, 0x0, 0xbf666666, 0xbf1c8487,
    0x0, 0x0, 0xbf666666, 0xbf1d8d8c,
    0x0, 0x0, 0xbf666666, 0xbf1e97ae,
    0x0, 0x0, 0xbf666666, 0xbf1fa2f0,
    0x0, 0x0, 0xbf666666, 0xbf20af56,
    0x0, 0x0, 0xbf666666, 0xbf21bce2,
    0x0, 0x0, 0xbf666666, 0xbf22cb98,
    0x0, 0x0, 0xbf666666, 0xbf23db7c,
    0x0, 0x0, 0xbf666666, 0xbf24ec90,
    0x0, 0x0, 0xbf666666, 0xbf25fed7,
    0x0, 0x0, 0xbf666666, 0xbf271256,
    0x0, 0x0, 0xbf666666, 0xbf28270f,
    0x0, 0x0, 0xbf666666, 0xbf293d06,
    0x0, 0x0, 0xbf666666, 0xbf2a543e,
    0x0, 0x0, 0xbf666666, 0xbf2b6cbc,
    0x0, 0x0, 0xbf666666, 0xbf2c8682,
    0x0, 0x0, 0xbf666666, 0xbf2da194,
    0x0, 0x0, 0xbf666666, 0xbf2ebdf6,
    0x0, 0x0, 0xbf666666, 0xbf2fdbac,
    0x0, 0x0, 0xbf666666, 0xbf30fab9,
    0x0, 0x0, 0xbf666666, 0xbf321b21,
    0x0, 0x0, 0xbf666666, 0xbf333ce9,
    0x0, 0x0, 0xbf666666, 0xbf346013,
    0x0, 0x0, 0xbf666666, 0xbf3584a4,
    0x0, 0x0, 0xbf666666, 0xbf36aaa0,
    0x0, 0x0, 0xbf666666, 0xbf37d20b,
    0x0, 0x0, 0xbf666666, 0xbf38fae9,
    0x0, 0x0, 0xbf666666, 0xbf3a253f,
    0x0, 0x0, 0xbf666666, 0xbf3b5110,
    0x0, 0x0, 0xbf666666, 0xbf3c7e61,
    0x0, 0x0, 0xbf666666, 0xbf3dad36,
    0x0, 0x0, 0xbf666666, 0xbf3edd94,
    0x0, 0x0, 0xbf666666, 0xbf400f7f,
    0x0, 0x0, 0xbf666666, 0xbf4142fb,
    0x0, 0x0, 0xbf666666, 0xbf42780e,
    0x0, 0x0, 0xbf666666, 0xbf43aebb,
    0x0, 0x0, 0xbf666666, 0xbf44e708,
    0x0, 0x0, 0xbf666666, 0xbf4620fa,
    0x0, 0x0, 0xbf666666, 0xbf475c94,
    0x0, 0x0, 0xbf666666, 0xbf4899dd,
    0x0, 0x0, 0xbf666666, 0xbf49d8d9,
    0x0, 0x0, 0xbf666666, 0xbf4b198c,
    0x0, 0x0, 0xbf666666, 0xbf4c5bfe,
    0x0, 0x0, 0xbf666666, 0xbf4da031,
    0x0, 0x0, 0xbf666666, 0xbf4ee62d,
    0x0, 0x0, 0xbf666666, 0xbf502df5,
    0x0, 0x0, 0xbf666666, 0xbf517790,
    0x0, 0x0, 0xbf666666, 0xbf52c303,
    0x0, 0x0, 0xbf666666, 0xbf541054,
    0x0, 0x0, 0xbf666666, 0xbf555f88,
    0x0, 0x0, 0xbf666666, 0xbf56b0a5,
    0x0, 0x0, 0xbf666666, 0xbf5803b0,
    0x0, 0x0, 0xbf666666, 0xbf5958b1,
    0x0, 0x0, 0xbf666666, 0xbf5aafac,
    0x0, 0x0, 0xbf666666, 0xbf5c08a8,
    0x0, 0x0, 0xbf666666, 0xbf5d63ab,
    0x0, 0x0, 0xbf666666, 0xbf5ec0bc,
    0x0, 0x0, 0xbf666666, 0xbf601fe0,
    0x0, 0x0, 0xbf666666, 0xbf61811f,
    0x0, 0x0, 0xbf666666, 0xbf62e47e,
    0x0, 0x0, 0xbf666666, 0xbf644a04,
    0x0, 0x0, 0xbf666666, 0xbf65b1b9,
    0x0, 0x0, 0xbf666666, 0xbf671ba2,
    0x0, 0x0, 0xbf666666, 0xbf6887c8,
    0x0, 0x0, 0xbf666666, 0xbf69f631,
    0x0, 0x0, 0xbf666666, 0xbf6b66e4,
    0x0, 0x0, 0xbf666666, 0xbf6cd9e8,
    0x0, 0x0, 0xbf666666, 0xbf6e4f46,
    0x0, 0x0, 0xbf666666, 0xbf6fc704,
    0x0, 0x0, 0xbf666666, 0xbf71412a,
    0x0, 0x0, 0xbf666666, 0xbf72bdc1,
    0x0, 0x0, 0xbf666666, 0xbf743ccf,
    0x0, 0x0, 0xbf666666, 0xbf75be5d,
    0x0, 0x0, 0xbf666666, 0xbf774273,
    0x0, 0x0, 0xbf666666, 0xbf78c91a,
    0x0, 0x0, 0xbf666666, 0xbf7a5259,
    0x0, 0x0, 0xbf666666, 0xbf7bde3a,
    0x0, 0x0, 0xbf666666, 0xbf7d6cc5,
    0x0, 0x0, 0xbf666666, 0xbf7efe03,
    0x0, 0x0, 0xbf666666, 0xbf8048fe,
    0x0, 0x0, 0xbf666666, 0xbf81145e,
    0x0, 0x0, 0xbf666666, 0xbf81e124,
    0x0, 0x0, 0xbf666666, 0xbf82af57,
    0x0, 0x0, 0xbf666666, 0xbf837efa,
    0x0, 0x0, 0xbf666666, 0xbf845013,
    0x0, 0x0, 0xbf666666, 0xbf8522a6,
    0x0, 0x0, 0xbf666666, 0xbf85f6b9,
    0x0, 0x0, 0xbf666666, 0xbf86cc51,
    0x0, 0x0, 0xbf666666, 0xbf87a372,
    0x0, 0x0, 0xbf666666, 0xbf887c24,
    0x0, 0x0, 0xbf666666, 0xbf895669,
    0x0, 0x0, 0xbf666666, 0xbf8a3249,
    0x0, 0x0, 0xbf666666, 0xbf8b0fc9,
    0x0, 0x0, 0xbf666666, 0xbf8beeef,
    0x0, 0x0, 0xbf666666, 0xbf8ccfc0,
    0x0, 0x0, 0xbf666666, 0xbf8db242,
    0x0, 0x0, 0xbf666666, 0xbf8e967b,
    0x0, 0x0, 0xbf666666, 0xbf8f7c72,
    0x0, 0x0, 0xbf666666, 0xbf90642d,
    0x0, 0x0, 0xbf666666, 0xbf914db1,
    0x0, 0x0, 0xbf666666, 0xbf923906,
    0x0, 0x0, 0xbf666666, 0xbf932632,
    0x0, 0x0, 0xbf666666, 0xbf94153c,
    0x0, 0x0, 0xbf666666, 0xbf95062a,
    0x0, 0x0, 0xbf666666, 0xbf95f904,
    0x0, 0x0, 0xbf666666, 0xbf96edd1,
    0x0, 0x0, 0xbf666666, 0xbf97e497,
    0x0, 0x0, 0xbf666666, 0xbf98dd5e,
    0x0, 0x0, 0xbf666666, 0xbf99d82f,
    0x0, 0x0, 0xbf666666, 0xbf9ad50f,
    0x0, 0x0, 0xbf666666, 0xbf9bd407,
    0x0, 0x0, 0xbf666666, 0xbf9cd520,
    0x0, 0x0, 0xbf666666, 0xbf9dd861,
    0x0, 0x0, 0xbf666666, 0xbf9eddd2,
    0x0, 0x0, 0xbf666666, 0xbf9fe57b,
    0x0, 0x0, 0xbf666666, 0xbfa0ef66,
    0x0, 0x0, 0xbf666666, 0xbfa1fb9b,
    0x0, 0x0, 0xbf666666, 0xbfa30a23,
    0x0, 0x0, 0xbf666666, 0xbfa41b07,
    0x0, 0x0, 0xbf666666, 0xbfa52e51,
    0x0, 0x0, 0xbf666666, 0xbfa64409,
    0x0, 0x0, 0xbf666666, 0xbfa75c3a,
    0x0, 0x0, 0xbf666666, 0xbfa876ec,
    0x0, 0x0, 0xbf666666, 0xbfa9942c,
    0x0, 0x0, 0xbf666666, 0xbfaab401,
    0x0, 0x0, 0xbf666666, 0xbfabd678,
    0x0, 0x0, 0xbf666666, 0xbfacfb9b,
    0x0, 0x0, 0xbf666666, 0xbfae2374,
    0x0, 0x0, 0xbf666666, 0xbfaf4e0e,
    0x0, 0x0, 0xbf666666, 0xbfb07b76,
    0x0, 0x0, 0xbf666666, 0xbfb1abb7,
    0x0, 0x0, 0xbf666666, 0xbfb2dedc,
    0x0, 0x0, 0xbf666666, 0xbfb414f2,
    0x0, 0x0, 0xbf666666, 0xbfb54e05,
    0x0, 0x0, 0xbf666666, 0xbfb68a22,
    0x0, 0x0, 0xbf666666, 0xbfb7c956,
    0x0, 0x0, 0xbf666666, 0xbfb90bad,
    0x0, 0x0, 0xbf666666, 0xbfba5135,
    0x0, 0x0, 0xbf666666, 0xbfbb99fd,
    0x0, 0x0, 0xbf666666, 0xbfbce612,
    0x0, 0x0, 0xbf666666, 0xbfbe3583,
    0x0, 0x0, 0xbf666666, 0xbfbf885e,
    0x0, 0x0, 0xbf666666, 0xbfc0deb3,
    0x0, 0x0, 0xbf666666, 0xbfc23890,
    0x0, 0x0, 0xbf666666, 0xbfc39607,
    0x0, 0x0, 0xbf666666, 0xbfc4f726,
    0x0, 0x0, 0xbf666666, 0xbfc65bfe,
    0x0, 0x0, 0xbf666666, 0xbfc7c4a1,
    0x0, 0x0, 0xbf666666, 0xbfc9311f,
    0x0, 0x0, 0xbf666666, 0xbfcaa18b,
    0x0, 0x0, 0xbf666666, 0xbfcc15f6,
    0x0, 0x0, 0xbf666666, 0xbfcd8e73,
    0x0, 0x0, 0xbf666666, 0xbfcf0b16,
    0x0, 0x0, 0xbf666666, 0xbfd08bf1,
    0x0, 0x0, 0xbf666666, 0xbfd21118,
    0x0, 0x0, 0xbf666666, 0xbfd39aa0,
    0x0, 0x0, 0xbf666666, 0xbfd5289e,
    0x0, 0x0, 0xbf666666, 0xbfd6bb28,
    0x0, 0x0, 0xbf666666, 0xbfd85253,
    0x0, 0x0, 0xbf666666, 0xbfd9ee35,
    0x0, 0x0, 0xbf666666, 0xbfdb8ee7,
    0x0, 0x0, 0xbf666666, 0xbfdd3480,
    0x0, 0x0, 0xbf666666, 0xbfdedf18,
    0x0, 0x0, 0xbf666666, 0xbfe08ec8,
    0x0, 0x0, 0xbf666666, 0xbfe243aa,
    0x0, 0x0, 0xbf666666, 0xbfe3fdd8,
    0x0, 0x0, 0xbf666666, 0xbfe5bd6d,
    0x0, 0x0, 0xbf666666, 0xbfe78284,
    0x0, 0x0, 0xbf666666, 0xbfe94d3b,
    0x0, 0x0, 0xbf666666, 0xbfeb1dae,
    0x0, 0x0, 0xbf666666, 0xbfecf3fc,
    0x0, 0x0, 0xbf666666, 0xbfeed042,
    0x0, 0x0, 0xbf666666, 0xbff0b2a2,
    0x0, 0x0, 0xbf666666, 0xbff29b3b,
    0x0, 0x0, 0xbf666666, 0xbff48a2f,
    0x0, 0x0, 0xbf666666, 0xbff67fa0,
    0x0, 0x0, 0xbf666666, 0xbff87bb1,
    0x0, 0x0, 0xbf666666, 0xbffa7e87,
    0x0, 0x0, 0xbf666666, 0xbffc8848,
    0x0, 0x0, 0xbf666666, 0xbffe9919,
    0x0, 0x0, 0xbf666666, 0xc0005892,
    0x0, 0x0, 0xbf666666, 0xc0016847,
    0x0, 0x0, 0xbf666666, 0xc0027bc2,
    0x0, 0x0, 0xbf666666, 0xc0039318,
    0x0, 0x0, 0xbf666666, 0xc004ae5f,
    0x0, 0x0, 0xbf666666, 0xc005cdaf,
    0x0, 0x0, 0xbf666666, 0xc006f11f,
    0x0, 0x0, 0xbf666666, 0xc00818c7,
    0x0, 0x0, 0xbf666666, 0xc00944c0,
    0x0, 0x0, 0xbf666666, 0xc00a7524,
    0x0, 0x0, 0xbf666666, 0xc00baa0f,
    0x0, 0x0, 0xbf666666, 0xc00ce39a,
    0x0, 0x0, 0xbf666666, 0xc00e21e4,
    0x0, 0x0, 0xbf666666, 0xc00f6508,
    0x0, 0x0, 0xbf666666, 0xc010ad26,
    0x0, 0x0, 0xbf666666, 0xc011fa5d,
    0x0, 0x0, 0xbf666666, 0xc0134ccd,
    0x0, 0x0, 0xbf666666, 0xc014a496,
    0x0, 0x0, 0xbf666666, 0xc01601dd,
    0x0, 0x0, 0xbf666666, 0xc01764c4,
    0x0, 0x0, 0xbf666666, 0xc018cd70,
    0x0, 0x0, 0xbf666666, 0xc01a3c07,
    0x0, 0x0, 0xbf666666, 0xc01bb0b1,
    0x0, 0x0, 0xbf666666, 0xc01d2b96,
    0x0, 0x0, 0xbf666666, 0xc01eace1,
    0x0, 0x0, 0xbf666666, 0xc02034be,
    0x0, 0x0, 0xbf666666, 0xc021c359,
    0x0, 0x0, 0xbf666666, 0xc02358e2,
    0x0, 0x0, 0xbf666666, 0xc024f58a,
    0x0, 0x0, 0xbf666666, 0xc0269982,
    0x0, 0x0, 0xbf666666, 0xc0284500,
    0x0, 0x0, 0xbf666666, 0xc029f838,
    0x0, 0x0, 0xbf666666, 0xc02bb365,
    0x0, 0x0, 0xbf666666, 0xc02d76c0,
    0x0, 0x0, 0xbf666666, 0xc02f4286,
    0x0, 0x0, 0xbf666666, 0xc03116f6,
    0x0, 0x0, 0xbf666666, 0xc032f452,
    0x0, 0x0, 0xbf666666, 0xc034dade,
    0x0, 0x0, 0xbf666666, 0xc036cae1,
    0x0, 0x0, 0xbf666666, 0xc038c4a5,
    0x0, 0x0, 0xbf666666, 0xc03ac876,
    0x0, 0x0, 0xbf666666, 0xc03cd6a6,
    0x0, 0x0, 0xbf666666, 0xc03eef86,
    0x0, 0x0, 0xbf666666, 0xc041136f,
    0x0, 0x0, 0xbf666666, 0xc04342bb,
    0x0, 0x0, 0xbf666666, 0xc0457dc9,
    0x0, 0x0, 0xbf666666, 0xc047c4fa,
    0x0, 0x0, 0xbf666666, 0xc04a18b7,
    0x0, 0x0, 0xbf666666, 0xc04c796b,
    0x0, 0x0, 0xbf666666, 0xc04ee787,
    0x0, 0x0, 0xbf666666, 0xc0516380,
    0x0, 0x0, 0xbf666666, 0xc053edd2,
    0x0, 0x0, 0xbf666666, 0xc05686fd,
    0x0, 0x0, 0xbf666666, 0xc0592f88,
    0x0, 0x0, 0xbf666666, 0xc05be801,
    0x0, 0x0, 0xbf666666, 0xc05eb0fd,
    0x0, 0x0, 0xbf666666, 0xc0618b16,
    0x0, 0x0, 0xbf666666, 0xc06476f1,
    0x0, 0x0, 0xbf666666, 0xc0677539,
    0x0, 0x0, 0xbf666666, 0xc06a86a1,
    0x0, 0x0, 0xbf666666, 0xc06dabe9,
    0x0, 0x0, 0xbf666666, 0xc070e5d7,
    0x0, 0x0, 0xbf666666, 0xc074353d,
    0x0, 0x0, 0xbf666666, 0xc0779af9,
    0x0, 0x0, 0xbf666666, 0xc07b17f5,
    0x0, 0x0, 0xbf666666, 0xc07ead26,
    0x0, 0x0, 0xbf666666, 0xc0812dc8,
    0x0, 0x0, 0xbf666666, 0xc0831224,
    0x0, 0x0, 0xbf666666, 0xc0850438,
    0x0, 0x0, 0xbf666666, 0xc087049c,
    0x0, 0x0, 0xbf666666, 0xc08913f6,
    0x0, 0x0, 0xbf666666, 0xc08b32f0,
    0x0, 0x0, 0xbf666666, 0xc08d6243,
    0x0, 0x0, 0xbf666666, 0xc08fa2b0,
    0x0, 0x0, 0xbf666666, 0xc091f508,
    0x0, 0x0, 0xbf666666, 0xc0945a26,
    0x0, 0x0, 0xbf666666, 0xc096d2f5,
    0x0, 0x0, 0xbf666666, 0xc099606e,
    0x0, 0x0, 0xbf666666, 0xc09c039c,
    0x0, 0x0, 0xbf666666, 0xc09ebd9d,
    0x0, 0x0, 0xbf666666, 0xc0a18fa1,
    0x0, 0x0, 0xbf666666, 0xc0a47aef,
    0x0, 0x0, 0xbf666666, 0xc0a780e5,
    0x0, 0x0, 0xbf666666, 0xc0aaa2fa,
    0x0, 0x0, 0xbf666666, 0xc0ade2c2,
    0x0, 0x0, 0xbf666666, 0xc0b141ef,
    0x0, 0x0, 0xbf666666, 0xc0b4c256,
    0x0, 0x0, 0xbf666666, 0xc0b865f0,
    0x0, 0x0, 0xbf666666, 0xc0bc2ee0,
    0x0, 0x0, 0xbf666666, 0xc0c01f74,
    0x0, 0x0, 0xbf666666, 0xc0c43a2d,
    0x0, 0x0, 0xbf666666, 0xc0c881c4,
    0x0, 0x0, 0xbf666666, 0xc0ccf92d,
    0x0, 0x0, 0xbf666666, 0xc0d1a3a3,
    0x0, 0x0, 0xbf666666, 0xc0d684ab,
    0x0, 0x0, 0xbf666666, 0xc0dba01e,
    0x0, 0x0, 0xbf666666, 0xc0e0fa35,
    0x0, 0x0, 0xbf666666, 0xc0e69796,
    0x0, 0x0, 0xbf666666, 0xc0ec7d5c,
    0x0, 0x0, 0xbf666666, 0xc0f2b12a,
    0x0, 0x0, 0xbf666666, 0xc0f93940,
    0x0, 0x0, 0xbf666666, 0xc1000e46,
    0x0, 0x0, 0xbf666666, 0xc103b160,
    0x0, 0x0, 0xbf666666, 0xc1078a3c,
    0x0, 0x0, 0xbf666666, 0xc10b9dab,
    0x0, 0x0, 0xbf666666, 0xc10ff113,
    0x0, 0x0, 0xbf666666, 0xc1148a8f,
    0x0, 0x0, 0xbf666666, 0xc1197101,
    0x0, 0x0, 0xbf666666, 0xc11eac3d,
    0x0, 0x0, 0xbf666666, 0xc1244531,
    0x0, 0x0, 0xbf666666, 0xc12a4615,
    0x0, 0x0, 0xbf666666, 0xc130baae,
    0x0, 0x0, 0xbf666666, 0xc137b099,
    0x0, 0x0, 0xbf666666, 0xc13f37ab,
    0x0, 0x0, 0xbf666666, 0xc147626c,
    0x0, 0x0, 0xbf666666, 0xc15046b0,
    0x0, 0x0, 0xbf666666, 0xc159fe59,
    0x0, 0x0, 0xbf666666, 0xc164a856,
    0x0, 0x0, 0xbf666666, 0xc17069ef,
    0x0, 0x0, 0xbf666666, 0xc17d707d,
    0x0, 0x0, 0xbf666666, 0xc185f9da,
    0x0, 0x0, 0xbf666666, 0xc18e1c65,
    0x0, 0x0, 0xbf666666, 0xc1974b69,
    0x0, 0x0, 0xbf666666, 0xc1a1be72,
    0x0, 0x0, 0xbf666666, 0xc1adbd7f,
    0x0, 0x0, 0xbf666666, 0xc1bba79f,
    0x0, 0x0, 0xbf666666, 0xc1cbfce9,
    0x0, 0x0, 0xbf666666, 0xc1df6e48,
    0x0, 0x0, 0xbf666666, 0xc1f6f71f,
    0x0, 0x0, 0xbf666666, 0xc20a0491,
    0x0, 0x0, 0xbf666666, 0xc21c6d96,
    0x0, 0x0, 0xbf666666, 0xc2348079,
    0x0, 0x0, 0xbf666666, 0xc2555412,
    0x0, 0x0, 0xbf666666, 0xc2825f17,
    0x0, 0x0, 0xbf666666, 0xc2a79fe8,
    0x0, 0x0, 0xbf666666, 0xc2eaadcd,
    0x0, 0x0, 0xbf666666, 0xc3439176,
    0x0, 0x0, 0xbf666666, 0xc412ad55
    };

static const uint32_t ref_cfft_step_2048[4096] = {
    0x44666666, 0x0, 0xbf666666, 0x4412ad55,
    0x0, 0x0, 0xbf666666, 0x43439176,
    0x0, 0x0, 0xbf666666, 0x42eaadcd,
    0x0, 0x0, 0xbf666666, 0x42a79fe8,
    0x0, 0x0, 0xbf666666, 0x42825f17,
    0x0, 0x0, 0xbf666666, 0x42555412,
    0x0, 0x0, 0xbf666666, 0x42348079,
    0x0, 0x0, 0xbf666666, 0x421c6d96,
    0x0, 0x0, 0xbf666666, 0x420a0491,
    0x0, 0x0, 0xbf666666, 0x41f6f71f,
    0x0, 0x0, 0xbf666666, 0x41df6e48,
    0x0, 0x0, 0xbf666666, 0x41cbfce9,
    0x0, 0x0, 0xbf666666, 0x41bba79f,
    0x0, 0x0, 0xbf666666, 0x41adbd7f,
    0x0, 0x0, 0xbf666666, 0x41a1be72,
    0x0, 0x0, 0xbf666666, 0x41974b69,
    0x0, 0x0, 0xbf666666, 0x418e1c65,
    0x0, 0x0, 0xbf666666, 0x4185f9da,
    0x0, 0x0, 0xbf666666, 0x417d707d,
    0x0, 0x0, 0xbf666666, 0x417069ef,
    0x0, 0x0, 0xbf666666, 0x4164a856,
    0x0, 0x0, 0xbf666666, 0x4159fe59,
    0x0, 0x0, 0xbf666666, 0x415046b0,
    0x0, 0x0, 0xbf666666, 0x4147626c,
    0x0, 0x0, 0xbf666666, 0x413f37ab,
    0x0, 0x0, 0xbf666666, 0x4137b099,
    0x0, 0x0, 0xbf666666, 0x4130baae,
    0x0, 0x0, 0xbf666666, 0x412a4615,
    0x0, 0x0, 0xbf666666, 0x41244531,
    0x0, 0x0, 0xbf666666, 0x411eac3d,
    0x0, 0x0, 0xbf666666, 0x41197101,
    0x0, 0x0, 0xbf666666, 0x41148a8f,
    0x0, 0x0, 0xbf666666, 0x410ff113,
    0x0, 0x0, 0xbf666666, 0x410b9dab,
    0x0, 0x0, 0xbf666666, 0x41078a3c,
    0x0, 0x0, 0xbf666666, 0x4103b160,
    0x0, 0x0, 0xbf666666, 0x41000e46,
    0x0, 0x0, 0xbf666666, 0x40f93940,
    0x0, 0x0, 0xbf666666, 0x40f2b12a,
    0x0, 0x0, 0xbf666666, 0x40ec7d5c,
    0x0, 0x0, 0xbf666666, 0x40e69796,
    0x0, 0x0, 0xbf666666, 0x40e0fa35,
    0x0, 0x0, 0xbf666666, 0x40dba01e,
    0x0, 0x0, 0xbf666666, 0x40d684ab,
    0x0, 0x0, 0xbf666666, 0x40d1a3a3,
    0x0, 0x0, 0xbf666666, 0x40ccf92d,
    0x0, 0x0, 0xbf666666, 0x40c881c4,
    0x0, 0x0, 0xbf666666, 0x40c43a2d,
    0x0, 0x0, 0xbf666666, 0x40c01f74,
    0x0, 0x0, 0xbf666666, 0x40bc2ee0,
    0x0, 0x0, 0xbf666666, 0x40b865f0,
    0x0, 0x0, 0xbf666666, 0x40b4c256,
    0x0, 0x0, 0xbf666666, 0x40b141ef,
    0x0, 0x0, 0xbf666666, 0x40ade2c2,
    0x0, 0x0, 0xbf666666, 0x40aaa2fa,
    0x0, 0x0, 0xbf666666, 0x40a780e5,
    0x0, 0x0, 0xbf666666, 0x40a47aef,
    0x0, 0x0, 0xbf666666, 0x40a18fa1,
    0x0, 0x0, 0xbf666666, 0x409ebd9d,
    0x0, 0x0, 0xbf666666, 0x409c039c,
    0x0, 0x0, 0xbf666666, 0x4099606e,
    0x0, 0x0, 0xbf666666, 0x4096d2f5,
    0x0, 0x0, 0xbf666666, 0x40945a26,
    0x0, 0x0, 0xbf666666, 0x4091f508,
    0x0, 0x0, 0xbf666666, 0x408fa2b0,
    0x0, 0x0, 0xbf666666, 0x408d6243,
    0x0, 0x0, 0xbf666666, 0x408b32f0,
    0x0, 0x0, 0xbf666666, 0x408913f6,
    0x0, 0x0, 0xbf666666, 0x4087049c,
    0x0, 0x0, 0xbf666666, 0x40850438,
    0x0, 0x0, 0xbf666666, 0x40831224,
    0x0, 0x0, 0xbf666666, 0x40812dc8,
    0x0, 0x0, 0xbf666666, 0x407ead26,
    0x0, 0x0, 0xbf666666, 0x407b17f5,
    0x0, 0x0, 0xbf666666, 0x40779af9,
    0x0, 0x0, 0xbf666666, 0x4074353d,
    0x0, 0x0, 0xbf666666, 0x4070e5d7,
    0x0, 0x0, 0xbf666666, 0x406dabe9,
    0x0, 0x0, 0xbf666666, 0x406a86a1,
    0x0, 0x0, 0xbf666666, 0x40677539,
    0x0, 0x0, 0xbf666666, 0x406476f1,
    0x0, 0x0, 0xbf666666, 0x40618b16,
    0x0, 0x0, 0xbf666666, 0x405eb0fd,
    0x0, 0x0, 0xbf666666, 0x405be801,
    0x0, 0x0, 0xbf666666, 0x40592f88,
    0x0, 0x0, 0xbf666666, 0x405686fd,
    0x0, 0x0, 0xbf666666, 0x4053edd2,
    0x0, 0x0, 0xbf666666, 0x40516380,
    0x0, 0x0, 0xbf666666, 0x404ee787,
    0x0, 0x0, 0xbf666666, 0x404c796b,
    0x0, 0x0, 0xbf666666, 0x404a18b7,
    0x0, 0x0, 0xbf666666, 0x4047c4fa,
    0x0, 0x0, 0xbf666666, 0x40457dc9,
    0x0, 0x0, 0xbf666666, 0x404342bb,
    0x0, 0x0, 0xbf666666, 0x4041136f,
    0x0, 0x0, 0xbf666666, 0x403eef86,
    0x0, 0x0, 0xbf666666, 0x403cd6a6,
    0x0, 0x0, 0xbf666666, 0x403ac876,
    0x0, 0x0, 0xbf666666, 0x4038c4a5,
    0x0, 0x0, 0xbf666666, 0x4036cae1,
    0x0, 0x0, 0xbf666666, 0x4034dade,
    0x0, 0x0, 0xbf666666, 0x4032f452,
    0x0, 0x0, 0xbf666666, 0x403116f6,
    0x0, 0x0, 0xbf666666, 0x402f4286,
    0x0, 0x0, 0xbf666666, 0x402d76c0,
    0x0, 0x0, 0xbf666666, 0x402bb365,
    0x0, 0x0, 0xbf666666, 0x4029f838,
    0x0, 0x0, 0xbf666666, 0x40284500,
    0x0, 0x0, 0xbf666666, 0x40269982,
    0x0, 0x0, 0xbf666666, 0x4024f58a,
    0x0, 0x0, 0xbf666666, 0x402358e2,
    0x0, 0x0, 0xbf666666, 0x4021c359,
    0x0, 0x0, 0xbf666666, 0x402034be,
    0x0, 0x0, 0xbf666666, 0x401eace1,
    0x0, 0x0, 0xbf666666, 0x401d2b96,
    0x0, 0x0, 0xbf666666, 0x401bb0b1,
    0x0, 0x0, 0xbf666666, 0x401a3c07,
    0x0, 0x0, 0xbf666666, 0x4018cd70,
    0x0, 0x0, 0xbf666666, 0x401764c4,
    0x0, 0x0, 0xbf666666, 0x401601dd,
    0x0, 0x0, 0xbf666666, 0x4014a496,
    0x0, 0x0, 0xbf666666, 0x40134ccd,
    0x0, 0x0, 0xbf666666, 0x4011fa5d,
    0x0, 0x0, 0xbf666666, 0x4010ad26,
    0x0, 0x0, 0xbf666666, 0x400f6508,
    0x0, 0x0, 0xbf666666, 0x400e21e4,
    0x0, 0x0, 0xbf666666, 0x400ce39a,
    0x0, 0x0, 0xbf666666, 0x400baa0f,
    0x0, 0x0, 0xbf666666, 0x400a7524,
    0x0, 0x0, 0xbf666666, 0x400944c0,
    0x0, 0x0, 0xbf666666, 0x400818c7,
    0x0, 0x0, 0xbf666666, 0x4006f11f,
    0x0, 0x0, 0xbf666666, 0x4005cdaf,
    0x0, 0x0, 0xbf666666, 0x4004ae5f,
    0x0, 0x0, 0xbf666666, 0x40039318,
    0x0, 0x0, 0xbf666666, 0x40027bc2,
    0x0, 0x0, 0xbf666666, 0x40016847,
    0x0, 0x0, 0xbf666666, 0x40005892,
    0x0, 0x0, 0xbf666666, 0x3ffe9919,
    0x0, 0x0, 0xbf666666, 0x3ffc8848,
    0x0, 0x0, 0xbf666666, 0x3ffa7e87,
    0x0, 0x0, 0xbf666666, 0x3ff87bb1,
    0x0, 0x0, 0xbf666666, 0x3ff67fa0,
    0x0, 0x0, 0xbf666666, 0x3ff48a2f,
    0x0, 0x0, 0xbf666666, 0x3ff29b3b,
    0x0, 0x0, 0xbf666666, 0x3ff0b2a2,
    0x0, 0x0, 0xbf666666, 0x3feed042,
    0x0, 0x0, 0xbf666666, 0x3fecf3fc,
    0x0, 0x0, 0xbf666666, 0x3feb1dae,
    0x0, 0x0, 0xbf666666, 0x3fe94d3b,
    0x0, 0x0, 0xbf666666, 0x3fe78284,
    0x0, 0x0, 0xbf666666, 0x3fe5bd6d,
    0x0, 0x0, 0xbf666666, 0x3fe3fdd8,
    0x0, 0x0, 0xbf666666, 0x3fe243aa,
    0x0, 0x0, 0xbf666666, 0x3fe08ec8,
    0x0, 0x0, 0xbf666666, 0x3fdedf18,
    0x0, 0x0, 0xbf666666, 0x3fdd3480,
    0x0, 0x0, 0xbf666666, 0x3fdb8ee7,
    0x0, 0x0, 0xbf666666, 0x3fd9ee35,
    0x0, 0x0, 0xbf666666, 0x3fd85253,
    0x0, 0x0, 0xbf666666, 0x3fd6bb28,
    0x0, 0x0, 0xbf666666, 0x3fd5289e,
    0x0, 0x0, 0xbf666666, 0x3fd39aa0,
    0x0, 0x0, 0xbf666666, 0x3fd21118,
    0x0, 0x0, 0xbf666666, 0x3fd08bf1,
    0x0, 0x0, 0xbf666666, 0x3fcf0b16,
    0x0, 0x0, 0xbf666666, 0x3fcd8e73,
    0x0, 0x0, 0xbf666666, 0x3fcc15f6,
    0x0, 0x0, 0xbf666666, 0x3fcaa18b,
    0x0, 0x0, 0xbf666666, 0x3fc9311f,
    0x0, 0x0, 0xbf666666, 0x3fc7c4a1,
    0x0, 0x0, 0xbf666666, 0x3fc65bfe,
    0x0, 0x0, 0xbf666666, 0x3fc4f726,
    0x0, 0x0, 0xbf666666, 0x3fc39607,
    0x0, 0x0, 0xbf666666, 0x3fc23890,
    0x0, 0x0, 0xbf666666, 0x3fc0deb3,
    0x0, 0x0, 0xbf666666, 0x3fbf885e,
    0x0, 0x0, 0xbf666666, 0x3fbe3583,
    0x0, 0x0, 0xbf666666, 0x3fbce612,
    0x0, 0x0, 0xbf666666, 0x3fbb99fd,
    0x0, 0x0, 0xbf666666, 0x3fba5135,
    0x0, 0x0, 0xbf666666, 0x3fb90bad,
    0x0, 0x0, 0xbf666666, 0x3fb7c956,
    0x0, 0x0, 0xbf666666, 0x3fb68a22,
    0x0, 0x0, 0xbf666666, 0x3fb54e05,
    0x0, 0x0, 0xbf666666, 0x3fb414f2,
    0x0, 0x0, 0xbf666666, 0x3fb2dedc,
    0x0, 0x0, 0xbf666666, 0x3fb1abb7,
    0x0, 0x0, 0xbf666666, 0x3fb07b76,
    0x0, 0x0, 0xbf666666, 0x3faf4e0e,
    0x0, 0x0, 0xbf666666, 0x3fae2374,
    0x0, 0x0, 0xbf666666, 0x3facfb9b,
    0x0, 0x0, 0xbf666666, 0x3fabd678,
    0x0, 0x0, 0xbf666666, 0x3faab401,
    0x0, 0x0, 0xbf666666, 0x3fa9942c,
    0x0, 0x0, 0xbf666666, 0x3fa876ec,
    0x0, 0x0, 0xbf666666, 0x3fa75c3a,
    0x0, 0x0, 0xbf666666, 0x3fa64409,
    0x0, 0x0, 0xbf666666, 0x3fa52e51,
    0x0, 0x0, 0xbf666666, 0x3fa41b07,
    0x0, 0x0, 0xbf666666, 0x3fa30a23,
    0x0, 0x0, 0xbf666666, 0x3fa1fb9b,
    0x0, 0x0, 0xbf666666, 0x3fa0ef66,
    0x0, 0x0, 0xbf666666, 0x3f9fe57b,
    0x0, 0x0, 0xbf666666, 0x3f9eddd2,
    0x0, 0x0, 0xbf666666, 0x3f9dd861,
    0x0, 0x0, 0xbf666666, 0x3f9cd520,
    0x0, 0x0, 0xbf666666, 0x3f9bd407,
    0x0, 0x0, 0xbf666666, 0x3f9ad50f,
    0x0, 0x0, 0xbf666666, 0x3f99d82f,
    0x0, 0x0, 0xbf666666, 0x3f98dd5e,
    0x0, 0x0, 0xbf666666, 0x3f97e497,
    0x0, 0x0, 0xbf666666, 0x3f96edd1,
    0x0, 0x0, 0xbf666666, 0x3f95f904,
    0x0, 0x0, 0xbf666666, 0x3f95062a,
    0x0, 0x0, 0xbf666666, 0x3f94153c,
    0x0, 0x0, 0xbf666666, 0x3f932632,
    0x0, 0x0, 0xbf666666, 0x3f923906,
    0x0, 0x0, 0xbf666666, 0x3f914db1,
    0x0, 0x0, 0xbf666666, 0x3f90642d,
    0x0, 0x0, 0xbf666666, 0x3f8f7c72,
    0x0, 0x0, 0xbf666666, 0x3f8e967b,
    0x0, 0x0, 0xbf666666, 0x3f8db242,
    0x0, 0x0, 0xbf666666, 0x3f8ccfc0,
    0x0, 0x0, 0xbf666666, 0x3f8beeef,
    0x0, 0x0, 0xbf666666, 0x3f8b0fc9,
    0x0, 0x0, 0xbf666666, 0x3f8a3249,
    0x0, 0x0, 0xbf666666, 0x3f895669,
    0x0, 0x0, 0xbf666666, 0x3f887c24,
    0x0, 0x0, 0xbf666666, 0x3f87a372,
    0x0, 0x0, 0xbf666666, 0x3f86cc51,
    0x0, 0x0, 0xbf666666, 0x3f85f6b9,
    0x0, 0x0, 0xbf666666, 0x3f8522a6,
    0x0, 0x0, 0xbf666666, 0x3f845013,
    0x0, 0x0, 0xbf666666, 0x3f837efa,
    0x0, 0x0, 0xbf666666, 0x3f82af57,
    0x0, 0x0, 0xbf666666, 0x3f81e124,
    0x0, 0x0, 0xbf666666, 0x3f81145e,
    0x0, 0x0, 0xbf666666, 0x3f8048fe,
    0x0, 0x0, 0xbf666666, 0x3f7efe03,
    0x0, 0x0, 0xbf666666, 0x3f7d6cc5,
    0x0, 0x0, 0xbf666666, 0x3f7bde3a,
    0x0, 0x0, 0xbf666666, 0x3f7a5259,
    0x0, 0x0, 0xbf666666, 0x3f78c91a,
    0x0, 0x0, 0xbf666666, 0x3f774273,
    0x0, 0x0, 0xbf666666, 0x3f75be5d,
    0x0, 0x0, 0xbf666666, 0x3f743ccf,
    0x0, 0x0, 0xbf666666, 0x3f72bdc1,
    0x0, 0x0, 0xbf666666, 0x3f71412a,
    0x0, 0x0, 0xbf666666, 0x3f6fc704,
    0x0, 0x0, 0xbf666666, 0x3f6e4f46,
    0x0, 0x0, 0xbf666666, 0x3f6cd9e8,
    0x0, 0x0, 0xbf666666, 0x3f6b66e4,
    0x0, 0x0, 0xbf666666, 0x3f69f631,
    0x0, 0x0, 0xbf666666, 0x3f6887c8,
    0x0, 0x0, 0xbf666666, 0x3f671ba2,
    0x0, 0x0, 0xbf666666, 0x3f65b1b9,
    0x0, 0x0, 0xbf666666, 0x3f644a04,
    0x0, 0x0, 0xbf666666, 0x3f62e47e,
    0x0, 0x0, 0xbf666666, 0x3f61811f,
    0x0, 0x0, 0xbf666666, 0x3f601fe0,
    0x0, 0x0, 0xbf666666, 0x3f5ec0bc,
    0x0, 0x0, 0xbf666666, 0x3f5d63ab,
    0x0, 0x0, 0xbf666666, 0x3f5c08a8,
    0x0, 0x0, 0xbf666666, 0x3f5aafac,
    0x0, 0x0, 0xbf666666, 0x3f5958b1,
    0x0, 0x0, 0xbf666666, 0x3f5803b0,
    0x0, 0x0, 0xbf666666, 0x3f56b0a5,
    0x0, 0x0, 0xbf666666, 0x3f555f88,
    0x0, 0x0, 0xbf666666, 0x3f541054,
    0x0, 0x0, 0xbf666666, 0x3f52c303,
    0x0, 0x0, 0xbf666666, 0x3f517790,
    0x0, 0x0, 0xbf666666, 0x3f502df5,
    0x0, 0x0, 0xbf666666, 0x3f4ee62d,
    0x0, 0x0, 0xbf666666, 0x3f4da031,
    0x0, 0x0, 0xbf666666, 0x3f4c5bfe,
    0x0, 0x0, 0xbf666666, 0x3f4b198c,
    0x0, 0x0, 0xbf666666, 0x3f49d8d9,
    0x0, 0x0, 0xbf666666, 0x3f4899dd,
    0x0, 0x0, 0xbf666666, 0x3f475c94,
    0x0, 0x0, 0xbf666666, 0x3f4620fa,
    0x0, 0x0, 0xbf666666, 0x3f44e708,
    0x0, 0x0, 0xbf666666, 0x3f43aebb,
    0x0, 0x0, 0xbf666666, 0x3f42780e,
    0x0, 0x0, 0xbf666666, 0x3f4142fb,
    0x0, 0x0, 0xbf666666, 0x3f400f7f,
    0x0, 0x0, 0xbf666666, 0x3f3edd94,
    0x0, 0x0, 0xbf666666, 0x3f3dad36,
    0x0, 0x0, 0xbf666666, 0x3f3c7e61,
    0x0, 0x0, 0xbf666666, 0x3f3b5110,
    0x0, 0x0, 0xbf666666, 0x3f3a253f,
    0x0, 0x0, 0xbf666666, 0x3f38fae9,
    0x0, 0x0, 0xbf666666, 0x3f37d20b,
    0x0, 0x0, 0xbf666666, 0x3f36aaa0,
    0x0, 0x0, 0xbf666666, 0x3f3584a4,
    0x0, 0x0, 0xbf666666, 0x3f346013,
    0x0, 0x0, 0xbf666666, 0x3f333ce9,
    0x0, 0x0, 0xbf666666, 0x3f321b21,
    0x0, 0x0, 0xbf666666, 0x3f30fab9,
    0x0, 0x0, 0xbf666666, 0x3f2fdbac,
    0x0, 0x0, 0xbf666666, 0x3f2ebdf6,
    0x0, 0x0, 0xbf666666, 0x3f2da194,
    0x0, 0x0, 0xbf666666, 0x3f2c8682,
    0x0, 0x0, 0xbf666666, 0x3f2b6cbc,
    0x0, 0x0, 0xbf666666, 0x3f2a543e,
    0x0, 0x0, 0xbf666666, 0x3f293d06,
    0x0, 0x0, 0xbf666666, 0x3f28270f,
    0x0, 0x0, 0xbf666666, 0x3f271256,
    0x0, 0x0, 0xbf666666, 0x3f25fed7,
    0x0, 0x0, 0xbf666666, 0x3f24ec90,
    0x0, 0x0, 0xbf666666, 0x3f23db7c,
    0x0, 0x0, 0xbf666666, 0x3f22cb98,
    0x0, 0x0, 0xbf666666, 0x3f21bce2,
    0x0, 0x0, 0xbf666666, 0x3f20af56,
    0x0, 0x0, 0xbf666666, 0x3f1fa2f0,
    0x0, 0x0, 0xbf666666, 0x3f1e97ae,
    0x0, 0x0, 0xbf666666, 0x3f1d8d8c,
    0x0, 0x0, 0xbf666666, 0x3f1c8487,
    0x0, 0x0, 0xbf666666, 0x3f1b7c9d,
    0x0, 0x0, 0xbf666666, 0x3f1a75c9,
    0x0, 0x0, 0xbf666666, 0x3f19700a,
    0x0, 0x0, 0xbf666666, 0x3f186b5d,
    0x0, 0x0, 0xbf666666, 0x3f1767bd,
    0x0, 0x0, 0xbf666666, 0x3f166529,
    0x0, 0x0, 0xbf666666, 0x3f15639e,
    0x0, 0x0, 0xbf666666, 0x3f146318,
    0x0, 0x0, 0xbf666666, 0x3f136396,
    0x0, 0x0, 0xbf666666, 0x3f126513,
    0x0, 0x0, 0xbf666666, 0x3f11678e,
    0x0, 0x0, 0xbf666666, 0x3f106b05,
    0x0, 0x0, 0xbf666666, 0x3f0f6f73,
    0x0, 0x0, 0xbf666666, 0x3f0e74d6,
    0x0, 0x0, 0xbf666666, 0x3f0d7b2d,
    0x0, 0x0, 0xbf666666, 0x3f0c8274,
    0x0, 0x0, 0xbf666666, 0x3f0b8aa9,
    0x0, 0x0, 0xbf666666, 0x3f0a93c9,
    0x0, 0x0, 0xbf666666, 0x3f099dd2,
    0x0, 0x0, 0xbf666666, 0x3f08a8c1,
    0x0, 0x0, 0xbf666666, 0x3f07b495,
    0x0, 0x0, 0xbf666666, 0x3f06c149,
    0x0, 0x0, 0xbf666666, 0x3f05cedd,
    0x0, 0x0, 0xbf666666, 0x3f04dd4e,
    0x0, 0x0, 0xbf666666, 0x3f03ec99,
    0x0, 0x0, 0xbf666666, 0x3f02fcbc,
    0x0, 0x0, 0xbf666666, 0x3f020db5,
    0x0, 0x0, 0xbf666666, 0x3f011f82,
    0x0, 0x0, 0xbf666666, 0x3f00321f,
    0x0, 0x0, 0xbf666666, 0x3efe8b19,
    0x0, 0x0, 0xbf666666, 0x3efcb38d,
    0x0, 0x0, 0xbf666666, 0x3efadd96,
    0x0, 0x0, 0xbf666666, 0x3ef90931,
    0x0, 0x0, 0xbf666666, 0x3ef73658,
    0x0, 0x0, 0xbf666666, 0x3ef56509,
    0x0, 0x0, 0xbf666666, 0x3ef3953e,
    0x0, 0x0, 0xbf666666, 0x3ef1c6f3,
    0x0, 0x0, 0xbf666666, 0x3eeffa25,
    0x0, 0x0, 0xbf666666, 0x3eee2ecf,
    0x0, 0x0, 0xbf666666, 0x3eec64ee,
    0x0, 0x0, 0xbf666666, 0x3eea9c7d,
    0x0, 0x0, 0xbf666666, 0x3ee8d578,
    0x0, 0x0, 0xbf666666, 0x3ee70fdc,
    0x0, 0x0, 0xbf666666, 0x3ee54ba5,
    0x0, 0x0, 0xbf666666, 0x3ee388cf,
    0x0, 0x0, 0xbf666666, 0x3ee1c756,
    0x0, 0x0, 0xbf666666, 0x3ee00736,
    0x0, 0x0, 0xbf666666, 0x3ede486c,
    0x0, 0x0, 0xbf666666, 0x3edc8af4,
    0x0, 0x0, 0xbf666666, 0x3edaceca,
    0x0, 0x0, 0xbf666666, 0x3ed913ec,
    0x0, 0x0, 0xbf666666, 0x3ed75a54,
    0x0, 0x0, 0xbf666666, 0x3ed5a200,
    0x0, 0x0, 0xbf666666, 0x3ed3eaed,
    0x0, 0x0, 0xbf666666, 0x3ed23516,
    0x0, 0x0, 0xbf666666, 0x3ed08079,
    0x0, 0x0, 0xbf666666, 0x3ececd11,
    0x0, 0x0, 0xbf666666, 0x3ecd1adc,
    0x0, 0x0, 0xbf666666, 0x3ecb69d6,
    0x0, 0x0, 0xbf666666, 0x3ec9b9fc,
    0x0, 0x0, 0xbf666666, 0x3ec80b4a,
    0x0, 0x0, 0xbf666666, 0x3ec65dbe,
    0x0, 0x0, 0xbf666666, 0x3ec4b154,
    0x0, 0x0, 0xbf666666, 0x3ec30609,
    0x0, 0x0, 0xbf666666, 0x3ec15bd9,
    0x0, 0x0, 0xbf666666, 0x3ebfb2c2,
    0x0, 0x0, 0xbf666666, 0x3ebe0ac0,
    0x0, 0x0, 0xbf666666, 0x3ebc63d1,
    0x0, 0x0, 0xbf666666, 0x3ebabdf1,
    0x0, 0x0, 0xbf666666, 0x3eb9191d,
    0x0, 0x0, 0xbf666666, 0x3eb77553,
    0x0, 0x0, 0xbf666666, 0x3eb5d28f,
    0x0, 0x0, 0xbf666666, 0x3eb430cd,
    0x0, 0x0, 0xbf666666, 0x3eb2900d,
    0x0, 0x0, 0xbf666666, 0x3eb0f049,
    0x0, 0x0, 0xbf666666, 0x3eaf5180,
    0x0, 0x0, 0xbf666666, 0x3eadb3af,
    0x0, 0x0, 0xbf666666, 0x3eac16d2,
    0x0, 0x0, 0xbf666666, 0x3eaa7ae8,
    0x0, 0x0, 0xbf666666, 0x3ea8dfec,
    0x0, 0x0, 0xbf666666, 0x3ea745dd,
    0x0, 0x0, 0xbf666666, 0x3ea5acb7,
    0x0, 0x0, 0xbf666666, 0x3ea41478,
    0x0, 0x0, 0xbf666666, 0x3ea27d1d,
    0x0, 0x0, 0xbf666666, 0x3ea0e6a4,
    0x0, 0x0, 0xbf666666, 0x3e9f5109,
    0x0, 0x0, 0xbf666666, 0x3e9dbc4b,
    0x0, 0x0, 0xbf666666, 0x3e9c2865,
    0x0, 0x0, 0xbf666666, 0x3e9a9557,
    0x0, 0x0, 0xbf666666, 0x3e99031d,
    0x0, 0x0, 0xbf666666, 0x3e9771b4,
    0x0, 0x0, 0xbf666666, 0x3e95e11a,
    0x0, 0x0, 0xbf666666, 0x3e94514d,
    0x0, 0x0, 0xbf666666, 0x3e92c24a,
    0x0, 0x0, 0xbf666666, 0x3e91340e,
    0x0, 0x0, 0xbf666666, 0x3e8fa697,
    0x0, 0x0, 0xbf666666, 0x3e8e19e3,
    0x0, 0x0, 0xbf666666, 0x3e8c8dee,
    0x0, 0x0, 0xbf666666, 0x3e8b02b7,
    0x0, 0x0, 0xbf666666, 0x3e89783b,
    0x0, 0x0, 0xbf666666, 0x3e87ee78,
    0x0, 0x0, 0xbf666666, 0x3e86656b,
    0x0, 0x0, 0xbf666666, 0x3e84dd12,
    0x0, 0x0, 0xbf666666, 0x3e83556b,
    0x0, 0x0, 0xbf666666, 0x3e81ce73,
    0x0, 0x0, 0xbf666666, 0x3e804827,
    0x0, 0x0, 0xbf666666, 0x3e7d850d,
    0x0, 0x0, 0xbf666666, 0x3e7a7b1c,
    0x0, 0x0, 0xbf666666, 0x3e777276,
    0x0, 0x0, 0xbf666666, 0x3e746b18,
    0x0, 0x0, 0xbf666666, 0x3e7164fd,
    0x0, 0x0, 0xbf666666, 0x3e6e6020,
    0x0, 0x0, 0xbf666666, 0x3e6b5c7c,
    0x0, 0x0, 0xbf666666, 0x3e685a0e,
    0x0, 0x0, 0xbf666666, 0x3e6558d1,
    0x0, 0x0, 0xbf666666, 0x3e6258c0,
    0x0, 0x0, 0xbf666666, 0x3e5f59d8,
    0x0, 0x0, 0xbf666666, 0x3e5c5c13,
    0x0, 0x0, 0xbf666666, 0x3e595f6d,
    0x0, 0x0, 0xbf666666, 0x3e5663e3,
    0x0, 0x0, 0xbf666666, 0x3e53696f,
    0x0, 0x0, 0xbf666666, 0x3e50700e,
    0x0, 0x0, 0xbf666666, 0x3e4d77bc,
    0x0, 0x0, 0xbf666666, 0x3e4a8073,
    0x0, 0x0, 0xbf666666, 0x3e478a30,
    0x0, 0x0, 0xbf666666, 0x3e4494ef,
    0x0, 0x0, 0xbf666666, 0x3e41a0ac,
    0x0, 0x0, 0xbf666666, 0x3e3ead62,
    0x0, 0x0, 0xbf666666, 0x3e3bbb0d,
    0x0, 0x0, 0xbf666666, 0x3e38c9a9,
    0x0, 0x0, 0xbf666666, 0x3e35d933,
    0x0, 0x0, 0xbf666666, 0x3e32e9a6,
    0x0, 0x0, 0xbf666666, 0x3e2ffafd,
    0x0, 0x0, 0xbf666666, 0x3e2d0d36,
    0x0, 0x0, 0xbf666666, 0x3e2a204c,
    0x0, 0x0, 0xbf666666, 0x3e27343b,
    0x0, 0x0, 0xbf666666, 0x3e2448ff,
    0x0, 0x0, 0xbf666666, 0x3e215e94,
    0x0, 0x0, 0xbf666666, 0x3e1e74f6,
    0x0, 0x0, 0xbf666666, 0x3e1b8c21,
    0x0, 0x0, 0xbf666666, 0x3e18a412,
    0x0, 0x0, 0xbf666666, 0x3e15bcc4,
    0x0, 0x0, 0xbf666666, 0x3e12d634,
    0x0, 0x0, 0xbf666666, 0x3e0ff05e,
    0x0, 0x0, 0xbf666666, 0x3e0d0b3e,
    0x0, 0x0, 0xbf666666, 0x3e0a26cf,
    0x0, 0x0, 0xbf666666, 0x3e07430f,
    0x0, 0x0, 0xbf666666, 0x3e045ffa,
    0x0, 0x0, 0xbf666666, 0x3e017d8b,
    0x0, 0x0, 0xbf666666, 0x3dfd377d,
    0x0, 0x0, 0xbf666666, 0x3df77524,
    0x0, 0x0, 0xbf666666, 0x3df1b401,
    0x0, 0x0, 0xbf666666, 0x3debf40d,
    0x0, 0x0, 0xbf666666, 0x3de63541,
    0x0, 0x0, 0xbf666666, 0x3de07796,
    0x0, 0x0, 0xbf666666, 0x3ddabb04,
    0x0, 0x0, 0xbf666666, 0x3dd4ff83,
    0x0, 0x0, 0xbf666666, 0x3dcf450d,
    0x0, 0x0, 0xbf666666, 0x3dc98b99,
    0x0, 0x0, 0xbf666666, 0x3dc3d322,
    0x0, 0x0, 0xbf666666, 0x3dbe1b9e,
    0x0, 0x0, 0xbf666666, 0x3db86508,
    0x0, 0x0, 0xbf666666, 0x3db2af57,
    0x0, 0x0, 0xbf666666, 0x3dacfa85,
    0x0, 0x0, 0xbf666666, 0x3da7468a,
    0x0, 0x0, 0xbf666666, 0x3da1935f,
    0x0, 0x0, 0xbf666666, 0x3d9be0fd,
    0x0, 0x0, 0xbf666666, 0x3d962f5d,
    0x0, 0x0, 0xbf666666, 0x3d907e77,
    0x0, 0x0, 0xbf666666, 0x3d8ace45,
    0x0, 0x0, 0xbf666666, 0x3d851ebf,
    0x0, 0x0, 0xbf666666, 0x3d7edfbc,
    0x0, 0x0, 0xbf666666, 0x3d738336,
    0x0, 0x0, 0xbf666666, 0x3d6827dd,
    0x0, 0x0, 0xbf666666, 0x3d5ccda4,
    0x0, 0x0, 0xbf666666, 0x3d51747d,
    0x0, 0x0, 0xbf666666, 0x3d461c59,
    0x0, 0x0, 0xbf666666, 0x3d3ac52a,
    0x0, 0x0, 0xbf666666, 0x3d2f6ee1,
    0x0, 0x0, 0xbf666666, 0x3d241972,
    0x0, 0x0, 0xbf666666, 0x3d18c4ce,
    0x0, 0x0, 0xbf666666, 0x3d0d70e6,
    0x0, 0x0, 0xbf666666, 0x3d021dae,
    0x0, 0x0, 0xbf666666, 0x3ced962b,
    0x0, 0x0, 0xbf666666, 0x3cd6f220,
    0x0, 0x0, 0xbf666666, 0x3cc04f1f,
    0x0, 0x0, 0xbf666666, 0x3ca9ad0b,
    0x0, 0x0, 0xbf666666, 0x3c930bc9,
    0x0, 0x0, 0xbf666666, 0x3c78d677,
    0x0, 0x0, 0xbf666666, 0x3c4b9690,
    0x0, 0x0, 0xbf666666, 0x3c1e57a5,
    0x0, 0x0, 0xbf666666, 0x3be232f9,
    0x0, 0x0, 0xbf666666, 0x3b87b7bf,
    0x0, 0x0, 0xbf666666, 0x3ab4f4b4,
    0x0, 0x0, 0xbf666666, 0xbab4f4b4,
    0x0, 0x0, 0xbf666666, 0xbb87b7bf,
    0x0, 0x0, 0xbf666666, 0xbbe232f9,
    0x0, 0x0, 0xbf666666, 0xbc1e57a5,
    0x0, 0x0, 0xbf666666, 0xbc4b9690,
    0x0, 0x0, 0xbf666666, 0xbc78d677,
    0x0, 0x0, 0xbf666666, 0xbc930bc9,
    0x0, 0x0, 0xbf666666, 0xbca9ad0b,
    0x0, 0x0, 0xbf666666, 0xbcc04f1f,
    0x0, 0x0, 0xbf666666, 0xbcd6f220,
    0x0, 0x0, 0xbf666666, 0xbced962b,
    0x0, 0x0, 0xbf666666, 0xbd021dae,
    0x0, 0x0, 0xbf666666, 0xbd0d70e6,
    0x0, 0x0, 0xbf666666, 0xbd18c4ce,
    0x0, 0x0, 0xbf666666, 0xbd241972,
    0x0, 0x0, 0xbf666666, 0xbd2f6ee1,
    0x0, 0x0, 0xbf666666, 0xbd3ac52a,
    0x0, 0x0, 0xbf666666, 0xbd461c59,
    0x0, 0x0, 0xbf666666, 0xbd51747d,
    0x0, 0x0, 0xbf666666, 0xbd5ccda4,
    0x0, 0x0, 0xbf666666, 0xbd6827dd,
    0x0, 0x0, 0xbf666666, 0xbd738336,
    0x0, 0x0, 0xbf666666, 0xbd7edfbc,
    0x0, 0x0, 0xbf666666, 0xbd851ebf,
    0x0, 0x0, 0xbf666666, 0xbd8ace45,
    0x0, 0x0, 0xbf666666, 0xbd907e77,
    0x0, 0x0, 0xbf666666, 0xbd962f5d,
    0x0, 0x0, 0xbf666666, 0xbd9be0fd,
    0x0, 0x0, 0xbf666666, 0xbda1935f,
    0x0, 0x0, 0xbf666666, 0xbda7468a,
    0x0, 0x0, 0xbf666666, 0xbdacfa85,
    0x0, 0x0, 0xbf666666, 0xbdb2af57,
    0x0, 0x0, 0xbf666666, 0xbdb86508,
    0x0, 0x0, 0xbf666666, 0xbdbe1b9e,
    0x0, 0x0, 0xbf666666, 0xbdc3d322,
    0x0, 0x0, 0xbf666666, 0xbdc98b99,
    0x0, 0x0, 0xbf666666, 0xbdcf450d,
    0x0, 0x0, 0xbf666666, 0xbdd4ff83,
    0x0, 0x0, 0xbf666666, 0xbddabb04,
    0x0, 0x0, 0xbf666666, 0xbde07796,
    0x0, 0x0, 0xbf666666, 0xbde63541,
    0x0, 0x0, 0xbf666666, 0xbdebf40d,
    0x0, 0x0, 0xbf666666, 0xbdf1b401,
    0x0, 0x0, 0xbf666666, 0xbdf77524,
    0x0, 0x0, 0xbf666666, 0xbdfd377d,
    0x0, 0x0, 0xbf666666, 0xbe017d8b,
    0x0, 0x0, 0xbf666666, 0xbe045ffa,
    0x0, 0x0, 0xbf666666, 0xbe07430f,
    0x0, 0x0, 0xbf666666, 0xbe0a26cf,
    0x0, 0x0, 0xbf666666, 0xbe0d0b3e,
    0x0, 0x0, 0xbf666666, 0xbe0ff05e,
    0x0, 0x0, 0xbf666666, 0xbe12d634,
    0x0, 0x0, 0xbf666666, 0xbe15bcc4,
    0x0, 0x0, 0xbf666666, 0xbe18a412,
    0x0, 0x0, 0xbf666666, 0xbe1b8c21,
    0x0, 0x0, 0xbf666666, 0xbe1e74f6,
    0x0, 0x0, 0xbf666666, 0xbe215e94,
    0x0, 0x0, 0xbf666666, 0xbe2448ff,
    0x0, 0x0, 0xbf666666, 0xbe27343b,
    0x0, 0x0, 0xbf666666, 0xbe2a204c,
    0x0, 0x0, 0xbf666666, 0xbe2d0d36,
    0x0, 0x0, 0xbf666666, 0xbe2ffafd,
    0x0, 0x0, 0xbf666666, 0xbe32e9a6,
    0x0, 0x0, 0xbf666666, 0xbe35d933,
    0x0, 0x0, 0xbf666666, 0xbe38c9a9,
    0x0, 0x0, 0xbf666666, 0xbe3bbb0d,
    0x0, 0x0, 0xbf666666, 0xbe3ead62,
    0x0, 0x0, 0xbf666666, 0xbe41a0ac,
    0x0, 0x0, 0xbf666666, 0xbe4494ef,
    0x0, 0x0, 0xbf666666, 0xbe478a30,
    0x0, 0x0, 0xbf666666, 0xbe4a8073,
    0x0, 0x0, 0xbf666666, 0xbe4d77bc,
    0x0, 0x0, 0xbf666666, 0xbe50700e,
    0x0, 0x0, 0xbf666666, 0xbe53696f,
    0x0, 0x0, 0xbf666666, 0xbe5663e3,
    0x0, 0x0, 0xbf666666, 0xbe595f6d,
    0x0, 0x0, 0xbf666666, 0xbe5c5c13,
    0x0, 0x0, 0xbf666666, 0xbe5f59d8,
    0x0, 0x0, 0xbf666666, 0xbe6258c0,
    0x0, 0x0, 0xbf666666, 0xbe6558d1,
    0x0, 0x0, 0xbf666666, 0xbe685a0e,
    0x0, 0x0, 0xbf666666, 0xbe6b5c7c,
    0x0, 0x0, 0xbf666666, 0xbe6e6020,
    0x0, 0x0, 0xbf666666, 0xbe7164fd,
    0x0, 0x0, 0xbf666666, 0xbe746b18,
    0x0, 0x0, 0xbf666666, 0xbe777276,
    0x0, 0x0, 0xbf666666, 0xbe7a7b1c,
    0x0, 0x0, 0xbf666666, 0xbe7d850d,
    0x0, 0x0, 0xbf666666, 0xbe804827,
    0x0, 0x0, 0xbf666666, 0xbe81ce73,
    0x0, 0x0, 0xbf666666, 0xbe83556b,
    0x0, 0x0, 0xbf666666, 0xbe84dd12,
    0x0, 0x0, 0xbf666666, 0xbe86656b,
    0x0, 0x0, 0xbf666666, 0xbe87ee78,
    0x0, 0x0, 0xbf666666, 0xbe89783b,
    0x0, 0x0, 0xbf666666, 0xbe8b02b7,
    0x0, 0x0, 0xbf666666, 0xbe8c8dee,
    0x0, 0x0, 0xbf666666, 0xbe8e19e3,
    0x0, 0x0, 0xbf666666, 0xbe8fa697,
    0x0, 0x0, 0xbf666666, 0xbe91340e,
    0x0, 0x0, 0xbf666666, 0xbe92c24a,
    0x0, 0x0, 0xbf666666, 0xbe94514d,
    0x0, 0x0, 0xbf666666, 0xbe95e11a,
    0x0, 0x0, 0xbf666666, 0xbe9771b4,
    0x0, 0x0, 0xbf666666, 0xbe99031d,
    0x0, 0x0, 0xbf666666, 0xbe9a9557,
    0x0, 0x0, 0xbf666666, 0xbe9c2865,
    0x0, 0x0, 0xbf666666, 0xbe9dbc4b,
    0x0, 0x0, 0xbf666666, 0xbe9f5109,
    0x0, 0x0, 0xbf666666, 0xbea0e6a4,
    0x0, 0x0, 0xbf666666, 0xbea27d1d,
    0x0, 0x0, 0xbf666666, 0xbea41478,
    0x0, 0x0, 0xbf666666, 0xbea5acb7,
    0x0, 0x0, 0xbf666666, 0xbea745dd,
    0x0, 0x0, 0xbf666666, 0xbea8dfec,
    0x0, 0x0, 0xbf666666, 0xbeaa7ae8,
    0x0, 0x0, 0xbf666666, 0xbeac16d2,
    0x0, 0x0, 0xbf666666, 0xbeadb3af,
    0x0, 0x0, 0xbf666666, 0xbeaf5180,
    0x0, 0x0, 0xbf666666, 0xbeb0f049,
    0x0, 0x0, 0xbf666666, 0xbeb2900d,
    0x0, 0x0, 0xbf666666, 0xbeb430cd,
    0x0, 0x0, 0xbf666666, 0xbeb5d28f,
    0x0, 0x0, 0xbf666666, 0xbeb77553,
    0x0, 0x0, 0xbf666666, 0xbeb9191d,
    0x0, 0x0, 0xbf666666, 0xbebabdf1,
    0x0, 0x0, 0xbf666666, 0xbebc63d1,
    0x0, 0x0, 0xbf666666, 0xbebe0ac0,
    0x0, 0x0, 0xbf666666, 0xbebfb2c2,
    0x0, 0x0, 0xbf666666, 0xbec15bd9,
    0x0, 0x0, 0xbf666666, 0xbec30609,
    0x0, 0x0, 0xbf666666, 0xbec4b154,
    0x0, 0x0, 0xbf666666, 0xbec65dbe,
    0x0, 0x0, 0xbf666666, 0xbec80b4a,
    0x0, 0x0, 0xbf666666, 0xbec9b9fc,
    0x0, 0x0, 0xbf666666, 0xbecb69d6,
    0x0, 0x0, 0xbf666666, 0xbecd1adc,
    0x0, 0x0, 0xbf666666, 0xbececd11,
    0x0, 0x0, 0xbf666666, 0xbed08079,
    0x0, 0x0, 0xbf666666, 0xbed23516,
    0x0, 0x0, 0xbf666666, 0xbed3eaed,
    0x0, 0x0, 0xbf666666, 0xbed5a200,
    0x0, 0x0, 0xbf666666, 0xbed75a54,
    0x0, 0x0, 0xbf666666, 0xbed913ec,
    0x0, 0x0, 0xbf666666, 0xbedaceca,
    0x0, 0x0, 0xbf666666, 0xbedc8af4,
    0x0, 0x0, 0xbf666666, 0xbede486c,
    0x0, 0x0, 0xbf666666, 0xbee00736,
    0x0, 0x0, 0xbf666666, 0xbee1c756,
    0x0, 0x0, 0xbf666666, 0xbee388cf,
    0x0, 0x0, 0xbf666666, 0xbee54ba5,
    0x0, 0x0, 0xbf666666, 0xbee70fdc,
    0x0, 0x0, 0xbf666666, 0xbee8d578,
    0x0, 0x0, 0xbf666666, 0xbeea9c7d,
    0x0, 0x0, 0xbf666666, 0xbeec64ee,
    0x0, 0x0, 0xbf666666, 0xbeee2ecf,
    0x0, 0x0, 0xbf666666, 0xbeeffa25,
    0x0, 0x0, 0xbf666666, 0xbef1c6f3,
    0x0, 0x0, 0xbf666666, 0xbef3953e,
    0x0, 0x0, 0xbf666666, 0xbef56509,
    0x0, 0x0, 0xbf666666, 0xbef73658,
    0x0, 0x0, 0xbf666666, 0xbef90931,
    0x0, 0x0, 0xbf666666, 0xbefadd96,
    0x0, 0x0, 0xbf666666, 0xbefcb38d,
    0x0, 0x0, 0xbf666666, 0xbefe8b19,
    0x0, 0x0, 0xbf666666, 0xbf00321f,
    0x0, 0x0, 0xbf666666, 0xbf011f82,
    0x0, 0x0, 0xbf666666, 0xbf020db5,
    0x0, 0x0, 0xbf666666, 0xbf02fcbc,
    0x0, 0x0, 0xbf666666, 0xbf03ec99,
    0x0, 0x0, 0xbf666666, 0xbf04dd4e,
    0x0, 0x0, 0xbf666666, 0xbf05cedd,
    0x0, 0x0, 0xbf666666, 0xbf06c149,
    0x0, 0x0, 0xbf666666, 0xbf07b495,
    0x0, 0x0, 0xbf666666, 0xbf08a8c1,
    0x0, 0x0, 0xbf666666, 0xbf099dd2,
    0x0, 0x0, 0xbf666666, 0xbf0a93c9,
    0x0, 0x0, 0xbf666666, 0xbf0b8aa9,
    0x0, 0x0, 0xbf666666, 0xbf0c8274,
    0x0, 0x0, 0xbf666666, 0xbf0d7b2d,
    0x0, 0x0, 0xbf666666, 0xbf0e74d6,
    0x0, 0x0, 0xbf666666, 0xbf0f6f73,
    0x0, 0x0, 0xbf666666, 0xbf106b05,
    0x0, 0x0, 0xbf666666, 0xbf11678e,
    0x0, 0x0, 0xbf666666, 0xbf126513,
    0x0, 0x0, 0xbf666666, 0xbf136396,
    0x0, 0x0, 0xbf666666, 0xbf146318,
    0x0, 0x0, 0xbf666666, 0xbf15639e,
    0x0, 0x0, 0xbf666666, 0xbf166529,
    0x0, 0x0, 0xbf666666, 0xbf1767bd,
    0x0, 0x0, 0xbf666666, 0xbf186b5d,
    0x0, 0x0, 0xbf666666, 0xbf19700a,
    0x0, 0x0, 0xbf666666, 0xbf1a75c9,
    0x0, 0x0, 0xbf666666, 0xbf1b7c9d,
    0x0, 0x0, 0xbf666666, 0xbf1c8487,
    0x0, 0x0, 0xbf666666, 0xbf1d8d8c,
    0x0, 0x0, 0xbf666666, 0xbf1e97ae,
    0x0, 0x0, 0xbf666666, 0xbf1fa2f0,
    0x0, 0x0, 0xbf666666, 0xbf20af56,
    0x0, 0x0, 0xbf666666, 0xbf21bce2,
    0x0, 0x0, 0xbf666666, 0xbf22cb98,
    0x0, 0x0, 0xbf666666, 0xbf23db7c,
    0x0, 0x0, 0xbf666666, 0xbf24ec90,
    0x0, 0x0, 0xbf666666, 0xbf25fed7,
    0x0, 0x0, 0xbf666666, 0xbf271256,
    0x0, 0x0, 0xbf666666, 0xbf28270f,
    0x0, 0x0, 0xbf666666, 0xbf293d06,
    0x0, 0x0, 0xbf666666, 0xbf2a543e,
    0x0, 0x0, 0xbf666666, 0xbf2b6cbc,
    0x0, 0x0, 0xbf666666, 0xbf2c8682,
    0x0, 0x0, 0xbf666666, 0xbf2da194,
    0x0, 0x0, 0xbf666666, 0xbf2ebdf6,
    0x0, 0x0, 0xbf666666, 0xbf2fdbac,
    0x0, 0x0, 0xbf666666, 0xbf30fab9,
    0x0, 0x0, 0xbf666666, 0xbf321b21,
    0x0, 0x0, 0xbf666666, 0xbf333ce9,
    0x0, 0x0, 0xbf666666, 0xbf346013,
    0x0, 0x0, 0xbf666666, 0xbf3584a4,
    0x0, 0x0, 0xbf666666, 0xbf36aaa0,
    0x0, 0x0, 0xbf666666, 0xbf37d20b,
    0x0, 0x0, 0xbf666666, 0xbf38fae9,
    0x0, 0x0, 0xbf666666, 0xbf3a253f,
    0x0, 0x0, 0xbf666666, 0xbf3b5110,
    0x0, 0x0, 0xbf666666, 0xbf3c7e61,
    0x0, 0x0, 0xbf666666, 0xbf3dad36,
    0x0, 0x0, 0xbf666666, 0xbf3edd94,
    0x0, 0x0, 0xbf666666, 0xbf400f7f,
    0x0, 0x0, 0xbf666666, 0xbf4142fb,
    0x0, 0x0, 0xbf666666, 0xbf42780e,
    0x0, 0x0, 0xbf666666, 0xbf43aebb,
    0x0, 0x0, 0xbf666666, 0xbf44e708,
    0x0, 0x0, 0xbf666666, 0xbf4620fa,
    0x0, 0x0, 0xbf666666, 0xbf475c94,
    0x0, 0x0, 0xbf666666, 0xbf4899dd,
    0x0, 0x0, 0xbf666666, 0xbf49d8d9,
    0x0, 0x0, 0xbf666666, 0xbf4b198c,
    0x0, 0x0, 0xbf666666, 0xbf4c5bfe,
    0x0, 0x0, 0xbf666666, 0xbf4da031,
    0x0, 0x0, 0xbf666666, 0xbf4ee62d,
    0x0, 0x0, 0xbf666666, 0xbf502df5,
    0x0, 0x0, 0xbf666666, 0xbf517790,
    0x0, 0x0, 0xbf666666, 0xbf52c303,
    0x0, 0x0, 0xbf666666, 0xbf541054,
    0x0, 0x0, 0xbf666666, 0xbf555f88,
    0x0, 0x0, 0xbf666666, 0xbf56b0a5,
    0x0, 0x0, 0xbf666666, 0xbf5803b0,
    0x0, 0x0, 0xbf666666, 0xbf5958b1,
    0x0, 0x0, 0xbf666666, 0xbf5aafac,
    0x0, 0x0, 0xbf666666, 0xbf5c08a8,
    0x0, 0x0, 0xbf666666, 0xbf5d63ab,
    0x0, 0x0, 0xbf666666, 0xbf5ec0bc,
    0x0, 0x0, 0xbf666666, 0xbf601fe0,
    0x0, 0x0, 0xbf666666, 0xbf61811f,
    0x0, 0x0, 0xbf666666, 0xbf62e47e,
    0x0, 0x0, 0xbf666666, 0xbf644a04,
    0x0, 0x0, 0xbf666666, 0xbf65b1b9,
    0x0, 0x0, 0xbf666666, 0xbf671ba2,
    0x0, 0x0, 0xbf666666, 0xbf6887c8,
    0x0, 0x0, 0xbf666666, 0xbf69f631,
    0x0, 0x0, 0xbf666666, 0xbf6b66e4,
    0x0, 0x0, 0xbf666666, 0xbf6cd9e8,
    0x0, 0x0, 0xbf666666, 0xbf6e4f46,
    0x0, 0x0, 0xbf666666, 0xbf6fc704,
    0x0, 0x0, 0xbf666666, 0xbf71412a,
    0x0, 0x0, 0xbf666666, 0xbf72bdc1,
    0x0, 0x0, 0xbf666666, 0xbf743ccf,
    0x0, 0x0, 0xbf666666, 0xbf75be5d,
    0x0, 0x0, 0xbf666666, 0xbf774273,
    0x0, 0x0, 0xbf666666, 0xbf78c91a,
    0x0, 0x0, 0xbf666666, 0xbf7a5259,
    0x0, 0x0, 0xbf666666, 0xbf7bde3a,
    0x0, 0x0, 0xbf666666, 0xbf7d6cc5,
    0x0, 0x0, 0xbf666666, 0xbf7efe03,
    0x0, 0x0, 0xbf666666, 0xbf8048fe,
    0x0, 0x0, 0xbf666666, 0xbf81145e,
    0x0, 0x0, 0xbf666666, 0xbf81e124,
    0x0, 0x0, 0xbf666666, 0xbf82af57,
    0x0, 0x0, 0xbf666666, 0xbf837efa,
    0x0, 0x0, 0xbf666666, 0xbf845013,
    0x0, 0x0, 0xbf666666, 0xbf8522a6,
    0x0, 0x0, 0xbf666666, 0xbf85f6b9,
    0x0, 0x0, 0xbf666666, 0xbf86cc51,
    0x0, 0x0, 0xbf666666, 0xbf87a372,
    0x0, 0x0, 0xbf666666, 0xbf887c24,
    0x0, 0x0, 0xbf666666, 0xbf895669,
    0x0, 0x0, 0xbf666666, 0xbf8a3249,
    0x0, 0x0, 0xbf666666, 0xbf8b0fc9,
    0x0, 0x0, 0xbf666666, 0xbf8beeef,
    0x0, 0x0, 0xbf666666, 0xbf8ccfc0,
    0x0, 0x0, 0xbf666666, 0xbf8db242,
    0x0, 0x0, 0xbf666666, 0xbf8e967b,
    0x0, 0x0, 0xbf666666, 0xbf8f7c72,
    0x0, 0x0, 0xbf666666, 0xbf90642d,
    0x0, 0x0, 0xbf666666, 0xbf914db1,
    0x0, 0x0, 0xbf666666, 0xbf923906,
    0x0, 0x0, 0xbf666666, 0xbf932632,
    0x0, 0x0, 0xbf666666, 0xbf94153c,
    0x0, 0x0, 0xbf666666, 0xbf95062a,
    0x0, 0x0, 0xbf666666, 0xbf95f904,
    0x0, 0x0, 0xbf666666, 0xbf96edd1,
    0x0, 0x0, 0xbf666666, 0xbf97e497,
    0x0, 0x0, 0xbf666666, 0xbf98dd5e,
    0x0, 0x0, 0xbf666666, 0xbf99d82f,
    0x0, 0x0, 0xbf666666, 0xbf9ad50f,
    0x0, 0x0, 0xbf666666, 0xbf9bd407,
    0x0, 0x0, 0xbf666666, 0xbf9cd520,
    0x0, 0x0, 0xbf666666, 0xbf9dd861,
    0x0, 0x0, 0xbf666666, 0xbf9eddd2,
    0x0, 0x0, 0xbf666666, 0xbf9fe57b,
    0x0, 0x0, 0xbf666666, 0xbfa0ef66,
    0x0, 0x0, 0xbf666666, 0xbfa1fb9b,
    0x0, 0x0, 0xbf666666, 0xbfa30a23,
    0x0, 0x0, 0xbf666666, 0xbfa41b07,
    0x0, 0x0, 0xbf666666, 0xbfa52e51,
    0x0, 0x0, 0xbf666666, 0xbfa64409,
    0x0, 0x0, 0xbf666666, 0xbfa75c3a,
    0x0, 0x0, 0xbf666666, 0xbfa876ec,
    0x0, 0x0, 0xbf666666, 0xbfa9942c,
    0x0, 0x0, 0xbf666666, 0xbfaab401,
    0x0, 0x0, 0xbf666666, 0xbfabd678,
    0x0, 0x0, 0xbf666666, 0xbfacfb9b,
    0x0, 0x0, 0xbf666666, 0xbfae2374,
    0x0, 0x0, 0xbf666666, 0xbfaf4e0e,
    0x0, 0x0, 0xbf666666, 0xbfb07b76,
    0x0, 0x0, 0xbf666666, 0xbfb1abb7,
    0x0, 0x0, 0xbf666666, 0xbfb2dedc,
    0x0, 0x0, 0xbf666666, 0xbfb414f2,
    0x0, 0x0, 0xbf666666, 0xbfb54e05,
    0x0, 0x0, 0xbf666666, 0xbfb68a22,
    0x0, 0x0, 0xbf666666, 0xbfb7c956,
    0x0, 0x0, 0xbf666666, 0xbfb90bad,
    0x0, 0x0, 0xbf666666, 0xbfba5135,
    0x0, 0x0, 0xbf666666, 0xbfbb99fd,
    0x0, 0x0, 0xbf666666, 0xbfbce612,
    0x0, 0x0, 0xbf666666, 0xbfbe3583,
    0x0, 0x0, 0xbf666666, 0xbfbf885e,
    0x0, 0x0, 0xbf666666, 0xbfc0deb3,
    0x0, 0x0, 0xbf666666, 0xbfc23890,
    0x0, 0x0, 0xbf666666, 0xbfc39607,
    0x0, 0x0, 0xbf666666, 0xbfc4f726,
    0x0, 0x0, 0xbf666666, 0xbfc65bfe,
    0x0, 0x0, 0xbf666666, 0xbfc7c4a1,
    0x0, 0x0, 0xbf666666, 0xbfc9311f,
    0x0, 0x0, 0xbf666666, 0xbfcaa18b,
    0x0, 0x0, 0xbf666666, 0xbfcc15f6,
    0x0, 0x0, 0xbf666666, 0xbfcd8e73,
    0x0, 0x0, 0xbf666666, 0xbfcf0b16,
    0x0, 0x0, 0xbf666666, 0xbfd08bf1,
    0x0, 0x0, 0xbf666666, 0xbfd21118,
    0x0, 0x0, 0xbf666666, 0xbfd39aa0,
    0x0, 0x0, 0xbf666666, 0xbfd5289e,
    0x0, 0x0, 0xbf666666, 0xbfd6bb28,
    0x0, 0x0, 0xbf666666, 0xbfd85253,
    0x0, 0x0, 0xbf666666, 0xbfd9ee35,
    0x0, 0x0, 0xbf666666, 0xbfdb8ee7,
    0x0, 0x0, 0xbf666666, 0xbfdd3480,
    0x0, 0x0, 0xbf666666, 0xbfdedf18,
    0x0, 0x0, 0xbf666666, 0xbfe08ec8,
    0x0, 0x0, 0xbf666666, 0xbfe243aa,
    0x0, 0x0, 0xbf666666, 0xbfe3fdd8,
    0x0, 0x0, 0xbf666666, 0xbfe5bd6d,
    0x0, 0x0, 0xbf666666, 0xbfe78284,
    0x0, 0x0, 0xbf666666, 0xbfe94d3b,
    0x0, 0x0, 0xbf666666, 0xbfeb1dae,
    0x0, 0x0, 0xbf666666, 0xbfecf3fc,
    0x0, 0x0, 0xbf666666, 0xbfeed042,
    0x0, 0x0, 0xbf666666, 0xbff0b2a2,
    0x0, 0x0, 0xbf666666, 0xbff29b3b,
    0x0, 0x0, 0xbf666666, 0xbff48a2f,
    0x0, 0x0, 0xbf666666, 0xbff67fa0,
    0x0, 0x0, 0xbf666666, 0xbff87bb1,
    0x0, 0x0, 0xbf666666, 0xbffa7e87,
    0x0, 0x0, 0xbf666666, 0xbffc8848,
    0x0, 0x0, 0xbf666666, 0xbffe9919,
    0x0, 0x0, 0xbf666666, 0xc0005892,
    0x0, 0x0, 0xbf666666, 0xc0016847,
    0x0, 0x0, 0xbf666666, 0xc0027bc2,
    0x0, 0x0, 0xbf666666, 0xc0039318,
    0x0, 0x0, 0xbf666666, 0xc004ae5f,
    0x0, 0x0, 0xbf666666, 0xc005cdaf,
    0x0, 0x0, 0xbf666666, 0xc006f11f,
    0x0, 0x0, 0xbf666666, 0xc00818c7,
    0x0, 0x0, 0xbf666666, 0xc00944c0,
    0x0, 0x0, 0xbf666666, 0xc00a7524,
    0x0, 0x0, 0xbf666666, 0xc00baa0f,
    0x0, 0x0, 0xbf666666, 0xc00ce39a,
    0x0, 0x0, 0xbf666666, 0xc00e21e4,
    0x0, 0x0, 0xbf666666, 0xc00f6508,
    0x0, 0x0, 0xbf666666, 0xc010ad26,
    0x0, 0x0, 0xbf666666, 0xc011fa5d,
    0x0, 0x0, 0xbf666666, 0xc0134ccd,
    0x0, 0x0, 0xbf666666, 0xc014a496,
    0x0, 0x0, 0xbf666666, 0xc01601dd,
    0x0, 0x0, 0xbf666666, 0xc01764c4,
    0x0, 0x0, 0xbf666666, 0xc018cd70,
    0x0, 0x0, 0xbf666666, 0xc01a3c07,
    0x0, 0x0, 0xbf666666, 0xc01bb0b1,
    0x0, 0x0, 0xbf666666, 0xc01d2b96,
    0x0, 0x0, 0xbf666666, 0xc01eace1,
    0x0, 0x0, 0xbf666666, 0xc02034be,
    0x0, 0x0, 0xbf666666, 0xc021c359,
    0x0, 0x0, 0xbf666666, 0xc02358e2,
    0x0, 0x0, 0xbf666666, 0xc024f58a,
    0x0, 0x0, 0xbf666666, 0xc0269982,
    0x0, 0x0, 0xbf666666, 0xc0284500,
    0x0, 0x0, 0xbf666666, 0xc029f838,
    0x0, 0x0, 0xbf666666, 0xc02bb365,
    0x0, 0x0, 0xbf666666, 0xc02d76c0,
    0x0, 0x0, 0xbf666666, 0xc02f4286,
    0x0, 0x0, 0xbf666666, 0xc03116f6,
    0x0, 0x0, 0xbf666666, 0xc032f452,
    0x0, 0x0, 0xbf666666, 0xc034dade,
    0x0, 0x0, 0xbf666666, 0xc036cae1,
    0x0, 0x0, 0xbf666666, 0xc038c4a5,
    0x0, 0x0, 0xbf666666, 0xc03ac876,
    0x0, 0x0, 0xbf666666, 0xc03cd6a6,
    0x0, 0x0, 0xbf666666, 0xc03eef86,
    0x0, 0x0, 0xbf666666, 0xc041136f,
    0x0, 0x0, 0xbf666666, 0xc04342bb,
    0x0, 0x0, 0xbf666666, 0xc0457dc9,
    0x0, 0x0, 0xbf666666, 0xc047c4fa,
    0x0, 0x0, 0xbf666666, 0xc04a18b7,
    0x0, 0x0, 0xbf666666, 0xc04c796b,
    0x0, 0x0, 0xbf666666, 0xc04ee787,
    0x0, 0x0, 0xbf666666, 0xc0516380,
    0x0, 0x0, 0xbf666666, 0xc053edd2,
    0x0, 0x0, 0xbf666666, 0xc05686fd,
    0x0, 0x0, 0xbf666666, 0xc0592f88,
    0x0, 0x0, 0xbf666666, 0xc05be801,
    0x0, 0x0, 0xbf666666, 0xc05eb0fd,
    0x0, 0x0, 0xbf666666, 0xc0618b16,
    0x0, 0x0, 0xbf666666, 0xc06476f1,
    0x0, 0x0, 0xbf666666, 0xc0677539,
    0x0, 0x0, 0xbf666666, 0xc06a86a1,
    0x0, 0x0, 0xbf666666, 0xc06dabe9,
    0x0, 0x0, 0xbf666666, 0xc070e5d7,
    0x0, 0x0, 0xbf666666, 0xc074353d,
    0x0, 0x0, 0xbf666666, 0xc0779af9,
    0x0, 0x0, 0xbf666666, 0xc07b17f5,
    0x0, 0x0, 0xbf666666, 0xc07ead26,
    0x0, 0x0, 0xbf666666, 0xc0812dc8,
    0x0, 0x0, 0xbf666666, 0xc0831224,
    0x0, 0x0, 0xbf666666, 0xc0850438,
    0x0, 0x0, 0xbf666666, 0xc087049c,
    0x0, 0x0, 0xbf666666, 0xc08913f6,
    0x0, 0x0, 0xbf666666, 0xc08b32f0,
    0x0, 0x0, 0xbf666666, 0xc08d6243,
    0x0, 0x0, 0xbf666666, 0xc08fa2b0,
    0x0, 0x0, 0xbf666666, 0xc091f508,
    0x0, 0x0, 0xbf666666, 0xc0945a26,
    0x0, 0x0, 0xbf666666, 0xc096d2f5,
    0x0, 0x0, 0xbf666666, 0xc099606e,
    0x0, 0x0, 0xbf666666, 0xc09c039c,
    0x0, 0x0, 0xbf666666, 0xc09ebd9d,
    0x0, 0x0, 0xbf666666, 0xc0a18fa1,
    0x0, 0x0, 0xbf666666, 0xc0a47aef,
    0x0, 0x0, 0xbf666666, 0xc0a780e5,
    0x0, 0x0, 0xbf666666, 0xc0aaa2fa,
    0x0, 0x0, 0xbf666666, 0xc0ade2c2,
    0x0, 0x0, 0xbf666666, 0xc0b141ef,
    0x0, 0x0, 0xbf666666, 0xc0b4c256,
    0x0, 0x0, 0xbf666666, 0xc0b865f0,
    0x0, 0x0, 0xbf666666, 0xc0bc2ee0,
    0x0, 0x0, 0xbf666666, 0xc0c01f74,
    0x0, 0x0, 0xbf666666, 0xc0c43a2d,
    0x0, 0x0, 0xbf666666, 0xc0c881c4,
    0x0, 0x0, 0xbf666666, 0xc0ccf92d,
    0x0, 0x0, 0xbf666666, 0xc0d1a3a3,
    0x0, 0x0, 0xbf666666, 0xc0d684ab,
    0x0, 0x0, 0xbf666666, 0xc0dba01e,
    0x0, 0x0, 0xbf666666, 0xc0e0fa35,
    0x0, 0x0, 0xbf666666, 0xc0e69796,
    0x0, 0x0, 0xbf666666, 0xc0ec7d5c,
    0x0, 0x0, 0xbf666666, 0xc0f2b12a,
    0x0, 0x0, 0xbf666666, 0xc0f93940,
    0x0, 0x0, 0xbf666666, 0xc1000e46,
    0x0, 0x0, 0xbf666666, 0xc103b160,
    0x0, 0x0, 0xbf666666, 0xc1078a3c,
    0x0, 0x0, 0xbf666666, 0xc10b9dab,
    0x0, 0x0, 0xbf666666, 0xc10ff113,
    0x0, 0x0, 0xbf666666, 0xc1148a8f,
    0x0, 0x0, 0xbf666666, 0xc1197101,
    0x0, 0x0, 0xbf666666, 0xc11eac3d,
    0x0, 0x0, 0xbf666666, 0xc1244531,
    0x0, 0x0, 0xbf666666, 0xc12a4615,
    0x0, 0x0, 0xbf666666, 0xc130baae,
    0x0, 0x0, 0xbf666666, 0xc137b099,
    0x0, 0x0, 0xbf666666, 0xc13f37ab,
    0x0, 0x0, 0xbf666666, 0xc147626c,
    0x0, 0x0, 0xbf666666, 0xc15046b0,
    0x0, 0x0, 0xbf666666, 0xc159fe59,
    0x0, 0x0, 0xbf666666, 0xc164a856,
    0x0, 0x0, 0xbf666666, 0xc17069ef,
    0x0, 0x0, 0xbf666666, 0xc17d707d,
    0x0, 0x0, 0xbf666666, 0xc185f9da,
    0x0, 0x0, 0xbf666666, 0xc18e1c65,
    0x0, 0x0, 0xbf666666, 0xc1974b69,
    0x0, 0x0, 0xbf666666, 0xc1a1be72,
    0x0, 0x0, 0xbf666666, 0xc1adbd7f,
    0x0, 0x0, 0xbf666666, 0xc1bba79f,
    0x0, 0x0, 0xbf666666, 0xc1cbfce9,
    0x0, 0x0, 0xbf666666, 0xc1df6e48,
    0x0, 0x0, 0xbf666666, 0xc1f6f71f,
    0x0, 0x0, 0xbf666666, 0xc20a0491,
    0x0, 0x0, 0xbf666666, 0xc21c6d96,
    0x0, 0x0, 0xbf666666, 0xc2348079,
    0x0, 0x0, 0xbf666666, 0xc2555412,
    0x0, 0x0, 0xbf666666, 0xc2825f17,
    0x0, 0x0, 0xbf666666, 0xc2a79fe8,
    0x0, 0x0, 0xbf666666, 0xc2eaadcd,
    0x0, 0x0, 0xbf666666, 0xc3439176,
    0x0, 0x0, 0xbf666666, 0xc412ad55
    };

static const uint32_t in_cfft_step_4096[8192] = {
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0,
    0x3f666666, 0x0, 0x3f666666, 0x0
    };

static const uint32_t in_cifft_step_4096[8192] = {
    0x44e66666, 0x0, 0xbf666666, 0x4492ad5b,
    0x0, 0x0, 0xbf666666, 0x43c391ba,
    0x0, 0x0, 0xbf666666, 0x436aaeaf,
    0x0, 0x0, 0xbf666666, 0x4327a125,
    0x0, 0x0, 0xbf666666, 0x430260ae,
    0x0, 0x0, 0xbf666666, 0x42d557f5,
    0x0, 0x0, 0xbf666666, 0x42b48511,
    0x0, 0x0, 0xbf666666, 0x429c72e3,
    0x0, 0x0, 0xbf666666, 0x428a0a93,
    0x0, 0x0, 0xbf666666, 0x4277048e,
    0x0, 0x0, 0xbf666666, 0x425f7d21,
    0x0, 0x0, 0xbf666666, 0x424c0d2c,
    0x0, 0x0, 0xbf666666, 0x423bb94b,
    0x0, 0x0, 0xbf666666, 0x422dd096,
    0x0, 0x0, 0xbf666666, 0x4221d2f2,
    0x0, 0x0, 0xbf666666, 0x42176154,
    0x0, 0x0, 0xbf666666, 0x420e33ba,
    0x0, 0x0, 0xbf666666, 0x42061299,
    0x0, 0x0, 0xbf666666, 0x41fda4d0,
    0x0, 0x0, 0xbf666666, 0x41f0a116,
    0x0, 0x0, 0xbf666666, 0x41e4e251,
    0x0, 0x0, 0xbf666666, 0x41da3b28,
    0x0, 0x0, 0xbf666666, 0x41d08654,
    0x0, 0x0, 0xbf666666, 0x41c7a4e5,
    0x0, 0x0, 0xbf666666, 0x41bf7cf9,
    0x0, 0x0, 0xbf666666, 0x41b7f8bc,
    0x0, 0x0, 0xbf666666, 0x41b105a6,
    0x0, 0x0, 0xbf666666, 0x41aa93e2,
    0x0, 0x0, 0xbf666666, 0x41a495d3,
    0x0, 0x0, 0xbf666666, 0x419effb4,
    0x0, 0x0, 0xbf666666, 0x4199c74d,
    0x0, 0x0, 0xbf666666, 0x4194e3b1,
    0x0, 0x0, 0xbf666666, 0x41904d0b,
    0x0, 0x0, 0xbf666666, 0x418bfc78,
    0x0, 0x0, 0xbf666666, 0x4187ebdf,
    0x0, 0x0, 0xbf666666, 0x418415d9,
    0x0, 0x0, 0xbf666666, 0x41807595,
    0x0, 0x0, 0xbf666666, 0x417a0d8b,
    0x0, 0x0, 0xbf666666, 0x41738b22,
    0x0, 0x0, 0xbf666666, 0x416d5d00,
    0x0, 0x0, 0xbf666666, 0x41677ce7,
    0x0, 0x0, 0xbf666666, 0x4161e534,
    0x0, 0x0, 0xbf666666, 0x415c90ca,
    0x0, 0x0, 0xbf666666, 0x41577b05,
    0x0, 0x0, 0xbf666666, 0x41529fac,
    0x0, 0x0, 0xbf666666, 0x414dfae4,
    0x0, 0x0, 0xbf666666, 0x4149892a,
    0x0, 0x0, 0xbf666666, 0x41454742,
    0x0, 0x0, 0xbf666666, 0x41413238,
    0x0, 0x0, 0xbf666666, 0x413d4754,
    0x0, 0x0, 0xbf666666, 0x41398415,
    0x0, 0x0, 0xbf666666, 0x4135e62b,
    0x0, 0x0, 0xbf666666, 0x41326b75,
    0x0, 0x0, 0xbf666666, 0x412f11f9,
    0x0, 0x0, 0xbf666666, 0x412bd7e3,
    0x0, 0x0, 0xbf666666, 0x4128bb80,
    0x0, 0x0, 0xbf666666, 0x4125bb3d,
    0x0, 0x0, 0xbf666666, 0x4122d5a2,
    0x0, 0x0, 0xbf666666, 0x41200951,
    0x0, 0x0, 0xbf666666, 0x411d5503,
    0x0, 0x0, 0xbf666666, 0x411ab789,
    0x0, 0x0, 0xbf666666, 0x41182fc4,
    0x0, 0x0, 0xbf666666, 0x4115bcaa,
    0x0, 0x0, 0xbf666666, 0x41135d42,
    0x0, 0x0, 0xbf666666, 0x4111109f,
    0x0, 0x0, 0xbf666666, 0x410ed5e8,
    0x0, 0x0, 0xbf666666, 0x410cac4c,
    0x0, 0x0, 0xbf666666, 0x410a9308,
    0x0, 0x0, 0xbf666666, 0x41088967,
    0x0, 0x0, 0xbf666666, 0x41068eba,
    0x0, 0x0, 0xbf666666, 0x4104a25f,
    0x0, 0x0, 0xbf666666, 0x4102c3bc,
    0x0, 0x0, 0xbf666666, 0x4100f240,
    0x0, 0x0, 0xbf666666, 0x40fe5ac3,
    0x0, 0x0, 0xbf666666, 0x40fae93d,
    0x0, 0x0, 0xbf666666, 0x40f78ef6,
    0x0, 0x0, 0xbf666666, 0x40f44b07,
    0x0, 0x0, 0xbf666666, 0x40f11c91,
    0x0, 0x0, 0xbf666666, 0x40ee02c3,
    0x0, 0x0, 0xbf666666, 0x40eafcd4,
    0x0, 0x0, 0xbf666666, 0x40e80a08,
    0x0, 0x0, 0xbf666666, 0x40e529aa,
    0x0, 0x0, 0xbf666666, 0x40e25b0e,
    0x0, 0x0, 0xbf666666, 0x40df9d91,
    0x0, 0x0, 0xbf666666, 0x40dcf098,
    0x0, 0x0, 0xbf666666, 0x40da538d,
    0x0, 0x0, 0xbf666666, 0x40d7c5e5,
    0x0, 0x0, 0xbf666666, 0x40d54717,
    0x0, 0x0, 0xbf666666, 0x40d2d6a2,
    0x0, 0x0, 0xbf666666, 0x40d0740d,
    0x0, 0x0, 0xbf666666, 0x40ce1ee0,
    0x0, 0x0, 0xbf666666, 0x40cbd6ab,
    0x0, 0x0, 0xbf666666, 0x40c99b03,
    0x0, 0x0, 0xbf666666, 0x40c76b81,
    0x0, 0x0, 0xbf666666, 0x40c547c1,
    0x0, 0x0, 0xbf666666, 0x40c32f66,
    0x0, 0x0, 0xbf666666, 0x40c12214,
    0x0, 0x0, 0xbf666666, 0x40bf1f75,
    0x0, 0x0, 0xbf666666, 0x40bd2735,
    0x0, 0x0, 0xbf666666, 0x40bb3904,
    0x0, 0x0, 0xbf666666, 0x40b95496,
    0x0, 0x0, 0xbf666666, 0x40b779a0,
    0x0, 0x0, 0xbf666666, 0x40b5a7db,
    0x0, 0x0, 0xbf666666, 0x40b3df04,
    0x0, 0x0, 0xbf666666, 0x40b21ed8,
    0x0, 0x0, 0xbf666666, 0x40b06719,
    0x0, 0x0, 0xbf666666, 0x40aeb78a,
    0x0, 0x0, 0xbf666666, 0x40ad0ff0,
    0x0, 0x0, 0xbf666666, 0x40ab7012,
    0x0, 0x0, 0xbf666666, 0x40a9d7bc,
    0x0, 0x0, 0xbf666666, 0x40a846b8,
    0x0, 0x0, 0xbf666666, 0x40a6bcd4,
    0x0, 0x0, 0xbf666666, 0x40a539df,
    0x0, 0x0, 0xbf666666, 0x40a3bdaa,
    0x0, 0x0, 0xbf666666, 0x40a24809,
    0x0, 0x0, 0xbf666666, 0x40a0d8cf,
    0x0, 0x0, 0xbf666666, 0x409f6fd2,
    0x0, 0x0, 0xbf666666, 0x409e0ce9,
    0x0, 0x0, 0xbf666666, 0x409cafed,
    0x0, 0x0, 0xbf666666, 0x409b58b8,
    0x0, 0x0, 0xbf666666, 0x409a0726,
    0x0, 0x0, 0xbf666666, 0x4098bb11,
    0x0, 0x0, 0xbf666666, 0x40977459,
    0x0, 0x0, 0xbf666666, 0x409632db,
    0x0, 0x0, 0xbf666666, 0x4094f678,
    0x0, 0x0, 0xbf666666, 0x4093bf0f,
    0x0, 0x0, 0xbf666666, 0x40928c84,
    0x0, 0x0, 0xbf666666, 0x40915eb8,
    0x0, 0x0, 0xbf666666, 0x40903590,
    0x0, 0x0, 0xbf666666, 0x408f10ef,
    0x0, 0x0, 0xbf666666, 0x408df0bc,
    0x0, 0x0, 0xbf666666, 0x408cd4db,
    0x0, 0x0, 0xbf666666, 0x408bbd35,
    0x0, 0x0, 0xbf666666, 0x408aa9b0,
    0x0, 0x0, 0xbf666666, 0x40899a36,
    0x0, 0x0, 0xbf666666, 0x40888eaf,
    0x0, 0x0, 0xbf666666, 0x40878705,
    0x0, 0x0, 0xbf666666, 0x40868323,
    0x0, 0x0, 0xbf666666, 0x408582f3,
    0x0, 0x0, 0xbf666666, 0x40848661,
    0x0, 0x0, 0xbf666666, 0x40838d5a,
    0x0, 0x0, 0xbf666666, 0x408297ca,
    0x0, 0x0, 0xbf666666, 0x4081a59e,
    0x0, 0x0, 0xbf666666, 0x4080b6c5,
    0x0, 0x0, 0xbf666666, 0x407f9659,
    0x0, 0x0, 0xbf666666, 0x407dc587,
    0x0, 0x0, 0xbf666666, 0x407bfaf2,
    0x0, 0x0, 0xbf666666, 0x407a367b,
    0x0, 0x0, 0xbf666666, 0x40787801,
    0x0, 0x0, 0xbf666666, 0x4076bf66,
    0x0, 0x0, 0xbf666666, 0x40750c8b,
    0x0, 0x0, 0xbf666666, 0x40735f54,
    0x0, 0x0, 0xbf666666, 0x4071b7a5,
    0x0, 0x0, 0xbf666666, 0x40701560,
    0x0, 0x0, 0xbf666666, 0x406e786d,
    0x0, 0x0, 0xbf666666, 0x406ce0af,
    0x0, 0x0, 0xbf666666, 0x406b4e0f,
    0x0, 0x0, 0xbf666666, 0x4069c072,
    0x0, 0x0, 0xbf666666, 0x406837c0,
    0x0, 0x0, 0xbf666666, 0x4066b3e3,
    0x0, 0x0, 0xbf666666, 0x406534c2,
    0x0, 0x0, 0xbf666666, 0x4063ba47,
    0x0, 0x0, 0xbf666666, 0x4062445c,
    0x0, 0x0, 0xbf666666, 0x4060d2ec,
    0x0, 0x0, 0xbf666666, 0x405f65e2,
    0x0, 0x0, 0xbf666666, 0x405dfd29,
    0x0, 0x0, 0xbf666666, 0x405c98ae,
    0x0, 0x0, 0xbf666666, 0x405b385d,
    0x0, 0x0, 0xbf666666, 0x4059dc22,
    0x0, 0x0, 0xbf666666, 0x405883ec,
    0x0, 0x0, 0xbf666666, 0x40572fa9,
    0x0, 0x0, 0xbf666666, 0x4055df46,
    0x0, 0x0, 0xbf666666, 0x405492b3,
    0x0, 0x0, 0xbf666666, 0x405349de,
    0x0, 0x0, 0xbf666666, 0x405204b7,
    0x0, 0x0, 0xbf666666, 0x4050c32f,
    0x0, 0x0, 0xbf666666, 0x404f8534,
    0x0, 0x0, 0xbf666666, 0x404e4ab8,
    0x0, 0x0, 0xbf666666, 0x404d13ac,
    0x0, 0x0, 0xbf666666, 0x404be001,
    0x0, 0x0, 0xbf666666, 0x404aafa9,
    0x0, 0x0, 0xbf666666, 0x40498295,
    0x0, 0x0, 0xbf666666, 0x404858b8,
    0x0, 0x0, 0xbf666666, 0x40473205,
    0x0, 0x0, 0xbf666666, 0x40460e6e,
    0x0, 0x0, 0xbf666666, 0x4044ede6,
    0x0, 0x0, 0xbf666666, 0x4043d061,
    0x0, 0x0, 0xbf666666, 0x4042b5d2,
    0x0, 0x0, 0xbf666666, 0x40419e2e,
    0x0, 0x0, 0xbf666666, 0x40408968,
    0x0, 0x0, 0xbf666666, 0x403f7774,
    0x0, 0x0, 0xbf666666, 0x403e6849,
    0x0, 0x0, 0xbf666666, 0x403d5bda,
    0x0, 0x0, 0xbf666666, 0x403c521d,
    0x0, 0x0, 0xbf666666, 0x403b4b06,
    0x0, 0x0, 0xbf666666, 0x403a468c,
    0x0, 0x0, 0xbf666666, 0x403944a5,
    0x0, 0x0, 0xbf666666, 0x40384545,
    0x0, 0x0, 0xbf666666, 0x40374865,
    0x0, 0x0, 0xbf666666, 0x40364df9,
    0x0, 0x0, 0xbf666666, 0x403555f8,
    0x0, 0x0, 0xbf666666, 0x4034605a,
    0x0, 0x0, 0xbf666666, 0x40336d15,
    0x0, 0x0, 0xbf666666, 0x40327c21,
    0x0, 0x0, 0xbf666666, 0x40318d74,
    0x0, 0x0, 0xbf666666, 0x4030a106,
    0x0, 0x0, 0xbf666666, 0x402fb6cf,
    0x0, 0x0, 0xbf666666, 0x402ecec7,
    0x0, 0x0, 0xbf666666, 0x402de8e5,
    0x0, 0x0, 0xbf666666, 0x402d0521,
    0x0, 0x0, 0xbf666666, 0x402c2375,
    0x0, 0x0, 0xbf666666, 0x402b43d8,
    0x0, 0x0, 0xbf666666, 0x402a6642,
    0x0, 0x0, 0xbf666666, 0x40298aae,
    0x0, 0x0, 0xbf666666, 0x4028b112,
    0x0, 0x0, 0xbf666666, 0x4027d969,
    0x0, 0x0, 0xbf666666, 0x402703ab,
    0x0, 0x0, 0xbf666666, 0x40262fd2,
    0x0, 0x0, 0xbf666666, 0x40255dd6,
    0x0, 0x0, 0xbf666666, 0x40248db2,
    0x0, 0x0, 0xbf666666, 0x4023bf60,
    0x0, 0x0, 0xbf666666, 0x4022f2d7,
    0x0, 0x0, 0xbf666666, 0x40222813,
    0x0, 0x0, 0xbf666666, 0x40215f0e,
    0x0, 0x0, 0xbf666666, 0x402097c1,
    0x0, 0x0, 0xbf666666, 0x401fd227,
    0x0, 0x0, 0xbf666666, 0x401f0e39,
    0x0, 0x0, 0xbf666666, 0x401e4bf3,
    0x0, 0x0, 0xbf666666, 0x401d8b4e,
    0x0, 0x0, 0xbf666666, 0x401ccc45,
    0x0, 0x0, 0xbf666666, 0x401c0ed3,
    0x0, 0x0, 0xbf666666, 0x401b52f2,
    0x0, 0x0, 0xbf666666, 0x401a989e,
    0x0, 0x0, 0xbf666666, 0x4019dfd1,
    0x0, 0x0, 0xbf666666, 0x40192886,
    0x0, 0x0, 0xbf666666, 0x401872b8,
    0x0, 0x0, 0xbf666666, 0x4017be63,
    0x0, 0x0, 0xbf666666, 0x40170b81,
    0x0, 0x0, 0xbf666666, 0x40165a0e,
    0x0, 0x0, 0xbf666666, 0x4015aa06,
    0x0, 0x0, 0xbf666666, 0x4014fb63,
    0x0, 0x0, 0xbf666666, 0x40144e22,
    0x0, 0x0, 0xbf666666, 0x4013a23d,
    0x0, 0x0, 0xbf666666, 0x4012f7b2,
    0x0, 0x0, 0xbf666666, 0x40124e7a,
    0x0, 0x0, 0xbf666666, 0x4011a693,
    0x0, 0x0, 0xbf666666, 0x4010fff9,
    0x0, 0x0, 0xbf666666, 0x40105aa6,
    0x0, 0x0, 0xbf666666, 0x400fb697,
    0x0, 0x0, 0xbf666666, 0x400f13c9,
    0x0, 0x0, 0xbf666666, 0x400e7237,
    0x0, 0x0, 0xbf666666, 0x400dd1de,
    0x0, 0x0, 0xbf666666, 0x400d32ba,
    0x0, 0x0, 0xbf666666, 0x400c94c7,
    0x0, 0x0, 0xbf666666, 0x400bf801,
    0x0, 0x0, 0xbf666666, 0x400b5c66,
    0x0, 0x0, 0xbf666666, 0x400ac1f1,
    0x0, 0x0, 0xbf666666, 0x400a28a0,
    0x0, 0x0, 0xbf666666, 0x4009906e,
    0x0, 0x0, 0xbf666666, 0x4008f959,
    0x0, 0x0, 0xbf666666, 0x4008635c,
    0x0, 0x0, 0xbf666666, 0x4007ce76,
    0x0, 0x0, 0xbf666666, 0x40073aa3,
    0x0, 0x0, 0xbf666666, 0x4006a7df,
    0x0, 0x0, 0xbf666666, 0x40061627,
    0x0, 0x0, 0xbf666666, 0x40058579,
    0x0, 0x0, 0xbf666666, 0x4004f5d2,
    0x0, 0x0, 0xbf666666, 0x4004672e,
    0x0, 0x0, 0xbf666666, 0x4003d98a,
    0x0, 0x0, 0xbf666666, 0x40034ce5,
    0x0, 0x0, 0xbf666666, 0x4002c13a,
    0x0, 0x0, 0xbf666666, 0x40023687,
    0x0, 0x0, 0xbf666666, 0x4001acca,
    0x0, 0x0, 0xbf666666, 0x40012400,
    0x0, 0x0, 0xbf666666, 0x40009c26,
    0x0, 0x0, 0xbf666666, 0x40001539,
    0x0, 0x0, 0xbf666666, 0x3fff1e6d,
    0x0, 0x0, 0xbf666666, 0x3ffe1439,
    0x0, 0x0, 0xbf666666, 0x3ffd0bd1,
    0x0, 0x0, 0xbf666666, 0x3ffc0530,
    0x0, 0x0, 0xbf666666, 0x3ffb0050,
    0x0, 0x0, 0xbf666666, 0x3ff9fd2d,
    0x0, 0x0, 0xbf666666, 0x3ff8fbc3,
    0x0, 0x0, 0xbf666666, 0x3ff7fc0c,
    0x0, 0x0, 0xbf666666, 0x3ff6fe03,
    0x0, 0x0, 0xbf666666, 0x3ff601a6,
    0x0, 0x0, 0xbf666666, 0x3ff506ee,
    0x0, 0x0, 0xbf666666, 0x3ff40dd7,
    0x0, 0x0, 0xbf666666, 0x3ff3165e,
    0x0, 0x0, 0xbf666666, 0x3ff2207d,
    0x0, 0x0, 0xbf666666, 0x3ff12c32,
    0x0, 0x0, 0xbf666666, 0x3ff03976,
    0x0, 0x0, 0xbf666666, 0x3fef4847,
    0x0, 0x0, 0xbf666666, 0x3fee58a0,
    0x0, 0x0, 0xbf666666, 0x3fed6a7d,
    0x0, 0x0, 0xbf666666, 0x3fec7dda,
    0x0, 0x0, 0xbf666666, 0x3feb92b4,
    0x0, 0x0, 0xbf666666, 0x3feaa906,
    0x0, 0x0, 0xbf666666, 0x3fe9c0cd,
    0x0, 0x0, 0xbf666666, 0x3fe8da05,
    0x0, 0x0, 0xbf666666, 0x3fe7f4aa,
    0x0, 0x0, 0xbf666666, 0x3fe710b9,
    0x0, 0x0, 0xbf666666, 0x3fe62e2d,
    0x0, 0x0, 0xbf666666, 0x3fe54d04,
    0x0, 0x0, 0xbf666666, 0x3fe46d3a,
    0x0, 0x0, 0xbf666666, 0x3fe38ecc,
    0x0, 0x0, 0xbf666666, 0x3fe2b1b5,
    0x0, 0x0, 0xbf666666, 0x3fe1d5f3,
    0x0, 0x0, 0xbf666666, 0x3fe0fb83,
    0x0, 0x0, 0xbf666666, 0x3fe02260,
    0x0, 0x0, 0xbf666666, 0x3fdf4a89,
    0x0, 0x0, 0xbf666666, 0x3fde73f9,
    0x0, 0x0, 0xbf666666, 0x3fdd9ead,
    0x0, 0x0, 0xbf666666, 0x3fdccaa3,
    0x0, 0x0, 0xbf666666, 0x3fdbf7d7,
    0x0, 0x0, 0xbf666666, 0x3fdb2646,
    0x0, 0x0, 0xbf666666, 0x3fda55ee,
    0x0, 0x0, 0xbf666666, 0x3fd986ca,
    0x0, 0x0, 0xbf666666, 0x3fd8b8d9,
    0x0, 0x0, 0xbf666666, 0x3fd7ec17,
    0x0, 0x0, 0xbf666666, 0x3fd72082,
    0x0, 0x0, 0xbf666666, 0x3fd65617,
    0x0, 0x0, 0xbf666666, 0x3fd58cd3,
    0x0, 0x0, 0xbf666666, 0x3fd4c4b2,
    0x0, 0x0, 0xbf666666, 0x3fd3fdb4,
    0x0, 0x0, 0xbf666666, 0x3fd337d4,
    0x0, 0x0, 0xbf666666, 0x3fd27310,
    0x0, 0x0, 0xbf666666, 0x3fd1af66,
    0x0, 0x0, 0xbf666666, 0x3fd0ecd2,
    0x0, 0x0, 0xbf666666, 0x3fd02b53,
    0x0, 0x0, 0xbf666666, 0x3fcf6ae6,
    0x0, 0x0, 0xbf666666, 0x3fceab89,
    0x0, 0x0, 0xbf666666, 0x3fcded38,
    0x0, 0x0, 0xbf666666, 0x3fcd2ff1,
    0x0, 0x0, 0xbf666666, 0x3fcc73b3,
    0x0, 0x0, 0xbf666666, 0x3fcbb87b,
    0x0, 0x0, 0xbf666666, 0x3fcafe45,
    0x0, 0x0, 0xbf666666, 0x3fca4511,
    0x0, 0x0, 0xbf666666, 0x3fc98cdb,
    0x0, 0x0, 0xbf666666, 0x3fc8d5a2,
    0x0, 0x0, 0xbf666666, 0x3fc81f63,
    0x0, 0x0, 0xbf666666, 0x3fc76a1c,
    0x0, 0x0, 0xbf666666, 0x3fc6b5cb,
    0x0, 0x0, 0xbf666666, 0x3fc6026e,
    0x0, 0x0, 0xbf666666, 0x3fc55002,
    0x0, 0x0, 0xbf666666, 0x3fc49e85,
    0x0, 0x0, 0xbf666666, 0x3fc3edf6,
    0x0, 0x0, 0xbf666666, 0x3fc33e52,
    0x0, 0x0, 0xbf666666, 0x3fc28f97,
    0x0, 0x0, 0xbf666666, 0x3fc1e1c3,
    0x0, 0x0, 0xbf666666, 0x3fc134d5,
    0x0, 0x0, 0xbf666666, 0x3fc088c9,
    0x0, 0x0, 0xbf666666, 0x3fbfdd9f,
    0x0, 0x0, 0xbf666666, 0x3fbf3354,
    0x0, 0x0, 0xbf666666, 0x3fbe89e7,
    0x0, 0x0, 0xbf666666, 0x3fbde155,
    0x0, 0x0, 0xbf666666, 0x3fbd399d,
    0x0, 0x0, 0xbf666666, 0x3fbc92bd,
    0x0, 0x0, 0xbf666666, 0x3fbbecb3,
    0x0, 0x0, 0xbf666666, 0x3fbb477d,
    0x0, 0x0, 0xbf666666, 0x3fbaa319,
    0x0, 0x0, 0xbf666666, 0x3fb9ff86,
    0x0, 0x0, 0xbf666666, 0x3fb95cc2,
    0x0, 0x0, 0xbf666666, 0x3fb8bacb,
    0x0, 0x0, 0xbf666666, 0x3fb8199f,
    0x0, 0x0, 0xbf666666, 0x3fb7793e,
    0x0, 0x0, 0xbf666666, 0x3fb6d9a4,
    0x0, 0x0, 0xbf666666, 0x3fb63ad1,
    0x0, 0x0, 0xbf666666, 0x3fb59cc3,
    0x0, 0x0, 0xbf666666, 0x3fb4ff78,
    0x0, 0x0, 0xbf666666, 0x3fb462ef,
    0x0, 0x0, 0xbf666666, 0x3fb3c726,
    0x0, 0x0, 0xbf666666, 0x3fb32c1b,
    0x0, 0x0, 0xbf666666, 0x3fb291cd,
    0x0, 0x0, 0xbf666666, 0x3fb1f83a,
    0x0, 0x0, 0xbf666666, 0x3fb15f62,
    0x0, 0x0, 0xbf666666, 0x3fb0c742,
    0x0, 0x0, 0xbf666666, 0x3fb02fd9,
    0x0, 0x0, 0xbf666666, 0x3faf9925,
    0x0, 0x0, 0xbf666666, 0x3faf0325,
    0x0, 0x0, 0xbf666666, 0x3fae6dd8,
    0x0, 0x0, 0xbf666666, 0x3fadd93c,
    0x0, 0x0, 0xbf666666, 0x3fad454f,
    0x0, 0x0, 0xbf666666, 0x3facb211,
    0x0, 0x0, 0xbf666666, 0x3fac1f80,
    0x0, 0x0, 0xbf666666, 0x3fab8d9b,
    0x0, 0x0, 0xbf666666, 0x3faafc60,
    0x0, 0x0, 0xbf666666, 0x3faa6bcd,
    0x0, 0x0, 0xbf666666, 0x3fa9dbe3,
    0x0, 0x0, 0xbf666666, 0x3fa94c9e,
    0x0, 0x0, 0xbf666666, 0x3fa8bdff,
    0x0, 0x0, 0xbf666666, 0x3fa83003,
    0x0, 0x0, 0xbf666666, 0x3fa7a2aa,
    0x0, 0x0, 0xbf666666, 0x3fa715f2,
    0x0, 0x0, 0xbf666666, 0x3fa689da,
    0x0, 0x0, 0xbf666666, 0x3fa5fe60,
    0x0, 0x0, 0xbf666666, 0x3fa57384,
    0x0, 0x0, 0xbf666666, 0x3fa4e945,
    0x0, 0x0, 0xbf666666, 0x3fa45fa0,
    0x0, 0x0, 0xbf666666, 0x3fa3d695,
    0x0, 0x0, 0xbf666666, 0x3fa34e23,
    0x0, 0x0, 0xbf666666, 0x3fa2c649,
    0x0, 0x0, 0xbf666666, 0x3fa23f05,
    0x0, 0x0, 0xbf666666, 0x3fa1b857,
    0x0, 0x0, 0xbf666666, 0x3fa1323c,
    0x0, 0x0, 0xbf666666, 0x3fa0acb5,
    0x0, 0x0, 0xbf666666, 0x3fa027c0,
    0x0, 0x0, 0xbf666666, 0x3f9fa35b,
    0x0, 0x0, 0xbf666666, 0x3f9f1f86,
    0x0, 0x0, 0xbf666666, 0x3f9e9c40,
    0x0, 0x0, 0xbf666666, 0x3f9e1988,
    0x0, 0x0, 0xbf666666, 0x3f9d975c,
    0x0, 0x0, 0xbf666666, 0x3f9d15bc,
    0x0, 0x0, 0xbf666666, 0x3f9c94a6,
    0x0, 0x0, 0xbf666666, 0x3f9c141a,
    0x0, 0x0, 0xbf666666, 0x3f9b9417,
    0x0, 0x0, 0xbf666666, 0x3f9b149a,
    0x0, 0x0, 0xbf666666, 0x3f9a95a5,
    0x0, 0x0, 0xbf666666, 0x3f9a1735,
    0x0, 0x0, 0xbf666666, 0x3f999949,
    0x0, 0x0, 0xbf666666, 0x3f991be1,
    0x0, 0x0, 0xbf666666, 0x3f989efc,
    0x0, 0x0, 0xbf666666, 0x3f982298,
    0x0, 0x0, 0xbf666666, 0x3f97a6b6,
    0x0, 0x0, 0xbf666666, 0x3f972b53,
    0x0, 0x0, 0xbf666666, 0x3f96b06e,
    0x0, 0x0, 0xbf666666, 0x3f963608,
    0x0, 0x0, 0xbf666666, 0x3f95bc1f,
    0x0, 0x0, 0xbf666666, 0x3f9542b2,
    0x0, 0x0, 0xbf666666, 0x3f94c9c1,
    0x0, 0x0, 0xbf666666, 0x3f94514a,
    0x0, 0x0, 0xbf666666, 0x3f93d94c,
    0x0, 0x0, 0xbf666666, 0x3f9361c8,
    0x0, 0x0, 0xbf666666, 0x3f92eabb,
    0x0, 0x0, 0xbf666666, 0x3f927425,
    0x0, 0x0, 0xbf666666, 0x3f91fe05,
    0x0, 0x0, 0xbf666666, 0x3f91885b,
    0x0, 0x0, 0xbf666666, 0x3f911325,
    0x0, 0x0, 0xbf666666, 0x3f909e63,
    0x0, 0x0, 0xbf666666, 0x3f902a13,
    0x0, 0x0, 0xbf666666, 0x3f8fb636,
    0x0, 0x0, 0xbf666666, 0x3f8f42ca,
    0x0, 0x0, 0xbf666666, 0x3f8ecfcf,
    0x0, 0x0, 0xbf666666, 0x3f8e5d44,
    0x0, 0x0, 0xbf666666, 0x3f8deb27,
    0x0, 0x0, 0xbf666666, 0x3f8d7978,
    0x0, 0x0, 0xbf666666, 0x3f8d0837,
    0x0, 0x0, 0xbf666666, 0x3f8c9763,
    0x0, 0x0, 0xbf666666, 0x3f8c26fb,
    0x0, 0x0, 0xbf666666, 0x3f8bb6fe,
    0x0, 0x0, 0xbf666666, 0x3f8b476b,
    0x0, 0x0, 0xbf666666, 0x3f8ad842,
    0x0, 0x0, 0xbf666666, 0x3f8a6982,
    0x0, 0x0, 0xbf666666, 0x3f89fb2b,
    0x0, 0x0, 0xbf666666, 0x3f898d3b,
    0x0, 0x0, 0xbf666666, 0x3f891fb2,
    0x0, 0x0, 0xbf666666, 0x3f88b28f,
    0x0, 0x0, 0xbf666666, 0x3f8845d2,
    0x0, 0x0, 0xbf666666, 0x3f87d979,
    0x0, 0x0, 0xbf666666, 0x3f876d85,
    0x0, 0x0, 0xbf666666, 0x3f8701f4,
    0x0, 0x0, 0xbf666666, 0x3f8696c6,
    0x0, 0x0, 0xbf666666, 0x3f862bfa,
    0x0, 0x0, 0xbf666666, 0x3f85c190,
    0x0, 0x0, 0xbf666666, 0x3f855786,
    0x0, 0x0, 0xbf666666, 0x3f84eddd,
    0x0, 0x0, 0xbf666666, 0x3f848494,
    0x0, 0x0, 0xbf666666, 0x3f841ba9,
    0x0, 0x0, 0xbf666666, 0x3f83b31d,
    0x0, 0x0, 0xbf666666, 0x3f834aee,
    0x0, 0x0, 0xbf666666, 0x3f82e31d,
    0x0, 0x0, 0xbf666666, 0x3f827ba8,
    0x0, 0x0, 0xbf666666, 0x3f82148e,
    0x0, 0x0, 0xbf666666, 0x3f81add1,
    0x0, 0x0, 0xbf666666, 0x3f81476d,
    0x0, 0x0, 0xbf666666, 0x3f80e164,
    0x0, 0x0, 0xbf666666, 0x3f807bb5,
    0x0, 0x0, 0xbf666666, 0x3f80165e,
    0x0, 0x0, 0xbf666666, 0x3f7f62bf,
    0x0, 0x0, 0xbf666666, 0x3f7e9972,
    0x0, 0x0, 0xbf666666, 0x3f7dd0d3,
    0x0, 0x0, 0xbf666666, 0x3f7d08e2,
    0x0, 0x0, 0xbf666666, 0x3f7c419c,
    0x0, 0x0, 0xbf666666, 0x3f7b7b02,
    0x0, 0x0, 0xbf666666, 0x3f7ab512,
    0x0, 0x0, 0xbf666666, 0x3f79efcb,
    0x0, 0x0, 0xbf666666, 0x3f792b2b,
    0x0, 0x0, 0xbf666666, 0x3f786732,
    0x0, 0x0, 0xbf666666, 0x3f77a3df,
    0x0, 0x0, 0xbf666666, 0x3f76e130,
    0x0, 0x0, 0xbf666666, 0x3f761f25,
    0x0, 0x0, 0xbf666666, 0x3f755dbd,
    0x0, 0x0, 0xbf666666, 0x3f749cf6,
    0x0, 0x0, 0xbf666666, 0x3f73dcd0,
    0x0, 0x0, 0xbf666666, 0x3f731d49,
    0x0, 0x0, 0xbf666666, 0x3f725e60,
    0x0, 0x0, 0xbf666666, 0x3f71a015,
    0x0, 0x0, 0xbf666666, 0x3f70e266,
    0x0, 0x0, 0xbf666666, 0x3f702553,
    0x0, 0x0, 0xbf666666, 0x3f6f68db,
    0x0, 0x0, 0xbf666666, 0x3f6eacfc,
    0x0, 0x0, 0xbf666666, 0x3f6df1b6,
    0x0, 0x0, 0xbf666666, 0x3f6d3707,
    0x0, 0x0, 0xbf666666, 0x3f6c7cef,
    0x0, 0x0, 0xbf666666, 0x3f6bc36d,
    0x0, 0x0, 0xbf666666, 0x3f6b0a7f,
    0x0, 0x0, 0xbf666666, 0x3f6a5226,
    0x0, 0x0, 0xbf666666, 0x3f699a60,
    0x0, 0x0, 0xbf666666, 0x3f68e32c,
    0x0, 0x0, 0xbf666666, 0x3f682c88,
    0x0, 0x0, 0xbf666666, 0x3f677676,
    0x0, 0x0, 0xbf666666, 0x3f66c0f3,
    0x0, 0x0, 0xbf666666, 0x3f660bfe,
    0x0, 0x0, 0xbf666666, 0x3f655797,
    0x0, 0x0, 0xbf666666, 0x3f64a3bd,
    0x0, 0x0, 0xbf666666, 0x3f63f06e,
    0x0, 0x0, 0xbf666666, 0x3f633dab,
    0x0, 0x0, 0xbf666666, 0x3f628b72,
    0x0, 0x0, 0xbf666666, 0x3f61d9c3,
    0x0, 0x0, 0xbf666666, 0x3f61289c,
    0x0, 0x0, 0xbf666666, 0x3f6077fd,
    0x0, 0x0, 0xbf666666, 0x3f5fc7e5,
    0x0, 0x0, 0xbf666666, 0x3f5f1853,
    0x0, 0x0, 0xbf666666, 0x3f5e6946,
    0x0, 0x0, 0xbf666666, 0x3f5dbabe,
    0x0, 0x0, 0xbf666666, 0x3f5d0cba,
    0x0, 0x0, 0xbf666666, 0x3f5c5f38,
    0x0, 0x0, 0xbf666666, 0x3f5bb239,
    0x0, 0x0, 0xbf666666, 0x3f5b05bb,
    0x0, 0x0, 0xbf666666, 0x3f5a59be,
    0x0, 0x0, 0xbf666666, 0x3f59ae40,
    0x0, 0x0, 0xbf666666, 0x3f590341,
    0x0, 0x0, 0xbf666666, 0x3f5858c1,
    0x0, 0x0, 0xbf666666, 0x3f57aebf,
    0x0, 0x0, 0xbf666666, 0x3f570539,
    0x0, 0x0, 0xbf666666, 0x3f565c2f,
    0x0, 0x0, 0xbf666666, 0x3f55b3a1,
    0x0, 0x0, 0xbf666666, 0x3f550b8d,
    0x0, 0x0, 0xbf666666, 0x3f5463f3,
    0x0, 0x0, 0xbf666666, 0x3f53bcd3,
    0x0, 0x0, 0xbf666666, 0x3f53162a,
    0x0, 0x0, 0xbf666666, 0x3f526ffa,
    0x0, 0x0, 0xbf666666, 0x3f51ca40,
    0x0, 0x0, 0xbf666666, 0x3f5124fd,
    0x0, 0x0, 0xbf666666, 0x3f508030,
    0x0, 0x0, 0xbf666666, 0x3f4fdbd8,
    0x0, 0x0, 0xbf666666, 0x3f4f37f3,
    0x0, 0x0, 0xbf666666, 0x3f4e9483,
    0x0, 0x0, 0xbf666666, 0x3f4df185,
    0x0, 0x0, 0xbf666666, 0x3f4d4efa,
    0x0, 0x0, 0xbf666666, 0x3f4cace0,
    0x0, 0x0, 0xbf666666, 0x3f4c0b37,
    0x0, 0x0, 0xbf666666, 0x3f4b69ff,
    0x0, 0x0, 0xbf666666, 0x3f4ac936,
    0x0, 0x0, 0xbf666666, 0x3f4a28dc,
    0x0, 0x0, 0xbf666666, 0x3f4988f1,
    0x0, 0x0, 0xbf666666, 0x3f48e973,
    0x0, 0x0, 0xbf666666, 0x3f484a62,
    0x0, 0x0, 0xbf666666, 0x3f47abbe,
    0x0, 0x0, 0xbf666666, 0x3f470d85,
    0x0, 0x0, 0xbf666666, 0x3f466fb8,
    0x0, 0x0, 0xbf666666, 0x3f45d256,
    0x0, 0x0, 0xbf666666, 0x3f45355d,
    0x0, 0x0, 0xbf666666, 0x3f4498ce,
    0x0, 0x0, 0xbf666666, 0x3f43fca7,
    0x0, 0x0, 0xbf666666, 0x3f4360e9,
    0x0, 0x0, 0xbf666666, 0x3f42c592,
    0x0, 0x0, 0xbf666666, 0x3f422aa3,
    0x0, 0x0, 0xbf666666, 0x3f41901a,
    0x0, 0x0, 0xbf666666, 0x3f40f5f6,
    0x0, 0x0, 0xbf666666, 0x3f405c38,
    0x0, 0x0, 0xbf666666, 0x3f3fc2df,
    0x0, 0x0, 0xbf666666, 0x3f3f29e9,
    0x0, 0x0, 0xbf666666, 0x3f3e9157,
    0x0, 0x0, 0xbf666666, 0x3f3df929,
    0x0, 0x0, 0xbf666666, 0x3f3d615c,
    0x0, 0x0, 0xbf666666, 0x3f3cc9f2,
    0x0, 0x0, 0xbf666666, 0x3f3c32e9,
    0x0, 0x0, 0xbf666666, 0x3f3b9c40,
    0x0, 0x0, 0xbf666666, 0x3f3b05f8,
    0x0, 0x0, 0xbf666666, 0x3f3a700f,
    0x0, 0x0, 0xbf666666, 0x3f39da86,
    0x0, 0x0, 0xbf666666, 0x3f39455b,
    0x0, 0x0, 0xbf666666, 0x3f38b08f,
    0x0, 0x0, 0xbf666666, 0x3f381c20,
    0x0, 0x0, 0xbf666666, 0x3f37880e,
    0x0, 0x0, 0xbf666666, 0x3f36f458,
    0x0, 0x0, 0xbf666666, 0x3f3660ff,
    0x0, 0x0, 0xbf666666, 0x3f35ce01,
    0x0, 0x0, 0xbf666666, 0x3f353b5e,
    0x0, 0x0, 0xbf666666, 0x3f34a915,
    0x0, 0x0, 0xbf666666, 0x3f341727,
    0x0, 0x0, 0xbf666666, 0x3f338592,
    0x0, 0x0, 0xbf666666, 0x3f32f456,
    0x0, 0x0, 0xbf666666, 0x3f326372,
    0x0, 0x0, 0xbf666666, 0x3f31d2e6,
    0x0, 0x0, 0xbf666666, 0x3f3142b2,
    0x0, 0x0, 0xbf666666, 0x3f30b2d5,
    0x0, 0x0, 0xbf666666, 0x3f30234f,
    0x0, 0x0, 0xbf666666, 0x3f2f941f,
    0x0, 0x0, 0xbf666666, 0x3f2f0544,
    0x0, 0x0, 0xbf666666, 0x3f2e76be,
    0x0, 0x0, 0xbf666666, 0x3f2de88d,
    0x0, 0x0, 0xbf666666, 0x3f2d5ab0,
    0x0, 0x0, 0xbf666666, 0x3f2ccd27,
    0x0, 0x0, 0xbf666666, 0x3f2c3ff1,
    0x0, 0x0, 0xbf666666, 0x3f2bb30e,
    0x0, 0x0, 0xbf666666, 0x3f2b267e,
    0x0, 0x0, 0xbf666666, 0x3f2a9a3f,
    0x0, 0x0, 0xbf666666, 0x3f2a0e52,
    0x0, 0x0, 0xbf666666, 0x3f2982b6,
    0x0, 0x0, 0xbf666666, 0x3f28f76a,
    0x0, 0x0, 0xbf666666, 0x3f286c6f,
    0x0, 0x0, 0xbf666666, 0x3f27e1c3,
    0x0, 0x0, 0xbf666666, 0x3f275766,
    0x0, 0x0, 0xbf666666, 0x3f26cd59,
    0x0, 0x0, 0xbf666666, 0x3f264399,
    0x0, 0x0, 0xbf666666, 0x3f25ba28,
    0x0, 0x0, 0xbf666666, 0x3f253104,
    0x0, 0x0, 0xbf666666, 0x3f24a82e,
    0x0, 0x0, 0xbf666666, 0x3f241fa4,
    0x0, 0x0, 0xbf666666, 0x3f239766,
    0x0, 0x0, 0xbf666666, 0x3f230f75,
    0x0, 0x0, 0xbf666666, 0x3f2287cf,
    0x0, 0x0, 0xbf666666, 0x3f220074,
    0x0, 0x0, 0xbf666666, 0x3f217963,
    0x0, 0x0, 0xbf666666, 0x3f20f29d,
    0x0, 0x0, 0xbf666666, 0x3f206c21,
    0x0, 0x0, 0xbf666666, 0x3f1fe5ee,
    0x0, 0x0, 0xbf666666, 0x3f1f6004,
    0x0, 0x0, 0xbf666666, 0x3f1eda63,
    0x0, 0x0, 0xbf666666, 0x3f1e550a,
    0x0, 0x0, 0xbf666666, 0x3f1dcff9,
    0x0, 0x0, 0xbf666666, 0x3f1d4b30,
    0x0, 0x0, 0xbf666666, 0x3f1cc6ae,
    0x0, 0x0, 0xbf666666, 0x3f1c4272,
    0x0, 0x0, 0xbf666666, 0x3f1bbe7d,
    0x0, 0x0, 0xbf666666, 0x3f1b3ace,
    0x0, 0x0, 0xbf666666, 0x3f1ab764,
    0x0, 0x0, 0xbf666666, 0x3f1a3440,
    0x0, 0x0, 0xbf666666, 0x3f19b160,
    0x0, 0x0, 0xbf666666, 0x3f192ec5,
    0x0, 0x0, 0xbf666666, 0x3f18ac6f,
    0x0, 0x0, 0xbf666666, 0x3f182a5c,
    0x0, 0x0, 0xbf666666, 0x3f17a88c,
    0x0, 0x0, 0xbf666666, 0x3f1726ff,
    0x0, 0x0, 0xbf666666, 0x3f16a5b5,
    0x0, 0x0, 0xbf666666, 0x3f1624ae,
    0x0, 0x0, 0xbf666666, 0x3f15a3e8,
    0x0, 0x0, 0xbf666666, 0x3f152364,
    0x0, 0x0, 0xbf666666, 0x3f14a321,
    0x0, 0x0, 0xbf666666, 0x3f14231f,
    0x0, 0x0, 0xbf666666, 0x3f13a35e,
    0x0, 0x0, 0xbf666666, 0x3f1323dd,
    0x0, 0x0, 0xbf666666, 0x3f12a49c,
    0x0, 0x0, 0xbf666666, 0x3f12259a,
    0x0, 0x0, 0xbf666666, 0x3f11a6d8,
    0x0, 0x0, 0xbf666666, 0x3f112855,
    0x0, 0x0, 0xbf666666, 0x3f10aa10,
    0x0, 0x0, 0xbf666666, 0x3f102c09,
    0x0, 0x0, 0xbf666666, 0x3f0fae40,
    0x0, 0x0, 0xbf666666, 0x3f0f30b5,
    0x0, 0x0, 0xbf666666, 0x3f0eb367,
    0x0, 0x0, 0xbf666666, 0x3f0e3655,
    0x0, 0x0, 0xbf666666, 0x3f0db981,
    0x0, 0x0, 0xbf666666, 0x3f0d3ce8,
    0x0, 0x0, 0xbf666666, 0x3f0cc08c,
    0x0, 0x0, 0xbf666666, 0x3f0c446b,
    0x0, 0x0, 0xbf666666, 0x3f0bc886,
    0x0, 0x0, 0xbf666666, 0x3f0b4cdb,
    0x0, 0x0, 0xbf666666, 0x3f0ad16b,
    0x0, 0x0, 0xbf666666, 0x3f0a5636,
    0x0, 0x0, 0xbf666666, 0x3f09db3a,
    0x0, 0x0, 0xbf666666, 0x3f096078,
    0x0, 0x0, 0xbf666666, 0x3f08e5f0,
    0x0, 0x0, 0xbf666666, 0x3f086ba1,
    0x0, 0x0, 0xbf666666, 0x3f07f18b,
    0x0, 0x0, 0xbf666666, 0x3f0777ad,
    0x0, 0x0, 0xbf666666, 0x3f06fe07,
    0x0, 0x0, 0xbf666666, 0x3f068499,
    0x0, 0x0, 0xbf666666, 0x3f060b63,
    0x0, 0x0, 0xbf666666, 0x3f059265,
    0x0, 0x0, 0xbf666666, 0x3f05199d,
    0x0, 0x0, 0xbf666666, 0x3f04a10c,
    0x0, 0x0, 0xbf666666, 0x3f0428b2,
    0x0, 0x0, 0xbf666666, 0x3f03b08d,
    0x0, 0x0, 0xbf666666, 0x3f03389f,
    0x0, 0x0, 0xbf666666, 0x3f02c0e6,
    0x0, 0x0, 0xbf666666, 0x3f024963,
    0x0, 0x0, 0xbf666666, 0x3f01d214,
    0x0, 0x0, 0xbf666666, 0x3f015afb,
    0x0, 0x0, 0xbf666666, 0x3f00e415,
    0x0, 0x0, 0xbf666666, 0x3f006d64,
    0x0, 0x0, 0xbf666666, 0x3effedcf,
    0x0, 0x0, 0xbf666666, 0x3eff013c,
    0x0, 0x0, 0xbf666666, 0x3efe1510,
    0x0, 0x0, 0xbf666666, 0x3efd294a,
    0x0, 0x0, 0xbf666666, 0x3efc3de9,
    0x0, 0x0, 0xbf666666, 0x3efb52ee,
    0x0, 0x0, 0xbf666666, 0x3efa6857,
    0x0, 0x0, 0xbf666666, 0x3ef97e25,
    0x0, 0x0, 0xbf666666, 0x3ef89456,
    0x0, 0x0, 0xbf666666, 0x3ef7aaea,
    0x0, 0x0, 0xbf666666, 0x3ef6c1e0,
    0x0, 0x0, 0xbf666666, 0x3ef5d938,
    0x0, 0x0, 0xbf666666, 0x3ef4f0f2,
    0x0, 0x0, 0xbf666666, 0x3ef4090c,
    0x0, 0x0, 0xbf666666, 0x3ef32187,
    0x0, 0x0, 0xbf666666, 0x3ef23a62,
    0x0, 0x0, 0xbf666666, 0x3ef1539c,
    0x0, 0x0, 0xbf666666, 0x3ef06d35,
    0x0, 0x0, 0xbf666666, 0x3eef872d,
    0x0, 0x0, 0xbf666666, 0x3eeea182,
    0x0, 0x0, 0xbf666666, 0x3eedbc34,
    0x0, 0x0, 0xbf666666, 0x3eecd744,
    0x0, 0x0, 0xbf666666, 0x3eebf2af,
    0x0, 0x0, 0xbf666666, 0x3eeb0e77,
    0x0, 0x0, 0xbf666666, 0x3eea2a9a,
    0x0, 0x0, 0xbf666666, 0x3ee94718,
    0x0, 0x0, 0xbf666666, 0x3ee863f0,
    0x0, 0x0, 0xbf666666, 0x3ee78122,
    0x0, 0x0, 0xbf666666, 0x3ee69ead,
    0x0, 0x0, 0xbf666666, 0x3ee5bc92,
    0x0, 0x0, 0xbf666666, 0x3ee4dacf,
    0x0, 0x0, 0xbf666666, 0x3ee3f964,
    0x0, 0x0, 0xbf666666, 0x3ee31850,
    0x0, 0x0, 0xbf666666, 0x3ee23793,
    0x0, 0x0, 0xbf666666, 0x3ee1572e,
    0x0, 0x0, 0xbf666666, 0x3ee0771e,
    0x0, 0x0, 0xbf666666, 0x3edf9764,
    0x0, 0x0, 0xbf666666, 0x3edeb7ff,
    0x0, 0x0, 0xbf666666, 0x3eddd8ee,
    0x0, 0x0, 0xbf666666, 0x3edcfa33,
    0x0, 0x0, 0xbf666666, 0x3edc1bca,
    0x0, 0x0, 0xbf666666, 0x3edb3db6,
    0x0, 0x0, 0xbf666666, 0x3eda5ff4,
    0x0, 0x0, 0xbf666666, 0x3ed98285,
    0x0, 0x0, 0xbf666666, 0x3ed8a567,
    0x0, 0x0, 0xbf666666, 0x3ed7c89c,
    0x0, 0x0, 0xbf666666, 0x3ed6ec21,
    0x0, 0x0, 0xbf666666, 0x3ed60ff7,
    0x0, 0x0, 0xbf666666, 0x3ed5341e,
    0x0, 0x0, 0xbf666666, 0x3ed45894,
    0x0, 0x0, 0xbf666666, 0x3ed37d5a,
    0x0, 0x0, 0xbf666666, 0x3ed2a26e,
    0x0, 0x0, 0xbf666666, 0x3ed1c7d1,
    0x0, 0x0, 0xbf666666, 0x3ed0ed83,
    0x0, 0x0, 0xbf666666, 0x3ed01382,
    0x0, 0x0, 0xbf666666, 0x3ecf39ce,
    0x0, 0x0, 0xbf666666, 0x3ece6067,
    0x0, 0x0, 0xbf666666, 0x3ecd874c,
    0x0, 0x0, 0xbf666666, 0x3eccae7e,
    0x0, 0x0, 0xbf666666, 0x3ecbd5fb,
    0x0, 0x0, 0xbf666666, 0x3ecafdc3,
    0x0, 0x0, 0xbf666666, 0x3eca25d6,
    0x0, 0x0, 0xbf666666, 0x3ec94e34,
    0x0, 0x0, 0xbf666666, 0x3ec876db,
    0x0, 0x0, 0xbf666666, 0x3ec79fcc,
    0x0, 0x0, 0xbf666666, 0x3ec6c906,
    0x0, 0x0, 0xbf666666, 0x3ec5f288,
    0x0, 0x0, 0xbf666666, 0x3ec51c53,
    0x0, 0x0, 0xbf666666, 0x3ec44666,
    0x0, 0x0, 0xbf666666, 0x3ec370c1,
    0x0, 0x0, 0xbf666666, 0x3ec29b62,
    0x0, 0x0, 0xbf666666, 0x3ec1c64a,
    0x0, 0x0, 0xbf666666, 0x3ec0f179,
    0x0, 0x0, 0xbf666666, 0x3ec01cee,
    0x0, 0x0, 0xbf666666, 0x3ebf48a8,
    0x0, 0x0, 0xbf666666, 0x3ebe74a7,
    0x0, 0x0, 0xbf666666, 0x3ebda0eb,
    0x0, 0x0, 0xbf666666, 0x3ebccd73,
    0x0, 0x0, 0xbf666666, 0x3ebbfa40,
    0x0, 0x0, 0xbf666666, 0x3ebb2750,
    0x0, 0x0, 0xbf666666, 0x3eba54a3,
    0x0, 0x0, 0xbf666666, 0x3eb98239,
    0x0, 0x0, 0xbf666666, 0x3eb8b012,
    0x0, 0x0, 0xbf666666, 0x3eb7de2d,
    0x0, 0x0, 0xbf666666, 0x3eb70c89,
    0x0, 0x0, 0xbf666666, 0x3eb63b27,
    0x0, 0x0, 0xbf666666, 0x3eb56a06,
    0x0, 0x0, 0xbf666666, 0x3eb49926,
    0x0, 0x0, 0xbf666666, 0x3eb3c885,
    0x0, 0x0, 0xbf666666, 0x3eb2f825,
    0x0, 0x0, 0xbf666666, 0x3eb22804,
    0x0, 0x0, 0xbf666666, 0x3eb15822,
    0x0, 0x0, 0xbf666666, 0x3eb08880,
    0x0, 0x0, 0xbf666666, 0x3eafb91b,
    0x0, 0x0, 0xbf666666, 0x3eaee9f5,
    0x0, 0x0, 0xbf666666, 0x3eae1b0c,
    0x0, 0x0, 0xbf666666, 0x3ead4c61,
    0x0, 0x0, 0xbf666666, 0x3eac7df3,
    0x0, 0x0, 0xbf666666, 0x3eabafc1,
    0x0, 0x0, 0xbf666666, 0x3eaae1cc,
    0x0, 0x0, 0xbf666666, 0x3eaa1412,
    0x0, 0x0, 0xbf666666, 0x3ea94695,
    0x0, 0x0, 0xbf666666, 0x3ea87952,
    0x0, 0x0, 0xbf666666, 0x3ea7ac4b,
    0x0, 0x0, 0xbf666666, 0x3ea6df7e,
    0x0, 0x0, 0xbf666666, 0x3ea612eb,
    0x0, 0x0, 0xbf666666, 0x3ea54692,
    0x0, 0x0, 0xbf666666, 0x3ea47a72,
    0x0, 0x0, 0xbf666666, 0x3ea3ae8c,
    0x0, 0x0, 0xbf666666, 0x3ea2e2df,
    0x0, 0x0, 0xbf666666, 0x3ea2176a,
    0x0, 0x0, 0xbf666666, 0x3ea14c2d,
    0x0, 0x0, 0xbf666666, 0x3ea08129,
    0x0, 0x0, 0xbf666666, 0x3e9fb65b,
    0x0, 0x0, 0xbf666666, 0x3e9eebc5,
    0x0, 0x0, 0xbf666666, 0x3e9e2166,
    0x0, 0x0, 0xbf666666, 0x3e9d573d,
    0x0, 0x0, 0xbf666666, 0x3e9c8d4b,
    0x0, 0x0, 0xbf666666, 0x3e9bc38e,
    0x0, 0x0, 0xbf666666, 0x3e9afa07,
    0x0, 0x0, 0xbf666666, 0x3e9a30b5,
    0x0, 0x0, 0xbf666666, 0x3e996798,
    0x0, 0x0, 0xbf666666, 0x3e989eaf,
    0x0, 0x0, 0xbf666666, 0x3e97d5fb,
    0x0, 0x0, 0xbf666666, 0x3e970d7a,
    0x0, 0x0, 0xbf666666, 0x3e96452d,
    0x0, 0x0, 0xbf666666, 0x3e957d14,
    0x0, 0x0, 0xbf666666, 0x3e94b52d,
    0x0, 0x0, 0xbf666666, 0x3e93ed79,
    0x0, 0x0, 0xbf666666, 0x3e9325f8,
    0x0, 0x0, 0xbf666666, 0x3e925ea8,
    0x0, 0x0, 0xbf666666, 0x3e91978a,
    0x0, 0x0, 0xbf666666, 0x3e90d09e,
    0x0, 0x0, 0xbf666666, 0x3e9009e2,
    0x0, 0x0, 0xbf666666, 0x3e8f4358,
    0x0, 0x0, 0xbf666666, 0x3e8e7cfe,
    0x0, 0x0, 0xbf666666, 0x3e8db6d4,
    0x0, 0x0, 0xbf666666, 0x3e8cf0d9,
    0x0, 0x0, 0xbf666666, 0x3e8c2b0f,
    0x0, 0x0, 0xbf666666, 0x3e8b6573,
    0x0, 0x0, 0xbf666666, 0x3e8aa007,
    0x0, 0x0, 0xbf666666, 0x3e89dac9,
    0x0, 0x0, 0xbf666666, 0x3e8915b9,
    0x0, 0x0, 0xbf666666, 0x3e8850d8,
    0x0, 0x0, 0xbf666666, 0x3e878c24,
    0x0, 0x0, 0xbf666666, 0x3e86c79e,
    0x0, 0x0, 0xbf666666, 0x3e860344,
    0x0, 0x0, 0xbf666666, 0x3e853f18,
    0x0, 0x0, 0xbf666666, 0x3e847b18,
    0x0, 0x0, 0xbf666666, 0x3e83b744,
    0x0, 0x0, 0xbf666666, 0x3e82f39d,
    0x0, 0x0, 0xbf666666, 0x3e823020,
    0x0, 0x0, 0xbf666666, 0x3e816cd0,
    0x0, 0x0, 0xbf666666, 0x3e80a9aa,
    0x0, 0x0, 0xbf666666, 0x3e7fcd5e,
    0x0, 0x0, 0xbf666666, 0x3e7e47be,
    0x0, 0x0, 0xbf666666, 0x3e7cc271,
    0x0, 0x0, 0xbf666666, 0x3e7b3d79,
    0x0, 0x0, 0xbf666666, 0x3e79b8d3,
    0x0, 0x0, 0xbf666666, 0x3e783481,
    0x0, 0x0, 0xbf666666, 0x3e76b080,
    0x0, 0x0, 0xbf666666, 0x3e752cd1,
    0x0, 0x0, 0xbf666666, 0x3e73a973,
    0x0, 0x0, 0xbf666666, 0x3e722666,
    0x0, 0x0, 0xbf666666, 0x3e70a3a8,
    0x0, 0x0, 0xbf666666, 0x3e6f2139,
    0x0, 0x0, 0xbf666666, 0x3e6d9f1a,
    0x0, 0x0, 0xbf666666, 0x3e6c1d48,
    0x0, 0x0, 0xbf666666, 0x3e6a9bc4,
    0x0, 0x0, 0xbf666666, 0x3e691a8d,
    0x0, 0x0, 0xbf666666, 0x3e6799a3,
    0x0, 0x0, 0xbf666666, 0x3e661904,
    0x0, 0x0, 0xbf666666, 0x3e6498b1,
    0x0, 0x0, 0xbf666666, 0x3e6318a9,
    0x0, 0x0, 0xbf666666, 0x3e6198eb,
    0x0, 0x0, 0xbf666666, 0x3e601976,
    0x0, 0x0, 0xbf666666, 0x3e5e9a4b,
    0x0, 0x0, 0xbf666666, 0x3e5d1b69,
    0x0, 0x0, 0xbf666666, 0x3e5b9ccf,
    0x0, 0x0, 0xbf666666, 0x3e5a1e7c,
    0x0, 0x0, 0xbf666666, 0x3e58a070,
    0x0, 0x0, 0xbf666666, 0x3e5722ab,
    0x0, 0x0, 0xbf666666, 0x3e55a52c,
    0x0, 0x0, 0xbf666666, 0x3e5427f2,
    0x0, 0x0, 0xbf666666, 0x3e52aafe,
    0x0, 0x0, 0xbf666666, 0x3e512e4d,
    0x0, 0x0, 0xbf666666, 0x3e4fb1e0,
    0x0, 0x0, 0xbf666666, 0x3e4e35b7,
    0x0, 0x0, 0xbf666666, 0x3e4cb9d1,
    0x0, 0x0, 0xbf666666, 0x3e4b3e2c,
    0x0, 0x0, 0xbf666666, 0x3e49c2ca,
    0x0, 0x0, 0xbf666666, 0x3e4847a9,
    0x0, 0x0, 0xbf666666, 0x3e46ccc8,
    0x0, 0x0, 0xbf666666, 0x3e455227,
    0x0, 0x0, 0xbf666666, 0x3e43d7c7,
    0x0, 0x0, 0xbf666666, 0x3e425da5,
    0x0, 0x0, 0xbf666666, 0x3e40e3c2,
    0x0, 0x0, 0xbf666666, 0x3e3f6a1d,
    0x0, 0x0, 0xbf666666, 0x3e3df0b6,
    0x0, 0x0, 0xbf666666, 0x3e3c778b,
    0x0, 0x0, 0xbf666666, 0x3e3afe9d,
    0x0, 0x0, 0xbf666666, 0x3e3985ec,
    0x0, 0x0, 0xbf666666, 0x3e380d76,
    0x0, 0x0, 0xbf666666, 0x3e36953a,
    0x0, 0x0, 0xbf666666, 0x3e351d3a,
    0x0, 0x0, 0xbf666666, 0x3e33a573,
    0x0, 0x0, 0xbf666666, 0x3e322de6,
    0x0, 0x0, 0xbf666666, 0x3e30b692,
    0x0, 0x0, 0xbf666666, 0x3e2f3f77,
    0x0, 0x0, 0xbf666666, 0x3e2dc893,
    0x0, 0x0, 0xbf666666, 0x3e2c51e7,
    0x0, 0x0, 0xbf666666, 0x3e2adb72,
    0x0, 0x0, 0xbf666666, 0x3e296533,
    0x0, 0x0, 0xbf666666, 0x3e27ef2b,
    0x0, 0x0, 0xbf666666, 0x3e267958,
    0x0, 0x0, 0xbf666666, 0x3e2503ba,
    0x0, 0x0, 0xbf666666, 0x3e238e50,
    0x0, 0x0, 0xbf666666, 0x3e22191b,
    0x0, 0x0, 0xbf666666, 0x3e20a419,
    0x0, 0x0, 0xbf666666, 0x3e1f2f4a,
    0x0, 0x0, 0xbf666666, 0x3e1dbaae,
    0x0, 0x0, 0xbf666666, 0x3e1c4644,
    0x0, 0x0, 0xbf666666, 0x3e1ad20b,
    0x0, 0x0, 0xbf666666, 0x3e195e04,
    0x0, 0x0, 0xbf666666, 0x3e17ea2d,
    0x0, 0x0, 0xbf666666, 0x3e167686,
    0x0, 0x0, 0xbf666666, 0x3e15030f,
    0x0, 0x0, 0xbf666666, 0x3e138fc7,
    0x0, 0x0, 0xbf666666, 0x3e121cad,
    0x0, 0x0, 0xbf666666, 0x3e10a9c2,
    0x0, 0x0, 0xbf666666, 0x3e0f3705,
    0x0, 0x0, 0xbf666666, 0x3e0dc475,
    0x0, 0x0, 0xbf666666, 0x3e0c5211,
    0x0, 0x0, 0xbf666666, 0x3e0adfda,
    0x0, 0x0, 0xbf666666, 0x3e096dcf,
    0x0, 0x0, 0xbf666666, 0x3e07fbef,
    0x0, 0x0, 0xbf666666, 0x3e068a3a,
    0x0, 0x0, 0xbf666666, 0x3e0518af,
    0x0, 0x0, 0xbf666666, 0x3e03a74e,
    0x0, 0x0, 0xbf666666, 0x3e023617,
    0x0, 0x0, 0xbf666666, 0x3e00c509,
    0x0, 0x0, 0xbf666666, 0x3dfea845,
    0x0, 0x0, 0xbf666666, 0x3dfbc6c9,
    0x0, 0x0, 0xbf666666, 0x3df8e59d,
    0x0, 0x0, 0xbf666666, 0x3df604be,
    0x0, 0x0, 0xbf666666, 0x3df3242d,
    0x0, 0x0, 0xbf666666, 0x3df043e8,
    0x0, 0x0, 0xbf666666, 0x3ded63ee,
    0x0, 0x0, 0xbf666666, 0x3dea843f,
    0x0, 0x0, 0xbf666666, 0x3de7a4d9,
    0x0, 0x0, 0xbf666666, 0x3de4c5bc,
    0x0, 0x0, 0xbf666666, 0x3de1e6e6,
    0x0, 0x0, 0xbf666666, 0x3ddf0857,
    0x0, 0x0, 0xbf666666, 0x3ddc2a0e,
    0x0, 0x0, 0xbf666666, 0x3dd94c0a,
    0x0, 0x0, 0xbf666666, 0x3dd66e4a,
    0x0, 0x0, 0xbf666666, 0x3dd390cd,
    0x0, 0x0, 0xbf666666, 0x3dd0b392,
    0x0, 0x0, 0xbf666666, 0x3dcdd698,
    0x0, 0x0, 0xbf666666, 0x3dcaf9de,
    0x0, 0x0, 0xbf666666, 0x3dc81d64,
    0x0, 0x0, 0xbf666666, 0x3dc54128,
    0x0, 0x0, 0xbf666666, 0x3dc2652a,
    0x0, 0x0, 0xbf666666, 0x3dbf8969,
    0x0, 0x0, 0xbf666666, 0x3dbcade3,
    0x0, 0x0, 0xbf666666, 0x3db9d298,
    0x0, 0x0, 0xbf666666, 0x3db6f786,
    0x0, 0x0, 0xbf666666, 0x3db41cae,
    0x0, 0x0, 0xbf666666, 0x3db1420e,
    0x0, 0x0, 0xbf666666, 0x3dae67a5,
    0x0, 0x0, 0xbf666666, 0x3dab8d72,
    0x0, 0x0, 0xbf666666, 0x3da8b375,
    0x0, 0x0, 0xbf666666, 0x3da5d9ac,
    0x0, 0x0, 0xbf666666, 0x3da30017,
    0x0, 0x0, 0xbf666666, 0x3da026b4,
    0x0, 0x0, 0xbf666666, 0x3d9d4d83,
    0x0, 0x0, 0xbf666666, 0x3d9a7483,
    0x0, 0x0, 0xbf666666, 0x3d979bb3,
    0x0, 0x0, 0xbf666666, 0x3d94c313,
    0x0, 0x0, 0xbf666666, 0x3d91eaa0,
    0x0, 0x0, 0xbf666666, 0x3d8f125a,
    0x0, 0x0, 0xbf666666, 0x3d8c3a41,
    0x0, 0x0, 0xbf666666, 0x3d896254,
    0x0, 0x0, 0xbf666666, 0x3d868a91,
    0x0, 0x0, 0xbf666666, 0x3d83b2f8,
    0x0, 0x0, 0xbf666666, 0x3d80db87,
    0x0, 0x0, 0xbf666666, 0x3d7c087d,
    0x0, 0x0, 0xbf666666, 0x3d765a3a,
    0x0, 0x0, 0xbf666666, 0x3d70ac44,
    0x0, 0x0, 0xbf666666, 0x3d6afe98,
    0x0, 0x0, 0xbf666666, 0x3d655135,
    0x0, 0x0, 0xbf666666, 0x3d5fa418,
    0x0, 0x0, 0xbf666666, 0x3d59f741,
    0x0, 0x0, 0xbf666666, 0x3d544aae,
    0x0, 0x0, 0xbf666666, 0x3d4e9e5c,
    0x0, 0x0, 0xbf666666, 0x3d48f24a,
    0x0, 0x0, 0xbf666666, 0x3d434676,
    0x0, 0x0, 0xbf666666, 0x3d3d9adf,
    0x0, 0x0, 0xbf666666, 0x3d37ef82,
    0x0, 0x0, 0xbf666666, 0x3d32445f,
    0x0, 0x0, 0xbf666666, 0x3d2c9972,
    0x0, 0x0, 0xbf666666, 0x3d26eeba,
    0x0, 0x0, 0xbf666666, 0x3d214437,
    0x0, 0x0, 0xbf666666, 0x3d1b99e5,
    0x0, 0x0, 0xbf666666, 0x3d15efc3,
    0x0, 0x0, 0xbf666666, 0x3d1045cf,
    0x0, 0x0, 0xbf666666, 0x3d0a9c08,
    0x0, 0x0, 0xbf666666, 0x3d04f26c,
    0x0, 0x0, 0xbf666666, 0x3cfe91f2,
    0x0, 0x0, 0xbf666666, 0x3cf33f5a,
    0x0, 0x0, 0xbf666666, 0x3ce7ed0e,
    0x0, 0x0, 0xbf666666, 0x3cdc9b09,
    0x0, 0x0, 0xbf666666, 0x3cd14948,
    0x0, 0x0, 0xbf666666, 0x3cc5f7c8,
    0x0, 0x0, 0xbf666666, 0x3cbaa685,
    0x0, 0x0, 0xbf666666, 0x3caf557b,
    0x0, 0x0, 0xbf666666, 0x3ca404a8,
    0x0, 0x0, 0xbf666666, 0x3c98b407,
    0x0, 0x0, 0xbf666666, 0x3c8d6395,
    0x0, 0x0, 0xbf666666, 0x3c82134f,
    0x0, 0x0, 0xbf666666, 0x3c6d8663,
    0x0, 0x0, 0xbf666666, 0x3c56e670,
    0x0, 0x0, 0xbf666666, 0x3c4046c0,
    0x0, 0x0, 0xbf666666, 0x3c29a74b,
    0x0, 0x0, 0xbf666666, 0x3c13080a,
    0x0, 0x0, 0xbf666666, 0x3bf8d1ee,
    0x0, 0x0, 0xbf666666, 0x3bcb9414,
    0x0, 0x0, 0xbf666666, 0x3b9e5679,
    0x0, 0x0, 0xbf666666, 0x3b62321f,
    0x0, 0x0, 0xbf666666, 0x3b07b790,
    0x0, 0x0, 0xbf666666, 0x3a34f4ad,
    0x0, 0x0, 0xbf666666, 0xba34f4ad,
    0x0, 0x0, 0xbf666666, 0xbb07b790,
    0x0, 0x0, 0xbf666666, 0xbb62321f,
    0x0, 0x0, 0xbf666666, 0xbb9e5679,
    0x0, 0x0, 0xbf666666, 0xbbcb9414,
    0x0, 0x0, 0xbf666666, 0xbbf8d1ee,
    0x0, 0x0, 0xbf666666, 0xbc13080a,
    0x0, 0x0, 0xbf666666, 0xbc29a74b,
    0x0, 0x0, 0xbf666666, 0xbc4046c0,
    0x0, 0x0, 0xbf666666, 0xbc56e670,
    0x0, 0x0, 0xbf666666, 0xbc6d8663,
    0x0, 0x0, 0xbf666666, 0xbc82134f,
    0x0, 0x0, 0xbf666666, 0xbc8d6395,
    0x0, 0x0, 0xbf666666, 0xbc98b407,
    0x0, 0x0, 0xbf666666, 0xbca404a8,
    0x0, 0x0, 0xbf666666, 0xbcaf557b,
    0x0, 0x0, 0xbf666666, 0xbcbaa685,
    0x0, 0x0, 0xbf666666, 0xbcc5f7c8,
    0x0, 0x0, 0xbf666666, 0xbcd14948,
    0x0, 0x0, 0xbf666666, 0xbcdc9b09,
    0x0, 0x0, 0xbf666666, 0xbce7ed0e,
    0x0, 0x0, 0xbf666666, 0xbcf33f5a,
    0x0, 0x0, 0xbf666666, 0xbcfe91f2,
    0x0, 0x0, 0xbf666666, 0xbd04f26c,
    0x0, 0x0, 0xbf666666, 0xbd0a9c08,
    0x0, 0x0, 0xbf666666, 0xbd1045cf,
    0x0, 0x0, 0xbf666666, 0xbd15efc3,
    0x0, 0x0, 0xbf666666, 0xbd1b99e5,
    0x0, 0x0, 0xbf666666, 0xbd214437,
    0x0, 0x0, 0xbf666666, 0xbd26eeba,
    0x0, 0x0, 0xbf666666, 0xbd2c9972,
    0x0, 0x0, 0xbf666666, 0xbd32445f,
    0x0, 0x0, 0xbf666666, 0xbd37ef82,
    0x0, 0x0, 0xbf666666, 0xbd3d9adf,
    0x0, 0x0, 0xbf666666, 0xbd434676,
    0x0, 0x0, 0xbf666666, 0xbd48f24a,
    0x0, 0x0, 0xbf666666, 0xbd4e9e5c,
    0x0, 0x0, 0xbf666666, 0xbd544aae,
    0x0, 0x0, 0xbf666666, 0xbd59f741,
    0x0, 0x0, 0xbf666666, 0xbd5fa418,
    0x0, 0x0, 0xbf666666, 0xbd655135,
    0x0, 0x0, 0xbf666666, 0xbd6afe98,
    0x0, 0x0, 0xbf666666, 0xbd70ac44,
    0x0, 0x0, 0xbf666666, 0xbd765a3a,
    0x0, 0x0, 0xbf666666, 0xbd7c087d,
    0x0, 0x0, 0xbf666666, 0xbd80db87,
    0x0, 0x0, 0xbf666666, 0xbd83b2f8,
    0x0, 0x0, 0xbf666666, 0xbd868a91,
    0x0, 0x0, 0xbf666666, 0xbd896254,
    0x0, 0x0, 0xbf666666, 0xbd8c3a41,
    0x0, 0x0, 0xbf666666, 0xbd8f125a,
    0x0, 0x0, 0xbf666666, 0xbd91eaa0,
    0x0, 0x0, 0xbf666666, 0xbd94c313,
    0x0, 0x0, 0xbf666666, 0xbd979bb3,
    0x0, 0x0, 0xbf666666, 0xbd9a7483,
    0x0, 0x0, 0xbf666666, 0xbd9d4d83,
    0x0, 0x0, 0xbf666666, 0xbda026b4,
    0x0, 0x0, 0xbf666666, 0xbda30017,
    0x0, 0x0, 0xbf666666, 0xbda5d9ac,
    0x0, 0x0, 0xbf666666, 0xbda8b375,
    0x0, 0x0, 0xbf666666, 0xbdab8d72,
    0x0, 0x0, 0xbf666666, 0xbdae67a5,
    0x0, 0x0, 0xbf666666, 0xbdb1420e,
    0x0, 0x0, 0xbf666666, 0xbdb41cae,
    0x0, 0x0, 0xbf666666, 0xbdb6f786,
    0x0, 0x0, 0xbf666666, 0xbdb9d298,
    0x0, 0x0, 0xbf666666, 0xbdbcade3,
    0x0, 0x0, 0xbf666666, 0xbdbf8969,
    0x0, 0x0, 0xbf666666, 0xbdc2652a,
    0x0, 0x0, 0xbf666666, 0xbdc54128,
    0x0, 0x0, 0xbf666666, 0xbdc81d64,
    0x0, 0x0, 0xbf666666, 0xbdcaf9de,
    0x0, 0x0, 0xbf666666, 0xbdcdd698,
    0x0, 0x0, 0xbf666666, 0xbdd0b392,
    0x0, 0x0, 0xbf666666, 0xbdd390cd,
    0x0, 0x0, 0xbf666666, 0xbdd66e4a,
    0x0, 0x0, 0xbf666666, 0xbdd94c0a,
    0x0, 0x0, 0xbf666666, 0xbddc2a0e,
    0x0, 0x0, 0xbf666666, 0xbddf0857,
    0x0, 0x0, 0xbf666666, 0xbde1e6e6,
    0x0, 0x0, 0xbf666666, 0xbde4c5bc,
    0x0, 0x0, 0xbf666666, 0xbde7a4d9,
    0x0, 0x0, 0xbf666666, 0xbdea843f,
    0x0, 0x0, 0xbf666666, 0xbded63ee,
    0x0, 0x0, 0xbf666666, 0xbdf043e8,
    0x0, 0x0, 0xbf666666, 0xbdf3242d,
    0x0, 0x0, 0xbf666666, 0xbdf604be,
    0x0, 0x0, 0xbf666666, 0xbdf8e59d,
    0x0, 0x0, 0xbf666666, 0xbdfbc6c9,
    0x0, 0x0, 0xbf666666, 0xbdfea845,
    0x0, 0x0, 0xbf666666, 0xbe00c509,
    0x0, 0x0, 0xbf666666, 0xbe023617,
    0x0, 0x0, 0xbf666666, 0xbe03a74e,
    0x0, 0x0, 0xbf666666, 0xbe0518af,
    0x0, 0x0, 0xbf666666, 0xbe068a3a,
    0x0, 0x0, 0xbf666666, 0xbe07fbef,
    0x0, 0x0, 0xbf666666, 0xbe096dcf,
    0x0, 0x0, 0xbf666666, 0xbe0adfda,
    0x0, 0x0, 0xbf666666, 0xbe0c5211,
    0x0, 0x0, 0xbf666666, 0xbe0dc475,
    0x0, 0x0, 0xbf666666, 0xbe0f3705,
    0x0, 0x0, 0xbf666666, 0xbe10a9c2,
    0x0, 0x0, 0xbf666666, 0xbe121cad,
    0x0, 0x0, 0xbf666666, 0xbe138fc7,
    0x0, 0x0, 0xbf666666, 0xbe15030f,
    0x0, 0x0, 0xbf666666, 0xbe167686,
    0x0, 0x0, 0xbf666666, 0xbe17ea2d,
    0x0, 0x0, 0xbf666666, 0xbe195e04,
    0x0, 0x0, 0xbf666666, 0xbe1ad20b,
    0x0, 0x0, 0xbf666666, 0xbe1c4644,
    0x0, 0x0, 0xbf666666, 0xbe1dbaae,
    0x0, 0x0, 0xbf666666, 0xbe1f2f4a,
    0x0, 0x0, 0xbf666666, 0xbe20a419,
    0x0, 0x0, 0xbf666666, 0xbe22191b,
    0x0, 0x0, 0xbf666666, 0xbe238e50,
    0x0, 0x0, 0xbf666666, 0xbe2503ba,
    0x0, 0x0, 0xbf666666, 0xbe267958,
    0x0, 0x0, 0xbf666666, 0xbe27ef2b,
    0x0, 0x0, 0xbf666666, 0xbe296533,
    0x0, 0x0, 0xbf666666, 0xbe2adb72,
    0x0, 0x0, 0xbf666666, 0xbe2c51e7,
    0x0, 0x0, 0xbf666666, 0xbe2dc893,
    0x0, 0x0, 0xbf666666, 0xbe2f3f77,
    0x0, 0x0, 0xbf666666, 0xbe30b692,
    0x0, 0x0, 0xbf666666, 0xbe322de6,
    0x0, 0x0, 0xbf666666, 0xbe33a573,
    0x0, 0x0, 0xbf666666, 0xbe351d3a,
    0x0, 0x0, 0xbf666666, 0xbe36953a,
    0x0, 0x0, 0xbf666666, 0xbe380d76,
    0x0, 0x0, 0xbf666666, 0xbe3985ec,
    0x0, 0x0, 0xbf666666, 0xbe3afe9d,
    0x0, 0x0, 0xbf666666, 0xbe3c778b,
    0x0, 0x0, 0xbf666666, 0xbe3df0b6,
    0x0, 0x0, 0xbf666666, 0xbe3f6a1d,
    0x0, 0x0, 0xbf666666, 0xbe40e3c2,
    0x0, 0x0, 0xbf666666, 0xbe425da5,
    0x0, 0x0, 0xbf666666, 0xbe43d7c7,
    0x0, 0x0, 0xbf666666, 0xbe455227,
    0x0, 0x0, 0xbf666666, 0xbe46ccc8,
    0x0, 0x0, 0xbf666666, 0xbe4847a9,
    0x0, 0x0, 0xbf666666, 0xbe49c2ca,
    0x0, 0x0, 0xbf666666, 0xbe4b3e2c,
    0x0, 0x0, 0xbf666666, 0xbe4cb9d1,
    0x0, 0x0, 0xbf666666, 0xbe4e35b7,
    0x0, 0x0, 0xbf666666, 0xbe4fb1e0,
    0x0, 0x0, 0xbf666666, 0xbe512e4d,
    0x0, 0x0, 0xbf666666, 0xbe52aafe,
    0x0, 0x0, 0xbf666666, 0xbe5427f2,
    0x0, 0x0, 0xbf666666, 0xbe55a52c,
    0x0, 0x0, 0xbf666666, 0xbe5722ab,
    0x0, 0x0, 0xbf666666, 0xbe58a070,
    0x0, 0x0, 0xbf666666, 0xbe5a1e7c,
    0x0, 0x0, 0xbf666666, 0xbe5b9ccf,
    0x0, 0x0, 0xbf666666, 0xbe5d1b69,
    0x0, 0x0, 0xbf666666, 0xbe5e9a4b,
    0x0, 0x0, 0xbf666666, 0xbe601976,
    0x0, 0x0, 0xbf666666, 0xbe6198eb,
    0x0, 0x0, 0xbf666666, 0xbe6318a9,
    0x0, 0x0, 0xbf666666, 0xbe6498b1,
    0x0, 0x0, 0xbf666666, 0xbe661904,
    0x0, 0x0, 0xbf666666, 0xbe6799a3,
    0x0, 0x0, 0xbf666666, 0xbe691a8d,
    0x0, 0x0, 0xbf666666, 0xbe6a9bc4,
    0x0, 0x0, 0xbf666666, 0xbe6c1d48,
    0x0, 0x0, 0xbf666666, 0xbe6d9f1a,
    0x0, 0x0, 0xbf666666, 0xbe6f2139,
    0x0, 0x0, 0xbf666666, 0xbe70a3a8,
    0x0, 0x0, 0xbf666666, 0xbe722666,
    0x0, 0x0, 0xbf666666, 0xbe73a973,
    0x0, 0x0, 0xbf666666, 0xbe752cd1,
    0x0, 0x0, 0xbf666666, 0xbe76b080,
    0x0, 0x0, 0xbf666666, 0xbe783481,
    0x0, 0x0, 0xbf666666, 0xbe79b8d3,
    0x0, 0x0, 0xbf666666, 0xbe7b3d79,
    0x0, 0x0, 0xbf666666, 0xbe7cc271,
    0x0, 0x0, 0xbf666666, 0xbe7e47be,
    0x0, 0x0, 0xbf666666, 0xbe7fcd5e,
    0x0, 0x0, 0xbf666666, 0xbe80a9aa,
    0x0, 0x0, 0xbf666666, 0xbe816cd0,
    0x0, 0x0, 0xbf666666, 0xbe823020,
    0x0, 0x0, 0xbf666666, 0xbe82f39d,
    0x0, 0x0, 0xbf666666, 0xbe83b744,
    0x0, 0x0, 0xbf666666, 0xbe847b18,
    0x0, 0x0, 0xbf666666, 0xbe853f18,
    0x0, 0x0, 0xbf666666, 0xbe860344,
    0x0, 0x0, 0xbf666666, 0xbe86c79e,
    0x0, 0x0, 0xbf666666, 0xbe878c24,
    0x0, 0x0, 0xbf666666, 0xbe8850d8,
    0x0, 0x0, 0xbf666666, 0xbe8915b9,
    0x0, 0x0, 0xbf666666, 0xbe89dac9,
    0x0, 0x0, 0xbf666666, 0xbe8aa007,
    0x0, 0x0, 0xbf666666, 0xbe8b6573,
    0x0, 0x0, 0xbf666666, 0xbe8c2b0f,
    0x0, 0x0, 0xbf666666, 0xbe8cf0d9,
    0x0, 0x0, 0xbf666666, 0xbe8db6d4,
    0x0, 0x0, 0xbf666666, 0xbe8e7cfe,
    0x0, 0x0, 0xbf666666, 0xbe8f4358,
    0x0, 0x0, 0xbf666666, 0xbe9009e2,
    0x0, 0x0, 0xbf666666, 0xbe90d09e,
    0x0, 0x0, 0xbf666666, 0xbe91978a,
    0x0, 0x0, 0xbf666666, 0xbe925ea8,
    0x0, 0x0, 0xbf666666, 0xbe9325f8,
    0x0, 0x0, 0xbf666666, 0xbe93ed79,
    0x0, 0x0, 0xbf666666, 0xbe94b52d,
    0x0, 0x0, 0xbf666666, 0xbe957d14,
    0x0, 0x0, 0xbf666666, 0xbe96452d,
    0x0, 0x0, 0xbf666666, 0xbe970d7a,
    0x0, 0x0, 0xbf666666, 0xbe97d5fb,
    0x0, 0x0, 0xbf666666, 0xbe989eaf,
    0x0, 0x0, 0xbf666666, 0xbe996798,
    0x0, 0x0, 0xbf666666, 0xbe9a30b5,
    0x0, 0x0, 0xbf666666, 0xbe9afa07,
    0x0, 0x0, 0xbf666666, 0xbe9bc38e,
    0x0, 0x0, 0xbf666666, 0xbe9c8d4b,
    0x0, 0x0, 0xbf666666, 0xbe9d573d,
    0x0, 0x0, 0xbf666666, 0xbe9e2166,
    0x0, 0x0, 0xbf666666, 0xbe9eebc5,
    0x0, 0x0, 0xbf666666, 0xbe9fb65b,
    0x0, 0x0, 0xbf666666, 0xbea08129,
    0x0, 0x0, 0xbf666666, 0xbea14c2d,
    0x0, 0x0, 0xbf666666, 0xbea2176a,
    0x0, 0x0, 0xbf666666, 0xbea2e2df,
    0x0, 0x0, 0xbf666666, 0xbea3ae8c,
    0x0, 0x0, 0xbf666666, 0xbea47a72,
    0x0, 0x0, 0xbf666666, 0xbea54692,
    0x0, 0x0, 0xbf666666, 0xbea612eb,
    0x0, 0x0, 0xbf666666, 0xbea6df7e,
    0x0, 0x0, 0xbf666666, 0xbea7ac4b,
    0x0, 0x0, 0xbf666666, 0xbea87952,
    0x0, 0x0, 0xbf666666, 0xbea94695,
    0x0, 0x0, 0xbf666666, 0xbeaa1412,
    0x0, 0x0, 0xbf666666, 0xbeaae1cc,
    0x0, 0x0, 0xbf666666, 0xbeabafc1,
    0x0, 0x0, 0xbf666666, 0xbeac7df3,
    0x0, 0x0, 0xbf666666, 0xbead4c61,
    0x0, 0x0, 0xbf666666, 0xbeae1b0c,
    0x0, 0x0, 0xbf666666, 0xbeaee9f5,
    0x0, 0x0, 0xbf666666, 0xbeafb91b,
    0x0, 0x0, 0xbf666666, 0xbeb08880,
    0x0, 0x0, 0xbf666666, 0xbeb15822,
    0x0, 0x0, 0xbf666666, 0xbeb22804,
    0x0, 0x0, 0xbf666666, 0xbeb2f825,
    0x0, 0x0, 0xbf666666, 0xbeb3c885,
    0x0, 0x0, 0xbf666666, 0xbeb49926,
    0x0, 0x0, 0xbf666666, 0xbeb56a06,
    0x0, 0x0, 0xbf666666, 0xbeb63b27,
    0x0, 0x0, 0xbf666666, 0xbeb70c89,
    0x0, 0x0, 0xbf666666, 0xbeb7de2d,
    0x0, 0x0, 0xbf666666, 0xbeb8b012,
    0x0, 0x0, 0xbf666666, 0xbeb98239,
    0x0, 0x0, 0xbf666666, 0xbeba54a3,
    0x0, 0x0, 0xbf666666, 0xbebb2750,
    0x0, 0x0, 0xbf666666, 0xbebbfa40,
    0x0, 0x0, 0xbf666666, 0xbebccd73,
    0x0, 0x0, 0xbf666666, 0xbebda0eb,
    0x0, 0x0, 0xbf666666, 0xbebe74a7,
    0x0, 0x0, 0xbf666666, 0xbebf48a8,
    0x0, 0x0, 0xbf666666, 0xbec01cee,
    0x0, 0x0, 0xbf666666, 0xbec0f179,
    0x0, 0x0, 0xbf666666, 0xbec1c64a,
    0x0, 0x0, 0xbf666666, 0xbec29b62,
    0x0, 0x0, 0xbf666666, 0xbec370c1,
    0x0, 0x0, 0xbf666666, 0xbec44666,
    0x0, 0x0, 0xbf666666, 0xbec51c53,
    0x0, 0x0, 0xbf666666, 0xbec5f288,
    0x0, 0x0, 0xbf666666, 0xbec6c906,
    0x0, 0x0, 0xbf666666, 0xbec79fcc,
    0x0, 0x0, 0xbf666666, 0xbec876db,
    0x0, 0x0, 0xbf666666, 0xbec94e34,
    0x0, 0x0, 0xbf666666, 0xbeca25d6,
    0x0, 0x0, 0xbf666666, 0xbecafdc3,
    0x0, 0x0, 0xbf666666, 0xbecbd5fb,
    0x0, 0x0, 0xbf666666, 0xbeccae7e,
    0x0, 0x0, 0xbf666666, 0xbecd874c,
    0x0, 0x0, 0xbf666666, 0xbece6067,
    0x0, 0x0, 0xbf666666, 0xbecf39ce,
    0x0, 0x0, 0xbf666666, 0xbed01382,
    0x0, 0x0, 0xbf666666, 0xbed0ed83,
    0x0, 0x0, 0xbf666666, 0xbed1c7d1,
    0x0, 0x0, 0xbf666666, 0xbed2a26e,
    0x0, 0x0, 0xbf666666, 0xbed37d5a,
    0x0, 0x0, 0xbf666666, 0xbed45894,
    0x0, 0x0, 0xbf666666, 0xbed5341e,
    0x0, 0x0, 0xbf666666, 0xbed60ff7,
    0x0, 0x0, 0xbf666666, 0xbed6ec21,
    0x0, 0x0, 0xbf666666, 0xbed7c89c,
    0x0, 0x0, 0xbf666666, 0xbed8a567,
    0x0, 0x0, 0xbf666666, 0xbed98285,
    0x0, 0x0, 0xbf666666, 0xbeda5ff4,
    0x0, 0x0, 0xbf666666, 0xbedb3db6,
    0x0, 0x0, 0xbf666666, 0xbedc1bca,
    0x0, 0x0, 0xbf666666, 0xbedcfa33,
    0x0, 0x0, 0xbf666666, 0xbeddd8ee,
    0x0, 0x0, 0xbf666666, 0xbedeb7ff,
    0x0, 0x0, 0xbf666666, 0xbedf9764,
    0x0, 0x0, 0xbf666666, 0xbee0771e,
    0x0, 0x0, 0xbf666666, 0xbee1572e,
    0x0, 0x0, 0xbf666666, 0xbee23793,
    0x0, 0x0, 0xbf666666, 0xbee31850,
    0x0, 0x0, 0xbf666666, 0xbee3f964,
    0x0, 0x0, 0xbf666666, 0xbee4dacf,
    0x0, 0x0, 0xbf666666, 0xbee5bc92,
    0x0, 0x0, 0xbf666666, 0xbee69ead,
    0x0, 0x0, 0xbf666666, 0xbee78122,
    0x0, 0x0, 0xbf666666, 0xbee863f0,
    0x0, 0x0, 0xbf666666, 0xbee94718,
    0x0, 0x0, 0xbf666666, 0xbeea2a9a,
    0x0, 0x0, 0xbf666666, 0xbeeb0e77,
    0x0, 0x0, 0xbf666666, 0xbeebf2af,
    0x0, 0x0, 0xbf666666, 0xbeecd744,
    0x0, 0x0, 0xbf666666, 0xbeedbc34,
    0x0, 0x0, 0xbf666666, 0xbeeea182,
    0x0, 0x0, 0xbf666666, 0xbeef872d,
    0x0, 0x0, 0xbf666666, 0xbef06d35,
    0x0, 0x0, 0xbf666666, 0xbef1539c,
    0x0, 0x0, 0xbf666666, 0xbef23a62,
    0x0, 0x0, 0xbf666666, 0xbef32187,
    0x0, 0x0, 0xbf666666, 0xbef4090c,
    0x0, 0x0, 0xbf666666, 0xbef4f0f2,
    0x0, 0x0, 0xbf666666, 0xbef5d938,
    0x0, 0x0, 0xbf666666, 0xbef6c1e0,
    0x0, 0x0, 0xbf666666, 0xbef7aaea,
    0x0, 0x0, 0xbf666666, 0xbef89456,
    0x0, 0x0, 0xbf666666, 0xbef97e25,
    0x0, 0x0, 0xbf666666, 0xbefa6857,
    0x0, 0x0, 0xbf666666, 0xbefb52ee,
    0x0, 0x0, 0xbf666666, 0xbefc3de9,
    0x0, 0x0, 0xbf666666, 0xbefd294a,
    0x0, 0x0, 0xbf666666, 0xbefe1510,
    0x0, 0x0, 0xbf666666, 0xbeff013c,
    0x0, 0x0, 0xbf666666, 0xbeffedcf,
    0x0, 0x0, 0xbf666666, 0xbf006d64,
    0x0, 0x0, 0xbf666666, 0xbf00e415,
    0x0, 0x0, 0xbf666666, 0xbf015afb,
    0x0, 0x0, 0xbf666666, 0xbf01d214,
    0x0, 0x0, 0xbf666666, 0xbf024963,
    0x0, 0x0, 0xbf666666, 0xbf02c0e6,
    0x0, 0x0, 0xbf666666, 0xbf03389f,
    0x0, 0x0, 0xbf666666, 0xbf03b08d,
    0x0, 0x0, 0xbf666666, 0xbf0428b2,
    0x0, 0x0, 0xbf666666, 0xbf04a10c,
    0x0, 0x0, 0xbf666666, 0xbf05199d,
    0x0, 0x0, 0xbf666666, 0xbf059265,
    0x0, 0x0, 0xbf666666, 0xbf060b63,
    0x0, 0x0, 0xbf666666, 0xbf068499,
    0x0, 0x0, 0xbf666666, 0xbf06fe07,
    0x0, 0x0, 0xbf666666, 0xbf0777ad,
    0x0, 0x0, 0xbf666666, 0xbf07f18b,
    0x0, 0x0, 0xbf666666, 0xbf086ba1,
    0x0, 0x0, 0xbf666666, 0xbf08e5f0,
    0x0, 0x0, 0xbf666666, 0xbf096078,
    0x0, 0x0, 0xbf666666, 0xbf09db3a,
    0x0, 0x0, 0xbf666666, 0xbf0a5636,
    0x0, 0x0, 0xbf666666, 0xbf0ad16b,
    0x0, 0x0, 0xbf666666, 0xbf0b4cdb,
    0x0, 0x0, 0xbf666666, 0xbf0bc886,
    0x0, 0x0, 0xbf666666, 0xbf0c446b,
    0x0, 0x0, 0xbf666666, 0xbf0cc08c,
    0x0, 0x0, 0xbf666666, 0xbf0d3ce8,
    0x0, 0x0, 0xbf666666, 0xbf0db981,
    0x0, 0x0, 0xbf666666, 0xbf0e3655,
    0x0, 0x0, 0xbf666666, 0xbf0eb367,
    0x0, 0x0, 0xbf666666, 0xbf0f30b5,
    0x0, 0x0, 0xbf666666, 0xbf0fae40,
    0x0, 0x0, 0xbf666666, 0xbf102c09,
    0x0, 0x0, 0xbf666666, 0xbf10aa10,
    0x0, 0x0, 0xbf666666, 0xbf112855,
    0x0, 0x0, 0xbf666666, 0xbf11a6d8,
    0x0, 0x0, 0xbf666666, 0xbf12259a,
    0x0, 0x0, 0xbf666666, 0xbf12a49c,
    0x0, 0x0, 0xbf666666, 0xbf1323dd,
    0x0, 0x0, 0xbf666666, 0xbf13a35e,
    0x0, 0x0, 0xbf666666, 0xbf14231f,
    0x0, 0x0, 0xbf666666, 0xbf14a321,
    0x0, 0x0, 0xbf666666, 0xbf152364,
    0x0, 0x0, 0xbf666666, 0xbf15a3e8,
    0x0, 0x0, 0xbf666666, 0xbf1624ae,
    0x0, 0x0, 0xbf666666, 0xbf16a5b5,
    0x0, 0x0, 0xbf666666, 0xbf1726ff,
    0x0, 0x0, 0xbf666666, 0xbf17a88c,
    0x0, 0x0, 0xbf666666, 0xbf182a5c,
    0x0, 0x0, 0xbf666666, 0xbf18ac6f,
    0x0, 0x0, 0xbf666666, 0xbf192ec5,
    0x0, 0x0, 0xbf666666, 0xbf19b160,
    0x0, 0x0, 0xbf666666, 0xbf1a3440,
    0x0, 0x0, 0xbf666666, 0xbf1ab764,
    0x0, 0x0, 0xbf666666, 0xbf1b3ace,
    0x0, 0x0, 0xbf666666, 0xbf1bbe7d,
    0x0, 0x0, 0xbf666666, 0xbf1c4272,
    0x0, 0x0, 0xbf666666, 0xbf1cc6ae,
    0x0, 0x0, 0xbf666666, 0xbf1d4b30,
    0x0, 0x0, 0xbf666666, 0xbf1dcff9,
    0x0, 0x0, 0xbf666666, 0xbf1e550a,
    0x0, 0x0, 0xbf666666, 0xbf1eda63,
    0x0, 0x0, 0xbf666666, 0xbf1f6004,
    0x0, 0x0, 0xbf666666, 0xbf1fe5ee,
    0x0, 0x0, 0xbf666666, 0xbf206c21,
    0x0, 0x0, 0xbf666666, 0xbf20f29d,
    0x0, 0x0, 0xbf666666, 0xbf217963,
    0x0, 0x0, 0xbf666666, 0xbf220074,
    0x0, 0x0, 0xbf666666, 0xbf2287cf,
    0x0, 0x0, 0xbf666666, 0xbf230f75,
    0x0, 0x0, 0xbf666666, 0xbf239766,
    0x0, 0x0, 0xbf666666, 0xbf241fa4,
    0x0, 0x0, 0xbf666666, 0xbf24a82e,
    0x0, 0x0, 0xbf666666, 0xbf253104,
    0x0, 0x0, 0xbf666666, 0xbf25ba28,
    0x0, 0x0, 0xbf666666, 0xbf264399,
    0x0, 0x0, 0xbf666666, 0xbf26cd59,
    0x0, 0x0, 0xbf666666, 0xbf275766,
    0x0, 0x0, 0xbf666666, 0xbf27e1c3,
    0x0, 0x0, 0xbf666666, 0xbf286c6f,
    0x0, 0x0, 0xbf666666, 0xbf28f76a,
    0x0, 0x0, 0xbf666666, 0xbf2982b6,
    0x0, 0x0, 0xbf666666, 0xbf2a0e52,
    0x0, 0x0, 0xbf666666, 0xbf2a9a3f,
    0x0, 0x0, 0xbf666666, 0xbf2b267e,
    0x0, 0x0, 0xbf666666, 0xbf2bb30e,
    0x0, 0x0, 0xbf666666, 0xbf2c3ff1,
    0x0, 0x0, 0xbf666666, 0xbf2ccd27,
    0x0, 0x0, 0xbf666666, 0xbf2d5ab0,
    0x0, 0x0, 0xbf666666, 0xbf2de88d,
    0x0, 0x0, 0xbf666666, 0xbf2e76be,
    0x0, 0x0, 0xbf666666, 0xbf2f0544,
    0x0, 0x0, 0xbf666666, 0xbf2f941f,
    0x0, 0x0, 0xbf666666, 0xbf30234f,
    0x0, 0x0, 0xbf666666, 0xbf30b2d5,
    0x0, 0x0, 0xbf666666, 0xbf3142b2,
    0x0, 0x0, 0xbf666666, 0xbf31d2e6,
    0x0, 0x0, 0xbf666666, 0xbf326372,
    0x0, 0x0, 0xbf666666, 0xbf32f456,
    0x0, 0x0, 0xbf666666, 0xbf338592,
    0x0, 0x0, 0xbf666666, 0xbf341727,
    0x0, 0x0, 0xbf666666, 0xbf34a915,
    0x0, 0x0, 0xbf666666, 0xbf353b5e,
    0x0, 0x0, 0xbf666666, 0xbf35ce01,
    0x0, 0x0, 0xbf666666, 0xbf3660ff,
    0x0, 0x0, 0xbf666666, 0xbf36f458,
    0x0, 0x0, 0xbf666666, 0xbf37880e,
    0x0, 0x0, 0xbf666666, 0xbf381c20,
    0x0, 0x0, 0xbf666666, 0xbf38b08f,
    0x0, 0x0, 0xbf666666, 0xbf39455b,
    0x0, 0x0, 0xbf666666, 0xbf39da86,
    0x0, 0x0, 0xbf666666, 0xbf3a700f,
    0x0, 0x0, 0xbf666666, 0xbf3b05f8,
    0x0, 0x0, 0xbf666666, 0xbf3b9c40,
    0x0, 0x0, 0xbf666666, 0xbf3c32e9,
    0x0, 0x0, 0xbf666666, 0xbf3cc9f2,
    0x0, 0x0, 0xbf666666, 0xbf3d615c,
    0x0, 0x0, 0xbf666666, 0xbf3df929,
    0x0, 0x0, 0xbf666666, 0xbf3e9157,
    0x0, 0x0, 0xbf666666, 0xbf3f29e9,
    0x0, 0x0, 0xbf666666, 0xbf3fc2df,
    0x0, 0x0, 0xbf666666, 0xbf405c38,
    0x0, 0x0, 0xbf666666, 0xbf40f5f6,
    0x0, 0x0, 0xbf666666, 0xbf41901a,
    0x0, 0x0, 0xbf666666, 0xbf422aa3,
    0x0, 0x0, 0xbf666666, 0xbf42c592,
    0x0, 0x0, 0xbf666666, 0xbf4360e9,
    0x0, 0x0, 0xbf666666, 0xbf43fca7,
    0x0, 0x0, 0xbf666666, 0xbf4498ce,
    0x0, 0x0, 0xbf666666, 0xbf45355d,
    0x0, 0x0, 0xbf666666, 0xbf45d256,
    0x0, 0x0, 0xbf666666, 0xbf466fb8,
    0x0, 0x0, 0xbf666666, 0xbf470d85,
    0x0, 0x0, 0xbf666666, 0xbf47abbe,
    0x0, 0x0, 0xbf666666, 0xbf484a62,
    0x0, 0x0, 0xbf666666, 0xbf48e973,
    0x0, 0x0, 0xbf666666, 0xbf4988f1,
    0x0, 0x0, 0xbf666666, 0xbf4a28dc,
    0x0, 0x0, 0xbf666666, 0xbf4ac936,
    0x0, 0x0, 0xbf666666, 0xbf4b69ff,
    0x0, 0x0, 0xbf666666, 0xbf4c0b37,
    0x0, 0x0, 0xbf666666, 0xbf4cace0,
    0x0, 0x0, 0xbf666666, 0xbf4d4efa,
    0x0, 0x0, 0xbf666666, 0xbf4df185,
    0x0, 0x0, 0xbf666666, 0xbf4e9483,
    0x0, 0x0, 0xbf666666, 0xbf4f37f3,
    0x0, 0x0, 0xbf666666, 0xbf4fdbd8,
    0x0, 0x0, 0xbf666666, 0xbf508030,
    0x0, 0x0, 0xbf666666, 0xbf5124fd,
    0x0, 0x0, 0xbf666666, 0xbf51ca40,
    0x0, 0x0, 0xbf666666, 0xbf526ffa,
    0x0, 0x0, 0xbf666666, 0xbf53162a,
    0x0, 0x0, 0xbf666666, 0xbf53bcd3,
    0x0, 0x0, 0xbf666666, 0xbf5463f3,
    0x0, 0x0, 0xbf666666, 0xbf550b8d,
    0x0, 0x0, 0xbf666666, 0xbf55b3a1,
    0x0, 0x0, 0xbf666666, 0xbf565c2f,
    0x0, 0x0, 0xbf666666, 0xbf570539,
    0x0, 0x0, 0xbf666666, 0xbf57aebf,
    0x0, 0x0, 0xbf666666, 0xbf5858c1,
    0x0, 0x0, 0xbf666666, 0xbf590341,
    0x0, 0x0, 0xbf666666, 0xbf59ae40,
    0x0, 0x0, 0xbf666666, 0xbf5a59be,
    0x0, 0x0, 0xbf666666, 0xbf5b05bb,
    0x0, 0x0, 0xbf666666, 0xbf5bb239,
    0x0, 0x0, 0xbf666666, 0xbf5c5f38,
    0x0, 0x0, 0xbf666666, 0xbf5d0cba,
    0x0, 0x0, 0xbf666666, 0xbf5dbabe,
    0x0, 0x0, 0xbf666666, 0xbf5e6946,
    0x0, 0x0, 0xbf666666, 0xbf5f1853,
    0x0, 0x0, 0xbf666666, 0xbf5fc7e5,
    0x0, 0x0, 0xbf666666, 0xbf6077fd,
    0x0, 0x0, 0xbf666666, 0xbf61289c,
    0x0, 0x0, 0xbf666666, 0xbf61d9c3,
    0x0, 0x0, 0xbf666666, 0xbf628b72,
    0x0, 0x0, 0xbf666666, 0xbf633dab,
    0x0, 0x0, 0xbf666666, 0xbf63f06e,
    0x0, 0x0, 0xbf666666, 0xbf64a3bd,
    0x0, 0x0, 0xbf666666, 0xbf655797,
    0x0, 0x0, 0xbf666666, 0xbf660bfe,
    0x0, 0x0, 0xbf666666, 0xbf66c0f3,
    0x0, 0x0, 0xbf666666, 0xbf677676,
    0x0, 0x0, 0xbf666666, 0xbf682c88,
    0x0, 0x0, 0xbf666666, 0xbf68e32c,
    0x0, 0x0, 0xbf666666, 0xbf699a60,
    0x0, 0x0, 0xbf666666, 0xbf6a5226,
    0x0, 0x0, 0xbf666666, 0xbf6b0a7f,
    0x0, 0x0, 0xbf666666, 0xbf6bc36d,
    0x0, 0x0, 0xbf666666, 0xbf6c7cef,
    0x0, 0x0, 0xbf666666, 0xbf6d3707,
    0x0, 0x0, 0xbf666666, 0xbf6df1b6,
    0x0, 0x0, 0xbf666666, 0xbf6eacfc,
    0x0, 0x0, 0xbf666666, 0xbf6f68db,
    0x0, 0x0, 0xbf666666, 0xbf702553,
    0x0, 0x0, 0xbf666666, 0xbf70e266,
    0x0, 0x0, 0xbf666666, 0xbf71a015,
    0x0, 0x0, 0xbf666666, 0xbf725e60,
    0x0, 0x0, 0xbf666666, 0xbf731d49,
    0x0, 0x0, 0xbf666666, 0xbf73dcd0,
    0x0, 0x0, 0xbf666666, 0xbf749cf6,
    0x0, 0x0, 0xbf666666, 0xbf755dbd,
    0x0, 0x0, 0xbf666666, 0xbf761f25,
    0x0, 0x0, 0xbf666666, 0xbf76e130,
    0x0, 0x0, 0xbf666666, 0xbf77a3df,
    0x0, 0x0, 0xbf666666, 0xbf786732,
    0x0, 0x0, 0xbf666666, 0xbf792b2b,
    0x0, 0x0, 0xbf666666, 0xbf79efcb,
    0x0, 0x0, 0xbf666666, 0xbf7ab512,
    0x0, 0x0, 0xbf666666, 0xbf7b7b02,
    0x0, 0x0, 0xbf666666, 0xbf7c419c,
    0x0, 0x0, 0xbf666666, 0xbf7d08e2,
    0x0, 0x0, 0xbf666666, 0xbf7dd0d3,
    0x0, 0x0, 0xbf666666, 0xbf7e9972,
    0x0, 0x0, 0xbf666666, 0xbf7f62bf,
    0x0, 0x0, 0xbf666666, 0xbf80165e,
    0x0, 0x0, 0xbf666666, 0xbf807bb5,
    0x0, 0x0, 0xbf666666, 0xbf80e164,
    0x0, 0x0, 0xbf666666, 0xbf81476d,
    0x0, 0x0, 0xbf666666, 0xbf81add1,
    0x0, 0x0, 0xbf666666, 0xbf82148e,
    0x0, 0x0, 0xbf666666, 0xbf827ba8,
    0x0, 0x0, 0xbf666666, 0xbf82e31d,
    0x0, 0x0, 0xbf666666, 0xbf834aee,
    0x0, 0x0, 0xbf666666, 0xbf83b31d,
    0x0, 0x0, 0xbf666666, 0xbf841ba9,
    0x0, 0x0, 0xbf666666, 0xbf848494,
    0x0, 0x0, 0xbf666666, 0xbf84eddd,
    0x0, 0x0, 0xbf666666, 0xbf855786,
    0x0, 0x0, 0xbf666666, 0xbf85c190,
    0x0, 0x0, 0xbf666666, 0xbf862bfa,
    0x0, 0x0, 0xbf666666, 0xbf8696c6,
    0x0, 0x0, 0xbf666666, 0xbf8701f4,
    0x0, 0x0, 0xbf666666, 0xbf876d85,
    0x0, 0x0, 0xbf666666, 0xbf87d979,
    0x0, 0x0, 0xbf666666, 0xbf8845d2,
    0x0, 0x0, 0xbf666666, 0xbf88b28f,
    0x0, 0x0, 0xbf666666, 0xbf891fb2,
    0x0, 0x0, 0xbf666666, 0xbf898d3b,
    0x0, 0x0, 0xbf666666, 0xbf89fb2b,
    0x0, 0x0, 0xbf666666, 0xbf8a6982,
    0x0, 0x0, 0xbf666666, 0xbf8ad842,
    0x0, 0x0, 0xbf666666, 0xbf8b476b,
    0x0, 0x0, 0xbf666666, 0xbf8bb6fe,
    0x0, 0x0, 0xbf666666, 0xbf8c26fb,
    0x0, 0x0, 0xbf666666, 0xbf8c9763,
    0x0, 0x0, 0xbf666666, 0xbf8d0837,
    0x0, 0x0, 0xbf666666, 0xbf8d7978,
    0x0, 0x0, 0xbf666666, 0xbf8deb27,
    0x0, 0x0, 0xbf666666, 0xbf8e5d44,
    0x0, 0x0, 0xbf666666, 0xbf8ecfcf,
    0x0, 0x0, 0xbf666666, 0xbf8f42ca,
    0x0, 0x0, 0xbf666666, 0xbf8fb636,
    0x0, 0x0, 0xbf666666, 0xbf902a13,
    0x0, 0x0, 0xbf666666, 0xbf909e63,
    0x0, 0x0, 0xbf666666, 0xbf911325,
    0x0, 0x0, 0xbf666666, 0xbf91885b,
    0x0, 0x0, 0xbf666666, 0xbf91fe05,
    0x0, 0x0, 0xbf666666, 0xbf927425,
    0x0, 0x0, 0xbf666666, 0xbf92eabb,
    0x0, 0x0, 0xbf666666, 0xbf9361c8,
    0x0, 0x0, 0xbf666666, 0xbf93d94c,
    0x0, 0x0, 0xbf666666, 0xbf94514a,
    0x0, 0x0, 0xbf666666, 0xbf94c9c1,
    0x0, 0x0, 0xbf666666, 0xbf9542b2,
    0x0, 0x0, 0xbf666666, 0xbf95bc1f,
    0x0, 0x0, 0xbf666666, 0xbf963608,
    0x0, 0x0, 0xbf666666, 0xbf96b06e,
    0x0, 0x0, 0xbf666666, 0xbf972b53,
    0x0, 0x0, 0xbf666666, 0xbf97a6b6,
    0x0, 0x0, 0xbf666666, 0xbf982298,
    0x0, 0x0, 0xbf666666, 0xbf989efc,
    0x0, 0x0, 0xbf666666, 0xbf991be1,
    0x0, 0x0, 0xbf666666, 0xbf999949,
    0x0, 0x0, 0xbf666666, 0xbf9a1735,
    0x0, 0x0, 0xbf666666, 0xbf9a95a5,
    0x0, 0x0, 0xbf666666, 0xbf9b149a,
    0x0, 0x0, 0xbf666666, 0xbf9b9417,
    0x0, 0x0, 0xbf666666, 0xbf9c141a,
    0x0, 0x0, 0xbf666666, 0xbf9c94a6,
    0x0, 0x0, 0xbf666666, 0xbf9d15bc,
    0x0, 0x0, 0xbf666666, 0xbf9d975c,
    0x0, 0x0, 0xbf666666, 0xbf9e1988,
    0x0, 0x0, 0xbf666666, 0xbf9e9c40,
    0x0, 0x0, 0xbf666666, 0xbf9f1f86,
    0x0, 0x0, 0xbf666666, 0xbf9fa35b,
    0x0, 0x0, 0xbf666666, 0xbfa027c0,
    0x0, 0x0, 0xbf666666, 0xbfa0acb5,
    0x0, 0x0, 0xbf666666, 0xbfa1323c,
    0x0, 0x0, 0xbf666666, 0xbfa1b857,
    0x0, 0x0, 0xbf666666, 0xbfa23f05,
    0x0, 0x0, 0xbf666666, 0xbfa2c649,
    0x0, 0x0, 0xbf666666, 0xbfa34e23,
    0x0, 0x0, 0xbf666666, 0xbfa3d695,
    0x0, 0x0, 0xbf666666, 0xbfa45fa0,
    0x0, 0x0, 0xbf666666, 0xbfa4e945,
    0x0, 0x0, 0xbf666666, 0xbfa57384,
    0x0, 0x0, 0xbf666666, 0xbfa5fe60,
    0x0, 0x0, 0xbf666666, 0xbfa689da,
    0x0, 0x0, 0xbf666666, 0xbfa715f2,
    0x0, 0x0, 0xbf666666, 0xbfa7a2aa,
    0x0, 0x0, 0xbf666666, 0xbfa83003,
    0x0, 0x0, 0xbf666666, 0xbfa8bdff,
    0x0, 0x0, 0xbf666666, 0xbfa94c9e,
    0x0, 0x0, 0xbf666666, 0xbfa9dbe3,
    0x0, 0x0, 0xbf666666, 0xbfaa6bcd,
    0x0, 0x0, 0xbf666666, 0xbfaafc60,
    0x0, 0x0, 0xbf666666, 0xbfab8d9b,
    0x0, 0x0, 0xbf666666, 0xbfac1f80,
    0x0, 0x0, 0xbf666666, 0xbfacb211,
    0x0, 0x0, 0xbf666666, 0xbfad454f,
    0x0, 0x0, 0xbf666666, 0xbfadd93c,
    0x0, 0x0, 0xbf666666, 0xbfae6dd8,
    0x0, 0x0, 0xbf666666, 0xbfaf0325,
    0x0, 0x0, 0xbf666666, 0xbfaf9925,
    0x0, 0x0, 0xbf666666, 0xbfb02fd9,
    0x0, 0x0, 0xbf666666, 0xbfb0c742,
    0x0, 0x0, 0xbf666666, 0xbfb15f62,
    0x0, 0x0, 0xbf666666, 0xbfb1f83a,
    0x0, 0x0, 0xbf666666, 0xbfb291cd,
    0x0, 0x0, 0xbf666666, 0xbfb32c1b,
    0x0, 0x0, 0xbf666666, 0xbfb3c726,
    0x0, 0x0, 0xbf666666, 0xbfb462ef,
    0x0, 0x0, 0xbf666666, 0xbfb4ff78,
    0x0, 0x0, 0xbf666666, 0xbfb59cc3,
    0x0, 0x0, 0xbf666666, 0xbfb63ad1,
    0x0, 0x0, 0xbf666666, 0xbfb6d9a4,
    0x0, 0x0, 0xbf666666, 0xbfb7793e,
    0x0, 0x0, 0xbf666666, 0xbfb8199f,
    0x0, 0x0, 0xbf666666, 0xbfb8bacb,
    0x0, 0x0, 0xbf666666, 0xbfb95cc2,
    0x0, 0x0, 0xbf666666, 0xbfb9ff86,
    0x0, 0x0, 0xbf666666, 0xbfbaa319,
    0x0, 0x0, 0xbf666666, 0xbfbb477d,
    0x0, 0x0, 0xbf666666, 0xbfbbecb3,
    0x0, 0x0, 0xbf666666, 0xbfbc92bd,
    0x0, 0x0, 0xbf666666, 0xbfbd399d,
    0x0, 0x0, 0xbf666666, 0xbfbde155,
    0x0, 0x0, 0xbf666666, 0xbfbe89e7,
    0x0, 0x0, 0xbf666666, 0xbfbf3354,
    0x0, 0x0, 0xbf666666, 0xbfbfdd9f,
    0x0, 0x0, 0xbf666666, 0xbfc088c9,
    0x0, 0x0, 0xbf666666, 0xbfc134d5,
    0x0, 0x0, 0xbf666666, 0xbfc1e1c3,
    0x0, 0x0, 0xbf666666, 0xbfc28f97,
    0x0, 0x0, 0xbf666666, 0xbfc33e52,
    0x0, 0x0, 0xbf666666, 0xbfc3edf6,
    0x0, 0x0, 0xbf666666, 0xbfc49e85,
    0x0, 0x0, 0xbf666666, 0xbfc55002,
    0x0, 0x0, 0xbf666666, 0xbfc6026e,
    0x0, 0x0, 0xbf666666, 0xbfc6b5cb,
    0x0, 0x0, 0xbf666666, 0xbfc76a1c,
    0x0, 0x0, 0xbf666666, 0xbfc81f63,
    0x0, 0x0, 0xbf666666, 0xbfc8d5a2,
    0x0, 0x0, 0xbf666666, 0xbfc98cdb,
    0x0, 0x0, 0xbf666666, 0xbfca4511,
    0x0, 0x0, 0xbf666666, 0xbfcafe45,
    0x0, 0x0, 0xbf666666, 0xbfcbb87b,
    0x0, 0x0, 0xbf666666, 0xbfcc73b3,
    0x0, 0x0, 0xbf666666, 0xbfcd2ff1,
    0x0, 0x0, 0xbf666666, 0xbfcded38,
    0x0, 0x0, 0xbf666666, 0xbfceab89,
    0x0, 0x0, 0xbf666666, 0xbfcf6ae6,
    0x0, 0x0, 0xbf666666, 0xbfd02b53,
    0x0, 0x0, 0xbf666666, 0xbfd0ecd2,
    0x0, 0x0, 0xbf666666, 0xbfd1af66,
    0x0, 0x0, 0xbf666666, 0xbfd27310,
    0x0, 0x0, 0xbf666666, 0xbfd337d4,
    0x0, 0x0, 0xbf666666, 0xbfd3fdb4,
    0x0, 0x0, 0xbf666666, 0xbfd4c4b2,
    0x0, 0x0, 0xbf666666, 0xbfd58cd3,
    0x0, 0x0, 0xbf666666, 0xbfd65617,
    0x0, 0x0, 0xbf666666, 0xbfd72082,
    0x0, 0x0, 0xbf666666, 0xbfd7ec17,
    0x0, 0x0, 0xbf666666, 0xbfd8b8d9,
    0x0, 0x0, 0xbf666666, 0xbfd986ca,
    0x0, 0x0, 0xbf666666, 0xbfda55ee,
    0x0, 0x0, 0xbf666666, 0xbfdb2646,
    0x0, 0x0, 0xbf666666, 0xbfdbf7d7,
    0x0, 0x0, 0xbf666666, 0xbfdccaa3,
    0x0, 0x0, 0xbf666666, 0xbfdd9ead,
    0x0, 0x0, 0xbf666666, 0xbfde73f9,
    0x0, 0x0, 0xbf666666, 0xbfdf4a89,
    0x0, 0x0, 0xbf666666, 0xbfe02260,
    0x0, 0x0, 0xbf666666, 0xbfe0fb83,
    0x0, 0x0, 0xbf666666, 0xbfe1d5f3,
    0x0, 0x0, 0xbf666666, 0xbfe2b1b5,
    0x0, 0x0, 0xbf666666, 0xbfe38ecc,
    0x0, 0x0, 0xbf666666, 0xbfe46d3a,
    0x0, 0x0, 0xbf666666, 0xbfe54d04,
    0x0, 0x0, 0xbf666666, 0xbfe62e2d,
    0x0, 0x0, 0xbf666666, 0xbfe710b9,
    0x0, 0x0, 0xbf666666, 0xbfe7f4aa,
    0x0, 0x0, 0xbf666666, 0xbfe8da05,
    0x0, 0x0, 0xbf666666, 0xbfe9c0cd,
    0x0, 0x0, 0xbf666666, 0xbfeaa906,
    0x0, 0x0, 0xbf666666, 0xbfeb92b4,
    0x0, 0x0, 0xbf666666, 0xbfec7dda,
    0x0, 0x0, 0xbf666666, 0xbfed6a7d,
    0x0, 0x0, 0xbf666666, 0xbfee58a0,
    0x0, 0x0, 0xbf666666, 0xbfef4847,
    0x0, 0x0, 0xbf666666, 0xbff03976,
    0x0, 0x0, 0xbf666666, 0xbff12c32,
    0x0, 0x0, 0xbf666666, 0xbff2207d,
    0x0, 0x0, 0xbf666666, 0xbff3165e,
    0x0, 0x0, 0xbf666666, 0xbff40dd7,
    0x0, 0x0, 0xbf666666, 0xbff506ee,
    0x0, 0x0, 0xbf666666, 0xbff601a6,
    0x0, 0x0, 0xbf666666, 0xbff6fe03,
    0x0, 0x0, 0xbf666666, 0xbff7fc0c,
    0x0, 0x0, 0xbf666666, 0xbff8fbc3,
    0x0, 0x0, 0xbf666666, 0xbff9fd2d,
    0x0, 0x0, 0xbf666666, 0xbffb0050,
    0x0, 0x0, 0xbf666666, 0xbffc0530,
    0x0, 0x0, 0xbf666666, 0xbffd0bd1,
    0x0, 0x0, 0xbf666666, 0xbffe1439,
    0x0, 0x0, 0xbf666666, 0xbfff1e6d,
    0x0, 0x0, 0xbf666666, 0xc0001539,
    0x0, 0x0, 0xbf666666, 0xc0009c26,
    0x0, 0x0, 0xbf666666, 0xc0012400,
    0x0, 0x0, 0xbf666666, 0xc001acca,
    0x0, 0x0, 0xbf666666, 0xc0023687,
    0x0, 0x0, 0xbf666666, 0xc002c13a,
    0x0, 0x0, 0xbf666666, 0xc0034ce5,
    0x0, 0x0, 0xbf666666, 0xc003d98a,
    0x0, 0x0, 0xbf666666, 0xc004672e,
    0x0, 0x0, 0xbf666666, 0xc004f5d2,
    0x0, 0x0, 0xbf666666, 0xc0058579,
    0x0, 0x0, 0xbf666666, 0xc0061627,
    0x0, 0x0, 0xbf666666, 0xc006a7df,
    0x0, 0x0, 0xbf666666, 0xc0073aa3,
    0x0, 0x0, 0xbf666666, 0xc007ce76,
    0x0, 0x0, 0xbf666666, 0xc008635c,
    0x0, 0x0, 0xbf666666, 0xc008f959,
    0x0, 0x0, 0xbf666666, 0xc009906e,
    0x0, 0x0, 0xbf666666, 0xc00a28a0,
    0x0, 0x0, 0xbf666666, 0xc00ac1f1,
    0x0, 0x0, 0xbf666666, 0xc00b5c66,
    0x0, 0x0, 0xbf666666, 0xc00bf801,
    0x0, 0x0, 0xbf666666, 0xc00c94c7,
    0x0, 0x0, 0xbf666666, 0xc00d32ba,
    0x0, 0x0, 0xbf666666, 0xc00dd1de,
    0x0, 0x0, 0xbf666666, 0xc00e7237,
    0x0, 0x0, 0xbf666666, 0xc00f13c9,
    0x0, 0x0, 0xbf666666, 0xc00fb697,
    0x0, 0x0, 0xbf666666, 0xc0105aa6,
    0x0, 0x0, 0xbf666666, 0xc010fff9,
    0x0, 0x0, 0xbf666666, 0xc011a693,
    0x0, 0x0, 0xbf666666, 0xc0124e7a,
    0x0, 0x0, 0xbf666666, 0xc012f7b2,
    0x0, 0x0, 0xbf666666, 0xc013a23d,
    0x0, 0x0, 0xbf666666, 0xc0144e22,
    0x0, 0x0, 0xbf666666, 0xc014fb63,
    0x0, 0x0, 0xbf666666, 0xc015aa06,
    0x0, 0x0, 0xbf666666, 0xc0165a0e,
    0x0, 0x0, 0xbf666666, 0xc0170b81,
    0x0, 0x0, 0xbf666666, 0xc017be63,
    0x0, 0x0, 0xbf666666, 0xc01872b8,
    0x0, 0x0, 0xbf666666, 0xc0192886,
    0x0, 0x0, 0xbf666666, 0xc019dfd1,
    0x0, 0x0, 0xbf666666, 0xc01a989e,
    0x0, 0x0, 0xbf666666, 0xc01b52f2,
    0x0, 0x0, 0xbf666666, 0xc01c0ed3,
    0x0, 0x0, 0xbf666666, 0xc01ccc45,
    0x0, 0x0, 0xbf666666, 0xc01d8b4e,
    0x0, 0x0, 0xbf666666, 0xc01e4bf3,
    0x0, 0x0, 0xbf666666, 0xc01f0e39,
    0x0, 0x0, 0xbf666666, 0xc01fd227,
    0x0, 0x0, 0xbf666666, 0xc02097c1,
    0x0, 0x0, 0xbf666666, 0xc0215f0e,
    0x0, 0x0, 0xbf666666, 0xc0222813,
    0x0, 0x0, 0xbf666666, 0xc022f2d7,
    0x0, 0x0, 0xbf666666, 0xc023bf60,
    0x0, 0x0, 0xbf666666, 0xc0248db2,
    0x0, 0x0, 0xbf666666, 0xc0255dd6,
    0x0, 0x0, 0xbf666666, 0xc0262fd2,
    0x0, 0x0, 0xbf666666, 0xc02703ab,
    0x0, 0x0, 0xbf666666, 0xc027d969,
    0x0, 0x0, 0xbf666666, 0xc028b112,
    0x0, 0x0, 0xbf666666, 0xc0298aae,
    0x0, 0x0, 0xbf666666, 0xc02a6642,
    0x0, 0x0, 0xbf666666, 0xc02b43d8,
    0x0, 0x0, 0xbf666666, 0xc02c2375,
    0x0, 0x0, 0xbf666666, 0xc02d0521,
    0x0, 0x0, 0xbf666666, 0xc02de8e5,
    0x0, 0x0, 0xbf666666, 0xc02ecec7,
    0x0, 0x0, 0xbf666666, 0xc02fb6cf,
    0x0, 0x0, 0xbf666666, 0xc030a106,
    0x0, 0x0, 0xbf666666, 0xc0318d74,
    0x0, 0x0, 0xbf666666, 0xc0327c21,
    0x0, 0x0, 0xbf666666, 0xc0336d15,
    0x0, 0x0, 0xbf666666, 0xc034605a,
    0x0, 0x0, 0xbf666666, 0xc03555f8,
    0x0, 0x0, 0xbf666666, 0xc0364df9,
    0x0, 0x0, 0xbf666666, 0xc0374865,
    0x0, 0x0, 0xbf666666, 0xc0384545,
    0x0, 0x0, 0xbf666666, 0xc03944a5,
    0x0, 0x0, 0xbf666666, 0xc03a468c,
    0x0, 0x0, 0xbf666666, 0xc03b4b06,
    0x0, 0x0, 0xbf666666, 0xc03c521d,
    0x0, 0x0, 0xbf666666, 0xc03d5bda,
    0x0, 0x0, 0xbf666666, 0xc03e6849,
    0x0, 0x0, 0xbf666666, 0xc03f7774,
    0x0, 0x0, 0xbf666666, 0xc0408968,
    0x0, 0x0, 0xbf666666, 0xc0419e2e,
    0x0, 0x0, 0xbf666666, 0xc042b5d2,
    0x0, 0x0, 0xbf666666, 0xc043d061,
    0x0, 0x0, 0xbf666666, 0xc044ede6,
    0x0, 0x0, 0xbf666666, 0xc0460e6e,
    0x0, 0x0, 0xbf666666, 0xc0473205,
    0x0, 0x0, 0xbf666666, 0xc04858b8,
    0x0, 0x0, 0xbf666666, 0xc0498295,
    0x0, 0x0, 0xbf666666, 0xc04aafa9,
    0x0, 0x0, 0xbf666666, 0xc04be001,
    0x0, 0x0, 0xbf666666, 0xc04d13ac,
    0x0, 0x0, 0xbf666666, 0xc04e4ab8,
    0x0, 0x0, 0xbf666666, 0xc04f8534,
    0x0, 0x0, 0xbf666666, 0xc050c32f,
    0x0, 0x0, 0xbf666666, 0xc05204b7,
    0x0, 0x0, 0xbf666666, 0xc05349de,
    0x0, 0x0, 0xbf666666, 0xc05492b3,
    0x0, 0x0, 0xbf666666, 0xc055df46,
    0x0, 0x0, 0xbf666666, 0xc0572fa9,
    0x0, 0x0, 0xbf666666, 0xc05883ec,
    0x0, 0x0, 0xbf666666, 0xc059dc22,
    0x0, 0x0, 0xbf666666, 0xc05b385d,
    0x0, 0x0, 0xbf666666, 0xc05c98ae,
    0x0, 0x0, 0xbf666666, 0xc05dfd29,
    0x0, 0x0, 0xbf666666, 0xc05f65e2,
    0x0, 0x0, 0xbf666666, 0xc060d2ec,
    0x0, 0x0, 0xbf666666, 0xc062445c,
    0x0, 0x0, 0xbf666666, 0xc063ba47,
    0x0, 0x0, 0xbf666666, 0xc06534c2,
    0x0, 0x0, 0xbf666666, 0xc066b3e3,
    0x0, 0x0, 0xbf666666, 0xc06837c0,
    0x0, 0x0, 0xbf666666, 0xc069c072,
    0x0, 0x0, 0xbf666666, 0xc06b4e0f,
    0x0, 0x0, 0xbf666666, 0xc06ce0af,
    0x0, 0x0, 0xbf666666, 0xc06e786d,
    0x0, 0x0, 0xbf666666, 0xc0701560,
    0x0, 0x0, 0xbf666666, 0xc071b7a5,
    0x0, 0x0, 0xbf666666, 0xc0735f54,
    0x0, 0x0, 0xbf666666, 0xc0750c8b,
    0x0, 0x0, 0xbf666666, 0xc076bf66,
    0x0, 0x0, 0xbf666666, 0xc0787801,
    0x0, 0x0, 0xbf666666, 0xc07a367b,
    0x0, 0x0, 0xbf666666, 0xc07bfaf2,
    0x0, 0x0, 0xbf666666, 0xc07dc587,
    0x0, 0x0, 0xbf666666, 0xc07f9659,
    0x0, 0x0, 0xbf666666, 0xc080b6c5,
    0x0, 0x0, 0xbf666666, 0xc081a59e,
    0x0, 0x0, 0xbf666666, 0xc08297ca,
    0x0, 0x0, 0xbf666666, 0xc0838d5a,
    0x0, 0x0, 0xbf666666, 0xc0848661,
    0x0, 0x0, 0xbf666666, 0xc08582f3,
    0x0, 0x0, 0xbf666666, 0xc0868323,
    0x0, 0x0, 0xbf666666, 0xc0878705,
    0x0, 0x0, 0xbf666666, 0xc0888eaf,
    0x0, 0x0, 0xbf666666, 0xc0899a36,
    0x0, 0x0, 0xbf666666, 0xc08aa9b0,
    0x0, 0x0, 0xbf666666, 0xc08bbd35,
    0x0, 0x0, 0xbf666666, 0xc08cd4db,
    0x0, 0x0, 0xbf666666, 0xc08df0bc,
    0x0, 0x0, 0xbf666666, 0xc08f10ef,
    0x0, 0x0, 0xbf666666, 0xc0903590,
    0x0, 0x0, 0xbf666666, 0xc0915eb8,
    0x0, 0x0, 0xbf666666, 0xc0928c84,
    0x0, 0x0, 0xbf666666, 0xc093bf0f,
    0x0, 0x0, 0xbf666666, 0xc094f678,
    0x0, 0x0, 0xbf666666, 0xc09632db,
    0x0, 0x0, 0xbf666666, 0xc0977459,
    0x0, 0x0, 0xbf666666, 0xc098bb11,
    0x0, 0x0, 0xbf666666, 0xc09a0726,
    0x0, 0x0, 0xbf666666, 0xc09b58b8,
    0x0, 0x0, 0xbf666666, 0xc09cafed,
    0x0, 0x0, 0xbf666666, 0xc09e0ce9,
    0x0, 0x0, 0xbf666666, 0xc09f6fd2,
    0x0, 0x0, 0xbf666666, 0xc0a0d8cf,
    0x0, 0x0, 0xbf666666, 0xc0a24809,
    0x0, 0x0, 0xbf666666, 0xc0a3bdaa,
    0x0, 0x0, 0xbf666666, 0xc0a539df,
    0x0, 0x0, 0xbf666666, 0xc0a6bcd4,
    0x0, 0x0, 0xbf666666, 0xc0a846b8,
    0x0, 0x0, 0xbf666666, 0xc0a9d7bc,
    0x0, 0x0, 0xbf666666, 0xc0ab7012,
    0x0, 0x0, 0xbf666666, 0xc0ad0ff0,
    0x0, 0x0, 0xbf666666, 0xc0aeb78a,
    0x0, 0x0, 0xbf666666, 0xc0b06719,
    0x0, 0x0, 0xbf666666, 0xc0b21ed8,
    0x0, 0x0, 0xbf666666, 0xc0b3df04,
    0x0, 0x0, 0xbf666666, 0xc0b5a7db,
    0x0, 0x0, 0xbf666666, 0xc0b779a0,
    0x0, 0x0, 0xbf666666, 0xc0b95496,
    0x0, 0x0, 0xbf666666, 0xc0bb3904,
    0x0, 0x0, 0xbf666666, 0xc0bd2735,
    0x0, 0x0, 0xbf666666, 0xc0bf1f75,
    0x0, 0x0, 0xbf666666, 0xc0c12214,
    0x0, 0x0, 0xbf666666, 0xc0c32f66,
    0x0, 0x0, 0xbf666666, 0xc0c547c1,
    0x0, 0x0, 0xbf666666, 0xc0c76b81,
    0x0, 0x0, 0xbf666666, 0xc0c99b03,
    0x0, 0x0, 0xbf666666, 0xc0cbd6ab,
    0x0, 0x0, 0xbf666666, 0xc0ce1ee0,
    0x0, 0x0, 0xbf666666, 0xc0d0740d,
    0x0, 0x0, 0xbf666666, 0xc0d2d6a2,
    0x0, 0x0, 0xbf666666, 0xc0d54717,
    0x0, 0x0, 0xbf666666, 0xc0d7c5e5,
    0x0, 0x0, 0xbf666666, 0xc0da538d,
    0x0, 0x0, 0xbf666666, 0xc0dcf098,
    0x0, 0x0, 0xbf666666, 0xc0df9d91,
    0x0, 0x0, 0xbf666666, 0xc0e25b0e,
    0x0, 0x0, 0xbf666666, 0xc0e529aa,
    0x0, 0x0, 0xbf666666, 0xc0e80a08,
    0x0, 0x0, 0xbf666666, 0xc0eafcd4,
    0x0, 0x0, 0xbf666666, 0xc0ee02c3,
    0x0, 0x0, 0xbf666666, 0xc0f11c91,
    0x0, 0x0, 0xbf666666, 0xc0f44b07,
    0x0, 0x0, 0xbf666666, 0xc0f78ef6,
    0x0, 0x0, 0xbf666666, 0xc0fae93d,
    0x0, 0x0, 0xbf666666, 0xc0fe5ac3,
    0x0, 0x0, 0xbf666666, 0xc100f240,
    0x0, 0x0, 0xbf666666, 0xc102c3bc,
    0x0, 0x0, 0xbf666666, 0xc104a25f,
    0x0, 0x0, 0xbf666666, 0xc1068eba,
    0x0, 0x0, 0xbf666666, 0xc1088967,
    0x0, 0x0, 0xbf666666, 0xc10a9308,
    0x0, 0x0, 0xbf666666, 0xc10cac4c,
    0x0, 0x0, 0xbf666666, 0xc10ed5e8,
    0x0, 0x0, 0xbf666666, 0xc111109f,
    0x0, 0x0, 0xbf666666, 0xc1135d42,
    0x0, 0x0, 0xbf666666, 0xc115bcaa,
    0x0, 0x0, 0xbf666666, 0xc1182fc4,
    0x0, 0x0, 0xbf666666, 0xc11ab789,
    0x0, 0x0, 0xbf666666, 0xc11d5503,
    0x0, 0x0, 0xbf666666, 0xc1200951,
    0x0, 0x0, 0xbf666666, 0xc122d5a2,
    0x0, 0x0, 0xbf666666, 0xc125bb3d,
    0x0, 0x0, 0xbf666666, 0xc128bb80,
    0x0, 0x0, 0xbf666666, 0xc12bd7e3,
    0x0, 0x0, 0xbf666666, 0xc12f11f9,
    0x0, 0x0, 0xbf666666, 0xc1326b75,
    0x0, 0x0, 0xbf666666, 0xc135e62b,
    0x0, 0x0, 0xbf666666, 0xc1398415,
    0x0, 0x0, 0xbf666666, 0xc13d4754,
    0x0, 0x0, 0xbf666666, 0xc1413238,
    0x0, 0x0, 0xbf666666, 0xc1454742,
    0x0, 0x0, 0xbf666666, 0xc149892a,
    0x0, 0x0, 0xbf666666, 0xc14dfae4,
    0x0, 0x0, 0xbf666666, 0xc1529fac,
    0x0, 0x0, 0xbf666666, 0xc1577b05,
    0x0, 0x0, 0xbf666666, 0xc15c90ca,
    0x0, 0x0, 0xbf666666, 0xc161e534,
    0x0, 0x0, 0xbf666666, 0xc1677ce7,
    0x0, 0x0, 0xbf666666, 0xc16d5d00,
    0x0, 0x0, 0xbf666666, 0xc1738b22,
    0x0, 0x0, 0xbf666666, 0xc17a0d8b,
    0x0, 0x0, 0xbf666666, 0xc1807595,
    0x0, 0x0, 0xbf666666, 0xc18415d9,
    0x0, 0x0, 0xbf666666, 0xc187ebdf,
    0x0, 0x0, 0xbf666666, 0xc18bfc78,
    0x0, 0x0, 0xbf666666, 0xc1904d0b,
    0x0, 0x0, 0xbf666666, 0xc194e3b1,
    0x0, 0x0, 0xbf666666, 0xc199c74d,
    0x0, 0x0, 0xbf666666, 0xc19effb4,
    0x0, 0x0, 0xbf666666, 0xc1a495d3,
    0x0, 0x0, 0xbf666666, 0xc1aa93e2,
    0x0, 0x0, 0xbf666666, 0xc1b105a6,
    0x0, 0x0, 0xbf666666, 0xc1b7f8bc,
    0x0, 0x0, 0xbf666666, 0xc1bf7cf9,
    0x0, 0x0, 0xbf666666, 0xc1c7a4e5,
    0x0, 0x0, 0xbf666666, 0xc1d08654,
    0x0, 0x0, 0xbf666666, 0xc1da3b28,
    0x0, 0x0, 0xbf666666, 0xc1e4e251,
    0x0, 0x0, 0xbf666666, 0xc1f0a116,
    0x0, 0x0, 0xbf666666, 0xc1fda4d0,
    0x0, 0x0, 0xbf666666, 0xc2061299,
    0x0, 0x0, 0xbf666666, 0xc20e33ba,
    0x0, 0x0, 0xbf666666, 0xc2176154,
    0x0, 0x0, 0xbf666666, 0xc221d2f2,
    0x0, 0x0, 0xbf666666, 0xc22dd096,
    0x0, 0x0, 0xbf666666, 0xc23bb94b,
    0x0, 0x0, 0xbf666666, 0xc24c0d2c,
    0x0, 0x0, 0xbf666666, 0xc25f7d21,
    0x0, 0x0, 0xbf666666, 0xc277048e,
    0x0, 0x0, 0xbf666666, 0xc28a0a93,
    0x0, 0x0, 0xbf666666, 0xc29c72e3,
    0x0, 0x0, 0xbf666666, 0xc2b48511,
    0x0, 0x0, 0xbf666666, 0xc2d557f5,
    0x0, 0x0, 0xbf666666, 0xc30260ae,
    0x0, 0x0, 0xbf666666, 0xc327a125,
    0x0, 0x0, 0xbf666666, 0xc36aaeaf,
    0x0, 0x0, 0xbf666666, 0xc3c391ba,
    0x0, 0x0, 0xbf666666, 0xc492ad5b
    };

static const uint32_t ref_cfft_step_4096[8192] = {
    0x44e66666, 0x0, 0xbf666666, 0x4492ad5b,
    0x0, 0x0, 0xbf666666, 0x43c391ba,
    0x0, 0x0, 0xbf666666, 0x436aaeaf,
    0x0, 0x0, 0xbf666666, 0x4327a125,
    0x0, 0x0, 0xbf666666, 0x430260ae,
    0x0, 0x0, 0xbf666666, 0x42d557f5,
    0x0, 0x0, 0xbf666666, 0x42b48511,
    0x0, 0x0, 0xbf666666, 0x429c72e3,
    0x0, 0x0, 0xbf666666, 0x428a0a93,
    0x0, 0x0, 0xbf666666, 0x4277048e,
    0x0, 0x0, 0xbf666666, 0x425f7d21,
    0x0, 0x0, 0xbf666666, 0x424c0d2c,
    0x0, 0x0, 0xbf666666, 0x423bb94b,
    0x0, 0x0, 0xbf666666, 0x422dd096,
    0x0, 0x0, 0xbf666666, 0x4221d2f2,
    0x0, 0x0, 0xbf666666, 0x42176154,
    0x0, 0x0, 0xbf666666, 0x420e33ba,
    0x0, 0x0, 0xbf666666, 0x42061299,
    0x0, 0x0, 0xbf666666, 0x41fda4d0,
    0x0, 0x0, 0xbf666666, 0x41f0a116,
    0x0, 0x0, 0xbf666666, 0x41e4e251,
    0x0, 0x0, 0xbf666666, 0x41da3b28,
    0x0, 0x0, 0xbf666666, 0x41d08654,
    0x0, 0x0, 0xbf666666, 0x41c7a4e5,
    0x0, 0x0, 0xbf666666, 0x41bf7cf9,
    0x0, 0x0, 0xbf666666, 0x41b7f8bc,
    0x0, 0x0, 0xbf666666, 0x41b105a6,
    0x0, 0x0, 0xbf666666, 0x41aa93e2,
    0x0, 0x0, 0xbf666666, 0x41a495d3,
    0x0, 0x0, 0xbf666666, 0x419effb4,
    0x0, 0x0, 0xbf666666, 0x4199c74d,
    0x0, 0x0, 0xbf666666, 0x4194e3b1,
    0x0, 0x0, 0xbf666666, 0x41904d0b,
    0x0, 0x0, 0xbf666666, 0x418bfc78,
    0x0, 0x0, 0xbf666666, 0x4187ebdf,
    0x0, 0x0, 0xbf666666, 0x418415d9,
    0x0, 0x0, 0xbf666666, 0x41807595,
    0x0, 0x0, 0xbf666666, 0x417a0d8b,
    0x0, 0x0, 0xbf666666, 0x41738b22,
    0x0, 0x0, 0xbf666666, 0x416d5d00,
    0x0, 0x0, 0xbf666666, 0x41677ce7,
    0x0, 0x0, 0xbf666666, 0x4161e534,
    0x0, 0x0, 0xbf666666, 0x415c90ca,
    0x0, 0x0, 0xbf666666, 0x41577b05,
    0x0, 0x0, 0xbf666666, 0x41529fac,
    0x0, 0x0, 0xbf666666, 0x414dfae4,
    0x0, 0x0, 0xbf666666, 0x4149892a,
    0x0, 0x0, 0xbf666666, 0x41454742,
    0x0, 0x0, 0xbf666666, 0x41413238,
    0x0, 0x0, 0xbf666666, 0x413d4754,
    0x0, 0x0, 0xbf666666, 0x41398415,
    0x0, 0x0, 0xbf666666, 0x4135e62b,
    0x0, 0x0, 0xbf666666, 0x41326b75,
    0x0, 0x0, 0xbf666666, 0x412f11f9,
    0x0, 0x0, 0xbf666666, 0x412bd7e3,
    0x0, 0x0, 0xbf666666, 0x4128bb80,
    0x0, 0x0, 0xbf666666, 0x4125bb3d,
    0x0, 0x0, 0xbf666666, 0x4122d5a2,
    0x0, 0x0, 0xbf666666, 0x41200951,
    0x0, 0x0, 0xbf666666, 0x411d5503,
    0x0, 0x0, 0xbf666666, 0x411ab789,
    0x0, 0x0, 0xbf666666, 0x41182fc4,
    0x0, 0x0, 0xbf666666, 0x4115bcaa,
    0x0, 0x0, 0xbf666666, 0x41135d42,
    0x0, 0x0, 0xbf666666, 0x4111109f,
    0x0, 0x0, 0xbf666666, 0x410ed5e8,
    0x0, 0x0, 0xbf666666, 0x410cac4c,
    0x0, 0x0, 0xbf666666, 0x410a9308,
    0x0, 0x0, 0xbf666666, 0x41088967,
    0x0, 0x0, 0xbf666666, 0x41068eba,
    0x0, 0x0, 0xbf666666, 0x4104a25f,
    0x0, 0x0, 0xbf666666, 0x4102c3bc,
    0x0, 0x0, 0xbf666666, 0x4100f240,
    0x0, 0x0, 0xbf666666, 0x40fe5ac3,
    0x0, 0x0, 0xbf666666, 0x40fae93d,
    0x0, 0x0, 0xbf666666, 0x40f78ef6,
    0x0, 0x0, 0xbf666666, 0x40f44b07,
    0x0, 0x0, 0xbf666666, 0x40f11c91,
    0x0, 0x0, 0xbf666666, 0x40ee02c3,
    0x0, 0x0, 0xbf666666, 0x40eafcd4,
    0x0, 0x0, 0xbf666666, 0x40e80a08,
    0x0, 0x0, 0xbf666666, 0x40e529aa,
    0x0, 0x0, 0xbf666666, 0x40e25b0e,
    0x0, 0x0, 0xbf666666, 0x40df9d91,
    0x0, 0x0, 0xbf666666, 0x40dcf098,
    0x0, 0x0, 0xbf666666, 0x40da538d,
    0x0, 0x0, 0xbf666666, 0x40d7c5e5,
    0x0, 0x0, 0xbf666666, 0x40d54717,
    0x0, 0x0, 0xbf666666, 0x40d2d6a2,
    0x0, 0x0, 0xbf666666, 0x40d0740d,
    0x0, 0x0, 0xbf666666, 0x40ce1ee0,
    0x0, 0x0, 0xbf666666, 0x40cbd6ab,
    0x0, 0x0, 0xbf666666, 0x40c99b03,
    0x0, 0x0, 0xbf666666, 0x40c76b81,
    0x0, 0x0, 0xbf666666, 0x40c547c1,
    0x0, 0x0, 0xbf666666, 0x40c32f66,
    0x0, 0x0, 0xbf666666, 0x40c12214,
    0x0, 0x0, 0xbf666666, 0x40bf1f75,
    0x0, 0x0, 0xbf666666, 0x40bd2735,
    0x0, 0x0, 0xbf666666, 0x40bb3904,
    0x0, 0x0, 0xbf666666, 0x40b95496,
    0x0, 0x0, 0xbf666666, 0x40b779a0,
    0x0, 0x0, 0xbf666666, 0x40b5a7db,
    0x0, 0x0, 0xbf666666, 0x40b3df04,
    0x0, 0x0, 0xbf666666, 0x40b21ed8,
    0x0, 0x0, 0xbf666666, 0x40b06719,
    0x0, 0x0, 0xbf666666, 0x40aeb78a,
    0x0, 0x0, 0xbf666666, 0x40ad0ff0,
    0x0, 0x0, 0xbf666666, 0x40ab7012,
    0x0, 0x0, 0xbf666666, 0x40a9d7bc,
    0x0, 0x0, 0xbf666666, 0x40a846b8,
    0x0, 0x0, 0xbf666666, 0x40a6bcd4,
    0x0, 0x0, 0xbf666666, 0x40a539df,
    0x0, 0x0, 0xbf666666, 0x40a3bdaa,
    0x0, 0x0, 0xbf666666, 0x40a24809,
    0x0, 0x0, 0xbf666666, 0x40a0d8cf,
    0x0, 0x0, 0xbf666666, 0x409f6fd2,
    0x0, 0x0, 0xbf666666, 0x409e0ce9,
    0x0, 0x0, 0xbf666666, 0x409cafed,
    0x0, 0x0, 0xbf666666, 0x409b58b8,
    0x0, 0x0, 0xbf666666, 0x409a0726,
    0x0, 0x0, 0xbf666666, 0x4098bb11,
    0x0, 0x0, 0xbf666666, 0x40977459,
    0x0, 0x0, 0xbf666666, 0x409632db,
    0x0, 0x0, 0xbf666666, 0x4094f678,
    0x0, 0x0, 0xbf666666, 0x4093bf0f,
    0x0, 0x0, 0xbf666666, 0x40928c84,
    0x0, 0x0, 0xbf666666, 0x40915eb8,
    0x0, 0x0, 0xbf666666, 0x40903590,
    0x0, 0x0, 0xbf666666, 0x408f10ef,
    0x0, 0x0, 0xbf666666, 0x408df0bc,
    0x0, 0x0, 0xbf666666, 0x408cd4db,
    0x0, 0x0, 0xbf666666, 0x408bbd35,
    0x0, 0x0, 0xbf666666, 0x408aa9b0,
    0x0, 0x0, 0xbf666666, 0x40899a36,
    0x0, 0x0, 0xbf666666, 0x40888eaf,
    0x0, 0x0, 0xbf666666, 0x40878705,
    0x0, 0x0, 0xbf666666, 0x40868323,
    0x0, 0x0, 0xbf666666, 0x408582f3,
    0x0, 0x0, 0xbf666666, 0x40848661,
    0x0, 0x0, 0xbf666666, 0x40838d5a,
    0x0, 0x0, 0xbf666666, 0x408297ca,
    0x0, 0x0, 0xbf666666, 0x4081a59e,
    0x0, 0x0, 0xbf666666, 0x4080b6c5,
    0x0, 0x0, 0xbf666666, 0x407f9659,
    0x0, 0x0, 0xbf666666, 0x407dc587,
    0x0, 0x0, 0xbf666666, 0x407bfaf2,
    0x0, 0x0, 0xbf666666, 0x407a367b,
    0x0, 0x0, 0xbf666666, 0x40787801,
    0x0, 0x0, 0xbf666666, 0x4076bf66,
    0x0, 0x0, 0xbf666666, 0x40750c8b,
    0x0, 0x0, 0xbf666666, 0x40735f54,
    0x0, 0x0, 0xbf666666, 0x4071b7a5,
    0x0, 0x0, 0xbf666666, 0x40701560,
    0x0, 0x0, 0xbf666666, 0x406e786d,
    0x0, 0x0, 0xbf666666, 0x406ce0af,
    0x0, 0x0, 0xbf666666, 0x406b4e0f,
    0x0, 0x0, 0xbf666666, 0x4069c072,
    0x0, 0x0, 0xbf666666, 0x406837c0,
    0x0, 0x0, 0xbf666666, 0x4066b3e3,
    0x0, 0x0, 0xbf666666, 0x406534c2,
    0x0, 0x0, 0xbf666666, 0x4063ba47,
    0x0, 0x0, 0xbf666666, 0x4062445c,
    0x0, 0x0, 0xbf666666, 0x4060d2ec,
    0x0, 0x0, 0xbf666666, 0x405f65e2,
    0x0, 0x0, 0xbf666666, 0x405dfd29,
    0x0, 0x0, 0xbf666666, 0x405c98ae,
    0x0, 0x0, 0xbf666666, 0x405b385d,
    0x0, 0x0, 0xbf666666, 0x4059dc22,
    0x0, 0x0, 0xbf666666, 0x405883ec,
    0x0, 0x0, 0xbf666666, 0x40572fa9,
    0x0, 0x0, 0xbf666666, 0x4055df46,
    0x0, 0x0, 0xbf666666, 0x405492b3,
    0x0, 0x0, 0xbf666666, 0x405349de,
    0x0, 0x0, 0xbf666666, 0x405204b7,
    0x0, 0x0, 0xbf666666, 0x4050c32f,
    0x0, 0x0, 0xbf666666, 0x404f8534,
    0x0, 0x0, 0xbf666666, 0x404e4ab8,
    0x0, 0x0, 0xbf666666, 0x404d13ac,
    0x0, 0x0, 0xbf666666, 0x404be001,
    0x0, 0x0, 0xbf666666, 0x404aafa9,
    0x0, 0x0, 0xbf666666, 0x40498295,
    0x0, 0x0, 0xbf666666, 0x404858b8,
    0x0, 0x0, 0xbf666666, 0x40473205,
    0x0, 0x0, 0xbf666666, 0x40460e6e,
    0x0, 0x0, 0xbf666666, 0x4044ede6,
    0x0, 0x0, 0xbf666666, 0x4043d061,
    0x0, 0x0, 0xbf666666, 0x4042b5d2,
    0x0, 0x0, 0xbf666666, 0x40419e2e,
    0x0, 0x0, 0xbf666666, 0x40408968,
    0x0, 0x0, 0xbf666666, 0x403f7774,
    0x0, 0x0, 0xbf666666, 0x403e6849,
    0x0, 0x0, 0xbf666666, 0x403d5bda,
    0x0, 0x0, 0xbf666666, 0x403c521d,
    0x0, 0x0, 0xbf666666, 0x403b4b06,
    0x0, 0x0, 0xbf666666, 0x403a468c,
    0x0, 0x0, 0xbf666666, 0x403944a5,
    0x0, 0x0, 0xbf666666, 0x40384545,
    0x0, 0x0, 0xbf666666, 0x40374865,
    0x0, 0x0, 0xbf666666, 0x40364df9,
    0x0, 0x0, 0xbf666666, 0x403555f8,
    0x0, 0x0, 0xbf666666, 0x4034605a,
    0x0, 0x0, 0xbf666666, 0x40336d15,
    0x0, 0x0, 0xbf666666, 0x40327c21,
    0x0, 0x0, 0xbf666666, 0x40318d74,
    0x0, 0x0, 0xbf666666, 0x4030a106,
    0x0, 0x0, 0xbf666666, 0x402fb6cf,
    0x0, 0x0, 0xbf666666, 0x402ecec7,
    0x0, 0x0, 0xbf666666, 0x402de8e5,
    0x0, 0x0, 0xbf666666, 0x402d0521,
    0x0, 0x0, 0xbf666666, 0x402c2375,
    0x0, 0x0, 0xbf666666, 0x402b43d8,
    0x0, 0x0, 0xbf666666, 0x402a6642,
    0x0, 0x0, 0xbf666666, 0x40298aae,
    0x0, 0x0, 0xbf666666, 0x4028b112,
    0x0, 0x0, 0xbf666666, 0x4027d969,
    0x0, 0x0, 0xbf666666, 0x402703ab,
    0x0, 0x0, 0xbf666666, 0x40262fd2,
    0x0, 0x0, 0xbf666666, 0x40255dd6,
    0x0, 0x0, 0xbf666666, 0x40248db2,
    0x0, 0x0, 0xbf666666, 0x4023bf60,
    0x0, 0x0, 0xbf666666, 0x4022f2d7,
    0x0, 0x0, 0xbf666666, 0x40222813,
    0x0, 0x0, 0xbf666666, 0x40215f0e,
    0x0, 0x0, 0xbf666666, 0x402097c1,
    0x0, 0x0, 0xbf666666, 0x401fd227,
    0x0, 0x0, 0xbf666666, 0x401f0e39,
    0x0, 0x0, 0xbf666666, 0x401e4bf3,
    0x0, 0x0, 0xbf666666, 0x401d8b4e,
    0x0, 0x0, 0xbf666666, 0x401ccc45,
    0x0, 0x0, 0xbf666666, 0x401c0ed3,
    0x0, 0x0, 0xbf666666, 0x401b52f2,
    0x0, 0x0, 0xbf666666, 0x401a989e,
    0x0, 0x0, 0xbf666666, 0x4019dfd1,
    0x0, 0x0, 0xbf666666, 0x40192886,
    0x0, 0x0, 0xbf666666, 0x401872b8,
    0x0, 0x0, 0xbf666666, 0x4017be63,
    0x0, 0x0, 0xbf666666, 0x40170b81,
    0x0, 0x0, 0xbf666666, 0x40165a0e,
    0x0, 0x0, 0xbf666666, 0x4015aa06,
    0x0, 0x0, 0xbf666666, 0x4014fb63,
    0x0, 0x0, 0xbf666666, 0x40144e22,
    0x0, 0x0, 0xbf666666, 0x4013a23d,
    0x0, 0x0, 0xbf666666, 0x4012f7b2,
    0x0, 0x0, 0xbf666666, 0x40124e7a,
    0x0, 0x0, 0xbf666666, 0x4011a693,
    0x0, 0x0, 0xbf666666, 0x4010fff9,
    0x0, 0x0, 0xbf666666, 0x40105aa6,
    0x0, 0x0, 0xbf666666, 0x400fb697,
    0x0, 0x0, 0xbf666666, 0x400f13c9,
    0x0, 0x0, 0xbf666666, 0x400e7237,
    0x0, 0x0, 0xbf666666, 0x400dd1de,
    0x0, 0x0, 0xbf666666, 0x400d32ba,
    0x0, 0x0, 0xbf666666, 0x400c94c7,
    0x0, 0x0, 0xbf666666, 0x400bf801,
    0x0, 0x0, 0xbf666666, 0x400b5c66,
    0x0, 0x0, 0xbf666666, 0x400ac1f1,
    0x0, 0x0, 0xbf666666, 0x400a28a0,
    0x0, 0x0, 0xbf666666, 0x4009906e,
    0x0, 0x0, 0xbf666666, 0x4008f959,
    0x0, 0x0, 0xbf666666, 0x4008635c,
    0x0, 0x0, 0xbf666666, 0x4007ce76,
    0x0, 0x0, 0xbf666666, 0x40073aa3,
    0x0, 0x0, 0xbf666666, 0x4006a7df,
    0x0, 0x0, 0xbf666666, 0x40061627,
    0x0, 0x0, 0xbf666666, 0x40058579,
    0x0, 0x0, 0xbf666666, 0x4004f5d2,
    0x0, 0x0, 0xbf666666, 0x4004672e,
    0x0, 0x0, 0xbf666666, 0x4003d98a,
    0x0, 0x0, 0xbf666666, 0x40034ce5,
    0x0, 0x0, 0xbf666666, 0x4002c13a,
    0x0, 0x0, 0xbf666666, 0x40023687,
    0x0, 0x0, 0xbf666666, 0x4001acca,
    0x0, 0x0, 0xbf666666, 0x40012400,
    0x0, 0x0, 0xbf666666, 0x40009c26,
    0x0, 0x0, 0xbf666666, 0x40001539,
    0x0, 0x0, 0xbf666666, 0x3fff1e6d,
    0x0, 0x0, 0xbf666666, 0x3ffe1439,
    0x0, 0x0, 0xbf666666, 0x3ffd0bd1,
    0x0, 0x0, 0xbf666666, 0x3ffc0530,
    0x0, 0x0, 0xbf666666, 0x3ffb0050,
    0x0, 0x0, 0xbf666666, 0x3ff9fd2d,
    0x0, 0x0, 0xbf666666, 0x3ff8fbc3,
    0x0, 0x0, 0xbf666666, 0x3ff7fc0c,
    0x0, 0x0, 0xbf666666, 0x3ff6fe03,
    0x0, 0x0, 0xbf666666, 0x3ff601a6,
    0x0, 0x0, 0xbf666666, 0x3ff506ee,
    0x0, 0x0, 0xbf666666, 0x3ff40dd7,
    0x0, 0x0, 0xbf666666, 0x3ff3165e,
    0x0, 0x0, 0xbf666666, 0x3ff2207d,
    0x0, 0x0, 0xbf666666, 0x3ff12c32,
    0x0, 0x0, 0xbf666666, 0x3ff03976,
    0x0, 0x0, 0xbf666666, 0x3fef4847,
    0x0, 0x0, 0xbf666666, 0x3fee58a0,
    0x0, 0x0, 0xbf666666, 0x3fed6a7d,
    0x0, 0x0, 0xbf666666, 0x3fec7dda,
    0x0, 0x0, 0xbf666666, 0x3feb92b4,
    0x0, 0x0, 0xbf666666, 0x3feaa906,
    0x0, 0x0, 0xbf666666, 0x3fe9c0cd,
    0x0, 0x0, 0xbf666666, 0x3fe8da05,
    0x0, 0x0, 0xbf666666, 0x3fe7f4aa,
    0x0, 0x0, 0xbf666666, 0x3fe710b9,
    0x0, 0x0, 0xbf666666, 0x3fe62e2d,
    0x0, 0x0, 0xbf666666, 0x3fe54d04,
    0x0, 0x0, 0xbf666666, 0x3fe46d3a,
    0x0, 0x0, 0xbf666666, 0x3fe38ecc,
    0x0, 0x0, 0xbf666666, 0x3fe2b1b5,
    0x0, 0x0, 0xbf666666, 0x3fe1d5f3,
    0x0, 0x0, 0xbf666666, 0x3fe0fb83,
    0x0, 0x0, 0xbf666666, 0x3fe02260,
    0x0, 0x0, 0xbf666666, 0x3fdf4a89,
    0x0, 0x0, 0xbf666666, 0x3fde73f9,
    0x0, 0x0, 0xbf666666, 0x3fdd9ead,
    0x0, 0x0, 0xbf666666, 0x3fdccaa3,
    0x0, 0x0, 0xbf666666, 0x3fdbf7d7,
    0x0, 0x0, 0xbf666666, 0x3fdb2646,
    0x0, 0x0, 0xbf666666, 0x3fda55ee,
    0x0, 0x0, 0xbf666666, 0x3fd986ca,
    0x0, 0x0, 0xbf666666, 0x3fd8b8d9,
    0x0, 0x0, 0xbf666666, 0x3fd7ec17,
    0x0, 0x0, 0xbf666666, 0x3fd72082,
    0x0, 0x0, 0xbf666666, 0x3fd65617,
    0x0, 0x0, 0xbf666666, 0x3fd58cd3,
    0x0, 0x0, 0xbf666666, 0x3fd4c4b2,
    0x0, 0x0, 0xbf666666, 0x3fd3fdb4,
    0x0, 0x0, 0xbf666666, 0x3fd337d4,
    0x0, 0x0, 0xbf666666, 0x3fd27310,
    0x0, 0x0, 0xbf666666, 0x3fd1af66,
    0x0, 0x0, 0xbf666666, 0x3fd0ecd2,
    0x0, 0x0, 0xbf666666, 0x3fd02b53,
    0x0, 0x0, 0xbf666666, 0x3fcf6ae6,
    0x0, 0x0, 0xbf666666, 0x3fceab89,
    0x0, 0x0, 0xbf666666, 0x3fcded38,
    0x0, 0x0, 0xbf666666, 0x3fcd2ff1,
    0x0, 0x0, 0xbf666666, 0x3fcc73b3,
    0x0, 0x0, 0xbf666666, 0x3fcbb87b,
    0x0, 0x0, 0xbf666666, 0x3fcafe45,
    0x0, 0x0, 0xbf666666, 0x3fca4511,
    0x0, 0x0, 0xbf666666, 0x3fc98cdb,
    0x0, 0x0, 0xbf666666, 0x3fc8d5a2,
    0x0, 0x0, 0xbf666666, 0x3fc81f63,
    0x0, 0x0, 0xbf666666, 0x3fc76a1c,
    0x0, 0x0, 0xbf666666, 0x3fc6b5cb,
    0x0, 0x0, 0xbf666666, 0x3fc6026e,
    0x0, 0x0, 0xbf666666, 0x3fc55002,
    0x0, 0x0, 0xbf666666, 0x3fc49e85,
    0x0, 0x0, 0xbf666666, 0x3fc3edf6,
    0x0, 0x0, 0xbf666666, 0x3fc33e52,
    0x0, 0x0, 0xbf666666, 0x3fc28f97,
    0x0, 0x0, 0xbf666666, 0x3fc1e1c3,
    0x0, 0x0, 0xbf666666, 0x3fc134d5,
    0x0, 0x0, 0xbf666666, 0x3fc088c9,
    0x0, 0x0, 0xbf666666, 0x3fbfdd9f,
    0x0, 0x0, 0xbf666666, 0x3fbf3354,
    0x0, 0x0, 0xbf666666, 0x3fbe89e7,
    0x0, 0x0, 0xbf666666, 0x3fbde155,
    0x0, 0x0, 0xbf666666, 0x3fbd399d,
    0x0, 0x0, 0xbf666666, 0x3fbc92bd,
    0x0, 0x0, 0xbf666666, 0x3fbbecb3,
    0x0, 0x0, 0xbf666666, 0x3fbb477d,
    0x0, 0x0, 0xbf666666, 0x3fbaa319,
    0x0, 0x0, 0xbf666666, 0x3fb9ff86,
    0x0, 0x0, 0xbf666666, 0x3fb95cc2,
    0x0, 0x0, 0xbf666666, 0x3fb8bacb,
    0x0, 0x0, 0xbf666666, 0x3fb8199f,
    0x0, 0x0, 0xbf666666, 0x3fb7793e,
    0x0, 0x0, 0xbf666666, 0x3fb6d9a4,
    0x0, 0x0, 0xbf666666, 0x3fb63ad1,
    0x0, 0x0, 0xbf666666, 0x3fb59cc3,
    0x0, 0x0, 0xbf666666, 0x3fb4ff78,
    0x0, 0x0, 0xbf666666, 0x3fb462ef,
    0x0, 0x0, 0xbf666666, 0x3fb3c726,
    0x0, 0x0, 0xbf666666, 0x3fb32c1b,
    0x0, 0x0, 0xbf666666, 0x3fb291cd,
    0x0, 0x0, 0xbf666666, 0x3fb1f83a,
    0x0, 0x0, 0xbf666666, 0x3fb15f62,
    0x0, 0x0, 0xbf666666, 0x3fb0c742,
    0x0, 0x0, 0xbf666666, 0x3fb02fd9,
    0x0, 0x0, 0xbf666666, 0x3faf9925,
    0x0, 0x0, 0xbf666666, 0x3faf0325,
    0x0, 0x0, 0xbf666666, 0x3fae6dd8,
    0x0, 0x0, 0xbf666666, 0x3fadd93c,
    0x0, 0x0, 0xbf666666, 0x3fad454f,
    0x0, 0x0, 0xbf666666, 0x3facb211,
    0x0, 0x0, 0xbf666666, 0x3fac1f80,
    0x0, 0x0, 0xbf666666, 0x3fab8d9b,
    0x0, 0x0, 0xbf666666, 0x3faafc60,
    0x0, 0x0, 0xbf666666, 0x3faa6bcd,
    0x0, 0x0, 0xbf666666, 0x3fa9dbe3,
    0x0, 0x0, 0xbf666666, 0x3fa94c9e,
    0x0, 0x0, 0xbf666666, 0x3fa8bdff,
    0x0, 0x0, 0xbf666666, 0x3fa83003,
    0x0, 0x0, 0xbf666666, 0x3fa7a2aa,
    0x0, 0x0, 0xbf666666, 0x3fa715f2,
    0x0, 0x0, 0xbf666666, 0x3fa689da,
    0x0, 0x0, 0xbf666666, 0x3fa5fe60,
    0x0, 0x0, 0xbf666666, 0x3fa57384,
    0x0, 0x0, 0xbf666666, 0x3fa4e945,
    0x0, 0x0, 0xbf666666, 0x3fa45fa0,
    0x0, 0x0, 0xbf666666, 0x3fa3d695,
    0x0, 0x0, 0xbf666666, 0x3fa34e23,
    0x0, 0x0, 0xbf666666, 0x3fa2c649,
    0x0, 0x0, 0xbf666666, 0x3fa23f05,
    0x0, 0x0, 0xbf666666, 0x3fa1b857,
    0x0, 0x0, 0xbf666666, 0x3fa1323c,
    0x0, 0x0, 0xbf666666, 0x3fa0acb5,
    0x0, 0x0, 0xbf666666, 0x3fa027c0,
    0x0, 0x0, 0xbf666666, 0x3f9fa35b,
    0x0, 0x0, 0xbf666666, 0x3f9f1f86,
    0x0, 0x0, 0xbf666666, 0x3f9e9c40,
    0x0, 0x0, 0xbf666666, 0x3f9e1988,
    0x0, 0x0, 0xbf666666, 0x3f9d975c,
    0x0, 0x0, 0xbf666666, 0x3f9d15bc,
    0x0, 0x0, 0xbf666666, 0x3f9c94a6,
    0x0, 0x0, 0xbf666666, 0x3f9c141a,
    0x0, 0x0, 0xbf666666, 0x3f9b9417,
    0x0, 0x0, 0xbf666666, 0x3f9b149a,
    0x0, 0x0, 0xbf666666, 0x3f9a95a5,
    0x0, 0x0, 0xbf666666, 0x3f9a1735,
    0x0, 0x0, 0xbf666666, 0x3f999949,
    0x0, 0x0, 0xbf666666, 0x3f991be1,
    0x0, 0x0, 0xbf666666, 0x3f989efc,
    0x0, 0x0, 0xbf666666, 0x3f982298,
    0x0, 0x0, 0xbf666666, 0x3f97a6b6,
    0x0, 0x0, 0xbf666666, 0x3f972b53,
    0x0, 0x0, 0xbf666666, 0x3f96b06e,
    0x0, 0x0, 0xbf666666, 0x3f963608,
    0x0, 0x0, 0xbf666666, 0x3f95bc1f,
    0x0, 0x0, 0xbf666666, 0x3f9542b2,
    0x0, 0x0, 0xbf666666, 0x3f94c9c1,
    0x0, 0x0, 0xbf666666, 0x3f94514a,
    0x0, 0x0, 0xbf666666, 0x3f93d94c,
    0x0, 0x0, 0xbf666666, 0x3f9361c8,
    0x0, 0x0, 0xbf666666, 0x3f92eabb,
    0x0, 0x0, 0xbf666666, 0x3f927425,
    0x0, 0x0, 0xbf666666, 0x3f91fe05,
    0x0, 0x0, 0xbf666666, 0x3f91885b,
    0x0, 0x0, 0xbf666666, 0x3f911325,
    0x0, 0x0, 0xbf666666, 0x3f909e63,
    0x0, 0x0, 0xbf666666, 0x3f902a13,
    0x0, 0x0, 0xbf666666, 0x3f8fb636,
    0x0, 0x0, 0xbf666666, 0x3f8f42ca,
    0x0, 0x0, 0xbf666666, 0x3f8ecfcf,
    0x0, 0x0, 0xbf666666, 0x3f8e5d44,
    0x0, 0x0, 0xbf666666, 0x3f8deb27,
    0x0, 0x0, 0xbf666666, 0x3f8d7978,
    0x0, 0x0, 0xbf666666, 0x3f8d0837,
    0x0, 0x0, 0xbf666666, 0x3f8c9763,
    0x0, 0x0, 0xbf666666, 0x3f8c26fb,
    0x0, 0x0, 0xbf666666, 0x3f8bb6fe,
    0x0, 0x0, 0xbf666666, 0x3f8b476b,
    0x0, 0x0, 0xbf666666, 0x3f8ad842,
    0x0, 0x0, 0xbf666666, 0x3f8a6982,
    0x0, 0x0, 0xbf666666, 0x3f89fb2b,
    0x0, 0x0, 0xbf666666, 0x3f898d3b,
    0x0, 0x0, 0xbf666666, 0x3f891fb2,
    0x0, 0x0, 0xbf666666, 0x3f88b28f,
    0x0, 0x0, 0xbf666666, 0x3f8845d2,
    0x0, 0x0, 0xbf666666, 0x3f87d979,
    0x0, 0x0, 0xbf666666, 0x3f876d85,
    0x0, 0x0, 0xbf666666, 0x3f8701f4,
    0x0, 0x0, 0xbf666666, 0x3f8696c6,
    0x0, 0x0, 0xbf666666, 0x3f862bfa,
    0x0, 0x0, 0xbf666666, 0x3f85c190,
    0x0, 0x0, 0xbf666666, 0x3f855786,
    0x0, 0x0, 0xbf666666, 0x3f84eddd,
    0x0, 0x0, 0xbf666666, 0x3f848494,
    0x0, 0x0, 0xbf666666, 0x3f841ba9,
    0x0, 0x0, 0xbf666666, 0x3f83b31d,
    0x0, 0x0, 0xbf666666, 0x3f834aee,
    0x0, 0x0, 0xbf666666, 0x3f82e31d,
    0x0, 0x0, 0xbf666666, 0x3f827ba8,
    0x0, 0x0, 0xbf666666, 0x3f82148e,
    0x0, 0x0, 0xbf666666, 0x3f81add1,
    0x0, 0x0, 0xbf666666, 0x3f81476d,
    0x0, 0x0, 0xbf666666, 0x3f80e164,
    0x0, 0x0, 0xbf666666, 0x3f807bb5,
    0x0, 0x0, 0xbf666666, 0x3f80165e,
    0x0, 0x0, 0xbf666666, 0x3f7f62bf,
    0x0, 0x0, 0xbf666666, 0x3f7e9972,
    0x0, 0x0, 0xbf666666, 0x3f7dd0d3,
    0x0, 0x0, 0xbf666666, 0x3f7d08e2,
    0x0, 0x0, 0xbf666666, 0x3f7c419c,
    0x0, 0x0, 0xbf666666, 0x3f7b7b02,
    0x0, 0x0, 0xbf666666, 0x3f7ab512,
    0x0, 0x0, 0xbf666666, 0x3f79efcb,
    0x0, 0x0, 0xbf666666, 0x3f792b2b,
    0x0, 0x0, 0xbf666666, 0x3f786732,
    0x0, 0x0, 0xbf666666, 0x3f77a3df,
    0x0, 0x0, 0xbf666666, 0x3f76e130,
    0x0, 0x0, 0xbf666666, 0x3f761f25,
    0x0, 0x0, 0xbf666666, 0x3f755dbd,
    0x0, 0x0, 0xbf666666, 0x3f749cf6,
    0x0, 0x0, 0xbf666666, 0x3f73dcd0,
    0x0, 0x0, 0xbf666666, 0x3f731d49,
    0x0, 0x0, 0xbf666666, 0x3f725e60,
    0x0, 0x0, 0xbf666666, 0x3f71a015,
    0x0, 0x0, 0xbf666666, 0x3f70e266,
    0x0, 0x0, 0xbf666666, 0x3f702553,
    0x0, 0x0, 0xbf666666, 0x3f6f68db,
    0x0, 0x0, 0xbf666666, 0x3f6eacfc,
    0x0, 0x0, 0xbf666666, 0x3f6df1b6,
    0x0, 0x0, 0xbf666666, 0x3f6d3707,
    0x0, 0x0, 0xbf666666, 0x3f6c7cef,
    0x0, 0x0, 0xbf666666, 0x3f6bc36d,
    0x0, 0x0, 0xbf666666, 0x3f6b0a7f,
    0x0, 0x0, 0xbf666666, 0x3f6a5226,
    0x0, 0x0, 0xbf666666, 0x3f699a60,
    0x0, 0x0, 0xbf666666, 0x3f68e32c,
    0x0, 0x0, 0xbf666666, 0x3f682c88,
    0x0, 0x0, 0xbf666666, 0x3f677676,
    0x0, 0x0, 0xbf666666, 0x3f66c0f3,
    0x0, 0x0, 0xbf666666, 0x3f660bfe,
    0x0, 0x0, 0xbf666666, 0x3f655797,
    0x0, 0x0, 0xbf666666, 0x3f64a3bd,
    0x0, 0x0, 0xbf666666, 0x3f63f06e,
    0x0, 0x0, 0xbf666666, 0x3f633dab,
    0x0, 0x0, 0xbf666666, 0x3f628b72,
    0x0, 0x0, 0xbf666666, 0x3f61d9c3,
    0x0, 0x0, 0xbf666666, 0x3f61289c,
    0x0, 0x0, 0xbf666666, 0x3f6077fd,
    0x0, 0x0, 0xbf666666, 0x3f5fc7e5,
    0x0, 0x0, 0xbf666666, 0x3f5f1853,
    0x0, 0x0, 0xbf666666, 0x3f5e6946,
    0x0, 0x0, 0xbf666666, 0x3f5dbabe,
    0x0, 0x0, 0xbf666666, 0x3f5d0cba,
    0x0, 0x0, 0xbf666666, 0x3f5c5f38,
    0x0, 0x0, 0xbf666666, 0x3f5bb239,
    0x0, 0x0, 0xbf666666, 0x3f5b05bb,
    0x0, 0x0, 0xbf666666, 0x3f5a59be,
    0x0, 0x0, 0xbf666666, 0x3f59ae40,
    0x0, 0x0, 0xbf666666, 0x3f590341,
    0x0, 0x0, 0xbf666666, 0x3f5858c1,
    0x0, 0x0, 0xbf666666, 0x3f57aebf,
    0x0, 0x0, 0xbf666666, 0x3f570539,
    0x0, 0x0, 0xbf666666, 0x3f565c2f,
    0x0, 0x0, 0xbf666666, 0x3f55b3a1,
    0x0, 0x0, 0xbf666666, 0x3f550b8d,
    0x0, 0x0, 0xbf666666, 0x3f5463f3,
    0x0, 0x0, 0xbf666666, 0x3f53bcd3,
    0x0, 0x0, 0xbf666666, 0x3f53162a,
    0x0, 0x0, 0xbf666666, 0x3f526ffa,
    0x0, 0x0, 0xbf666666, 0x3f51ca40,
    0x0, 0x0, 0xbf666666, 0x3f5124fd,
    0x0, 0x0, 0xbf666666, 0x3f508030,
    0x0, 0x0, 0xbf666666, 0x3f4fdbd8,
    0x0, 0x0, 0xbf666666, 0x3f4f37f3,
    0x0, 0x0, 0xbf666666, 0x3f4e9483,
    0x0, 0x0, 0xbf666666, 0x3f4df185,
    0x0, 0x0, 0xbf666666, 0x3f4d4efa,
    0x0, 0x0, 0xbf666666, 0x3f4cace0,
    0x0, 0x0, 0xbf666666, 0x3f4c0b37,
    0x0, 0x0, 0xbf666666, 0x3f4b69ff,
    0x0, 0x0, 0xbf666666, 0x3f4ac936,
    0x0, 0x0, 0xbf666666, 0x3f4a28dc,
    0x0, 0x0, 0xbf666666, 0x3f4988f1,
    0x0, 0x0, 0xbf666666, 0x3f48e973,
    0x0, 0x0, 0xbf666666, 0x3f484a62,
    0x0, 0x0, 0xbf666666, 0x3f47abbe,
    0x0, 0x0, 0xbf666666, 0x3f470d85,
    0x0, 0x0, 0xbf666666, 0x3f466fb8,
    0x0, 0x0, 0xbf666666, 0x3f45d256,
    0x0, 0x0, 0xbf666666, 0x3f45355d,
    0x0, 0x0, 0xbf666666, 0x3f4498ce,
    0x0, 0x0, 0xbf666666, 0x3f43fca7,
    0x0, 0x0, 0xbf666666, 0x3f4360e9,
    0x0, 0x0, 0xbf666666, 0x3f42c592,
    0x0, 0x0, 0xbf666666, 0x3f422aa3,
    0x0, 0x0, 0xbf666666, 0x3f41901a,
    0x0, 0x0, 0xbf666666, 0x3f40f5f6,
    0x0, 0x0, 0xbf666666, 0x3f405c38,
    0x0, 0x0, 0xbf666666, 0x3f3fc2df,
    0x0, 0x0, 0xbf666666, 0x3f3f29e9,
    0x0, 0x0, 0xbf666666, 0x3f3e9157,
    0x0, 0x0, 0xbf666666, 0x3f3df929,
    0x0, 0x0, 0xbf666666, 0x3f3d615c,
    0x0, 0x0, 0xbf666666, 0x3f3cc9f2,
    0x0, 0x0, 0xbf666666, 0x3f3c32e9,
    0x0, 0x0, 0xbf666666, 0x3f3b9c40,
    0x0, 0x0, 0xbf666666, 0x3f3b05f8,
    0x0, 0x0, 0xbf666666, 0x3f3a700f,
    0x0, 0x0, 0xbf666666, 0x3f39da86,
    0x0, 0x0, 0xbf666666, 0x3f39455b,
    0x0, 0x0, 0xbf666666, 0x3f38b08f,
    0x0, 0x0, 0xbf666666, 0x3f381c20,
    0x0, 0x0, 0xbf666666, 0x3f37880e,
    0x0, 0x0, 0xbf666666, 0x3f36f458,
    0x0, 0x0, 0xbf666666, 0x3f3660ff,
    0x0, 0x0, 0xbf666666, 0x3f35ce01,
    0x0, 0x0, 0xbf666666, 0x3f353b5e,
    0x0, 0x0, 0xbf666666, 0x3f34a915,
    0x0, 0x0, 0xbf666666, 0x3f341727,
    0x0, 0x0, 0xbf666666, 0x3f338592,
    0x0, 0x0, 0xbf666666, 0x3f32f456,
    0x0, 0x0, 0xbf666666, 0x3f326372,
    0x0, 0x0, 0xbf666666, 0x3f31d2e6,
    0x0, 0x0, 0xbf666666, 0x3f3142b2,
    0x0, 0x0, 0xbf666666, 0x3f30b2d5,
    0x0, 0x0, 0xbf666666, 0x3f30234f,
    0x0, 0x0, 0xbf666666, 0x3f2f941f,
    0x0, 0x0, 0xbf666666, 0x3f2f0544,
    0x0, 0x0, 0xbf666666, 0x3f2e76be,
    0x0, 0x0, 0xbf666666, 0x3f2de88d,
    0x0, 0x0, 0xbf666666, 0x3f2d5ab0,
    0x0, 0x0, 0xbf666666, 0x3f2ccd27,
    0x0, 0x0, 0xbf666666, 0x3f2c3ff1,
    0x0, 0x0, 0xbf666666, 0x3f2bb30e,
    0x0, 0x0, 0xbf666666, 0x3f2b267e,
    0x0, 0x0, 0xbf666666, 0x3f2a9a3f,
    0x0, 0x0, 0xbf666666, 0x3f2a0e52,
    0x0, 0x0, 0xbf666666, 0x3f2982b6,
    0x0, 0x0, 0xbf666666, 0x3f28f76a,
    0x0, 0x0, 0xbf666666, 0x3f286c6f,
    0x0, 0x0, 0xbf666666, 0x3f27e1c3,
    0x0, 0x0, 0xbf666666, 0x3f275766,
    0x0, 0x0, 0xbf666666, 0x3f26cd59,
    0x0, 0x0, 0xbf666666, 0x3f264399,
    0x0, 0x0, 0xbf666666, 0x3f25ba28,
    0x0, 0x0, 0xbf666666, 0x3f253104,
    0x0, 0x0, 0xbf666666, 0x3f24a82e,
    0x0, 0x0, 0xbf666666, 0x3f241fa4,
    0x0, 0x0, 0xbf666666, 0x3f239766,
    0x0, 0x0, 0xbf666666, 0x3f230f75,
    0x0, 0x0, 0xbf666666, 0x3f2287cf,
    0x0, 0x0, 0xbf666666, 0x3f220074,
    0x0, 0x0, 0xbf666666, 0x3f217963,
    0x0, 0x0, 0xbf666666, 0x3f20f29d,
    0x0, 0x0, 0xbf666666, 0x3f206c21,
    0x0, 0x0, 0xbf666666, 0x3f1fe5ee,
    0x0, 0x0, 0xbf666666, 0x3f1f6004,
    0x0, 0x0, 0xbf666666, 0x3f1eda63,
    0x0, 0x0, 0xbf666666, 0x3f1e550a,
    0x0, 0x0, 0xbf666666, 0x3f1dcff9,
    0x0, 0x0, 0xbf666666, 0x3f1d4b30,
    0x0, 0x0, 0xbf666666, 0x3f1cc6ae,
    0x0, 0x0, 0xbf666666, 0x3f1c4272,
    0x0, 0x0, 0xbf666666, 0x3f1bbe7d,
    0x0, 0x0, 0xbf666666, 0x3f1b3ace,
    0x0, 0x0, 0xbf666666, 0x3f1ab764,
    0x0, 0x0, 0xbf666666, 0x3f1a3440,
    0x0, 0x0, 0xbf666666, 0x3f19b160,
    0x0, 0x0, 0xbf666666, 0x3f192ec5,
    0x0, 0x0, 0xbf666666, 0x3f18ac6f,
    0x0, 0x0, 0xbf666666, 0x3f182a5c,
    0x0, 0x0, 0xbf666666, 0x3f17a88c,
    0x0, 0x0, 0xbf666666, 0x3f1726ff,
    0x0, 0x0, 0xbf666666, 0x3f16a5b5,
    0x0, 0x0, 0xbf666666, 0x3f1624ae,
    0x0, 0x0, 0xbf666666, 0x3f15a3e8,
    0x0, 0x0, 0xbf666666, 0x3f152364,
    0x0, 0x0, 0xbf666666, 0x3f14a321,
    0x0, 0x0, 0xbf666666, 0x3f14231f,
    0x0, 0x0, 0xbf666666, 0x3f13a35e,
    0x0, 0x0, 0xbf666666, 0x3f1323dd,
    0x0, 0x0, 0xbf666666, 0x3f12a49c,
    0x0, 0x0, 0xbf666666, 0x3f12259a,
    0x0, 0x0, 0xbf666666, 0x3f11a6d8,
    0x0, 0x0, 0xbf666666, 0x3f112855,
    0x0, 0x0, 0xbf666666, 0x3f10aa10,
    0x0, 0x0, 0xbf666666, 0x3f102c09,
    0x0, 0x0, 0xbf666666, 0x3f0fae40,
    0x0, 0x0, 0xbf666666, 0x3f0f30b5,
    0x0, 0x0, 0xbf666666, 0x3f0eb367,
    0x0, 0x0, 0xbf666666, 0x3f0e3655,
    0x0, 0x0, 0xbf666666, 0x3f0db981,
    0x0, 0x0, 0xbf666666, 0x3f0d3ce8,
    0x0, 0x0, 0xbf666666, 0x3f0cc08c,
    0x0, 0x0, 0xbf666666, 0x3f0c446b,
    0x0, 0x0, 0xbf666666, 0x3f0bc886,
    0x0, 0x0, 0xbf666666, 0x3f0b4cdb,
    0x0, 0x0, 0xbf666666, 0x3f0ad16b,
    0x0, 0x0, 0xbf666666, 0x3f0a5636,
    0x0, 0x0, 0xbf666666, 0x3f09db3a,
    0x0, 0x0, 0xbf666666, 0x3f096078,
    0x0, 0x0, 0xbf666666, 0x3f08e5f0,
    0x0, 0x0, 0xbf666666, 0x3f086ba1,
    0x0, 0x0, 0xbf666666, 0x3f07f18b,
    0x0, 0x0, 0xbf666666, 0x3f0777ad,
    0x0, 0x0, 0xbf666666, 0x3f06fe07,
    0x0, 0x0, 0xbf666666, 0x3f068499,
    0x0, 0x0, 0xbf666666, 0x3f060b63,
    0x0, 0x0, 0xbf666666, 0x3f059265,
    0x0, 0x0, 0xbf666666, 0x3f05199d,
    0x0, 0x0, 0xbf666666, 0x3f04a10c,
    0x0, 0x0, 0xbf666666, 0x3f0428b2,
    0x0, 0x0, 0xbf666666, 0x3f03b08d,
    0x0, 0x0, 0xbf666666, 0x3f03389f,
    0x0, 0x0, 0xbf666666, 0x3f02c0e6,
    0x0, 0x0, 0xbf666666, 0x3f024963,
    0x0, 0x0, 0xbf666666, 0x3f01d214,
    0x0, 0x0, 0xbf666666, 0x3f015afb,
    0x0, 0x0, 0xbf666666, 0x3f00e415,
    0x0, 0x0, 0xbf666666, 0x3f006d64,
    0x0, 0x0, 0xbf666666, 0x3effedcf,
    0x0, 0x0, 0xbf666666, 0x3eff013c,
    0x0, 0x0, 0xbf666666, 0x3efe1510,
    0x0, 0x0, 0xbf666666, 0x3efd294a,
    0x0, 0x0, 0xbf666666, 0x3efc3de9,
    0x0, 0x0, 0xbf666666, 0x3efb52ee,
    0x0, 0x0, 0xbf666666, 0x3efa6857,
    0x0, 0x0, 0xbf666666, 0x3ef97e25,
    0x0, 0x0, 0xbf666666, 0x3ef89456,
    0x0, 0x0, 0xbf666666, 0x3ef7aaea,
    0x0, 0x0, 0xbf666666, 0x3ef6c1e0,
    0x0, 0x0, 0xbf666666, 0x3ef5d938,
    0x0, 0x0, 0xbf666666, 0x3ef4f0f2,
    0x0, 0x0, 0xbf666666, 0x3ef4090c,
    0x0, 0x0, 0xbf666666, 0x3ef32187,
    0x0, 0x0, 0xbf666666, 0x3ef23a62,
    0x0, 0x0, 0xbf666666, 0x3ef1539c,
    0x0, 0x0, 0xbf666666, 0x3ef06d35,
    0x0, 0x0, 0xbf666666, 0x3eef872d,
    0x0, 0x0, 0xbf666666, 0x3eeea182,
    0x0, 0x0, 0xbf666666, 0x3eedbc34,
    0x0, 0x0, 0xbf666666, 0x3eecd744,
    0x0, 0x0, 0xbf666666, 0x3eebf2af,
    0x0, 0x0, 0xbf666666, 0x3eeb0e77,
    0x0, 0x0, 0xbf666666, 0x3eea2a9a,
    0x0, 0x0, 0xbf666666, 0x3ee94718,
    0x0, 0x0, 0xbf666666, 0x3ee863f0,
    0x0, 0x0, 0xbf666666, 0x3ee78122,
    0x0, 0x0, 0xbf666666, 0x3ee69ead,
    0x0, 0x0, 0xbf666666, 0x3ee5bc92,
    0x0, 0x0, 0xbf666666, 0x3ee4dacf,
    0x0, 0x0, 0xbf666666, 0x3ee3f964,
    0x0, 0x0, 0xbf666666, 0x3ee31850,
    0x0, 0x0, 0xbf666666, 0x3ee23793,
    0x0, 0x0, 0xbf666666, 0x3ee1572e,
    0x0, 0x0, 0xbf666666, 0x3ee0771e,
    0x0, 0x0, 0xbf666666, 0x3edf9764,
    0x0, 0x0, 0xbf666666, 0x3edeb7ff,
    0x0, 0x0, 0xbf666666, 0x3eddd8ee,
    0x0, 0x0, 0xbf666666, 0x3edcfa33,
    0x0, 0x0, 0xbf666666, 0x3edc1bca,
    0x0, 0x0, 0xbf666666, 0x3edb3db6,
    0x0, 0x0, 0xbf666666, 0x3eda5ff4,
    0x0, 0x0, 0xbf666666, 0x3ed98285,
    0x0, 0x0, 0xbf666666, 0x3ed8a567,
    0x0, 0x0, 0xbf666666, 0x3ed7c89c,
    0x0, 0x0, 0xbf666666, 0x3ed6ec21,
    0x0, 0x0, 0xbf666666, 0x3ed60ff7,
    0x0, 0x0, 0xbf666666, 0x3ed5341e,
    0x0, 0x0, 0xbf666666, 0x3ed45894,
    0x0, 0x0, 0xbf666666, 0x3ed37d5a,
    0x0, 0x0, 0xbf666666, 0x3ed2a26e,
    0x0, 0x0, 0xbf666666, 0x3ed1c7d1,
    0x0, 0x0, 0xbf666666, 0x3ed0ed83,
    0x0, 0x0, 0xbf666666, 0x3ed01382,
    0x0, 0x0, 0xbf666666, 0x3ecf39ce,
    0x0, 0x0, 0xbf666666, 0x3ece6067,
    0x0, 0x0, 0xbf666666, 0x3ecd874c,
    0x0, 0x0, 0xbf666666, 0x3eccae7e,
    0x0, 0x0, 0xbf666666, 0x3ecbd5fb,
    0x0, 0x0, 0xbf666666, 0x3ecafdc3,
    0x0, 0x0, 0xbf666666, 0x3eca25d6,
    0x0, 0x0, 0xbf666666, 0x3ec94e34,
    0x0, 0x0, 0xbf666666, 0x3ec876db,
    0x0, 0x0, 0xbf666666, 0x3ec79fcc,
    0x0, 0x0, 0xbf666666, 0x3ec6c906,
    0x0, 0x0, 0xbf666666, 0x3ec5f288,
    0x0, 0x0, 0xbf666666, 0x3ec51c53,
    0x0, 0x0, 0xbf666666, 0x3ec44666,
    0x0, 0x0, 0xbf666666, 0x3ec370c1,
    0x0, 0x0, 0xbf666666, 0x3ec29b62,
    0x0, 0x0, 0xbf666666, 0x3ec1c64a,
    0x0, 0x0, 0xbf666666, 0x3ec0f179,
    0x0, 0x0, 0xbf666666, 0x3ec01cee,
    0x0, 0x0, 0xbf666666, 0x3ebf48a8,
    0x0, 0x0, 0xbf666666, 0x3ebe74a7,
    0x0, 0x0, 0xbf666666, 0x3ebda0eb,
    0x0, 0x0, 0xbf666666, 0x3ebccd73,
    0x0, 0x0, 0xbf666666, 0x3ebbfa40,
    0x0, 0x0, 0xbf666666, 0x3ebb2750,
    0x0, 0x0, 0xbf666666, 0x3eba54a3,
    0x0, 0x0, 0xbf666666, 0x3eb98239,
    0x0, 0x0, 0xbf666666, 0x3eb8b012,
    0x0, 0x0, 0xbf666666, 0x3eb7de2d,
    0x0, 0x0, 0xbf666666, 0x3eb70c89,
    0x0, 0x0, 0xbf666666, 0x3eb63b27,
    0x0, 0x0, 0xbf666666, 0x3eb56a06,
    0x0, 0x0, 0xbf666666, 0x3eb49926,
    0x0, 0x0, 0xbf666666, 0x3eb3c885,
    0x0, 0x0, 0xbf666666, 0x3eb2f825,
    0x0, 0x0, 0xbf666666, 0x3eb22804,
    0x0, 0x0, 0xbf666666, 0x3eb15822,
    0x0, 0x0, 0xbf666666, 0x3eb08880,
    0x0, 0x0, 0xbf666666, 0x3eafb91b,
    0x0, 0x0, 0xbf666666, 0x3eaee9f5,
    0x0, 0x0, 0xbf666666, 0x3eae1b0c,
    0x0, 0x0, 0xbf666666, 0x3ead4c61,
    0x0, 0x0, 0xbf666666, 0x3eac7df3,
    0x0, 0x0, 0xbf666666, 0x3eabafc1,
    0x0, 0x0, 0xbf666666, 0x3eaae1cc,
    0x0, 0x0, 0xbf666666, 0x3eaa1412,
    0x0, 0x0, 0xbf666666, 0x3ea94695,
    0x0, 0x0, 0xbf666666, 0x3ea87952,
    0x0, 0x0, 0xbf666666, 0x3ea7ac4b,
    0x0, 0x0, 0xbf666666, 0x3ea6df7e,
    0x0, 0x0, 0xbf666666, 0x3ea612eb,
    0x0, 0x0, 0xbf666666, 0x3ea54692,
    0x0, 0x0, 0xbf666666, 0x3ea47a72,
    0x0, 0x0, 0xbf666666, 0x3ea3ae8c,
    0x0, 0x0, 0xbf666666, 0x3ea2e2df,
    0x0, 0x0, 0xbf666666, 0x3ea2176a,
    0x0, 0x0, 0xbf666666, 0x3ea14c2d,
    0x0, 0x0, 0xbf666666, 0x3ea08129,
    0x0, 0x0, 0xbf666666, 0x3e9fb65b,
    0x0, 0x0, 0xbf666666, 0x3e9eebc5,
    0x0, 0x0, 0xbf666666, 0x3e9e2166,
    0x0, 0x0, 0xbf666666, 0x3e9d573d,
    0x0, 0x0, 0xbf666666, 0x3e9c8d4b,
    0x0, 0x0, 0xbf666666, 0x3e9bc38e,
    0x0, 0x0, 0xbf666666, 0x3e9afa07,
    0x0, 0x0, 0xbf666666, 0x3e9a30b5,
    0x0, 0x0, 0xbf666666, 0x3e996798,
    0x0, 0x0, 0xbf666666, 0x3e989eaf,
    0x0, 0x0, 0xbf666666, 0x3e97d5fb,
    0x0, 0x0, 0xbf666666, 0x3e970d7a,
    0x0, 0x0, 0xbf666666, 0x3e96452d,
    0x0, 0x0, 0xbf666666, 0x3e957d14,
    0x0, 0x0, 0xbf666666, 0x3e94b52d,
    0x0, 0x0, 0xbf666666, 0x3e93ed79,
    0x0, 0x0, 0xbf666666, 0x3e9325f8,
    0x0, 0x0, 0xbf666666, 0x3e925ea8,
    0x0, 0x0, 0xbf666666, 0x3e91978a,
    0x0, 0x0, 0xbf666666, 0x3e90d09e,
    0x0, 0x0, 0xbf666666, 0x3e9009e2,
    0x0, 0x0, 0xbf666666, 0x3e8f4358,
    0x0, 0x0, 0xbf666666, 0x3e8e7cfe,
    0x0, 0x0, 0xbf666666, 0x3e8db6d4,
    0x0, 0x0, 0xbf666666, 0x3e8cf0d9,
    0x0, 0x0, 0xbf666666, 0x3e8c2b0f,
    0x0, 0x0, 0xbf666666, 0x3e8b6573,
    0x0, 0x0, 0xbf666666, 0x3e8aa007,
    0x0, 0x0, 0xbf666666, 0x3e89dac9,
    0x0, 0x0, 0xbf666666, 0x3e8915b9,
    0x0, 0x0, 0xbf666666, 0x3e8850d8,
    0x0, 0x0, 0xbf666666, 0x3e878c24,
    0x0, 0x0, 0xbf666666, 0x3e86c79e,
    0x0, 0x0, 0xbf666666, 0x3e860344,
    0x0, 0x0, 0xbf666666, 0x3e853f18,
    0x0, 0x0, 0xbf666666, 0x3e847b18,
    0x0, 0x0, 0xbf666666, 0x3e83b744,
    0x0, 0x0, 0xbf666666, 0x3e82f39d,
    0x0, 0x0, 0xbf666666, 0x3e823020,
    0x0, 0x0, 0xbf666666, 0x3e816cd0,
    0x0, 0x0, 0xbf666666, 0x3e80a9aa,
    0x0, 0x0, 0xbf666666, 0x3e7fcd5e,
    0x0, 0x0, 0xbf666666, 0x3e7e47be,
    0x0, 0x0, 0xbf666666, 0x3e7cc271,
    0x0, 0x0, 0xbf666666, 0x3e7b3d79,
    0x0, 0x0, 0xbf666666, 0x3e79b8d3,
    0x0, 0x0, 0xbf666666, 0x3e783481,
    0x0, 0x0, 0xbf666666, 0x3e76b080,
    0x0, 0x0, 0xbf666666, 0x3e752cd1,
    0x0, 0x0, 0xbf666666, 0x3e73a973,
    0x0, 0x0, 0xbf666666, 0x3e722666,
    0x0, 0x0, 0xbf666666, 0x3e70a3a8,
    0x0, 0x0, 0xbf666666, 0x3e6f2139,
    0x0, 0x0, 0xbf666666, 0x3e6d9f1a,
    0x0, 0x0, 0xbf666666, 0x3e6c1d48,
    0x0, 0x0, 0xbf666666, 0x3e6a9bc4,
    0x0, 0x0, 0xbf666666, 0x3e691a8d,
    0x0, 0x0, 0xbf666666, 0x3e6799a3,
    0x0, 0x0, 0xbf666666, 0x3e661904,
    0x0, 0x0, 0xbf666666, 0x3e6498b1,
    0x0, 0x0, 0xbf666666, 0x3e6318a9,
    0x0, 0x0, 0xbf666666, 0x3e6198eb,
    0x0, 0x0, 0xbf666666, 0x3e601976,
    0x0, 0x0, 0xbf666666, 0x3e5e9a4b,
    0x0, 0x0, 0xbf666666, 0x3e5d1b69,
    0x0, 0x0, 0xbf666666, 0x3e5b9ccf,
    0x0, 0x0, 0xbf666666, 0x3e5a1e7c,
    0x0, 0x0, 0xbf666666, 0x3e58a070,
    0x0, 0x0, 0xbf666666, 0x3e5722ab,
    0x0, 0x0, 0xbf666666, 0x3e55a52c,
    0x0, 0x0, 0xbf666666, 0x3e5427f2,
    0x0, 0x0, 0xbf666666, 0x3e52aafe,
    0x0, 0x0, 0xbf666666, 0x3e512e4d,
    0x0, 0x0, 0xbf666666, 0x3e4fb1e0,
    0x0, 0x0, 0xbf666666, 0x3e4e35b7,
    0x0, 0x0, 0xbf666666, 0x3e4cb9d1,
    0x0, 0x0, 0xbf666666, 0x3e4b3e2c,
    0x0, 0x0, 0xbf666666, 0x3e49c2ca,
    0x0, 0x0, 0xbf666666, 0x3e4847a9,
    0x0, 0x0, 0xbf666666, 0x3e46ccc8,
    0x0, 0x0, 0xbf666666, 0x3e455227,
    0x0, 0x0, 0xbf666666, 0x3e43d7c7,
    0x0, 0x0, 0xbf666666, 0x3e425da5,
    0x0, 0x0, 0xbf666666, 0x3e40e3c2,
    0x0, 0x0, 0xbf666666, 0x3e3f6a1d,
    0x0, 0x0, 0xbf666666, 0x3e3df0b6,
    0x0, 0x0, 0xbf666666, 0x3e3c778b,
    0x0, 0x0, 0xbf666666, 0x3e3afe9d,
    0x0, 0x0, 0xbf666666, 0x3e3985ec,
    0x0, 0x0, 0xbf666666, 0x3e380d76,
    0x0, 0x0, 0xbf666666, 0x3e36953a,
    0x0, 0x0, 0xbf666666, 0x3e351d3a,
    0x0, 0x0, 0xbf666666, 0x3e33a573,
    0x0, 0x0, 0xbf666666, 0x3e322de6,
    0x0, 0x0, 0xbf666666, 0x3e30b692,
    0x0, 0x0, 0xbf666666, 0x3e2f3f77,
    0x0, 0x0, 0xbf666666, 0x3e2dc893,
    0x0, 0x0, 0xbf666666, 0x3e2c51e7,
    0x0, 0x0, 0xbf666666, 0x3e2adb72,
    0x0, 0x0, 0xbf666666, 0x3e296533,
    0x0, 0x0, 0xbf666666, 0x3e27ef2b,
    0x0, 0x0, 0xbf666666, 0x3e267958,
    0x0, 0x0, 0xbf666666, 0x3e2503ba,
    0x0, 0x0, 0xbf666666, 0x3e238e50,
    0x0, 0x0, 0xbf666666, 0x3e22191b,
    0x0, 0x0, 0xbf666666, 0x3e20a419,
    0x0, 0x0, 0xbf666666, 0x3e1f2f4a,
    0x0, 0x0, 0xbf666666, 0x3e1dbaae,
    0x0, 0x0, 0xbf666666, 0x3e1c4644,
    0x0, 0x0, 0xbf666666, 0x3e1ad20b,
    0x0, 0x0, 0xbf666666, 0x3e195e04,
    0x0, 0x0, 0xbf666666, 0x3e17ea2d,
    0x0, 0x0, 0xbf666666, 0x3e167686,
    0x0, 0x0, 0xbf666666, 0x3e15030f,
    0x0, 0x0, 0xbf666666, 0x3e138fc7,
    0x0, 0x0, 0xbf666666, 0x3e121cad,
    0x0, 0x0, 0xbf666666, 0x3e10a9c2,
    0x0, 0x0, 0xbf666666, 0x3e0f3705,
    0x0, 0x0, 0xbf666666, 0x3e0dc475,
    0x0, 0x0, 0xbf666666, 0x3e0c5211,
    0x0, 0x0, 0xbf666666, 0x3e0adfda,
    0x0, 0x0, 0xbf666666, 0x3e096dcf,
    0x0, 0x0, 0xbf666666, 0x3e07fbef,
    0x0, 0x0, 0xbf666666, 0x3e068a3a,
    0x0, 0x0, 0xbf666666, 0x3e0518af,
    0x0, 0x0, 0xbf666666, 0x3e03a74e,
    0x0, 0x0, 0xbf666666, 0x3e023617,
    0x0, 0x0, 0xbf666666, 0x3e00c509,
    0x0, 0x0, 0xbf666666, 0x3dfea845,
    0x0, 0x0, 0xbf666666, 0x3dfbc6c9,
    0x0, 0x0, 0xbf666666, 0x3df8e59d,
    0x0, 0x0, 0xbf666666, 0x3df604be,
    0x0, 0x0, 0xbf666666, 0x3df3242d,
    0x0, 0x0, 0xbf666666, 0x3df043e8,
    0x0, 0x0, 0xbf666666, 0x3ded63ee,
    0x0, 0x0, 0xbf666666, 0x3dea843f,
    0x0, 0x0, 0xbf666666, 0x3de7a4d9,
    0x0, 0x0, 0xbf666666, 0x3de4c5bc,
    0x0, 0x0, 0xbf666666, 0x3de1e6e6,
    0x0, 0x0, 0xbf666666, 0x3ddf0857,
    0x0, 0x0, 0xbf666666, 0x3ddc2a0e,
    0x0, 0x0, 0xbf666666, 0x3dd94c0a,
    0x0, 0x0, 0xbf666666, 0x3dd66e4a,
    0x0, 0x0, 0xbf666666, 0x3dd390cd,
    0x0, 0x0, 0xbf666666, 0x3dd0b392,
    0x0, 0x0, 0xbf666666, 0x3dcdd698,
    0x0, 0x0, 0xbf666666, 0x3dcaf9de,
    0x0, 0x0, 0xbf666666, 0x3dc81d64,
    0x0, 0x0, 0xbf666666, 0x3dc54128,
    0x0, 0x0, 0xbf666666, 0x3dc2652a,
    0x0, 0x0, 0xbf666666, 0x3dbf8969,
    0x0, 0x0, 0xbf666666, 0x3dbcade3,
    0x0, 0x0, 0xbf666666, 0x3db9d298,
    0x0, 0x0, 0xbf666666, 0x3db6f786,
    0x0, 0x0, 0xbf666666, 0x3db41cae,
    0x0, 0x0, 0xbf666666, 0x3db1420e,
    0x0, 0x0, 0xbf666666, 0x3dae67a5,
    0x0, 0x0, 0xbf666666, 0x3dab8d72,
    0x0, 0x0, 0xbf666666, 0x3da8b375,
    0x0, 0x0, 0xbf666666, 0x3da5d9ac,
    0x0, 0x0, 0xbf666666, 0x3da30017,
    0x0, 0x0, 0xbf666666, 0x3da026b4,
    0x0, 0x0, 0xbf666666, 0x3d9d4d83,
    0x0, 0x0, 0xbf666666, 0x3d9a7483,
    0x0, 0x0, 0xbf666666, 0x3d979bb3,
    0x0, 0x0, 0xbf666666, 0x3d94c313,
    0x0, 0x0, 0xbf666666, 0x3d91eaa0,
    0x0, 0x0, 0xbf666666, 0x3d8f125a,
    0x0, 0x0, 0xbf666666, 0x3d8c3a41,
    0x0, 0x0, 0xbf666666, 0x3d896254,
    0x0, 0x0, 0xbf666666, 0x3d868a91,
    0x0, 0x0, 0xbf666666, 0x3d83b2f8,
    0x0, 0x0, 0xbf666666, 0x3d80db87,
    0x0, 0x0, 0xbf666666, 0x3d7c087d,
    0x0, 0x0, 0xbf666666, 0x3d765a3a,
    0x0, 0x0, 0xbf666666, 0x3d70ac44,
    0x0, 0x0, 0xbf666666, 0x3d6afe98,
    0x0, 0x0, 0xbf666666, 0x3d655135,
    0x0, 0x0, 0xbf666666, 0x3d5fa418,
    0x0, 0x0, 0xbf666666, 0x3d59f741,
    0x0, 0x0, 0xbf666666, 0x3d544aae,
    0x0, 0x0, 0xbf666666, 0x3d4e9e5c,
    0x0, 0x0, 0xbf666666, 0x3d48f24a,
    0x0, 0x0, 0xbf666666, 0x3d434676,
    0x0, 0x0, 0xbf666666, 0x3d3d9adf,
    0x0, 0x0, 0xbf666666, 0x3d37ef82,
    0x0, 0x0, 0xbf666666, 0x3d32445f,
    0x0, 0x0, 0xbf666666, 0x3d2c9972,
    0x0, 0x0, 0xbf666666, 0x3d26eeba,
    0x0, 0x0, 0xbf666666, 0x3d214437,
    0x0, 0x0, 0xbf666666, 0x3d1b99e5,
    0x0, 0x0, 0xbf666666, 0x3d15efc3,
    0x0, 0x0, 0xbf666666, 0x3d1045cf,
    0x0, 0x0, 0xbf666666, 0x3d0a9c08,
    0x0, 0x0, 0xbf666666, 0x3d04f26c,
    0x0, 0x0, 0xbf666666, 0x3cfe91f2,
    0x0, 0x0, 0xbf666666, 0x3cf33f5a,
    0x0, 0x0, 0xbf666666, 0x3ce7ed0e,
    0x0, 0x0, 0xbf666666, 0x3cdc9b09,
    0x0, 0x0, 0xbf666666, 0x3cd14948,
    0x0, 0x0, 0xbf666666, 0x3cc5f7c8,
    0x0, 0x0, 0xbf666666, 0x3cbaa685,
    0x0, 0x0, 0xbf666666, 0x3caf557b,
    0x0, 0x0, 0xbf666666, 0x3ca404a8,
    0x0, 0x0, 0xbf666666, 0x3c98b407,
    0x0, 0x0, 0xbf666666, 0x3c8d6395,
    0x0, 0x0, 0xbf666666, 0x3c82134f,
    0x0, 0x0, 0xbf666666, 0x3c6d8663,
    0x0, 0x0, 0xbf666666, 0x3c56e670,
    0x0, 0x0, 0xbf666666, 0x3c4046c0,
    0x0, 0x0, 0xbf666666, 0x3c29a74b,
    0x0, 0x0, 0xbf666666, 0x3c13080a,
    0x0, 0x0, 0xbf666666, 0x3bf8d1ee,
    0x0, 0x0, 0xbf666666, 0x3bcb9414,
    0x0, 0x0, 0xbf666666, 0x3b9e5679,
    0x0, 0x0, 0xbf666666, 0x3b62321f,
    0x0, 0x0, 0xbf666666, 0x3b07b790,
    0x0, 0x0, 0xbf666666, 0x3a34f4ad,
    0x0, 0x0, 0xbf666666, 0xba34f4ad,
    0x0, 0x0, 0xbf666666, 0xbb07b790,
    0x0, 0x0, 0xbf666666, 0xbb62321f,
    0x0, 0x0, 0xbf666666, 0xbb9e5679,
    0x0, 0x0, 0xbf666666, 0xbbcb9414,
    0x0, 0x0, 0xbf666666, 0xbbf8d1ee,
    0x0, 0x0, 0xbf666666, 0xbc13080a,
    0x0, 0x0, 0xbf666666, 0xbc29a74b,
    0x0, 0x0, 0xbf666666, 0xbc4046c0,
    0x0, 0x0, 0xbf666666, 0xbc56e670,
    0x0, 0x0, 0xbf666666, 0xbc6d8663,
    0x0, 0x0, 0xbf666666, 0xbc82134f,
    0x0, 0x0, 0xbf666666, 0xbc8d6395,
    0x0, 0x0, 0xbf666666, 0xbc98b407,
    0x0, 0x0, 0xbf666666, 0xbca404a8,
    0x0, 0x0, 0xbf666666, 0xbcaf557b,
    0x0, 0x0, 0xbf666666, 0xbcbaa685,
    0x0, 0x0, 0xbf666666, 0xbcc5f7c8,
    0x0, 0x0, 0xbf666666, 0xbcd14948,
    0x0, 0x0, 0xbf666666, 0xbcdc9b09,
    0x0, 0x0, 0xbf666666, 0xbce7ed0e,
    0x0, 0x0, 0xbf666666, 0xbcf33f5a,
    0x0, 0x0, 0xbf666666, 0xbcfe91f2,
    0x0, 0x0, 0xbf666666, 0xbd04f26c,
    0x0, 0x0, 0xbf666666, 0xbd0a9c08,
    0x0, 0x0, 0xbf666666, 0xbd1045cf,
    0x0, 0x0, 0xbf666666, 0xbd15efc3,
    0x0, 0x0, 0xbf666666, 0xbd1b99e5,
    0x0, 0x0, 0xbf666666, 0xbd214437,
    0x0, 0x0, 0xbf666666, 0xbd26eeba,
    0x0, 0x0, 0xbf666666, 0xbd2c9972,
    0x0, 0x0, 0xbf666666, 0xbd32445f,
    0x0, 0x0, 0xbf666666, 0xbd37ef82,
    0x0, 0x0, 0xbf666666, 0xbd3d9adf,
    0x0, 0x0, 0xbf666666, 0xbd434676,
    0x0, 0x0, 0xbf666666, 0xbd48f24a,
    0x0, 0x0, 0xbf666666, 0xbd4e9e5c,
    0x0, 0x0, 0xbf666666, 0xbd544aae,
    0x0, 0x0, 0xbf666666, 0xbd59f741,
    0x0, 0x0, 0xbf666666, 0xbd5fa418,
    0x0, 0x0, 0xbf666666, 0xbd655135,
    0x0, 0x0, 0xbf666666, 0xbd6afe98,
    0x0, 0x0, 0xbf666666, 0xbd70ac44,
    0x0, 0x0, 0xbf666666, 0xbd765a3a,
    0x0, 0x0, 0xbf666666, 0xbd7c087d,
    0x0, 0x0, 0xbf666666, 0xbd80db87,
    0x0, 0x0, 0xbf666666, 0xbd83b2f8,
    0x0, 0x0, 0xbf666666, 0xbd868a91,
    0x0, 0x0, 0xbf666666, 0xbd896254,
    0x0, 0x0, 0xbf666666, 0xbd8c3a41,
    0x0, 0x0, 0xbf666666, 0xbd8f125a,
    0x0, 0x0, 0xbf666666, 0xbd91eaa0,
    0x0, 0x0, 0xbf666666, 0xbd94c313,
    0x0, 0x0, 0xbf666666, 0xbd979bb3,
    0x0, 0x0, 0xbf666666, 0xbd9a7483,
    0x0, 0x0, 0xbf666666, 0xbd9d4d83,
    0x0, 0x0, 0xbf666666, 0xbda026b4,
    0x0, 0x0, 0xbf666666, 0xbda30017,
    0x0, 0x0, 0xbf666666, 0xbda5d9ac,
    0x0, 0x0, 0xbf666666, 0xbda8b375,
    0x0, 0x0, 0xbf666666, 0xbdab8d72,
    0x0, 0x0, 0xbf666666, 0xbdae67a5,
    0x0, 0x0, 0xbf666666, 0xbdb1420e,
    0x0, 0x0, 0xbf666666, 0xbdb41cae,
    0x0, 0x0, 0xbf666666, 0xbdb6f786,
    0x0, 0x0, 0xbf666666, 0xbdb9d298,
    0x0, 0x0, 0xbf666666, 0xbdbcade3,
    0x0, 0x0, 0xbf666666, 0xbdbf8969,
    0x0, 0x0, 0xbf666666, 0xbdc2652a,
    0x0, 0x0, 0xbf666666, 0xbdc54128,
    0x0, 0x0, 0xbf666666, 0xbdc81d64,
    0x0, 0x0, 0xbf666666, 0xbdcaf9de,
    0x0, 0x0, 0xbf666666, 0xbdcdd698,
    0x0, 0x0, 0xbf666666, 0xbdd0b392,
    0x0, 0x0, 0xbf666666, 0xbdd390cd,
    0x0, 0x0, 0xbf666666, 0xbdd66e4a,
    0x0, 0x0, 0xbf666666, 0xbdd94c0a,
    0x0, 0x0, 0xbf666666, 0xbddc2a0e,
    0x0, 0x0, 0xbf666666, 0xbddf0857,
    0x0, 0x0, 0xbf666666, 0xbde1e6e6,
    0x0, 0x0, 0xbf666666, 0xbde4c5bc,
    0x0, 0x0, 0xbf666666, 0xbde7a4d9,
    0x0, 0x0, 0xbf666666, 0xbdea843f,
    0x0, 0x0, 0xbf666666, 0xbded63ee,
    0x0, 0x0, 0xbf666666, 0xbdf043e8,
    0x0, 0x0, 0xbf666666, 0xbdf3242d,
    0x0, 0x0, 0xbf666666, 0xbdf604be,
    0x0, 0x0, 0xbf666666, 0xbdf8e59d,
    0x0, 0x0, 0xbf666666, 0xbdfbc6c9,
    0x0, 0x0, 0xbf666666, 0xbdfea845,
    0x0, 0x0, 0xbf666666, 0xbe00c509,
    0x0, 0x0, 0xbf666666, 0xbe023617,
    0x0, 0x0, 0xbf666666, 0xbe03a74e,
    0x0, 0x0, 0xbf666666, 0xbe0518af,
    0x0, 0x0, 0xbf666666, 0xbe068a3a,
    0x0, 0x0, 0xbf666666, 0xbe07fbef,
    0x0, 0x0, 0xbf666666, 0xbe096dcf,
    0x0, 0x0, 0xbf666666, 0xbe0adfda,
    0x0, 0x0, 0xbf666666, 0xbe0c5211,
    0x0, 0x0, 0xbf666666, 0xbe0dc475,
    0x0, 0x0, 0xbf666666, 0xbe0f3705,
    0x0, 0x0, 0xbf666666, 0xbe10a9c2,
    0x0, 0x0, 0xbf666666, 0xbe121cad,
    0x0, 0x0, 0xbf666666, 0xbe138fc7,
    0x0, 0x0, 0xbf666666, 0xbe15030f,
    0x0, 0x0, 0xbf666666, 0xbe167686,
    0x0, 0x0, 0xbf666666, 0xbe17ea2d,
    0x0, 0x0, 0xbf666666, 0xbe195e04,
    0x0, 0x0, 0xbf666666, 0xbe1ad20b,
    0x0, 0x0, 0xbf666666, 0xbe1c4644,
    0x0, 0x0, 0xbf666666, 0xbe1dbaae,
    0x0, 0x0, 0xbf666666, 0xbe1f2f4a,
    0x0, 0x0, 0xbf666666, 0xbe20a419,
    0x0, 0x0, 0xbf666666, 0xbe22191b,
    0x0, 0x0, 0xbf666666, 0xbe238e50,
    0x0, 0x0, 0xbf666666, 0xbe2503ba,
    0x0, 0x0, 0xbf666666, 0xbe267958,
    0x0, 0x0, 0xbf666666, 0xbe27ef2b,
    0x0, 0x0, 0xbf666666, 0xbe296533,
    0x0, 0x0, 0xbf666666, 0xbe2adb72,
    0x0, 0x0, 0xbf666666, 0xbe2c51e7,
    0x0, 0x0, 0xbf666666, 0xbe2dc893,
    0x0, 0x0, 0xbf666666, 0xbe2f3f77,
    0x0, 0x0, 0xbf666666, 0xbe30b692,
    0x0, 0x0, 0xbf666666, 0xbe322de6,
    0x0, 0x0, 0xbf666666, 0xbe33a573,
    0x0, 0x0, 0xbf666666, 0xbe351d3a,
    0x0, 0x0, 0xbf666666, 0xbe36953a,
    0x0, 0x0, 0xbf666666, 0xbe380d76,
    0x0, 0x0, 0xbf666666, 0xbe3985ec,
    0x0, 0x0, 0xbf666666, 0xbe3afe9d,
    0x0, 0x0, 0xbf666666, 0xbe3c778b,
    0x0, 0x0, 0xbf666666, 0xbe3df0b6,
    0x0, 0x0, 0xbf666666, 0xbe3f6a1d,
    0x0, 0x0, 0xbf666666, 0xbe40e3c2,
    0x0, 0x0, 0xbf666666, 0xbe425da5,
    0x0, 0x0, 0xbf666666, 0xbe43d7c7,
    0x0, 0x0, 0xbf666666, 0xbe455227,
    0x0, 0x0, 0xbf666666, 0xbe46ccc8,
    0x0, 0x0, 0xbf666666, 0xbe4847a9,
    0x0, 0x0, 0xbf666666, 0xbe49c2ca,
    0x0, 0x0, 0xbf666666, 0xbe4b3e2c,
    0x0, 0x0, 0xbf666666, 0xbe4cb9d1,
    0x0, 0x0, 0xbf666666, 0xbe4e35b7,
    0x0, 0x0, 0xbf666666, 0xbe4fb1e0,
    0x0, 0x0, 0xbf666666, 0xbe512e4d,
    0x0, 0x0, 0xbf666666, 0xbe52aafe,
    0x0, 0x0, 0xbf666666, 0xbe5427f2,
    0x0, 0x0, 0xbf666666, 0xbe55a52c,
    0x0, 0x0, 0xbf666666, 0xbe5722ab,
    0x0, 0x0, 0xbf666666, 0xbe58a070,
    0x0, 0x0, 0xbf666666, 0xbe5a1e7c,
    0x0, 0x0, 0xbf666666, 0xbe5b9ccf,
    0x0, 0x0, 0xbf666666, 0xbe5d1b69,
    0x0, 0x0, 0xbf666666, 0xbe5e9a4b,
    0x0, 0x0, 0xbf666666, 0xbe601976,
    0x0, 0x0, 0xbf666666, 0xbe6198eb,
    0x0, 0x0, 0xbf666666, 0xbe6318a9,
    0x0, 0x0, 0xbf666666, 0xbe6498b1,
    0x0, 0x0, 0xbf666666, 0xbe661904,
    0x0, 0x0, 0xbf666666, 0xbe6799a3,
    0x0, 0x0, 0xbf666666, 0xbe691a8d,
    0x0, 0x0, 0xbf666666, 0xbe6a9bc4,
    0x0, 0x0, 0xbf666666, 0xbe6c1d48,
    0x0, 0x0, 0xbf666666, 0xbe6d9f1a,
    0x0, 0x0, 0xbf666666, 0xbe6f2139,
    0x0, 0x0, 0xbf666666, 0xbe70a3a8,
    0x0, 0x0, 0xbf666666, 0xbe722666,
    0x0, 0x0, 0xbf666666, 0xbe73a973,
    0x0, 0x0, 0xbf666666, 0xbe752cd1,
    0x0, 0x0, 0xbf666666, 0xbe76b080,
    0x0, 0x0, 0xbf666666, 0xbe783481,
    0x0, 0x0, 0xbf666666, 0xbe79b8d3,
    0x0, 0x0, 0xbf666666, 0xbe7b3d79,
    0x0, 0x0, 0xbf666666, 0xbe7cc271,
    0x0, 0x0, 0xbf666666, 0xbe7e47be,
    0x0, 0x0, 0xbf666666, 0xbe7fcd5e,
    0x0, 0x0, 0xbf666666, 0xbe80a9aa,
    0x0, 0x0, 0xbf666666, 0xbe816cd0,
    0x0, 0x0, 0xbf666666, 0xbe823020,
    0x0, 0x0, 0xbf666666, 0xbe82f39d,
    0x0, 0x0, 0xbf666666, 0xbe83b744,
    0x0, 0x0, 0xbf666666, 0xbe847b18,
    0x0, 0x0, 0xbf666666, 0xbe853f18,
    0x0, 0x0, 0xbf666666, 0xbe860344,
    0x0, 0x0, 0xbf666666, 0xbe86c79e,
    0x0, 0x0, 0xbf666666, 0xbe878c24,
    0x0, 0x0, 0xbf666666, 0xbe8850d8,
    0x0, 0x0, 0xbf666666, 0xbe8915b9,
    0x0, 0x0, 0xbf666666, 0xbe89dac9,
    0x0, 0x0, 0xbf666666, 0xbe8aa007,
    0x0, 0x0, 0xbf666666, 0xbe8b6573,
    0x0, 0x0, 0xbf666666, 0xbe8c2b0f,
    0x0, 0x0, 0xbf666666, 0xbe8cf0d9,
    0x0, 0x0, 0xbf666666, 0xbe8db6d4,
    0x0, 0x0, 0xbf666666, 0xbe8e7cfe,
    0x0, 0x0, 0xbf666666, 0xbe8f4358,
    0x0, 0x0, 0xbf666666, 0xbe9009e2,
    0x0, 0x0, 0xbf666666, 0xbe90d09e,
    0x0, 0x0, 0xbf666666, 0xbe91978a,
    0x0, 0x0, 0xbf666666, 0xbe925ea8,
    0x0, 0x0, 0xbf666666, 0xbe9325f8,
    0x0, 0x0, 0xbf666666, 0xbe93ed79,
    0x0, 0x0, 0xbf666666, 0xbe94b52d,
    0x0, 0x0, 0xbf666666, 0xbe957d14,
    0x0, 0x0, 0xbf666666, 0xbe96452d,
    0x0, 0x0, 0xbf666666, 0xbe970d7a,
    0x0, 0x0, 0xbf666666, 0xbe97d5fb,
    0x0, 0x0, 0xbf666666, 0xbe989eaf,
    0x0, 0x0, 0xbf666666, 0xbe996798,
    0x0, 0x0, 0xbf666666, 0xbe9a30b5,
    0x0, 0x0, 0xbf666666, 0xbe9afa07,
    0x0, 0x0, 0xbf666666, 0xbe9bc38e,
    0x0, 0x0, 0xbf666666, 0xbe9c8d4b,
    0x0, 0x0, 0xbf666666, 0xbe9d573d,
    0x0, 0x0, 0xbf666666, 0xbe9e2166,
    0x0, 0x0, 0xbf666666, 0xbe9eebc5,
    0x0, 0x0, 0xbf666666, 0xbe9fb65b,
    0x0, 0x0, 0xbf666666, 0xbea08129,
    0x0, 0x0, 0xbf666666, 0xbea14c2d,
    0x0, 0x0, 0xbf666666, 0xbea2176a,
    0x0, 0x0, 0xbf666666, 0xbea2e2df,
    0x0, 0x0, 0xbf666666, 0xbea3ae8c,
    0x0, 0x0, 0xbf666666, 0xbea47a72,
    0x0, 0x0, 0xbf666666, 0xbea54692,
    0x0, 0x0, 0xbf666666, 0xbea612eb,
    0x0, 0x0, 0xbf666666, 0xbea6df7e,
    0x0, 0x0, 0xbf666666, 0xbea7ac4b,
    0x0, 0x0, 0xbf666666, 0xbea87952,
    0x0, 0x0, 0xbf666666, 0xbea94695,
    0x0, 0x0, 0xbf666666, 0xbeaa1412,
    0x0, 0x0, 0xbf666666, 0xbeaae1cc,
    0x0, 0x0, 0xbf666666, 0xbeabafc1,
    0x0, 0x0, 0xbf666666, 0xbeac7df3,
    0x0, 0x0, 0xbf666666, 0xbead4c61,
    0x0, 0x0, 0xbf666666, 0xbeae1b0c,
    0x0, 0x0, 0xbf666666, 0xbeaee9f5,
    0x0, 0x0, 0xbf666666, 0xbeafb91b,
    0x0, 0x0, 0xbf666666, 0xbeb08880,
    0x0, 0x0, 0xbf666666, 0xbeb15822,
    0x0, 0x0, 0xbf666666, 0xbeb22804,
    0x0, 0x0, 0xbf666666, 0xbeb2f825,
    0x0, 0x0, 0xbf666666, 0xbeb3c885,
    0x0, 0x0, 0xbf666666, 0xbeb49926,
    0x0, 0x0, 0xbf666666, 0xbeb56a06,
    0x0, 0x0, 0xbf666666, 0xbeb63b27,
    0x0, 0x0, 0xbf666666, 0xbeb70c89,
    0x0, 0x0, 0xbf666666, 0xbeb7de2d,
    0x0, 0x0, 0xbf666666, 0xbeb8b012,
    0x0, 0x0, 0xbf666666, 0xbeb98239,
    0x0, 0x0, 0xbf666666, 0xbeba54a3,
    0x0, 0x0, 0xbf666666, 0xbebb2750,
    0x0, 0x0, 0xbf666666, 0xbebbfa40,
    0x0, 0x0, 0xbf666666, 0xbebccd73,
    0x0, 0x0, 0xbf666666, 0xbebda0eb,
    0x0, 0x0, 0xbf666666, 0xbebe74a7,
    0x0, 0x0, 0xbf666666, 0xbebf48a8,
    0x0, 0x0, 0xbf666666, 0xbec01cee,
    0x0, 0x0, 0xbf666666, 0xbec0f179,
    0x0, 0x0, 0xbf666666, 0xbec1c64a,
    0x0, 0x0, 0xbf666666, 0xbec29b62,
    0x0, 0x0, 0xbf666666, 0xbec370c1,
    0x0, 0x0, 0xbf666666, 0xbec44666,
    0x0, 0x0, 0xbf666666, 0xbec51c53,
    0x0, 0x0, 0xbf666666, 0xbec5f288,
    0x0, 0x0, 0xbf666666, 0xbec6c906,
    0x0, 0x0, 0xbf666666, 0xbec79fcc,
    0x0, 0x0, 0xbf666666, 0xbec876db,
    0x0, 0x0, 0xbf666666, 0xbec94e34,
    0x0, 0x0, 0xbf666666, 0xbeca25d6,
    0x0, 0x0, 0xbf666666, 0xbecafdc3,
    0x0, 0x0, 0xbf666666, 0xbecbd5fb,
    0x0, 0x0, 0xbf666666, 0xbeccae7e,
    0x0, 0x0, 0xbf666666, 0xbecd874c,
    0x0, 0x0, 0xbf666666, 0xbece6067,
    0x0, 0x0, 0xbf666666, 0xbecf39ce,
    0x0, 0x0, 0xbf666666, 0xbed01382,
    0x0, 0x0, 0xbf666666, 0xbed0ed83,
    0x0, 0x0, 0xbf666666, 0xbed1c7d1,
    0x0, 0x0, 0xbf666666, 0xbed2a26e,
    0x0, 0x0, 0xbf666666, 0xbed37d5a,
    0x0, 0x0, 0xbf666666, 0xbed45894,
    0x0, 0x0, 0xbf666666, 0xbed5341e,
    0x0, 0x0, 0xbf666666, 0xbed60ff7,
    0x0, 0x0, 0xbf666666, 0xbed6ec21,
    0x0, 0x0, 0xbf666666, 0xbed7c89c,
    0x0, 0x0, 0xbf666666, 0xbed8a567,
    0x0, 0x0, 0xbf666666, 0xbed98285,
    0x0, 0x0, 0xbf666666, 0xbeda5ff4,
    0x0, 0x0, 0xbf666666, 0xbedb3db6,
    0x0, 0x0, 0xbf666666, 0xbedc1bca,
    0x0, 0x0, 0xbf666666, 0xbedcfa33,
    0x0, 0x0, 0xbf666666, 0xbeddd8ee,
    0x0, 0x0, 0xbf666666, 0xbedeb7ff,
    0x0, 0x0, 0xbf666666, 0xbedf9764,
    0x0, 0x0, 0xbf666666, 0xbee0771e,
    0x0, 0x0, 0xbf666666, 0xbee1572e,
    0x0, 0x0, 0xbf666666, 0xbee23793,
    0x0, 0x0, 0xbf666666, 0xbee31850,
    0x0, 0x0, 0xbf666666, 0xbee3f964,
    0x0, 0x0, 0xbf666666, 0xbee4dacf,
    0x0, 0x0, 0xbf666666, 0xbee5bc92,
    0x0, 0x0, 0xbf666666, 0xbee69ead,
    0x0, 0x0, 0xbf666666, 0xbee78122,
    0x0, 0x0, 0xbf666666, 0xbee863f0,
    0x0, 0x0, 0xbf666666, 0xbee94718,
    0x0, 0x0, 0xbf666666, 0xbeea2a9a,
    0x0, 0x0, 0xbf666666, 0xbeeb0e77,
    0x0, 0x0, 0xbf666666, 0xbeebf2af,
    0x0, 0x0, 0xbf666666, 0xbeecd744,
    0x0, 0x0, 0xbf666666, 0xbeedbc34,
    0x0, 0x0, 0xbf666666, 0xbeeea182,
    0x0, 0x0, 0xbf666666, 0xbeef872d,
    0x0, 0x0, 0xbf666666, 0xbef06d35,
    0x0, 0x0, 0xbf666666, 0xbef1539c,
    0x0, 0x0, 0xbf666666, 0xbef23a62,
    0x0, 0x0, 0xbf666666, 0xbef32187,
    0x0, 0x0, 0xbf666666, 0xbef4090c,
    0x0, 0x0, 0xbf666666, 0xbef4f0f2,
    0x0, 0x0, 0xbf666666, 0xbef5d938,
    0x0, 0x0, 0xbf666666, 0xbef6c1e0,
    0x0, 0x0, 0xbf666666, 0xbef7aaea,
    0x0, 0x0, 0xbf666666, 0xbef89456,
    0x0, 0x0, 0xbf666666, 0xbef97e25,
    0x0, 0x0, 0xbf666666, 0xbefa6857,
    0x0, 0x0, 0xbf666666, 0xbefb52ee,
    0x0, 0x0, 0xbf666666, 0xbefc3de9,
    0x0, 0x0, 0xbf666666, 0xbefd294a,
    0x0, 0x0, 0xbf666666, 0xbefe1510,
    0x0, 0x0, 0xbf666666, 0xbeff013c,
    0x0, 0x0, 0xbf666666, 0xbeffedcf,
    0x0, 0x0, 0xbf666666, 0xbf006d64,
    0x0, 0x0, 0xbf666666, 0xbf00e415,
    0x0, 0x0, 0xbf666666, 0xbf015afb,
    0x0, 0x0, 0xbf666666, 0xbf01d214,
    0x0, 0x0, 0xbf666666, 0xbf024963,
    0x0, 0x0, 0xbf666666, 0xbf02c0e6,
    0x0, 0x0, 0xbf666666, 0xbf03389f,
    0x0, 0x0, 0xbf666666, 0xbf03b08d,
    0x0, 0x0, 0xbf666666, 0xbf0428b2,
    0x0, 0x0, 0xbf666666, 0xbf04a10c,
    0x0, 0x0, 0xbf666666, 0xbf05199d,
    0x0, 0x0, 0xbf666666, 0xbf059265,
    0x0, 0x0, 0xbf666666, 0xbf060b63,
    0x0, 0x0, 0xbf666666, 0xbf068499,
    0x0, 0x0, 0xbf666666, 0xbf06fe07,
    0x0, 0x0, 0xbf666666, 0xbf0777ad,
    0x0, 0x0, 0xbf666666, 0xbf07f18b,
    0x0, 0x0, 0xbf666666, 0xbf086ba1,
    0x0, 0x0, 0xbf666666, 0xbf08e5f0,
    0x0, 0x0, 0xbf666666, 0xbf096078,
    0x0, 0x0, 0xbf666666, 0xbf09db3a,
    0x0, 0x0, 0xbf666666, 0xbf0a5636,
    0x0, 0x0, 0xbf666666, 0xbf0ad16b,
    0x0, 0x0, 0xbf666666, 0xbf0b4cdb,
    0x0, 0x0, 0xbf666666, 0xbf0bc886,
    0x0, 0x0, 0xbf666666, 0xbf0c446b,
    0x0, 0x0, 0xbf666666, 0xbf0cc08c,
    0x0, 0x0, 0xbf666666, 0xbf0d3ce8,
    0x0, 0x0, 0xbf666666, 0xbf0db981,
    0x0, 0x0, 0xbf666666, 0xbf0e3655,
    0x0, 0x0, 0xbf666666, 0xbf0eb367,
    0x0, 0x0, 0xbf666666, 0xbf0f30b5,
    0x0, 0x0, 0xbf666666, 0xbf0fae40,
    0x0, 0x0, 0xbf666666, 0xbf102c09,
    0x0, 0x0, 0xbf666666, 0xbf10aa10,
    0x0, 0x0, 0xbf666666, 0xbf112855,
    0x0, 0x0, 0xbf666666, 0xbf11a6d8,
    0x0, 0x0, 0xbf666666, 0xbf12259a,
    0x0, 0x0, 0xbf666666, 0xbf12a49c,
    0x0, 0x0, 0xbf666666, 0xbf1323dd,
    0x0, 0x0, 0xbf666666, 0xbf13a35e,
    0x0, 0x0, 0xbf666666, 0xbf14231f,
    0x0, 0x0, 0xbf666666, 0xbf14a321,
    0x0, 0x0, 0xbf666666, 0xbf152364,
    0x0, 0x0, 0xbf666666, 0xbf15a3e8,
    0x0, 0x0, 0xbf666666, 0xbf1624ae,
    0x0, 0x0, 0xbf666666, 0xbf16a5b5,
    0x0, 0x0, 0xbf666666, 0xbf1726ff,
    0x0, 0x0, 0xbf666666, 0xbf17a88c,
    0x0, 0x0, 0xbf666666, 0xbf182a5c,
    0x0, 0x0, 0xbf666666, 0xbf18ac6f,
    0x0, 0x0, 0xbf666666, 0xbf192ec5,
    0x0, 0x0, 0xbf666666, 0xbf19b160,
    0x0, 0x0, 0xbf666666, 0xbf1a3440,
    0x0, 0x0, 0xbf666666, 0xbf1ab764,
    0x0, 0x0, 0xbf666666, 0xbf1b3ace,
    0x0, 0x0, 0xbf666666, 0xbf1bbe7d,
    0x0, 0x0, 0xbf666666, 0xbf1c4272,
    0x0, 0x0, 0xbf666666, 0xbf1cc6ae,
    0x0, 0x0, 0xbf666666, 0xbf1d4b30,
    0x0, 0x0, 0xbf666666, 0xbf1dcff9,
    0x0, 0x0, 0xbf666666, 0xbf1e550a,
    0x0, 0x0, 0xbf666666, 0xbf1eda63,
    0x0, 0x0, 0xbf666666, 0xbf1f6004,
    0x0, 0x0, 0xbf666666, 0xbf1fe5ee,
    0x0, 0x0, 0xbf666666, 0xbf206c21,
    0x0, 0x0, 0xbf666666, 0xbf20f29d,
    0x0, 0x0, 0xbf666666, 0xbf217963,
    0x0, 0x0, 0xbf666666, 0xbf220074,
    0x0, 0x0, 0xbf666666, 0xbf2287cf,
    0x0, 0x0, 0xbf666666, 0xbf230f75,
    0x0, 0x0, 0xbf666666, 0xbf239766,
    0x0, 0x0, 0xbf666666, 0xbf241fa4,
    0x0, 0x0, 0xbf666666, 0xbf24a82e,
    0x0, 0x0, 0xbf666666, 0xbf253104,
    0x0, 0x0, 0xbf666666, 0xbf25ba28,
    0x0, 0x0, 0xbf666666, 0xbf264399,
    0x0, 0x0, 0xbf666666, 0xbf26cd59,
    0x0, 0x0, 0xbf666666, 0xbf275766,
    0x0, 0x0, 0xbf666666, 0xbf27e1c3,
    0x0, 0x0, 0xbf666666, 0xbf286c6f,
    0x0, 0x0, 0xbf666666, 0xbf28f76a,
    0x0, 0x0, 0xbf666666, 0xbf2982b6,
    0x0, 0x0, 0xbf666666, 0xbf2a0e52,
    0x0, 0x0, 0xbf666666, 0xbf2a9a3f,
    0x0, 0x0, 0xbf666666, 0xbf2b267e,
    0x0, 0x0, 0xbf666666, 0xbf2bb30e,
    0x0, 0x0, 0xbf666666, 0xbf2c3ff1,
    0x0, 0x0, 0xbf666666, 0xbf2ccd27,
    0x0, 0x0, 0xbf666666, 0xbf2d5ab0,
    0x0, 0x0, 0xbf666666, 0xbf2de88d,
    0x0, 0x0, 0xbf666666, 0xbf2e76be,
    0x0, 0x0, 0xbf666666, 0xbf2f0544,
    0x0, 0x0, 0xbf666666, 0xbf2f941f,
    0x0, 0x0, 0xbf666666, 0xbf30234f,
    0x0, 0x0, 0xbf666666, 0xbf30b2d5,
    0x0, 0x0, 0xbf666666, 0xbf3142b2,
    0x0, 0x0, 0xbf666666, 0xbf31d2e6,
    0x0, 0x0, 0xbf666666, 0xbf326372,
    0x0, 0x0, 0xbf666666, 0xbf32f456,
    0x0, 0x0, 0xbf666666, 0xbf338592,
    0x0, 0x0, 0xbf666666, 0xbf341727,
    0x0, 0x0, 0xbf666666, 0xbf34a915,
    0x0, 0x0, 0xbf666666, 0xbf353b5e,
    0x0, 0x0, 0xbf666666, 0xbf35ce01,
    0x0, 0x0, 0xbf666666, 0xbf3660ff,
    0x0, 0x0, 0xbf666666, 0xbf36f458,
    0x0, 0x0, 0xbf666666, 0xbf37880e,
    0x0, 0x0, 0xbf666666, 0xbf381c20,
    0x0, 0x0, 0xbf666666, 0xbf38b08f,
    0x0, 0x0, 0xbf666666, 0xbf39455b,
    0x0, 0x0, 0xbf666666, 0xbf39da86,
    0x0, 0x0, 0xbf666666, 0xbf3a700f,
    0x0, 0x0, 0xbf666666, 0xbf3b05f8,
    0x0, 0x0, 0xbf666666, 0xbf3b9c40,
    0x0, 0x0, 0xbf666666, 0xbf3c32e9,
    0x0, 0x0, 0xbf666666, 0xbf3cc9f2,
    0x0, 0x0, 0xbf666666, 0xbf3d615c,
    0x0, 0x0, 0xbf666666, 0xbf3df929,
    0x0, 0x0, 0xbf666666, 0xbf3e9157,
    0x0, 0x0, 0xbf666666, 0xbf3f29e9,
    0x0, 0x0, 0xbf666666, 0xbf3fc2df,
    0x0, 0x0, 0xbf666666, 0xbf405c38,
    0x0, 0x0, 0xbf666666, 0xbf40f5f6,
    0x0, 0x0, 0xbf666666, 0xbf41901a,
    0x0, 0x0, 0xbf666666, 0xbf422aa3,
    0x0, 0x0, 0xbf666666, 0xbf42c592,
    0x0, 0x0, 0xbf666666, 0xbf4360e9,
    0x0, 0x0, 0xbf666666, 0xbf43fca7,
    0x0, 0x0, 0xbf666666, 0xbf4498ce,
    0x0, 0x0, 0xbf666666, 0xbf45355d,
    0x0, 0x0, 0xbf666666, 0xbf45d256,
    0x0, 0x0, 0xbf666666, 0xbf466fb8,
    0x0, 0x0, 0xbf666666, 0xbf470d85,
    0x0, 0x0, 0xbf666666, 0xbf47abbe,
    0x0, 0x0, 0xbf666666, 0xbf484a62,
    0x0, 0x0, 0xbf666666, 0xbf48e973,
    0x0, 0x0, 0xbf666666, 0xbf4988f1,
    0x0, 0x0, 0xbf666666, 0xbf4a28dc,
    0x0, 0x0, 0xbf666666, 0xbf4ac936,
    0x0, 0x0, 0xbf666666, 0xbf4b69ff,
    0x0, 0x0, 0xbf666666, 0xbf4c0b37,
    0x0, 0x0, 0xbf666666, 0xbf4cace0,
    0x0, 0x0, 0xbf666666, 0xbf4d4efa,
    0x0, 0x0, 0xbf666666, 0xbf4df185,
