#!/usr/bin/env bash
#
# Copyright (c) 2023-2025 Nordic Semiconductor ASA
#
# SPDX-License-Identifier: Apache-2.0

SIMULATION_ID="bap_broadcast_audio_assistant"
VERBOSITY_LEVEL=2
EXECUTE_TIMEOUT=240

source ${ZEPHYR_BASE}/tests/bsim/sh_common.source

cd ${BSIM_OUT_PATH}/bin

printf "\n\n======== Running BAP Broadcast Audio Assistant =========\n\n"

Execute ./bs_${BOARD_TS}_tests_bsim_bluetooth_audio_prj_conf \
  -v=${VERBOSITY_LEVEL} -s=${SIMULATION_ID} -d=0 \
  -testid=broadcast_sink_with_assistant -RealEncryption=1 -rs=24 -D=3

Execute ./bs_${BOARD_TS}_tests_bsim_bluetooth_audio_prj_conf \
  -v=${VERBOSITY_LEVEL} -s=${SIMULATION_ID} -d=1 \
  -testid=bap_broadcast_assistant_client_sync -RealEncryption=1 -rs=46 -D=3

Execute ./bs_${BOARD_TS}_tests_bsim_bluetooth_audio_prj_conf \
  -v=${VERBOSITY_LEVEL} -s=${SIMULATION_ID} -d=2 \
  -testid=broadcast_source -RealEncryption=1 -rs=69 -D=3 \
  -start_offset=2e3 -argstest subgroup_cnt 1 streams_per_subgroup_cnt 2

# Simulation time should be larger than the WAIT_TIME in common.h
Execute ./bs_2G4_phy_v1 -v=${VERBOSITY_LEVEL} -s=${SIMULATION_ID} -D=3 -sim_length=60e6 $@

wait_for_background_jobs
