/*
 * Copyright (c) 2022 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/** Keys "test" IDs associated with a BT address */
#define BT_ADDR_ID_0 (0x00)
#define BT_ADDR_ID_1 (0x55)
#define BT_ADDR_ID_2 (0xAA)
#define BT_ADDR_ID_3 (0xA5)
#define BT_ADDR_ID_4 (0x5A)
#define BT_ADDR_ID_5 (0xAC)

/** Bluetooth LE device "test" addresses */
#define BT_ADDR_LE_1 ((bt_addr_le_t[]){{BT_ADDR_LE_PUBLIC, {{0x0A, 0x89, 0x67, 0x45, 0x23, 0x01}}}})
#define BT_ADDR_LE_2 ((bt_addr_le_t[]){{BT_ADDR_LE_PUBLIC, {{0x0B, 0x89, 0x67, 0x45, 0x23, 0x01}}}})
#define BT_ADDR_LE_3 ((bt_addr_le_t[]){{BT_ADDR_LE_PUBLIC, {{0x0C, 0x89, 0x67, 0x45, 0x23, 0x01}}}})
#define BT_ADDR_LE_4 ((bt_addr_le_t[]){{BT_ADDR_LE_PUBLIC, {{0x0D, 0x89, 0x67, 0x45, 0x23, 0x01}}}})
#define BT_ADDR_LE_5 ((bt_addr_le_t[]){{BT_ADDR_LE_PUBLIC, {{0x0E, 0x89, 0x67, 0x45, 0x23, 0x01}}}})

/** Bluetooth LE device "test" random addresses */
#define BT_RPA_ADDR_LE_1                                                                           \
	((bt_addr_le_t[]){{BT_ADDR_LE_RANDOM, {{0x0A, 0x89, 0x67, 0x45, 0x23, 0x41}}}})
#define BT_RPA_ADDR_LE_2                                                                           \
	((bt_addr_le_t[]){{BT_ADDR_LE_RANDOM, {{0x0B, 0x89, 0x67, 0x45, 0x23, 0x41}}}})
#define BT_RPA_ADDR_LE_3                                                                           \
	((bt_addr_le_t[]){{BT_ADDR_LE_RANDOM, {{0x0C, 0x89, 0x67, 0x45, 0x23, 0x41}}}})
#define BT_RPA_ADDR_LE_4                                                                           \
	((bt_addr_le_t[]){{BT_ADDR_LE_RANDOM, {{0x0D, 0x89, 0x67, 0x45, 0x23, 0x41}}}})
#define BT_RPA_ADDR_LE_5                                                                           \
	((bt_addr_le_t[]){{BT_ADDR_LE_RANDOM, {{0x0E, 0x89, 0x67, 0x45, 0x23, 0x41}}}})
