/*
 * Copyright (c) 2017 Nordic Semiconductor ASA
 * Copyright (c) 2016-2017 Linaro Limited
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DFU_BOOT_MCUBOOT_H_
#define ZEPHYR_DFU_BOOT_MCUBOOT_H_

#include <zephyr/storage/flash_map.h>

#ifdef CONFIG_TRUSTED_EXECUTION_NONSECURE
#define SLOT0_LABEL	slot0_ns_partition
#define SLOT1_LABEL	slot1_ns_partition
#else
#define SLOT0_LABEL	slot0_partition
#define SLOT1_LABEL	slot1_partition
#endif /* CONFIG_TRUSTED_EXECUTION_NONSECURE */

/* FIXED_PARTITION_ID() values used below are auto-generated by DT */
#define FLASH_AREA_IMAGE_PRIMARY FIXED_PARTITION_ID(SLOT0_LABEL)
#if FIXED_PARTITION_EXISTS(SLOT1_LABEL)
#define FLASH_AREA_IMAGE_SECONDARY FIXED_PARTITION_ID(SLOT1_LABEL)
#endif


#endif /* ZEPHYR_DFU_BOOT_MCUBOOT_H_ */
