/*
 * Copyright (c) 2018 Endre Karlson <endre.karlson@gmail.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief System/hardware module for STM32L0 processor
 */

#include <zephyr/device.h>
#include <zephyr/init.h>
#include <zephyr/linker/linker-defs.h>
#include <string.h>
#include <stm32_ll_bus.h>
#include <stm32_ll_system.h>

#include <cmsis_core.h>

/**
 * @brief Perform basic hardware initialization at boot.
 *
 * This needs to be run from the very beginning.
 */
void soc_early_init_hook(void)
{
#if defined(CONFIG_STM32_FLASH_PREFETCH)
	/* Enable ART accelerator prefetch */
	LL_FLASH_EnablePrefetch();
#endif

	/* Update CMSIS SystemCoreClock variable (HCLK) */
	/* At reset, system core clock is set to 2.1 MHz from MSI */
	SystemCoreClock = 2097152;

	/* On STM32L0, there are some hardfault when enabling DBGMCU bit:
	 * Sleep, Stop or Standby.
	 * See https://github.com/zephyrproject-rtos/zephyr/issues/#37119
	 * For unclear reason, enabling DMA clock fixes this issue
	 * (similarly than it fixes
	 * https://github.com/zephyrproject-rtos/zephyr/issues/#34324 )
	 */
	LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_DMA1);
#ifdef CONFIG_PM
	/* Enable Power clock */
	LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);
#endif
}
