/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright (c) 2024 sensry.io
 */

#ifndef GANYMED_SY1XX_PAD_CTRL_H
#define GANYMED_SY1XX_PAD_CTRL_H

#define SY1XX_PAD_CONFIG(pin_offset, SMT, SLEW, PULLUP, PULLDOWN, DRV, PMOD, DIR)                  \
	(((SMT << 7) | (SLEW << 6) | (PULLUP << 5) | (PULLDOWN << 4) | (DRV << 2) | (PMOD << 1) |  \
	  DIR)                                                                                     \
	 << pin_offset)

#define SY1XX_PAD_CONFIG_ADDR (SY1XX_ARCHI_SOC_PERIPHERALS_ADDR + SY1XX_ARCHI_APB_SOC_CTRL_OFFSET)

#define SY1XX_PAD_CONFIG_ADDR_UART (SY1XX_PAD_CONFIG_ADDR + 0x020)
#define SY1XX_PAD_CONFIG_ADDR_SPI  (SY1XX_PAD_CONFIG_ADDR + 0x02c)
#define SY1XX_PAD_CONFIG_ADDR_I2C  (SY1XX_PAD_CONFIG_ADDR + 0x100)
#define SY1XX_PAD_CONFIG_ADDR_MAC  (SY1XX_PAD_CONFIG_ADDR + 0x130)

#define SY1XX_PAD_SMT_DISABLE 0
#define SY1XX_PAD_SMT_ENABLE  1

#define SY1XX_PAD_SLEW_LOW  0
#define SY1XX_PAD_SLEW_HIGH 1

#define SY1XX_PAD_PULLUP_DIS 0
#define SY1XX_PAD_PULLUP_EN  1

#define SY1XX_PAD_PULLDOWN_DIS 0
#define SY1XX_PAD_PULLDOWN_EN  1

#define SY1XX_PAD_DRIVE_2PF  0
#define SY1XX_PAD_DRIVE_4PF  1
#define SY1XX_PAD_DRIVE_8PF  2
#define SY1XX_PAD_DRIVE_16PF 3

#define SY1XX_PAD_PMOD_NORMAL   0
#define SY1XX_PAD_PMOD_TRISTATE 1

#define SY1XX_PAD_DIR_OUTPUT 0
#define SY1XX_PAD_DIR_INPUT  1

#endif /* GANYMED_SY1XX_PAD_CTRL_H */
