/*
 * Copyright (c) 2017 Intel Corporation.
 * Copyright (c) 2018 Nordic Semiconductor ASA.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#include <zephyr/kernel.h>

#include "net_sample_common.h"

/* Value of 0 will cause the IP stack to select next free port */
#define MY_PORT 0

#define PEER_PORT 4242

/* Turn off the progress printing so that shell can be used.
 * Set to true if you want to see progress output.
 */
#define PRINT_PROGRESS false

#if defined(CONFIG_USERSPACE)
#include <zephyr/app_memory/app_memdomain.h>
extern struct k_mem_partition app_partition;
extern struct k_mem_domain app_domain;
#define APP_BMEM K_APP_BMEM(app_partition)
#define APP_DMEM K_APP_DMEM(app_partition)
#else
#define APP_BMEM
#define APP_DMEM
#endif

#if defined(CONFIG_NET_TC_THREAD_PREEMPTIVE)
#define THREAD_PRIORITY K_PRIO_PREEMPT(8)
#else
#define THREAD_PRIORITY K_PRIO_COOP(CONFIG_NUM_COOP_PRIORITIES - 1)
#endif

#define UDP_STACK_SIZE 2048

struct udp_control {
	struct k_poll_signal tx_signal;
	struct k_timer tx_timer;
	struct k_timer rx_timer;
};

struct sample_data {
	const char *proto;

	struct {
		int sock;
		uint32_t expecting;
		uint32_t counter;
		uint32_t mtu;
		struct udp_control *ctrl;
	} udp;

	struct {
		int sock;
		uint32_t expecting;
		uint32_t received;
		uint32_t counter;
	} tcp;
};

struct configs {
	struct sample_data ipv4;
	struct sample_data ipv6;
};

#if !defined(CONFIG_NET_CONFIG_PEER_IPV4_ADDR)
#define CONFIG_NET_CONFIG_PEER_IPV4_ADDR ""
#endif

#if !defined(CONFIG_NET_CONFIG_PEER_IPV6_ADDR)
#define CONFIG_NET_CONFIG_PEER_IPV6_ADDR ""
#endif

extern const char lorem_ipsum[];
extern const int ipsum_len;
extern struct configs conf;

#if defined(CONFIG_NET_UDP)
/* init_udp initializes kernel objects, hence it has to be called from
 * supervisor thread.
 */
void init_udp(void);
int start_udp(void);
int process_udp(void);
void stop_udp(void);
#else
static inline void init_udp(void) { }
static inline int start_udp(void) { return 0; }
static inline int process_udp(void) { return 0; }
static inline void stop_udp(void) { }
#endif /* defined(CONFIG_NET_UDP) */

int start_tcp(void);
int process_tcp(void);
void stop_tcp(void);
