/*
 * Copyright 2025 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef SINE_H_
#define SINE_H_

/*
 * Keep the PCM data in flash to avoid large RAM usage.
 * If a platform requires DMA-readable RAM buffers, copy
 * chunks of this table into a small nocache TX buffer
 * at runtime instead of keeping the entire table in RAM.
 */
static const unsigned char __16kHz16bit_stereo_sine_pcm[] = {
	0x00, 0x00, 0x00, 0x00, 0x08, 0x0b, 0x08, 0x0b, 0xbb, 0x15, 0xbb, 0x15, 0xc9, 0x1f, 0xc9,
	0x1f, 0xe4, 0x28, 0xe4, 0x28, 0xc8, 0x30, 0xc8, 0x30, 0x38, 0x37, 0x38, 0x37, 0x03, 0x3c,
	0x03, 0x3c, 0x04, 0x3f, 0x04, 0x3f, 0x25, 0x40, 0x25, 0x40, 0x5d, 0x3f, 0x5d, 0x3f, 0xb1,
	0x3c, 0xb1, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x11, 0x32, 0x11, 0x32, 0x6d, 0x2a, 0x6d, 0x2a,
	0x85, 0x21, 0x85, 0x21, 0x9e, 0x17, 0x9e, 0x17, 0x02, 0x0d, 0x02, 0x0d, 0x04, 0x02, 0x04,
	0x02, 0xf6, 0xf6, 0xf6, 0xf6, 0x2d, 0xec, 0x2d, 0xec, 0xfb, 0xe1, 0xfb, 0xe1, 0xae, 0xd8,
	0xae, 0xd8, 0x8d, 0xd0, 0x8d, 0xd0, 0xd6, 0xc9, 0xd6, 0xc9, 0xbb, 0xc4, 0xbb, 0xc4, 0x65,
	0xc1, 0x65, 0xc1, 0xeb, 0xbf, 0xeb, 0xbf, 0x5b, 0xc0, 0x5b, 0xc0, 0xaf, 0xc2, 0xaf, 0xc2,
	0xd7, 0xc6, 0xd7, 0xc6, 0xb3, 0xcc, 0xb3, 0xcc, 0x16, 0xd4, 0x16, 0xd4, 0xc7, 0xdc, 0xc7,
	0xdc, 0x86, 0xe6, 0x86, 0xe6, 0x06, 0xf1, 0x06, 0xf1, 0xf9, 0xfb, 0xf9, 0xfb, 0x0a, 0x07,
	0x0a, 0x07, 0xe6, 0x11, 0xe6, 0x11, 0x39, 0x1c, 0x39, 0x1c, 0xb5, 0x25, 0xb5, 0x25, 0x12,
	0x2e, 0x12, 0x2e, 0x0f, 0x35, 0x0f, 0x35, 0x78, 0x3a, 0x78, 0x3a, 0x23, 0x3e, 0x23, 0x3e,
	0xf4, 0x3f, 0xf4, 0x3f, 0xde, 0x3f, 0xde, 0x3f, 0xe1, 0x3d, 0xe1, 0x3d, 0x0c, 0x3a, 0x0c,
	0x3a, 0x7c, 0x34, 0x7c, 0x34, 0x5d, 0x2d, 0x5d, 0x2d, 0xe3, 0x24, 0xe3, 0x24, 0x51, 0x1b,
	0x51, 0x1b, 0xee, 0x10, 0xee, 0x10, 0x0a, 0x06, 0x0a, 0x06, 0xf7, 0xfa, 0xf7, 0xfa, 0x0c,
	0xf0, 0x0c, 0xf0, 0x9a, 0xe5, 0x9a, 0xe5, 0xf1, 0xdb, 0xf1, 0xdb, 0x5b, 0xd3, 0x5b, 0xd3,
	0x1a, 0xcc, 0x1a, 0xcc, 0x64, 0xc6, 0x64, 0xc6, 0x65, 0xc2, 0x65, 0xc2, 0x3c, 0xc0, 0x3c,
	0xc0, 0xfa, 0xbf, 0xfa, 0xbf, 0x9f, 0xc1, 0x9f, 0xc1, 0x20, 0xc5, 0x20, 0xc5, 0x62, 0xca,
	0x62, 0xca, 0x3c, 0xd1, 0x3c, 0xd1, 0x7b, 0xd9, 0x7b, 0xd9, 0xe0, 0xe2, 0xe0, 0xe2, 0x23,
	0xed, 0x23, 0xed, 0xf6, 0xf7, 0xf6, 0xf7, 0x06, 0x03, 0x06, 0x03, 0xff, 0x0d, 0xff, 0x0d,
	0x8d, 0x18, 0x8d, 0x18, 0x60, 0x22, 0x60, 0x22, 0x2d, 0x2b, 0x2d, 0x2b, 0xb1, 0x32, 0xb1,
	0x32, 0xb2, 0x38, 0xb2, 0x38, 0x03, 0x3d, 0x03, 0x3d, 0x83, 0x3f, 0x83, 0x3f, 0x1f, 0x40,
	0x1f, 0x40, 0xd2, 0x3e, 0xd2, 0x3e, 0xa6, 0x3b, 0xa6, 0x3b, 0xb3, 0x36, 0xb3, 0x36, 0x1f,
	0x30, 0x1f, 0x30, 0x1c, 0x28, 0x1c, 0x28, 0xe8, 0x1e, 0xe8, 0x1e, 0xc8, 0x14, 0xc8, 0x14,
	0x09, 0x0a, 0x09, 0x0a, 0xfe, 0xfe, 0xfe, 0xfe, 0xfb, 0xf3, 0xfb, 0xf3, 0x53, 0xe9, 0x53,
	0xe9, 0x58, 0xdf, 0x58, 0xdf, 0x56, 0xd6, 0x56, 0xd6, 0x92, 0xce, 0x92, 0xce, 0x47, 0xc8,
	0x47, 0xc8, 0xa4, 0xc3, 0xa4, 0xc3, 0xce, 0xc0, 0xce, 0xc0, 0xd9, 0xbf, 0xd9, 0xbf, 0xce,
	0xc0, 0xce, 0xc0, 0xa4, 0xc3, 0xa4, 0xc3, 0x47, 0xc8, 0x47, 0xc8, 0x92, 0xce, 0x92, 0xce,
	0x56, 0xd6, 0x56, 0xd6, 0x58, 0xdf, 0x58, 0xdf, 0x53, 0xe9, 0x53, 0xe9, 0xfb, 0xf3, 0xfb,
	0xf3, 0xfe, 0xfe, 0xfe, 0xfe, 0x09, 0x0a, 0x09, 0x0a, 0xc8, 0x14, 0xc8, 0x14, 0xe8, 0x1e,
	0xe8, 0x1e, 0x1c, 0x28, 0x1c, 0x28, 0x1f, 0x30, 0x1f, 0x30, 0xb3, 0x36, 0xb3, 0x36, 0xa6,
	0x3b, 0xa6, 0x3b, 0xd2, 0x3e, 0xd2, 0x3e, 0x1f, 0x40, 0x1f, 0x40, 0x83, 0x3f, 0x83, 0x3f,
	0x03, 0x3d, 0x03, 0x3d, 0xb2, 0x38, 0xb2, 0x38, 0xb1, 0x32, 0xb1, 0x32, 0x2d, 0x2b, 0x2d,
	0x2b, 0x60, 0x22, 0x60, 0x22, 0x8d, 0x18, 0x8d, 0x18, 0xff, 0x0d, 0xff, 0x0d, 0x06, 0x03,
	0x06, 0x03, 0xf6, 0xf7, 0xf6, 0xf7, 0x23, 0xed, 0x23, 0xed, 0xe0, 0xe2, 0xe0, 0xe2, 0x7b,
	0xd9, 0x7b, 0xd9, 0x3c, 0xd1, 0x3c, 0xd1, 0x62, 0xca, 0x62, 0xca, 0x20, 0xc5, 0x20, 0xc5,
	0x9f, 0xc1, 0x9f, 0xc1, 0xfa, 0xbf, 0xfa, 0xbf, 0x3c, 0xc0, 0x3c, 0xc0, 0x65, 0xc2, 0x65,
	0xc2, 0x64, 0xc6, 0x64, 0xc6, 0x1a, 0xcc, 0x1a, 0xcc, 0x5b, 0xd3, 0x5b, 0xd3, 0xf1, 0xdb,
	0xf1, 0xdb, 0x9a, 0xe5, 0x9a, 0xe5, 0x0c, 0xf0, 0x0c, 0xf0, 0xf7, 0xfa, 0xf7, 0xfa, 0x0a,
	0x06, 0x0a, 0x06, 0xee, 0x10, 0xee, 0x10, 0x51, 0x1b, 0x51, 0x1b, 0xe3, 0x24, 0xe3, 0x24,
	0x5d, 0x2d, 0x5d, 0x2d, 0x7c, 0x34, 0x7c, 0x34, 0x0c, 0x3a, 0x0c, 0x3a, 0xe1, 0x3d, 0xe1,
	0x3d, 0xde, 0x3f, 0xde, 0x3f, 0xf4, 0x3f, 0xf4, 0x3f, 0x23, 0x3e, 0x23, 0x3e, 0x78, 0x3a,
	0x78, 0x3a, 0x0f, 0x35, 0x0f, 0x35, 0x12, 0x2e, 0x12, 0x2e, 0xb5, 0x25, 0xb5, 0x25, 0x39,
	0x1c, 0x39, 0x1c, 0xe6, 0x11, 0xe6, 0x11, 0x0a, 0x07, 0x0a, 0x07, 0xf9, 0xfb, 0xf9, 0xfb,
	0x06, 0xf1, 0x06, 0xf1, 0x86, 0xe6, 0x86, 0xe6, 0xc7, 0xdc, 0xc7, 0xdc, 0x16, 0xd4, 0x16,
	0xd4, 0xb3, 0xcc, 0xb3, 0xcc, 0xd7, 0xc6, 0xd7, 0xc6, 0xaf, 0xc2, 0xaf, 0xc2, 0x5b, 0xc0,
	0x5b, 0xc0, 0xeb, 0xbf, 0xeb, 0xbf, 0x65, 0xc1, 0x65, 0xc1, 0xbb, 0xc4, 0xbb, 0xc4, 0xd6,
	0xc9, 0xd6, 0xc9, 0x8d, 0xd0, 0x8d, 0xd0, 0xae, 0xd8, 0xae, 0xd8, 0xfb, 0xe1, 0xfb, 0xe1,
	0x2d, 0xec, 0x2d, 0xec, 0xf6, 0xf6, 0xf6, 0xf6, 0x04, 0x02, 0x04, 0x02, 0x02, 0x0d, 0x02,
	0x0d, 0x9e, 0x17, 0x9e, 0x17, 0x85, 0x21, 0x85, 0x21, 0x6d, 0x2a, 0x6d, 0x2a, 0x11, 0x32,
	0x11, 0x32, 0x38, 0x38, 0x38, 0x38, 0xb1, 0x3c, 0xb1, 0x3c, 0x5d, 0x3f, 0x5d, 0x3f, 0x25,
	0x40, 0x25, 0x40, 0x04, 0x3f, 0x04, 0x3f, 0x03, 0x3c, 0x03, 0x3c, 0x38, 0x37, 0x38, 0x37,
	0xc8, 0x30, 0xc8, 0x30, 0xe4, 0x28, 0xe4, 0x28, 0xc9, 0x1f, 0xc9, 0x1f, 0xbb, 0x15, 0xbb,
	0x15, 0x08, 0x0b, 0x08, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf4, 0xf8, 0xf4, 0x45, 0xea,
	0x45, 0xea, 0x37, 0xe0, 0x37, 0xe0, 0x1c, 0xd7, 0x1c, 0xd7, 0x38, 0xcf, 0x38, 0xcf, 0xc8,
	0xc8, 0xc8, 0xc8, 0xfd, 0xc3, 0xfd, 0xc3, 0xfc, 0xc0, 0xfc, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf,
	0xa3, 0xc0, 0xa3, 0xc0, 0x4f, 0xc3, 0x4f, 0xc3, 0xc8, 0xc7, 0xc8, 0xc7, 0xef, 0xcd, 0xef,
	0xcd, 0x93, 0xd5, 0x93, 0xd5, 0x7b, 0xde, 0x7b, 0xde, 0x62, 0xe8, 0x62, 0xe8, 0xfe, 0xf2,
	0xfe, 0xf2, 0xfc, 0xfd, 0xfc, 0xfd, 0x0a, 0x09, 0x0a, 0x09, 0xd3, 0x13, 0xd3, 0x13, 0x05,
	0x1e, 0x05, 0x1e, 0x52, 0x27, 0x52, 0x27, 0x73, 0x2f, 0x73, 0x2f, 0x2a, 0x36, 0x2a, 0x36,
	0x45, 0x3b, 0x45, 0x3b, 0x9b, 0x3e, 0x9b, 0x3e, 0x15, 0x40, 0x15, 0x40, 0xa5, 0x3f, 0xa5,
	0x3f, 0x51, 0x3d, 0x51, 0x3d, 0x29, 0x39, 0x29, 0x39, 0x4d, 0x33, 0x4d, 0x33, 0xea, 0x2b,
	0xea, 0x2b, 0x39, 0x23, 0x39, 0x23, 0x7a, 0x19, 0x7a, 0x19, 0xfa, 0x0e, 0xfa, 0x0e, 0x07,
	0x04, 0x07, 0x04, 0xf6, 0xf8, 0xf6, 0xf8, 0x1a, 0xee, 0x1a, 0xee, 0xc7, 0xe3, 0xc7, 0xe3,
	0x4b, 0xda, 0x4b, 0xda, 0xee, 0xd1, 0xee, 0xd1, 0xf1, 0xca, 0xf1, 0xca, 0x88, 0xc5, 0x88,
	0xc5, 0xdd, 0xc1, 0xdd, 0xc1, 0x0c, 0xc0, 0x0c, 0xc0, 0x22, 0xc0, 0x22, 0xc0, 0x1f, 0xc2,
	0x1f, 0xc2, 0xf4, 0xc5, 0xf4, 0xc5, 0x84, 0xcb, 0x84, 0xcb, 0xa3, 0xd2, 0xa3, 0xd2, 0x1d,
	0xdb, 0x1d, 0xdb, 0xaf, 0xe4, 0xaf, 0xe4, 0x12, 0xef, 0x12, 0xef, 0xf6, 0xf9, 0xf6, 0xf9,
	0x09, 0x05, 0x09, 0x05, 0xf4, 0x0f, 0xf4, 0x0f, 0x66, 0x1a, 0x66, 0x1a, 0x0f, 0x24, 0x0f,
	0x24, 0xa5, 0x2c, 0xa5, 0x2c, 0xe6, 0x33, 0xe6, 0x33, 0x9c, 0x39, 0x9c, 0x39, 0x9b, 0x3d,
	0x9b, 0x3d, 0xc4, 0x3f, 0xc4, 0x3f, 0x06, 0x40, 0x06, 0x40, 0x61, 0x3e, 0x61, 0x3e, 0xe0,
	0x3a, 0xe0, 0x3a, 0x9e, 0x35, 0x9e, 0x35, 0xc4, 0x2e, 0xc4, 0x2e, 0x85, 0x26, 0x85, 0x26,
	0x20, 0x1d, 0x20, 0x1d, 0xdd, 0x12, 0xdd, 0x12, 0x0a, 0x08, 0x0a, 0x08, 0xfa, 0xfc, 0xfa,
	0xfc, 0x01, 0xf2, 0x01, 0xf2, 0x73, 0xe7, 0x73, 0xe7, 0xa0, 0xdd, 0xa0, 0xdd, 0xd3, 0xd4,
	0xd3, 0xd4, 0x4f, 0xcd, 0x4f, 0xcd, 0x4e, 0xc7, 0x4e, 0xc7, 0xfd, 0xc2, 0xfd, 0xc2, 0x7d,
	0xc0, 0x7d, 0xc0, 0xe1, 0xbf, 0xe1, 0xbf, 0x2e, 0xc1, 0x2e, 0xc1, 0x5a, 0xc4, 0x5a, 0xc4,
	0x4d, 0xc9, 0x4d, 0xc9, 0xe1, 0xcf, 0xe1, 0xcf, 0xe4, 0xd7, 0xe4, 0xd7, 0x18, 0xe1, 0x18,
	0xe1, 0x38, 0xeb, 0x38, 0xeb, 0xf7, 0xf5, 0xf7, 0xf5, 0x02, 0x01, 0x02, 0x01, 0x05, 0x0c,
	0x05, 0x0c, 0xad, 0x16, 0xad, 0x16, 0xa8, 0x20, 0xa8, 0x20, 0xaa, 0x29, 0xaa, 0x29, 0x6e,
	0x31, 0x6e, 0x31, 0xb9, 0x37, 0xb9, 0x37, 0x5c, 0x3c, 0x5c, 0x3c, 0x32, 0x3f, 0x32, 0x3f,
	0x27, 0x40, 0x27, 0x40, 0x32, 0x3f, 0x32, 0x3f, 0x5c, 0x3c, 0x5c, 0x3c, 0xb9, 0x37, 0xb9,
	0x37, 0x6e, 0x31, 0x6e, 0x31, 0xaa, 0x29, 0xaa, 0x29, 0xa8, 0x20, 0xa8, 0x20, 0xad, 0x16,
	0xad, 0x16, 0x05, 0x0c, 0x05, 0x0c, 0x02, 0x01, 0x02, 0x01, 0xf7, 0xf5, 0xf7, 0xf5, 0x38,
	0xeb, 0x38, 0xeb, 0x18, 0xe1, 0x18, 0xe1, 0xe4, 0xd7, 0xe4, 0xd7, 0xe1, 0xcf, 0xe1, 0xcf,
	0x4d, 0xc9, 0x4d, 0xc9, 0x5a, 0xc4, 0x5a, 0xc4, 0x2e, 0xc1, 0x2e, 0xc1, 0xe1, 0xbf, 0xe1,
	0xbf, 0x7d, 0xc0, 0x7d, 0xc0, 0xfd, 0xc2, 0xfd, 0xc2, 0x4e, 0xc7, 0x4e, 0xc7, 0x4f, 0xcd,
	0x4f, 0xcd, 0xd3, 0xd4, 0xd3, 0xd4, 0xa0, 0xdd, 0xa0, 0xdd, 0x73, 0xe7, 0x73, 0xe7, 0x01,
	0xf2, 0x01, 0xf2, 0xfa, 0xfc, 0xfa, 0xfc, 0x0a, 0x08, 0x0a, 0x08, 0xdd, 0x12, 0xdd, 0x12,
	0x20, 0x1d, 0x20, 0x1d, 0x85, 0x26, 0x85, 0x26, 0xc4, 0x2e, 0xc4, 0x2e, 0x9e, 0x35, 0x9e,
	0x35, 0xe0, 0x3a, 0xe0, 0x3a, 0x61, 0x3e, 0x61, 0x3e, 0x06, 0x40, 0x06, 0x40, 0xc4, 0x3f,
	0xc4, 0x3f, 0x9b, 0x3d, 0x9b, 0x3d, 0x9c, 0x39, 0x9c, 0x39, 0xe6, 0x33, 0xe6, 0x33, 0xa5,
	0x2c, 0xa5, 0x2c, 0x0f, 0x24, 0x0f, 0x24, 0x66, 0x1a, 0x66, 0x1a, 0xf4, 0x0f, 0xf4, 0x0f,
	0x09, 0x05, 0x09, 0x05, 0xf6, 0xf9, 0xf6, 0xf9, 0x12, 0xef, 0x12, 0xef, 0xaf, 0xe4, 0xaf,
	0xe4, 0x1d, 0xdb, 0x1d, 0xdb, 0xa3, 0xd2, 0xa3, 0xd2, 0x84, 0xcb, 0x84, 0xcb, 0xf4, 0xc5,
	0xf4, 0xc5, 0x1f, 0xc2, 0x1f, 0xc2, 0x22, 0xc0, 0x22, 0xc0, 0x0c, 0xc0, 0x0c, 0xc0, 0xdd,
	0xc1, 0xdd, 0xc1, 0x88, 0xc5, 0x88, 0xc5, 0xf1, 0xca, 0xf1, 0xca, 0xee, 0xd1, 0xee, 0xd1,
	0x4b, 0xda, 0x4b, 0xda, 0xc7, 0xe3, 0xc7, 0xe3, 0x1a, 0xee, 0x1a, 0xee, 0xf6, 0xf8, 0xf6,
	0xf8, 0x07, 0x04, 0x07, 0x04, 0xfa, 0x0e, 0xfa, 0x0e, 0x7a, 0x19, 0x7a, 0x19, 0x39, 0x23,
	0x39, 0x23, 0xea, 0x2b, 0xea, 0x2b, 0x4d, 0x33, 0x4d, 0x33, 0x29, 0x39, 0x29, 0x39, 0x51,
	0x3d, 0x51, 0x3d, 0xa5, 0x3f, 0xa5, 0x3f, 0x15, 0x40, 0x15, 0x40, 0x9b, 0x3e, 0x9b, 0x3e,
	0x45, 0x3b, 0x45, 0x3b, 0x2a, 0x36, 0x2a, 0x36, 0x73, 0x2f, 0x73, 0x2f, 0x52, 0x27, 0x52,
	0x27, 0x05, 0x1e, 0x05, 0x1e, 0xd3, 0x13, 0xd3, 0x13, 0x0a, 0x09, 0x0a, 0x09, 0xfc, 0xfd,
	0xfc, 0xfd, 0xfe, 0xf2, 0xfe, 0xf2, 0x62, 0xe8, 0x62, 0xe8, 0x7b, 0xde, 0x7b, 0xde, 0x93,
	0xd5, 0x93, 0xd5, 0xef, 0xcd, 0xef, 0xcd, 0xc8, 0xc7, 0xc8, 0xc7, 0x4f, 0xc3, 0x4f, 0xc3,
	0xa3, 0xc0, 0xa3, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf, 0xfc, 0xc0, 0xfc, 0xc0, 0xfd, 0xc3, 0xfd,
	0xc3, 0xc8, 0xc8, 0xc8, 0xc8, 0x38, 0xcf, 0x38, 0xcf, 0x1c, 0xd7, 0x1c, 0xd7, 0x37, 0xe0,
	0x37, 0xe0, 0x45, 0xea, 0x45, 0xea, 0xf8, 0xf4, 0xf8, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x08,
	0x0b, 0x08, 0x0b, 0xbb, 0x15, 0xbb, 0x15, 0xc9, 0x1f, 0xc9, 0x1f, 0xe4, 0x28, 0xe4, 0x28,
	0xc8, 0x30, 0xc8, 0x30, 0x38, 0x37, 0x38, 0x37, 0x03, 0x3c, 0x03, 0x3c, 0x04, 0x3f, 0x04,
	0x3f, 0x25, 0x40, 0x25, 0x40, 0x5d, 0x3f, 0x5d, 0x3f, 0xb1, 0x3c, 0xb1, 0x3c, 0x38, 0x38,
	0x38, 0x38, 0x11, 0x32, 0x11, 0x32, 0x6d, 0x2a, 0x6d, 0x2a, 0x85, 0x21, 0x85, 0x21, 0x9e,
	0x17, 0x9e, 0x17, 0x02, 0x0d, 0x02, 0x0d, 0x04, 0x02, 0x04, 0x02, 0xf6, 0xf6, 0xf6, 0xf6,
	0x2d, 0xec, 0x2d, 0xec, 0xfb, 0xe1, 0xfb, 0xe1, 0xae, 0xd8, 0xae, 0xd8, 0x8d, 0xd0, 0x8d,
	0xd0, 0xd6, 0xc9, 0xd6, 0xc9, 0xbb, 0xc4, 0xbb, 0xc4, 0x65, 0xc1, 0x65, 0xc1, 0xeb, 0xbf,
	0xeb, 0xbf, 0x5b, 0xc0, 0x5b, 0xc0, 0xaf, 0xc2, 0xaf, 0xc2, 0xd7, 0xc6, 0xd7, 0xc6, 0xb3,
	0xcc, 0xb3, 0xcc, 0x16, 0xd4, 0x16, 0xd4, 0xc7, 0xdc, 0xc7, 0xdc, 0x86, 0xe6, 0x86, 0xe6,
	0x06, 0xf1, 0x06, 0xf1, 0xf9, 0xfb, 0xf9, 0xfb, 0x0a, 0x07, 0x0a, 0x07, 0xe6, 0x11, 0xe6,
	0x11, 0x39, 0x1c, 0x39, 0x1c, 0xb5, 0x25, 0xb5, 0x25, 0x12, 0x2e, 0x12, 0x2e, 0x0f, 0x35,
	0x0f, 0x35, 0x78, 0x3a, 0x78, 0x3a, 0x23, 0x3e, 0x23, 0x3e, 0xf4, 0x3f, 0xf4, 0x3f, 0xde,
	0x3f, 0xde, 0x3f, 0xe1, 0x3d, 0xe1, 0x3d, 0x0c, 0x3a, 0x0c, 0x3a, 0x7c, 0x34, 0x7c, 0x34,
	0x5d, 0x2d, 0x5d, 0x2d, 0xe3, 0x24, 0xe3, 0x24, 0x51, 0x1b, 0x51, 0x1b, 0xee, 0x10, 0xee,
	0x10, 0x0a, 0x06, 0x0a, 0x06, 0xf7, 0xfa, 0xf7, 0xfa, 0x0c, 0xf0, 0x0c, 0xf0, 0x9a, 0xe5,
	0x9a, 0xe5, 0xf1, 0xdb, 0xf1, 0xdb, 0x5b, 0xd3, 0x5b, 0xd3, 0x1a, 0xcc, 0x1a, 0xcc, 0x64,
	0xc6, 0x64, 0xc6, 0x65, 0xc2, 0x65, 0xc2, 0x3c, 0xc0, 0x3c, 0xc0, 0xfa, 0xbf, 0xfa, 0xbf,
	0x9f, 0xc1, 0x9f, 0xc1, 0x20, 0xc5, 0x20, 0xc5, 0x62, 0xca, 0x62, 0xca, 0x3c, 0xd1, 0x3c,
	0xd1, 0x7b, 0xd9, 0x7b, 0xd9, 0xe0, 0xe2, 0xe0, 0xe2, 0x23, 0xed, 0x23, 0xed, 0xf6, 0xf7,
	0xf6, 0xf7, 0x06, 0x03, 0x06, 0x03, 0xff, 0x0d, 0xff, 0x0d, 0x8d, 0x18, 0x8d, 0x18, 0x60,
	0x22, 0x60, 0x22, 0x2d, 0x2b, 0x2d, 0x2b, 0xb1, 0x32, 0xb1, 0x32, 0xb2, 0x38, 0xb2, 0x38,
	0x03, 0x3d, 0x03, 0x3d, 0x83, 0x3f, 0x83, 0x3f, 0x1f, 0x40, 0x1f, 0x40, 0xd2, 0x3e, 0xd2,
	0x3e, 0xa6, 0x3b, 0xa6, 0x3b, 0xb3, 0x36, 0xb3, 0x36, 0x1f, 0x30, 0x1f, 0x30, 0x1c, 0x28,
	0x1c, 0x28, 0xe8, 0x1e, 0xe8, 0x1e, 0xc8, 0x14, 0xc8, 0x14, 0x09, 0x0a, 0x09, 0x0a, 0xfe,
	0xfe, 0xfe, 0xfe, 0xfb, 0xf3, 0xfb, 0xf3, 0x53, 0xe9, 0x53, 0xe9, 0x58, 0xdf, 0x58, 0xdf,
	0x56, 0xd6, 0x56, 0xd6, 0x92, 0xce, 0x92, 0xce, 0x47, 0xc8, 0x47, 0xc8, 0xa4, 0xc3, 0xa4,
	0xc3, 0xce, 0xc0, 0xce, 0xc0, 0xd9, 0xbf, 0xd9, 0xbf, 0xce, 0xc0, 0xce, 0xc0, 0xa4, 0xc3,
	0xa4, 0xc3, 0x47, 0xc8, 0x47, 0xc8, 0x92, 0xce, 0x92, 0xce, 0x56, 0xd6, 0x56, 0xd6, 0x58,
	0xdf, 0x58, 0xdf, 0x53, 0xe9, 0x53, 0xe9, 0xfb, 0xf3, 0xfb, 0xf3, 0xfe, 0xfe, 0xfe, 0xfe,
	0x09, 0x0a, 0x09, 0x0a, 0xc8, 0x14, 0xc8, 0x14, 0xe8, 0x1e, 0xe8, 0x1e, 0x1c, 0x28, 0x1c,
	0x28, 0x1f, 0x30, 0x1f, 0x30, 0xb3, 0x36, 0xb3, 0x36, 0xa6, 0x3b, 0xa6, 0x3b, 0xd2, 0x3e,
	0xd2, 0x3e, 0x1f, 0x40, 0x1f, 0x40, 0x83, 0x3f, 0x83, 0x3f, 0x03, 0x3d, 0x03, 0x3d, 0xb2,
	0x38, 0xb2, 0x38, 0xb1, 0x32, 0xb1, 0x32, 0x2d, 0x2b, 0x2d, 0x2b, 0x60, 0x22, 0x60, 0x22,
	0x8d, 0x18, 0x8d, 0x18, 0xff, 0x0d, 0xff, 0x0d, 0x06, 0x03, 0x06, 0x03, 0xf6, 0xf7, 0xf6,
	0xf7, 0x23, 0xed, 0x23, 0xed, 0xe0, 0xe2, 0xe0, 0xe2, 0x7b, 0xd9, 0x7b, 0xd9, 0x3c, 0xd1,
	0x3c, 0xd1, 0x62, 0xca, 0x62, 0xca, 0x20, 0xc5, 0x20, 0xc5, 0x9f, 0xc1, 0x9f, 0xc1, 0xfa,
	0xbf, 0xfa, 0xbf, 0x3c, 0xc0, 0x3c, 0xc0, 0x65, 0xc2, 0x65, 0xc2, 0x64, 0xc6, 0x64, 0xc6,
	0x1a, 0xcc, 0x1a, 0xcc, 0x5b, 0xd3, 0x5b, 0xd3, 0xf1, 0xdb, 0xf1, 0xdb, 0x9a, 0xe5, 0x9a,
	0xe5, 0x0c, 0xf0, 0x0c, 0xf0, 0xf7, 0xfa, 0xf7, 0xfa, 0x0a, 0x06, 0x0a, 0x06, 0xee, 0x10,
	0xee, 0x10, 0x51, 0x1b, 0x51, 0x1b, 0xe3, 0x24, 0xe3, 0x24, 0x5d, 0x2d, 0x5d, 0x2d, 0x7c,
	0x34, 0x7c, 0x34, 0x0c, 0x3a, 0x0c, 0x3a, 0xe1, 0x3d, 0xe1, 0x3d, 0xde, 0x3f, 0xde, 0x3f,
	0xf4, 0x3f, 0xf4, 0x3f, 0x23, 0x3e, 0x23, 0x3e, 0x78, 0x3a, 0x78, 0x3a, 0x0f, 0x35, 0x0f,
	0x35, 0x12, 0x2e, 0x12, 0x2e, 0xb5, 0x25, 0xb5, 0x25, 0x39, 0x1c, 0x39, 0x1c, 0xe6, 0x11,
	0xe6, 0x11, 0x0a, 0x07, 0x0a, 0x07, 0xf9, 0xfb, 0xf9, 0xfb, 0x06, 0xf1, 0x06, 0xf1, 0x86,
	0xe6, 0x86, 0xe6, 0xc7, 0xdc, 0xc7, 0xdc, 0x16, 0xd4, 0x16, 0xd4, 0xb3, 0xcc, 0xb3, 0xcc,
	0xd7, 0xc6, 0xd7, 0xc6, 0xaf, 0xc2, 0xaf, 0xc2, 0x5b, 0xc0, 0x5b, 0xc0, 0xeb, 0xbf, 0xeb,
	0xbf, 0x65, 0xc1, 0x65, 0xc1, 0xbb, 0xc4, 0xbb, 0xc4, 0xd6, 0xc9, 0xd6, 0xc9, 0x8d, 0xd0,
	0x8d, 0xd0, 0xae, 0xd8, 0xae, 0xd8, 0xfb, 0xe1, 0xfb, 0xe1, 0x2d, 0xec, 0x2d, 0xec, 0xf6,
	0xf6, 0xf6, 0xf6, 0x04, 0x02, 0x04, 0x02, 0x02, 0x0d, 0x02, 0x0d, 0x9e, 0x17, 0x9e, 0x17,
	0x85, 0x21, 0x85, 0x21, 0x6d, 0x2a, 0x6d, 0x2a, 0x11, 0x32, 0x11, 0x32, 0x38, 0x38, 0x38,
	0x38, 0xb1, 0x3c, 0xb1, 0x3c, 0x5d, 0x3f, 0x5d, 0x3f, 0x25, 0x40, 0x25, 0x40, 0x04, 0x3f,
	0x04, 0x3f, 0x03, 0x3c, 0x03, 0x3c, 0x38, 0x37, 0x38, 0x37, 0xc8, 0x30, 0xc8, 0x30, 0xe4,
	0x28, 0xe4, 0x28, 0xc9, 0x1f, 0xc9, 0x1f, 0xbb, 0x15, 0xbb, 0x15, 0x08, 0x0b, 0x08, 0x0b,
	0x00, 0x00, 0x00, 0x00, 0xf8, 0xf4, 0xf8, 0xf4, 0x45, 0xea, 0x45, 0xea, 0x37, 0xe0, 0x37,
	0xe0, 0x1c, 0xd7, 0x1c, 0xd7, 0x38, 0xcf, 0x38, 0xcf, 0xc8, 0xc8, 0xc8, 0xc8, 0xfd, 0xc3,
	0xfd, 0xc3, 0xfc, 0xc0, 0xfc, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf, 0xa3, 0xc0, 0xa3, 0xc0, 0x4f,
	0xc3, 0x4f, 0xc3, 0xc8, 0xc7, 0xc8, 0xc7, 0xef, 0xcd, 0xef, 0xcd, 0x93, 0xd5, 0x93, 0xd5,
	0x7b, 0xde, 0x7b, 0xde, 0x62, 0xe8, 0x62, 0xe8, 0xfe, 0xf2, 0xfe, 0xf2, 0xfc, 0xfd, 0xfc,
	0xfd, 0x0a, 0x09, 0x0a, 0x09, 0xd3, 0x13, 0xd3, 0x13, 0x05, 0x1e, 0x05, 0x1e, 0x52, 0x27,
	0x52, 0x27, 0x73, 0x2f, 0x73, 0x2f, 0x2a, 0x36, 0x2a, 0x36, 0x45, 0x3b, 0x45, 0x3b, 0x9b,
	0x3e, 0x9b, 0x3e, 0x15, 0x40, 0x15, 0x40, 0xa5, 0x3f, 0xa5, 0x3f, 0x51, 0x3d, 0x51, 0x3d,
	0x29, 0x39, 0x29, 0x39, 0x4d, 0x33, 0x4d, 0x33, 0xea, 0x2b, 0xea, 0x2b, 0x39, 0x23, 0x39,
	0x23, 0x7a, 0x19, 0x7a, 0x19, 0xfa, 0x0e, 0xfa, 0x0e, 0x07, 0x04, 0x07, 0x04, 0xf6, 0xf8,
	0xf6, 0xf8, 0x1a, 0xee, 0x1a, 0xee, 0xc7, 0xe3, 0xc7, 0xe3, 0x4b, 0xda, 0x4b, 0xda, 0xee,
	0xd1, 0xee, 0xd1, 0xf1, 0xca, 0xf1, 0xca, 0x88, 0xc5, 0x88, 0xc5, 0xdd, 0xc1, 0xdd, 0xc1,
	0x0c, 0xc0, 0x0c, 0xc0, 0x22, 0xc0, 0x22, 0xc0, 0x1f, 0xc2, 0x1f, 0xc2, 0xf4, 0xc5, 0xf4,
	0xc5, 0x84, 0xcb, 0x84, 0xcb, 0xa3, 0xd2, 0xa3, 0xd2, 0x1d, 0xdb, 0x1d, 0xdb, 0xaf, 0xe4,
	0xaf, 0xe4, 0x12, 0xef, 0x12, 0xef, 0xf6, 0xf9, 0xf6, 0xf9, 0x09, 0x05, 0x09, 0x05, 0xf4,
	0x0f, 0xf4, 0x0f, 0x66, 0x1a, 0x66, 0x1a, 0x0f, 0x24, 0x0f, 0x24, 0xa5, 0x2c, 0xa5, 0x2c,
	0xe6, 0x33, 0xe6, 0x33, 0x9c, 0x39, 0x9c, 0x39, 0x9b, 0x3d, 0x9b, 0x3d, 0xc4, 0x3f, 0xc4,
	0x3f, 0x06, 0x40, 0x06, 0x40, 0x61, 0x3e, 0x61, 0x3e, 0xe0, 0x3a, 0xe0, 0x3a, 0x9e, 0x35,
	0x9e, 0x35, 0xc4, 0x2e, 0xc4, 0x2e, 0x85, 0x26, 0x85, 0x26, 0x20, 0x1d, 0x20, 0x1d, 0xdd,
	0x12, 0xdd, 0x12, 0x0a, 0x08, 0x0a, 0x08, 0xfa, 0xfc, 0xfa, 0xfc, 0x01, 0xf2, 0x01, 0xf2,
	0x73, 0xe7, 0x73, 0xe7, 0xa0, 0xdd, 0xa0, 0xdd, 0xd3, 0xd4, 0xd3, 0xd4, 0x4f, 0xcd, 0x4f,
	0xcd, 0x4e, 0xc7, 0x4e, 0xc7, 0xfd, 0xc2, 0xfd, 0xc2, 0x7d, 0xc0, 0x7d, 0xc0, 0xe1, 0xbf,
	0xe1, 0xbf, 0x2e, 0xc1, 0x2e, 0xc1, 0x5a, 0xc4, 0x5a, 0xc4, 0x4d, 0xc9, 0x4d, 0xc9, 0xe1,
	0xcf, 0xe1, 0xcf, 0xe4, 0xd7, 0xe4, 0xd7, 0x18, 0xe1, 0x18, 0xe1, 0x38, 0xeb, 0x38, 0xeb,
	0xf7, 0xf5, 0xf7, 0xf5, 0x02, 0x01, 0x02, 0x01, 0x05, 0x0c, 0x05, 0x0c, 0xad, 0x16, 0xad,
	0x16, 0xa8, 0x20, 0xa8, 0x20, 0xaa, 0x29, 0xaa, 0x29, 0x6e, 0x31, 0x6e, 0x31, 0xb9, 0x37,
	0xb9, 0x37, 0x5c, 0x3c, 0x5c, 0x3c, 0x32, 0x3f, 0x32, 0x3f, 0x27, 0x40, 0x27, 0x40, 0x32,
	0x3f, 0x32, 0x3f, 0x5c, 0x3c, 0x5c, 0x3c, 0xb9, 0x37, 0xb9, 0x37, 0x6e, 0x31, 0x6e, 0x31,
	0xaa, 0x29, 0xaa, 0x29, 0xa8, 0x20, 0xa8, 0x20, 0xad, 0x16, 0xad, 0x16, 0x05, 0x0c, 0x05,
	0x0c, 0x02, 0x01, 0x02, 0x01, 0xf7, 0xf5, 0xf7, 0xf5, 0x38, 0xeb, 0x38, 0xeb, 0x18, 0xe1,
	0x18, 0xe1, 0xe4, 0xd7, 0xe4, 0xd7, 0xe1, 0xcf, 0xe1, 0xcf, 0x4d, 0xc9, 0x4d, 0xc9, 0x5a,
	0xc4, 0x5a, 0xc4, 0x2e, 0xc1, 0x2e, 0xc1, 0xe1, 0xbf, 0xe1, 0xbf, 0x7d, 0xc0, 0x7d, 0xc0,
	0xfd, 0xc2, 0xfd, 0xc2, 0x4e, 0xc7, 0x4e, 0xc7, 0x4f, 0xcd, 0x4f, 0xcd, 0xd3, 0xd4, 0xd3,
	0xd4, 0xa0, 0xdd, 0xa0, 0xdd, 0x73, 0xe7, 0x73, 0xe7, 0x01, 0xf2, 0x01, 0xf2, 0xfa, 0xfc,
	0xfa, 0xfc, 0x0a, 0x08, 0x0a, 0x08, 0xdd, 0x12, 0xdd, 0x12, 0x20, 0x1d, 0x20, 0x1d, 0x85,
	0x26, 0x85, 0x26, 0xc4, 0x2e, 0xc4, 0x2e, 0x9e, 0x35, 0x9e, 0x35, 0xe0, 0x3a, 0xe0, 0x3a,
	0x61, 0x3e, 0x61, 0x3e, 0x06, 0x40, 0x06, 0x40, 0xc4, 0x3f, 0xc4, 0x3f, 0x9b, 0x3d, 0x9b,
	0x3d, 0x9c, 0x39, 0x9c, 0x39, 0xe6, 0x33, 0xe6, 0x33, 0xa5, 0x2c, 0xa5, 0x2c, 0x0f, 0x24,
	0x0f, 0x24, 0x66, 0x1a, 0x66, 0x1a, 0xf4, 0x0f, 0xf4, 0x0f, 0x09, 0x05, 0x09, 0x05, 0xf6,
	0xf9, 0xf6, 0xf9, 0x12, 0xef, 0x12, 0xef, 0xaf, 0xe4, 0xaf, 0xe4, 0x1d, 0xdb, 0x1d, 0xdb,
	0xa3, 0xd2, 0xa3, 0xd2, 0x84, 0xcb, 0x84, 0xcb, 0xf4, 0xc5, 0xf4, 0xc5, 0x1f, 0xc2, 0x1f,
	0xc2, 0x22, 0xc0, 0x22, 0xc0, 0x0c, 0xc0, 0x0c, 0xc0, 0xdd, 0xc1, 0xdd, 0xc1, 0x88, 0xc5,
	0x88, 0xc5, 0xf1, 0xca, 0xf1, 0xca, 0xee, 0xd1, 0xee, 0xd1, 0x4b, 0xda, 0x4b, 0xda, 0xc7,
	0xe3, 0xc7, 0xe3, 0x1a, 0xee, 0x1a, 0xee, 0xf6, 0xf8, 0xf6, 0xf8, 0x07, 0x04, 0x07, 0x04,
	0xfa, 0x0e, 0xfa, 0x0e, 0x7a, 0x19, 0x7a, 0x19, 0x39, 0x23, 0x39, 0x23, 0xea, 0x2b, 0xea,
	0x2b, 0x4d, 0x33, 0x4d, 0x33, 0x29, 0x39, 0x29, 0x39, 0x51, 0x3d, 0x51, 0x3d, 0xa5, 0x3f,
	0xa5, 0x3f, 0x15, 0x40, 0x15, 0x40, 0x9b, 0x3e, 0x9b, 0x3e, 0x45, 0x3b, 0x45, 0x3b, 0x2a,
	0x36, 0x2a, 0x36, 0x73, 0x2f, 0x73, 0x2f, 0x52, 0x27, 0x52, 0x27, 0x05, 0x1e, 0x05, 0x1e,
	0xd3, 0x13, 0xd3, 0x13, 0x0a, 0x09, 0x0a, 0x09, 0xfc, 0xfd, 0xfc, 0xfd, 0xfe, 0xf2, 0xfe,
	0xf2, 0x62, 0xe8, 0x62, 0xe8, 0x7b, 0xde, 0x7b, 0xde, 0x93, 0xd5, 0x93, 0xd5, 0xef, 0xcd,
	0xef, 0xcd, 0xc8, 0xc7, 0xc8, 0xc7, 0x4f, 0xc3, 0x4f, 0xc3, 0xa3, 0xc0, 0xa3, 0xc0, 0xdb,
	0xbf, 0xdb, 0xbf, 0xfc, 0xc0, 0xfc, 0xc0, 0xfd, 0xc3, 0xfd, 0xc3, 0xc8, 0xc8, 0xc8, 0xc8,
	0x38, 0xcf, 0x38, 0xcf, 0x1c, 0xd7, 0x1c, 0xd7, 0x37, 0xe0, 0x37, 0xe0, 0x45, 0xea, 0x45,
	0xea, 0xf8, 0xf4, 0xf8, 0xf4, 0x00, 0x00, 0x00, 0x00, 0x08, 0x0b, 0x08, 0x0b, 0xbb, 0x15,
	0xbb, 0x15, 0xc9, 0x1f, 0xc9, 0x1f, 0xe4, 0x28, 0xe4, 0x28, 0xc8, 0x30, 0xc8, 0x30, 0x38,
	0x37, 0x38, 0x37, 0x03, 0x3c, 0x03, 0x3c, 0x04, 0x3f, 0x04, 0x3f, 0x25, 0x40, 0x25, 0x40,
	0x5d, 0x3f, 0x5d, 0x3f, 0xb1, 0x3c, 0xb1, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x11, 0x32, 0x11,
	0x32, 0x6d, 0x2a, 0x6d, 0x2a, 0x85, 0x21, 0x85, 0x21, 0x9e, 0x17, 0x9e, 0x17, 0x02, 0x0d,
	0x02, 0x0d, 0x04, 0x02, 0x04, 0x02, 0xf6, 0xf6, 0xf6, 0xf6, 0x2d, 0xec, 0x2d, 0xec, 0xfb,
	0xe1, 0xfb, 0xe1, 0xae, 0xd8, 0xae, 0xd8, 0x8d, 0xd0, 0x8d, 0xd0, 0xd6, 0xc9, 0xd6, 0xc9,
	0xbb, 0xc4, 0xbb, 0xc4, 0x65, 0xc1, 0x65, 0xc1, 0xeb, 0xbf, 0xeb, 0xbf, 0x5b, 0xc0, 0x5b,
	0xc0, 0xaf, 0xc2, 0xaf, 0xc2, 0xd7, 0xc6, 0xd7, 0xc6, 0xb3, 0xcc, 0xb3, 0xcc, 0x16, 0xd4,
	0x16, 0xd4, 0xc7, 0xdc, 0xc7, 0xdc, 0x86, 0xe6, 0x86, 0xe6, 0x06, 0xf1, 0x06, 0xf1, 0xf9,
	0xfb, 0xf9, 0xfb, 0x0a, 0x07, 0x0a, 0x07, 0xe6, 0x11, 0xe6, 0x11, 0x39, 0x1c, 0x39, 0x1c,
	0xb5, 0x25, 0xb5, 0x25, 0x12, 0x2e, 0x12, 0x2e, 0x0f, 0x35, 0x0f, 0x35, 0x78, 0x3a, 0x78,
	0x3a, 0x23, 0x3e, 0x23, 0x3e, 0xf4, 0x3f, 0xf4, 0x3f, 0xde, 0x3f, 0xde, 0x3f, 0xe1, 0x3d,
	0xe1, 0x3d, 0x0c, 0x3a, 0x0c, 0x3a, 0x7c, 0x34, 0x7c, 0x34, 0x5d, 0x2d, 0x5d, 0x2d, 0xe3,
	0x24, 0xe3, 0x24, 0x51, 0x1b, 0x51, 0x1b, 0xee, 0x10, 0xee, 0x10, 0x0a, 0x06, 0x0a, 0x06,
	0xf7, 0xfa, 0xf7, 0xfa, 0x0c, 0xf0, 0x0c, 0xf0, 0x9a, 0xe5, 0x9a, 0xe5, 0xf1, 0xdb, 0xf1,
	0xdb, 0x5b, 0xd3, 0x5b, 0xd3, 0x1a, 0xcc, 0x1a, 0xcc, 0x64, 0xc6, 0x64, 0xc6, 0x65, 0xc2,
	0x65, 0xc2, 0x3c, 0xc0, 0x3c, 0xc0, 0xfa, 0xbf, 0xfa, 0xbf, 0x9f, 0xc1, 0x9f, 0xc1, 0x20,
	0xc5, 0x20, 0xc5, 0x62, 0xca, 0x62, 0xca, 0x3c, 0xd1, 0x3c, 0xd1, 0x7b, 0xd9, 0x7b, 0xd9,
	0xe0, 0xe2, 0xe0, 0xe2, 0x23, 0xed, 0x23, 0xed, 0xf6, 0xf7, 0xf6, 0xf7, 0x06, 0x03, 0x06,
	0x03, 0xff, 0x0d, 0xff, 0x0d, 0x8d, 0x18, 0x8d, 0x18, 0x60, 0x22, 0x60, 0x22, 0x2d, 0x2b,
	0x2d, 0x2b, 0xb1, 0x32, 0xb1, 0x32, 0xb2, 0x38, 0xb2, 0x38, 0x03, 0x3d, 0x03, 0x3d, 0x83,
	0x3f, 0x83, 0x3f, 0x1f, 0x40, 0x1f, 0x40, 0xd2, 0x3e, 0xd2, 0x3e, 0xa6, 0x3b, 0xa6, 0x3b,
	0xb3, 0x36, 0xb3, 0x36, 0x1f, 0x30, 0x1f, 0x30, 0x1c, 0x28, 0x1c, 0x28, 0xe8, 0x1e, 0xe8,
	0x1e, 0xc8, 0x14, 0xc8, 0x14, 0x09, 0x0a, 0x09, 0x0a, 0xfe, 0xfe, 0xfe, 0xfe, 0xfb, 0xf3,
	0xfb, 0xf3, 0x53, 0xe9, 0x53, 0xe9, 0x58, 0xdf, 0x58, 0xdf, 0x56, 0xd6, 0x56, 0xd6, 0x92,
	0xce, 0x92, 0xce, 0x47, 0xc8, 0x47, 0xc8, 0xa4, 0xc3, 0xa4, 0xc3, 0xce, 0xc0, 0xce, 0xc0,
	0xd9, 0xbf, 0xd9, 0xbf, 0xce, 0xc0, 0xce, 0xc0, 0xa4, 0xc3, 0xa4, 0xc3, 0x47, 0xc8, 0x47,
	0xc8, 0x92, 0xce, 0x92, 0xce, 0x56, 0xd6, 0x56, 0xd6, 0x58, 0xdf, 0x58, 0xdf, 0x53, 0xe9,
	0x53, 0xe9, 0xfb, 0xf3, 0xfb, 0xf3, 0xfe, 0xfe, 0xfe, 0xfe, 0x09, 0x0a, 0x09, 0x0a, 0xc8,
	0x14, 0xc8, 0x14, 0xe8, 0x1e, 0xe8, 0x1e, 0x1c, 0x28, 0x1c, 0x28, 0x1f, 0x30, 0x1f, 0x30,
	0xb3, 0x36, 0xb3, 0x36, 0xa6, 0x3b, 0xa6, 0x3b, 0xd2, 0x3e, 0xd2, 0x3e, 0x1f, 0x40, 0x1f,
	0x40, 0x83, 0x3f, 0x83, 0x3f, 0x03, 0x3d, 0x03, 0x3d, 0xb2, 0x38, 0xb2, 0x38, 0xb1, 0x32,
	0xb1, 0x32, 0x2d, 0x2b, 0x2d, 0x2b, 0x60, 0x22, 0x60, 0x22, 0x8d, 0x18, 0x8d, 0x18, 0xff,
	0x0d, 0xff, 0x0d, 0x06, 0x03, 0x06, 0x03, 0xf6, 0xf7, 0xf6, 0xf7, 0x23, 0xed, 0x23, 0xed,
	0xe0, 0xe2, 0xe0, 0xe2, 0x7b, 0xd9, 0x7b, 0xd9, 0x3c, 0xd1, 0x3c, 0xd1, 0x62, 0xca, 0x62,
	0xca, 0x20, 0xc5, 0x20, 0xc5, 0x9f, 0xc1, 0x9f, 0xc1, 0xfa, 0xbf, 0xfa, 0xbf, 0x3c, 0xc0,
	0x3c, 0xc0, 0x65, 0xc2, 0x65, 0xc2, 0x64, 0xc6, 0x64, 0xc6, 0x1a, 0xcc, 0x1a, 0xcc, 0x5b,
	0xd3, 0x5b, 0xd3, 0xf1, 0xdb, 0xf1, 0xdb, 0x9a, 0xe5, 0x9a, 0xe5, 0x0c, 0xf0, 0x0c, 0xf0,
	0xf7, 0xfa, 0xf7, 0xfa, 0x0a, 0x06, 0x0a, 0x06, 0xee, 0x10, 0xee, 0x10, 0x51, 0x1b, 0x51,
	0x1b, 0xe3, 0x24, 0xe3, 0x24, 0x5d, 0x2d, 0x5d, 0x2d, 0x7c, 0x34, 0x7c, 0x34, 0x0c, 0x3a,
	0x0c, 0x3a, 0xe1, 0x3d, 0xe1, 0x3d, 0xde, 0x3f, 0xde, 0x3f, 0xf4, 0x3f, 0xf4, 0x3f, 0x23,
	0x3e, 0x23, 0x3e, 0x78, 0x3a, 0x78, 0x3a, 0x0f, 0x35, 0x0f, 0x35, 0x12, 0x2e, 0x12, 0x2e,
	0xb5, 0x25, 0xb5, 0x25, 0x39, 0x1c, 0x39, 0x1c, 0xe6, 0x11, 0xe6, 0x11, 0x0a, 0x07, 0x0a,
	0x07, 0xf9, 0xfb, 0xf9, 0xfb, 0x06, 0xf1, 0x06, 0xf1, 0x86, 0xe6, 0x86, 0xe6, 0xc7, 0xdc,
	0xc7, 0xdc, 0x16, 0xd4, 0x16, 0xd4, 0xb3, 0xcc, 0xb3, 0xcc, 0xd7, 0xc6, 0xd7, 0xc6, 0xaf,
	0xc2, 0xaf, 0xc2, 0x5b, 0xc0, 0x5b, 0xc0, 0xeb, 0xbf, 0xeb, 0xbf, 0x65, 0xc1, 0x65, 0xc1,
	0xbb, 0xc4, 0xbb, 0xc4, 0xd6, 0xc9, 0xd6, 0xc9, 0x8d, 0xd0, 0x8d, 0xd0, 0xae, 0xd8, 0xae,
	0xd8, 0xfb, 0xe1, 0xfb, 0xe1, 0x2d, 0xec, 0x2d, 0xec, 0xf6, 0xf6, 0xf6, 0xf6, 0x04, 0x02,
	0x04, 0x02, 0x02, 0x0d, 0x02, 0x0d, 0x9e, 0x17, 0x9e, 0x17, 0x85, 0x21, 0x85, 0x21, 0x6d,
	0x2a, 0x6d, 0x2a, 0x11, 0x32, 0x11, 0x32, 0x38, 0x38, 0x38, 0x38, 0xb1, 0x3c, 0xb1, 0x3c,
	0x5d, 0x3f, 0x5d, 0x3f, 0x25, 0x40, 0x25, 0x40, 0x04, 0x3f, 0x04, 0x3f, 0x03, 0x3c, 0x03,
	0x3c, 0x38, 0x37, 0x38, 0x37, 0xc8, 0x30, 0xc8, 0x30, 0xe4, 0x28, 0xe4, 0x28, 0xc9, 0x1f,
	0xc9, 0x1f, 0xbb, 0x15, 0xbb, 0x15, 0x08, 0x0b, 0x08, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xf8,
	0xf4, 0xf8, 0xf4, 0x45, 0xea, 0x45, 0xea, 0x37, 0xe0, 0x37, 0xe0, 0x1c, 0xd7, 0x1c, 0xd7,
	0x38, 0xcf, 0x38, 0xcf, 0xc8, 0xc8, 0xc8, 0xc8, 0xfd, 0xc3, 0xfd, 0xc3, 0xfc, 0xc0, 0xfc,
	0xc0, 0xdb, 0xbf, 0xdb, 0xbf, 0xa3, 0xc0, 0xa3, 0xc0, 0x4f, 0xc3, 0x4f, 0xc3, 0xc8, 0xc7,
	0xc8, 0xc7, 0xef, 0xcd, 0xef, 0xcd, 0x93, 0xd5, 0x93, 0xd5, 0x7b, 0xde, 0x7b, 0xde, 0x62,
	0xe8, 0x62, 0xe8, 0xfe, 0xf2, 0xfe, 0xf2, 0xfc, 0xfd, 0xfc, 0xfd, 0x0a, 0x09, 0x0a, 0x09,
	0xd3, 0x13, 0xd3, 0x13, 0x05, 0x1e, 0x05, 0x1e, 0x52, 0x27, 0x52, 0x27, 0x73, 0x2f, 0x73,
	0x2f, 0x2a, 0x36, 0x2a, 0x36, 0x45, 0x3b, 0x45, 0x3b, 0x9b, 0x3e, 0x9b, 0x3e, 0x15, 0x40,
	0x15, 0x40, 0xa5, 0x3f, 0xa5, 0x3f, 0x51, 0x3d, 0x51, 0x3d, 0x29, 0x39, 0x29, 0x39, 0x4d,
	0x33, 0x4d, 0x33, 0xea, 0x2b, 0xea, 0x2b, 0x39, 0x23, 0x39, 0x23, 0x7a, 0x19, 0x7a, 0x19,
	0xfa, 0x0e, 0xfa, 0x0e, 0x07, 0x04, 0x07, 0x04, 0xf6, 0xf8, 0xf6, 0xf8, 0x1a, 0xee, 0x1a,
	0xee, 0xc7, 0xe3, 0xc7, 0xe3, 0x4b, 0xda, 0x4b, 0xda, 0xee, 0xd1, 0xee, 0xd1, 0xf1, 0xca,
	0xf1, 0xca, 0x88, 0xc5, 0x88, 0xc5, 0xdd, 0xc1, 0xdd, 0xc1, 0x0c, 0xc0, 0x0c, 0xc0, 0x22,
	0xc0, 0x22, 0xc0, 0x1f, 0xc2, 0x1f, 0xc2, 0xf4, 0xc5, 0xf4, 0xc5, 0x84, 0xcb, 0x84, 0xcb,
	0xa3, 0xd2, 0xa3, 0xd2, 0x1d, 0xdb, 0x1d, 0xdb, 0xaf, 0xe4, 0xaf, 0xe4, 0x12, 0xef, 0x12,
	0xef, 0xf6, 0xf9, 0xf6, 0xf9, 0x09, 0x05, 0x09, 0x05, 0xf4, 0x0f, 0xf4, 0x0f, 0x66, 0x1a,
	0x66, 0x1a, 0x0f, 0x24, 0x0f, 0x24, 0xa5, 0x2c, 0xa5, 0x2c, 0xe6, 0x33, 0xe6, 0x33, 0x9c,
	0x39, 0x9c, 0x39, 0x9b, 0x3d, 0x9b, 0x3d, 0xc4, 0x3f, 0xc4, 0x3f, 0x06, 0x40, 0x06, 0x40,
	0x61, 0x3e, 0x61, 0x3e, 0xe0, 0x3a, 0xe0, 0x3a, 0x9e, 0x35, 0x9e, 0x35, 0xc4, 0x2e, 0xc4,
	0x2e, 0x85, 0x26, 0x85, 0x26, 0x20, 0x1d, 0x20, 0x1d, 0xdd, 0x12, 0xdd, 0x12, 0x0a, 0x08,
	0x0a, 0x08, 0xfa, 0xfc, 0xfa, 0xfc, 0x01, 0xf2, 0x01, 0xf2, 0x73, 0xe7, 0x73, 0xe7, 0xa0,
	0xdd, 0xa0, 0xdd, 0xd3, 0xd4, 0xd3, 0xd4, 0x4f, 0xcd, 0x4f, 0xcd, 0x4e, 0xc7, 0x4e, 0xc7,
	0xfd, 0xc2, 0xfd, 0xc2, 0x7d, 0xc0, 0x7d, 0xc0, 0xe1, 0xbf, 0xe1, 0xbf, 0x2e, 0xc1, 0x2e,
	0xc1, 0x5a, 0xc4, 0x5a, 0xc4, 0x4d, 0xc9, 0x4d, 0xc9, 0xe1, 0xcf, 0xe1, 0xcf, 0xe4, 0xd7,
	0xe4, 0xd7, 0x18, 0xe1, 0x18, 0xe1, 0x38, 0xeb, 0x38, 0xeb, 0xf7, 0xf5, 0xf7, 0xf5, 0x02,
	0x01, 0x02, 0x01, 0x05, 0x0c, 0x05, 0x0c, 0xad, 0x16, 0xad, 0x16, 0xa8, 0x20, 0xa8, 0x20,
	0xaa, 0x29, 0xaa, 0x29, 0x6e, 0x31, 0x6e, 0x31, 0xb9, 0x37, 0xb9, 0x37, 0x5c, 0x3c, 0x5c,
	0x3c, 0x32, 0x3f, 0x32, 0x3f, 0x27, 0x40, 0x27, 0x40, 0x32, 0x3f, 0x32, 0x3f, 0x5c, 0x3c,
	0x5c, 0x3c, 0xb9, 0x37, 0xb9, 0x37, 0x6e, 0x31, 0x6e, 0x31, 0xaa, 0x29, 0xaa, 0x29, 0xa8,
	0x20, 0xa8, 0x20, 0xad, 0x16, 0xad, 0x16, 0x05, 0x0c, 0x05, 0x0c, 0x02, 0x01, 0x02, 0x01,
	0xf7, 0xf5, 0xf7, 0xf5, 0x38, 0xeb, 0x38, 0xeb, 0x18, 0xe1, 0x18, 0xe1, 0xe4, 0xd7, 0xe4,
	0xd7, 0xe1, 0xcf, 0xe1, 0xcf, 0x4d, 0xc9, 0x4d, 0xc9, 0x5a, 0xc4, 0x5a, 0xc4, 0x2e, 0xc1,
	0x2e, 0xc1, 0xe1, 0xbf, 0xe1, 0xbf, 0x7d, 0xc0, 0x7d, 0xc0, 0xfd, 0xc2, 0xfd, 0xc2, 0x4e,
	0xc7, 0x4e, 0xc7, 0x4f, 0xcd, 0x4f, 0xcd, 0xd3, 0xd4, 0xd3, 0xd4, 0xa0, 0xdd, 0xa0, 0xdd,
	0x73, 0xe7, 0x73, 0xe7, 0x01, 0xf2, 0x01, 0xf2, 0xfa, 0xfc, 0xfa, 0xfc, 0x0a, 0x08, 0x0a,
	0x08, 0xdd, 0x12, 0xdd, 0x12, 0x20, 0x1d, 0x20, 0x1d, 0x85, 0x26, 0x85, 0x26, 0xc4, 0x2e,
	0xc4, 0x2e, 0x9e, 0x35, 0x9e, 0x35, 0xe0, 0x3a, 0xe0, 0x3a, 0x61, 0x3e, 0x61, 0x3e, 0x06,
	0x40, 0x06, 0x40, 0xc4, 0x3f, 0xc4, 0x3f, 0x9b, 0x3d, 0x9b, 0x3d, 0x9c, 0x39, 0x9c, 0x39,
	0xe6, 0x33, 0xe6, 0x33, 0xa5, 0x2c, 0xa5, 0x2c, 0x0f, 0x24, 0x0f, 0x24, 0x66, 0x1a, 0x66,
	0x1a, 0xf4, 0x0f, 0xf4, 0x0f, 0x09, 0x05, 0x09, 0x05, 0xf6, 0xf9, 0xf6, 0xf9, 0x12, 0xef,
	0x12, 0xef, 0xaf, 0xe4, 0xaf, 0xe4, 0x1d, 0xdb, 0x1d, 0xdb, 0xa3, 0xd2, 0xa3, 0xd2, 0x84,
	0xcb, 0x84, 0xcb, 0xf4, 0xc5, 0xf4, 0xc5, 0x1f, 0xc2, 0x1f, 0xc2, 0x22, 0xc0, 0x22, 0xc0,
	0x0c, 0xc0, 0x0c, 0xc0, 0xdd, 0xc1, 0xdd, 0xc1, 0x88, 0xc5, 0x88, 0xc5, 0xf1, 0xca, 0xf1,
	0xca, 0xee, 0xd1, 0xee, 0xd1, 0x4b, 0xda, 0x4b, 0xda, 0xc7, 0xe3, 0xc7, 0xe3, 0x1a, 0xee,
	0x1a, 0xee, 0xf6, 0xf8, 0xf6, 0xf8, 0x07, 0x04, 0x07, 0x04, 0xfa, 0x0e, 0xfa, 0x0e, 0x7a,
	0x19, 0x7a, 0x19, 0x39, 0x23, 0x39, 0x23, 0xea, 0x2b, 0xea, 0x2b, 0x4d, 0x33, 0x4d, 0x33,
	0x29, 0x39, 0x29, 0x39, 0x51, 0x3d, 0x51, 0x3d, 0xa5, 0x3f, 0xa5, 0x3f, 0x15, 0x40, 0x15,
	0x40, 0x9b, 0x3e, 0x9b, 0x3e, 0x45, 0x3b, 0x45, 0x3b, 0x2a, 0x36, 0x2a, 0x36, 0x73, 0x2f,
	0x73, 0x2f, 0x52, 0x27, 0x52, 0x27, 0x05, 0x1e, 0x05, 0x1e, 0xd3, 0x13, 0xd3, 0x13, 0x0a,
	0x09, 0x0a, 0x09, 0xfc, 0xfd, 0xfc, 0xfd, 0xfe, 0xf2, 0xfe, 0xf2, 0x62, 0xe8, 0x62, 0xe8,
	0x7b, 0xde, 0x7b, 0xde, 0x93, 0xd5, 0x93, 0xd5, 0xef, 0xcd, 0xef, 0xcd, 0xc8, 0xc7, 0xc8,
	0xc7, 0x4f, 0xc3, 0x4f, 0xc3, 0xa3, 0xc0, 0xa3, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf, 0xfc, 0xc0,
	0xfc, 0xc0, 0xfd, 0xc3, 0xfd, 0xc3, 0xc8, 0xc8, 0xc8, 0xc8, 0x38, 0xcf, 0x38, 0xcf, 0x1c,
	0xd7, 0x1c, 0xd7, 0x37, 0xe0, 0x37, 0xe0, 0x45, 0xea, 0x45, 0xea, 0xf8, 0xf4, 0xf8, 0xf4,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x0b, 0x08, 0x0b, 0xbb, 0x15, 0xbb, 0x15, 0xc9, 0x1f, 0xc9,
	0x1f, 0xe4, 0x28, 0xe4, 0x28, 0xc8, 0x30, 0xc8, 0x30, 0x38, 0x37, 0x38, 0x37, 0x03, 0x3c,
	0x03, 0x3c, 0x04, 0x3f, 0x04, 0x3f, 0x25, 0x40, 0x25, 0x40, 0x5d, 0x3f, 0x5d, 0x3f, 0xb1,
	0x3c, 0xb1, 0x3c, 0x38, 0x38, 0x38, 0x38, 0x11, 0x32, 0x11, 0x32, 0x6d, 0x2a, 0x6d, 0x2a,
	0x85, 0x21, 0x85, 0x21, 0x9e, 0x17, 0x9e, 0x17, 0x02, 0x0d, 0x02, 0x0d, 0x04, 0x02, 0x04,
	0x02, 0xf6, 0xf6, 0xf6, 0xf6, 0x2d, 0xec, 0x2d, 0xec, 0xfb, 0xe1, 0xfb, 0xe1, 0xae, 0xd8,
	0xae, 0xd8, 0x8d, 0xd0, 0x8d, 0xd0, 0xd6, 0xc9, 0xd6, 0xc9, 0xbb, 0xc4, 0xbb, 0xc4, 0x65,
	0xc1, 0x65, 0xc1, 0xeb, 0xbf, 0xeb, 0xbf, 0x5b, 0xc0, 0x5b, 0xc0, 0xaf, 0xc2, 0xaf, 0xc2,
	0xd7, 0xc6, 0xd7, 0xc6, 0xb3, 0xcc, 0xb3, 0xcc, 0x16, 0xd4, 0x16, 0xd4, 0xc7, 0xdc, 0xc7,
	0xdc, 0x86, 0xe6, 0x86, 0xe6, 0x06, 0xf1, 0x06, 0xf1, 0xf9, 0xfb, 0xf9, 0xfb, 0x0a, 0x07,
	0x0a, 0x07, 0xe6, 0x11, 0xe6, 0x11, 0x39, 0x1c, 0x39, 0x1c, 0xb5, 0x25, 0xb5, 0x25, 0x12,
	0x2e, 0x12, 0x2e, 0x0f, 0x35, 0x0f, 0x35, 0x78, 0x3a, 0x78, 0x3a, 0x23, 0x3e, 0x23, 0x3e,
	0xf4, 0x3f, 0xf4, 0x3f, 0xde, 0x3f, 0xde, 0x3f, 0xe1, 0x3d, 0xe1, 0x3d, 0x0c, 0x3a, 0x0c,
	0x3a, 0x7c, 0x34, 0x7c, 0x34, 0x5d, 0x2d, 0x5d, 0x2d, 0xe3, 0x24, 0xe3, 0x24, 0x51, 0x1b,
	0x51, 0x1b, 0xee, 0x10, 0xee, 0x10, 0x0a, 0x06, 0x0a, 0x06, 0xf7, 0xfa, 0xf7, 0xfa, 0x0c,
	0xf0, 0x0c, 0xf0, 0x9a, 0xe5, 0x9a, 0xe5, 0xf1, 0xdb, 0xf1, 0xdb, 0x5b, 0xd3, 0x5b, 0xd3,
	0x1a, 0xcc, 0x1a, 0xcc, 0x64, 0xc6, 0x64, 0xc6, 0x65, 0xc2, 0x65, 0xc2, 0x3c, 0xc0, 0x3c,
	0xc0, 0xfa, 0xbf, 0xfa, 0xbf, 0x9f, 0xc1, 0x9f, 0xc1, 0x20, 0xc5, 0x20, 0xc5, 0x62, 0xca,
	0x62, 0xca, 0x3c, 0xd1, 0x3c, 0xd1, 0x7b, 0xd9, 0x7b, 0xd9, 0xe0, 0xe2, 0xe0, 0xe2, 0x23,
	0xed, 0x23, 0xed, 0xf6, 0xf7, 0xf6, 0xf7, 0x06, 0x03, 0x06, 0x03, 0xff, 0x0d, 0xff, 0x0d,
	0x8d, 0x18, 0x8d, 0x18, 0x60, 0x22, 0x60, 0x22, 0x2d, 0x2b, 0x2d, 0x2b, 0xb1, 0x32, 0xb1,
	0x32, 0xb2, 0x38, 0xb2, 0x38, 0x03, 0x3d, 0x03, 0x3d, 0x83, 0x3f, 0x83, 0x3f, 0x1f, 0x40,
	0x1f, 0x40, 0xd2, 0x3e, 0xd2, 0x3e, 0xa6, 0x3b, 0xa6, 0x3b, 0xb3, 0x36, 0xb3, 0x36, 0x1f,
	0x30, 0x1f, 0x30, 0x1c, 0x28, 0x1c, 0x28, 0xe8, 0x1e, 0xe8, 0x1e, 0xc8, 0x14, 0xc8, 0x14,
	0x09, 0x0a, 0x09, 0x0a, 0xfe, 0xfe, 0xfe, 0xfe, 0xfb, 0xf3, 0xfb, 0xf3, 0x53, 0xe9, 0x53,
	0xe9, 0x58, 0xdf, 0x58, 0xdf, 0x56, 0xd6, 0x56, 0xd6, 0x92, 0xce, 0x92, 0xce, 0x47, 0xc8,
	0x47, 0xc8, 0xa4, 0xc3, 0xa4, 0xc3, 0xce, 0xc0, 0xce, 0xc0, 0xd9, 0xbf, 0xd9, 0xbf, 0xce,
	0xc0, 0xce, 0xc0, 0xa4, 0xc3, 0xa4, 0xc3, 0x47, 0xc8, 0x47, 0xc8, 0x92, 0xce, 0x92, 0xce,
	0x56, 0xd6, 0x56, 0xd6, 0x58, 0xdf, 0x58, 0xdf, 0x53, 0xe9, 0x53, 0xe9, 0xfb, 0xf3, 0xfb,
	0xf3, 0xfe, 0xfe, 0xfe, 0xfe, 0x09, 0x0a, 0x09, 0x0a, 0xc8, 0x14, 0xc8, 0x14, 0xe8, 0x1e,
	0xe8, 0x1e, 0x1c, 0x28, 0x1c, 0x28, 0x1f, 0x30, 0x1f, 0x30, 0xb3, 0x36, 0xb3, 0x36, 0xa6,
	0x3b, 0xa6, 0x3b, 0xd2, 0x3e, 0xd2, 0x3e, 0x1f, 0x40, 0x1f, 0x40, 0x83, 0x3f, 0x83, 0x3f,
	0x03, 0x3d, 0x03, 0x3d, 0xb2, 0x38, 0xb2, 0x38, 0xb1, 0x32, 0xb1, 0x32, 0x2d, 0x2b, 0x2d,
	0x2b, 0x60, 0x22, 0x60, 0x22, 0x8d, 0x18, 0x8d, 0x18, 0xff, 0x0d, 0xff, 0x0d, 0x06, 0x03,
	0x06, 0x03, 0xf6, 0xf7, 0xf6, 0xf7, 0x23, 0xed, 0x23, 0xed, 0xe0, 0xe2, 0xe0, 0xe2, 0x7b,
	0xd9, 0x7b, 0xd9, 0x3c, 0xd1, 0x3c, 0xd1, 0x62, 0xca, 0x62, 0xca, 0x20, 0xc5, 0x20, 0xc5,
	0x9f, 0xc1, 0x9f, 0xc1, 0xfa, 0xbf, 0xfa, 0xbf, 0x3c, 0xc0, 0x3c, 0xc0, 0x65, 0xc2, 0x65,
	0xc2, 0x64, 0xc6, 0x64, 0xc6, 0x1a, 0xcc, 0x1a, 0xcc, 0x5b, 0xd3, 0x5b, 0xd3, 0xf1, 0xdb,
	0xf1, 0xdb, 0x9a, 0xe5, 0x9a, 0xe5, 0x0c, 0xf0, 0x0c, 0xf0, 0xf7, 0xfa, 0xf7, 0xfa, 0x0a,
	0x06, 0x0a, 0x06, 0xee, 0x10, 0xee, 0x10, 0x51, 0x1b, 0x51, 0x1b, 0xe3, 0x24, 0xe3, 0x24,
	0x5d, 0x2d, 0x5d, 0x2d, 0x7c, 0x34, 0x7c, 0x34, 0x0c, 0x3a, 0x0c, 0x3a, 0xe1, 0x3d, 0xe1,
	0x3d, 0xde, 0x3f, 0xde, 0x3f, 0xf4, 0x3f, 0xf4, 0x3f, 0x23, 0x3e, 0x23, 0x3e, 0x78, 0x3a,
	0x78, 0x3a, 0x0f, 0x35, 0x0f, 0x35, 0x12, 0x2e, 0x12, 0x2e, 0xb5, 0x25, 0xb5, 0x25, 0x39,
	0x1c, 0x39, 0x1c, 0xe6, 0x11, 0xe6, 0x11, 0x0a, 0x07, 0x0a, 0x07, 0xf9, 0xfb, 0xf9, 0xfb,
	0x06, 0xf1, 0x06, 0xf1, 0x86, 0xe6, 0x86, 0xe6, 0xc7, 0xdc, 0xc7, 0xdc, 0x16, 0xd4, 0x16,
	0xd4, 0xb3, 0xcc, 0xb3, 0xcc, 0xd7, 0xc6, 0xd7, 0xc6, 0xaf, 0xc2, 0xaf, 0xc2, 0x5b, 0xc0,
	0x5b, 0xc0, 0xeb, 0xbf, 0xeb, 0xbf, 0x65, 0xc1, 0x65, 0xc1, 0xbb, 0xc4, 0xbb, 0xc4, 0xd6,
	0xc9, 0xd6, 0xc9, 0x8d, 0xd0, 0x8d, 0xd0, 0xae, 0xd8, 0xae, 0xd8, 0xfb, 0xe1, 0xfb, 0xe1,
	0x2d, 0xec, 0x2d, 0xec, 0xf6, 0xf6, 0xf6, 0xf6, 0x04, 0x02, 0x04, 0x02, 0x02, 0x0d, 0x02,
	0x0d, 0x9e, 0x17, 0x9e, 0x17, 0x85, 0x21, 0x85, 0x21, 0x6d, 0x2a, 0x6d, 0x2a, 0x11, 0x32,
	0x11, 0x32, 0x38, 0x38, 0x38, 0x38, 0xb1, 0x3c, 0xb1, 0x3c, 0x5d, 0x3f, 0x5d, 0x3f, 0x25,
	0x40, 0x25, 0x40, 0x04, 0x3f, 0x04, 0x3f, 0x03, 0x3c, 0x03, 0x3c, 0x38, 0x37, 0x38, 0x37,
	0xc8, 0x30, 0xc8, 0x30, 0xe4, 0x28, 0xe4, 0x28, 0xc9, 0x1f, 0xc9, 0x1f, 0xbb, 0x15, 0xbb,
	0x15, 0x08, 0x0b, 0x08, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xf4, 0xf8, 0xf4, 0x45, 0xea,
	0x45, 0xea, 0x37, 0xe0, 0x37, 0xe0, 0x1c, 0xd7, 0x1c, 0xd7, 0x38, 0xcf, 0x38, 0xcf, 0xc8,
	0xc8, 0xc8, 0xc8, 0xfd, 0xc3, 0xfd, 0xc3, 0xfc, 0xc0, 0xfc, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf,
	0xa3, 0xc0, 0xa3, 0xc0, 0x4f, 0xc3, 0x4f, 0xc3, 0xc8, 0xc7, 0xc8, 0xc7, 0xef, 0xcd, 0xef,
	0xcd, 0x93, 0xd5, 0x93, 0xd5, 0x7b, 0xde, 0x7b, 0xde, 0x62, 0xe8, 0x62, 0xe8, 0xfe, 0xf2,
	0xfe, 0xf2, 0xfc, 0xfd, 0xfc, 0xfd, 0x0a, 0x09, 0x0a, 0x09, 0xd3, 0x13, 0xd3, 0x13, 0x05,
	0x1e, 0x05, 0x1e, 0x52, 0x27, 0x52, 0x27, 0x73, 0x2f, 0x73, 0x2f, 0x2a, 0x36, 0x2a, 0x36,
	0x45, 0x3b, 0x45, 0x3b, 0x9b, 0x3e, 0x9b, 0x3e, 0x15, 0x40, 0x15, 0x40, 0xa5, 0x3f, 0xa5,
	0x3f, 0x51, 0x3d, 0x51, 0x3d, 0x29, 0x39, 0x29, 0x39, 0x4d, 0x33, 0x4d, 0x33, 0xea, 0x2b,
	0xea, 0x2b, 0x39, 0x23, 0x39, 0x23, 0x7a, 0x19, 0x7a, 0x19, 0xfa, 0x0e, 0xfa, 0x0e, 0x07,
	0x04, 0x07, 0x04, 0xf6, 0xf8, 0xf6, 0xf8, 0x1a, 0xee, 0x1a, 0xee, 0xc7, 0xe3, 0xc7, 0xe3,
	0x4b, 0xda, 0x4b, 0xda, 0xee, 0xd1, 0xee, 0xd1, 0xf1, 0xca, 0xf1, 0xca, 0x88, 0xc5, 0x88,
	0xc5, 0xdd, 0xc1, 0xdd, 0xc1, 0x0c, 0xc0, 0x0c, 0xc0, 0x22, 0xc0, 0x22, 0xc0, 0x1f, 0xc2,
	0x1f, 0xc2, 0xf4, 0xc5, 0xf4, 0xc5, 0x84, 0xcb, 0x84, 0xcb, 0xa3, 0xd2, 0xa3, 0xd2, 0x1d,
	0xdb, 0x1d, 0xdb, 0xaf, 0xe4, 0xaf, 0xe4, 0x12, 0xef, 0x12, 0xef, 0xf6, 0xf9, 0xf6, 0xf9,
	0x09, 0x05, 0x09, 0x05, 0xf4, 0x0f, 0xf4, 0x0f, 0x66, 0x1a, 0x66, 0x1a, 0x0f, 0x24, 0x0f,
	0x24, 0xa5, 0x2c, 0xa5, 0x2c, 0xe6, 0x33, 0xe6, 0x33, 0x9c, 0x39, 0x9c, 0x39, 0x9b, 0x3d,
	0x9b, 0x3d, 0xc4, 0x3f, 0xc4, 0x3f, 0x06, 0x40, 0x06, 0x40, 0x61, 0x3e, 0x61, 0x3e, 0xe0,
	0x3a, 0xe0, 0x3a, 0x9e, 0x35, 0x9e, 0x35, 0xc4, 0x2e, 0xc4, 0x2e, 0x85, 0x26, 0x85, 0x26,
	0x20, 0x1d, 0x20, 0x1d, 0xdd, 0x12, 0xdd, 0x12, 0x0a, 0x08, 0x0a, 0x08, 0xfa, 0xfc, 0xfa,
	0xfc, 0x01, 0xf2, 0x01, 0xf2, 0x73, 0xe7, 0x73, 0xe7, 0xa0, 0xdd, 0xa0, 0xdd, 0xd3, 0xd4,
	0xd3, 0xd4, 0x4f, 0xcd, 0x4f, 0xcd, 0x4e, 0xc7, 0x4e, 0xc7, 0xfd, 0xc2, 0xfd, 0xc2, 0x7d,
	0xc0, 0x7d, 0xc0, 0xe1, 0xbf, 0xe1, 0xbf, 0x2e, 0xc1, 0x2e, 0xc1, 0x5a, 0xc4, 0x5a, 0xc4,
	0x4d, 0xc9, 0x4d, 0xc9, 0xe1, 0xcf, 0xe1, 0xcf, 0xe4, 0xd7, 0xe4, 0xd7, 0x18, 0xe1, 0x18,
	0xe1, 0x38, 0xeb, 0x38, 0xeb, 0xf7, 0xf5, 0xf7, 0xf5, 0x02, 0x01, 0x02, 0x01, 0x05, 0x0c,
	0x05, 0x0c, 0xad, 0x16, 0xad, 0x16, 0xa8, 0x20, 0xa8, 0x20, 0xaa, 0x29, 0xaa, 0x29, 0x6e,
	0x31, 0x6e, 0x31, 0xb9, 0x37, 0xb9, 0x37, 0x5c, 0x3c, 0x5c, 0x3c, 0x32, 0x3f, 0x32, 0x3f,
	0x27, 0x40, 0x27, 0x40, 0x32, 0x3f, 0x32, 0x3f, 0x5c, 0x3c, 0x5c, 0x3c, 0xb9, 0x37, 0xb9,
	0x37, 0x6e, 0x31, 0x6e, 0x31, 0xaa, 0x29, 0xaa, 0x29, 0xa8, 0x20, 0xa8, 0x20, 0xad, 0x16,
	0xad, 0x16, 0x05, 0x0c, 0x05, 0x0c, 0x02, 0x01, 0x02, 0x01, 0xf7, 0xf5, 0xf7, 0xf5, 0x38,
	0xeb, 0x38, 0xeb, 0x18, 0xe1, 0x18, 0xe1, 0xe4, 0xd7, 0xe4, 0xd7, 0xe1, 0xcf, 0xe1, 0xcf,
	0x4d, 0xc9, 0x4d, 0xc9, 0x5a, 0xc4, 0x5a, 0xc4, 0x2e, 0xc1, 0x2e, 0xc1, 0xe1, 0xbf, 0xe1,
	0xbf, 0x7d, 0xc0, 0x7d, 0xc0, 0xfd, 0xc2, 0xfd, 0xc2, 0x4e, 0xc7, 0x4e, 0xc7, 0x4f, 0xcd,
	0x4f, 0xcd, 0xd3, 0xd4, 0xd3, 0xd4, 0xa0, 0xdd, 0xa0, 0xdd, 0x73, 0xe7, 0x73, 0xe7, 0x01,
	0xf2, 0x01, 0xf2, 0xfa, 0xfc, 0xfa, 0xfc, 0x0a, 0x08, 0x0a, 0x08, 0xdd, 0x12, 0xdd, 0x12,
	0x20, 0x1d, 0x20, 0x1d, 0x85, 0x26, 0x85, 0x26, 0xc4, 0x2e, 0xc4, 0x2e, 0x9e, 0x35, 0x9e,
	0x35, 0xe0, 0x3a, 0xe0, 0x3a, 0x61, 0x3e, 0x61, 0x3e, 0x06, 0x40, 0x06, 0x40, 0xc4, 0x3f,
	0xc4, 0x3f, 0x9b, 0x3d, 0x9b, 0x3d, 0x9c, 0x39, 0x9c, 0x39, 0xe6, 0x33, 0xe6, 0x33, 0xa5,
	0x2c, 0xa5, 0x2c, 0x0f, 0x24, 0x0f, 0x24, 0x66, 0x1a, 0x66, 0x1a, 0xf4, 0x0f, 0xf4, 0x0f,
	0x09, 0x05, 0x09, 0x05, 0xf6, 0xf9, 0xf6, 0xf9, 0x12, 0xef, 0x12, 0xef, 0xaf, 0xe4, 0xaf,
	0xe4, 0x1d, 0xdb, 0x1d, 0xdb, 0xa3, 0xd2, 0xa3, 0xd2, 0x84, 0xcb, 0x84, 0xcb, 0xf4, 0xc5,
	0xf4, 0xc5, 0x1f, 0xc2, 0x1f, 0xc2, 0x22, 0xc0, 0x22, 0xc0, 0x0c, 0xc0, 0x0c, 0xc0, 0xdd,
	0xc1, 0xdd, 0xc1, 0x88, 0xc5, 0x88, 0xc5, 0xf1, 0xca, 0xf1, 0xca, 0xee, 0xd1, 0xee, 0xd1,
	0x4b, 0xda, 0x4b, 0xda, 0xc7, 0xe3, 0xc7, 0xe3, 0x1a, 0xee, 0x1a, 0xee, 0xf6, 0xf8, 0xf6,
	0xf8, 0x07, 0x04, 0x07, 0x04, 0xfa, 0x0e, 0xfa, 0x0e, 0x7a, 0x19, 0x7a, 0x19, 0x39, 0x23,
	0x39, 0x23, 0xea, 0x2b, 0xea, 0x2b, 0x4d, 0x33, 0x4d, 0x33, 0x29, 0x39, 0x29, 0x39, 0x51,
	0x3d, 0x51, 0x3d, 0xa5, 0x3f, 0xa5, 0x3f, 0x15, 0x40, 0x15, 0x40, 0x9b, 0x3e, 0x9b, 0x3e,
	0x45, 0x3b, 0x45, 0x3b, 0x2a, 0x36, 0x2a, 0x36, 0x73, 0x2f, 0x73, 0x2f, 0x52, 0x27, 0x52,
	0x27, 0x05, 0x1e, 0x05, 0x1e, 0xd3, 0x13, 0xd3, 0x13, 0x0a, 0x09, 0x0a, 0x09, 0xfc, 0xfd,
	0xfc, 0xfd, 0xfe, 0xf2, 0xfe, 0xf2, 0x62, 0xe8, 0x62, 0xe8, 0x7b, 0xde, 0x7b, 0xde, 0x93,
	0xd5, 0x93, 0xd5, 0xef, 0xcd, 0xef, 0xcd, 0xc8, 0xc7, 0xc8, 0xc7, 0x4f, 0xc3, 0x4f, 0xc3,
	0xa3, 0xc0, 0xa3, 0xc0, 0xdb, 0xbf, 0xdb, 0xbf, 0xfc, 0xc0, 0xfc, 0xc0, 0xfd, 0xc3, 0xfd,
	0xc3, 0xc8, 0xc8, 0xc8, 0xc8, 0x38, 0xcf, 0x38, 0xcf, 0x1c, 0xd7, 0x1c, 0xd7, 0x37, 0xe0,
	0x37, 0xe0, 0x45, 0xea, 0x45, 0xea, 0xf8, 0xf4, 0xf8, 0xf4};

static const unsigned int __16kHz16bit_stereo_sine_pcm_len =
					ARRAY_SIZE(__16kHz16bit_stereo_sine_pcm);

#endif /* SINE_H_ */
