/*
 * Copyright (c) 2021 Intel Corporation.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @file
 * @brief Virtual Interface Management interface public header
 */

#ifndef ZEPHYR_INCLUDE_NET_VIRTUAL_MGMT_H_
#define ZEPHYR_INCLUDE_NET_VIRTUAL_MGMT_H_

#include <zephyr/net/virtual.h>
#include <zephyr/net/net_mgmt.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief Virtual interface library
 * @defgroup virtual_mgmt Virtual Interface Library
 * @since 2.6
 * @version 0.8.0
 * @ingroup networking
 * @{
 */

/** @cond INTERNAL_HIDDEN */

#define NET_VIRTUAL_INTERFACE_LAYER	NET_MGMT_LAYER_L2
#define NET_VIRTUAL_INTERFACE_CODE	NET_MGMT_LAYER_CODE_VIRTUAL
#define NET_VIRTUAL_INTERFACE_BASE					\
	(NET_MGMT_IFACE_BIT |						\
	 NET_MGMT_LAYER(NET_VIRTUAL_INTERFACE_LAYER) |			\
	 NET_MGMT_LAYER_CODE(NET_VIRTUAL_INTERFACE_CODE))
#define NET_VIRTUAL_INTERFACE_EVENT					\
	(NET_VIRTUAL_INTERFACE_BASE | NET_MGMT_EVENT_BIT)

struct virtual_interface_req_params {
	sa_family_t family;
	union {
		struct in_addr peer4addr;
		struct in6_addr peer6addr;
		int mtu;
		struct virtual_interface_link_types link_types;
		struct {
			size_t len;
			uint8_t *data;
		} private_key;
		struct {
			size_t len;
			uint8_t data[NET_VIRTUAL_MAX_PUBLIC_KEY_LEN];
		} public_key;
	};
};

enum net_request_virtual_interface_cmd {
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_PEER_ADDR = 1,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_PEER_ADDR,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_MTU,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_MTU,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_LINK_TYPE,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_LINK_TYPE,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_PRIVATE_KEY,
	NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_PUBLIC_KEY,
};

#define NET_REQUEST_VIRTUAL_INTERFACE_SET_PEER_ADDRESS		\
	(NET_VIRTUAL_INTERFACE_BASE |				\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_PEER_ADDR)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_SET_PEER_ADDRESS);

#define NET_REQUEST_VIRTUAL_INTERFACE_SET_MTU		\
	(NET_VIRTUAL_INTERFACE_BASE |			\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_MTU)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_SET_MTU);

#define NET_REQUEST_VIRTUAL_INTERFACE_SET_LINK_TYPE	\
	(NET_VIRTUAL_INTERFACE_BASE |			\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_LINK_TYPE)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_SET_LINK_TYPE);

#define NET_REQUEST_VIRTUAL_INTERFACE_GET_PEER_ADDRESS		\
	(NET_VIRTUAL_INTERFACE_BASE |				\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_PEER_ADDR)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_GET_PEER_ADDRESS);

#define NET_REQUEST_VIRTUAL_INTERFACE_GET_MTU		\
	(NET_VIRTUAL_INTERFACE_BASE |			\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_MTU)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_GET_MTU);

#define NET_REQUEST_VIRTUAL_INTERFACE_GET_LINK_TYPE	\
	(NET_VIRTUAL_INTERFACE_BASE |			\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_LINK_TYPE)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_GET_LINK_TYPE);

#define NET_REQUEST_VIRTUAL_INTERFACE_SET_PRIVATE_KEY		\
	(NET_VIRTUAL_INTERFACE_BASE |				\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_SET_PRIVATE_KEY)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_SET_PRIVATE_KEY);

#define NET_REQUEST_VIRTUAL_INTERFACE_GET_PUBLIC_KEY		\
	(NET_VIRTUAL_INTERFACE_BASE |				\
	 NET_REQUEST_VIRTUAL_INTERFACE_CMD_GET_PUBLIC_KEY)

NET_MGMT_DEFINE_REQUEST_HANDLER(NET_REQUEST_VIRTUAL_INTERFACE_GET_PUBLIC_KEY);

struct net_if;

/** @endcond */

/**
 * @}
 */

#ifdef __cplusplus
}
#endif

#endif /* ZEPHYR_INCLUDE_NET_VIRTUAL_MGMT_H_ */
