/*
 * Copyright (c) 2024 Intel Corporation
 * Copyright (c) 2025 Croxel, Inc.
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42688P_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42688P_H_

#include "icm4268x.h"

/**
 * @defgroup icm42688 Invensense (TDK) ICM42688 DT Options
 * @ingroup sensor_interface
 * @{
 */

/**
 * @defgroup icm42688_accel_power_modes Accelerometer power modes
 * @{
 */
#define ICM42688_DT_ACCEL_OFF		ICM4268X_DT_ACCEL_OFF
#define ICM42688_DT_ACCEL_LP		ICM4268X_DT_ACCEL_LP
#define ICM42688_DT_ACCEL_LN		ICM4268X_DT_ACCEL_LN
/** @} */

/**
 * @defgroup icm42688_gyro_power_modes Gyroscope power modes
 * @{
 */
#define ICM42688_DT_GYRO_OFF		ICM4268X_DT_GYRO_OFF
#define ICM42688_DT_GYRO_STANDBY	ICM4268X_DT_GYRO_STANDBY
#define ICM42688_DT_GYRO_LN		ICM4268X_DT_GYRO_LN
/** @} */

/**
 * @defgroup icm42688_accel_scale Accelerometer scale options
 * @{
 */
#define ICM42688_DT_ACCEL_FS_16	0
#define ICM42688_DT_ACCEL_FS_8		1
#define ICM42688_DT_ACCEL_FS_4		2
#define ICM42688_DT_ACCEL_FS_2		3
/** @} */

/**
 * @defgroup icm42688_gyro_scale Gyroscope scale options
 * @{
 */
#define ICM42688_DT_GYRO_FS_2000		0
#define ICM42688_DT_GYRO_FS_1000		1
#define ICM42688_DT_GYRO_FS_500		2
#define ICM42688_DT_GYRO_FS_250		3
#define ICM42688_DT_GYRO_FS_125		4
#define ICM42688_DT_GYRO_FS_62_5		5
#define ICM42688_DT_GYRO_FS_31_25		6
#define ICM42688_DT_GYRO_FS_15_625		7
/** @} */

/**
 * @defgroup icm42688_accel_data_rate Accelerometer data rate options
 * @{
 */
#define ICM42688_DT_ACCEL_ODR_32000		ICM4268X_DT_ACCEL_ODR_32000
#define ICM42688_DT_ACCEL_ODR_16000		ICM4268X_DT_ACCEL_ODR_16000
#define ICM42688_DT_ACCEL_ODR_8000		ICM4268X_DT_ACCEL_ODR_8000
#define ICM42688_DT_ACCEL_ODR_4000		ICM4268X_DT_ACCEL_ODR_4000
#define ICM42688_DT_ACCEL_ODR_2000		ICM4268X_DT_ACCEL_ODR_2000
#define ICM42688_DT_ACCEL_ODR_1000		ICM4268X_DT_ACCEL_ODR_1000
#define ICM42688_DT_ACCEL_ODR_200		ICM4268X_DT_ACCEL_ODR_200
#define ICM42688_DT_ACCEL_ODR_100		ICM4268X_DT_ACCEL_ODR_100
#define ICM42688_DT_ACCEL_ODR_50		ICM4268X_DT_ACCEL_ODR_50
#define ICM42688_DT_ACCEL_ODR_25		ICM4268X_DT_ACCEL_ODR_25
#define ICM42688_DT_ACCEL_ODR_12_5		ICM4268X_DT_ACCEL_ODR_12_5
#define ICM42688_DT_ACCEL_ODR_6_25		ICM4268X_DT_ACCEL_ODR_6_25
#define ICM42688_DT_ACCEL_ODR_3_125		ICM4268X_DT_ACCEL_ODR_3_125
#define ICM42688_DT_ACCEL_ODR_1_5625		ICM4268X_DT_ACCEL_ODR_1_5625
#define ICM42688_DT_ACCEL_ODR_500		ICM4268X_DT_ACCEL_ODR_500
/** @} */

/**
 * @defgroup icm42688_gyro_data_rate Gyroscope data rate options
 * @{
 */
#define ICM42688_DT_GYRO_ODR_32000		ICM4268X_DT_GYRO_ODR_32000
#define ICM42688_DT_GYRO_ODR_16000		ICM4268X_DT_GYRO_ODR_16000
#define ICM42688_DT_GYRO_ODR_8000		ICM4268X_DT_GYRO_ODR_8000
#define ICM42688_DT_GYRO_ODR_4000		ICM4268X_DT_GYRO_ODR_4000
#define ICM42688_DT_GYRO_ODR_2000		ICM4268X_DT_GYRO_ODR_2000
#define ICM42688_DT_GYRO_ODR_1000		ICM4268X_DT_GYRO_ODR_1000
#define ICM42688_DT_GYRO_ODR_200		ICM4268X_DT_GYRO_ODR_200
#define ICM42688_DT_GYRO_ODR_100		ICM4268X_DT_GYRO_ODR_100
#define ICM42688_DT_GYRO_ODR_50			ICM4268X_DT_GYRO_ODR_50
#define ICM42688_DT_GYRO_ODR_25			ICM4268X_DT_GYRO_ODR_25
#define ICM42688_DT_GYRO_ODR_12_5		ICM4268X_DT_GYRO_ODR_12_5
#define ICM42688_DT_GYRO_ODR_500		ICM4268X_DT_GYRO_ODR_500
/** @} */

/** @} */

#endif /*ZEPHYR_INCLUDE_DT_BINDINGS_TDK_ICM42688P_H_ */
