/*
 * Copyright (c) 2025 Nuvoton Technology Corporation.
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_RESET_NUMAKER_M55M1X_RESET_H
#define ZEPHYR_INCLUDE_DT_BINDINGS_RESET_NUMAKER_M55M1X_RESET_H

/* Beginning of M55M1 BSP sys_reg.h reset module copy */

#define SYS_RSTCTL_CHIPRST_Pos           0
#define SYS_RSTCTL_NPURST_Pos            6
#define SYS_ACMPRST_ACMP01RST_Pos        0
#define SYS_ACMPRST_ACMP23RST_Pos        1
#define SYS_AWFRST_AWF0RST_Pos           0
#define SYS_BPWMRST_BPWM0RST_Pos         0
#define SYS_BPWMRST_BPWM1RST_Pos         1
#define SYS_CANFDRST_CANFD0RST_Pos       0
#define SYS_CANFDRST_CANFD1RST_Pos       1
#define SYS_CCAPRST_CCAP0RST_Pos         0
#define SYS_CRCRST_CRC0RST_Pos           0
#define SYS_CRYPTORST_CRYPTO0RST_Pos     0
#define SYS_DACRST_DAC01RST_Pos          0
#define SYS_DMICRST_DMIC0RST_Pos         0
#define SYS_EADCRST_EADC0RST_Pos         0
#define SYS_EBIRST_EBI0RST_Pos           0
#define SYS_ECAPRST_ECAP0RST_Pos         0
#define SYS_ECAPRST_ECAP1RST_Pos         1
#define SYS_ECAPRST_ECAP2RST_Pos         2
#define SYS_ECAPRST_ECAP3RST_Pos         3
#define SYS_EMACRST_EMAC0RST_Pos         0
#define SYS_EPWMRST_EPWM0RST_Pos         0
#define SYS_EPWMRST_EPWM1RST_Pos         1
#define SYS_EQEIRST_EQEI0RST_Pos         0
#define SYS_EQEIRST_EQEI1RST_Pos         1
#define SYS_EQEIRST_EQEI2RST_Pos         2
#define SYS_EQEIRST_EQEI3RST_Pos         3
#define SYS_FMCRST_FMC0RST_Pos           0
#define SYS_GDMARST_GDMA0RST_Pos         0
#define SYS_GPIORST_GPIO0RST_Pos         0
#define SYS_HSOTGRST_HSOTG0RST_Pos       0
#define SYS_HSUSBDRST_HSUSBD0RST_Pos     0
#define SYS_HSUSBHRST_HSUSBH0RST_Pos     0
#define SYS_I2CRST_I2C0RST_Pos           0
#define SYS_I2CRST_I2C1RST_Pos           1
#define SYS_I2CRST_I2C2RST_Pos           2
#define SYS_I2CRST_I2C3RST_Pos           3
#define SYS_I2SRST_I2S0RST_Pos           0
#define SYS_I2SRST_I2S1RST_Pos           1
#define SYS_I3CRST_I3C0RST_Pos           0
#define SYS_KDFRST_KDF0RST_Pos           0
#define SYS_KPIRST_KPI0RST_Pos           0
#define SYS_KSRST_KS0RST_Pos             0
#define SYS_LPADCRST_LPADC0RST_Pos       0
#define SYS_LPPDMARST_LPPDMA0RST_Pos     0
#define SYS_LPGPIORST_LPGPIO0RST_Pos     0
#define SYS_LPI2CRST_LPI2C0RST_Pos       0
#define SYS_LPSPIRST_LPSPI0RST_Pos       0
#define SYS_LPTMRRST_LPTMR0RST_Pos       0
#define SYS_LPTMRRST_LPTMR1RST_Pos       1
#define SYS_LPUARTRST_LPUART0RST_Pos     0
#define SYS_OTFCRST_OTFC0RST_Pos         0
#define SYS_OTGRST_OTG0RST_Pos           0
#define SYS_PDMARST_PDMA0RST_Pos         0
#define SYS_PDMARST_PDMA1RST_Pos         1
#define SYS_PSIORST_PSIO0RST_Pos         0
#define SYS_QSPIRST_QSPI0RST_Pos         0
#define SYS_QSPIRST_QSPI1RST_Pos         1
#define SYS_RTCRST_RTC0RST_Pos           0
#define SYS_SCRST_SC0RST_Pos             0
#define SYS_SCRST_SC1RST_Pos             1
#define SYS_SCRST_SC2RST_Pos             2
#define SYS_SCURST_SCU0RST_Pos           0
#define SYS_SDHRST_SDH0RST_Pos           0
#define SYS_SDHRST_SDH1RST_Pos           1
#define SYS_SPIRST_SPI0RST_Pos           0
#define SYS_SPIRST_SPI1RST_Pos           1
#define SYS_SPIRST_SPI2RST_Pos           2
#define SYS_SPIRST_SPI3RST_Pos           3
#define SYS_SPIMRST_SPIM0RST_Pos         0
#define SYS_TMRRST_TMR0RST_Pos           0
#define SYS_TMRRST_TMR1RST_Pos           1
#define SYS_TMRRST_TMR2RST_Pos           2
#define SYS_TMRRST_TMR3RST_Pos           3
#define SYS_TRNGRST_TRNG0RST_Pos         0
#define SYS_TTMRRST_TTMR0RST_Pos         0
#define SYS_TTMRRST_TTMR1RST_Pos         1
#define SYS_UARTRST_UART0RST_Pos         0
#define SYS_UARTRST_UART1RST_Pos         1
#define SYS_UARTRST_UART2RST_Pos         2
#define SYS_UARTRST_UART3RST_Pos         3
#define SYS_UARTRST_UART4RST_Pos         4
#define SYS_UARTRST_UART5RST_Pos         5
#define SYS_UARTRST_UART6RST_Pos         6
#define SYS_UARTRST_UART7RST_Pos         7
#define SYS_UARTRST_UART8RST_Pos         8
#define SYS_UARTRST_UART9RST_Pos         9
#define SYS_USBDRST_USBD0RST_Pos         0
#define SYS_USBHRST_USBH0RST_Pos         0
#define SYS_USCIRST_USCI0RST_Pos         0
#define SYS_UTCPDRST_UTCPD0RST_Pos       0
#define SYS_WWDTRST_WWDT0RST_Pos         0
#define SYS_WWDTRST_WWDT1RST_Pos         1

/* End of M55M1 BSP sys_reg.h reset module copy */

/* Beginning of M55M1 BSP sys.h reset module copy */

/*---------------------------------------------------------------------
 *  Module Reset Control Resister constant definitions.
 *---------------------------------------------------------------------
 */

#define NUMAKER_SYS_ACMP01RST       ((0x200UL<<20) | SYS_ACMPRST_ACMP01RST_Pos)
#define NUMAKER_SYS_ACMP23RST       ((0x200UL<<20) | SYS_ACMPRST_ACMP23RST_Pos)
#define NUMAKER_SYS_AWF0RST         ((0x204UL<<20) | SYS_AWFRST_AWF0RST_Pos)
#define NUMAKER_SYS_BPWM0RST        ((0x208UL<<20) | SYS_BPWMRST_BPWM0RST_Pos)
#define NUMAKER_SYS_BPWM1RST        ((0x208UL<<20) | SYS_BPWMRST_BPWM1RST_Pos)
#define NUMAKER_SYS_CANFD0RST       ((0x20CUL<<20) | SYS_CANFDRST_CANFD0RST_Pos)
#define NUMAKER_SYS_CANFD1RST       ((0x20CUL<<20) | SYS_CANFDRST_CANFD1RST_Pos)
#define NUMAKER_SYS_CCAP0RST        ((0x210UL<<20) | SYS_CCAPRST_CCAP0RST_Pos)
#define NUMAKER_SYS_CRC0RST         ((0x214UL<<20) | SYS_CRCRST_CRC0RST_Pos)
#define NUMAKER_SYS_CRYPTO0RST      ((0x218UL<<20) | SYS_CRYPTORST_CRYPTO0RST_Pos)
#define NUMAKER_SYS_DAC01RST        ((0x21CUL<<20) | SYS_DACRST_DAC01RST_Pos)
#define NUMAKER_SYS_DMIC0RST        ((0x220UL<<20) | SYS_DMICRST_DMIC0RST_Pos)
#define NUMAKER_SYS_EADC0RST        ((0x224UL<<20) | SYS_EADCRST_EADC0RST_Pos)
#define NUMAKER_SYS_EBI0RST         ((0x228UL<<20) | SYS_EBIRST_EBI0RST_Pos)
#define NUMAKER_SYS_ECAP0RST        ((0x22CUL<<20) | SYS_ECAPRST_ECAP0RST_Pos)
#define NUMAKER_SYS_ECAP1RST        ((0x22CUL<<20) | SYS_ECAPRST_ECAP1RST_Pos)
#define NUMAKER_SYS_ECAP2RST        ((0x22CUL<<20) | SYS_ECAPRST_ECAP2RST_Pos)
#define NUMAKER_SYS_ECAP3RST        ((0x22CUL<<20) | SYS_ECAPRST_ECAP3RST_Pos)
#define NUMAKER_SYS_EMAC0RST        ((0x230UL<<20) | SYS_EMACRST_EMAC0RST_Pos)
#define NUMAKER_SYS_EPWM0RST        ((0x234UL<<20) | SYS_EPWMRST_EPWM0RST_Pos)
#define NUMAKER_SYS_EPWM1RST        ((0x234UL<<20) | SYS_EPWMRST_EPWM1RST_Pos)
#define NUMAKER_SYS_EQEI0RST        ((0x238UL<<20) | SYS_EQEIRST_EQEI0RST_Pos)
#define NUMAKER_SYS_EQEI1RST        ((0x238UL<<20) | SYS_EQEIRST_EQEI1RST_Pos)
#define NUMAKER_SYS_EQEI2RST        ((0x238UL<<20) | SYS_EQEIRST_EQEI2RST_Pos)
#define NUMAKER_SYS_EQEI3RST        ((0x238UL<<20) | SYS_EQEIRST_EQEI3RST_Pos)
#define NUMAKER_SYS_FMC0RST         ((0x23CUL<<20) | SYS_FMCRST_FMC0RST_Pos)
#define NUMAKER_SYS_GDMA0RST        ((0x240UL<<20) | SYS_GDMARST_GDMA0RST_Pos)
#define NUMAKER_SYS_GPIO0RST        ((0x244UL<<20) | SYS_GPIORST_GPIO0RST_Pos)
#define NUMAKER_SYS_HSOTG0RST       ((0x248UL<<20) | SYS_HSOTGRST_HSOTG0RST_Pos)
#define NUMAKER_SYS_HSUSBD0RST      ((0x24CUL<<20) | SYS_HSUSBDRST_HSUSBD0RST_Pos)
#define NUMAKER_SYS_HSUSBH0RST      ((0x250UL<<20) | SYS_HSUSBHRST_HSUSBH0RST_Pos)
#define NUMAKER_SYS_I2C0RST         ((0x254UL<<20) | SYS_I2CRST_I2C0RST_Pos)
#define NUMAKER_SYS_I2C1RST         ((0x254UL<<20) | SYS_I2CRST_I2C1RST_Pos)
#define NUMAKER_SYS_I2C2RST         ((0x254UL<<20) | SYS_I2CRST_I2C2RST_Pos)
#define NUMAKER_SYS_I2C3RST         ((0x254UL<<20) | SYS_I2CRST_I2C3RST_Pos)
#define NUMAKER_SYS_I2S0RST         ((0x258UL<<20) | SYS_I2SRST_I2S0RST_Pos)
#define NUMAKER_SYS_I2S1RST         ((0x258UL<<20) | SYS_I2SRST_I2S1RST_Pos)
#define NUMAKER_SYS_I3C0RST         ((0x25CUL<<20) | SYS_I3CRST_I3C0RST_Pos)
#define NUMAKER_SYS_KDF0RST         ((0x260UL<<20) | SYS_KDFRST_KDF0RST_Pos)
#define NUMAKER_SYS_KPI0RST         ((0x264UL<<20) | SYS_KPIRST_KPI0RST_Pos)
#define NUMAKER_SYS_KS0RST          ((0x268UL<<20) | SYS_KSRST_KS0RST_Pos)
#define NUMAKER_SYS_LPADC0RST       ((0x26CUL<<20) | SYS_LPADCRST_LPADC0RST_Pos)
#define NUMAKER_SYS_LPPDMA0RST      ((0x270UL<<20) | SYS_LPPDMARST_LPPDMA0RST_Pos)
#define NUMAKER_SYS_LPGPIO0RST      ((0x274UL<<20) | SYS_LPGPIORST_LPGPIO0RST_Pos)
#define NUMAKER_SYS_LPI2C0RST       ((0x278UL<<20) | SYS_LPI2CRST_LPI2C0RST_Pos)
#define NUMAKER_SYS_LPSPI0RST       ((0x27CUL<<20) | SYS_LPSPIRST_LPSPI0RST_Pos)
#define NUMAKER_SYS_LPTMR0RST       ((0x280UL<<20) | SYS_LPTMRRST_LPTMR0RST_Pos)
#define NUMAKER_SYS_LPTMR1RST       ((0x280UL<<20) | SYS_LPTMRRST_LPTMR1RST_Pos)
#define NUMAKER_SYS_LPUART0RST      ((0x284UL<<20) | SYS_LPUARTRST_LPUART0RST_Pos)
#define NUMAKER_SYS_NPURST          ((0x004UL<<20) | SYS_RSTCTL_NPURST_Pos)
#define NUMAKER_SYS_OTFC0RST        ((0x288UL<<20) | SYS_OTFCRST_OTFC0RST_Pos)
#define NUMAKER_SYS_OTG0RST         ((0x28CUL<<20) | SYS_OTGRST_OTG0RST_Pos)
#define NUMAKER_SYS_PDMA0RST        ((0x290UL<<20) | SYS_PDMARST_PDMA0RST_Pos)
#define NUMAKER_SYS_PDMA1RST        ((0x290UL<<20) | SYS_PDMARST_PDMA1RST_Pos)
#define NUMAKER_SYS_PSIO0RST        ((0x294UL<<20) | SYS_PSIORST_PSIO0RST_Pos)
#define NUMAKER_SYS_QSPI0RST        ((0x298UL<<20) | SYS_QSPIRST_QSPI0RST_Pos)
#define NUMAKER_SYS_QSPI1RST        ((0x298UL<<20) | SYS_QSPIRST_QSPI1RST_Pos)
#define NUMAKER_SYS_RTC0RST         ((0x29CUL<<20) | SYS_RTCRST_RTC0RST_Pos)
#define NUMAKER_SYS_SC0RST          ((0x2A0UL<<20) | SYS_SCRST_SC0RST_Pos)
#define NUMAKER_SYS_SC1RST          ((0x2A0UL<<20) | SYS_SCRST_SC1RST_Pos)
#define NUMAKER_SYS_SC2RST          ((0x2A0UL<<20) | SYS_SCRST_SC2RST_Pos)
#define NUMAKER_SYS_SCU0RST         ((0x2A4UL<<20) | SYS_SCURST_SCU0RST_Pos)
#define NUMAKER_SYS_SDH0RST         ((0x2A8UL<<20) | SYS_SDHRST_SDH0RST_Pos)
#define NUMAKER_SYS_SDH1RST         ((0x2A8UL<<20) | SYS_SDHRST_SDH1RST_Pos)
#define NUMAKER_SYS_SPI0RST         ((0x2ACUL<<20) | SYS_SPIRST_SPI0RST_Pos)
#define NUMAKER_SYS_SPI1RST         ((0x2ACUL<<20) | SYS_SPIRST_SPI1RST_Pos)
#define NUMAKER_SYS_SPI2RST         ((0x2ACUL<<20) | SYS_SPIRST_SPI2RST_Pos)
#define NUMAKER_SYS_SPI3RST         ((0x2ACUL<<20) | SYS_SPIRST_SPI3RST_Pos)
#define NUMAKER_SYS_SPIM0RST        ((0x2B0UL<<20) | SYS_SPIMRST_SPIM0RST_Pos)
#define NUMAKER_SYS_TMR0RST         ((0x2C0UL<<20) | SYS_TMRRST_TMR0RST_Pos)
#define NUMAKER_SYS_TMR1RST         ((0x2C0UL<<20) | SYS_TMRRST_TMR1RST_Pos)
#define NUMAKER_SYS_TMR2RST         ((0x2C0UL<<20) | SYS_TMRRST_TMR2RST_Pos)
#define NUMAKER_SYS_TMR3RST         ((0x2C0UL<<20) | SYS_TMRRST_TMR3RST_Pos)
#define NUMAKER_SYS_TRNG0RST        ((0x2C4UL<<20) | SYS_TRNGRST_TRNG0RST_Pos)
#define NUMAKER_SYS_TTMR0RST        ((0x2C8UL<<20) | SYS_TTMRRST_TTMR0RST_Pos)
#define NUMAKER_SYS_TTMR1RST        ((0x2C8UL<<20) | SYS_TTMRRST_TTMR1RST_Pos)
#define NUMAKER_SYS_UART0RST        ((0x2CCUL<<20) | SYS_UARTRST_UART0RST_Pos)
#define NUMAKER_SYS_UART1RST        ((0x2CCUL<<20) | SYS_UARTRST_UART1RST_Pos)
#define NUMAKER_SYS_UART2RST        ((0x2CCUL<<20) | SYS_UARTRST_UART2RST_Pos)
#define NUMAKER_SYS_UART3RST        ((0x2CCUL<<20) | SYS_UARTRST_UART3RST_Pos)
#define NUMAKER_SYS_UART4RST        ((0x2CCUL<<20) | SYS_UARTRST_UART4RST_Pos)
#define NUMAKER_SYS_UART5RST        ((0x2CCUL<<20) | SYS_UARTRST_UART5RST_Pos)
#define NUMAKER_SYS_UART6RST        ((0x2CCUL<<20) | SYS_UARTRST_UART6RST_Pos)
#define NUMAKER_SYS_UART7RST        ((0x2CCUL<<20) | SYS_UARTRST_UART7RST_Pos)
#define NUMAKER_SYS_UART8RST        ((0x2CCUL<<20) | SYS_UARTRST_UART8RST_Pos)
#define NUMAKER_SYS_UART9RST        ((0x2CCUL<<20) | SYS_UARTRST_UART9RST_Pos)
#define NUMAKER_SYS_USBD0RST        ((0x2D0UL<<20) | SYS_USBDRST_USBD0RST_Pos)
#define NUMAKER_SYS_USBH0RST        ((0x2D4UL<<20) | SYS_USBHRST_USBH0RST_Pos)
#define NUMAKER_SYS_USCI0RST        ((0x2D8UL<<20) | SYS_USCIRST_USCI0RST_Pos)
#define NUMAKER_SYS_UTCPD0RST       ((0x2DCUL<<20) | SYS_UTCPDRST_UTCPD0RST_Pos)
#define NUMAKER_SYS_WWDT0RST        ((0x2E0UL<<20) | SYS_WWDTRST_WWDT0RST_Pos)
#define NUMAKER_SYS_WWDT1RST        ((0x2E0UL<<20) | SYS_WWDTRST_WWDT1RST_Pos)

/* End of M55M1 BSP sys.h reset module copy */

#endif
