/*
 * Copyright (c) 2025 Renesas Electronics Corporation
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_RZV2H_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_RZV2H_H_

/* Superset list of all possible IO ports. */
#define PORT_00 0x0000 /* IO port 0 */
#define PORT_01 0x0100 /* IO port 1 */
#define PORT_02 0x0200 /* IO port 2 */
#define PORT_03 0x0300 /* IO port 3 */
#define PORT_04 0x0400 /* IO port 4 */
#define PORT_05 0x0500 /* IO port 5 */
#define PORT_06 0x0600 /* IO port 6 */
#define PORT_07 0x0700 /* IO port 7 */
#define PORT_08 0x0800 /* IO port 8 */
#define PORT_09 0x0900 /* IO port 9 */
#define PORT_10 0x0A00 /* IO port 10 */
#define PORT_11 0x0B00 /* IO port 11 */

/*
 * Create the value contain port/pin/function information
 *
 * port: port number BSP_IO_PORT_00..BSP_IO_PORT_11
 * pin: pin number
 * func: pin function
 */
#define RZV_PINMUX(port, pin, func) (port | pin | (func << 4))

/* Special purpose port */
#define BSP_IO_NMI 0xFFFF0100 /* NMI */

#define BSP_IO_TMS_SWDIO 0xFFFF0300 /* TMS_SWDIO */

#define BSP_IO_TDO 0xFFFF0302 /* TDO */

#define BSP_IO_WDTUDFCA 0xFFFF0500 /* WDTUDFCA */
#define BSP_IO_WDTUDFCM 0xFFFF0501 /* WDTUDFCM */

#define BSP_IO_SCIF_RXD 0xFFFF0600 /* SCIF_RXD */
#define BSP_IO_SCIF_TXD 0xFFFF0601 /* SCIF_TXD */

#define BSP_IO_XSPI0_CKP     0xFFFF0700 /* XSPI0_CKP */
#define BSP_IO_XSPI0_CKN     0xFFFF0701 /* XSPI0_CKN */
#define BSP_IO_XSPI0_CS0N    0xFFFF0702 /* XSPI0_CS0N */
#define BSP_IO_XSPI0_DS      0xFFFF0703 /* XSPI0_DS */
#define BSP_IO_XSPI0_RESET0N 0xFFFF0704 /* XSPI0_RESET0N */
#define BSP_IO_XSPI0_RSTO0N  0xFFFF0705 /* XSPI0_RSTO0N */
#define BSP_IO_XSPI0_INT0N   0xFFFF0706 /* XSPI0_INT0N */
#define BSP_IO_XSPI0_ECS0N   0xFFFF0707 /* XSPI0_ECS0N */

#define BSP_IO_XSPI0_IO0 0xFFFF0800 /* XSPI0_IO0 */
#define BSP_IO_XSPI0_IO1 0xFFFF0801 /* XSPI0_IO1 */
#define BSP_IO_XSPI0_IO2 0xFFFF0802 /* XSPI0_IO2 */
#define BSP_IO_XSPI0_IO3 0xFFFF0803 /* XSPI0_IO3 */
#define BSP_IO_XSPI0_IO4 0xFFFF0804 /* XSPI0_IO4 */
#define BSP_IO_XSPI0_IO5 0xFFFF0805 /* XSPI0_IO5 */
#define BSP_IO_XSPI0_IO6 0xFFFF0806 /* XSPI0_IO6 */
#define BSP_IO_XSPI0_IO7 0xFFFF0807 /* XSPI0_IO7 */

#define BSP_IO_SD0CLK  0xFFFF0900 /* SD0CLK */
#define BSP_IO_SD0CMD  0xFFFF0901 /* SD0CMD */
#define BSP_IO_SD0RSTN 0xFFFF0902 /* SD0RSTN */

#define BSP_IO_SD0DAT0 0xFFFF0A00 /* SD0DAT0 */
#define BSP_IO_SD0DAT1 0xFFFF0A01 /* SD0DAT1 */
#define BSP_IO_SD0DAT2 0xFFFF0A02 /* SD0DAT2 */
#define BSP_IO_SD0DAT3 0xFFFF0A03 /* SD0DAT3 */
#define BSP_IO_SD0DAT4 0xFFFF0A04 /* SD0DAT4 */
#define BSP_IO_SD0DAT5 0xFFFF0A05 /* SD0DAT5 */
#define BSP_IO_SD0DAT6 0xFFFF0A06 /* SD0DAT6 */
#define BSP_IO_SD0DAT7 0xFFFF0A07 /* SD0DAT7 */

#define BSP_IO_SD1CLK 0xFFFF0B00 /* SD1CLK */
#define BSP_IO_SD1CMD 0xFFFF0B01 /* SD1CMD */

#define BSP_IO_SD1DAT0 0xFFFF0C00 /* SD1DAT0 */
#define BSP_IO_SD1DAT1 0xFFFF0C01 /* SD1DAT1 */
#define BSP_IO_SD1DAT2 0xFFFF0C02 /* SD1DAT2 */
#define BSP_IO_SD1DAT3 0xFFFF0C03 /* SD1DAT3 */

#define BSP_IO_PCIE0_RSTOUTB 0xFFFF0E00 /* PCIE0_RSTOUTB */
#define BSP_IO_PCIE1_RSTOUTB 0xFFFF0E01 /* PCIE1_RSTOUTB */

#define BSP_IO_ET0_MDIO 0xFFFF0F00 /* ET0_MDIO */
#define BSP_IO_ET0_MDC  0xFFFF0F01 /* ET0_MDC */

#define BSP_IO_ET0_RXCTL_RXDV 0xFFFF1000 /* ET0_RXCTL_RXDV */
#define BSP_IO_ET0_TXCTL_TXEN 0xFFFF1001 /* ET0_TXCTL_TXEN */
#define BSP_IO_ET0_TXER       0xFFFF1002 /* ET0_TXER */
#define BSP_IO_ET0_RXER       0xFFFF1003 /* ET0_RXER */
#define BSP_IO_ET0_RXC_RXCLK  0xFFFF1004 /* ET0_RXC_RXCLK */
#define BSP_IO_ET0_TXC_TXCLK  0xFFFF1005 /* ET0_TXC_TXCLK */
#define BSP_IO_ET0_CRS        0xFFFF1006 /* ET0_CRS */
#define BSP_IO_ET0_COL        0xFFFF1007 /* ET0_COL */

#define BSP_IO_ET0_TXD0 0xFFFF1100 /* ET0_TXD0 */
#define BSP_IO_ET0_TXD1 0xFFFF1101 /* ET0_TXD1 */
#define BSP_IO_ET0_TXD2 0xFFFF1102 /* ET0_TXD2 */
#define BSP_IO_ET0_TXD3 0xFFFF1103 /* ET0_TXD3 */
#define BSP_IO_ET0_RXD0 0xFFFF1104 /* ET0_RXD0 */
#define BSP_IO_ET0_RXD1 0xFFFF1105 /* ET0_RXD1 */
#define BSP_IO_ET0_RXD2 0xFFFF1106 /* ET0_RXD2 */
#define BSP_IO_ET0_RXD3 0xFFFF1107 /* ET0_RXD3 */

#define BSP_IO_ET1_MDIO 0xFFFF1200 /* ET1_MDIO */
#define BSP_IO_ET1_MDC  0xFFFF1201 /* ET1_MDC */

#define BSP_IO_ET1_RXCTL_RXDV 0xFFFF1300 /* ET1_RXCTL_RXDV */
#define BSP_IO_ET1_TXCTL_TXEN 0xFFFF1301 /* ET1_TXCTL_TXEN */
#define BSP_IO_ET1_TXER       0xFFFF1302 /* ET1_TXER */
#define BSP_IO_ET1_RXER       0xFFFF1303 /* ET1_RXER */
#define BSP_IO_ET1_RXC_RXCLK  0xFFFF1304 /* ET1_RXC_RXCLK */
#define BSP_IO_ET1_TXC_TXCLK  0xFFFF1305 /* ET1_TXC_TXCLK */
#define BSP_IO_ET1_CRS        0xFFFF1306 /* ET1_CRS */
#define BSP_IO_ET1_COL        0xFFFF1307 /* ET1_COL */

#define BSP_IO_ET1_TXD0 0xFFFF1400 /* ET1_TXD0 */
#define BSP_IO_ET1_TXD1 0xFFFF1401 /* ET1_TXD1 */
#define BSP_IO_ET1_TXD2 0xFFFF1402 /* ET1_TXD2 */
#define BSP_IO_ET1_TXD3 0xFFFF1403 /* ET1_TXD3 */
#define BSP_IO_ET1_RXD0 0xFFFF1404 /* ET1_RXD0 */
#define BSP_IO_ET1_RXD1 0xFFFF1405 /* ET1_RXD1 */
#define BSP_IO_ET1_RXD2 0xFFFF1406 /* ET1_RXD2 */
#define BSP_IO_ET1_RXD3 0xFFFF1407 /* ET1_RXD3 */

/* FILNUM */
#define RZV_FILNUM_4_STAGE  0
#define RZV_FILNUM_8_STAGE  1
#define RZV_FILNUM_12_STAGE 2
#define RZV_FILNUM_16_STAGE 3

/* FILCLKSEL */
#define RZV_FILCLKSEL_NOT_DIV   0
#define RZV_FILCLKSEL_DIV_9000  1
#define RZV_FILCLKSEL_DIV_18000 2
#define RZV_FILCLKSEL_DIV_36000 3

#define RZV_FILTER_SET(filnum, filclksel) (((filnum) & 0x3) << 0x2) | (filclksel & 0x3)

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_RENESAS_PINCTRL_RZV2H_H_ */
