/*
 * Copyright (c) 2024 Antmicro <www.antmicro.com>
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_ZYNQMP_PINCTRL_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_PINCTRL_ZYNQMP_PINCTRL_H_

/*
 * The offset is defined at `pictrl_soc.h` for the ZynqMP platform
 */
#define FUNCTION_OFFSET 8
#define UART_FUNCTION 0x1

/*
 * For functions that can be selected for a subset of MIO pins,
 * specific macro identifiers were generated to avoid complex checking
 * logic at compile time. For more generalized applications existing on
 * every pin (eg. GPIO), a generic macro function to generate a driver-compliant
 * selector value can be used.
 */

#define UART0_RX_2  (2U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_6  (6U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_10 (10U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_14 (14U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_18 (18U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_22 (22U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_26 (26U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_30 (30U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_34 (34U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_38 (38U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_42 (42U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_46 (46U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_50 (50U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_54 (54U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_58 (58U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_62 (62U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_66 (66U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_70 (70U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_RX_74 (74U | (UART_FUNCTION << FUNCTION_OFFSET))

#define UART0_TX_3  (3U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_7  (7U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_11 (11U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_15 (15U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_19 (19U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_23 (23U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_27 (27U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_31 (31U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_35 (35U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_39 (39U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_43 (43U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_47 (47U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_51 (51U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_55 (55U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_59 (59U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_63 (63U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_67 (67U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_71 (71U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART0_TX_75 (75U | (UART_FUNCTION << FUNCTION_OFFSET))

#define UART1_RX_1  (1U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_5  (5U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_9  (9U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_13 (13U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_17 (17U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_21 (21U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_25 (25U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_29 (29U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_33 (33U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_37 (37U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_41 (41U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_45 (45U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_49 (49U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_53 (53U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_57 (57U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_61 (61U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_65 (65U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_69 (69U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_RX_73 (73U | (UART_FUNCTION << FUNCTION_OFFSET))

#define UART1_TX_0  (0U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_4  (4U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_8  (8U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_12 (12U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_16 (16U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_20 (20U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_24 (24U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_28 (28U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_32 (32U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_36 (36U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_40 (40U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_44 (44U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_48 (28U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_52 (52U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_56 (56U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_60 (60U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_64 (64U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_68 (28U | (UART_FUNCTION << FUNCTION_OFFSET))
#define UART1_TX_72 (72U | (UART_FUNCTION << FUNCTION_OFFSET))

#endif
