/*
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DT_BINDINGS_MEMORY_CONTROLLER_ADI_MAX32_HPB_H_
#define ZEPHYR_INCLUDE_DT_BINDINGS_MEMORY_CONTROLLER_ADI_MAX32_HPB_H_

#define ADI_MAX32_HPB_CS_HIGH_1_5  0  /**< CS High 1.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_2_5  1  /**< CS High 2.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_3_5  2  /**< CS High 3.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_4_5  3  /**< CS High 4.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_5_5  4  /**< CS High 5.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_6_5  5  /**< CS High 6.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_7_5  6  /**< CS High 7.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_8_5  7  /**< CS High 8.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_9_5  8  /**< CS High 9.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_10_5 9  /**< CS High 10.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_11_5 10 /**< CS High 11.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_12_5 11 /**< CS High 12.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_13_5 12 /**< CS High 13.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_14_5 13 /**< CS High 14.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_15_5 14 /**< CS High 15.5 clock cycles */
#define ADI_MAX32_HPB_CS_HIGH_16_5 15 /**< CS High 16.5 clock cycles */

#define ADI_MAX32_HPB_CS_SETUP_HOLD_1  0  /**< CS Setup/Hold 1 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_2  1  /**< CS Setup/Hold 2 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_3  2  /**< CS Setup/Hold 3 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_4  3  /**< CS Setup/Hold 4 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_5  4  /**< CS Setup/Hold 5 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_6  5  /**< CS Setup/Hold 6 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_7  6  /**< CS Setup/Hold 7 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_8  7  /**< CS Setup/Hold 8 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_9  8  /**< CS Setup/Hold 9 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_10 9  /**< CS Setup/Hold 10 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_11 10 /**< CS Setup/Hold 11 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_12 11 /**< CS Setup/Hold 12 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_13 12 /**< CS Setup/Hold 13 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_14 13 /**< CS Setup/Hold 14 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_15 14 /**< CS Setup/Hold 15 clock cycles */
#define ADI_MAX32_HPB_CS_SETUP_HOLD_16 15 /**< CS Setup/Hold 16 clock cycles */

#define ADI_MAX32_HPB_LAT_5 0x0 /**< 5 clock latency for RAM */
#define ADI_MAX32_HPB_LAT_6 0x1 /**< 6 clock latency for RAM */
#define ADI_MAX32_HPB_LAT_3 0xE /**< 3 clock latency for RAM */
#define ADI_MAX32_HPB_LAT_4 0xF /**< 4 clock latency for RAM */

#define ADI_MAX32_HPB_DEV_TYPE_HYPER_FLASH  0
#define ADI_MAX32_HPB_DEV_TYPE_XCCELA_PSRAM 1
#define ADI_MAX32_HPB_DEV_TYPE_HYPER_RAM    2

#endif /* ZEPHYR_INCLUDE_DT_BINDINGS_MEMORY_CONTROLLER_ADI_MAX32_HPB_H_ */
