/*
 * Copyright (c) 2025 Core Devices LLC
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef _INCLUDE_ZEPHYR_DT_BINDINGS_CLOCK_SF32LB52X_CLOCKS_H_
#define _INCLUDE_ZEPHYR_DT_BINDINGS_CLOCK_SF32LB52X_CLOCKS_H_

#include "sf32lb-clocks-common.h"

/**
 * @name Register offsets
 * @{
 */

#define SF32LB52X_RCC_ENR1 0x08U
#define SF32LB52X_RCC_ENR2 0x0CU

/** @} */

/**
 * @name Clock enable/disable definitions for peripherals
 * @{
 */

#define SF32LB52X_CLOCK_DMAC1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 0U)
#define SF32LB52X_CLOCK_MAILBOX1 SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 1U)
#define SF32LB52X_CLOCK_PINMUX1  SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 2U)
#define SF32LB52X_CLOCK_USART2   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 4U)
#define SF32LB52X_CLOCK_EZIP1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 5U)
#define SF32LB52X_CLOCK_EPIC     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 6U)
#define SF32LB52X_CLOCK_LCDC1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 7U)
#define SF32LB52X_CLOCK_I2S1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 8U)
#define SF32LB52X_CLOCK_SYSCFG1  SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 10U)
#define SF32LB52X_CLOCK_EFUSEC   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 11U)
#define SF32LB52X_CLOCK_AES      SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 12U)
#define SF32LB52X_CLOCK_CRC1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 13U)
#define SF32LB52X_CLOCK_TRNG     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 14U)
#define SF32LB52X_CLOCK_GPTIM1   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 15U)
#define SF32LB52X_CLOCK_GPTIM2   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 16U)
#define SF32LB52X_CLOCK_BTIM1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 17U)
#define SF32LB52X_CLOCK_BTIM2    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 18U)
#define SF32LB52X_CLOCK_SPI1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 20U)
#define SF32LB52X_CLOCK_SPI2     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 21U)
#define SF32LB52X_CLOCK_EXTDMA   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 22U)
#define SF32LB52X_CLOCK_SECU1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 23U)
#define SF32LB52X_CLOCK_PDM1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 25U)
#define SF32LB52X_CLOCK_I2C1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 27U)
#define SF32LB52X_CLOCK_I2C2     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 28U)
#define SF32LB52X_CLOCK_PTC1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR1, 31U)

#define SF32LB52X_CLOCK_GPIO1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 0U)
#define SF32LB52X_CLOCK_MPI1     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 1U)
#define SF32LB52X_CLOCK_MPI2     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 2U)
#define SF32LB52X_CLOCK_SDMMC1   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 4U)
#define SF32LB52X_CLOCK_USBC     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 6U)
#define SF32LB52X_CLOCK_I2C3     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 8U)
#define SF32LB52X_CLOCK_ATIM1    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 9U)
#define SF32LB52X_CLOCK_USART3   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 12U)
#define SF32LB52X_CLOCK_AUDCODEC SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 19U)
#define SF32LB52X_CLOCK_AUDPRC   SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 20U)
#define SF32LB52X_CLOCK_GPADC    SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 22U)
#define SF32LB52X_CLOCK_TSEN     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 23U)
#define SF32LB52X_CLOCK_I2C4     SF32LB_CLOCK_CONFIG(SF32LB52X_RCC_ENR2, 25U)

/** @} */

#endif /* _INCLUDE_ZEPHYR_DT_BINDINGS_CLOCK_SF32LB52X_CLOCKS_H_ */
