/*
 * Copyright (c) 2024 SILA Embedded Solutions GmbH
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_INCLUDE_DRIVERS_MFD_MAX31790_H_
#define ZEPHYR_INCLUDE_DRIVERS_MFD_MAX31790_H_

#include <zephyr/sys/util.h>
#include <zephyr/sys/util_macro.h>

#define MAX31790_OSCILLATOR_FREQUENCY_IN_HZ 32768
#define MAX31790_PWMTARGETDUTYCYCLE_MAXIMUM ((1 << 9) - 1)
#define MAX31790_TACHTARGETCOUNT_MAXIMUM    ((1 << 11) - 1)
#define MAX31790_CHANNEL_COUNT              6
#define MAX31790_RESET_TIMEOUT_IN_US        1000

#define MAX37190_REGISTER_GLOBALCONFIGURATION               0x00
#define MAX37190_REGISTER_PWMFREQUENCY                      0x01
#define MAX37190_REGISTER_FANCONFIGURATION(channel)         (0x02 + channel)
#define MAX31790_REGISTER_FANDYNAMICS(channel)              (0x08 + channel)
#define MAX37190_REGISTER_FANFAULTSTATUS1                   0x11
#define MAX37190_REGISTER_TACHCOUNTMSB(channel)             (0x18 + 2 * channel)
#define MAX31790_REGISTER_PWMOUTTARGETDUTYCYCLEMSB(channel) (0x40 + 2 * channel)
#define MAX31790_REGISTER_TACHTARGETCOUNTMSB(channel)       (0x50 + 2 * channel)

#define MAX37190_GLOBALCONFIGURATION_STANDBY_BIT             BIT(7)
#define MAX37190_GLOBALCONFIGURATION_RESET_BIT               BIT(6)
#define MAX37190_GLOBALCONFIGURATION_BUSTIMEOUT_BIT          BIT(5)
#define MAX37190_GLOBALCONFIGURATION_OSCILLATORSELECTION_BIT BIT(3)
#define MAX37190_GLOBALCONFIGURATION_I2CWATCHDOGSTATUS_BIT   BIT(0)
#define MAX37190_FANXCONFIGURATION_MONITOR_BIT               BIT(4)
#define MAX37190_FANXCONFIGURATION_TACHINPUTENABLED_BIT      BIT(3)
#define MAX37190_FANXCONFIGURATION_LOCKEDROTOR_BIT           BIT(2)
#define MAX37190_FANXCONFIGURATION_LOCKEDROTORPOLARITY_BIT   BIT(1)
#define MAX37190_FANXCONFIGURATION_TACH_BIT                  BIT(0)
#define MAX37190_FANXCONFIGURATION_MODE_BIT                  BIT(7)
#define MAX37190_FANXDYNAMICS_ASYMMETRICRATEOFCHANGE_BIT     BIT(1)

#define MAX37190_GLOBALCONFIGURATION_I2CWATCHDOG_LENGTH 2
#define MAX37190_GLOBALCONFIGURATION_I2CWATCHDOG_POS    1
#define MAX37190_FANXDYNAMICS_SPEEDRANGE_LENGTH         3
#define MAX37190_FANXDYNAMICS_SPEEDRANGE_POS            5
#define MAX37190_FANXDYNAMICS_PWMRATEOFCHANGE_LENGTH    3
#define MAX37190_FANXDYNAMICS_PWMRATEOFCHANGE_POS       2
#define MAX37190_PWMFREQUENCY_PWM_LENGTH                4
#define MAX37190_PWMFREQUENCY_PWM4TO6_POS               4
#define MAX37190_PWMFREQUENCY_PWM1TO3_LENGTH            4
#define MAX37190_PWMFREQUENCY_PWM1TO3_POS               0
#define MAX37190_FANXCONFIGURATION_SPINUP_LENGTH        2
#define MAX37190_FANXCONFIGURATION_SPINUP_POS           5

#define MAX31790_FANXDYNAMCIS_SPEED_RANGE_GET(value)                                               \
	FIELD_GET(GENMASK(MAX37190_FANXDYNAMICS_SPEEDRANGE_LENGTH +                                \
				  MAX37190_FANXDYNAMICS_SPEEDRANGE_POS - 1,                        \
			  MAX37190_FANXDYNAMICS_SPEEDRANGE_POS),                                   \
		  value)

#define MAX31790_FLAG_SPEED_RANGE_GET(flags)                                                       \
	FIELD_GET(GENMASK(MAX37190_FANXDYNAMICS_SPEEDRANGE_LENGTH +                                \
				  PWM_MAX31790_FLAG_SPEED_RANGE_POS - 1,                           \
			  PWM_MAX31790_FLAG_SPEED_RANGE_POS),                                      \
		  flags)
#define MAX31790_FLAG_PWM_RATE_OF_CHANGE_GET(flags)                                                \
	FIELD_GET(GENMASK(MAX37190_FANXDYNAMICS_PWMRATEOFCHANGE_LENGTH +                           \
				  PWM_MAX31790_FLAG_PWM_RATE_OF_CHANGE_POS - 1,                    \
			  PWM_MAX31790_FLAG_PWM_RATE_OF_CHANGE_POS),                               \
		  flags)

#endif /* ZEPHYR_INCLUDE_DRIVERS_MFD_MAX31790_H_ */
