/*
 * Copyright (c) 2023 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef ZEPHYR_DRIVERS_SENSOR_AKM09918C_AKM09918C_REG_H
#define ZEPHYR_DRIVERS_SENSOR_AKM09918C_AKM09918C_REG_H

#include <zephyr/sys/util_macro.h>

#define AKM09918C_REG_WIA1  0x00
#define AKM09918C_REG_WIA2  0x01
#define AKM09918C_REG_RSV1  0x02
#define AKM09918C_REG_RSV2  0x03
#define AKM09918C_REG_ST1   0x10
#define AKM09918C_REG_HXL   0x11
#define AKM09918C_REG_HXH   0x12
#define AKM09918C_REG_HYL   0x13
#define AKM09918C_REG_HYH   0x14
#define AKM09918C_REG_HZL   0x15
#define AKM09918C_REG_HZH   0x16
#define AKM09918C_REG_TMPS  0x17
#define AKM09918C_REG_ST2   0x18
#define AKM09918C_REG_CNTL1 0x30
#define AKM09918C_REG_CNTL2 0x31
#define AKM09918C_REG_CNTL3 0x32
#define AKM09918C_REG_TS1   0x33
#define AKM09918C_REG_TS2   0x34

/* Who-I-Am register values */
#define AKM09918C_WIA1 0x48
#define AKM09918C_WIA2 0x0c

/* ST1 values */
#define AKM09918C_ST1_DRDY BIT(0)
#define AKM09918C_ST1_DOR  BIT(1)

/* CNTL2 values */
#define AKM09918C_CNTL2_PWR_DOWN       0x00
#define AKM09918C_CNTL2_SINGLE_MEASURE BIT(0)
#define AKM09918C_CNTL2_CONTINUOUS_1   BIT(1)
#define AKM09918C_CNTL2_CONTINUOUS_2   BIT(2)
#define AKM09918C_CNTL2_CONTINUOUS_3   (BIT(1) | BIT(2))
#define AKM09918C_CNTL2_CONTINUOUS_4   BIT(3)

/* CNTL3 values */
#define AKM09918C_CNTL3_SRST BIT(0)

#endif /* ZEPHYR_DRIVERS_SENSOR_AKM09918C_AKM09918C_REG_H */
