# SPDX-License-Identifier: Apache-2.0

# Determines what argument to give to -mcpu= based on the
# KConfig'uration and sets this to GCC_M_CPU

if("${ARCH}" STREQUAL "arm")
  if    (CONFIG_CPU_CORTEX_M0)
    set(GCC_M_CPU cortex-m0)
  elseif(CONFIG_CPU_CORTEX_M0PLUS)
    set(GCC_M_CPU cortex-m0plus)
  elseif(CONFIG_CPU_CORTEX_M1)
    set(GCC_M_CPU cortex-m1)
  elseif(CONFIG_CPU_CORTEX_M3)
    set(GCC_M_CPU cortex-m3)
  elseif(CONFIG_CPU_CORTEX_M4)
    set(GCC_M_CPU cortex-m4)
  elseif(CONFIG_CPU_CORTEX_M7)
    set(GCC_M_CPU cortex-m7)
  elseif(CONFIG_CPU_CORTEX_M23)
    set(GCC_M_CPU cortex-m23)
  elseif(CONFIG_CPU_CORTEX_M33)
    if    (CONFIG_ARMV8_M_DSP)
      set(GCC_M_CPU cortex-m33)
    else()
      set(GCC_M_CPU cortex-m33+nodsp)
    endif()
  elseif(CONFIG_CPU_CORTEX_M52)
    if    (CONFIG_ARMV8_1_M_MVEF)
      set(GCC_M_CPU cortex-m52)
    elseif(CONFIG_ARMV8_1_M_MVEI)
      set(GCC_M_CPU cortex-m52+nomve.fp)
    elseif(CONFIG_ARMV8_M_DSP)
      set(GCC_M_CPU cortex-m52+nomve)
    else()
      set(GCC_M_CPU cortex-m52+nodsp)
    endif()
  elseif(CONFIG_CPU_CORTEX_M55)
    if    (CONFIG_ARMV8_1_M_MVEF)
      set(GCC_M_CPU cortex-m55)
    elseif(CONFIG_ARMV8_1_M_MVEI)
      set(GCC_M_CPU cortex-m55+nomve.fp)
    elseif(CONFIG_ARMV8_M_DSP)
      set(GCC_M_CPU cortex-m55+nomve)
    else()
      set(GCC_M_CPU cortex-m55+nodsp)
    endif()
  elseif(CONFIG_CPU_CORTEX_M85)
    if    (CONFIG_ARMV8_1_M_MVEF)
      set(GCC_M_CPU cortex-m85)
    elseif(CONFIG_ARMV8_1_M_MVEI)
      set(GCC_M_CPU cortex-m85+nomve.fp)
    elseif(CONFIG_ARMV8_M_DSP)
      set(GCC_M_CPU cortex-m85+nomve)
    else()
      set(GCC_M_CPU cortex-m85+nodsp)
    endif()
  elseif(CONFIG_CPU_CORTEX_R4)
    if(CONFIG_FPU AND CONFIG_CPU_HAS_VFP)
      set(GCC_M_CPU cortex-r4f)
    else()
      set(GCC_M_CPU cortex-r4)
    endif()
  elseif(CONFIG_CPU_CORTEX_R5)
    set(GCC_M_CPU cortex-r5)
    if(CONFIG_FPU AND CONFIG_CPU_HAS_VFP)
      if(NOT CONFIG_VFP_FEATURE_DOUBLE_PRECISION)
        set(GCC_M_CPU ${GCC_M_CPU}+nofp.dp)
      endif()
    else()
      set(GCC_M_CPU ${GCC_M_CPU}+nofp)
    endif()
  elseif(CONFIG_CPU_CORTEX_R7)
    set(GCC_M_CPU cortex-r7)
    if(CONFIG_FPU AND CONFIG_CPU_HAS_VFP)
      if(NOT CONFIG_VFP_FEATURE_DOUBLE_PRECISION)
        set(GCC_M_CPU ${GCC_M_CPU}+nofp.dp)
      endif()
    else()
      set(GCC_M_CPU ${GCC_M_CPU}+nofp)
    endif()
  elseif(CONFIG_CPU_CORTEX_R8)
    set(GCC_M_CPU cortex-r8)
    if(CONFIG_FPU AND CONFIG_CPU_HAS_VFP)
      if(NOT CONFIG_VFP_FEATURE_DOUBLE_PRECISION)
        set(GCC_M_CPU ${GCC_M_CPU}+nofp.dp)
      endif()
    else()
      set(GCC_M_CPU ${GCC_M_CPU}+nofp)
    endif()
  elseif(CONFIG_CPU_CORTEX_R52)
    set(GCC_M_CPU cortex-r52)
    if(CONFIG_FPU AND CONFIG_CPU_HAS_VFP)
      if(NOT CONFIG_VFP_FEATURE_DOUBLE_PRECISION)
        set(GCC_M_CPU ${GCC_M_CPU}+nofp.dp)
      endif()
    endif()
  elseif(CONFIG_CPU_CORTEX_A7)
    set(GCC_M_CPU cortex-a7)
  elseif(CONFIG_CPU_CORTEX_A9)
    set(GCC_M_CPU cortex-a9)
  else()
    message(FATAL_ERROR "Expected CONFIG_CPU_CORTEX_x to be defined")
  endif()
elseif("${ARCH}" STREQUAL "arm64")
  if(CONFIG_CPU_CORTEX_A53)
    set(GCC_M_CPU cortex-a53)
  elseif(CONFIG_CPU_CORTEX_A55)
    set(GCC_M_CPU cortex-a55)
  elseif(CONFIG_CPU_CORTEX_A76)
    set(GCC_M_CPU cortex-a76)
  elseif(CONFIG_CPU_CORTEX_A76_A55)
    set(GCC_M_CPU cortex-a76)
    set(GCC_M_TUNE cortex-a76.cortex-a55)
  elseif(CONFIG_CPU_CORTEX_A72)
    set(GCC_M_CPU cortex-a72)
  elseif(CONFIG_CPU_CORTEX_A78)
    set(GCC_M_CPU cortex-a78)
  elseif(CONFIG_CPU_CORTEX_R82)
    set(GCC_M_CPU cortex-r82)
  endif()
elseif("${ARCH}" STREQUAL "arc")
  if(CONFIG_CPU_EM4_FPUS)
    set(GCC_M_CPU em4_fpus)
  elseif(CONFIG_CPU_EM4_DMIPS)
    set(GCC_M_CPU em4_dmips)
  elseif(CONFIG_CPU_EM4_FPUDA)
    set(GCC_M_CPU em4_fpuda)
  elseif(CONFIG_CPU_HS3X)
    set(GCC_M_CPU archs)
  elseif(CONFIG_CPU_HS4X)
    set(GCC_M_CPU hs4x)
  elseif(CONFIG_CPU_HS5X)
    set(GCC_M_CPU hs5x)
  elseif(CONFIG_CPU_HS6X)
    set(GCC_M_CPU hs6x)
  elseif(CONFIG_CPU_EM4)
    set(GCC_M_CPU arcem)
  elseif(CONFIG_CPU_EM6)
    set(GCC_M_CPU arcem)
  endif()
endif()
