// 给按钮设置Svg图标
package main

import (
	"github.com/twgh/xcgui/app"
	"github.com/twgh/xcgui/imagex"
	"github.com/twgh/xcgui/widget"
	"github.com/twgh/xcgui/window"
	"github.com/twgh/xcgui/xc"
	"github.com/twgh/xcgui/xcc"
)

func main() {
	// 初始化界面库
	app.InitOrExit()
	a := app.New(true)
	a.EnableAutoDPI(true).EnableDPI(true)

	w := window.New(0, 0, 400, 300, "给按钮设置Svg图标", 0, xcc.Window_Style_Default)

	// 加载图片从svg string
	img1 := imagex.NewBySvgStringW(svgStr1)
	// 设置图片的大小
	xc.XSvg_SetSize(img1.GetSvg(), 24, 24)

	// 创建按钮1
	btn1 := widget.NewButton(30, 40, 130, 30, "Test Svg Icon", w.Handle)
	// 设置按钮1的icon
	btn1.SetIcon(img1.Handle)

	// 加载图片从svg string
	img2 := imagex.NewBySvgStringW(svgStr2)
	// 设置图片的大小
	xc.XSvg_SetSize(img2.GetSvg(), 100, 100)

	// 创建按钮2
	btn2 := widget.NewButton(30, 80, 100, 100, "", w.Handle)
	// 设置按钮2的icon
	btn2.SetIcon(img2.Handle)

	w.ShowWindow(xcc.SW_SHOW)
	a.Run()
	a.Exit()
}

const (
	svgStr1 = `<svg t="1637648393269" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="32285" width="22" height="22"><path d="M511.0272 84.1728C274.0736 84.1728 81.92 276.2752 81.92 513.28s192.1024 429.1072 429.1072 429.1072 429.1072-192.1024 429.1072-429.1072-192.1024-429.1072-429.1072-429.1072z m130.304 493.9776c21.1968 0 38.3488 17.152 38.3488 38.3488s-17.152 38.3488-38.3488 38.3488H549.376v34.2528c0 21.1968-17.152 38.3488-38.3488 38.3488-21.1968 0-38.3488-17.152-38.3488-38.3488v-34.2528H380.7744c-21.1968 0-38.3488-17.152-38.3488-38.3488s17.152-38.3488 38.3488-38.3488h91.904v-36.2496H380.7744c-21.1968 0-38.3488-17.152-38.3488-38.3488s17.152-38.3488 38.3488-38.3488h56.6784L364.4928 359.168c-11.9808-17.4592-7.5776-41.3184 9.8816-53.2992s41.3184-7.5776 53.2992 9.8816l82.432 119.8592L585.728 318.976a38.35904 38.35904 0 0 1 53.0432-11.3152 38.35904 38.35904 0 0 1 11.3152 53.0432l-67.7888 104.4992h59.0336c21.1968 0 38.3488 17.152 38.3488 38.3488s-17.152 38.3488-38.3488 38.3488H549.376v36.2496h91.9552z" fill="#FF8E12" p-id="32286"></path><path d="M887.7056 307.5584c-72.8576-133.12-214.1696-223.3856-376.6272-223.3856C274.0736 84.1728 81.92 276.2752 81.92 513.28c0 152.8832 80.0256 287.0272 200.448 363.0592 7.0656 0.256 14.1312 0.4096 21.248 0.4096 317.6448 0 576.1024-253.4912 584.0896-569.1904z m-246.3744 270.592c21.1968 0 38.3488 17.152 38.3488 38.3488s-17.152 38.3488-38.3488 38.3488H549.376v34.2528c0 21.1968-17.152 38.3488-38.3488 38.3488-21.1968 0-38.3488-17.152-38.3488-38.3488v-34.2528H380.7744c-21.1968 0-38.3488-17.152-38.3488-38.3488s17.152-38.3488 38.3488-38.3488h91.904v-36.2496H380.7744c-21.1968 0-38.3488-17.152-38.3488-38.3488 0-21.1968 17.152-38.3488 38.3488-38.3488h56.6784L364.4928 359.168c-11.9808-17.4592-7.5776-41.3184 9.8816-53.2992s41.3184-7.5776 53.2992 9.8816l82.432 119.8592L585.728 318.976a38.35904 38.35904 0 0 1 53.0432-11.3152 38.35904 38.35904 0 0 1 11.3152 53.0432l-67.7888 104.4992h59.0336c21.1968 0 38.3488 17.152 38.3488 38.3488 0 21.1968-17.152 38.3488-38.3488 38.3488H549.376v36.2496h91.9552z" fill="#FCA315" p-id="32287"></path><path d="M511.0272 84.1728C274.0736 84.1728 81.92 276.2752 81.92 513.28c0 54.6816 10.3424 106.9568 28.9792 155.0336 10.9056 0.6144 21.8624 0.9216 32.8704 0.9216 71.168 0 139.3664-12.7488 202.496-36.0448a38.32832 38.32832 0 0 1 34.5088-55.04h76.3904c5.2224-3.328 10.3936-6.7584 15.5136-10.24v-25.9584H380.7744c-21.1968 0-38.3488-17.152-38.3488-38.3488 0-21.1968 17.152-38.3488 38.3488-38.3488h56.6784L364.4928 359.168c-11.9808-17.4592-7.5776-41.3184 9.8816-53.2992s41.3184-7.5776 53.2992 9.8816l82.432 119.8592L585.728 318.976a38.35904 38.35904 0 0 1 53.0432-11.3152 38.35904 38.35904 0 0 1 11.3152 53.0432l-67.7888 104.4992h5.0688c76.1856-88.7808 126.1568-200.6528 137.984-323.6864a427.43808 427.43808 0 0 0-214.3232-57.344z" fill="#FCB138" p-id="32288"></path><path d="M85.9136 455.7312c101.5808-15.5136 194.6112-57.2416 271.872-118.016a38.2976 38.2976 0 0 1 43.8784-38.1952 585.32352 585.32352 0 0 0 141.6192-214.016c-10.6496-0.768-21.3504-1.3312-32.2048-1.3312-217.4976 0-397.056 161.792-425.1648 371.5584z" fill="#FFC65E" p-id="32289"></path></svg>`

	svgStr2 = `<svg t="1637648366450" class="icon" viewBox="0 0 1024 1024" version="1.1" xmlns="http://www.w3.org/2000/svg" p-id="32129" width="22" height="22"><path d="M279.808 647.4752c0-72.2944 0.4608-144.5888-0.3072-216.832-0.2048-21.0432 7.3728-32.0512 27.8016-39.1168 78.0288-26.8288 124.16-83.6096 146.8416-161.4336 7.8848-27.0848 15.1552-54.5792 26.1632-80.384 17.8688-41.8304 50.688-56.5248 96.256-46.7968 35.1744 7.5264 57.344 37.5808 57.7024 79.6672 0.4608 53.6576 0.0512 107.3152 0.2048 160.9728 0.1024 29.3888 5.2224 35.4304 35.2256 35.7376 60.3648 0.6656 120.7808 2.048 181.0432-0.3072 53.6576-2.0992 92.672 32.8704 79.1552 92.672-16.1792 71.6288-36.608 142.336-56.576 213.0944-12.288 43.6224-26.7264 86.6816-40.8576 129.7408-18.688 56.9856-53.5552 82.176-112.4352 82.176H324.352c-42.496 0-44.5952-2.048-44.5952-43.5712 0.0512-68.5056 0.0512-137.0624 0.0512-205.6192z" fill="#FF8E12" p-id="32130"></path><path d="M215.1936 645.888c0 70.0416 0.1536 140.1344-0.1024 210.176-0.1024 34.4576-6.5024 40.5504-40.2432 40.6528-9.6768 0.0512-19.3536 0.0512-29.0816 0-39.5776-0.2048-58.368-18.6368-58.5728-59.1872-0.4096-73.0112-0.1536-146.0736-0.1536-219.136 0-53.6576-0.2048-107.3152 0.1024-160.9728 0.256-42.6496 20.8896-63.0272 62.9248-63.1808 65.0752-0.256 65.0752-0.256 65.0752 63.8464 0.1024 62.5664 0.1024 125.184 0.0512 187.8016zM883.0976 388.5568c0-1.9456-0.1024-3.84-0.1536-5.7856-9.8304-2.8672-20.6336-4.1984-32.1536-3.7888-60.2624 2.3552-120.6784 0.9728-181.0432 0.3072-29.952-0.3072-35.1232-6.3488-35.2256-35.7376-0.1536-53.6576 0.256-107.3152-0.2048-160.9728-0.3584-42.0864-22.5792-72.1408-57.7024-79.6672-45.568-9.7792-78.3872 4.9664-96.256 46.7968-11.008 25.8048-18.2784 53.3504-26.1632 80.384-22.6816 77.8752-68.8128 134.6048-146.8416 161.4336-20.48 7.0656-28.0576 18.0736-27.8016 39.1168 0.768 72.2944 0.3072 144.5376 0.3072 216.832v205.6704c0 41.5232 2.0992 43.5712 44.5952 43.5712h222.6176c197.4784-84.0704 336.0256-279.9616 336.0256-508.16z" fill="#FCA315" p-id="32131"></path><path d="M150.1696 394.1888c-42.0352 0.1536-62.72 20.5824-62.9248 63.1808-0.3072 53.6576-0.1024 107.3152-0.1024 160.9728 0 39.3728-0.0512 78.7456-0.0512 118.1184 30.2592 5.12 61.3376 7.9872 93.0304 7.9872 11.8272 0 23.5008-0.512 35.1232-1.2288 0-32.4608-0.0512-64.9216-0.0512-97.3824V458.0352c0.0512-64.0512 0-64.1024-65.024-63.8464zM699.4944 379.648c-9.9328-0.1024-19.8144-0.256-29.7472-0.3584-29.952-0.3072-35.1232-6.3488-35.2256-35.7376-0.1536-53.6576 0.256-107.3152-0.2048-160.9728-0.3584-42.0864-22.5792-72.1408-57.7024-79.6672-45.568-9.7792-78.3872 4.9664-96.256 46.7968-11.008 25.8048-18.2784 53.3504-26.1632 80.384-22.6816 77.8752-68.8128 134.6048-146.8416 161.4336-20.48 7.0656-28.0576 18.0736-27.8016 39.1168 0.768 72.2944 0.3072 144.5376 0.3072 216.832v87.8592c194.7648-35.584 353.8944-173.2608 419.6352-355.6864z" fill="#FCB138" p-id="32132"></path><path d="M582.7584 104.4992c-1.9968-0.6144-4.0448-1.1264-6.144-1.5872-45.568-9.7792-78.3872 4.9664-96.256 46.7968-11.008 25.8048-18.2784 53.3504-26.1632 80.384-22.6816 77.8752-68.8128 134.6048-146.8416 161.4336-20.48 7.0656-28.0576 18.0736-27.8016 39.1168 0.2048 21.4528 0.3072 42.9056 0.3584 64.3584 154.3168-74.0864 268.8-217.856 302.848-390.5024zM150.1696 394.1888c-42.0352 0.1536-62.72 20.5824-62.9248 63.1808-0.2048 29.952-0.2048 59.8528-0.2048 89.7536 44.4416-3.6352 87.3472-12.544 128.2048-26.112v-62.976c0-64.0512-0.0512-64.1024-65.0752-63.8464z" fill="#FFC65E" p-id="32133"></path></svg>`
)
